package config

import (
	"os"
	"path/filepath"
	"runtime"

	"github.com/mitchellh/go-homedir"
)

func IsEnvPresent(s string) bool {
	_, present := os.LookupEnv(s)
	return present
}

func RootDir() string {
	_, b, _, _ := runtime.Caller(0)
	return filepath.Join(filepath.Dir(b), "../..")
}

func userConfigDir() string {
	dir, _ := homedir.Expand("~/.config/infracost")
	return dir
}

func FileExists(path string) bool {
	info, err := os.Stat(path)
	if err != nil {
		return false
	}

	return !info.IsDir()
}
