/*
 * Subset of Influx API covered by Influx CLI
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * API version: 2.0.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package api

import (
	_context "context"
	_fmt "fmt"
	_io "io"
	_nethttp "net/http"
	_neturl "net/url"
	"strings"
)

// Linger please
var (
	_ _context.Context
)

type RemoteConnectionsApi interface {

	/*
	 * DeleteRemoteConnectionByID Delete a remote connection
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param remoteID
	 * @return ApiDeleteRemoteConnectionByIDRequest
	 */
	DeleteRemoteConnectionByID(ctx _context.Context, remoteID string) ApiDeleteRemoteConnectionByIDRequest

	/*
	 * DeleteRemoteConnectionByIDExecute executes the request
	 */
	DeleteRemoteConnectionByIDExecute(r ApiDeleteRemoteConnectionByIDRequest) error

	/*
	 * DeleteRemoteConnectionByIDExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not
	 * available on the returned HTTP response as it will have already been read and closed; access to the response body
	 * content should be achieved through the returned response model if applicable.
	 */
	DeleteRemoteConnectionByIDExecuteWithHttpInfo(r ApiDeleteRemoteConnectionByIDRequest) (*_nethttp.Response, error)

	/*
	 * GetRemoteConnectionByID Retrieve a remote connection
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param remoteID
	 * @return ApiGetRemoteConnectionByIDRequest
	 */
	GetRemoteConnectionByID(ctx _context.Context, remoteID string) ApiGetRemoteConnectionByIDRequest

	/*
	 * GetRemoteConnectionByIDExecute executes the request
	 * @return RemoteConnection
	 */
	GetRemoteConnectionByIDExecute(r ApiGetRemoteConnectionByIDRequest) (RemoteConnection, error)

	/*
	 * GetRemoteConnectionByIDExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not
	 * available on the returned HTTP response as it will have already been read and closed; access to the response body
	 * content should be achieved through the returned response model if applicable.
	 * @return RemoteConnection
	 */
	GetRemoteConnectionByIDExecuteWithHttpInfo(r ApiGetRemoteConnectionByIDRequest) (RemoteConnection, *_nethttp.Response, error)

	/*
	 * GetRemoteConnections List all remote connections
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return ApiGetRemoteConnectionsRequest
	 */
	GetRemoteConnections(ctx _context.Context) ApiGetRemoteConnectionsRequest

	/*
	 * GetRemoteConnectionsExecute executes the request
	 * @return RemoteConnections
	 */
	GetRemoteConnectionsExecute(r ApiGetRemoteConnectionsRequest) (RemoteConnections, error)

	/*
	 * GetRemoteConnectionsExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not
	 * available on the returned HTTP response as it will have already been read and closed; access to the response body
	 * content should be achieved through the returned response model if applicable.
	 * @return RemoteConnections
	 */
	GetRemoteConnectionsExecuteWithHttpInfo(r ApiGetRemoteConnectionsRequest) (RemoteConnections, *_nethttp.Response, error)

	/*
	 * PatchRemoteConnectionByID Update a remote connection
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param remoteID
	 * @return ApiPatchRemoteConnectionByIDRequest
	 */
	PatchRemoteConnectionByID(ctx _context.Context, remoteID string) ApiPatchRemoteConnectionByIDRequest

	/*
	 * PatchRemoteConnectionByIDExecute executes the request
	 * @return RemoteConnection
	 */
	PatchRemoteConnectionByIDExecute(r ApiPatchRemoteConnectionByIDRequest) (RemoteConnection, error)

	/*
	 * PatchRemoteConnectionByIDExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not
	 * available on the returned HTTP response as it will have already been read and closed; access to the response body
	 * content should be achieved through the returned response model if applicable.
	 * @return RemoteConnection
	 */
	PatchRemoteConnectionByIDExecuteWithHttpInfo(r ApiPatchRemoteConnectionByIDRequest) (RemoteConnection, *_nethttp.Response, error)

	/*
	 * PostRemoteConnection Register a new remote connection
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return ApiPostRemoteConnectionRequest
	 */
	PostRemoteConnection(ctx _context.Context) ApiPostRemoteConnectionRequest

	/*
	 * PostRemoteConnectionExecute executes the request
	 * @return RemoteConnection
	 */
	PostRemoteConnectionExecute(r ApiPostRemoteConnectionRequest) (RemoteConnection, error)

	/*
	 * PostRemoteConnectionExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not
	 * available on the returned HTTP response as it will have already been read and closed; access to the response body
	 * content should be achieved through the returned response model if applicable.
	 * @return RemoteConnection
	 */
	PostRemoteConnectionExecuteWithHttpInfo(r ApiPostRemoteConnectionRequest) (RemoteConnection, *_nethttp.Response, error)
}

// RemoteConnectionsApiService RemoteConnectionsApi service
type RemoteConnectionsApiService service

type ApiDeleteRemoteConnectionByIDRequest struct {
	ctx          _context.Context
	ApiService   RemoteConnectionsApi
	remoteID     string
	zapTraceSpan *string
}

func (r ApiDeleteRemoteConnectionByIDRequest) RemoteID(remoteID string) ApiDeleteRemoteConnectionByIDRequest {
	r.remoteID = remoteID
	return r
}
func (r ApiDeleteRemoteConnectionByIDRequest) GetRemoteID() string {
	return r.remoteID
}

func (r ApiDeleteRemoteConnectionByIDRequest) ZapTraceSpan(zapTraceSpan string) ApiDeleteRemoteConnectionByIDRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiDeleteRemoteConnectionByIDRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiDeleteRemoteConnectionByIDRequest) Execute() error {
	return r.ApiService.DeleteRemoteConnectionByIDExecute(r)
}

func (r ApiDeleteRemoteConnectionByIDRequest) ExecuteWithHttpInfo() (*_nethttp.Response, error) {
	return r.ApiService.DeleteRemoteConnectionByIDExecuteWithHttpInfo(r)
}

/*
 * DeleteRemoteConnectionByID Delete a remote connection
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param remoteID
 * @return ApiDeleteRemoteConnectionByIDRequest
 */
func (a *RemoteConnectionsApiService) DeleteRemoteConnectionByID(ctx _context.Context, remoteID string) ApiDeleteRemoteConnectionByIDRequest {
	return ApiDeleteRemoteConnectionByIDRequest{
		ApiService: a,
		ctx:        ctx,
		remoteID:   remoteID,
	}
}

/*
 * Execute executes the request
 */
func (a *RemoteConnectionsApiService) DeleteRemoteConnectionByIDExecute(r ApiDeleteRemoteConnectionByIDRequest) error {
	_, err := a.DeleteRemoteConnectionByIDExecuteWithHttpInfo(r)
	return err
}

/*
 * ExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not available on the
 * returned HTTP response as it will have already been read and closed; access to the response body content should be
 * achieved through the returned response model if applicable.
 */
func (a *RemoteConnectionsApiService) DeleteRemoteConnectionByIDExecuteWithHttpInfo(r ApiDeleteRemoteConnectionByIDRequest) (*_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemoteConnectionsApiService.DeleteRemoteConnectionByID")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v2/remotes/{remoteID}"
	localVarPath = strings.Replace(localVarPath, "{"+"remoteID"+"}", _neturl.PathEscape(parameterToString(r.remoteID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	newErr := GenericOpenAPIError{
		buildHeader: localVarHTTPResponse.Header.Get("X-Influxdb-Build"),
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			newErr.error = err.Error()
			return localVarHTTPResponse, newErr
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			newErr.error = err.Error()
			return localVarHTTPResponse, newErr
		}
		newErr.body = localVarBody
		newErr.error = localVarHTTPResponse.Status
		if localVarHTTPResponse.StatusCode == 404 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarHTTPResponse, newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarHTTPResponse, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiGetRemoteConnectionByIDRequest struct {
	ctx          _context.Context
	ApiService   RemoteConnectionsApi
	remoteID     string
	zapTraceSpan *string
}

func (r ApiGetRemoteConnectionByIDRequest) RemoteID(remoteID string) ApiGetRemoteConnectionByIDRequest {
	r.remoteID = remoteID
	return r
}
func (r ApiGetRemoteConnectionByIDRequest) GetRemoteID() string {
	return r.remoteID
}

func (r ApiGetRemoteConnectionByIDRequest) ZapTraceSpan(zapTraceSpan string) ApiGetRemoteConnectionByIDRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiGetRemoteConnectionByIDRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiGetRemoteConnectionByIDRequest) Execute() (RemoteConnection, error) {
	return r.ApiService.GetRemoteConnectionByIDExecute(r)
}

func (r ApiGetRemoteConnectionByIDRequest) ExecuteWithHttpInfo() (RemoteConnection, *_nethttp.Response, error) {
	return r.ApiService.GetRemoteConnectionByIDExecuteWithHttpInfo(r)
}

/*
 * GetRemoteConnectionByID Retrieve a remote connection
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param remoteID
 * @return ApiGetRemoteConnectionByIDRequest
 */
func (a *RemoteConnectionsApiService) GetRemoteConnectionByID(ctx _context.Context, remoteID string) ApiGetRemoteConnectionByIDRequest {
	return ApiGetRemoteConnectionByIDRequest{
		ApiService: a,
		ctx:        ctx,
		remoteID:   remoteID,
	}
}

/*
 * Execute executes the request
 * @return RemoteConnection
 */
func (a *RemoteConnectionsApiService) GetRemoteConnectionByIDExecute(r ApiGetRemoteConnectionByIDRequest) (RemoteConnection, error) {
	returnVal, _, err := a.GetRemoteConnectionByIDExecuteWithHttpInfo(r)
	return returnVal, err
}

/*
 * ExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not available on the
 * returned HTTP response as it will have already been read and closed; access to the response body content should be
 * achieved through the returned response model if applicable.
 * @return RemoteConnection
 */
func (a *RemoteConnectionsApiService) GetRemoteConnectionByIDExecuteWithHttpInfo(r ApiGetRemoteConnectionByIDRequest) (RemoteConnection, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  RemoteConnection
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemoteConnectionsApiService.GetRemoteConnectionByID")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v2/remotes/{remoteID}"
	localVarPath = strings.Replace(localVarPath, "{"+"remoteID"+"}", _neturl.PathEscape(parameterToString(r.remoteID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	newErr := GenericOpenAPIError{
		buildHeader: localVarHTTPResponse.Header.Get("X-Influxdb-Build"),
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.body = localVarBody
		newErr.error = localVarHTTPResponse.Status
		if localVarHTTPResponse.StatusCode == 404 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	newErr.body = localVarBody
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiGetRemoteConnectionsRequest struct {
	ctx          _context.Context
	ApiService   RemoteConnectionsApi
	orgID        *string
	zapTraceSpan *string
	name         *string
	remoteURL    *string
}

func (r ApiGetRemoteConnectionsRequest) OrgID(orgID string) ApiGetRemoteConnectionsRequest {
	r.orgID = &orgID
	return r
}
func (r ApiGetRemoteConnectionsRequest) GetOrgID() *string {
	return r.orgID
}

func (r ApiGetRemoteConnectionsRequest) ZapTraceSpan(zapTraceSpan string) ApiGetRemoteConnectionsRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiGetRemoteConnectionsRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiGetRemoteConnectionsRequest) Name(name string) ApiGetRemoteConnectionsRequest {
	r.name = &name
	return r
}
func (r ApiGetRemoteConnectionsRequest) GetName() *string {
	return r.name
}

func (r ApiGetRemoteConnectionsRequest) RemoteURL(remoteURL string) ApiGetRemoteConnectionsRequest {
	r.remoteURL = &remoteURL
	return r
}
func (r ApiGetRemoteConnectionsRequest) GetRemoteURL() *string {
	return r.remoteURL
}

func (r ApiGetRemoteConnectionsRequest) Execute() (RemoteConnections, error) {
	return r.ApiService.GetRemoteConnectionsExecute(r)
}

func (r ApiGetRemoteConnectionsRequest) ExecuteWithHttpInfo() (RemoteConnections, *_nethttp.Response, error) {
	return r.ApiService.GetRemoteConnectionsExecuteWithHttpInfo(r)
}

/*
 * GetRemoteConnections List all remote connections
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @return ApiGetRemoteConnectionsRequest
 */
func (a *RemoteConnectionsApiService) GetRemoteConnections(ctx _context.Context) ApiGetRemoteConnectionsRequest {
	return ApiGetRemoteConnectionsRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return RemoteConnections
 */
func (a *RemoteConnectionsApiService) GetRemoteConnectionsExecute(r ApiGetRemoteConnectionsRequest) (RemoteConnections, error) {
	returnVal, _, err := a.GetRemoteConnectionsExecuteWithHttpInfo(r)
	return returnVal, err
}

/*
 * ExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not available on the
 * returned HTTP response as it will have already been read and closed; access to the response body content should be
 * achieved through the returned response model if applicable.
 * @return RemoteConnections
 */
func (a *RemoteConnectionsApiService) GetRemoteConnectionsExecuteWithHttpInfo(r ApiGetRemoteConnectionsRequest) (RemoteConnections, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  RemoteConnections
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemoteConnectionsApiService.GetRemoteConnections")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v2/remotes"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.orgID == nil {
		return localVarReturnValue, nil, reportError("orgID is required and must be specified")
	}

	localVarQueryParams.Add("orgID", parameterToString(*r.orgID, ""))
	if r.name != nil {
		localVarQueryParams.Add("name", parameterToString(*r.name, ""))
	}
	if r.remoteURL != nil {
		localVarQueryParams.Add("remoteURL", parameterToString(*r.remoteURL, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	newErr := GenericOpenAPIError{
		buildHeader: localVarHTTPResponse.Header.Get("X-Influxdb-Build"),
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.body = localVarBody
		newErr.error = localVarHTTPResponse.Status
		if localVarHTTPResponse.StatusCode == 404 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	newErr.body = localVarBody
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiPatchRemoteConnectionByIDRequest struct {
	ctx                            _context.Context
	ApiService                     RemoteConnectionsApi
	remoteID                       string
	remoteConnenctionUpdateRequest *RemoteConnenctionUpdateRequest
	zapTraceSpan                   *string
}

func (r ApiPatchRemoteConnectionByIDRequest) RemoteID(remoteID string) ApiPatchRemoteConnectionByIDRequest {
	r.remoteID = remoteID
	return r
}
func (r ApiPatchRemoteConnectionByIDRequest) GetRemoteID() string {
	return r.remoteID
}

func (r ApiPatchRemoteConnectionByIDRequest) RemoteConnenctionUpdateRequest(remoteConnenctionUpdateRequest RemoteConnenctionUpdateRequest) ApiPatchRemoteConnectionByIDRequest {
	r.remoteConnenctionUpdateRequest = &remoteConnenctionUpdateRequest
	return r
}
func (r ApiPatchRemoteConnectionByIDRequest) GetRemoteConnenctionUpdateRequest() *RemoteConnenctionUpdateRequest {
	return r.remoteConnenctionUpdateRequest
}

func (r ApiPatchRemoteConnectionByIDRequest) ZapTraceSpan(zapTraceSpan string) ApiPatchRemoteConnectionByIDRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiPatchRemoteConnectionByIDRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiPatchRemoteConnectionByIDRequest) Execute() (RemoteConnection, error) {
	return r.ApiService.PatchRemoteConnectionByIDExecute(r)
}

func (r ApiPatchRemoteConnectionByIDRequest) ExecuteWithHttpInfo() (RemoteConnection, *_nethttp.Response, error) {
	return r.ApiService.PatchRemoteConnectionByIDExecuteWithHttpInfo(r)
}

/*
 * PatchRemoteConnectionByID Update a remote connection
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param remoteID
 * @return ApiPatchRemoteConnectionByIDRequest
 */
func (a *RemoteConnectionsApiService) PatchRemoteConnectionByID(ctx _context.Context, remoteID string) ApiPatchRemoteConnectionByIDRequest {
	return ApiPatchRemoteConnectionByIDRequest{
		ApiService: a,
		ctx:        ctx,
		remoteID:   remoteID,
	}
}

/*
 * Execute executes the request
 * @return RemoteConnection
 */
func (a *RemoteConnectionsApiService) PatchRemoteConnectionByIDExecute(r ApiPatchRemoteConnectionByIDRequest) (RemoteConnection, error) {
	returnVal, _, err := a.PatchRemoteConnectionByIDExecuteWithHttpInfo(r)
	return returnVal, err
}

/*
 * ExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not available on the
 * returned HTTP response as it will have already been read and closed; access to the response body content should be
 * achieved through the returned response model if applicable.
 * @return RemoteConnection
 */
func (a *RemoteConnectionsApiService) PatchRemoteConnectionByIDExecuteWithHttpInfo(r ApiPatchRemoteConnectionByIDRequest) (RemoteConnection, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPatch
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  RemoteConnection
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemoteConnectionsApiService.PatchRemoteConnectionByID")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v2/remotes/{remoteID}"
	localVarPath = strings.Replace(localVarPath, "{"+"remoteID"+"}", _neturl.PathEscape(parameterToString(r.remoteID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.remoteConnenctionUpdateRequest == nil {
		return localVarReturnValue, nil, reportError("remoteConnenctionUpdateRequest is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	// body params
	localVarPostBody = r.remoteConnenctionUpdateRequest
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	newErr := GenericOpenAPIError{
		buildHeader: localVarHTTPResponse.Header.Get("X-Influxdb-Build"),
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.body = localVarBody
		newErr.error = localVarHTTPResponse.Status
		if localVarHTTPResponse.StatusCode == 400 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	newErr.body = localVarBody
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiPostRemoteConnectionRequest struct {
	ctx                             _context.Context
	ApiService                      RemoteConnectionsApi
	remoteConnectionCreationRequest *RemoteConnectionCreationRequest
}

func (r ApiPostRemoteConnectionRequest) RemoteConnectionCreationRequest(remoteConnectionCreationRequest RemoteConnectionCreationRequest) ApiPostRemoteConnectionRequest {
	r.remoteConnectionCreationRequest = &remoteConnectionCreationRequest
	return r
}
func (r ApiPostRemoteConnectionRequest) GetRemoteConnectionCreationRequest() *RemoteConnectionCreationRequest {
	return r.remoteConnectionCreationRequest
}

func (r ApiPostRemoteConnectionRequest) Execute() (RemoteConnection, error) {
	return r.ApiService.PostRemoteConnectionExecute(r)
}

func (r ApiPostRemoteConnectionRequest) ExecuteWithHttpInfo() (RemoteConnection, *_nethttp.Response, error) {
	return r.ApiService.PostRemoteConnectionExecuteWithHttpInfo(r)
}

/*
 * PostRemoteConnection Register a new remote connection
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @return ApiPostRemoteConnectionRequest
 */
func (a *RemoteConnectionsApiService) PostRemoteConnection(ctx _context.Context) ApiPostRemoteConnectionRequest {
	return ApiPostRemoteConnectionRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return RemoteConnection
 */
func (a *RemoteConnectionsApiService) PostRemoteConnectionExecute(r ApiPostRemoteConnectionRequest) (RemoteConnection, error) {
	returnVal, _, err := a.PostRemoteConnectionExecuteWithHttpInfo(r)
	return returnVal, err
}

/*
 * ExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not available on the
 * returned HTTP response as it will have already been read and closed; access to the response body content should be
 * achieved through the returned response model if applicable.
 * @return RemoteConnection
 */
func (a *RemoteConnectionsApiService) PostRemoteConnectionExecuteWithHttpInfo(r ApiPostRemoteConnectionRequest) (RemoteConnection, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  RemoteConnection
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemoteConnectionsApiService.PostRemoteConnection")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v2/remotes"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.remoteConnectionCreationRequest == nil {
		return localVarReturnValue, nil, reportError("remoteConnectionCreationRequest is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.remoteConnectionCreationRequest
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	newErr := GenericOpenAPIError{
		buildHeader: localVarHTTPResponse.Header.Get("X-Influxdb-Build"),
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.body = localVarBody
		newErr.error = localVarHTTPResponse.Status
		if localVarHTTPResponse.StatusCode == 400 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	newErr.body = localVarBody
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
