/*
 * Subset of Influx API covered by Influx CLI
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * API version: 2.0.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package api

import (
	_context "context"
	_fmt "fmt"
	_io "io"
	_nethttp "net/http"
	_neturl "net/url"
	"strings"
	"time"
)

// Linger please
var (
	_ _context.Context
)

type TasksApi interface {

	/*
	 * DeleteTasksID Delete a task
	 * Deletes a task and all associated records
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param taskID The ID of the task to delete.
	 * @return ApiDeleteTasksIDRequest
	 */
	DeleteTasksID(ctx _context.Context, taskID string) ApiDeleteTasksIDRequest

	/*
	 * DeleteTasksIDExecute executes the request
	 */
	DeleteTasksIDExecute(r ApiDeleteTasksIDRequest) error

	/*
	 * DeleteTasksIDRunsID Cancel a running task
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param taskID The task ID.
	 * @param runID The run ID.
	 * @return ApiDeleteTasksIDRunsIDRequest
	 */
	DeleteTasksIDRunsID(ctx _context.Context, taskID string, runID string) ApiDeleteTasksIDRunsIDRequest

	/*
	 * DeleteTasksIDRunsIDExecute executes the request
	 */
	DeleteTasksIDRunsIDExecute(r ApiDeleteTasksIDRunsIDRequest) error

	/*
	 * GetTasks List all tasks
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return ApiGetTasksRequest
	 */
	GetTasks(ctx _context.Context) ApiGetTasksRequest

	/*
	 * GetTasksExecute executes the request
	 * @return Tasks
	 */
	GetTasksExecute(r ApiGetTasksRequest) (Tasks, error)

	/*
	 * GetTasksID Retrieve a task
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param taskID The task ID.
	 * @return ApiGetTasksIDRequest
	 */
	GetTasksID(ctx _context.Context, taskID string) ApiGetTasksIDRequest

	/*
	 * GetTasksIDExecute executes the request
	 * @return Task
	 */
	GetTasksIDExecute(r ApiGetTasksIDRequest) (Task, error)

	/*
	 * GetTasksIDLogs Retrieve all logs for a task
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param taskID The task ID.
	 * @return ApiGetTasksIDLogsRequest
	 */
	GetTasksIDLogs(ctx _context.Context, taskID string) ApiGetTasksIDLogsRequest

	/*
	 * GetTasksIDLogsExecute executes the request
	 * @return Logs
	 */
	GetTasksIDLogsExecute(r ApiGetTasksIDLogsRequest) (Logs, error)

	/*
	 * GetTasksIDRuns List runs for a task
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param taskID The ID of the task to get runs for.
	 * @return ApiGetTasksIDRunsRequest
	 */
	GetTasksIDRuns(ctx _context.Context, taskID string) ApiGetTasksIDRunsRequest

	/*
	 * GetTasksIDRunsExecute executes the request
	 * @return Runs
	 */
	GetTasksIDRunsExecute(r ApiGetTasksIDRunsRequest) (Runs, error)

	/*
	 * GetTasksIDRunsID Retrieve a single run for a task
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param taskID The task ID.
	 * @param runID The run ID.
	 * @return ApiGetTasksIDRunsIDRequest
	 */
	GetTasksIDRunsID(ctx _context.Context, taskID string, runID string) ApiGetTasksIDRunsIDRequest

	/*
	 * GetTasksIDRunsIDExecute executes the request
	 * @return Run
	 */
	GetTasksIDRunsIDExecute(r ApiGetTasksIDRunsIDRequest) (Run, error)

	/*
	 * GetTasksIDRunsIDLogs Retrieve all logs for a run
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param taskID ID of task to get logs for.
	 * @param runID ID of run to get logs for.
	 * @return ApiGetTasksIDRunsIDLogsRequest
	 */
	GetTasksIDRunsIDLogs(ctx _context.Context, taskID string, runID string) ApiGetTasksIDRunsIDLogsRequest

	/*
	 * GetTasksIDRunsIDLogsExecute executes the request
	 * @return Logs
	 */
	GetTasksIDRunsIDLogsExecute(r ApiGetTasksIDRunsIDLogsRequest) (Logs, error)

	/*
	 * PatchTasksID Update a task
	 * Update a task. This will cancel all queued runs.
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param taskID The task ID.
	 * @return ApiPatchTasksIDRequest
	 */
	PatchTasksID(ctx _context.Context, taskID string) ApiPatchTasksIDRequest

	/*
	 * PatchTasksIDExecute executes the request
	 * @return Task
	 */
	PatchTasksIDExecute(r ApiPatchTasksIDRequest) (Task, error)

	/*
	 * PostTasks Create a new task
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return ApiPostTasksRequest
	 */
	PostTasks(ctx _context.Context) ApiPostTasksRequest

	/*
	 * PostTasksExecute executes the request
	 * @return Task
	 */
	PostTasksExecute(r ApiPostTasksRequest) (Task, error)

	/*
	 * PostTasksIDRuns Manually start a task run, overriding the current schedule
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param taskID
	 * @return ApiPostTasksIDRunsRequest
	 */
	PostTasksIDRuns(ctx _context.Context, taskID string) ApiPostTasksIDRunsRequest

	/*
	 * PostTasksIDRunsExecute executes the request
	 * @return Run
	 */
	PostTasksIDRunsExecute(r ApiPostTasksIDRunsRequest) (Run, error)

	/*
	 * PostTasksIDRunsIDRetry Retry a task run
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param taskID The task ID.
	 * @param runID The run ID.
	 * @return ApiPostTasksIDRunsIDRetryRequest
	 */
	PostTasksIDRunsIDRetry(ctx _context.Context, taskID string, runID string) ApiPostTasksIDRunsIDRetryRequest

	/*
	 * PostTasksIDRunsIDRetryExecute executes the request
	 * @return Run
	 */
	PostTasksIDRunsIDRetryExecute(r ApiPostTasksIDRunsIDRetryRequest) (Run, error)

	// Sets additional descriptive text in the error message if any request in
	// this API fails, indicating that it is intended to be used only on OSS
	// servers.
	OnlyOSS() TasksApi

	// Sets additional descriptive text in the error message if any request in
	// this API fails, indicating that it is intended to be used only on cloud
	// servers.
	OnlyCloud() TasksApi
}

// TasksApiService TasksApi service
type TasksApiService service

func (a *TasksApiService) OnlyOSS() TasksApi {
	a.isOnlyOSS = true
	return a
}

func (a *TasksApiService) OnlyCloud() TasksApi {
	a.isOnlyCloud = true
	return a
}

type ApiDeleteTasksIDRequest struct {
	ctx          _context.Context
	ApiService   TasksApi
	taskID       string
	zapTraceSpan *string
}

func (r ApiDeleteTasksIDRequest) TaskID(taskID string) ApiDeleteTasksIDRequest {
	r.taskID = taskID
	return r
}
func (r ApiDeleteTasksIDRequest) GetTaskID() string {
	return r.taskID
}

func (r ApiDeleteTasksIDRequest) ZapTraceSpan(zapTraceSpan string) ApiDeleteTasksIDRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiDeleteTasksIDRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiDeleteTasksIDRequest) Execute() error {
	return r.ApiService.DeleteTasksIDExecute(r)
}

/*
 * DeleteTasksID Delete a task
 * Deletes a task and all associated records
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param taskID The ID of the task to delete.
 * @return ApiDeleteTasksIDRequest
 */
func (a *TasksApiService) DeleteTasksID(ctx _context.Context, taskID string) ApiDeleteTasksIDRequest {
	return ApiDeleteTasksIDRequest{
		ApiService: a,
		ctx:        ctx,
		taskID:     taskID,
	}
}

/*
 * Execute executes the request
 */
func (a *TasksApiService) DeleteTasksIDExecute(r ApiDeleteTasksIDRequest) error {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TasksApiService.DeleteTasksID")
	if err != nil {
		return GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/tasks/{taskID}"
	localVarPath = strings.Replace(localVarPath, "{"+"taskID"+"}", _neturl.PathEscape(parameterToString(r.taskID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return newErr
	}

	return nil
}

type ApiDeleteTasksIDRunsIDRequest struct {
	ctx          _context.Context
	ApiService   TasksApi
	taskID       string
	runID        string
	zapTraceSpan *string
}

func (r ApiDeleteTasksIDRunsIDRequest) TaskID(taskID string) ApiDeleteTasksIDRunsIDRequest {
	r.taskID = taskID
	return r
}
func (r ApiDeleteTasksIDRunsIDRequest) GetTaskID() string {
	return r.taskID
}

func (r ApiDeleteTasksIDRunsIDRequest) RunID(runID string) ApiDeleteTasksIDRunsIDRequest {
	r.runID = runID
	return r
}
func (r ApiDeleteTasksIDRunsIDRequest) GetRunID() string {
	return r.runID
}

func (r ApiDeleteTasksIDRunsIDRequest) ZapTraceSpan(zapTraceSpan string) ApiDeleteTasksIDRunsIDRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiDeleteTasksIDRunsIDRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiDeleteTasksIDRunsIDRequest) Execute() error {
	return r.ApiService.DeleteTasksIDRunsIDExecute(r)
}

/*
 * DeleteTasksIDRunsID Cancel a running task
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param taskID The task ID.
 * @param runID The run ID.
 * @return ApiDeleteTasksIDRunsIDRequest
 */
func (a *TasksApiService) DeleteTasksIDRunsID(ctx _context.Context, taskID string, runID string) ApiDeleteTasksIDRunsIDRequest {
	return ApiDeleteTasksIDRunsIDRequest{
		ApiService: a,
		ctx:        ctx,
		taskID:     taskID,
		runID:      runID,
	}
}

/*
 * Execute executes the request
 */
func (a *TasksApiService) DeleteTasksIDRunsIDExecute(r ApiDeleteTasksIDRunsIDRequest) error {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TasksApiService.DeleteTasksIDRunsID")
	if err != nil {
		return GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/tasks/{taskID}/runs/{runID}"
	localVarPath = strings.Replace(localVarPath, "{"+"taskID"+"}", _neturl.PathEscape(parameterToString(r.taskID, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"runID"+"}", _neturl.PathEscape(parameterToString(r.runID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return newErr
	}

	return nil
}

type ApiGetTasksRequest struct {
	ctx          _context.Context
	ApiService   TasksApi
	zapTraceSpan *string
	name         *string
	after        *string
	user         *string
	org          *string
	orgID        *string
	status       *string
	limit        *int32
}

func (r ApiGetTasksRequest) ZapTraceSpan(zapTraceSpan string) ApiGetTasksRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiGetTasksRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiGetTasksRequest) Name(name string) ApiGetTasksRequest {
	r.name = &name
	return r
}
func (r ApiGetTasksRequest) GetName() *string {
	return r.name
}

func (r ApiGetTasksRequest) After(after string) ApiGetTasksRequest {
	r.after = &after
	return r
}
func (r ApiGetTasksRequest) GetAfter() *string {
	return r.after
}

func (r ApiGetTasksRequest) User(user string) ApiGetTasksRequest {
	r.user = &user
	return r
}
func (r ApiGetTasksRequest) GetUser() *string {
	return r.user
}

func (r ApiGetTasksRequest) Org(org string) ApiGetTasksRequest {
	r.org = &org
	return r
}
func (r ApiGetTasksRequest) GetOrg() *string {
	return r.org
}

func (r ApiGetTasksRequest) OrgID(orgID string) ApiGetTasksRequest {
	r.orgID = &orgID
	return r
}
func (r ApiGetTasksRequest) GetOrgID() *string {
	return r.orgID
}

func (r ApiGetTasksRequest) Status(status string) ApiGetTasksRequest {
	r.status = &status
	return r
}
func (r ApiGetTasksRequest) GetStatus() *string {
	return r.status
}

func (r ApiGetTasksRequest) Limit(limit int32) ApiGetTasksRequest {
	r.limit = &limit
	return r
}
func (r ApiGetTasksRequest) GetLimit() *int32 {
	return r.limit
}

func (r ApiGetTasksRequest) Execute() (Tasks, error) {
	return r.ApiService.GetTasksExecute(r)
}

/*
 * GetTasks List all tasks
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @return ApiGetTasksRequest
 */
func (a *TasksApiService) GetTasks(ctx _context.Context) ApiGetTasksRequest {
	return ApiGetTasksRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return Tasks
 */
func (a *TasksApiService) GetTasksExecute(r ApiGetTasksRequest) (Tasks, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Tasks
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TasksApiService.GetTasks")
	if err != nil {
		return localVarReturnValue, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/tasks"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.name != nil {
		localVarQueryParams.Add("name", parameterToString(*r.name, ""))
	}
	if r.after != nil {
		localVarQueryParams.Add("after", parameterToString(*r.after, ""))
	}
	if r.user != nil {
		localVarQueryParams.Add("user", parameterToString(*r.user, ""))
	}
	if r.org != nil {
		localVarQueryParams.Add("org", parameterToString(*r.org, ""))
	}
	if r.orgID != nil {
		localVarQueryParams.Add("orgID", parameterToString(*r.orgID, ""))
	}
	if r.status != nil {
		localVarQueryParams.Add("status", parameterToString(*r.status, ""))
	}
	if r.limit != nil {
		localVarQueryParams.Add("limit", parameterToString(*r.limit, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, err.Error()),
		}
		return localVarReturnValue, newErr
	}

	return localVarReturnValue, nil
}

type ApiGetTasksIDRequest struct {
	ctx          _context.Context
	ApiService   TasksApi
	taskID       string
	zapTraceSpan *string
}

func (r ApiGetTasksIDRequest) TaskID(taskID string) ApiGetTasksIDRequest {
	r.taskID = taskID
	return r
}
func (r ApiGetTasksIDRequest) GetTaskID() string {
	return r.taskID
}

func (r ApiGetTasksIDRequest) ZapTraceSpan(zapTraceSpan string) ApiGetTasksIDRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiGetTasksIDRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiGetTasksIDRequest) Execute() (Task, error) {
	return r.ApiService.GetTasksIDExecute(r)
}

/*
 * GetTasksID Retrieve a task
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param taskID The task ID.
 * @return ApiGetTasksIDRequest
 */
func (a *TasksApiService) GetTasksID(ctx _context.Context, taskID string) ApiGetTasksIDRequest {
	return ApiGetTasksIDRequest{
		ApiService: a,
		ctx:        ctx,
		taskID:     taskID,
	}
}

/*
 * Execute executes the request
 * @return Task
 */
func (a *TasksApiService) GetTasksIDExecute(r ApiGetTasksIDRequest) (Task, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Task
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TasksApiService.GetTasksID")
	if err != nil {
		return localVarReturnValue, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/tasks/{taskID}"
	localVarPath = strings.Replace(localVarPath, "{"+"taskID"+"}", _neturl.PathEscape(parameterToString(r.taskID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, err.Error()),
		}
		return localVarReturnValue, newErr
	}

	return localVarReturnValue, nil
}

type ApiGetTasksIDLogsRequest struct {
	ctx          _context.Context
	ApiService   TasksApi
	taskID       string
	zapTraceSpan *string
}

func (r ApiGetTasksIDLogsRequest) TaskID(taskID string) ApiGetTasksIDLogsRequest {
	r.taskID = taskID
	return r
}
func (r ApiGetTasksIDLogsRequest) GetTaskID() string {
	return r.taskID
}

func (r ApiGetTasksIDLogsRequest) ZapTraceSpan(zapTraceSpan string) ApiGetTasksIDLogsRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiGetTasksIDLogsRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiGetTasksIDLogsRequest) Execute() (Logs, error) {
	return r.ApiService.GetTasksIDLogsExecute(r)
}

/*
 * GetTasksIDLogs Retrieve all logs for a task
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param taskID The task ID.
 * @return ApiGetTasksIDLogsRequest
 */
func (a *TasksApiService) GetTasksIDLogs(ctx _context.Context, taskID string) ApiGetTasksIDLogsRequest {
	return ApiGetTasksIDLogsRequest{
		ApiService: a,
		ctx:        ctx,
		taskID:     taskID,
	}
}

/*
 * Execute executes the request
 * @return Logs
 */
func (a *TasksApiService) GetTasksIDLogsExecute(r ApiGetTasksIDLogsRequest) (Logs, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Logs
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TasksApiService.GetTasksIDLogs")
	if err != nil {
		return localVarReturnValue, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/tasks/{taskID}/logs"
	localVarPath = strings.Replace(localVarPath, "{"+"taskID"+"}", _neturl.PathEscape(parameterToString(r.taskID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, err.Error()),
		}
		return localVarReturnValue, newErr
	}

	return localVarReturnValue, nil
}

type ApiGetTasksIDRunsRequest struct {
	ctx          _context.Context
	ApiService   TasksApi
	taskID       string
	zapTraceSpan *string
	after        *string
	limit        *int32
	afterTime    *time.Time
	beforeTime   *time.Time
}

func (r ApiGetTasksIDRunsRequest) TaskID(taskID string) ApiGetTasksIDRunsRequest {
	r.taskID = taskID
	return r
}
func (r ApiGetTasksIDRunsRequest) GetTaskID() string {
	return r.taskID
}

func (r ApiGetTasksIDRunsRequest) ZapTraceSpan(zapTraceSpan string) ApiGetTasksIDRunsRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiGetTasksIDRunsRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiGetTasksIDRunsRequest) After(after string) ApiGetTasksIDRunsRequest {
	r.after = &after
	return r
}
func (r ApiGetTasksIDRunsRequest) GetAfter() *string {
	return r.after
}

func (r ApiGetTasksIDRunsRequest) Limit(limit int32) ApiGetTasksIDRunsRequest {
	r.limit = &limit
	return r
}
func (r ApiGetTasksIDRunsRequest) GetLimit() *int32 {
	return r.limit
}

func (r ApiGetTasksIDRunsRequest) AfterTime(afterTime time.Time) ApiGetTasksIDRunsRequest {
	r.afterTime = &afterTime
	return r
}
func (r ApiGetTasksIDRunsRequest) GetAfterTime() *time.Time {
	return r.afterTime
}

func (r ApiGetTasksIDRunsRequest) BeforeTime(beforeTime time.Time) ApiGetTasksIDRunsRequest {
	r.beforeTime = &beforeTime
	return r
}
func (r ApiGetTasksIDRunsRequest) GetBeforeTime() *time.Time {
	return r.beforeTime
}

func (r ApiGetTasksIDRunsRequest) Execute() (Runs, error) {
	return r.ApiService.GetTasksIDRunsExecute(r)
}

/*
 * GetTasksIDRuns List runs for a task
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param taskID The ID of the task to get runs for.
 * @return ApiGetTasksIDRunsRequest
 */
func (a *TasksApiService) GetTasksIDRuns(ctx _context.Context, taskID string) ApiGetTasksIDRunsRequest {
	return ApiGetTasksIDRunsRequest{
		ApiService: a,
		ctx:        ctx,
		taskID:     taskID,
	}
}

/*
 * Execute executes the request
 * @return Runs
 */
func (a *TasksApiService) GetTasksIDRunsExecute(r ApiGetTasksIDRunsRequest) (Runs, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Runs
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TasksApiService.GetTasksIDRuns")
	if err != nil {
		return localVarReturnValue, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/tasks/{taskID}/runs"
	localVarPath = strings.Replace(localVarPath, "{"+"taskID"+"}", _neturl.PathEscape(parameterToString(r.taskID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.after != nil {
		localVarQueryParams.Add("after", parameterToString(*r.after, ""))
	}
	if r.limit != nil {
		localVarQueryParams.Add("limit", parameterToString(*r.limit, ""))
	}
	if r.afterTime != nil {
		localVarQueryParams.Add("afterTime", parameterToString(*r.afterTime, ""))
	}
	if r.beforeTime != nil {
		localVarQueryParams.Add("beforeTime", parameterToString(*r.beforeTime, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, err.Error()),
		}
		return localVarReturnValue, newErr
	}

	return localVarReturnValue, nil
}

type ApiGetTasksIDRunsIDRequest struct {
	ctx          _context.Context
	ApiService   TasksApi
	taskID       string
	runID        string
	zapTraceSpan *string
}

func (r ApiGetTasksIDRunsIDRequest) TaskID(taskID string) ApiGetTasksIDRunsIDRequest {
	r.taskID = taskID
	return r
}
func (r ApiGetTasksIDRunsIDRequest) GetTaskID() string {
	return r.taskID
}

func (r ApiGetTasksIDRunsIDRequest) RunID(runID string) ApiGetTasksIDRunsIDRequest {
	r.runID = runID
	return r
}
func (r ApiGetTasksIDRunsIDRequest) GetRunID() string {
	return r.runID
}

func (r ApiGetTasksIDRunsIDRequest) ZapTraceSpan(zapTraceSpan string) ApiGetTasksIDRunsIDRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiGetTasksIDRunsIDRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiGetTasksIDRunsIDRequest) Execute() (Run, error) {
	return r.ApiService.GetTasksIDRunsIDExecute(r)
}

/*
 * GetTasksIDRunsID Retrieve a single run for a task
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param taskID The task ID.
 * @param runID The run ID.
 * @return ApiGetTasksIDRunsIDRequest
 */
func (a *TasksApiService) GetTasksIDRunsID(ctx _context.Context, taskID string, runID string) ApiGetTasksIDRunsIDRequest {
	return ApiGetTasksIDRunsIDRequest{
		ApiService: a,
		ctx:        ctx,
		taskID:     taskID,
		runID:      runID,
	}
}

/*
 * Execute executes the request
 * @return Run
 */
func (a *TasksApiService) GetTasksIDRunsIDExecute(r ApiGetTasksIDRunsIDRequest) (Run, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Run
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TasksApiService.GetTasksIDRunsID")
	if err != nil {
		return localVarReturnValue, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/tasks/{taskID}/runs/{runID}"
	localVarPath = strings.Replace(localVarPath, "{"+"taskID"+"}", _neturl.PathEscape(parameterToString(r.taskID, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"runID"+"}", _neturl.PathEscape(parameterToString(r.runID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, err.Error()),
		}
		return localVarReturnValue, newErr
	}

	return localVarReturnValue, nil
}

type ApiGetTasksIDRunsIDLogsRequest struct {
	ctx          _context.Context
	ApiService   TasksApi
	taskID       string
	runID        string
	zapTraceSpan *string
}

func (r ApiGetTasksIDRunsIDLogsRequest) TaskID(taskID string) ApiGetTasksIDRunsIDLogsRequest {
	r.taskID = taskID
	return r
}
func (r ApiGetTasksIDRunsIDLogsRequest) GetTaskID() string {
	return r.taskID
}

func (r ApiGetTasksIDRunsIDLogsRequest) RunID(runID string) ApiGetTasksIDRunsIDLogsRequest {
	r.runID = runID
	return r
}
func (r ApiGetTasksIDRunsIDLogsRequest) GetRunID() string {
	return r.runID
}

func (r ApiGetTasksIDRunsIDLogsRequest) ZapTraceSpan(zapTraceSpan string) ApiGetTasksIDRunsIDLogsRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiGetTasksIDRunsIDLogsRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiGetTasksIDRunsIDLogsRequest) Execute() (Logs, error) {
	return r.ApiService.GetTasksIDRunsIDLogsExecute(r)
}

/*
 * GetTasksIDRunsIDLogs Retrieve all logs for a run
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param taskID ID of task to get logs for.
 * @param runID ID of run to get logs for.
 * @return ApiGetTasksIDRunsIDLogsRequest
 */
func (a *TasksApiService) GetTasksIDRunsIDLogs(ctx _context.Context, taskID string, runID string) ApiGetTasksIDRunsIDLogsRequest {
	return ApiGetTasksIDRunsIDLogsRequest{
		ApiService: a,
		ctx:        ctx,
		taskID:     taskID,
		runID:      runID,
	}
}

/*
 * Execute executes the request
 * @return Logs
 */
func (a *TasksApiService) GetTasksIDRunsIDLogsExecute(r ApiGetTasksIDRunsIDLogsRequest) (Logs, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Logs
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TasksApiService.GetTasksIDRunsIDLogs")
	if err != nil {
		return localVarReturnValue, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/tasks/{taskID}/runs/{runID}/logs"
	localVarPath = strings.Replace(localVarPath, "{"+"taskID"+"}", _neturl.PathEscape(parameterToString(r.taskID, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"runID"+"}", _neturl.PathEscape(parameterToString(r.runID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, err.Error()),
		}
		return localVarReturnValue, newErr
	}

	return localVarReturnValue, nil
}

type ApiPatchTasksIDRequest struct {
	ctx               _context.Context
	ApiService        TasksApi
	taskID            string
	taskUpdateRequest *TaskUpdateRequest
	zapTraceSpan      *string
}

func (r ApiPatchTasksIDRequest) TaskID(taskID string) ApiPatchTasksIDRequest {
	r.taskID = taskID
	return r
}
func (r ApiPatchTasksIDRequest) GetTaskID() string {
	return r.taskID
}

func (r ApiPatchTasksIDRequest) TaskUpdateRequest(taskUpdateRequest TaskUpdateRequest) ApiPatchTasksIDRequest {
	r.taskUpdateRequest = &taskUpdateRequest
	return r
}
func (r ApiPatchTasksIDRequest) GetTaskUpdateRequest() *TaskUpdateRequest {
	return r.taskUpdateRequest
}

func (r ApiPatchTasksIDRequest) ZapTraceSpan(zapTraceSpan string) ApiPatchTasksIDRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiPatchTasksIDRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiPatchTasksIDRequest) Execute() (Task, error) {
	return r.ApiService.PatchTasksIDExecute(r)
}

/*
 * PatchTasksID Update a task
 * Update a task. This will cancel all queued runs.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param taskID The task ID.
 * @return ApiPatchTasksIDRequest
 */
func (a *TasksApiService) PatchTasksID(ctx _context.Context, taskID string) ApiPatchTasksIDRequest {
	return ApiPatchTasksIDRequest{
		ApiService: a,
		ctx:        ctx,
		taskID:     taskID,
	}
}

/*
 * Execute executes the request
 * @return Task
 */
func (a *TasksApiService) PatchTasksIDExecute(r ApiPatchTasksIDRequest) (Task, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPatch
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Task
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TasksApiService.PatchTasksID")
	if err != nil {
		return localVarReturnValue, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/tasks/{taskID}"
	localVarPath = strings.Replace(localVarPath, "{"+"taskID"+"}", _neturl.PathEscape(parameterToString(r.taskID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.taskUpdateRequest == nil {
		return localVarReturnValue, reportError("taskUpdateRequest is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	// body params
	localVarPostBody = r.taskUpdateRequest
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, err.Error()),
		}
		return localVarReturnValue, newErr
	}

	return localVarReturnValue, nil
}

type ApiPostTasksRequest struct {
	ctx               _context.Context
	ApiService        TasksApi
	taskCreateRequest *TaskCreateRequest
	zapTraceSpan      *string
}

func (r ApiPostTasksRequest) TaskCreateRequest(taskCreateRequest TaskCreateRequest) ApiPostTasksRequest {
	r.taskCreateRequest = &taskCreateRequest
	return r
}
func (r ApiPostTasksRequest) GetTaskCreateRequest() *TaskCreateRequest {
	return r.taskCreateRequest
}

func (r ApiPostTasksRequest) ZapTraceSpan(zapTraceSpan string) ApiPostTasksRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiPostTasksRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiPostTasksRequest) Execute() (Task, error) {
	return r.ApiService.PostTasksExecute(r)
}

/*
 * PostTasks Create a new task
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @return ApiPostTasksRequest
 */
func (a *TasksApiService) PostTasks(ctx _context.Context) ApiPostTasksRequest {
	return ApiPostTasksRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return Task
 */
func (a *TasksApiService) PostTasksExecute(r ApiPostTasksRequest) (Task, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Task
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TasksApiService.PostTasks")
	if err != nil {
		return localVarReturnValue, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/tasks"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.taskCreateRequest == nil {
		return localVarReturnValue, reportError("taskCreateRequest is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	// body params
	localVarPostBody = r.taskCreateRequest
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, err.Error()),
		}
		return localVarReturnValue, newErr
	}

	return localVarReturnValue, nil
}

type ApiPostTasksIDRunsRequest struct {
	ctx          _context.Context
	ApiService   TasksApi
	taskID       string
	zapTraceSpan *string
	runManually  *RunManually
}

func (r ApiPostTasksIDRunsRequest) TaskID(taskID string) ApiPostTasksIDRunsRequest {
	r.taskID = taskID
	return r
}
func (r ApiPostTasksIDRunsRequest) GetTaskID() string {
	return r.taskID
}

func (r ApiPostTasksIDRunsRequest) ZapTraceSpan(zapTraceSpan string) ApiPostTasksIDRunsRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiPostTasksIDRunsRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiPostTasksIDRunsRequest) RunManually(runManually RunManually) ApiPostTasksIDRunsRequest {
	r.runManually = &runManually
	return r
}
func (r ApiPostTasksIDRunsRequest) GetRunManually() *RunManually {
	return r.runManually
}

func (r ApiPostTasksIDRunsRequest) Execute() (Run, error) {
	return r.ApiService.PostTasksIDRunsExecute(r)
}

/*
 * PostTasksIDRuns Manually start a task run, overriding the current schedule
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param taskID
 * @return ApiPostTasksIDRunsRequest
 */
func (a *TasksApiService) PostTasksIDRuns(ctx _context.Context, taskID string) ApiPostTasksIDRunsRequest {
	return ApiPostTasksIDRunsRequest{
		ApiService: a,
		ctx:        ctx,
		taskID:     taskID,
	}
}

/*
 * Execute executes the request
 * @return Run
 */
func (a *TasksApiService) PostTasksIDRunsExecute(r ApiPostTasksIDRunsRequest) (Run, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Run
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TasksApiService.PostTasksIDRuns")
	if err != nil {
		return localVarReturnValue, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/tasks/{taskID}/runs"
	localVarPath = strings.Replace(localVarPath, "{"+"taskID"+"}", _neturl.PathEscape(parameterToString(r.taskID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	// body params
	localVarPostBody = r.runManually
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, err.Error()),
		}
		return localVarReturnValue, newErr
	}

	return localVarReturnValue, nil
}

type ApiPostTasksIDRunsIDRetryRequest struct {
	ctx          _context.Context
	ApiService   TasksApi
	taskID       string
	runID        string
	zapTraceSpan *string
	body         *map[string]interface{}
}

func (r ApiPostTasksIDRunsIDRetryRequest) TaskID(taskID string) ApiPostTasksIDRunsIDRetryRequest {
	r.taskID = taskID
	return r
}
func (r ApiPostTasksIDRunsIDRetryRequest) GetTaskID() string {
	return r.taskID
}

func (r ApiPostTasksIDRunsIDRetryRequest) RunID(runID string) ApiPostTasksIDRunsIDRetryRequest {
	r.runID = runID
	return r
}
func (r ApiPostTasksIDRunsIDRetryRequest) GetRunID() string {
	return r.runID
}

func (r ApiPostTasksIDRunsIDRetryRequest) ZapTraceSpan(zapTraceSpan string) ApiPostTasksIDRunsIDRetryRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiPostTasksIDRunsIDRetryRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiPostTasksIDRunsIDRetryRequest) Body(body map[string]interface{}) ApiPostTasksIDRunsIDRetryRequest {
	r.body = &body
	return r
}
func (r ApiPostTasksIDRunsIDRetryRequest) GetBody() *map[string]interface{} {
	return r.body
}

func (r ApiPostTasksIDRunsIDRetryRequest) Execute() (Run, error) {
	return r.ApiService.PostTasksIDRunsIDRetryExecute(r)
}

/*
 * PostTasksIDRunsIDRetry Retry a task run
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param taskID The task ID.
 * @param runID The run ID.
 * @return ApiPostTasksIDRunsIDRetryRequest
 */
func (a *TasksApiService) PostTasksIDRunsIDRetry(ctx _context.Context, taskID string, runID string) ApiPostTasksIDRunsIDRetryRequest {
	return ApiPostTasksIDRunsIDRetryRequest{
		ApiService: a,
		ctx:        ctx,
		taskID:     taskID,
		runID:      runID,
	}
}

/*
 * Execute executes the request
 * @return Run
 */
func (a *TasksApiService) PostTasksIDRunsIDRetryExecute(r ApiPostTasksIDRunsIDRetryRequest) (Run, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Run
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TasksApiService.PostTasksIDRunsIDRetry")
	if err != nil {
		return localVarReturnValue, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/tasks/{taskID}/runs/{runID}/retry"
	localVarPath = strings.Replace(localVarPath, "{"+"taskID"+"}", _neturl.PathEscape(parameterToString(r.taskID, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"runID"+"}", _neturl.PathEscape(parameterToString(r.runID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json; charset=utf-8"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	// body params
	localVarPostBody = r.body
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, err.Error()),
		}
		return localVarReturnValue, newErr
	}

	return localVarReturnValue, nil
}
