/*
 * Subset of Influx API covered by Influx CLI
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * API version: 2.0.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package api

import (
	_context "context"
	_fmt "fmt"
	_io "io"
	_nethttp "net/http"
	_neturl "net/url"
	"strings"
)

// Linger please
var (
	_ _context.Context
)

type ReplicationsApi interface {

	/*
	 * DeleteReplicationByID Delete a replication
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param replicationID
	 * @return ApiDeleteReplicationByIDRequest
	 */
	DeleteReplicationByID(ctx _context.Context, replicationID string) ApiDeleteReplicationByIDRequest

	/*
	 * DeleteReplicationByIDExecute executes the request
	 */
	DeleteReplicationByIDExecute(r ApiDeleteReplicationByIDRequest) error

	/*
	 * GetReplicationByID Retrieve a replication
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param replicationID
	 * @return ApiGetReplicationByIDRequest
	 */
	GetReplicationByID(ctx _context.Context, replicationID string) ApiGetReplicationByIDRequest

	/*
	 * GetReplicationByIDExecute executes the request
	 * @return Replication
	 */
	GetReplicationByIDExecute(r ApiGetReplicationByIDRequest) (Replication, error)

	/*
	 * GetReplications List all replications
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return ApiGetReplicationsRequest
	 */
	GetReplications(ctx _context.Context) ApiGetReplicationsRequest

	/*
	 * GetReplicationsExecute executes the request
	 * @return Replications
	 */
	GetReplicationsExecute(r ApiGetReplicationsRequest) (Replications, error)

	/*
	 * PatchReplicationByID Update a replication
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param replicationID
	 * @return ApiPatchReplicationByIDRequest
	 */
	PatchReplicationByID(ctx _context.Context, replicationID string) ApiPatchReplicationByIDRequest

	/*
	 * PatchReplicationByIDExecute executes the request
	 * @return Replication
	 */
	PatchReplicationByIDExecute(r ApiPatchReplicationByIDRequest) (Replication, error)

	/*
	 * PostReplication Register a new replication
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return ApiPostReplicationRequest
	 */
	PostReplication(ctx _context.Context) ApiPostReplicationRequest

	/*
	 * PostReplicationExecute executes the request
	 * @return Replication
	 */
	PostReplicationExecute(r ApiPostReplicationRequest) (Replication, error)

	/*
	 * PostValidateReplicationByID Validate a replication
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param replicationID
	 * @return ApiPostValidateReplicationByIDRequest
	 */
	PostValidateReplicationByID(ctx _context.Context, replicationID string) ApiPostValidateReplicationByIDRequest

	/*
	 * PostValidateReplicationByIDExecute executes the request
	 */
	PostValidateReplicationByIDExecute(r ApiPostValidateReplicationByIDRequest) error

	// Sets additional descriptive text in the error message if any request in
	// this API fails, indicating that it is intended to be used only on OSS
	// servers.
	OnlyOSS() ReplicationsApi

	// Sets additional descriptive text in the error message if any request in
	// this API fails, indicating that it is intended to be used only on cloud
	// servers.
	OnlyCloud() ReplicationsApi
}

// ReplicationsApiService ReplicationsApi service
type ReplicationsApiService service

func (a *ReplicationsApiService) OnlyOSS() ReplicationsApi {
	a.isOnlyOSS = true
	return a
}

func (a *ReplicationsApiService) OnlyCloud() ReplicationsApi {
	a.isOnlyCloud = true
	return a
}

type ApiDeleteReplicationByIDRequest struct {
	ctx           _context.Context
	ApiService    ReplicationsApi
	replicationID string
	zapTraceSpan  *string
}

func (r ApiDeleteReplicationByIDRequest) ReplicationID(replicationID string) ApiDeleteReplicationByIDRequest {
	r.replicationID = replicationID
	return r
}
func (r ApiDeleteReplicationByIDRequest) GetReplicationID() string {
	return r.replicationID
}

func (r ApiDeleteReplicationByIDRequest) ZapTraceSpan(zapTraceSpan string) ApiDeleteReplicationByIDRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiDeleteReplicationByIDRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiDeleteReplicationByIDRequest) Execute() error {
	return r.ApiService.DeleteReplicationByIDExecute(r)
}

/*
 * DeleteReplicationByID Delete a replication
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param replicationID
 * @return ApiDeleteReplicationByIDRequest
 */
func (a *ReplicationsApiService) DeleteReplicationByID(ctx _context.Context, replicationID string) ApiDeleteReplicationByIDRequest {
	return ApiDeleteReplicationByIDRequest{
		ApiService:    a,
		ctx:           ctx,
		replicationID: replicationID,
	}
}

/*
 * Execute executes the request
 */
func (a *ReplicationsApiService) DeleteReplicationByIDExecute(r ApiDeleteReplicationByIDRequest) error {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ReplicationsApiService.DeleteReplicationByID")
	if err != nil {
		return GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/replications/{replicationID}"
	localVarPath = strings.Replace(localVarPath, "{"+"replicationID"+"}", _neturl.PathEscape(parameterToString(r.replicationID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return newErr
	}

	return nil
}

type ApiGetReplicationByIDRequest struct {
	ctx           _context.Context
	ApiService    ReplicationsApi
	replicationID string
	zapTraceSpan  *string
}

func (r ApiGetReplicationByIDRequest) ReplicationID(replicationID string) ApiGetReplicationByIDRequest {
	r.replicationID = replicationID
	return r
}
func (r ApiGetReplicationByIDRequest) GetReplicationID() string {
	return r.replicationID
}

func (r ApiGetReplicationByIDRequest) ZapTraceSpan(zapTraceSpan string) ApiGetReplicationByIDRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiGetReplicationByIDRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiGetReplicationByIDRequest) Execute() (Replication, error) {
	return r.ApiService.GetReplicationByIDExecute(r)
}

/*
 * GetReplicationByID Retrieve a replication
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param replicationID
 * @return ApiGetReplicationByIDRequest
 */
func (a *ReplicationsApiService) GetReplicationByID(ctx _context.Context, replicationID string) ApiGetReplicationByIDRequest {
	return ApiGetReplicationByIDRequest{
		ApiService:    a,
		ctx:           ctx,
		replicationID: replicationID,
	}
}

/*
 * Execute executes the request
 * @return Replication
 */
func (a *ReplicationsApiService) GetReplicationByIDExecute(r ApiGetReplicationByIDRequest) (Replication, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Replication
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ReplicationsApiService.GetReplicationByID")
	if err != nil {
		return localVarReturnValue, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/replications/{replicationID}"
	localVarPath = strings.Replace(localVarPath, "{"+"replicationID"+"}", _neturl.PathEscape(parameterToString(r.replicationID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, err.Error()),
		}
		return localVarReturnValue, newErr
	}

	return localVarReturnValue, nil
}

type ApiGetReplicationsRequest struct {
	ctx           _context.Context
	ApiService    ReplicationsApi
	orgID         *string
	zapTraceSpan  *string
	name          *string
	remoteID      *string
	localBucketID *string
}

func (r ApiGetReplicationsRequest) OrgID(orgID string) ApiGetReplicationsRequest {
	r.orgID = &orgID
	return r
}
func (r ApiGetReplicationsRequest) GetOrgID() *string {
	return r.orgID
}

func (r ApiGetReplicationsRequest) ZapTraceSpan(zapTraceSpan string) ApiGetReplicationsRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiGetReplicationsRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiGetReplicationsRequest) Name(name string) ApiGetReplicationsRequest {
	r.name = &name
	return r
}
func (r ApiGetReplicationsRequest) GetName() *string {
	return r.name
}

func (r ApiGetReplicationsRequest) RemoteID(remoteID string) ApiGetReplicationsRequest {
	r.remoteID = &remoteID
	return r
}
func (r ApiGetReplicationsRequest) GetRemoteID() *string {
	return r.remoteID
}

func (r ApiGetReplicationsRequest) LocalBucketID(localBucketID string) ApiGetReplicationsRequest {
	r.localBucketID = &localBucketID
	return r
}
func (r ApiGetReplicationsRequest) GetLocalBucketID() *string {
	return r.localBucketID
}

func (r ApiGetReplicationsRequest) Execute() (Replications, error) {
	return r.ApiService.GetReplicationsExecute(r)
}

/*
 * GetReplications List all replications
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @return ApiGetReplicationsRequest
 */
func (a *ReplicationsApiService) GetReplications(ctx _context.Context) ApiGetReplicationsRequest {
	return ApiGetReplicationsRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return Replications
 */
func (a *ReplicationsApiService) GetReplicationsExecute(r ApiGetReplicationsRequest) (Replications, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Replications
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ReplicationsApiService.GetReplications")
	if err != nil {
		return localVarReturnValue, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/replications"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.orgID == nil {
		return localVarReturnValue, reportError("orgID is required and must be specified")
	}

	localVarQueryParams.Add("orgID", parameterToString(*r.orgID, ""))
	if r.name != nil {
		localVarQueryParams.Add("name", parameterToString(*r.name, ""))
	}
	if r.remoteID != nil {
		localVarQueryParams.Add("remoteID", parameterToString(*r.remoteID, ""))
	}
	if r.localBucketID != nil {
		localVarQueryParams.Add("localBucketID", parameterToString(*r.localBucketID, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, err.Error()),
		}
		return localVarReturnValue, newErr
	}

	return localVarReturnValue, nil
}

type ApiPatchReplicationByIDRequest struct {
	ctx                      _context.Context
	ApiService               ReplicationsApi
	replicationID            string
	replicationUpdateRequest *ReplicationUpdateRequest
	zapTraceSpan             *string
	validate                 *bool
}

func (r ApiPatchReplicationByIDRequest) ReplicationID(replicationID string) ApiPatchReplicationByIDRequest {
	r.replicationID = replicationID
	return r
}
func (r ApiPatchReplicationByIDRequest) GetReplicationID() string {
	return r.replicationID
}

func (r ApiPatchReplicationByIDRequest) ReplicationUpdateRequest(replicationUpdateRequest ReplicationUpdateRequest) ApiPatchReplicationByIDRequest {
	r.replicationUpdateRequest = &replicationUpdateRequest
	return r
}
func (r ApiPatchReplicationByIDRequest) GetReplicationUpdateRequest() *ReplicationUpdateRequest {
	return r.replicationUpdateRequest
}

func (r ApiPatchReplicationByIDRequest) ZapTraceSpan(zapTraceSpan string) ApiPatchReplicationByIDRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiPatchReplicationByIDRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiPatchReplicationByIDRequest) Validate(validate bool) ApiPatchReplicationByIDRequest {
	r.validate = &validate
	return r
}
func (r ApiPatchReplicationByIDRequest) GetValidate() *bool {
	return r.validate
}

func (r ApiPatchReplicationByIDRequest) Execute() (Replication, error) {
	return r.ApiService.PatchReplicationByIDExecute(r)
}

/*
 * PatchReplicationByID Update a replication
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param replicationID
 * @return ApiPatchReplicationByIDRequest
 */
func (a *ReplicationsApiService) PatchReplicationByID(ctx _context.Context, replicationID string) ApiPatchReplicationByIDRequest {
	return ApiPatchReplicationByIDRequest{
		ApiService:    a,
		ctx:           ctx,
		replicationID: replicationID,
	}
}

/*
 * Execute executes the request
 * @return Replication
 */
func (a *ReplicationsApiService) PatchReplicationByIDExecute(r ApiPatchReplicationByIDRequest) (Replication, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPatch
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Replication
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ReplicationsApiService.PatchReplicationByID")
	if err != nil {
		return localVarReturnValue, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/replications/{replicationID}"
	localVarPath = strings.Replace(localVarPath, "{"+"replicationID"+"}", _neturl.PathEscape(parameterToString(r.replicationID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.replicationUpdateRequest == nil {
		return localVarReturnValue, reportError("replicationUpdateRequest is required and must be specified")
	}

	if r.validate != nil {
		localVarQueryParams.Add("validate", parameterToString(*r.validate, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	// body params
	localVarPostBody = r.replicationUpdateRequest
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, err.Error()),
		}
		return localVarReturnValue, newErr
	}

	return localVarReturnValue, nil
}

type ApiPostReplicationRequest struct {
	ctx                        _context.Context
	ApiService                 ReplicationsApi
	replicationCreationRequest *ReplicationCreationRequest
	zapTraceSpan               *string
	validate                   *bool
}

func (r ApiPostReplicationRequest) ReplicationCreationRequest(replicationCreationRequest ReplicationCreationRequest) ApiPostReplicationRequest {
	r.replicationCreationRequest = &replicationCreationRequest
	return r
}
func (r ApiPostReplicationRequest) GetReplicationCreationRequest() *ReplicationCreationRequest {
	return r.replicationCreationRequest
}

func (r ApiPostReplicationRequest) ZapTraceSpan(zapTraceSpan string) ApiPostReplicationRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiPostReplicationRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiPostReplicationRequest) Validate(validate bool) ApiPostReplicationRequest {
	r.validate = &validate
	return r
}
func (r ApiPostReplicationRequest) GetValidate() *bool {
	return r.validate
}

func (r ApiPostReplicationRequest) Execute() (Replication, error) {
	return r.ApiService.PostReplicationExecute(r)
}

/*
 * PostReplication Register a new replication
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @return ApiPostReplicationRequest
 */
func (a *ReplicationsApiService) PostReplication(ctx _context.Context) ApiPostReplicationRequest {
	return ApiPostReplicationRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return Replication
 */
func (a *ReplicationsApiService) PostReplicationExecute(r ApiPostReplicationRequest) (Replication, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Replication
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ReplicationsApiService.PostReplication")
	if err != nil {
		return localVarReturnValue, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/replications"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.replicationCreationRequest == nil {
		return localVarReturnValue, reportError("replicationCreationRequest is required and must be specified")
	}

	if r.validate != nil {
		localVarQueryParams.Add("validate", parameterToString(*r.validate, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	// body params
	localVarPostBody = r.replicationCreationRequest
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, err.Error()),
		}
		return localVarReturnValue, newErr
	}

	return localVarReturnValue, nil
}

type ApiPostValidateReplicationByIDRequest struct {
	ctx           _context.Context
	ApiService    ReplicationsApi
	replicationID string
	zapTraceSpan  *string
}

func (r ApiPostValidateReplicationByIDRequest) ReplicationID(replicationID string) ApiPostValidateReplicationByIDRequest {
	r.replicationID = replicationID
	return r
}
func (r ApiPostValidateReplicationByIDRequest) GetReplicationID() string {
	return r.replicationID
}

func (r ApiPostValidateReplicationByIDRequest) ZapTraceSpan(zapTraceSpan string) ApiPostValidateReplicationByIDRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiPostValidateReplicationByIDRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiPostValidateReplicationByIDRequest) Execute() error {
	return r.ApiService.PostValidateReplicationByIDExecute(r)
}

/*
 * PostValidateReplicationByID Validate a replication
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param replicationID
 * @return ApiPostValidateReplicationByIDRequest
 */
func (a *ReplicationsApiService) PostValidateReplicationByID(ctx _context.Context, replicationID string) ApiPostValidateReplicationByIDRequest {
	return ApiPostValidateReplicationByIDRequest{
		ApiService:    a,
		ctx:           ctx,
		replicationID: replicationID,
	}
}

/*
 * Execute executes the request
 */
func (a *ReplicationsApiService) PostValidateReplicationByIDExecute(r ApiPostValidateReplicationByIDRequest) error {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ReplicationsApiService.PostValidateReplicationByID")
	if err != nil {
		return GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/replications/{replicationID}/validate"
	localVarPath = strings.Replace(localVarPath, "{"+"replicationID"+"}", _neturl.PathEscape(parameterToString(r.replicationID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return newErr
	}

	return nil
}
