# go-internal - awesome utils from the go compiler

The Go compiler, whether surprisingly or not, has
a ton of incredible code, utilities, and other hidden gems.
Many rely on `internal` packages and so we cannot import them directly.

This repository contains code extracted from the Go compiler
and modified to fit more general purposes.
You can find example usage around the code base.


### Using

[![GitHub Release](https://img.shields.io/github/v/release/hofstadter-io/hof)](https://github.com/hofstadter-io/hof/releases)
[![go.dev reference](https://img.shields.io/badge/go.dev-reference-007d9c?logo=go&logoColor=white)](https://pkg.go.dev/mod/github.com/hofstadter-io/go-internals)
[![hof docs](https://img.shields.io/static/v1?label=_docs&message=hofstadter.io&color=02344d&labelColor=cba44f)](https://docs.hofstadter.io)
[![GitHub All Releases](https://img.shields.io/github/downloads/hofstadter-io/hof/total?color=02344d&labelColor=cba44f)](https://github.com/hofstadter-io/hof/releases)
[![Gitter](https://img.shields.io/gitter/room/hofstadter/hof)](https://gitter.im/hofstadter-io)



---

### Original readme from source fork


This repository factors out an opinionated selection of internal packages and functionality from the Go standard
library. Currently this consists mostly of packages and testing code from within the Go tool implementation.

Included are the following:

- dirhash: calculate hashes over directory trees the same way that the Go tool does.
- goproxytest: a GOPROXY implementation designed for test use.
- gotooltest: Use the Go tool inside test scripts (see testscript below)
- imports: list of known architectures and OSs, and support for reading import import statements.
- modfile: read and write `go.mod` files while preserving formatting and comments.
- module: module paths and versions.
- par: do work in parallel.
- semver: semantic version parsing.
- testenv: information on the current testing environment.
- testscript: script-based testing based on txtar files
- txtar: simple text-based file archives for testing.
