package cmdmod

import (
	"fmt"
	"os"

	"github.com/spf13/cobra"

	"github.com/hofstadter-io/hof/lib/mod"

	"github.com/hofstadter-io/hof/cmd/hof/ga"
)

var publishLong = `publish a module`

func PublishRun(module string) (err error) {

	if err = mod.Publish(module); err != nil {
		fmt.Println(err)
		os.Exit(1)
	}

	return err
}

var PublishCmd = &cobra.Command{
	Use: "publish <module>",

	Short: "publish a module",

	Long: publishLong,

	Run: func(cmd *cobra.Command, args []string) {

		ga.SendCommandPath(cmd.CommandPath())

		var err error

		// Argument Parsing

		if 0 >= len(args) {
			fmt.Println("missing required argument: 'module'")
			cmd.Usage()
			os.Exit(1)
		}

		var module string

		if 0 < len(args) {
			module = args[0]
		}

		err = PublishRun(module)
		if err != nil {
			fmt.Println(err)
			os.Exit(1)
		}
	},
}

func init() {
	extra := func(cmd *cobra.Command) bool {
		return false
	}

	ohelp := PublishCmd.HelpFunc()
	ousage := PublishCmd.UsageFunc()

	help := func(cmd *cobra.Command, args []string) {

		ga.SendCommandPath(cmd.CommandPath() + " help")

		if extra(cmd) {
			return
		}
		ohelp(cmd, args)
	}
	usage := func(cmd *cobra.Command) error {
		if extra(cmd) {
			return nil
		}
		return ousage(cmd)
	}

	thelp := func(cmd *cobra.Command, args []string) {
		help(cmd, args)
	}
	tusage := func(cmd *cobra.Command) error {
		return usage(cmd)
	}
	PublishCmd.SetHelpFunc(thelp)
	PublishCmd.SetUsageFunc(tusage)
}
