package v5

const VulnerabilityStoreFileName = "vulnerability.db"

type VulnerabilityStore interface {
	VulnerabilityStoreReader
	VulnerabilityStoreWriter
}

type VulnerabilityStoreReader interface {
	// GetVulnerabilityNamespaces retrieves unique list of vulnerability namespaces
	GetVulnerabilityNamespaces() ([]string, error)
	// GetVulnerability retrieves vulnerabilities by namespace and package
	GetVulnerability(namespace, packageName string) ([]Vulnerability, error)
	GetAllVulnerabilities() (*[]Vulnerability, error)
}

type VulnerabilityStoreWriter interface {
	// AddVulnerability inserts a new record of a vulnerability into the store
	AddVulnerability(vulnerabilities ...Vulnerability) error
}
