package v3

// Vulnerability represents the minimum data fields necessary to perform package-to-vulnerability matching. This can represent a CVE, 3rd party advisory, or any source that relates back to a CVE.
type Vulnerability struct {
	ID                     string                   // The identifier of the vulnerability or advisory
	PackageName            string                   // The name of the package that is vulnerable
	Namespace              string                   // The ecosystem where the package resides
	VersionConstraint      string                   // The version range which the given package is vulnerable
	VersionFormat          string                   // The format which all version fields should be interpreted as
	CPEs                   []string                 // The CPEs which are considered vulnerable
	RelatedVulnerabilities []VulnerabilityReference // Other Vulnerabilities that are related to this one (e.g. GHSA relate to CVEs, or how distro CVE relates to NVD record)
	Fix                    Fix                      // All information about fixed versions
	Advisories             []Advisory               // Any vendor advisories about fixes or other notifications about this vulnerability
}

type VulnerabilityReference struct {
	ID        string
	Namespace string
}
