This folder contains a rendered OpenAPI file for each group/version. The “real” OpenAPI is generated by the running server, but the files here are used to build static frontend clients.

## Generating RTK API Clients

The RTK API clients are generated from processed OpenAPI files using the `scripts/process-specs.ts` script. The source files are in `pkg/tests/apis/openapi_snapshots`, and the processed files are stored in the `data/openapi` directory. Spec processing happens as part of `yarn generate-apis` task, but can also be triggered separately (see below).

To generate or update the RTK API clients:

1. _If generating or updating an RTK client for the first time_, update `scripts/generate-rtk-apis.js` so `schemaFile` points to the processed spec files, for example:
   ```typescript
   '../public/app/features/dashboards/api/endpoints.gen.ts': {
     schemaFile: '../data/openapi/dashboard.grafana.app-v0alpha1.json',
   },
   ```

2. Generate or update the OpenAPI spec files by running:
   ```bash
   go test pkg/tests/apis/openapi_test.go
   ```
   _If generating an RTK client for a new API_, also add a new group/version of the API to the `groups` slice. If the API is behind a feature toggle, add the toggle to `EnableFeatureToggles` in `pkg/tests/apis/openapi_test.go`.


3. Run:
   ```bash
   yarn generate-apis
   ```
   This command generates (or updates) the spec files in the `data/openapi` directory and generates the RTK API clients.

If you want to process the OpenAPI files without generating the RTK API clients (for example, if you have a separate `generate-rtk-apis` file), run:
```bash
yarn process-specs
```
