---
aliases:
  - /docs/grafana/latest/setup-grafana/configure-grafana/feature-toggles/
description: Learn about feature toggles, which you can enable or disable.
title: Configure feature toggles
weight: 150
---

<!-- DO NOT EDIT THIS PAGE, it is machine generated by running the test in -->
<!-- https://github.com/grafana/grafana/blob/main/pkg/services/featuremgmt/toggles_gen_test.go#L19 -->

# Configure feature toggles

You use feature toggles, also known as feature flags, to enable or disable features in Grafana. You can turn on feature toggles to try out new functionality in development or test environments.

This page contains a list of available feature toggles. To learn how to turn on feature toggles, refer to our [Configure Grafana documentation]({{< relref "../_index.md#feature_toggles" >}}). Feature toggles are also available to Grafana Cloud Advanced customers. If you use Grafana Cloud Advanced, you can open a support ticket and specify the feature toggles and stack for which you want them enabled.

## Feature toggles

Some features are enabled by default. You can disable these feature by setting the feature flag to "false" in the configuration.

| Feature toggle name                              | Description                                                                                                                                                                                         | Enabled by default |
| ------------------------------------------------ | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------ |
| `disableEnvelopeEncryption`                      | Disable envelope encryption (emergency only)                                                                                                                                                        |                    |
| `featureHighlights`                              | Highlight Grafana Enterprise features                                                                                                                                                               |                    |
| `dataConnectionsConsole`                         | Enables a new top-level page called Connections. This page is an experiment that provides a better experience when you install and configure data sources and other plugins.                        | Yes                |
| `cloudWatchCrossAccountQuerying`                 | Enables cross-account querying in CloudWatch datasources                                                                                                                                            | Yes                |
| `redshiftAsyncQueryDataSupport`                  | Enable async query data support for Redshift                                                                                                                                                        | Yes                |
| `athenaAsyncQueryDataSupport`                    | Enable async query data support for Athena                                                                                                                                                          | Yes                |
| `newPanelChromeUI`                               | Show updated look and feel of grafana-ui PanelChrome: panel header, icons, and menu                                                                                                                 | Yes                |
| `nestedFolderPicker`                             | Enables the new folder picker to work with nested folders. Requires the folderPicker feature flag                                                                                                   | Yes                |
| `accessTokenExpirationCheck`                     | Enable OAuth access_token expiration check and token refresh using the refresh_token                                                                                                                |                    |
| `emptyDashboardPage`                             | Enable the redesigned user interface of a dashboard page that includes no panels                                                                                                                    | Yes                |
| `disablePrometheusExemplarSampling`              | Disable Prometheus exemplar sampling                                                                                                                                                                |                    |
| `logsContextDatasourceUi`                        | Allow datasource to provide custom UI for context view                                                                                                                                              | Yes                |
| `gcomOnlyExternalOrgRoleSync`                    | Prohibits a user from changing organization roles synced with Grafana Cloud auth provider                                                                                                           |                    |
| `prometheusMetricEncyclopedia`                   | Adds the metrics explorer component to the Prometheus query builder as an option in metric select                                                                                                   | Yes                |
| `prometheusResourceBrowserCache`                 | Displays browser caching options in Prometheus data source configuration                                                                                                                            | Yes                |
| `prometheusDataplane`                            | Changes responses to from Prometheus to be compliant with the dataplane specification. In particular it sets the numeric Field.Name from 'Value' to the value of the `__name__` label when present. | Yes                |
| `lokiMetricDataplane`                            | Changes metric responses from Loki to be compliant with the dataplane specification.                                                                                                                | Yes                |
| `dataplaneFrontendFallback`                      | Support dataplane contract field name change for transformations and field name matchers where the name is different                                                                                | Yes                |
| `alertingNotificationsPoliciesMatchingInstances` | Enables the preview of matching instances for notification policies                                                                                                                                 | Yes                |
| `useCachingService`                              | When turned on, the new query and resource caching implementation using a wire service inject will be used in place of the previous middleware implementation                                       |                    |
| `advancedDataSourcePicker`                       | Enable a new data source picker with contextual information, recently used order and advanced mode                                                                                                  | Yes                |
| `transformationsRedesign`                        | Enables the transformations redesign                                                                                                                                                                | Yes                |
| `azureMonitorDataplane`                          | Adds dataplane compliant frame metadata in the Azure Monitor datasource                                                                                                                             | Yes                |

## Preview feature toggles

| Feature toggle name                  | Description                                                                                                                                                                                  |
| ------------------------------------ | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `trimDefaults`                       | Use cue schema to remove values that will be applied automatically                                                                                                                           |
| `panelTitleSearch`                   | Search for dashboards using panel title                                                                                                                                                      |
| `publicDashboards`                   | Enables public access to dashboards                                                                                                                                                          |
| `migrationLocking`                   | Lock database during migrations                                                                                                                                                              |
| `correlations`                       | Correlations page                                                                                                                                                                            |
| `newDBLibrary`                       | Use jmoiron/sqlx rather than xorm for a few backend services                                                                                                                                 |
| `validateDashboardsOnSave`           | Validate dashboard JSON POSTed to api/dashboards/db                                                                                                                                          |
| `autoMigrateOldPanels`               | Migrate old angular panels to supported versions (graph, table-old, worldmap, etc)                                                                                                           |
| `disableAngular`                     | Dynamic flag to disable angular at runtime. The preferred method is to set `angular_support_enabled` to `false` in the [security] settings, which allows you to change the state at runtime. |
| `grpcServer`                         | Run the GRPC server                                                                                                                                                                          |
| `accessControlOnCall`                | Access control primitives for OnCall                                                                                                                                                         |
| `nestedFolders`                      | Enable folder nesting                                                                                                                                                                        |
| `alertingNoNormalState`              | Stop maintaining state of alerts that are not firing                                                                                                                                         |
| `influxdbBackendMigration`           | Query InfluxDB InfluxQL without the proxy                                                                                                                                                    |
| `renderAuthJWT`                      | Uses JWT-based auth for rendering instead of relying on remote cache                                                                                                                         |
| `refactorVariablesTimeRange`         | Refactor time range variables flow to reduce number of API calls made when query variables are chained                                                                                       |
| `enableElasticsearchBackendQuerying` | Enable the processing of queries and responses in the Elasticsearch data source through backend                                                                                              |
| `faroDatasourceSelector`             | Enable the data source selector within the Frontend Apps section of the Frontend Observability                                                                                               |
| `enableDatagridEditing`              | Enables the edit functionality in the datagrid panel                                                                                                                                         |
| `dataSourcePageHeader`               | Apply new pageHeader UI in data source edit page                                                                                                                                             |
| `sqlDatasourceDatabaseSelection`     | Enables previous SQL data source dataset dropdown behavior                                                                                                                                   |
| `splitScopes`                        | Support faster dashboard and folder search by splitting permission scopes into parts                                                                                                         |

## Experimental feature toggles

These features are early in their development lifecycle and so are not yet supported in Grafana Cloud.
Experimental features might be changed or removed without prior notice.

| Feature toggle name                         | Description                                                                                                                                                                              |
| ------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `live-service-web-worker`                   | This will use a webworker thread to processes events rather than the main thread                                                                                                         |
| `queryOverLive`                             | Use Grafana Live WebSocket to execute backend queries                                                                                                                                    |
| `lokiExperimentalStreaming`                 | Support new streaming approach for loki (prototype, needs special loki build)                                                                                                            |
| `storage`                                   | Configurable storage for dashboards, datasources, and resources                                                                                                                          |
| `datasourceQueryMultiStatus`                | Introduce HTTP 207 Multi Status for api/ds/query                                                                                                                                         |
| `traceToMetrics`                            | Enable trace to metrics links                                                                                                                                                            |
| `prometheusWideSeries`                      | Enable wide series responses in the Prometheus datasource                                                                                                                                |
| `canvasPanelNesting`                        | Allow elements nesting                                                                                                                                                                   |
| `scenes`                                    | Experimental framework to build interactive dashboards                                                                                                                                   |
| `disableSecretsCompatibility`               | Disable duplicated secret storage in legacy tables                                                                                                                                       |
| `logRequestsInstrumentedAsUnknown`          | Logs the path for requests that are instrumented as unknown                                                                                                                              |
| `showDashboardValidationWarnings`           | Show warnings when dashboards do not validate against the schema                                                                                                                         |
| `mysqlAnsiQuotes`                           | Use double quotes to escape keyword in a MySQL query                                                                                                                                     |
| `alertingBacktesting`                       | Rule backtesting API for alerting                                                                                                                                                        |
| `editPanelCSVDragAndDrop`                   | Enables drag and drop for CSV and Excel files                                                                                                                                            |
| `lokiQuerySplitting`                        | Split large interval queries into subqueries with smaller time intervals                                                                                                                 |
| `lokiQuerySplittingConfig`                  | Give users the option to configure split durations for Loki queries                                                                                                                      |
| `individualCookiePreferences`               | Support overriding cookie preferences per user                                                                                                                                           |
| `timeSeriesTable`                           | Enable time series table transformer & sparkline cell type                                                                                                                               |
| `clientTokenRotation`                       | Replaces the current in-request token rotation so that the client initiates the rotation                                                                                                 |
| `lokiLogsDataplane`                         | Changes logs responses from Loki to be compliant with the dataplane specification.                                                                                                       |
| `disableSSEDataplane`                       | Disables dataplane specific processing in server side expressions.                                                                                                                       |
| `alertStateHistoryLokiSecondary`            | Enable Grafana to write alert state history to an external Loki instance in addition to Grafana annotations.                                                                             |
| `alertStateHistoryLokiPrimary`              | Enable a remote Loki instance as the primary source for state history reads.                                                                                                             |
| `alertStateHistoryLokiOnly`                 | Disable Grafana alerts from emitting annotations when a remote Loki instance is available.                                                                                               |
| `unifiedRequestLog`                         | Writes error logs to the request logger                                                                                                                                                  |
| `pyroscopeFlameGraph`                       | Changes flame graph to pyroscope one                                                                                                                                                     |
| `extraThemes`                               | Enables extra themes                                                                                                                                                                     |
| `lokiPredefinedOperations`                  | Adds predefined query operations to Loki query editor                                                                                                                                    |
| `pluginsFrontendSandbox`                    | Enables the plugins frontend sandbox                                                                                                                                                     |
| `dashboardEmbed`                            | Allow embedding dashboard for external use in Code editors                                                                                                                               |
| `frontendSandboxMonitorOnly`                | Enables monitor only in the plugin frontend sandbox (if enabled)                                                                                                                         |
| `lokiFormatQuery`                           | Enables the ability to format Loki queries                                                                                                                                               |
| `cloudWatchLogsMonacoEditor`                | Enables the Monaco editor for CloudWatch Logs queries                                                                                                                                    |
| `exploreScrollableLogsContainer`            | Improves the scrolling behavior of logs in Explore                                                                                                                                       |
| `recordedQueriesMulti`                      | Enables writing multiple items from a single query within Recorded Queries                                                                                                               |
| `pluginsDynamicAngularDetectionPatterns`    | Enables fetching Angular detection patterns for plugins from GCOM and fallback to hardcoded ones                                                                                         |
| `alertingLokiRangeToInstant`                | Rewrites eligible loki range queries to instant queries                                                                                                                                  |
| `elasticToggleableFilters`                  | Enable support to toggle filters off from the query through the Logs Details component                                                                                                   |
| `vizAndWidgetSplit`                         | Split panels between vizualizations and widgets                                                                                                                                          |
| `prometheusIncrementalQueryInstrumentation` | Adds RudderStack events to incremental queries                                                                                                                                           |
| `logsExploreTableVisualisation`             | A table visualisation for logs in Explore                                                                                                                                                |
| `awsDatasourcesTempCredentials`             | Support temporary security credentials in AWS plugins for Grafana Cloud customers                                                                                                        |
| `toggleLabelsInLogsUI`                      | Enable toggleable filters in log details view                                                                                                                                            |
| `mlExpressions`                             | Enable support for Machine Learning in server-side expressions                                                                                                                           |
| `traceQLStreaming`                          | Enables response streaming of TraceQL queries of the Tempo data source                                                                                                                   |
| `grafanaAPIServer`                          | Enable Kubernetes API Server for Grafana resources                                                                                                                                       |
| `featureToggleAdminPage`                    | Enable admin page for managing feature toggles from the Grafana front-end                                                                                                                |
| `awsAsyncQueryCaching`                      | Enable caching for async queries for Redshift and Athena. Requires that the `useCachingService` feature toggle is enabled and the datasource has caching and async query support enabled |
| `permissionsFilterRemoveSubquery`           | Alternative permission filter implementation that does not use subqueries for fetching the dashboard folder                                                                              |
| `prometheusConfigOverhaulAuth`              | Update the Prometheus configuration page with the new auth component                                                                                                                     |

## Development feature toggles

The following toggles require explicitly setting Grafana's [app mode]({{< relref "../_index.md#app_mode" >}}) to 'development' before you can enable this feature toggle. These features tend to be experimental.

| Feature toggle name   | Description                                                    |
| --------------------- | -------------------------------------------------------------- |
| `entityStore`         | SQL-based entity store (requires storage flag also)            |
| `externalServiceAuth` | Starts an OAuth2 authentication provider for external services |
