---
description: An index of how-to topics for extending or enhancing Grafana plugins.
keywords:
  - grafana
  - plugins
  - plugin
  - development
  - extension
  - documentation
labels:
  products:
    - enterprise
    - oss
menuTitle: Extend a plugin
title: Extend a Grafana plugin
weight: 200
---

# Extend a Grafana plugin

This section contains how-to topics for extending or enhancing Grafana plugins:

- [Enable annotations]({{< relref "./add-support-for-annotations.md" >}})
- [Add anonymous usage reporting]({{< relref "./add-anonymous-usage-reporting.md" >}})
- [Add authentication for a data source plugin]({{< relref "./add-authentication-for-data-source-plugins.md" >}})
- [Add distributed tracing for backend plugins]({{< relref "./add-distributed-tracing-for-backend-plugins.md" >}})
- [Add features to Explore queries]({{< relref "./add-support-for-explore-queries.md" >}})
- [Add query editor help]({{< relref "./add-query-editor-help.md" >}})
- [Add support for variables]({{< relref "./add-support-for-variables.md" >}})
- [Build a custom panel option editor]({{< relref "./custom-panel-option-editors.md" >}})
- [Use extensions to add links to app plugins]({{< relref "./extend-the-grafana-ui-with-links.md" >}})
- [Work with cross-plugin links]({{< relref "./cross-plugin-linking.md" >}})

Additional resources:

- [Automate development with CI](https://grafana.github.io/plugin-tools/docs/ci)
- [Create nested plugins](https://grafana.github.io/plugin-tools/docs/nested-plugins)
- [Extend configurations](https://grafana.github.io/plugin-tools/docs/advanced-configuration)
