package action

import (
	"bytes"
	"context"
	"os"
	"testing"

	_ "github.com/gopasspw/gopass/internal/backend/crypto"
	_ "github.com/gopasspw/gopass/internal/backend/storage"
	"github.com/gopasspw/gopass/internal/out"
	"github.com/gopasspw/gopass/pkg/ctxutil"
	"github.com/gopasspw/gopass/tests/gptest"
	"github.com/stretchr/testify/require"
	"github.com/urfave/cli/v2"
)

func TestVersion(t *testing.T) {
	u := gptest.NewUnitTester(t)

	ctx := context.Background()
	ctx = ctxutil.WithAlwaysYes(ctx, true)
	ctx = ctxutil.WithInteractive(ctx, false)

	act, err := newMock(ctx, u.StoreDir(""))
	require.NoError(t, err)

	buf := &bytes.Buffer{}
	out.Stdout = buf
	stdout = buf
	defer func() {
		out.Stdout = os.Stdout
		stdout = os.Stdout
	}()

	cli.VersionPrinter = func(*cli.Context) {
		out.Printf(ctx, "gopass version 0.0.0-test")
	}

	t.Run("print fixed version", func(t *testing.T) {
		require.NoError(t, act.Version(gptest.CliCtx(ctx, t)))
	})
}
