// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package osconfig_test

import (
	"context"

	osconfig "cloud.google.com/go/osconfig/apiv1"
	"google.golang.org/api/iterator"
	osconfigpb "google.golang.org/genproto/googleapis/cloud/osconfig/v1"
)

func ExampleNewOsConfigZonalClient() {
	ctx := context.Background()
	c, err := osconfig.NewOsConfigZonalClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	// TODO: Use client.
	_ = c
}

func ExampleOsConfigZonalClient_GetInventory() {
	ctx := context.Background()
	c, err := osconfig.NewOsConfigZonalClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &osconfigpb.GetInventoryRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/osconfig/v1#GetInventoryRequest.
	}
	resp, err := c.GetInventory(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleOsConfigZonalClient_ListInventories() {
	ctx := context.Background()
	c, err := osconfig.NewOsConfigZonalClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &osconfigpb.ListInventoriesRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/osconfig/v1#ListInventoriesRequest.
	}
	it := c.ListInventories(ctx, req)
	for {
		resp, err := it.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			// TODO: Handle error.
		}
		// TODO: Use resp.
		_ = resp
	}
}

func ExampleOsConfigZonalClient_GetVulnerabilityReport() {
	ctx := context.Background()
	c, err := osconfig.NewOsConfigZonalClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &osconfigpb.GetVulnerabilityReportRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/osconfig/v1#GetVulnerabilityReportRequest.
	}
	resp, err := c.GetVulnerabilityReport(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleOsConfigZonalClient_ListVulnerabilityReports() {
	ctx := context.Background()
	c, err := osconfig.NewOsConfigZonalClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &osconfigpb.ListVulnerabilityReportsRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/osconfig/v1#ListVulnerabilityReportsRequest.
	}
	it := c.ListVulnerabilityReports(ctx, req)
	for {
		resp, err := it.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			// TODO: Handle error.
		}
		// TODO: Use resp.
		_ = resp
	}
}
