// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package networksecurity

import (
	"context"
	"fmt"
	"math"
	"net/url"
	"time"

	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	networksecuritypb "google.golang.org/genproto/googleapis/cloud/networksecurity/v1beta1"
	longrunningpb "google.golang.org/genproto/googleapis/longrunning"
	"google.golang.org/grpc"
	"google.golang.org/grpc/metadata"
	"google.golang.org/protobuf/proto"
)

var newClientHook clientHook

// CallOptions contains the retry settings for each method of Client.
type CallOptions struct {
	ListAuthorizationPolicies []gax.CallOption
	GetAuthorizationPolicy    []gax.CallOption
	CreateAuthorizationPolicy []gax.CallOption
	UpdateAuthorizationPolicy []gax.CallOption
	DeleteAuthorizationPolicy []gax.CallOption
	ListServerTlsPolicies     []gax.CallOption
	GetServerTlsPolicy        []gax.CallOption
	CreateServerTlsPolicy     []gax.CallOption
	UpdateServerTlsPolicy     []gax.CallOption
	DeleteServerTlsPolicy     []gax.CallOption
	ListClientTlsPolicies     []gax.CallOption
	GetClientTlsPolicy        []gax.CallOption
	CreateClientTlsPolicy     []gax.CallOption
	UpdateClientTlsPolicy     []gax.CallOption
	DeleteClientTlsPolicy     []gax.CallOption
}

func defaultGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("networksecurity.googleapis.com:443"),
		internaloption.WithDefaultMTLSEndpoint("networksecurity.mtls.googleapis.com:443"),
		internaloption.WithDefaultAudience("https://networksecurity.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDisableServiceConfig()),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultCallOptions() *CallOptions {
	return &CallOptions{
		ListAuthorizationPolicies: []gax.CallOption{},
		GetAuthorizationPolicy:    []gax.CallOption{},
		CreateAuthorizationPolicy: []gax.CallOption{},
		UpdateAuthorizationPolicy: []gax.CallOption{},
		DeleteAuthorizationPolicy: []gax.CallOption{},
		ListServerTlsPolicies:     []gax.CallOption{},
		GetServerTlsPolicy:        []gax.CallOption{},
		CreateServerTlsPolicy:     []gax.CallOption{},
		UpdateServerTlsPolicy:     []gax.CallOption{},
		DeleteServerTlsPolicy:     []gax.CallOption{},
		ListClientTlsPolicies:     []gax.CallOption{},
		GetClientTlsPolicy:        []gax.CallOption{},
		CreateClientTlsPolicy:     []gax.CallOption{},
		UpdateClientTlsPolicy:     []gax.CallOption{},
		DeleteClientTlsPolicy:     []gax.CallOption{},
	}
}

// internalClient is an interface that defines the methods availaible from Network Security API.
type internalClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListAuthorizationPolicies(context.Context, *networksecuritypb.ListAuthorizationPoliciesRequest, ...gax.CallOption) *AuthorizationPolicyIterator
	GetAuthorizationPolicy(context.Context, *networksecuritypb.GetAuthorizationPolicyRequest, ...gax.CallOption) (*networksecuritypb.AuthorizationPolicy, error)
	CreateAuthorizationPolicy(context.Context, *networksecuritypb.CreateAuthorizationPolicyRequest, ...gax.CallOption) (*CreateAuthorizationPolicyOperation, error)
	CreateAuthorizationPolicyOperation(name string) *CreateAuthorizationPolicyOperation
	UpdateAuthorizationPolicy(context.Context, *networksecuritypb.UpdateAuthorizationPolicyRequest, ...gax.CallOption) (*UpdateAuthorizationPolicyOperation, error)
	UpdateAuthorizationPolicyOperation(name string) *UpdateAuthorizationPolicyOperation
	DeleteAuthorizationPolicy(context.Context, *networksecuritypb.DeleteAuthorizationPolicyRequest, ...gax.CallOption) (*DeleteAuthorizationPolicyOperation, error)
	DeleteAuthorizationPolicyOperation(name string) *DeleteAuthorizationPolicyOperation
	ListServerTlsPolicies(context.Context, *networksecuritypb.ListServerTlsPoliciesRequest, ...gax.CallOption) *ServerTlsPolicyIterator
	GetServerTlsPolicy(context.Context, *networksecuritypb.GetServerTlsPolicyRequest, ...gax.CallOption) (*networksecuritypb.ServerTlsPolicy, error)
	CreateServerTlsPolicy(context.Context, *networksecuritypb.CreateServerTlsPolicyRequest, ...gax.CallOption) (*CreateServerTlsPolicyOperation, error)
	CreateServerTlsPolicyOperation(name string) *CreateServerTlsPolicyOperation
	UpdateServerTlsPolicy(context.Context, *networksecuritypb.UpdateServerTlsPolicyRequest, ...gax.CallOption) (*UpdateServerTlsPolicyOperation, error)
	UpdateServerTlsPolicyOperation(name string) *UpdateServerTlsPolicyOperation
	DeleteServerTlsPolicy(context.Context, *networksecuritypb.DeleteServerTlsPolicyRequest, ...gax.CallOption) (*DeleteServerTlsPolicyOperation, error)
	DeleteServerTlsPolicyOperation(name string) *DeleteServerTlsPolicyOperation
	ListClientTlsPolicies(context.Context, *networksecuritypb.ListClientTlsPoliciesRequest, ...gax.CallOption) *ClientTlsPolicyIterator
	GetClientTlsPolicy(context.Context, *networksecuritypb.GetClientTlsPolicyRequest, ...gax.CallOption) (*networksecuritypb.ClientTlsPolicy, error)
	CreateClientTlsPolicy(context.Context, *networksecuritypb.CreateClientTlsPolicyRequest, ...gax.CallOption) (*CreateClientTlsPolicyOperation, error)
	CreateClientTlsPolicyOperation(name string) *CreateClientTlsPolicyOperation
	UpdateClientTlsPolicy(context.Context, *networksecuritypb.UpdateClientTlsPolicyRequest, ...gax.CallOption) (*UpdateClientTlsPolicyOperation, error)
	UpdateClientTlsPolicyOperation(name string) *UpdateClientTlsPolicyOperation
	DeleteClientTlsPolicy(context.Context, *networksecuritypb.DeleteClientTlsPolicyRequest, ...gax.CallOption) (*DeleteClientTlsPolicyOperation, error)
	DeleteClientTlsPolicyOperation(name string) *DeleteClientTlsPolicyOperation
}

// Client is a client for interacting with Network Security API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type Client struct {
	// The internal transport-dependent client.
	internalClient internalClient

	// The call options for this service.
	CallOptions *CallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *Client) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *Client) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated.
func (c *Client) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListAuthorizationPolicies lists AuthorizationPolicies in a given project and location.
func (c *Client) ListAuthorizationPolicies(ctx context.Context, req *networksecuritypb.ListAuthorizationPoliciesRequest, opts ...gax.CallOption) *AuthorizationPolicyIterator {
	return c.internalClient.ListAuthorizationPolicies(ctx, req, opts...)
}

// GetAuthorizationPolicy gets details of a single AuthorizationPolicy.
func (c *Client) GetAuthorizationPolicy(ctx context.Context, req *networksecuritypb.GetAuthorizationPolicyRequest, opts ...gax.CallOption) (*networksecuritypb.AuthorizationPolicy, error) {
	return c.internalClient.GetAuthorizationPolicy(ctx, req, opts...)
}

// CreateAuthorizationPolicy creates a new AuthorizationPolicy in a given project and location.
func (c *Client) CreateAuthorizationPolicy(ctx context.Context, req *networksecuritypb.CreateAuthorizationPolicyRequest, opts ...gax.CallOption) (*CreateAuthorizationPolicyOperation, error) {
	return c.internalClient.CreateAuthorizationPolicy(ctx, req, opts...)
}

// CreateAuthorizationPolicyOperation returns a new CreateAuthorizationPolicyOperation from a given name.
// The name must be that of a previously created CreateAuthorizationPolicyOperation, possibly from a different process.
func (c *Client) CreateAuthorizationPolicyOperation(name string) *CreateAuthorizationPolicyOperation {
	return c.internalClient.CreateAuthorizationPolicyOperation(name)
}

// UpdateAuthorizationPolicy updates the parameters of a single AuthorizationPolicy.
func (c *Client) UpdateAuthorizationPolicy(ctx context.Context, req *networksecuritypb.UpdateAuthorizationPolicyRequest, opts ...gax.CallOption) (*UpdateAuthorizationPolicyOperation, error) {
	return c.internalClient.UpdateAuthorizationPolicy(ctx, req, opts...)
}

// UpdateAuthorizationPolicyOperation returns a new UpdateAuthorizationPolicyOperation from a given name.
// The name must be that of a previously created UpdateAuthorizationPolicyOperation, possibly from a different process.
func (c *Client) UpdateAuthorizationPolicyOperation(name string) *UpdateAuthorizationPolicyOperation {
	return c.internalClient.UpdateAuthorizationPolicyOperation(name)
}

// DeleteAuthorizationPolicy deletes a single AuthorizationPolicy.
func (c *Client) DeleteAuthorizationPolicy(ctx context.Context, req *networksecuritypb.DeleteAuthorizationPolicyRequest, opts ...gax.CallOption) (*DeleteAuthorizationPolicyOperation, error) {
	return c.internalClient.DeleteAuthorizationPolicy(ctx, req, opts...)
}

// DeleteAuthorizationPolicyOperation returns a new DeleteAuthorizationPolicyOperation from a given name.
// The name must be that of a previously created DeleteAuthorizationPolicyOperation, possibly from a different process.
func (c *Client) DeleteAuthorizationPolicyOperation(name string) *DeleteAuthorizationPolicyOperation {
	return c.internalClient.DeleteAuthorizationPolicyOperation(name)
}

// ListServerTlsPolicies lists ServerTlsPolicies in a given project and location.
func (c *Client) ListServerTlsPolicies(ctx context.Context, req *networksecuritypb.ListServerTlsPoliciesRequest, opts ...gax.CallOption) *ServerTlsPolicyIterator {
	return c.internalClient.ListServerTlsPolicies(ctx, req, opts...)
}

// GetServerTlsPolicy gets details of a single ServerTlsPolicy.
func (c *Client) GetServerTlsPolicy(ctx context.Context, req *networksecuritypb.GetServerTlsPolicyRequest, opts ...gax.CallOption) (*networksecuritypb.ServerTlsPolicy, error) {
	return c.internalClient.GetServerTlsPolicy(ctx, req, opts...)
}

// CreateServerTlsPolicy creates a new ServerTlsPolicy in a given project and location.
func (c *Client) CreateServerTlsPolicy(ctx context.Context, req *networksecuritypb.CreateServerTlsPolicyRequest, opts ...gax.CallOption) (*CreateServerTlsPolicyOperation, error) {
	return c.internalClient.CreateServerTlsPolicy(ctx, req, opts...)
}

// CreateServerTlsPolicyOperation returns a new CreateServerTlsPolicyOperation from a given name.
// The name must be that of a previously created CreateServerTlsPolicyOperation, possibly from a different process.
func (c *Client) CreateServerTlsPolicyOperation(name string) *CreateServerTlsPolicyOperation {
	return c.internalClient.CreateServerTlsPolicyOperation(name)
}

// UpdateServerTlsPolicy updates the parameters of a single ServerTlsPolicy.
func (c *Client) UpdateServerTlsPolicy(ctx context.Context, req *networksecuritypb.UpdateServerTlsPolicyRequest, opts ...gax.CallOption) (*UpdateServerTlsPolicyOperation, error) {
	return c.internalClient.UpdateServerTlsPolicy(ctx, req, opts...)
}

// UpdateServerTlsPolicyOperation returns a new UpdateServerTlsPolicyOperation from a given name.
// The name must be that of a previously created UpdateServerTlsPolicyOperation, possibly from a different process.
func (c *Client) UpdateServerTlsPolicyOperation(name string) *UpdateServerTlsPolicyOperation {
	return c.internalClient.UpdateServerTlsPolicyOperation(name)
}

// DeleteServerTlsPolicy deletes a single ServerTlsPolicy.
func (c *Client) DeleteServerTlsPolicy(ctx context.Context, req *networksecuritypb.DeleteServerTlsPolicyRequest, opts ...gax.CallOption) (*DeleteServerTlsPolicyOperation, error) {
	return c.internalClient.DeleteServerTlsPolicy(ctx, req, opts...)
}

// DeleteServerTlsPolicyOperation returns a new DeleteServerTlsPolicyOperation from a given name.
// The name must be that of a previously created DeleteServerTlsPolicyOperation, possibly from a different process.
func (c *Client) DeleteServerTlsPolicyOperation(name string) *DeleteServerTlsPolicyOperation {
	return c.internalClient.DeleteServerTlsPolicyOperation(name)
}

// ListClientTlsPolicies lists ClientTlsPolicies in a given project and location.
func (c *Client) ListClientTlsPolicies(ctx context.Context, req *networksecuritypb.ListClientTlsPoliciesRequest, opts ...gax.CallOption) *ClientTlsPolicyIterator {
	return c.internalClient.ListClientTlsPolicies(ctx, req, opts...)
}

// GetClientTlsPolicy gets details of a single ClientTlsPolicy.
func (c *Client) GetClientTlsPolicy(ctx context.Context, req *networksecuritypb.GetClientTlsPolicyRequest, opts ...gax.CallOption) (*networksecuritypb.ClientTlsPolicy, error) {
	return c.internalClient.GetClientTlsPolicy(ctx, req, opts...)
}

// CreateClientTlsPolicy creates a new ClientTlsPolicy in a given project and location.
func (c *Client) CreateClientTlsPolicy(ctx context.Context, req *networksecuritypb.CreateClientTlsPolicyRequest, opts ...gax.CallOption) (*CreateClientTlsPolicyOperation, error) {
	return c.internalClient.CreateClientTlsPolicy(ctx, req, opts...)
}

// CreateClientTlsPolicyOperation returns a new CreateClientTlsPolicyOperation from a given name.
// The name must be that of a previously created CreateClientTlsPolicyOperation, possibly from a different process.
func (c *Client) CreateClientTlsPolicyOperation(name string) *CreateClientTlsPolicyOperation {
	return c.internalClient.CreateClientTlsPolicyOperation(name)
}

// UpdateClientTlsPolicy updates the parameters of a single ClientTlsPolicy.
func (c *Client) UpdateClientTlsPolicy(ctx context.Context, req *networksecuritypb.UpdateClientTlsPolicyRequest, opts ...gax.CallOption) (*UpdateClientTlsPolicyOperation, error) {
	return c.internalClient.UpdateClientTlsPolicy(ctx, req, opts...)
}

// UpdateClientTlsPolicyOperation returns a new UpdateClientTlsPolicyOperation from a given name.
// The name must be that of a previously created UpdateClientTlsPolicyOperation, possibly from a different process.
func (c *Client) UpdateClientTlsPolicyOperation(name string) *UpdateClientTlsPolicyOperation {
	return c.internalClient.UpdateClientTlsPolicyOperation(name)
}

// DeleteClientTlsPolicy deletes a single ClientTlsPolicy.
func (c *Client) DeleteClientTlsPolicy(ctx context.Context, req *networksecuritypb.DeleteClientTlsPolicyRequest, opts ...gax.CallOption) (*DeleteClientTlsPolicyOperation, error) {
	return c.internalClient.DeleteClientTlsPolicy(ctx, req, opts...)
}

// DeleteClientTlsPolicyOperation returns a new DeleteClientTlsPolicyOperation from a given name.
// The name must be that of a previously created DeleteClientTlsPolicyOperation, possibly from a different process.
func (c *Client) DeleteClientTlsPolicyOperation(name string) *DeleteClientTlsPolicyOperation {
	return c.internalClient.DeleteClientTlsPolicyOperation(name)
}

// gRPCClient is a client for interacting with Network Security API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type gRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// flag to opt out of default deadlines via GOOGLE_API_GO_EXPERIMENTAL_DISABLE_DEFAULT_DEADLINE
	disableDeadlines bool

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions

	// The gRPC API client.
	client networksecuritypb.NetworkSecurityClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogMetadata metadata.MD
}

// NewClient creates a new network security client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
func NewClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := defaultGRPCClientOptions()
	if newClientHook != nil {
		hookOpts, err := newClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	disableDeadlines, err := checkDisableDeadlines()
	if err != nil {
		return nil, err
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := Client{CallOptions: defaultCallOptions()}

	c := &gRPCClient{
		connPool:         connPool,
		disableDeadlines: disableDeadlines,
		client:           networksecuritypb.NewNetworkSecurityClient(connPool),
		CallOptions:      &client.CallOptions,
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated.
func (c *gRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *gRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", versionGo()}, keyval...)
	kv = append(kv, "gapic", versionClient, "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogMetadata = metadata.Pairs("x-goog-api-client", gax.XGoogHeader(kv...))
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *gRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *gRPCClient) ListAuthorizationPolicies(ctx context.Context, req *networksecuritypb.ListAuthorizationPoliciesRequest, opts ...gax.CallOption) *AuthorizationPolicyIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListAuthorizationPolicies[0:len((*c.CallOptions).ListAuthorizationPolicies):len((*c.CallOptions).ListAuthorizationPolicies)], opts...)
	it := &AuthorizationPolicyIterator{}
	req = proto.Clone(req).(*networksecuritypb.ListAuthorizationPoliciesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networksecuritypb.AuthorizationPolicy, string, error) {
		resp := &networksecuritypb.ListAuthorizationPoliciesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListAuthorizationPolicies(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetAuthorizationPolicies(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetAuthorizationPolicy(ctx context.Context, req *networksecuritypb.GetAuthorizationPolicyRequest, opts ...gax.CallOption) (*networksecuritypb.AuthorizationPolicy, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetAuthorizationPolicy[0:len((*c.CallOptions).GetAuthorizationPolicy):len((*c.CallOptions).GetAuthorizationPolicy)], opts...)
	var resp *networksecuritypb.AuthorizationPolicy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetAuthorizationPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateAuthorizationPolicy(ctx context.Context, req *networksecuritypb.CreateAuthorizationPolicyRequest, opts ...gax.CallOption) (*CreateAuthorizationPolicyOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateAuthorizationPolicy[0:len((*c.CallOptions).CreateAuthorizationPolicy):len((*c.CallOptions).CreateAuthorizationPolicy)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateAuthorizationPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateAuthorizationPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateAuthorizationPolicy(ctx context.Context, req *networksecuritypb.UpdateAuthorizationPolicyRequest, opts ...gax.CallOption) (*UpdateAuthorizationPolicyOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "authorization_policy.name", url.QueryEscape(req.GetAuthorizationPolicy().GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateAuthorizationPolicy[0:len((*c.CallOptions).UpdateAuthorizationPolicy):len((*c.CallOptions).UpdateAuthorizationPolicy)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateAuthorizationPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateAuthorizationPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteAuthorizationPolicy(ctx context.Context, req *networksecuritypb.DeleteAuthorizationPolicyRequest, opts ...gax.CallOption) (*DeleteAuthorizationPolicyOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteAuthorizationPolicy[0:len((*c.CallOptions).DeleteAuthorizationPolicy):len((*c.CallOptions).DeleteAuthorizationPolicy)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.DeleteAuthorizationPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteAuthorizationPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListServerTlsPolicies(ctx context.Context, req *networksecuritypb.ListServerTlsPoliciesRequest, opts ...gax.CallOption) *ServerTlsPolicyIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListServerTlsPolicies[0:len((*c.CallOptions).ListServerTlsPolicies):len((*c.CallOptions).ListServerTlsPolicies)], opts...)
	it := &ServerTlsPolicyIterator{}
	req = proto.Clone(req).(*networksecuritypb.ListServerTlsPoliciesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networksecuritypb.ServerTlsPolicy, string, error) {
		resp := &networksecuritypb.ListServerTlsPoliciesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListServerTlsPolicies(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetServerTlsPolicies(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetServerTlsPolicy(ctx context.Context, req *networksecuritypb.GetServerTlsPolicyRequest, opts ...gax.CallOption) (*networksecuritypb.ServerTlsPolicy, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetServerTlsPolicy[0:len((*c.CallOptions).GetServerTlsPolicy):len((*c.CallOptions).GetServerTlsPolicy)], opts...)
	var resp *networksecuritypb.ServerTlsPolicy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetServerTlsPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateServerTlsPolicy(ctx context.Context, req *networksecuritypb.CreateServerTlsPolicyRequest, opts ...gax.CallOption) (*CreateServerTlsPolicyOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateServerTlsPolicy[0:len((*c.CallOptions).CreateServerTlsPolicy):len((*c.CallOptions).CreateServerTlsPolicy)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateServerTlsPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateServerTlsPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateServerTlsPolicy(ctx context.Context, req *networksecuritypb.UpdateServerTlsPolicyRequest, opts ...gax.CallOption) (*UpdateServerTlsPolicyOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "server_tls_policy.name", url.QueryEscape(req.GetServerTlsPolicy().GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateServerTlsPolicy[0:len((*c.CallOptions).UpdateServerTlsPolicy):len((*c.CallOptions).UpdateServerTlsPolicy)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateServerTlsPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateServerTlsPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteServerTlsPolicy(ctx context.Context, req *networksecuritypb.DeleteServerTlsPolicyRequest, opts ...gax.CallOption) (*DeleteServerTlsPolicyOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteServerTlsPolicy[0:len((*c.CallOptions).DeleteServerTlsPolicy):len((*c.CallOptions).DeleteServerTlsPolicy)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.DeleteServerTlsPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteServerTlsPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListClientTlsPolicies(ctx context.Context, req *networksecuritypb.ListClientTlsPoliciesRequest, opts ...gax.CallOption) *ClientTlsPolicyIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListClientTlsPolicies[0:len((*c.CallOptions).ListClientTlsPolicies):len((*c.CallOptions).ListClientTlsPolicies)], opts...)
	it := &ClientTlsPolicyIterator{}
	req = proto.Clone(req).(*networksecuritypb.ListClientTlsPoliciesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networksecuritypb.ClientTlsPolicy, string, error) {
		resp := &networksecuritypb.ListClientTlsPoliciesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListClientTlsPolicies(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetClientTlsPolicies(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetClientTlsPolicy(ctx context.Context, req *networksecuritypb.GetClientTlsPolicyRequest, opts ...gax.CallOption) (*networksecuritypb.ClientTlsPolicy, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetClientTlsPolicy[0:len((*c.CallOptions).GetClientTlsPolicy):len((*c.CallOptions).GetClientTlsPolicy)], opts...)
	var resp *networksecuritypb.ClientTlsPolicy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetClientTlsPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateClientTlsPolicy(ctx context.Context, req *networksecuritypb.CreateClientTlsPolicyRequest, opts ...gax.CallOption) (*CreateClientTlsPolicyOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateClientTlsPolicy[0:len((*c.CallOptions).CreateClientTlsPolicy):len((*c.CallOptions).CreateClientTlsPolicy)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateClientTlsPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateClientTlsPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateClientTlsPolicy(ctx context.Context, req *networksecuritypb.UpdateClientTlsPolicyRequest, opts ...gax.CallOption) (*UpdateClientTlsPolicyOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "client_tls_policy.name", url.QueryEscape(req.GetClientTlsPolicy().GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateClientTlsPolicy[0:len((*c.CallOptions).UpdateClientTlsPolicy):len((*c.CallOptions).UpdateClientTlsPolicy)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateClientTlsPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateClientTlsPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteClientTlsPolicy(ctx context.Context, req *networksecuritypb.DeleteClientTlsPolicyRequest, opts ...gax.CallOption) (*DeleteClientTlsPolicyOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteClientTlsPolicy[0:len((*c.CallOptions).DeleteClientTlsPolicy):len((*c.CallOptions).DeleteClientTlsPolicy)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.DeleteClientTlsPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteClientTlsPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

// CreateAuthorizationPolicyOperation manages a long-running operation from CreateAuthorizationPolicy.
type CreateAuthorizationPolicyOperation struct {
	lro *longrunning.Operation
}

// CreateAuthorizationPolicyOperation returns a new CreateAuthorizationPolicyOperation from a given name.
// The name must be that of a previously created CreateAuthorizationPolicyOperation, possibly from a different process.
func (c *gRPCClient) CreateAuthorizationPolicyOperation(name string) *CreateAuthorizationPolicyOperation {
	return &CreateAuthorizationPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateAuthorizationPolicyOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*networksecuritypb.AuthorizationPolicy, error) {
	var resp networksecuritypb.AuthorizationPolicy
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateAuthorizationPolicyOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*networksecuritypb.AuthorizationPolicy, error) {
	var resp networksecuritypb.AuthorizationPolicy
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateAuthorizationPolicyOperation) Metadata() (*networksecuritypb.OperationMetadata, error) {
	var meta networksecuritypb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateAuthorizationPolicyOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateAuthorizationPolicyOperation) Name() string {
	return op.lro.Name()
}

// CreateClientTlsPolicyOperation manages a long-running operation from CreateClientTlsPolicy.
type CreateClientTlsPolicyOperation struct {
	lro *longrunning.Operation
}

// CreateClientTlsPolicyOperation returns a new CreateClientTlsPolicyOperation from a given name.
// The name must be that of a previously created CreateClientTlsPolicyOperation, possibly from a different process.
func (c *gRPCClient) CreateClientTlsPolicyOperation(name string) *CreateClientTlsPolicyOperation {
	return &CreateClientTlsPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateClientTlsPolicyOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*networksecuritypb.ClientTlsPolicy, error) {
	var resp networksecuritypb.ClientTlsPolicy
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateClientTlsPolicyOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*networksecuritypb.ClientTlsPolicy, error) {
	var resp networksecuritypb.ClientTlsPolicy
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateClientTlsPolicyOperation) Metadata() (*networksecuritypb.OperationMetadata, error) {
	var meta networksecuritypb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateClientTlsPolicyOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateClientTlsPolicyOperation) Name() string {
	return op.lro.Name()
}

// CreateServerTlsPolicyOperation manages a long-running operation from CreateServerTlsPolicy.
type CreateServerTlsPolicyOperation struct {
	lro *longrunning.Operation
}

// CreateServerTlsPolicyOperation returns a new CreateServerTlsPolicyOperation from a given name.
// The name must be that of a previously created CreateServerTlsPolicyOperation, possibly from a different process.
func (c *gRPCClient) CreateServerTlsPolicyOperation(name string) *CreateServerTlsPolicyOperation {
	return &CreateServerTlsPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateServerTlsPolicyOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*networksecuritypb.ServerTlsPolicy, error) {
	var resp networksecuritypb.ServerTlsPolicy
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateServerTlsPolicyOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*networksecuritypb.ServerTlsPolicy, error) {
	var resp networksecuritypb.ServerTlsPolicy
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateServerTlsPolicyOperation) Metadata() (*networksecuritypb.OperationMetadata, error) {
	var meta networksecuritypb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateServerTlsPolicyOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateServerTlsPolicyOperation) Name() string {
	return op.lro.Name()
}

// DeleteAuthorizationPolicyOperation manages a long-running operation from DeleteAuthorizationPolicy.
type DeleteAuthorizationPolicyOperation struct {
	lro *longrunning.Operation
}

// DeleteAuthorizationPolicyOperation returns a new DeleteAuthorizationPolicyOperation from a given name.
// The name must be that of a previously created DeleteAuthorizationPolicyOperation, possibly from a different process.
func (c *gRPCClient) DeleteAuthorizationPolicyOperation(name string) *DeleteAuthorizationPolicyOperation {
	return &DeleteAuthorizationPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteAuthorizationPolicyOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteAuthorizationPolicyOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteAuthorizationPolicyOperation) Metadata() (*networksecuritypb.OperationMetadata, error) {
	var meta networksecuritypb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteAuthorizationPolicyOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteAuthorizationPolicyOperation) Name() string {
	return op.lro.Name()
}

// DeleteClientTlsPolicyOperation manages a long-running operation from DeleteClientTlsPolicy.
type DeleteClientTlsPolicyOperation struct {
	lro *longrunning.Operation
}

// DeleteClientTlsPolicyOperation returns a new DeleteClientTlsPolicyOperation from a given name.
// The name must be that of a previously created DeleteClientTlsPolicyOperation, possibly from a different process.
func (c *gRPCClient) DeleteClientTlsPolicyOperation(name string) *DeleteClientTlsPolicyOperation {
	return &DeleteClientTlsPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteClientTlsPolicyOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteClientTlsPolicyOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteClientTlsPolicyOperation) Metadata() (*networksecuritypb.OperationMetadata, error) {
	var meta networksecuritypb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteClientTlsPolicyOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteClientTlsPolicyOperation) Name() string {
	return op.lro.Name()
}

// DeleteServerTlsPolicyOperation manages a long-running operation from DeleteServerTlsPolicy.
type DeleteServerTlsPolicyOperation struct {
	lro *longrunning.Operation
}

// DeleteServerTlsPolicyOperation returns a new DeleteServerTlsPolicyOperation from a given name.
// The name must be that of a previously created DeleteServerTlsPolicyOperation, possibly from a different process.
func (c *gRPCClient) DeleteServerTlsPolicyOperation(name string) *DeleteServerTlsPolicyOperation {
	return &DeleteServerTlsPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteServerTlsPolicyOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteServerTlsPolicyOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteServerTlsPolicyOperation) Metadata() (*networksecuritypb.OperationMetadata, error) {
	var meta networksecuritypb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteServerTlsPolicyOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteServerTlsPolicyOperation) Name() string {
	return op.lro.Name()
}

// UpdateAuthorizationPolicyOperation manages a long-running operation from UpdateAuthorizationPolicy.
type UpdateAuthorizationPolicyOperation struct {
	lro *longrunning.Operation
}

// UpdateAuthorizationPolicyOperation returns a new UpdateAuthorizationPolicyOperation from a given name.
// The name must be that of a previously created UpdateAuthorizationPolicyOperation, possibly from a different process.
func (c *gRPCClient) UpdateAuthorizationPolicyOperation(name string) *UpdateAuthorizationPolicyOperation {
	return &UpdateAuthorizationPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *UpdateAuthorizationPolicyOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*networksecuritypb.AuthorizationPolicy, error) {
	var resp networksecuritypb.AuthorizationPolicy
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *UpdateAuthorizationPolicyOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*networksecuritypb.AuthorizationPolicy, error) {
	var resp networksecuritypb.AuthorizationPolicy
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *UpdateAuthorizationPolicyOperation) Metadata() (*networksecuritypb.OperationMetadata, error) {
	var meta networksecuritypb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *UpdateAuthorizationPolicyOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *UpdateAuthorizationPolicyOperation) Name() string {
	return op.lro.Name()
}

// UpdateClientTlsPolicyOperation manages a long-running operation from UpdateClientTlsPolicy.
type UpdateClientTlsPolicyOperation struct {
	lro *longrunning.Operation
}

// UpdateClientTlsPolicyOperation returns a new UpdateClientTlsPolicyOperation from a given name.
// The name must be that of a previously created UpdateClientTlsPolicyOperation, possibly from a different process.
func (c *gRPCClient) UpdateClientTlsPolicyOperation(name string) *UpdateClientTlsPolicyOperation {
	return &UpdateClientTlsPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *UpdateClientTlsPolicyOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*networksecuritypb.ClientTlsPolicy, error) {
	var resp networksecuritypb.ClientTlsPolicy
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *UpdateClientTlsPolicyOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*networksecuritypb.ClientTlsPolicy, error) {
	var resp networksecuritypb.ClientTlsPolicy
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *UpdateClientTlsPolicyOperation) Metadata() (*networksecuritypb.OperationMetadata, error) {
	var meta networksecuritypb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *UpdateClientTlsPolicyOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *UpdateClientTlsPolicyOperation) Name() string {
	return op.lro.Name()
}

// UpdateServerTlsPolicyOperation manages a long-running operation from UpdateServerTlsPolicy.
type UpdateServerTlsPolicyOperation struct {
	lro *longrunning.Operation
}

// UpdateServerTlsPolicyOperation returns a new UpdateServerTlsPolicyOperation from a given name.
// The name must be that of a previously created UpdateServerTlsPolicyOperation, possibly from a different process.
func (c *gRPCClient) UpdateServerTlsPolicyOperation(name string) *UpdateServerTlsPolicyOperation {
	return &UpdateServerTlsPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *UpdateServerTlsPolicyOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*networksecuritypb.ServerTlsPolicy, error) {
	var resp networksecuritypb.ServerTlsPolicy
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *UpdateServerTlsPolicyOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*networksecuritypb.ServerTlsPolicy, error) {
	var resp networksecuritypb.ServerTlsPolicy
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *UpdateServerTlsPolicyOperation) Metadata() (*networksecuritypb.OperationMetadata, error) {
	var meta networksecuritypb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *UpdateServerTlsPolicyOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *UpdateServerTlsPolicyOperation) Name() string {
	return op.lro.Name()
}

// AuthorizationPolicyIterator manages a stream of *networksecuritypb.AuthorizationPolicy.
type AuthorizationPolicyIterator struct {
	items    []*networksecuritypb.AuthorizationPolicy
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*networksecuritypb.AuthorizationPolicy, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *AuthorizationPolicyIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *AuthorizationPolicyIterator) Next() (*networksecuritypb.AuthorizationPolicy, error) {
	var item *networksecuritypb.AuthorizationPolicy
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *AuthorizationPolicyIterator) bufLen() int {
	return len(it.items)
}

func (it *AuthorizationPolicyIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// ClientTlsPolicyIterator manages a stream of *networksecuritypb.ClientTlsPolicy.
type ClientTlsPolicyIterator struct {
	items    []*networksecuritypb.ClientTlsPolicy
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*networksecuritypb.ClientTlsPolicy, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *ClientTlsPolicyIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *ClientTlsPolicyIterator) Next() (*networksecuritypb.ClientTlsPolicy, error) {
	var item *networksecuritypb.ClientTlsPolicy
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *ClientTlsPolicyIterator) bufLen() int {
	return len(it.items)
}

func (it *ClientTlsPolicyIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// ServerTlsPolicyIterator manages a stream of *networksecuritypb.ServerTlsPolicy.
type ServerTlsPolicyIterator struct {
	items    []*networksecuritypb.ServerTlsPolicy
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*networksecuritypb.ServerTlsPolicy, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *ServerTlsPolicyIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *ServerTlsPolicyIterator) Next() (*networksecuritypb.ServerTlsPolicy, error) {
	var item *networksecuritypb.ServerTlsPolicy
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *ServerTlsPolicyIterator) bufLen() int {
	return len(it.items)
}

func (it *ServerTlsPolicyIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}
