// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/shopping/merchant/accounts/v1beta/autofeedsettings.proto

package accountspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Collection of information related to the
// [autofeed](https://support.google.com/merchants/answer/7538732) settings.
type AutofeedSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of the autofeed settings.
	// Format: `accounts/{account}/autofeedSettings`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Enables or disables product crawling through the autofeed for the
	// given account. Autofeed accounts must meet [certain
	// conditions](https://support.google.com/merchants/answer/7538732#Configure_automated_feeds_Standard_Experience),
	// which can be checked through the `eligible` field.
	// The account must **not** be a marketplace.
	// When the autofeed is enabled for the first time, the products usually
	// appear instantly. When re-enabling, it might take up to 24 hours for
	// products to appear.
	EnableProducts bool `protobuf:"varint,2,opt,name=enable_products,json=enableProducts,proto3" json:"enable_products,omitempty"`
	// Output only. Determines whether merchant is eligible for being enrolled
	// into an autofeed.
	Eligible bool `protobuf:"varint,3,opt,name=eligible,proto3" json:"eligible,omitempty"`
}

func (x *AutofeedSettings) Reset() {
	*x = AutofeedSettings{}
	mi := &file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutofeedSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutofeedSettings) ProtoMessage() {}

func (x *AutofeedSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutofeedSettings.ProtoReflect.Descriptor instead.
func (*AutofeedSettings) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_rawDescGZIP(), []int{0}
}

func (x *AutofeedSettings) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AutofeedSettings) GetEnableProducts() bool {
	if x != nil {
		return x.EnableProducts
	}
	return false
}

func (x *AutofeedSettings) GetEligible() bool {
	if x != nil {
		return x.Eligible
	}
	return false
}

// Request message for the `GetAutofeedSettings` method.
type GetAutofeedSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the autofeed settings.
	// Format: `accounts/{account}/autofeedSettings`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAutofeedSettingsRequest) Reset() {
	*x = GetAutofeedSettingsRequest{}
	mi := &file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetAutofeedSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAutofeedSettingsRequest) ProtoMessage() {}

func (x *GetAutofeedSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAutofeedSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetAutofeedSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_rawDescGZIP(), []int{1}
}

func (x *GetAutofeedSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the `UpdateAutofeedSettings` method.
type UpdateAutofeedSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new version of the autofeed setting.
	AutofeedSettings *AutofeedSettings `protobuf:"bytes,1,opt,name=autofeed_settings,json=autofeedSettings,proto3" json:"autofeed_settings,omitempty"`
	// Required. List of fields being updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAutofeedSettingsRequest) Reset() {
	*x = UpdateAutofeedSettingsRequest{}
	mi := &file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateAutofeedSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAutofeedSettingsRequest) ProtoMessage() {}

func (x *UpdateAutofeedSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAutofeedSettingsRequest.ProtoReflect.Descriptor instead.
func (*UpdateAutofeedSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_rawDescGZIP(), []int{2}
}

func (x *UpdateAutofeedSettingsRequest) GetAutofeedSettings() *AutofeedSettings {
	if x != nil {
		return x.AutofeedSettings
	}
	return nil
}

func (x *UpdateAutofeedSettingsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

var File_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_rawDesc = []byte{
	0x0a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x66,
	0x65, 0x65, 0x64, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xf5, 0x01, 0x0a, 0x10, 0x41, 0x75, 0x74, 0x6f, 0x66, 0x65, 0x65, 0x64, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2c,
	0x0a, 0x0f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x12, 0x1f, 0x0a, 0x08,
	0x65, 0x6c, 0x69, 0x67, 0x69, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x08, 0x65, 0x6c, 0x69, 0x67, 0x69, 0x62, 0x6c, 0x65, 0x3a, 0x79, 0xea,
	0x41, 0x76, 0x0a, 0x2b, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x75, 0x74, 0x6f, 0x66, 0x65, 0x65, 0x64, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0x23, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x7d, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x66, 0x65, 0x65, 0x64, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x2a, 0x10, 0x61, 0x75, 0x74, 0x6f, 0x66, 0x65, 0x65, 0x64, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x32, 0x10, 0x61, 0x75, 0x74, 0x6f, 0x66, 0x65, 0x65, 0x64,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x65, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x41,
	0x75, 0x74, 0x6f, 0x66, 0x65, 0x65, 0x64, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x74, 0x6f, 0x66, 0x65, 0x65,
	0x64, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xcf, 0x01, 0x0a, 0x1d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x66, 0x65,
	0x65, 0x64, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x6c, 0x0a, 0x11, 0x61, 0x75, 0x74, 0x6f, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x66, 0x65, 0x65, 0x64,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x61,
	0x75, 0x74, 0x6f, 0x66, 0x65, 0x65, 0x64, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x6b, 0x32, 0xe3, 0x04, 0x0a, 0x17, 0x41, 0x75, 0x74, 0x6f, 0x66, 0x65, 0x65, 0x64, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xdb, 0x01,
	0x0a, 0x13, 0x47, 0x65, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x66, 0x65, 0x65, 0x64, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x47, 0x65, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x66, 0x65, 0x65, 0x64, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x66, 0x65, 0x65, 0x64, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x42, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x12, 0x33, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x66, 0x65,
	0x65, 0x64, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x12, 0xa0, 0x02, 0x0a, 0x16,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x66, 0x65, 0x65, 0x64, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x66, 0x65, 0x65, 0x64,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x66,
	0x65, 0x65, 0x64, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x80, 0x01, 0xda, 0x41,
	0x1d, 0x61, 0x75, 0x74, 0x6f, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x5a, 0x3a, 0x11, 0x61, 0x75, 0x74, 0x6f, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x32, 0x45, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x61, 0x75, 0x74, 0x6f, 0x66,
	0x65, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x75, 0x74,
	0x6f, 0x66, 0x65, 0x65, 0x64, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x1a, 0x47,
	0xca, 0x41, 0x1a, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x27,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x97, 0x01, 0x0a, 0x2c, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x15, 0x41, 0x75, 0x74, 0x6f, 0x66, 0x65,
	0x65, 0x64, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x4e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x70, 0x62, 0x3b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x70,
	0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_rawDescData = file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_rawDesc
)

func file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_rawDescData)
	})
	return file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_rawDescData
}

var file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_goTypes = []any{
	(*AutofeedSettings)(nil),              // 0: google.shopping.merchant.accounts.v1beta.AutofeedSettings
	(*GetAutofeedSettingsRequest)(nil),    // 1: google.shopping.merchant.accounts.v1beta.GetAutofeedSettingsRequest
	(*UpdateAutofeedSettingsRequest)(nil), // 2: google.shopping.merchant.accounts.v1beta.UpdateAutofeedSettingsRequest
	(*fieldmaskpb.FieldMask)(nil),         // 3: google.protobuf.FieldMask
}
var file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_depIdxs = []int32{
	0, // 0: google.shopping.merchant.accounts.v1beta.UpdateAutofeedSettingsRequest.autofeed_settings:type_name -> google.shopping.merchant.accounts.v1beta.AutofeedSettings
	3, // 1: google.shopping.merchant.accounts.v1beta.UpdateAutofeedSettingsRequest.update_mask:type_name -> google.protobuf.FieldMask
	1, // 2: google.shopping.merchant.accounts.v1beta.AutofeedSettingsService.GetAutofeedSettings:input_type -> google.shopping.merchant.accounts.v1beta.GetAutofeedSettingsRequest
	2, // 3: google.shopping.merchant.accounts.v1beta.AutofeedSettingsService.UpdateAutofeedSettings:input_type -> google.shopping.merchant.accounts.v1beta.UpdateAutofeedSettingsRequest
	0, // 4: google.shopping.merchant.accounts.v1beta.AutofeedSettingsService.GetAutofeedSettings:output_type -> google.shopping.merchant.accounts.v1beta.AutofeedSettings
	0, // 5: google.shopping.merchant.accounts.v1beta.AutofeedSettingsService.UpdateAutofeedSettings:output_type -> google.shopping.merchant.accounts.v1beta.AutofeedSettings
	4, // [4:6] is the sub-list for method output_type
	2, // [2:4] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_init() }
func file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_init() {
	if File_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_depIdxs,
		MessageInfos:      file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto = out.File
	file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_rawDesc = nil
	file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_goTypes = nil
	file_google_shopping_merchant_accounts_v1beta_autofeedsettings_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AutofeedSettingsServiceClient is the client API for AutofeedSettingsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AutofeedSettingsServiceClient interface {
	// Retrieves the autofeed settings of an account.
	GetAutofeedSettings(ctx context.Context, in *GetAutofeedSettingsRequest, opts ...grpc.CallOption) (*AutofeedSettings, error)
	// Updates the autofeed settings of an account.
	UpdateAutofeedSettings(ctx context.Context, in *UpdateAutofeedSettingsRequest, opts ...grpc.CallOption) (*AutofeedSettings, error)
}

type autofeedSettingsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAutofeedSettingsServiceClient(cc grpc.ClientConnInterface) AutofeedSettingsServiceClient {
	return &autofeedSettingsServiceClient{cc}
}

func (c *autofeedSettingsServiceClient) GetAutofeedSettings(ctx context.Context, in *GetAutofeedSettingsRequest, opts ...grpc.CallOption) (*AutofeedSettings, error) {
	out := new(AutofeedSettings)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.accounts.v1beta.AutofeedSettingsService/GetAutofeedSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autofeedSettingsServiceClient) UpdateAutofeedSettings(ctx context.Context, in *UpdateAutofeedSettingsRequest, opts ...grpc.CallOption) (*AutofeedSettings, error) {
	out := new(AutofeedSettings)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.accounts.v1beta.AutofeedSettingsService/UpdateAutofeedSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AutofeedSettingsServiceServer is the server API for AutofeedSettingsService service.
type AutofeedSettingsServiceServer interface {
	// Retrieves the autofeed settings of an account.
	GetAutofeedSettings(context.Context, *GetAutofeedSettingsRequest) (*AutofeedSettings, error)
	// Updates the autofeed settings of an account.
	UpdateAutofeedSettings(context.Context, *UpdateAutofeedSettingsRequest) (*AutofeedSettings, error)
}

// UnimplementedAutofeedSettingsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAutofeedSettingsServiceServer struct {
}

func (*UnimplementedAutofeedSettingsServiceServer) GetAutofeedSettings(context.Context, *GetAutofeedSettingsRequest) (*AutofeedSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAutofeedSettings not implemented")
}
func (*UnimplementedAutofeedSettingsServiceServer) UpdateAutofeedSettings(context.Context, *UpdateAutofeedSettingsRequest) (*AutofeedSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAutofeedSettings not implemented")
}

func RegisterAutofeedSettingsServiceServer(s *grpc.Server, srv AutofeedSettingsServiceServer) {
	s.RegisterService(&_AutofeedSettingsService_serviceDesc, srv)
}

func _AutofeedSettingsService_GetAutofeedSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAutofeedSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutofeedSettingsServiceServer).GetAutofeedSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.accounts.v1beta.AutofeedSettingsService/GetAutofeedSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutofeedSettingsServiceServer).GetAutofeedSettings(ctx, req.(*GetAutofeedSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutofeedSettingsService_UpdateAutofeedSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAutofeedSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutofeedSettingsServiceServer).UpdateAutofeedSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.accounts.v1beta.AutofeedSettingsService/UpdateAutofeedSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutofeedSettingsServiceServer).UpdateAutofeedSettings(ctx, req.(*UpdateAutofeedSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AutofeedSettingsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.shopping.merchant.accounts.v1beta.AutofeedSettingsService",
	HandlerType: (*AutofeedSettingsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAutofeedSettings",
			Handler:    _AutofeedSettingsService_GetAutofeedSettings_Handler,
		},
		{
			MethodName: "UpdateAutofeedSettings",
			Handler:    _AutofeedSettingsService_UpdateAutofeedSettings_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/shopping/merchant/accounts/v1beta/autofeedsettings.proto",
}
