// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/run/v2/vendor_settings.proto

package runpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Allowed ingress traffic for the Container.
type IngressTraffic int32

const (
	// Unspecified
	IngressTraffic_INGRESS_TRAFFIC_UNSPECIFIED IngressTraffic = 0
	// All inbound traffic is allowed.
	IngressTraffic_INGRESS_TRAFFIC_ALL IngressTraffic = 1
	// Only internal traffic is allowed.
	IngressTraffic_INGRESS_TRAFFIC_INTERNAL_ONLY IngressTraffic = 2
	// Both internal and Google Cloud Load Balancer traffic is allowed.
	IngressTraffic_INGRESS_TRAFFIC_INTERNAL_LOAD_BALANCER IngressTraffic = 3
	// No ingress traffic is allowed.
	IngressTraffic_INGRESS_TRAFFIC_NONE IngressTraffic = 4
)

// Enum value maps for IngressTraffic.
var (
	IngressTraffic_name = map[int32]string{
		0: "INGRESS_TRAFFIC_UNSPECIFIED",
		1: "INGRESS_TRAFFIC_ALL",
		2: "INGRESS_TRAFFIC_INTERNAL_ONLY",
		3: "INGRESS_TRAFFIC_INTERNAL_LOAD_BALANCER",
		4: "INGRESS_TRAFFIC_NONE",
	}
	IngressTraffic_value = map[string]int32{
		"INGRESS_TRAFFIC_UNSPECIFIED":            0,
		"INGRESS_TRAFFIC_ALL":                    1,
		"INGRESS_TRAFFIC_INTERNAL_ONLY":          2,
		"INGRESS_TRAFFIC_INTERNAL_LOAD_BALANCER": 3,
		"INGRESS_TRAFFIC_NONE":                   4,
	}
)

func (x IngressTraffic) Enum() *IngressTraffic {
	p := new(IngressTraffic)
	*p = x
	return p
}

func (x IngressTraffic) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IngressTraffic) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_run_v2_vendor_settings_proto_enumTypes[0].Descriptor()
}

func (IngressTraffic) Type() protoreflect.EnumType {
	return &file_google_cloud_run_v2_vendor_settings_proto_enumTypes[0]
}

func (x IngressTraffic) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IngressTraffic.Descriptor instead.
func (IngressTraffic) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_vendor_settings_proto_rawDescGZIP(), []int{0}
}

// Alternatives for execution environments.
type ExecutionEnvironment int32

const (
	// Unspecified
	ExecutionEnvironment_EXECUTION_ENVIRONMENT_UNSPECIFIED ExecutionEnvironment = 0
	// Uses the First Generation environment.
	ExecutionEnvironment_EXECUTION_ENVIRONMENT_GEN1 ExecutionEnvironment = 1
	// Uses Second Generation environment.
	ExecutionEnvironment_EXECUTION_ENVIRONMENT_GEN2 ExecutionEnvironment = 2
)

// Enum value maps for ExecutionEnvironment.
var (
	ExecutionEnvironment_name = map[int32]string{
		0: "EXECUTION_ENVIRONMENT_UNSPECIFIED",
		1: "EXECUTION_ENVIRONMENT_GEN1",
		2: "EXECUTION_ENVIRONMENT_GEN2",
	}
	ExecutionEnvironment_value = map[string]int32{
		"EXECUTION_ENVIRONMENT_UNSPECIFIED": 0,
		"EXECUTION_ENVIRONMENT_GEN1":        1,
		"EXECUTION_ENVIRONMENT_GEN2":        2,
	}
)

func (x ExecutionEnvironment) Enum() *ExecutionEnvironment {
	p := new(ExecutionEnvironment)
	*p = x
	return p
}

func (x ExecutionEnvironment) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExecutionEnvironment) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_run_v2_vendor_settings_proto_enumTypes[1].Descriptor()
}

func (ExecutionEnvironment) Type() protoreflect.EnumType {
	return &file_google_cloud_run_v2_vendor_settings_proto_enumTypes[1]
}

func (x ExecutionEnvironment) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExecutionEnvironment.Descriptor instead.
func (ExecutionEnvironment) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_vendor_settings_proto_rawDescGZIP(), []int{1}
}

// Specifies behavior if an encryption key used by a resource is revoked.
type EncryptionKeyRevocationAction int32

const (
	// Unspecified
	EncryptionKeyRevocationAction_ENCRYPTION_KEY_REVOCATION_ACTION_UNSPECIFIED EncryptionKeyRevocationAction = 0
	// Prevents the creation of new instances.
	EncryptionKeyRevocationAction_PREVENT_NEW EncryptionKeyRevocationAction = 1
	// Shuts down existing instances, and prevents creation of new ones.
	EncryptionKeyRevocationAction_SHUTDOWN EncryptionKeyRevocationAction = 2
)

// Enum value maps for EncryptionKeyRevocationAction.
var (
	EncryptionKeyRevocationAction_name = map[int32]string{
		0: "ENCRYPTION_KEY_REVOCATION_ACTION_UNSPECIFIED",
		1: "PREVENT_NEW",
		2: "SHUTDOWN",
	}
	EncryptionKeyRevocationAction_value = map[string]int32{
		"ENCRYPTION_KEY_REVOCATION_ACTION_UNSPECIFIED": 0,
		"PREVENT_NEW": 1,
		"SHUTDOWN":    2,
	}
)

func (x EncryptionKeyRevocationAction) Enum() *EncryptionKeyRevocationAction {
	p := new(EncryptionKeyRevocationAction)
	*p = x
	return p
}

func (x EncryptionKeyRevocationAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EncryptionKeyRevocationAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_run_v2_vendor_settings_proto_enumTypes[2].Descriptor()
}

func (EncryptionKeyRevocationAction) Type() protoreflect.EnumType {
	return &file_google_cloud_run_v2_vendor_settings_proto_enumTypes[2]
}

func (x EncryptionKeyRevocationAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EncryptionKeyRevocationAction.Descriptor instead.
func (EncryptionKeyRevocationAction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_vendor_settings_proto_rawDescGZIP(), []int{2}
}

// Egress options for VPC access.
type VpcAccess_VpcEgress int32

const (
	// Unspecified
	VpcAccess_VPC_EGRESS_UNSPECIFIED VpcAccess_VpcEgress = 0
	// All outbound traffic is routed through the VPC connector.
	VpcAccess_ALL_TRAFFIC VpcAccess_VpcEgress = 1
	// Only private IP ranges are routed through the VPC connector.
	VpcAccess_PRIVATE_RANGES_ONLY VpcAccess_VpcEgress = 2
)

// Enum value maps for VpcAccess_VpcEgress.
var (
	VpcAccess_VpcEgress_name = map[int32]string{
		0: "VPC_EGRESS_UNSPECIFIED",
		1: "ALL_TRAFFIC",
		2: "PRIVATE_RANGES_ONLY",
	}
	VpcAccess_VpcEgress_value = map[string]int32{
		"VPC_EGRESS_UNSPECIFIED": 0,
		"ALL_TRAFFIC":            1,
		"PRIVATE_RANGES_ONLY":    2,
	}
)

func (x VpcAccess_VpcEgress) Enum() *VpcAccess_VpcEgress {
	p := new(VpcAccess_VpcEgress)
	*p = x
	return p
}

func (x VpcAccess_VpcEgress) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VpcAccess_VpcEgress) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_run_v2_vendor_settings_proto_enumTypes[3].Descriptor()
}

func (VpcAccess_VpcEgress) Type() protoreflect.EnumType {
	return &file_google_cloud_run_v2_vendor_settings_proto_enumTypes[3]
}

func (x VpcAccess_VpcEgress) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VpcAccess_VpcEgress.Descriptor instead.
func (VpcAccess_VpcEgress) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_vendor_settings_proto_rawDescGZIP(), []int{0, 0}
}

// The scaling mode for the service. If not provided, it defaults to
// AUTOMATIC.
type ServiceScaling_ScalingMode int32

const (
	// Unspecified.
	ServiceScaling_SCALING_MODE_UNSPECIFIED ServiceScaling_ScalingMode = 0
	// Scale based on traffic between min and max instances.
	ServiceScaling_AUTOMATIC ServiceScaling_ScalingMode = 1
	// Scale to exactly min instances and ignore max instances.
	ServiceScaling_MANUAL ServiceScaling_ScalingMode = 2
)

// Enum value maps for ServiceScaling_ScalingMode.
var (
	ServiceScaling_ScalingMode_name = map[int32]string{
		0: "SCALING_MODE_UNSPECIFIED",
		1: "AUTOMATIC",
		2: "MANUAL",
	}
	ServiceScaling_ScalingMode_value = map[string]int32{
		"SCALING_MODE_UNSPECIFIED": 0,
		"AUTOMATIC":                1,
		"MANUAL":                   2,
	}
)

func (x ServiceScaling_ScalingMode) Enum() *ServiceScaling_ScalingMode {
	p := new(ServiceScaling_ScalingMode)
	*p = x
	return p
}

func (x ServiceScaling_ScalingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServiceScaling_ScalingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_run_v2_vendor_settings_proto_enumTypes[4].Descriptor()
}

func (ServiceScaling_ScalingMode) Type() protoreflect.EnumType {
	return &file_google_cloud_run_v2_vendor_settings_proto_enumTypes[4]
}

func (x ServiceScaling_ScalingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServiceScaling_ScalingMode.Descriptor instead.
func (ServiceScaling_ScalingMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_vendor_settings_proto_rawDescGZIP(), []int{4, 0}
}

// VPC Access settings. For more information on sending traffic to a VPC
// network, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
type VpcAccess struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// VPC Access connector name.
	// Format: `projects/{project}/locations/{location}/connectors/{connector}`,
	// where `{project}` can be project id or number.
	// For more information on sending traffic to a VPC network via a connector,
	// visit https://cloud.google.com/run/docs/configuring/vpc-connectors.
	Connector string `protobuf:"bytes,1,opt,name=connector,proto3" json:"connector,omitempty"`
	// Optional. Traffic VPC egress settings. If not provided, it defaults to
	// PRIVATE_RANGES_ONLY.
	Egress VpcAccess_VpcEgress `protobuf:"varint,2,opt,name=egress,proto3,enum=google.cloud.run.v2.VpcAccess_VpcEgress" json:"egress,omitempty"`
	// Optional. Direct VPC egress settings. Currently only single network
	// interface is supported.
	NetworkInterfaces []*VpcAccess_NetworkInterface `protobuf:"bytes,3,rep,name=network_interfaces,json=networkInterfaces,proto3" json:"network_interfaces,omitempty"`
}

func (x *VpcAccess) Reset() {
	*x = VpcAccess{}
	mi := &file_google_cloud_run_v2_vendor_settings_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VpcAccess) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VpcAccess) ProtoMessage() {}

func (x *VpcAccess) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_vendor_settings_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VpcAccess.ProtoReflect.Descriptor instead.
func (*VpcAccess) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_vendor_settings_proto_rawDescGZIP(), []int{0}
}

func (x *VpcAccess) GetConnector() string {
	if x != nil {
		return x.Connector
	}
	return ""
}

func (x *VpcAccess) GetEgress() VpcAccess_VpcEgress {
	if x != nil {
		return x.Egress
	}
	return VpcAccess_VPC_EGRESS_UNSPECIFIED
}

func (x *VpcAccess) GetNetworkInterfaces() []*VpcAccess_NetworkInterface {
	if x != nil {
		return x.NetworkInterfaces
	}
	return nil
}

// Settings for Binary Authorization feature.
type BinaryAuthorization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to BinauthzMethod:
	//
	//	*BinaryAuthorization_UseDefault
	//	*BinaryAuthorization_Policy
	BinauthzMethod isBinaryAuthorization_BinauthzMethod `protobuf_oneof:"binauthz_method"`
	// Optional. If present, indicates to use Breakglass using this justification.
	// If use_default is False, then it must be empty.
	// For more information on breakglass, see
	// https://cloud.google.com/binary-authorization/docs/using-breakglass
	BreakglassJustification string `protobuf:"bytes,2,opt,name=breakglass_justification,json=breakglassJustification,proto3" json:"breakglass_justification,omitempty"`
}

func (x *BinaryAuthorization) Reset() {
	*x = BinaryAuthorization{}
	mi := &file_google_cloud_run_v2_vendor_settings_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BinaryAuthorization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BinaryAuthorization) ProtoMessage() {}

func (x *BinaryAuthorization) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_vendor_settings_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BinaryAuthorization.ProtoReflect.Descriptor instead.
func (*BinaryAuthorization) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_vendor_settings_proto_rawDescGZIP(), []int{1}
}

func (m *BinaryAuthorization) GetBinauthzMethod() isBinaryAuthorization_BinauthzMethod {
	if m != nil {
		return m.BinauthzMethod
	}
	return nil
}

func (x *BinaryAuthorization) GetUseDefault() bool {
	if x, ok := x.GetBinauthzMethod().(*BinaryAuthorization_UseDefault); ok {
		return x.UseDefault
	}
	return false
}

func (x *BinaryAuthorization) GetPolicy() string {
	if x, ok := x.GetBinauthzMethod().(*BinaryAuthorization_Policy); ok {
		return x.Policy
	}
	return ""
}

func (x *BinaryAuthorization) GetBreakglassJustification() string {
	if x != nil {
		return x.BreakglassJustification
	}
	return ""
}

type isBinaryAuthorization_BinauthzMethod interface {
	isBinaryAuthorization_BinauthzMethod()
}

type BinaryAuthorization_UseDefault struct {
	// Optional. If True, indicates to use the default project's binary
	// authorization policy. If False, binary authorization will be disabled.
	UseDefault bool `protobuf:"varint,1,opt,name=use_default,json=useDefault,proto3,oneof"`
}

type BinaryAuthorization_Policy struct {
	// Optional. The path to a binary authorization policy.
	// Format: `projects/{project}/platforms/cloudRun/{policy-name}`
	Policy string `protobuf:"bytes,3,opt,name=policy,proto3,oneof"`
}

func (*BinaryAuthorization_UseDefault) isBinaryAuthorization_BinauthzMethod() {}

func (*BinaryAuthorization_Policy) isBinaryAuthorization_BinauthzMethod() {}

// Settings for revision-level scaling settings.
type RevisionScaling struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Minimum number of serving instances that this resource should
	// have.
	MinInstanceCount int32 `protobuf:"varint,1,opt,name=min_instance_count,json=minInstanceCount,proto3" json:"min_instance_count,omitempty"`
	// Optional. Maximum number of serving instances that this resource should
	// have. When unspecified, the field is set to the server default value of
	// 100. For more information see
	// https://cloud.google.com/run/docs/configuring/max-instances
	MaxInstanceCount int32 `protobuf:"varint,2,opt,name=max_instance_count,json=maxInstanceCount,proto3" json:"max_instance_count,omitempty"`
}

func (x *RevisionScaling) Reset() {
	*x = RevisionScaling{}
	mi := &file_google_cloud_run_v2_vendor_settings_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RevisionScaling) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RevisionScaling) ProtoMessage() {}

func (x *RevisionScaling) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_vendor_settings_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RevisionScaling.ProtoReflect.Descriptor instead.
func (*RevisionScaling) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_vendor_settings_proto_rawDescGZIP(), []int{2}
}

func (x *RevisionScaling) GetMinInstanceCount() int32 {
	if x != nil {
		return x.MinInstanceCount
	}
	return 0
}

func (x *RevisionScaling) GetMaxInstanceCount() int32 {
	if x != nil {
		return x.MaxInstanceCount
	}
	return 0
}

// Settings for Cloud Service Mesh. For more information see
// https://cloud.google.com/service-mesh/docs/overview.
type ServiceMesh struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Mesh resource name. Format:
	// `projects/{project}/locations/global/meshes/{mesh}`, where `{project}` can
	// be project id or number.
	Mesh string `protobuf:"bytes,1,opt,name=mesh,proto3" json:"mesh,omitempty"`
}

func (x *ServiceMesh) Reset() {
	*x = ServiceMesh{}
	mi := &file_google_cloud_run_v2_vendor_settings_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceMesh) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceMesh) ProtoMessage() {}

func (x *ServiceMesh) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_vendor_settings_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceMesh.ProtoReflect.Descriptor instead.
func (*ServiceMesh) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_vendor_settings_proto_rawDescGZIP(), []int{3}
}

func (x *ServiceMesh) GetMesh() string {
	if x != nil {
		return x.Mesh
	}
	return ""
}

// Scaling settings applied at the service level rather than
// at the revision level.
type ServiceScaling struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. total min instances for the service. This number of instances is
	// divided among all revisions with specified traffic based on the percent
	// of traffic they are receiving.
	MinInstanceCount int32 `protobuf:"varint,1,opt,name=min_instance_count,json=minInstanceCount,proto3" json:"min_instance_count,omitempty"`
	// Optional. The scaling mode for the service.
	ScalingMode ServiceScaling_ScalingMode `protobuf:"varint,3,opt,name=scaling_mode,json=scalingMode,proto3,enum=google.cloud.run.v2.ServiceScaling_ScalingMode" json:"scaling_mode,omitempty"`
	// Optional. total instance count for the service in manual scaling mode. This
	// number of instances is divided among all revisions with specified traffic
	// based on the percent of traffic they are receiving.
	ManualInstanceCount *int32 `protobuf:"varint,6,opt,name=manual_instance_count,json=manualInstanceCount,proto3,oneof" json:"manual_instance_count,omitempty"`
}

func (x *ServiceScaling) Reset() {
	*x = ServiceScaling{}
	mi := &file_google_cloud_run_v2_vendor_settings_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceScaling) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceScaling) ProtoMessage() {}

func (x *ServiceScaling) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_vendor_settings_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceScaling.ProtoReflect.Descriptor instead.
func (*ServiceScaling) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_vendor_settings_proto_rawDescGZIP(), []int{4}
}

func (x *ServiceScaling) GetMinInstanceCount() int32 {
	if x != nil {
		return x.MinInstanceCount
	}
	return 0
}

func (x *ServiceScaling) GetScalingMode() ServiceScaling_ScalingMode {
	if x != nil {
		return x.ScalingMode
	}
	return ServiceScaling_SCALING_MODE_UNSPECIFIED
}

func (x *ServiceScaling) GetManualInstanceCount() int32 {
	if x != nil && x.ManualInstanceCount != nil {
		return *x.ManualInstanceCount
	}
	return 0
}

// Hardware constraints configuration.
type NodeSelector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. GPU accelerator type to attach to an instance.
	Accelerator string `protobuf:"bytes,1,opt,name=accelerator,proto3" json:"accelerator,omitempty"`
}

func (x *NodeSelector) Reset() {
	*x = NodeSelector{}
	mi := &file_google_cloud_run_v2_vendor_settings_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodeSelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeSelector) ProtoMessage() {}

func (x *NodeSelector) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_vendor_settings_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeSelector.ProtoReflect.Descriptor instead.
func (*NodeSelector) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_vendor_settings_proto_rawDescGZIP(), []int{5}
}

func (x *NodeSelector) GetAccelerator() string {
	if x != nil {
		return x.Accelerator
	}
	return ""
}

// Describes the Build step of the function that builds a container from the
// given source.
type BuildConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The Cloud Build name of the latest successful deployment of
	// the function.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The Cloud Storage bucket URI where the function source code is located.
	SourceLocation string `protobuf:"bytes,2,opt,name=source_location,json=sourceLocation,proto3" json:"source_location,omitempty"`
	// Optional. The name of the function (as defined in source code) that will be
	// executed. Defaults to the resource name suffix, if not specified. For
	// backward compatibility, if function with given name is not found, then the
	// system will try to use function named "function".
	FunctionTarget string `protobuf:"bytes,3,opt,name=function_target,json=functionTarget,proto3" json:"function_target,omitempty"`
	// Optional. Artifact Registry URI to store the built image.
	ImageUri string `protobuf:"bytes,4,opt,name=image_uri,json=imageUri,proto3" json:"image_uri,omitempty"`
	// Optional. The base image used to build the function.
	BaseImage string `protobuf:"bytes,5,opt,name=base_image,json=baseImage,proto3" json:"base_image,omitempty"`
	// Optional. Sets whether the function will receive automatic base image
	// updates.
	EnableAutomaticUpdates bool `protobuf:"varint,6,opt,name=enable_automatic_updates,json=enableAutomaticUpdates,proto3" json:"enable_automatic_updates,omitempty"`
	// Optional. Name of the Cloud Build Custom Worker Pool that should be used to
	// build the Cloud Run function. The format of this field is
	// `projects/{project}/locations/{region}/workerPools/{workerPool}` where
	// `{project}` and `{region}` are the project id and region respectively where
	// the worker pool is defined and `{workerPool}` is the short name of the
	// worker pool.
	WorkerPool string `protobuf:"bytes,7,opt,name=worker_pool,json=workerPool,proto3" json:"worker_pool,omitempty"`
	// Optional. User-provided build-time environment variables for the function
	EnvironmentVariables map[string]string `protobuf:"bytes,8,rep,name=environment_variables,json=environmentVariables,proto3" json:"environment_variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Service account to be used for building the container. The format
	// of this field is
	// `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
	ServiceAccount string `protobuf:"bytes,9,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
}

func (x *BuildConfig) Reset() {
	*x = BuildConfig{}
	mi := &file_google_cloud_run_v2_vendor_settings_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BuildConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BuildConfig) ProtoMessage() {}

func (x *BuildConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_vendor_settings_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BuildConfig.ProtoReflect.Descriptor instead.
func (*BuildConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_vendor_settings_proto_rawDescGZIP(), []int{6}
}

func (x *BuildConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BuildConfig) GetSourceLocation() string {
	if x != nil {
		return x.SourceLocation
	}
	return ""
}

func (x *BuildConfig) GetFunctionTarget() string {
	if x != nil {
		return x.FunctionTarget
	}
	return ""
}

func (x *BuildConfig) GetImageUri() string {
	if x != nil {
		return x.ImageUri
	}
	return ""
}

func (x *BuildConfig) GetBaseImage() string {
	if x != nil {
		return x.BaseImage
	}
	return ""
}

func (x *BuildConfig) GetEnableAutomaticUpdates() bool {
	if x != nil {
		return x.EnableAutomaticUpdates
	}
	return false
}

func (x *BuildConfig) GetWorkerPool() string {
	if x != nil {
		return x.WorkerPool
	}
	return ""
}

func (x *BuildConfig) GetEnvironmentVariables() map[string]string {
	if x != nil {
		return x.EnvironmentVariables
	}
	return nil
}

func (x *BuildConfig) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

// Direct VPC egress settings.
type VpcAccess_NetworkInterface struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The VPC network that the Cloud Run resource will be able to
	// send traffic to. At least one of network or subnetwork must be specified.
	// If both network and subnetwork are specified, the given VPC subnetwork
	// must belong to the given VPC network. If network is not specified, it
	// will be looked up from the subnetwork.
	Network string `protobuf:"bytes,1,opt,name=network,proto3" json:"network,omitempty"`
	// Optional. The VPC subnetwork that the Cloud Run resource will get IPs
	// from. At least one of network or subnetwork must be specified. If both
	// network and subnetwork are specified, the given VPC subnetwork must
	// belong to the given VPC network. If subnetwork is not specified, the
	// subnetwork with the same name with the network will be used.
	Subnetwork string `protobuf:"bytes,2,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
	// Optional. Network tags applied to this Cloud Run resource.
	Tags []string `protobuf:"bytes,3,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (x *VpcAccess_NetworkInterface) Reset() {
	*x = VpcAccess_NetworkInterface{}
	mi := &file_google_cloud_run_v2_vendor_settings_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VpcAccess_NetworkInterface) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VpcAccess_NetworkInterface) ProtoMessage() {}

func (x *VpcAccess_NetworkInterface) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_vendor_settings_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VpcAccess_NetworkInterface.ProtoReflect.Descriptor instead.
func (*VpcAccess_NetworkInterface) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_vendor_settings_proto_rawDescGZIP(), []int{0, 0}
}

func (x *VpcAccess_NetworkInterface) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *VpcAccess_NetworkInterface) GetSubnetwork() string {
	if x != nil {
		return x.Subnetwork
	}
	return ""
}

func (x *VpcAccess_NetworkInterface) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

var File_google_cloud_run_v2_vendor_settings_proto protoreflect.FileDescriptor

var file_google_cloud_run_v2_vendor_settings_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x75, 0x6e, 0x2f, 0x76, 0x32, 0x2f, 0x76, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x5f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x13, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc2, 0x03, 0x0a,
	0x09, 0x56, 0x70, 0x63, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x45, 0x0a, 0x09, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xfa,
	0x41, 0x24, 0x0a, 0x22, 0x76, 0x70, 0x63, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x12, 0x45, 0x0a, 0x06, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x70, 0x63, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x2e, 0x56, 0x70, 0x63, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x63, 0x0a, 0x12, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x70, 0x63, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x66, 0x61, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73, 0x1a, 0x6f, 0x0a,
	0x10, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63,
	0x65, 0x12, 0x1d, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x12, 0x23, 0x0a, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x22, 0x51,
	0x0a, 0x09, 0x56, 0x70, 0x63, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1a, 0x0a, 0x16, 0x56,
	0x50, 0x43, 0x5f, 0x45, 0x47, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x4c, 0x4c, 0x5f, 0x54,
	0x52, 0x41, 0x46, 0x46, 0x49, 0x43, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x50, 0x52, 0x49, 0x56,
	0x41, 0x54, 0x45, 0x5f, 0x52, 0x41, 0x4e, 0x47, 0x45, 0x53, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10,
	0x02, 0x22, 0xdd, 0x01, 0x0a, 0x13, 0x42, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0b, 0x75, 0x73, 0x65,
	0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0a, 0x75, 0x73, 0x65, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x31, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x62, 0x69, 0x6e, 0x61, 0x72,
	0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x48, 0x00, 0x52, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x3e,
	0x0a, 0x18, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x67, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x6a, 0x75, 0x73,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x17, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x67, 0x6c, 0x61, 0x73,
	0x73, 0x4a, 0x75, 0x73, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x11,
	0x0a, 0x0f, 0x62, 0x69, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x7a, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x22, 0x77, 0x0a, 0x0f, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x63, 0x61,
	0x6c, 0x69, 0x6e, 0x67, 0x12, 0x31, 0x0a, 0x12, 0x6d, 0x69, 0x6e, 0x5f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x6d, 0x69, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x31, 0x0a, 0x12, 0x6d, 0x61, 0x78, 0x5f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x6d, 0x61, 0x78, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x4b, 0x0a, 0x0b, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x65, 0x73, 0x68, 0x12, 0x3c, 0x0a, 0x04, 0x6d, 0x65, 0x73,
	0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x73,
	0x68, 0x52, 0x04, 0x6d, 0x65, 0x73, 0x68, 0x22, 0xbc, 0x02, 0x0a, 0x0e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x53, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x31, 0x0a, 0x12, 0x6d, 0x69,
	0x6e, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x6d, 0x69, 0x6e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x57, 0x0a,
	0x0c, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x53, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x53, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67,
	0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x73, 0x63, 0x61, 0x6c, 0x69,
	0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x3c, 0x0a, 0x15, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c,
	0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x13, 0x6d, 0x61,
	0x6e, 0x75, 0x61, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x88, 0x01, 0x01, 0x22, 0x46, 0x0a, 0x0b, 0x53, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x4d,
	0x6f, 0x64, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x53, 0x43, 0x41, 0x4c, 0x49, 0x4e, 0x47, 0x5f, 0x4d,
	0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0d, 0x0a, 0x09, 0x41, 0x55, 0x54, 0x4f, 0x4d, 0x41, 0x54, 0x49, 0x43, 0x10, 0x01,
	0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x41, 0x4e, 0x55, 0x41, 0x4c, 0x10, 0x02, 0x42, 0x18, 0x0a, 0x16,
	0x5f, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x35, 0x0a, 0x0c, 0x4e, 0x6f, 0x64, 0x65, 0x53, 0x65,
	0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x25, 0x0a, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x22, 0xe2, 0x04,
	0x0a, 0x0b, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x03,
	0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42,
	0x75, 0x69, 0x6c, 0x64, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x0f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x12, 0x20, 0x0a, 0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x69, 0x6d, 0x61, 0x67, 0x65,
	0x55, 0x72, 0x69, 0x12, 0x22, 0x0a, 0x0a, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x62, 0x61,
	0x73, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x3d, 0x0a, 0x18, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x12, 0x4d, 0x0a, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x01,
	0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x0a, 0x77, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x74, 0x0a, 0x15, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x08,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x2c, 0x0a, 0x0f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x47, 0x0a, 0x19, 0x45, 0x6e, 0x76,
	0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x2a, 0xb3, 0x01, 0x0a, 0x0e, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x54, 0x72,
	0x61, 0x66, 0x66, 0x69, 0x63, 0x12, 0x1f, 0x0a, 0x1b, 0x49, 0x4e, 0x47, 0x52, 0x45, 0x53, 0x53,
	0x5f, 0x54, 0x52, 0x41, 0x46, 0x46, 0x49, 0x43, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x49, 0x4e, 0x47, 0x52, 0x45, 0x53,
	0x53, 0x5f, 0x54, 0x52, 0x41, 0x46, 0x46, 0x49, 0x43, 0x5f, 0x41, 0x4c, 0x4c, 0x10, 0x01, 0x12,
	0x21, 0x0a, 0x1d, 0x49, 0x4e, 0x47, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x54, 0x52, 0x41, 0x46, 0x46,
	0x49, 0x43, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x4f, 0x4e, 0x4c, 0x59,
	0x10, 0x02, 0x12, 0x2a, 0x0a, 0x26, 0x49, 0x4e, 0x47, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x54, 0x52,
	0x41, 0x46, 0x46, 0x49, 0x43, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x4c,
	0x4f, 0x41, 0x44, 0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x52, 0x10, 0x03, 0x12, 0x18,
	0x0a, 0x14, 0x49, 0x4e, 0x47, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x54, 0x52, 0x41, 0x46, 0x46, 0x49,
	0x43, 0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x04, 0x2a, 0x7d, 0x0a, 0x14, 0x45, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x25, 0x0a, 0x21, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x4e,
	0x56, 0x49, 0x52, 0x4f, 0x4e, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1e, 0x0a, 0x1a, 0x45, 0x58, 0x45, 0x43, 0x55,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x4e, 0x56, 0x49, 0x52, 0x4f, 0x4e, 0x4d, 0x45, 0x4e, 0x54,
	0x5f, 0x47, 0x45, 0x4e, 0x31, 0x10, 0x01, 0x12, 0x1e, 0x0a, 0x1a, 0x45, 0x58, 0x45, 0x43, 0x55,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x4e, 0x56, 0x49, 0x52, 0x4f, 0x4e, 0x4d, 0x45, 0x4e, 0x54,
	0x5f, 0x47, 0x45, 0x4e, 0x32, 0x10, 0x02, 0x2a, 0x70, 0x0a, 0x1d, 0x45, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x0a, 0x2c, 0x45, 0x4e, 0x43, 0x52,
	0x59, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x52, 0x45, 0x56, 0x4f, 0x43,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x52,
	0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x4e, 0x45, 0x57, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x53,
	0x48, 0x55, 0x54, 0x44, 0x4f, 0x57, 0x4e, 0x10, 0x02, 0x42, 0xfc, 0x02, 0xea, 0x41, 0x63, 0x0a,
	0x29, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x19, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x1b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0xea, 0x41, 0x5c, 0x0a, 0x23, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x73, 0x68, 0x12, 0x35, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x6d, 0x65, 0x73, 0x68, 0x65, 0x73, 0x2f, 0x7b, 0x6d, 0x65, 0x73, 0x68,
	0x7d, 0xea, 0x41, 0x59, 0x0a, 0x1f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x42, 0x75, 0x69, 0x6c, 0x64, 0x12, 0x36, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x73, 0x2f, 0x7b, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x7d, 0x0a, 0x17, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x42, 0x13, 0x56, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x29, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x72, 0x75, 0x6e, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x72, 0x75, 0x6e,
	0x70, 0x62, 0x3b, 0x72, 0x75, 0x6e, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_run_v2_vendor_settings_proto_rawDescOnce sync.Once
	file_google_cloud_run_v2_vendor_settings_proto_rawDescData = file_google_cloud_run_v2_vendor_settings_proto_rawDesc
)

func file_google_cloud_run_v2_vendor_settings_proto_rawDescGZIP() []byte {
	file_google_cloud_run_v2_vendor_settings_proto_rawDescOnce.Do(func() {
		file_google_cloud_run_v2_vendor_settings_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_run_v2_vendor_settings_proto_rawDescData)
	})
	return file_google_cloud_run_v2_vendor_settings_proto_rawDescData
}

var file_google_cloud_run_v2_vendor_settings_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_run_v2_vendor_settings_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_cloud_run_v2_vendor_settings_proto_goTypes = []any{
	(IngressTraffic)(0),                // 0: google.cloud.run.v2.IngressTraffic
	(ExecutionEnvironment)(0),          // 1: google.cloud.run.v2.ExecutionEnvironment
	(EncryptionKeyRevocationAction)(0), // 2: google.cloud.run.v2.EncryptionKeyRevocationAction
	(VpcAccess_VpcEgress)(0),           // 3: google.cloud.run.v2.VpcAccess.VpcEgress
	(ServiceScaling_ScalingMode)(0),    // 4: google.cloud.run.v2.ServiceScaling.ScalingMode
	(*VpcAccess)(nil),                  // 5: google.cloud.run.v2.VpcAccess
	(*BinaryAuthorization)(nil),        // 6: google.cloud.run.v2.BinaryAuthorization
	(*RevisionScaling)(nil),            // 7: google.cloud.run.v2.RevisionScaling
	(*ServiceMesh)(nil),                // 8: google.cloud.run.v2.ServiceMesh
	(*ServiceScaling)(nil),             // 9: google.cloud.run.v2.ServiceScaling
	(*NodeSelector)(nil),               // 10: google.cloud.run.v2.NodeSelector
	(*BuildConfig)(nil),                // 11: google.cloud.run.v2.BuildConfig
	(*VpcAccess_NetworkInterface)(nil), // 12: google.cloud.run.v2.VpcAccess.NetworkInterface
	nil,                                // 13: google.cloud.run.v2.BuildConfig.EnvironmentVariablesEntry
}
var file_google_cloud_run_v2_vendor_settings_proto_depIdxs = []int32{
	3,  // 0: google.cloud.run.v2.VpcAccess.egress:type_name -> google.cloud.run.v2.VpcAccess.VpcEgress
	12, // 1: google.cloud.run.v2.VpcAccess.network_interfaces:type_name -> google.cloud.run.v2.VpcAccess.NetworkInterface
	4,  // 2: google.cloud.run.v2.ServiceScaling.scaling_mode:type_name -> google.cloud.run.v2.ServiceScaling.ScalingMode
	13, // 3: google.cloud.run.v2.BuildConfig.environment_variables:type_name -> google.cloud.run.v2.BuildConfig.EnvironmentVariablesEntry
	4,  // [4:4] is the sub-list for method output_type
	4,  // [4:4] is the sub-list for method input_type
	4,  // [4:4] is the sub-list for extension type_name
	4,  // [4:4] is the sub-list for extension extendee
	0,  // [0:4] is the sub-list for field type_name
}

func init() { file_google_cloud_run_v2_vendor_settings_proto_init() }
func file_google_cloud_run_v2_vendor_settings_proto_init() {
	if File_google_cloud_run_v2_vendor_settings_proto != nil {
		return
	}
	file_google_cloud_run_v2_vendor_settings_proto_msgTypes[1].OneofWrappers = []any{
		(*BinaryAuthorization_UseDefault)(nil),
		(*BinaryAuthorization_Policy)(nil),
	}
	file_google_cloud_run_v2_vendor_settings_proto_msgTypes[4].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_run_v2_vendor_settings_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_run_v2_vendor_settings_proto_goTypes,
		DependencyIndexes: file_google_cloud_run_v2_vendor_settings_proto_depIdxs,
		EnumInfos:         file_google_cloud_run_v2_vendor_settings_proto_enumTypes,
		MessageInfos:      file_google_cloud_run_v2_vendor_settings_proto_msgTypes,
	}.Build()
	File_google_cloud_run_v2_vendor_settings_proto = out.File
	file_google_cloud_run_v2_vendor_settings_proto_rawDesc = nil
	file_google_cloud_run_v2_vendor_settings_proto_goTypes = nil
	file_google_cloud_run_v2_vendor_settings_proto_depIdxs = nil
}
