// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/retail/v2beta/export_config.proto

package retailpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The output configuration setting.
type OutputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The configuration of destination for holding output data.
	//
	// Types that are assignable to Destination:
	//
	//	*OutputConfig_GcsDestination_
	//	*OutputConfig_BigqueryDestination
	Destination isOutputConfig_Destination `protobuf_oneof:"destination"`
}

func (x *OutputConfig) Reset() {
	*x = OutputConfig{}
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OutputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputConfig) ProtoMessage() {}

func (x *OutputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputConfig.ProtoReflect.Descriptor instead.
func (*OutputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_export_config_proto_rawDescGZIP(), []int{0}
}

func (m *OutputConfig) GetDestination() isOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *OutputConfig) GetGcsDestination() *OutputConfig_GcsDestination {
	if x, ok := x.GetDestination().(*OutputConfig_GcsDestination_); ok {
		return x.GcsDestination
	}
	return nil
}

func (x *OutputConfig) GetBigqueryDestination() *OutputConfig_BigQueryDestination {
	if x, ok := x.GetDestination().(*OutputConfig_BigqueryDestination); ok {
		return x.BigqueryDestination
	}
	return nil
}

type isOutputConfig_Destination interface {
	isOutputConfig_Destination()
}

type OutputConfig_GcsDestination_ struct {
	// The Google Cloud Storage location where the output is to be written to.
	GcsDestination *OutputConfig_GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

type OutputConfig_BigqueryDestination struct {
	// The BigQuery location where the output is to be written to.
	BigqueryDestination *OutputConfig_BigQueryDestination `protobuf:"bytes,2,opt,name=bigquery_destination,json=bigqueryDestination,proto3,oneof"`
}

func (*OutputConfig_GcsDestination_) isOutputConfig_Destination() {}

func (*OutputConfig_BigqueryDestination) isOutputConfig_Destination() {}

// Configuration of destination for Export related errors.
type ExportErrorsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Errors destination.
	//
	// Types that are assignable to Destination:
	//
	//	*ExportErrorsConfig_GcsPrefix
	Destination isExportErrorsConfig_Destination `protobuf_oneof:"destination"`
}

func (x *ExportErrorsConfig) Reset() {
	*x = ExportErrorsConfig{}
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportErrorsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportErrorsConfig) ProtoMessage() {}

func (x *ExportErrorsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportErrorsConfig.ProtoReflect.Descriptor instead.
func (*ExportErrorsConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_export_config_proto_rawDescGZIP(), []int{1}
}

func (m *ExportErrorsConfig) GetDestination() isExportErrorsConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *ExportErrorsConfig) GetGcsPrefix() string {
	if x, ok := x.GetDestination().(*ExportErrorsConfig_GcsPrefix); ok {
		return x.GcsPrefix
	}
	return ""
}

type isExportErrorsConfig_Destination interface {
	isExportErrorsConfig_Destination()
}

type ExportErrorsConfig_GcsPrefix struct {
	// Google Cloud Storage path for import errors. This must be an empty,
	// existing Cloud Storage bucket. Export errors will be written to a file in
	// this bucket, one per line, as a JSON-encoded
	// `google.rpc.Status` message.
	GcsPrefix string `protobuf:"bytes,1,opt,name=gcs_prefix,json=gcsPrefix,proto3,oneof"`
}

func (*ExportErrorsConfig_GcsPrefix) isExportErrorsConfig_Destination() {}

// Request message for ExportProducts method.
type ExportProductsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of a [Branch][google.cloud.retail.v2beta.Branch],
	// and `default_branch` for branch_id component is supported. For example
	//
	//	`projects/1234/locations/global/catalogs/default_catalog/branches/default_branch`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The output location of the data.
	OutputConfig *OutputConfig `protobuf:"bytes,2,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	// A filtering expression to specify restrictions on returned events.
	// The expression is a sequence of terms. Each term applies a restriction to
	// the returned products. Use this expression to restrict results to a
	// specific time range, tag, or stock state or to filter products by product
	// type.
	// For example, `lastModifiedTime > "2012-04-23T18:25:43.511Z"
	// lastModifiedTime<"2012-04-23T18:25:43.511Z" productType=primary`
	//
	//	We expect only four types of fields:
	//
	//	 * `lastModifiedTime`: This can be specified twice, once with a
	//	   less than operator and once with a greater than operator. The
	//	   `lastModifiedTime` restriction should result in one, contiguous,
	//	   valid, last-modified, time range.
	//
	//	 * `productType`: Supported values are `primary` and `variant`. The
	//	 Boolean operators `OR` and `NOT` are supported if the expression is
	//	 enclosed in parentheses and must be separated from the
	//	   `productType` values by a space.
	//
	//	 * `availability`: Supported values are `IN_STOCK`, `OUT_OF_STOCK`,
	//	 `PREORDER`, and `BACKORDER`. Boolean operators `OR` and `NOT` are
	//	 supported if the expression is enclosed in parentheses and must be
	//	 separated from the `availability` values by a space.
	//
	//	 * `Tag expressions`: Restricts output to products that match all of the
	//	   specified tags. Boolean operators `OR` and `NOT` are supported if the
	//	   expression is enclosed in parentheses and the operators are separated
	//	   from the tag values by a space. Also supported is '`-"tagA"`', which
	//	   is equivalent to '`NOT "tagA"`'. Tag values must be double-quoted,
	//	   UTF-8 encoded strings and have a size limit of 1,000 characters.
	//
	//	Some examples of valid filters expressions:
	//
	//	* Example 1: `lastModifiedTime > "2012-04-23T18:25:43.511Z"
	//	          lastModifiedTime < "2012-04-23T18:30:43.511Z"`
	//	* Example 2: `lastModifiedTime > "2012-04-23T18:25:43.511Z"
	//	          productType = "variant"`
	//	* Example 3: `tag=("Red" OR "Blue") tag="New-Arrival"
	//	          tag=(NOT "promotional")
	//	          productType = "primary" lastModifiedTime <
	//	          "2018-04-23T18:30:43.511Z"`
	//	* Example 4: `lastModifiedTime > "2012-04-23T18:25:43.511Z"`
	//	* Example 5: `availability = (IN_STOCK OR BACKORDER)`
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ExportProductsRequest) Reset() {
	*x = ExportProductsRequest{}
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportProductsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportProductsRequest) ProtoMessage() {}

func (x *ExportProductsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportProductsRequest.ProtoReflect.Descriptor instead.
func (*ExportProductsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_export_config_proto_rawDescGZIP(), []int{2}
}

func (x *ExportProductsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ExportProductsRequest) GetOutputConfig() *OutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

func (x *ExportProductsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Request message for the `ExportUserEvents` method.
type ExportUserEventsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of a [Catalog][google.cloud.retail.v2beta.Catalog].
	// For example `projects/1234/locations/global/catalogs/default_catalog`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The output location of the data.
	OutputConfig *OutputConfig `protobuf:"bytes,2,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	// A filtering expression to specify restrictions on returned events.
	// The expression is a sequence of terms. Each term applies a restriction to
	// the returned user events. Use this expression to restrict results to a
	// specific time range or to filter events by eventType.
	// For example, `eventTime > "2012-04-23T18:25:43.511Z"
	// eventsMissingCatalogItems eventTime<"2012-04-23T18:25:43.511Z"
	// eventType=search`
	//
	//	We expect only three types of fields:
	//
	//	 * `eventTime`: This can be specified twice, once with a
	//	   less than operator and once with a greater than operator. The
	//	   `eventTime` restriction should result in one, contiguous, valid,
	//	   `eventTime` range.
	//
	//	 * `eventType`: Boolean operators `OR` and `NOT` are supported if the
	//	   expression is enclosed in parentheses and the operators are separated
	//	   from the tag values by a space.
	//
	//	 * `eventsMissingCatalogItems`: This restricts results
	//	   to events for which catalog items were not found in the catalog. The
	//	   default behavior is to return only those events for which catalog
	//	   items were found.
	//
	//	Some examples of valid filters expressions:
	//
	//	* Example 1: `eventTime > "2012-04-23T18:25:43.511Z"
	//	          eventTime < "2012-04-23T18:30:43.511Z"`
	//	* Example 2: `eventTime > "2012-04-23T18:25:43.511Z"
	//	          eventType = detail-page-view`
	//	* Example 3: `eventsMissingCatalogItems
	//	          eventType = (NOT search) eventTime <
	//	          "2018-04-23T18:30:43.511Z"`
	//	* Example 4: `eventTime > "2012-04-23T18:25:43.511Z"`
	//	* Example 5: `eventType = (detail-page-view OR search)`
	//	* Example 6: `eventsMissingCatalogItems`
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ExportUserEventsRequest) Reset() {
	*x = ExportUserEventsRequest{}
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportUserEventsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportUserEventsRequest) ProtoMessage() {}

func (x *ExportUserEventsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportUserEventsRequest.ProtoReflect.Descriptor instead.
func (*ExportUserEventsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_export_config_proto_rawDescGZIP(), []int{3}
}

func (x *ExportUserEventsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ExportUserEventsRequest) GetOutputConfig() *OutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

func (x *ExportUserEventsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Request message for the `ExportAnalyticsMetrics` method.
type ExportAnalyticsMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full resource name of the parent catalog.
	// Expected format: `projects/*/locations/*/catalogs/*`
	Catalog string `protobuf:"bytes,1,opt,name=catalog,proto3" json:"catalog,omitempty"`
	// Required. The output location of the data.
	OutputConfig *OutputConfig `protobuf:"bytes,2,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	// A filtering expression to specify restrictions on returned metrics.
	// The expression is a sequence of terms. Each term applies a restriction to
	// the returned metrics. Use this expression to restrict results to a
	// specific time range.
	//
	//	Currently we expect only one types of fields:
	//
	//	 * `timestamp`: This can be specified twice, once with a
	//	   less than operator and once with a greater than operator. The
	//	   `timestamp` restriction should result in one, contiguous, valid,
	//	   `timestamp` range.
	//
	//	Some examples of valid filters expressions:
	//
	//	* Example 1: `timestamp > "2012-04-23T18:25:43.511Z"
	//	          timestamp < "2012-04-23T18:30:43.511Z"`
	//	* Example 2: `timestamp > "2012-04-23T18:25:43.511Z"`
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ExportAnalyticsMetricsRequest) Reset() {
	*x = ExportAnalyticsMetricsRequest{}
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportAnalyticsMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportAnalyticsMetricsRequest) ProtoMessage() {}

func (x *ExportAnalyticsMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportAnalyticsMetricsRequest.ProtoReflect.Descriptor instead.
func (*ExportAnalyticsMetricsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_export_config_proto_rawDescGZIP(), []int{4}
}

func (x *ExportAnalyticsMetricsRequest) GetCatalog() string {
	if x != nil {
		return x.Catalog
	}
	return ""
}

func (x *ExportAnalyticsMetricsRequest) GetOutputConfig() *OutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

func (x *ExportAnalyticsMetricsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Metadata related to the progress of the Export operation. This is
// returned by the google.longrunning.Operation.metadata field.
type ExportMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation create time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Operation last update time. If the operation is done, this is also the
	// finish time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *ExportMetadata) Reset() {
	*x = ExportMetadata{}
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportMetadata) ProtoMessage() {}

func (x *ExportMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportMetadata.ProtoReflect.Descriptor instead.
func (*ExportMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_export_config_proto_rawDescGZIP(), []int{5}
}

func (x *ExportMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ExportMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Response of the ExportProductsRequest. If the long running
// operation is done, then this message is returned by the
// google.longrunning.Operations.response field if the operation was successful.
type ExportProductsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A sample of errors encountered while processing the request.
	ErrorSamples []*status.Status `protobuf:"bytes,1,rep,name=error_samples,json=errorSamples,proto3" json:"error_samples,omitempty"`
	// This field is never set.
	ErrorsConfig *ExportErrorsConfig `protobuf:"bytes,2,opt,name=errors_config,json=errorsConfig,proto3" json:"errors_config,omitempty"`
	// Output result indicating where the data were exported to.
	OutputResult *OutputResult `protobuf:"bytes,3,opt,name=output_result,json=outputResult,proto3" json:"output_result,omitempty"`
}

func (x *ExportProductsResponse) Reset() {
	*x = ExportProductsResponse{}
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportProductsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportProductsResponse) ProtoMessage() {}

func (x *ExportProductsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportProductsResponse.ProtoReflect.Descriptor instead.
func (*ExportProductsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_export_config_proto_rawDescGZIP(), []int{6}
}

func (x *ExportProductsResponse) GetErrorSamples() []*status.Status {
	if x != nil {
		return x.ErrorSamples
	}
	return nil
}

func (x *ExportProductsResponse) GetErrorsConfig() *ExportErrorsConfig {
	if x != nil {
		return x.ErrorsConfig
	}
	return nil
}

func (x *ExportProductsResponse) GetOutputResult() *OutputResult {
	if x != nil {
		return x.OutputResult
	}
	return nil
}

// Response of the ExportUserEventsRequest. If the long running
// operation was successful, then this message is returned by the
// google.longrunning.Operations.response field if the operation was successful.
type ExportUserEventsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A sample of errors encountered while processing the request.
	ErrorSamples []*status.Status `protobuf:"bytes,1,rep,name=error_samples,json=errorSamples,proto3" json:"error_samples,omitempty"`
	// This field is never set.
	ErrorsConfig *ExportErrorsConfig `protobuf:"bytes,2,opt,name=errors_config,json=errorsConfig,proto3" json:"errors_config,omitempty"`
	// Output result indicating where the data were exported to.
	OutputResult *OutputResult `protobuf:"bytes,3,opt,name=output_result,json=outputResult,proto3" json:"output_result,omitempty"`
}

func (x *ExportUserEventsResponse) Reset() {
	*x = ExportUserEventsResponse{}
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportUserEventsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportUserEventsResponse) ProtoMessage() {}

func (x *ExportUserEventsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportUserEventsResponse.ProtoReflect.Descriptor instead.
func (*ExportUserEventsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_export_config_proto_rawDescGZIP(), []int{7}
}

func (x *ExportUserEventsResponse) GetErrorSamples() []*status.Status {
	if x != nil {
		return x.ErrorSamples
	}
	return nil
}

func (x *ExportUserEventsResponse) GetErrorsConfig() *ExportErrorsConfig {
	if x != nil {
		return x.ErrorsConfig
	}
	return nil
}

func (x *ExportUserEventsResponse) GetOutputResult() *OutputResult {
	if x != nil {
		return x.OutputResult
	}
	return nil
}

// Response of the ExportAnalyticsMetricsRequest. If the long running
// operation was successful, then this message is returned by the
// google.longrunning.Operations.response field if the operation was successful.
type ExportAnalyticsMetricsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A sample of errors encountered while processing the request.
	ErrorSamples []*status.Status `protobuf:"bytes,1,rep,name=error_samples,json=errorSamples,proto3" json:"error_samples,omitempty"`
	// This field is never set.
	ErrorsConfig *ExportErrorsConfig `protobuf:"bytes,2,opt,name=errors_config,json=errorsConfig,proto3" json:"errors_config,omitempty"`
	// Output result indicating where the data were exported to.
	OutputResult *OutputResult `protobuf:"bytes,3,opt,name=output_result,json=outputResult,proto3" json:"output_result,omitempty"`
}

func (x *ExportAnalyticsMetricsResponse) Reset() {
	*x = ExportAnalyticsMetricsResponse{}
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportAnalyticsMetricsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportAnalyticsMetricsResponse) ProtoMessage() {}

func (x *ExportAnalyticsMetricsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportAnalyticsMetricsResponse.ProtoReflect.Descriptor instead.
func (*ExportAnalyticsMetricsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_export_config_proto_rawDescGZIP(), []int{8}
}

func (x *ExportAnalyticsMetricsResponse) GetErrorSamples() []*status.Status {
	if x != nil {
		return x.ErrorSamples
	}
	return nil
}

func (x *ExportAnalyticsMetricsResponse) GetErrorsConfig() *ExportErrorsConfig {
	if x != nil {
		return x.ErrorsConfig
	}
	return nil
}

func (x *ExportAnalyticsMetricsResponse) GetOutputResult() *OutputResult {
	if x != nil {
		return x.OutputResult
	}
	return nil
}

// Output result that stores the information about where the exported data is
// stored.
type OutputResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The BigQuery location where the result is stored.
	BigqueryResult []*BigQueryOutputResult `protobuf:"bytes,1,rep,name=bigquery_result,json=bigqueryResult,proto3" json:"bigquery_result,omitempty"`
	// The Google Cloud Storage location where the result is stored.
	GcsResult []*GcsOutputResult `protobuf:"bytes,2,rep,name=gcs_result,json=gcsResult,proto3" json:"gcs_result,omitempty"`
}

func (x *OutputResult) Reset() {
	*x = OutputResult{}
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OutputResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputResult) ProtoMessage() {}

func (x *OutputResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputResult.ProtoReflect.Descriptor instead.
func (*OutputResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_export_config_proto_rawDescGZIP(), []int{9}
}

func (x *OutputResult) GetBigqueryResult() []*BigQueryOutputResult {
	if x != nil {
		return x.BigqueryResult
	}
	return nil
}

func (x *OutputResult) GetGcsResult() []*GcsOutputResult {
	if x != nil {
		return x.GcsResult
	}
	return nil
}

// A BigQuery output result.
type BigQueryOutputResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of a BigQuery Dataset.
	DatasetId string `protobuf:"bytes,1,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// The ID of a BigQuery Table.
	TableId string `protobuf:"bytes,2,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
}

func (x *BigQueryOutputResult) Reset() {
	*x = BigQueryOutputResult{}
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BigQueryOutputResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryOutputResult) ProtoMessage() {}

func (x *BigQueryOutputResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryOutputResult.ProtoReflect.Descriptor instead.
func (*BigQueryOutputResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_export_config_proto_rawDescGZIP(), []int{10}
}

func (x *BigQueryOutputResult) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *BigQueryOutputResult) GetTableId() string {
	if x != nil {
		return x.TableId
	}
	return ""
}

// A Gcs output result.
type GcsOutputResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The uri of Gcs output
	OutputUri string `protobuf:"bytes,1,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
}

func (x *GcsOutputResult) Reset() {
	*x = GcsOutputResult{}
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GcsOutputResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsOutputResult) ProtoMessage() {}

func (x *GcsOutputResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsOutputResult.ProtoReflect.Descriptor instead.
func (*GcsOutputResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_export_config_proto_rawDescGZIP(), []int{11}
}

func (x *GcsOutputResult) GetOutputUri() string {
	if x != nil {
		return x.OutputUri
	}
	return ""
}

// The Google Cloud Storage output destination configuration.
type OutputConfig_GcsDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The output uri prefix for saving output data to json files.
	// Some mapping examples are as follows:
	// output_uri_prefix         sample output(assuming the object is foo.json)
	// ========================  =============================================
	// gs://bucket/              gs://bucket/foo.json
	// gs://bucket/folder/       gs://bucket/folder/foo.json
	// gs://bucket/folder/item_  gs://bucket/folder/item_foo.json
	OutputUriPrefix string `protobuf:"bytes,1,opt,name=output_uri_prefix,json=outputUriPrefix,proto3" json:"output_uri_prefix,omitempty"`
}

func (x *OutputConfig_GcsDestination) Reset() {
	*x = OutputConfig_GcsDestination{}
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OutputConfig_GcsDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputConfig_GcsDestination) ProtoMessage() {}

func (x *OutputConfig_GcsDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputConfig_GcsDestination.ProtoReflect.Descriptor instead.
func (*OutputConfig_GcsDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_export_config_proto_rawDescGZIP(), []int{0, 0}
}

func (x *OutputConfig_GcsDestination) GetOutputUriPrefix() string {
	if x != nil {
		return x.OutputUriPrefix
	}
	return ""
}

// The BigQuery output destination configuration.
type OutputConfig_BigQueryDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of a BigQuery Dataset.
	DatasetId string `protobuf:"bytes,1,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// Required. The prefix of exported BigQuery tables.
	TableIdPrefix string `protobuf:"bytes,2,opt,name=table_id_prefix,json=tableIdPrefix,proto3" json:"table_id_prefix,omitempty"`
	// Required. Describes the table type. The following values are supported:
	//
	// * `table`: A BigQuery native table.
	// * `view`: A virtual table defined by a SQL query.
	TableType string `protobuf:"bytes,3,opt,name=table_type,json=tableType,proto3" json:"table_type,omitempty"`
}

func (x *OutputConfig_BigQueryDestination) Reset() {
	*x = OutputConfig_BigQueryDestination{}
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OutputConfig_BigQueryDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputConfig_BigQueryDestination) ProtoMessage() {}

func (x *OutputConfig_BigQueryDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_export_config_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputConfig_BigQueryDestination.ProtoReflect.Descriptor instead.
func (*OutputConfig_BigQueryDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_export_config_proto_rawDescGZIP(), []int{0, 1}
}

func (x *OutputConfig_BigQueryDestination) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *OutputConfig_BigQueryDestination) GetTableIdPrefix() string {
	if x != nil {
		return x.TableIdPrefix
	}
	return ""
}

func (x *OutputConfig_BigQueryDestination) GetTableType() string {
	if x != nil {
		return x.TableType
	}
	return ""
}

var File_google_cloud_retail_v2beta_export_config_proto protoreflect.FileDescriptor

var file_google_cloud_retail_v2beta_export_config_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x65, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xc4, 0x03, 0x0a, 0x0c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x62, 0x0a, 0x0f, 0x67, 0x63, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0e, 0x67, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x71, 0x0a, 0x14, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x13, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x44,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x41, 0x0a, 0x0e, 0x47, 0x63,
	0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x11,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69,
	0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x1a, 0x8a, 0x01,
	0x0a, 0x13, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x0f, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x69, 0x64, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x64,
	0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x22, 0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x44, 0x0a, 0x12, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x1f, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xc1, 0x01, 0x0a, 0x15, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x1e, 0x0a, 0x1c, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x52, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x16, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x22, 0xc4, 0x01, 0x0a, 0x17, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x55, 0x73,
	0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x52,
	0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xaa, 0x01, 0x0a, 0x1d, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x07,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x07, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x12, 0x52, 0x0a, 0x0d, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x8a, 0x01, 0x0a, 0x0e, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x22, 0xf5, 0x01, 0x0a, 0x16, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x37, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12, 0x53, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4d, 0x0a,
	0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x0c,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0xf7, 0x01, 0x0a,
	0x18, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x0d, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x53, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x73, 0x12, 0x53, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4d, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0xfd, 0x01, 0x0a, 0x1e, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x0d, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x53, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x73, 0x12, 0x53, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4d, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0xb5, 0x01, 0x0a, 0x0c, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x59, 0x0a, 0x0f, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x69,
	0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x52, 0x0e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x4a, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x47, 0x63, 0x73, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x52, 0x09, 0x67, 0x63, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x50,
	0x0a, 0x14, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x64,
	0x22, 0x30, 0x0a, 0x0f, 0x47, 0x63, 0x73, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x55,
	0x72, 0x69, 0x42, 0xd0, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x42, 0x11, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x36, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x70, 0x62, 0x3b, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x70, 0x62, 0xa2, 0x02, 0x06, 0x52, 0x45, 0x54, 0x41, 0x49, 0x4c, 0xaa, 0x02, 0x1a, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x52, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x2e, 0x56, 0x32, 0x42, 0x65, 0x74, 0x61, 0xca, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x5c, 0x56,
	0x32, 0x62, 0x65, 0x74, 0x61, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x3a, 0x3a, 0x56,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_retail_v2beta_export_config_proto_rawDescOnce sync.Once
	file_google_cloud_retail_v2beta_export_config_proto_rawDescData = file_google_cloud_retail_v2beta_export_config_proto_rawDesc
)

func file_google_cloud_retail_v2beta_export_config_proto_rawDescGZIP() []byte {
	file_google_cloud_retail_v2beta_export_config_proto_rawDescOnce.Do(func() {
		file_google_cloud_retail_v2beta_export_config_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_retail_v2beta_export_config_proto_rawDescData)
	})
	return file_google_cloud_retail_v2beta_export_config_proto_rawDescData
}

var file_google_cloud_retail_v2beta_export_config_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_google_cloud_retail_v2beta_export_config_proto_goTypes = []any{
	(*OutputConfig)(nil),                     // 0: google.cloud.retail.v2beta.OutputConfig
	(*ExportErrorsConfig)(nil),               // 1: google.cloud.retail.v2beta.ExportErrorsConfig
	(*ExportProductsRequest)(nil),            // 2: google.cloud.retail.v2beta.ExportProductsRequest
	(*ExportUserEventsRequest)(nil),          // 3: google.cloud.retail.v2beta.ExportUserEventsRequest
	(*ExportAnalyticsMetricsRequest)(nil),    // 4: google.cloud.retail.v2beta.ExportAnalyticsMetricsRequest
	(*ExportMetadata)(nil),                   // 5: google.cloud.retail.v2beta.ExportMetadata
	(*ExportProductsResponse)(nil),           // 6: google.cloud.retail.v2beta.ExportProductsResponse
	(*ExportUserEventsResponse)(nil),         // 7: google.cloud.retail.v2beta.ExportUserEventsResponse
	(*ExportAnalyticsMetricsResponse)(nil),   // 8: google.cloud.retail.v2beta.ExportAnalyticsMetricsResponse
	(*OutputResult)(nil),                     // 9: google.cloud.retail.v2beta.OutputResult
	(*BigQueryOutputResult)(nil),             // 10: google.cloud.retail.v2beta.BigQueryOutputResult
	(*GcsOutputResult)(nil),                  // 11: google.cloud.retail.v2beta.GcsOutputResult
	(*OutputConfig_GcsDestination)(nil),      // 12: google.cloud.retail.v2beta.OutputConfig.GcsDestination
	(*OutputConfig_BigQueryDestination)(nil), // 13: google.cloud.retail.v2beta.OutputConfig.BigQueryDestination
	(*timestamppb.Timestamp)(nil),            // 14: google.protobuf.Timestamp
	(*status.Status)(nil),                    // 15: google.rpc.Status
}
var file_google_cloud_retail_v2beta_export_config_proto_depIdxs = []int32{
	12, // 0: google.cloud.retail.v2beta.OutputConfig.gcs_destination:type_name -> google.cloud.retail.v2beta.OutputConfig.GcsDestination
	13, // 1: google.cloud.retail.v2beta.OutputConfig.bigquery_destination:type_name -> google.cloud.retail.v2beta.OutputConfig.BigQueryDestination
	0,  // 2: google.cloud.retail.v2beta.ExportProductsRequest.output_config:type_name -> google.cloud.retail.v2beta.OutputConfig
	0,  // 3: google.cloud.retail.v2beta.ExportUserEventsRequest.output_config:type_name -> google.cloud.retail.v2beta.OutputConfig
	0,  // 4: google.cloud.retail.v2beta.ExportAnalyticsMetricsRequest.output_config:type_name -> google.cloud.retail.v2beta.OutputConfig
	14, // 5: google.cloud.retail.v2beta.ExportMetadata.create_time:type_name -> google.protobuf.Timestamp
	14, // 6: google.cloud.retail.v2beta.ExportMetadata.update_time:type_name -> google.protobuf.Timestamp
	15, // 7: google.cloud.retail.v2beta.ExportProductsResponse.error_samples:type_name -> google.rpc.Status
	1,  // 8: google.cloud.retail.v2beta.ExportProductsResponse.errors_config:type_name -> google.cloud.retail.v2beta.ExportErrorsConfig
	9,  // 9: google.cloud.retail.v2beta.ExportProductsResponse.output_result:type_name -> google.cloud.retail.v2beta.OutputResult
	15, // 10: google.cloud.retail.v2beta.ExportUserEventsResponse.error_samples:type_name -> google.rpc.Status
	1,  // 11: google.cloud.retail.v2beta.ExportUserEventsResponse.errors_config:type_name -> google.cloud.retail.v2beta.ExportErrorsConfig
	9,  // 12: google.cloud.retail.v2beta.ExportUserEventsResponse.output_result:type_name -> google.cloud.retail.v2beta.OutputResult
	15, // 13: google.cloud.retail.v2beta.ExportAnalyticsMetricsResponse.error_samples:type_name -> google.rpc.Status
	1,  // 14: google.cloud.retail.v2beta.ExportAnalyticsMetricsResponse.errors_config:type_name -> google.cloud.retail.v2beta.ExportErrorsConfig
	9,  // 15: google.cloud.retail.v2beta.ExportAnalyticsMetricsResponse.output_result:type_name -> google.cloud.retail.v2beta.OutputResult
	10, // 16: google.cloud.retail.v2beta.OutputResult.bigquery_result:type_name -> google.cloud.retail.v2beta.BigQueryOutputResult
	11, // 17: google.cloud.retail.v2beta.OutputResult.gcs_result:type_name -> google.cloud.retail.v2beta.GcsOutputResult
	18, // [18:18] is the sub-list for method output_type
	18, // [18:18] is the sub-list for method input_type
	18, // [18:18] is the sub-list for extension type_name
	18, // [18:18] is the sub-list for extension extendee
	0,  // [0:18] is the sub-list for field type_name
}

func init() { file_google_cloud_retail_v2beta_export_config_proto_init() }
func file_google_cloud_retail_v2beta_export_config_proto_init() {
	if File_google_cloud_retail_v2beta_export_config_proto != nil {
		return
	}
	file_google_cloud_retail_v2beta_export_config_proto_msgTypes[0].OneofWrappers = []any{
		(*OutputConfig_GcsDestination_)(nil),
		(*OutputConfig_BigqueryDestination)(nil),
	}
	file_google_cloud_retail_v2beta_export_config_proto_msgTypes[1].OneofWrappers = []any{
		(*ExportErrorsConfig_GcsPrefix)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_retail_v2beta_export_config_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_retail_v2beta_export_config_proto_goTypes,
		DependencyIndexes: file_google_cloud_retail_v2beta_export_config_proto_depIdxs,
		MessageInfos:      file_google_cloud_retail_v2beta_export_config_proto_msgTypes,
	}.Build()
	File_google_cloud_retail_v2beta_export_config_proto = out.File
	file_google_cloud_retail_v2beta_export_config_proto_rawDesc = nil
	file_google_cloud_retail_v2beta_export_config_proto_goTypes = nil
	file_google_cloud_retail_v2beta_export_config_proto_depIdxs = nil
}
