// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package netapp

import (
	"bytes"
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/http"
	"net/url"
	"time"

	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	netapppb "cloud.google.com/go/netapp/apiv1/netapppb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	locationpb "google.golang.org/genproto/googleapis/cloud/location"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newClientHook clientHook

// CallOptions contains the retry settings for each method of Client.
type CallOptions struct {
	ListStoragePools            []gax.CallOption
	CreateStoragePool           []gax.CallOption
	GetStoragePool              []gax.CallOption
	UpdateStoragePool           []gax.CallOption
	DeleteStoragePool           []gax.CallOption
	ValidateDirectoryService    []gax.CallOption
	SwitchActiveReplicaZone     []gax.CallOption
	ListVolumes                 []gax.CallOption
	GetVolume                   []gax.CallOption
	CreateVolume                []gax.CallOption
	UpdateVolume                []gax.CallOption
	DeleteVolume                []gax.CallOption
	RevertVolume                []gax.CallOption
	ListSnapshots               []gax.CallOption
	GetSnapshot                 []gax.CallOption
	CreateSnapshot              []gax.CallOption
	DeleteSnapshot              []gax.CallOption
	UpdateSnapshot              []gax.CallOption
	ListActiveDirectories       []gax.CallOption
	GetActiveDirectory          []gax.CallOption
	CreateActiveDirectory       []gax.CallOption
	UpdateActiveDirectory       []gax.CallOption
	DeleteActiveDirectory       []gax.CallOption
	ListKmsConfigs              []gax.CallOption
	CreateKmsConfig             []gax.CallOption
	GetKmsConfig                []gax.CallOption
	UpdateKmsConfig             []gax.CallOption
	EncryptVolumes              []gax.CallOption
	VerifyKmsConfig             []gax.CallOption
	DeleteKmsConfig             []gax.CallOption
	ListReplications            []gax.CallOption
	GetReplication              []gax.CallOption
	CreateReplication           []gax.CallOption
	DeleteReplication           []gax.CallOption
	UpdateReplication           []gax.CallOption
	StopReplication             []gax.CallOption
	ResumeReplication           []gax.CallOption
	ReverseReplicationDirection []gax.CallOption
	EstablishPeering            []gax.CallOption
	SyncReplication             []gax.CallOption
	CreateBackupVault           []gax.CallOption
	GetBackupVault              []gax.CallOption
	ListBackupVaults            []gax.CallOption
	UpdateBackupVault           []gax.CallOption
	DeleteBackupVault           []gax.CallOption
	CreateBackup                []gax.CallOption
	GetBackup                   []gax.CallOption
	ListBackups                 []gax.CallOption
	DeleteBackup                []gax.CallOption
	UpdateBackup                []gax.CallOption
	CreateBackupPolicy          []gax.CallOption
	GetBackupPolicy             []gax.CallOption
	ListBackupPolicies          []gax.CallOption
	UpdateBackupPolicy          []gax.CallOption
	DeleteBackupPolicy          []gax.CallOption
	ListQuotaRules              []gax.CallOption
	GetQuotaRule                []gax.CallOption
	CreateQuotaRule             []gax.CallOption
	UpdateQuotaRule             []gax.CallOption
	DeleteQuotaRule             []gax.CallOption
	GetLocation                 []gax.CallOption
	ListLocations               []gax.CallOption
	CancelOperation             []gax.CallOption
	DeleteOperation             []gax.CallOption
	GetOperation                []gax.CallOption
	ListOperations              []gax.CallOption
}

func defaultGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("netapp.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("netapp.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("netapp.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://netapp.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultCallOptions() *CallOptions {
	return &CallOptions{
		ListStoragePools: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateStoragePool: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetStoragePool: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateStoragePool: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteStoragePool: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ValidateDirectoryService: []gax.CallOption{},
		SwitchActiveReplicaZone:  []gax.CallOption{},
		ListVolumes: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RevertVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListSnapshots: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetSnapshot: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateSnapshot: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteSnapshot: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateSnapshot: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListActiveDirectories: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetActiveDirectory: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateActiveDirectory: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateActiveDirectory: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteActiveDirectory: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListKmsConfigs: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateKmsConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetKmsConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateKmsConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		EncryptVolumes: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		VerifyKmsConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteKmsConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListReplications: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetReplication: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateReplication: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteReplication: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateReplication: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		StopReplication: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ResumeReplication: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ReverseReplicationDirection: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		EstablishPeering: []gax.CallOption{},
		SyncReplication:  []gax.CallOption{},
		CreateBackupVault: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetBackupVault: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListBackupVaults: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateBackupVault: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteBackupVault: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateBackup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetBackup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListBackups: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteBackup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateBackup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateBackupPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetBackupPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListBackupPolicies: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateBackupPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteBackupPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListQuotaRules:  []gax.CallOption{},
		GetQuotaRule:    []gax.CallOption{},
		CreateQuotaRule: []gax.CallOption{},
		UpdateQuotaRule: []gax.CallOption{},
		DeleteQuotaRule: []gax.CallOption{},
		GetLocation:     []gax.CallOption{},
		ListLocations:   []gax.CallOption{},
		CancelOperation: []gax.CallOption{},
		DeleteOperation: []gax.CallOption{},
		GetOperation:    []gax.CallOption{},
		ListOperations:  []gax.CallOption{},
	}
}

func defaultRESTCallOptions() *CallOptions {
	return &CallOptions{
		ListStoragePools: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		CreateStoragePool: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetStoragePool: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		UpdateStoragePool: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteStoragePool: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ValidateDirectoryService: []gax.CallOption{},
		SwitchActiveReplicaZone:  []gax.CallOption{},
		ListVolumes: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		CreateVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RevertVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListSnapshots: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetSnapshot: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		CreateSnapshot: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteSnapshot: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateSnapshot: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListActiveDirectories: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetActiveDirectory: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		CreateActiveDirectory: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateActiveDirectory: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteActiveDirectory: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListKmsConfigs: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		CreateKmsConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetKmsConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		UpdateKmsConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		EncryptVolumes: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		VerifyKmsConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteKmsConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListReplications: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetReplication: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		CreateReplication: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteReplication: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateReplication: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		StopReplication: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ResumeReplication: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ReverseReplicationDirection: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		EstablishPeering: []gax.CallOption{},
		SyncReplication:  []gax.CallOption{},
		CreateBackupVault: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetBackupVault: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ListBackupVaults: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		UpdateBackupVault: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteBackupVault: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateBackup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetBackup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ListBackups: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		DeleteBackup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateBackup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateBackupPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetBackupPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ListBackupPolicies: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		UpdateBackupPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteBackupPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListQuotaRules:  []gax.CallOption{},
		GetQuotaRule:    []gax.CallOption{},
		CreateQuotaRule: []gax.CallOption{},
		UpdateQuotaRule: []gax.CallOption{},
		DeleteQuotaRule: []gax.CallOption{},
		GetLocation:     []gax.CallOption{},
		ListLocations:   []gax.CallOption{},
		CancelOperation: []gax.CallOption{},
		DeleteOperation: []gax.CallOption{},
		GetOperation:    []gax.CallOption{},
		ListOperations:  []gax.CallOption{},
	}
}

// internalClient is an interface that defines the methods available from NetApp API.
type internalClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListStoragePools(context.Context, *netapppb.ListStoragePoolsRequest, ...gax.CallOption) *StoragePoolIterator
	CreateStoragePool(context.Context, *netapppb.CreateStoragePoolRequest, ...gax.CallOption) (*CreateStoragePoolOperation, error)
	CreateStoragePoolOperation(name string) *CreateStoragePoolOperation
	GetStoragePool(context.Context, *netapppb.GetStoragePoolRequest, ...gax.CallOption) (*netapppb.StoragePool, error)
	UpdateStoragePool(context.Context, *netapppb.UpdateStoragePoolRequest, ...gax.CallOption) (*UpdateStoragePoolOperation, error)
	UpdateStoragePoolOperation(name string) *UpdateStoragePoolOperation
	DeleteStoragePool(context.Context, *netapppb.DeleteStoragePoolRequest, ...gax.CallOption) (*DeleteStoragePoolOperation, error)
	DeleteStoragePoolOperation(name string) *DeleteStoragePoolOperation
	ValidateDirectoryService(context.Context, *netapppb.ValidateDirectoryServiceRequest, ...gax.CallOption) (*ValidateDirectoryServiceOperation, error)
	ValidateDirectoryServiceOperation(name string) *ValidateDirectoryServiceOperation
	SwitchActiveReplicaZone(context.Context, *netapppb.SwitchActiveReplicaZoneRequest, ...gax.CallOption) (*SwitchActiveReplicaZoneOperation, error)
	SwitchActiveReplicaZoneOperation(name string) *SwitchActiveReplicaZoneOperation
	ListVolumes(context.Context, *netapppb.ListVolumesRequest, ...gax.CallOption) *VolumeIterator
	GetVolume(context.Context, *netapppb.GetVolumeRequest, ...gax.CallOption) (*netapppb.Volume, error)
	CreateVolume(context.Context, *netapppb.CreateVolumeRequest, ...gax.CallOption) (*CreateVolumeOperation, error)
	CreateVolumeOperation(name string) *CreateVolumeOperation
	UpdateVolume(context.Context, *netapppb.UpdateVolumeRequest, ...gax.CallOption) (*UpdateVolumeOperation, error)
	UpdateVolumeOperation(name string) *UpdateVolumeOperation
	DeleteVolume(context.Context, *netapppb.DeleteVolumeRequest, ...gax.CallOption) (*DeleteVolumeOperation, error)
	DeleteVolumeOperation(name string) *DeleteVolumeOperation
	RevertVolume(context.Context, *netapppb.RevertVolumeRequest, ...gax.CallOption) (*RevertVolumeOperation, error)
	RevertVolumeOperation(name string) *RevertVolumeOperation
	ListSnapshots(context.Context, *netapppb.ListSnapshotsRequest, ...gax.CallOption) *SnapshotIterator
	GetSnapshot(context.Context, *netapppb.GetSnapshotRequest, ...gax.CallOption) (*netapppb.Snapshot, error)
	CreateSnapshot(context.Context, *netapppb.CreateSnapshotRequest, ...gax.CallOption) (*CreateSnapshotOperation, error)
	CreateSnapshotOperation(name string) *CreateSnapshotOperation
	DeleteSnapshot(context.Context, *netapppb.DeleteSnapshotRequest, ...gax.CallOption) (*DeleteSnapshotOperation, error)
	DeleteSnapshotOperation(name string) *DeleteSnapshotOperation
	UpdateSnapshot(context.Context, *netapppb.UpdateSnapshotRequest, ...gax.CallOption) (*UpdateSnapshotOperation, error)
	UpdateSnapshotOperation(name string) *UpdateSnapshotOperation
	ListActiveDirectories(context.Context, *netapppb.ListActiveDirectoriesRequest, ...gax.CallOption) *ActiveDirectoryIterator
	GetActiveDirectory(context.Context, *netapppb.GetActiveDirectoryRequest, ...gax.CallOption) (*netapppb.ActiveDirectory, error)
	CreateActiveDirectory(context.Context, *netapppb.CreateActiveDirectoryRequest, ...gax.CallOption) (*CreateActiveDirectoryOperation, error)
	CreateActiveDirectoryOperation(name string) *CreateActiveDirectoryOperation
	UpdateActiveDirectory(context.Context, *netapppb.UpdateActiveDirectoryRequest, ...gax.CallOption) (*UpdateActiveDirectoryOperation, error)
	UpdateActiveDirectoryOperation(name string) *UpdateActiveDirectoryOperation
	DeleteActiveDirectory(context.Context, *netapppb.DeleteActiveDirectoryRequest, ...gax.CallOption) (*DeleteActiveDirectoryOperation, error)
	DeleteActiveDirectoryOperation(name string) *DeleteActiveDirectoryOperation
	ListKmsConfigs(context.Context, *netapppb.ListKmsConfigsRequest, ...gax.CallOption) *KmsConfigIterator
	CreateKmsConfig(context.Context, *netapppb.CreateKmsConfigRequest, ...gax.CallOption) (*CreateKmsConfigOperation, error)
	CreateKmsConfigOperation(name string) *CreateKmsConfigOperation
	GetKmsConfig(context.Context, *netapppb.GetKmsConfigRequest, ...gax.CallOption) (*netapppb.KmsConfig, error)
	UpdateKmsConfig(context.Context, *netapppb.UpdateKmsConfigRequest, ...gax.CallOption) (*UpdateKmsConfigOperation, error)
	UpdateKmsConfigOperation(name string) *UpdateKmsConfigOperation
	EncryptVolumes(context.Context, *netapppb.EncryptVolumesRequest, ...gax.CallOption) (*EncryptVolumesOperation, error)
	EncryptVolumesOperation(name string) *EncryptVolumesOperation
	VerifyKmsConfig(context.Context, *netapppb.VerifyKmsConfigRequest, ...gax.CallOption) (*netapppb.VerifyKmsConfigResponse, error)
	DeleteKmsConfig(context.Context, *netapppb.DeleteKmsConfigRequest, ...gax.CallOption) (*DeleteKmsConfigOperation, error)
	DeleteKmsConfigOperation(name string) *DeleteKmsConfigOperation
	ListReplications(context.Context, *netapppb.ListReplicationsRequest, ...gax.CallOption) *ReplicationIterator
	GetReplication(context.Context, *netapppb.GetReplicationRequest, ...gax.CallOption) (*netapppb.Replication, error)
	CreateReplication(context.Context, *netapppb.CreateReplicationRequest, ...gax.CallOption) (*CreateReplicationOperation, error)
	CreateReplicationOperation(name string) *CreateReplicationOperation
	DeleteReplication(context.Context, *netapppb.DeleteReplicationRequest, ...gax.CallOption) (*DeleteReplicationOperation, error)
	DeleteReplicationOperation(name string) *DeleteReplicationOperation
	UpdateReplication(context.Context, *netapppb.UpdateReplicationRequest, ...gax.CallOption) (*UpdateReplicationOperation, error)
	UpdateReplicationOperation(name string) *UpdateReplicationOperation
	StopReplication(context.Context, *netapppb.StopReplicationRequest, ...gax.CallOption) (*StopReplicationOperation, error)
	StopReplicationOperation(name string) *StopReplicationOperation
	ResumeReplication(context.Context, *netapppb.ResumeReplicationRequest, ...gax.CallOption) (*ResumeReplicationOperation, error)
	ResumeReplicationOperation(name string) *ResumeReplicationOperation
	ReverseReplicationDirection(context.Context, *netapppb.ReverseReplicationDirectionRequest, ...gax.CallOption) (*ReverseReplicationDirectionOperation, error)
	ReverseReplicationDirectionOperation(name string) *ReverseReplicationDirectionOperation
	EstablishPeering(context.Context, *netapppb.EstablishPeeringRequest, ...gax.CallOption) (*EstablishPeeringOperation, error)
	EstablishPeeringOperation(name string) *EstablishPeeringOperation
	SyncReplication(context.Context, *netapppb.SyncReplicationRequest, ...gax.CallOption) (*SyncReplicationOperation, error)
	SyncReplicationOperation(name string) *SyncReplicationOperation
	CreateBackupVault(context.Context, *netapppb.CreateBackupVaultRequest, ...gax.CallOption) (*CreateBackupVaultOperation, error)
	CreateBackupVaultOperation(name string) *CreateBackupVaultOperation
	GetBackupVault(context.Context, *netapppb.GetBackupVaultRequest, ...gax.CallOption) (*netapppb.BackupVault, error)
	ListBackupVaults(context.Context, *netapppb.ListBackupVaultsRequest, ...gax.CallOption) *BackupVaultIterator
	UpdateBackupVault(context.Context, *netapppb.UpdateBackupVaultRequest, ...gax.CallOption) (*UpdateBackupVaultOperation, error)
	UpdateBackupVaultOperation(name string) *UpdateBackupVaultOperation
	DeleteBackupVault(context.Context, *netapppb.DeleteBackupVaultRequest, ...gax.CallOption) (*DeleteBackupVaultOperation, error)
	DeleteBackupVaultOperation(name string) *DeleteBackupVaultOperation
	CreateBackup(context.Context, *netapppb.CreateBackupRequest, ...gax.CallOption) (*CreateBackupOperation, error)
	CreateBackupOperation(name string) *CreateBackupOperation
	GetBackup(context.Context, *netapppb.GetBackupRequest, ...gax.CallOption) (*netapppb.Backup, error)
	ListBackups(context.Context, *netapppb.ListBackupsRequest, ...gax.CallOption) *BackupIterator
	DeleteBackup(context.Context, *netapppb.DeleteBackupRequest, ...gax.CallOption) (*DeleteBackupOperation, error)
	DeleteBackupOperation(name string) *DeleteBackupOperation
	UpdateBackup(context.Context, *netapppb.UpdateBackupRequest, ...gax.CallOption) (*UpdateBackupOperation, error)
	UpdateBackupOperation(name string) *UpdateBackupOperation
	CreateBackupPolicy(context.Context, *netapppb.CreateBackupPolicyRequest, ...gax.CallOption) (*CreateBackupPolicyOperation, error)
	CreateBackupPolicyOperation(name string) *CreateBackupPolicyOperation
	GetBackupPolicy(context.Context, *netapppb.GetBackupPolicyRequest, ...gax.CallOption) (*netapppb.BackupPolicy, error)
	ListBackupPolicies(context.Context, *netapppb.ListBackupPoliciesRequest, ...gax.CallOption) *BackupPolicyIterator
	UpdateBackupPolicy(context.Context, *netapppb.UpdateBackupPolicyRequest, ...gax.CallOption) (*UpdateBackupPolicyOperation, error)
	UpdateBackupPolicyOperation(name string) *UpdateBackupPolicyOperation
	DeleteBackupPolicy(context.Context, *netapppb.DeleteBackupPolicyRequest, ...gax.CallOption) (*DeleteBackupPolicyOperation, error)
	DeleteBackupPolicyOperation(name string) *DeleteBackupPolicyOperation
	ListQuotaRules(context.Context, *netapppb.ListQuotaRulesRequest, ...gax.CallOption) *QuotaRuleIterator
	GetQuotaRule(context.Context, *netapppb.GetQuotaRuleRequest, ...gax.CallOption) (*netapppb.QuotaRule, error)
	CreateQuotaRule(context.Context, *netapppb.CreateQuotaRuleRequest, ...gax.CallOption) (*CreateQuotaRuleOperation, error)
	CreateQuotaRuleOperation(name string) *CreateQuotaRuleOperation
	UpdateQuotaRule(context.Context, *netapppb.UpdateQuotaRuleRequest, ...gax.CallOption) (*UpdateQuotaRuleOperation, error)
	UpdateQuotaRuleOperation(name string) *UpdateQuotaRuleOperation
	DeleteQuotaRule(context.Context, *netapppb.DeleteQuotaRuleRequest, ...gax.CallOption) (*DeleteQuotaRuleOperation, error)
	DeleteQuotaRuleOperation(name string) *DeleteQuotaRuleOperation
	GetLocation(context.Context, *locationpb.GetLocationRequest, ...gax.CallOption) (*locationpb.Location, error)
	ListLocations(context.Context, *locationpb.ListLocationsRequest, ...gax.CallOption) *LocationIterator
	CancelOperation(context.Context, *longrunningpb.CancelOperationRequest, ...gax.CallOption) error
	DeleteOperation(context.Context, *longrunningpb.DeleteOperationRequest, ...gax.CallOption) error
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
	ListOperations(context.Context, *longrunningpb.ListOperationsRequest, ...gax.CallOption) *OperationIterator
}

// Client is a client for interacting with NetApp API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// NetApp Files Google Cloud Service
type Client struct {
	// The internal transport-dependent client.
	internalClient internalClient

	// The call options for this service.
	CallOptions *CallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *Client) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *Client) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *Client) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListStoragePools returns descriptions of all storage pools owned by the caller.
func (c *Client) ListStoragePools(ctx context.Context, req *netapppb.ListStoragePoolsRequest, opts ...gax.CallOption) *StoragePoolIterator {
	return c.internalClient.ListStoragePools(ctx, req, opts...)
}

// CreateStoragePool creates a new storage pool.
func (c *Client) CreateStoragePool(ctx context.Context, req *netapppb.CreateStoragePoolRequest, opts ...gax.CallOption) (*CreateStoragePoolOperation, error) {
	return c.internalClient.CreateStoragePool(ctx, req, opts...)
}

// CreateStoragePoolOperation returns a new CreateStoragePoolOperation from a given name.
// The name must be that of a previously created CreateStoragePoolOperation, possibly from a different process.
func (c *Client) CreateStoragePoolOperation(name string) *CreateStoragePoolOperation {
	return c.internalClient.CreateStoragePoolOperation(name)
}

// GetStoragePool returns the description of the specified storage pool by poolId.
func (c *Client) GetStoragePool(ctx context.Context, req *netapppb.GetStoragePoolRequest, opts ...gax.CallOption) (*netapppb.StoragePool, error) {
	return c.internalClient.GetStoragePool(ctx, req, opts...)
}

// UpdateStoragePool updates the storage pool properties with the full spec
func (c *Client) UpdateStoragePool(ctx context.Context, req *netapppb.UpdateStoragePoolRequest, opts ...gax.CallOption) (*UpdateStoragePoolOperation, error) {
	return c.internalClient.UpdateStoragePool(ctx, req, opts...)
}

// UpdateStoragePoolOperation returns a new UpdateStoragePoolOperation from a given name.
// The name must be that of a previously created UpdateStoragePoolOperation, possibly from a different process.
func (c *Client) UpdateStoragePoolOperation(name string) *UpdateStoragePoolOperation {
	return c.internalClient.UpdateStoragePoolOperation(name)
}

// DeleteStoragePool warning! This operation will permanently delete the storage pool.
func (c *Client) DeleteStoragePool(ctx context.Context, req *netapppb.DeleteStoragePoolRequest, opts ...gax.CallOption) (*DeleteStoragePoolOperation, error) {
	return c.internalClient.DeleteStoragePool(ctx, req, opts...)
}

// DeleteStoragePoolOperation returns a new DeleteStoragePoolOperation from a given name.
// The name must be that of a previously created DeleteStoragePoolOperation, possibly from a different process.
func (c *Client) DeleteStoragePoolOperation(name string) *DeleteStoragePoolOperation {
	return c.internalClient.DeleteStoragePoolOperation(name)
}

// ValidateDirectoryService validateDirectoryService does a connectivity check for a directory service
// policy attached to the storage pool.
func (c *Client) ValidateDirectoryService(ctx context.Context, req *netapppb.ValidateDirectoryServiceRequest, opts ...gax.CallOption) (*ValidateDirectoryServiceOperation, error) {
	return c.internalClient.ValidateDirectoryService(ctx, req, opts...)
}

// ValidateDirectoryServiceOperation returns a new ValidateDirectoryServiceOperation from a given name.
// The name must be that of a previously created ValidateDirectoryServiceOperation, possibly from a different process.
func (c *Client) ValidateDirectoryServiceOperation(name string) *ValidateDirectoryServiceOperation {
	return c.internalClient.ValidateDirectoryServiceOperation(name)
}

// SwitchActiveReplicaZone this operation will switch the active/replica zone for a regional
// storagePool.
func (c *Client) SwitchActiveReplicaZone(ctx context.Context, req *netapppb.SwitchActiveReplicaZoneRequest, opts ...gax.CallOption) (*SwitchActiveReplicaZoneOperation, error) {
	return c.internalClient.SwitchActiveReplicaZone(ctx, req, opts...)
}

// SwitchActiveReplicaZoneOperation returns a new SwitchActiveReplicaZoneOperation from a given name.
// The name must be that of a previously created SwitchActiveReplicaZoneOperation, possibly from a different process.
func (c *Client) SwitchActiveReplicaZoneOperation(name string) *SwitchActiveReplicaZoneOperation {
	return c.internalClient.SwitchActiveReplicaZoneOperation(name)
}

// ListVolumes lists Volumes in a given project.
func (c *Client) ListVolumes(ctx context.Context, req *netapppb.ListVolumesRequest, opts ...gax.CallOption) *VolumeIterator {
	return c.internalClient.ListVolumes(ctx, req, opts...)
}

// GetVolume gets details of a single Volume.
func (c *Client) GetVolume(ctx context.Context, req *netapppb.GetVolumeRequest, opts ...gax.CallOption) (*netapppb.Volume, error) {
	return c.internalClient.GetVolume(ctx, req, opts...)
}

// CreateVolume creates a new Volume in a given project and location.
func (c *Client) CreateVolume(ctx context.Context, req *netapppb.CreateVolumeRequest, opts ...gax.CallOption) (*CreateVolumeOperation, error) {
	return c.internalClient.CreateVolume(ctx, req, opts...)
}

// CreateVolumeOperation returns a new CreateVolumeOperation from a given name.
// The name must be that of a previously created CreateVolumeOperation, possibly from a different process.
func (c *Client) CreateVolumeOperation(name string) *CreateVolumeOperation {
	return c.internalClient.CreateVolumeOperation(name)
}

// UpdateVolume updates the parameters of a single Volume.
func (c *Client) UpdateVolume(ctx context.Context, req *netapppb.UpdateVolumeRequest, opts ...gax.CallOption) (*UpdateVolumeOperation, error) {
	return c.internalClient.UpdateVolume(ctx, req, opts...)
}

// UpdateVolumeOperation returns a new UpdateVolumeOperation from a given name.
// The name must be that of a previously created UpdateVolumeOperation, possibly from a different process.
func (c *Client) UpdateVolumeOperation(name string) *UpdateVolumeOperation {
	return c.internalClient.UpdateVolumeOperation(name)
}

// DeleteVolume deletes a single Volume.
func (c *Client) DeleteVolume(ctx context.Context, req *netapppb.DeleteVolumeRequest, opts ...gax.CallOption) (*DeleteVolumeOperation, error) {
	return c.internalClient.DeleteVolume(ctx, req, opts...)
}

// DeleteVolumeOperation returns a new DeleteVolumeOperation from a given name.
// The name must be that of a previously created DeleteVolumeOperation, possibly from a different process.
func (c *Client) DeleteVolumeOperation(name string) *DeleteVolumeOperation {
	return c.internalClient.DeleteVolumeOperation(name)
}

// RevertVolume revert an existing volume to a specified snapshot.
// Warning! This operation will permanently revert all changes made after the
// snapshot was created.
func (c *Client) RevertVolume(ctx context.Context, req *netapppb.RevertVolumeRequest, opts ...gax.CallOption) (*RevertVolumeOperation, error) {
	return c.internalClient.RevertVolume(ctx, req, opts...)
}

// RevertVolumeOperation returns a new RevertVolumeOperation from a given name.
// The name must be that of a previously created RevertVolumeOperation, possibly from a different process.
func (c *Client) RevertVolumeOperation(name string) *RevertVolumeOperation {
	return c.internalClient.RevertVolumeOperation(name)
}

// ListSnapshots returns descriptions of all snapshots for a volume.
func (c *Client) ListSnapshots(ctx context.Context, req *netapppb.ListSnapshotsRequest, opts ...gax.CallOption) *SnapshotIterator {
	return c.internalClient.ListSnapshots(ctx, req, opts...)
}

// GetSnapshot describe a snapshot for a volume.
func (c *Client) GetSnapshot(ctx context.Context, req *netapppb.GetSnapshotRequest, opts ...gax.CallOption) (*netapppb.Snapshot, error) {
	return c.internalClient.GetSnapshot(ctx, req, opts...)
}

// CreateSnapshot create a new snapshot for a volume.
func (c *Client) CreateSnapshot(ctx context.Context, req *netapppb.CreateSnapshotRequest, opts ...gax.CallOption) (*CreateSnapshotOperation, error) {
	return c.internalClient.CreateSnapshot(ctx, req, opts...)
}

// CreateSnapshotOperation returns a new CreateSnapshotOperation from a given name.
// The name must be that of a previously created CreateSnapshotOperation, possibly from a different process.
func (c *Client) CreateSnapshotOperation(name string) *CreateSnapshotOperation {
	return c.internalClient.CreateSnapshotOperation(name)
}

// DeleteSnapshot deletes a snapshot.
func (c *Client) DeleteSnapshot(ctx context.Context, req *netapppb.DeleteSnapshotRequest, opts ...gax.CallOption) (*DeleteSnapshotOperation, error) {
	return c.internalClient.DeleteSnapshot(ctx, req, opts...)
}

// DeleteSnapshotOperation returns a new DeleteSnapshotOperation from a given name.
// The name must be that of a previously created DeleteSnapshotOperation, possibly from a different process.
func (c *Client) DeleteSnapshotOperation(name string) *DeleteSnapshotOperation {
	return c.internalClient.DeleteSnapshotOperation(name)
}

// UpdateSnapshot updates the settings of a specific snapshot.
func (c *Client) UpdateSnapshot(ctx context.Context, req *netapppb.UpdateSnapshotRequest, opts ...gax.CallOption) (*UpdateSnapshotOperation, error) {
	return c.internalClient.UpdateSnapshot(ctx, req, opts...)
}

// UpdateSnapshotOperation returns a new UpdateSnapshotOperation from a given name.
// The name must be that of a previously created UpdateSnapshotOperation, possibly from a different process.
func (c *Client) UpdateSnapshotOperation(name string) *UpdateSnapshotOperation {
	return c.internalClient.UpdateSnapshotOperation(name)
}

// ListActiveDirectories lists active directories.
func (c *Client) ListActiveDirectories(ctx context.Context, req *netapppb.ListActiveDirectoriesRequest, opts ...gax.CallOption) *ActiveDirectoryIterator {
	return c.internalClient.ListActiveDirectories(ctx, req, opts...)
}

// GetActiveDirectory describes a specified active directory.
func (c *Client) GetActiveDirectory(ctx context.Context, req *netapppb.GetActiveDirectoryRequest, opts ...gax.CallOption) (*netapppb.ActiveDirectory, error) {
	return c.internalClient.GetActiveDirectory(ctx, req, opts...)
}

// CreateActiveDirectory createActiveDirectory
// Creates the active directory specified in the request.
func (c *Client) CreateActiveDirectory(ctx context.Context, req *netapppb.CreateActiveDirectoryRequest, opts ...gax.CallOption) (*CreateActiveDirectoryOperation, error) {
	return c.internalClient.CreateActiveDirectory(ctx, req, opts...)
}

// CreateActiveDirectoryOperation returns a new CreateActiveDirectoryOperation from a given name.
// The name must be that of a previously created CreateActiveDirectoryOperation, possibly from a different process.
func (c *Client) CreateActiveDirectoryOperation(name string) *CreateActiveDirectoryOperation {
	return c.internalClient.CreateActiveDirectoryOperation(name)
}

// UpdateActiveDirectory update the parameters of an active directories.
func (c *Client) UpdateActiveDirectory(ctx context.Context, req *netapppb.UpdateActiveDirectoryRequest, opts ...gax.CallOption) (*UpdateActiveDirectoryOperation, error) {
	return c.internalClient.UpdateActiveDirectory(ctx, req, opts...)
}

// UpdateActiveDirectoryOperation returns a new UpdateActiveDirectoryOperation from a given name.
// The name must be that of a previously created UpdateActiveDirectoryOperation, possibly from a different process.
func (c *Client) UpdateActiveDirectoryOperation(name string) *UpdateActiveDirectoryOperation {
	return c.internalClient.UpdateActiveDirectoryOperation(name)
}

// DeleteActiveDirectory delete the active directory specified in the request.
func (c *Client) DeleteActiveDirectory(ctx context.Context, req *netapppb.DeleteActiveDirectoryRequest, opts ...gax.CallOption) (*DeleteActiveDirectoryOperation, error) {
	return c.internalClient.DeleteActiveDirectory(ctx, req, opts...)
}

// DeleteActiveDirectoryOperation returns a new DeleteActiveDirectoryOperation from a given name.
// The name must be that of a previously created DeleteActiveDirectoryOperation, possibly from a different process.
func (c *Client) DeleteActiveDirectoryOperation(name string) *DeleteActiveDirectoryOperation {
	return c.internalClient.DeleteActiveDirectoryOperation(name)
}

// ListKmsConfigs returns descriptions of all KMS configs owned by the caller.
func (c *Client) ListKmsConfigs(ctx context.Context, req *netapppb.ListKmsConfigsRequest, opts ...gax.CallOption) *KmsConfigIterator {
	return c.internalClient.ListKmsConfigs(ctx, req, opts...)
}

// CreateKmsConfig creates a new KMS config.
func (c *Client) CreateKmsConfig(ctx context.Context, req *netapppb.CreateKmsConfigRequest, opts ...gax.CallOption) (*CreateKmsConfigOperation, error) {
	return c.internalClient.CreateKmsConfig(ctx, req, opts...)
}

// CreateKmsConfigOperation returns a new CreateKmsConfigOperation from a given name.
// The name must be that of a previously created CreateKmsConfigOperation, possibly from a different process.
func (c *Client) CreateKmsConfigOperation(name string) *CreateKmsConfigOperation {
	return c.internalClient.CreateKmsConfigOperation(name)
}

// GetKmsConfig returns the description of the specified KMS config by kms_config_id.
func (c *Client) GetKmsConfig(ctx context.Context, req *netapppb.GetKmsConfigRequest, opts ...gax.CallOption) (*netapppb.KmsConfig, error) {
	return c.internalClient.GetKmsConfig(ctx, req, opts...)
}

// UpdateKmsConfig updates the Kms config properties with the full spec
func (c *Client) UpdateKmsConfig(ctx context.Context, req *netapppb.UpdateKmsConfigRequest, opts ...gax.CallOption) (*UpdateKmsConfigOperation, error) {
	return c.internalClient.UpdateKmsConfig(ctx, req, opts...)
}

// UpdateKmsConfigOperation returns a new UpdateKmsConfigOperation from a given name.
// The name must be that of a previously created UpdateKmsConfigOperation, possibly from a different process.
func (c *Client) UpdateKmsConfigOperation(name string) *UpdateKmsConfigOperation {
	return c.internalClient.UpdateKmsConfigOperation(name)
}

// EncryptVolumes encrypt the existing volumes without CMEK encryption with the desired the
// KMS config for the whole region.
func (c *Client) EncryptVolumes(ctx context.Context, req *netapppb.EncryptVolumesRequest, opts ...gax.CallOption) (*EncryptVolumesOperation, error) {
	return c.internalClient.EncryptVolumes(ctx, req, opts...)
}

// EncryptVolumesOperation returns a new EncryptVolumesOperation from a given name.
// The name must be that of a previously created EncryptVolumesOperation, possibly from a different process.
func (c *Client) EncryptVolumesOperation(name string) *EncryptVolumesOperation {
	return c.internalClient.EncryptVolumesOperation(name)
}

// VerifyKmsConfig verifies KMS config reachability.
func (c *Client) VerifyKmsConfig(ctx context.Context, req *netapppb.VerifyKmsConfigRequest, opts ...gax.CallOption) (*netapppb.VerifyKmsConfigResponse, error) {
	return c.internalClient.VerifyKmsConfig(ctx, req, opts...)
}

// DeleteKmsConfig warning! This operation will permanently delete the Kms config.
func (c *Client) DeleteKmsConfig(ctx context.Context, req *netapppb.DeleteKmsConfigRequest, opts ...gax.CallOption) (*DeleteKmsConfigOperation, error) {
	return c.internalClient.DeleteKmsConfig(ctx, req, opts...)
}

// DeleteKmsConfigOperation returns a new DeleteKmsConfigOperation from a given name.
// The name must be that of a previously created DeleteKmsConfigOperation, possibly from a different process.
func (c *Client) DeleteKmsConfigOperation(name string) *DeleteKmsConfigOperation {
	return c.internalClient.DeleteKmsConfigOperation(name)
}

// ListReplications returns descriptions of all replications for a volume.
func (c *Client) ListReplications(ctx context.Context, req *netapppb.ListReplicationsRequest, opts ...gax.CallOption) *ReplicationIterator {
	return c.internalClient.ListReplications(ctx, req, opts...)
}

// GetReplication describe a replication for a volume.
func (c *Client) GetReplication(ctx context.Context, req *netapppb.GetReplicationRequest, opts ...gax.CallOption) (*netapppb.Replication, error) {
	return c.internalClient.GetReplication(ctx, req, opts...)
}

// CreateReplication create a new replication for a volume.
func (c *Client) CreateReplication(ctx context.Context, req *netapppb.CreateReplicationRequest, opts ...gax.CallOption) (*CreateReplicationOperation, error) {
	return c.internalClient.CreateReplication(ctx, req, opts...)
}

// CreateReplicationOperation returns a new CreateReplicationOperation from a given name.
// The name must be that of a previously created CreateReplicationOperation, possibly from a different process.
func (c *Client) CreateReplicationOperation(name string) *CreateReplicationOperation {
	return c.internalClient.CreateReplicationOperation(name)
}

// DeleteReplication deletes a replication.
func (c *Client) DeleteReplication(ctx context.Context, req *netapppb.DeleteReplicationRequest, opts ...gax.CallOption) (*DeleteReplicationOperation, error) {
	return c.internalClient.DeleteReplication(ctx, req, opts...)
}

// DeleteReplicationOperation returns a new DeleteReplicationOperation from a given name.
// The name must be that of a previously created DeleteReplicationOperation, possibly from a different process.
func (c *Client) DeleteReplicationOperation(name string) *DeleteReplicationOperation {
	return c.internalClient.DeleteReplicationOperation(name)
}

// UpdateReplication updates the settings of a specific replication.
func (c *Client) UpdateReplication(ctx context.Context, req *netapppb.UpdateReplicationRequest, opts ...gax.CallOption) (*UpdateReplicationOperation, error) {
	return c.internalClient.UpdateReplication(ctx, req, opts...)
}

// UpdateReplicationOperation returns a new UpdateReplicationOperation from a given name.
// The name must be that of a previously created UpdateReplicationOperation, possibly from a different process.
func (c *Client) UpdateReplicationOperation(name string) *UpdateReplicationOperation {
	return c.internalClient.UpdateReplicationOperation(name)
}

// StopReplication stop Cross Region Replication.
func (c *Client) StopReplication(ctx context.Context, req *netapppb.StopReplicationRequest, opts ...gax.CallOption) (*StopReplicationOperation, error) {
	return c.internalClient.StopReplication(ctx, req, opts...)
}

// StopReplicationOperation returns a new StopReplicationOperation from a given name.
// The name must be that of a previously created StopReplicationOperation, possibly from a different process.
func (c *Client) StopReplicationOperation(name string) *StopReplicationOperation {
	return c.internalClient.StopReplicationOperation(name)
}

// ResumeReplication resume Cross Region Replication.
func (c *Client) ResumeReplication(ctx context.Context, req *netapppb.ResumeReplicationRequest, opts ...gax.CallOption) (*ResumeReplicationOperation, error) {
	return c.internalClient.ResumeReplication(ctx, req, opts...)
}

// ResumeReplicationOperation returns a new ResumeReplicationOperation from a given name.
// The name must be that of a previously created ResumeReplicationOperation, possibly from a different process.
func (c *Client) ResumeReplicationOperation(name string) *ResumeReplicationOperation {
	return c.internalClient.ResumeReplicationOperation(name)
}

// ReverseReplicationDirection reverses direction of replication. Source becomes destination and
// destination becomes source.
func (c *Client) ReverseReplicationDirection(ctx context.Context, req *netapppb.ReverseReplicationDirectionRequest, opts ...gax.CallOption) (*ReverseReplicationDirectionOperation, error) {
	return c.internalClient.ReverseReplicationDirection(ctx, req, opts...)
}

// ReverseReplicationDirectionOperation returns a new ReverseReplicationDirectionOperation from a given name.
// The name must be that of a previously created ReverseReplicationDirectionOperation, possibly from a different process.
func (c *Client) ReverseReplicationDirectionOperation(name string) *ReverseReplicationDirectionOperation {
	return c.internalClient.ReverseReplicationDirectionOperation(name)
}

// EstablishPeering establish replication peering.
func (c *Client) EstablishPeering(ctx context.Context, req *netapppb.EstablishPeeringRequest, opts ...gax.CallOption) (*EstablishPeeringOperation, error) {
	return c.internalClient.EstablishPeering(ctx, req, opts...)
}

// EstablishPeeringOperation returns a new EstablishPeeringOperation from a given name.
// The name must be that of a previously created EstablishPeeringOperation, possibly from a different process.
func (c *Client) EstablishPeeringOperation(name string) *EstablishPeeringOperation {
	return c.internalClient.EstablishPeeringOperation(name)
}

// SyncReplication syncs the replication. This will invoke one time volume data transfer from
// source to destination.
func (c *Client) SyncReplication(ctx context.Context, req *netapppb.SyncReplicationRequest, opts ...gax.CallOption) (*SyncReplicationOperation, error) {
	return c.internalClient.SyncReplication(ctx, req, opts...)
}

// SyncReplicationOperation returns a new SyncReplicationOperation from a given name.
// The name must be that of a previously created SyncReplicationOperation, possibly from a different process.
func (c *Client) SyncReplicationOperation(name string) *SyncReplicationOperation {
	return c.internalClient.SyncReplicationOperation(name)
}

// CreateBackupVault creates new backup vault
func (c *Client) CreateBackupVault(ctx context.Context, req *netapppb.CreateBackupVaultRequest, opts ...gax.CallOption) (*CreateBackupVaultOperation, error) {
	return c.internalClient.CreateBackupVault(ctx, req, opts...)
}

// CreateBackupVaultOperation returns a new CreateBackupVaultOperation from a given name.
// The name must be that of a previously created CreateBackupVaultOperation, possibly from a different process.
func (c *Client) CreateBackupVaultOperation(name string) *CreateBackupVaultOperation {
	return c.internalClient.CreateBackupVaultOperation(name)
}

// GetBackupVault returns the description of the specified backup vault
func (c *Client) GetBackupVault(ctx context.Context, req *netapppb.GetBackupVaultRequest, opts ...gax.CallOption) (*netapppb.BackupVault, error) {
	return c.internalClient.GetBackupVault(ctx, req, opts...)
}

// ListBackupVaults returns list of all available backup vaults.
func (c *Client) ListBackupVaults(ctx context.Context, req *netapppb.ListBackupVaultsRequest, opts ...gax.CallOption) *BackupVaultIterator {
	return c.internalClient.ListBackupVaults(ctx, req, opts...)
}

// UpdateBackupVault updates the settings of a specific backup vault.
func (c *Client) UpdateBackupVault(ctx context.Context, req *netapppb.UpdateBackupVaultRequest, opts ...gax.CallOption) (*UpdateBackupVaultOperation, error) {
	return c.internalClient.UpdateBackupVault(ctx, req, opts...)
}

// UpdateBackupVaultOperation returns a new UpdateBackupVaultOperation from a given name.
// The name must be that of a previously created UpdateBackupVaultOperation, possibly from a different process.
func (c *Client) UpdateBackupVaultOperation(name string) *UpdateBackupVaultOperation {
	return c.internalClient.UpdateBackupVaultOperation(name)
}

// DeleteBackupVault warning! This operation will permanently delete the backup vault.
func (c *Client) DeleteBackupVault(ctx context.Context, req *netapppb.DeleteBackupVaultRequest, opts ...gax.CallOption) (*DeleteBackupVaultOperation, error) {
	return c.internalClient.DeleteBackupVault(ctx, req, opts...)
}

// DeleteBackupVaultOperation returns a new DeleteBackupVaultOperation from a given name.
// The name must be that of a previously created DeleteBackupVaultOperation, possibly from a different process.
func (c *Client) DeleteBackupVaultOperation(name string) *DeleteBackupVaultOperation {
	return c.internalClient.DeleteBackupVaultOperation(name)
}

// CreateBackup creates a backup from the volume specified in the request
// The backup can be created from the given snapshot if specified in the
// request. If no snapshot specified, there’ll be a new snapshot taken to
// initiate the backup creation.
func (c *Client) CreateBackup(ctx context.Context, req *netapppb.CreateBackupRequest, opts ...gax.CallOption) (*CreateBackupOperation, error) {
	return c.internalClient.CreateBackup(ctx, req, opts...)
}

// CreateBackupOperation returns a new CreateBackupOperation from a given name.
// The name must be that of a previously created CreateBackupOperation, possibly from a different process.
func (c *Client) CreateBackupOperation(name string) *CreateBackupOperation {
	return c.internalClient.CreateBackupOperation(name)
}

// GetBackup returns the description of the specified backup
func (c *Client) GetBackup(ctx context.Context, req *netapppb.GetBackupRequest, opts ...gax.CallOption) (*netapppb.Backup, error) {
	return c.internalClient.GetBackup(ctx, req, opts...)
}

// ListBackups returns descriptions of all backups for a backupVault.
func (c *Client) ListBackups(ctx context.Context, req *netapppb.ListBackupsRequest, opts ...gax.CallOption) *BackupIterator {
	return c.internalClient.ListBackups(ctx, req, opts...)
}

// DeleteBackup warning! This operation will permanently delete the backup.
func (c *Client) DeleteBackup(ctx context.Context, req *netapppb.DeleteBackupRequest, opts ...gax.CallOption) (*DeleteBackupOperation, error) {
	return c.internalClient.DeleteBackup(ctx, req, opts...)
}

// DeleteBackupOperation returns a new DeleteBackupOperation from a given name.
// The name must be that of a previously created DeleteBackupOperation, possibly from a different process.
func (c *Client) DeleteBackupOperation(name string) *DeleteBackupOperation {
	return c.internalClient.DeleteBackupOperation(name)
}

// UpdateBackup update backup with full spec.
func (c *Client) UpdateBackup(ctx context.Context, req *netapppb.UpdateBackupRequest, opts ...gax.CallOption) (*UpdateBackupOperation, error) {
	return c.internalClient.UpdateBackup(ctx, req, opts...)
}

// UpdateBackupOperation returns a new UpdateBackupOperation from a given name.
// The name must be that of a previously created UpdateBackupOperation, possibly from a different process.
func (c *Client) UpdateBackupOperation(name string) *UpdateBackupOperation {
	return c.internalClient.UpdateBackupOperation(name)
}

// CreateBackupPolicy creates new backup policy
func (c *Client) CreateBackupPolicy(ctx context.Context, req *netapppb.CreateBackupPolicyRequest, opts ...gax.CallOption) (*CreateBackupPolicyOperation, error) {
	return c.internalClient.CreateBackupPolicy(ctx, req, opts...)
}

// CreateBackupPolicyOperation returns a new CreateBackupPolicyOperation from a given name.
// The name must be that of a previously created CreateBackupPolicyOperation, possibly from a different process.
func (c *Client) CreateBackupPolicyOperation(name string) *CreateBackupPolicyOperation {
	return c.internalClient.CreateBackupPolicyOperation(name)
}

// GetBackupPolicy returns the description of the specified backup policy by backup_policy_id.
func (c *Client) GetBackupPolicy(ctx context.Context, req *netapppb.GetBackupPolicyRequest, opts ...gax.CallOption) (*netapppb.BackupPolicy, error) {
	return c.internalClient.GetBackupPolicy(ctx, req, opts...)
}

// ListBackupPolicies returns list of all available backup policies.
func (c *Client) ListBackupPolicies(ctx context.Context, req *netapppb.ListBackupPoliciesRequest, opts ...gax.CallOption) *BackupPolicyIterator {
	return c.internalClient.ListBackupPolicies(ctx, req, opts...)
}

// UpdateBackupPolicy updates settings of a specific backup policy.
func (c *Client) UpdateBackupPolicy(ctx context.Context, req *netapppb.UpdateBackupPolicyRequest, opts ...gax.CallOption) (*UpdateBackupPolicyOperation, error) {
	return c.internalClient.UpdateBackupPolicy(ctx, req, opts...)
}

// UpdateBackupPolicyOperation returns a new UpdateBackupPolicyOperation from a given name.
// The name must be that of a previously created UpdateBackupPolicyOperation, possibly from a different process.
func (c *Client) UpdateBackupPolicyOperation(name string) *UpdateBackupPolicyOperation {
	return c.internalClient.UpdateBackupPolicyOperation(name)
}

// DeleteBackupPolicy warning! This operation will permanently delete the backup policy.
func (c *Client) DeleteBackupPolicy(ctx context.Context, req *netapppb.DeleteBackupPolicyRequest, opts ...gax.CallOption) (*DeleteBackupPolicyOperation, error) {
	return c.internalClient.DeleteBackupPolicy(ctx, req, opts...)
}

// DeleteBackupPolicyOperation returns a new DeleteBackupPolicyOperation from a given name.
// The name must be that of a previously created DeleteBackupPolicyOperation, possibly from a different process.
func (c *Client) DeleteBackupPolicyOperation(name string) *DeleteBackupPolicyOperation {
	return c.internalClient.DeleteBackupPolicyOperation(name)
}

// ListQuotaRules returns list of all quota rules in a location.
func (c *Client) ListQuotaRules(ctx context.Context, req *netapppb.ListQuotaRulesRequest, opts ...gax.CallOption) *QuotaRuleIterator {
	return c.internalClient.ListQuotaRules(ctx, req, opts...)
}

// GetQuotaRule returns details of the specified quota rule.
func (c *Client) GetQuotaRule(ctx context.Context, req *netapppb.GetQuotaRuleRequest, opts ...gax.CallOption) (*netapppb.QuotaRule, error) {
	return c.internalClient.GetQuotaRule(ctx, req, opts...)
}

// CreateQuotaRule creates a new quota rule.
func (c *Client) CreateQuotaRule(ctx context.Context, req *netapppb.CreateQuotaRuleRequest, opts ...gax.CallOption) (*CreateQuotaRuleOperation, error) {
	return c.internalClient.CreateQuotaRule(ctx, req, opts...)
}

// CreateQuotaRuleOperation returns a new CreateQuotaRuleOperation from a given name.
// The name must be that of a previously created CreateQuotaRuleOperation, possibly from a different process.
func (c *Client) CreateQuotaRuleOperation(name string) *CreateQuotaRuleOperation {
	return c.internalClient.CreateQuotaRuleOperation(name)
}

// UpdateQuotaRule updates a quota rule.
func (c *Client) UpdateQuotaRule(ctx context.Context, req *netapppb.UpdateQuotaRuleRequest, opts ...gax.CallOption) (*UpdateQuotaRuleOperation, error) {
	return c.internalClient.UpdateQuotaRule(ctx, req, opts...)
}

// UpdateQuotaRuleOperation returns a new UpdateQuotaRuleOperation from a given name.
// The name must be that of a previously created UpdateQuotaRuleOperation, possibly from a different process.
func (c *Client) UpdateQuotaRuleOperation(name string) *UpdateQuotaRuleOperation {
	return c.internalClient.UpdateQuotaRuleOperation(name)
}

// DeleteQuotaRule deletes a quota rule.
func (c *Client) DeleteQuotaRule(ctx context.Context, req *netapppb.DeleteQuotaRuleRequest, opts ...gax.CallOption) (*DeleteQuotaRuleOperation, error) {
	return c.internalClient.DeleteQuotaRule(ctx, req, opts...)
}

// DeleteQuotaRuleOperation returns a new DeleteQuotaRuleOperation from a given name.
// The name must be that of a previously created DeleteQuotaRuleOperation, possibly from a different process.
func (c *Client) DeleteQuotaRuleOperation(name string) *DeleteQuotaRuleOperation {
	return c.internalClient.DeleteQuotaRuleOperation(name)
}

// GetLocation gets information about a location.
func (c *Client) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	return c.internalClient.GetLocation(ctx, req, opts...)
}

// ListLocations lists information about the supported locations for this service.
func (c *Client) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	return c.internalClient.ListLocations(ctx, req, opts...)
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *Client) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.CancelOperation(ctx, req, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *Client) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteOperation(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *Client) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *Client) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	return c.internalClient.ListOperations(ctx, req, opts...)
}

// gRPCClient is a client for interacting with NetApp API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type gRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions

	// The gRPC API client.
	client netapppb.NetAppClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	locationsClient locationpb.LocationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewClient creates a new net app client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// NetApp Files Google Cloud Service
func NewClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := defaultGRPCClientOptions()
	if newClientHook != nil {
		hookOpts, err := newClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := Client{CallOptions: defaultCallOptions()}

	c := &gRPCClient{
		connPool:         connPool,
		client:           netapppb.NewNetAppClient(connPool),
		CallOptions:      &client.CallOptions,
		logger:           internaloption.GetLogger(opts),
		operationsClient: longrunningpb.NewOperationsClient(connPool),
		locationsClient:  locationpb.NewLocationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *gRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *gRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *gRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type restClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions

	logger *slog.Logger
}

// NewRESTClient creates a new net app rest client.
//
// NetApp Files Google Cloud Service
func NewRESTClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := append(defaultRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultRESTCallOptions()
	c := &restClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
		logger:      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	lroOpts := []option.ClientOption{
		option.WithHTTPClient(httpClient),
		option.WithEndpoint(endpoint),
	}
	opClient, err := lroauto.NewOperationsRESTClient(ctx, lroOpts...)
	if err != nil {
		return nil, err
	}
	c.LROClient = &opClient

	return &Client{internalClient: c, CallOptions: callOpts}, nil
}

func defaultRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://netapp.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://netapp.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://netapp.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://netapp.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableNewAuthLibrary(),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *restClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *restClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *restClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *gRPCClient) ListStoragePools(ctx context.Context, req *netapppb.ListStoragePoolsRequest, opts ...gax.CallOption) *StoragePoolIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListStoragePools[0:len((*c.CallOptions).ListStoragePools):len((*c.CallOptions).ListStoragePools)], opts...)
	it := &StoragePoolIterator{}
	req = proto.Clone(req).(*netapppb.ListStoragePoolsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.StoragePool, string, error) {
		resp := &netapppb.ListStoragePoolsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListStoragePools, req, settings.GRPC, c.logger, "ListStoragePools")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetStoragePools(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) CreateStoragePool(ctx context.Context, req *netapppb.CreateStoragePoolRequest, opts ...gax.CallOption) (*CreateStoragePoolOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateStoragePool[0:len((*c.CallOptions).CreateStoragePool):len((*c.CallOptions).CreateStoragePool)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateStoragePool, req, settings.GRPC, c.logger, "CreateStoragePool")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateStoragePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) GetStoragePool(ctx context.Context, req *netapppb.GetStoragePoolRequest, opts ...gax.CallOption) (*netapppb.StoragePool, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetStoragePool[0:len((*c.CallOptions).GetStoragePool):len((*c.CallOptions).GetStoragePool)], opts...)
	var resp *netapppb.StoragePool
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetStoragePool, req, settings.GRPC, c.logger, "GetStoragePool")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) UpdateStoragePool(ctx context.Context, req *netapppb.UpdateStoragePoolRequest, opts ...gax.CallOption) (*UpdateStoragePoolOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "storage_pool.name", url.QueryEscape(req.GetStoragePool().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateStoragePool[0:len((*c.CallOptions).UpdateStoragePool):len((*c.CallOptions).UpdateStoragePool)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateStoragePool, req, settings.GRPC, c.logger, "UpdateStoragePool")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateStoragePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteStoragePool(ctx context.Context, req *netapppb.DeleteStoragePoolRequest, opts ...gax.CallOption) (*DeleteStoragePoolOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteStoragePool[0:len((*c.CallOptions).DeleteStoragePool):len((*c.CallOptions).DeleteStoragePool)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteStoragePool, req, settings.GRPC, c.logger, "DeleteStoragePool")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteStoragePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ValidateDirectoryService(ctx context.Context, req *netapppb.ValidateDirectoryServiceRequest, opts ...gax.CallOption) (*ValidateDirectoryServiceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ValidateDirectoryService[0:len((*c.CallOptions).ValidateDirectoryService):len((*c.CallOptions).ValidateDirectoryService)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.ValidateDirectoryService, req, settings.GRPC, c.logger, "ValidateDirectoryService")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ValidateDirectoryServiceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) SwitchActiveReplicaZone(ctx context.Context, req *netapppb.SwitchActiveReplicaZoneRequest, opts ...gax.CallOption) (*SwitchActiveReplicaZoneOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SwitchActiveReplicaZone[0:len((*c.CallOptions).SwitchActiveReplicaZone):len((*c.CallOptions).SwitchActiveReplicaZone)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.SwitchActiveReplicaZone, req, settings.GRPC, c.logger, "SwitchActiveReplicaZone")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &SwitchActiveReplicaZoneOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListVolumes(ctx context.Context, req *netapppb.ListVolumesRequest, opts ...gax.CallOption) *VolumeIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListVolumes[0:len((*c.CallOptions).ListVolumes):len((*c.CallOptions).ListVolumes)], opts...)
	it := &VolumeIterator{}
	req = proto.Clone(req).(*netapppb.ListVolumesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.Volume, string, error) {
		resp := &netapppb.ListVolumesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListVolumes, req, settings.GRPC, c.logger, "ListVolumes")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetVolumes(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetVolume(ctx context.Context, req *netapppb.GetVolumeRequest, opts ...gax.CallOption) (*netapppb.Volume, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetVolume[0:len((*c.CallOptions).GetVolume):len((*c.CallOptions).GetVolume)], opts...)
	var resp *netapppb.Volume
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetVolume, req, settings.GRPC, c.logger, "GetVolume")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateVolume(ctx context.Context, req *netapppb.CreateVolumeRequest, opts ...gax.CallOption) (*CreateVolumeOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateVolume[0:len((*c.CallOptions).CreateVolume):len((*c.CallOptions).CreateVolume)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateVolume, req, settings.GRPC, c.logger, "CreateVolume")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateVolumeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateVolume(ctx context.Context, req *netapppb.UpdateVolumeRequest, opts ...gax.CallOption) (*UpdateVolumeOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "volume.name", url.QueryEscape(req.GetVolume().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateVolume[0:len((*c.CallOptions).UpdateVolume):len((*c.CallOptions).UpdateVolume)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateVolume, req, settings.GRPC, c.logger, "UpdateVolume")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateVolumeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteVolume(ctx context.Context, req *netapppb.DeleteVolumeRequest, opts ...gax.CallOption) (*DeleteVolumeOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteVolume[0:len((*c.CallOptions).DeleteVolume):len((*c.CallOptions).DeleteVolume)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteVolume, req, settings.GRPC, c.logger, "DeleteVolume")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteVolumeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) RevertVolume(ctx context.Context, req *netapppb.RevertVolumeRequest, opts ...gax.CallOption) (*RevertVolumeOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).RevertVolume[0:len((*c.CallOptions).RevertVolume):len((*c.CallOptions).RevertVolume)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.RevertVolume, req, settings.GRPC, c.logger, "RevertVolume")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &RevertVolumeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListSnapshots(ctx context.Context, req *netapppb.ListSnapshotsRequest, opts ...gax.CallOption) *SnapshotIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListSnapshots[0:len((*c.CallOptions).ListSnapshots):len((*c.CallOptions).ListSnapshots)], opts...)
	it := &SnapshotIterator{}
	req = proto.Clone(req).(*netapppb.ListSnapshotsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.Snapshot, string, error) {
		resp := &netapppb.ListSnapshotsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListSnapshots, req, settings.GRPC, c.logger, "ListSnapshots")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetSnapshots(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetSnapshot(ctx context.Context, req *netapppb.GetSnapshotRequest, opts ...gax.CallOption) (*netapppb.Snapshot, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetSnapshot[0:len((*c.CallOptions).GetSnapshot):len((*c.CallOptions).GetSnapshot)], opts...)
	var resp *netapppb.Snapshot
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetSnapshot, req, settings.GRPC, c.logger, "GetSnapshot")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateSnapshot(ctx context.Context, req *netapppb.CreateSnapshotRequest, opts ...gax.CallOption) (*CreateSnapshotOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateSnapshot[0:len((*c.CallOptions).CreateSnapshot):len((*c.CallOptions).CreateSnapshot)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateSnapshot, req, settings.GRPC, c.logger, "CreateSnapshot")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateSnapshotOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteSnapshot(ctx context.Context, req *netapppb.DeleteSnapshotRequest, opts ...gax.CallOption) (*DeleteSnapshotOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteSnapshot[0:len((*c.CallOptions).DeleteSnapshot):len((*c.CallOptions).DeleteSnapshot)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteSnapshot, req, settings.GRPC, c.logger, "DeleteSnapshot")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteSnapshotOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateSnapshot(ctx context.Context, req *netapppb.UpdateSnapshotRequest, opts ...gax.CallOption) (*UpdateSnapshotOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "snapshot.name", url.QueryEscape(req.GetSnapshot().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateSnapshot[0:len((*c.CallOptions).UpdateSnapshot):len((*c.CallOptions).UpdateSnapshot)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateSnapshot, req, settings.GRPC, c.logger, "UpdateSnapshot")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateSnapshotOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListActiveDirectories(ctx context.Context, req *netapppb.ListActiveDirectoriesRequest, opts ...gax.CallOption) *ActiveDirectoryIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListActiveDirectories[0:len((*c.CallOptions).ListActiveDirectories):len((*c.CallOptions).ListActiveDirectories)], opts...)
	it := &ActiveDirectoryIterator{}
	req = proto.Clone(req).(*netapppb.ListActiveDirectoriesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.ActiveDirectory, string, error) {
		resp := &netapppb.ListActiveDirectoriesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListActiveDirectories, req, settings.GRPC, c.logger, "ListActiveDirectories")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetActiveDirectories(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetActiveDirectory(ctx context.Context, req *netapppb.GetActiveDirectoryRequest, opts ...gax.CallOption) (*netapppb.ActiveDirectory, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetActiveDirectory[0:len((*c.CallOptions).GetActiveDirectory):len((*c.CallOptions).GetActiveDirectory)], opts...)
	var resp *netapppb.ActiveDirectory
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetActiveDirectory, req, settings.GRPC, c.logger, "GetActiveDirectory")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateActiveDirectory(ctx context.Context, req *netapppb.CreateActiveDirectoryRequest, opts ...gax.CallOption) (*CreateActiveDirectoryOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateActiveDirectory[0:len((*c.CallOptions).CreateActiveDirectory):len((*c.CallOptions).CreateActiveDirectory)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateActiveDirectory, req, settings.GRPC, c.logger, "CreateActiveDirectory")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateActiveDirectoryOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateActiveDirectory(ctx context.Context, req *netapppb.UpdateActiveDirectoryRequest, opts ...gax.CallOption) (*UpdateActiveDirectoryOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "active_directory.name", url.QueryEscape(req.GetActiveDirectory().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateActiveDirectory[0:len((*c.CallOptions).UpdateActiveDirectory):len((*c.CallOptions).UpdateActiveDirectory)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateActiveDirectory, req, settings.GRPC, c.logger, "UpdateActiveDirectory")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateActiveDirectoryOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteActiveDirectory(ctx context.Context, req *netapppb.DeleteActiveDirectoryRequest, opts ...gax.CallOption) (*DeleteActiveDirectoryOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteActiveDirectory[0:len((*c.CallOptions).DeleteActiveDirectory):len((*c.CallOptions).DeleteActiveDirectory)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteActiveDirectory, req, settings.GRPC, c.logger, "DeleteActiveDirectory")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteActiveDirectoryOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListKmsConfigs(ctx context.Context, req *netapppb.ListKmsConfigsRequest, opts ...gax.CallOption) *KmsConfigIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListKmsConfigs[0:len((*c.CallOptions).ListKmsConfigs):len((*c.CallOptions).ListKmsConfigs)], opts...)
	it := &KmsConfigIterator{}
	req = proto.Clone(req).(*netapppb.ListKmsConfigsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.KmsConfig, string, error) {
		resp := &netapppb.ListKmsConfigsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListKmsConfigs, req, settings.GRPC, c.logger, "ListKmsConfigs")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetKmsConfigs(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) CreateKmsConfig(ctx context.Context, req *netapppb.CreateKmsConfigRequest, opts ...gax.CallOption) (*CreateKmsConfigOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateKmsConfig[0:len((*c.CallOptions).CreateKmsConfig):len((*c.CallOptions).CreateKmsConfig)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateKmsConfig, req, settings.GRPC, c.logger, "CreateKmsConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateKmsConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) GetKmsConfig(ctx context.Context, req *netapppb.GetKmsConfigRequest, opts ...gax.CallOption) (*netapppb.KmsConfig, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetKmsConfig[0:len((*c.CallOptions).GetKmsConfig):len((*c.CallOptions).GetKmsConfig)], opts...)
	var resp *netapppb.KmsConfig
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetKmsConfig, req, settings.GRPC, c.logger, "GetKmsConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) UpdateKmsConfig(ctx context.Context, req *netapppb.UpdateKmsConfigRequest, opts ...gax.CallOption) (*UpdateKmsConfigOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "kms_config.name", url.QueryEscape(req.GetKmsConfig().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateKmsConfig[0:len((*c.CallOptions).UpdateKmsConfig):len((*c.CallOptions).UpdateKmsConfig)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateKmsConfig, req, settings.GRPC, c.logger, "UpdateKmsConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateKmsConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) EncryptVolumes(ctx context.Context, req *netapppb.EncryptVolumesRequest, opts ...gax.CallOption) (*EncryptVolumesOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).EncryptVolumes[0:len((*c.CallOptions).EncryptVolumes):len((*c.CallOptions).EncryptVolumes)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.EncryptVolumes, req, settings.GRPC, c.logger, "EncryptVolumes")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &EncryptVolumesOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) VerifyKmsConfig(ctx context.Context, req *netapppb.VerifyKmsConfigRequest, opts ...gax.CallOption) (*netapppb.VerifyKmsConfigResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).VerifyKmsConfig[0:len((*c.CallOptions).VerifyKmsConfig):len((*c.CallOptions).VerifyKmsConfig)], opts...)
	var resp *netapppb.VerifyKmsConfigResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.VerifyKmsConfig, req, settings.GRPC, c.logger, "VerifyKmsConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) DeleteKmsConfig(ctx context.Context, req *netapppb.DeleteKmsConfigRequest, opts ...gax.CallOption) (*DeleteKmsConfigOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteKmsConfig[0:len((*c.CallOptions).DeleteKmsConfig):len((*c.CallOptions).DeleteKmsConfig)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteKmsConfig, req, settings.GRPC, c.logger, "DeleteKmsConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteKmsConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListReplications(ctx context.Context, req *netapppb.ListReplicationsRequest, opts ...gax.CallOption) *ReplicationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListReplications[0:len((*c.CallOptions).ListReplications):len((*c.CallOptions).ListReplications)], opts...)
	it := &ReplicationIterator{}
	req = proto.Clone(req).(*netapppb.ListReplicationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.Replication, string, error) {
		resp := &netapppb.ListReplicationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListReplications, req, settings.GRPC, c.logger, "ListReplications")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetReplications(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetReplication(ctx context.Context, req *netapppb.GetReplicationRequest, opts ...gax.CallOption) (*netapppb.Replication, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetReplication[0:len((*c.CallOptions).GetReplication):len((*c.CallOptions).GetReplication)], opts...)
	var resp *netapppb.Replication
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetReplication, req, settings.GRPC, c.logger, "GetReplication")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateReplication(ctx context.Context, req *netapppb.CreateReplicationRequest, opts ...gax.CallOption) (*CreateReplicationOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateReplication[0:len((*c.CallOptions).CreateReplication):len((*c.CallOptions).CreateReplication)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateReplication, req, settings.GRPC, c.logger, "CreateReplication")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateReplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteReplication(ctx context.Context, req *netapppb.DeleteReplicationRequest, opts ...gax.CallOption) (*DeleteReplicationOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteReplication[0:len((*c.CallOptions).DeleteReplication):len((*c.CallOptions).DeleteReplication)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteReplication, req, settings.GRPC, c.logger, "DeleteReplication")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteReplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateReplication(ctx context.Context, req *netapppb.UpdateReplicationRequest, opts ...gax.CallOption) (*UpdateReplicationOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "replication.name", url.QueryEscape(req.GetReplication().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateReplication[0:len((*c.CallOptions).UpdateReplication):len((*c.CallOptions).UpdateReplication)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateReplication, req, settings.GRPC, c.logger, "UpdateReplication")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateReplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) StopReplication(ctx context.Context, req *netapppb.StopReplicationRequest, opts ...gax.CallOption) (*StopReplicationOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).StopReplication[0:len((*c.CallOptions).StopReplication):len((*c.CallOptions).StopReplication)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.StopReplication, req, settings.GRPC, c.logger, "StopReplication")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &StopReplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ResumeReplication(ctx context.Context, req *netapppb.ResumeReplicationRequest, opts ...gax.CallOption) (*ResumeReplicationOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ResumeReplication[0:len((*c.CallOptions).ResumeReplication):len((*c.CallOptions).ResumeReplication)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.ResumeReplication, req, settings.GRPC, c.logger, "ResumeReplication")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ResumeReplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ReverseReplicationDirection(ctx context.Context, req *netapppb.ReverseReplicationDirectionRequest, opts ...gax.CallOption) (*ReverseReplicationDirectionOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ReverseReplicationDirection[0:len((*c.CallOptions).ReverseReplicationDirection):len((*c.CallOptions).ReverseReplicationDirection)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.ReverseReplicationDirection, req, settings.GRPC, c.logger, "ReverseReplicationDirection")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ReverseReplicationDirectionOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) EstablishPeering(ctx context.Context, req *netapppb.EstablishPeeringRequest, opts ...gax.CallOption) (*EstablishPeeringOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).EstablishPeering[0:len((*c.CallOptions).EstablishPeering):len((*c.CallOptions).EstablishPeering)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.EstablishPeering, req, settings.GRPC, c.logger, "EstablishPeering")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &EstablishPeeringOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) SyncReplication(ctx context.Context, req *netapppb.SyncReplicationRequest, opts ...gax.CallOption) (*SyncReplicationOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SyncReplication[0:len((*c.CallOptions).SyncReplication):len((*c.CallOptions).SyncReplication)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.SyncReplication, req, settings.GRPC, c.logger, "SyncReplication")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &SyncReplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) CreateBackupVault(ctx context.Context, req *netapppb.CreateBackupVaultRequest, opts ...gax.CallOption) (*CreateBackupVaultOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateBackupVault[0:len((*c.CallOptions).CreateBackupVault):len((*c.CallOptions).CreateBackupVault)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateBackupVault, req, settings.GRPC, c.logger, "CreateBackupVault")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateBackupVaultOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) GetBackupVault(ctx context.Context, req *netapppb.GetBackupVaultRequest, opts ...gax.CallOption) (*netapppb.BackupVault, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetBackupVault[0:len((*c.CallOptions).GetBackupVault):len((*c.CallOptions).GetBackupVault)], opts...)
	var resp *netapppb.BackupVault
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetBackupVault, req, settings.GRPC, c.logger, "GetBackupVault")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListBackupVaults(ctx context.Context, req *netapppb.ListBackupVaultsRequest, opts ...gax.CallOption) *BackupVaultIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListBackupVaults[0:len((*c.CallOptions).ListBackupVaults):len((*c.CallOptions).ListBackupVaults)], opts...)
	it := &BackupVaultIterator{}
	req = proto.Clone(req).(*netapppb.ListBackupVaultsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.BackupVault, string, error) {
		resp := &netapppb.ListBackupVaultsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListBackupVaults, req, settings.GRPC, c.logger, "ListBackupVaults")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetBackupVaults(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) UpdateBackupVault(ctx context.Context, req *netapppb.UpdateBackupVaultRequest, opts ...gax.CallOption) (*UpdateBackupVaultOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "backup_vault.name", url.QueryEscape(req.GetBackupVault().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateBackupVault[0:len((*c.CallOptions).UpdateBackupVault):len((*c.CallOptions).UpdateBackupVault)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateBackupVault, req, settings.GRPC, c.logger, "UpdateBackupVault")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateBackupVaultOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteBackupVault(ctx context.Context, req *netapppb.DeleteBackupVaultRequest, opts ...gax.CallOption) (*DeleteBackupVaultOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteBackupVault[0:len((*c.CallOptions).DeleteBackupVault):len((*c.CallOptions).DeleteBackupVault)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteBackupVault, req, settings.GRPC, c.logger, "DeleteBackupVault")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteBackupVaultOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) CreateBackup(ctx context.Context, req *netapppb.CreateBackupRequest, opts ...gax.CallOption) (*CreateBackupOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateBackup[0:len((*c.CallOptions).CreateBackup):len((*c.CallOptions).CreateBackup)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateBackup, req, settings.GRPC, c.logger, "CreateBackup")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateBackupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) GetBackup(ctx context.Context, req *netapppb.GetBackupRequest, opts ...gax.CallOption) (*netapppb.Backup, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetBackup[0:len((*c.CallOptions).GetBackup):len((*c.CallOptions).GetBackup)], opts...)
	var resp *netapppb.Backup
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetBackup, req, settings.GRPC, c.logger, "GetBackup")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListBackups(ctx context.Context, req *netapppb.ListBackupsRequest, opts ...gax.CallOption) *BackupIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListBackups[0:len((*c.CallOptions).ListBackups):len((*c.CallOptions).ListBackups)], opts...)
	it := &BackupIterator{}
	req = proto.Clone(req).(*netapppb.ListBackupsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.Backup, string, error) {
		resp := &netapppb.ListBackupsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListBackups, req, settings.GRPC, c.logger, "ListBackups")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetBackups(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) DeleteBackup(ctx context.Context, req *netapppb.DeleteBackupRequest, opts ...gax.CallOption) (*DeleteBackupOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteBackup[0:len((*c.CallOptions).DeleteBackup):len((*c.CallOptions).DeleteBackup)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteBackup, req, settings.GRPC, c.logger, "DeleteBackup")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteBackupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateBackup(ctx context.Context, req *netapppb.UpdateBackupRequest, opts ...gax.CallOption) (*UpdateBackupOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "backup.name", url.QueryEscape(req.GetBackup().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateBackup[0:len((*c.CallOptions).UpdateBackup):len((*c.CallOptions).UpdateBackup)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateBackup, req, settings.GRPC, c.logger, "UpdateBackup")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateBackupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) CreateBackupPolicy(ctx context.Context, req *netapppb.CreateBackupPolicyRequest, opts ...gax.CallOption) (*CreateBackupPolicyOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateBackupPolicy[0:len((*c.CallOptions).CreateBackupPolicy):len((*c.CallOptions).CreateBackupPolicy)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateBackupPolicy, req, settings.GRPC, c.logger, "CreateBackupPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateBackupPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) GetBackupPolicy(ctx context.Context, req *netapppb.GetBackupPolicyRequest, opts ...gax.CallOption) (*netapppb.BackupPolicy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetBackupPolicy[0:len((*c.CallOptions).GetBackupPolicy):len((*c.CallOptions).GetBackupPolicy)], opts...)
	var resp *netapppb.BackupPolicy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetBackupPolicy, req, settings.GRPC, c.logger, "GetBackupPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListBackupPolicies(ctx context.Context, req *netapppb.ListBackupPoliciesRequest, opts ...gax.CallOption) *BackupPolicyIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListBackupPolicies[0:len((*c.CallOptions).ListBackupPolicies):len((*c.CallOptions).ListBackupPolicies)], opts...)
	it := &BackupPolicyIterator{}
	req = proto.Clone(req).(*netapppb.ListBackupPoliciesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.BackupPolicy, string, error) {
		resp := &netapppb.ListBackupPoliciesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListBackupPolicies, req, settings.GRPC, c.logger, "ListBackupPolicies")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetBackupPolicies(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) UpdateBackupPolicy(ctx context.Context, req *netapppb.UpdateBackupPolicyRequest, opts ...gax.CallOption) (*UpdateBackupPolicyOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "backup_policy.name", url.QueryEscape(req.GetBackupPolicy().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateBackupPolicy[0:len((*c.CallOptions).UpdateBackupPolicy):len((*c.CallOptions).UpdateBackupPolicy)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateBackupPolicy, req, settings.GRPC, c.logger, "UpdateBackupPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateBackupPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteBackupPolicy(ctx context.Context, req *netapppb.DeleteBackupPolicyRequest, opts ...gax.CallOption) (*DeleteBackupPolicyOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteBackupPolicy[0:len((*c.CallOptions).DeleteBackupPolicy):len((*c.CallOptions).DeleteBackupPolicy)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteBackupPolicy, req, settings.GRPC, c.logger, "DeleteBackupPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteBackupPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListQuotaRules(ctx context.Context, req *netapppb.ListQuotaRulesRequest, opts ...gax.CallOption) *QuotaRuleIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListQuotaRules[0:len((*c.CallOptions).ListQuotaRules):len((*c.CallOptions).ListQuotaRules)], opts...)
	it := &QuotaRuleIterator{}
	req = proto.Clone(req).(*netapppb.ListQuotaRulesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.QuotaRule, string, error) {
		resp := &netapppb.ListQuotaRulesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListQuotaRules, req, settings.GRPC, c.logger, "ListQuotaRules")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetQuotaRules(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetQuotaRule(ctx context.Context, req *netapppb.GetQuotaRuleRequest, opts ...gax.CallOption) (*netapppb.QuotaRule, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetQuotaRule[0:len((*c.CallOptions).GetQuotaRule):len((*c.CallOptions).GetQuotaRule)], opts...)
	var resp *netapppb.QuotaRule
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetQuotaRule, req, settings.GRPC, c.logger, "GetQuotaRule")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateQuotaRule(ctx context.Context, req *netapppb.CreateQuotaRuleRequest, opts ...gax.CallOption) (*CreateQuotaRuleOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateQuotaRule[0:len((*c.CallOptions).CreateQuotaRule):len((*c.CallOptions).CreateQuotaRule)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateQuotaRule, req, settings.GRPC, c.logger, "CreateQuotaRule")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateQuotaRuleOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateQuotaRule(ctx context.Context, req *netapppb.UpdateQuotaRuleRequest, opts ...gax.CallOption) (*UpdateQuotaRuleOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "quota_rule.name", url.QueryEscape(req.GetQuotaRule().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateQuotaRule[0:len((*c.CallOptions).UpdateQuotaRule):len((*c.CallOptions).UpdateQuotaRule)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateQuotaRule, req, settings.GRPC, c.logger, "UpdateQuotaRule")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateQuotaRuleOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteQuotaRule(ctx context.Context, req *netapppb.DeleteQuotaRuleRequest, opts ...gax.CallOption) (*DeleteQuotaRuleOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteQuotaRule[0:len((*c.CallOptions).DeleteQuotaRule):len((*c.CallOptions).DeleteQuotaRule)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteQuotaRule, req, settings.GRPC, c.logger, "DeleteQuotaRule")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteQuotaRuleOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	var resp *locationpb.Location
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.locationsClient.GetLocation, req, settings.GRPC, c.logger, "GetLocation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListLocations[0:len((*c.CallOptions).ListLocations):len((*c.CallOptions).ListLocations)], opts...)
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.locationsClient.ListLocations, req, settings.GRPC, c.logger, "ListLocations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CancelOperation[0:len((*c.CallOptions).CancelOperation):len((*c.CallOptions).CancelOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.CancelOperation, req, settings.GRPC, c.logger, "CancelOperation")
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteOperation[0:len((*c.CallOptions).DeleteOperation):len((*c.CallOptions).DeleteOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.DeleteOperation, req, settings.GRPC, c.logger, "DeleteOperation")
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.operationsClient.GetOperation, req, settings.GRPC, c.logger, "GetOperation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListOperations[0:len((*c.CallOptions).ListOperations):len((*c.CallOptions).ListOperations)], opts...)
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.operationsClient.ListOperations, req, settings.GRPC, c.logger, "ListOperations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// ListStoragePools returns descriptions of all storage pools owned by the caller.
func (c *restClient) ListStoragePools(ctx context.Context, req *netapppb.ListStoragePoolsRequest, opts ...gax.CallOption) *StoragePoolIterator {
	it := &StoragePoolIterator{}
	req = proto.Clone(req).(*netapppb.ListStoragePoolsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.StoragePool, string, error) {
		resp := &netapppb.ListStoragePoolsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/storagePools", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListStoragePools")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetStoragePools(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateStoragePool creates a new storage pool.
func (c *restClient) CreateStoragePool(ctx context.Context, req *netapppb.CreateStoragePoolRequest, opts ...gax.CallOption) (*CreateStoragePoolOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetStoragePool()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/storagePools", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("storagePoolId", fmt.Sprintf("%v", req.GetStoragePoolId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateStoragePool")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateStoragePoolOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetStoragePool returns the description of the specified storage pool by poolId.
func (c *restClient) GetStoragePool(ctx context.Context, req *netapppb.GetStoragePoolRequest, opts ...gax.CallOption) (*netapppb.StoragePool, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetStoragePool[0:len((*c.CallOptions).GetStoragePool):len((*c.CallOptions).GetStoragePool)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &netapppb.StoragePool{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetStoragePool")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateStoragePool updates the storage pool properties with the full spec
func (c *restClient) UpdateStoragePool(ctx context.Context, req *netapppb.UpdateStoragePoolRequest, opts ...gax.CallOption) (*UpdateStoragePoolOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetStoragePool()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetStoragePool().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "storage_pool.name", url.QueryEscape(req.GetStoragePool().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateStoragePool")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateStoragePoolOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteStoragePool warning! This operation will permanently delete the storage pool.
func (c *restClient) DeleteStoragePool(ctx context.Context, req *netapppb.DeleteStoragePoolRequest, opts ...gax.CallOption) (*DeleteStoragePoolOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteStoragePool")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteStoragePoolOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ValidateDirectoryService validateDirectoryService does a connectivity check for a directory service
// policy attached to the storage pool.
func (c *restClient) ValidateDirectoryService(ctx context.Context, req *netapppb.ValidateDirectoryServiceRequest, opts ...gax.CallOption) (*ValidateDirectoryServiceOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:validateDirectoryService", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "ValidateDirectoryService")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &ValidateDirectoryServiceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// SwitchActiveReplicaZone this operation will switch the active/replica zone for a regional
// storagePool.
func (c *restClient) SwitchActiveReplicaZone(ctx context.Context, req *netapppb.SwitchActiveReplicaZoneRequest, opts ...gax.CallOption) (*SwitchActiveReplicaZoneOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:switch", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "SwitchActiveReplicaZone")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &SwitchActiveReplicaZoneOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListVolumes lists Volumes in a given project.
func (c *restClient) ListVolumes(ctx context.Context, req *netapppb.ListVolumesRequest, opts ...gax.CallOption) *VolumeIterator {
	it := &VolumeIterator{}
	req = proto.Clone(req).(*netapppb.ListVolumesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.Volume, string, error) {
		resp := &netapppb.ListVolumesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/volumes", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListVolumes")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetVolumes(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetVolume gets details of a single Volume.
func (c *restClient) GetVolume(ctx context.Context, req *netapppb.GetVolumeRequest, opts ...gax.CallOption) (*netapppb.Volume, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetVolume[0:len((*c.CallOptions).GetVolume):len((*c.CallOptions).GetVolume)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &netapppb.Volume{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetVolume")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateVolume creates a new Volume in a given project and location.
func (c *restClient) CreateVolume(ctx context.Context, req *netapppb.CreateVolumeRequest, opts ...gax.CallOption) (*CreateVolumeOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetVolume()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/volumes", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("volumeId", fmt.Sprintf("%v", req.GetVolumeId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateVolume")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateVolumeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateVolume updates the parameters of a single Volume.
func (c *restClient) UpdateVolume(ctx context.Context, req *netapppb.UpdateVolumeRequest, opts ...gax.CallOption) (*UpdateVolumeOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetVolume()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetVolume().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "volume.name", url.QueryEscape(req.GetVolume().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateVolume")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateVolumeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteVolume deletes a single Volume.
func (c *restClient) DeleteVolume(ctx context.Context, req *netapppb.DeleteVolumeRequest, opts ...gax.CallOption) (*DeleteVolumeOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetForce() {
		params.Add("force", fmt.Sprintf("%v", req.GetForce()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteVolume")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteVolumeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// RevertVolume revert an existing volume to a specified snapshot.
// Warning! This operation will permanently revert all changes made after the
// snapshot was created.
func (c *restClient) RevertVolume(ctx context.Context, req *netapppb.RevertVolumeRequest, opts ...gax.CallOption) (*RevertVolumeOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:revert", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "RevertVolume")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &RevertVolumeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListSnapshots returns descriptions of all snapshots for a volume.
func (c *restClient) ListSnapshots(ctx context.Context, req *netapppb.ListSnapshotsRequest, opts ...gax.CallOption) *SnapshotIterator {
	it := &SnapshotIterator{}
	req = proto.Clone(req).(*netapppb.ListSnapshotsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.Snapshot, string, error) {
		resp := &netapppb.ListSnapshotsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/snapshots", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListSnapshots")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetSnapshots(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetSnapshot describe a snapshot for a volume.
func (c *restClient) GetSnapshot(ctx context.Context, req *netapppb.GetSnapshotRequest, opts ...gax.CallOption) (*netapppb.Snapshot, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetSnapshot[0:len((*c.CallOptions).GetSnapshot):len((*c.CallOptions).GetSnapshot)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &netapppb.Snapshot{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetSnapshot")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateSnapshot create a new snapshot for a volume.
func (c *restClient) CreateSnapshot(ctx context.Context, req *netapppb.CreateSnapshotRequest, opts ...gax.CallOption) (*CreateSnapshotOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetSnapshot()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/snapshots", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("snapshotId", fmt.Sprintf("%v", req.GetSnapshotId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateSnapshot")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateSnapshotOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteSnapshot deletes a snapshot.
func (c *restClient) DeleteSnapshot(ctx context.Context, req *netapppb.DeleteSnapshotRequest, opts ...gax.CallOption) (*DeleteSnapshotOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteSnapshot")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteSnapshotOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateSnapshot updates the settings of a specific snapshot.
func (c *restClient) UpdateSnapshot(ctx context.Context, req *netapppb.UpdateSnapshotRequest, opts ...gax.CallOption) (*UpdateSnapshotOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetSnapshot()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetSnapshot().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "snapshot.name", url.QueryEscape(req.GetSnapshot().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateSnapshot")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateSnapshotOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListActiveDirectories lists active directories.
func (c *restClient) ListActiveDirectories(ctx context.Context, req *netapppb.ListActiveDirectoriesRequest, opts ...gax.CallOption) *ActiveDirectoryIterator {
	it := &ActiveDirectoryIterator{}
	req = proto.Clone(req).(*netapppb.ListActiveDirectoriesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.ActiveDirectory, string, error) {
		resp := &netapppb.ListActiveDirectoriesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/activeDirectories", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListActiveDirectories")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetActiveDirectories(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetActiveDirectory describes a specified active directory.
func (c *restClient) GetActiveDirectory(ctx context.Context, req *netapppb.GetActiveDirectoryRequest, opts ...gax.CallOption) (*netapppb.ActiveDirectory, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetActiveDirectory[0:len((*c.CallOptions).GetActiveDirectory):len((*c.CallOptions).GetActiveDirectory)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &netapppb.ActiveDirectory{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetActiveDirectory")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateActiveDirectory createActiveDirectory
// Creates the active directory specified in the request.
func (c *restClient) CreateActiveDirectory(ctx context.Context, req *netapppb.CreateActiveDirectoryRequest, opts ...gax.CallOption) (*CreateActiveDirectoryOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetActiveDirectory()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/activeDirectories", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("activeDirectoryId", fmt.Sprintf("%v", req.GetActiveDirectoryId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateActiveDirectory")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateActiveDirectoryOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateActiveDirectory update the parameters of an active directories.
func (c *restClient) UpdateActiveDirectory(ctx context.Context, req *netapppb.UpdateActiveDirectoryRequest, opts ...gax.CallOption) (*UpdateActiveDirectoryOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetActiveDirectory()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetActiveDirectory().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "active_directory.name", url.QueryEscape(req.GetActiveDirectory().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateActiveDirectory")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateActiveDirectoryOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteActiveDirectory delete the active directory specified in the request.
func (c *restClient) DeleteActiveDirectory(ctx context.Context, req *netapppb.DeleteActiveDirectoryRequest, opts ...gax.CallOption) (*DeleteActiveDirectoryOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteActiveDirectory")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteActiveDirectoryOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListKmsConfigs returns descriptions of all KMS configs owned by the caller.
func (c *restClient) ListKmsConfigs(ctx context.Context, req *netapppb.ListKmsConfigsRequest, opts ...gax.CallOption) *KmsConfigIterator {
	it := &KmsConfigIterator{}
	req = proto.Clone(req).(*netapppb.ListKmsConfigsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.KmsConfig, string, error) {
		resp := &netapppb.ListKmsConfigsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/kmsConfigs", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListKmsConfigs")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetKmsConfigs(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateKmsConfig creates a new KMS config.
func (c *restClient) CreateKmsConfig(ctx context.Context, req *netapppb.CreateKmsConfigRequest, opts ...gax.CallOption) (*CreateKmsConfigOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetKmsConfig()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/kmsConfigs", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("kmsConfigId", fmt.Sprintf("%v", req.GetKmsConfigId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateKmsConfig")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateKmsConfigOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetKmsConfig returns the description of the specified KMS config by kms_config_id.
func (c *restClient) GetKmsConfig(ctx context.Context, req *netapppb.GetKmsConfigRequest, opts ...gax.CallOption) (*netapppb.KmsConfig, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetKmsConfig[0:len((*c.CallOptions).GetKmsConfig):len((*c.CallOptions).GetKmsConfig)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &netapppb.KmsConfig{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetKmsConfig")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateKmsConfig updates the Kms config properties with the full spec
func (c *restClient) UpdateKmsConfig(ctx context.Context, req *netapppb.UpdateKmsConfigRequest, opts ...gax.CallOption) (*UpdateKmsConfigOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetKmsConfig()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetKmsConfig().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "kms_config.name", url.QueryEscape(req.GetKmsConfig().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateKmsConfig")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateKmsConfigOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// EncryptVolumes encrypt the existing volumes without CMEK encryption with the desired the
// KMS config for the whole region.
func (c *restClient) EncryptVolumes(ctx context.Context, req *netapppb.EncryptVolumesRequest, opts ...gax.CallOption) (*EncryptVolumesOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:encrypt", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "EncryptVolumes")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &EncryptVolumesOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// VerifyKmsConfig verifies KMS config reachability.
func (c *restClient) VerifyKmsConfig(ctx context.Context, req *netapppb.VerifyKmsConfigRequest, opts ...gax.CallOption) (*netapppb.VerifyKmsConfigResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:verify", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).VerifyKmsConfig[0:len((*c.CallOptions).VerifyKmsConfig):len((*c.CallOptions).VerifyKmsConfig)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &netapppb.VerifyKmsConfigResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "VerifyKmsConfig")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// DeleteKmsConfig warning! This operation will permanently delete the Kms config.
func (c *restClient) DeleteKmsConfig(ctx context.Context, req *netapppb.DeleteKmsConfigRequest, opts ...gax.CallOption) (*DeleteKmsConfigOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteKmsConfig")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteKmsConfigOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListReplications returns descriptions of all replications for a volume.
func (c *restClient) ListReplications(ctx context.Context, req *netapppb.ListReplicationsRequest, opts ...gax.CallOption) *ReplicationIterator {
	it := &ReplicationIterator{}
	req = proto.Clone(req).(*netapppb.ListReplicationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.Replication, string, error) {
		resp := &netapppb.ListReplicationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/replications", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListReplications")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetReplications(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetReplication describe a replication for a volume.
func (c *restClient) GetReplication(ctx context.Context, req *netapppb.GetReplicationRequest, opts ...gax.CallOption) (*netapppb.Replication, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetReplication[0:len((*c.CallOptions).GetReplication):len((*c.CallOptions).GetReplication)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &netapppb.Replication{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetReplication")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateReplication create a new replication for a volume.
func (c *restClient) CreateReplication(ctx context.Context, req *netapppb.CreateReplicationRequest, opts ...gax.CallOption) (*CreateReplicationOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetReplication()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/replications", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("replicationId", fmt.Sprintf("%v", req.GetReplicationId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateReplication")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateReplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteReplication deletes a replication.
func (c *restClient) DeleteReplication(ctx context.Context, req *netapppb.DeleteReplicationRequest, opts ...gax.CallOption) (*DeleteReplicationOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteReplication")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteReplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateReplication updates the settings of a specific replication.
func (c *restClient) UpdateReplication(ctx context.Context, req *netapppb.UpdateReplicationRequest, opts ...gax.CallOption) (*UpdateReplicationOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetReplication()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetReplication().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "replication.name", url.QueryEscape(req.GetReplication().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateReplication")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateReplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// StopReplication stop Cross Region Replication.
func (c *restClient) StopReplication(ctx context.Context, req *netapppb.StopReplicationRequest, opts ...gax.CallOption) (*StopReplicationOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:stop", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "StopReplication")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &StopReplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ResumeReplication resume Cross Region Replication.
func (c *restClient) ResumeReplication(ctx context.Context, req *netapppb.ResumeReplicationRequest, opts ...gax.CallOption) (*ResumeReplicationOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:resume", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "ResumeReplication")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &ResumeReplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ReverseReplicationDirection reverses direction of replication. Source becomes destination and
// destination becomes source.
func (c *restClient) ReverseReplicationDirection(ctx context.Context, req *netapppb.ReverseReplicationDirectionRequest, opts ...gax.CallOption) (*ReverseReplicationDirectionOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:reverseDirection", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "ReverseReplicationDirection")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &ReverseReplicationDirectionOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// EstablishPeering establish replication peering.
func (c *restClient) EstablishPeering(ctx context.Context, req *netapppb.EstablishPeeringRequest, opts ...gax.CallOption) (*EstablishPeeringOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:establishPeering", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "EstablishPeering")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &EstablishPeeringOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// SyncReplication syncs the replication. This will invoke one time volume data transfer from
// source to destination.
func (c *restClient) SyncReplication(ctx context.Context, req *netapppb.SyncReplicationRequest, opts ...gax.CallOption) (*SyncReplicationOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:sync", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "SyncReplication")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &SyncReplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// CreateBackupVault creates new backup vault
func (c *restClient) CreateBackupVault(ctx context.Context, req *netapppb.CreateBackupVaultRequest, opts ...gax.CallOption) (*CreateBackupVaultOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetBackupVault()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/backupVaults", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("backupVaultId", fmt.Sprintf("%v", req.GetBackupVaultId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateBackupVault")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateBackupVaultOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetBackupVault returns the description of the specified backup vault
func (c *restClient) GetBackupVault(ctx context.Context, req *netapppb.GetBackupVaultRequest, opts ...gax.CallOption) (*netapppb.BackupVault, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetBackupVault[0:len((*c.CallOptions).GetBackupVault):len((*c.CallOptions).GetBackupVault)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &netapppb.BackupVault{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetBackupVault")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListBackupVaults returns list of all available backup vaults.
func (c *restClient) ListBackupVaults(ctx context.Context, req *netapppb.ListBackupVaultsRequest, opts ...gax.CallOption) *BackupVaultIterator {
	it := &BackupVaultIterator{}
	req = proto.Clone(req).(*netapppb.ListBackupVaultsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.BackupVault, string, error) {
		resp := &netapppb.ListBackupVaultsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/backupVaults", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListBackupVaults")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetBackupVaults(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// UpdateBackupVault updates the settings of a specific backup vault.
func (c *restClient) UpdateBackupVault(ctx context.Context, req *netapppb.UpdateBackupVaultRequest, opts ...gax.CallOption) (*UpdateBackupVaultOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetBackupVault()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetBackupVault().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "backup_vault.name", url.QueryEscape(req.GetBackupVault().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateBackupVault")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateBackupVaultOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteBackupVault warning! This operation will permanently delete the backup vault.
func (c *restClient) DeleteBackupVault(ctx context.Context, req *netapppb.DeleteBackupVaultRequest, opts ...gax.CallOption) (*DeleteBackupVaultOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteBackupVault")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteBackupVaultOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// CreateBackup creates a backup from the volume specified in the request
// The backup can be created from the given snapshot if specified in the
// request. If no snapshot specified, there’ll be a new snapshot taken to
// initiate the backup creation.
func (c *restClient) CreateBackup(ctx context.Context, req *netapppb.CreateBackupRequest, opts ...gax.CallOption) (*CreateBackupOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetBackup()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/backups", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("backupId", fmt.Sprintf("%v", req.GetBackupId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateBackup")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateBackupOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetBackup returns the description of the specified backup
func (c *restClient) GetBackup(ctx context.Context, req *netapppb.GetBackupRequest, opts ...gax.CallOption) (*netapppb.Backup, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetBackup[0:len((*c.CallOptions).GetBackup):len((*c.CallOptions).GetBackup)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &netapppb.Backup{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetBackup")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListBackups returns descriptions of all backups for a backupVault.
func (c *restClient) ListBackups(ctx context.Context, req *netapppb.ListBackupsRequest, opts ...gax.CallOption) *BackupIterator {
	it := &BackupIterator{}
	req = proto.Clone(req).(*netapppb.ListBackupsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.Backup, string, error) {
		resp := &netapppb.ListBackupsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/backups", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListBackups")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetBackups(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// DeleteBackup warning! This operation will permanently delete the backup.
func (c *restClient) DeleteBackup(ctx context.Context, req *netapppb.DeleteBackupRequest, opts ...gax.CallOption) (*DeleteBackupOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteBackup")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteBackupOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateBackup update backup with full spec.
func (c *restClient) UpdateBackup(ctx context.Context, req *netapppb.UpdateBackupRequest, opts ...gax.CallOption) (*UpdateBackupOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetBackup()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetBackup().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "backup.name", url.QueryEscape(req.GetBackup().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateBackup")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateBackupOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// CreateBackupPolicy creates new backup policy
func (c *restClient) CreateBackupPolicy(ctx context.Context, req *netapppb.CreateBackupPolicyRequest, opts ...gax.CallOption) (*CreateBackupPolicyOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetBackupPolicy()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/backupPolicies", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("backupPolicyId", fmt.Sprintf("%v", req.GetBackupPolicyId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateBackupPolicy")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateBackupPolicyOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetBackupPolicy returns the description of the specified backup policy by backup_policy_id.
func (c *restClient) GetBackupPolicy(ctx context.Context, req *netapppb.GetBackupPolicyRequest, opts ...gax.CallOption) (*netapppb.BackupPolicy, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetBackupPolicy[0:len((*c.CallOptions).GetBackupPolicy):len((*c.CallOptions).GetBackupPolicy)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &netapppb.BackupPolicy{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetBackupPolicy")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListBackupPolicies returns list of all available backup policies.
func (c *restClient) ListBackupPolicies(ctx context.Context, req *netapppb.ListBackupPoliciesRequest, opts ...gax.CallOption) *BackupPolicyIterator {
	it := &BackupPolicyIterator{}
	req = proto.Clone(req).(*netapppb.ListBackupPoliciesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.BackupPolicy, string, error) {
		resp := &netapppb.ListBackupPoliciesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/backupPolicies", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListBackupPolicies")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetBackupPolicies(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// UpdateBackupPolicy updates settings of a specific backup policy.
func (c *restClient) UpdateBackupPolicy(ctx context.Context, req *netapppb.UpdateBackupPolicyRequest, opts ...gax.CallOption) (*UpdateBackupPolicyOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetBackupPolicy()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetBackupPolicy().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "backup_policy.name", url.QueryEscape(req.GetBackupPolicy().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateBackupPolicy")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateBackupPolicyOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteBackupPolicy warning! This operation will permanently delete the backup policy.
func (c *restClient) DeleteBackupPolicy(ctx context.Context, req *netapppb.DeleteBackupPolicyRequest, opts ...gax.CallOption) (*DeleteBackupPolicyOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteBackupPolicy")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteBackupPolicyOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListQuotaRules returns list of all quota rules in a location.
func (c *restClient) ListQuotaRules(ctx context.Context, req *netapppb.ListQuotaRulesRequest, opts ...gax.CallOption) *QuotaRuleIterator {
	it := &QuotaRuleIterator{}
	req = proto.Clone(req).(*netapppb.ListQuotaRulesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.QuotaRule, string, error) {
		resp := &netapppb.ListQuotaRulesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/quotaRules", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListQuotaRules")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetQuotaRules(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetQuotaRule returns details of the specified quota rule.
func (c *restClient) GetQuotaRule(ctx context.Context, req *netapppb.GetQuotaRuleRequest, opts ...gax.CallOption) (*netapppb.QuotaRule, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetQuotaRule[0:len((*c.CallOptions).GetQuotaRule):len((*c.CallOptions).GetQuotaRule)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &netapppb.QuotaRule{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetQuotaRule")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateQuotaRule creates a new quota rule.
func (c *restClient) CreateQuotaRule(ctx context.Context, req *netapppb.CreateQuotaRuleRequest, opts ...gax.CallOption) (*CreateQuotaRuleOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetQuotaRule()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/quotaRules", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("quotaRuleId", fmt.Sprintf("%v", req.GetQuotaRuleId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateQuotaRule")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateQuotaRuleOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateQuotaRule updates a quota rule.
func (c *restClient) UpdateQuotaRule(ctx context.Context, req *netapppb.UpdateQuotaRuleRequest, opts ...gax.CallOption) (*UpdateQuotaRuleOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetQuotaRule()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetQuotaRule().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "quota_rule.name", url.QueryEscape(req.GetQuotaRule().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateQuotaRule")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateQuotaRuleOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteQuotaRule deletes a quota rule.
func (c *restClient) DeleteQuotaRule(ctx context.Context, req *netapppb.DeleteQuotaRuleRequest, opts ...gax.CallOption) (*DeleteQuotaRuleOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteQuotaRule")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteQuotaRuleOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetLocation gets information about a location.
func (c *restClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &locationpb.Location{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetLocation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListLocations lists information about the supported locations for this service.
func (c *restClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/locations", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListLocations")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *restClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:cancel", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CancelOperation")
		return err
	}, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *restClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteOperation")
		return err
	}, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *restClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetOperation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *restClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/operations", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListOperations")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateActiveDirectoryOperation returns a new CreateActiveDirectoryOperation from a given name.
// The name must be that of a previously created CreateActiveDirectoryOperation, possibly from a different process.
func (c *gRPCClient) CreateActiveDirectoryOperation(name string) *CreateActiveDirectoryOperation {
	return &CreateActiveDirectoryOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateActiveDirectoryOperation returns a new CreateActiveDirectoryOperation from a given name.
// The name must be that of a previously created CreateActiveDirectoryOperation, possibly from a different process.
func (c *restClient) CreateActiveDirectoryOperation(name string) *CreateActiveDirectoryOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateActiveDirectoryOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateBackupOperation returns a new CreateBackupOperation from a given name.
// The name must be that of a previously created CreateBackupOperation, possibly from a different process.
func (c *gRPCClient) CreateBackupOperation(name string) *CreateBackupOperation {
	return &CreateBackupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateBackupOperation returns a new CreateBackupOperation from a given name.
// The name must be that of a previously created CreateBackupOperation, possibly from a different process.
func (c *restClient) CreateBackupOperation(name string) *CreateBackupOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateBackupOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateBackupPolicyOperation returns a new CreateBackupPolicyOperation from a given name.
// The name must be that of a previously created CreateBackupPolicyOperation, possibly from a different process.
func (c *gRPCClient) CreateBackupPolicyOperation(name string) *CreateBackupPolicyOperation {
	return &CreateBackupPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateBackupPolicyOperation returns a new CreateBackupPolicyOperation from a given name.
// The name must be that of a previously created CreateBackupPolicyOperation, possibly from a different process.
func (c *restClient) CreateBackupPolicyOperation(name string) *CreateBackupPolicyOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateBackupPolicyOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateBackupVaultOperation returns a new CreateBackupVaultOperation from a given name.
// The name must be that of a previously created CreateBackupVaultOperation, possibly from a different process.
func (c *gRPCClient) CreateBackupVaultOperation(name string) *CreateBackupVaultOperation {
	return &CreateBackupVaultOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateBackupVaultOperation returns a new CreateBackupVaultOperation from a given name.
// The name must be that of a previously created CreateBackupVaultOperation, possibly from a different process.
func (c *restClient) CreateBackupVaultOperation(name string) *CreateBackupVaultOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateBackupVaultOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateKmsConfigOperation returns a new CreateKmsConfigOperation from a given name.
// The name must be that of a previously created CreateKmsConfigOperation, possibly from a different process.
func (c *gRPCClient) CreateKmsConfigOperation(name string) *CreateKmsConfigOperation {
	return &CreateKmsConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateKmsConfigOperation returns a new CreateKmsConfigOperation from a given name.
// The name must be that of a previously created CreateKmsConfigOperation, possibly from a different process.
func (c *restClient) CreateKmsConfigOperation(name string) *CreateKmsConfigOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateKmsConfigOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateQuotaRuleOperation returns a new CreateQuotaRuleOperation from a given name.
// The name must be that of a previously created CreateQuotaRuleOperation, possibly from a different process.
func (c *gRPCClient) CreateQuotaRuleOperation(name string) *CreateQuotaRuleOperation {
	return &CreateQuotaRuleOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateQuotaRuleOperation returns a new CreateQuotaRuleOperation from a given name.
// The name must be that of a previously created CreateQuotaRuleOperation, possibly from a different process.
func (c *restClient) CreateQuotaRuleOperation(name string) *CreateQuotaRuleOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateQuotaRuleOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateReplicationOperation returns a new CreateReplicationOperation from a given name.
// The name must be that of a previously created CreateReplicationOperation, possibly from a different process.
func (c *gRPCClient) CreateReplicationOperation(name string) *CreateReplicationOperation {
	return &CreateReplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateReplicationOperation returns a new CreateReplicationOperation from a given name.
// The name must be that of a previously created CreateReplicationOperation, possibly from a different process.
func (c *restClient) CreateReplicationOperation(name string) *CreateReplicationOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateReplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateSnapshotOperation returns a new CreateSnapshotOperation from a given name.
// The name must be that of a previously created CreateSnapshotOperation, possibly from a different process.
func (c *gRPCClient) CreateSnapshotOperation(name string) *CreateSnapshotOperation {
	return &CreateSnapshotOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateSnapshotOperation returns a new CreateSnapshotOperation from a given name.
// The name must be that of a previously created CreateSnapshotOperation, possibly from a different process.
func (c *restClient) CreateSnapshotOperation(name string) *CreateSnapshotOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateSnapshotOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateStoragePoolOperation returns a new CreateStoragePoolOperation from a given name.
// The name must be that of a previously created CreateStoragePoolOperation, possibly from a different process.
func (c *gRPCClient) CreateStoragePoolOperation(name string) *CreateStoragePoolOperation {
	return &CreateStoragePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateStoragePoolOperation returns a new CreateStoragePoolOperation from a given name.
// The name must be that of a previously created CreateStoragePoolOperation, possibly from a different process.
func (c *restClient) CreateStoragePoolOperation(name string) *CreateStoragePoolOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateStoragePoolOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateVolumeOperation returns a new CreateVolumeOperation from a given name.
// The name must be that of a previously created CreateVolumeOperation, possibly from a different process.
func (c *gRPCClient) CreateVolumeOperation(name string) *CreateVolumeOperation {
	return &CreateVolumeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateVolumeOperation returns a new CreateVolumeOperation from a given name.
// The name must be that of a previously created CreateVolumeOperation, possibly from a different process.
func (c *restClient) CreateVolumeOperation(name string) *CreateVolumeOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateVolumeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteActiveDirectoryOperation returns a new DeleteActiveDirectoryOperation from a given name.
// The name must be that of a previously created DeleteActiveDirectoryOperation, possibly from a different process.
func (c *gRPCClient) DeleteActiveDirectoryOperation(name string) *DeleteActiveDirectoryOperation {
	return &DeleteActiveDirectoryOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteActiveDirectoryOperation returns a new DeleteActiveDirectoryOperation from a given name.
// The name must be that of a previously created DeleteActiveDirectoryOperation, possibly from a different process.
func (c *restClient) DeleteActiveDirectoryOperation(name string) *DeleteActiveDirectoryOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteActiveDirectoryOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteBackupOperation returns a new DeleteBackupOperation from a given name.
// The name must be that of a previously created DeleteBackupOperation, possibly from a different process.
func (c *gRPCClient) DeleteBackupOperation(name string) *DeleteBackupOperation {
	return &DeleteBackupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteBackupOperation returns a new DeleteBackupOperation from a given name.
// The name must be that of a previously created DeleteBackupOperation, possibly from a different process.
func (c *restClient) DeleteBackupOperation(name string) *DeleteBackupOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteBackupOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteBackupPolicyOperation returns a new DeleteBackupPolicyOperation from a given name.
// The name must be that of a previously created DeleteBackupPolicyOperation, possibly from a different process.
func (c *gRPCClient) DeleteBackupPolicyOperation(name string) *DeleteBackupPolicyOperation {
	return &DeleteBackupPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteBackupPolicyOperation returns a new DeleteBackupPolicyOperation from a given name.
// The name must be that of a previously created DeleteBackupPolicyOperation, possibly from a different process.
func (c *restClient) DeleteBackupPolicyOperation(name string) *DeleteBackupPolicyOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteBackupPolicyOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteBackupVaultOperation returns a new DeleteBackupVaultOperation from a given name.
// The name must be that of a previously created DeleteBackupVaultOperation, possibly from a different process.
func (c *gRPCClient) DeleteBackupVaultOperation(name string) *DeleteBackupVaultOperation {
	return &DeleteBackupVaultOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteBackupVaultOperation returns a new DeleteBackupVaultOperation from a given name.
// The name must be that of a previously created DeleteBackupVaultOperation, possibly from a different process.
func (c *restClient) DeleteBackupVaultOperation(name string) *DeleteBackupVaultOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteBackupVaultOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteKmsConfigOperation returns a new DeleteKmsConfigOperation from a given name.
// The name must be that of a previously created DeleteKmsConfigOperation, possibly from a different process.
func (c *gRPCClient) DeleteKmsConfigOperation(name string) *DeleteKmsConfigOperation {
	return &DeleteKmsConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteKmsConfigOperation returns a new DeleteKmsConfigOperation from a given name.
// The name must be that of a previously created DeleteKmsConfigOperation, possibly from a different process.
func (c *restClient) DeleteKmsConfigOperation(name string) *DeleteKmsConfigOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteKmsConfigOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteQuotaRuleOperation returns a new DeleteQuotaRuleOperation from a given name.
// The name must be that of a previously created DeleteQuotaRuleOperation, possibly from a different process.
func (c *gRPCClient) DeleteQuotaRuleOperation(name string) *DeleteQuotaRuleOperation {
	return &DeleteQuotaRuleOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteQuotaRuleOperation returns a new DeleteQuotaRuleOperation from a given name.
// The name must be that of a previously created DeleteQuotaRuleOperation, possibly from a different process.
func (c *restClient) DeleteQuotaRuleOperation(name string) *DeleteQuotaRuleOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteQuotaRuleOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteReplicationOperation returns a new DeleteReplicationOperation from a given name.
// The name must be that of a previously created DeleteReplicationOperation, possibly from a different process.
func (c *gRPCClient) DeleteReplicationOperation(name string) *DeleteReplicationOperation {
	return &DeleteReplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteReplicationOperation returns a new DeleteReplicationOperation from a given name.
// The name must be that of a previously created DeleteReplicationOperation, possibly from a different process.
func (c *restClient) DeleteReplicationOperation(name string) *DeleteReplicationOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteReplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteSnapshotOperation returns a new DeleteSnapshotOperation from a given name.
// The name must be that of a previously created DeleteSnapshotOperation, possibly from a different process.
func (c *gRPCClient) DeleteSnapshotOperation(name string) *DeleteSnapshotOperation {
	return &DeleteSnapshotOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteSnapshotOperation returns a new DeleteSnapshotOperation from a given name.
// The name must be that of a previously created DeleteSnapshotOperation, possibly from a different process.
func (c *restClient) DeleteSnapshotOperation(name string) *DeleteSnapshotOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteSnapshotOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteStoragePoolOperation returns a new DeleteStoragePoolOperation from a given name.
// The name must be that of a previously created DeleteStoragePoolOperation, possibly from a different process.
func (c *gRPCClient) DeleteStoragePoolOperation(name string) *DeleteStoragePoolOperation {
	return &DeleteStoragePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteStoragePoolOperation returns a new DeleteStoragePoolOperation from a given name.
// The name must be that of a previously created DeleteStoragePoolOperation, possibly from a different process.
func (c *restClient) DeleteStoragePoolOperation(name string) *DeleteStoragePoolOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteStoragePoolOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteVolumeOperation returns a new DeleteVolumeOperation from a given name.
// The name must be that of a previously created DeleteVolumeOperation, possibly from a different process.
func (c *gRPCClient) DeleteVolumeOperation(name string) *DeleteVolumeOperation {
	return &DeleteVolumeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteVolumeOperation returns a new DeleteVolumeOperation from a given name.
// The name must be that of a previously created DeleteVolumeOperation, possibly from a different process.
func (c *restClient) DeleteVolumeOperation(name string) *DeleteVolumeOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteVolumeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// EncryptVolumesOperation returns a new EncryptVolumesOperation from a given name.
// The name must be that of a previously created EncryptVolumesOperation, possibly from a different process.
func (c *gRPCClient) EncryptVolumesOperation(name string) *EncryptVolumesOperation {
	return &EncryptVolumesOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// EncryptVolumesOperation returns a new EncryptVolumesOperation from a given name.
// The name must be that of a previously created EncryptVolumesOperation, possibly from a different process.
func (c *restClient) EncryptVolumesOperation(name string) *EncryptVolumesOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &EncryptVolumesOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// EstablishPeeringOperation returns a new EstablishPeeringOperation from a given name.
// The name must be that of a previously created EstablishPeeringOperation, possibly from a different process.
func (c *gRPCClient) EstablishPeeringOperation(name string) *EstablishPeeringOperation {
	return &EstablishPeeringOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// EstablishPeeringOperation returns a new EstablishPeeringOperation from a given name.
// The name must be that of a previously created EstablishPeeringOperation, possibly from a different process.
func (c *restClient) EstablishPeeringOperation(name string) *EstablishPeeringOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &EstablishPeeringOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// ResumeReplicationOperation returns a new ResumeReplicationOperation from a given name.
// The name must be that of a previously created ResumeReplicationOperation, possibly from a different process.
func (c *gRPCClient) ResumeReplicationOperation(name string) *ResumeReplicationOperation {
	return &ResumeReplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ResumeReplicationOperation returns a new ResumeReplicationOperation from a given name.
// The name must be that of a previously created ResumeReplicationOperation, possibly from a different process.
func (c *restClient) ResumeReplicationOperation(name string) *ResumeReplicationOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &ResumeReplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// ReverseReplicationDirectionOperation returns a new ReverseReplicationDirectionOperation from a given name.
// The name must be that of a previously created ReverseReplicationDirectionOperation, possibly from a different process.
func (c *gRPCClient) ReverseReplicationDirectionOperation(name string) *ReverseReplicationDirectionOperation {
	return &ReverseReplicationDirectionOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ReverseReplicationDirectionOperation returns a new ReverseReplicationDirectionOperation from a given name.
// The name must be that of a previously created ReverseReplicationDirectionOperation, possibly from a different process.
func (c *restClient) ReverseReplicationDirectionOperation(name string) *ReverseReplicationDirectionOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &ReverseReplicationDirectionOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// RevertVolumeOperation returns a new RevertVolumeOperation from a given name.
// The name must be that of a previously created RevertVolumeOperation, possibly from a different process.
func (c *gRPCClient) RevertVolumeOperation(name string) *RevertVolumeOperation {
	return &RevertVolumeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// RevertVolumeOperation returns a new RevertVolumeOperation from a given name.
// The name must be that of a previously created RevertVolumeOperation, possibly from a different process.
func (c *restClient) RevertVolumeOperation(name string) *RevertVolumeOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &RevertVolumeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// StopReplicationOperation returns a new StopReplicationOperation from a given name.
// The name must be that of a previously created StopReplicationOperation, possibly from a different process.
func (c *gRPCClient) StopReplicationOperation(name string) *StopReplicationOperation {
	return &StopReplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// StopReplicationOperation returns a new StopReplicationOperation from a given name.
// The name must be that of a previously created StopReplicationOperation, possibly from a different process.
func (c *restClient) StopReplicationOperation(name string) *StopReplicationOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &StopReplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// SwitchActiveReplicaZoneOperation returns a new SwitchActiveReplicaZoneOperation from a given name.
// The name must be that of a previously created SwitchActiveReplicaZoneOperation, possibly from a different process.
func (c *gRPCClient) SwitchActiveReplicaZoneOperation(name string) *SwitchActiveReplicaZoneOperation {
	return &SwitchActiveReplicaZoneOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// SwitchActiveReplicaZoneOperation returns a new SwitchActiveReplicaZoneOperation from a given name.
// The name must be that of a previously created SwitchActiveReplicaZoneOperation, possibly from a different process.
func (c *restClient) SwitchActiveReplicaZoneOperation(name string) *SwitchActiveReplicaZoneOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &SwitchActiveReplicaZoneOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// SyncReplicationOperation returns a new SyncReplicationOperation from a given name.
// The name must be that of a previously created SyncReplicationOperation, possibly from a different process.
func (c *gRPCClient) SyncReplicationOperation(name string) *SyncReplicationOperation {
	return &SyncReplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// SyncReplicationOperation returns a new SyncReplicationOperation from a given name.
// The name must be that of a previously created SyncReplicationOperation, possibly from a different process.
func (c *restClient) SyncReplicationOperation(name string) *SyncReplicationOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &SyncReplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateActiveDirectoryOperation returns a new UpdateActiveDirectoryOperation from a given name.
// The name must be that of a previously created UpdateActiveDirectoryOperation, possibly from a different process.
func (c *gRPCClient) UpdateActiveDirectoryOperation(name string) *UpdateActiveDirectoryOperation {
	return &UpdateActiveDirectoryOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateActiveDirectoryOperation returns a new UpdateActiveDirectoryOperation from a given name.
// The name must be that of a previously created UpdateActiveDirectoryOperation, possibly from a different process.
func (c *restClient) UpdateActiveDirectoryOperation(name string) *UpdateActiveDirectoryOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateActiveDirectoryOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateBackupOperation returns a new UpdateBackupOperation from a given name.
// The name must be that of a previously created UpdateBackupOperation, possibly from a different process.
func (c *gRPCClient) UpdateBackupOperation(name string) *UpdateBackupOperation {
	return &UpdateBackupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateBackupOperation returns a new UpdateBackupOperation from a given name.
// The name must be that of a previously created UpdateBackupOperation, possibly from a different process.
func (c *restClient) UpdateBackupOperation(name string) *UpdateBackupOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateBackupOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateBackupPolicyOperation returns a new UpdateBackupPolicyOperation from a given name.
// The name must be that of a previously created UpdateBackupPolicyOperation, possibly from a different process.
func (c *gRPCClient) UpdateBackupPolicyOperation(name string) *UpdateBackupPolicyOperation {
	return &UpdateBackupPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateBackupPolicyOperation returns a new UpdateBackupPolicyOperation from a given name.
// The name must be that of a previously created UpdateBackupPolicyOperation, possibly from a different process.
func (c *restClient) UpdateBackupPolicyOperation(name string) *UpdateBackupPolicyOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateBackupPolicyOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateBackupVaultOperation returns a new UpdateBackupVaultOperation from a given name.
// The name must be that of a previously created UpdateBackupVaultOperation, possibly from a different process.
func (c *gRPCClient) UpdateBackupVaultOperation(name string) *UpdateBackupVaultOperation {
	return &UpdateBackupVaultOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateBackupVaultOperation returns a new UpdateBackupVaultOperation from a given name.
// The name must be that of a previously created UpdateBackupVaultOperation, possibly from a different process.
func (c *restClient) UpdateBackupVaultOperation(name string) *UpdateBackupVaultOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateBackupVaultOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateKmsConfigOperation returns a new UpdateKmsConfigOperation from a given name.
// The name must be that of a previously created UpdateKmsConfigOperation, possibly from a different process.
func (c *gRPCClient) UpdateKmsConfigOperation(name string) *UpdateKmsConfigOperation {
	return &UpdateKmsConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateKmsConfigOperation returns a new UpdateKmsConfigOperation from a given name.
// The name must be that of a previously created UpdateKmsConfigOperation, possibly from a different process.
func (c *restClient) UpdateKmsConfigOperation(name string) *UpdateKmsConfigOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateKmsConfigOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateQuotaRuleOperation returns a new UpdateQuotaRuleOperation from a given name.
// The name must be that of a previously created UpdateQuotaRuleOperation, possibly from a different process.
func (c *gRPCClient) UpdateQuotaRuleOperation(name string) *UpdateQuotaRuleOperation {
	return &UpdateQuotaRuleOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateQuotaRuleOperation returns a new UpdateQuotaRuleOperation from a given name.
// The name must be that of a previously created UpdateQuotaRuleOperation, possibly from a different process.
func (c *restClient) UpdateQuotaRuleOperation(name string) *UpdateQuotaRuleOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateQuotaRuleOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateReplicationOperation returns a new UpdateReplicationOperation from a given name.
// The name must be that of a previously created UpdateReplicationOperation, possibly from a different process.
func (c *gRPCClient) UpdateReplicationOperation(name string) *UpdateReplicationOperation {
	return &UpdateReplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateReplicationOperation returns a new UpdateReplicationOperation from a given name.
// The name must be that of a previously created UpdateReplicationOperation, possibly from a different process.
func (c *restClient) UpdateReplicationOperation(name string) *UpdateReplicationOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateReplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateSnapshotOperation returns a new UpdateSnapshotOperation from a given name.
// The name must be that of a previously created UpdateSnapshotOperation, possibly from a different process.
func (c *gRPCClient) UpdateSnapshotOperation(name string) *UpdateSnapshotOperation {
	return &UpdateSnapshotOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateSnapshotOperation returns a new UpdateSnapshotOperation from a given name.
// The name must be that of a previously created UpdateSnapshotOperation, possibly from a different process.
func (c *restClient) UpdateSnapshotOperation(name string) *UpdateSnapshotOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateSnapshotOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateStoragePoolOperation returns a new UpdateStoragePoolOperation from a given name.
// The name must be that of a previously created UpdateStoragePoolOperation, possibly from a different process.
func (c *gRPCClient) UpdateStoragePoolOperation(name string) *UpdateStoragePoolOperation {
	return &UpdateStoragePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateStoragePoolOperation returns a new UpdateStoragePoolOperation from a given name.
// The name must be that of a previously created UpdateStoragePoolOperation, possibly from a different process.
func (c *restClient) UpdateStoragePoolOperation(name string) *UpdateStoragePoolOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateStoragePoolOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateVolumeOperation returns a new UpdateVolumeOperation from a given name.
// The name must be that of a previously created UpdateVolumeOperation, possibly from a different process.
func (c *gRPCClient) UpdateVolumeOperation(name string) *UpdateVolumeOperation {
	return &UpdateVolumeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateVolumeOperation returns a new UpdateVolumeOperation from a given name.
// The name must be that of a previously created UpdateVolumeOperation, possibly from a different process.
func (c *restClient) UpdateVolumeOperation(name string) *UpdateVolumeOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateVolumeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// ValidateDirectoryServiceOperation returns a new ValidateDirectoryServiceOperation from a given name.
// The name must be that of a previously created ValidateDirectoryServiceOperation, possibly from a different process.
func (c *gRPCClient) ValidateDirectoryServiceOperation(name string) *ValidateDirectoryServiceOperation {
	return &ValidateDirectoryServiceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ValidateDirectoryServiceOperation returns a new ValidateDirectoryServiceOperation from a given name.
// The name must be that of a previously created ValidateDirectoryServiceOperation, possibly from a different process.
func (c *restClient) ValidateDirectoryServiceOperation(name string) *ValidateDirectoryServiceOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &ValidateDirectoryServiceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}
