// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/discoveryengine/v1beta/grounded_generation_service.proto

package discoveryenginepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The version of the predictor to be used in dynamic retrieval.
type GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor_Version int32

const (
	// Automatically choose the best version of the retrieval predictor.
	GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor_VERSION_UNSPECIFIED GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor_Version = 0
	// The V1 model which is evaluating each source independently.
	GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor_V1_INDEPENDENT GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor_Version = 1
)

// Enum value maps for GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor_Version.
var (
	GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor_Version_name = map[int32]string{
		0: "VERSION_UNSPECIFIED",
		1: "V1_INDEPENDENT",
	}
	GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor_Version_value = map[string]int32{
		"VERSION_UNSPECIFIED": 0,
		"V1_INDEPENDENT":      1,
	}
)

func (x GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor_Version) Enum() *GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor_Version {
	p := new(GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor_Version)
	*p = x
	return p
}

func (x GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor_Version) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor_Version) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_enumTypes[0].Descriptor()
}

func (GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor_Version) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_enumTypes[0]
}

func (x GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor_Version) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor_Version.Descriptor instead.
func (GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor_Version) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP(), []int{1, 1, 0, 0}
}

// Describes the source to which the metadata is associated to.
type GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_Source int32

const (
	// Unspecified source.
	GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_SOURCE_UNSPECIFIED GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_Source = 0
	// Vertex AI search.
	GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_VERTEX_AI_SEARCH GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_Source = 1
	// Google Search.
	GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_GOOGLE_SEARCH GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_Source = 3
	// User inline provided content.
	GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_INLINE_CONTENT GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_Source = 2
	// Google Maps.
	GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_GOOGLE_MAPS GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_Source = 4
)

// Enum value maps for GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_Source.
var (
	GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_Source_name = map[int32]string{
		0: "SOURCE_UNSPECIFIED",
		1: "VERTEX_AI_SEARCH",
		3: "GOOGLE_SEARCH",
		2: "INLINE_CONTENT",
		4: "GOOGLE_MAPS",
	}
	GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_Source_value = map[string]int32{
		"SOURCE_UNSPECIFIED": 0,
		"VERTEX_AI_SEARCH":   1,
		"GOOGLE_SEARCH":      3,
		"INLINE_CONTENT":     2,
		"GOOGLE_MAPS":        4,
	}
)

func (x GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_Source) Enum() *GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_Source {
	p := new(GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_Source)
	*p = x
	return p
}

func (x GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_Source) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_Source) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_enumTypes[1].Descriptor()
}

func (GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_Source) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_enumTypes[1]
}

func (x GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_Source) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_Source.Descriptor instead.
func (GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_Source) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP(), []int{2, 0, 0, 0, 0}
}

// The version of the predictor which was used in dynamic retrieval.
type GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata_Version int32

const (
	// Unspecified version, should never be used.
	GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata_VERSION_UNSPECIFIED GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata_Version = 0
	// The V1 model which is evaluating each source independently.
	GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata_V1_INDEPENDENT GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata_Version = 1
)

// Enum value maps for GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata_Version.
var (
	GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata_Version_name = map[int32]string{
		0: "VERSION_UNSPECIFIED",
		1: "V1_INDEPENDENT",
	}
	GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata_Version_value = map[string]int32{
		"VERSION_UNSPECIFIED": 0,
		"V1_INDEPENDENT":      1,
	}
)

func (x GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata_Version) Enum() *GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata_Version {
	p := new(GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata_Version)
	*p = x
	return p
}

func (x GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata_Version) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata_Version) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_enumTypes[2].Descriptor()
}

func (GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata_Version) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_enumTypes[2]
}

func (x GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata_Version) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata_Version.Descriptor instead.
func (GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata_Version) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP(), []int{2, 0, 0, 2, 0}
}

// Base structured datatype containing multi-part content of a message.
type GroundedGenerationContent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Producer of the content. Must be either `user` or `model`.
	//
	// Intended to be used for multi-turn conversations. Otherwise, it can be left
	// unset.
	Role string `protobuf:"bytes,1,opt,name=role,proto3" json:"role,omitempty"`
	// Ordered `Parts` that constitute a single message.
	Parts []*GroundedGenerationContent_Part `protobuf:"bytes,2,rep,name=parts,proto3" json:"parts,omitempty"`
}

func (x *GroundedGenerationContent) Reset() {
	*x = GroundedGenerationContent{}
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroundedGenerationContent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroundedGenerationContent) ProtoMessage() {}

func (x *GroundedGenerationContent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroundedGenerationContent.ProtoReflect.Descriptor instead.
func (*GroundedGenerationContent) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP(), []int{0}
}

func (x *GroundedGenerationContent) GetRole() string {
	if x != nil {
		return x.Role
	}
	return ""
}

func (x *GroundedGenerationContent) GetParts() []*GroundedGenerationContent_Part {
	if x != nil {
		return x.Parts
	}
	return nil
}

// Top-level message sent by the client for the `GenerateGroundedContent`
// method.
type GenerateGroundedContentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Location resource.
	//
	// Format: `projects/{project}/locations/{location}`.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// Content of the system instruction for the current API.
	//
	// These instructions will take priority over any other prompt instructions
	// if the selected model is supporting them.
	SystemInstruction *GroundedGenerationContent `protobuf:"bytes,5,opt,name=system_instruction,json=systemInstruction,proto3" json:"system_instruction,omitempty"`
	// Content of the current conversation with the model.
	//
	// For single-turn queries, this is a single instance. For multi-turn queries,
	// this is a repeated field that contains conversation history + latest
	// request.
	Contents []*GroundedGenerationContent `protobuf:"bytes,2,rep,name=contents,proto3" json:"contents,omitempty"`
	// Content generation specification.
	GenerationSpec *GenerateGroundedContentRequest_GenerationSpec `protobuf:"bytes,3,opt,name=generation_spec,json=generationSpec,proto3" json:"generation_spec,omitempty"`
	// Grounding specification.
	GroundingSpec *GenerateGroundedContentRequest_GroundingSpec `protobuf:"bytes,4,opt,name=grounding_spec,json=groundingSpec,proto3" json:"grounding_spec,omitempty"`
	// The user labels applied to a resource must meet the following requirements:
	//
	//   - Each resource can have multiple labels, up to a maximum of 64.
	//   - Each label must be a key-value pair.
	//   - Keys have a minimum length of 1 character and a maximum length of 63
	//     characters and cannot be empty. Values can be empty and have a maximum
	//     length of 63 characters.
	//   - Keys and values can contain only lowercase letters, numeric characters,
	//     underscores, and dashes. All characters must use UTF-8 encoding, and
	//     international characters are allowed.
	//   - The key portion of a label must be unique. However, you can use the same
	//     key with multiple resources.
	//   - Keys must start with a lowercase letter or international character.
	//
	// See [Google Cloud
	// Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `protobuf:"bytes,6,rep,name=user_labels,json=userLabels,proto3" json:"user_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *GenerateGroundedContentRequest) Reset() {
	*x = GenerateGroundedContentRequest{}
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateGroundedContentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateGroundedContentRequest) ProtoMessage() {}

func (x *GenerateGroundedContentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateGroundedContentRequest.ProtoReflect.Descriptor instead.
func (*GenerateGroundedContentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP(), []int{1}
}

func (x *GenerateGroundedContentRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *GenerateGroundedContentRequest) GetSystemInstruction() *GroundedGenerationContent {
	if x != nil {
		return x.SystemInstruction
	}
	return nil
}

func (x *GenerateGroundedContentRequest) GetContents() []*GroundedGenerationContent {
	if x != nil {
		return x.Contents
	}
	return nil
}

func (x *GenerateGroundedContentRequest) GetGenerationSpec() *GenerateGroundedContentRequest_GenerationSpec {
	if x != nil {
		return x.GenerationSpec
	}
	return nil
}

func (x *GenerateGroundedContentRequest) GetGroundingSpec() *GenerateGroundedContentRequest_GroundingSpec {
	if x != nil {
		return x.GroundingSpec
	}
	return nil
}

func (x *GenerateGroundedContentRequest) GetUserLabels() map[string]string {
	if x != nil {
		return x.UserLabels
	}
	return nil
}

// Response for the `GenerateGroundedContent` method.
type GenerateGroundedContentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Generated candidates.
	Candidates []*GenerateGroundedContentResponse_Candidate `protobuf:"bytes,1,rep,name=candidates,proto3" json:"candidates,omitempty"`
}

func (x *GenerateGroundedContentResponse) Reset() {
	*x = GenerateGroundedContentResponse{}
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateGroundedContentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateGroundedContentResponse) ProtoMessage() {}

func (x *GenerateGroundedContentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateGroundedContentResponse.ProtoReflect.Descriptor instead.
func (*GenerateGroundedContentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP(), []int{2}
}

func (x *GenerateGroundedContentResponse) GetCandidates() []*GenerateGroundedContentResponse_Candidate {
	if x != nil {
		return x.Candidates
	}
	return nil
}

// Specification for the grounding check.
type CheckGroundingSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The threshold (in [0,1]) used for determining whether a fact must be
	// cited for a claim in the answer candidate. Choosing a higher threshold
	// will lead to fewer but very strong citations, while choosing a lower
	// threshold may lead to more but somewhat weaker citations. If unset, the
	// threshold will default to 0.6.
	CitationThreshold *float64 `protobuf:"fixed64,1,opt,name=citation_threshold,json=citationThreshold,proto3,oneof" json:"citation_threshold,omitempty"`
}

func (x *CheckGroundingSpec) Reset() {
	*x = CheckGroundingSpec{}
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CheckGroundingSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckGroundingSpec) ProtoMessage() {}

func (x *CheckGroundingSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckGroundingSpec.ProtoReflect.Descriptor instead.
func (*CheckGroundingSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP(), []int{3}
}

func (x *CheckGroundingSpec) GetCitationThreshold() float64 {
	if x != nil && x.CitationThreshold != nil {
		return *x.CitationThreshold
	}
	return 0
}

// Request message for
// [GroundedGenerationService.CheckGrounding][google.cloud.discoveryengine.v1beta.GroundedGenerationService.CheckGrounding]
// method.
type CheckGroundingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the grounding config, such as
	// `projects/*/locations/global/groundingConfigs/default_grounding_config`.
	GroundingConfig string `protobuf:"bytes,1,opt,name=grounding_config,json=groundingConfig,proto3" json:"grounding_config,omitempty"`
	// Answer candidate to check. It can have a maximum length of 4096 tokens.
	AnswerCandidate string `protobuf:"bytes,2,opt,name=answer_candidate,json=answerCandidate,proto3" json:"answer_candidate,omitempty"`
	// List of facts for the grounding check.
	// We support up to 200 facts.
	Facts []*GroundingFact `protobuf:"bytes,3,rep,name=facts,proto3" json:"facts,omitempty"`
	// Configuration of the grounding check.
	GroundingSpec *CheckGroundingSpec `protobuf:"bytes,4,opt,name=grounding_spec,json=groundingSpec,proto3" json:"grounding_spec,omitempty"`
	// The user labels applied to a resource must meet the following requirements:
	//
	//   - Each resource can have multiple labels, up to a maximum of 64.
	//   - Each label must be a key-value pair.
	//   - Keys have a minimum length of 1 character and a maximum length of 63
	//     characters and cannot be empty. Values can be empty and have a maximum
	//     length of 63 characters.
	//   - Keys and values can contain only lowercase letters, numeric characters,
	//     underscores, and dashes. All characters must use UTF-8 encoding, and
	//     international characters are allowed.
	//   - The key portion of a label must be unique. However, you can use the same
	//     key with multiple resources.
	//   - Keys must start with a lowercase letter or international character.
	//
	// See [Google Cloud
	// Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `protobuf:"bytes,5,rep,name=user_labels,json=userLabels,proto3" json:"user_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *CheckGroundingRequest) Reset() {
	*x = CheckGroundingRequest{}
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CheckGroundingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckGroundingRequest) ProtoMessage() {}

func (x *CheckGroundingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckGroundingRequest.ProtoReflect.Descriptor instead.
func (*CheckGroundingRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP(), []int{4}
}

func (x *CheckGroundingRequest) GetGroundingConfig() string {
	if x != nil {
		return x.GroundingConfig
	}
	return ""
}

func (x *CheckGroundingRequest) GetAnswerCandidate() string {
	if x != nil {
		return x.AnswerCandidate
	}
	return ""
}

func (x *CheckGroundingRequest) GetFacts() []*GroundingFact {
	if x != nil {
		return x.Facts
	}
	return nil
}

func (x *CheckGroundingRequest) GetGroundingSpec() *CheckGroundingSpec {
	if x != nil {
		return x.GroundingSpec
	}
	return nil
}

func (x *CheckGroundingRequest) GetUserLabels() map[string]string {
	if x != nil {
		return x.UserLabels
	}
	return nil
}

// Response message for the
// [GroundedGenerationService.CheckGrounding][google.cloud.discoveryengine.v1beta.GroundedGenerationService.CheckGrounding]
// method.
type CheckGroundingResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The support score for the input answer candidate.
	// Higher the score, higher is the fraction of claims that are supported by
	// the provided facts. This is always set when a response is returned.
	SupportScore *float32 `protobuf:"fixed32,1,opt,name=support_score,json=supportScore,proto3,oneof" json:"support_score,omitempty"`
	// List of facts cited across all claims in the answer candidate.
	// These are derived from the facts supplied in the request.
	CitedChunks []*FactChunk `protobuf:"bytes,3,rep,name=cited_chunks,json=citedChunks,proto3" json:"cited_chunks,omitempty"`
	// List of facts cited across all claims in the answer candidate.
	// These are derived from the facts supplied in the request.
	CitedFacts []*CheckGroundingResponse_CheckGroundingFactChunk `protobuf:"bytes,6,rep,name=cited_facts,json=citedFacts,proto3" json:"cited_facts,omitempty"`
	// Claim texts and citation info across all claims in the answer candidate.
	Claims []*CheckGroundingResponse_Claim `protobuf:"bytes,4,rep,name=claims,proto3" json:"claims,omitempty"`
}

func (x *CheckGroundingResponse) Reset() {
	*x = CheckGroundingResponse{}
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CheckGroundingResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckGroundingResponse) ProtoMessage() {}

func (x *CheckGroundingResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckGroundingResponse.ProtoReflect.Descriptor instead.
func (*CheckGroundingResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP(), []int{5}
}

func (x *CheckGroundingResponse) GetSupportScore() float32 {
	if x != nil && x.SupportScore != nil {
		return *x.SupportScore
	}
	return 0
}

func (x *CheckGroundingResponse) GetCitedChunks() []*FactChunk {
	if x != nil {
		return x.CitedChunks
	}
	return nil
}

func (x *CheckGroundingResponse) GetCitedFacts() []*CheckGroundingResponse_CheckGroundingFactChunk {
	if x != nil {
		return x.CitedFacts
	}
	return nil
}

func (x *CheckGroundingResponse) GetClaims() []*CheckGroundingResponse_Claim {
	if x != nil {
		return x.Claims
	}
	return nil
}

// Single part of content.
type GroundedGenerationContent_Part struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Holder of data. It only supports text for now.
	//
	// Types that are assignable to Data:
	//
	//	*GroundedGenerationContent_Part_Text
	Data isGroundedGenerationContent_Part_Data `protobuf_oneof:"data"`
}

func (x *GroundedGenerationContent_Part) Reset() {
	*x = GroundedGenerationContent_Part{}
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroundedGenerationContent_Part) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroundedGenerationContent_Part) ProtoMessage() {}

func (x *GroundedGenerationContent_Part) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroundedGenerationContent_Part.ProtoReflect.Descriptor instead.
func (*GroundedGenerationContent_Part) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP(), []int{0, 0}
}

func (m *GroundedGenerationContent_Part) GetData() isGroundedGenerationContent_Part_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (x *GroundedGenerationContent_Part) GetText() string {
	if x, ok := x.GetData().(*GroundedGenerationContent_Part_Text); ok {
		return x.Text
	}
	return ""
}

type isGroundedGenerationContent_Part_Data interface {
	isGroundedGenerationContent_Part_Data()
}

type GroundedGenerationContent_Part_Text struct {
	// Inline text.
	Text string `protobuf:"bytes,1,opt,name=text,proto3,oneof"`
}

func (*GroundedGenerationContent_Part_Text) isGroundedGenerationContent_Part_Data() {}

// Content generation specification.
type GenerateGroundedContentRequest_GenerationSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies which Vertex model id to use for generation.
	ModelId string `protobuf:"bytes,3,opt,name=model_id,json=modelId,proto3" json:"model_id,omitempty"`
	// Language code for content. Use language tags defined by
	// [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// If specified, custom value for the temperature will be used.
	Temperature *float32 `protobuf:"fixed32,4,opt,name=temperature,proto3,oneof" json:"temperature,omitempty"`
	// If specified, custom value for nucleus sampling will be used.
	TopP *float32 `protobuf:"fixed32,5,opt,name=top_p,json=topP,proto3,oneof" json:"top_p,omitempty"`
	// If specified, custom value for top-k sampling will be used.
	TopK *int32 `protobuf:"varint,7,opt,name=top_k,json=topK,proto3,oneof" json:"top_k,omitempty"`
	// If specified, custom value for frequency penalty will be used.
	FrequencyPenalty *float32 `protobuf:"fixed32,8,opt,name=frequency_penalty,json=frequencyPenalty,proto3,oneof" json:"frequency_penalty,omitempty"`
	// If specified, custom value for presence penalty will be used.
	PresencePenalty *float32 `protobuf:"fixed32,9,opt,name=presence_penalty,json=presencePenalty,proto3,oneof" json:"presence_penalty,omitempty"`
	// If specified, custom value for max output tokens will be used.
	MaxOutputTokens *int32 `protobuf:"varint,10,opt,name=max_output_tokens,json=maxOutputTokens,proto3,oneof" json:"max_output_tokens,omitempty"`
}

func (x *GenerateGroundedContentRequest_GenerationSpec) Reset() {
	*x = GenerateGroundedContentRequest_GenerationSpec{}
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateGroundedContentRequest_GenerationSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateGroundedContentRequest_GenerationSpec) ProtoMessage() {}

func (x *GenerateGroundedContentRequest_GenerationSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateGroundedContentRequest_GenerationSpec.ProtoReflect.Descriptor instead.
func (*GenerateGroundedContentRequest_GenerationSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP(), []int{1, 0}
}

func (x *GenerateGroundedContentRequest_GenerationSpec) GetModelId() string {
	if x != nil {
		return x.ModelId
	}
	return ""
}

func (x *GenerateGroundedContentRequest_GenerationSpec) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *GenerateGroundedContentRequest_GenerationSpec) GetTemperature() float32 {
	if x != nil && x.Temperature != nil {
		return *x.Temperature
	}
	return 0
}

func (x *GenerateGroundedContentRequest_GenerationSpec) GetTopP() float32 {
	if x != nil && x.TopP != nil {
		return *x.TopP
	}
	return 0
}

func (x *GenerateGroundedContentRequest_GenerationSpec) GetTopK() int32 {
	if x != nil && x.TopK != nil {
		return *x.TopK
	}
	return 0
}

func (x *GenerateGroundedContentRequest_GenerationSpec) GetFrequencyPenalty() float32 {
	if x != nil && x.FrequencyPenalty != nil {
		return *x.FrequencyPenalty
	}
	return 0
}

func (x *GenerateGroundedContentRequest_GenerationSpec) GetPresencePenalty() float32 {
	if x != nil && x.PresencePenalty != nil {
		return *x.PresencePenalty
	}
	return 0
}

func (x *GenerateGroundedContentRequest_GenerationSpec) GetMaxOutputTokens() int32 {
	if x != nil && x.MaxOutputTokens != nil {
		return *x.MaxOutputTokens
	}
	return 0
}

// Describes the options to customize dynamic retrieval.
type GenerateGroundedContentRequest_DynamicRetrievalConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specification for the predictor for dynamic retrieval.
	Predictor *GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor `protobuf:"bytes,1,opt,name=predictor,proto3" json:"predictor,omitempty"`
}

func (x *GenerateGroundedContentRequest_DynamicRetrievalConfiguration) Reset() {
	*x = GenerateGroundedContentRequest_DynamicRetrievalConfiguration{}
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateGroundedContentRequest_DynamicRetrievalConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateGroundedContentRequest_DynamicRetrievalConfiguration) ProtoMessage() {}

func (x *GenerateGroundedContentRequest_DynamicRetrievalConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateGroundedContentRequest_DynamicRetrievalConfiguration.ProtoReflect.Descriptor instead.
func (*GenerateGroundedContentRequest_DynamicRetrievalConfiguration) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP(), []int{1, 1}
}

func (x *GenerateGroundedContentRequest_DynamicRetrievalConfiguration) GetPredictor() *GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor {
	if x != nil {
		return x.Predictor
	}
	return nil
}

// Grounding source.
type GenerateGroundedContentRequest_GroundingSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sources.
	//
	// Types that are assignable to Source:
	//
	//	*GenerateGroundedContentRequest_GroundingSource_InlineSource_
	//	*GenerateGroundedContentRequest_GroundingSource_SearchSource_
	//	*GenerateGroundedContentRequest_GroundingSource_GoogleSearchSource_
	Source isGenerateGroundedContentRequest_GroundingSource_Source `protobuf_oneof:"source"`
}

func (x *GenerateGroundedContentRequest_GroundingSource) Reset() {
	*x = GenerateGroundedContentRequest_GroundingSource{}
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateGroundedContentRequest_GroundingSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateGroundedContentRequest_GroundingSource) ProtoMessage() {}

func (x *GenerateGroundedContentRequest_GroundingSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateGroundedContentRequest_GroundingSource.ProtoReflect.Descriptor instead.
func (*GenerateGroundedContentRequest_GroundingSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP(), []int{1, 2}
}

func (m *GenerateGroundedContentRequest_GroundingSource) GetSource() isGenerateGroundedContentRequest_GroundingSource_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *GenerateGroundedContentRequest_GroundingSource) GetInlineSource() *GenerateGroundedContentRequest_GroundingSource_InlineSource {
	if x, ok := x.GetSource().(*GenerateGroundedContentRequest_GroundingSource_InlineSource_); ok {
		return x.InlineSource
	}
	return nil
}

func (x *GenerateGroundedContentRequest_GroundingSource) GetSearchSource() *GenerateGroundedContentRequest_GroundingSource_SearchSource {
	if x, ok := x.GetSource().(*GenerateGroundedContentRequest_GroundingSource_SearchSource_); ok {
		return x.SearchSource
	}
	return nil
}

func (x *GenerateGroundedContentRequest_GroundingSource) GetGoogleSearchSource() *GenerateGroundedContentRequest_GroundingSource_GoogleSearchSource {
	if x, ok := x.GetSource().(*GenerateGroundedContentRequest_GroundingSource_GoogleSearchSource_); ok {
		return x.GoogleSearchSource
	}
	return nil
}

type isGenerateGroundedContentRequest_GroundingSource_Source interface {
	isGenerateGroundedContentRequest_GroundingSource_Source()
}

type GenerateGroundedContentRequest_GroundingSource_InlineSource_ struct {
	// If set, grounding is performed with inline content.
	InlineSource *GenerateGroundedContentRequest_GroundingSource_InlineSource `protobuf:"bytes,1,opt,name=inline_source,json=inlineSource,proto3,oneof"`
}

type GenerateGroundedContentRequest_GroundingSource_SearchSource_ struct {
	// If set, grounding is performed with Vertex AI Search.
	SearchSource *GenerateGroundedContentRequest_GroundingSource_SearchSource `protobuf:"bytes,2,opt,name=search_source,json=searchSource,proto3,oneof"`
}

type GenerateGroundedContentRequest_GroundingSource_GoogleSearchSource_ struct {
	// If set, grounding is performed with Google Search.
	GoogleSearchSource *GenerateGroundedContentRequest_GroundingSource_GoogleSearchSource `protobuf:"bytes,3,opt,name=google_search_source,json=googleSearchSource,proto3,oneof"`
}

func (*GenerateGroundedContentRequest_GroundingSource_InlineSource_) isGenerateGroundedContentRequest_GroundingSource_Source() {
}

func (*GenerateGroundedContentRequest_GroundingSource_SearchSource_) isGenerateGroundedContentRequest_GroundingSource_Source() {
}

func (*GenerateGroundedContentRequest_GroundingSource_GoogleSearchSource_) isGenerateGroundedContentRequest_GroundingSource_Source() {
}

// Grounding specification.
type GenerateGroundedContentRequest_GroundingSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Grounding sources.
	GroundingSources []*GenerateGroundedContentRequest_GroundingSource `protobuf:"bytes,1,rep,name=grounding_sources,json=groundingSources,proto3" json:"grounding_sources,omitempty"`
}

func (x *GenerateGroundedContentRequest_GroundingSpec) Reset() {
	*x = GenerateGroundedContentRequest_GroundingSpec{}
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateGroundedContentRequest_GroundingSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateGroundedContentRequest_GroundingSpec) ProtoMessage() {}

func (x *GenerateGroundedContentRequest_GroundingSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateGroundedContentRequest_GroundingSpec.ProtoReflect.Descriptor instead.
func (*GenerateGroundedContentRequest_GroundingSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP(), []int{1, 3}
}

func (x *GenerateGroundedContentRequest_GroundingSpec) GetGroundingSources() []*GenerateGroundedContentRequest_GroundingSource {
	if x != nil {
		return x.GroundingSources
	}
	return nil
}

// Describes the predictor settings for dynamic retrieval.
type GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The version of the predictor to be used in dynamic retrieval.
	Version GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor_Version `protobuf:"varint,1,opt,name=version,proto3,enum=google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor_Version" json:"version,omitempty"`
	// The value of the threshold. If the predictor will predict a
	// value smaller than this, it would suppress grounding in the source.
	Threshold *float32 `protobuf:"fixed32,2,opt,name=threshold,proto3,oneof" json:"threshold,omitempty"`
}

func (x *GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor) Reset() {
	*x = GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor{}
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor) ProtoMessage() {
}

func (x *GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor.ProtoReflect.Descriptor instead.
func (*GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP(), []int{1, 1, 0}
}

func (x *GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor) GetVersion() GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor_Version {
	if x != nil {
		return x.Version
	}
	return GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor_VERSION_UNSPECIFIED
}

func (x *GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor) GetThreshold() float32 {
	if x != nil && x.Threshold != nil {
		return *x.Threshold
	}
	return 0
}

// Message to be used for grounding based on inline content.
type GenerateGroundedContentRequest_GroundingSource_InlineSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of facts to be used for grounding.
	GroundingFacts []*GroundingFact `protobuf:"bytes,1,rep,name=grounding_facts,json=groundingFacts,proto3" json:"grounding_facts,omitempty"`
	// Attributes associated with the content.
	//
	// Common attributes include `source` (indicating where the content was
	// sourced from) and `author` (indicating the author of the content).
	Attributes map[string]string `protobuf:"bytes,2,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *GenerateGroundedContentRequest_GroundingSource_InlineSource) Reset() {
	*x = GenerateGroundedContentRequest_GroundingSource_InlineSource{}
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateGroundedContentRequest_GroundingSource_InlineSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateGroundedContentRequest_GroundingSource_InlineSource) ProtoMessage() {}

func (x *GenerateGroundedContentRequest_GroundingSource_InlineSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateGroundedContentRequest_GroundingSource_InlineSource.ProtoReflect.Descriptor instead.
func (*GenerateGroundedContentRequest_GroundingSource_InlineSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP(), []int{1, 2, 0}
}

func (x *GenerateGroundedContentRequest_GroundingSource_InlineSource) GetGroundingFacts() []*GroundingFact {
	if x != nil {
		return x.GroundingFacts
	}
	return nil
}

func (x *GenerateGroundedContentRequest_GroundingSource_InlineSource) GetAttributes() map[string]string {
	if x != nil {
		return x.Attributes
	}
	return nil
}

// Message to be used for grounding with Vertex AI Search.
type GenerateGroundedContentRequest_GroundingSource_SearchSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the Engine to use.
	//
	// Format:
	// `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}/servingConfigs/{serving_config_id}`
	ServingConfig string `protobuf:"bytes,1,opt,name=serving_config,json=servingConfig,proto3" json:"serving_config,omitempty"`
	// Number of search results to return.
	//
	// The default value is 10. The maximumm allowed value is 10.
	MaxResultCount int32 `protobuf:"varint,2,opt,name=max_result_count,json=maxResultCount,proto3" json:"max_result_count,omitempty"`
	// Filter expression to be applied to the search.
	//
	// The syntax is the same as
	// [SearchRequest.filter][google.cloud.discoveryengine.v1beta.SearchRequest.filter].
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// If set, safe search is enabled in Vertex AI Search requests.
	SafeSearch bool `protobuf:"varint,5,opt,name=safe_search,json=safeSearch,proto3" json:"safe_search,omitempty"`
}

func (x *GenerateGroundedContentRequest_GroundingSource_SearchSource) Reset() {
	*x = GenerateGroundedContentRequest_GroundingSource_SearchSource{}
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateGroundedContentRequest_GroundingSource_SearchSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateGroundedContentRequest_GroundingSource_SearchSource) ProtoMessage() {}

func (x *GenerateGroundedContentRequest_GroundingSource_SearchSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateGroundedContentRequest_GroundingSource_SearchSource.ProtoReflect.Descriptor instead.
func (*GenerateGroundedContentRequest_GroundingSource_SearchSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP(), []int{1, 2, 1}
}

func (x *GenerateGroundedContentRequest_GroundingSource_SearchSource) GetServingConfig() string {
	if x != nil {
		return x.ServingConfig
	}
	return ""
}

func (x *GenerateGroundedContentRequest_GroundingSource_SearchSource) GetMaxResultCount() int32 {
	if x != nil {
		return x.MaxResultCount
	}
	return 0
}

func (x *GenerateGroundedContentRequest_GroundingSource_SearchSource) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *GenerateGroundedContentRequest_GroundingSource_SearchSource) GetSafeSearch() bool {
	if x != nil {
		return x.SafeSearch
	}
	return false
}

// Google Search config parameters.
type GenerateGroundedContentRequest_GroundingSource_GoogleSearchSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Specifies the dynamic retrieval configuration for the given
	// source.
	DynamicRetrievalConfig *GenerateGroundedContentRequest_DynamicRetrievalConfiguration `protobuf:"bytes,2,opt,name=dynamic_retrieval_config,json=dynamicRetrievalConfig,proto3" json:"dynamic_retrieval_config,omitempty"`
}

func (x *GenerateGroundedContentRequest_GroundingSource_GoogleSearchSource) Reset() {
	*x = GenerateGroundedContentRequest_GroundingSource_GoogleSearchSource{}
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateGroundedContentRequest_GroundingSource_GoogleSearchSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateGroundedContentRequest_GroundingSource_GoogleSearchSource) ProtoMessage() {}

func (x *GenerateGroundedContentRequest_GroundingSource_GoogleSearchSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateGroundedContentRequest_GroundingSource_GoogleSearchSource.ProtoReflect.Descriptor instead.
func (*GenerateGroundedContentRequest_GroundingSource_GoogleSearchSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP(), []int{1, 2, 2}
}

func (x *GenerateGroundedContentRequest_GroundingSource_GoogleSearchSource) GetDynamicRetrievalConfig() *GenerateGroundedContentRequest_DynamicRetrievalConfiguration {
	if x != nil {
		return x.DynamicRetrievalConfig
	}
	return nil
}

// A response candidate generated from the model.
type GenerateGroundedContentResponse_Candidate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Index of the candidate.
	Index int32 `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
	// Content of the candidate.
	Content *GroundedGenerationContent `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
	// The overall grounding score for the candidate, in the range of [0, 1].
	GroundingScore *float32 `protobuf:"fixed32,3,opt,name=grounding_score,json=groundingScore,proto3,oneof" json:"grounding_score,omitempty"`
	// Grounding metadata for the generated content.
	GroundingMetadata *GenerateGroundedContentResponse_Candidate_GroundingMetadata `protobuf:"bytes,4,opt,name=grounding_metadata,json=groundingMetadata,proto3" json:"grounding_metadata,omitempty"`
}

func (x *GenerateGroundedContentResponse_Candidate) Reset() {
	*x = GenerateGroundedContentResponse_Candidate{}
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateGroundedContentResponse_Candidate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateGroundedContentResponse_Candidate) ProtoMessage() {}

func (x *GenerateGroundedContentResponse_Candidate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateGroundedContentResponse_Candidate.ProtoReflect.Descriptor instead.
func (*GenerateGroundedContentResponse_Candidate) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP(), []int{2, 0}
}

func (x *GenerateGroundedContentResponse_Candidate) GetIndex() int32 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *GenerateGroundedContentResponse_Candidate) GetContent() *GroundedGenerationContent {
	if x != nil {
		return x.Content
	}
	return nil
}

func (x *GenerateGroundedContentResponse_Candidate) GetGroundingScore() float32 {
	if x != nil && x.GroundingScore != nil {
		return *x.GroundingScore
	}
	return 0
}

func (x *GenerateGroundedContentResponse_Candidate) GetGroundingMetadata() *GenerateGroundedContentResponse_Candidate_GroundingMetadata {
	if x != nil {
		return x.GroundingMetadata
	}
	return nil
}

// Citation for the generated content.
type GenerateGroundedContentResponse_Candidate_GroundingMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Retrieval metadata to provide an understanding in the
	// retrieval steps performed by the model. There can be multiple such
	// messages which can correspond to different parts of the retrieval. This
	// is a mechanism used to ensure transparency to our users.
	RetrievalMetadata []*GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata `protobuf:"bytes,5,rep,name=retrieval_metadata,json=retrievalMetadata,proto3" json:"retrieval_metadata,omitempty"`
	// List of chunks to be attributed across all claims in the candidate.
	// These are derived from the grounding sources supplied in the request.
	SupportChunks []*FactChunk `protobuf:"bytes,1,rep,name=support_chunks,json=supportChunks,proto3" json:"support_chunks,omitempty"`
	// Web search queries for the following-up web search.
	WebSearchQueries []string `protobuf:"bytes,3,rep,name=web_search_queries,json=webSearchQueries,proto3" json:"web_search_queries,omitempty"`
	// Google search entry for the following-up web searches.
	SearchEntryPoint *GenerateGroundedContentResponse_Candidate_GroundingMetadata_SearchEntryPoint `protobuf:"bytes,4,opt,name=search_entry_point,json=searchEntryPoint,proto3" json:"search_entry_point,omitempty"`
	// GroundingSupport across all claims in the answer candidate.
	// An support to a fact indicates that the claim is supported by
	// the fact.
	GroundingSupport []*GenerateGroundedContentResponse_Candidate_GroundingMetadata_GroundingSupport `protobuf:"bytes,2,rep,name=grounding_support,json=groundingSupport,proto3" json:"grounding_support,omitempty"`
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata) Reset() {
	*x = GenerateGroundedContentResponse_Candidate_GroundingMetadata{}
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateGroundedContentResponse_Candidate_GroundingMetadata) ProtoMessage() {}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateGroundedContentResponse_Candidate_GroundingMetadata.ProtoReflect.Descriptor instead.
func (*GenerateGroundedContentResponse_Candidate_GroundingMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP(), []int{2, 0, 0}
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata) GetRetrievalMetadata() []*GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata {
	if x != nil {
		return x.RetrievalMetadata
	}
	return nil
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata) GetSupportChunks() []*FactChunk {
	if x != nil {
		return x.SupportChunks
	}
	return nil
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata) GetWebSearchQueries() []string {
	if x != nil {
		return x.WebSearchQueries
	}
	return nil
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata) GetSearchEntryPoint() *GenerateGroundedContentResponse_Candidate_GroundingMetadata_SearchEntryPoint {
	if x != nil {
		return x.SearchEntryPoint
	}
	return nil
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata) GetGroundingSupport() []*GenerateGroundedContentResponse_Candidate_GroundingMetadata_GroundingSupport {
	if x != nil {
		return x.GroundingSupport
	}
	return nil
}

// Describes the metadata associated with a retrieval step.
type GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Describes the source to which the metadata is referring to.
	Source GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_Source `protobuf:"varint,1,opt,name=source,proto3,enum=google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_Source" json:"source,omitempty"`
	// Metadata for dynamic retrieval.
	DynamicRetrievalMetadata *GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalMetadata `protobuf:"bytes,2,opt,name=dynamic_retrieval_metadata,json=dynamicRetrievalMetadata,proto3" json:"dynamic_retrieval_metadata,omitempty"`
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata) Reset() {
	*x = GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata{}
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata) ProtoMessage() {
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata.ProtoReflect.Descriptor instead.
func (*GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP(), []int{2, 0, 0, 0}
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata) GetSource() GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_Source {
	if x != nil {
		return x.Source
	}
	return GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_SOURCE_UNSPECIFIED
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata) GetDynamicRetrievalMetadata() *GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalMetadata {
	if x != nil {
		return x.DynamicRetrievalMetadata
	}
	return nil
}

// Describes the metadata about dynamic retrieval.
type GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Metadata for the dynamic retrieval predictor.
	PredictorMetadata *GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata `protobuf:"bytes,1,opt,name=predictor_metadata,json=predictorMetadata,proto3" json:"predictor_metadata,omitempty"`
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalMetadata) Reset() {
	*x = GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalMetadata{}
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalMetadata) ProtoMessage() {
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalMetadata.ProtoReflect.Descriptor instead.
func (*GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP(), []int{2, 0, 0, 1}
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalMetadata) GetPredictorMetadata() *GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata {
	if x != nil {
		return x.PredictorMetadata
	}
	return nil
}

// Describes the metadata about the dynamic retrieval predictor.
type GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The version of the predictor which was used in dynamic retrieval.
	Version GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata_Version `protobuf:"varint,1,opt,name=version,proto3,enum=google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata_Version" json:"version,omitempty"`
	// The value of the predictor. This should be between [0, 1] where
	// a value of 0 means that the query would not benefit from grounding,
	// while a value of 1.0 means that the query would benefit the most.
	// In between values allow to differentiate between different usefulness
	// scores for grounding.
	Prediction *float32 `protobuf:"fixed32,2,opt,name=prediction,proto3,oneof" json:"prediction,omitempty"`
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata) Reset() {
	*x = GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata{}
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata) ProtoMessage() {
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata.ProtoReflect.Descriptor instead.
func (*GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP(), []int{2, 0, 0, 2}
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata) GetVersion() GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata_Version {
	if x != nil {
		return x.Version
	}
	return GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata_VERSION_UNSPECIFIED
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata) GetPrediction() float32 {
	if x != nil && x.Prediction != nil {
		return *x.Prediction
	}
	return 0
}

// Google search entry point.
type GenerateGroundedContentResponse_Candidate_GroundingMetadata_SearchEntryPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Web content snippet that can be embedded in a web page or an app
	// webview.
	RenderedContent string `protobuf:"bytes,1,opt,name=rendered_content,json=renderedContent,proto3" json:"rendered_content,omitempty"`
	// Base64 encoded JSON representing array of <search term, search url>
	// tuple.
	SdkBlob []byte `protobuf:"bytes,2,opt,name=sdk_blob,json=sdkBlob,proto3" json:"sdk_blob,omitempty"`
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata_SearchEntryPoint) Reset() {
	*x = GenerateGroundedContentResponse_Candidate_GroundingMetadata_SearchEntryPoint{}
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata_SearchEntryPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateGroundedContentResponse_Candidate_GroundingMetadata_SearchEntryPoint) ProtoMessage() {}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata_SearchEntryPoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateGroundedContentResponse_Candidate_GroundingMetadata_SearchEntryPoint.ProtoReflect.Descriptor instead.
func (*GenerateGroundedContentResponse_Candidate_GroundingMetadata_SearchEntryPoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP(), []int{2, 0, 0, 3}
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata_SearchEntryPoint) GetRenderedContent() string {
	if x != nil {
		return x.RenderedContent
	}
	return ""
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata_SearchEntryPoint) GetSdkBlob() []byte {
	if x != nil {
		return x.SdkBlob
	}
	return nil
}

// Grounding info for a claim in the candidate and its support.
type GenerateGroundedContentResponse_Candidate_GroundingMetadata_GroundingSupport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Text for the claim in the candidate. Always provided when a
	// support is found.
	ClaimText string `protobuf:"bytes,1,opt,name=claim_text,json=claimText,proto3" json:"claim_text,omitempty"`
	// A list of indices (into 'support_chunks') specifying the
	// citations associated with the claim. For instance [1,3,4] means
	// that support_chunks[1], support_chunks[3],
	// support_chunks[4] are the chunks attributed to the claim.
	SupportChunkIndices []int32 `protobuf:"varint,3,rep,packed,name=support_chunk_indices,json=supportChunkIndices,proto3" json:"support_chunk_indices,omitempty"`
	// A score in the range of [0, 1] describing how grounded is a specific
	// claim in the support chunks indicated.
	// Higher value means that the claim is better supported by the chunks.
	SupportScore *float32 `protobuf:"fixed32,2,opt,name=support_score,json=supportScore,proto3,oneof" json:"support_score,omitempty"`
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata_GroundingSupport) Reset() {
	*x = GenerateGroundedContentResponse_Candidate_GroundingMetadata_GroundingSupport{}
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata_GroundingSupport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateGroundedContentResponse_Candidate_GroundingMetadata_GroundingSupport) ProtoMessage() {}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata_GroundingSupport) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateGroundedContentResponse_Candidate_GroundingMetadata_GroundingSupport.ProtoReflect.Descriptor instead.
func (*GenerateGroundedContentResponse_Candidate_GroundingMetadata_GroundingSupport) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP(), []int{2, 0, 0, 4}
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata_GroundingSupport) GetClaimText() string {
	if x != nil {
		return x.ClaimText
	}
	return ""
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata_GroundingSupport) GetSupportChunkIndices() []int32 {
	if x != nil {
		return x.SupportChunkIndices
	}
	return nil
}

func (x *GenerateGroundedContentResponse_Candidate_GroundingMetadata_GroundingSupport) GetSupportScore() float32 {
	if x != nil && x.SupportScore != nil {
		return *x.SupportScore
	}
	return 0
}

// Fact chunk for grounding check.
type CheckGroundingResponse_CheckGroundingFactChunk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Text content of the fact chunk. Can be at most 10K characters long.
	ChunkText string `protobuf:"bytes,1,opt,name=chunk_text,json=chunkText,proto3" json:"chunk_text,omitempty"`
}

func (x *CheckGroundingResponse_CheckGroundingFactChunk) Reset() {
	*x = CheckGroundingResponse_CheckGroundingFactChunk{}
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CheckGroundingResponse_CheckGroundingFactChunk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckGroundingResponse_CheckGroundingFactChunk) ProtoMessage() {}

func (x *CheckGroundingResponse_CheckGroundingFactChunk) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckGroundingResponse_CheckGroundingFactChunk.ProtoReflect.Descriptor instead.
func (*CheckGroundingResponse_CheckGroundingFactChunk) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP(), []int{5, 0}
}

func (x *CheckGroundingResponse_CheckGroundingFactChunk) GetChunkText() string {
	if x != nil {
		return x.ChunkText
	}
	return ""
}

// Text and citation info for a claim in the answer candidate.
type CheckGroundingResponse_Claim struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Position indicating the start of the claim in the answer candidate,
	// measured in bytes.
	StartPos *int32 `protobuf:"varint,1,opt,name=start_pos,json=startPos,proto3,oneof" json:"start_pos,omitempty"`
	// Position indicating the end of the claim in the answer candidate,
	// exclusive.
	EndPos *int32 `protobuf:"varint,2,opt,name=end_pos,json=endPos,proto3,oneof" json:"end_pos,omitempty"`
	// Text for the claim in the answer candidate. Always provided regardless of
	// whether citations or anti-citations are found.
	ClaimText string `protobuf:"bytes,3,opt,name=claim_text,json=claimText,proto3" json:"claim_text,omitempty"`
	// A list of indices (into 'cited_chunks') specifying the citations
	// associated with the claim. For instance [1,3,4] means that
	// cited_chunks[1], cited_chunks[3], cited_chunks[4] are the facts cited
	// supporting for the claim. A citation to a fact indicates that the claim
	// is supported by the fact.
	CitationIndices []int32 `protobuf:"varint,4,rep,packed,name=citation_indices,json=citationIndices,proto3" json:"citation_indices,omitempty"`
	// Indicates that this claim required grounding check. When the system
	// decided this claim doesn't require attribution/grounding check, this
	// field will be set to false. In that case, no grounding check was done for
	// the claim and therefore
	// [citation_indices][google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.citation_indices],
	// [anti_citation_indices][google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.anti_citation_indices],
	// and
	// [score][google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.score]
	// should not be returned.
	GroundingCheckRequired *bool `protobuf:"varint,6,opt,name=grounding_check_required,json=groundingCheckRequired,proto3,oneof" json:"grounding_check_required,omitempty"`
}

func (x *CheckGroundingResponse_Claim) Reset() {
	*x = CheckGroundingResponse_Claim{}
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CheckGroundingResponse_Claim) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckGroundingResponse_Claim) ProtoMessage() {}

func (x *CheckGroundingResponse_Claim) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckGroundingResponse_Claim.ProtoReflect.Descriptor instead.
func (*CheckGroundingResponse_Claim) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP(), []int{5, 1}
}

func (x *CheckGroundingResponse_Claim) GetStartPos() int32 {
	if x != nil && x.StartPos != nil {
		return *x.StartPos
	}
	return 0
}

func (x *CheckGroundingResponse_Claim) GetEndPos() int32 {
	if x != nil && x.EndPos != nil {
		return *x.EndPos
	}
	return 0
}

func (x *CheckGroundingResponse_Claim) GetClaimText() string {
	if x != nil {
		return x.ClaimText
	}
	return ""
}

func (x *CheckGroundingResponse_Claim) GetCitationIndices() []int32 {
	if x != nil {
		return x.CitationIndices
	}
	return nil
}

func (x *CheckGroundingResponse_Claim) GetGroundingCheckRequired() bool {
	if x != nil && x.GroundingCheckRequired != nil {
		return *x.GroundingCheckRequired
	}
	return false
}

var File_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto protoreflect.FileDescriptor

var file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDesc = []byte{
	0x0a, 0x45, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb0, 0x01, 0x0a, 0x19, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65,
	0x64, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x59, 0x0a, 0x05, 0x70, 0x61, 0x72, 0x74, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x72, 0x6f, 0x75,
	0x6e, 0x64, 0x65, 0x64, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x52, 0x05, 0x70, 0x61, 0x72, 0x74,
	0x73, 0x1a, 0x24, 0x0a, 0x04, 0x50, 0x61, 0x72, 0x74, 0x12, 0x14, 0x0a, 0x04, 0x74, 0x65, 0x78,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x42,
	0x06, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x22, 0x9c, 0x17, 0x0a, 0x1e, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x08, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6d, 0x0a, 0x12, 0x73, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64,
	0x65, 0x64, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x52, 0x11, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5a, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47,
	0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x73, 0x12, 0x7b, 0x0a, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64,
	0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52,
	0x0e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x78, 0x0a, 0x0e, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x47, 0x72, 0x6f,
	0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0d, 0x67, 0x72, 0x6f, 0x75,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x12, 0x74, 0x0a, 0x0b, 0x75, 0x73, 0x65,
	0x72, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x53,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f,
	0x75, 0x6e, 0x64, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a,
	0xa3, 0x03, 0x0a, 0x0e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70,
	0x65, 0x63, 0x12, 0x19, 0x0a, 0x08, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x64, 0x12, 0x23, 0x0a,
	0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x74, 0x65, 0x6d, 0x70, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00, 0x52, 0x0b, 0x74, 0x65, 0x6d, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x18, 0x0a, 0x05, 0x74, 0x6f, 0x70,
	0x5f, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x02, 0x48, 0x01, 0x52, 0x04, 0x74, 0x6f, 0x70, 0x50,
	0x88, 0x01, 0x01, 0x12, 0x18, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x5f, 0x6b, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x05, 0x48, 0x02, 0x52, 0x04, 0x74, 0x6f, 0x70, 0x4b, 0x88, 0x01, 0x01, 0x12, 0x30, 0x0a,
	0x11, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x70, 0x65, 0x6e, 0x61, 0x6c,
	0x74, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x02, 0x48, 0x03, 0x52, 0x10, 0x66, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x79, 0x50, 0x65, 0x6e, 0x61, 0x6c, 0x74, 0x79, 0x88, 0x01, 0x01, 0x12,
	0x2e, 0x0a, 0x10, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x65, 0x6e, 0x61,
	0x6c, 0x74, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x02, 0x48, 0x04, 0x52, 0x0f, 0x70, 0x72, 0x65,
	0x73, 0x65, 0x6e, 0x63, 0x65, 0x50, 0x65, 0x6e, 0x61, 0x6c, 0x74, 0x79, 0x88, 0x01, 0x01, 0x12,
	0x2f, 0x0a, 0x11, 0x6d, 0x61, 0x78, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x05, 0x48, 0x05, 0x52, 0x0f, 0x6d, 0x61,
	0x78, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x88, 0x01, 0x01,
	0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x42, 0x08, 0x0a, 0x06, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x70, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x74,
	0x6f, 0x70, 0x5f, 0x6b, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x79, 0x5f, 0x70, 0x65, 0x6e, 0x61, 0x6c, 0x74, 0x79, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x70,
	0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x65, 0x6e, 0x61, 0x6c, 0x74, 0x79, 0x42,
	0x14, 0x0a, 0x12, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x1a, 0xe3, 0x03, 0x0a, 0x1d, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69,
	0x63, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x99, 0x01, 0x0a, 0x09, 0x70, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x7b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64,
	0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61,
	0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44,
	0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x50,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x09, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x6f, 0x72, 0x1a, 0xa5, 0x02, 0x0a, 0x19, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x52,
	0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x6f,
	0x72, 0x12, 0x9e, 0x01, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x83, 0x01, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69,
	0x63, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x52,
	0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x6f,
	0x72, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00, 0x52, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f,
	0x6c, 0x64, 0x88, 0x01, 0x01, 0x22, 0x36, 0x0a, 0x07, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x17, 0x0a, 0x13, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x56, 0x31, 0x5f,
	0x49, 0x4e, 0x44, 0x45, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x42, 0x0c, 0x0a,
	0x0a, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x1a, 0x94, 0x09, 0x0a, 0x0f,
	0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x87, 0x01, 0x0a, 0x0d, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x60, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x47, 0x72, 0x6f,
	0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x49, 0x6e, 0x6c,
	0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0c, 0x69, 0x6e, 0x6c,
	0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x87, 0x01, 0x0a, 0x0d, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x60, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x9a, 0x01, 0x0a, 0x14, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x66, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x12, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x1a, 0xbd, 0x02, 0x0a, 0x0c, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x5b, 0x0a, 0x0f, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x66,
	0x61, 0x63, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x46, 0x61, 0x63, 0x74, 0x52, 0x0e,
	0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x46, 0x61, 0x63, 0x74, 0x73, 0x12, 0x90,
	0x01, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x1a, 0x3d, 0x0a, 0x0f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x1a, 0xcb, 0x01, 0x0a, 0x0c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x58, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xfa, 0x41, 0x2e, 0x0a, 0x2c,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x28, 0x0a, 0x10, 0x6d,
	0x61, 0x78, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1f, 0x0a,
	0x0b, 0x73, 0x61, 0x66, 0x65, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0a, 0x73, 0x61, 0x66, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x1a, 0xb7,
	0x01, 0x0a, 0x12, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0xa0, 0x01, 0x0a, 0x18, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69,
	0x63, 0x5f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x79,
	0x6e, 0x61, 0x6d, 0x69, 0x63, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x16, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76,
	0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x1a, 0x92, 0x01, 0x0a, 0x0d, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x80, 0x01, 0x0a, 0x11, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x47,
	0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x10, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0x3d, 0x0a, 0x0f, 0x55, 0x73, 0x65, 0x72, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xc3, 0x12, 0x0a, 0x1f, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6e, 0x0a, 0x0a, 0x63, 0x61,
	0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f,
	0x75, 0x6e, 0x64, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x52, 0x0a,
	0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x1a, 0xaf, 0x11, 0x0a, 0x09, 0x43,
	0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x58,
	0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52,
	0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x2c, 0x0a, 0x0f, 0x67, 0x72, 0x6f, 0x75,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x02, 0x48, 0x00, 0x52, 0x0e, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x63,
	0x6f, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x8f, 0x01, 0x0a, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x60, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x61, 0x6e, 0x64, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x11, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0xdd, 0x0e, 0x0a, 0x11, 0x47, 0x72, 0x6f,
	0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xa1,
	0x01, 0x0a, 0x12, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64,
	0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x2e, 0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x47, 0x72, 0x6f, 0x75,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x52, 0x65,
	0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x11, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x55, 0x0a, 0x0e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x68,
	0x75, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x46, 0x61, 0x63, 0x74, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x52, 0x0d, 0x73, 0x75, 0x70, 0x70,
	0x6f, 0x72, 0x74, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x77, 0x65, 0x62,
	0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x77, 0x65, 0x62, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x9f, 0x01, 0x0a, 0x12, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x71, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x61, 0x6e, 0x64, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x10, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x9e, 0x01, 0x0a, 0x11, 0x67, 0x72,
	0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x71, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x61, 0x6e, 0x64,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x10, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x1a, 0xd1, 0x03, 0x0a, 0x11, 0x52,
	0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x91, 0x01, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x06, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0xb7, 0x01, 0x0a, 0x1a, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63,
	0x5f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x44, 0x79, 0x6e, 0x61,
	0x6d, 0x69, 0x63, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x52, 0x18, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x52, 0x65, 0x74,
	0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x6e,
	0x0a, 0x06, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x4f, 0x55, 0x52,
	0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x14, 0x0a, 0x10, 0x56, 0x45, 0x52, 0x54, 0x45, 0x58, 0x5f, 0x41, 0x49, 0x5f, 0x53, 0x45,
	0x41, 0x52, 0x43, 0x48, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45,
	0x5f, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x49, 0x4e, 0x4c,
	0x49, 0x4e, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x0f, 0x0a,
	0x0b, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x4d, 0x41, 0x50, 0x53, 0x10, 0x04, 0x1a, 0xcf,
	0x01, 0x0a, 0x18, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65,
	0x76, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xb2, 0x01, 0x0a, 0x12,
	0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x82, 0x01, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x44, 0x79, 0x6e, 0x61,
	0x6d, 0x69, 0x63, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x50, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x74, 0x6f, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x11, 0x70,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x6f, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x1a, 0xb7, 0x02, 0x0a, 0x21, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x52, 0x65, 0x74, 0x72,
	0x69, 0x65, 0x76, 0x61, 0x6c, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x6f, 0x72, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xa5, 0x01, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x8a, 0x01, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x44, 0x79, 0x6e, 0x61,
	0x6d, 0x69, 0x63, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x50, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x74, 0x6f, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x23,
	0x0a, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x02, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x88, 0x01, 0x01, 0x22, 0x36, 0x0a, 0x07, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x17,
	0x0a, 0x13, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x56, 0x31, 0x5f, 0x49, 0x4e,
	0x44, 0x45, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f,
	0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x58, 0x0a, 0x10, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x29,
	0x0a, 0x10, 0x72, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x72, 0x65, 0x6e, 0x64, 0x65, 0x72,
	0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x64, 0x6b,
	0x5f, 0x62, 0x6c, 0x6f, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x73, 0x64, 0x6b,
	0x42, 0x6c, 0x6f, 0x62, 0x1a, 0xa1, 0x01, 0x0a, 0x10, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x61,
	0x69, 0x6d, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63,
	0x6c, 0x61, 0x69, 0x6d, 0x54, 0x65, 0x78, 0x74, 0x12, 0x32, 0x0a, 0x15, 0x73, 0x75, 0x70, 0x70,
	0x6f, 0x72, 0x74, 0x5f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x5f, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x05, 0x52, 0x13, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x43, 0x68, 0x75, 0x6e, 0x6b, 0x49, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x12, 0x28, 0x0a, 0x0d,
	0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x02, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x63,
	0x6f, 0x72, 0x65, 0x88, 0x01, 0x01, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x22, 0x5f, 0x0a, 0x12,
	0x43, 0x68, 0x65, 0x63, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x70,
	0x65, 0x63, 0x12, 0x32, 0x0a, 0x12, 0x63, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74,
	0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00,
	0x52, 0x11, 0x63, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68,
	0x6f, 0x6c, 0x64, 0x88, 0x01, 0x01, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x63, 0x69, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x22, 0xfb, 0x03,
	0x0a, 0x15, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x61, 0x0a, 0x10, 0x67, 0x72, 0x6f, 0x75, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0f, 0x67, 0x72, 0x6f, 0x75, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x29, 0x0a, 0x10, 0x61, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x64,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x12, 0x48, 0x0a, 0x05, 0x66, 0x61, 0x63, 0x74, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x46, 0x61, 0x63, 0x74, 0x52, 0x05, 0x66, 0x61, 0x63, 0x74, 0x73, 0x12,
	0x5e, 0x0a, 0x0e, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63,
	0x52, 0x0d, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x6b, 0x0a, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x05,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b,
	0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x3d, 0x0a, 0x0f,
	0x55, 0x73, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xbc, 0x05, 0x0a, 0x16,
	0x43, 0x68, 0x65, 0x63, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72,
	0x74, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00, 0x52,
	0x0c, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x51, 0x0a, 0x0c, 0x63, 0x69, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x61, 0x63,
	0x74, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x52, 0x0b, 0x63, 0x69, 0x74, 0x65, 0x64, 0x43, 0x68, 0x75,
	0x6e, 0x6b, 0x73, 0x12, 0x74, 0x0a, 0x0b, 0x63, 0x69, 0x74, 0x65, 0x64, 0x5f, 0x66, 0x61, 0x63,
	0x74, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x46, 0x61, 0x63, 0x74, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x52, 0x0a, 0x63,
	0x69, 0x74, 0x65, 0x64, 0x46, 0x61, 0x63, 0x74, 0x73, 0x12, 0x59, 0x0a, 0x06, 0x63, 0x6c, 0x61,
	0x69, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x43, 0x68, 0x65, 0x63, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x52, 0x06, 0x63, 0x6c,
	0x61, 0x69, 0x6d, 0x73, 0x1a, 0x38, 0x0a, 0x17, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x47, 0x72, 0x6f,
	0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x46, 0x61, 0x63, 0x74, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x12,
	0x1d, 0x0a, 0x0a, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x54, 0x65, 0x78, 0x74, 0x1a, 0x87,
	0x02, 0x0a, 0x05, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x12, 0x20, 0x0a, 0x09, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x5f, 0x70, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x08, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x50, 0x6f, 0x73, 0x88, 0x01, 0x01, 0x12, 0x1c, 0x0a, 0x07, 0x65, 0x6e,
	0x64, 0x5f, 0x70, 0x6f, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x01, 0x52, 0x06, 0x65,
	0x6e, 0x64, 0x50, 0x6f, 0x73, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x61, 0x69,
	0x6d, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6c,
	0x61, 0x69, 0x6d, 0x54, 0x65, 0x78, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x63, 0x69, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x05, 0x52, 0x0f, 0x63, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x64, 0x69, 0x63,
	0x65, 0x73, 0x12, 0x3d, 0x0a, 0x18, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f,
	0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x02, 0x52, 0x16, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x88, 0x01,
	0x01, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x70, 0x6f, 0x73, 0x42,
	0x0a, 0x0a, 0x08, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x70, 0x6f, 0x73, 0x42, 0x1b, 0x0a, 0x19, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f,
	0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x73, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x32, 0xcc, 0x06, 0x0a, 0x19, 0x47,
	0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x82, 0x02, 0x0a, 0x1d, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x6e,
	0x64, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65,
	0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x47, 0x72,
	0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x52, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4c, 0x3a, 0x01, 0x2a,
	0x22, 0x47, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64,
	0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x28, 0x01, 0x30, 0x01, 0x12, 0xf2, 0x01,
	0x0a, 0x17, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64,
	0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x44,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f,
	0x75, 0x6e, 0x64, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x3a, 0x01, 0x2a, 0x22,
	0x41, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x12, 0xe0, 0x01, 0x0a, 0x0e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x47, 0x72, 0x6f, 0x75,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x68, 0x65, 0x63,
	0x6b, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x47, 0x72, 0x6f,
	0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x55,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4f, 0x3a, 0x01, 0x2a, 0x22, 0x4a, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2f, 0x7b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x72, 0x6f, 0x75,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x63, 0x68, 0x65, 0x63, 0x6b, 0x1a, 0x52, 0xca, 0x41, 0x1e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xa5, 0x02, 0x0a, 0x27, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x1e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x51, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0x3b, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0xa2, 0x02, 0x0f, 0x44, 0x49, 0x53,
	0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0xaa, 0x02, 0x23, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x56, 0x31, 0x42, 0x65,
	0x74, 0x61, 0xca, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0xea, 0x02, 0x26, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescOnce sync.Once
	file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescData = file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDesc
)

func file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescGZIP() []byte {
	file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescData)
	})
	return file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDescData
}

var file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes = make([]protoimpl.MessageInfo, 27)
var file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_goTypes = []any{
	(GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor_Version)(0),        // 0: google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Version
	(GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_Source)(0),                  // 1: google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata.Source
	(GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata_Version)(0), // 2: google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata.Version
	(*GroundedGenerationContent)(nil),                                    // 3: google.cloud.discoveryengine.v1beta.GroundedGenerationContent
	(*GenerateGroundedContentRequest)(nil),                               // 4: google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest
	(*GenerateGroundedContentResponse)(nil),                              // 5: google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
	(*CheckGroundingSpec)(nil),                                           // 6: google.cloud.discoveryengine.v1beta.CheckGroundingSpec
	(*CheckGroundingRequest)(nil),                                        // 7: google.cloud.discoveryengine.v1beta.CheckGroundingRequest
	(*CheckGroundingResponse)(nil),                                       // 8: google.cloud.discoveryengine.v1beta.CheckGroundingResponse
	(*GroundedGenerationContent_Part)(nil),                               // 9: google.cloud.discoveryengine.v1beta.GroundedGenerationContent.Part
	(*GenerateGroundedContentRequest_GenerationSpec)(nil),                // 10: google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.GenerationSpec
	(*GenerateGroundedContentRequest_DynamicRetrievalConfiguration)(nil), // 11: google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.DynamicRetrievalConfiguration
	(*GenerateGroundedContentRequest_GroundingSource)(nil),               // 12: google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.GroundingSource
	(*GenerateGroundedContentRequest_GroundingSpec)(nil),                 // 13: google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.GroundingSpec
	nil, // 14: google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.UserLabelsEntry
	(*GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor)(nil), // 15: google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor
	(*GenerateGroundedContentRequest_GroundingSource_InlineSource)(nil),                            // 16: google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.GroundingSource.InlineSource
	(*GenerateGroundedContentRequest_GroundingSource_SearchSource)(nil),                            // 17: google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.GroundingSource.SearchSource
	(*GenerateGroundedContentRequest_GroundingSource_GoogleSearchSource)(nil),                      // 18: google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.GroundingSource.GoogleSearchSource
	nil, // 19: google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.GroundingSource.InlineSource.AttributesEntry
	(*GenerateGroundedContentResponse_Candidate)(nil),                                                     // 20: google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
	(*GenerateGroundedContentResponse_Candidate_GroundingMetadata)(nil),                                   // 21: google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata
	(*GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata)(nil),                 // 22: google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata
	(*GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalMetadata)(nil),          // 23: google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalMetadata
	(*GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata)(nil), // 24: google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata
	(*GenerateGroundedContentResponse_Candidate_GroundingMetadata_SearchEntryPoint)(nil),                  // 25: google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.SearchEntryPoint
	(*GenerateGroundedContentResponse_Candidate_GroundingMetadata_GroundingSupport)(nil),                  // 26: google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport
	nil, // 27: google.cloud.discoveryengine.v1beta.CheckGroundingRequest.UserLabelsEntry
	(*CheckGroundingResponse_CheckGroundingFactChunk)(nil), // 28: google.cloud.discoveryengine.v1beta.CheckGroundingResponse.CheckGroundingFactChunk
	(*CheckGroundingResponse_Claim)(nil),                   // 29: google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim
	(*GroundingFact)(nil),                                  // 30: google.cloud.discoveryengine.v1beta.GroundingFact
	(*FactChunk)(nil),                                      // 31: google.cloud.discoveryengine.v1beta.FactChunk
}
var file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_depIdxs = []int32{
	9,  // 0: google.cloud.discoveryengine.v1beta.GroundedGenerationContent.parts:type_name -> google.cloud.discoveryengine.v1beta.GroundedGenerationContent.Part
	3,  // 1: google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.system_instruction:type_name -> google.cloud.discoveryengine.v1beta.GroundedGenerationContent
	3,  // 2: google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.contents:type_name -> google.cloud.discoveryengine.v1beta.GroundedGenerationContent
	10, // 3: google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.generation_spec:type_name -> google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.GenerationSpec
	13, // 4: google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.grounding_spec:type_name -> google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.GroundingSpec
	14, // 5: google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.user_labels:type_name -> google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.UserLabelsEntry
	20, // 6: google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.candidates:type_name -> google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
	30, // 7: google.cloud.discoveryengine.v1beta.CheckGroundingRequest.facts:type_name -> google.cloud.discoveryengine.v1beta.GroundingFact
	6,  // 8: google.cloud.discoveryengine.v1beta.CheckGroundingRequest.grounding_spec:type_name -> google.cloud.discoveryengine.v1beta.CheckGroundingSpec
	27, // 9: google.cloud.discoveryengine.v1beta.CheckGroundingRequest.user_labels:type_name -> google.cloud.discoveryengine.v1beta.CheckGroundingRequest.UserLabelsEntry
	31, // 10: google.cloud.discoveryengine.v1beta.CheckGroundingResponse.cited_chunks:type_name -> google.cloud.discoveryengine.v1beta.FactChunk
	28, // 11: google.cloud.discoveryengine.v1beta.CheckGroundingResponse.cited_facts:type_name -> google.cloud.discoveryengine.v1beta.CheckGroundingResponse.CheckGroundingFactChunk
	29, // 12: google.cloud.discoveryengine.v1beta.CheckGroundingResponse.claims:type_name -> google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim
	15, // 13: google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.predictor:type_name -> google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor
	16, // 14: google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.GroundingSource.inline_source:type_name -> google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.GroundingSource.InlineSource
	17, // 15: google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.GroundingSource.search_source:type_name -> google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.GroundingSource.SearchSource
	18, // 16: google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.GroundingSource.google_search_source:type_name -> google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.GroundingSource.GoogleSearchSource
	12, // 17: google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.GroundingSpec.grounding_sources:type_name -> google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.GroundingSource
	0,  // 18: google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor.version:type_name -> google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Version
	30, // 19: google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.GroundingSource.InlineSource.grounding_facts:type_name -> google.cloud.discoveryengine.v1beta.GroundingFact
	19, // 20: google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.GroundingSource.InlineSource.attributes:type_name -> google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.GroundingSource.InlineSource.AttributesEntry
	11, // 21: google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.GroundingSource.GoogleSearchSource.dynamic_retrieval_config:type_name -> google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest.DynamicRetrievalConfiguration
	3,  // 22: google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.content:type_name -> google.cloud.discoveryengine.v1beta.GroundedGenerationContent
	21, // 23: google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.grounding_metadata:type_name -> google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata
	22, // 24: google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.retrieval_metadata:type_name -> google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata
	31, // 25: google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.support_chunks:type_name -> google.cloud.discoveryengine.v1beta.FactChunk
	25, // 26: google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.search_entry_point:type_name -> google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.SearchEntryPoint
	26, // 27: google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.grounding_support:type_name -> google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport
	1,  // 28: google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata.source:type_name -> google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata.Source
	23, // 29: google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata.dynamic_retrieval_metadata:type_name -> google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalMetadata
	24, // 30: google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalMetadata.predictor_metadata:type_name -> google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata
	2,  // 31: google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata.version:type_name -> google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata.Version
	4,  // 32: google.cloud.discoveryengine.v1beta.GroundedGenerationService.StreamGenerateGroundedContent:input_type -> google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest
	4,  // 33: google.cloud.discoveryengine.v1beta.GroundedGenerationService.GenerateGroundedContent:input_type -> google.cloud.discoveryengine.v1beta.GenerateGroundedContentRequest
	7,  // 34: google.cloud.discoveryengine.v1beta.GroundedGenerationService.CheckGrounding:input_type -> google.cloud.discoveryengine.v1beta.CheckGroundingRequest
	5,  // 35: google.cloud.discoveryengine.v1beta.GroundedGenerationService.StreamGenerateGroundedContent:output_type -> google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
	5,  // 36: google.cloud.discoveryengine.v1beta.GroundedGenerationService.GenerateGroundedContent:output_type -> google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
	8,  // 37: google.cloud.discoveryengine.v1beta.GroundedGenerationService.CheckGrounding:output_type -> google.cloud.discoveryengine.v1beta.CheckGroundingResponse
	35, // [35:38] is the sub-list for method output_type
	32, // [32:35] is the sub-list for method input_type
	32, // [32:32] is the sub-list for extension type_name
	32, // [32:32] is the sub-list for extension extendee
	0,  // [0:32] is the sub-list for field type_name
}

func init() { file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_init() }
func file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_init() {
	if File_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto != nil {
		return
	}
	file_google_cloud_discoveryengine_v1beta_grounding_proto_init()
	file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[3].OneofWrappers = []any{}
	file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[5].OneofWrappers = []any{}
	file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[6].OneofWrappers = []any{
		(*GroundedGenerationContent_Part_Text)(nil),
	}
	file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[7].OneofWrappers = []any{}
	file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[9].OneofWrappers = []any{
		(*GenerateGroundedContentRequest_GroundingSource_InlineSource_)(nil),
		(*GenerateGroundedContentRequest_GroundingSource_SearchSource_)(nil),
		(*GenerateGroundedContentRequest_GroundingSource_GoogleSearchSource_)(nil),
	}
	file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[12].OneofWrappers = []any{}
	file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[17].OneofWrappers = []any{}
	file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[21].OneofWrappers = []any{}
	file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[23].OneofWrappers = []any{}
	file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes[26].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   27,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_msgTypes,
	}.Build()
	File_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto = out.File
	file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_rawDesc = nil
	file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_goTypes = nil
	file_google_cloud_discoveryengine_v1beta_grounded_generation_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// GroundedGenerationServiceClient is the client API for GroundedGenerationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type GroundedGenerationServiceClient interface {
	// Generates grounded content in a streaming fashion.
	StreamGenerateGroundedContent(ctx context.Context, opts ...grpc.CallOption) (GroundedGenerationService_StreamGenerateGroundedContentClient, error)
	// Generates grounded content.
	GenerateGroundedContent(ctx context.Context, in *GenerateGroundedContentRequest, opts ...grpc.CallOption) (*GenerateGroundedContentResponse, error)
	// Performs a grounding check.
	CheckGrounding(ctx context.Context, in *CheckGroundingRequest, opts ...grpc.CallOption) (*CheckGroundingResponse, error)
}

type groundedGenerationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewGroundedGenerationServiceClient(cc grpc.ClientConnInterface) GroundedGenerationServiceClient {
	return &groundedGenerationServiceClient{cc}
}

func (c *groundedGenerationServiceClient) StreamGenerateGroundedContent(ctx context.Context, opts ...grpc.CallOption) (GroundedGenerationService_StreamGenerateGroundedContentClient, error) {
	stream, err := c.cc.NewStream(ctx, &_GroundedGenerationService_serviceDesc.Streams[0], "/google.cloud.discoveryengine.v1beta.GroundedGenerationService/StreamGenerateGroundedContent", opts...)
	if err != nil {
		return nil, err
	}
	x := &groundedGenerationServiceStreamGenerateGroundedContentClient{stream}
	return x, nil
}

type GroundedGenerationService_StreamGenerateGroundedContentClient interface {
	Send(*GenerateGroundedContentRequest) error
	Recv() (*GenerateGroundedContentResponse, error)
	grpc.ClientStream
}

type groundedGenerationServiceStreamGenerateGroundedContentClient struct {
	grpc.ClientStream
}

func (x *groundedGenerationServiceStreamGenerateGroundedContentClient) Send(m *GenerateGroundedContentRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *groundedGenerationServiceStreamGenerateGroundedContentClient) Recv() (*GenerateGroundedContentResponse, error) {
	m := new(GenerateGroundedContentResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *groundedGenerationServiceClient) GenerateGroundedContent(ctx context.Context, in *GenerateGroundedContentRequest, opts ...grpc.CallOption) (*GenerateGroundedContentResponse, error) {
	out := new(GenerateGroundedContentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1beta.GroundedGenerationService/GenerateGroundedContent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groundedGenerationServiceClient) CheckGrounding(ctx context.Context, in *CheckGroundingRequest, opts ...grpc.CallOption) (*CheckGroundingResponse, error) {
	out := new(CheckGroundingResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1beta.GroundedGenerationService/CheckGrounding", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GroundedGenerationServiceServer is the server API for GroundedGenerationService service.
type GroundedGenerationServiceServer interface {
	// Generates grounded content in a streaming fashion.
	StreamGenerateGroundedContent(GroundedGenerationService_StreamGenerateGroundedContentServer) error
	// Generates grounded content.
	GenerateGroundedContent(context.Context, *GenerateGroundedContentRequest) (*GenerateGroundedContentResponse, error)
	// Performs a grounding check.
	CheckGrounding(context.Context, *CheckGroundingRequest) (*CheckGroundingResponse, error)
}

// UnimplementedGroundedGenerationServiceServer can be embedded to have forward compatible implementations.
type UnimplementedGroundedGenerationServiceServer struct {
}

func (*UnimplementedGroundedGenerationServiceServer) StreamGenerateGroundedContent(GroundedGenerationService_StreamGenerateGroundedContentServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamGenerateGroundedContent not implemented")
}
func (*UnimplementedGroundedGenerationServiceServer) GenerateGroundedContent(context.Context, *GenerateGroundedContentRequest) (*GenerateGroundedContentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateGroundedContent not implemented")
}
func (*UnimplementedGroundedGenerationServiceServer) CheckGrounding(context.Context, *CheckGroundingRequest) (*CheckGroundingResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CheckGrounding not implemented")
}

func RegisterGroundedGenerationServiceServer(s *grpc.Server, srv GroundedGenerationServiceServer) {
	s.RegisterService(&_GroundedGenerationService_serviceDesc, srv)
}

func _GroundedGenerationService_StreamGenerateGroundedContent_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(GroundedGenerationServiceServer).StreamGenerateGroundedContent(&groundedGenerationServiceStreamGenerateGroundedContentServer{stream})
}

type GroundedGenerationService_StreamGenerateGroundedContentServer interface {
	Send(*GenerateGroundedContentResponse) error
	Recv() (*GenerateGroundedContentRequest, error)
	grpc.ServerStream
}

type groundedGenerationServiceStreamGenerateGroundedContentServer struct {
	grpc.ServerStream
}

func (x *groundedGenerationServiceStreamGenerateGroundedContentServer) Send(m *GenerateGroundedContentResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *groundedGenerationServiceStreamGenerateGroundedContentServer) Recv() (*GenerateGroundedContentRequest, error) {
	m := new(GenerateGroundedContentRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _GroundedGenerationService_GenerateGroundedContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateGroundedContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroundedGenerationServiceServer).GenerateGroundedContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1beta.GroundedGenerationService/GenerateGroundedContent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroundedGenerationServiceServer).GenerateGroundedContent(ctx, req.(*GenerateGroundedContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GroundedGenerationService_CheckGrounding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckGroundingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroundedGenerationServiceServer).CheckGrounding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1beta.GroundedGenerationService/CheckGrounding",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroundedGenerationServiceServer).CheckGrounding(ctx, req.(*CheckGroundingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _GroundedGenerationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.discoveryengine.v1beta.GroundedGenerationService",
	HandlerType: (*GroundedGenerationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GenerateGroundedContent",
			Handler:    _GroundedGenerationService_GenerateGroundedContent_Handler,
		},
		{
			MethodName: "CheckGrounding",
			Handler:    _GroundedGenerationService_CheckGrounding_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamGenerateGroundedContent",
			Handler:       _GroundedGenerationService_StreamGenerateGroundedContent_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/discoveryengine/v1beta/grounded_generation_service.proto",
}
