// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/discoveryengine/v1alpha/import_config.proto

package discoveryenginepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	date "google.golang.org/genproto/googleapis/type/date"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of values in a Bigtable column or column family.
// The values are expected to be encoded using
// [HBase
// Bytes.toBytes](https://hbase.apache.org/apidocs/org/apache/hadoop/hbase/util/Bytes.html)
// function when the encoding value is set to `BINARY`.
type BigtableOptions_Type int32

const (
	// The type is unspecified.
	BigtableOptions_TYPE_UNSPECIFIED BigtableOptions_Type = 0
	// String type.
	BigtableOptions_STRING BigtableOptions_Type = 1
	// Numerical type.
	BigtableOptions_NUMBER BigtableOptions_Type = 2
	// Integer type.
	BigtableOptions_INTEGER BigtableOptions_Type = 3
	// Variable length integer type.
	BigtableOptions_VAR_INTEGER BigtableOptions_Type = 4
	// BigDecimal type.
	BigtableOptions_BIG_NUMERIC BigtableOptions_Type = 5
	// Boolean type.
	BigtableOptions_BOOLEAN BigtableOptions_Type = 6
	// JSON type.
	BigtableOptions_JSON BigtableOptions_Type = 7
)

// Enum value maps for BigtableOptions_Type.
var (
	BigtableOptions_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "STRING",
		2: "NUMBER",
		3: "INTEGER",
		4: "VAR_INTEGER",
		5: "BIG_NUMERIC",
		6: "BOOLEAN",
		7: "JSON",
	}
	BigtableOptions_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"STRING":           1,
		"NUMBER":           2,
		"INTEGER":          3,
		"VAR_INTEGER":      4,
		"BIG_NUMERIC":      5,
		"BOOLEAN":          6,
		"JSON":             7,
	}
)

func (x BigtableOptions_Type) Enum() *BigtableOptions_Type {
	p := new(BigtableOptions_Type)
	*p = x
	return p
}

func (x BigtableOptions_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigtableOptions_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_enumTypes[0].Descriptor()
}

func (BigtableOptions_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_import_config_proto_enumTypes[0]
}

func (x BigtableOptions_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigtableOptions_Type.Descriptor instead.
func (BigtableOptions_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{3, 0}
}

// The encoding mode of a Bigtable column or column family.
type BigtableOptions_Encoding int32

const (
	// The encoding is unspecified.
	BigtableOptions_ENCODING_UNSPECIFIED BigtableOptions_Encoding = 0
	// Text encoding.
	BigtableOptions_TEXT BigtableOptions_Encoding = 1
	// Binary encoding.
	BigtableOptions_BINARY BigtableOptions_Encoding = 2
)

// Enum value maps for BigtableOptions_Encoding.
var (
	BigtableOptions_Encoding_name = map[int32]string{
		0: "ENCODING_UNSPECIFIED",
		1: "TEXT",
		2: "BINARY",
	}
	BigtableOptions_Encoding_value = map[string]int32{
		"ENCODING_UNSPECIFIED": 0,
		"TEXT":                 1,
		"BINARY":               2,
	}
)

func (x BigtableOptions_Encoding) Enum() *BigtableOptions_Encoding {
	p := new(BigtableOptions_Encoding)
	*p = x
	return p
}

func (x BigtableOptions_Encoding) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigtableOptions_Encoding) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_enumTypes[1].Descriptor()
}

func (BigtableOptions_Encoding) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_import_config_proto_enumTypes[1]
}

func (x BigtableOptions_Encoding) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigtableOptions_Encoding.Descriptor instead.
func (BigtableOptions_Encoding) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{3, 1}
}

// Indicates how imported documents are reconciled with the existing documents
// created or imported before.
type ImportDocumentsRequest_ReconciliationMode int32

const (
	// Defaults to `INCREMENTAL`.
	ImportDocumentsRequest_RECONCILIATION_MODE_UNSPECIFIED ImportDocumentsRequest_ReconciliationMode = 0
	// Inserts new documents or updates existing documents.
	ImportDocumentsRequest_INCREMENTAL ImportDocumentsRequest_ReconciliationMode = 1
	// Calculates diff and replaces the entire document dataset. Existing
	// documents may be deleted if they are not present in the source location.
	ImportDocumentsRequest_FULL ImportDocumentsRequest_ReconciliationMode = 2
)

// Enum value maps for ImportDocumentsRequest_ReconciliationMode.
var (
	ImportDocumentsRequest_ReconciliationMode_name = map[int32]string{
		0: "RECONCILIATION_MODE_UNSPECIFIED",
		1: "INCREMENTAL",
		2: "FULL",
	}
	ImportDocumentsRequest_ReconciliationMode_value = map[string]int32{
		"RECONCILIATION_MODE_UNSPECIFIED": 0,
		"INCREMENTAL":                     1,
		"FULL":                            2,
	}
)

func (x ImportDocumentsRequest_ReconciliationMode) Enum() *ImportDocumentsRequest_ReconciliationMode {
	p := new(ImportDocumentsRequest_ReconciliationMode)
	*p = x
	return p
}

func (x ImportDocumentsRequest_ReconciliationMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ImportDocumentsRequest_ReconciliationMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_enumTypes[2].Descriptor()
}

func (ImportDocumentsRequest_ReconciliationMode) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_import_config_proto_enumTypes[2]
}

func (x ImportDocumentsRequest_ReconciliationMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ImportDocumentsRequest_ReconciliationMode.Descriptor instead.
func (ImportDocumentsRequest_ReconciliationMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{14, 0}
}

// Cloud Storage location for input content.
type GcsSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Cloud Storage URIs to input files. Each URI can be up to
	// 2000 characters long. URIs can match the full object path (for example,
	// `gs://bucket/directory/object.json`) or a pattern matching one or more
	// files, such as `gs://bucket/directory/*.json`.
	//
	// A request can contain at most 100 files (or 100,000 files if `data_schema`
	// is `content`). Each file can be up to 2 GB (or 100 MB if `data_schema` is
	// `content`).
	InputUris []string `protobuf:"bytes,1,rep,name=input_uris,json=inputUris,proto3" json:"input_uris,omitempty"`
	// The schema to use when parsing the data from the source.
	//
	// Supported values for document imports:
	//
	// * `document` (default): One JSON
	// [Document][google.cloud.discoveryengine.v1alpha.Document] per line. Each
	// document must
	//
	//	have a valid
	//	[Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
	//   - `content`: Unstructured data (e.g. PDF, HTML). Each file matched by
	//     `input_uris` becomes a document, with the ID set to the first 128
	//     bits of SHA256(URI) encoded as a hex string.
	//   - `custom`: One custom data JSON per row in arbitrary format that conforms
	//     to the defined [Schema][google.cloud.discoveryengine.v1alpha.Schema] of
	//     the data store. This can only be used by the GENERIC Data Store vertical.
	//   - `csv`: A CSV file with header conforming to the defined
	//
	// [Schema][google.cloud.discoveryengine.v1alpha.Schema] of the
	//
	//	data store. Each entry after the header is imported as a Document.
	//	This can only be used by the GENERIC Data Store vertical.
	//
	// Supported values for user event imports:
	//
	// * `user_event` (default): One JSON
	// [UserEvent][google.cloud.discoveryengine.v1alpha.UserEvent] per line.
	DataSchema string `protobuf:"bytes,2,opt,name=data_schema,json=dataSchema,proto3" json:"data_schema,omitempty"`
}

func (x *GcsSource) Reset() {
	*x = GcsSource{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GcsSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsSource) ProtoMessage() {}

func (x *GcsSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsSource.ProtoReflect.Descriptor instead.
func (*GcsSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{0}
}

func (x *GcsSource) GetInputUris() []string {
	if x != nil {
		return x.InputUris
	}
	return nil
}

func (x *GcsSource) GetDataSchema() string {
	if x != nil {
		return x.DataSchema
	}
	return ""
}

// BigQuery source import data from.
type BigQuerySource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// BigQuery table partition info. Leave this empty if the BigQuery table
	// is not partitioned.
	//
	// Types that are assignable to Partition:
	//
	//	*BigQuerySource_PartitionDate
	Partition isBigQuerySource_Partition `protobuf_oneof:"partition"`
	// The project ID or the project number that contains the BigQuery source. Has
	// a length limit of 128 characters. If not specified, inherits the project
	// ID from the parent request.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The BigQuery data set to copy the data from with a length limit
	// of 1,024 characters.
	DatasetId string `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// Required. The BigQuery table to copy the data from with a length limit of
	// 1,024 characters.
	TableId string `protobuf:"bytes,3,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	// Intermediate Cloud Storage directory used for the import with a length
	// limit of 2,000 characters. Can be specified if one wants to have the
	// BigQuery export to a specific Cloud Storage directory.
	GcsStagingDir string `protobuf:"bytes,4,opt,name=gcs_staging_dir,json=gcsStagingDir,proto3" json:"gcs_staging_dir,omitempty"`
	// The schema to use when parsing the data from the source.
	//
	// Supported values for user event imports:
	//
	// * `user_event` (default): One
	// [UserEvent][google.cloud.discoveryengine.v1alpha.UserEvent] per row.
	//
	// Supported values for document imports:
	//
	// * `document` (default): One
	// [Document][google.cloud.discoveryengine.v1alpha.Document] format per
	//
	//	row. Each document must have a valid
	//	[Document.id][google.cloud.discoveryengine.v1alpha.Document.id] and one
	//	of
	//	[Document.json_data][google.cloud.discoveryengine.v1alpha.Document.json_data]
	//	or
	//	[Document.struct_data][google.cloud.discoveryengine.v1alpha.Document.struct_data].
	//   - `custom`: One custom data per row in arbitrary format that conforms to
	//     the defined [Schema][google.cloud.discoveryengine.v1alpha.Schema] of the
	//     data store. This can only be used by the GENERIC Data Store vertical.
	DataSchema string `protobuf:"bytes,6,opt,name=data_schema,json=dataSchema,proto3" json:"data_schema,omitempty"`
}

func (x *BigQuerySource) Reset() {
	*x = BigQuerySource{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BigQuerySource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQuerySource) ProtoMessage() {}

func (x *BigQuerySource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQuerySource.ProtoReflect.Descriptor instead.
func (*BigQuerySource) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{1}
}

func (m *BigQuerySource) GetPartition() isBigQuerySource_Partition {
	if m != nil {
		return m.Partition
	}
	return nil
}

func (x *BigQuerySource) GetPartitionDate() *date.Date {
	if x, ok := x.GetPartition().(*BigQuerySource_PartitionDate); ok {
		return x.PartitionDate
	}
	return nil
}

func (x *BigQuerySource) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *BigQuerySource) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *BigQuerySource) GetTableId() string {
	if x != nil {
		return x.TableId
	}
	return ""
}

func (x *BigQuerySource) GetGcsStagingDir() string {
	if x != nil {
		return x.GcsStagingDir
	}
	return ""
}

func (x *BigQuerySource) GetDataSchema() string {
	if x != nil {
		return x.DataSchema
	}
	return ""
}

type isBigQuerySource_Partition interface {
	isBigQuerySource_Partition()
}

type BigQuerySource_PartitionDate struct {
	// BigQuery time partitioned table's _PARTITIONDATE in YYYY-MM-DD format.
	PartitionDate *date.Date `protobuf:"bytes,5,opt,name=partition_date,json=partitionDate,proto3,oneof"`
}

func (*BigQuerySource_PartitionDate) isBigQuerySource_Partition() {}

// The Spanner source for importing data
type SpannerSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The project ID that contains the Spanner source. Has a length limit of 128
	// characters. If not specified, inherits the project ID from the parent
	// request.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The instance ID of the source Spanner table.
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Required. The database ID of the source Spanner table.
	DatabaseId string `protobuf:"bytes,3,opt,name=database_id,json=databaseId,proto3" json:"database_id,omitempty"`
	// Required. The table name of the Spanner database that needs to be imported.
	TableId string `protobuf:"bytes,4,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	// Whether to apply data boost on Spanner export. Enabling this option will
	// incur additional cost. More info can be found
	// [here](https://cloud.google.com/spanner/docs/databoost/databoost-overview#billing_and_quotas).
	EnableDataBoost bool `protobuf:"varint,5,opt,name=enable_data_boost,json=enableDataBoost,proto3" json:"enable_data_boost,omitempty"`
}

func (x *SpannerSource) Reset() {
	*x = SpannerSource{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpannerSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpannerSource) ProtoMessage() {}

func (x *SpannerSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpannerSource.ProtoReflect.Descriptor instead.
func (*SpannerSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{2}
}

func (x *SpannerSource) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *SpannerSource) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *SpannerSource) GetDatabaseId() string {
	if x != nil {
		return x.DatabaseId
	}
	return ""
}

func (x *SpannerSource) GetTableId() string {
	if x != nil {
		return x.TableId
	}
	return ""
}

func (x *SpannerSource) GetEnableDataBoost() bool {
	if x != nil {
		return x.EnableDataBoost
	}
	return false
}

// The Bigtable Options object that contains information to support
// the import.
type BigtableOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The field name used for saving row key value in the document. The name has
	// to match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`.
	KeyFieldName string `protobuf:"bytes,1,opt,name=key_field_name,json=keyFieldName,proto3" json:"key_field_name,omitempty"`
	// The mapping from family names to an object that contains column families
	// level information for the given column family. If a family is not present
	// in this map it will be ignored.
	Families map[string]*BigtableOptions_BigtableColumnFamily `protobuf:"bytes,2,rep,name=families,proto3" json:"families,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *BigtableOptions) Reset() {
	*x = BigtableOptions{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BigtableOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigtableOptions) ProtoMessage() {}

func (x *BigtableOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigtableOptions.ProtoReflect.Descriptor instead.
func (*BigtableOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{3}
}

func (x *BigtableOptions) GetKeyFieldName() string {
	if x != nil {
		return x.KeyFieldName
	}
	return ""
}

func (x *BigtableOptions) GetFamilies() map[string]*BigtableOptions_BigtableColumnFamily {
	if x != nil {
		return x.Families
	}
	return nil
}

// The Cloud Bigtable source for importing data.
type BigtableSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The project ID that contains the Bigtable source. Has a length limit of 128
	// characters. If not specified, inherits the project ID from the parent
	// request.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The instance ID of the Cloud Bigtable that needs to be imported.
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Required. The table ID of the Cloud Bigtable that needs to be imported.
	TableId string `protobuf:"bytes,3,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	// Required. Bigtable options that contains information needed when parsing
	// data into typed structures. For example, column type annotations.
	BigtableOptions *BigtableOptions `protobuf:"bytes,4,opt,name=bigtable_options,json=bigtableOptions,proto3" json:"bigtable_options,omitempty"`
}

func (x *BigtableSource) Reset() {
	*x = BigtableSource{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BigtableSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigtableSource) ProtoMessage() {}

func (x *BigtableSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigtableSource.ProtoReflect.Descriptor instead.
func (*BigtableSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{4}
}

func (x *BigtableSource) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *BigtableSource) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *BigtableSource) GetTableId() string {
	if x != nil {
		return x.TableId
	}
	return ""
}

func (x *BigtableSource) GetBigtableOptions() *BigtableOptions {
	if x != nil {
		return x.BigtableOptions
	}
	return nil
}

// Cloud FhirStore source import data from.
type FhirStoreSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The full resource name of the FHIR store to import data from, in
	// the format of
	// `projects/{project}/locations/{location}/datasets/{dataset}/fhirStores/{fhir_store}`.
	FhirStore string `protobuf:"bytes,1,opt,name=fhir_store,json=fhirStore,proto3" json:"fhir_store,omitempty"`
	// Intermediate Cloud Storage directory used for the import with a length
	// limit of 2,000 characters. Can be specified if one wants to have the
	// FhirStore export to a specific Cloud Storage directory.
	GcsStagingDir string `protobuf:"bytes,2,opt,name=gcs_staging_dir,json=gcsStagingDir,proto3" json:"gcs_staging_dir,omitempty"`
	// The FHIR resource types to import. The resource types should be a subset of
	// all [supported FHIR resource
	// types](https://cloud.google.com/generative-ai-app-builder/docs/fhir-schema-reference#resource-level-specification).
	// Default to all supported FHIR resource types if empty.
	ResourceTypes []string `protobuf:"bytes,3,rep,name=resource_types,json=resourceTypes,proto3" json:"resource_types,omitempty"`
}

func (x *FhirStoreSource) Reset() {
	*x = FhirStoreSource{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FhirStoreSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FhirStoreSource) ProtoMessage() {}

func (x *FhirStoreSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FhirStoreSource.ProtoReflect.Descriptor instead.
func (*FhirStoreSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{5}
}

func (x *FhirStoreSource) GetFhirStore() string {
	if x != nil {
		return x.FhirStore
	}
	return ""
}

func (x *FhirStoreSource) GetGcsStagingDir() string {
	if x != nil {
		return x.GcsStagingDir
	}
	return ""
}

func (x *FhirStoreSource) GetResourceTypes() []string {
	if x != nil {
		return x.ResourceTypes
	}
	return nil
}

// Cloud SQL source import data from.
type CloudSqlSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The project ID that contains the Cloud SQL source. Has a length limit of
	// 128 characters. If not specified, inherits the project ID from the parent
	// request.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The Cloud SQL instance to copy the data from with a length limit
	// of 256 characters.
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Required. The Cloud SQL database to copy the data from with a length limit
	// of 256 characters.
	DatabaseId string `protobuf:"bytes,3,opt,name=database_id,json=databaseId,proto3" json:"database_id,omitempty"`
	// Required. The Cloud SQL table to copy the data from with a length limit of
	// 256 characters.
	TableId string `protobuf:"bytes,4,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	// Intermediate Cloud Storage directory used for the import with a length
	// limit of 2,000 characters. Can be specified if one wants to have the
	// Cloud SQL export to a specific Cloud Storage directory.
	//
	// Ensure that the Cloud SQL service account has the necessary Cloud
	// Storage Admin permissions to access the specified Cloud Storage directory.
	GcsStagingDir string `protobuf:"bytes,5,opt,name=gcs_staging_dir,json=gcsStagingDir,proto3" json:"gcs_staging_dir,omitempty"`
	// Option for serverless export. Enabling this option will incur additional
	// cost. More info can be found
	// [here](https://cloud.google.com/sql/pricing#serverless).
	Offload bool `protobuf:"varint,6,opt,name=offload,proto3" json:"offload,omitempty"`
}

func (x *CloudSqlSource) Reset() {
	*x = CloudSqlSource{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloudSqlSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudSqlSource) ProtoMessage() {}

func (x *CloudSqlSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudSqlSource.ProtoReflect.Descriptor instead.
func (*CloudSqlSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{6}
}

func (x *CloudSqlSource) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *CloudSqlSource) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *CloudSqlSource) GetDatabaseId() string {
	if x != nil {
		return x.DatabaseId
	}
	return ""
}

func (x *CloudSqlSource) GetTableId() string {
	if x != nil {
		return x.TableId
	}
	return ""
}

func (x *CloudSqlSource) GetGcsStagingDir() string {
	if x != nil {
		return x.GcsStagingDir
	}
	return ""
}

func (x *CloudSqlSource) GetOffload() bool {
	if x != nil {
		return x.Offload
	}
	return false
}

// AlloyDB source import data from.
type AlloyDbSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The project ID that contains the AlloyDB source.
	// Has a length limit of 128 characters. If not specified, inherits the
	// project ID from the parent request.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The AlloyDB location to copy the data from with a length limit of
	// 256 characters.
	LocationId string `protobuf:"bytes,2,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
	// Required. The AlloyDB cluster to copy the data from with a length limit of
	// 256 characters.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The AlloyDB database to copy the data from with a length limit of
	// 256 characters.
	DatabaseId string `protobuf:"bytes,4,opt,name=database_id,json=databaseId,proto3" json:"database_id,omitempty"`
	// Required. The AlloyDB table to copy the data from with a length limit of
	// 256 characters.
	TableId string `protobuf:"bytes,5,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	// Intermediate Cloud Storage directory used for the import with a length
	// limit of 2,000 characters. Can be specified if one wants to have the
	// AlloyDB export to a specific Cloud Storage directory.
	//
	// Ensure that the AlloyDB service account has the necessary Cloud
	// Storage Admin permissions to access the specified Cloud Storage directory.
	GcsStagingDir string `protobuf:"bytes,6,opt,name=gcs_staging_dir,json=gcsStagingDir,proto3" json:"gcs_staging_dir,omitempty"`
}

func (x *AlloyDbSource) Reset() {
	*x = AlloyDbSource{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AlloyDbSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AlloyDbSource) ProtoMessage() {}

func (x *AlloyDbSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AlloyDbSource.ProtoReflect.Descriptor instead.
func (*AlloyDbSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{7}
}

func (x *AlloyDbSource) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *AlloyDbSource) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

func (x *AlloyDbSource) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *AlloyDbSource) GetDatabaseId() string {
	if x != nil {
		return x.DatabaseId
	}
	return ""
}

func (x *AlloyDbSource) GetTableId() string {
	if x != nil {
		return x.TableId
	}
	return ""
}

func (x *AlloyDbSource) GetGcsStagingDir() string {
	if x != nil {
		return x.GcsStagingDir
	}
	return ""
}

// Firestore source import data from.
type FirestoreSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The project ID that the Cloud SQL source is in with a length limit of 128
	// characters. If not specified, inherits the project ID from the parent
	// request.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The Firestore database to copy the data from with a length limit
	// of 256 characters.
	DatabaseId string `protobuf:"bytes,2,opt,name=database_id,json=databaseId,proto3" json:"database_id,omitempty"`
	// Required. The Firestore collection (or entity) to copy the data from with a
	// length limit of 1,500 characters.
	CollectionId string `protobuf:"bytes,3,opt,name=collection_id,json=collectionId,proto3" json:"collection_id,omitempty"`
	// Intermediate Cloud Storage directory used for the import with a length
	// limit of 2,000 characters. Can be specified if one wants to have the
	// Firestore export to a specific Cloud Storage directory.
	//
	// Ensure that the Firestore service account has the necessary Cloud
	// Storage Admin permissions to access the specified Cloud Storage directory.
	GcsStagingDir string `protobuf:"bytes,4,opt,name=gcs_staging_dir,json=gcsStagingDir,proto3" json:"gcs_staging_dir,omitempty"`
}

func (x *FirestoreSource) Reset() {
	*x = FirestoreSource{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FirestoreSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FirestoreSource) ProtoMessage() {}

func (x *FirestoreSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FirestoreSource.ProtoReflect.Descriptor instead.
func (*FirestoreSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{8}
}

func (x *FirestoreSource) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *FirestoreSource) GetDatabaseId() string {
	if x != nil {
		return x.DatabaseId
	}
	return ""
}

func (x *FirestoreSource) GetCollectionId() string {
	if x != nil {
		return x.CollectionId
	}
	return ""
}

func (x *FirestoreSource) GetGcsStagingDir() string {
	if x != nil {
		return x.GcsStagingDir
	}
	return ""
}

// Configuration of destination for Import related errors.
type ImportErrorConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Errors destination.
	//
	// Types that are assignable to Destination:
	//
	//	*ImportErrorConfig_GcsPrefix
	Destination isImportErrorConfig_Destination `protobuf_oneof:"destination"`
}

func (x *ImportErrorConfig) Reset() {
	*x = ImportErrorConfig{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportErrorConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportErrorConfig) ProtoMessage() {}

func (x *ImportErrorConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportErrorConfig.ProtoReflect.Descriptor instead.
func (*ImportErrorConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{9}
}

func (m *ImportErrorConfig) GetDestination() isImportErrorConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *ImportErrorConfig) GetGcsPrefix() string {
	if x, ok := x.GetDestination().(*ImportErrorConfig_GcsPrefix); ok {
		return x.GcsPrefix
	}
	return ""
}

type isImportErrorConfig_Destination interface {
	isImportErrorConfig_Destination()
}

type ImportErrorConfig_GcsPrefix struct {
	// Cloud Storage prefix for import errors. This must be an empty,
	// existing Cloud Storage directory. Import errors are written to
	// sharded files in this directory, one per line, as a JSON-encoded
	// `google.rpc.Status` message.
	GcsPrefix string `protobuf:"bytes,1,opt,name=gcs_prefix,json=gcsPrefix,proto3,oneof"`
}

func (*ImportErrorConfig_GcsPrefix) isImportErrorConfig_Destination() {}

// Request message for the ImportUserEvents request.
type ImportUserEventsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required - The desired input source of the user event data.
	//
	// Types that are assignable to Source:
	//
	//	*ImportUserEventsRequest_InlineSource_
	//	*ImportUserEventsRequest_GcsSource
	//	*ImportUserEventsRequest_BigquerySource
	Source isImportUserEventsRequest_Source `protobuf_oneof:"source"`
	// Required. Parent DataStore resource name, of the form
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The desired location of errors incurred during the Import. Cannot be set
	// for inline user event imports.
	ErrorConfig *ImportErrorConfig `protobuf:"bytes,5,opt,name=error_config,json=errorConfig,proto3" json:"error_config,omitempty"`
}

func (x *ImportUserEventsRequest) Reset() {
	*x = ImportUserEventsRequest{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportUserEventsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportUserEventsRequest) ProtoMessage() {}

func (x *ImportUserEventsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportUserEventsRequest.ProtoReflect.Descriptor instead.
func (*ImportUserEventsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{10}
}

func (m *ImportUserEventsRequest) GetSource() isImportUserEventsRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ImportUserEventsRequest) GetInlineSource() *ImportUserEventsRequest_InlineSource {
	if x, ok := x.GetSource().(*ImportUserEventsRequest_InlineSource_); ok {
		return x.InlineSource
	}
	return nil
}

func (x *ImportUserEventsRequest) GetGcsSource() *GcsSource {
	if x, ok := x.GetSource().(*ImportUserEventsRequest_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (x *ImportUserEventsRequest) GetBigquerySource() *BigQuerySource {
	if x, ok := x.GetSource().(*ImportUserEventsRequest_BigquerySource); ok {
		return x.BigquerySource
	}
	return nil
}

func (x *ImportUserEventsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ImportUserEventsRequest) GetErrorConfig() *ImportErrorConfig {
	if x != nil {
		return x.ErrorConfig
	}
	return nil
}

type isImportUserEventsRequest_Source interface {
	isImportUserEventsRequest_Source()
}

type ImportUserEventsRequest_InlineSource_ struct {
	// The Inline source for the input content for UserEvents.
	InlineSource *ImportUserEventsRequest_InlineSource `protobuf:"bytes,2,opt,name=inline_source,json=inlineSource,proto3,oneof"`
}

type ImportUserEventsRequest_GcsSource struct {
	// Cloud Storage location for the input content.
	GcsSource *GcsSource `protobuf:"bytes,3,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

type ImportUserEventsRequest_BigquerySource struct {
	// BigQuery input source.
	BigquerySource *BigQuerySource `protobuf:"bytes,4,opt,name=bigquery_source,json=bigquerySource,proto3,oneof"`
}

func (*ImportUserEventsRequest_InlineSource_) isImportUserEventsRequest_Source() {}

func (*ImportUserEventsRequest_GcsSource) isImportUserEventsRequest_Source() {}

func (*ImportUserEventsRequest_BigquerySource) isImportUserEventsRequest_Source() {}

// Response of the ImportUserEventsRequest. If the long running
// operation was successful, then this message is returned by the
// google.longrunning.Operations.response field if the operation was successful.
type ImportUserEventsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A sample of errors encountered while processing the request.
	ErrorSamples []*status.Status `protobuf:"bytes,1,rep,name=error_samples,json=errorSamples,proto3" json:"error_samples,omitempty"`
	// Echoes the destination for the complete errors if this field was set in
	// the request.
	ErrorConfig *ImportErrorConfig `protobuf:"bytes,2,opt,name=error_config,json=errorConfig,proto3" json:"error_config,omitempty"`
	// Count of user events imported with complete existing Documents.
	JoinedEventsCount int64 `protobuf:"varint,3,opt,name=joined_events_count,json=joinedEventsCount,proto3" json:"joined_events_count,omitempty"`
	// Count of user events imported, but with Document information not found
	// in the existing Branch.
	UnjoinedEventsCount int64 `protobuf:"varint,4,opt,name=unjoined_events_count,json=unjoinedEventsCount,proto3" json:"unjoined_events_count,omitempty"`
}

func (x *ImportUserEventsResponse) Reset() {
	*x = ImportUserEventsResponse{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportUserEventsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportUserEventsResponse) ProtoMessage() {}

func (x *ImportUserEventsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportUserEventsResponse.ProtoReflect.Descriptor instead.
func (*ImportUserEventsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{11}
}

func (x *ImportUserEventsResponse) GetErrorSamples() []*status.Status {
	if x != nil {
		return x.ErrorSamples
	}
	return nil
}

func (x *ImportUserEventsResponse) GetErrorConfig() *ImportErrorConfig {
	if x != nil {
		return x.ErrorConfig
	}
	return nil
}

func (x *ImportUserEventsResponse) GetJoinedEventsCount() int64 {
	if x != nil {
		return x.JoinedEventsCount
	}
	return 0
}

func (x *ImportUserEventsResponse) GetUnjoinedEventsCount() int64 {
	if x != nil {
		return x.UnjoinedEventsCount
	}
	return 0
}

// Metadata related to the progress of the Import operation. This is
// returned by the google.longrunning.Operation.metadata field.
type ImportUserEventsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation create time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Operation last update time. If the operation is done, this is also the
	// finish time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Count of entries that were processed successfully.
	SuccessCount int64 `protobuf:"varint,3,opt,name=success_count,json=successCount,proto3" json:"success_count,omitempty"`
	// Count of entries that encountered errors while processing.
	FailureCount int64 `protobuf:"varint,4,opt,name=failure_count,json=failureCount,proto3" json:"failure_count,omitempty"`
}

func (x *ImportUserEventsMetadata) Reset() {
	*x = ImportUserEventsMetadata{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportUserEventsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportUserEventsMetadata) ProtoMessage() {}

func (x *ImportUserEventsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportUserEventsMetadata.ProtoReflect.Descriptor instead.
func (*ImportUserEventsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{12}
}

func (x *ImportUserEventsMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ImportUserEventsMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ImportUserEventsMetadata) GetSuccessCount() int64 {
	if x != nil {
		return x.SuccessCount
	}
	return 0
}

func (x *ImportUserEventsMetadata) GetFailureCount() int64 {
	if x != nil {
		return x.FailureCount
	}
	return 0
}

// Metadata related to the progress of the ImportDocuments operation. This is
// returned by the google.longrunning.Operation.metadata field.
type ImportDocumentsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation create time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Operation last update time. If the operation is done, this is also the
	// finish time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Count of entries that were processed successfully.
	SuccessCount int64 `protobuf:"varint,3,opt,name=success_count,json=successCount,proto3" json:"success_count,omitempty"`
	// Count of entries that encountered errors while processing.
	FailureCount int64 `protobuf:"varint,4,opt,name=failure_count,json=failureCount,proto3" json:"failure_count,omitempty"`
	// Total count of entries that were processed.
	TotalCount int64 `protobuf:"varint,5,opt,name=total_count,json=totalCount,proto3" json:"total_count,omitempty"`
}

func (x *ImportDocumentsMetadata) Reset() {
	*x = ImportDocumentsMetadata{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportDocumentsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDocumentsMetadata) ProtoMessage() {}

func (x *ImportDocumentsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDocumentsMetadata.ProtoReflect.Descriptor instead.
func (*ImportDocumentsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{13}
}

func (x *ImportDocumentsMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ImportDocumentsMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ImportDocumentsMetadata) GetSuccessCount() int64 {
	if x != nil {
		return x.SuccessCount
	}
	return 0
}

func (x *ImportDocumentsMetadata) GetFailureCount() int64 {
	if x != nil {
		return x.FailureCount
	}
	return 0
}

func (x *ImportDocumentsMetadata) GetTotalCount() int64 {
	if x != nil {
		return x.TotalCount
	}
	return 0
}

// Request message for Import methods.
type ImportDocumentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The source of the input.
	//
	// Types that are assignable to Source:
	//
	//	*ImportDocumentsRequest_InlineSource_
	//	*ImportDocumentsRequest_GcsSource
	//	*ImportDocumentsRequest_BigquerySource
	//	*ImportDocumentsRequest_FhirStoreSource
	//	*ImportDocumentsRequest_SpannerSource
	//	*ImportDocumentsRequest_CloudSqlSource
	//	*ImportDocumentsRequest_FirestoreSource
	//	*ImportDocumentsRequest_AlloyDbSource
	//	*ImportDocumentsRequest_BigtableSource
	Source isImportDocumentsRequest_Source `protobuf_oneof:"source"`
	// Required. The parent branch resource name, such as
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.
	// Requires create/update permission.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The desired location of errors incurred during the Import.
	ErrorConfig *ImportErrorConfig `protobuf:"bytes,5,opt,name=error_config,json=errorConfig,proto3" json:"error_config,omitempty"`
	// The mode of reconciliation between existing documents and the documents to
	// be imported. Defaults to
	// [ReconciliationMode.INCREMENTAL][google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode.INCREMENTAL].
	ReconciliationMode ImportDocumentsRequest_ReconciliationMode `protobuf:"varint,6,opt,name=reconciliation_mode,json=reconciliationMode,proto3,enum=google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest_ReconciliationMode" json:"reconciliation_mode,omitempty"`
	// Indicates which fields in the provided imported documents to update. If
	// not set, the default is to update all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,7,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Whether to automatically generate IDs for the documents if absent.
	//
	// If set to `true`,
	// [Document.id][google.cloud.discoveryengine.v1alpha.Document.id]s are
	// automatically generated based on the hash of the payload, where IDs may not
	// be consistent during multiple imports. In which case
	// [ReconciliationMode.FULL][google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode.FULL]
	// is highly recommended to avoid duplicate contents. If unset or set to
	// `false`, [Document.id][google.cloud.discoveryengine.v1alpha.Document.id]s
	// have to be specified using
	// [id_field][google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.id_field],
	// otherwise, documents without IDs fail to be imported.
	//
	// Supported data sources:
	//
	// * [GcsSource][google.cloud.discoveryengine.v1alpha.GcsSource].
	// [GcsSource.data_schema][google.cloud.discoveryengine.v1alpha.GcsSource.data_schema]
	// must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
	// * [BigQuerySource][google.cloud.discoveryengine.v1alpha.BigQuerySource].
	// [BigQuerySource.data_schema][google.cloud.discoveryengine.v1alpha.BigQuerySource.data_schema]
	// must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
	// * [SpannerSource][google.cloud.discoveryengine.v1alpha.SpannerSource].
	// * [CloudSqlSource][google.cloud.discoveryengine.v1alpha.CloudSqlSource].
	// * [FirestoreSource][google.cloud.discoveryengine.v1alpha.FirestoreSource].
	// * [BigtableSource][google.cloud.discoveryengine.v1alpha.BigtableSource].
	AutoGenerateIds bool `protobuf:"varint,8,opt,name=auto_generate_ids,json=autoGenerateIds,proto3" json:"auto_generate_ids,omitempty"`
	// The field indicates the ID field or column to be used as unique IDs of
	// the documents.
	//
	// For [GcsSource][google.cloud.discoveryengine.v1alpha.GcsSource] it is the
	// key of the JSON field. For instance, `my_id` for JSON `{"my_id":
	// "some_uuid"}`. For others, it may be the column name of the table where the
	// unique ids are stored.
	//
	// The values of the JSON field or the table column are used as the
	// [Document.id][google.cloud.discoveryengine.v1alpha.Document.id]s. The JSON
	// field or the table column must be of string type, and the values must be
	// set as valid strings conform to
	// [RFC-1034](https://tools.ietf.org/html/rfc1034) with 1-63 characters.
	// Otherwise, documents without valid IDs fail to be imported.
	//
	// Only set this field when
	// [auto_generate_ids][google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.auto_generate_ids]
	// is unset or set as `false`. Otherwise, an INVALID_ARGUMENT error is thrown.
	//
	// If it is unset, a default value `_id` is used when importing from the
	// allowed data sources.
	//
	// Supported data sources:
	//
	// * [GcsSource][google.cloud.discoveryengine.v1alpha.GcsSource].
	// [GcsSource.data_schema][google.cloud.discoveryengine.v1alpha.GcsSource.data_schema]
	// must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
	// * [BigQuerySource][google.cloud.discoveryengine.v1alpha.BigQuerySource].
	// [BigQuerySource.data_schema][google.cloud.discoveryengine.v1alpha.BigQuerySource.data_schema]
	// must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
	// * [SpannerSource][google.cloud.discoveryengine.v1alpha.SpannerSource].
	// * [CloudSqlSource][google.cloud.discoveryengine.v1alpha.CloudSqlSource].
	// * [FirestoreSource][google.cloud.discoveryengine.v1alpha.FirestoreSource].
	// * [BigtableSource][google.cloud.discoveryengine.v1alpha.BigtableSource].
	IdField string `protobuf:"bytes,9,opt,name=id_field,json=idField,proto3" json:"id_field,omitempty"`
}

func (x *ImportDocumentsRequest) Reset() {
	*x = ImportDocumentsRequest{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportDocumentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDocumentsRequest) ProtoMessage() {}

func (x *ImportDocumentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDocumentsRequest.ProtoReflect.Descriptor instead.
func (*ImportDocumentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{14}
}

func (m *ImportDocumentsRequest) GetSource() isImportDocumentsRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ImportDocumentsRequest) GetInlineSource() *ImportDocumentsRequest_InlineSource {
	if x, ok := x.GetSource().(*ImportDocumentsRequest_InlineSource_); ok {
		return x.InlineSource
	}
	return nil
}

func (x *ImportDocumentsRequest) GetGcsSource() *GcsSource {
	if x, ok := x.GetSource().(*ImportDocumentsRequest_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (x *ImportDocumentsRequest) GetBigquerySource() *BigQuerySource {
	if x, ok := x.GetSource().(*ImportDocumentsRequest_BigquerySource); ok {
		return x.BigquerySource
	}
	return nil
}

func (x *ImportDocumentsRequest) GetFhirStoreSource() *FhirStoreSource {
	if x, ok := x.GetSource().(*ImportDocumentsRequest_FhirStoreSource); ok {
		return x.FhirStoreSource
	}
	return nil
}

func (x *ImportDocumentsRequest) GetSpannerSource() *SpannerSource {
	if x, ok := x.GetSource().(*ImportDocumentsRequest_SpannerSource); ok {
		return x.SpannerSource
	}
	return nil
}

func (x *ImportDocumentsRequest) GetCloudSqlSource() *CloudSqlSource {
	if x, ok := x.GetSource().(*ImportDocumentsRequest_CloudSqlSource); ok {
		return x.CloudSqlSource
	}
	return nil
}

func (x *ImportDocumentsRequest) GetFirestoreSource() *FirestoreSource {
	if x, ok := x.GetSource().(*ImportDocumentsRequest_FirestoreSource); ok {
		return x.FirestoreSource
	}
	return nil
}

func (x *ImportDocumentsRequest) GetAlloyDbSource() *AlloyDbSource {
	if x, ok := x.GetSource().(*ImportDocumentsRequest_AlloyDbSource); ok {
		return x.AlloyDbSource
	}
	return nil
}

func (x *ImportDocumentsRequest) GetBigtableSource() *BigtableSource {
	if x, ok := x.GetSource().(*ImportDocumentsRequest_BigtableSource); ok {
		return x.BigtableSource
	}
	return nil
}

func (x *ImportDocumentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ImportDocumentsRequest) GetErrorConfig() *ImportErrorConfig {
	if x != nil {
		return x.ErrorConfig
	}
	return nil
}

func (x *ImportDocumentsRequest) GetReconciliationMode() ImportDocumentsRequest_ReconciliationMode {
	if x != nil {
		return x.ReconciliationMode
	}
	return ImportDocumentsRequest_RECONCILIATION_MODE_UNSPECIFIED
}

func (x *ImportDocumentsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *ImportDocumentsRequest) GetAutoGenerateIds() bool {
	if x != nil {
		return x.AutoGenerateIds
	}
	return false
}

func (x *ImportDocumentsRequest) GetIdField() string {
	if x != nil {
		return x.IdField
	}
	return ""
}

type isImportDocumentsRequest_Source interface {
	isImportDocumentsRequest_Source()
}

type ImportDocumentsRequest_InlineSource_ struct {
	// The Inline source for the input content for documents.
	InlineSource *ImportDocumentsRequest_InlineSource `protobuf:"bytes,2,opt,name=inline_source,json=inlineSource,proto3,oneof"`
}

type ImportDocumentsRequest_GcsSource struct {
	// Cloud Storage location for the input content.
	GcsSource *GcsSource `protobuf:"bytes,3,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

type ImportDocumentsRequest_BigquerySource struct {
	// BigQuery input source.
	BigquerySource *BigQuerySource `protobuf:"bytes,4,opt,name=bigquery_source,json=bigquerySource,proto3,oneof"`
}

type ImportDocumentsRequest_FhirStoreSource struct {
	// FhirStore input source.
	FhirStoreSource *FhirStoreSource `protobuf:"bytes,10,opt,name=fhir_store_source,json=fhirStoreSource,proto3,oneof"`
}

type ImportDocumentsRequest_SpannerSource struct {
	// Spanner input source.
	SpannerSource *SpannerSource `protobuf:"bytes,11,opt,name=spanner_source,json=spannerSource,proto3,oneof"`
}

type ImportDocumentsRequest_CloudSqlSource struct {
	// Cloud SQL input source.
	CloudSqlSource *CloudSqlSource `protobuf:"bytes,12,opt,name=cloud_sql_source,json=cloudSqlSource,proto3,oneof"`
}

type ImportDocumentsRequest_FirestoreSource struct {
	// Firestore input source.
	FirestoreSource *FirestoreSource `protobuf:"bytes,13,opt,name=firestore_source,json=firestoreSource,proto3,oneof"`
}

type ImportDocumentsRequest_AlloyDbSource struct {
	// AlloyDB input source.
	AlloyDbSource *AlloyDbSource `protobuf:"bytes,14,opt,name=alloy_db_source,json=alloyDbSource,proto3,oneof"`
}

type ImportDocumentsRequest_BigtableSource struct {
	// Cloud Bigtable input source.
	BigtableSource *BigtableSource `protobuf:"bytes,15,opt,name=bigtable_source,json=bigtableSource,proto3,oneof"`
}

func (*ImportDocumentsRequest_InlineSource_) isImportDocumentsRequest_Source() {}

func (*ImportDocumentsRequest_GcsSource) isImportDocumentsRequest_Source() {}

func (*ImportDocumentsRequest_BigquerySource) isImportDocumentsRequest_Source() {}

func (*ImportDocumentsRequest_FhirStoreSource) isImportDocumentsRequest_Source() {}

func (*ImportDocumentsRequest_SpannerSource) isImportDocumentsRequest_Source() {}

func (*ImportDocumentsRequest_CloudSqlSource) isImportDocumentsRequest_Source() {}

func (*ImportDocumentsRequest_FirestoreSource) isImportDocumentsRequest_Source() {}

func (*ImportDocumentsRequest_AlloyDbSource) isImportDocumentsRequest_Source() {}

func (*ImportDocumentsRequest_BigtableSource) isImportDocumentsRequest_Source() {}

// Response of the
// [ImportDocumentsRequest][google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest].
// If the long running operation is done, then this message is returned by the
// google.longrunning.Operations.response field if the operation was successful.
type ImportDocumentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A sample of errors encountered while processing the request.
	ErrorSamples []*status.Status `protobuf:"bytes,1,rep,name=error_samples,json=errorSamples,proto3" json:"error_samples,omitempty"`
	// Echoes the destination for the complete errors in the request if set.
	ErrorConfig *ImportErrorConfig `protobuf:"bytes,2,opt,name=error_config,json=errorConfig,proto3" json:"error_config,omitempty"`
}

func (x *ImportDocumentsResponse) Reset() {
	*x = ImportDocumentsResponse{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportDocumentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDocumentsResponse) ProtoMessage() {}

func (x *ImportDocumentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDocumentsResponse.ProtoReflect.Descriptor instead.
func (*ImportDocumentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{15}
}

func (x *ImportDocumentsResponse) GetErrorSamples() []*status.Status {
	if x != nil {
		return x.ErrorSamples
	}
	return nil
}

func (x *ImportDocumentsResponse) GetErrorConfig() *ImportErrorConfig {
	if x != nil {
		return x.ErrorConfig
	}
	return nil
}

// Request message for
// [CompletionService.ImportSuggestionDenyListEntries][google.cloud.discoveryengine.v1alpha.CompletionService.ImportSuggestionDenyListEntries]
// method.
type ImportSuggestionDenyListEntriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source of the updated SuggestionDenyList.
	//
	// Types that are assignable to Source:
	//
	//	*ImportSuggestionDenyListEntriesRequest_InlineSource_
	//	*ImportSuggestionDenyListEntriesRequest_GcsSource
	Source isImportSuggestionDenyListEntriesRequest_Source `protobuf_oneof:"source"`
	// Required. The parent data store resource name for which to import denylist
	// entries. Follows pattern projects/*/locations/*/collections/*/dataStores/*.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ImportSuggestionDenyListEntriesRequest) Reset() {
	*x = ImportSuggestionDenyListEntriesRequest{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportSuggestionDenyListEntriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportSuggestionDenyListEntriesRequest) ProtoMessage() {}

func (x *ImportSuggestionDenyListEntriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportSuggestionDenyListEntriesRequest.ProtoReflect.Descriptor instead.
func (*ImportSuggestionDenyListEntriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{16}
}

func (m *ImportSuggestionDenyListEntriesRequest) GetSource() isImportSuggestionDenyListEntriesRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ImportSuggestionDenyListEntriesRequest) GetInlineSource() *ImportSuggestionDenyListEntriesRequest_InlineSource {
	if x, ok := x.GetSource().(*ImportSuggestionDenyListEntriesRequest_InlineSource_); ok {
		return x.InlineSource
	}
	return nil
}

func (x *ImportSuggestionDenyListEntriesRequest) GetGcsSource() *GcsSource {
	if x, ok := x.GetSource().(*ImportSuggestionDenyListEntriesRequest_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (x *ImportSuggestionDenyListEntriesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

type isImportSuggestionDenyListEntriesRequest_Source interface {
	isImportSuggestionDenyListEntriesRequest_Source()
}

type ImportSuggestionDenyListEntriesRequest_InlineSource_ struct {
	// The Inline source for the input content for suggestion deny list entries.
	InlineSource *ImportSuggestionDenyListEntriesRequest_InlineSource `protobuf:"bytes,2,opt,name=inline_source,json=inlineSource,proto3,oneof"`
}

type ImportSuggestionDenyListEntriesRequest_GcsSource struct {
	// Cloud Storage location for the input content.
	//
	// Only 1 file can be specified that contains all entries to import.
	// Supported values `gcs_source.schema` for autocomplete suggestion deny
	// list entry imports:
	//
	// * `suggestion_deny_list` (default): One JSON [SuggestionDenyListEntry]
	// per line.
	GcsSource *GcsSource `protobuf:"bytes,3,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

func (*ImportSuggestionDenyListEntriesRequest_InlineSource_) isImportSuggestionDenyListEntriesRequest_Source() {
}

func (*ImportSuggestionDenyListEntriesRequest_GcsSource) isImportSuggestionDenyListEntriesRequest_Source() {
}

// Response message for
// [CompletionService.ImportSuggestionDenyListEntries][google.cloud.discoveryengine.v1alpha.CompletionService.ImportSuggestionDenyListEntries]
// method.
type ImportSuggestionDenyListEntriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A sample of errors encountered while processing the request.
	ErrorSamples []*status.Status `protobuf:"bytes,1,rep,name=error_samples,json=errorSamples,proto3" json:"error_samples,omitempty"`
	// Count of deny list entries successfully imported.
	ImportedEntriesCount int64 `protobuf:"varint,2,opt,name=imported_entries_count,json=importedEntriesCount,proto3" json:"imported_entries_count,omitempty"`
	// Count of deny list entries that failed to be imported.
	FailedEntriesCount int64 `protobuf:"varint,3,opt,name=failed_entries_count,json=failedEntriesCount,proto3" json:"failed_entries_count,omitempty"`
}

func (x *ImportSuggestionDenyListEntriesResponse) Reset() {
	*x = ImportSuggestionDenyListEntriesResponse{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportSuggestionDenyListEntriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportSuggestionDenyListEntriesResponse) ProtoMessage() {}

func (x *ImportSuggestionDenyListEntriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportSuggestionDenyListEntriesResponse.ProtoReflect.Descriptor instead.
func (*ImportSuggestionDenyListEntriesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{17}
}

func (x *ImportSuggestionDenyListEntriesResponse) GetErrorSamples() []*status.Status {
	if x != nil {
		return x.ErrorSamples
	}
	return nil
}

func (x *ImportSuggestionDenyListEntriesResponse) GetImportedEntriesCount() int64 {
	if x != nil {
		return x.ImportedEntriesCount
	}
	return 0
}

func (x *ImportSuggestionDenyListEntriesResponse) GetFailedEntriesCount() int64 {
	if x != nil {
		return x.FailedEntriesCount
	}
	return 0
}

// Metadata related to the progress of the ImportSuggestionDenyListEntries
// operation. This is returned by the google.longrunning.Operation.metadata
// field.
type ImportSuggestionDenyListEntriesMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation create time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Operation last update time. If the operation is done, this is also the
	// finish time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *ImportSuggestionDenyListEntriesMetadata) Reset() {
	*x = ImportSuggestionDenyListEntriesMetadata{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportSuggestionDenyListEntriesMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportSuggestionDenyListEntriesMetadata) ProtoMessage() {}

func (x *ImportSuggestionDenyListEntriesMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportSuggestionDenyListEntriesMetadata.ProtoReflect.Descriptor instead.
func (*ImportSuggestionDenyListEntriesMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{18}
}

func (x *ImportSuggestionDenyListEntriesMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ImportSuggestionDenyListEntriesMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Request message for
// [CompletionService.ImportCompletionSuggestions][google.cloud.discoveryengine.v1alpha.CompletionService.ImportCompletionSuggestions]
// method.
type ImportCompletionSuggestionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source of the autocomplete suggestions.
	//
	// Types that are assignable to Source:
	//
	//	*ImportCompletionSuggestionsRequest_InlineSource_
	//	*ImportCompletionSuggestionsRequest_GcsSource
	//	*ImportCompletionSuggestionsRequest_BigquerySource
	Source isImportCompletionSuggestionsRequest_Source `protobuf_oneof:"source"`
	// Required. The parent data store resource name for which to import customer
	// autocomplete suggestions.
	//
	// Follows pattern `projects/*/locations/*/collections/*/dataStores/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The desired location of errors incurred during the Import.
	ErrorConfig *ImportErrorConfig `protobuf:"bytes,5,opt,name=error_config,json=errorConfig,proto3" json:"error_config,omitempty"`
}

func (x *ImportCompletionSuggestionsRequest) Reset() {
	*x = ImportCompletionSuggestionsRequest{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportCompletionSuggestionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportCompletionSuggestionsRequest) ProtoMessage() {}

func (x *ImportCompletionSuggestionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportCompletionSuggestionsRequest.ProtoReflect.Descriptor instead.
func (*ImportCompletionSuggestionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{19}
}

func (m *ImportCompletionSuggestionsRequest) GetSource() isImportCompletionSuggestionsRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ImportCompletionSuggestionsRequest) GetInlineSource() *ImportCompletionSuggestionsRequest_InlineSource {
	if x, ok := x.GetSource().(*ImportCompletionSuggestionsRequest_InlineSource_); ok {
		return x.InlineSource
	}
	return nil
}

func (x *ImportCompletionSuggestionsRequest) GetGcsSource() *GcsSource {
	if x, ok := x.GetSource().(*ImportCompletionSuggestionsRequest_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (x *ImportCompletionSuggestionsRequest) GetBigquerySource() *BigQuerySource {
	if x, ok := x.GetSource().(*ImportCompletionSuggestionsRequest_BigquerySource); ok {
		return x.BigquerySource
	}
	return nil
}

func (x *ImportCompletionSuggestionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ImportCompletionSuggestionsRequest) GetErrorConfig() *ImportErrorConfig {
	if x != nil {
		return x.ErrorConfig
	}
	return nil
}

type isImportCompletionSuggestionsRequest_Source interface {
	isImportCompletionSuggestionsRequest_Source()
}

type ImportCompletionSuggestionsRequest_InlineSource_ struct {
	// The Inline source for suggestion entries.
	InlineSource *ImportCompletionSuggestionsRequest_InlineSource `protobuf:"bytes,2,opt,name=inline_source,json=inlineSource,proto3,oneof"`
}

type ImportCompletionSuggestionsRequest_GcsSource struct {
	// Cloud Storage location for the input content.
	GcsSource *GcsSource `protobuf:"bytes,3,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

type ImportCompletionSuggestionsRequest_BigquerySource struct {
	// BigQuery input source.
	BigquerySource *BigQuerySource `protobuf:"bytes,4,opt,name=bigquery_source,json=bigquerySource,proto3,oneof"`
}

func (*ImportCompletionSuggestionsRequest_InlineSource_) isImportCompletionSuggestionsRequest_Source() {
}

func (*ImportCompletionSuggestionsRequest_GcsSource) isImportCompletionSuggestionsRequest_Source() {}

func (*ImportCompletionSuggestionsRequest_BigquerySource) isImportCompletionSuggestionsRequest_Source() {
}

// Response of the
// [CompletionService.ImportCompletionSuggestions][google.cloud.discoveryengine.v1alpha.CompletionService.ImportCompletionSuggestions]
// method. If the long running operation is done, this message is returned by
// the google.longrunning.Operations.response field if the operation is
// successful.
type ImportCompletionSuggestionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A sample of errors encountered while processing the request.
	ErrorSamples []*status.Status `protobuf:"bytes,1,rep,name=error_samples,json=errorSamples,proto3" json:"error_samples,omitempty"`
	// The desired location of errors incurred during the Import.
	ErrorConfig *ImportErrorConfig `protobuf:"bytes,2,opt,name=error_config,json=errorConfig,proto3" json:"error_config,omitempty"`
}

func (x *ImportCompletionSuggestionsResponse) Reset() {
	*x = ImportCompletionSuggestionsResponse{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportCompletionSuggestionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportCompletionSuggestionsResponse) ProtoMessage() {}

func (x *ImportCompletionSuggestionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportCompletionSuggestionsResponse.ProtoReflect.Descriptor instead.
func (*ImportCompletionSuggestionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{20}
}

func (x *ImportCompletionSuggestionsResponse) GetErrorSamples() []*status.Status {
	if x != nil {
		return x.ErrorSamples
	}
	return nil
}

func (x *ImportCompletionSuggestionsResponse) GetErrorConfig() *ImportErrorConfig {
	if x != nil {
		return x.ErrorConfig
	}
	return nil
}

// Metadata related to the progress of the ImportCompletionSuggestions
// operation. This will be returned by the google.longrunning.Operation.metadata
// field.
type ImportCompletionSuggestionsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation create time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Operation last update time. If the operation is done, this is also the
	// finish time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Count of
	// [CompletionSuggestion][google.cloud.discoveryengine.v1alpha.CompletionSuggestion]s
	// successfully imported.
	SuccessCount int64 `protobuf:"varint,3,opt,name=success_count,json=successCount,proto3" json:"success_count,omitempty"`
	// Count of
	// [CompletionSuggestion][google.cloud.discoveryengine.v1alpha.CompletionSuggestion]s
	// that failed to be imported.
	FailureCount int64 `protobuf:"varint,4,opt,name=failure_count,json=failureCount,proto3" json:"failure_count,omitempty"`
}

func (x *ImportCompletionSuggestionsMetadata) Reset() {
	*x = ImportCompletionSuggestionsMetadata{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportCompletionSuggestionsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportCompletionSuggestionsMetadata) ProtoMessage() {}

func (x *ImportCompletionSuggestionsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportCompletionSuggestionsMetadata.ProtoReflect.Descriptor instead.
func (*ImportCompletionSuggestionsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{21}
}

func (x *ImportCompletionSuggestionsMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ImportCompletionSuggestionsMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ImportCompletionSuggestionsMetadata) GetSuccessCount() int64 {
	if x != nil {
		return x.SuccessCount
	}
	return 0
}

func (x *ImportCompletionSuggestionsMetadata) GetFailureCount() int64 {
	if x != nil {
		return x.FailureCount
	}
	return 0
}

// Request message for
// [SampleQueryService.ImportSampleQueries][google.cloud.discoveryengine.v1alpha.SampleQueryService.ImportSampleQueries]
// method.
type ImportSampleQueriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source of the sample queries.
	//
	// Types that are assignable to Source:
	//
	//	*ImportSampleQueriesRequest_InlineSource_
	//	*ImportSampleQueriesRequest_GcsSource
	//	*ImportSampleQueriesRequest_BigquerySource
	Source isImportSampleQueriesRequest_Source `protobuf_oneof:"source"`
	// Required. The parent sample query set resource name, such as
	// `projects/{project}/locations/{location}/sampleQuerySets/{sampleQuerySet}`.
	//
	// If the caller does not have permission to list
	// [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s under this
	// sample query set, regardless of whether or not this sample query set
	// exists, a `PERMISSION_DENIED` error is returned.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The desired location of errors incurred during the Import.
	ErrorConfig *ImportErrorConfig `protobuf:"bytes,5,opt,name=error_config,json=errorConfig,proto3" json:"error_config,omitempty"`
}

func (x *ImportSampleQueriesRequest) Reset() {
	*x = ImportSampleQueriesRequest{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportSampleQueriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportSampleQueriesRequest) ProtoMessage() {}

func (x *ImportSampleQueriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportSampleQueriesRequest.ProtoReflect.Descriptor instead.
func (*ImportSampleQueriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{22}
}

func (m *ImportSampleQueriesRequest) GetSource() isImportSampleQueriesRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ImportSampleQueriesRequest) GetInlineSource() *ImportSampleQueriesRequest_InlineSource {
	if x, ok := x.GetSource().(*ImportSampleQueriesRequest_InlineSource_); ok {
		return x.InlineSource
	}
	return nil
}

func (x *ImportSampleQueriesRequest) GetGcsSource() *GcsSource {
	if x, ok := x.GetSource().(*ImportSampleQueriesRequest_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (x *ImportSampleQueriesRequest) GetBigquerySource() *BigQuerySource {
	if x, ok := x.GetSource().(*ImportSampleQueriesRequest_BigquerySource); ok {
		return x.BigquerySource
	}
	return nil
}

func (x *ImportSampleQueriesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ImportSampleQueriesRequest) GetErrorConfig() *ImportErrorConfig {
	if x != nil {
		return x.ErrorConfig
	}
	return nil
}

type isImportSampleQueriesRequest_Source interface {
	isImportSampleQueriesRequest_Source()
}

type ImportSampleQueriesRequest_InlineSource_ struct {
	// The Inline source for sample query entries.
	InlineSource *ImportSampleQueriesRequest_InlineSource `protobuf:"bytes,2,opt,name=inline_source,json=inlineSource,proto3,oneof"`
}

type ImportSampleQueriesRequest_GcsSource struct {
	// Cloud Storage location for the input content.
	GcsSource *GcsSource `protobuf:"bytes,3,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

type ImportSampleQueriesRequest_BigquerySource struct {
	// BigQuery input source.
	BigquerySource *BigQuerySource `protobuf:"bytes,4,opt,name=bigquery_source,json=bigquerySource,proto3,oneof"`
}

func (*ImportSampleQueriesRequest_InlineSource_) isImportSampleQueriesRequest_Source() {}

func (*ImportSampleQueriesRequest_GcsSource) isImportSampleQueriesRequest_Source() {}

func (*ImportSampleQueriesRequest_BigquerySource) isImportSampleQueriesRequest_Source() {}

// Response of the
// [SampleQueryService.ImportSampleQueries][google.cloud.discoveryengine.v1alpha.SampleQueryService.ImportSampleQueries]
// method. If the long running operation is done, this message is returned by
// the google.longrunning.Operations.response field if the operation is
// successful.
type ImportSampleQueriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A sample of errors encountered while processing the request.
	ErrorSamples []*status.Status `protobuf:"bytes,1,rep,name=error_samples,json=errorSamples,proto3" json:"error_samples,omitempty"`
	// The desired location of errors incurred during the Import.
	ErrorConfig *ImportErrorConfig `protobuf:"bytes,2,opt,name=error_config,json=errorConfig,proto3" json:"error_config,omitempty"`
}

func (x *ImportSampleQueriesResponse) Reset() {
	*x = ImportSampleQueriesResponse{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportSampleQueriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportSampleQueriesResponse) ProtoMessage() {}

func (x *ImportSampleQueriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportSampleQueriesResponse.ProtoReflect.Descriptor instead.
func (*ImportSampleQueriesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{23}
}

func (x *ImportSampleQueriesResponse) GetErrorSamples() []*status.Status {
	if x != nil {
		return x.ErrorSamples
	}
	return nil
}

func (x *ImportSampleQueriesResponse) GetErrorConfig() *ImportErrorConfig {
	if x != nil {
		return x.ErrorConfig
	}
	return nil
}

// Metadata related to the progress of the ImportSampleQueries
// operation. This will be returned by the google.longrunning.Operation.metadata
// field.
type ImportSampleQueriesMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ImportSampleQueries operation create time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// ImportSampleQueries operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Count of [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s
	// successfully imported.
	SuccessCount int64 `protobuf:"varint,3,opt,name=success_count,json=successCount,proto3" json:"success_count,omitempty"`
	// Count of [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s
	// that failed to be imported.
	FailureCount int64 `protobuf:"varint,4,opt,name=failure_count,json=failureCount,proto3" json:"failure_count,omitempty"`
	// Total count of
	// [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s that were
	// processed.
	TotalCount int64 `protobuf:"varint,5,opt,name=total_count,json=totalCount,proto3" json:"total_count,omitempty"`
}

func (x *ImportSampleQueriesMetadata) Reset() {
	*x = ImportSampleQueriesMetadata{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportSampleQueriesMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportSampleQueriesMetadata) ProtoMessage() {}

func (x *ImportSampleQueriesMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportSampleQueriesMetadata.ProtoReflect.Descriptor instead.
func (*ImportSampleQueriesMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{24}
}

func (x *ImportSampleQueriesMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ImportSampleQueriesMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ImportSampleQueriesMetadata) GetSuccessCount() int64 {
	if x != nil {
		return x.SuccessCount
	}
	return 0
}

func (x *ImportSampleQueriesMetadata) GetFailureCount() int64 {
	if x != nil {
		return x.FailureCount
	}
	return 0
}

func (x *ImportSampleQueriesMetadata) GetTotalCount() int64 {
	if x != nil {
		return x.TotalCount
	}
	return 0
}

// The column family of the Bigtable.
type BigtableOptions_BigtableColumnFamily struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The field name to use for this column family in the document. The
	// name has to match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`. If not set,
	// it is parsed from the family name with best effort. However, due to
	// different naming patterns, field name collisions could happen, where
	// parsing behavior is undefined.
	FieldName string `protobuf:"bytes,1,opt,name=field_name,json=fieldName,proto3" json:"field_name,omitempty"`
	// The encoding mode of the values when the type is not STRING.
	// Acceptable encoding values are:
	//
	// * `TEXT`: indicates values are alphanumeric text strings.
	// * `BINARY`: indicates values are encoded using `HBase Bytes.toBytes`
	// family of functions. This can be overridden for a specific column
	// by listing that column in `columns` and specifying an encoding for it.
	Encoding BigtableOptions_Encoding `protobuf:"varint,2,opt,name=encoding,proto3,enum=google.cloud.discoveryengine.v1alpha.BigtableOptions_Encoding" json:"encoding,omitempty"`
	// The type of values in this column family.
	// The values are expected to be encoded using `HBase Bytes.toBytes`
	// function when the encoding value is set to `BINARY`.
	Type BigtableOptions_Type `protobuf:"varint,3,opt,name=type,proto3,enum=google.cloud.discoveryengine.v1alpha.BigtableOptions_Type" json:"type,omitempty"`
	// The list of objects that contains column level information for each
	// column. If a column is not present in this list it will be ignored.
	Columns []*BigtableOptions_BigtableColumn `protobuf:"bytes,4,rep,name=columns,proto3" json:"columns,omitempty"`
}

func (x *BigtableOptions_BigtableColumnFamily) Reset() {
	*x = BigtableOptions_BigtableColumnFamily{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BigtableOptions_BigtableColumnFamily) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigtableOptions_BigtableColumnFamily) ProtoMessage() {}

func (x *BigtableOptions_BigtableColumnFamily) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigtableOptions_BigtableColumnFamily.ProtoReflect.Descriptor instead.
func (*BigtableOptions_BigtableColumnFamily) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{3, 0}
}

func (x *BigtableOptions_BigtableColumnFamily) GetFieldName() string {
	if x != nil {
		return x.FieldName
	}
	return ""
}

func (x *BigtableOptions_BigtableColumnFamily) GetEncoding() BigtableOptions_Encoding {
	if x != nil {
		return x.Encoding
	}
	return BigtableOptions_ENCODING_UNSPECIFIED
}

func (x *BigtableOptions_BigtableColumnFamily) GetType() BigtableOptions_Type {
	if x != nil {
		return x.Type
	}
	return BigtableOptions_TYPE_UNSPECIFIED
}

func (x *BigtableOptions_BigtableColumnFamily) GetColumns() []*BigtableOptions_BigtableColumn {
	if x != nil {
		return x.Columns
	}
	return nil
}

// The column of the Bigtable.
type BigtableOptions_BigtableColumn struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Qualifier of the column. If it cannot be decoded with utf-8,
	// use a base-64 encoded string instead.
	Qualifier []byte `protobuf:"bytes,1,opt,name=qualifier,proto3" json:"qualifier,omitempty"`
	// The field name to use for this column in the document. The name has to
	// match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`.
	// If not set, it is parsed from the qualifier bytes with best effort.
	// However, due to different naming patterns, field name collisions could
	// happen, where parsing behavior is undefined.
	FieldName string `protobuf:"bytes,2,opt,name=field_name,json=fieldName,proto3" json:"field_name,omitempty"`
	// The encoding mode of the values when the type is not `STRING`.
	// Acceptable encoding values are:
	//
	// * `TEXT`: indicates values are alphanumeric text strings.
	// * `BINARY`: indicates values are encoded using `HBase Bytes.toBytes`
	// family of functions. This can be overridden for a specific column
	// by listing that column in `columns` and specifying an encoding for it.
	Encoding BigtableOptions_Encoding `protobuf:"varint,3,opt,name=encoding,proto3,enum=google.cloud.discoveryengine.v1alpha.BigtableOptions_Encoding" json:"encoding,omitempty"`
	// The type of values in this column family.
	// The values are expected to be encoded using `HBase Bytes.toBytes`
	// function when the encoding value is set to `BINARY`.
	Type BigtableOptions_Type `protobuf:"varint,4,opt,name=type,proto3,enum=google.cloud.discoveryengine.v1alpha.BigtableOptions_Type" json:"type,omitempty"`
}

func (x *BigtableOptions_BigtableColumn) Reset() {
	*x = BigtableOptions_BigtableColumn{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BigtableOptions_BigtableColumn) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigtableOptions_BigtableColumn) ProtoMessage() {}

func (x *BigtableOptions_BigtableColumn) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigtableOptions_BigtableColumn.ProtoReflect.Descriptor instead.
func (*BigtableOptions_BigtableColumn) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{3, 1}
}

func (x *BigtableOptions_BigtableColumn) GetQualifier() []byte {
	if x != nil {
		return x.Qualifier
	}
	return nil
}

func (x *BigtableOptions_BigtableColumn) GetFieldName() string {
	if x != nil {
		return x.FieldName
	}
	return ""
}

func (x *BigtableOptions_BigtableColumn) GetEncoding() BigtableOptions_Encoding {
	if x != nil {
		return x.Encoding
	}
	return BigtableOptions_ENCODING_UNSPECIFIED
}

func (x *BigtableOptions_BigtableColumn) GetType() BigtableOptions_Type {
	if x != nil {
		return x.Type
	}
	return BigtableOptions_TYPE_UNSPECIFIED
}

// The inline source for the input config for ImportUserEvents method.
type ImportUserEventsRequest_InlineSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A list of user events to import. Recommended max of 10k items.
	UserEvents []*UserEvent `protobuf:"bytes,1,rep,name=user_events,json=userEvents,proto3" json:"user_events,omitempty"`
}

func (x *ImportUserEventsRequest_InlineSource) Reset() {
	*x = ImportUserEventsRequest_InlineSource{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportUserEventsRequest_InlineSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportUserEventsRequest_InlineSource) ProtoMessage() {}

func (x *ImportUserEventsRequest_InlineSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportUserEventsRequest_InlineSource.ProtoReflect.Descriptor instead.
func (*ImportUserEventsRequest_InlineSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{10, 0}
}

func (x *ImportUserEventsRequest_InlineSource) GetUserEvents() []*UserEvent {
	if x != nil {
		return x.UserEvents
	}
	return nil
}

// The inline source for the input config for ImportDocuments method.
type ImportDocumentsRequest_InlineSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A list of documents to update/create. Each document must have a
	// valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
	// Recommended max of 100 items.
	Documents []*Document `protobuf:"bytes,1,rep,name=documents,proto3" json:"documents,omitempty"`
}

func (x *ImportDocumentsRequest_InlineSource) Reset() {
	*x = ImportDocumentsRequest_InlineSource{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportDocumentsRequest_InlineSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDocumentsRequest_InlineSource) ProtoMessage() {}

func (x *ImportDocumentsRequest_InlineSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDocumentsRequest_InlineSource.ProtoReflect.Descriptor instead.
func (*ImportDocumentsRequest_InlineSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{14, 0}
}

func (x *ImportDocumentsRequest_InlineSource) GetDocuments() []*Document {
	if x != nil {
		return x.Documents
	}
	return nil
}

// The inline source for SuggestionDenyListEntry.
type ImportSuggestionDenyListEntriesRequest_InlineSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A list of all denylist entries to import. Max of 1000 items.
	Entries []*SuggestionDenyListEntry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *ImportSuggestionDenyListEntriesRequest_InlineSource) Reset() {
	*x = ImportSuggestionDenyListEntriesRequest_InlineSource{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportSuggestionDenyListEntriesRequest_InlineSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportSuggestionDenyListEntriesRequest_InlineSource) ProtoMessage() {}

func (x *ImportSuggestionDenyListEntriesRequest_InlineSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportSuggestionDenyListEntriesRequest_InlineSource.ProtoReflect.Descriptor instead.
func (*ImportSuggestionDenyListEntriesRequest_InlineSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{16, 0}
}

func (x *ImportSuggestionDenyListEntriesRequest_InlineSource) GetEntries() []*SuggestionDenyListEntry {
	if x != nil {
		return x.Entries
	}
	return nil
}

// The inline source for CompletionSuggestions.
type ImportCompletionSuggestionsRequest_InlineSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A list of all denylist entries to import. Max of 1000 items.
	Suggestions []*CompletionSuggestion `protobuf:"bytes,1,rep,name=suggestions,proto3" json:"suggestions,omitempty"`
}

func (x *ImportCompletionSuggestionsRequest_InlineSource) Reset() {
	*x = ImportCompletionSuggestionsRequest_InlineSource{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportCompletionSuggestionsRequest_InlineSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportCompletionSuggestionsRequest_InlineSource) ProtoMessage() {}

func (x *ImportCompletionSuggestionsRequest_InlineSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportCompletionSuggestionsRequest_InlineSource.ProtoReflect.Descriptor instead.
func (*ImportCompletionSuggestionsRequest_InlineSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{19, 0}
}

func (x *ImportCompletionSuggestionsRequest_InlineSource) GetSuggestions() []*CompletionSuggestion {
	if x != nil {
		return x.Suggestions
	}
	return nil
}

// The inline source for
// [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s.
type ImportSampleQueriesRequest_InlineSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A list of
	// [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
	// import. Max of 1000 items.
	SampleQueries []*SampleQuery `protobuf:"bytes,1,rep,name=sample_queries,json=sampleQueries,proto3" json:"sample_queries,omitempty"`
}

func (x *ImportSampleQueriesRequest_InlineSource) Reset() {
	*x = ImportSampleQueriesRequest_InlineSource{}
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportSampleQueriesRequest_InlineSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportSampleQueriesRequest_InlineSource) ProtoMessage() {}

func (x *ImportSampleQueriesRequest_InlineSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportSampleQueriesRequest_InlineSource.ProtoReflect.Descriptor instead.
func (*ImportSampleQueriesRequest_InlineSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP(), []int{22, 0}
}

func (x *ImportSampleQueriesRequest_InlineSource) GetSampleQueries() []*SampleQuery {
	if x != nil {
		return x.SampleQueries
	}
	return nil
}

var File_google_cloud_discoveryengine_v1alpha_import_config_proto protoreflect.FileDescriptor

var file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDesc = []byte{
	0x0a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x24, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x73,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x50, 0x0a, 0x09,
	0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x09, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x73, 0x12, 0x1f, 0x0a,
	0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0x85,
	0x02, 0x0a, 0x0e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x3a, 0x0a, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64,
	0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x0d,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x64,
	0x12, 0x1e, 0x0a, 0x08, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x64,
	0x12, 0x26, 0x0a, 0x0f, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x5f,
	0x64, 0x69, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x67, 0x63, 0x73, 0x53, 0x74,
	0x61, 0x67, 0x69, 0x6e, 0x67, 0x44, 0x69, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0x0b, 0x0a, 0x09, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc6, 0x01, 0x0a, 0x0d, 0x53, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x24, 0x0a,
	0x0b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x49, 0x64, 0x12, 0x1e, 0x0a, 0x08, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x49, 0x64, 0x12, 0x2a, 0x0a, 0x11, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x22,
	0x9f, 0x08, 0x0a, 0x0f, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x24, 0x0a, 0x0e, 0x6b, 0x65, 0x79, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6b, 0x65, 0x79,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x5f, 0x0a, 0x08, 0x66, 0x61, 0x6d,
	0x69, 0x6c, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x08, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x69, 0x65, 0x73, 0x1a, 0xc1, 0x02, 0x0a, 0x14, 0x42,
	0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x46, 0x61, 0x6d,
	0x69, 0x6c, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x5a, 0x0a, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x69, 0x67, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x45, 0x6e, 0x63, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x4e,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x5e,
	0x0a, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x43,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x52, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x1a, 0xfe,
	0x01, 0x0a, 0x0e, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x12, 0x21, 0x0a, 0x09, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x71, 0x75, 0x61, 0x6c, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x5a, 0x0a, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x69, 0x67,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x45, 0x6e, 0x63,
	0x6f, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12,
	0x4e, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x1a,
	0x87, 0x01, 0x0a, 0x0d, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x60, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x7a, 0x0a, 0x04, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x52, 0x49, 0x4e,
	0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x55, 0x4d, 0x42, 0x45, 0x52, 0x10, 0x02, 0x12,
	0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x54, 0x45, 0x47, 0x45, 0x52, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b,
	0x56, 0x41, 0x52, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x47, 0x45, 0x52, 0x10, 0x04, 0x12, 0x0f, 0x0a,
	0x0b, 0x42, 0x49, 0x47, 0x5f, 0x4e, 0x55, 0x4d, 0x45, 0x52, 0x49, 0x43, 0x10, 0x05, 0x12, 0x0b,
	0x0a, 0x07, 0x42, 0x4f, 0x4f, 0x4c, 0x45, 0x41, 0x4e, 0x10, 0x06, 0x12, 0x08, 0x0a, 0x04, 0x4a,
	0x53, 0x4f, 0x4e, 0x10, 0x07, 0x22, 0x3a, 0x0a, 0x08, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e,
	0x67, 0x12, 0x18, 0x0a, 0x14, 0x45, 0x4e, 0x43, 0x4f, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x54,
	0x45, 0x58, 0x54, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x42, 0x49, 0x4e, 0x41, 0x52, 0x59, 0x10,
	0x02, 0x22, 0xdc, 0x01, 0x0a, 0x0e, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x1e, 0x0a, 0x08, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x07, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x65, 0x0a, 0x10, 0x62, 0x69, 0x67,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x69, 0x67, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0xac, 0x01, 0x0a, 0x0f, 0x46, 0x68, 0x69, 0x72, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x4a, 0x0a, 0x0a, 0x66, 0x68, 0x69, 0x72, 0x5f, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25,
	0x0a, 0x23, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x63, 0x61, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x68, 0x69, 0x72,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x09, 0x66, 0x68, 0x69, 0x72, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x12, 0x26, 0x0a, 0x0f, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x5f,
	0x64, 0x69, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x67, 0x63, 0x73, 0x53, 0x74,
	0x61, 0x67, 0x69, 0x6e, 0x67, 0x44, 0x69, 0x72, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x22,
	0xdd, 0x01, 0x0a, 0x0e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49,
	0x64, 0x12, 0x24, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x49, 0x64, 0x12, 0x1e, 0x0a,
	0x08, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x26, 0x0a,
	0x0f, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x69, 0x72,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x67, 0x63, 0x73, 0x53, 0x74, 0x61, 0x67, 0x69,
	0x6e, 0x67, 0x44, 0x69, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x6f, 0x66, 0x66, 0x6c, 0x6f, 0x61, 0x64,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x6f, 0x66, 0x66, 0x6c, 0x6f, 0x61, 0x64, 0x22,
	0xe6, 0x01, 0x0a, 0x0d, 0x41, 0x6c, 0x6c, 0x6f, 0x79, 0x44, 0x62, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64,
	0x12, 0x24, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0b, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x49, 0x64,
	0x12, 0x1e, 0x0a, 0x08, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x64,
	0x12, 0x26, 0x0a, 0x0f, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x5f,
	0x64, 0x69, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x67, 0x63, 0x73, 0x53, 0x74,
	0x61, 0x67, 0x69, 0x6e, 0x67, 0x44, 0x69, 0x72, 0x22, 0xa8, 0x01, 0x0a, 0x0f, 0x46, 0x69, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0b, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x49,
	0x64, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x63,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x26, 0x0a, 0x0f, 0x67,
	0x63, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x69, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x67, 0x63, 0x73, 0x53, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67,
	0x44, 0x69, 0x72, 0x22, 0x43, 0x0a, 0x11, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1f, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f,
	0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09,
	0x67, 0x63, 0x73, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xd6, 0x04, 0x0a, 0x17, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x71, 0x0a, 0x0d, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x49, 0x6e, 0x6c, 0x69, 0x6e,
	0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0c, 0x69, 0x6e, 0x6c, 0x69, 0x6e,
	0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x50, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x09,
	0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x5f, 0x0a, 0x0f, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2a, 0x0a, 0x28, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x5a, 0x0a, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x0b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x1a, 0x65, 0x0a, 0x0c, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x55, 0x0a, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73, 0x65,
	0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x73, 0x65,
	0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x22, 0x93, 0x02, 0x0a, 0x18, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x55, 0x73, 0x65, 0x72,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37,
	0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72,
	0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12, 0x5a, 0x0a, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x2e, 0x0a, 0x13, 0x6a, 0x6f, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x11, 0x6a, 0x6f, 0x69, 0x6e, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x32, 0x0a, 0x15, 0x75, 0x6e, 0x6a, 0x6f, 0x69, 0x6e, 0x65, 0x64, 0x5f,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x13, 0x75, 0x6e, 0x6a, 0x6f, 0x69, 0x6e, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xde, 0x01, 0x0a, 0x18, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x23,
	0x0a, 0x0d, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x66, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xfe, 0x01, 0x0a, 0x17, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x23,
	0x0a, 0x0d, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x66, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xf3, 0x0b, 0x0a, 0x16, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x70, 0x0a, 0x0d, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0c, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x50, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x67,
	0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x5f, 0x0a, 0x0f, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x63, 0x0a, 0x11, 0x66, 0x68, 0x69,
	0x72, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x68, 0x69, 0x72,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0f, 0x66,
	0x68, 0x69, 0x72, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x5c,
	0x0a, 0x0e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x60, 0x0a, 0x10,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73, 0x71, 0x6c, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x62,
	0x0a, 0x10, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x46, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48,
	0x00, 0x52, 0x0f, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x5d, 0x0a, 0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x5f, 0x64, 0x62, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x79, 0x44, 0x62, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x48, 0x00, 0x52, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x44, 0x62, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x5f, 0x0a, 0x0f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x48, 0x00, 0x52, 0x0e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x72, 0x61, 0x6e, 0x63,
	0x68, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5a, 0x0a, 0x0c, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x80, 0x01, 0x0a, 0x13, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63,
	0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x6f, 0x64, 0x65, 0x52, 0x12, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x2a, 0x0a, 0x11, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0f, 0x61, 0x75, 0x74, 0x6f, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x49, 0x64,
	0x73, 0x12, 0x19, 0x0a, 0x08, 0x69, 0x64, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x69, 0x64, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x1a, 0x61, 0x0a, 0x0c,
	0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x51, 0x0a, 0x09,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x22,
	0x54, 0x0a, 0x12, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x52, 0x45, 0x43, 0x4f, 0x4e, 0x43, 0x49,
	0x4c, 0x49, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e,
	0x43, 0x52, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x46,
	0x55, 0x4c, 0x4c, 0x10, 0x02, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22,
	0xae, 0x01, 0x0a, 0x17, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x0d, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x53, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x73, 0x12, 0x5a, 0x0a, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x0b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0xbf, 0x03, 0x0a, 0x26, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x6e, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74,
	0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x80, 0x01, 0x0a, 0x0d,
	0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x59, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x6e, 0x79, 0x4c,
	0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00,
	0x52, 0x0c, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x50,
	0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x1a, 0x6c, 0x0a, 0x0c, 0x49, 0x6e,
	0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x5c, 0x0a, 0x07, 0x65, 0x6e,
	0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x6e,
	0x79, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x22, 0xca, 0x01, 0x0a, 0x27, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x6e, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x45,
	0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37,
	0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72,
	0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x69, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65,
	0x64, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x30, 0x0a,
	0x14, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x12, 0x66, 0x61, 0x69,
	0x6c, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22,
	0xa3, 0x01, 0x0a, 0x27, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x6e, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xf8, 0x04, 0x0a, 0x22, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x7c, 0x0a, 0x0d,
	0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x49, 0x6e,
	0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0c, 0x69, 0x6e,
	0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x50, 0x0a, 0x0a, 0x67, 0x63,
	0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48,
	0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x5f, 0x0a, 0x0f,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x69, 0x67,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x48, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5a, 0x0a, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x1a, 0x71, 0x0a, 0x0c, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x61, 0x0a, 0x0b, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x73, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x22, 0xba, 0x01, 0x0a, 0x23, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6c,
	0x65, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x73, 0x12, 0x5a, 0x0a, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x0b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xe9, 0x01,
	0x0a, 0x23, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x23, 0x0a, 0x0d, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x66, 0x61, 0x69,
	0x6c, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xe9, 0x04, 0x0a, 0x1a, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x74, 0x0a, 0x0d, 0x69, 0x6e, 0x6c, 0x69,
	0x6e, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00,
	0x52, 0x0c, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x50,
	0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x5f, 0x0a, 0x0f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48,
	0x00, 0x52, 0x0e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x5a, 0x0a, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x0b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x6d, 0x0a, 0x0c,
	0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x5d, 0x0a, 0x0e,
	0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x73, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x42, 0x08, 0x0a, 0x06, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xb2, 0x01, 0x0a, 0x1b, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x73,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12, 0x5a,
	0x0a, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x82, 0x02, 0x0a, 0x1b, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x69,
	0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x73, 0x75, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x66, 0x61, 0x69,
	0x6c, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0c, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1f,
	0x0a, 0x0b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x42,
	0x9d, 0x02, 0x0a, 0x28, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x42, 0x11, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x52, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x70, 0x62, 0x3b, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x70, 0x62, 0xa2, 0x02, 0x0f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52,
	0x59, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0xaa, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x56, 0x31, 0x41, 0x6c, 0x70, 0x68, 0x61, 0xca, 0x02,
	0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5c, 0x56, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0xea, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescOnce sync.Once
	file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescData = file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDesc
)

func file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescGZIP() []byte {
	file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescOnce.Do(func() {
		file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescData)
	})
	return file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDescData
}

var file_google_cloud_discoveryengine_v1alpha_import_config_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes = make([]protoimpl.MessageInfo, 33)
var file_google_cloud_discoveryengine_v1alpha_import_config_proto_goTypes = []any{
	(BigtableOptions_Type)(0),                                   // 0: google.cloud.discoveryengine.v1alpha.BigtableOptions.Type
	(BigtableOptions_Encoding)(0),                               // 1: google.cloud.discoveryengine.v1alpha.BigtableOptions.Encoding
	(ImportDocumentsRequest_ReconciliationMode)(0),              // 2: google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode
	(*GcsSource)(nil),                                           // 3: google.cloud.discoveryengine.v1alpha.GcsSource
	(*BigQuerySource)(nil),                                      // 4: google.cloud.discoveryengine.v1alpha.BigQuerySource
	(*SpannerSource)(nil),                                       // 5: google.cloud.discoveryengine.v1alpha.SpannerSource
	(*BigtableOptions)(nil),                                     // 6: google.cloud.discoveryengine.v1alpha.BigtableOptions
	(*BigtableSource)(nil),                                      // 7: google.cloud.discoveryengine.v1alpha.BigtableSource
	(*FhirStoreSource)(nil),                                     // 8: google.cloud.discoveryengine.v1alpha.FhirStoreSource
	(*CloudSqlSource)(nil),                                      // 9: google.cloud.discoveryengine.v1alpha.CloudSqlSource
	(*AlloyDbSource)(nil),                                       // 10: google.cloud.discoveryengine.v1alpha.AlloyDbSource
	(*FirestoreSource)(nil),                                     // 11: google.cloud.discoveryengine.v1alpha.FirestoreSource
	(*ImportErrorConfig)(nil),                                   // 12: google.cloud.discoveryengine.v1alpha.ImportErrorConfig
	(*ImportUserEventsRequest)(nil),                             // 13: google.cloud.discoveryengine.v1alpha.ImportUserEventsRequest
	(*ImportUserEventsResponse)(nil),                            // 14: google.cloud.discoveryengine.v1alpha.ImportUserEventsResponse
	(*ImportUserEventsMetadata)(nil),                            // 15: google.cloud.discoveryengine.v1alpha.ImportUserEventsMetadata
	(*ImportDocumentsMetadata)(nil),                             // 16: google.cloud.discoveryengine.v1alpha.ImportDocumentsMetadata
	(*ImportDocumentsRequest)(nil),                              // 17: google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest
	(*ImportDocumentsResponse)(nil),                             // 18: google.cloud.discoveryengine.v1alpha.ImportDocumentsResponse
	(*ImportSuggestionDenyListEntriesRequest)(nil),              // 19: google.cloud.discoveryengine.v1alpha.ImportSuggestionDenyListEntriesRequest
	(*ImportSuggestionDenyListEntriesResponse)(nil),             // 20: google.cloud.discoveryengine.v1alpha.ImportSuggestionDenyListEntriesResponse
	(*ImportSuggestionDenyListEntriesMetadata)(nil),             // 21: google.cloud.discoveryengine.v1alpha.ImportSuggestionDenyListEntriesMetadata
	(*ImportCompletionSuggestionsRequest)(nil),                  // 22: google.cloud.discoveryengine.v1alpha.ImportCompletionSuggestionsRequest
	(*ImportCompletionSuggestionsResponse)(nil),                 // 23: google.cloud.discoveryengine.v1alpha.ImportCompletionSuggestionsResponse
	(*ImportCompletionSuggestionsMetadata)(nil),                 // 24: google.cloud.discoveryengine.v1alpha.ImportCompletionSuggestionsMetadata
	(*ImportSampleQueriesRequest)(nil),                          // 25: google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest
	(*ImportSampleQueriesResponse)(nil),                         // 26: google.cloud.discoveryengine.v1alpha.ImportSampleQueriesResponse
	(*ImportSampleQueriesMetadata)(nil),                         // 27: google.cloud.discoveryengine.v1alpha.ImportSampleQueriesMetadata
	(*BigtableOptions_BigtableColumnFamily)(nil),                // 28: google.cloud.discoveryengine.v1alpha.BigtableOptions.BigtableColumnFamily
	(*BigtableOptions_BigtableColumn)(nil),                      // 29: google.cloud.discoveryengine.v1alpha.BigtableOptions.BigtableColumn
	nil,                                                         // 30: google.cloud.discoveryengine.v1alpha.BigtableOptions.FamiliesEntry
	(*ImportUserEventsRequest_InlineSource)(nil),                // 31: google.cloud.discoveryengine.v1alpha.ImportUserEventsRequest.InlineSource
	(*ImportDocumentsRequest_InlineSource)(nil),                 // 32: google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
	(*ImportSuggestionDenyListEntriesRequest_InlineSource)(nil), // 33: google.cloud.discoveryengine.v1alpha.ImportSuggestionDenyListEntriesRequest.InlineSource
	(*ImportCompletionSuggestionsRequest_InlineSource)(nil),     // 34: google.cloud.discoveryengine.v1alpha.ImportCompletionSuggestionsRequest.InlineSource
	(*ImportSampleQueriesRequest_InlineSource)(nil),             // 35: google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
	(*date.Date)(nil),                                           // 36: google.type.Date
	(*status.Status)(nil),                                       // 37: google.rpc.Status
	(*timestamppb.Timestamp)(nil),                               // 38: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),                               // 39: google.protobuf.FieldMask
	(*UserEvent)(nil),                                           // 40: google.cloud.discoveryengine.v1alpha.UserEvent
	(*Document)(nil),                                            // 41: google.cloud.discoveryengine.v1alpha.Document
	(*SuggestionDenyListEntry)(nil),                             // 42: google.cloud.discoveryengine.v1alpha.SuggestionDenyListEntry
	(*CompletionSuggestion)(nil),                                // 43: google.cloud.discoveryengine.v1alpha.CompletionSuggestion
	(*SampleQuery)(nil),                                         // 44: google.cloud.discoveryengine.v1alpha.SampleQuery
}
var file_google_cloud_discoveryengine_v1alpha_import_config_proto_depIdxs = []int32{
	36, // 0: google.cloud.discoveryengine.v1alpha.BigQuerySource.partition_date:type_name -> google.type.Date
	30, // 1: google.cloud.discoveryengine.v1alpha.BigtableOptions.families:type_name -> google.cloud.discoveryengine.v1alpha.BigtableOptions.FamiliesEntry
	6,  // 2: google.cloud.discoveryengine.v1alpha.BigtableSource.bigtable_options:type_name -> google.cloud.discoveryengine.v1alpha.BigtableOptions
	31, // 3: google.cloud.discoveryengine.v1alpha.ImportUserEventsRequest.inline_source:type_name -> google.cloud.discoveryengine.v1alpha.ImportUserEventsRequest.InlineSource
	3,  // 4: google.cloud.discoveryengine.v1alpha.ImportUserEventsRequest.gcs_source:type_name -> google.cloud.discoveryengine.v1alpha.GcsSource
	4,  // 5: google.cloud.discoveryengine.v1alpha.ImportUserEventsRequest.bigquery_source:type_name -> google.cloud.discoveryengine.v1alpha.BigQuerySource
	12, // 6: google.cloud.discoveryengine.v1alpha.ImportUserEventsRequest.error_config:type_name -> google.cloud.discoveryengine.v1alpha.ImportErrorConfig
	37, // 7: google.cloud.discoveryengine.v1alpha.ImportUserEventsResponse.error_samples:type_name -> google.rpc.Status
	12, // 8: google.cloud.discoveryengine.v1alpha.ImportUserEventsResponse.error_config:type_name -> google.cloud.discoveryengine.v1alpha.ImportErrorConfig
	38, // 9: google.cloud.discoveryengine.v1alpha.ImportUserEventsMetadata.create_time:type_name -> google.protobuf.Timestamp
	38, // 10: google.cloud.discoveryengine.v1alpha.ImportUserEventsMetadata.update_time:type_name -> google.protobuf.Timestamp
	38, // 11: google.cloud.discoveryengine.v1alpha.ImportDocumentsMetadata.create_time:type_name -> google.protobuf.Timestamp
	38, // 12: google.cloud.discoveryengine.v1alpha.ImportDocumentsMetadata.update_time:type_name -> google.protobuf.Timestamp
	32, // 13: google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.inline_source:type_name -> google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
	3,  // 14: google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.gcs_source:type_name -> google.cloud.discoveryengine.v1alpha.GcsSource
	4,  // 15: google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.bigquery_source:type_name -> google.cloud.discoveryengine.v1alpha.BigQuerySource
	8,  // 16: google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.fhir_store_source:type_name -> google.cloud.discoveryengine.v1alpha.FhirStoreSource
	5,  // 17: google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.spanner_source:type_name -> google.cloud.discoveryengine.v1alpha.SpannerSource
	9,  // 18: google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.cloud_sql_source:type_name -> google.cloud.discoveryengine.v1alpha.CloudSqlSource
	11, // 19: google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.firestore_source:type_name -> google.cloud.discoveryengine.v1alpha.FirestoreSource
	10, // 20: google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.alloy_db_source:type_name -> google.cloud.discoveryengine.v1alpha.AlloyDbSource
	7,  // 21: google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.bigtable_source:type_name -> google.cloud.discoveryengine.v1alpha.BigtableSource
	12, // 22: google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.error_config:type_name -> google.cloud.discoveryengine.v1alpha.ImportErrorConfig
	2,  // 23: google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.reconciliation_mode:type_name -> google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode
	39, // 24: google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.update_mask:type_name -> google.protobuf.FieldMask
	37, // 25: google.cloud.discoveryengine.v1alpha.ImportDocumentsResponse.error_samples:type_name -> google.rpc.Status
	12, // 26: google.cloud.discoveryengine.v1alpha.ImportDocumentsResponse.error_config:type_name -> google.cloud.discoveryengine.v1alpha.ImportErrorConfig
	33, // 27: google.cloud.discoveryengine.v1alpha.ImportSuggestionDenyListEntriesRequest.inline_source:type_name -> google.cloud.discoveryengine.v1alpha.ImportSuggestionDenyListEntriesRequest.InlineSource
	3,  // 28: google.cloud.discoveryengine.v1alpha.ImportSuggestionDenyListEntriesRequest.gcs_source:type_name -> google.cloud.discoveryengine.v1alpha.GcsSource
	37, // 29: google.cloud.discoveryengine.v1alpha.ImportSuggestionDenyListEntriesResponse.error_samples:type_name -> google.rpc.Status
	38, // 30: google.cloud.discoveryengine.v1alpha.ImportSuggestionDenyListEntriesMetadata.create_time:type_name -> google.protobuf.Timestamp
	38, // 31: google.cloud.discoveryengine.v1alpha.ImportSuggestionDenyListEntriesMetadata.update_time:type_name -> google.protobuf.Timestamp
	34, // 32: google.cloud.discoveryengine.v1alpha.ImportCompletionSuggestionsRequest.inline_source:type_name -> google.cloud.discoveryengine.v1alpha.ImportCompletionSuggestionsRequest.InlineSource
	3,  // 33: google.cloud.discoveryengine.v1alpha.ImportCompletionSuggestionsRequest.gcs_source:type_name -> google.cloud.discoveryengine.v1alpha.GcsSource
	4,  // 34: google.cloud.discoveryengine.v1alpha.ImportCompletionSuggestionsRequest.bigquery_source:type_name -> google.cloud.discoveryengine.v1alpha.BigQuerySource
	12, // 35: google.cloud.discoveryengine.v1alpha.ImportCompletionSuggestionsRequest.error_config:type_name -> google.cloud.discoveryengine.v1alpha.ImportErrorConfig
	37, // 36: google.cloud.discoveryengine.v1alpha.ImportCompletionSuggestionsResponse.error_samples:type_name -> google.rpc.Status
	12, // 37: google.cloud.discoveryengine.v1alpha.ImportCompletionSuggestionsResponse.error_config:type_name -> google.cloud.discoveryengine.v1alpha.ImportErrorConfig
	38, // 38: google.cloud.discoveryengine.v1alpha.ImportCompletionSuggestionsMetadata.create_time:type_name -> google.protobuf.Timestamp
	38, // 39: google.cloud.discoveryengine.v1alpha.ImportCompletionSuggestionsMetadata.update_time:type_name -> google.protobuf.Timestamp
	35, // 40: google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.inline_source:type_name -> google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
	3,  // 41: google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.gcs_source:type_name -> google.cloud.discoveryengine.v1alpha.GcsSource
	4,  // 42: google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.bigquery_source:type_name -> google.cloud.discoveryengine.v1alpha.BigQuerySource
	12, // 43: google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.error_config:type_name -> google.cloud.discoveryengine.v1alpha.ImportErrorConfig
	37, // 44: google.cloud.discoveryengine.v1alpha.ImportSampleQueriesResponse.error_samples:type_name -> google.rpc.Status
	12, // 45: google.cloud.discoveryengine.v1alpha.ImportSampleQueriesResponse.error_config:type_name -> google.cloud.discoveryengine.v1alpha.ImportErrorConfig
	38, // 46: google.cloud.discoveryengine.v1alpha.ImportSampleQueriesMetadata.create_time:type_name -> google.protobuf.Timestamp
	38, // 47: google.cloud.discoveryengine.v1alpha.ImportSampleQueriesMetadata.update_time:type_name -> google.protobuf.Timestamp
	1,  // 48: google.cloud.discoveryengine.v1alpha.BigtableOptions.BigtableColumnFamily.encoding:type_name -> google.cloud.discoveryengine.v1alpha.BigtableOptions.Encoding
	0,  // 49: google.cloud.discoveryengine.v1alpha.BigtableOptions.BigtableColumnFamily.type:type_name -> google.cloud.discoveryengine.v1alpha.BigtableOptions.Type
	29, // 50: google.cloud.discoveryengine.v1alpha.BigtableOptions.BigtableColumnFamily.columns:type_name -> google.cloud.discoveryengine.v1alpha.BigtableOptions.BigtableColumn
	1,  // 51: google.cloud.discoveryengine.v1alpha.BigtableOptions.BigtableColumn.encoding:type_name -> google.cloud.discoveryengine.v1alpha.BigtableOptions.Encoding
	0,  // 52: google.cloud.discoveryengine.v1alpha.BigtableOptions.BigtableColumn.type:type_name -> google.cloud.discoveryengine.v1alpha.BigtableOptions.Type
	28, // 53: google.cloud.discoveryengine.v1alpha.BigtableOptions.FamiliesEntry.value:type_name -> google.cloud.discoveryengine.v1alpha.BigtableOptions.BigtableColumnFamily
	40, // 54: google.cloud.discoveryengine.v1alpha.ImportUserEventsRequest.InlineSource.user_events:type_name -> google.cloud.discoveryengine.v1alpha.UserEvent
	41, // 55: google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource.documents:type_name -> google.cloud.discoveryengine.v1alpha.Document
	42, // 56: google.cloud.discoveryengine.v1alpha.ImportSuggestionDenyListEntriesRequest.InlineSource.entries:type_name -> google.cloud.discoveryengine.v1alpha.SuggestionDenyListEntry
	43, // 57: google.cloud.discoveryengine.v1alpha.ImportCompletionSuggestionsRequest.InlineSource.suggestions:type_name -> google.cloud.discoveryengine.v1alpha.CompletionSuggestion
	44, // 58: google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource.sample_queries:type_name -> google.cloud.discoveryengine.v1alpha.SampleQuery
	59, // [59:59] is the sub-list for method output_type
	59, // [59:59] is the sub-list for method input_type
	59, // [59:59] is the sub-list for extension type_name
	59, // [59:59] is the sub-list for extension extendee
	0,  // [0:59] is the sub-list for field type_name
}

func init() { file_google_cloud_discoveryengine_v1alpha_import_config_proto_init() }
func file_google_cloud_discoveryengine_v1alpha_import_config_proto_init() {
	if File_google_cloud_discoveryengine_v1alpha_import_config_proto != nil {
		return
	}
	file_google_cloud_discoveryengine_v1alpha_completion_proto_init()
	file_google_cloud_discoveryengine_v1alpha_document_proto_init()
	file_google_cloud_discoveryengine_v1alpha_sample_query_proto_init()
	file_google_cloud_discoveryengine_v1alpha_user_event_proto_init()
	file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[1].OneofWrappers = []any{
		(*BigQuerySource_PartitionDate)(nil),
	}
	file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[9].OneofWrappers = []any{
		(*ImportErrorConfig_GcsPrefix)(nil),
	}
	file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[10].OneofWrappers = []any{
		(*ImportUserEventsRequest_InlineSource_)(nil),
		(*ImportUserEventsRequest_GcsSource)(nil),
		(*ImportUserEventsRequest_BigquerySource)(nil),
	}
	file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[14].OneofWrappers = []any{
		(*ImportDocumentsRequest_InlineSource_)(nil),
		(*ImportDocumentsRequest_GcsSource)(nil),
		(*ImportDocumentsRequest_BigquerySource)(nil),
		(*ImportDocumentsRequest_FhirStoreSource)(nil),
		(*ImportDocumentsRequest_SpannerSource)(nil),
		(*ImportDocumentsRequest_CloudSqlSource)(nil),
		(*ImportDocumentsRequest_FirestoreSource)(nil),
		(*ImportDocumentsRequest_AlloyDbSource)(nil),
		(*ImportDocumentsRequest_BigtableSource)(nil),
	}
	file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[16].OneofWrappers = []any{
		(*ImportSuggestionDenyListEntriesRequest_InlineSource_)(nil),
		(*ImportSuggestionDenyListEntriesRequest_GcsSource)(nil),
	}
	file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[19].OneofWrappers = []any{
		(*ImportCompletionSuggestionsRequest_InlineSource_)(nil),
		(*ImportCompletionSuggestionsRequest_GcsSource)(nil),
		(*ImportCompletionSuggestionsRequest_BigquerySource)(nil),
	}
	file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes[22].OneofWrappers = []any{
		(*ImportSampleQueriesRequest_InlineSource_)(nil),
		(*ImportSampleQueriesRequest_GcsSource)(nil),
		(*ImportSampleQueriesRequest_BigquerySource)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   33,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_discoveryengine_v1alpha_import_config_proto_goTypes,
		DependencyIndexes: file_google_cloud_discoveryengine_v1alpha_import_config_proto_depIdxs,
		EnumInfos:         file_google_cloud_discoveryengine_v1alpha_import_config_proto_enumTypes,
		MessageInfos:      file_google_cloud_discoveryengine_v1alpha_import_config_proto_msgTypes,
	}.Build()
	File_google_cloud_discoveryengine_v1alpha_import_config_proto = out.File
	file_google_cloud_discoveryengine_v1alpha_import_config_proto_rawDesc = nil
	file_google_cloud_discoveryengine_v1alpha_import_config_proto_goTypes = nil
	file_google_cloud_discoveryengine_v1alpha_import_config_proto_depIdxs = nil
}
