// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/api/apikeys/v2/apikeys.proto

package apikeyspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for `CreateKey` method.
type CreateKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project in which the API key is created.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The API key fields to set at creation time.
	// You can configure only the `display_name`, `restrictions`, and
	// `annotations` fields.
	Key *Key `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	// User specified key id (optional). If specified, it will become the final
	// component of the key resource name.
	//
	// The id must be unique within the project, must conform with RFC-1034,
	// is restricted to lower-cased letters, and has a maximum length of 63
	// characters. In another word, the id must match the regular
	// expression: `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
	//
	// The id must NOT be a UUID-like string.
	KeyId string `protobuf:"bytes,3,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
}

func (x *CreateKeyRequest) Reset() {
	*x = CreateKeyRequest{}
	mi := &file_google_api_apikeys_v2_apikeys_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateKeyRequest) ProtoMessage() {}

func (x *CreateKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_apikeys_v2_apikeys_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateKeyRequest.ProtoReflect.Descriptor instead.
func (*CreateKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_api_apikeys_v2_apikeys_proto_rawDescGZIP(), []int{0}
}

func (x *CreateKeyRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateKeyRequest) GetKey() *Key {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *CreateKeyRequest) GetKeyId() string {
	if x != nil {
		return x.KeyId
	}
	return ""
}

// Request message for `ListKeys` method.
type ListKeysRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Lists all API keys associated with this project.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Specifies the maximum number of results to be returned at a time.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Requests a specific page of results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Indicate that keys deleted in the past 30 days should also be
	// returned.
	ShowDeleted bool `protobuf:"varint,6,opt,name=show_deleted,json=showDeleted,proto3" json:"show_deleted,omitempty"`
}

func (x *ListKeysRequest) Reset() {
	*x = ListKeysRequest{}
	mi := &file_google_api_apikeys_v2_apikeys_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListKeysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListKeysRequest) ProtoMessage() {}

func (x *ListKeysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_apikeys_v2_apikeys_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListKeysRequest.ProtoReflect.Descriptor instead.
func (*ListKeysRequest) Descriptor() ([]byte, []int) {
	return file_google_api_apikeys_v2_apikeys_proto_rawDescGZIP(), []int{1}
}

func (x *ListKeysRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListKeysRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListKeysRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListKeysRequest) GetShowDeleted() bool {
	if x != nil {
		return x.ShowDeleted
	}
	return false
}

// Response message for `ListKeys` method.
type ListKeysResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of API keys.
	Keys []*Key `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	// The pagination token for the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListKeysResponse) Reset() {
	*x = ListKeysResponse{}
	mi := &file_google_api_apikeys_v2_apikeys_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListKeysResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListKeysResponse) ProtoMessage() {}

func (x *ListKeysResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_apikeys_v2_apikeys_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListKeysResponse.ProtoReflect.Descriptor instead.
func (*ListKeysResponse) Descriptor() ([]byte, []int) {
	return file_google_api_apikeys_v2_apikeys_proto_rawDescGZIP(), []int{2}
}

func (x *ListKeysResponse) GetKeys() []*Key {
	if x != nil {
		return x.Keys
	}
	return nil
}

func (x *ListKeysResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for `GetKey` method.
type GetKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the API key to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetKeyRequest) Reset() {
	*x = GetKeyRequest{}
	mi := &file_google_api_apikeys_v2_apikeys_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetKeyRequest) ProtoMessage() {}

func (x *GetKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_apikeys_v2_apikeys_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetKeyRequest.ProtoReflect.Descriptor instead.
func (*GetKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_api_apikeys_v2_apikeys_proto_rawDescGZIP(), []int{3}
}

func (x *GetKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for `GetKeyString` method.
type GetKeyStringRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the API key to be retrieved.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetKeyStringRequest) Reset() {
	*x = GetKeyStringRequest{}
	mi := &file_google_api_apikeys_v2_apikeys_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetKeyStringRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetKeyStringRequest) ProtoMessage() {}

func (x *GetKeyStringRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_apikeys_v2_apikeys_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetKeyStringRequest.ProtoReflect.Descriptor instead.
func (*GetKeyStringRequest) Descriptor() ([]byte, []int) {
	return file_google_api_apikeys_v2_apikeys_proto_rawDescGZIP(), []int{4}
}

func (x *GetKeyStringRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for `GetKeyString` method.
type GetKeyStringResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An encrypted and signed value of the key.
	KeyString string `protobuf:"bytes,1,opt,name=key_string,json=keyString,proto3" json:"key_string,omitempty"`
}

func (x *GetKeyStringResponse) Reset() {
	*x = GetKeyStringResponse{}
	mi := &file_google_api_apikeys_v2_apikeys_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetKeyStringResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetKeyStringResponse) ProtoMessage() {}

func (x *GetKeyStringResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_apikeys_v2_apikeys_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetKeyStringResponse.ProtoReflect.Descriptor instead.
func (*GetKeyStringResponse) Descriptor() ([]byte, []int) {
	return file_google_api_apikeys_v2_apikeys_proto_rawDescGZIP(), []int{5}
}

func (x *GetKeyStringResponse) GetKeyString() string {
	if x != nil {
		return x.KeyString
	}
	return ""
}

// Request message for `UpdateKey` method.
type UpdateKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Set the `name` field to the resource name of the API key to be
	// updated. You can update only the `display_name`, `restrictions`, and
	// `annotations` fields.
	Key *Key `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The field mask specifies which fields to be updated as part of this
	// request. All other fields are ignored.
	// Mutable fields are: `display_name`, `restrictions`, and `annotations`.
	// If an update mask is not provided, the service treats it as an implied mask
	// equivalent to all allowed fields that are set on the wire. If the field
	// mask has a special value "*", the service treats it equivalent to replace
	// all allowed mutable fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateKeyRequest) Reset() {
	*x = UpdateKeyRequest{}
	mi := &file_google_api_apikeys_v2_apikeys_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateKeyRequest) ProtoMessage() {}

func (x *UpdateKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_apikeys_v2_apikeys_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateKeyRequest.ProtoReflect.Descriptor instead.
func (*UpdateKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_api_apikeys_v2_apikeys_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateKeyRequest) GetKey() *Key {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *UpdateKeyRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for `DeleteKey` method.
type DeleteKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the API key to be deleted.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The etag known to the client for the expected state of the key.
	// This is to be used for optimistic concurrency.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteKeyRequest) Reset() {
	*x = DeleteKeyRequest{}
	mi := &file_google_api_apikeys_v2_apikeys_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteKeyRequest) ProtoMessage() {}

func (x *DeleteKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_apikeys_v2_apikeys_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteKeyRequest.ProtoReflect.Descriptor instead.
func (*DeleteKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_api_apikeys_v2_apikeys_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteKeyRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Request message for `UndeleteKey` method.
type UndeleteKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the API key to be undeleted.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *UndeleteKeyRequest) Reset() {
	*x = UndeleteKeyRequest{}
	mi := &file_google_api_apikeys_v2_apikeys_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UndeleteKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeleteKeyRequest) ProtoMessage() {}

func (x *UndeleteKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_apikeys_v2_apikeys_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeleteKeyRequest.ProtoReflect.Descriptor instead.
func (*UndeleteKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_api_apikeys_v2_apikeys_proto_rawDescGZIP(), []int{8}
}

func (x *UndeleteKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for `LookupKey` method.
type LookupKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Finds the project that owns the key string value.
	KeyString string `protobuf:"bytes,1,opt,name=key_string,json=keyString,proto3" json:"key_string,omitempty"`
}

func (x *LookupKeyRequest) Reset() {
	*x = LookupKeyRequest{}
	mi := &file_google_api_apikeys_v2_apikeys_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LookupKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LookupKeyRequest) ProtoMessage() {}

func (x *LookupKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_apikeys_v2_apikeys_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LookupKeyRequest.ProtoReflect.Descriptor instead.
func (*LookupKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_api_apikeys_v2_apikeys_proto_rawDescGZIP(), []int{9}
}

func (x *LookupKeyRequest) GetKeyString() string {
	if x != nil {
		return x.KeyString
	}
	return ""
}

// Response message for `LookupKey` method.
type LookupKeyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The project that owns the key with the value specified in the request.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The resource name of the API key. If the API key has been purged,
	// resource name is empty.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *LookupKeyResponse) Reset() {
	*x = LookupKeyResponse{}
	mi := &file_google_api_apikeys_v2_apikeys_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LookupKeyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LookupKeyResponse) ProtoMessage() {}

func (x *LookupKeyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_apikeys_v2_apikeys_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LookupKeyResponse.ProtoReflect.Descriptor instead.
func (*LookupKeyResponse) Descriptor() ([]byte, []int) {
	return file_google_api_apikeys_v2_apikeys_proto_rawDescGZIP(), []int{10}
}

func (x *LookupKeyResponse) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *LookupKeyResponse) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_api_apikeys_v2_apikeys_proto protoreflect.FileDescriptor

var file_google_api_apikeys_v2_apikeys_proto_rawDesc = []byte{
	0x0a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x70, 0x69,
	0x6b, 0x65, 0x79, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x61, 0x70, 0x69, 0x6b, 0x65, 0x79, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x61, 0x70, 0x69, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x32, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x25, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x70, 0x69, 0x6b, 0x65, 0x79, 0x73, 0x2f, 0x76,
	0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x98, 0x01, 0x0a, 0x10, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x22, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1c, 0x12, 0x1a, 0x61, 0x70, 0x69, 0x6b, 0x65, 0x79, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4b, 0x65, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x31, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x61, 0x70, 0x69, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x4b, 0x65, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x15,
	0x0a, 0x06, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x6b, 0x65, 0x79, 0x49, 0x64, 0x22, 0xbb, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x4b, 0x65,
	0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x1c, 0x12, 0x1a, 0x61, 0x70, 0x69, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4b, 0x65, 0x79, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x26, 0x0a, 0x0c, 0x73,
	0x68, 0x6f, 0x77, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x73, 0x68, 0x6f, 0x77, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x64, 0x22, 0x6a, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x4b, 0x65, 0x79, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2e, 0x0a, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x61, 0x70, 0x69, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x4b, 0x65,
	0x79, 0x52, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x47, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x36, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1c, 0x0a, 0x1a, 0x61, 0x70, 0x69, 0x6b, 0x65, 0x79, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4b,
	0x65, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x4d, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x4b,
	0x65, 0x79, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x36, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x1c, 0x0a, 0x1a, 0x61, 0x70, 0x69, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4b, 0x65,
	0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x35, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x4b, 0x65,
	0x79, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x6b, 0x65, 0x79, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x22, 0x82,
	0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x31, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x61, 0x70,
	0x69, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x4b, 0x65, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x22, 0x63, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4b, 0x65, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x36, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1c, 0x0a, 0x1a, 0x61,
	0x70, 0x69, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4b, 0x65, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x4c, 0x0a, 0x12, 0x55, 0x6e, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x36,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x1c, 0x0a, 0x1a, 0x61, 0x70, 0x69, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4b, 0x65, 0x79,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x36, 0x0a, 0x10, 0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70,
	0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x6b, 0x65,
	0x79, 0x5f, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x6b, 0x65, 0x79, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x22, 0x3f,
	0x0a, 0x11, 0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32,
	0xbe, 0x0b, 0x0a, 0x07, 0x41, 0x70, 0x69, 0x4b, 0x65, 0x79, 0x73, 0x12, 0xbd, 0x01, 0x0a, 0x09,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x61, 0x70, 0x69, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x68, 0xca, 0x41, 0x1c, 0x0a, 0x03, 0x4b, 0x65, 0x79, 0x12, 0x15, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0xda, 0x41, 0x11, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6b, 0x65, 0x79, 0x2c,
	0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x3a, 0x03, 0x6b, 0x65,
	0x79, 0x22, 0x28, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6b, 0x65, 0x79, 0x73, 0x12, 0x96, 0x01, 0x0a, 0x08,
	0x4c, 0x69, 0x73, 0x74, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x61, 0x70, 0x69, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x61, 0x70,
	0x69, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4b, 0x65, 0x79,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x39, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x12, 0x28, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x6b, 0x65, 0x79, 0x73, 0x12, 0x83, 0x01, 0x0a, 0x06, 0x47, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x12,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x61, 0x70, 0x69,
	0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x61, 0x70, 0x69, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x4b, 0x65,
	0x79, 0x22, 0x37, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a,
	0x12, 0x28, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6b, 0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xaa, 0x01, 0x0a, 0x0c, 0x47,
	0x65, 0x74, 0x4b, 0x65, 0x79, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x61, 0x70, 0x69, 0x6b, 0x65, 0x79, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x61, 0x70, 0x69, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x47, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6b, 0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6b, 0x65,
	0x79, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x12, 0xbf, 0x01, 0x0a, 0x09, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x61, 0x70, 0x69, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6a, 0xca,
	0x41, 0x1c, 0x0a, 0x03, 0x4b, 0x65, 0x79, 0x12, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0xda, 0x41,
	0x0f, 0x6b, 0x65, 0x79, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x3a, 0x03, 0x6b, 0x65, 0x79, 0x32, 0x2c, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x6b, 0x65, 0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x6b, 0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xab, 0x01, 0x0a, 0x09, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x61, 0x70, 0x69, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x56, 0xca, 0x41, 0x1c, 0x0a, 0x03, 0x4b, 0x65, 0x79, 0x12, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x2a, 0x28, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6b, 0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb4, 0x01, 0x0a, 0x0b, 0x55, 0x6e, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x61, 0x70, 0x69, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x5b, 0xca, 0x41, 0x1c, 0x0a, 0x03, 0x4b, 0x65, 0x79, 0x12, 0x15, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x3a, 0x01, 0x2a, 0x22, 0x31, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6b, 0x65,
	0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x75, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x7a,
	0x0a, 0x09, 0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x4b, 0x65, 0x79, 0x12, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x61, 0x70, 0x69, 0x6b, 0x65, 0x79, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x61, 0x70, 0x69, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x6f, 0x6f,
	0x6b, 0x75, 0x70, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x1a,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x14, 0x12, 0x12, 0x2f, 0x76, 0x32, 0x2f, 0x6b, 0x65, 0x79, 0x73,
	0x3a, 0x6c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x4b, 0x65, 0x79, 0x1a, 0x83, 0x01, 0xca, 0x41, 0x16,
	0x61, 0x70, 0x69, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x67, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x2d, 0x6f, 0x6e, 0x6c, 0x79,
	0x42, 0xb3, 0x01, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x61, 0x70, 0x69, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x32, 0x42, 0x0c,
	0x41, 0x70, 0x69, 0x4b, 0x65, 0x79, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x35,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x70, 0x69, 0x6b, 0x65, 0x79, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x32, 0x2f, 0x61, 0x70, 0x69, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x62, 0x3b, 0x61, 0x70, 0x69, 0x6b,
	0x65, 0x79, 0x73, 0x70, 0x62, 0xaa, 0x02, 0x17, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x70, 0x69, 0x4b, 0x65, 0x79, 0x73, 0x2e, 0x56, 0x32, 0xca,
	0x02, 0x17, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41,
	0x70, 0x69, 0x4b, 0x65, 0x79, 0x73, 0x5c, 0x56, 0x32, 0xea, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x70, 0x69, 0x4b, 0x65,
	0x79, 0x73, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_api_apikeys_v2_apikeys_proto_rawDescOnce sync.Once
	file_google_api_apikeys_v2_apikeys_proto_rawDescData = file_google_api_apikeys_v2_apikeys_proto_rawDesc
)

func file_google_api_apikeys_v2_apikeys_proto_rawDescGZIP() []byte {
	file_google_api_apikeys_v2_apikeys_proto_rawDescOnce.Do(func() {
		file_google_api_apikeys_v2_apikeys_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_api_apikeys_v2_apikeys_proto_rawDescData)
	})
	return file_google_api_apikeys_v2_apikeys_proto_rawDescData
}

var file_google_api_apikeys_v2_apikeys_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_api_apikeys_v2_apikeys_proto_goTypes = []any{
	(*CreateKeyRequest)(nil),        // 0: google.api.apikeys.v2.CreateKeyRequest
	(*ListKeysRequest)(nil),         // 1: google.api.apikeys.v2.ListKeysRequest
	(*ListKeysResponse)(nil),        // 2: google.api.apikeys.v2.ListKeysResponse
	(*GetKeyRequest)(nil),           // 3: google.api.apikeys.v2.GetKeyRequest
	(*GetKeyStringRequest)(nil),     // 4: google.api.apikeys.v2.GetKeyStringRequest
	(*GetKeyStringResponse)(nil),    // 5: google.api.apikeys.v2.GetKeyStringResponse
	(*UpdateKeyRequest)(nil),        // 6: google.api.apikeys.v2.UpdateKeyRequest
	(*DeleteKeyRequest)(nil),        // 7: google.api.apikeys.v2.DeleteKeyRequest
	(*UndeleteKeyRequest)(nil),      // 8: google.api.apikeys.v2.UndeleteKeyRequest
	(*LookupKeyRequest)(nil),        // 9: google.api.apikeys.v2.LookupKeyRequest
	(*LookupKeyResponse)(nil),       // 10: google.api.apikeys.v2.LookupKeyResponse
	(*Key)(nil),                     // 11: google.api.apikeys.v2.Key
	(*fieldmaskpb.FieldMask)(nil),   // 12: google.protobuf.FieldMask
	(*longrunningpb.Operation)(nil), // 13: google.longrunning.Operation
}
var file_google_api_apikeys_v2_apikeys_proto_depIdxs = []int32{
	11, // 0: google.api.apikeys.v2.CreateKeyRequest.key:type_name -> google.api.apikeys.v2.Key
	11, // 1: google.api.apikeys.v2.ListKeysResponse.keys:type_name -> google.api.apikeys.v2.Key
	11, // 2: google.api.apikeys.v2.UpdateKeyRequest.key:type_name -> google.api.apikeys.v2.Key
	12, // 3: google.api.apikeys.v2.UpdateKeyRequest.update_mask:type_name -> google.protobuf.FieldMask
	0,  // 4: google.api.apikeys.v2.ApiKeys.CreateKey:input_type -> google.api.apikeys.v2.CreateKeyRequest
	1,  // 5: google.api.apikeys.v2.ApiKeys.ListKeys:input_type -> google.api.apikeys.v2.ListKeysRequest
	3,  // 6: google.api.apikeys.v2.ApiKeys.GetKey:input_type -> google.api.apikeys.v2.GetKeyRequest
	4,  // 7: google.api.apikeys.v2.ApiKeys.GetKeyString:input_type -> google.api.apikeys.v2.GetKeyStringRequest
	6,  // 8: google.api.apikeys.v2.ApiKeys.UpdateKey:input_type -> google.api.apikeys.v2.UpdateKeyRequest
	7,  // 9: google.api.apikeys.v2.ApiKeys.DeleteKey:input_type -> google.api.apikeys.v2.DeleteKeyRequest
	8,  // 10: google.api.apikeys.v2.ApiKeys.UndeleteKey:input_type -> google.api.apikeys.v2.UndeleteKeyRequest
	9,  // 11: google.api.apikeys.v2.ApiKeys.LookupKey:input_type -> google.api.apikeys.v2.LookupKeyRequest
	13, // 12: google.api.apikeys.v2.ApiKeys.CreateKey:output_type -> google.longrunning.Operation
	2,  // 13: google.api.apikeys.v2.ApiKeys.ListKeys:output_type -> google.api.apikeys.v2.ListKeysResponse
	11, // 14: google.api.apikeys.v2.ApiKeys.GetKey:output_type -> google.api.apikeys.v2.Key
	5,  // 15: google.api.apikeys.v2.ApiKeys.GetKeyString:output_type -> google.api.apikeys.v2.GetKeyStringResponse
	13, // 16: google.api.apikeys.v2.ApiKeys.UpdateKey:output_type -> google.longrunning.Operation
	13, // 17: google.api.apikeys.v2.ApiKeys.DeleteKey:output_type -> google.longrunning.Operation
	13, // 18: google.api.apikeys.v2.ApiKeys.UndeleteKey:output_type -> google.longrunning.Operation
	10, // 19: google.api.apikeys.v2.ApiKeys.LookupKey:output_type -> google.api.apikeys.v2.LookupKeyResponse
	12, // [12:20] is the sub-list for method output_type
	4,  // [4:12] is the sub-list for method input_type
	4,  // [4:4] is the sub-list for extension type_name
	4,  // [4:4] is the sub-list for extension extendee
	0,  // [0:4] is the sub-list for field type_name
}

func init() { file_google_api_apikeys_v2_apikeys_proto_init() }
func file_google_api_apikeys_v2_apikeys_proto_init() {
	if File_google_api_apikeys_v2_apikeys_proto != nil {
		return
	}
	file_google_api_apikeys_v2_resources_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_api_apikeys_v2_apikeys_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_api_apikeys_v2_apikeys_proto_goTypes,
		DependencyIndexes: file_google_api_apikeys_v2_apikeys_proto_depIdxs,
		MessageInfos:      file_google_api_apikeys_v2_apikeys_proto_msgTypes,
	}.Build()
	File_google_api_apikeys_v2_apikeys_proto = out.File
	file_google_api_apikeys_v2_apikeys_proto_rawDesc = nil
	file_google_api_apikeys_v2_apikeys_proto_goTypes = nil
	file_google_api_apikeys_v2_apikeys_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ApiKeysClient is the client API for ApiKeys service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ApiKeysClient interface {
	// Creates a new API key.
	//
	// NOTE: Key is a global resource; hence the only supported value for
	// location is `global`.
	CreateKey(ctx context.Context, in *CreateKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the API keys owned by a project. The key string of the API key
	// isn't included in the response.
	//
	// NOTE: Key is a global resource; hence the only supported value for
	// location is `global`.
	ListKeys(ctx context.Context, in *ListKeysRequest, opts ...grpc.CallOption) (*ListKeysResponse, error)
	// Gets the metadata for an API key. The key string of the API key
	// isn't included in the response.
	//
	// NOTE: Key is a global resource; hence the only supported value for
	// location is `global`.
	GetKey(ctx context.Context, in *GetKeyRequest, opts ...grpc.CallOption) (*Key, error)
	// Get the key string for an API key.
	//
	// NOTE: Key is a global resource; hence the only supported value for
	// location is `global`.
	GetKeyString(ctx context.Context, in *GetKeyStringRequest, opts ...grpc.CallOption) (*GetKeyStringResponse, error)
	// Patches the modifiable fields of an API key.
	// The key string of the API key isn't included in the response.
	//
	// NOTE: Key is a global resource; hence the only supported value for
	// location is `global`.
	UpdateKey(ctx context.Context, in *UpdateKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an API key. Deleted key can be retrieved within 30 days of
	// deletion. Afterward, key will be purged from the project.
	//
	// NOTE: Key is a global resource; hence the only supported value for
	// location is `global`.
	DeleteKey(ctx context.Context, in *DeleteKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Undeletes an API key which was deleted within 30 days.
	//
	// NOTE: Key is a global resource; hence the only supported value for
	// location is `global`.
	UndeleteKey(ctx context.Context, in *UndeleteKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Find the parent project and resource name of the API
	// key that matches the key string in the request. If the API key has been
	// purged, resource name will not be set.
	// The service account must have the `apikeys.keys.lookup` permission
	// on the parent project.
	LookupKey(ctx context.Context, in *LookupKeyRequest, opts ...grpc.CallOption) (*LookupKeyResponse, error)
}

type apiKeysClient struct {
	cc grpc.ClientConnInterface
}

func NewApiKeysClient(cc grpc.ClientConnInterface) ApiKeysClient {
	return &apiKeysClient{cc}
}

func (c *apiKeysClient) CreateKey(ctx context.Context, in *CreateKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.api.apikeys.v2.ApiKeys/CreateKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiKeysClient) ListKeys(ctx context.Context, in *ListKeysRequest, opts ...grpc.CallOption) (*ListKeysResponse, error) {
	out := new(ListKeysResponse)
	err := c.cc.Invoke(ctx, "/google.api.apikeys.v2.ApiKeys/ListKeys", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiKeysClient) GetKey(ctx context.Context, in *GetKeyRequest, opts ...grpc.CallOption) (*Key, error) {
	out := new(Key)
	err := c.cc.Invoke(ctx, "/google.api.apikeys.v2.ApiKeys/GetKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiKeysClient) GetKeyString(ctx context.Context, in *GetKeyStringRequest, opts ...grpc.CallOption) (*GetKeyStringResponse, error) {
	out := new(GetKeyStringResponse)
	err := c.cc.Invoke(ctx, "/google.api.apikeys.v2.ApiKeys/GetKeyString", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiKeysClient) UpdateKey(ctx context.Context, in *UpdateKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.api.apikeys.v2.ApiKeys/UpdateKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiKeysClient) DeleteKey(ctx context.Context, in *DeleteKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.api.apikeys.v2.ApiKeys/DeleteKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiKeysClient) UndeleteKey(ctx context.Context, in *UndeleteKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.api.apikeys.v2.ApiKeys/UndeleteKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiKeysClient) LookupKey(ctx context.Context, in *LookupKeyRequest, opts ...grpc.CallOption) (*LookupKeyResponse, error) {
	out := new(LookupKeyResponse)
	err := c.cc.Invoke(ctx, "/google.api.apikeys.v2.ApiKeys/LookupKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ApiKeysServer is the server API for ApiKeys service.
type ApiKeysServer interface {
	// Creates a new API key.
	//
	// NOTE: Key is a global resource; hence the only supported value for
	// location is `global`.
	CreateKey(context.Context, *CreateKeyRequest) (*longrunningpb.Operation, error)
	// Lists the API keys owned by a project. The key string of the API key
	// isn't included in the response.
	//
	// NOTE: Key is a global resource; hence the only supported value for
	// location is `global`.
	ListKeys(context.Context, *ListKeysRequest) (*ListKeysResponse, error)
	// Gets the metadata for an API key. The key string of the API key
	// isn't included in the response.
	//
	// NOTE: Key is a global resource; hence the only supported value for
	// location is `global`.
	GetKey(context.Context, *GetKeyRequest) (*Key, error)
	// Get the key string for an API key.
	//
	// NOTE: Key is a global resource; hence the only supported value for
	// location is `global`.
	GetKeyString(context.Context, *GetKeyStringRequest) (*GetKeyStringResponse, error)
	// Patches the modifiable fields of an API key.
	// The key string of the API key isn't included in the response.
	//
	// NOTE: Key is a global resource; hence the only supported value for
	// location is `global`.
	UpdateKey(context.Context, *UpdateKeyRequest) (*longrunningpb.Operation, error)
	// Deletes an API key. Deleted key can be retrieved within 30 days of
	// deletion. Afterward, key will be purged from the project.
	//
	// NOTE: Key is a global resource; hence the only supported value for
	// location is `global`.
	DeleteKey(context.Context, *DeleteKeyRequest) (*longrunningpb.Operation, error)
	// Undeletes an API key which was deleted within 30 days.
	//
	// NOTE: Key is a global resource; hence the only supported value for
	// location is `global`.
	UndeleteKey(context.Context, *UndeleteKeyRequest) (*longrunningpb.Operation, error)
	// Find the parent project and resource name of the API
	// key that matches the key string in the request. If the API key has been
	// purged, resource name will not be set.
	// The service account must have the `apikeys.keys.lookup` permission
	// on the parent project.
	LookupKey(context.Context, *LookupKeyRequest) (*LookupKeyResponse, error)
}

// UnimplementedApiKeysServer can be embedded to have forward compatible implementations.
type UnimplementedApiKeysServer struct {
}

func (*UnimplementedApiKeysServer) CreateKey(context.Context, *CreateKeyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateKey not implemented")
}
func (*UnimplementedApiKeysServer) ListKeys(context.Context, *ListKeysRequest) (*ListKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListKeys not implemented")
}
func (*UnimplementedApiKeysServer) GetKey(context.Context, *GetKeyRequest) (*Key, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetKey not implemented")
}
func (*UnimplementedApiKeysServer) GetKeyString(context.Context, *GetKeyStringRequest) (*GetKeyStringResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetKeyString not implemented")
}
func (*UnimplementedApiKeysServer) UpdateKey(context.Context, *UpdateKeyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateKey not implemented")
}
func (*UnimplementedApiKeysServer) DeleteKey(context.Context, *DeleteKeyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteKey not implemented")
}
func (*UnimplementedApiKeysServer) UndeleteKey(context.Context, *UndeleteKeyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeleteKey not implemented")
}
func (*UnimplementedApiKeysServer) LookupKey(context.Context, *LookupKeyRequest) (*LookupKeyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LookupKey not implemented")
}

func RegisterApiKeysServer(s *grpc.Server, srv ApiKeysServer) {
	s.RegisterService(&_ApiKeys_serviceDesc, srv)
}

func _ApiKeys_CreateKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiKeysServer).CreateKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.apikeys.v2.ApiKeys/CreateKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiKeysServer).CreateKey(ctx, req.(*CreateKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiKeys_ListKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiKeysServer).ListKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.apikeys.v2.ApiKeys/ListKeys",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiKeysServer).ListKeys(ctx, req.(*ListKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiKeys_GetKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiKeysServer).GetKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.apikeys.v2.ApiKeys/GetKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiKeysServer).GetKey(ctx, req.(*GetKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiKeys_GetKeyString_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetKeyStringRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiKeysServer).GetKeyString(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.apikeys.v2.ApiKeys/GetKeyString",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiKeysServer).GetKeyString(ctx, req.(*GetKeyStringRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiKeys_UpdateKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiKeysServer).UpdateKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.apikeys.v2.ApiKeys/UpdateKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiKeysServer).UpdateKey(ctx, req.(*UpdateKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiKeys_DeleteKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiKeysServer).DeleteKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.apikeys.v2.ApiKeys/DeleteKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiKeysServer).DeleteKey(ctx, req.(*DeleteKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiKeys_UndeleteKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeleteKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiKeysServer).UndeleteKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.apikeys.v2.ApiKeys/UndeleteKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiKeysServer).UndeleteKey(ctx, req.(*UndeleteKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiKeys_LookupKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiKeysServer).LookupKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.apikeys.v2.ApiKeys/LookupKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiKeysServer).LookupKey(ctx, req.(*LookupKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ApiKeys_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.api.apikeys.v2.ApiKeys",
	HandlerType: (*ApiKeysServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateKey",
			Handler:    _ApiKeys_CreateKey_Handler,
		},
		{
			MethodName: "ListKeys",
			Handler:    _ApiKeys_ListKeys_Handler,
		},
		{
			MethodName: "GetKey",
			Handler:    _ApiKeys_GetKey_Handler,
		},
		{
			MethodName: "GetKeyString",
			Handler:    _ApiKeys_GetKeyString_Handler,
		},
		{
			MethodName: "UpdateKey",
			Handler:    _ApiKeys_UpdateKey_Handler,
		},
		{
			MethodName: "DeleteKey",
			Handler:    _ApiKeys_DeleteKey_Handler,
		},
		{
			MethodName: "UndeleteKey",
			Handler:    _ApiKeys_UndeleteKey_Handler,
		},
		{
			MethodName: "LookupKey",
			Handler:    _ApiKeys_LookupKey_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/api/apikeys/v2/apikeys.proto",
}
