// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/apihub/v1/linting_service.proto

package apihubpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The [GetStyleGuide][ApiHub.GetStyleGuide] method's request.
type GetStyleGuideRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the spec to retrieve.
	// Format:
	// `projects/{project}/locations/{location}/plugins/{plugin}/styleGuide`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetStyleGuideRequest) Reset() {
	*x = GetStyleGuideRequest{}
	mi := &file_google_cloud_apihub_v1_linting_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetStyleGuideRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStyleGuideRequest) ProtoMessage() {}

func (x *GetStyleGuideRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_linting_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStyleGuideRequest.ProtoReflect.Descriptor instead.
func (*GetStyleGuideRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_linting_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetStyleGuideRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The [UpdateStyleGuide][ApiHub.UpdateStyleGuide] method's request.
type UpdateStyleGuideRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Style guide resource to update.
	StyleGuide *StyleGuide `protobuf:"bytes,1,opt,name=style_guide,json=styleGuide,proto3" json:"style_guide,omitempty"`
	// Optional. The list of fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateStyleGuideRequest) Reset() {
	*x = UpdateStyleGuideRequest{}
	mi := &file_google_cloud_apihub_v1_linting_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateStyleGuideRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateStyleGuideRequest) ProtoMessage() {}

func (x *UpdateStyleGuideRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_linting_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateStyleGuideRequest.ProtoReflect.Descriptor instead.
func (*UpdateStyleGuideRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_linting_service_proto_rawDescGZIP(), []int{1}
}

func (x *UpdateStyleGuideRequest) GetStyleGuide() *StyleGuide {
	if x != nil {
		return x.StyleGuide
	}
	return nil
}

func (x *UpdateStyleGuideRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The [GetStyleGuideContents][ApiHub.GetStyleGuideContents] method's request.
type GetStyleGuideContentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the StyleGuide whose contents need to be retrieved.
	// There is exactly one style guide resource per project per location.
	// The expected format is
	// `projects/{project}/locations/{location}/plugins/{plugin}/styleGuide`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetStyleGuideContentsRequest) Reset() {
	*x = GetStyleGuideContentsRequest{}
	mi := &file_google_cloud_apihub_v1_linting_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetStyleGuideContentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStyleGuideContentsRequest) ProtoMessage() {}

func (x *GetStyleGuideContentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_linting_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStyleGuideContentsRequest.ProtoReflect.Descriptor instead.
func (*GetStyleGuideContentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_linting_service_proto_rawDescGZIP(), []int{2}
}

func (x *GetStyleGuideContentsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The [LintSpec][ApiHub.LintSpec] method's request.
type LintSpecRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the spec to be linted.
	// Format:
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *LintSpecRequest) Reset() {
	*x = LintSpecRequest{}
	mi := &file_google_cloud_apihub_v1_linting_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LintSpecRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LintSpecRequest) ProtoMessage() {}

func (x *LintSpecRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_linting_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LintSpecRequest.ProtoReflect.Descriptor instead.
func (*LintSpecRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_linting_service_proto_rawDescGZIP(), []int{3}
}

func (x *LintSpecRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The style guide contents.
type StyleGuideContents struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The contents of the style guide.
	Contents []byte `protobuf:"bytes,1,opt,name=contents,proto3" json:"contents,omitempty"`
	// Required. The mime type of the content.
	MimeType string `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
}

func (x *StyleGuideContents) Reset() {
	*x = StyleGuideContents{}
	mi := &file_google_cloud_apihub_v1_linting_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StyleGuideContents) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StyleGuideContents) ProtoMessage() {}

func (x *StyleGuideContents) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_linting_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StyleGuideContents.ProtoReflect.Descriptor instead.
func (*StyleGuideContents) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_linting_service_proto_rawDescGZIP(), []int{4}
}

func (x *StyleGuideContents) GetContents() []byte {
	if x != nil {
		return x.Contents
	}
	return nil
}

func (x *StyleGuideContents) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

// Represents a singleton style guide resource to be used for linting Open API
// specs.
type StyleGuide struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The name of the style guide.
	//
	// Format:
	// `projects/{project}/locations/{location}/plugins/{plugin}/styleGuide`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Target linter for the style guide.
	Linter Linter `protobuf:"varint,2,opt,name=linter,proto3,enum=google.cloud.apihub.v1.Linter" json:"linter,omitempty"`
	// Required. Input only. The contents of the uploaded style guide.
	Contents *StyleGuideContents `protobuf:"bytes,3,opt,name=contents,proto3" json:"contents,omitempty"`
}

func (x *StyleGuide) Reset() {
	*x = StyleGuide{}
	mi := &file_google_cloud_apihub_v1_linting_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StyleGuide) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StyleGuide) ProtoMessage() {}

func (x *StyleGuide) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_linting_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StyleGuide.ProtoReflect.Descriptor instead.
func (*StyleGuide) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_linting_service_proto_rawDescGZIP(), []int{5}
}

func (x *StyleGuide) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StyleGuide) GetLinter() Linter {
	if x != nil {
		return x.Linter
	}
	return Linter_LINTER_UNSPECIFIED
}

func (x *StyleGuide) GetContents() *StyleGuideContents {
	if x != nil {
		return x.Contents
	}
	return nil
}

var File_google_cloud_apihub_v1_linting_service_proto protoreflect.FileDescriptor

var file_google_cloud_apihub_v1_linting_service_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x70, 0x69, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x69, 0x6e, 0x74, 0x69, 0x6e, 0x67,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2f, 0x76,
	0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x54, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x53, 0x74, 0x79, 0x6c, 0x65,
	0x47, 0x75, 0x69, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x22, 0x0a, 0x20, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x47,
	0x75, 0x69, 0x64, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa5, 0x01, 0x0a, 0x17, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x47, 0x75, 0x69, 0x64, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x0b, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x5f,
	0x67, 0x75, 0x69, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x47, 0x75, 0x69, 0x64, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x47, 0x75, 0x69, 0x64, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0x5c, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x47, 0x75,
	0x69, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x74, 0x79, 0x6c, 0x65, 0x47, 0x75, 0x69, 0x64, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x49, 0x0a, 0x0f, 0x4c, 0x69, 0x6e, 0x74, 0x53, 0x70, 0x65, 0x63, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x36, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x22, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1c, 0x0a, 0x1a, 0x61, 0x70, 0x69, 0x68, 0x75,
	0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x70, 0x65, 0x63, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x57, 0x0a, 0x12, 0x53,
	0x74, 0x79, 0x6c, 0x65, 0x47, 0x75, 0x69, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0x1f, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x73, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x22, 0xb9, 0x02, 0x0a, 0x0a, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x47, 0x75,
	0x69, 0x64, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x06,
	0x6c, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x06, 0x6c, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x12, 0x4e, 0x0a, 0x08, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x47, 0x75, 0x69, 0x64, 0x65, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x04, 0x52,
	0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x84, 0x01, 0xea, 0x41, 0x80, 0x01,
	0x0a, 0x20, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x47, 0x75, 0x69,
	0x64, 0x65, 0x12, 0x43, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x73, 0x2f, 0x7b, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x7d, 0x2f, 0x73, 0x74, 0x79,
	0x6c, 0x65, 0x47, 0x75, 0x69, 0x64, 0x65, 0x2a, 0x0b, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x47, 0x75,
	0x69, 0x64, 0x65, 0x73, 0x32, 0x0a, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x47, 0x75, 0x69, 0x64, 0x65,
	0x32, 0xca, 0x06, 0x0a, 0x0e, 0x4c, 0x69, 0x6e, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x12, 0xa8, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x53, 0x74, 0x79, 0x6c, 0x65,
	0x47, 0x75, 0x69, 0x64, 0x65, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x47, 0x75, 0x69, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x79,
	0x6c, 0x65, 0x47, 0x75, 0x69, 0x64, 0x65, 0x22, 0x45, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x47, 0x75, 0x69, 0x64, 0x65, 0x7d, 0x12, 0xda,
	0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x47, 0x75,
	0x69, 0x64, 0x65, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x47, 0x75, 0x69, 0x64, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74,
	0x79, 0x6c, 0x65, 0x47, 0x75, 0x69, 0x64, 0x65, 0x22, 0x71, 0xda, 0x41, 0x17, 0x73, 0x74, 0x79,
	0x6c, 0x65, 0x5f, 0x67, 0x75, 0x69, 0x64, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x51, 0x3a, 0x0b, 0x73, 0x74, 0x79, 0x6c,
	0x65, 0x5f, 0x67, 0x75, 0x69, 0x64, 0x65, 0x32, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x74,
	0x79, 0x6c, 0x65, 0x5f, 0x67, 0x75, 0x69, 0x64, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x74, 0x79, 0x6c, 0x65, 0x47, 0x75, 0x69, 0x64, 0x65, 0x7d, 0x12, 0xc9, 0x01, 0x0a, 0x15,
	0x47, 0x65, 0x74, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x47, 0x75, 0x69, 0x64, 0x65, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x47, 0x75, 0x69, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x47, 0x75, 0x69, 0x64, 0x65, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x4e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x12, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x47, 0x75, 0x69, 0x64, 0x65, 0x7d, 0x3a, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x98, 0x01, 0x0a, 0x08, 0x4c, 0x69, 0x6e, 0x74,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x6e, 0x74, 0x53, 0x70, 0x65, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x4b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x3a, 0x01, 0x2a,
	0x22, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x70, 0x65, 0x63, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6c, 0x69,
	0x6e, 0x74, 0x1a, 0x49, 0xca, 0x41, 0x15, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xb5, 0x01,
	0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x42, 0x13, 0x4c, 0x69,
	0x6e, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x32, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x70, 0x62, 0x3b, 0x61,
	0x70, 0x69, 0x68, 0x75, 0x62, 0x70, 0x62, 0xaa, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x70, 0x69, 0x48, 0x75, 0x62, 0x2e, 0x56, 0x31,
	0xca, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x41, 0x70, 0x69, 0x48, 0x75, 0x62, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x70, 0x69, 0x48, 0x75,
	0x62, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_apihub_v1_linting_service_proto_rawDescOnce sync.Once
	file_google_cloud_apihub_v1_linting_service_proto_rawDescData = file_google_cloud_apihub_v1_linting_service_proto_rawDesc
)

func file_google_cloud_apihub_v1_linting_service_proto_rawDescGZIP() []byte {
	file_google_cloud_apihub_v1_linting_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_apihub_v1_linting_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_apihub_v1_linting_service_proto_rawDescData)
	})
	return file_google_cloud_apihub_v1_linting_service_proto_rawDescData
}

var file_google_cloud_apihub_v1_linting_service_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_cloud_apihub_v1_linting_service_proto_goTypes = []any{
	(*GetStyleGuideRequest)(nil),         // 0: google.cloud.apihub.v1.GetStyleGuideRequest
	(*UpdateStyleGuideRequest)(nil),      // 1: google.cloud.apihub.v1.UpdateStyleGuideRequest
	(*GetStyleGuideContentsRequest)(nil), // 2: google.cloud.apihub.v1.GetStyleGuideContentsRequest
	(*LintSpecRequest)(nil),              // 3: google.cloud.apihub.v1.LintSpecRequest
	(*StyleGuideContents)(nil),           // 4: google.cloud.apihub.v1.StyleGuideContents
	(*StyleGuide)(nil),                   // 5: google.cloud.apihub.v1.StyleGuide
	(*fieldmaskpb.FieldMask)(nil),        // 6: google.protobuf.FieldMask
	(Linter)(0),                          // 7: google.cloud.apihub.v1.Linter
	(*emptypb.Empty)(nil),                // 8: google.protobuf.Empty
}
var file_google_cloud_apihub_v1_linting_service_proto_depIdxs = []int32{
	5, // 0: google.cloud.apihub.v1.UpdateStyleGuideRequest.style_guide:type_name -> google.cloud.apihub.v1.StyleGuide
	6, // 1: google.cloud.apihub.v1.UpdateStyleGuideRequest.update_mask:type_name -> google.protobuf.FieldMask
	7, // 2: google.cloud.apihub.v1.StyleGuide.linter:type_name -> google.cloud.apihub.v1.Linter
	4, // 3: google.cloud.apihub.v1.StyleGuide.contents:type_name -> google.cloud.apihub.v1.StyleGuideContents
	0, // 4: google.cloud.apihub.v1.LintingService.GetStyleGuide:input_type -> google.cloud.apihub.v1.GetStyleGuideRequest
	1, // 5: google.cloud.apihub.v1.LintingService.UpdateStyleGuide:input_type -> google.cloud.apihub.v1.UpdateStyleGuideRequest
	2, // 6: google.cloud.apihub.v1.LintingService.GetStyleGuideContents:input_type -> google.cloud.apihub.v1.GetStyleGuideContentsRequest
	3, // 7: google.cloud.apihub.v1.LintingService.LintSpec:input_type -> google.cloud.apihub.v1.LintSpecRequest
	5, // 8: google.cloud.apihub.v1.LintingService.GetStyleGuide:output_type -> google.cloud.apihub.v1.StyleGuide
	5, // 9: google.cloud.apihub.v1.LintingService.UpdateStyleGuide:output_type -> google.cloud.apihub.v1.StyleGuide
	4, // 10: google.cloud.apihub.v1.LintingService.GetStyleGuideContents:output_type -> google.cloud.apihub.v1.StyleGuideContents
	8, // 11: google.cloud.apihub.v1.LintingService.LintSpec:output_type -> google.protobuf.Empty
	8, // [8:12] is the sub-list for method output_type
	4, // [4:8] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_google_cloud_apihub_v1_linting_service_proto_init() }
func file_google_cloud_apihub_v1_linting_service_proto_init() {
	if File_google_cloud_apihub_v1_linting_service_proto != nil {
		return
	}
	file_google_cloud_apihub_v1_common_fields_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_apihub_v1_linting_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_apihub_v1_linting_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_apihub_v1_linting_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_apihub_v1_linting_service_proto_msgTypes,
	}.Build()
	File_google_cloud_apihub_v1_linting_service_proto = out.File
	file_google_cloud_apihub_v1_linting_service_proto_rawDesc = nil
	file_google_cloud_apihub_v1_linting_service_proto_goTypes = nil
	file_google_cloud_apihub_v1_linting_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// LintingServiceClient is the client API for LintingService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type LintingServiceClient interface {
	// Get the style guide being used for linting.
	GetStyleGuide(ctx context.Context, in *GetStyleGuideRequest, opts ...grpc.CallOption) (*StyleGuide, error)
	// Update the styleGuide to be used for liniting in by API hub.
	UpdateStyleGuide(ctx context.Context, in *UpdateStyleGuideRequest, opts ...grpc.CallOption) (*StyleGuide, error)
	// Get the contents of the style guide.
	GetStyleGuideContents(ctx context.Context, in *GetStyleGuideContentsRequest, opts ...grpc.CallOption) (*StyleGuideContents, error)
	// Lints the requested spec and updates the corresponding API Spec with the
	// lint response. This lint response will be available in all subsequent
	// Get and List Spec calls to Core service.
	LintSpec(ctx context.Context, in *LintSpecRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type lintingServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewLintingServiceClient(cc grpc.ClientConnInterface) LintingServiceClient {
	return &lintingServiceClient{cc}
}

func (c *lintingServiceClient) GetStyleGuide(ctx context.Context, in *GetStyleGuideRequest, opts ...grpc.CallOption) (*StyleGuide, error) {
	out := new(StyleGuide)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.LintingService/GetStyleGuide", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lintingServiceClient) UpdateStyleGuide(ctx context.Context, in *UpdateStyleGuideRequest, opts ...grpc.CallOption) (*StyleGuide, error) {
	out := new(StyleGuide)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.LintingService/UpdateStyleGuide", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lintingServiceClient) GetStyleGuideContents(ctx context.Context, in *GetStyleGuideContentsRequest, opts ...grpc.CallOption) (*StyleGuideContents, error) {
	out := new(StyleGuideContents)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.LintingService/GetStyleGuideContents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lintingServiceClient) LintSpec(ctx context.Context, in *LintSpecRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.LintingService/LintSpec", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LintingServiceServer is the server API for LintingService service.
type LintingServiceServer interface {
	// Get the style guide being used for linting.
	GetStyleGuide(context.Context, *GetStyleGuideRequest) (*StyleGuide, error)
	// Update the styleGuide to be used for liniting in by API hub.
	UpdateStyleGuide(context.Context, *UpdateStyleGuideRequest) (*StyleGuide, error)
	// Get the contents of the style guide.
	GetStyleGuideContents(context.Context, *GetStyleGuideContentsRequest) (*StyleGuideContents, error)
	// Lints the requested spec and updates the corresponding API Spec with the
	// lint response. This lint response will be available in all subsequent
	// Get and List Spec calls to Core service.
	LintSpec(context.Context, *LintSpecRequest) (*emptypb.Empty, error)
}

// UnimplementedLintingServiceServer can be embedded to have forward compatible implementations.
type UnimplementedLintingServiceServer struct {
}

func (*UnimplementedLintingServiceServer) GetStyleGuide(context.Context, *GetStyleGuideRequest) (*StyleGuide, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetStyleGuide not implemented")
}
func (*UnimplementedLintingServiceServer) UpdateStyleGuide(context.Context, *UpdateStyleGuideRequest) (*StyleGuide, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateStyleGuide not implemented")
}
func (*UnimplementedLintingServiceServer) GetStyleGuideContents(context.Context, *GetStyleGuideContentsRequest) (*StyleGuideContents, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetStyleGuideContents not implemented")
}
func (*UnimplementedLintingServiceServer) LintSpec(context.Context, *LintSpecRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LintSpec not implemented")
}

func RegisterLintingServiceServer(s *grpc.Server, srv LintingServiceServer) {
	s.RegisterService(&_LintingService_serviceDesc, srv)
}

func _LintingService_GetStyleGuide_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetStyleGuideRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LintingServiceServer).GetStyleGuide(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.LintingService/GetStyleGuide",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LintingServiceServer).GetStyleGuide(ctx, req.(*GetStyleGuideRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LintingService_UpdateStyleGuide_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateStyleGuideRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LintingServiceServer).UpdateStyleGuide(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.LintingService/UpdateStyleGuide",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LintingServiceServer).UpdateStyleGuide(ctx, req.(*UpdateStyleGuideRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LintingService_GetStyleGuideContents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetStyleGuideContentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LintingServiceServer).GetStyleGuideContents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.LintingService/GetStyleGuideContents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LintingServiceServer).GetStyleGuideContents(ctx, req.(*GetStyleGuideContentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LintingService_LintSpec_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LintSpecRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LintingServiceServer).LintSpec(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.LintingService/LintSpec",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LintingServiceServer).LintSpec(ctx, req.(*LintSpecRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _LintingService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.apihub.v1.LintingService",
	HandlerType: (*LintingServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetStyleGuide",
			Handler:    _LintingService_GetStyleGuide_Handler,
		},
		{
			MethodName: "UpdateStyleGuide",
			Handler:    _LintingService_UpdateStyleGuide_Handler,
		},
		{
			MethodName: "GetStyleGuideContents",
			Handler:    _LintingService_GetStyleGuideContents_Handler,
		},
		{
			MethodName: "LintSpec",
			Handler:    _LintingService_LintSpec_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/apihub/v1/linting_service.proto",
}
