// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/apihub/v1/apihub_service.proto

package apihubpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The [CreateApi][google.cloud.apihub.v1.ApiHub.CreateApi] method's request.
type CreateApiRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource for the API resource.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The ID to use for the API resource, which will become the final
	// component of the API's resource name. This field is optional.
	//
	// * If provided, the same will be used. The service will throw an error if
	// the specified id is already used by another API resource in the API hub.
	// * If not provided, a system generated id will be used.
	//
	// This value should be 4-500 characters, and valid characters
	// are /[a-z][A-Z][0-9]-_/.
	ApiId string `protobuf:"bytes,2,opt,name=api_id,json=apiId,proto3" json:"api_id,omitempty"`
	// Required. The API resource to create.
	Api *Api `protobuf:"bytes,3,opt,name=api,proto3" json:"api,omitempty"`
}

func (x *CreateApiRequest) Reset() {
	*x = CreateApiRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateApiRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateApiRequest) ProtoMessage() {}

func (x *CreateApiRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateApiRequest.ProtoReflect.Descriptor instead.
func (*CreateApiRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreateApiRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateApiRequest) GetApiId() string {
	if x != nil {
		return x.ApiId
	}
	return ""
}

func (x *CreateApiRequest) GetApi() *Api {
	if x != nil {
		return x.Api
	}
	return nil
}

// The [GetApi][google.cloud.apihub.v1.ApiHub.GetApi] method's request.
type GetApiRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the API resource to retrieve.
	// Format: `projects/{project}/locations/{location}/apis/{api}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetApiRequest) Reset() {
	*x = GetApiRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetApiRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetApiRequest) ProtoMessage() {}

func (x *GetApiRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetApiRequest.ProtoReflect.Descriptor instead.
func (*GetApiRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{1}
}

func (x *GetApiRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The [UpdateApi][google.cloud.apihub.v1.ApiHub.UpdateApi] method's request.
type UpdateApiRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The API resource to update.
	//
	// The API resource's `name` field is used to identify the API resource to
	// update.
	// Format: `projects/{project}/locations/{location}/apis/{api}`
	Api *Api `protobuf:"bytes,1,opt,name=api,proto3" json:"api,omitempty"`
	// Required. The list of fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateApiRequest) Reset() {
	*x = UpdateApiRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateApiRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateApiRequest) ProtoMessage() {}

func (x *UpdateApiRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateApiRequest.ProtoReflect.Descriptor instead.
func (*UpdateApiRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{2}
}

func (x *UpdateApiRequest) GetApi() *Api {
	if x != nil {
		return x.Api
	}
	return nil
}

func (x *UpdateApiRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The [DeleteApi][google.cloud.apihub.v1.ApiHub.DeleteApi] method's request.
type DeleteApiRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the API resource to delete.
	// Format: `projects/{project}/locations/{location}/apis/{api}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If set to true, any versions from this API will also be deleted.
	// Otherwise, the request will only work if the API has no versions.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteApiRequest) Reset() {
	*x = DeleteApiRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteApiRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteApiRequest) ProtoMessage() {}

func (x *DeleteApiRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteApiRequest.ProtoReflect.Descriptor instead.
func (*DeleteApiRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{3}
}

func (x *DeleteApiRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteApiRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// The [ListApis][google.cloud.apihub.v1.ApiHub.ListApis] method's request.
type ListApisRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of API resources.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. An expression that filters the list of ApiResources.
	//
	// A filter expression consists of a field name, a comparison
	// operator, and a value for filtering. The value must be a string. The
	// comparison operator must be one of: `<`, `>`, `:` or `=`. Filters are not
	// case sensitive.
	//
	// The following fields in the `ApiResource` are eligible for filtering:
	//
	//   - `owner.email` - The email of the team which owns the ApiResource.
	//     Allowed comparison operators: `=`.
	//   - `create_time` - The time at which the ApiResource was created. The
	//     value should be in the (RFC3339)[https://tools.ietf.org/html/rfc3339]
	//     format. Allowed comparison operators: `>` and `<`.
	//   - `display_name` - The display name of the ApiResource. Allowed
	//     comparison operators: `=`.
	//   - `target_user.enum_values.values.id` - The allowed value id of the
	//     target users attribute associated with the ApiResource. Allowed
	//     comparison operator is `:`.
	//   - `target_user.enum_values.values.display_name` - The allowed value
	//     display name of the target users attribute associated with the
	//     ApiResource. Allowed comparison operator is `:`.
	//   - `team.enum_values.values.id` - The allowed value id of the team
	//     attribute associated with the ApiResource. Allowed comparison operator is
	//     `:`.
	//   - `team.enum_values.values.display_name` - The allowed value display name
	//     of the team attribute associated with the ApiResource. Allowed comparison
	//     operator is `:`.
	//   - `business_unit.enum_values.values.id` - The allowed value id of the
	//     business unit attribute associated with the ApiResource. Allowed
	//     comparison operator is `:`.
	//   - `business_unit.enum_values.values.display_name` - The allowed value
	//     display name of the business unit attribute associated with the
	//     ApiResource. Allowed comparison operator is `:`.
	//   - `maturity_level.enum_values.values.id` - The allowed value id of the
	//     maturity level attribute associated with the ApiResource. Allowed
	//     comparison operator is `:`.
	//   - `maturity_level.enum_values.values.display_name` - The allowed value
	//     display name of the maturity level attribute associated with the
	//     ApiResource. Allowed comparison operator is `:`.
	//   - `api_style.enum_values.values.id` - The allowed value id of the
	//     api style attribute associated with the ApiResource. Allowed
	//     comparison operator is `:`.
	//   - `api_style.enum_values.values.display_name` - The allowed value display
	//     name of the api style attribute associated with the ApiResource. Allowed
	//     comparison operator is `:`.
	//
	// Expressions are combined with either `AND` logic operator or `OR` logical
	// operator but not both of them together i.e. only one of the `AND` or `OR`
	// operator can be used throughout the filter string and both the operators
	// cannot be used together. No other logical operators are supported. At most
	// three filter fields are allowed in the filter string and if provided
	// more than that then `INVALID_ARGUMENT` error is returned by the API.
	//
	// Here are a few examples:
	//
	//   - `owner.email = \"apihub@google.com\"` -  - The owner team email is
	//     _apihub@google.com_.
	//   - `owner.email = \"apihub@google.com\" AND create_time <
	//     \"2021-08-15T14:50:00Z\" AND create_time > \"2021-08-10T12:00:00Z\"` -
	//     The owner team email is _apihub@google.com_ and the api was created
	//     before _2021-08-15 14:50:00 UTC_ and after _2021-08-10 12:00:00 UTC_.
	//   - `owner.email = \"apihub@google.com\" OR team.enum_values.values.id:
	//     apihub-team-id` - The filter string specifies the APIs where the owner
	//     team email is _apihub@google.com_ or the id of the allowed value
	//     associated with the team attribute is _apihub-team-id_.
	//   - `owner.email = \"apihub@google.com\" OR
	//     team.enum_values.values.display_name: ApiHub Team` - The filter string
	//     specifies the APIs where the owner team email is _apihub@google.com_ or
	//     the display name of the allowed value associated with the team attribute
	//     is `ApiHub Team`.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The maximum number of API resources to return. The service may
	// return fewer than this value. If unspecified, at most 50 Apis will be
	// returned. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListApis` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters (except page_size) provided to
	// `ListApis` must match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListApisRequest) Reset() {
	*x = ListApisRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListApisRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListApisRequest) ProtoMessage() {}

func (x *ListApisRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListApisRequest.ProtoReflect.Descriptor instead.
func (*ListApisRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListApisRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListApisRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListApisRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListApisRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The [ListApis][google.cloud.apihub.v1.ApiHub.ListApis] method's response.
type ListApisResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The API resources present in the API hub.
	Apis []*Api `protobuf:"bytes,1,rep,name=apis,proto3" json:"apis,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListApisResponse) Reset() {
	*x = ListApisResponse{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListApisResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListApisResponse) ProtoMessage() {}

func (x *ListApisResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListApisResponse.ProtoReflect.Descriptor instead.
func (*ListApisResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{5}
}

func (x *ListApisResponse) GetApis() []*Api {
	if x != nil {
		return x.Apis
	}
	return nil
}

func (x *ListApisResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The [CreateVersion][google.cloud.apihub.v1.ApiHub.CreateVersion] method's
// request.
type CreateVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource for API version.
	// Format: `projects/{project}/locations/{location}/apis/{api}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The ID to use for the API version, which will become the final
	// component of the version's resource name. This field is optional.
	//
	// * If provided, the same will be used. The service will throw an error if
	// the specified id is already used by another version in the API resource.
	// * If not provided, a system generated id will be used.
	//
	// This value should be 4-500 characters, and valid characters
	// are /[a-z][A-Z][0-9]-_/.
	VersionId string `protobuf:"bytes,2,opt,name=version_id,json=versionId,proto3" json:"version_id,omitempty"`
	// Required. The version to create.
	Version *Version `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *CreateVersionRequest) Reset() {
	*x = CreateVersionRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateVersionRequest) ProtoMessage() {}

func (x *CreateVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateVersionRequest.ProtoReflect.Descriptor instead.
func (*CreateVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{6}
}

func (x *CreateVersionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateVersionRequest) GetVersionId() string {
	if x != nil {
		return x.VersionId
	}
	return ""
}

func (x *CreateVersionRequest) GetVersion() *Version {
	if x != nil {
		return x.Version
	}
	return nil
}

// The [GetVersion][google.cloud.apihub.v1.ApiHub.GetVersion] method's request.
type GetVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the API version to retrieve.
	// Format:
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetVersionRequest) Reset() {
	*x = GetVersionRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVersionRequest) ProtoMessage() {}

func (x *GetVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVersionRequest.ProtoReflect.Descriptor instead.
func (*GetVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{7}
}

func (x *GetVersionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The [UpdateVersion][google.cloud.apihub.v1.ApiHub.UpdateVersion] method's
// request.
type UpdateVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The API version to update.
	//
	// The version's `name` field is used to identify the API version to update.
	// Format:
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
	Version *Version `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Required. The list of fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateVersionRequest) Reset() {
	*x = UpdateVersionRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateVersionRequest) ProtoMessage() {}

func (x *UpdateVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateVersionRequest.ProtoReflect.Descriptor instead.
func (*UpdateVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{8}
}

func (x *UpdateVersionRequest) GetVersion() *Version {
	if x != nil {
		return x.Version
	}
	return nil
}

func (x *UpdateVersionRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The [DeleteVersion][google.cloud.apihub.v1.ApiHub.DeleteVersion] method's
// request.
type DeleteVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the version to delete.
	// Format:
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If set to true, any specs from this version will also be deleted.
	// Otherwise, the request will only work if the version has no specs.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteVersionRequest) Reset() {
	*x = DeleteVersionRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteVersionRequest) ProtoMessage() {}

func (x *DeleteVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteVersionRequest.ProtoReflect.Descriptor instead.
func (*DeleteVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{9}
}

func (x *DeleteVersionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteVersionRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// The [ListVersions][google.cloud.apihub.v1.ApiHub.ListVersions] method's
// request.
type ListVersionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent which owns this collection of API versions i.e., the
	// API resource Format: `projects/{project}/locations/{location}/apis/{api}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. An expression that filters the list of Versions.
	//
	// A filter expression consists of a field name, a comparison
	// operator, and a value for filtering. The value must be a string, a
	// number, or a boolean. The comparison operator must be one of: `<`, `>` or
	// `=`. Filters are not case sensitive.
	//
	// The following fields in the `Version` are eligible for filtering:
	//
	//   - `display_name` - The display name of the Version. Allowed
	//     comparison operators: `=`.
	//   - `create_time` - The time at which the Version was created. The
	//     value should be in the (RFC3339)[https://tools.ietf.org/html/rfc3339]
	//     format. Allowed comparison operators: `>` and `<`.
	//   - `lifecycle.enum_values.values.id` - The allowed value id of the
	//     lifecycle attribute associated with the Version. Allowed comparison
	//     operators: `:`.
	//   - `lifecycle.enum_values.values.display_name` - The allowed value display
	//     name of the lifecycle attribute associated with the Version. Allowed
	//     comparison operators: `:`.
	//   - `compliance.enum_values.values.id` -  The allowed value id of the
	//     compliances attribute associated with the Version. Allowed comparison
	//     operators: `:`.
	//   - `compliance.enum_values.values.display_name` -  The allowed value
	//     display name of the compliances attribute associated with the Version.
	//     Allowed comparison operators: `:`.
	//   - `accreditation.enum_values.values.id` - The allowed value id of the
	//     accreditations attribute associated with the Version. Allowed
	//     comparison operators: `:`.
	//   - `accreditation.enum_values.values.display_name` - The allowed value
	//     display name of the accreditations attribute associated with the Version.
	//     Allowed comparison operators: `:`.
	//
	// Expressions are combined with either `AND` logic operator or `OR` logical
	// operator but not both of them together i.e. only one of the `AND` or `OR`
	// operator can be used throughout the filter string and both the operators
	// cannot be used together. No other logical operators are
	// supported. At most three filter fields are allowed in the filter
	// string and if provided more than that then `INVALID_ARGUMENT` error is
	// returned by the API.
	//
	// Here are a few examples:
	//
	//   - `lifecycle.enum_values.values.id: preview-id` - The filter string
	//     specifies that the id of the allowed value associated with the lifecycle
	//     attribute of the Version is _preview-id_.
	//   - `lifecycle.enum_values.values.display_name: \"Preview Display Name\"` -
	//     The filter string specifies that the display name of the allowed value
	//     associated with the lifecycle attribute of the Version is `Preview
	//     Display Name`.
	//   - `lifecycle.enum_values.values.id: preview-id AND create_time <
	//     \"2021-08-15T14:50:00Z\" AND create_time > \"2021-08-10T12:00:00Z\"` -
	//     The id of the allowed value associated with the lifecycle attribute of
	//     the Version is _preview-id_ and it was created before _2021-08-15
	//     14:50:00 UTC_ and after _2021-08-10 12:00:00 UTC_.
	//   - `compliance.enum_values.values.id: gdpr-id OR
	//     compliance.enum_values.values.id: pci-dss-id`
	//   - The id of the allowed value associated with the compliance attribute is
	//     _gdpr-id_ or _pci-dss-id_.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The maximum number of versions to return. The service may return
	// fewer than this value. If unspecified, at most 50 versions will be
	// returned. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListVersions` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters (except page_size) provided to
	// `ListVersions` must match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListVersionsRequest) Reset() {
	*x = ListVersionsRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListVersionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVersionsRequest) ProtoMessage() {}

func (x *ListVersionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVersionsRequest.ProtoReflect.Descriptor instead.
func (*ListVersionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{10}
}

func (x *ListVersionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListVersionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListVersionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListVersionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The [ListVersions][google.cloud.apihub.v1.ApiHub.ListVersions] method's
// response.
type ListVersionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The versions corresponding to an API.
	Versions []*Version `protobuf:"bytes,1,rep,name=versions,proto3" json:"versions,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListVersionsResponse) Reset() {
	*x = ListVersionsResponse{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListVersionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVersionsResponse) ProtoMessage() {}

func (x *ListVersionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVersionsResponse.ProtoReflect.Descriptor instead.
func (*ListVersionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{11}
}

func (x *ListVersionsResponse) GetVersions() []*Version {
	if x != nil {
		return x.Versions
	}
	return nil
}

func (x *ListVersionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The [CreateSpec][google.cloud.apihub.v1.ApiHub.CreateSpec] method's request.
type CreateSpecRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource for Spec.
	// Format:
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The ID to use for the spec, which will become the final component
	// of the spec's resource name. This field is optional.
	//
	// * If provided, the same will be used. The service will throw an error if
	// the specified id is already used by another spec in the API
	// resource.
	// * If not provided, a system generated id will be used.
	//
	// This value should be 4-500 characters, and valid characters
	// are /[a-z][A-Z][0-9]-_/.
	SpecId string `protobuf:"bytes,2,opt,name=spec_id,json=specId,proto3" json:"spec_id,omitempty"`
	// Required. The spec to create.
	Spec *Spec `protobuf:"bytes,3,opt,name=spec,proto3" json:"spec,omitempty"`
}

func (x *CreateSpecRequest) Reset() {
	*x = CreateSpecRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateSpecRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSpecRequest) ProtoMessage() {}

func (x *CreateSpecRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSpecRequest.ProtoReflect.Descriptor instead.
func (*CreateSpecRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{12}
}

func (x *CreateSpecRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSpecRequest) GetSpecId() string {
	if x != nil {
		return x.SpecId
	}
	return ""
}

func (x *CreateSpecRequest) GetSpec() *Spec {
	if x != nil {
		return x.Spec
	}
	return nil
}

// The [GetSpec][google.cloud.apihub.v1.ApiHub.GetSpec] method's request.
type GetSpecRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the spec to retrieve.
	// Format:
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSpecRequest) Reset() {
	*x = GetSpecRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSpecRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSpecRequest) ProtoMessage() {}

func (x *GetSpecRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSpecRequest.ProtoReflect.Descriptor instead.
func (*GetSpecRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{13}
}

func (x *GetSpecRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The [UpdateSpec][google.cloud.apihub.v1.ApiHub.UpdateSpec] method's request.
type UpdateSpecRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The spec to update.
	//
	// The spec's `name` field is used to identify the spec to
	// update. Format:
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
	Spec *Spec `protobuf:"bytes,1,opt,name=spec,proto3" json:"spec,omitempty"`
	// Required. The list of fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSpecRequest) Reset() {
	*x = UpdateSpecRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateSpecRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSpecRequest) ProtoMessage() {}

func (x *UpdateSpecRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSpecRequest.ProtoReflect.Descriptor instead.
func (*UpdateSpecRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{14}
}

func (x *UpdateSpecRequest) GetSpec() *Spec {
	if x != nil {
		return x.Spec
	}
	return nil
}

func (x *UpdateSpecRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The [DeleteSpec][google.cloud.apihub.v1.ApiHub.DeleteSpec] method's request.
type DeleteSpecRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the spec  to delete.
	// Format:
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSpecRequest) Reset() {
	*x = DeleteSpecRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteSpecRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSpecRequest) ProtoMessage() {}

func (x *DeleteSpecRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSpecRequest.ProtoReflect.Descriptor instead.
func (*DeleteSpecRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{15}
}

func (x *DeleteSpecRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The [ListSpecs][ListSpecs] method's request.
type ListSpecsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of specs.
	// Format:
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. An expression that filters the list of Specs.
	//
	// A filter expression consists of a field name, a comparison
	// operator, and a value for filtering. The value must be a string. The
	// comparison operator must be one of: `<`, `>`, `:` or `=`. Filters are not
	// case sensitive.
	//
	// The following fields in the `Spec` are eligible for filtering:
	//
	//   - `display_name` - The display name of the Spec. Allowed comparison
	//     operators: `=`.
	//   - `create_time` - The time at which the Spec was created. The
	//     value should be in the (RFC3339)[https://tools.ietf.org/html/rfc3339]
	//     format. Allowed comparison operators: `>` and `<`.
	//   - `spec_type.enum_values.values.id` - The allowed value id of the
	//     spec_type attribute associated with the Spec. Allowed comparison
	//     operators: `:`.
	//   - `spec_type.enum_values.values.display_name` - The allowed value display
	//     name of the spec_type attribute associated with the Spec. Allowed
	//     comparison operators: `:`.
	//   - `lint_response.json_values.values` - The json value of the
	//     lint_response attribute associated with the Spec. Allowed comparison
	//     operators: `:`.
	//   - `mime_type` - The MIME type of the Spec. Allowed comparison
	//     operators: `=`.
	//
	// Expressions are combined with either `AND` logic operator or `OR` logical
	// operator but not both of them together i.e. only one of the `AND` or `OR`
	// operator can be used throughout the filter string and both the operators
	// cannot be used together. No other logical operators are
	// supported. At most three filter fields are allowed in the filter
	// string and if provided more than that then `INVALID_ARGUMENT` error is
	// returned by the API.
	//
	// Here are a few examples:
	//
	//   - `spec_type.enum_values.values.id: rest-id` -  The filter
	//     string specifies that the id of the allowed value associated with the
	//     spec_type attribute is _rest-id_.
	//   - `spec_type.enum_values.values.display_name: \"Rest Display Name\"` -
	//     The filter string specifies that the display name of the allowed value
	//     associated with the spec_type attribute is `Rest Display Name`.
	//   - `spec_type.enum_values.values.id: grpc-id AND create_time <
	//     \"2021-08-15T14:50:00Z\" AND create_time > \"2021-08-10T12:00:00Z\"` -
	//     The id of the allowed value associated with the spec_type attribute is
	//     _grpc-id_ and the spec was created before _2021-08-15 14:50:00 UTC_ and
	//     after _2021-08-10 12:00:00 UTC_.
	//   - `spec_type.enum_values.values.id: rest-id OR
	//     spec_type.enum_values.values.id: grpc-id`
	//   - The id of the allowed value associated with the spec_type attribute is
	//     _rest-id_ or _grpc-id_.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The maximum number of specs to return. The service may return
	// fewer than this value. If unspecified, at most 50 specs will be
	// returned. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListSpecs` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListSpecs` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSpecsRequest) Reset() {
	*x = ListSpecsRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSpecsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSpecsRequest) ProtoMessage() {}

func (x *ListSpecsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSpecsRequest.ProtoReflect.Descriptor instead.
func (*ListSpecsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{16}
}

func (x *ListSpecsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSpecsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListSpecsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSpecsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The [ListSpecs][google.cloud.apihub.v1.ApiHub.ListSpecs] method's response.
type ListSpecsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The specs corresponding to an API.
	Specs []*Spec `protobuf:"bytes,1,rep,name=specs,proto3" json:"specs,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSpecsResponse) Reset() {
	*x = ListSpecsResponse{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSpecsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSpecsResponse) ProtoMessage() {}

func (x *ListSpecsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSpecsResponse.ProtoReflect.Descriptor instead.
func (*ListSpecsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{17}
}

func (x *ListSpecsResponse) GetSpecs() []*Spec {
	if x != nil {
		return x.Specs
	}
	return nil
}

func (x *ListSpecsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The [GetSpecContents][google.cloud.apihub.v1.ApiHub.GetSpecContents] method's
// request.
type GetSpecContentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the spec whose contents need to be retrieved.
	// Format:
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSpecContentsRequest) Reset() {
	*x = GetSpecContentsRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSpecContentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSpecContentsRequest) ProtoMessage() {}

func (x *GetSpecContentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSpecContentsRequest.ProtoReflect.Descriptor instead.
func (*GetSpecContentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{18}
}

func (x *GetSpecContentsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The [GetApiOperation][google.cloud.apihub.v1.ApiHub.GetApiOperation] method's
// request.
type GetApiOperationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the operation to retrieve.
	// Format:
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operations/{operation}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetApiOperationRequest) Reset() {
	*x = GetApiOperationRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetApiOperationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetApiOperationRequest) ProtoMessage() {}

func (x *GetApiOperationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetApiOperationRequest.ProtoReflect.Descriptor instead.
func (*GetApiOperationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{19}
}

func (x *GetApiOperationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The [ListApiOperations][google.cloud.apihub.v1.ApiHub.ListApiOperations]
// method's request.
type ListApiOperationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent which owns this collection of operations i.e., the API
	// version. Format:
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. An expression that filters the list of ApiOperations.
	//
	// A filter expression consists of a field name, a comparison
	// operator, and a value for filtering. The value must be a string or a
	// boolean. The comparison operator must be one of: `<`, `>` or
	// `=`. Filters are not case sensitive.
	//
	// The following fields in the `ApiOperation` are eligible for filtering:
	//   - `name` - The ApiOperation resource name. Allowed comparison
	//     operators:
	//     `=`.
	//   - `details.http_operation.path.path` - The http operation's complete path
	//     relative to server endpoint. Allowed comparison operators: `=`.
	//   - `details.http_operation.method` - The http operation method type.
	//     Allowed comparison operators: `=`.
	//   - `details.deprecated` - Indicates if the ApiOperation is deprecated.
	//     Allowed values are True / False indicating the deprycation status of the
	//     ApiOperation. Allowed comparison operators: `=`.
	//   - `create_time` - The time at which the ApiOperation was created. The
	//     value should be in the (RFC3339)[https://tools.ietf.org/html/rfc3339]
	//     format. Allowed comparison operators: `>` and `<`.
	//
	// Expressions are combined with either `AND` logic operator or `OR` logical
	// operator but not both of them together i.e. only one of the `AND` or `OR`
	// operator can be used throughout the filter string and both the operators
	// cannot be used together. No other logical operators are supported. At most
	// three filter fields are allowed in the filter string and if provided
	// more than that then `INVALID_ARGUMENT` error is returned by the API.
	//
	// Here are a few examples:
	//
	//   - `details.deprecated = True` -  The ApiOperation is deprecated.
	//   - `details.http_operation.method = GET AND create_time <
	//     \"2021-08-15T14:50:00Z\" AND create_time > \"2021-08-10T12:00:00Z\"` -
	//     The method of the http operation of the ApiOperation is _GET_ and the
	//     spec was created before _2021-08-15 14:50:00 UTC_ and after _2021-08-10
	//     12:00:00 UTC_.
	//   - `details.http_operation.method = GET OR details.http_operation.method =
	//     POST`. - The http operation of the method of ApiOperation is _GET_ or
	//     _POST_.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The maximum number of operations to return. The service may
	// return fewer than this value. If unspecified, at most 50 operations will be
	// returned. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListApiOperations` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters (except page_size) provided to
	// `ListApiOperations` must match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListApiOperationsRequest) Reset() {
	*x = ListApiOperationsRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListApiOperationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListApiOperationsRequest) ProtoMessage() {}

func (x *ListApiOperationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListApiOperationsRequest.ProtoReflect.Descriptor instead.
func (*ListApiOperationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{20}
}

func (x *ListApiOperationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListApiOperationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListApiOperationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListApiOperationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The [ListApiOperations][google.cloud.apihub.v1.ApiHub.ListApiOperations]
// method's response.
type ListApiOperationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The operations corresponding to an API version.
	// Only following field will be populated in the response: name,
	// spec, details.deprecated, details.http_operation.path.path,
	// details.http_operation.method and details.documentation.external_uri.
	ApiOperations []*ApiOperation `protobuf:"bytes,1,rep,name=api_operations,json=apiOperations,proto3" json:"api_operations,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListApiOperationsResponse) Reset() {
	*x = ListApiOperationsResponse{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListApiOperationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListApiOperationsResponse) ProtoMessage() {}

func (x *ListApiOperationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListApiOperationsResponse.ProtoReflect.Descriptor instead.
func (*ListApiOperationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{21}
}

func (x *ListApiOperationsResponse) GetApiOperations() []*ApiOperation {
	if x != nil {
		return x.ApiOperations
	}
	return nil
}

func (x *ListApiOperationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The [GetDefinition][google.cloud.apihub.v1.ApiHub.GetDefinition] method's
// request.
type GetDefinitionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the definition to retrieve.
	// Format:
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}/definitions/{definition}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDefinitionRequest) Reset() {
	*x = GetDefinitionRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDefinitionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDefinitionRequest) ProtoMessage() {}

func (x *GetDefinitionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDefinitionRequest.ProtoReflect.Descriptor instead.
func (*GetDefinitionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{22}
}

func (x *GetDefinitionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The [CreateDeployment][google.cloud.apihub.v1.ApiHub.CreateDeployment]
// method's request.
type CreateDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource for the deployment resource.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The ID to use for the deployment resource, which will become the
	// final component of the deployment's resource name. This field is optional.
	//
	// * If provided, the same will be used. The service will throw an error if
	// the specified id is already used by another deployment resource in the API
	// hub.
	// * If not provided, a system generated id will be used.
	//
	// This value should be 4-500 characters, and valid characters
	// are /[a-z][A-Z][0-9]-_/.
	DeploymentId string `protobuf:"bytes,2,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	// Required. The deployment resource to create.
	Deployment *Deployment `protobuf:"bytes,3,opt,name=deployment,proto3" json:"deployment,omitempty"`
}

func (x *CreateDeploymentRequest) Reset() {
	*x = CreateDeploymentRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDeploymentRequest) ProtoMessage() {}

func (x *CreateDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDeploymentRequest.ProtoReflect.Descriptor instead.
func (*CreateDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{23}
}

func (x *CreateDeploymentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDeploymentRequest) GetDeploymentId() string {
	if x != nil {
		return x.DeploymentId
	}
	return ""
}

func (x *CreateDeploymentRequest) GetDeployment() *Deployment {
	if x != nil {
		return x.Deployment
	}
	return nil
}

// The [GetDeployment][google.cloud.apihub.v1.ApiHub.GetDeployment] method's
// request.
type GetDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the deployment resource to retrieve.
	// Format: `projects/{project}/locations/{location}/deployments/{deployment}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDeploymentRequest) Reset() {
	*x = GetDeploymentRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDeploymentRequest) ProtoMessage() {}

func (x *GetDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDeploymentRequest.ProtoReflect.Descriptor instead.
func (*GetDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{24}
}

func (x *GetDeploymentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The [UpdateDeployment][google.cloud.apihub.v1.ApiHub.UpdateDeployment]
// method's request.
type UpdateDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The deployment resource to update.
	//
	// The deployment resource's `name` field is used to identify the deployment
	// resource to update.
	// Format: `projects/{project}/locations/{location}/deployments/{deployment}`
	Deployment *Deployment `protobuf:"bytes,1,opt,name=deployment,proto3" json:"deployment,omitempty"`
	// Required. The list of fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDeploymentRequest) Reset() {
	*x = UpdateDeploymentRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDeploymentRequest) ProtoMessage() {}

func (x *UpdateDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDeploymentRequest.ProtoReflect.Descriptor instead.
func (*UpdateDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{25}
}

func (x *UpdateDeploymentRequest) GetDeployment() *Deployment {
	if x != nil {
		return x.Deployment
	}
	return nil
}

func (x *UpdateDeploymentRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The [DeleteDeployment][google.cloud.apihub.v1.ApiHub.DeleteDeployment]
// method's request.
type DeleteDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the deployment resource to delete.
	// Format: `projects/{project}/locations/{location}/deployments/{deployment}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDeploymentRequest) Reset() {
	*x = DeleteDeploymentRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDeploymentRequest) ProtoMessage() {}

func (x *DeleteDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDeploymentRequest.ProtoReflect.Descriptor instead.
func (*DeleteDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{26}
}

func (x *DeleteDeploymentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The [ListDeployments][google.cloud.apihub.v1.ApiHub.ListDeployments] method's
// request.
type ListDeploymentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of deployment resources.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. An expression that filters the list of Deployments.
	//
	// A filter expression consists of a field name, a comparison
	// operator, and a value for filtering. The value must be a string. The
	// comparison operator must be one of: `<`, `>` or
	// `=`. Filters are not case sensitive.
	//
	// The following fields in the `Deployments` are eligible for filtering:
	//
	//   - `display_name` - The display name of the Deployment. Allowed
	//     comparison operators: `=`.
	//   - `create_time` - The time at which the Deployment was created. The
	//     value should be in the (RFC3339)[https://tools.ietf.org/html/rfc3339]
	//     format. Allowed comparison operators: `>` and `<`.
	//   - `resource_uri` - A URI to the deployment resource. Allowed
	//     comparison operators: `=`.
	//   - `api_versions` - The API versions linked to this deployment. Allowed
	//     comparison operators: `:`.
	//   - `deployment_type.enum_values.values.id` - The allowed value id of the
	//     deployment_type attribute associated with the Deployment. Allowed
	//     comparison operators: `:`.
	//   - `deployment_type.enum_values.values.display_name` - The allowed value
	//     display name of the deployment_type attribute associated with the
	//     Deployment. Allowed comparison operators: `:`.
	//   - `slo.string_values.values` -The allowed string value of the slo
	//     attribute associated with the deployment. Allowed comparison
	//     operators: `:`.
	//   - `environment.enum_values.values.id` - The allowed value id of the
	//     environment attribute associated with the deployment. Allowed
	//     comparison operators: `:`.
	//   - `environment.enum_values.values.display_name` - The allowed value
	//     display name of the environment attribute associated with the deployment.
	//     Allowed comparison operators: `:`.
	//
	// Expressions are combined with either `AND` logic operator or `OR` logical
	// operator but not both of them together i.e. only one of the `AND` or `OR`
	// operator can be used throughout the filter string and both the operators
	// cannot be used together. No other logical operators are supported. At most
	// three filter fields are allowed in the filter string and if provided
	// more than that then `INVALID_ARGUMENT` error is returned by the API.
	//
	// Here are a few examples:
	//
	//   - `environment.enum_values.values.id: staging-id` - The allowed value id
	//     of the environment attribute associated with the Deployment is
	//     _staging-id_.
	//   - `environment.enum_values.values.display_name: \"Staging Deployment\"` -
	//     The allowed value display name of the environment attribute associated
	//     with the Deployment is `Staging Deployment`.
	//   - `environment.enum_values.values.id: production-id AND create_time <
	//     \"2021-08-15T14:50:00Z\" AND create_time > \"2021-08-10T12:00:00Z\"` -
	//     The allowed value id of the environment attribute associated with the
	//     Deployment is _production-id_ and Deployment was created before
	//     _2021-08-15 14:50:00 UTC_ and after _2021-08-10 12:00:00 UTC_.
	//   - `environment.enum_values.values.id: production-id OR
	//     slo.string_values.values: \"99.99%\"`
	//   - The allowed value id of the environment attribute Deployment is
	//     _production-id_ or string value of the slo attribute is _99.99%_.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The maximum number of deployment resources to return. The service
	// may return fewer than this value. If unspecified, at most 50 deployments
	// will be returned. The maximum value is 1000; values above 1000 will be
	// coerced to 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListDeployments` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters (except page_size) provided to
	// `ListDeployments` must match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDeploymentsRequest) Reset() {
	*x = ListDeploymentsRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDeploymentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDeploymentsRequest) ProtoMessage() {}

func (x *ListDeploymentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDeploymentsRequest.ProtoReflect.Descriptor instead.
func (*ListDeploymentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{27}
}

func (x *ListDeploymentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDeploymentsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListDeploymentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDeploymentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The [ListDeployments][google.cloud.apihub.v1.ApiHub.ListDeployments] method's
// response.
type ListDeploymentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The deployment resources present in the API hub.
	Deployments []*Deployment `protobuf:"bytes,1,rep,name=deployments,proto3" json:"deployments,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDeploymentsResponse) Reset() {
	*x = ListDeploymentsResponse{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDeploymentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDeploymentsResponse) ProtoMessage() {}

func (x *ListDeploymentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDeploymentsResponse.ProtoReflect.Descriptor instead.
func (*ListDeploymentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{28}
}

func (x *ListDeploymentsResponse) GetDeployments() []*Deployment {
	if x != nil {
		return x.Deployments
	}
	return nil
}

func (x *ListDeploymentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The [CreateAttribute][google.cloud.apihub.v1.ApiHub.CreateAttribute] method's
// request.
type CreateAttributeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource for Attribute.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The ID to use for the attribute, which will become the final
	// component of the attribute's resource name. This field is optional.
	//
	// * If provided, the same will be used. The service will throw an error if
	// the specified id is already used by another attribute resource in the API
	// hub.
	// * If not provided, a system generated id will be used.
	//
	// This value should be 4-500 characters, and valid characters
	// are /[a-z][A-Z][0-9]-_/.
	AttributeId string `protobuf:"bytes,2,opt,name=attribute_id,json=attributeId,proto3" json:"attribute_id,omitempty"`
	// Required. The attribute to create.
	Attribute *Attribute `protobuf:"bytes,3,opt,name=attribute,proto3" json:"attribute,omitempty"`
}

func (x *CreateAttributeRequest) Reset() {
	*x = CreateAttributeRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateAttributeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAttributeRequest) ProtoMessage() {}

func (x *CreateAttributeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAttributeRequest.ProtoReflect.Descriptor instead.
func (*CreateAttributeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{29}
}

func (x *CreateAttributeRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAttributeRequest) GetAttributeId() string {
	if x != nil {
		return x.AttributeId
	}
	return ""
}

func (x *CreateAttributeRequest) GetAttribute() *Attribute {
	if x != nil {
		return x.Attribute
	}
	return nil
}

// The [GetAttribute][google.cloud.apihub.v1.ApiHub.GetAttribute] method's
// request.
type GetAttributeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the attribute to retrieve.
	// Format:
	// `projects/{project}/locations/{location}/attributes/{attribute}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAttributeRequest) Reset() {
	*x = GetAttributeRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetAttributeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAttributeRequest) ProtoMessage() {}

func (x *GetAttributeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAttributeRequest.ProtoReflect.Descriptor instead.
func (*GetAttributeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{30}
}

func (x *GetAttributeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The [UpdateAttribute][google.cloud.apihub.v1.ApiHub.UpdateAttribute] method's
// request.
type UpdateAttributeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The attribute to update.
	//
	// The attribute's `name` field is used to identify the attribute to update.
	// Format:
	// `projects/{project}/locations/{location}/attributes/{attribute}`
	Attribute *Attribute `protobuf:"bytes,1,opt,name=attribute,proto3" json:"attribute,omitempty"`
	// Required. The list of fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAttributeRequest) Reset() {
	*x = UpdateAttributeRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateAttributeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAttributeRequest) ProtoMessage() {}

func (x *UpdateAttributeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAttributeRequest.ProtoReflect.Descriptor instead.
func (*UpdateAttributeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{31}
}

func (x *UpdateAttributeRequest) GetAttribute() *Attribute {
	if x != nil {
		return x.Attribute
	}
	return nil
}

func (x *UpdateAttributeRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The [DeleteAttribute][google.cloud.apihub.v1.ApiHub.DeleteAttribute] method's
// request.
type DeleteAttributeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the attribute to delete.
	// Format:
	// `projects/{project}/locations/{location}/attributes/{attribute}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAttributeRequest) Reset() {
	*x = DeleteAttributeRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteAttributeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAttributeRequest) ProtoMessage() {}

func (x *DeleteAttributeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAttributeRequest.ProtoReflect.Descriptor instead.
func (*DeleteAttributeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{32}
}

func (x *DeleteAttributeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The [ListAttributes][google.cloud.apihub.v1.ApiHub.ListAttributes] method's
// request.
type ListAttributesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource for Attribute.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. An expression that filters the list of Attributes.
	//
	// A filter expression consists of a field name, a comparison
	// operator, and a value for filtering. The value must be a string or a
	// boolean. The comparison operator must be one of: `<`, `>` or
	// `=`. Filters are not case sensitive.
	//
	// The following fields in the `Attribute` are eligible for filtering:
	//
	//   - `display_name` - The display name of the Attribute. Allowed
	//     comparison operators: `=`.
	//   - `definition_type` - The definition type of the attribute. Allowed
	//     comparison operators: `=`.
	//   - `scope` - The scope of the attribute. Allowed comparison operators:
	//     `=`.
	//   - `data_type` - The type of the data of the attribute. Allowed
	//     comparison operators: `=`.
	//   - `mandatory` - Denotes whether the attribute is mandatory or not.
	//     Allowed comparison operators: `=`.
	//   - `create_time` - The time at which the Attribute was created. The
	//     value should be in the (RFC3339)[https://tools.ietf.org/html/rfc3339]
	//     format. Allowed comparison operators: `>` and `<`.
	//
	// Expressions are combined with either `AND` logic operator or `OR` logical
	// operator but not both of them together i.e. only one of the `AND` or `OR`
	// operator can be used throughout the filter string and both the operators
	// cannot be used together. No other logical operators are
	// supported. At most three filter fields are allowed in the filter
	// string and if provided more than that then `INVALID_ARGUMENT` error is
	// returned by the API.
	//
	// Here are a few examples:
	//
	//   - `display_name = production` -  - The display name of the attribute is
	//     _production_.
	//   - `(display_name = production) AND (create_time <
	//     \"2021-08-15T14:50:00Z\") AND (create_time > \"2021-08-10T12:00:00Z\")` -
	//     The display name of the attribute is _production_ and the attribute was
	//     created before _2021-08-15 14:50:00 UTC_ and after _2021-08-10 12:00:00
	//     UTC_.
	//   - `display_name = production OR scope = api` -
	//     The attribute where the display name is _production_ or the scope is
	//     _api_.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The maximum number of attribute resources to return. The service
	// may return fewer than this value. If unspecified, at most 50 attributes
	// will be returned. The maximum value is 1000; values above 1000 will be
	// coerced to 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListAttributes` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListAttributes` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAttributesRequest) Reset() {
	*x = ListAttributesRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAttributesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAttributesRequest) ProtoMessage() {}

func (x *ListAttributesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAttributesRequest.ProtoReflect.Descriptor instead.
func (*ListAttributesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{33}
}

func (x *ListAttributesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAttributesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListAttributesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAttributesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The [ListAttributes][google.cloud.apihub.v1.ApiHub.ListAttributes] method's
// response.
type ListAttributesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of all attributes.
	Attributes []*Attribute `protobuf:"bytes,1,rep,name=attributes,proto3" json:"attributes,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAttributesResponse) Reset() {
	*x = ListAttributesResponse{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAttributesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAttributesResponse) ProtoMessage() {}

func (x *ListAttributesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAttributesResponse.ProtoReflect.Descriptor instead.
func (*ListAttributesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{34}
}

func (x *ListAttributesResponse) GetAttributes() []*Attribute {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *ListAttributesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The [SearchResources][google.cloud.apihub.v1.ApiHub.SearchResources] method's
// request.
type SearchResourcesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the location which will be of the type
	// `projects/{project_id}/locations/{location_id}`. This field is used to
	// identify the instance of API-Hub in which resources should be searched.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// Required. The free text search query. This query can contain keywords which
	// could be related to any detail of the API-Hub resources such display names,
	// descriptions, attributes etc.
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Optional. An expression that filters the list of search results.
	//
	// A filter expression consists of a field name, a comparison operator,
	// and a value for filtering. The value must be a string, a number, or a
	// boolean. The comparison operator must be `=`. Filters are not case
	// sensitive.
	//
	// The following field names are eligible for filtering:
	//   - `resource_type` - The type of resource in the search results.
	//     Must be one of the following: `Api`, `ApiOperation`, `Deployment`,
	//     `Definition`, `Spec` or `Version`. This field can only be specified once
	//     in the filter.
	//
	// Here are is an example:
	//
	//   - `resource_type = Api` - The resource_type is _Api_.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The maximum number of search results to return. The service may
	// return fewer than this value. If unspecified at most 10 search results will
	// be returned. If value is negative then `INVALID_ARGUMENT` error is
	// returned. The maximum value is 25; values above 25 will be coerced to 25.
	// While paginating, you can specify a new page size parameter for each page
	// of search results to be listed.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous
	// [SearchResources][SearchResources]
	// call. Specify this parameter to retrieve the next page of transactions.
	//
	// When paginating, you must specify the `page_token` parameter and all the
	// other parameters except
	// [page_size][google.cloud.apihub.v1.SearchResourcesRequest.page_size]
	// should be specified with the same value which was used in the previous
	// call. If the other fields are set with a different value than the previous
	// call then `INVALID_ARGUMENT` error is returned.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchResourcesRequest) Reset() {
	*x = SearchResourcesRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchResourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResourcesRequest) ProtoMessage() {}

func (x *SearchResourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResourcesRequest.ProtoReflect.Descriptor instead.
func (*SearchResourcesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{35}
}

func (x *SearchResourcesRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *SearchResourcesRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchResourcesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *SearchResourcesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchResourcesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// ApiHubResource is one of the resources such as Api, Operation, Deployment,
// Definition, Spec and Version resources stored in API-Hub.
type ApiHubResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Resource:
	//
	//	*ApiHubResource_Api
	//	*ApiHubResource_Operation
	//	*ApiHubResource_Deployment
	//	*ApiHubResource_Spec
	//	*ApiHubResource_Definition
	//	*ApiHubResource_Version
	Resource isApiHubResource_Resource `protobuf_oneof:"resource"`
}

func (x *ApiHubResource) Reset() {
	*x = ApiHubResource{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApiHubResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApiHubResource) ProtoMessage() {}

func (x *ApiHubResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApiHubResource.ProtoReflect.Descriptor instead.
func (*ApiHubResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{36}
}

func (m *ApiHubResource) GetResource() isApiHubResource_Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (x *ApiHubResource) GetApi() *Api {
	if x, ok := x.GetResource().(*ApiHubResource_Api); ok {
		return x.Api
	}
	return nil
}

func (x *ApiHubResource) GetOperation() *ApiOperation {
	if x, ok := x.GetResource().(*ApiHubResource_Operation); ok {
		return x.Operation
	}
	return nil
}

func (x *ApiHubResource) GetDeployment() *Deployment {
	if x, ok := x.GetResource().(*ApiHubResource_Deployment); ok {
		return x.Deployment
	}
	return nil
}

func (x *ApiHubResource) GetSpec() *Spec {
	if x, ok := x.GetResource().(*ApiHubResource_Spec); ok {
		return x.Spec
	}
	return nil
}

func (x *ApiHubResource) GetDefinition() *Definition {
	if x, ok := x.GetResource().(*ApiHubResource_Definition); ok {
		return x.Definition
	}
	return nil
}

func (x *ApiHubResource) GetVersion() *Version {
	if x, ok := x.GetResource().(*ApiHubResource_Version); ok {
		return x.Version
	}
	return nil
}

type isApiHubResource_Resource interface {
	isApiHubResource_Resource()
}

type ApiHubResource_Api struct {
	// This represents Api resource in search results. Only name, display_name,
	// description and owner fields are populated in search results.
	Api *Api `protobuf:"bytes,1,opt,name=api,proto3,oneof"`
}

type ApiHubResource_Operation struct {
	// This represents ApiOperation resource in search results. Only name,
	// and description fields are populated in search results.
	Operation *ApiOperation `protobuf:"bytes,2,opt,name=operation,proto3,oneof"`
}

type ApiHubResource_Deployment struct {
	// This represents Deployment resource in search results. Only name,
	// display_name and description fields are populated in search results.
	Deployment *Deployment `protobuf:"bytes,3,opt,name=deployment,proto3,oneof"`
}

type ApiHubResource_Spec struct {
	// This represents Spec resource in search results. Only name,
	// display_name and description fields are populated in search results.
	Spec *Spec `protobuf:"bytes,4,opt,name=spec,proto3,oneof"`
}

type ApiHubResource_Definition struct {
	// This represents Definition resource in search results.
	// Only name field is populated in search results.
	Definition *Definition `protobuf:"bytes,5,opt,name=definition,proto3,oneof"`
}

type ApiHubResource_Version struct {
	// This represents Version resource in search results. Only name,
	// display_name and description fields are populated in search results.
	Version *Version `protobuf:"bytes,6,opt,name=version,proto3,oneof"`
}

func (*ApiHubResource_Api) isApiHubResource_Resource() {}

func (*ApiHubResource_Operation) isApiHubResource_Resource() {}

func (*ApiHubResource_Deployment) isApiHubResource_Resource() {}

func (*ApiHubResource_Spec) isApiHubResource_Resource() {}

func (*ApiHubResource_Definition) isApiHubResource_Resource() {}

func (*ApiHubResource_Version) isApiHubResource_Resource() {}

// Represents the search results.
type SearchResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This represents the ApiHubResource.
	// Note: Only selected fields of the resources are populated in response.
	Resource *ApiHubResource `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
}

func (x *SearchResult) Reset() {
	*x = SearchResult{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResult) ProtoMessage() {}

func (x *SearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResult.ProtoReflect.Descriptor instead.
func (*SearchResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{37}
}

func (x *SearchResult) GetResource() *ApiHubResource {
	if x != nil {
		return x.Resource
	}
	return nil
}

// Response for the
// [SearchResources][google.cloud.apihub.v1.ApiHub.SearchResources] method.
type SearchResourcesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of search results according to the filter and search query specified.
	// The order of search results represents the ranking.
	SearchResults []*SearchResult `protobuf:"bytes,1,rep,name=search_results,json=searchResults,proto3" json:"search_results,omitempty"`
	// Pass this token in the
	// [SearchResourcesRequest][google.cloud.apihub.v1.SearchResourcesRequest]
	// to continue to list results. If all results have been returned, this field
	// is an empty string or not present in the response.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchResourcesResponse) Reset() {
	*x = SearchResourcesResponse{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchResourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResourcesResponse) ProtoMessage() {}

func (x *SearchResourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResourcesResponse.ProtoReflect.Descriptor instead.
func (*SearchResourcesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{38}
}

func (x *SearchResourcesResponse) GetSearchResults() []*SearchResult {
	if x != nil {
		return x.SearchResults
	}
	return nil
}

func (x *SearchResourcesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The
// [CreateDependency][google.cloud.apihub.v1.ApiHubDependencies.CreateDependency]
// method's request.
type CreateDependencyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource for the dependency resource.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The ID to use for the dependency resource, which will become the
	// final component of the dependency's resource name. This field is optional.
	// * If provided, the same will be used. The service will throw an error if
	// duplicate id is provided by the client.
	// * If not provided, a system generated id will be used.
	//
	// This value should be 4-500 characters, and valid characters
	// are `[a-z][A-Z][0-9]-_`.
	DependencyId string `protobuf:"bytes,2,opt,name=dependency_id,json=dependencyId,proto3" json:"dependency_id,omitempty"`
	// Required. The dependency resource to create.
	Dependency *Dependency `protobuf:"bytes,3,opt,name=dependency,proto3" json:"dependency,omitempty"`
}

func (x *CreateDependencyRequest) Reset() {
	*x = CreateDependencyRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateDependencyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDependencyRequest) ProtoMessage() {}

func (x *CreateDependencyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDependencyRequest.ProtoReflect.Descriptor instead.
func (*CreateDependencyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{39}
}

func (x *CreateDependencyRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDependencyRequest) GetDependencyId() string {
	if x != nil {
		return x.DependencyId
	}
	return ""
}

func (x *CreateDependencyRequest) GetDependency() *Dependency {
	if x != nil {
		return x.Dependency
	}
	return nil
}

// The [GetDependency][.ApiHubDependencies.GetDependency]
// method's request.
type GetDependencyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the dependency resource to retrieve.
	// Format: `projects/{project}/locations/{location}/dependencies/{dependency}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDependencyRequest) Reset() {
	*x = GetDependencyRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDependencyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDependencyRequest) ProtoMessage() {}

func (x *GetDependencyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDependencyRequest.ProtoReflect.Descriptor instead.
func (*GetDependencyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{40}
}

func (x *GetDependencyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The
// [UpdateDependency][google.cloud.apihub.v1.ApiHubDependencies.UpdateDependency]
// method's request.
type UpdateDependencyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The dependency resource to update.
	//
	// The dependency's `name` field is used to identify the dependency to update.
	// Format: `projects/{project}/locations/{location}/dependencies/{dependency}`
	Dependency *Dependency `protobuf:"bytes,1,opt,name=dependency,proto3" json:"dependency,omitempty"`
	// Required. The list of fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDependencyRequest) Reset() {
	*x = UpdateDependencyRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateDependencyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDependencyRequest) ProtoMessage() {}

func (x *UpdateDependencyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDependencyRequest.ProtoReflect.Descriptor instead.
func (*UpdateDependencyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{41}
}

func (x *UpdateDependencyRequest) GetDependency() *Dependency {
	if x != nil {
		return x.Dependency
	}
	return nil
}

func (x *UpdateDependencyRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The
// [DeleteDependency][google.cloud.apihub.v1.ApiHubDependencies.DeleteDependency]
// method's request.
type DeleteDependencyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the dependency resource to delete.
	// Format: `projects/{project}/locations/{location}/dependencies/{dependency}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDependencyRequest) Reset() {
	*x = DeleteDependencyRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteDependencyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDependencyRequest) ProtoMessage() {}

func (x *DeleteDependencyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDependencyRequest.ProtoReflect.Descriptor instead.
func (*DeleteDependencyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{42}
}

func (x *DeleteDependencyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The
// [ListDependencies][google.cloud.apihub.v1.ApiHubDependencies.ListDependencies]
// method's request.
type ListDependenciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent which owns this collection of dependency resources.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. An expression that filters the list of Dependencies.
	//
	// A filter expression consists of a field name, a comparison operator, and
	// a value for filtering. The value must be a string. Allowed comparison
	// operator is `=`. Filters are not case sensitive.
	//
	// The following fields in the `Dependency` are eligible for filtering:
	//
	//   - `consumer.operation_resource_name` - The operation resource name for
	//     the consumer entity involved in a dependency. Allowed comparison
	//     operators: `=`.
	//   - `consumer.external_api_resource_name` - The external api resource name
	//     for the consumer entity involved in a dependency. Allowed comparison
	//     operators: `=`.
	//   - `supplier.operation_resource_name` - The operation resource name for
	//     the supplier entity involved in a dependency. Allowed comparison
	//     operators: `=`.
	//   - `supplier.external_api_resource_name` - The external api resource name
	//     for the supplier entity involved in a dependency. Allowed comparison
	//     operators: `=`.
	//
	// Expressions are combined with either `AND` logic operator or `OR` logical
	// operator but not both of them together i.e. only one of the `AND` or `OR`
	// operator can be used throughout the filter string and both the operators
	// cannot be used together. No other logical operators are supported. At most
	// three filter fields are allowed in the filter string and if provided
	// more than that then `INVALID_ARGUMENT` error is returned by the API.
	//
	// For example, `consumer.operation_resource_name =
	// \"projects/p1/locations/global/apis/a1/versions/v1/operations/o1\" OR
	// supplier.operation_resource_name =
	// \"projects/p1/locations/global/apis/a1/versions/v1/operations/o1\"` - The
	// dependencies with either consumer or supplier operation resource name as
	// _projects/p1/locations/global/apis/a1/versions/v1/operations/o1_.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The maximum number of dependency resources to return. The service
	// may return fewer than this value. If unspecified, at most 50 dependencies
	// will be returned. The maximum value is 1000; values above 1000 will be
	// coerced to 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListDependencies` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListDependencies` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDependenciesRequest) Reset() {
	*x = ListDependenciesRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDependenciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDependenciesRequest) ProtoMessage() {}

func (x *ListDependenciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDependenciesRequest.ProtoReflect.Descriptor instead.
func (*ListDependenciesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{43}
}

func (x *ListDependenciesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDependenciesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListDependenciesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDependenciesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The
// [ListDependencies][google.cloud.apihub.v1.ApiHubDependencies.ListDependencies]
// method's response.
type ListDependenciesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The dependency resources present in the API hub.
	// Only following field will be populated in the response: name.
	Dependencies []*Dependency `protobuf:"bytes,1,rep,name=dependencies,proto3" json:"dependencies,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDependenciesResponse) Reset() {
	*x = ListDependenciesResponse{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDependenciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDependenciesResponse) ProtoMessage() {}

func (x *ListDependenciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDependenciesResponse.ProtoReflect.Descriptor instead.
func (*ListDependenciesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{44}
}

func (x *ListDependenciesResponse) GetDependencies() []*Dependency {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

func (x *ListDependenciesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The [CreateExternalApi][google.cloud.apihub.v1.ApiHub.CreateExternalApi]
// method's request.
type CreateExternalApiRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource for the External API resource.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The ID to use for the External API resource, which will become
	// the final component of the External API's resource name. This field is
	// optional.
	//
	// * If provided, the same will be used. The service will throw an error if
	// the specified id is already used by another External API resource in the
	// API hub.
	// * If not provided, a system generated id will be used.
	//
	// This value should be 4-500 characters, and valid characters
	// are /[a-z][A-Z][0-9]-_/.
	ExternalApiId string `protobuf:"bytes,2,opt,name=external_api_id,json=externalApiId,proto3" json:"external_api_id,omitempty"`
	// Required. The External API resource to create.
	ExternalApi *ExternalApi `protobuf:"bytes,3,opt,name=external_api,json=externalApi,proto3" json:"external_api,omitempty"`
}

func (x *CreateExternalApiRequest) Reset() {
	*x = CreateExternalApiRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateExternalApiRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateExternalApiRequest) ProtoMessage() {}

func (x *CreateExternalApiRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateExternalApiRequest.ProtoReflect.Descriptor instead.
func (*CreateExternalApiRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{45}
}

func (x *CreateExternalApiRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateExternalApiRequest) GetExternalApiId() string {
	if x != nil {
		return x.ExternalApiId
	}
	return ""
}

func (x *CreateExternalApiRequest) GetExternalApi() *ExternalApi {
	if x != nil {
		return x.ExternalApi
	}
	return nil
}

// The [GetExternalApi][google.cloud.apihub.v1.ApiHub.GetExternalApi] method's
// request.
type GetExternalApiRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the External API resource to retrieve.
	// Format:
	// `projects/{project}/locations/{location}/externalApis/{externalApi}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetExternalApiRequest) Reset() {
	*x = GetExternalApiRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetExternalApiRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetExternalApiRequest) ProtoMessage() {}

func (x *GetExternalApiRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetExternalApiRequest.ProtoReflect.Descriptor instead.
func (*GetExternalApiRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{46}
}

func (x *GetExternalApiRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The [UpdateExternalApi][google.cloud.apihub.v1.ApiHub.UpdateExternalApi]
// method's request.
type UpdateExternalApiRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The External API resource to update.
	//
	// The External API resource's `name` field is used to identify the External
	// API resource to update. Format:
	// `projects/{project}/locations/{location}/externalApis/{externalApi}`
	ExternalApi *ExternalApi `protobuf:"bytes,1,opt,name=external_api,json=externalApi,proto3" json:"external_api,omitempty"`
	// Required. The list of fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateExternalApiRequest) Reset() {
	*x = UpdateExternalApiRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateExternalApiRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateExternalApiRequest) ProtoMessage() {}

func (x *UpdateExternalApiRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateExternalApiRequest.ProtoReflect.Descriptor instead.
func (*UpdateExternalApiRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{47}
}

func (x *UpdateExternalApiRequest) GetExternalApi() *ExternalApi {
	if x != nil {
		return x.ExternalApi
	}
	return nil
}

func (x *UpdateExternalApiRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The [DeleteExternalApi][google.cloud.apihub.v1.ApiHub.DeleteExternalApi]
// method's request.
type DeleteExternalApiRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the External API resource to delete.
	// Format:
	// `projects/{project}/locations/{location}/externalApis/{externalApi}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteExternalApiRequest) Reset() {
	*x = DeleteExternalApiRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteExternalApiRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteExternalApiRequest) ProtoMessage() {}

func (x *DeleteExternalApiRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteExternalApiRequest.ProtoReflect.Descriptor instead.
func (*DeleteExternalApiRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{48}
}

func (x *DeleteExternalApiRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The [ListExternalApis][google.cloud.apihub.v1.ApiHub.ListExternalApis]
// method's request.
type ListExternalApisRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of External API resources.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of External API resources to return. The
	// service may return fewer than this value. If unspecified, at most 50
	// ExternalApis will be returned. The maximum value is 1000; values above 1000
	// will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListExternalApis` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters (except page_size) provided to
	// `ListExternalApis` must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListExternalApisRequest) Reset() {
	*x = ListExternalApisRequest{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListExternalApisRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListExternalApisRequest) ProtoMessage() {}

func (x *ListExternalApisRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListExternalApisRequest.ProtoReflect.Descriptor instead.
func (*ListExternalApisRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{49}
}

func (x *ListExternalApisRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListExternalApisRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListExternalApisRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The [ListExternalApis][google.cloud.apihub.v1.ApiHub.ListExternalApis]
// method's response.
type ListExternalApisResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The External API resources present in the API hub.
	// Only following fields will be populated in the response: name,
	// display_name, documentation.external_uri.
	ExternalApis []*ExternalApi `protobuf:"bytes,1,rep,name=external_apis,json=externalApis,proto3" json:"external_apis,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListExternalApisResponse) Reset() {
	*x = ListExternalApisResponse{}
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListExternalApisResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListExternalApisResponse) ProtoMessage() {}

func (x *ListExternalApisResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListExternalApisResponse.ProtoReflect.Descriptor instead.
func (*ListExternalApisResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP(), []int{50}
}

func (x *ListExternalApisResponse) GetExternalApis() []*ExternalApi {
	if x != nil {
		return x.ExternalApis
	}
	return nil
}

func (x *ListExternalApisResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_cloud_apihub_v1_apihub_service_proto protoreflect.FileDescriptor

var file_google_cloud_apihub_v1_apihub_service_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x70, 0x69, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x31,
	0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x9d, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x70,
	0x69, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x21, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1b,
	0x12, 0x19, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x70, 0x69, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x1a, 0x0a, 0x06, 0x61, 0x70, 0x69, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x61, 0x70, 0x69, 0x49, 0x64, 0x12,
	0x32, 0x0a, 0x03, 0x61, 0x70, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x69, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03,
	0x61, 0x70, 0x69, 0x22, 0x46, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x41, 0x70, 0x69, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x35, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x21, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1b, 0x0a, 0x19, 0x61, 0x70, 0x69, 0x68,
	0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x70, 0x69, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x88, 0x01, 0x0a, 0x10,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x70, 0x69, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x32, 0x0a, 0x03, 0x61, 0x70, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x69, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x03, 0x61, 0x70, 0x69, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x64, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x41, 0x70, 0x69, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x35, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x21, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1b,
	0x0a, 0x19, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x70, 0x69, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xaf, 0x01, 0x0a,
	0x0f, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x70, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x39, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x21, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1b, 0x12, 0x19, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x70, 0x69, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x6b,
	0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x70, 0x69, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x2f, 0x0a, 0x04, 0x61, 0x70, 0x69, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x69, 0x52, 0x04, 0x61,
	0x70, 0x69, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb5, 0x01, 0x0a, 0x14,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x21, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1b, 0x0a, 0x19, 0x61, 0x70,
	0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x70, 0x69, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x22, 0x0a, 0x0a, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x12, 0x3e, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x22, 0x4e, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d,
	0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x98, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x6c,
	0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x61, 0x70,
	0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xb7, 0x01, 0x0a,
	0x13, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x12, 0x1d, 0x61, 0x70,
	0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x7b, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3b,
	0x0a, 0x08, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x08, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xa7, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x70,
	0x65, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x1f, 0x0a, 0x1d, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1c, 0x0a, 0x07, 0x73, 0x70, 0x65, 0x63,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x73, 0x70, 0x65, 0x63, 0x49, 0x64, 0x12, 0x35, 0x0a, 0x04, 0x73, 0x70, 0x65, 0x63, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70,
	0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x73, 0x70, 0x65, 0x63, 0x22, 0x48, 0x0a,
	0x0e, 0x47, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x36, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x1c, 0x0a, 0x1a, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x65,
	0x63, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x8c, 0x01, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x35, 0x0a,
	0x04, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04,
	0x73, 0x70, 0x65, 0x63, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x4b, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x53, 0x70, 0x65, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x36, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x1c, 0x0a, 0x1a, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x65, 0x63, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xb1, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1c,
	0x12, 0x1a, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x65, 0x63, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x6f, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x53,
	0x70, 0x65, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x32, 0x0a, 0x05,
	0x73, 0x70, 0x65, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x05, 0x73, 0x70, 0x65, 0x63, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x50, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x53,
	0x70, 0x65, 0x63, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x36, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x22, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1c, 0x0a, 0x1a, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x70, 0x65, 0x63, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x58, 0x0a, 0x16, 0x47, 0x65,
	0x74, 0x41, 0x70, 0x69, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x61, 0x70, 0x69, 0x68,
	0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x70, 0x69, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc1, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x70, 0x69,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12, 0x22, 0x61, 0x70, 0x69, 0x68, 0x75,
	0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x70, 0x69, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x90, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x70, 0x69, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x0e, 0x61, 0x70, 0x69, 0x5f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70,
	0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x69, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x61, 0x70, 0x69, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x54, 0x0a, 0x14, 0x47,
	0x65, 0x74, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x61, 0x70, 0x69, 0x68, 0x75,
	0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xce, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x22, 0x12, 0x20, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x28, 0x0a, 0x0d, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x47, 0x0a, 0x0a, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x22, 0x54, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22,
	0x0a, 0x20, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa4, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22,
	0x57, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22,
	0x0a, 0x20, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbd, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73,
	0x74, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x12, 0x20, 0x61, 0x70, 0x69,
	0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x87, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73,
	0x74, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x0b, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0xc7, 0x01, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x21, 0x12, 0x1f, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x26,
	0x0a, 0x0c, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x49, 0x64, 0x12, 0x44, 0x0a, 0x09, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x09, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x22, 0x52, 0x0a, 0x13,
	0x47, 0x65, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x61, 0x70, 0x69, 0x68, 0x75,
	0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xa0, 0x01, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x09, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70,
	0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x22, 0x55, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbb, 0x01, 0x0a, 0x15, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x12, 0x1f, 0x61, 0x70,
	0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x83, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xdd,
	0x01, 0x0a, 0x16, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x08, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x19, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1b, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x90,
	0x03, 0x0a, 0x0e, 0x41, 0x70, 0x69, 0x48, 0x75, 0x62, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x2f, 0x0a, 0x03, 0x61, 0x70, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70,
	0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x69, 0x48, 0x00, 0x52, 0x03, 0x61,
	0x70, 0x69, 0x12, 0x44, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x70, 0x69, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x09, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x48, 0x00, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x32,
	0x0a, 0x04, 0x73, 0x70, 0x65, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x04, 0x73, 0x70,
	0x65, 0x63, 0x12, 0x44, 0x0a, 0x0a, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0a, 0x64, 0x65,
	0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x0a, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x22, 0x52, 0x0a, 0x0c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0x42, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x69,
	0x48, 0x75, 0x62, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x08, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x8e, 0x01, 0x0a, 0x17, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x4b, 0x0a, 0x0e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52,
	0x0d, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xce, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x12, 0x20, 0x61, 0x70, 0x69, 0x68,
	0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x0d, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e,
	0x63, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x49, 0x64, 0x12, 0x47,
	0x0a, 0x0a, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64, 0x65, 0x70,
	0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x22, 0x54, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x44, 0x65,
	0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70,
	0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa4, 0x01,
	0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e,
	0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x0a, 0x64, 0x65, 0x70,
	0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e,
	0x63, 0x79, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x22, 0x57, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x65,
	0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70,
	0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbe, 0x01,
	0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x22, 0x12, 0x20, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65,
	0x6e, 0x63, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8a,
	0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x0c, 0x64,
	0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x65, 0x6e,
	0x64, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63,
	0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xd7, 0x01, 0x0a, 0x18,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70,
	0x69, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23,
	0x12, 0x21, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x41, 0x70, 0x69, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x0f, 0x65,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x65, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x49, 0x64, 0x12, 0x4b, 0x0a, 0x0c, 0x65, 0x78, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x61, 0x70, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70,
	0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x41, 0x70, 0x69, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x41, 0x70, 0x69, 0x22, 0x56, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x45, 0x78, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x78, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa9, 0x01,
	0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x41, 0x70, 0x69, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x0c, 0x65, 0x78,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x61, 0x70, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x41, 0x70, 0x69, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x65, 0x78, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x59, 0x0a, 0x18, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x70, 0x69,
	0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa2, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x78, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x12, 0x21, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8c, 0x01, 0x0a, 0x18, 0x4c, 0x69,
	0x73, 0x74, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x0d, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x5f, 0x61, 0x70, 0x69, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41,
	0x70, 0x69, 0x52, 0x0c, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x32, 0xba, 0x31, 0x0a, 0x06, 0x41, 0x70, 0x69,
	0x48, 0x75, 0x62, 0x12, 0x9d, 0x01, 0x0a, 0x09, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x70,
	0x69, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x41, 0x70, 0x69, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x69, 0x22, 0x49, 0xda, 0x41, 0x11, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x2c, 0x61, 0x70, 0x69, 0x2c, 0x61, 0x70, 0x69, 0x5f, 0x69, 0x64, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2f, 0x3a, 0x03, 0x61, 0x70, 0x69, 0x22, 0x28, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61,
	0x70, 0x69, 0x73, 0x12, 0x85, 0x01, 0x0a, 0x06, 0x47, 0x65, 0x74, 0x41, 0x70, 0x69, 0x12, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70,
	0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x70, 0x69, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x70, 0x69, 0x22, 0x37, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x2a, 0x12, 0x28, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x98, 0x01, 0x0a, 0x08,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x70, 0x69, 0x73, 0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x70, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x70, 0x69, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x39, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x12, 0x28, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x12, 0x9f, 0x01, 0x0a, 0x09, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x41, 0x70, 0x69, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x41, 0x70, 0x69, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70,
	0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x69, 0x22, 0x4b, 0xda, 0x41, 0x0f,
	0x61, 0x70, 0x69, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x33, 0x3a, 0x03, 0x61, 0x70, 0x69, 0x32, 0x2c, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x61, 0x70, 0x69, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x86, 0x01, 0x0a, 0x09, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x41, 0x70, 0x69, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x70, 0x69, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x37, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x2a, 0x28, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xc0, 0x01, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x22, 0x60, 0xda, 0x41, 0x19, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2c, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x3a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x9c, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70,
	0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0x42, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x12, 0x33,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xaf, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x44, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35,
	0x12, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xc2, 0x01, 0x0a, 0x0d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x62, 0xda, 0x41, 0x13, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x46, 0x3a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x32, 0x3b, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x2a, 0x2f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x99, 0x01, 0x0a, 0x0d, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x22, 0x42, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x35, 0x2a, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb6, 0x01, 0x0a, 0x0a, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x63, 0x22, 0x5f,
	0xda, 0x41, 0x13, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x70, 0x65, 0x63, 0x2c, 0x73,
	0x70, 0x65, 0x63, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x3a, 0x04, 0x73, 0x70,
	0x65, 0x63, 0x22, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x70, 0x65, 0x63, 0x73, 0x12,
	0x9b, 0x01, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x26, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x65,
	0x63, 0x22, 0x4a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d,
	0x12, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x70, 0x65, 0x63, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xbc, 0x01,
	0x0a, 0x0f, 0x47, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x70,
	0x65, 0x63, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x63, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x53, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x12, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x2a, 0x2f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x70, 0x65, 0x63, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xae, 0x01, 0x0a,
	0x09, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x4c, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d,
	0x12, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x70, 0x65, 0x63, 0x73, 0x12, 0xb8, 0x01,
	0x0a, 0x0a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x70, 0x65, 0x63, 0x22, 0x61, 0xda, 0x41, 0x10, 0x73, 0x70, 0x65, 0x63, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48,
	0x3a, 0x04, 0x73, 0x70, 0x65, 0x63, 0x32, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x70, 0x65,
	0x63, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70,
	0x69, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x70, 0x65, 0x63, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x9b, 0x01, 0x0a, 0x0a, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x4a, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x2a, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x69, 0x73,
	0x2f, 0x2a, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x70,
	0x65, 0x63, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb8, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x41, 0x70,
	0x69, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x70, 0x69, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x69, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x4f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x12,
	0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xcb, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x70, 0x69, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x70, 0x69, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x70, 0x69, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x51, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x12, 0x40, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0xb3, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x65,
	0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x50, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x43, 0x12, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xce, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x22,
	0x65, 0xda, 0x41, 0x1f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xa1, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x3e, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb4, 0x01, 0x0a, 0x0f, 0x4c,
	0x69, 0x73, 0x74, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70,
	0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70,
	0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x40, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31,
	0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0xd0, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x67, 0xda, 0x41, 0x16,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x3a, 0x0a, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x32, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x9b, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x22, 0x3e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x31, 0x2a, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xc7, 0x01, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x22, 0x61, 0xda, 0x41, 0x1d, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x2c, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3b, 0x3a, 0x09, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x22, 0x2e, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x9d, 0x01, 0x0a,
	0x0c, 0x47, 0x65, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x22, 0x3d, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc9, 0x01, 0x0a,
	0x0f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x22, 0x63, 0xda, 0x41, 0x15, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x45, 0x3a, 0x09, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x32, 0x38,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x98, 0x01, 0x0a, 0x0f, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x22, 0x3d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x30, 0x2a, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xb0, 0x01, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3f, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0xc5, 0x01, 0x0a, 0x0f, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x51, 0xda, 0x41, 0x0e,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3a, 0x3a, 0x01, 0x2a, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0xd8,
	0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x41, 0x70, 0x69, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x22, 0x6c, 0xda, 0x41, 0x23,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f,
	0x61, 0x70, 0x69, 0x2c, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x61, 0x70, 0x69,
	0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x3a, 0x0c, 0x65, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x5f, 0x61, 0x70, 0x69, 0x22, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x78, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x73, 0x12, 0xa5, 0x01, 0x0a, 0x0e, 0x47, 0x65,
	0x74, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x12, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x41, 0x70, 0x69, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69,
	0x22, 0x3f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12,
	0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xda, 0x01, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41,
	0x70, 0x69, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x22, 0x6e,
	0xda, 0x41, 0x18, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x61, 0x70, 0x69, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x4d, 0x3a, 0x0c, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x61, 0x70, 0x69, 0x32,
	0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x61,
	0x70, 0x69, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x9e,
	0x01, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x41, 0x70, 0x69, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3f,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x2a, 0x30, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xb8, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x41, 0x70, 0x69, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x78,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x73, 0x1a, 0x49, 0xca, 0x41, 0x15, 0x61,
	0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x32, 0x84, 0x08, 0x0a, 0x12, 0x41, 0x70, 0x69, 0x48, 0x75, 0x62,
	0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0xcf, 0x01, 0x0a,
	0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63,
	0x79, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x22, 0x66, 0xda, 0x41, 0x1f, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x2c, 0x64, 0x65, 0x70,
	0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e,
	0x3a, 0x0a, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x22, 0x30, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0xa2,
	0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79,
	0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x65, 0x70,
	0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70,
	0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e,
	0x63, 0x79, 0x22, 0x3f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xd1, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x65,
	0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e,
	0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x22, 0x68, 0xda,
	0x41, 0x16, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x2c, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x3a, 0x0a,
	0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x32, 0x3b, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e,
	0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x9c, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x65, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x32, 0x2a, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb8, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x44,
	0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65,
	0x6e, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64,
	0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12,
	0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65,
	0x73, 0x1a, 0x49, 0xca, 0x41, 0x15, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xb4, 0x01, 0x0a,
	0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x42, 0x12, 0x41, 0x70, 0x69,
	0x48, 0x75, 0x62, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x32, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x2f, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x70, 0x62, 0x3b, 0x61, 0x70, 0x69,
	0x68, 0x75, 0x62, 0x70, 0x62, 0xaa, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x70, 0x69, 0x48, 0x75, 0x62, 0x2e, 0x56, 0x31, 0xca, 0x02,
	0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x70,
	0x69, 0x48, 0x75, 0x62, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x70, 0x69, 0x48, 0x75, 0x62, 0x3a,
	0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_apihub_v1_apihub_service_proto_rawDescOnce sync.Once
	file_google_cloud_apihub_v1_apihub_service_proto_rawDescData = file_google_cloud_apihub_v1_apihub_service_proto_rawDesc
)

func file_google_cloud_apihub_v1_apihub_service_proto_rawDescGZIP() []byte {
	file_google_cloud_apihub_v1_apihub_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_apihub_v1_apihub_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_apihub_v1_apihub_service_proto_rawDescData)
	})
	return file_google_cloud_apihub_v1_apihub_service_proto_rawDescData
}

var file_google_cloud_apihub_v1_apihub_service_proto_msgTypes = make([]protoimpl.MessageInfo, 51)
var file_google_cloud_apihub_v1_apihub_service_proto_goTypes = []any{
	(*CreateApiRequest)(nil),          // 0: google.cloud.apihub.v1.CreateApiRequest
	(*GetApiRequest)(nil),             // 1: google.cloud.apihub.v1.GetApiRequest
	(*UpdateApiRequest)(nil),          // 2: google.cloud.apihub.v1.UpdateApiRequest
	(*DeleteApiRequest)(nil),          // 3: google.cloud.apihub.v1.DeleteApiRequest
	(*ListApisRequest)(nil),           // 4: google.cloud.apihub.v1.ListApisRequest
	(*ListApisResponse)(nil),          // 5: google.cloud.apihub.v1.ListApisResponse
	(*CreateVersionRequest)(nil),      // 6: google.cloud.apihub.v1.CreateVersionRequest
	(*GetVersionRequest)(nil),         // 7: google.cloud.apihub.v1.GetVersionRequest
	(*UpdateVersionRequest)(nil),      // 8: google.cloud.apihub.v1.UpdateVersionRequest
	(*DeleteVersionRequest)(nil),      // 9: google.cloud.apihub.v1.DeleteVersionRequest
	(*ListVersionsRequest)(nil),       // 10: google.cloud.apihub.v1.ListVersionsRequest
	(*ListVersionsResponse)(nil),      // 11: google.cloud.apihub.v1.ListVersionsResponse
	(*CreateSpecRequest)(nil),         // 12: google.cloud.apihub.v1.CreateSpecRequest
	(*GetSpecRequest)(nil),            // 13: google.cloud.apihub.v1.GetSpecRequest
	(*UpdateSpecRequest)(nil),         // 14: google.cloud.apihub.v1.UpdateSpecRequest
	(*DeleteSpecRequest)(nil),         // 15: google.cloud.apihub.v1.DeleteSpecRequest
	(*ListSpecsRequest)(nil),          // 16: google.cloud.apihub.v1.ListSpecsRequest
	(*ListSpecsResponse)(nil),         // 17: google.cloud.apihub.v1.ListSpecsResponse
	(*GetSpecContentsRequest)(nil),    // 18: google.cloud.apihub.v1.GetSpecContentsRequest
	(*GetApiOperationRequest)(nil),    // 19: google.cloud.apihub.v1.GetApiOperationRequest
	(*ListApiOperationsRequest)(nil),  // 20: google.cloud.apihub.v1.ListApiOperationsRequest
	(*ListApiOperationsResponse)(nil), // 21: google.cloud.apihub.v1.ListApiOperationsResponse
	(*GetDefinitionRequest)(nil),      // 22: google.cloud.apihub.v1.GetDefinitionRequest
	(*CreateDeploymentRequest)(nil),   // 23: google.cloud.apihub.v1.CreateDeploymentRequest
	(*GetDeploymentRequest)(nil),      // 24: google.cloud.apihub.v1.GetDeploymentRequest
	(*UpdateDeploymentRequest)(nil),   // 25: google.cloud.apihub.v1.UpdateDeploymentRequest
	(*DeleteDeploymentRequest)(nil),   // 26: google.cloud.apihub.v1.DeleteDeploymentRequest
	(*ListDeploymentsRequest)(nil),    // 27: google.cloud.apihub.v1.ListDeploymentsRequest
	(*ListDeploymentsResponse)(nil),   // 28: google.cloud.apihub.v1.ListDeploymentsResponse
	(*CreateAttributeRequest)(nil),    // 29: google.cloud.apihub.v1.CreateAttributeRequest
	(*GetAttributeRequest)(nil),       // 30: google.cloud.apihub.v1.GetAttributeRequest
	(*UpdateAttributeRequest)(nil),    // 31: google.cloud.apihub.v1.UpdateAttributeRequest
	(*DeleteAttributeRequest)(nil),    // 32: google.cloud.apihub.v1.DeleteAttributeRequest
	(*ListAttributesRequest)(nil),     // 33: google.cloud.apihub.v1.ListAttributesRequest
	(*ListAttributesResponse)(nil),    // 34: google.cloud.apihub.v1.ListAttributesResponse
	(*SearchResourcesRequest)(nil),    // 35: google.cloud.apihub.v1.SearchResourcesRequest
	(*ApiHubResource)(nil),            // 36: google.cloud.apihub.v1.ApiHubResource
	(*SearchResult)(nil),              // 37: google.cloud.apihub.v1.SearchResult
	(*SearchResourcesResponse)(nil),   // 38: google.cloud.apihub.v1.SearchResourcesResponse
	(*CreateDependencyRequest)(nil),   // 39: google.cloud.apihub.v1.CreateDependencyRequest
	(*GetDependencyRequest)(nil),      // 40: google.cloud.apihub.v1.GetDependencyRequest
	(*UpdateDependencyRequest)(nil),   // 41: google.cloud.apihub.v1.UpdateDependencyRequest
	(*DeleteDependencyRequest)(nil),   // 42: google.cloud.apihub.v1.DeleteDependencyRequest
	(*ListDependenciesRequest)(nil),   // 43: google.cloud.apihub.v1.ListDependenciesRequest
	(*ListDependenciesResponse)(nil),  // 44: google.cloud.apihub.v1.ListDependenciesResponse
	(*CreateExternalApiRequest)(nil),  // 45: google.cloud.apihub.v1.CreateExternalApiRequest
	(*GetExternalApiRequest)(nil),     // 46: google.cloud.apihub.v1.GetExternalApiRequest
	(*UpdateExternalApiRequest)(nil),  // 47: google.cloud.apihub.v1.UpdateExternalApiRequest
	(*DeleteExternalApiRequest)(nil),  // 48: google.cloud.apihub.v1.DeleteExternalApiRequest
	(*ListExternalApisRequest)(nil),   // 49: google.cloud.apihub.v1.ListExternalApisRequest
	(*ListExternalApisResponse)(nil),  // 50: google.cloud.apihub.v1.ListExternalApisResponse
	(*Api)(nil),                       // 51: google.cloud.apihub.v1.Api
	(*fieldmaskpb.FieldMask)(nil),     // 52: google.protobuf.FieldMask
	(*Version)(nil),                   // 53: google.cloud.apihub.v1.Version
	(*Spec)(nil),                      // 54: google.cloud.apihub.v1.Spec
	(*ApiOperation)(nil),              // 55: google.cloud.apihub.v1.ApiOperation
	(*Deployment)(nil),                // 56: google.cloud.apihub.v1.Deployment
	(*Attribute)(nil),                 // 57: google.cloud.apihub.v1.Attribute
	(*Definition)(nil),                // 58: google.cloud.apihub.v1.Definition
	(*Dependency)(nil),                // 59: google.cloud.apihub.v1.Dependency
	(*ExternalApi)(nil),               // 60: google.cloud.apihub.v1.ExternalApi
	(*emptypb.Empty)(nil),             // 61: google.protobuf.Empty
	(*SpecContents)(nil),              // 62: google.cloud.apihub.v1.SpecContents
}
var file_google_cloud_apihub_v1_apihub_service_proto_depIdxs = []int32{
	51, // 0: google.cloud.apihub.v1.CreateApiRequest.api:type_name -> google.cloud.apihub.v1.Api
	51, // 1: google.cloud.apihub.v1.UpdateApiRequest.api:type_name -> google.cloud.apihub.v1.Api
	52, // 2: google.cloud.apihub.v1.UpdateApiRequest.update_mask:type_name -> google.protobuf.FieldMask
	51, // 3: google.cloud.apihub.v1.ListApisResponse.apis:type_name -> google.cloud.apihub.v1.Api
	53, // 4: google.cloud.apihub.v1.CreateVersionRequest.version:type_name -> google.cloud.apihub.v1.Version
	53, // 5: google.cloud.apihub.v1.UpdateVersionRequest.version:type_name -> google.cloud.apihub.v1.Version
	52, // 6: google.cloud.apihub.v1.UpdateVersionRequest.update_mask:type_name -> google.protobuf.FieldMask
	53, // 7: google.cloud.apihub.v1.ListVersionsResponse.versions:type_name -> google.cloud.apihub.v1.Version
	54, // 8: google.cloud.apihub.v1.CreateSpecRequest.spec:type_name -> google.cloud.apihub.v1.Spec
	54, // 9: google.cloud.apihub.v1.UpdateSpecRequest.spec:type_name -> google.cloud.apihub.v1.Spec
	52, // 10: google.cloud.apihub.v1.UpdateSpecRequest.update_mask:type_name -> google.protobuf.FieldMask
	54, // 11: google.cloud.apihub.v1.ListSpecsResponse.specs:type_name -> google.cloud.apihub.v1.Spec
	55, // 12: google.cloud.apihub.v1.ListApiOperationsResponse.api_operations:type_name -> google.cloud.apihub.v1.ApiOperation
	56, // 13: google.cloud.apihub.v1.CreateDeploymentRequest.deployment:type_name -> google.cloud.apihub.v1.Deployment
	56, // 14: google.cloud.apihub.v1.UpdateDeploymentRequest.deployment:type_name -> google.cloud.apihub.v1.Deployment
	52, // 15: google.cloud.apihub.v1.UpdateDeploymentRequest.update_mask:type_name -> google.protobuf.FieldMask
	56, // 16: google.cloud.apihub.v1.ListDeploymentsResponse.deployments:type_name -> google.cloud.apihub.v1.Deployment
	57, // 17: google.cloud.apihub.v1.CreateAttributeRequest.attribute:type_name -> google.cloud.apihub.v1.Attribute
	57, // 18: google.cloud.apihub.v1.UpdateAttributeRequest.attribute:type_name -> google.cloud.apihub.v1.Attribute
	52, // 19: google.cloud.apihub.v1.UpdateAttributeRequest.update_mask:type_name -> google.protobuf.FieldMask
	57, // 20: google.cloud.apihub.v1.ListAttributesResponse.attributes:type_name -> google.cloud.apihub.v1.Attribute
	51, // 21: google.cloud.apihub.v1.ApiHubResource.api:type_name -> google.cloud.apihub.v1.Api
	55, // 22: google.cloud.apihub.v1.ApiHubResource.operation:type_name -> google.cloud.apihub.v1.ApiOperation
	56, // 23: google.cloud.apihub.v1.ApiHubResource.deployment:type_name -> google.cloud.apihub.v1.Deployment
	54, // 24: google.cloud.apihub.v1.ApiHubResource.spec:type_name -> google.cloud.apihub.v1.Spec
	58, // 25: google.cloud.apihub.v1.ApiHubResource.definition:type_name -> google.cloud.apihub.v1.Definition
	53, // 26: google.cloud.apihub.v1.ApiHubResource.version:type_name -> google.cloud.apihub.v1.Version
	36, // 27: google.cloud.apihub.v1.SearchResult.resource:type_name -> google.cloud.apihub.v1.ApiHubResource
	37, // 28: google.cloud.apihub.v1.SearchResourcesResponse.search_results:type_name -> google.cloud.apihub.v1.SearchResult
	59, // 29: google.cloud.apihub.v1.CreateDependencyRequest.dependency:type_name -> google.cloud.apihub.v1.Dependency
	59, // 30: google.cloud.apihub.v1.UpdateDependencyRequest.dependency:type_name -> google.cloud.apihub.v1.Dependency
	52, // 31: google.cloud.apihub.v1.UpdateDependencyRequest.update_mask:type_name -> google.protobuf.FieldMask
	59, // 32: google.cloud.apihub.v1.ListDependenciesResponse.dependencies:type_name -> google.cloud.apihub.v1.Dependency
	60, // 33: google.cloud.apihub.v1.CreateExternalApiRequest.external_api:type_name -> google.cloud.apihub.v1.ExternalApi
	60, // 34: google.cloud.apihub.v1.UpdateExternalApiRequest.external_api:type_name -> google.cloud.apihub.v1.ExternalApi
	52, // 35: google.cloud.apihub.v1.UpdateExternalApiRequest.update_mask:type_name -> google.protobuf.FieldMask
	60, // 36: google.cloud.apihub.v1.ListExternalApisResponse.external_apis:type_name -> google.cloud.apihub.v1.ExternalApi
	0,  // 37: google.cloud.apihub.v1.ApiHub.CreateApi:input_type -> google.cloud.apihub.v1.CreateApiRequest
	1,  // 38: google.cloud.apihub.v1.ApiHub.GetApi:input_type -> google.cloud.apihub.v1.GetApiRequest
	4,  // 39: google.cloud.apihub.v1.ApiHub.ListApis:input_type -> google.cloud.apihub.v1.ListApisRequest
	2,  // 40: google.cloud.apihub.v1.ApiHub.UpdateApi:input_type -> google.cloud.apihub.v1.UpdateApiRequest
	3,  // 41: google.cloud.apihub.v1.ApiHub.DeleteApi:input_type -> google.cloud.apihub.v1.DeleteApiRequest
	6,  // 42: google.cloud.apihub.v1.ApiHub.CreateVersion:input_type -> google.cloud.apihub.v1.CreateVersionRequest
	7,  // 43: google.cloud.apihub.v1.ApiHub.GetVersion:input_type -> google.cloud.apihub.v1.GetVersionRequest
	10, // 44: google.cloud.apihub.v1.ApiHub.ListVersions:input_type -> google.cloud.apihub.v1.ListVersionsRequest
	8,  // 45: google.cloud.apihub.v1.ApiHub.UpdateVersion:input_type -> google.cloud.apihub.v1.UpdateVersionRequest
	9,  // 46: google.cloud.apihub.v1.ApiHub.DeleteVersion:input_type -> google.cloud.apihub.v1.DeleteVersionRequest
	12, // 47: google.cloud.apihub.v1.ApiHub.CreateSpec:input_type -> google.cloud.apihub.v1.CreateSpecRequest
	13, // 48: google.cloud.apihub.v1.ApiHub.GetSpec:input_type -> google.cloud.apihub.v1.GetSpecRequest
	18, // 49: google.cloud.apihub.v1.ApiHub.GetSpecContents:input_type -> google.cloud.apihub.v1.GetSpecContentsRequest
	16, // 50: google.cloud.apihub.v1.ApiHub.ListSpecs:input_type -> google.cloud.apihub.v1.ListSpecsRequest
	14, // 51: google.cloud.apihub.v1.ApiHub.UpdateSpec:input_type -> google.cloud.apihub.v1.UpdateSpecRequest
	15, // 52: google.cloud.apihub.v1.ApiHub.DeleteSpec:input_type -> google.cloud.apihub.v1.DeleteSpecRequest
	19, // 53: google.cloud.apihub.v1.ApiHub.GetApiOperation:input_type -> google.cloud.apihub.v1.GetApiOperationRequest
	20, // 54: google.cloud.apihub.v1.ApiHub.ListApiOperations:input_type -> google.cloud.apihub.v1.ListApiOperationsRequest
	22, // 55: google.cloud.apihub.v1.ApiHub.GetDefinition:input_type -> google.cloud.apihub.v1.GetDefinitionRequest
	23, // 56: google.cloud.apihub.v1.ApiHub.CreateDeployment:input_type -> google.cloud.apihub.v1.CreateDeploymentRequest
	24, // 57: google.cloud.apihub.v1.ApiHub.GetDeployment:input_type -> google.cloud.apihub.v1.GetDeploymentRequest
	27, // 58: google.cloud.apihub.v1.ApiHub.ListDeployments:input_type -> google.cloud.apihub.v1.ListDeploymentsRequest
	25, // 59: google.cloud.apihub.v1.ApiHub.UpdateDeployment:input_type -> google.cloud.apihub.v1.UpdateDeploymentRequest
	26, // 60: google.cloud.apihub.v1.ApiHub.DeleteDeployment:input_type -> google.cloud.apihub.v1.DeleteDeploymentRequest
	29, // 61: google.cloud.apihub.v1.ApiHub.CreateAttribute:input_type -> google.cloud.apihub.v1.CreateAttributeRequest
	30, // 62: google.cloud.apihub.v1.ApiHub.GetAttribute:input_type -> google.cloud.apihub.v1.GetAttributeRequest
	31, // 63: google.cloud.apihub.v1.ApiHub.UpdateAttribute:input_type -> google.cloud.apihub.v1.UpdateAttributeRequest
	32, // 64: google.cloud.apihub.v1.ApiHub.DeleteAttribute:input_type -> google.cloud.apihub.v1.DeleteAttributeRequest
	33, // 65: google.cloud.apihub.v1.ApiHub.ListAttributes:input_type -> google.cloud.apihub.v1.ListAttributesRequest
	35, // 66: google.cloud.apihub.v1.ApiHub.SearchResources:input_type -> google.cloud.apihub.v1.SearchResourcesRequest
	45, // 67: google.cloud.apihub.v1.ApiHub.CreateExternalApi:input_type -> google.cloud.apihub.v1.CreateExternalApiRequest
	46, // 68: google.cloud.apihub.v1.ApiHub.GetExternalApi:input_type -> google.cloud.apihub.v1.GetExternalApiRequest
	47, // 69: google.cloud.apihub.v1.ApiHub.UpdateExternalApi:input_type -> google.cloud.apihub.v1.UpdateExternalApiRequest
	48, // 70: google.cloud.apihub.v1.ApiHub.DeleteExternalApi:input_type -> google.cloud.apihub.v1.DeleteExternalApiRequest
	49, // 71: google.cloud.apihub.v1.ApiHub.ListExternalApis:input_type -> google.cloud.apihub.v1.ListExternalApisRequest
	39, // 72: google.cloud.apihub.v1.ApiHubDependencies.CreateDependency:input_type -> google.cloud.apihub.v1.CreateDependencyRequest
	40, // 73: google.cloud.apihub.v1.ApiHubDependencies.GetDependency:input_type -> google.cloud.apihub.v1.GetDependencyRequest
	41, // 74: google.cloud.apihub.v1.ApiHubDependencies.UpdateDependency:input_type -> google.cloud.apihub.v1.UpdateDependencyRequest
	42, // 75: google.cloud.apihub.v1.ApiHubDependencies.DeleteDependency:input_type -> google.cloud.apihub.v1.DeleteDependencyRequest
	43, // 76: google.cloud.apihub.v1.ApiHubDependencies.ListDependencies:input_type -> google.cloud.apihub.v1.ListDependenciesRequest
	51, // 77: google.cloud.apihub.v1.ApiHub.CreateApi:output_type -> google.cloud.apihub.v1.Api
	51, // 78: google.cloud.apihub.v1.ApiHub.GetApi:output_type -> google.cloud.apihub.v1.Api
	5,  // 79: google.cloud.apihub.v1.ApiHub.ListApis:output_type -> google.cloud.apihub.v1.ListApisResponse
	51, // 80: google.cloud.apihub.v1.ApiHub.UpdateApi:output_type -> google.cloud.apihub.v1.Api
	61, // 81: google.cloud.apihub.v1.ApiHub.DeleteApi:output_type -> google.protobuf.Empty
	53, // 82: google.cloud.apihub.v1.ApiHub.CreateVersion:output_type -> google.cloud.apihub.v1.Version
	53, // 83: google.cloud.apihub.v1.ApiHub.GetVersion:output_type -> google.cloud.apihub.v1.Version
	11, // 84: google.cloud.apihub.v1.ApiHub.ListVersions:output_type -> google.cloud.apihub.v1.ListVersionsResponse
	53, // 85: google.cloud.apihub.v1.ApiHub.UpdateVersion:output_type -> google.cloud.apihub.v1.Version
	61, // 86: google.cloud.apihub.v1.ApiHub.DeleteVersion:output_type -> google.protobuf.Empty
	54, // 87: google.cloud.apihub.v1.ApiHub.CreateSpec:output_type -> google.cloud.apihub.v1.Spec
	54, // 88: google.cloud.apihub.v1.ApiHub.GetSpec:output_type -> google.cloud.apihub.v1.Spec
	62, // 89: google.cloud.apihub.v1.ApiHub.GetSpecContents:output_type -> google.cloud.apihub.v1.SpecContents
	17, // 90: google.cloud.apihub.v1.ApiHub.ListSpecs:output_type -> google.cloud.apihub.v1.ListSpecsResponse
	54, // 91: google.cloud.apihub.v1.ApiHub.UpdateSpec:output_type -> google.cloud.apihub.v1.Spec
	61, // 92: google.cloud.apihub.v1.ApiHub.DeleteSpec:output_type -> google.protobuf.Empty
	55, // 93: google.cloud.apihub.v1.ApiHub.GetApiOperation:output_type -> google.cloud.apihub.v1.ApiOperation
	21, // 94: google.cloud.apihub.v1.ApiHub.ListApiOperations:output_type -> google.cloud.apihub.v1.ListApiOperationsResponse
	58, // 95: google.cloud.apihub.v1.ApiHub.GetDefinition:output_type -> google.cloud.apihub.v1.Definition
	56, // 96: google.cloud.apihub.v1.ApiHub.CreateDeployment:output_type -> google.cloud.apihub.v1.Deployment
	56, // 97: google.cloud.apihub.v1.ApiHub.GetDeployment:output_type -> google.cloud.apihub.v1.Deployment
	28, // 98: google.cloud.apihub.v1.ApiHub.ListDeployments:output_type -> google.cloud.apihub.v1.ListDeploymentsResponse
	56, // 99: google.cloud.apihub.v1.ApiHub.UpdateDeployment:output_type -> google.cloud.apihub.v1.Deployment
	61, // 100: google.cloud.apihub.v1.ApiHub.DeleteDeployment:output_type -> google.protobuf.Empty
	57, // 101: google.cloud.apihub.v1.ApiHub.CreateAttribute:output_type -> google.cloud.apihub.v1.Attribute
	57, // 102: google.cloud.apihub.v1.ApiHub.GetAttribute:output_type -> google.cloud.apihub.v1.Attribute
	57, // 103: google.cloud.apihub.v1.ApiHub.UpdateAttribute:output_type -> google.cloud.apihub.v1.Attribute
	61, // 104: google.cloud.apihub.v1.ApiHub.DeleteAttribute:output_type -> google.protobuf.Empty
	34, // 105: google.cloud.apihub.v1.ApiHub.ListAttributes:output_type -> google.cloud.apihub.v1.ListAttributesResponse
	38, // 106: google.cloud.apihub.v1.ApiHub.SearchResources:output_type -> google.cloud.apihub.v1.SearchResourcesResponse
	60, // 107: google.cloud.apihub.v1.ApiHub.CreateExternalApi:output_type -> google.cloud.apihub.v1.ExternalApi
	60, // 108: google.cloud.apihub.v1.ApiHub.GetExternalApi:output_type -> google.cloud.apihub.v1.ExternalApi
	60, // 109: google.cloud.apihub.v1.ApiHub.UpdateExternalApi:output_type -> google.cloud.apihub.v1.ExternalApi
	61, // 110: google.cloud.apihub.v1.ApiHub.DeleteExternalApi:output_type -> google.protobuf.Empty
	50, // 111: google.cloud.apihub.v1.ApiHub.ListExternalApis:output_type -> google.cloud.apihub.v1.ListExternalApisResponse
	59, // 112: google.cloud.apihub.v1.ApiHubDependencies.CreateDependency:output_type -> google.cloud.apihub.v1.Dependency
	59, // 113: google.cloud.apihub.v1.ApiHubDependencies.GetDependency:output_type -> google.cloud.apihub.v1.Dependency
	59, // 114: google.cloud.apihub.v1.ApiHubDependencies.UpdateDependency:output_type -> google.cloud.apihub.v1.Dependency
	61, // 115: google.cloud.apihub.v1.ApiHubDependencies.DeleteDependency:output_type -> google.protobuf.Empty
	44, // 116: google.cloud.apihub.v1.ApiHubDependencies.ListDependencies:output_type -> google.cloud.apihub.v1.ListDependenciesResponse
	77, // [77:117] is the sub-list for method output_type
	37, // [37:77] is the sub-list for method input_type
	37, // [37:37] is the sub-list for extension type_name
	37, // [37:37] is the sub-list for extension extendee
	0,  // [0:37] is the sub-list for field type_name
}

func init() { file_google_cloud_apihub_v1_apihub_service_proto_init() }
func file_google_cloud_apihub_v1_apihub_service_proto_init() {
	if File_google_cloud_apihub_v1_apihub_service_proto != nil {
		return
	}
	file_google_cloud_apihub_v1_common_fields_proto_init()
	file_google_cloud_apihub_v1_apihub_service_proto_msgTypes[36].OneofWrappers = []any{
		(*ApiHubResource_Api)(nil),
		(*ApiHubResource_Operation)(nil),
		(*ApiHubResource_Deployment)(nil),
		(*ApiHubResource_Spec)(nil),
		(*ApiHubResource_Definition)(nil),
		(*ApiHubResource_Version)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_apihub_v1_apihub_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   51,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_google_cloud_apihub_v1_apihub_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_apihub_v1_apihub_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_apihub_v1_apihub_service_proto_msgTypes,
	}.Build()
	File_google_cloud_apihub_v1_apihub_service_proto = out.File
	file_google_cloud_apihub_v1_apihub_service_proto_rawDesc = nil
	file_google_cloud_apihub_v1_apihub_service_proto_goTypes = nil
	file_google_cloud_apihub_v1_apihub_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ApiHubClient is the client API for ApiHub service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ApiHubClient interface {
	// Create an API resource in the API hub.
	// Once an API resource is created, versions can be added to it.
	CreateApi(ctx context.Context, in *CreateApiRequest, opts ...grpc.CallOption) (*Api, error)
	// Get API resource details including the API versions contained in it.
	GetApi(ctx context.Context, in *GetApiRequest, opts ...grpc.CallOption) (*Api, error)
	// List API resources in the API hub.
	ListApis(ctx context.Context, in *ListApisRequest, opts ...grpc.CallOption) (*ListApisResponse, error)
	// Update an API resource in the API hub. The following fields in the
	// [API][] can be updated:
	//
	// * [display_name][google.cloud.apihub.v1.Api.display_name]
	// * [description][google.cloud.apihub.v1.Api.description]
	// * [owner][google.cloud.apihub.v1.Api.owner]
	// * [documentation][google.cloud.apihub.v1.Api.documentation]
	// * [target_user][google.cloud.apihub.v1.Api.target_user]
	// * [team][google.cloud.apihub.v1.Api.team]
	// * [business_unit][google.cloud.apihub.v1.Api.business_unit]
	// * [maturity_level][google.cloud.apihub.v1.Api.maturity_level]
	// * [attributes][google.cloud.apihub.v1.Api.attributes]
	//
	// The
	// [update_mask][google.cloud.apihub.v1.UpdateApiRequest.update_mask]
	// should be used to specify the fields being updated.
	//
	// Updating the owner field requires complete owner message
	// and updates both owner and email fields.
	UpdateApi(ctx context.Context, in *UpdateApiRequest, opts ...grpc.CallOption) (*Api, error)
	// Delete an API resource in the API hub. API can only be deleted if all
	// underlying versions are deleted.
	DeleteApi(ctx context.Context, in *DeleteApiRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Create an API version for an API resource in the API hub.
	CreateVersion(ctx context.Context, in *CreateVersionRequest, opts ...grpc.CallOption) (*Version, error)
	// Get details about the API version of an API resource. This will include
	// information about the specs and operations present in the API
	// version as well as the deployments linked to it.
	GetVersion(ctx context.Context, in *GetVersionRequest, opts ...grpc.CallOption) (*Version, error)
	// List API versions of an API resource in the API hub.
	ListVersions(ctx context.Context, in *ListVersionsRequest, opts ...grpc.CallOption) (*ListVersionsResponse, error)
	// Update API version. The following fields in the
	// [version][google.cloud.apihub.v1.Version] can be updated currently:
	//
	// * [display_name][google.cloud.apihub.v1.Version.display_name]
	// * [description][google.cloud.apihub.v1.Version.description]
	// * [documentation][google.cloud.apihub.v1.Version.documentation]
	// * [deployments][google.cloud.apihub.v1.Version.deployments]
	// * [lifecycle][google.cloud.apihub.v1.Version.lifecycle]
	// * [compliance][google.cloud.apihub.v1.Version.compliance]
	// * [accreditation][google.cloud.apihub.v1.Version.accreditation]
	// * [attributes][google.cloud.apihub.v1.Version.attributes]
	//
	// The
	// [update_mask][google.cloud.apihub.v1.UpdateVersionRequest.update_mask]
	// should be used to specify the fields being updated.
	UpdateVersion(ctx context.Context, in *UpdateVersionRequest, opts ...grpc.CallOption) (*Version, error)
	// Delete an API version. Version can only be deleted if all underlying specs,
	// operations, definitions and linked deployments are deleted.
	DeleteVersion(ctx context.Context, in *DeleteVersionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Add a spec to an API version in the API hub.
	// Multiple specs can be added to an API version.
	// Note, while adding a spec, at least one of `contents` or `source_uri` must
	// be provided. If `contents` is provided, then `spec_type` must also be
	// provided.
	//
	// On adding a spec with contents to the version, the operations present in it
	// will be added to the version.Note that the file contents in the spec should
	// be of the same type as defined in the
	// `projects/{project}/locations/{location}/attributes/system-spec-type`
	// attribute associated with spec resource. Note that specs of various types
	// can be uploaded, however parsing of details is supported for OpenAPI spec
	// currently.
	//
	// In order to access the information parsed from the spec, use the
	// [GetSpec][google.cloud.apihub.v1.ApiHub.GetSpec] method.
	// In order to access the raw contents for a particular spec, use the
	// [GetSpecContents][google.cloud.apihub.v1.ApiHub.GetSpecContents] method.
	// In order to access the operations parsed from the spec, use the
	// [ListAPIOperations][google.cloud.apihub.v1.ApiHub.ListApiOperations]
	// method.
	CreateSpec(ctx context.Context, in *CreateSpecRequest, opts ...grpc.CallOption) (*Spec, error)
	// Get details about the information parsed from a spec.
	// Note that this method does not return the raw spec contents.
	// Use [GetSpecContents][google.cloud.apihub.v1.ApiHub.GetSpecContents] method
	// to retrieve the same.
	GetSpec(ctx context.Context, in *GetSpecRequest, opts ...grpc.CallOption) (*Spec, error)
	// Get spec contents.
	GetSpecContents(ctx context.Context, in *GetSpecContentsRequest, opts ...grpc.CallOption) (*SpecContents, error)
	// List specs corresponding to a particular API resource.
	ListSpecs(ctx context.Context, in *ListSpecsRequest, opts ...grpc.CallOption) (*ListSpecsResponse, error)
	// Update spec. The following fields in the
	// [spec][google.cloud.apihub.v1.Spec] can be updated:
	//
	// * [display_name][google.cloud.apihub.v1.Spec.display_name]
	// * [source_uri][google.cloud.apihub.v1.Spec.source_uri]
	// * [lint_response][google.cloud.apihub.v1.Spec.lint_response]
	// * [attributes][google.cloud.apihub.v1.Spec.attributes]
	// * [contents][google.cloud.apihub.v1.Spec.contents]
	// * [spec_type][google.cloud.apihub.v1.Spec.spec_type]
	//
	// In case of an OAS spec, updating spec contents can lead to:
	// 1. Creation, deletion and update of operations.
	// 2. Creation, deletion and update of definitions.
	// 3. Update of other info parsed out from the new spec.
	//
	// In case of contents or source_uri being present in update mask, spec_type
	// must also be present. Also, spec_type can not be present in update mask if
	// contents or source_uri is not present.
	//
	// The
	// [update_mask][google.cloud.apihub.v1.UpdateSpecRequest.update_mask]
	// should be used to specify the fields being updated.
	UpdateSpec(ctx context.Context, in *UpdateSpecRequest, opts ...grpc.CallOption) (*Spec, error)
	// Delete a spec.
	// Deleting a spec will also delete the associated operations from the
	// version.
	DeleteSpec(ctx context.Context, in *DeleteSpecRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Get details about a particular operation in API version.
	GetApiOperation(ctx context.Context, in *GetApiOperationRequest, opts ...grpc.CallOption) (*ApiOperation, error)
	// List operations in an API version.
	ListApiOperations(ctx context.Context, in *ListApiOperationsRequest, opts ...grpc.CallOption) (*ListApiOperationsResponse, error)
	// Get details about a definition in an API version.
	GetDefinition(ctx context.Context, in *GetDefinitionRequest, opts ...grpc.CallOption) (*Definition, error)
	// Create a deployment resource in the API hub.
	// Once a deployment resource is created, it can be associated with API
	// versions.
	CreateDeployment(ctx context.Context, in *CreateDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error)
	// Get details about a deployment and the API versions linked to it.
	GetDeployment(ctx context.Context, in *GetDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error)
	// List deployment resources in the API hub.
	ListDeployments(ctx context.Context, in *ListDeploymentsRequest, opts ...grpc.CallOption) (*ListDeploymentsResponse, error)
	// Update a deployment resource in the API hub. The following fields in the
	// [deployment resource][google.cloud.apihub.v1.Deployment] can be
	// updated:
	//
	// * [display_name][google.cloud.apihub.v1.Deployment.display_name]
	// * [description][google.cloud.apihub.v1.Deployment.description]
	// * [documentation][google.cloud.apihub.v1.Deployment.documentation]
	// * [deployment_type][google.cloud.apihub.v1.Deployment.deployment_type]
	// * [resource_uri][google.cloud.apihub.v1.Deployment.resource_uri]
	// * [endpoints][google.cloud.apihub.v1.Deployment.endpoints]
	// * [slo][google.cloud.apihub.v1.Deployment.slo]
	// * [environment][google.cloud.apihub.v1.Deployment.environment]
	// * [attributes][google.cloud.apihub.v1.Deployment.attributes]
	//
	// The
	// [update_mask][google.cloud.apihub.v1.UpdateDeploymentRequest.update_mask]
	// should be used to specify the fields being updated.
	UpdateDeployment(ctx context.Context, in *UpdateDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error)
	// Delete a deployment resource in the API hub.
	DeleteDeployment(ctx context.Context, in *DeleteDeploymentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Create a user defined attribute.
	//
	// Certain pre defined attributes are already created by the API hub. These
	// attributes will have type as `SYSTEM_DEFINED` and can be listed via
	// [ListAttributes][google.cloud.apihub.v1.ApiHub.ListAttributes] method.
	// Allowed values for the same can be updated via
	// [UpdateAttribute][google.cloud.apihub.v1.ApiHub.UpdateAttribute] method.
	CreateAttribute(ctx context.Context, in *CreateAttributeRequest, opts ...grpc.CallOption) (*Attribute, error)
	// Get details about the attribute.
	GetAttribute(ctx context.Context, in *GetAttributeRequest, opts ...grpc.CallOption) (*Attribute, error)
	// Update the attribute.  The following fields in the
	// [Attribute resource][google.cloud.apihub.v1.Attribute] can be updated:
	//
	// * [display_name][google.cloud.apihub.v1.Attribute.display_name]
	// The display name can be updated for user defined attributes only.
	// * [description][google.cloud.apihub.v1.Attribute.description]
	// The description can be updated for user defined attributes only.
	// * [allowed_values][google.cloud.apihub.v1.Attribute.allowed_values]
	// To update the list of allowed values, clients need to use the fetched list
	// of allowed values and add or remove values to or from the same list.
	// The mutable allowed values can be updated for both user defined and System
	// defined attributes. The immutable allowed values cannot be updated or
	// deleted. The updated list of allowed values cannot be empty. If an allowed
	// value that is already used by some resource's attribute is deleted, then
	// the association between the resource and the attribute value will also be
	// deleted.
	// * [cardinality][google.cloud.apihub.v1.Attribute.cardinality]
	// The cardinality can be updated for user defined attributes only.
	// Cardinality can only be increased during an update.
	//
	// The
	// [update_mask][google.cloud.apihub.v1.UpdateAttributeRequest.update_mask]
	// should be used to specify the fields being updated.
	UpdateAttribute(ctx context.Context, in *UpdateAttributeRequest, opts ...grpc.CallOption) (*Attribute, error)
	// Delete an attribute.
	//
	// Note: System defined attributes cannot be deleted. All
	// associations of the attribute being deleted with any API hub resource will
	// also get deleted.
	DeleteAttribute(ctx context.Context, in *DeleteAttributeRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// List all attributes.
	ListAttributes(ctx context.Context, in *ListAttributesRequest, opts ...grpc.CallOption) (*ListAttributesResponse, error)
	// Search across API-Hub resources.
	SearchResources(ctx context.Context, in *SearchResourcesRequest, opts ...grpc.CallOption) (*SearchResourcesResponse, error)
	// Create an External API resource in the API hub.
	CreateExternalApi(ctx context.Context, in *CreateExternalApiRequest, opts ...grpc.CallOption) (*ExternalApi, error)
	// Get details about an External API resource in the API hub.
	GetExternalApi(ctx context.Context, in *GetExternalApiRequest, opts ...grpc.CallOption) (*ExternalApi, error)
	// Update an External API resource in the API hub. The following fields can be
	// updated:
	//
	// * [display_name][google.cloud.apihub.v1.ExternalApi.display_name]
	// * [description][google.cloud.apihub.v1.ExternalApi.description]
	// * [documentation][google.cloud.apihub.v1.ExternalApi.documentation]
	// * [endpoints][google.cloud.apihub.v1.ExternalApi.endpoints]
	// * [paths][google.cloud.apihub.v1.ExternalApi.paths]
	//
	// The
	// [update_mask][google.cloud.apihub.v1.UpdateExternalApiRequest.update_mask]
	// should be used to specify the fields being updated.
	UpdateExternalApi(ctx context.Context, in *UpdateExternalApiRequest, opts ...grpc.CallOption) (*ExternalApi, error)
	// Delete an External API resource in the API hub.
	DeleteExternalApi(ctx context.Context, in *DeleteExternalApiRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// List External API resources in the API hub.
	ListExternalApis(ctx context.Context, in *ListExternalApisRequest, opts ...grpc.CallOption) (*ListExternalApisResponse, error)
}

type apiHubClient struct {
	cc grpc.ClientConnInterface
}

func NewApiHubClient(cc grpc.ClientConnInterface) ApiHubClient {
	return &apiHubClient{cc}
}

func (c *apiHubClient) CreateApi(ctx context.Context, in *CreateApiRequest, opts ...grpc.CallOption) (*Api, error) {
	out := new(Api)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/CreateApi", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) GetApi(ctx context.Context, in *GetApiRequest, opts ...grpc.CallOption) (*Api, error) {
	out := new(Api)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/GetApi", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) ListApis(ctx context.Context, in *ListApisRequest, opts ...grpc.CallOption) (*ListApisResponse, error) {
	out := new(ListApisResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/ListApis", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) UpdateApi(ctx context.Context, in *UpdateApiRequest, opts ...grpc.CallOption) (*Api, error) {
	out := new(Api)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/UpdateApi", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) DeleteApi(ctx context.Context, in *DeleteApiRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/DeleteApi", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) CreateVersion(ctx context.Context, in *CreateVersionRequest, opts ...grpc.CallOption) (*Version, error) {
	out := new(Version)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/CreateVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) GetVersion(ctx context.Context, in *GetVersionRequest, opts ...grpc.CallOption) (*Version, error) {
	out := new(Version)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/GetVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) ListVersions(ctx context.Context, in *ListVersionsRequest, opts ...grpc.CallOption) (*ListVersionsResponse, error) {
	out := new(ListVersionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/ListVersions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) UpdateVersion(ctx context.Context, in *UpdateVersionRequest, opts ...grpc.CallOption) (*Version, error) {
	out := new(Version)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/UpdateVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) DeleteVersion(ctx context.Context, in *DeleteVersionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/DeleteVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) CreateSpec(ctx context.Context, in *CreateSpecRequest, opts ...grpc.CallOption) (*Spec, error) {
	out := new(Spec)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/CreateSpec", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) GetSpec(ctx context.Context, in *GetSpecRequest, opts ...grpc.CallOption) (*Spec, error) {
	out := new(Spec)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/GetSpec", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) GetSpecContents(ctx context.Context, in *GetSpecContentsRequest, opts ...grpc.CallOption) (*SpecContents, error) {
	out := new(SpecContents)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/GetSpecContents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) ListSpecs(ctx context.Context, in *ListSpecsRequest, opts ...grpc.CallOption) (*ListSpecsResponse, error) {
	out := new(ListSpecsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/ListSpecs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) UpdateSpec(ctx context.Context, in *UpdateSpecRequest, opts ...grpc.CallOption) (*Spec, error) {
	out := new(Spec)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/UpdateSpec", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) DeleteSpec(ctx context.Context, in *DeleteSpecRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/DeleteSpec", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) GetApiOperation(ctx context.Context, in *GetApiOperationRequest, opts ...grpc.CallOption) (*ApiOperation, error) {
	out := new(ApiOperation)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/GetApiOperation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) ListApiOperations(ctx context.Context, in *ListApiOperationsRequest, opts ...grpc.CallOption) (*ListApiOperationsResponse, error) {
	out := new(ListApiOperationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/ListApiOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) GetDefinition(ctx context.Context, in *GetDefinitionRequest, opts ...grpc.CallOption) (*Definition, error) {
	out := new(Definition)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/GetDefinition", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) CreateDeployment(ctx context.Context, in *CreateDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error) {
	out := new(Deployment)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/CreateDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) GetDeployment(ctx context.Context, in *GetDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error) {
	out := new(Deployment)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/GetDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) ListDeployments(ctx context.Context, in *ListDeploymentsRequest, opts ...grpc.CallOption) (*ListDeploymentsResponse, error) {
	out := new(ListDeploymentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/ListDeployments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) UpdateDeployment(ctx context.Context, in *UpdateDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error) {
	out := new(Deployment)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/UpdateDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) DeleteDeployment(ctx context.Context, in *DeleteDeploymentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/DeleteDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) CreateAttribute(ctx context.Context, in *CreateAttributeRequest, opts ...grpc.CallOption) (*Attribute, error) {
	out := new(Attribute)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/CreateAttribute", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) GetAttribute(ctx context.Context, in *GetAttributeRequest, opts ...grpc.CallOption) (*Attribute, error) {
	out := new(Attribute)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/GetAttribute", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) UpdateAttribute(ctx context.Context, in *UpdateAttributeRequest, opts ...grpc.CallOption) (*Attribute, error) {
	out := new(Attribute)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/UpdateAttribute", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) DeleteAttribute(ctx context.Context, in *DeleteAttributeRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/DeleteAttribute", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) ListAttributes(ctx context.Context, in *ListAttributesRequest, opts ...grpc.CallOption) (*ListAttributesResponse, error) {
	out := new(ListAttributesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/ListAttributes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) SearchResources(ctx context.Context, in *SearchResourcesRequest, opts ...grpc.CallOption) (*SearchResourcesResponse, error) {
	out := new(SearchResourcesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/SearchResources", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) CreateExternalApi(ctx context.Context, in *CreateExternalApiRequest, opts ...grpc.CallOption) (*ExternalApi, error) {
	out := new(ExternalApi)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/CreateExternalApi", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) GetExternalApi(ctx context.Context, in *GetExternalApiRequest, opts ...grpc.CallOption) (*ExternalApi, error) {
	out := new(ExternalApi)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/GetExternalApi", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) UpdateExternalApi(ctx context.Context, in *UpdateExternalApiRequest, opts ...grpc.CallOption) (*ExternalApi, error) {
	out := new(ExternalApi)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/UpdateExternalApi", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) DeleteExternalApi(ctx context.Context, in *DeleteExternalApiRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/DeleteExternalApi", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubClient) ListExternalApis(ctx context.Context, in *ListExternalApisRequest, opts ...grpc.CallOption) (*ListExternalApisResponse, error) {
	out := new(ListExternalApisResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHub/ListExternalApis", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ApiHubServer is the server API for ApiHub service.
type ApiHubServer interface {
	// Create an API resource in the API hub.
	// Once an API resource is created, versions can be added to it.
	CreateApi(context.Context, *CreateApiRequest) (*Api, error)
	// Get API resource details including the API versions contained in it.
	GetApi(context.Context, *GetApiRequest) (*Api, error)
	// List API resources in the API hub.
	ListApis(context.Context, *ListApisRequest) (*ListApisResponse, error)
	// Update an API resource in the API hub. The following fields in the
	// [API][] can be updated:
	//
	// * [display_name][google.cloud.apihub.v1.Api.display_name]
	// * [description][google.cloud.apihub.v1.Api.description]
	// * [owner][google.cloud.apihub.v1.Api.owner]
	// * [documentation][google.cloud.apihub.v1.Api.documentation]
	// * [target_user][google.cloud.apihub.v1.Api.target_user]
	// * [team][google.cloud.apihub.v1.Api.team]
	// * [business_unit][google.cloud.apihub.v1.Api.business_unit]
	// * [maturity_level][google.cloud.apihub.v1.Api.maturity_level]
	// * [attributes][google.cloud.apihub.v1.Api.attributes]
	//
	// The
	// [update_mask][google.cloud.apihub.v1.UpdateApiRequest.update_mask]
	// should be used to specify the fields being updated.
	//
	// Updating the owner field requires complete owner message
	// and updates both owner and email fields.
	UpdateApi(context.Context, *UpdateApiRequest) (*Api, error)
	// Delete an API resource in the API hub. API can only be deleted if all
	// underlying versions are deleted.
	DeleteApi(context.Context, *DeleteApiRequest) (*emptypb.Empty, error)
	// Create an API version for an API resource in the API hub.
	CreateVersion(context.Context, *CreateVersionRequest) (*Version, error)
	// Get details about the API version of an API resource. This will include
	// information about the specs and operations present in the API
	// version as well as the deployments linked to it.
	GetVersion(context.Context, *GetVersionRequest) (*Version, error)
	// List API versions of an API resource in the API hub.
	ListVersions(context.Context, *ListVersionsRequest) (*ListVersionsResponse, error)
	// Update API version. The following fields in the
	// [version][google.cloud.apihub.v1.Version] can be updated currently:
	//
	// * [display_name][google.cloud.apihub.v1.Version.display_name]
	// * [description][google.cloud.apihub.v1.Version.description]
	// * [documentation][google.cloud.apihub.v1.Version.documentation]
	// * [deployments][google.cloud.apihub.v1.Version.deployments]
	// * [lifecycle][google.cloud.apihub.v1.Version.lifecycle]
	// * [compliance][google.cloud.apihub.v1.Version.compliance]
	// * [accreditation][google.cloud.apihub.v1.Version.accreditation]
	// * [attributes][google.cloud.apihub.v1.Version.attributes]
	//
	// The
	// [update_mask][google.cloud.apihub.v1.UpdateVersionRequest.update_mask]
	// should be used to specify the fields being updated.
	UpdateVersion(context.Context, *UpdateVersionRequest) (*Version, error)
	// Delete an API version. Version can only be deleted if all underlying specs,
	// operations, definitions and linked deployments are deleted.
	DeleteVersion(context.Context, *DeleteVersionRequest) (*emptypb.Empty, error)
	// Add a spec to an API version in the API hub.
	// Multiple specs can be added to an API version.
	// Note, while adding a spec, at least one of `contents` or `source_uri` must
	// be provided. If `contents` is provided, then `spec_type` must also be
	// provided.
	//
	// On adding a spec with contents to the version, the operations present in it
	// will be added to the version.Note that the file contents in the spec should
	// be of the same type as defined in the
	// `projects/{project}/locations/{location}/attributes/system-spec-type`
	// attribute associated with spec resource. Note that specs of various types
	// can be uploaded, however parsing of details is supported for OpenAPI spec
	// currently.
	//
	// In order to access the information parsed from the spec, use the
	// [GetSpec][google.cloud.apihub.v1.ApiHub.GetSpec] method.
	// In order to access the raw contents for a particular spec, use the
	// [GetSpecContents][google.cloud.apihub.v1.ApiHub.GetSpecContents] method.
	// In order to access the operations parsed from the spec, use the
	// [ListAPIOperations][google.cloud.apihub.v1.ApiHub.ListApiOperations]
	// method.
	CreateSpec(context.Context, *CreateSpecRequest) (*Spec, error)
	// Get details about the information parsed from a spec.
	// Note that this method does not return the raw spec contents.
	// Use [GetSpecContents][google.cloud.apihub.v1.ApiHub.GetSpecContents] method
	// to retrieve the same.
	GetSpec(context.Context, *GetSpecRequest) (*Spec, error)
	// Get spec contents.
	GetSpecContents(context.Context, *GetSpecContentsRequest) (*SpecContents, error)
	// List specs corresponding to a particular API resource.
	ListSpecs(context.Context, *ListSpecsRequest) (*ListSpecsResponse, error)
	// Update spec. The following fields in the
	// [spec][google.cloud.apihub.v1.Spec] can be updated:
	//
	// * [display_name][google.cloud.apihub.v1.Spec.display_name]
	// * [source_uri][google.cloud.apihub.v1.Spec.source_uri]
	// * [lint_response][google.cloud.apihub.v1.Spec.lint_response]
	// * [attributes][google.cloud.apihub.v1.Spec.attributes]
	// * [contents][google.cloud.apihub.v1.Spec.contents]
	// * [spec_type][google.cloud.apihub.v1.Spec.spec_type]
	//
	// In case of an OAS spec, updating spec contents can lead to:
	// 1. Creation, deletion and update of operations.
	// 2. Creation, deletion and update of definitions.
	// 3. Update of other info parsed out from the new spec.
	//
	// In case of contents or source_uri being present in update mask, spec_type
	// must also be present. Also, spec_type can not be present in update mask if
	// contents or source_uri is not present.
	//
	// The
	// [update_mask][google.cloud.apihub.v1.UpdateSpecRequest.update_mask]
	// should be used to specify the fields being updated.
	UpdateSpec(context.Context, *UpdateSpecRequest) (*Spec, error)
	// Delete a spec.
	// Deleting a spec will also delete the associated operations from the
	// version.
	DeleteSpec(context.Context, *DeleteSpecRequest) (*emptypb.Empty, error)
	// Get details about a particular operation in API version.
	GetApiOperation(context.Context, *GetApiOperationRequest) (*ApiOperation, error)
	// List operations in an API version.
	ListApiOperations(context.Context, *ListApiOperationsRequest) (*ListApiOperationsResponse, error)
	// Get details about a definition in an API version.
	GetDefinition(context.Context, *GetDefinitionRequest) (*Definition, error)
	// Create a deployment resource in the API hub.
	// Once a deployment resource is created, it can be associated with API
	// versions.
	CreateDeployment(context.Context, *CreateDeploymentRequest) (*Deployment, error)
	// Get details about a deployment and the API versions linked to it.
	GetDeployment(context.Context, *GetDeploymentRequest) (*Deployment, error)
	// List deployment resources in the API hub.
	ListDeployments(context.Context, *ListDeploymentsRequest) (*ListDeploymentsResponse, error)
	// Update a deployment resource in the API hub. The following fields in the
	// [deployment resource][google.cloud.apihub.v1.Deployment] can be
	// updated:
	//
	// * [display_name][google.cloud.apihub.v1.Deployment.display_name]
	// * [description][google.cloud.apihub.v1.Deployment.description]
	// * [documentation][google.cloud.apihub.v1.Deployment.documentation]
	// * [deployment_type][google.cloud.apihub.v1.Deployment.deployment_type]
	// * [resource_uri][google.cloud.apihub.v1.Deployment.resource_uri]
	// * [endpoints][google.cloud.apihub.v1.Deployment.endpoints]
	// * [slo][google.cloud.apihub.v1.Deployment.slo]
	// * [environment][google.cloud.apihub.v1.Deployment.environment]
	// * [attributes][google.cloud.apihub.v1.Deployment.attributes]
	//
	// The
	// [update_mask][google.cloud.apihub.v1.UpdateDeploymentRequest.update_mask]
	// should be used to specify the fields being updated.
	UpdateDeployment(context.Context, *UpdateDeploymentRequest) (*Deployment, error)
	// Delete a deployment resource in the API hub.
	DeleteDeployment(context.Context, *DeleteDeploymentRequest) (*emptypb.Empty, error)
	// Create a user defined attribute.
	//
	// Certain pre defined attributes are already created by the API hub. These
	// attributes will have type as `SYSTEM_DEFINED` and can be listed via
	// [ListAttributes][google.cloud.apihub.v1.ApiHub.ListAttributes] method.
	// Allowed values for the same can be updated via
	// [UpdateAttribute][google.cloud.apihub.v1.ApiHub.UpdateAttribute] method.
	CreateAttribute(context.Context, *CreateAttributeRequest) (*Attribute, error)
	// Get details about the attribute.
	GetAttribute(context.Context, *GetAttributeRequest) (*Attribute, error)
	// Update the attribute.  The following fields in the
	// [Attribute resource][google.cloud.apihub.v1.Attribute] can be updated:
	//
	// * [display_name][google.cloud.apihub.v1.Attribute.display_name]
	// The display name can be updated for user defined attributes only.
	// * [description][google.cloud.apihub.v1.Attribute.description]
	// The description can be updated for user defined attributes only.
	// * [allowed_values][google.cloud.apihub.v1.Attribute.allowed_values]
	// To update the list of allowed values, clients need to use the fetched list
	// of allowed values and add or remove values to or from the same list.
	// The mutable allowed values can be updated for both user defined and System
	// defined attributes. The immutable allowed values cannot be updated or
	// deleted. The updated list of allowed values cannot be empty. If an allowed
	// value that is already used by some resource's attribute is deleted, then
	// the association between the resource and the attribute value will also be
	// deleted.
	// * [cardinality][google.cloud.apihub.v1.Attribute.cardinality]
	// The cardinality can be updated for user defined attributes only.
	// Cardinality can only be increased during an update.
	//
	// The
	// [update_mask][google.cloud.apihub.v1.UpdateAttributeRequest.update_mask]
	// should be used to specify the fields being updated.
	UpdateAttribute(context.Context, *UpdateAttributeRequest) (*Attribute, error)
	// Delete an attribute.
	//
	// Note: System defined attributes cannot be deleted. All
	// associations of the attribute being deleted with any API hub resource will
	// also get deleted.
	DeleteAttribute(context.Context, *DeleteAttributeRequest) (*emptypb.Empty, error)
	// List all attributes.
	ListAttributes(context.Context, *ListAttributesRequest) (*ListAttributesResponse, error)
	// Search across API-Hub resources.
	SearchResources(context.Context, *SearchResourcesRequest) (*SearchResourcesResponse, error)
	// Create an External API resource in the API hub.
	CreateExternalApi(context.Context, *CreateExternalApiRequest) (*ExternalApi, error)
	// Get details about an External API resource in the API hub.
	GetExternalApi(context.Context, *GetExternalApiRequest) (*ExternalApi, error)
	// Update an External API resource in the API hub. The following fields can be
	// updated:
	//
	// * [display_name][google.cloud.apihub.v1.ExternalApi.display_name]
	// * [description][google.cloud.apihub.v1.ExternalApi.description]
	// * [documentation][google.cloud.apihub.v1.ExternalApi.documentation]
	// * [endpoints][google.cloud.apihub.v1.ExternalApi.endpoints]
	// * [paths][google.cloud.apihub.v1.ExternalApi.paths]
	//
	// The
	// [update_mask][google.cloud.apihub.v1.UpdateExternalApiRequest.update_mask]
	// should be used to specify the fields being updated.
	UpdateExternalApi(context.Context, *UpdateExternalApiRequest) (*ExternalApi, error)
	// Delete an External API resource in the API hub.
	DeleteExternalApi(context.Context, *DeleteExternalApiRequest) (*emptypb.Empty, error)
	// List External API resources in the API hub.
	ListExternalApis(context.Context, *ListExternalApisRequest) (*ListExternalApisResponse, error)
}

// UnimplementedApiHubServer can be embedded to have forward compatible implementations.
type UnimplementedApiHubServer struct {
}

func (*UnimplementedApiHubServer) CreateApi(context.Context, *CreateApiRequest) (*Api, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateApi not implemented")
}
func (*UnimplementedApiHubServer) GetApi(context.Context, *GetApiRequest) (*Api, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetApi not implemented")
}
func (*UnimplementedApiHubServer) ListApis(context.Context, *ListApisRequest) (*ListApisResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListApis not implemented")
}
func (*UnimplementedApiHubServer) UpdateApi(context.Context, *UpdateApiRequest) (*Api, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateApi not implemented")
}
func (*UnimplementedApiHubServer) DeleteApi(context.Context, *DeleteApiRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteApi not implemented")
}
func (*UnimplementedApiHubServer) CreateVersion(context.Context, *CreateVersionRequest) (*Version, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateVersion not implemented")
}
func (*UnimplementedApiHubServer) GetVersion(context.Context, *GetVersionRequest) (*Version, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVersion not implemented")
}
func (*UnimplementedApiHubServer) ListVersions(context.Context, *ListVersionsRequest) (*ListVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVersions not implemented")
}
func (*UnimplementedApiHubServer) UpdateVersion(context.Context, *UpdateVersionRequest) (*Version, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateVersion not implemented")
}
func (*UnimplementedApiHubServer) DeleteVersion(context.Context, *DeleteVersionRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteVersion not implemented")
}
func (*UnimplementedApiHubServer) CreateSpec(context.Context, *CreateSpecRequest) (*Spec, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSpec not implemented")
}
func (*UnimplementedApiHubServer) GetSpec(context.Context, *GetSpecRequest) (*Spec, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSpec not implemented")
}
func (*UnimplementedApiHubServer) GetSpecContents(context.Context, *GetSpecContentsRequest) (*SpecContents, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSpecContents not implemented")
}
func (*UnimplementedApiHubServer) ListSpecs(context.Context, *ListSpecsRequest) (*ListSpecsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSpecs not implemented")
}
func (*UnimplementedApiHubServer) UpdateSpec(context.Context, *UpdateSpecRequest) (*Spec, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSpec not implemented")
}
func (*UnimplementedApiHubServer) DeleteSpec(context.Context, *DeleteSpecRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSpec not implemented")
}
func (*UnimplementedApiHubServer) GetApiOperation(context.Context, *GetApiOperationRequest) (*ApiOperation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetApiOperation not implemented")
}
func (*UnimplementedApiHubServer) ListApiOperations(context.Context, *ListApiOperationsRequest) (*ListApiOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListApiOperations not implemented")
}
func (*UnimplementedApiHubServer) GetDefinition(context.Context, *GetDefinitionRequest) (*Definition, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDefinition not implemented")
}
func (*UnimplementedApiHubServer) CreateDeployment(context.Context, *CreateDeploymentRequest) (*Deployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDeployment not implemented")
}
func (*UnimplementedApiHubServer) GetDeployment(context.Context, *GetDeploymentRequest) (*Deployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDeployment not implemented")
}
func (*UnimplementedApiHubServer) ListDeployments(context.Context, *ListDeploymentsRequest) (*ListDeploymentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeployments not implemented")
}
func (*UnimplementedApiHubServer) UpdateDeployment(context.Context, *UpdateDeploymentRequest) (*Deployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDeployment not implemented")
}
func (*UnimplementedApiHubServer) DeleteDeployment(context.Context, *DeleteDeploymentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDeployment not implemented")
}
func (*UnimplementedApiHubServer) CreateAttribute(context.Context, *CreateAttributeRequest) (*Attribute, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAttribute not implemented")
}
func (*UnimplementedApiHubServer) GetAttribute(context.Context, *GetAttributeRequest) (*Attribute, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAttribute not implemented")
}
func (*UnimplementedApiHubServer) UpdateAttribute(context.Context, *UpdateAttributeRequest) (*Attribute, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAttribute not implemented")
}
func (*UnimplementedApiHubServer) DeleteAttribute(context.Context, *DeleteAttributeRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAttribute not implemented")
}
func (*UnimplementedApiHubServer) ListAttributes(context.Context, *ListAttributesRequest) (*ListAttributesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAttributes not implemented")
}
func (*UnimplementedApiHubServer) SearchResources(context.Context, *SearchResourcesRequest) (*SearchResourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchResources not implemented")
}
func (*UnimplementedApiHubServer) CreateExternalApi(context.Context, *CreateExternalApiRequest) (*ExternalApi, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateExternalApi not implemented")
}
func (*UnimplementedApiHubServer) GetExternalApi(context.Context, *GetExternalApiRequest) (*ExternalApi, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetExternalApi not implemented")
}
func (*UnimplementedApiHubServer) UpdateExternalApi(context.Context, *UpdateExternalApiRequest) (*ExternalApi, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateExternalApi not implemented")
}
func (*UnimplementedApiHubServer) DeleteExternalApi(context.Context, *DeleteExternalApiRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteExternalApi not implemented")
}
func (*UnimplementedApiHubServer) ListExternalApis(context.Context, *ListExternalApisRequest) (*ListExternalApisResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListExternalApis not implemented")
}

func RegisterApiHubServer(s *grpc.Server, srv ApiHubServer) {
	s.RegisterService(&_ApiHub_serviceDesc, srv)
}

func _ApiHub_CreateApi_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateApiRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).CreateApi(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/CreateApi",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).CreateApi(ctx, req.(*CreateApiRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_GetApi_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApiRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).GetApi(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/GetApi",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).GetApi(ctx, req.(*GetApiRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_ListApis_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListApisRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).ListApis(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/ListApis",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).ListApis(ctx, req.(*ListApisRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_UpdateApi_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateApiRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).UpdateApi(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/UpdateApi",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).UpdateApi(ctx, req.(*UpdateApiRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_DeleteApi_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteApiRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).DeleteApi(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/DeleteApi",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).DeleteApi(ctx, req.(*DeleteApiRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_CreateVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).CreateVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/CreateVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).CreateVersion(ctx, req.(*CreateVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_GetVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).GetVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/GetVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).GetVersion(ctx, req.(*GetVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_ListVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).ListVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/ListVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).ListVersions(ctx, req.(*ListVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_UpdateVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).UpdateVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/UpdateVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).UpdateVersion(ctx, req.(*UpdateVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_DeleteVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).DeleteVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/DeleteVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).DeleteVersion(ctx, req.(*DeleteVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_CreateSpec_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSpecRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).CreateSpec(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/CreateSpec",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).CreateSpec(ctx, req.(*CreateSpecRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_GetSpec_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSpecRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).GetSpec(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/GetSpec",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).GetSpec(ctx, req.(*GetSpecRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_GetSpecContents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSpecContentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).GetSpecContents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/GetSpecContents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).GetSpecContents(ctx, req.(*GetSpecContentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_ListSpecs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSpecsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).ListSpecs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/ListSpecs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).ListSpecs(ctx, req.(*ListSpecsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_UpdateSpec_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSpecRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).UpdateSpec(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/UpdateSpec",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).UpdateSpec(ctx, req.(*UpdateSpecRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_DeleteSpec_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSpecRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).DeleteSpec(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/DeleteSpec",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).DeleteSpec(ctx, req.(*DeleteSpecRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_GetApiOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApiOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).GetApiOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/GetApiOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).GetApiOperation(ctx, req.(*GetApiOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_ListApiOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListApiOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).ListApiOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/ListApiOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).ListApiOperations(ctx, req.(*ListApiOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_GetDefinition_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDefinitionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).GetDefinition(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/GetDefinition",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).GetDefinition(ctx, req.(*GetDefinitionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_CreateDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).CreateDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/CreateDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).CreateDeployment(ctx, req.(*CreateDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_GetDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).GetDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/GetDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).GetDeployment(ctx, req.(*GetDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_ListDeployments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeploymentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).ListDeployments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/ListDeployments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).ListDeployments(ctx, req.(*ListDeploymentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_UpdateDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).UpdateDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/UpdateDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).UpdateDeployment(ctx, req.(*UpdateDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_DeleteDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).DeleteDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/DeleteDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).DeleteDeployment(ctx, req.(*DeleteDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_CreateAttribute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAttributeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).CreateAttribute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/CreateAttribute",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).CreateAttribute(ctx, req.(*CreateAttributeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_GetAttribute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAttributeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).GetAttribute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/GetAttribute",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).GetAttribute(ctx, req.(*GetAttributeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_UpdateAttribute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAttributeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).UpdateAttribute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/UpdateAttribute",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).UpdateAttribute(ctx, req.(*UpdateAttributeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_DeleteAttribute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAttributeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).DeleteAttribute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/DeleteAttribute",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).DeleteAttribute(ctx, req.(*DeleteAttributeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_ListAttributes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAttributesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).ListAttributes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/ListAttributes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).ListAttributes(ctx, req.(*ListAttributesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_SearchResources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchResourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).SearchResources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/SearchResources",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).SearchResources(ctx, req.(*SearchResourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_CreateExternalApi_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateExternalApiRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).CreateExternalApi(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/CreateExternalApi",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).CreateExternalApi(ctx, req.(*CreateExternalApiRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_GetExternalApi_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetExternalApiRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).GetExternalApi(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/GetExternalApi",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).GetExternalApi(ctx, req.(*GetExternalApiRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_UpdateExternalApi_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateExternalApiRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).UpdateExternalApi(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/UpdateExternalApi",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).UpdateExternalApi(ctx, req.(*UpdateExternalApiRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_DeleteExternalApi_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteExternalApiRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).DeleteExternalApi(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/DeleteExternalApi",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).DeleteExternalApi(ctx, req.(*DeleteExternalApiRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHub_ListExternalApis_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListExternalApisRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubServer).ListExternalApis(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHub/ListExternalApis",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubServer).ListExternalApis(ctx, req.(*ListExternalApisRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ApiHub_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.apihub.v1.ApiHub",
	HandlerType: (*ApiHubServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateApi",
			Handler:    _ApiHub_CreateApi_Handler,
		},
		{
			MethodName: "GetApi",
			Handler:    _ApiHub_GetApi_Handler,
		},
		{
			MethodName: "ListApis",
			Handler:    _ApiHub_ListApis_Handler,
		},
		{
			MethodName: "UpdateApi",
			Handler:    _ApiHub_UpdateApi_Handler,
		},
		{
			MethodName: "DeleteApi",
			Handler:    _ApiHub_DeleteApi_Handler,
		},
		{
			MethodName: "CreateVersion",
			Handler:    _ApiHub_CreateVersion_Handler,
		},
		{
			MethodName: "GetVersion",
			Handler:    _ApiHub_GetVersion_Handler,
		},
		{
			MethodName: "ListVersions",
			Handler:    _ApiHub_ListVersions_Handler,
		},
		{
			MethodName: "UpdateVersion",
			Handler:    _ApiHub_UpdateVersion_Handler,
		},
		{
			MethodName: "DeleteVersion",
			Handler:    _ApiHub_DeleteVersion_Handler,
		},
		{
			MethodName: "CreateSpec",
			Handler:    _ApiHub_CreateSpec_Handler,
		},
		{
			MethodName: "GetSpec",
			Handler:    _ApiHub_GetSpec_Handler,
		},
		{
			MethodName: "GetSpecContents",
			Handler:    _ApiHub_GetSpecContents_Handler,
		},
		{
			MethodName: "ListSpecs",
			Handler:    _ApiHub_ListSpecs_Handler,
		},
		{
			MethodName: "UpdateSpec",
			Handler:    _ApiHub_UpdateSpec_Handler,
		},
		{
			MethodName: "DeleteSpec",
			Handler:    _ApiHub_DeleteSpec_Handler,
		},
		{
			MethodName: "GetApiOperation",
			Handler:    _ApiHub_GetApiOperation_Handler,
		},
		{
			MethodName: "ListApiOperations",
			Handler:    _ApiHub_ListApiOperations_Handler,
		},
		{
			MethodName: "GetDefinition",
			Handler:    _ApiHub_GetDefinition_Handler,
		},
		{
			MethodName: "CreateDeployment",
			Handler:    _ApiHub_CreateDeployment_Handler,
		},
		{
			MethodName: "GetDeployment",
			Handler:    _ApiHub_GetDeployment_Handler,
		},
		{
			MethodName: "ListDeployments",
			Handler:    _ApiHub_ListDeployments_Handler,
		},
		{
			MethodName: "UpdateDeployment",
			Handler:    _ApiHub_UpdateDeployment_Handler,
		},
		{
			MethodName: "DeleteDeployment",
			Handler:    _ApiHub_DeleteDeployment_Handler,
		},
		{
			MethodName: "CreateAttribute",
			Handler:    _ApiHub_CreateAttribute_Handler,
		},
		{
			MethodName: "GetAttribute",
			Handler:    _ApiHub_GetAttribute_Handler,
		},
		{
			MethodName: "UpdateAttribute",
			Handler:    _ApiHub_UpdateAttribute_Handler,
		},
		{
			MethodName: "DeleteAttribute",
			Handler:    _ApiHub_DeleteAttribute_Handler,
		},
		{
			MethodName: "ListAttributes",
			Handler:    _ApiHub_ListAttributes_Handler,
		},
		{
			MethodName: "SearchResources",
			Handler:    _ApiHub_SearchResources_Handler,
		},
		{
			MethodName: "CreateExternalApi",
			Handler:    _ApiHub_CreateExternalApi_Handler,
		},
		{
			MethodName: "GetExternalApi",
			Handler:    _ApiHub_GetExternalApi_Handler,
		},
		{
			MethodName: "UpdateExternalApi",
			Handler:    _ApiHub_UpdateExternalApi_Handler,
		},
		{
			MethodName: "DeleteExternalApi",
			Handler:    _ApiHub_DeleteExternalApi_Handler,
		},
		{
			MethodName: "ListExternalApis",
			Handler:    _ApiHub_ListExternalApis_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/apihub/v1/apihub_service.proto",
}

// ApiHubDependenciesClient is the client API for ApiHubDependencies service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ApiHubDependenciesClient interface {
	// Create a dependency between two entities in the API hub.
	CreateDependency(ctx context.Context, in *CreateDependencyRequest, opts ...grpc.CallOption) (*Dependency, error)
	// Get details about a dependency resource in the API hub.
	GetDependency(ctx context.Context, in *GetDependencyRequest, opts ...grpc.CallOption) (*Dependency, error)
	// Update a dependency based on the
	// [update_mask][google.cloud.apihub.v1.UpdateDependencyRequest.update_mask]
	// provided in the request.
	//
	// The following fields in the [dependency][google.cloud.apihub.v1.Dependency]
	// can be updated:
	// * [description][google.cloud.apihub.v1.Dependency.description]
	UpdateDependency(ctx context.Context, in *UpdateDependencyRequest, opts ...grpc.CallOption) (*Dependency, error)
	// Delete the dependency resource.
	DeleteDependency(ctx context.Context, in *DeleteDependencyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// List dependencies based on the provided filter and pagination parameters.
	ListDependencies(ctx context.Context, in *ListDependenciesRequest, opts ...grpc.CallOption) (*ListDependenciesResponse, error)
}

type apiHubDependenciesClient struct {
	cc grpc.ClientConnInterface
}

func NewApiHubDependenciesClient(cc grpc.ClientConnInterface) ApiHubDependenciesClient {
	return &apiHubDependenciesClient{cc}
}

func (c *apiHubDependenciesClient) CreateDependency(ctx context.Context, in *CreateDependencyRequest, opts ...grpc.CallOption) (*Dependency, error) {
	out := new(Dependency)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHubDependencies/CreateDependency", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubDependenciesClient) GetDependency(ctx context.Context, in *GetDependencyRequest, opts ...grpc.CallOption) (*Dependency, error) {
	out := new(Dependency)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHubDependencies/GetDependency", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubDependenciesClient) UpdateDependency(ctx context.Context, in *UpdateDependencyRequest, opts ...grpc.CallOption) (*Dependency, error) {
	out := new(Dependency)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHubDependencies/UpdateDependency", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubDependenciesClient) DeleteDependency(ctx context.Context, in *DeleteDependencyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHubDependencies/DeleteDependency", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubDependenciesClient) ListDependencies(ctx context.Context, in *ListDependenciesRequest, opts ...grpc.CallOption) (*ListDependenciesResponse, error) {
	out := new(ListDependenciesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHubDependencies/ListDependencies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ApiHubDependenciesServer is the server API for ApiHubDependencies service.
type ApiHubDependenciesServer interface {
	// Create a dependency between two entities in the API hub.
	CreateDependency(context.Context, *CreateDependencyRequest) (*Dependency, error)
	// Get details about a dependency resource in the API hub.
	GetDependency(context.Context, *GetDependencyRequest) (*Dependency, error)
	// Update a dependency based on the
	// [update_mask][google.cloud.apihub.v1.UpdateDependencyRequest.update_mask]
	// provided in the request.
	//
	// The following fields in the [dependency][google.cloud.apihub.v1.Dependency]
	// can be updated:
	// * [description][google.cloud.apihub.v1.Dependency.description]
	UpdateDependency(context.Context, *UpdateDependencyRequest) (*Dependency, error)
	// Delete the dependency resource.
	DeleteDependency(context.Context, *DeleteDependencyRequest) (*emptypb.Empty, error)
	// List dependencies based on the provided filter and pagination parameters.
	ListDependencies(context.Context, *ListDependenciesRequest) (*ListDependenciesResponse, error)
}

// UnimplementedApiHubDependenciesServer can be embedded to have forward compatible implementations.
type UnimplementedApiHubDependenciesServer struct {
}

func (*UnimplementedApiHubDependenciesServer) CreateDependency(context.Context, *CreateDependencyRequest) (*Dependency, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDependency not implemented")
}
func (*UnimplementedApiHubDependenciesServer) GetDependency(context.Context, *GetDependencyRequest) (*Dependency, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDependency not implemented")
}
func (*UnimplementedApiHubDependenciesServer) UpdateDependency(context.Context, *UpdateDependencyRequest) (*Dependency, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDependency not implemented")
}
func (*UnimplementedApiHubDependenciesServer) DeleteDependency(context.Context, *DeleteDependencyRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDependency not implemented")
}
func (*UnimplementedApiHubDependenciesServer) ListDependencies(context.Context, *ListDependenciesRequest) (*ListDependenciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDependencies not implemented")
}

func RegisterApiHubDependenciesServer(s *grpc.Server, srv ApiHubDependenciesServer) {
	s.RegisterService(&_ApiHubDependencies_serviceDesc, srv)
}

func _ApiHubDependencies_CreateDependency_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDependencyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubDependenciesServer).CreateDependency(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHubDependencies/CreateDependency",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubDependenciesServer).CreateDependency(ctx, req.(*CreateDependencyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHubDependencies_GetDependency_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDependencyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubDependenciesServer).GetDependency(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHubDependencies/GetDependency",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubDependenciesServer).GetDependency(ctx, req.(*GetDependencyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHubDependencies_UpdateDependency_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDependencyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubDependenciesServer).UpdateDependency(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHubDependencies/UpdateDependency",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubDependenciesServer).UpdateDependency(ctx, req.(*UpdateDependencyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHubDependencies_DeleteDependency_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDependencyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubDependenciesServer).DeleteDependency(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHubDependencies/DeleteDependency",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubDependenciesServer).DeleteDependency(ctx, req.(*DeleteDependencyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHubDependencies_ListDependencies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDependenciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubDependenciesServer).ListDependencies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHubDependencies/ListDependencies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubDependenciesServer).ListDependencies(ctx, req.(*ListDependenciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ApiHubDependencies_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.apihub.v1.ApiHubDependencies",
	HandlerType: (*ApiHubDependenciesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateDependency",
			Handler:    _ApiHubDependencies_CreateDependency_Handler,
		},
		{
			MethodName: "GetDependency",
			Handler:    _ApiHubDependencies_GetDependency_Handler,
		},
		{
			MethodName: "UpdateDependency",
			Handler:    _ApiHubDependencies_UpdateDependency_Handler,
		},
		{
			MethodName: "DeleteDependency",
			Handler:    _ApiHubDependencies_DeleteDependency_Handler,
		},
		{
			MethodName: "ListDependencies",
			Handler:    _ApiHubDependencies_ListDependencies_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/apihub/v1/apihub_service.proto",
}
