// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/alloydb/v1alpha/resources.proto

package alloydbpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	dayofweek "google.golang.org/genproto/googleapis/type/dayofweek"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// View on Instance. Pass this enum to rpcs that returns an Instance message to
// control which subsets of fields to get.
type InstanceView int32

const (
	// INSTANCE_VIEW_UNSPECIFIED Not specified, equivalent to BASIC.
	InstanceView_INSTANCE_VIEW_UNSPECIFIED InstanceView = 0
	// BASIC server responses for a primary or read instance include all the
	// relevant instance details, excluding the details of each node in the
	// instance. The default value.
	InstanceView_INSTANCE_VIEW_BASIC InstanceView = 1
	// FULL response is equivalent to BASIC for primary instance (for now).
	// For read pool instance, this includes details of each node in the pool.
	InstanceView_INSTANCE_VIEW_FULL InstanceView = 2
)

// Enum value maps for InstanceView.
var (
	InstanceView_name = map[int32]string{
		0: "INSTANCE_VIEW_UNSPECIFIED",
		1: "INSTANCE_VIEW_BASIC",
		2: "INSTANCE_VIEW_FULL",
	}
	InstanceView_value = map[string]int32{
		"INSTANCE_VIEW_UNSPECIFIED": 0,
		"INSTANCE_VIEW_BASIC":       1,
		"INSTANCE_VIEW_FULL":        2,
	}
)

func (x InstanceView) Enum() *InstanceView {
	p := new(InstanceView)
	*p = x
	return p
}

func (x InstanceView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[0].Descriptor()
}

func (InstanceView) Type() protoreflect.EnumType {
	return &file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[0]
}

func (x InstanceView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceView.Descriptor instead.
func (InstanceView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{0}
}

// View on Cluster. Pass this enum to rpcs that returns a cluster message to
// control which subsets of fields to get.
type ClusterView int32

const (
	// CLUSTER_VIEW_UNSPECIFIED Not specified, equivalent to BASIC.
	ClusterView_CLUSTER_VIEW_UNSPECIFIED ClusterView = 0
	// BASIC server responses include all the relevant cluster details, excluding
	// Cluster.ContinuousBackupInfo.EarliestRestorableTime and other view-specific
	// fields. The default value.
	ClusterView_CLUSTER_VIEW_BASIC ClusterView = 1
	// CONTINUOUS_BACKUP response returns all the fields from BASIC plus
	// the earliest restorable time if continuous backups are enabled.
	// May increase latency.
	ClusterView_CLUSTER_VIEW_CONTINUOUS_BACKUP ClusterView = 2
)

// Enum value maps for ClusterView.
var (
	ClusterView_name = map[int32]string{
		0: "CLUSTER_VIEW_UNSPECIFIED",
		1: "CLUSTER_VIEW_BASIC",
		2: "CLUSTER_VIEW_CONTINUOUS_BACKUP",
	}
	ClusterView_value = map[string]int32{
		"CLUSTER_VIEW_UNSPECIFIED":       0,
		"CLUSTER_VIEW_BASIC":             1,
		"CLUSTER_VIEW_CONTINUOUS_BACKUP": 2,
	}
)

func (x ClusterView) Enum() *ClusterView {
	p := new(ClusterView)
	*p = x
	return p
}

func (x ClusterView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ClusterView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[1].Descriptor()
}

func (ClusterView) Type() protoreflect.EnumType {
	return &file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[1]
}

func (x ClusterView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ClusterView.Descriptor instead.
func (ClusterView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{1}
}

// The supported database engine versions.
type DatabaseVersion int32

const (
	// This is an unknown database version.
	DatabaseVersion_DATABASE_VERSION_UNSPECIFIED DatabaseVersion = 0
	// DEPRECATED - The database version is Postgres 13.
	//
	// Deprecated: Marked as deprecated in google/cloud/alloydb/v1alpha/resources.proto.
	DatabaseVersion_POSTGRES_13 DatabaseVersion = 1
	// The database version is Postgres 14.
	DatabaseVersion_POSTGRES_14 DatabaseVersion = 2
	// The database version is Postgres 15.
	DatabaseVersion_POSTGRES_15 DatabaseVersion = 3
	// The database version is Postgres 16.
	DatabaseVersion_POSTGRES_16 DatabaseVersion = 4
)

// Enum value maps for DatabaseVersion.
var (
	DatabaseVersion_name = map[int32]string{
		0: "DATABASE_VERSION_UNSPECIFIED",
		1: "POSTGRES_13",
		2: "POSTGRES_14",
		3: "POSTGRES_15",
		4: "POSTGRES_16",
	}
	DatabaseVersion_value = map[string]int32{
		"DATABASE_VERSION_UNSPECIFIED": 0,
		"POSTGRES_13":                  1,
		"POSTGRES_14":                  2,
		"POSTGRES_15":                  3,
		"POSTGRES_16":                  4,
	}
)

func (x DatabaseVersion) Enum() *DatabaseVersion {
	p := new(DatabaseVersion)
	*p = x
	return p
}

func (x DatabaseVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatabaseVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[2].Descriptor()
}

func (DatabaseVersion) Type() protoreflect.EnumType {
	return &file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[2]
}

func (x DatabaseVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatabaseVersion.Descriptor instead.
func (DatabaseVersion) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{2}
}

// Subscription_type added to distinguish between Standard and Trial
// subscriptions. By default, a subscription type is considered STANDARD unless
// explicitly specified.
type SubscriptionType int32

const (
	// This is an unknown subscription type. By default, the subscription type is
	// STANDARD.
	SubscriptionType_SUBSCRIPTION_TYPE_UNSPECIFIED SubscriptionType = 0
	// Standard subscription.
	SubscriptionType_STANDARD SubscriptionType = 1
	// Trial subscription.
	SubscriptionType_TRIAL SubscriptionType = 2
)

// Enum value maps for SubscriptionType.
var (
	SubscriptionType_name = map[int32]string{
		0: "SUBSCRIPTION_TYPE_UNSPECIFIED",
		1: "STANDARD",
		2: "TRIAL",
	}
	SubscriptionType_value = map[string]int32{
		"SUBSCRIPTION_TYPE_UNSPECIFIED": 0,
		"STANDARD":                      1,
		"TRIAL":                         2,
	}
)

func (x SubscriptionType) Enum() *SubscriptionType {
	p := new(SubscriptionType)
	*p = x
	return p
}

func (x SubscriptionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SubscriptionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[3].Descriptor()
}

func (SubscriptionType) Type() protoreflect.EnumType {
	return &file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[3]
}

func (x SubscriptionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SubscriptionType.Descriptor instead.
func (SubscriptionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{3}
}

// Denote the type of migration source that created this cluster.
type MigrationSource_MigrationSourceType int32

const (
	// Migration source is unknown.
	MigrationSource_MIGRATION_SOURCE_TYPE_UNSPECIFIED MigrationSource_MigrationSourceType = 0
	// DMS source means the cluster was created via DMS migration job.
	MigrationSource_DMS MigrationSource_MigrationSourceType = 1
)

// Enum value maps for MigrationSource_MigrationSourceType.
var (
	MigrationSource_MigrationSourceType_name = map[int32]string{
		0: "MIGRATION_SOURCE_TYPE_UNSPECIFIED",
		1: "DMS",
	}
	MigrationSource_MigrationSourceType_value = map[string]int32{
		"MIGRATION_SOURCE_TYPE_UNSPECIFIED": 0,
		"DMS":                               1,
	}
)

func (x MigrationSource_MigrationSourceType) Enum() *MigrationSource_MigrationSourceType {
	p := new(MigrationSource_MigrationSourceType)
	*p = x
	return p
}

func (x MigrationSource_MigrationSourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MigrationSource_MigrationSourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[4].Descriptor()
}

func (MigrationSource_MigrationSourceType) Type() protoreflect.EnumType {
	return &file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[4]
}

func (x MigrationSource_MigrationSourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MigrationSource_MigrationSourceType.Descriptor instead.
func (MigrationSource_MigrationSourceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{1, 0}
}

// Possible encryption types.
type EncryptionInfo_Type int32

const (
	// Encryption type not specified. Defaults to GOOGLE_DEFAULT_ENCRYPTION.
	EncryptionInfo_TYPE_UNSPECIFIED EncryptionInfo_Type = 0
	// The data is encrypted at rest with a key that is fully managed by Google.
	// No key version will be populated. This is the default state.
	EncryptionInfo_GOOGLE_DEFAULT_ENCRYPTION EncryptionInfo_Type = 1
	// The data is encrypted at rest with a key that is managed by the customer.
	// KMS key versions will be populated.
	EncryptionInfo_CUSTOMER_MANAGED_ENCRYPTION EncryptionInfo_Type = 2
)

// Enum value maps for EncryptionInfo_Type.
var (
	EncryptionInfo_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "GOOGLE_DEFAULT_ENCRYPTION",
		2: "CUSTOMER_MANAGED_ENCRYPTION",
	}
	EncryptionInfo_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":            0,
		"GOOGLE_DEFAULT_ENCRYPTION":   1,
		"CUSTOMER_MANAGED_ENCRYPTION": 2,
	}
)

func (x EncryptionInfo_Type) Enum() *EncryptionInfo_Type {
	p := new(EncryptionInfo_Type)
	*p = x
	return p
}

func (x EncryptionInfo_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EncryptionInfo_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[5].Descriptor()
}

func (EncryptionInfo_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[5]
}

func (x EncryptionInfo_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EncryptionInfo_Type.Descriptor instead.
func (EncryptionInfo_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{3, 0}
}

// SSL mode options.
type SslConfig_SslMode int32

const (
	// SSL mode is not specified. Defaults to ENCRYPTED_ONLY.
	SslConfig_SSL_MODE_UNSPECIFIED SslConfig_SslMode = 0
	// SSL connections are optional. CA verification not enforced.
	//
	// Deprecated: Marked as deprecated in google/cloud/alloydb/v1alpha/resources.proto.
	SslConfig_SSL_MODE_ALLOW SslConfig_SslMode = 1
	// SSL connections are required. CA verification not enforced.
	// Clients may use locally self-signed certificates (default psql client
	// behavior).
	//
	// Deprecated: Marked as deprecated in google/cloud/alloydb/v1alpha/resources.proto.
	SslConfig_SSL_MODE_REQUIRE SslConfig_SslMode = 2
	// SSL connections are required. CA verification enforced.
	// Clients must have certificates signed by a Cluster CA, for example, using
	// GenerateClientCertificate.
	//
	// Deprecated: Marked as deprecated in google/cloud/alloydb/v1alpha/resources.proto.
	SslConfig_SSL_MODE_VERIFY_CA SslConfig_SslMode = 3
	// SSL connections are optional. CA verification not enforced.
	SslConfig_ALLOW_UNENCRYPTED_AND_ENCRYPTED SslConfig_SslMode = 4
	// SSL connections are required. CA verification not enforced.
	SslConfig_ENCRYPTED_ONLY SslConfig_SslMode = 5
)

// Enum value maps for SslConfig_SslMode.
var (
	SslConfig_SslMode_name = map[int32]string{
		0: "SSL_MODE_UNSPECIFIED",
		1: "SSL_MODE_ALLOW",
		2: "SSL_MODE_REQUIRE",
		3: "SSL_MODE_VERIFY_CA",
		4: "ALLOW_UNENCRYPTED_AND_ENCRYPTED",
		5: "ENCRYPTED_ONLY",
	}
	SslConfig_SslMode_value = map[string]int32{
		"SSL_MODE_UNSPECIFIED":            0,
		"SSL_MODE_ALLOW":                  1,
		"SSL_MODE_REQUIRE":                2,
		"SSL_MODE_VERIFY_CA":              3,
		"ALLOW_UNENCRYPTED_AND_ENCRYPTED": 4,
		"ENCRYPTED_ONLY":                  5,
	}
)

func (x SslConfig_SslMode) Enum() *SslConfig_SslMode {
	p := new(SslConfig_SslMode)
	*p = x
	return p
}

func (x SslConfig_SslMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SslConfig_SslMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[6].Descriptor()
}

func (SslConfig_SslMode) Type() protoreflect.EnumType {
	return &file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[6]
}

func (x SslConfig_SslMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SslConfig_SslMode.Descriptor instead.
func (SslConfig_SslMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{4, 0}
}

// Certificate Authority (CA) source for SSL/TLS certificates.
type SslConfig_CaSource int32

const (
	// Certificate Authority (CA) source not specified. Defaults to
	// CA_SOURCE_MANAGED.
	SslConfig_CA_SOURCE_UNSPECIFIED SslConfig_CaSource = 0
	// Certificate Authority (CA) managed by the AlloyDB Cluster.
	SslConfig_CA_SOURCE_MANAGED SslConfig_CaSource = 1
)

// Enum value maps for SslConfig_CaSource.
var (
	SslConfig_CaSource_name = map[int32]string{
		0: "CA_SOURCE_UNSPECIFIED",
		1: "CA_SOURCE_MANAGED",
	}
	SslConfig_CaSource_value = map[string]int32{
		"CA_SOURCE_UNSPECIFIED": 0,
		"CA_SOURCE_MANAGED":     1,
	}
)

func (x SslConfig_CaSource) Enum() *SslConfig_CaSource {
	p := new(SslConfig_CaSource)
	*p = x
	return p
}

func (x SslConfig_CaSource) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SslConfig_CaSource) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[7].Descriptor()
}

func (SslConfig_CaSource) Type() protoreflect.EnumType {
	return &file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[7]
}

func (x SslConfig_CaSource) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SslConfig_CaSource.Descriptor instead.
func (SslConfig_CaSource) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{4, 1}
}

// Cluster State
type Cluster_State int32

const (
	// The state of the cluster is unknown.
	Cluster_STATE_UNSPECIFIED Cluster_State = 0
	// The cluster is active and running.
	Cluster_READY Cluster_State = 1
	// The cluster is stopped. All instances in the cluster are stopped.
	// Customers can start a stopped cluster at any point and all their
	// instances will come back to life with same names and IP resources. In
	// this state, customer pays for storage.
	// Associated backups could also be present in a stopped cluster.
	Cluster_STOPPED Cluster_State = 2
	// The cluster is empty and has no associated resources.
	// All instances, associated storage and backups have been deleted.
	Cluster_EMPTY Cluster_State = 3
	// The cluster is being created.
	Cluster_CREATING Cluster_State = 4
	// The cluster is being deleted.
	Cluster_DELETING Cluster_State = 5
	// The creation of the cluster failed.
	Cluster_FAILED Cluster_State = 6
	// The cluster is bootstrapping with data from some other source.
	// Direct mutations to the cluster (e.g. adding read pool) are not allowed.
	Cluster_BOOTSTRAPPING Cluster_State = 7
	// The cluster is under maintenance. AlloyDB regularly performs maintenance
	// and upgrades on customer clusters. Updates on the cluster are
	// not allowed while the cluster is in this state.
	Cluster_MAINTENANCE Cluster_State = 8
	// The cluster is being promoted.
	Cluster_PROMOTING Cluster_State = 9
)

// Enum value maps for Cluster_State.
var (
	Cluster_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "READY",
		2: "STOPPED",
		3: "EMPTY",
		4: "CREATING",
		5: "DELETING",
		6: "FAILED",
		7: "BOOTSTRAPPING",
		8: "MAINTENANCE",
		9: "PROMOTING",
	}
	Cluster_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"READY":             1,
		"STOPPED":           2,
		"EMPTY":             3,
		"CREATING":          4,
		"DELETING":          5,
		"FAILED":            6,
		"BOOTSTRAPPING":     7,
		"MAINTENANCE":       8,
		"PROMOTING":         9,
	}
)

func (x Cluster_State) Enum() *Cluster_State {
	p := new(Cluster_State)
	*p = x
	return p
}

func (x Cluster_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[8].Descriptor()
}

func (Cluster_State) Type() protoreflect.EnumType {
	return &file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[8]
}

func (x Cluster_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_State.Descriptor instead.
func (Cluster_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{12, 0}
}

// Type of Cluster
type Cluster_ClusterType int32

const (
	// The type of the cluster is unknown.
	Cluster_CLUSTER_TYPE_UNSPECIFIED Cluster_ClusterType = 0
	// Primary cluster that support read and write operations.
	Cluster_PRIMARY Cluster_ClusterType = 1
	// Secondary cluster that is replicating from another region.
	// This only supports read.
	Cluster_SECONDARY Cluster_ClusterType = 2
)

// Enum value maps for Cluster_ClusterType.
var (
	Cluster_ClusterType_name = map[int32]string{
		0: "CLUSTER_TYPE_UNSPECIFIED",
		1: "PRIMARY",
		2: "SECONDARY",
	}
	Cluster_ClusterType_value = map[string]int32{
		"CLUSTER_TYPE_UNSPECIFIED": 0,
		"PRIMARY":                  1,
		"SECONDARY":                2,
	}
)

func (x Cluster_ClusterType) Enum() *Cluster_ClusterType {
	p := new(Cluster_ClusterType)
	*p = x
	return p
}

func (x Cluster_ClusterType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_ClusterType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[9].Descriptor()
}

func (Cluster_ClusterType) Type() protoreflect.EnumType {
	return &file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[9]
}

func (x Cluster_ClusterType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_ClusterType.Descriptor instead.
func (Cluster_ClusterType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{12, 1}
}

// Instance State
type Instance_State int32

const (
	// The state of the instance is unknown.
	Instance_STATE_UNSPECIFIED Instance_State = 0
	// The instance is active and running.
	Instance_READY Instance_State = 1
	// The instance is stopped. Instance name and IP resources are preserved.
	Instance_STOPPED Instance_State = 2
	// The instance is being created.
	Instance_CREATING Instance_State = 3
	// The instance is being deleted.
	Instance_DELETING Instance_State = 4
	// The instance is down for maintenance.
	Instance_MAINTENANCE Instance_State = 5
	// The creation of the instance failed or a fatal error occurred during
	// an operation on the instance.
	// Note: Instances in this state would tried to be auto-repaired. And
	// Customers should be able to restart, update or delete these instances.
	Instance_FAILED Instance_State = 6
	// Index 7 is used in the producer apis for ROLLED_BACK state. Keeping that
	// index unused in case that state also needs to exposed via consumer apis
	// in future.
	// The instance has been configured to sync data from some other source.
	Instance_BOOTSTRAPPING Instance_State = 8
	// The instance is being promoted.
	Instance_PROMOTING Instance_State = 9
)

// Enum value maps for Instance_State.
var (
	Instance_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "READY",
		2: "STOPPED",
		3: "CREATING",
		4: "DELETING",
		5: "MAINTENANCE",
		6: "FAILED",
		8: "BOOTSTRAPPING",
		9: "PROMOTING",
	}
	Instance_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"READY":             1,
		"STOPPED":           2,
		"CREATING":          3,
		"DELETING":          4,
		"MAINTENANCE":       5,
		"FAILED":            6,
		"BOOTSTRAPPING":     8,
		"PROMOTING":         9,
	}
)

func (x Instance_State) Enum() *Instance_State {
	p := new(Instance_State)
	*p = x
	return p
}

func (x Instance_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[10].Descriptor()
}

func (Instance_State) Type() protoreflect.EnumType {
	return &file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[10]
}

func (x Instance_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_State.Descriptor instead.
func (Instance_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{13, 0}
}

// Type of an Instance
type Instance_InstanceType int32

const (
	// The type of the instance is unknown.
	Instance_INSTANCE_TYPE_UNSPECIFIED Instance_InstanceType = 0
	// PRIMARY instances support read and write operations.
	Instance_PRIMARY Instance_InstanceType = 1
	// READ POOL instances support read operations only. Each read pool instance
	// consists of one or more homogeneous nodes.
	//   - Read pool of size 1 can only have zonal availability.
	//   - Read pools with node count of 2 or more can have regional
	//     availability (nodes are present in 2 or more zones in a region).
	Instance_READ_POOL Instance_InstanceType = 2
	// SECONDARY instances support read operations only. SECONDARY instance
	// is a cross-region read replica
	Instance_SECONDARY Instance_InstanceType = 3
)

// Enum value maps for Instance_InstanceType.
var (
	Instance_InstanceType_name = map[int32]string{
		0: "INSTANCE_TYPE_UNSPECIFIED",
		1: "PRIMARY",
		2: "READ_POOL",
		3: "SECONDARY",
	}
	Instance_InstanceType_value = map[string]int32{
		"INSTANCE_TYPE_UNSPECIFIED": 0,
		"PRIMARY":                   1,
		"READ_POOL":                 2,
		"SECONDARY":                 3,
	}
)

func (x Instance_InstanceType) Enum() *Instance_InstanceType {
	p := new(Instance_InstanceType)
	*p = x
	return p
}

func (x Instance_InstanceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_InstanceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[11].Descriptor()
}

func (Instance_InstanceType) Type() protoreflect.EnumType {
	return &file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[11]
}

func (x Instance_InstanceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_InstanceType.Descriptor instead.
func (Instance_InstanceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{13, 1}
}

// The Availability type of an instance. Potential values:
//
//   - ZONAL: The instance serves data from only one zone. Outages in that
//     zone affect instance availability.
//   - REGIONAL: The instance can serve data from more than one zone in a
//     region (it is highly available).
type Instance_AvailabilityType int32

const (
	// This is an unknown Availability type.
	Instance_AVAILABILITY_TYPE_UNSPECIFIED Instance_AvailabilityType = 0
	// Zonal available instance.
	Instance_ZONAL Instance_AvailabilityType = 1
	// Regional (or Highly) available instance.
	Instance_REGIONAL Instance_AvailabilityType = 2
)

// Enum value maps for Instance_AvailabilityType.
var (
	Instance_AvailabilityType_name = map[int32]string{
		0: "AVAILABILITY_TYPE_UNSPECIFIED",
		1: "ZONAL",
		2: "REGIONAL",
	}
	Instance_AvailabilityType_value = map[string]int32{
		"AVAILABILITY_TYPE_UNSPECIFIED": 0,
		"ZONAL":                         1,
		"REGIONAL":                      2,
	}
)

func (x Instance_AvailabilityType) Enum() *Instance_AvailabilityType {
	p := new(Instance_AvailabilityType)
	*p = x
	return p
}

func (x Instance_AvailabilityType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_AvailabilityType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[12].Descriptor()
}

func (Instance_AvailabilityType) Type() protoreflect.EnumType {
	return &file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[12]
}

func (x Instance_AvailabilityType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_AvailabilityType.Descriptor instead.
func (Instance_AvailabilityType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{13, 2}
}

// Specifies the available modes of update.
type Instance_UpdatePolicy_Mode int32

const (
	// Mode is unknown.
	Instance_UpdatePolicy_MODE_UNSPECIFIED Instance_UpdatePolicy_Mode = 0
	// Least disruptive way to apply the update.
	Instance_UpdatePolicy_DEFAULT Instance_UpdatePolicy_Mode = 1
	// Performs a forced update when applicable. This will be fast but may
	// incur a downtime.
	Instance_UpdatePolicy_FORCE_APPLY Instance_UpdatePolicy_Mode = 2
)

// Enum value maps for Instance_UpdatePolicy_Mode.
var (
	Instance_UpdatePolicy_Mode_name = map[int32]string{
		0: "MODE_UNSPECIFIED",
		1: "DEFAULT",
		2: "FORCE_APPLY",
	}
	Instance_UpdatePolicy_Mode_value = map[string]int32{
		"MODE_UNSPECIFIED": 0,
		"DEFAULT":          1,
		"FORCE_APPLY":      2,
	}
)

func (x Instance_UpdatePolicy_Mode) Enum() *Instance_UpdatePolicy_Mode {
	p := new(Instance_UpdatePolicy_Mode)
	*p = x
	return p
}

func (x Instance_UpdatePolicy_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_UpdatePolicy_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[13].Descriptor()
}

func (Instance_UpdatePolicy_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[13]
}

func (x Instance_UpdatePolicy_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_UpdatePolicy_Mode.Descriptor instead.
func (Instance_UpdatePolicy_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{13, 5, 0}
}

// Backup State
type Backup_State int32

const (
	// The state of the backup is unknown.
	Backup_STATE_UNSPECIFIED Backup_State = 0
	// The backup is ready.
	Backup_READY Backup_State = 1
	// The backup is creating.
	Backup_CREATING Backup_State = 2
	// The backup failed.
	Backup_FAILED Backup_State = 3
	// The backup is being deleted.
	Backup_DELETING Backup_State = 4
)

// Enum value maps for Backup_State.
var (
	Backup_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "READY",
		2: "CREATING",
		3: "FAILED",
		4: "DELETING",
	}
	Backup_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"READY":             1,
		"CREATING":          2,
		"FAILED":            3,
		"DELETING":          4,
	}
)

func (x Backup_State) Enum() *Backup_State {
	p := new(Backup_State)
	*p = x
	return p
}

func (x Backup_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Backup_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[14].Descriptor()
}

func (Backup_State) Type() protoreflect.EnumType {
	return &file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[14]
}

func (x Backup_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Backup_State.Descriptor instead.
func (Backup_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{15, 0}
}

// Backup Type
type Backup_Type int32

const (
	// Backup Type is unknown.
	Backup_TYPE_UNSPECIFIED Backup_Type = 0
	// ON_DEMAND backups that were triggered by the customer (e.g., not
	// AUTOMATED).
	Backup_ON_DEMAND Backup_Type = 1
	// AUTOMATED backups triggered by the automated backups scheduler pursuant
	// to an automated backup policy.
	Backup_AUTOMATED Backup_Type = 2
	// CONTINUOUS backups triggered by the automated backups scheduler
	// due to a continuous backup policy.
	Backup_CONTINUOUS Backup_Type = 3
)

// Enum value maps for Backup_Type.
var (
	Backup_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "ON_DEMAND",
		2: "AUTOMATED",
		3: "CONTINUOUS",
	}
	Backup_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"ON_DEMAND":        1,
		"AUTOMATED":        2,
		"CONTINUOUS":       3,
	}
)

func (x Backup_Type) Enum() *Backup_Type {
	p := new(Backup_Type)
	*p = x
	return p
}

func (x Backup_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Backup_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[15].Descriptor()
}

func (Backup_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[15]
}

func (x Backup_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Backup_Type.Descriptor instead.
func (Backup_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{15, 1}
}

// ValueType describes the semantic type of the value that the flag accepts.
// Regardless of the ValueType, the Instance.database_flags field accepts the
// stringified version of the value, i.e. "20" or "3.14".
type SupportedDatabaseFlag_ValueType int32

const (
	// This is an unknown flag type.
	SupportedDatabaseFlag_VALUE_TYPE_UNSPECIFIED SupportedDatabaseFlag_ValueType = 0
	// String type flag.
	SupportedDatabaseFlag_STRING SupportedDatabaseFlag_ValueType = 1
	// Integer type flag.
	SupportedDatabaseFlag_INTEGER SupportedDatabaseFlag_ValueType = 2
	// Float type flag.
	SupportedDatabaseFlag_FLOAT SupportedDatabaseFlag_ValueType = 3
	// Denotes that the flag does not accept any values.
	SupportedDatabaseFlag_NONE SupportedDatabaseFlag_ValueType = 4
)

// Enum value maps for SupportedDatabaseFlag_ValueType.
var (
	SupportedDatabaseFlag_ValueType_name = map[int32]string{
		0: "VALUE_TYPE_UNSPECIFIED",
		1: "STRING",
		2: "INTEGER",
		3: "FLOAT",
		4: "NONE",
	}
	SupportedDatabaseFlag_ValueType_value = map[string]int32{
		"VALUE_TYPE_UNSPECIFIED": 0,
		"STRING":                 1,
		"INTEGER":                2,
		"FLOAT":                  3,
		"NONE":                   4,
	}
)

func (x SupportedDatabaseFlag_ValueType) Enum() *SupportedDatabaseFlag_ValueType {
	p := new(SupportedDatabaseFlag_ValueType)
	*p = x
	return p
}

func (x SupportedDatabaseFlag_ValueType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SupportedDatabaseFlag_ValueType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[16].Descriptor()
}

func (SupportedDatabaseFlag_ValueType) Type() protoreflect.EnumType {
	return &file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[16]
}

func (x SupportedDatabaseFlag_ValueType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SupportedDatabaseFlag_ValueType.Descriptor instead.
func (SupportedDatabaseFlag_ValueType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{16, 0}
}

// Enum that details the user type.
type User_UserType int32

const (
	// Unspecified user type.
	User_USER_TYPE_UNSPECIFIED User_UserType = 0
	// The default user type that authenticates via password-based
	// authentication.
	User_ALLOYDB_BUILT_IN User_UserType = 1
	// Database user that can authenticate via IAM-Based authentication.
	User_ALLOYDB_IAM_USER User_UserType = 2
)

// Enum value maps for User_UserType.
var (
	User_UserType_name = map[int32]string{
		0: "USER_TYPE_UNSPECIFIED",
		1: "ALLOYDB_BUILT_IN",
		2: "ALLOYDB_IAM_USER",
	}
	User_UserType_value = map[string]int32{
		"USER_TYPE_UNSPECIFIED": 0,
		"ALLOYDB_BUILT_IN":      1,
		"ALLOYDB_IAM_USER":      2,
	}
)

func (x User_UserType) Enum() *User_UserType {
	p := new(User_UserType)
	*p = x
	return p
}

func (x User_UserType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (User_UserType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[17].Descriptor()
}

func (User_UserType) Type() protoreflect.EnumType {
	return &file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes[17]
}

func (x User_UserType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use User_UserType.Descriptor instead.
func (User_UserType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{17, 0}
}

// The username/password for a database user. Used for specifying initial
// users at cluster creation time.
type UserPassword struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The database username.
	User string `protobuf:"bytes,1,opt,name=user,proto3" json:"user,omitempty"`
	// The initial password for the user.
	Password string `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
}

func (x *UserPassword) Reset() {
	*x = UserPassword{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserPassword) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserPassword) ProtoMessage() {}

func (x *UserPassword) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserPassword.ProtoReflect.Descriptor instead.
func (*UserPassword) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{0}
}

func (x *UserPassword) GetUser() string {
	if x != nil {
		return x.User
	}
	return ""
}

func (x *UserPassword) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

// Subset of the source instance configuration that is available when reading
// the cluster resource.
type MigrationSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The host and port of the on-premises instance in host:port
	// format
	HostPort string `protobuf:"bytes,1,opt,name=host_port,json=hostPort,proto3" json:"host_port,omitempty"`
	// Output only. Place holder for the external source identifier(e.g DMS job
	// name) that created the cluster.
	ReferenceId string `protobuf:"bytes,2,opt,name=reference_id,json=referenceId,proto3" json:"reference_id,omitempty"`
	// Output only. Type of migration source.
	SourceType MigrationSource_MigrationSourceType `protobuf:"varint,3,opt,name=source_type,json=sourceType,proto3,enum=google.cloud.alloydb.v1alpha.MigrationSource_MigrationSourceType" json:"source_type,omitempty"`
}

func (x *MigrationSource) Reset() {
	*x = MigrationSource{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MigrationSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigrationSource) ProtoMessage() {}

func (x *MigrationSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigrationSource.ProtoReflect.Descriptor instead.
func (*MigrationSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{1}
}

func (x *MigrationSource) GetHostPort() string {
	if x != nil {
		return x.HostPort
	}
	return ""
}

func (x *MigrationSource) GetReferenceId() string {
	if x != nil {
		return x.ReferenceId
	}
	return ""
}

func (x *MigrationSource) GetSourceType() MigrationSource_MigrationSourceType {
	if x != nil {
		return x.SourceType
	}
	return MigrationSource_MIGRATION_SOURCE_TYPE_UNSPECIFIED
}

// EncryptionConfig describes the encryption config of a cluster or a backup
// that is encrypted with a CMEK (customer-managed encryption key).
type EncryptionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The fully-qualified resource name of the KMS key.
	// Each Cloud KMS key is regionalized and has the following format:
	// projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME]
	KmsKeyName string `protobuf:"bytes,1,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
}

func (x *EncryptionConfig) Reset() {
	*x = EncryptionConfig{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EncryptionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EncryptionConfig) ProtoMessage() {}

func (x *EncryptionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EncryptionConfig.ProtoReflect.Descriptor instead.
func (*EncryptionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{2}
}

func (x *EncryptionConfig) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

// EncryptionInfo describes the encryption information of a cluster or a backup.
type EncryptionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Type of encryption.
	EncryptionType EncryptionInfo_Type `protobuf:"varint,1,opt,name=encryption_type,json=encryptionType,proto3,enum=google.cloud.alloydb.v1alpha.EncryptionInfo_Type" json:"encryption_type,omitempty"`
	// Output only. Cloud KMS key versions that are being used to protect the
	// database or the backup.
	KmsKeyVersions []string `protobuf:"bytes,2,rep,name=kms_key_versions,json=kmsKeyVersions,proto3" json:"kms_key_versions,omitempty"`
}

func (x *EncryptionInfo) Reset() {
	*x = EncryptionInfo{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EncryptionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EncryptionInfo) ProtoMessage() {}

func (x *EncryptionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EncryptionInfo.ProtoReflect.Descriptor instead.
func (*EncryptionInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{3}
}

func (x *EncryptionInfo) GetEncryptionType() EncryptionInfo_Type {
	if x != nil {
		return x.EncryptionType
	}
	return EncryptionInfo_TYPE_UNSPECIFIED
}

func (x *EncryptionInfo) GetKmsKeyVersions() []string {
	if x != nil {
		return x.KmsKeyVersions
	}
	return nil
}

// SSL configuration.
type SslConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. SSL mode. Specifies client-server SSL/TLS connection behavior.
	SslMode SslConfig_SslMode `protobuf:"varint,1,opt,name=ssl_mode,json=sslMode,proto3,enum=google.cloud.alloydb.v1alpha.SslConfig_SslMode" json:"ssl_mode,omitempty"`
	// Optional. Certificate Authority (CA) source. Only CA_SOURCE_MANAGED is
	// supported currently, and is the default value.
	CaSource SslConfig_CaSource `protobuf:"varint,2,opt,name=ca_source,json=caSource,proto3,enum=google.cloud.alloydb.v1alpha.SslConfig_CaSource" json:"ca_source,omitempty"`
}

func (x *SslConfig) Reset() {
	*x = SslConfig{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SslConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SslConfig) ProtoMessage() {}

func (x *SslConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SslConfig.ProtoReflect.Descriptor instead.
func (*SslConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{4}
}

func (x *SslConfig) GetSslMode() SslConfig_SslMode {
	if x != nil {
		return x.SslMode
	}
	return SslConfig_SSL_MODE_UNSPECIFIED
}

func (x *SslConfig) GetCaSource() SslConfig_CaSource {
	if x != nil {
		return x.CaSource
	}
	return SslConfig_CA_SOURCE_UNSPECIFIED
}

// Message describing the user-specified automated backup policy.
//
// All fields in the automated backup policy are optional. Defaults for each
// field are provided if they are not set.
type AutomatedBackupPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The schedule for this automated backup policy.
	//
	// A schedule specifies times at which to start a backup. If a backup
	// window is also provided, the backup is guaranteed to be started and
	// completed within the start time plus the backup window. If the backup is
	// not completed within the backup window it is marked as failed.
	//
	// If not set, the schedule defaults to a weekly schedule with one backup
	// per day and a start time chosen arbitrarily.
	//
	// Types that are assignable to Schedule:
	//
	//	*AutomatedBackupPolicy_WeeklySchedule_
	Schedule isAutomatedBackupPolicy_Schedule `protobuf_oneof:"schedule"`
	// The retention policy for automated backups.
	//
	// The retention policy for a backup is fixed at the time the backup is
	// created. Changes to this field only apply to new backups taken with the
	// policy; the retentions of existing backups remain unchanged.
	//
	// If no retention policy is set, a default of 14 days is used.
	//
	// Types that are assignable to Retention:
	//
	//	*AutomatedBackupPolicy_TimeBasedRetention_
	//	*AutomatedBackupPolicy_QuantityBasedRetention_
	Retention isAutomatedBackupPolicy_Retention `protobuf_oneof:"retention"`
	// Whether automated automated backups are enabled. If not set, defaults to
	// true.
	Enabled *bool `protobuf:"varint,1,opt,name=enabled,proto3,oneof" json:"enabled,omitempty"`
	// The length of the time window during which a backup can be
	// taken. If a backup does not succeed within this time window, it will be
	// canceled and considered failed.
	//
	// The backup window must be at least 5 minutes long. There is no upper bound
	// on the window. If not set, it defaults to 1 hour.
	BackupWindow *durationpb.Duration `protobuf:"bytes,3,opt,name=backup_window,json=backupWindow,proto3" json:"backup_window,omitempty"`
	// Optional. The encryption config can be specified to encrypt the
	// backups with a customer-managed encryption key (CMEK). When this field is
	// not specified, the backup will then use default encryption scheme to
	// protect the user data.
	EncryptionConfig *EncryptionConfig `protobuf:"bytes,8,opt,name=encryption_config,json=encryptionConfig,proto3" json:"encryption_config,omitempty"`
	// The location where the backup will be stored. Currently, the only supported
	// option is to store the backup in the same region as the cluster.
	//
	// If empty, defaults to the region of the cluster.
	Location string `protobuf:"bytes,6,opt,name=location,proto3" json:"location,omitempty"`
	// Labels to apply to backups created using this configuration.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *AutomatedBackupPolicy) Reset() {
	*x = AutomatedBackupPolicy{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutomatedBackupPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutomatedBackupPolicy) ProtoMessage() {}

func (x *AutomatedBackupPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutomatedBackupPolicy.ProtoReflect.Descriptor instead.
func (*AutomatedBackupPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{5}
}

func (m *AutomatedBackupPolicy) GetSchedule() isAutomatedBackupPolicy_Schedule {
	if m != nil {
		return m.Schedule
	}
	return nil
}

func (x *AutomatedBackupPolicy) GetWeeklySchedule() *AutomatedBackupPolicy_WeeklySchedule {
	if x, ok := x.GetSchedule().(*AutomatedBackupPolicy_WeeklySchedule_); ok {
		return x.WeeklySchedule
	}
	return nil
}

func (m *AutomatedBackupPolicy) GetRetention() isAutomatedBackupPolicy_Retention {
	if m != nil {
		return m.Retention
	}
	return nil
}

func (x *AutomatedBackupPolicy) GetTimeBasedRetention() *AutomatedBackupPolicy_TimeBasedRetention {
	if x, ok := x.GetRetention().(*AutomatedBackupPolicy_TimeBasedRetention_); ok {
		return x.TimeBasedRetention
	}
	return nil
}

func (x *AutomatedBackupPolicy) GetQuantityBasedRetention() *AutomatedBackupPolicy_QuantityBasedRetention {
	if x, ok := x.GetRetention().(*AutomatedBackupPolicy_QuantityBasedRetention_); ok {
		return x.QuantityBasedRetention
	}
	return nil
}

func (x *AutomatedBackupPolicy) GetEnabled() bool {
	if x != nil && x.Enabled != nil {
		return *x.Enabled
	}
	return false
}

func (x *AutomatedBackupPolicy) GetBackupWindow() *durationpb.Duration {
	if x != nil {
		return x.BackupWindow
	}
	return nil
}

func (x *AutomatedBackupPolicy) GetEncryptionConfig() *EncryptionConfig {
	if x != nil {
		return x.EncryptionConfig
	}
	return nil
}

func (x *AutomatedBackupPolicy) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *AutomatedBackupPolicy) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

type isAutomatedBackupPolicy_Schedule interface {
	isAutomatedBackupPolicy_Schedule()
}

type AutomatedBackupPolicy_WeeklySchedule_ struct {
	// Weekly schedule for the Backup.
	WeeklySchedule *AutomatedBackupPolicy_WeeklySchedule `protobuf:"bytes,2,opt,name=weekly_schedule,json=weeklySchedule,proto3,oneof"`
}

func (*AutomatedBackupPolicy_WeeklySchedule_) isAutomatedBackupPolicy_Schedule() {}

type isAutomatedBackupPolicy_Retention interface {
	isAutomatedBackupPolicy_Retention()
}

type AutomatedBackupPolicy_TimeBasedRetention_ struct {
	// Time-based Backup retention policy.
	TimeBasedRetention *AutomatedBackupPolicy_TimeBasedRetention `protobuf:"bytes,4,opt,name=time_based_retention,json=timeBasedRetention,proto3,oneof"`
}

type AutomatedBackupPolicy_QuantityBasedRetention_ struct {
	// Quantity-based Backup retention policy to retain recent backups.
	QuantityBasedRetention *AutomatedBackupPolicy_QuantityBasedRetention `protobuf:"bytes,5,opt,name=quantity_based_retention,json=quantityBasedRetention,proto3,oneof"`
}

func (*AutomatedBackupPolicy_TimeBasedRetention_) isAutomatedBackupPolicy_Retention() {}

func (*AutomatedBackupPolicy_QuantityBasedRetention_) isAutomatedBackupPolicy_Retention() {}

// ContinuousBackupConfig describes the continuous backups recovery
// configurations of a cluster.
type ContinuousBackupConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether ContinuousBackup is enabled.
	Enabled *bool `protobuf:"varint,1,opt,name=enabled,proto3,oneof" json:"enabled,omitempty"`
	// The number of days that are eligible to restore from using PITR. To support
	// the entire recovery window, backups and logs are retained for one day more
	// than the recovery window. If not set, defaults to 14 days.
	RecoveryWindowDays int32 `protobuf:"varint,4,opt,name=recovery_window_days,json=recoveryWindowDays,proto3" json:"recovery_window_days,omitempty"`
	// The encryption config can be specified to encrypt the
	// backups with a customer-managed encryption key (CMEK). When this field is
	// not specified, the backup will then use default encryption scheme to
	// protect the user data.
	EncryptionConfig *EncryptionConfig `protobuf:"bytes,3,opt,name=encryption_config,json=encryptionConfig,proto3" json:"encryption_config,omitempty"`
}

func (x *ContinuousBackupConfig) Reset() {
	*x = ContinuousBackupConfig{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContinuousBackupConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContinuousBackupConfig) ProtoMessage() {}

func (x *ContinuousBackupConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContinuousBackupConfig.ProtoReflect.Descriptor instead.
func (*ContinuousBackupConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{6}
}

func (x *ContinuousBackupConfig) GetEnabled() bool {
	if x != nil && x.Enabled != nil {
		return *x.Enabled
	}
	return false
}

func (x *ContinuousBackupConfig) GetRecoveryWindowDays() int32 {
	if x != nil {
		return x.RecoveryWindowDays
	}
	return 0
}

func (x *ContinuousBackupConfig) GetEncryptionConfig() *EncryptionConfig {
	if x != nil {
		return x.EncryptionConfig
	}
	return nil
}

// ContinuousBackupInfo describes the continuous backup properties of a
// cluster.
type ContinuousBackupInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The encryption information for the WALs and backups required
	// for ContinuousBackup.
	EncryptionInfo *EncryptionInfo `protobuf:"bytes,1,opt,name=encryption_info,json=encryptionInfo,proto3" json:"encryption_info,omitempty"`
	// Output only. When ContinuousBackup was most recently enabled. Set to null
	// if ContinuousBackup is not enabled.
	EnabledTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=enabled_time,json=enabledTime,proto3" json:"enabled_time,omitempty"`
	// Output only. Days of the week on which a continuous backup is taken. Output
	// only field. Ignored if passed into the request.
	Schedule []dayofweek.DayOfWeek `protobuf:"varint,3,rep,packed,name=schedule,proto3,enum=google.type.DayOfWeek" json:"schedule,omitempty"`
	// Output only. The earliest restorable time that can be restored to. Output
	// only field.
	EarliestRestorableTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=earliest_restorable_time,json=earliestRestorableTime,proto3" json:"earliest_restorable_time,omitempty"`
}

func (x *ContinuousBackupInfo) Reset() {
	*x = ContinuousBackupInfo{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContinuousBackupInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContinuousBackupInfo) ProtoMessage() {}

func (x *ContinuousBackupInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContinuousBackupInfo.ProtoReflect.Descriptor instead.
func (*ContinuousBackupInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{7}
}

func (x *ContinuousBackupInfo) GetEncryptionInfo() *EncryptionInfo {
	if x != nil {
		return x.EncryptionInfo
	}
	return nil
}

func (x *ContinuousBackupInfo) GetEnabledTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EnabledTime
	}
	return nil
}

func (x *ContinuousBackupInfo) GetSchedule() []dayofweek.DayOfWeek {
	if x != nil {
		return x.Schedule
	}
	return nil
}

func (x *ContinuousBackupInfo) GetEarliestRestorableTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EarliestRestorableTime
	}
	return nil
}

// Message describing a BackupSource.
type BackupSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The system-generated UID of the backup which was used to
	// create this resource. The UID is generated when the backup is created, and
	// it is retained until the backup is deleted.
	BackupUid string `protobuf:"bytes,2,opt,name=backup_uid,json=backupUid,proto3" json:"backup_uid,omitempty"`
	// Required. The name of the backup resource with the format:
	//   - projects/{project}/locations/{region}/backups/{backup_id}
	BackupName string `protobuf:"bytes,1,opt,name=backup_name,json=backupName,proto3" json:"backup_name,omitempty"`
}

func (x *BackupSource) Reset() {
	*x = BackupSource{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BackupSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupSource) ProtoMessage() {}

func (x *BackupSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupSource.ProtoReflect.Descriptor instead.
func (*BackupSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{8}
}

func (x *BackupSource) GetBackupUid() string {
	if x != nil {
		return x.BackupUid
	}
	return ""
}

func (x *BackupSource) GetBackupName() string {
	if x != nil {
		return x.BackupName
	}
	return ""
}

// Message describing a ContinuousBackupSource.
type ContinuousBackupSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The source cluster from which to restore. This cluster must have
	// continuous backup enabled for this operation to succeed. For the required
	// format, see the comment on the Cluster.name field.
	Cluster string `protobuf:"bytes,1,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Required. The point in time to restore to.
	PointInTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=point_in_time,json=pointInTime,proto3" json:"point_in_time,omitempty"`
}

func (x *ContinuousBackupSource) Reset() {
	*x = ContinuousBackupSource{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContinuousBackupSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContinuousBackupSource) ProtoMessage() {}

func (x *ContinuousBackupSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContinuousBackupSource.ProtoReflect.Descriptor instead.
func (*ContinuousBackupSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{9}
}

func (x *ContinuousBackupSource) GetCluster() string {
	if x != nil {
		return x.Cluster
	}
	return ""
}

func (x *ContinuousBackupSource) GetPointInTime() *timestamppb.Timestamp {
	if x != nil {
		return x.PointInTime
	}
	return nil
}

// MaintenanceUpdatePolicy defines the policy for system updates.
type MaintenanceUpdatePolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Preferred windows to perform maintenance. Currently limited to 1.
	MaintenanceWindows []*MaintenanceUpdatePolicy_MaintenanceWindow `protobuf:"bytes,1,rep,name=maintenance_windows,json=maintenanceWindows,proto3" json:"maintenance_windows,omitempty"`
}

func (x *MaintenanceUpdatePolicy) Reset() {
	*x = MaintenanceUpdatePolicy{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MaintenanceUpdatePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MaintenanceUpdatePolicy) ProtoMessage() {}

func (x *MaintenanceUpdatePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MaintenanceUpdatePolicy.ProtoReflect.Descriptor instead.
func (*MaintenanceUpdatePolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{10}
}

func (x *MaintenanceUpdatePolicy) GetMaintenanceWindows() []*MaintenanceUpdatePolicy_MaintenanceWindow {
	if x != nil {
		return x.MaintenanceWindows
	}
	return nil
}

// MaintenanceSchedule stores the maintenance schedule generated from
// the MaintenanceUpdatePolicy, once a maintenance rollout is triggered, if
// MaintenanceWindow is set, and if there is no conflicting DenyPeriod.
// The schedule is cleared once the update takes place. This field cannot be
// manually changed; modify the MaintenanceUpdatePolicy instead.
type MaintenanceSchedule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The scheduled start time for the maintenance.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
}

func (x *MaintenanceSchedule) Reset() {
	*x = MaintenanceSchedule{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MaintenanceSchedule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MaintenanceSchedule) ProtoMessage() {}

func (x *MaintenanceSchedule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MaintenanceSchedule.ProtoReflect.Descriptor instead.
func (*MaintenanceSchedule) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{11}
}

func (x *MaintenanceSchedule) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

// A cluster is a collection of regional AlloyDB resources. It can include a
// primary instance and one or more read pool instances.
// All cluster resources share a storage layer, which scales as needed.
type Cluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// In case of an imported cluster, this field contains information about the
	// source this cluster was imported from.
	//
	// Types that are assignable to Source:
	//
	//	*Cluster_BackupSource
	//	*Cluster_MigrationSource
	//	*Cluster_CloudsqlBackupRunSource
	Source isCluster_Source `protobuf_oneof:"source"`
	// Output only. The name of the cluster resource with the format:
	//   - projects/{project}/locations/{region}/clusters/{cluster_id}
	//
	// where the cluster ID segment should satisfy the regex expression
	// `[a-z0-9-]+`. For more details see https://google.aip.dev/122.
	// The prefix of the cluster resource name is the name of the parent resource:
	//   - projects/{project}/locations/{region}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// User-settable and human-readable display name for the Cluster.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The system-generated UID of the resource. The UID is assigned
	// when the resource is created, and it is retained until it is deleted.
	Uid string `protobuf:"bytes,3,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. Create time stamp
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Update time stamp
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Delete time stamp
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Labels as key value pairs
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The current serving state of the cluster.
	State Cluster_State `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.alloydb.v1alpha.Cluster_State" json:"state,omitempty"`
	// Output only. The type of the cluster. This is an output-only field and it's
	// populated at the Cluster creation time or the Cluster promotion
	// time. The cluster type is determined by which RPC was used to create
	// the cluster (i.e. `CreateCluster` vs. `CreateSecondaryCluster`
	ClusterType Cluster_ClusterType `protobuf:"varint,24,opt,name=cluster_type,json=clusterType,proto3,enum=google.cloud.alloydb.v1alpha.Cluster_ClusterType" json:"cluster_type,omitempty"`
	// Optional. The database engine major version. This is an optional field and
	// it is populated at the Cluster creation time. If a database version is not
	// supplied at cluster creation time, then a default database version will
	// be used.
	DatabaseVersion DatabaseVersion        `protobuf:"varint,9,opt,name=database_version,json=databaseVersion,proto3,enum=google.cloud.alloydb.v1alpha.DatabaseVersion" json:"database_version,omitempty"`
	NetworkConfig   *Cluster_NetworkConfig `protobuf:"bytes,29,opt,name=network_config,json=networkConfig,proto3" json:"network_config,omitempty"`
	// Required. The resource link for the VPC network in which cluster resources
	// are created and from which they are accessible via Private IP. The network
	// must belong to the same project as the cluster. It is specified in the
	// form: `projects/{project}/global/networks/{network_id}`. This is required
	// to create a cluster. Deprecated, use network_config.network instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/alloydb/v1alpha/resources.proto.
	Network string `protobuf:"bytes,10,opt,name=network,proto3" json:"network,omitempty"`
	// For Resource freshness validation (https://google.aip.dev/154)
	Etag string `protobuf:"bytes,11,opt,name=etag,proto3" json:"etag,omitempty"`
	// Annotations to allow client tools to store small amount of arbitrary data.
	// This is distinct from labels.
	// https://google.aip.dev/128
	Annotations map[string]string `protobuf:"bytes,12,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Reconciling (https://google.aip.dev/128#reconciliation).
	// Set to true if the current state of Cluster does not match the user's
	// intended state, and the service is actively updating the resource to
	// reconcile them. This can happen due to user-triggered updates or
	// system actions like failover or maintenance.
	Reconciling bool `protobuf:"varint,13,opt,name=reconciling,proto3" json:"reconciling,omitempty"`
	// Input only. Initial user to setup during cluster creation. Required.
	// If used in `RestoreCluster` this is ignored.
	InitialUser *UserPassword `protobuf:"bytes,14,opt,name=initial_user,json=initialUser,proto3" json:"initial_user,omitempty"`
	// The automated backup policy for this cluster.
	//
	// If no policy is provided then the default policy will be used. If backups
	// are supported for the cluster, the default policy takes one backup a day,
	// has a backup window of 1 hour, and retains backups for 14 days.
	// For more information on the defaults, consult the
	// documentation for the message type.
	AutomatedBackupPolicy *AutomatedBackupPolicy `protobuf:"bytes,17,opt,name=automated_backup_policy,json=automatedBackupPolicy,proto3" json:"automated_backup_policy,omitempty"`
	// SSL configuration for this AlloyDB cluster.
	//
	// Deprecated: Marked as deprecated in google/cloud/alloydb/v1alpha/resources.proto.
	SslConfig *SslConfig `protobuf:"bytes,18,opt,name=ssl_config,json=sslConfig,proto3" json:"ssl_config,omitempty"`
	// Optional. The encryption config can be specified to encrypt the data disks
	// and other persistent data resources of a cluster with a
	// customer-managed encryption key (CMEK). When this field is not
	// specified, the cluster will then use default encryption scheme to
	// protect the user data.
	EncryptionConfig *EncryptionConfig `protobuf:"bytes,19,opt,name=encryption_config,json=encryptionConfig,proto3" json:"encryption_config,omitempty"`
	// Output only. The encryption information for the cluster.
	EncryptionInfo *EncryptionInfo `protobuf:"bytes,20,opt,name=encryption_info,json=encryptionInfo,proto3" json:"encryption_info,omitempty"`
	// Optional. Continuous backup configuration for this cluster.
	ContinuousBackupConfig *ContinuousBackupConfig `protobuf:"bytes,27,opt,name=continuous_backup_config,json=continuousBackupConfig,proto3" json:"continuous_backup_config,omitempty"`
	// Output only. Continuous backup properties for this cluster.
	ContinuousBackupInfo *ContinuousBackupInfo `protobuf:"bytes,28,opt,name=continuous_backup_info,json=continuousBackupInfo,proto3" json:"continuous_backup_info,omitempty"`
	// Cross Region replication config specific to SECONDARY cluster.
	SecondaryConfig *Cluster_SecondaryConfig `protobuf:"bytes,22,opt,name=secondary_config,json=secondaryConfig,proto3" json:"secondary_config,omitempty"`
	// Output only. Cross Region replication config specific to PRIMARY cluster.
	PrimaryConfig *Cluster_PrimaryConfig `protobuf:"bytes,23,opt,name=primary_config,json=primaryConfig,proto3" json:"primary_config,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzi bool `protobuf:"varint,33,opt,name=satisfies_pzi,json=satisfiesPzi,proto3" json:"satisfies_pzi,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzs bool `protobuf:"varint,30,opt,name=satisfies_pzs,json=satisfiesPzs,proto3" json:"satisfies_pzs,omitempty"`
	// Optional. The configuration for Private Service Connect (PSC) for the
	// cluster.
	PscConfig *Cluster_PscConfig `protobuf:"bytes,31,opt,name=psc_config,json=pscConfig,proto3" json:"psc_config,omitempty"`
	// Optional. The maintenance update policy determines when to allow or deny
	// updates.
	MaintenanceUpdatePolicy *MaintenanceUpdatePolicy `protobuf:"bytes,32,opt,name=maintenance_update_policy,json=maintenanceUpdatePolicy,proto3" json:"maintenance_update_policy,omitempty"`
	// Output only. The maintenance schedule for the cluster, generated for a
	// specific rollout if a maintenance window is set.
	MaintenanceSchedule *MaintenanceSchedule `protobuf:"bytes,37,opt,name=maintenance_schedule,json=maintenanceSchedule,proto3" json:"maintenance_schedule,omitempty"`
	// Optional. Configuration parameters related to the Gemini in Databases
	// add-on.
	GeminiConfig *GeminiClusterConfig `protobuf:"bytes,36,opt,name=gemini_config,json=geminiConfig,proto3" json:"gemini_config,omitempty"`
	// Optional. Subscription type of the cluster.
	SubscriptionType SubscriptionType `protobuf:"varint,38,opt,name=subscription_type,json=subscriptionType,proto3,enum=google.cloud.alloydb.v1alpha.SubscriptionType" json:"subscription_type,omitempty"`
	// Output only. Metadata for free trial clusters
	TrialMetadata *Cluster_TrialMetadata `protobuf:"bytes,39,opt,name=trial_metadata,json=trialMetadata,proto3" json:"trial_metadata,omitempty"`
	// Optional. Input only. Immutable. Tag keys/values directly bound to this
	// resource. For example:
	// ```
	// "123/environment": "production",
	// "123/costCenter": "marketing"
	// ```
	Tags map[string]string `protobuf:"bytes,41,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Cluster) Reset() {
	*x = Cluster{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster) ProtoMessage() {}

func (x *Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster.ProtoReflect.Descriptor instead.
func (*Cluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{12}
}

func (m *Cluster) GetSource() isCluster_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *Cluster) GetBackupSource() *BackupSource {
	if x, ok := x.GetSource().(*Cluster_BackupSource); ok {
		return x.BackupSource
	}
	return nil
}

func (x *Cluster) GetMigrationSource() *MigrationSource {
	if x, ok := x.GetSource().(*Cluster_MigrationSource); ok {
		return x.MigrationSource
	}
	return nil
}

func (x *Cluster) GetCloudsqlBackupRunSource() *CloudSQLBackupRunSource {
	if x, ok := x.GetSource().(*Cluster_CloudsqlBackupRunSource); ok {
		return x.CloudsqlBackupRunSource
	}
	return nil
}

func (x *Cluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Cluster) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Cluster) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Cluster) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Cluster) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Cluster) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

func (x *Cluster) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Cluster) GetState() Cluster_State {
	if x != nil {
		return x.State
	}
	return Cluster_STATE_UNSPECIFIED
}

func (x *Cluster) GetClusterType() Cluster_ClusterType {
	if x != nil {
		return x.ClusterType
	}
	return Cluster_CLUSTER_TYPE_UNSPECIFIED
}

func (x *Cluster) GetDatabaseVersion() DatabaseVersion {
	if x != nil {
		return x.DatabaseVersion
	}
	return DatabaseVersion_DATABASE_VERSION_UNSPECIFIED
}

func (x *Cluster) GetNetworkConfig() *Cluster_NetworkConfig {
	if x != nil {
		return x.NetworkConfig
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/alloydb/v1alpha/resources.proto.
func (x *Cluster) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *Cluster) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Cluster) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *Cluster) GetReconciling() bool {
	if x != nil {
		return x.Reconciling
	}
	return false
}

func (x *Cluster) GetInitialUser() *UserPassword {
	if x != nil {
		return x.InitialUser
	}
	return nil
}

func (x *Cluster) GetAutomatedBackupPolicy() *AutomatedBackupPolicy {
	if x != nil {
		return x.AutomatedBackupPolicy
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/alloydb/v1alpha/resources.proto.
func (x *Cluster) GetSslConfig() *SslConfig {
	if x != nil {
		return x.SslConfig
	}
	return nil
}

func (x *Cluster) GetEncryptionConfig() *EncryptionConfig {
	if x != nil {
		return x.EncryptionConfig
	}
	return nil
}

func (x *Cluster) GetEncryptionInfo() *EncryptionInfo {
	if x != nil {
		return x.EncryptionInfo
	}
	return nil
}

func (x *Cluster) GetContinuousBackupConfig() *ContinuousBackupConfig {
	if x != nil {
		return x.ContinuousBackupConfig
	}
	return nil
}

func (x *Cluster) GetContinuousBackupInfo() *ContinuousBackupInfo {
	if x != nil {
		return x.ContinuousBackupInfo
	}
	return nil
}

func (x *Cluster) GetSecondaryConfig() *Cluster_SecondaryConfig {
	if x != nil {
		return x.SecondaryConfig
	}
	return nil
}

func (x *Cluster) GetPrimaryConfig() *Cluster_PrimaryConfig {
	if x != nil {
		return x.PrimaryConfig
	}
	return nil
}

func (x *Cluster) GetSatisfiesPzi() bool {
	if x != nil {
		return x.SatisfiesPzi
	}
	return false
}

func (x *Cluster) GetSatisfiesPzs() bool {
	if x != nil {
		return x.SatisfiesPzs
	}
	return false
}

func (x *Cluster) GetPscConfig() *Cluster_PscConfig {
	if x != nil {
		return x.PscConfig
	}
	return nil
}

func (x *Cluster) GetMaintenanceUpdatePolicy() *MaintenanceUpdatePolicy {
	if x != nil {
		return x.MaintenanceUpdatePolicy
	}
	return nil
}

func (x *Cluster) GetMaintenanceSchedule() *MaintenanceSchedule {
	if x != nil {
		return x.MaintenanceSchedule
	}
	return nil
}

func (x *Cluster) GetGeminiConfig() *GeminiClusterConfig {
	if x != nil {
		return x.GeminiConfig
	}
	return nil
}

func (x *Cluster) GetSubscriptionType() SubscriptionType {
	if x != nil {
		return x.SubscriptionType
	}
	return SubscriptionType_SUBSCRIPTION_TYPE_UNSPECIFIED
}

func (x *Cluster) GetTrialMetadata() *Cluster_TrialMetadata {
	if x != nil {
		return x.TrialMetadata
	}
	return nil
}

func (x *Cluster) GetTags() map[string]string {
	if x != nil {
		return x.Tags
	}
	return nil
}

type isCluster_Source interface {
	isCluster_Source()
}

type Cluster_BackupSource struct {
	// Output only. Cluster created from backup.
	BackupSource *BackupSource `protobuf:"bytes,15,opt,name=backup_source,json=backupSource,proto3,oneof"`
}

type Cluster_MigrationSource struct {
	// Output only. Cluster created via DMS migration.
	MigrationSource *MigrationSource `protobuf:"bytes,16,opt,name=migration_source,json=migrationSource,proto3,oneof"`
}

type Cluster_CloudsqlBackupRunSource struct {
	// Output only. Cluster created from CloudSQL snapshot.
	CloudsqlBackupRunSource *CloudSQLBackupRunSource `protobuf:"bytes,42,opt,name=cloudsql_backup_run_source,json=cloudsqlBackupRunSource,proto3,oneof"`
}

func (*Cluster_BackupSource) isCluster_Source() {}

func (*Cluster_MigrationSource) isCluster_Source() {}

func (*Cluster_CloudsqlBackupRunSource) isCluster_Source() {}

// An Instance is a computing unit that an end customer can connect to.
// It's the main unit of computing resources in AlloyDB.
type Instance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the instance resource with the format:
	//   - projects/{project}/locations/{region}/clusters/{cluster_id}/instances/{instance_id}
	//
	// where the cluster and instance ID segments should satisfy the regex
	// expression `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`, e.g. 1-63 characters of
	// lowercase letters, numbers, and dashes, starting with a letter, and ending
	// with a letter or number. For more details see https://google.aip.dev/122.
	// The prefix of the instance resource name is the name of the parent
	// resource:
	//   - projects/{project}/locations/{region}/clusters/{cluster_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// User-settable and human-readable display name for the Instance.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The system-generated UID of the resource. The UID is assigned
	// when the resource is created, and it is retained until it is deleted.
	Uid string `protobuf:"bytes,3,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. Create time stamp
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Update time stamp
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Delete time stamp
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Labels as key value pairs
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The current serving state of the instance.
	State Instance_State `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.alloydb.v1alpha.Instance_State" json:"state,omitempty"`
	// Required. The type of the instance. Specified at creation time.
	InstanceType Instance_InstanceType `protobuf:"varint,9,opt,name=instance_type,json=instanceType,proto3,enum=google.cloud.alloydb.v1alpha.Instance_InstanceType" json:"instance_type,omitempty"`
	// Configurations for the machines that host the underlying
	// database engine.
	MachineConfig *Instance_MachineConfig `protobuf:"bytes,10,opt,name=machine_config,json=machineConfig,proto3" json:"machine_config,omitempty"`
	// Availability type of an Instance.
	// If empty, defaults to REGIONAL for primary instances.
	// For read pools, availability_type is always UNSPECIFIED. Instances in the
	// read pools are evenly distributed across available zones within the region
	// (i.e. read pools with more than one node will have a node in at
	// least two zones).
	AvailabilityType Instance_AvailabilityType `protobuf:"varint,11,opt,name=availability_type,json=availabilityType,proto3,enum=google.cloud.alloydb.v1alpha.Instance_AvailabilityType" json:"availability_type,omitempty"`
	// The Compute Engine zone that the instance should serve from, per
	// https://cloud.google.com/compute/docs/regions-zones
	// This can ONLY be specified for ZONAL instances.
	// If present for a REGIONAL instance, an error will be thrown.
	// If this is absent for a ZONAL instance, instance is created in a random
	// zone with available capacity.
	GceZone string `protobuf:"bytes,12,opt,name=gce_zone,json=gceZone,proto3" json:"gce_zone,omitempty"`
	// Database flags. Set at instance level.
	//   - They are copied from primary instance on read instance creation.
	//   - Read instances can set new or override existing flags that are relevant
	//     for reads, e.g. for enabling columnar cache on a read instance. Flags
	//     set on read instance may or may not be present on primary.
	//
	// This is a list of "key": "value" pairs.
	// "key": The name of the flag. These flags are passed at instance setup time,
	// so include both server options and system variables for Postgres. Flags are
	// specified with underscores, not hyphens.
	// "value": The value of the flag. Booleans are set to **on** for true
	// and **off** for false. This field must be omitted if the flag
	// doesn't take a value.
	DatabaseFlags map[string]string `protobuf:"bytes,13,rep,name=database_flags,json=databaseFlags,proto3" json:"database_flags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. This is set for the read-write VM of the PRIMARY instance
	// only.
	WritableNode *Instance_Node `protobuf:"bytes,19,opt,name=writable_node,json=writableNode,proto3" json:"writable_node,omitempty"`
	// Output only. List of available read-only VMs in this instance, including
	// the standby for a PRIMARY instance.
	Nodes []*Instance_Node `protobuf:"bytes,20,rep,name=nodes,proto3" json:"nodes,omitempty"`
	// Configuration for query insights.
	QueryInsightsConfig *Instance_QueryInsightsInstanceConfig `protobuf:"bytes,21,opt,name=query_insights_config,json=queryInsightsConfig,proto3" json:"query_insights_config,omitempty"`
	// Configuration for observability.
	ObservabilityConfig *Instance_ObservabilityInstanceConfig `protobuf:"bytes,26,opt,name=observability_config,json=observabilityConfig,proto3" json:"observability_config,omitempty"`
	// Read pool instance configuration.
	// This is required if the value of instanceType is READ_POOL.
	ReadPoolConfig *Instance_ReadPoolConfig `protobuf:"bytes,14,opt,name=read_pool_config,json=readPoolConfig,proto3" json:"read_pool_config,omitempty"`
	// Output only. The IP address for the Instance.
	// This is the connection endpoint for an end-user application.
	IpAddress string `protobuf:"bytes,15,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	// Output only. The public IP addresses for the Instance. This is available
	// ONLY when enable_public_ip is set. This is the connection endpoint for an
	// end-user application.
	PublicIpAddress string `protobuf:"bytes,27,opt,name=public_ip_address,json=publicIpAddress,proto3" json:"public_ip_address,omitempty"`
	// Output only. Reconciling (https://google.aip.dev/128#reconciliation).
	// Set to true if the current state of Instance does not match the user's
	// intended state, and the service is actively updating the resource to
	// reconcile them. This can happen due to user-triggered updates or
	// system actions like failover or maintenance.
	Reconciling bool `protobuf:"varint,16,opt,name=reconciling,proto3" json:"reconciling,omitempty"`
	// For Resource freshness validation (https://google.aip.dev/154)
	Etag string `protobuf:"bytes,17,opt,name=etag,proto3" json:"etag,omitempty"`
	// Annotations to allow client tools to store small amount of arbitrary data.
	// This is distinct from labels.
	// https://google.aip.dev/128
	Annotations map[string]string `protobuf:"bytes,18,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Update policy that will be applied during instance update.
	// This field is not persisted when you update the instance.
	// To use a non-default update policy, you must
	// specify explicitly specify the value in each update request.
	UpdatePolicy *Instance_UpdatePolicy `protobuf:"bytes,22,opt,name=update_policy,json=updatePolicy,proto3" json:"update_policy,omitempty"`
	// Optional. Client connection specific configurations
	ClientConnectionConfig *Instance_ClientConnectionConfig `protobuf:"bytes,23,opt,name=client_connection_config,json=clientConnectionConfig,proto3" json:"client_connection_config,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzi bool `protobuf:"varint,30,opt,name=satisfies_pzi,json=satisfiesPzi,proto3" json:"satisfies_pzi,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzs bool `protobuf:"varint,24,opt,name=satisfies_pzs,json=satisfiesPzs,proto3" json:"satisfies_pzs,omitempty"`
	// Optional. The configuration for Private Service Connect (PSC) for the
	// instance.
	PscInstanceConfig *Instance_PscInstanceConfig `protobuf:"bytes,28,opt,name=psc_instance_config,json=pscInstanceConfig,proto3" json:"psc_instance_config,omitempty"`
	// Optional. Instance-level network configuration.
	NetworkConfig *Instance_InstanceNetworkConfig `protobuf:"bytes,29,opt,name=network_config,json=networkConfig,proto3" json:"network_config,omitempty"`
	// Optional. Configuration parameters related to the Gemini in Databases
	// add-on.
	GeminiConfig *GeminiInstanceConfig `protobuf:"bytes,33,opt,name=gemini_config,json=geminiConfig,proto3" json:"gemini_config,omitempty"`
	// Output only. All outbound public IP addresses configured for the instance.
	OutboundPublicIpAddresses []string `protobuf:"bytes,34,rep,name=outbound_public_ip_addresses,json=outboundPublicIpAddresses,proto3" json:"outbound_public_ip_addresses,omitempty"`
}

func (x *Instance) Reset() {
	*x = Instance{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Instance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance) ProtoMessage() {}

func (x *Instance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance.ProtoReflect.Descriptor instead.
func (*Instance) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{13}
}

func (x *Instance) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Instance) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Instance) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Instance) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Instance) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Instance) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

func (x *Instance) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Instance) GetState() Instance_State {
	if x != nil {
		return x.State
	}
	return Instance_STATE_UNSPECIFIED
}

func (x *Instance) GetInstanceType() Instance_InstanceType {
	if x != nil {
		return x.InstanceType
	}
	return Instance_INSTANCE_TYPE_UNSPECIFIED
}

func (x *Instance) GetMachineConfig() *Instance_MachineConfig {
	if x != nil {
		return x.MachineConfig
	}
	return nil
}

func (x *Instance) GetAvailabilityType() Instance_AvailabilityType {
	if x != nil {
		return x.AvailabilityType
	}
	return Instance_AVAILABILITY_TYPE_UNSPECIFIED
}

func (x *Instance) GetGceZone() string {
	if x != nil {
		return x.GceZone
	}
	return ""
}

func (x *Instance) GetDatabaseFlags() map[string]string {
	if x != nil {
		return x.DatabaseFlags
	}
	return nil
}

func (x *Instance) GetWritableNode() *Instance_Node {
	if x != nil {
		return x.WritableNode
	}
	return nil
}

func (x *Instance) GetNodes() []*Instance_Node {
	if x != nil {
		return x.Nodes
	}
	return nil
}

func (x *Instance) GetQueryInsightsConfig() *Instance_QueryInsightsInstanceConfig {
	if x != nil {
		return x.QueryInsightsConfig
	}
	return nil
}

func (x *Instance) GetObservabilityConfig() *Instance_ObservabilityInstanceConfig {
	if x != nil {
		return x.ObservabilityConfig
	}
	return nil
}

func (x *Instance) GetReadPoolConfig() *Instance_ReadPoolConfig {
	if x != nil {
		return x.ReadPoolConfig
	}
	return nil
}

func (x *Instance) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

func (x *Instance) GetPublicIpAddress() string {
	if x != nil {
		return x.PublicIpAddress
	}
	return ""
}

func (x *Instance) GetReconciling() bool {
	if x != nil {
		return x.Reconciling
	}
	return false
}

func (x *Instance) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Instance) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *Instance) GetUpdatePolicy() *Instance_UpdatePolicy {
	if x != nil {
		return x.UpdatePolicy
	}
	return nil
}

func (x *Instance) GetClientConnectionConfig() *Instance_ClientConnectionConfig {
	if x != nil {
		return x.ClientConnectionConfig
	}
	return nil
}

func (x *Instance) GetSatisfiesPzi() bool {
	if x != nil {
		return x.SatisfiesPzi
	}
	return false
}

func (x *Instance) GetSatisfiesPzs() bool {
	if x != nil {
		return x.SatisfiesPzs
	}
	return false
}

func (x *Instance) GetPscInstanceConfig() *Instance_PscInstanceConfig {
	if x != nil {
		return x.PscInstanceConfig
	}
	return nil
}

func (x *Instance) GetNetworkConfig() *Instance_InstanceNetworkConfig {
	if x != nil {
		return x.NetworkConfig
	}
	return nil
}

func (x *Instance) GetGeminiConfig() *GeminiInstanceConfig {
	if x != nil {
		return x.GeminiConfig
	}
	return nil
}

func (x *Instance) GetOutboundPublicIpAddresses() []string {
	if x != nil {
		return x.OutboundPublicIpAddresses
	}
	return nil
}

// ConnectionInfo singleton resource.
// https://google.aip.dev/156
type ConnectionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the ConnectionInfo singleton resource, e.g.:
	// projects/{project}/locations/{location}/clusters/*/instances/*/connectionInfo
	// This field currently has no semantic meaning.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The private network IP address for the Instance. This is the
	// default IP for the instance and is always created (even if enable_public_ip
	// is set). This is the connection endpoint for an end-user application.
	IpAddress string `protobuf:"bytes,2,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	// Output only. The public IP addresses for the Instance. This is available
	// ONLY when enable_public_ip is set. This is the connection endpoint for an
	// end-user application.
	PublicIpAddress string `protobuf:"bytes,5,opt,name=public_ip_address,json=publicIpAddress,proto3" json:"public_ip_address,omitempty"`
	// Output only. The pem-encoded chain that may be used to verify the X.509
	// certificate. Expected to be in issuer-to-root order according to RFC 5246.
	//
	// Deprecated: Marked as deprecated in google/cloud/alloydb/v1alpha/resources.proto.
	PemCertificateChain []string `protobuf:"bytes,3,rep,name=pem_certificate_chain,json=pemCertificateChain,proto3" json:"pem_certificate_chain,omitempty"`
	// Output only. The unique ID of the Instance.
	InstanceUid string `protobuf:"bytes,4,opt,name=instance_uid,json=instanceUid,proto3" json:"instance_uid,omitempty"`
	// Output only. The DNS name to use with PSC for the Instance.
	PscDnsName string `protobuf:"bytes,6,opt,name=psc_dns_name,json=pscDnsName,proto3" json:"psc_dns_name,omitempty"`
}

func (x *ConnectionInfo) Reset() {
	*x = ConnectionInfo{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConnectionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionInfo) ProtoMessage() {}

func (x *ConnectionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectionInfo.ProtoReflect.Descriptor instead.
func (*ConnectionInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{14}
}

func (x *ConnectionInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ConnectionInfo) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

func (x *ConnectionInfo) GetPublicIpAddress() string {
	if x != nil {
		return x.PublicIpAddress
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/alloydb/v1alpha/resources.proto.
func (x *ConnectionInfo) GetPemCertificateChain() []string {
	if x != nil {
		return x.PemCertificateChain
	}
	return nil
}

func (x *ConnectionInfo) GetInstanceUid() string {
	if x != nil {
		return x.InstanceUid
	}
	return ""
}

func (x *ConnectionInfo) GetPscDnsName() string {
	if x != nil {
		return x.PscDnsName
	}
	return ""
}

// Message describing Backup object
type Backup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the backup resource with the format:
	//   - projects/{project}/locations/{region}/backups/{backup_id}
	//
	// where the cluster and backup ID segments should satisfy the regex
	// expression `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`, e.g. 1-63 characters of
	// lowercase letters, numbers, and dashes, starting with a letter, and ending
	// with a letter or number. For more details see https://google.aip.dev/122.
	// The prefix of the backup resource name is the name of the parent
	// resource:
	//   - projects/{project}/locations/{region}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// User-settable and human-readable display name for the Backup.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The system-generated UID of the resource. The UID is assigned
	// when the resource is created, and it is retained until it is deleted.
	Uid string `protobuf:"bytes,3,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. Create time stamp
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Update time stamp
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Delete time stamp
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,15,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Labels as key value pairs
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The current state of the backup.
	State Backup_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.alloydb.v1alpha.Backup_State" json:"state,omitempty"`
	// The backup type, which suggests the trigger for the backup.
	Type Backup_Type `protobuf:"varint,8,opt,name=type,proto3,enum=google.cloud.alloydb.v1alpha.Backup_Type" json:"type,omitempty"`
	// User-provided description of the backup.
	Description string `protobuf:"bytes,9,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The system-generated UID of the cluster which was used to
	// create this resource.
	ClusterUid string `protobuf:"bytes,18,opt,name=cluster_uid,json=clusterUid,proto3" json:"cluster_uid,omitempty"`
	// Required. The full resource name of the backup source cluster
	// (e.g., projects/{project}/locations/{region}/clusters/{cluster_id}).
	ClusterName string `protobuf:"bytes,10,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	// Output only. Reconciling (https://google.aip.dev/128#reconciliation), if
	// true, indicates that the service is actively updating the resource. This
	// can happen due to user-triggered updates or system actions like failover or
	// maintenance.
	Reconciling bool `protobuf:"varint,11,opt,name=reconciling,proto3" json:"reconciling,omitempty"`
	// Optional. The encryption config can be specified to encrypt the
	// backup with a customer-managed encryption key (CMEK). When this field is
	// not specified, the backup will then use default encryption scheme to
	// protect the user data.
	EncryptionConfig *EncryptionConfig `protobuf:"bytes,12,opt,name=encryption_config,json=encryptionConfig,proto3" json:"encryption_config,omitempty"`
	// Output only. The encryption information for the backup.
	EncryptionInfo *EncryptionInfo `protobuf:"bytes,13,opt,name=encryption_info,json=encryptionInfo,proto3" json:"encryption_info,omitempty"`
	// For Resource freshness validation (https://google.aip.dev/154)
	Etag string `protobuf:"bytes,14,opt,name=etag,proto3" json:"etag,omitempty"`
	// Annotations to allow client tools to store small amount of arbitrary data.
	// This is distinct from labels.
	// https://google.aip.dev/128
	Annotations map[string]string `protobuf:"bytes,16,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The size of the backup in bytes.
	SizeBytes int64 `protobuf:"varint,17,opt,name=size_bytes,json=sizeBytes,proto3" json:"size_bytes,omitempty"`
	// Output only. The time at which after the backup is eligible to be garbage
	// collected. It is the duration specified by the backup's retention policy,
	// added to the backup's create_time.
	ExpiryTime *timestamppb.Timestamp `protobuf:"bytes,19,opt,name=expiry_time,json=expiryTime,proto3" json:"expiry_time,omitempty"`
	// Output only. The QuantityBasedExpiry of the backup, specified by the
	// backup's retention policy. Once the expiry quantity is over retention, the
	// backup is eligible to be garbage collected.
	ExpiryQuantity *Backup_QuantityBasedExpiry `protobuf:"bytes,20,opt,name=expiry_quantity,json=expiryQuantity,proto3" json:"expiry_quantity,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzi bool `protobuf:"varint,23,opt,name=satisfies_pzi,json=satisfiesPzi,proto3" json:"satisfies_pzi,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzs bool `protobuf:"varint,21,opt,name=satisfies_pzs,json=satisfiesPzs,proto3" json:"satisfies_pzs,omitempty"`
	// Output only. The database engine major version of the cluster this backup
	// was created from. Any restored cluster created from this backup will have
	// the same database version.
	DatabaseVersion DatabaseVersion `protobuf:"varint,22,opt,name=database_version,json=databaseVersion,proto3,enum=google.cloud.alloydb.v1alpha.DatabaseVersion" json:"database_version,omitempty"`
	// Optional. Input only. Immutable. Tag keys/values directly bound to this
	// resource. For example:
	// ```
	// "123/environment": "production",
	// "123/costCenter": "marketing"
	// ```
	Tags map[string]string `protobuf:"bytes,25,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Backup) Reset() {
	*x = Backup{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Backup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Backup) ProtoMessage() {}

func (x *Backup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Backup.ProtoReflect.Descriptor instead.
func (*Backup) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{15}
}

func (x *Backup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Backup) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Backup) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Backup) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Backup) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Backup) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

func (x *Backup) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Backup) GetState() Backup_State {
	if x != nil {
		return x.State
	}
	return Backup_STATE_UNSPECIFIED
}

func (x *Backup) GetType() Backup_Type {
	if x != nil {
		return x.Type
	}
	return Backup_TYPE_UNSPECIFIED
}

func (x *Backup) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Backup) GetClusterUid() string {
	if x != nil {
		return x.ClusterUid
	}
	return ""
}

func (x *Backup) GetClusterName() string {
	if x != nil {
		return x.ClusterName
	}
	return ""
}

func (x *Backup) GetReconciling() bool {
	if x != nil {
		return x.Reconciling
	}
	return false
}

func (x *Backup) GetEncryptionConfig() *EncryptionConfig {
	if x != nil {
		return x.EncryptionConfig
	}
	return nil
}

func (x *Backup) GetEncryptionInfo() *EncryptionInfo {
	if x != nil {
		return x.EncryptionInfo
	}
	return nil
}

func (x *Backup) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Backup) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *Backup) GetSizeBytes() int64 {
	if x != nil {
		return x.SizeBytes
	}
	return 0
}

func (x *Backup) GetExpiryTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpiryTime
	}
	return nil
}

func (x *Backup) GetExpiryQuantity() *Backup_QuantityBasedExpiry {
	if x != nil {
		return x.ExpiryQuantity
	}
	return nil
}

func (x *Backup) GetSatisfiesPzi() bool {
	if x != nil {
		return x.SatisfiesPzi
	}
	return false
}

func (x *Backup) GetSatisfiesPzs() bool {
	if x != nil {
		return x.SatisfiesPzs
	}
	return false
}

func (x *Backup) GetDatabaseVersion() DatabaseVersion {
	if x != nil {
		return x.DatabaseVersion
	}
	return DatabaseVersion_DATABASE_VERSION_UNSPECIFIED
}

func (x *Backup) GetTags() map[string]string {
	if x != nil {
		return x.Tags
	}
	return nil
}

// SupportedDatabaseFlag gives general information about a database flag,
// like type and allowed values. This is a static value that is defined
// on the server side, and it cannot be modified by callers.
// To set the Database flags on a particular Instance, a caller should modify
// the Instance.database_flags field.
type SupportedDatabaseFlag struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The restrictions on the flag value per type.
	//
	// Types that are assignable to Restrictions:
	//
	//	*SupportedDatabaseFlag_StringRestrictions_
	//	*SupportedDatabaseFlag_IntegerRestrictions_
	Restrictions isSupportedDatabaseFlag_Restrictions `protobuf_oneof:"restrictions"`
	// The name of the flag resource, following Google Cloud conventions, e.g.:
	//   - projects/{project}/locations/{location}/flags/{flag}
	//
	// This field currently has no semantic meaning.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name of the database flag, e.g. "max_allowed_packets".
	// The is a possibly key for the Instance.database_flags map field.
	FlagName  string                          `protobuf:"bytes,2,opt,name=flag_name,json=flagName,proto3" json:"flag_name,omitempty"`
	ValueType SupportedDatabaseFlag_ValueType `protobuf:"varint,3,opt,name=value_type,json=valueType,proto3,enum=google.cloud.alloydb.v1alpha.SupportedDatabaseFlag_ValueType" json:"value_type,omitempty"`
	// Whether the database flag accepts multiple values. If true,
	// a comma-separated list of stringified values may be specified.
	AcceptsMultipleValues bool `protobuf:"varint,4,opt,name=accepts_multiple_values,json=acceptsMultipleValues,proto3" json:"accepts_multiple_values,omitempty"`
	// Major database engine versions for which this flag is supported.
	SupportedDbVersions []DatabaseVersion `protobuf:"varint,5,rep,packed,name=supported_db_versions,json=supportedDbVersions,proto3,enum=google.cloud.alloydb.v1alpha.DatabaseVersion" json:"supported_db_versions,omitempty"`
	// Whether setting or updating this flag on an Instance requires a database
	// restart. If a flag that requires database restart is set, the backend
	// will automatically restart the database (making sure to satisfy any
	// availability SLO's).
	RequiresDbRestart bool `protobuf:"varint,6,opt,name=requires_db_restart,json=requiresDbRestart,proto3" json:"requires_db_restart,omitempty"`
}

func (x *SupportedDatabaseFlag) Reset() {
	*x = SupportedDatabaseFlag{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SupportedDatabaseFlag) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SupportedDatabaseFlag) ProtoMessage() {}

func (x *SupportedDatabaseFlag) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SupportedDatabaseFlag.ProtoReflect.Descriptor instead.
func (*SupportedDatabaseFlag) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{16}
}

func (m *SupportedDatabaseFlag) GetRestrictions() isSupportedDatabaseFlag_Restrictions {
	if m != nil {
		return m.Restrictions
	}
	return nil
}

func (x *SupportedDatabaseFlag) GetStringRestrictions() *SupportedDatabaseFlag_StringRestrictions {
	if x, ok := x.GetRestrictions().(*SupportedDatabaseFlag_StringRestrictions_); ok {
		return x.StringRestrictions
	}
	return nil
}

func (x *SupportedDatabaseFlag) GetIntegerRestrictions() *SupportedDatabaseFlag_IntegerRestrictions {
	if x, ok := x.GetRestrictions().(*SupportedDatabaseFlag_IntegerRestrictions_); ok {
		return x.IntegerRestrictions
	}
	return nil
}

func (x *SupportedDatabaseFlag) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SupportedDatabaseFlag) GetFlagName() string {
	if x != nil {
		return x.FlagName
	}
	return ""
}

func (x *SupportedDatabaseFlag) GetValueType() SupportedDatabaseFlag_ValueType {
	if x != nil {
		return x.ValueType
	}
	return SupportedDatabaseFlag_VALUE_TYPE_UNSPECIFIED
}

func (x *SupportedDatabaseFlag) GetAcceptsMultipleValues() bool {
	if x != nil {
		return x.AcceptsMultipleValues
	}
	return false
}

func (x *SupportedDatabaseFlag) GetSupportedDbVersions() []DatabaseVersion {
	if x != nil {
		return x.SupportedDbVersions
	}
	return nil
}

func (x *SupportedDatabaseFlag) GetRequiresDbRestart() bool {
	if x != nil {
		return x.RequiresDbRestart
	}
	return false
}

type isSupportedDatabaseFlag_Restrictions interface {
	isSupportedDatabaseFlag_Restrictions()
}

type SupportedDatabaseFlag_StringRestrictions_ struct {
	// Restriction on STRING type value.
	StringRestrictions *SupportedDatabaseFlag_StringRestrictions `protobuf:"bytes,7,opt,name=string_restrictions,json=stringRestrictions,proto3,oneof"`
}

type SupportedDatabaseFlag_IntegerRestrictions_ struct {
	// Restriction on INTEGER type value.
	IntegerRestrictions *SupportedDatabaseFlag_IntegerRestrictions `protobuf:"bytes,8,opt,name=integer_restrictions,json=integerRestrictions,proto3,oneof"`
}

func (*SupportedDatabaseFlag_StringRestrictions_) isSupportedDatabaseFlag_Restrictions() {}

func (*SupportedDatabaseFlag_IntegerRestrictions_) isSupportedDatabaseFlag_Restrictions() {}

// Message describing User object.
type User struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Name of the resource in the form of
	// projects/{project}/locations/{location}/cluster/{cluster}/users/{user}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Input only. Password for the user.
	Password string `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
	// Optional. List of database roles this user has.
	// The database role strings are subject to the PostgreSQL naming conventions.
	DatabaseRoles []string `protobuf:"bytes,4,rep,name=database_roles,json=databaseRoles,proto3" json:"database_roles,omitempty"`
	// Optional. Type of this user.
	UserType User_UserType `protobuf:"varint,5,opt,name=user_type,json=userType,proto3,enum=google.cloud.alloydb.v1alpha.User_UserType" json:"user_type,omitempty"`
	// Input only. If the user already exists and it has additional roles, keep
	// them granted.
	KeepExtraRoles bool `protobuf:"varint,6,opt,name=keep_extra_roles,json=keepExtraRoles,proto3" json:"keep_extra_roles,omitempty"`
}

func (x *User) Reset() {
	*x = User{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *User) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*User) ProtoMessage() {}

func (x *User) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use User.ProtoReflect.Descriptor instead.
func (*User) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{17}
}

func (x *User) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *User) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

func (x *User) GetDatabaseRoles() []string {
	if x != nil {
		return x.DatabaseRoles
	}
	return nil
}

func (x *User) GetUserType() User_UserType {
	if x != nil {
		return x.UserType
	}
	return User_USER_TYPE_UNSPECIFIED
}

func (x *User) GetKeepExtraRoles() bool {
	if x != nil {
		return x.KeepExtraRoles
	}
	return false
}

// Message describing Database object.
type Database struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. Name of the resource in the form of
	// `projects/{project}/locations/{location}/clusters/{cluster}/databases/{database}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Charset for the database.
	// This field can contain any PostgreSQL supported charset name.
	// Example values include "UTF8", "SQL_ASCII", etc.
	Charset string `protobuf:"bytes,2,opt,name=charset,proto3" json:"charset,omitempty"`
	// Optional. Collation for the database.
	// Name of the custom or native collation for postgres.
	// Example values include "C", "POSIX", etc
	Collation string `protobuf:"bytes,3,opt,name=collation,proto3" json:"collation,omitempty"`
}

func (x *Database) Reset() {
	*x = Database{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Database) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Database) ProtoMessage() {}

func (x *Database) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Database.ProtoReflect.Descriptor instead.
func (*Database) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{18}
}

func (x *Database) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Database) GetCharset() string {
	if x != nil {
		return x.Charset
	}
	return ""
}

func (x *Database) GetCollation() string {
	if x != nil {
		return x.Collation
	}
	return ""
}

// A weekly schedule starts a backup at prescribed start times within a
// day, for the specified days of the week.
//
// The weekly schedule message is flexible and can be used to create many
// types of schedules. For example, to have a daily backup that starts at
// 22:00, configure the `start_times` field to have one element "22:00" and
// the `days_of_week` field to have all seven days of the week.
type AutomatedBackupPolicy_WeeklySchedule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The times during the day to start a backup. The start times are assumed
	// to be in UTC and to be an exact hour (e.g., 04:00:00).
	//
	// If no start times are provided, a single fixed start time is chosen
	// arbitrarily.
	StartTimes []*timeofday.TimeOfDay `protobuf:"bytes,1,rep,name=start_times,json=startTimes,proto3" json:"start_times,omitempty"`
	// The days of the week to perform a backup.
	//
	// If this field is left empty, the default of every day of the week is
	// used.
	DaysOfWeek []dayofweek.DayOfWeek `protobuf:"varint,2,rep,packed,name=days_of_week,json=daysOfWeek,proto3,enum=google.type.DayOfWeek" json:"days_of_week,omitempty"`
}

func (x *AutomatedBackupPolicy_WeeklySchedule) Reset() {
	*x = AutomatedBackupPolicy_WeeklySchedule{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutomatedBackupPolicy_WeeklySchedule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutomatedBackupPolicy_WeeklySchedule) ProtoMessage() {}

func (x *AutomatedBackupPolicy_WeeklySchedule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutomatedBackupPolicy_WeeklySchedule.ProtoReflect.Descriptor instead.
func (*AutomatedBackupPolicy_WeeklySchedule) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{5, 0}
}

func (x *AutomatedBackupPolicy_WeeklySchedule) GetStartTimes() []*timeofday.TimeOfDay {
	if x != nil {
		return x.StartTimes
	}
	return nil
}

func (x *AutomatedBackupPolicy_WeeklySchedule) GetDaysOfWeek() []dayofweek.DayOfWeek {
	if x != nil {
		return x.DaysOfWeek
	}
	return nil
}

// A time based retention policy specifies that all backups within a certain
// time period should be retained.
type AutomatedBackupPolicy_TimeBasedRetention struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The retention period.
	RetentionPeriod *durationpb.Duration `protobuf:"bytes,1,opt,name=retention_period,json=retentionPeriod,proto3" json:"retention_period,omitempty"`
}

func (x *AutomatedBackupPolicy_TimeBasedRetention) Reset() {
	*x = AutomatedBackupPolicy_TimeBasedRetention{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutomatedBackupPolicy_TimeBasedRetention) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutomatedBackupPolicy_TimeBasedRetention) ProtoMessage() {}

func (x *AutomatedBackupPolicy_TimeBasedRetention) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutomatedBackupPolicy_TimeBasedRetention.ProtoReflect.Descriptor instead.
func (*AutomatedBackupPolicy_TimeBasedRetention) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{5, 1}
}

func (x *AutomatedBackupPolicy_TimeBasedRetention) GetRetentionPeriod() *durationpb.Duration {
	if x != nil {
		return x.RetentionPeriod
	}
	return nil
}

// A quantity based policy specifies that a certain number of the most recent
// successful backups should be retained.
type AutomatedBackupPolicy_QuantityBasedRetention struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of backups to retain.
	Count int32 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *AutomatedBackupPolicy_QuantityBasedRetention) Reset() {
	*x = AutomatedBackupPolicy_QuantityBasedRetention{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutomatedBackupPolicy_QuantityBasedRetention) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutomatedBackupPolicy_QuantityBasedRetention) ProtoMessage() {}

func (x *AutomatedBackupPolicy_QuantityBasedRetention) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutomatedBackupPolicy_QuantityBasedRetention.ProtoReflect.Descriptor instead.
func (*AutomatedBackupPolicy_QuantityBasedRetention) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{5, 2}
}

func (x *AutomatedBackupPolicy_QuantityBasedRetention) GetCount() int32 {
	if x != nil {
		return x.Count
	}
	return 0
}

// MaintenanceWindow specifies a preferred day and time for maintenance.
type MaintenanceUpdatePolicy_MaintenanceWindow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Preferred day of the week for maintenance, e.g. MONDAY, TUESDAY, etc.
	Day dayofweek.DayOfWeek `protobuf:"varint,1,opt,name=day,proto3,enum=google.type.DayOfWeek" json:"day,omitempty"`
	// Preferred time to start the maintenance operation on the specified day.
	// Maintenance will start within 1 hour of this time.
	StartTime *timeofday.TimeOfDay `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
}

func (x *MaintenanceUpdatePolicy_MaintenanceWindow) Reset() {
	*x = MaintenanceUpdatePolicy_MaintenanceWindow{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MaintenanceUpdatePolicy_MaintenanceWindow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MaintenanceUpdatePolicy_MaintenanceWindow) ProtoMessage() {}

func (x *MaintenanceUpdatePolicy_MaintenanceWindow) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MaintenanceUpdatePolicy_MaintenanceWindow.ProtoReflect.Descriptor instead.
func (*MaintenanceUpdatePolicy_MaintenanceWindow) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{10, 0}
}

func (x *MaintenanceUpdatePolicy_MaintenanceWindow) GetDay() dayofweek.DayOfWeek {
	if x != nil {
		return x.Day
	}
	return dayofweek.DayOfWeek(0)
}

func (x *MaintenanceUpdatePolicy_MaintenanceWindow) GetStartTime() *timeofday.TimeOfDay {
	if x != nil {
		return x.StartTime
	}
	return nil
}

// Metadata related to network configuration.
type Cluster_NetworkConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The resource link for the VPC network in which cluster
	// resources are created and from which they are accessible via Private IP.
	// The network must belong to the same project as the cluster. It is
	// specified in the form:
	// `projects/{project_number}/global/networks/{network_id}`. This is
	// required to create a cluster.
	Network string `protobuf:"bytes,1,opt,name=network,proto3" json:"network,omitempty"`
	// Optional. Name of the allocated IP range for the private IP AlloyDB
	// cluster, for example: "google-managed-services-default". If set, the
	// instance IPs for this cluster will be created in the allocated range. The
	// range name must comply with RFC 1035. Specifically, the name must be 1-63
	// characters long and match the regular expression
	// `[a-z]([-a-z0-9]*[a-z0-9])?`.
	// Field name is intended to be consistent with Cloud SQL.
	AllocatedIpRange string `protobuf:"bytes,2,opt,name=allocated_ip_range,json=allocatedIpRange,proto3" json:"allocated_ip_range,omitempty"`
}

func (x *Cluster_NetworkConfig) Reset() {
	*x = Cluster_NetworkConfig{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Cluster_NetworkConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster_NetworkConfig) ProtoMessage() {}

func (x *Cluster_NetworkConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster_NetworkConfig.ProtoReflect.Descriptor instead.
func (*Cluster_NetworkConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{12, 0}
}

func (x *Cluster_NetworkConfig) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *Cluster_NetworkConfig) GetAllocatedIpRange() string {
	if x != nil {
		return x.AllocatedIpRange
	}
	return ""
}

// Configuration information for the secondary cluster. This should be set
// if and only if the cluster is of type SECONDARY.
type Cluster_SecondaryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the primary cluster name with the format:
	// * projects/{project}/locations/{region}/clusters/{cluster_id}
	PrimaryClusterName string `protobuf:"bytes,1,opt,name=primary_cluster_name,json=primaryClusterName,proto3" json:"primary_cluster_name,omitempty"`
}

func (x *Cluster_SecondaryConfig) Reset() {
	*x = Cluster_SecondaryConfig{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Cluster_SecondaryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster_SecondaryConfig) ProtoMessage() {}

func (x *Cluster_SecondaryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster_SecondaryConfig.ProtoReflect.Descriptor instead.
func (*Cluster_SecondaryConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{12, 1}
}

func (x *Cluster_SecondaryConfig) GetPrimaryClusterName() string {
	if x != nil {
		return x.PrimaryClusterName
	}
	return ""
}

// Configuration for the primary cluster. It has the list of clusters that are
// replicating from this cluster. This should be set if and only if the
// cluster is of type PRIMARY.
type Cluster_PrimaryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Names of the clusters that are replicating from this
	// cluster.
	SecondaryClusterNames []string `protobuf:"bytes,1,rep,name=secondary_cluster_names,json=secondaryClusterNames,proto3" json:"secondary_cluster_names,omitempty"`
}

func (x *Cluster_PrimaryConfig) Reset() {
	*x = Cluster_PrimaryConfig{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Cluster_PrimaryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster_PrimaryConfig) ProtoMessage() {}

func (x *Cluster_PrimaryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster_PrimaryConfig.ProtoReflect.Descriptor instead.
func (*Cluster_PrimaryConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{12, 2}
}

func (x *Cluster_PrimaryConfig) GetSecondaryClusterNames() []string {
	if x != nil {
		return x.SecondaryClusterNames
	}
	return nil
}

// PscConfig contains PSC related configuration at a cluster level.
type Cluster_PscConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Create an instance that allows connections from Private Service
	// Connect endpoints to the instance.
	PscEnabled bool `protobuf:"varint,1,opt,name=psc_enabled,json=pscEnabled,proto3" json:"psc_enabled,omitempty"`
	// Output only. The project number that needs to be allowlisted on the
	// network attachment to enable outbound connectivity.
	ServiceOwnedProjectNumber int64 `protobuf:"varint,3,opt,name=service_owned_project_number,json=serviceOwnedProjectNumber,proto3" json:"service_owned_project_number,omitempty"`
}

func (x *Cluster_PscConfig) Reset() {
	*x = Cluster_PscConfig{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Cluster_PscConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster_PscConfig) ProtoMessage() {}

func (x *Cluster_PscConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster_PscConfig.ProtoReflect.Descriptor instead.
func (*Cluster_PscConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{12, 3}
}

func (x *Cluster_PscConfig) GetPscEnabled() bool {
	if x != nil {
		return x.PscEnabled
	}
	return false
}

func (x *Cluster_PscConfig) GetServiceOwnedProjectNumber() int64 {
	if x != nil {
		return x.ServiceOwnedProjectNumber
	}
	return 0
}

// Contains information and all metadata related to TRIAL clusters.
type Cluster_TrialMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// start time of the trial cluster.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End time of the trial cluster.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Upgrade time of trial cluster to Standard cluster.
	UpgradeTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=upgrade_time,json=upgradeTime,proto3" json:"upgrade_time,omitempty"`
	// grace end time of the cluster.
	GraceEndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=grace_end_time,json=graceEndTime,proto3" json:"grace_end_time,omitempty"`
}

func (x *Cluster_TrialMetadata) Reset() {
	*x = Cluster_TrialMetadata{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Cluster_TrialMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster_TrialMetadata) ProtoMessage() {}

func (x *Cluster_TrialMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster_TrialMetadata.ProtoReflect.Descriptor instead.
func (*Cluster_TrialMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{12, 4}
}

func (x *Cluster_TrialMetadata) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Cluster_TrialMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Cluster_TrialMetadata) GetUpgradeTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpgradeTime
	}
	return nil
}

func (x *Cluster_TrialMetadata) GetGraceEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.GraceEndTime
	}
	return nil
}

// MachineConfig describes the configuration of a machine.
type Instance_MachineConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of CPU's in the VM instance.
	CpuCount int32 `protobuf:"varint,1,opt,name=cpu_count,json=cpuCount,proto3" json:"cpu_count,omitempty"`
}

func (x *Instance_MachineConfig) Reset() {
	*x = Instance_MachineConfig{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Instance_MachineConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance_MachineConfig) ProtoMessage() {}

func (x *Instance_MachineConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance_MachineConfig.ProtoReflect.Descriptor instead.
func (*Instance_MachineConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{13, 0}
}

func (x *Instance_MachineConfig) GetCpuCount() int32 {
	if x != nil {
		return x.CpuCount
	}
	return 0
}

// Details of a single node in the instance.
// Nodes in an AlloyDB instance are ephemereal, they can change during
// update, failover, autohealing and resize operations.
type Instance_Node struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Compute Engine zone of the VM e.g. "us-central1-b".
	ZoneId string `protobuf:"bytes,1,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// The identifier of the VM e.g. "test-read-0601-407e52be-ms3l".
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// The private IP address of the VM e.g. "10.57.0.34".
	Ip string `protobuf:"bytes,3,opt,name=ip,proto3" json:"ip,omitempty"`
	// Determined by state of the compute VM and postgres-service health.
	// Compute VM state can have values listed in
	// https://cloud.google.com/compute/docs/instances/instance-life-cycle and
	// postgres-service health can have values: HEALTHY and UNHEALTHY.
	State string `protobuf:"bytes,4,opt,name=state,proto3" json:"state,omitempty"`
}

func (x *Instance_Node) Reset() {
	*x = Instance_Node{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Instance_Node) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance_Node) ProtoMessage() {}

func (x *Instance_Node) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance_Node.ProtoReflect.Descriptor instead.
func (*Instance_Node) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{13, 1}
}

func (x *Instance_Node) GetZoneId() string {
	if x != nil {
		return x.ZoneId
	}
	return ""
}

func (x *Instance_Node) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Instance_Node) GetIp() string {
	if x != nil {
		return x.Ip
	}
	return ""
}

func (x *Instance_Node) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

// QueryInsights Instance specific configuration.
type Instance_QueryInsightsInstanceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Record application tags for an instance.
	// This flag is turned "on" by default.
	RecordApplicationTags *bool `protobuf:"varint,2,opt,name=record_application_tags,json=recordApplicationTags,proto3,oneof" json:"record_application_tags,omitempty"`
	// Record client address for an instance. Client address is PII information.
	// This flag is turned "on" by default.
	RecordClientAddress *bool `protobuf:"varint,3,opt,name=record_client_address,json=recordClientAddress,proto3,oneof" json:"record_client_address,omitempty"`
	// Query string length. The default value is 1024.
	// Any integer between 256 and 4500 is considered valid.
	QueryStringLength uint32 `protobuf:"varint,4,opt,name=query_string_length,json=queryStringLength,proto3" json:"query_string_length,omitempty"`
	// Number of query execution plans captured by Insights per minute
	// for all queries combined. The default value is 5.
	// Any integer between 0 and 20 is considered valid.
	QueryPlansPerMinute *uint32 `protobuf:"varint,5,opt,name=query_plans_per_minute,json=queryPlansPerMinute,proto3,oneof" json:"query_plans_per_minute,omitempty"`
}

func (x *Instance_QueryInsightsInstanceConfig) Reset() {
	*x = Instance_QueryInsightsInstanceConfig{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Instance_QueryInsightsInstanceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance_QueryInsightsInstanceConfig) ProtoMessage() {}

func (x *Instance_QueryInsightsInstanceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance_QueryInsightsInstanceConfig.ProtoReflect.Descriptor instead.
func (*Instance_QueryInsightsInstanceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{13, 2}
}

func (x *Instance_QueryInsightsInstanceConfig) GetRecordApplicationTags() bool {
	if x != nil && x.RecordApplicationTags != nil {
		return *x.RecordApplicationTags
	}
	return false
}

func (x *Instance_QueryInsightsInstanceConfig) GetRecordClientAddress() bool {
	if x != nil && x.RecordClientAddress != nil {
		return *x.RecordClientAddress
	}
	return false
}

func (x *Instance_QueryInsightsInstanceConfig) GetQueryStringLength() uint32 {
	if x != nil {
		return x.QueryStringLength
	}
	return 0
}

func (x *Instance_QueryInsightsInstanceConfig) GetQueryPlansPerMinute() uint32 {
	if x != nil && x.QueryPlansPerMinute != nil {
		return *x.QueryPlansPerMinute
	}
	return 0
}

// Observability Instance specific configuration.
type Instance_ObservabilityInstanceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Observability feature status for an instance.
	// This flag is turned "off" by default.
	Enabled *bool `protobuf:"varint,1,opt,name=enabled,proto3,oneof" json:"enabled,omitempty"`
	// Preserve comments in query string for an instance.
	// This flag is turned "off" by default.
	PreserveComments *bool `protobuf:"varint,2,opt,name=preserve_comments,json=preserveComments,proto3,oneof" json:"preserve_comments,omitempty"`
	// Track wait events during query execution for an instance.
	// This flag is turned "on" by default but tracking is enabled only after
	// observability enabled flag is also turned on.
	TrackWaitEvents *bool `protobuf:"varint,3,opt,name=track_wait_events,json=trackWaitEvents,proto3,oneof" json:"track_wait_events,omitempty"`
	// Output only. Track wait event types during query execution for an
	// instance. This flag is turned "on" by default but tracking is enabled
	// only after observability enabled flag is also turned on. This is
	// read-only flag and only modifiable by producer API.
	TrackWaitEventTypes *bool `protobuf:"varint,4,opt,name=track_wait_event_types,json=trackWaitEventTypes,proto3,oneof" json:"track_wait_event_types,omitempty"`
	// Query string length. The default value is 10k.
	MaxQueryStringLength *int32 `protobuf:"varint,5,opt,name=max_query_string_length,json=maxQueryStringLength,proto3,oneof" json:"max_query_string_length,omitempty"`
	// Record application tags for an instance.
	// This flag is turned "off" by default.
	RecordApplicationTags *bool `protobuf:"varint,6,opt,name=record_application_tags,json=recordApplicationTags,proto3,oneof" json:"record_application_tags,omitempty"`
	// Number of query execution plans captured by Insights per minute
	// for all queries combined. The default value is 200.
	// Any integer between 0 to 200 is considered valid.
	QueryPlansPerMinute *int32 `protobuf:"varint,7,opt,name=query_plans_per_minute,json=queryPlansPerMinute,proto3,oneof" json:"query_plans_per_minute,omitempty"`
	// Track actively running queries on the instance.
	// If not set, this flag is "off" by default.
	TrackActiveQueries *bool `protobuf:"varint,8,opt,name=track_active_queries,json=trackActiveQueries,proto3,oneof" json:"track_active_queries,omitempty"`
	// Track client address for an instance.
	// If not set, default value is "off".
	TrackClientAddress *bool `protobuf:"varint,9,opt,name=track_client_address,json=trackClientAddress,proto3,oneof" json:"track_client_address,omitempty"`
}

func (x *Instance_ObservabilityInstanceConfig) Reset() {
	*x = Instance_ObservabilityInstanceConfig{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Instance_ObservabilityInstanceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance_ObservabilityInstanceConfig) ProtoMessage() {}

func (x *Instance_ObservabilityInstanceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance_ObservabilityInstanceConfig.ProtoReflect.Descriptor instead.
func (*Instance_ObservabilityInstanceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{13, 3}
}

func (x *Instance_ObservabilityInstanceConfig) GetEnabled() bool {
	if x != nil && x.Enabled != nil {
		return *x.Enabled
	}
	return false
}

func (x *Instance_ObservabilityInstanceConfig) GetPreserveComments() bool {
	if x != nil && x.PreserveComments != nil {
		return *x.PreserveComments
	}
	return false
}

func (x *Instance_ObservabilityInstanceConfig) GetTrackWaitEvents() bool {
	if x != nil && x.TrackWaitEvents != nil {
		return *x.TrackWaitEvents
	}
	return false
}

func (x *Instance_ObservabilityInstanceConfig) GetTrackWaitEventTypes() bool {
	if x != nil && x.TrackWaitEventTypes != nil {
		return *x.TrackWaitEventTypes
	}
	return false
}

func (x *Instance_ObservabilityInstanceConfig) GetMaxQueryStringLength() int32 {
	if x != nil && x.MaxQueryStringLength != nil {
		return *x.MaxQueryStringLength
	}
	return 0
}

func (x *Instance_ObservabilityInstanceConfig) GetRecordApplicationTags() bool {
	if x != nil && x.RecordApplicationTags != nil {
		return *x.RecordApplicationTags
	}
	return false
}

func (x *Instance_ObservabilityInstanceConfig) GetQueryPlansPerMinute() int32 {
	if x != nil && x.QueryPlansPerMinute != nil {
		return *x.QueryPlansPerMinute
	}
	return 0
}

func (x *Instance_ObservabilityInstanceConfig) GetTrackActiveQueries() bool {
	if x != nil && x.TrackActiveQueries != nil {
		return *x.TrackActiveQueries
	}
	return false
}

func (x *Instance_ObservabilityInstanceConfig) GetTrackClientAddress() bool {
	if x != nil && x.TrackClientAddress != nil {
		return *x.TrackClientAddress
	}
	return false
}

// Configuration for a read pool instance.
type Instance_ReadPoolConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Read capacity, i.e. number of nodes in a read pool instance.
	NodeCount int32 `protobuf:"varint,1,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
}

func (x *Instance_ReadPoolConfig) Reset() {
	*x = Instance_ReadPoolConfig{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Instance_ReadPoolConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance_ReadPoolConfig) ProtoMessage() {}

func (x *Instance_ReadPoolConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance_ReadPoolConfig.ProtoReflect.Descriptor instead.
func (*Instance_ReadPoolConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{13, 4}
}

func (x *Instance_ReadPoolConfig) GetNodeCount() int32 {
	if x != nil {
		return x.NodeCount
	}
	return 0
}

// Policy to be used while updating the instance.
type Instance_UpdatePolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Mode for updating the instance.
	Mode Instance_UpdatePolicy_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=google.cloud.alloydb.v1alpha.Instance_UpdatePolicy_Mode" json:"mode,omitempty"`
}

func (x *Instance_UpdatePolicy) Reset() {
	*x = Instance_UpdatePolicy{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Instance_UpdatePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance_UpdatePolicy) ProtoMessage() {}

func (x *Instance_UpdatePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance_UpdatePolicy.ProtoReflect.Descriptor instead.
func (*Instance_UpdatePolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{13, 5}
}

func (x *Instance_UpdatePolicy) GetMode() Instance_UpdatePolicy_Mode {
	if x != nil {
		return x.Mode
	}
	return Instance_UpdatePolicy_MODE_UNSPECIFIED
}

// Client connection configuration
type Instance_ClientConnectionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Configuration to enforce connectors only (ex: AuthProxy)
	// connections to the database.
	RequireConnectors bool `protobuf:"varint,1,opt,name=require_connectors,json=requireConnectors,proto3" json:"require_connectors,omitempty"`
	// Optional. SSL configuration option for this instance.
	SslConfig *SslConfig `protobuf:"bytes,2,opt,name=ssl_config,json=sslConfig,proto3" json:"ssl_config,omitempty"`
}

func (x *Instance_ClientConnectionConfig) Reset() {
	*x = Instance_ClientConnectionConfig{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Instance_ClientConnectionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance_ClientConnectionConfig) ProtoMessage() {}

func (x *Instance_ClientConnectionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance_ClientConnectionConfig.ProtoReflect.Descriptor instead.
func (*Instance_ClientConnectionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{13, 6}
}

func (x *Instance_ClientConnectionConfig) GetRequireConnectors() bool {
	if x != nil {
		return x.RequireConnectors
	}
	return false
}

func (x *Instance_ClientConnectionConfig) GetSslConfig() *SslConfig {
	if x != nil {
		return x.SslConfig
	}
	return nil
}

// Configuration for setting up a PSC interface to enable outbound
// connectivity.
type Instance_PscInterfaceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The network attachment resource created in the consumer network to which
	// the PSC interface will be linked. This is of the format:
	// "projects/${CONSUMER_PROJECT}/regions/${REGION}/networkAttachments/${NETWORK_ATTACHMENT_NAME}".
	// The network attachment must be in the same region as the instance.
	NetworkAttachmentResource string `protobuf:"bytes,1,opt,name=network_attachment_resource,json=networkAttachmentResource,proto3" json:"network_attachment_resource,omitempty"`
}

func (x *Instance_PscInterfaceConfig) Reset() {
	*x = Instance_PscInterfaceConfig{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Instance_PscInterfaceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance_PscInterfaceConfig) ProtoMessage() {}

func (x *Instance_PscInterfaceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance_PscInterfaceConfig.ProtoReflect.Descriptor instead.
func (*Instance_PscInterfaceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{13, 7}
}

func (x *Instance_PscInterfaceConfig) GetNetworkAttachmentResource() string {
	if x != nil {
		return x.NetworkAttachmentResource
	}
	return ""
}

// PscInstanceConfig contains PSC related configuration at an
// instance level.
type Instance_PscInstanceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The service attachment created when Private
	// Service Connect (PSC) is enabled for the instance.
	// The name of the resource will be in the format of
	// `projects/<alloydb-tenant-project-number>/regions/<region-name>/serviceAttachments/<service-attachment-name>`
	ServiceAttachmentLink string `protobuf:"bytes,1,opt,name=service_attachment_link,json=serviceAttachmentLink,proto3" json:"service_attachment_link,omitempty"`
	// Optional. List of consumer projects that are allowed to create
	// PSC endpoints to service-attachments to this instance.
	AllowedConsumerProjects []string `protobuf:"bytes,2,rep,name=allowed_consumer_projects,json=allowedConsumerProjects,proto3" json:"allowed_consumer_projects,omitempty"`
	// Output only. The DNS name of the instance for PSC connectivity.
	// Name convention: <uid>.<uid>.<region>.alloydb-psc.goog
	PscDnsName string `protobuf:"bytes,7,opt,name=psc_dns_name,json=pscDnsName,proto3" json:"psc_dns_name,omitempty"`
	// Optional. Configurations for setting up PSC interfaces attached to the
	// instance which are used for outbound connectivity. Only primary instances
	// can have PSC interface attached. Currently we only support 0 or 1 PSC
	// interface.
	PscInterfaceConfigs []*Instance_PscInterfaceConfig `protobuf:"bytes,8,rep,name=psc_interface_configs,json=pscInterfaceConfigs,proto3" json:"psc_interface_configs,omitempty"`
}

func (x *Instance_PscInstanceConfig) Reset() {
	*x = Instance_PscInstanceConfig{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Instance_PscInstanceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance_PscInstanceConfig) ProtoMessage() {}

func (x *Instance_PscInstanceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance_PscInstanceConfig.ProtoReflect.Descriptor instead.
func (*Instance_PscInstanceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{13, 8}
}

func (x *Instance_PscInstanceConfig) GetServiceAttachmentLink() string {
	if x != nil {
		return x.ServiceAttachmentLink
	}
	return ""
}

func (x *Instance_PscInstanceConfig) GetAllowedConsumerProjects() []string {
	if x != nil {
		return x.AllowedConsumerProjects
	}
	return nil
}

func (x *Instance_PscInstanceConfig) GetPscDnsName() string {
	if x != nil {
		return x.PscDnsName
	}
	return ""
}

func (x *Instance_PscInstanceConfig) GetPscInterfaceConfigs() []*Instance_PscInterfaceConfig {
	if x != nil {
		return x.PscInterfaceConfigs
	}
	return nil
}

// Metadata related to instance-level network configuration.
type Instance_InstanceNetworkConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A list of external network authorized to access this instance.
	AuthorizedExternalNetworks []*Instance_InstanceNetworkConfig_AuthorizedNetwork `protobuf:"bytes,1,rep,name=authorized_external_networks,json=authorizedExternalNetworks,proto3" json:"authorized_external_networks,omitempty"`
	// Optional. Enabling public ip for the instance.
	EnablePublicIp bool `protobuf:"varint,2,opt,name=enable_public_ip,json=enablePublicIp,proto3" json:"enable_public_ip,omitempty"`
	// Optional. Enabling an outbound public IP address to support a database
	// server sending requests out into the internet.
	EnableOutboundPublicIp bool `protobuf:"varint,3,opt,name=enable_outbound_public_ip,json=enableOutboundPublicIp,proto3" json:"enable_outbound_public_ip,omitempty"`
}

func (x *Instance_InstanceNetworkConfig) Reset() {
	*x = Instance_InstanceNetworkConfig{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Instance_InstanceNetworkConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance_InstanceNetworkConfig) ProtoMessage() {}

func (x *Instance_InstanceNetworkConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance_InstanceNetworkConfig.ProtoReflect.Descriptor instead.
func (*Instance_InstanceNetworkConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{13, 9}
}

func (x *Instance_InstanceNetworkConfig) GetAuthorizedExternalNetworks() []*Instance_InstanceNetworkConfig_AuthorizedNetwork {
	if x != nil {
		return x.AuthorizedExternalNetworks
	}
	return nil
}

func (x *Instance_InstanceNetworkConfig) GetEnablePublicIp() bool {
	if x != nil {
		return x.EnablePublicIp
	}
	return false
}

func (x *Instance_InstanceNetworkConfig) GetEnableOutboundPublicIp() bool {
	if x != nil {
		return x.EnableOutboundPublicIp
	}
	return false
}

// AuthorizedNetwork contains metadata for an authorized network.
type Instance_InstanceNetworkConfig_AuthorizedNetwork struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// CIDR range for one authorzied network of the instance.
	CidrRange string `protobuf:"bytes,1,opt,name=cidr_range,json=cidrRange,proto3" json:"cidr_range,omitempty"`
}

func (x *Instance_InstanceNetworkConfig_AuthorizedNetwork) Reset() {
	*x = Instance_InstanceNetworkConfig_AuthorizedNetwork{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Instance_InstanceNetworkConfig_AuthorizedNetwork) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance_InstanceNetworkConfig_AuthorizedNetwork) ProtoMessage() {}

func (x *Instance_InstanceNetworkConfig_AuthorizedNetwork) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance_InstanceNetworkConfig_AuthorizedNetwork.ProtoReflect.Descriptor instead.
func (*Instance_InstanceNetworkConfig_AuthorizedNetwork) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{13, 9, 0}
}

func (x *Instance_InstanceNetworkConfig_AuthorizedNetwork) GetCidrRange() string {
	if x != nil {
		return x.CidrRange
	}
	return ""
}

// A backup's position in a quantity-based retention queue, of backups with
// the same source cluster and type, with length, retention, specified by the
// backup's retention policy.
// Once the position is greater than the retention, the backup is eligible to
// be garbage collected.
//
// Example: 5 backups from the same source cluster and type with a
// quantity-based retention of 3 and denoted by backup_id (position,
// retention).
//
// Safe: backup_5 (1, 3), backup_4, (2, 3), backup_3 (3, 3).
// Awaiting garbage collection: backup_2 (4, 3), backup_1 (5, 3)
type Backup_QuantityBasedExpiry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The backup's position among its backups with the same source
	// cluster and type, by descending chronological order create time(i.e.
	// newest first).
	RetentionCount int32 `protobuf:"varint,1,opt,name=retention_count,json=retentionCount,proto3" json:"retention_count,omitempty"`
	// Output only. The length of the quantity-based queue, specified by the
	// backup's retention policy.
	TotalRetentionCount int32 `protobuf:"varint,2,opt,name=total_retention_count,json=totalRetentionCount,proto3" json:"total_retention_count,omitempty"`
}

func (x *Backup_QuantityBasedExpiry) Reset() {
	*x = Backup_QuantityBasedExpiry{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Backup_QuantityBasedExpiry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Backup_QuantityBasedExpiry) ProtoMessage() {}

func (x *Backup_QuantityBasedExpiry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Backup_QuantityBasedExpiry.ProtoReflect.Descriptor instead.
func (*Backup_QuantityBasedExpiry) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{15, 0}
}

func (x *Backup_QuantityBasedExpiry) GetRetentionCount() int32 {
	if x != nil {
		return x.RetentionCount
	}
	return 0
}

func (x *Backup_QuantityBasedExpiry) GetTotalRetentionCount() int32 {
	if x != nil {
		return x.TotalRetentionCount
	}
	return 0
}

// Restrictions on STRING type values
type SupportedDatabaseFlag_StringRestrictions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of allowed values, if bounded. This field will be empty
	// if there is a unbounded number of allowed values.
	AllowedValues []string `protobuf:"bytes,1,rep,name=allowed_values,json=allowedValues,proto3" json:"allowed_values,omitempty"`
}

func (x *SupportedDatabaseFlag_StringRestrictions) Reset() {
	*x = SupportedDatabaseFlag_StringRestrictions{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SupportedDatabaseFlag_StringRestrictions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SupportedDatabaseFlag_StringRestrictions) ProtoMessage() {}

func (x *SupportedDatabaseFlag_StringRestrictions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SupportedDatabaseFlag_StringRestrictions.ProtoReflect.Descriptor instead.
func (*SupportedDatabaseFlag_StringRestrictions) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{16, 0}
}

func (x *SupportedDatabaseFlag_StringRestrictions) GetAllowedValues() []string {
	if x != nil {
		return x.AllowedValues
	}
	return nil
}

// Restrictions on INTEGER type values.
type SupportedDatabaseFlag_IntegerRestrictions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The minimum value that can be specified, if applicable.
	MinValue *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=min_value,json=minValue,proto3" json:"min_value,omitempty"`
	// The maximum value that can be specified, if applicable.
	MaxValue *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=max_value,json=maxValue,proto3" json:"max_value,omitempty"`
}

func (x *SupportedDatabaseFlag_IntegerRestrictions) Reset() {
	*x = SupportedDatabaseFlag_IntegerRestrictions{}
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SupportedDatabaseFlag_IntegerRestrictions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SupportedDatabaseFlag_IntegerRestrictions) ProtoMessage() {}

func (x *SupportedDatabaseFlag_IntegerRestrictions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SupportedDatabaseFlag_IntegerRestrictions.ProtoReflect.Descriptor instead.
func (*SupportedDatabaseFlag_IntegerRestrictions) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP(), []int{16, 1}
}

func (x *SupportedDatabaseFlag_IntegerRestrictions) GetMinValue() *wrapperspb.Int64Value {
	if x != nil {
		return x.MinValue
	}
	return nil
}

func (x *SupportedDatabaseFlag_IntegerRestrictions) GetMaxValue() *wrapperspb.Int64Value {
	if x != nil {
		return x.MaxValue
	}
	return nil
}

var File_google_cloud_alloydb_v1alpha_resources_proto protoreflect.FileDescriptor

var file_google_cloud_alloydb_v1alpha_resources_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c,
	0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x63, 0x73, 0x71, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x67, 0x65, 0x6d, 0x69, 0x6e, 0x69, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x2f, 0x64, 0x61, 0x79, 0x6f, 0x66, 0x77, 0x65, 0x65, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x6f, 0x66, 0x64, 0x61, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x3e,
	0x0a, 0x0c, 0x55, 0x73, 0x65, 0x72, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x12,
	0x0a, 0x04, 0x75, 0x73, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x75, 0x73,
	0x65, 0x72, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x22, 0x8b,
	0x02, 0x0a, 0x0f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74,
	0x50, 0x6f, 0x72, 0x74, 0x12, 0x26, 0x0a, 0x0c, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0b, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x67, 0x0a, 0x0b,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0x45, 0x0a, 0x13, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x25, 0x0a, 0x21,
	0x4d, 0x49, 0x47, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x44, 0x4d, 0x53, 0x10, 0x01, 0x22, 0x34, 0x0a, 0x10,
	0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x20, 0x0a, 0x0c, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x22, 0xab, 0x02, 0x0a, 0x0e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x5f, 0x0a, 0x0f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c,
	0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x5a, 0x0a, 0x10, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65,
	0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x30, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b,
	0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x0e, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x22, 0x5c, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x1d, 0x0a, 0x19, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55,
	0x4c, 0x54, 0x5f, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12,
	0x1f, 0x0a, 0x1b, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x45, 0x52, 0x5f, 0x4d, 0x41, 0x4e, 0x41,
	0x47, 0x45, 0x44, 0x5f, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02,
	0x22, 0x9b, 0x03, 0x0a, 0x09, 0x53, 0x73, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4f,
	0x0a, 0x08, 0x73, 0x73, 0x6c, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x53, 0x73, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x73, 0x6c, 0x4d, 0x6f, 0x64,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x73, 0x73, 0x6c, 0x4d, 0x6f, 0x64, 0x65, 0x12,
	0x52, 0x0a, 0x09, 0x63, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x53, 0x73, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x61, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x63, 0x61, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x22, 0xaa, 0x01, 0x0a, 0x07, 0x53, 0x73, 0x6c, 0x4d, 0x6f, 0x64, 0x65, 0x12,
	0x18, 0x0a, 0x14, 0x53, 0x53, 0x4c, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x0e, 0x53, 0x53, 0x4c,
	0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x10, 0x01, 0x1a, 0x02, 0x08,
	0x01, 0x12, 0x18, 0x0a, 0x10, 0x53, 0x53, 0x4c, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x52, 0x45,
	0x51, 0x55, 0x49, 0x52, 0x45, 0x10, 0x02, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x1a, 0x0a, 0x12, 0x53,
	0x53, 0x4c, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x56, 0x45, 0x52, 0x49, 0x46, 0x59, 0x5f, 0x43,
	0x41, 0x10, 0x03, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x23, 0x0a, 0x1f, 0x41, 0x4c, 0x4c, 0x4f, 0x57,
	0x5f, 0x55, 0x4e, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x45, 0x44, 0x5f, 0x41, 0x4e, 0x44,
	0x5f, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x45, 0x44, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e,
	0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x45, 0x44, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x05,
	0x22, 0x3c, 0x0a, 0x08, 0x43, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x19, 0x0a, 0x15,
	0x43, 0x41, 0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x41, 0x5f, 0x53, 0x4f,
	0x55, 0x52, 0x43, 0x45, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44, 0x10, 0x01, 0x22, 0xb3,
	0x08, 0x0a, 0x15, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x6d, 0x0a, 0x0f, 0x77, 0x65, 0x65, 0x6b,
	0x6c, 0x79, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x57, 0x65, 0x65, 0x6b, 0x6c, 0x79, 0x53, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x0e, 0x77, 0x65, 0x65, 0x6b, 0x6c, 0x79, 0x53,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x7a, 0x0a, 0x14, 0x74, 0x69, 0x6d, 0x65, 0x5f,
	0x62, 0x61, 0x73, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x42,
	0x61, 0x73, 0x65, 0x64, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x01, 0x52,
	0x12, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x86, 0x01, 0x0a, 0x18, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x5f, 0x62, 0x61, 0x73, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x51, 0x75, 0x61, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x01, 0x52, 0x16, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x42, 0x61,
	0x73, 0x65, 0x64, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x07,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x02, 0x52,
	0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x88, 0x01, 0x01, 0x12, 0x3e, 0x0a, 0x0d, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x60, 0x0a, 0x11, 0x65,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x65, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1a, 0x0a,
	0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x57, 0x0a, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74,
	0x65, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x1a, 0x83, 0x01, 0x0a, 0x0e, 0x57, 0x65, 0x65, 0x6b, 0x6c, 0x79, 0x53, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x37, 0x0a, 0x0b, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x44,
	0x61, 0x79, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x12, 0x38,
	0x0a, 0x0c, 0x64, 0x61, 0x79, 0x73, 0x5f, 0x6f, 0x66, 0x5f, 0x77, 0x65, 0x65, 0x6b, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x44, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x52, 0x0a, 0x64, 0x61,
	0x79, 0x73, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x1a, 0x5a, 0x0a, 0x12, 0x54, 0x69, 0x6d, 0x65,
	0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x44,
	0x0a, 0x10, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x69,
	0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65,
	0x72, 0x69, 0x6f, 0x64, 0x1a, 0x2e, 0x0a, 0x16, 0x51, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14,
	0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42,
	0x0a, 0x0a, 0x08, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x42, 0x0b, 0x0a, 0x09, 0x72,
	0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x22, 0xd2, 0x01, 0x0a, 0x16, 0x43, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75,
	0x6f, 0x75, 0x73, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x1d, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x48, 0x00, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x88, 0x01, 0x01, 0x12, 0x30,
	0x0a, 0x14, 0x72, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x12, 0x72, 0x65,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x44, 0x61, 0x79, 0x73,
	0x12, 0x5b, 0x0a, 0x11, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79,
	0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x10, 0x65, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x0a, 0x0a,
	0x08, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0xca, 0x02, 0x0a, 0x14, 0x43, 0x6f,
	0x6e, 0x74, 0x69, 0x6e, 0x75, 0x6f, 0x75, 0x73, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x5a, 0x0a, 0x0f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79,
	0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e,
	0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x42,
	0x0a, 0x0c, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x37, 0x0a, 0x08, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x44, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x08, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x59, 0x0a, 0x18, 0x65,
	0x61, 0x72, 0x6c, 0x69, 0x65, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16,
	0x65, 0x61, 0x72, 0x6c, 0x69, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x62,
	0x6c, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x7a, 0x0a, 0x0c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x5f, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x09, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x55, 0x69, 0x64, 0x12, 0x46, 0x0a, 0x0b, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x0a, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x4e, 0x61,
	0x6d, 0x65, 0x22, 0x7c, 0x0a, 0x16, 0x43, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x6f, 0x75, 0x73,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x07,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x43, 0x0a, 0x0d, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x49, 0x6e, 0x54, 0x69, 0x6d, 0x65,
	0x22, 0x89, 0x02, 0x0a, 0x17, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x78, 0x0a, 0x13,
	0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x77, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e,
	0x61, 0x6e, 0x63, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x52, 0x12, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57,
	0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x1a, 0x74, 0x0a, 0x11, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65,
	0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x28, 0x0a, 0x03, 0x64,
	0x61, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b,
	0x52, 0x03, 0x64, 0x61, 0x79, 0x12, 0x35, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x44, 0x61,
	0x79, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x55, 0x0a, 0x13,
	0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x22, 0x80, 0x20, 0x0a, 0x07, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12,
	0x56, 0x0a, 0x0d, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x5f, 0x0a, 0x10, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x79, 0x0a, 0x1a, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x73, 0x71, 0x6c, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x72, 0x75, 0x6e, 0x5f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x2a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f,
	0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x53, 0x51, 0x4c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x17, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x73, 0x71, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f,
	0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x46, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x59, 0x0a, 0x0c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x18, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x5d, 0x0a, 0x10, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x5f, 0x0a, 0x0e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x1d, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x42, 0x0a, 0x07, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x18, 0x01, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x12,
	0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x12, 0x58, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x25, 0x0a, 0x0b,
	0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c,
	0x69, 0x6e, 0x67, 0x12, 0x52, 0x0a, 0x0c, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x75,
	0x73, 0x65, 0x72, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x50, 0x61, 0x73,
	0x73, 0x77, 0x6f, 0x72, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x0b, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x61, 0x6c, 0x55, 0x73, 0x65, 0x72, 0x12, 0x6b, 0x0a, 0x17, 0x61, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x65, 0x64, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65,
	0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x15, 0x61,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x4a, 0x0a, 0x0a, 0x73, 0x73, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x73, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x73, 0x73, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x60, 0x0a, 0x11, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79,
	0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x10, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x5a, 0x0a, 0x0f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79,
	0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e,
	0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x73,
	0x0a, 0x18, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x6f, 0x75, 0x73, 0x5f, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x43, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x6f, 0x75, 0x73, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x63, 0x6f, 0x6e,
	0x74, 0x69, 0x6e, 0x75, 0x6f, 0x75, 0x73, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x6d, 0x0a, 0x16, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x6f, 0x75,
	0x73, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x1c, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x6f, 0x75, 0x73, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x63, 0x6f,
	0x6e, 0x74, 0x69, 0x6e, 0x75, 0x6f, 0x75, 0x73, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x60, 0x0a, 0x10, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f,
	0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x2e, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x0f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x5f, 0x0a, 0x0e, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f,
	0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x2e, 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69,
	0x65, 0x73, 0x5f, 0x70, 0x7a, 0x69, 0x18, 0x21, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x69, 0x12,
	0x28, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x73,
	0x18, 0x1e, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x61, 0x74,
	0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x73, 0x12, 0x53, 0x0a, 0x0a, 0x70, 0x73, 0x63,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c,
	0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x2e, 0x50, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x76,
	0x0a, 0x19, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x20, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x17, 0x6d,
	0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x69, 0x0a, 0x14, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65,
	0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x25,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x53,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x6d, 0x61,
	0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x12, 0x5b, 0x0a, 0x0d, 0x67, 0x65, 0x6d, 0x69, 0x6e, 0x69, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x24, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x6d, 0x69, 0x6e, 0x69, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x67, 0x65, 0x6d, 0x69, 0x6e, 0x69, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x60,
	0x0a, 0x11, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x26, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10,
	0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x5f, 0x0a, 0x0e, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x27, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e,
	0x54, 0x72, 0x69, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0d, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x4e, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x29, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x42, 0x09, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x74, 0x61, 0x67,
	0x73, 0x1a, 0x84, 0x01, 0x0a, 0x0d, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x40, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x31, 0x0a, 0x12, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x65, 0x64, 0x5f, 0x69, 0x70, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65,
	0x64, 0x49, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x1a, 0x43, 0x0a, 0x0f, 0x53, 0x65, 0x63, 0x6f,
	0x6e, 0x64, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x30, 0x0a, 0x14, 0x70,
	0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x70, 0x72, 0x69, 0x6d, 0x61,
	0x72, 0x79, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x4c, 0x0a,
	0x0d, 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b,
	0x0a, 0x17, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x1a, 0x77, 0x0a, 0x09, 0x50,
	0x73, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x24, 0x0a, 0x0b, 0x70, 0x73, 0x63, 0x5f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0a, 0x70, 0x73, 0x63, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x44,
	0x0a, 0x1c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6f, 0x77, 0x6e, 0x65, 0x64, 0x5f,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x19, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x4f, 0x77, 0x6e, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x4e, 0x75,
	0x6d, 0x62, 0x65, 0x72, 0x1a, 0x82, 0x02, 0x0a, 0x0d, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3d, 0x0a, 0x0c, 0x75, 0x70, 0x67, 0x72,
	0x61, 0x64, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x75, 0x70, 0x67, 0x72,
	0x61, 0x64, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0e, 0x67, 0x72, 0x61, 0x63, 0x65,
	0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x67, 0x72, 0x61,
	0x63, 0x65, 0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x1a, 0x37, 0x0a, 0x09, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x9c, 0x01,
	0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09,
	0x0a, 0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x4f,
	0x50, 0x50, 0x45, 0x44, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x4d, 0x50, 0x54, 0x59, 0x10,
	0x03, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12,
	0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x0a, 0x0a,
	0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x12, 0x11, 0x0a, 0x0d, 0x42, 0x4f, 0x4f,
	0x54, 0x53, 0x54, 0x52, 0x41, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x12, 0x0f, 0x0a, 0x0b,
	0x4d, 0x41, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x08, 0x12, 0x0d, 0x0a,
	0x09, 0x50, 0x52, 0x4f, 0x4d, 0x4f, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x09, 0x22, 0x47, 0x0a, 0x0b,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x43,
	0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x52, 0x49,
	0x4d, 0x41, 0x52, 0x59, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44,
	0x41, 0x52, 0x59, 0x10, 0x02, 0x3a, 0x75, 0xea, 0x41, 0x72, 0x0a, 0x1e, 0x61, 0x6c, 0x6c, 0x6f,
	0x79, 0x64, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x3a, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x7d, 0x2a, 0x08, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73,
	0x32, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xf2, 0x28, 0x0a, 0x08, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4a, 0x0a, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f,
	0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x47, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x5d, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x5b, 0x0a, 0x0e, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d,
	0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x64, 0x0a,
	0x11, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x10, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x67, 0x63, 0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x63, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x60,
	0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x73,
	0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x73,
	0x12, 0x55, 0x0a, 0x0d, 0x77, 0x72, 0x69, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x6f, 0x64,
	0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e,
	0x4e, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x77, 0x72, 0x69, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x46, 0x0a, 0x05, 0x6e, 0x6f, 0x64, 0x65, 0x73,
	0x18, 0x14, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x4e,
	0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x12,
	0x76, 0x0a, 0x15, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c,
	0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x49, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x13, 0x71, 0x75, 0x65, 0x72, 0x79, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x75, 0x0a, 0x14, 0x6f, 0x62, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x4f, 0x62,
	0x73, 0x65, 0x72, 0x76, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x13, 0x6f, 0x62, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5f,
	0x0a, 0x10, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x52, 0x65, 0x61, 0x64, 0x50, 0x6f, 0x6f, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x0e, 0x72, 0x65, 0x61, 0x64, 0x50, 0x6f, 0x6f, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x22, 0x0a, 0x0a, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x0f, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x69, 0x70, 0x41, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x12, 0x37, 0x0a, 0x11, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x69, 0x70,
	0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b,
	0xe0, 0x41, 0x03, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x02, 0x52, 0x0f, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x49, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x25, 0x0a, 0x0b,
	0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x10, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c,
	0x69, 0x6e, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x11, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x59, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x12, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f,
	0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x58, 0x0a, 0x0d, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x7c, 0x0a, 0x18,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c,
	0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x16, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x61,
	0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x69, 0x18, 0x1e, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65,
	0x73, 0x50, 0x7a, 0x69, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65,
	0x73, 0x5f, 0x70, 0x7a, 0x73, 0x18, 0x18, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x73, 0x12, 0x6d,
	0x0a, 0x13, 0x70, 0x73, 0x63, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79,
	0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x2e, 0x50, 0x73, 0x63, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x70, 0x73, 0x63, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x68, 0x0a,
	0x0e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x1d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5c, 0x0a, 0x0d, 0x67, 0x65, 0x6d, 0x69, 0x6e,
	0x69, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x21, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c,
	0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65,
	0x6d, 0x69, 0x6e, 0x69, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x67, 0x65, 0x6d, 0x69, 0x6e, 0x69, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4c, 0x0a, 0x1c, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e,
	0x64, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x22, 0x20, 0x03, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x03,
	0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x02, 0x52, 0x19, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75,
	0x6e, 0x64, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x49, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x65, 0x73, 0x1a, 0x2c, 0x0a, 0x0d, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x63, 0x70, 0x75, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x1a, 0x55, 0x0a, 0x04, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x7a, 0x6f, 0x6e,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x7a, 0x6f, 0x6e, 0x65,
	0x49, 0x64, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02,
	0x69, 0x64, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02,
	0x69, 0x70, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x1a, 0xce, 0x02, 0x0a, 0x1b, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b, 0x0a, 0x17, 0x72, 0x65, 0x63, 0x6f,
	0x72, 0x64, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74,
	0x61, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x15, 0x72, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61,
	0x67, 0x73, 0x88, 0x01, 0x01, 0x12, 0x37, 0x0a, 0x15, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x5f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x01, 0x52, 0x13, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x43, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x88, 0x01, 0x01, 0x12, 0x2e,
	0x0a, 0x13, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x6c,
	0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x11, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x38,
	0x0a, 0x16, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x73, 0x5f, 0x70, 0x65,
	0x72, 0x5f, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x48, 0x02,
	0x52, 0x13, 0x71, 0x75, 0x65, 0x72, 0x79, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x50, 0x65, 0x72, 0x4d,
	0x69, 0x6e, 0x75, 0x74, 0x65, 0x88, 0x01, 0x01, 0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x72, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x61, 0x67, 0x73, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x5f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x42, 0x19,
	0x0a, 0x17, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x73, 0x5f, 0x70,
	0x65, 0x72, 0x5f, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x1a, 0xd7, 0x05, 0x0a, 0x1b, 0x4f, 0x62,
	0x73, 0x65, 0x72, 0x76, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a, 0x07, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x07, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x88, 0x01, 0x01, 0x12, 0x30, 0x0a, 0x11, 0x70, 0x72, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x48, 0x01, 0x52, 0x10, 0x70, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x43,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x88, 0x01, 0x01, 0x12, 0x2f, 0x0a, 0x11, 0x74, 0x72,
	0x61, 0x63, 0x6b, 0x5f, 0x77, 0x61, 0x69, 0x74, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x02, 0x52, 0x0f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x57, 0x61,
	0x69, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x88, 0x01, 0x01, 0x12, 0x3d, 0x0a, 0x16, 0x74,
	0x72, 0x61, 0x63, 0x6b, 0x5f, 0x77, 0x61, 0x69, 0x74, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x48, 0x03, 0x52, 0x13, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x57, 0x61, 0x69, 0x74, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x3a, 0x0a, 0x17, 0x6d, 0x61,
	0x78, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x6c,
	0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x48, 0x04, 0x52, 0x14, 0x6d,
	0x61, 0x78, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x4c, 0x65, 0x6e,
	0x67, 0x74, 0x68, 0x88, 0x01, 0x01, 0x12, 0x3b, 0x0a, 0x17, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x67,
	0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x48, 0x05, 0x52, 0x15, 0x72, 0x65, 0x63, 0x6f, 0x72,
	0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x67, 0x73,
	0x88, 0x01, 0x01, 0x12, 0x38, 0x0a, 0x16, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x6c, 0x61,
	0x6e, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x05, 0x48, 0x06, 0x52, 0x13, 0x71, 0x75, 0x65, 0x72, 0x79, 0x50, 0x6c, 0x61, 0x6e,
	0x73, 0x50, 0x65, 0x72, 0x4d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x35, 0x0a,
	0x14, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x71, 0x75,
	0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x48, 0x07, 0x52, 0x12, 0x74,
	0x72, 0x61, 0x63, 0x6b, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x88, 0x01, 0x01, 0x12, 0x35, 0x0a, 0x14, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x08, 0x48, 0x08, 0x52, 0x12, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x43, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x88, 0x01, 0x01, 0x42, 0x0a, 0x0a, 0x08, 0x5f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x70, 0x72, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x42, 0x14, 0x0a,
	0x12, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x77, 0x61, 0x69, 0x74, 0x5f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x73, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x77, 0x61,
	0x69, 0x74, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x42, 0x1a,
	0x0a, 0x18, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x72,
	0x65, 0x63, 0x6f, 0x72, 0x64, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6d, 0x69, 0x6e, 0x75, 0x74,
	0x65, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x61, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x74,
	0x72, 0x61, 0x63, 0x6b, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x1a, 0x2f, 0x0a, 0x0e, 0x52, 0x65, 0x61, 0x64, 0x50, 0x6f, 0x6f, 0x6c, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x98, 0x01, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x4c, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6d,
	0x6f, 0x64, 0x65, 0x22, 0x3a, 0x0a, 0x04, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x4d,
	0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x01, 0x12, 0x0f,
	0x0a, 0x0b, 0x46, 0x4f, 0x52, 0x43, 0x45, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x59, 0x10, 0x02, 0x1a,
	0x99, 0x01, 0x0a, 0x16, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x32, 0x0a, 0x12, 0x72, 0x65,
	0x71, 0x75, 0x69, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x72, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x4b,
	0x0a, 0x0a, 0x73, 0x73, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x53, 0x73, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x73, 0x73, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x54, 0x0a, 0x12, 0x50,
	0x73, 0x63, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x3e, 0x0a, 0x1b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x61, 0x74, 0x74,
	0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x19, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x41,
	0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x1a, 0xac, 0x02, 0x0a, 0x11, 0x50, 0x73, 0x63, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b, 0x0a, 0x17, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74,
	0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x3f, 0x0a, 0x19, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x17, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x50, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x12, 0x25, 0x0a, 0x0c, 0x70, 0x73, 0x63, 0x5f, 0x64, 0x6e, 0x73,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x70, 0x73, 0x63, 0x44, 0x6e, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x72, 0x0a, 0x15,
	0x70, 0x73, 0x63, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79,
	0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x2e, 0x50, 0x73, 0x63, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x70, 0x73, 0x63,
	0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x1a, 0xdc, 0x02, 0x0a, 0x15, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x95, 0x01, 0x0a, 0x1c, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1a, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x12, 0x2d, 0x0a, 0x10, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x5f, 0x69, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0e, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x49,
	0x70, 0x12, 0x3e, 0x0a, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6f, 0x75, 0x74, 0x62,
	0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x69, 0x70, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x4f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x49,
	0x70, 0x1a, 0x3c, 0x0a, 0x11, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x27, 0x0a, 0x0a, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x72,
	0x61, 0x6e, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xe2, 0x8c, 0xcf, 0xd7,
	0x08, 0x02, 0x08, 0x02, 0x52, 0x09, 0x63, 0x69, 0x64, 0x72, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x1a,
	0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x40, 0x0a, 0x12, 0x44, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3e, 0x0a, 0x10,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x91, 0x01, 0x0a,
	0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a,
	0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x4f, 0x50,
	0x50, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10,
	0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x4d, 0x41, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45,
	0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x12, 0x11,
	0x0a, 0x0d, 0x42, 0x4f, 0x4f, 0x54, 0x53, 0x54, 0x52, 0x41, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x10,
	0x08, 0x12, 0x0d, 0x0a, 0x09, 0x50, 0x52, 0x4f, 0x4d, 0x4f, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x09,
	0x22, 0x58, 0x0a, 0x0c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x1d, 0x0a, 0x19, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0b, 0x0a, 0x07, 0x50, 0x52, 0x49, 0x4d, 0x41, 0x52, 0x59, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09,
	0x52, 0x45, 0x41, 0x44, 0x5f, 0x50, 0x4f, 0x4f, 0x4c, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53,
	0x45, 0x43, 0x4f, 0x4e, 0x44, 0x41, 0x52, 0x59, 0x10, 0x03, 0x22, 0x4e, 0x0a, 0x10, 0x41, 0x76,
	0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21,
	0x0a, 0x1d, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x09, 0x0a, 0x05, 0x5a, 0x4f, 0x4e, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08,
	0x52, 0x45, 0x47, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x10, 0x02, 0x3a, 0x8e, 0x01, 0xea, 0x41, 0x8a,
	0x01, 0x0a, 0x1f, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x12, 0x4f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x7d, 0x2f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x7d, 0x2a, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x32, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x01, 0x01, 0x22, 0xba, 0x03, 0x0a, 0x0e,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x69, 0x70, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x37, 0x0a, 0x11, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x5f, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x0b, 0xe0, 0x41, 0x03, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x02, 0x52, 0x0f,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x49, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12,
	0x39, 0x0a, 0x15, 0x70, 0x65, 0x6d, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x05,
	0xe0, 0x41, 0x03, 0x18, 0x01, 0x52, 0x13, 0x70, 0x65, 0x6d, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x12, 0x26, 0x0a, 0x0c, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x75, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x55,
	0x69, 0x64, 0x12, 0x25, 0x0a, 0x0c, 0x70, 0x73, 0x63, 0x5f, 0x64, 0x6e, 0x73, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x70,
	0x73, 0x63, 0x44, 0x6e, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x3a, 0xac, 0x01, 0xea, 0x41, 0xa8, 0x01,
	0x0a, 0x25, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x5e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2a, 0x0f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x32, 0x0e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0xe9, 0x0f, 0x0a, 0x06, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x48, 0x0a, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f,
	0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x45, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3d, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79,
	0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24,
	0x0a, 0x0b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x75, 0x69, 0x64, 0x18, 0x12, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x55, 0x69, 0x64, 0x12, 0x49, 0x0a, 0x0c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x20, 0x0a, 0x1e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x52, 0x0b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x25, 0x0a, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e,
	0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x60, 0x0a, 0x11, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5a, 0x0a, 0x0f, 0x65, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x57, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c,
	0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x22, 0x0a, 0x0a, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18,
	0x11, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x69, 0x7a, 0x65,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x79, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x65, 0x78, 0x70,
	0x69, 0x72, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x66, 0x0a, 0x0f, 0x65, 0x78, 0x70, 0x69, 0x72,
	0x79, 0x5f, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x51, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x42,
	0x61, 0x73, 0x65, 0x64, 0x45, 0x78, 0x70, 0x69, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0e, 0x65, 0x78, 0x70, 0x69, 0x72, 0x79, 0x51, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12,
	0x28, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x69,
	0x18, 0x17, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x61, 0x74,
	0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x69, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x61, 0x74,
	0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x73, 0x18, 0x15, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73,
	0x50, 0x7a, 0x73, 0x12, 0x5d, 0x0a, 0x10, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c,
	0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x4d, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x19, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x42, 0x09, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x74, 0x61, 0x67,
	0x73, 0x1a, 0x7c, 0x0a, 0x13, 0x51, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x42, 0x61, 0x73,
	0x65, 0x64, 0x45, 0x78, 0x70, 0x69, 0x72, 0x79, 0x12, 0x2c, 0x0a, 0x0f, 0x72, 0x65, 0x74, 0x65,
	0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x37, 0x0a, 0x15, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f,
	0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a,
	0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x37, 0x0a, 0x09, 0x54, 0x61,
	0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x51, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x01, 0x12, 0x0c,
	0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06,
	0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45,
	0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x22, 0x4a, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14,
	0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4d, 0x41, 0x4e,
	0x44, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x41, 0x55, 0x54, 0x4f, 0x4d, 0x41, 0x54, 0x45, 0x44,
	0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x4f, 0x4e, 0x54, 0x49, 0x4e, 0x55, 0x4f, 0x55, 0x53,
	0x10, 0x03, 0x3a, 0x70, 0xea, 0x41, 0x6d, 0x0a, 0x1d, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x38, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x7d,
	0x2a, 0x07, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x32, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x52, 0x01, 0x01, 0x22, 0xb4, 0x08, 0x0a, 0x15, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x12, 0x79,
	0x0a, 0x13, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79,
	0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x46, 0x6c, 0x61, 0x67,
	0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x12, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73,
	0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x7c, 0x0a, 0x14, 0x69, 0x6e, 0x74,
	0x65, 0x67, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64,
	0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x2e, 0x49, 0x6e, 0x74,
	0x65, 0x67, 0x65, 0x72, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x48, 0x00, 0x52, 0x13, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x52, 0x65, 0x73, 0x74, 0x72,
	0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x66,
	0x6c, 0x61, 0x67, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x66, 0x6c, 0x61, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x5c, 0x0a, 0x0a, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f,
	0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x75, 0x70, 0x70,
	0x6f, 0x72, 0x74, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x46, 0x6c, 0x61,
	0x67, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x36, 0x0a, 0x17, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74,
	0x73, 0x5f, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x73,
	0x4d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x61,
	0x0a, 0x15, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x64, 0x62, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c,
	0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x44, 0x62, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x2e, 0x0a, 0x13, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x73, 0x5f, 0x64, 0x62,
	0x5f, 0x72, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11,
	0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x73, 0x44, 0x62, 0x52, 0x65, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x1a, 0x3b, 0x0a, 0x12, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x74, 0x72,
	0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x65, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x89,
	0x01, 0x0a, 0x13, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x38, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x38, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x08, 0x6d, 0x61, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x55, 0x0a, 0x09, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x56, 0x41, 0x4c, 0x55, 0x45,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12,
	0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x54, 0x45, 0x47, 0x45, 0x52, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05,
	0x46, 0x4c, 0x4f, 0x41, 0x54, 0x10, 0x03, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10,
	0x04, 0x3a, 0x97, 0x01, 0xea, 0x41, 0x93, 0x01, 0x0a, 0x2c, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64,
	0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x12, 0x34, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x66, 0x6c, 0x61, 0x67, 0x73, 0x2f, 0x7b, 0x66, 0x6c, 0x61, 0x67, 0x7d, 0x2a, 0x16, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x46,
	0x6c, 0x61, 0x67, 0x73, 0x32, 0x15, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x44,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x42, 0x0e, 0x0a, 0x0c, 0x72,
	0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xb8, 0x03, 0x0a, 0x04,
	0x55, 0x73, 0x65, 0x72, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a,
	0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x04, 0x52, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x2a,
	0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x12, 0x4d, 0x0a, 0x09, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c,
	0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73, 0x65,
	0x72, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x75, 0x73, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2d, 0x0a, 0x10, 0x6b, 0x65, 0x65,
	0x70, 0x5f, 0x65, 0x78, 0x74, 0x72, 0x61, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x0e, 0x6b, 0x65, 0x65, 0x70, 0x45, 0x78,
	0x74, 0x72, 0x61, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x22, 0x51, 0x0a, 0x08, 0x55, 0x73, 0x65, 0x72,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x14, 0x0a, 0x10, 0x41, 0x4c, 0x4c, 0x4f, 0x59, 0x44, 0x42, 0x5f, 0x42, 0x55, 0x49, 0x4c, 0x54,
	0x5f, 0x49, 0x4e, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x41, 0x4c, 0x4c, 0x4f, 0x59, 0x44, 0x42,
	0x5f, 0x49, 0x41, 0x4d, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x10, 0x02, 0x3a, 0x79, 0xea, 0x41, 0x76,
	0x0a, 0x1b, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x73, 0x65, 0x72, 0x12, 0x47, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f,
	0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x73, 0x2f,
	0x7b, 0x75, 0x73, 0x65, 0x72, 0x7d, 0x2a, 0x05, 0x75, 0x73, 0x65, 0x72, 0x73, 0x32, 0x04, 0x75,
	0x73, 0x65, 0x72, 0x52, 0x01, 0x01, 0x22, 0xf6, 0x01, 0x0a, 0x08, 0x44, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x07,
	0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x07, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x12, 0x21, 0x0a, 0x09, 0x63,
	0x6f, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x8e,
	0x01, 0xea, 0x41, 0x8a, 0x01, 0x0a, 0x1f, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x4f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x7d, 0x2a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x73, 0x32, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x01, 0x01, 0x2a,
	0x5e, 0x0a, 0x0c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x69, 0x65, 0x77, 0x12,
	0x1d, 0x0a, 0x19, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x56, 0x49, 0x45, 0x57,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17,
	0x0a, 0x13, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f,
	0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x49, 0x4e, 0x53, 0x54, 0x41,
	0x4e, 0x43, 0x45, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x02, 0x2a,
	0x67, 0x0a, 0x0b, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x56, 0x69, 0x65, 0x77, 0x12, 0x1c,
	0x0a, 0x18, 0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12,
	0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x42, 0x41, 0x53,
	0x49, 0x43, 0x10, 0x01, 0x12, 0x22, 0x0a, 0x1e, 0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x5f,
	0x56, 0x49, 0x45, 0x57, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x49, 0x4e, 0x55, 0x4f, 0x55, 0x53, 0x5f,
	0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x10, 0x02, 0x2a, 0x7b, 0x0a, 0x0f, 0x44, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x1c, 0x44,
	0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a,
	0x0b, 0x50, 0x4f, 0x53, 0x54, 0x47, 0x52, 0x45, 0x53, 0x5f, 0x31, 0x33, 0x10, 0x01, 0x1a, 0x02,
	0x08, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x4f, 0x53, 0x54, 0x47, 0x52, 0x45, 0x53, 0x5f, 0x31,
	0x34, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x4f, 0x53, 0x54, 0x47, 0x52, 0x45, 0x53, 0x5f,
	0x31, 0x35, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x4f, 0x53, 0x54, 0x47, 0x52, 0x45, 0x53,
	0x5f, 0x31, 0x36, 0x10, 0x04, 0x2a, 0x4e, 0x0a, 0x10, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x1d, 0x53, 0x55, 0x42,
	0x53, 0x43, 0x52, 0x49, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08,
	0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x54, 0x52,
	0x49, 0x41, 0x4c, 0x10, 0x02, 0x42, 0xcb, 0x03, 0xea, 0x41, 0xa6, 0x01, 0x0a, 0x28, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x7a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x6b, 0x65, 0x79, 0x52, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x69,
	0x6e, 0x67, 0x7d, 0x2f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x7b,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x7d, 0x2f, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x7d, 0xea, 0x41, 0x4e, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x2c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c,
	0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x7d, 0x0a, 0x20, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x42, 0x0e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x6c, 0x6c,
	0x6f, 0x79, 0x64, 0x62, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x70, 0x62, 0x3b, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64,
	0x62, 0x70, 0x62, 0xaa, 0x02, 0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x79, 0x44, 0x62, 0x2e, 0x56, 0x31, 0x41, 0x6c, 0x70,
	0x68, 0x61, 0xca, 0x02, 0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x41, 0x6c, 0x6c, 0x6f, 0x79, 0x44, 0x62, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0xea, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x3a, 0x3a, 0x41, 0x6c, 0x6c, 0x6f, 0x79, 0x44, 0x42, 0x3a, 0x3a, 0x56, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_alloydb_v1alpha_resources_proto_rawDescOnce sync.Once
	file_google_cloud_alloydb_v1alpha_resources_proto_rawDescData = file_google_cloud_alloydb_v1alpha_resources_proto_rawDesc
)

func file_google_cloud_alloydb_v1alpha_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_alloydb_v1alpha_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_alloydb_v1alpha_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_alloydb_v1alpha_resources_proto_rawDescData)
	})
	return file_google_cloud_alloydb_v1alpha_resources_proto_rawDescData
}

var file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 18)
var file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 52)
var file_google_cloud_alloydb_v1alpha_resources_proto_goTypes = []any{
	(InstanceView)(0),                                    // 0: google.cloud.alloydb.v1alpha.InstanceView
	(ClusterView)(0),                                     // 1: google.cloud.alloydb.v1alpha.ClusterView
	(DatabaseVersion)(0),                                 // 2: google.cloud.alloydb.v1alpha.DatabaseVersion
	(SubscriptionType)(0),                                // 3: google.cloud.alloydb.v1alpha.SubscriptionType
	(MigrationSource_MigrationSourceType)(0),             // 4: google.cloud.alloydb.v1alpha.MigrationSource.MigrationSourceType
	(EncryptionInfo_Type)(0),                             // 5: google.cloud.alloydb.v1alpha.EncryptionInfo.Type
	(SslConfig_SslMode)(0),                               // 6: google.cloud.alloydb.v1alpha.SslConfig.SslMode
	(SslConfig_CaSource)(0),                              // 7: google.cloud.alloydb.v1alpha.SslConfig.CaSource
	(Cluster_State)(0),                                   // 8: google.cloud.alloydb.v1alpha.Cluster.State
	(Cluster_ClusterType)(0),                             // 9: google.cloud.alloydb.v1alpha.Cluster.ClusterType
	(Instance_State)(0),                                  // 10: google.cloud.alloydb.v1alpha.Instance.State
	(Instance_InstanceType)(0),                           // 11: google.cloud.alloydb.v1alpha.Instance.InstanceType
	(Instance_AvailabilityType)(0),                       // 12: google.cloud.alloydb.v1alpha.Instance.AvailabilityType
	(Instance_UpdatePolicy_Mode)(0),                      // 13: google.cloud.alloydb.v1alpha.Instance.UpdatePolicy.Mode
	(Backup_State)(0),                                    // 14: google.cloud.alloydb.v1alpha.Backup.State
	(Backup_Type)(0),                                     // 15: google.cloud.alloydb.v1alpha.Backup.Type
	(SupportedDatabaseFlag_ValueType)(0),                 // 16: google.cloud.alloydb.v1alpha.SupportedDatabaseFlag.ValueType
	(User_UserType)(0),                                   // 17: google.cloud.alloydb.v1alpha.User.UserType
	(*UserPassword)(nil),                                 // 18: google.cloud.alloydb.v1alpha.UserPassword
	(*MigrationSource)(nil),                              // 19: google.cloud.alloydb.v1alpha.MigrationSource
	(*EncryptionConfig)(nil),                             // 20: google.cloud.alloydb.v1alpha.EncryptionConfig
	(*EncryptionInfo)(nil),                               // 21: google.cloud.alloydb.v1alpha.EncryptionInfo
	(*SslConfig)(nil),                                    // 22: google.cloud.alloydb.v1alpha.SslConfig
	(*AutomatedBackupPolicy)(nil),                        // 23: google.cloud.alloydb.v1alpha.AutomatedBackupPolicy
	(*ContinuousBackupConfig)(nil),                       // 24: google.cloud.alloydb.v1alpha.ContinuousBackupConfig
	(*ContinuousBackupInfo)(nil),                         // 25: google.cloud.alloydb.v1alpha.ContinuousBackupInfo
	(*BackupSource)(nil),                                 // 26: google.cloud.alloydb.v1alpha.BackupSource
	(*ContinuousBackupSource)(nil),                       // 27: google.cloud.alloydb.v1alpha.ContinuousBackupSource
	(*MaintenanceUpdatePolicy)(nil),                      // 28: google.cloud.alloydb.v1alpha.MaintenanceUpdatePolicy
	(*MaintenanceSchedule)(nil),                          // 29: google.cloud.alloydb.v1alpha.MaintenanceSchedule
	(*Cluster)(nil),                                      // 30: google.cloud.alloydb.v1alpha.Cluster
	(*Instance)(nil),                                     // 31: google.cloud.alloydb.v1alpha.Instance
	(*ConnectionInfo)(nil),                               // 32: google.cloud.alloydb.v1alpha.ConnectionInfo
	(*Backup)(nil),                                       // 33: google.cloud.alloydb.v1alpha.Backup
	(*SupportedDatabaseFlag)(nil),                        // 34: google.cloud.alloydb.v1alpha.SupportedDatabaseFlag
	(*User)(nil),                                         // 35: google.cloud.alloydb.v1alpha.User
	(*Database)(nil),                                     // 36: google.cloud.alloydb.v1alpha.Database
	(*AutomatedBackupPolicy_WeeklySchedule)(nil),         // 37: google.cloud.alloydb.v1alpha.AutomatedBackupPolicy.WeeklySchedule
	(*AutomatedBackupPolicy_TimeBasedRetention)(nil),     // 38: google.cloud.alloydb.v1alpha.AutomatedBackupPolicy.TimeBasedRetention
	(*AutomatedBackupPolicy_QuantityBasedRetention)(nil), // 39: google.cloud.alloydb.v1alpha.AutomatedBackupPolicy.QuantityBasedRetention
	nil, // 40: google.cloud.alloydb.v1alpha.AutomatedBackupPolicy.LabelsEntry
	(*MaintenanceUpdatePolicy_MaintenanceWindow)(nil), // 41: google.cloud.alloydb.v1alpha.MaintenanceUpdatePolicy.MaintenanceWindow
	(*Cluster_NetworkConfig)(nil),                     // 42: google.cloud.alloydb.v1alpha.Cluster.NetworkConfig
	(*Cluster_SecondaryConfig)(nil),                   // 43: google.cloud.alloydb.v1alpha.Cluster.SecondaryConfig
	(*Cluster_PrimaryConfig)(nil),                     // 44: google.cloud.alloydb.v1alpha.Cluster.PrimaryConfig
	(*Cluster_PscConfig)(nil),                         // 45: google.cloud.alloydb.v1alpha.Cluster.PscConfig
	(*Cluster_TrialMetadata)(nil),                     // 46: google.cloud.alloydb.v1alpha.Cluster.TrialMetadata
	nil,                                               // 47: google.cloud.alloydb.v1alpha.Cluster.LabelsEntry
	nil,                                               // 48: google.cloud.alloydb.v1alpha.Cluster.AnnotationsEntry
	nil,                                               // 49: google.cloud.alloydb.v1alpha.Cluster.TagsEntry
	(*Instance_MachineConfig)(nil),                    // 50: google.cloud.alloydb.v1alpha.Instance.MachineConfig
	(*Instance_Node)(nil),                             // 51: google.cloud.alloydb.v1alpha.Instance.Node
	(*Instance_QueryInsightsInstanceConfig)(nil), // 52: google.cloud.alloydb.v1alpha.Instance.QueryInsightsInstanceConfig
	(*Instance_ObservabilityInstanceConfig)(nil), // 53: google.cloud.alloydb.v1alpha.Instance.ObservabilityInstanceConfig
	(*Instance_ReadPoolConfig)(nil),              // 54: google.cloud.alloydb.v1alpha.Instance.ReadPoolConfig
	(*Instance_UpdatePolicy)(nil),                // 55: google.cloud.alloydb.v1alpha.Instance.UpdatePolicy
	(*Instance_ClientConnectionConfig)(nil),      // 56: google.cloud.alloydb.v1alpha.Instance.ClientConnectionConfig
	(*Instance_PscInterfaceConfig)(nil),          // 57: google.cloud.alloydb.v1alpha.Instance.PscInterfaceConfig
	(*Instance_PscInstanceConfig)(nil),           // 58: google.cloud.alloydb.v1alpha.Instance.PscInstanceConfig
	(*Instance_InstanceNetworkConfig)(nil),       // 59: google.cloud.alloydb.v1alpha.Instance.InstanceNetworkConfig
	nil,                                          // 60: google.cloud.alloydb.v1alpha.Instance.LabelsEntry
	nil,                                          // 61: google.cloud.alloydb.v1alpha.Instance.DatabaseFlagsEntry
	nil,                                          // 62: google.cloud.alloydb.v1alpha.Instance.AnnotationsEntry
	(*Instance_InstanceNetworkConfig_AuthorizedNetwork)(nil), // 63: google.cloud.alloydb.v1alpha.Instance.InstanceNetworkConfig.AuthorizedNetwork
	(*Backup_QuantityBasedExpiry)(nil),                       // 64: google.cloud.alloydb.v1alpha.Backup.QuantityBasedExpiry
	nil,                                                      // 65: google.cloud.alloydb.v1alpha.Backup.LabelsEntry
	nil,                                                      // 66: google.cloud.alloydb.v1alpha.Backup.AnnotationsEntry
	nil,                                                      // 67: google.cloud.alloydb.v1alpha.Backup.TagsEntry
	(*SupportedDatabaseFlag_StringRestrictions)(nil),  // 68: google.cloud.alloydb.v1alpha.SupportedDatabaseFlag.StringRestrictions
	(*SupportedDatabaseFlag_IntegerRestrictions)(nil), // 69: google.cloud.alloydb.v1alpha.SupportedDatabaseFlag.IntegerRestrictions
	(*durationpb.Duration)(nil),                       // 70: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),                     // 71: google.protobuf.Timestamp
	(dayofweek.DayOfWeek)(0),                          // 72: google.type.DayOfWeek
	(*CloudSQLBackupRunSource)(nil),                   // 73: google.cloud.alloydb.v1alpha.CloudSQLBackupRunSource
	(*GeminiClusterConfig)(nil),                       // 74: google.cloud.alloydb.v1alpha.GeminiClusterConfig
	(*GeminiInstanceConfig)(nil),                      // 75: google.cloud.alloydb.v1alpha.GeminiInstanceConfig
	(*timeofday.TimeOfDay)(nil),                       // 76: google.type.TimeOfDay
	(*wrapperspb.Int64Value)(nil),                     // 77: google.protobuf.Int64Value
}
var file_google_cloud_alloydb_v1alpha_resources_proto_depIdxs = []int32{
	4,  // 0: google.cloud.alloydb.v1alpha.MigrationSource.source_type:type_name -> google.cloud.alloydb.v1alpha.MigrationSource.MigrationSourceType
	5,  // 1: google.cloud.alloydb.v1alpha.EncryptionInfo.encryption_type:type_name -> google.cloud.alloydb.v1alpha.EncryptionInfo.Type
	6,  // 2: google.cloud.alloydb.v1alpha.SslConfig.ssl_mode:type_name -> google.cloud.alloydb.v1alpha.SslConfig.SslMode
	7,  // 3: google.cloud.alloydb.v1alpha.SslConfig.ca_source:type_name -> google.cloud.alloydb.v1alpha.SslConfig.CaSource
	37, // 4: google.cloud.alloydb.v1alpha.AutomatedBackupPolicy.weekly_schedule:type_name -> google.cloud.alloydb.v1alpha.AutomatedBackupPolicy.WeeklySchedule
	38, // 5: google.cloud.alloydb.v1alpha.AutomatedBackupPolicy.time_based_retention:type_name -> google.cloud.alloydb.v1alpha.AutomatedBackupPolicy.TimeBasedRetention
	39, // 6: google.cloud.alloydb.v1alpha.AutomatedBackupPolicy.quantity_based_retention:type_name -> google.cloud.alloydb.v1alpha.AutomatedBackupPolicy.QuantityBasedRetention
	70, // 7: google.cloud.alloydb.v1alpha.AutomatedBackupPolicy.backup_window:type_name -> google.protobuf.Duration
	20, // 8: google.cloud.alloydb.v1alpha.AutomatedBackupPolicy.encryption_config:type_name -> google.cloud.alloydb.v1alpha.EncryptionConfig
	40, // 9: google.cloud.alloydb.v1alpha.AutomatedBackupPolicy.labels:type_name -> google.cloud.alloydb.v1alpha.AutomatedBackupPolicy.LabelsEntry
	20, // 10: google.cloud.alloydb.v1alpha.ContinuousBackupConfig.encryption_config:type_name -> google.cloud.alloydb.v1alpha.EncryptionConfig
	21, // 11: google.cloud.alloydb.v1alpha.ContinuousBackupInfo.encryption_info:type_name -> google.cloud.alloydb.v1alpha.EncryptionInfo
	71, // 12: google.cloud.alloydb.v1alpha.ContinuousBackupInfo.enabled_time:type_name -> google.protobuf.Timestamp
	72, // 13: google.cloud.alloydb.v1alpha.ContinuousBackupInfo.schedule:type_name -> google.type.DayOfWeek
	71, // 14: google.cloud.alloydb.v1alpha.ContinuousBackupInfo.earliest_restorable_time:type_name -> google.protobuf.Timestamp
	71, // 15: google.cloud.alloydb.v1alpha.ContinuousBackupSource.point_in_time:type_name -> google.protobuf.Timestamp
	41, // 16: google.cloud.alloydb.v1alpha.MaintenanceUpdatePolicy.maintenance_windows:type_name -> google.cloud.alloydb.v1alpha.MaintenanceUpdatePolicy.MaintenanceWindow
	71, // 17: google.cloud.alloydb.v1alpha.MaintenanceSchedule.start_time:type_name -> google.protobuf.Timestamp
	26, // 18: google.cloud.alloydb.v1alpha.Cluster.backup_source:type_name -> google.cloud.alloydb.v1alpha.BackupSource
	19, // 19: google.cloud.alloydb.v1alpha.Cluster.migration_source:type_name -> google.cloud.alloydb.v1alpha.MigrationSource
	73, // 20: google.cloud.alloydb.v1alpha.Cluster.cloudsql_backup_run_source:type_name -> google.cloud.alloydb.v1alpha.CloudSQLBackupRunSource
	71, // 21: google.cloud.alloydb.v1alpha.Cluster.create_time:type_name -> google.protobuf.Timestamp
	71, // 22: google.cloud.alloydb.v1alpha.Cluster.update_time:type_name -> google.protobuf.Timestamp
	71, // 23: google.cloud.alloydb.v1alpha.Cluster.delete_time:type_name -> google.protobuf.Timestamp
	47, // 24: google.cloud.alloydb.v1alpha.Cluster.labels:type_name -> google.cloud.alloydb.v1alpha.Cluster.LabelsEntry
	8,  // 25: google.cloud.alloydb.v1alpha.Cluster.state:type_name -> google.cloud.alloydb.v1alpha.Cluster.State
	9,  // 26: google.cloud.alloydb.v1alpha.Cluster.cluster_type:type_name -> google.cloud.alloydb.v1alpha.Cluster.ClusterType
	2,  // 27: google.cloud.alloydb.v1alpha.Cluster.database_version:type_name -> google.cloud.alloydb.v1alpha.DatabaseVersion
	42, // 28: google.cloud.alloydb.v1alpha.Cluster.network_config:type_name -> google.cloud.alloydb.v1alpha.Cluster.NetworkConfig
	48, // 29: google.cloud.alloydb.v1alpha.Cluster.annotations:type_name -> google.cloud.alloydb.v1alpha.Cluster.AnnotationsEntry
	18, // 30: google.cloud.alloydb.v1alpha.Cluster.initial_user:type_name -> google.cloud.alloydb.v1alpha.UserPassword
	23, // 31: google.cloud.alloydb.v1alpha.Cluster.automated_backup_policy:type_name -> google.cloud.alloydb.v1alpha.AutomatedBackupPolicy
	22, // 32: google.cloud.alloydb.v1alpha.Cluster.ssl_config:type_name -> google.cloud.alloydb.v1alpha.SslConfig
	20, // 33: google.cloud.alloydb.v1alpha.Cluster.encryption_config:type_name -> google.cloud.alloydb.v1alpha.EncryptionConfig
	21, // 34: google.cloud.alloydb.v1alpha.Cluster.encryption_info:type_name -> google.cloud.alloydb.v1alpha.EncryptionInfo
	24, // 35: google.cloud.alloydb.v1alpha.Cluster.continuous_backup_config:type_name -> google.cloud.alloydb.v1alpha.ContinuousBackupConfig
	25, // 36: google.cloud.alloydb.v1alpha.Cluster.continuous_backup_info:type_name -> google.cloud.alloydb.v1alpha.ContinuousBackupInfo
	43, // 37: google.cloud.alloydb.v1alpha.Cluster.secondary_config:type_name -> google.cloud.alloydb.v1alpha.Cluster.SecondaryConfig
	44, // 38: google.cloud.alloydb.v1alpha.Cluster.primary_config:type_name -> google.cloud.alloydb.v1alpha.Cluster.PrimaryConfig
	45, // 39: google.cloud.alloydb.v1alpha.Cluster.psc_config:type_name -> google.cloud.alloydb.v1alpha.Cluster.PscConfig
	28, // 40: google.cloud.alloydb.v1alpha.Cluster.maintenance_update_policy:type_name -> google.cloud.alloydb.v1alpha.MaintenanceUpdatePolicy
	29, // 41: google.cloud.alloydb.v1alpha.Cluster.maintenance_schedule:type_name -> google.cloud.alloydb.v1alpha.MaintenanceSchedule
	74, // 42: google.cloud.alloydb.v1alpha.Cluster.gemini_config:type_name -> google.cloud.alloydb.v1alpha.GeminiClusterConfig
	3,  // 43: google.cloud.alloydb.v1alpha.Cluster.subscription_type:type_name -> google.cloud.alloydb.v1alpha.SubscriptionType
	46, // 44: google.cloud.alloydb.v1alpha.Cluster.trial_metadata:type_name -> google.cloud.alloydb.v1alpha.Cluster.TrialMetadata
	49, // 45: google.cloud.alloydb.v1alpha.Cluster.tags:type_name -> google.cloud.alloydb.v1alpha.Cluster.TagsEntry
	71, // 46: google.cloud.alloydb.v1alpha.Instance.create_time:type_name -> google.protobuf.Timestamp
	71, // 47: google.cloud.alloydb.v1alpha.Instance.update_time:type_name -> google.protobuf.Timestamp
	71, // 48: google.cloud.alloydb.v1alpha.Instance.delete_time:type_name -> google.protobuf.Timestamp
	60, // 49: google.cloud.alloydb.v1alpha.Instance.labels:type_name -> google.cloud.alloydb.v1alpha.Instance.LabelsEntry
	10, // 50: google.cloud.alloydb.v1alpha.Instance.state:type_name -> google.cloud.alloydb.v1alpha.Instance.State
	11, // 51: google.cloud.alloydb.v1alpha.Instance.instance_type:type_name -> google.cloud.alloydb.v1alpha.Instance.InstanceType
	50, // 52: google.cloud.alloydb.v1alpha.Instance.machine_config:type_name -> google.cloud.alloydb.v1alpha.Instance.MachineConfig
	12, // 53: google.cloud.alloydb.v1alpha.Instance.availability_type:type_name -> google.cloud.alloydb.v1alpha.Instance.AvailabilityType
	61, // 54: google.cloud.alloydb.v1alpha.Instance.database_flags:type_name -> google.cloud.alloydb.v1alpha.Instance.DatabaseFlagsEntry
	51, // 55: google.cloud.alloydb.v1alpha.Instance.writable_node:type_name -> google.cloud.alloydb.v1alpha.Instance.Node
	51, // 56: google.cloud.alloydb.v1alpha.Instance.nodes:type_name -> google.cloud.alloydb.v1alpha.Instance.Node
	52, // 57: google.cloud.alloydb.v1alpha.Instance.query_insights_config:type_name -> google.cloud.alloydb.v1alpha.Instance.QueryInsightsInstanceConfig
	53, // 58: google.cloud.alloydb.v1alpha.Instance.observability_config:type_name -> google.cloud.alloydb.v1alpha.Instance.ObservabilityInstanceConfig
	54, // 59: google.cloud.alloydb.v1alpha.Instance.read_pool_config:type_name -> google.cloud.alloydb.v1alpha.Instance.ReadPoolConfig
	62, // 60: google.cloud.alloydb.v1alpha.Instance.annotations:type_name -> google.cloud.alloydb.v1alpha.Instance.AnnotationsEntry
	55, // 61: google.cloud.alloydb.v1alpha.Instance.update_policy:type_name -> google.cloud.alloydb.v1alpha.Instance.UpdatePolicy
	56, // 62: google.cloud.alloydb.v1alpha.Instance.client_connection_config:type_name -> google.cloud.alloydb.v1alpha.Instance.ClientConnectionConfig
	58, // 63: google.cloud.alloydb.v1alpha.Instance.psc_instance_config:type_name -> google.cloud.alloydb.v1alpha.Instance.PscInstanceConfig
	59, // 64: google.cloud.alloydb.v1alpha.Instance.network_config:type_name -> google.cloud.alloydb.v1alpha.Instance.InstanceNetworkConfig
	75, // 65: google.cloud.alloydb.v1alpha.Instance.gemini_config:type_name -> google.cloud.alloydb.v1alpha.GeminiInstanceConfig
	71, // 66: google.cloud.alloydb.v1alpha.Backup.create_time:type_name -> google.protobuf.Timestamp
	71, // 67: google.cloud.alloydb.v1alpha.Backup.update_time:type_name -> google.protobuf.Timestamp
	71, // 68: google.cloud.alloydb.v1alpha.Backup.delete_time:type_name -> google.protobuf.Timestamp
	65, // 69: google.cloud.alloydb.v1alpha.Backup.labels:type_name -> google.cloud.alloydb.v1alpha.Backup.LabelsEntry
	14, // 70: google.cloud.alloydb.v1alpha.Backup.state:type_name -> google.cloud.alloydb.v1alpha.Backup.State
	15, // 71: google.cloud.alloydb.v1alpha.Backup.type:type_name -> google.cloud.alloydb.v1alpha.Backup.Type
	20, // 72: google.cloud.alloydb.v1alpha.Backup.encryption_config:type_name -> google.cloud.alloydb.v1alpha.EncryptionConfig
	21, // 73: google.cloud.alloydb.v1alpha.Backup.encryption_info:type_name -> google.cloud.alloydb.v1alpha.EncryptionInfo
	66, // 74: google.cloud.alloydb.v1alpha.Backup.annotations:type_name -> google.cloud.alloydb.v1alpha.Backup.AnnotationsEntry
	71, // 75: google.cloud.alloydb.v1alpha.Backup.expiry_time:type_name -> google.protobuf.Timestamp
	64, // 76: google.cloud.alloydb.v1alpha.Backup.expiry_quantity:type_name -> google.cloud.alloydb.v1alpha.Backup.QuantityBasedExpiry
	2,  // 77: google.cloud.alloydb.v1alpha.Backup.database_version:type_name -> google.cloud.alloydb.v1alpha.DatabaseVersion
	67, // 78: google.cloud.alloydb.v1alpha.Backup.tags:type_name -> google.cloud.alloydb.v1alpha.Backup.TagsEntry
	68, // 79: google.cloud.alloydb.v1alpha.SupportedDatabaseFlag.string_restrictions:type_name -> google.cloud.alloydb.v1alpha.SupportedDatabaseFlag.StringRestrictions
	69, // 80: google.cloud.alloydb.v1alpha.SupportedDatabaseFlag.integer_restrictions:type_name -> google.cloud.alloydb.v1alpha.SupportedDatabaseFlag.IntegerRestrictions
	16, // 81: google.cloud.alloydb.v1alpha.SupportedDatabaseFlag.value_type:type_name -> google.cloud.alloydb.v1alpha.SupportedDatabaseFlag.ValueType
	2,  // 82: google.cloud.alloydb.v1alpha.SupportedDatabaseFlag.supported_db_versions:type_name -> google.cloud.alloydb.v1alpha.DatabaseVersion
	17, // 83: google.cloud.alloydb.v1alpha.User.user_type:type_name -> google.cloud.alloydb.v1alpha.User.UserType
	76, // 84: google.cloud.alloydb.v1alpha.AutomatedBackupPolicy.WeeklySchedule.start_times:type_name -> google.type.TimeOfDay
	72, // 85: google.cloud.alloydb.v1alpha.AutomatedBackupPolicy.WeeklySchedule.days_of_week:type_name -> google.type.DayOfWeek
	70, // 86: google.cloud.alloydb.v1alpha.AutomatedBackupPolicy.TimeBasedRetention.retention_period:type_name -> google.protobuf.Duration
	72, // 87: google.cloud.alloydb.v1alpha.MaintenanceUpdatePolicy.MaintenanceWindow.day:type_name -> google.type.DayOfWeek
	76, // 88: google.cloud.alloydb.v1alpha.MaintenanceUpdatePolicy.MaintenanceWindow.start_time:type_name -> google.type.TimeOfDay
	71, // 89: google.cloud.alloydb.v1alpha.Cluster.TrialMetadata.start_time:type_name -> google.protobuf.Timestamp
	71, // 90: google.cloud.alloydb.v1alpha.Cluster.TrialMetadata.end_time:type_name -> google.protobuf.Timestamp
	71, // 91: google.cloud.alloydb.v1alpha.Cluster.TrialMetadata.upgrade_time:type_name -> google.protobuf.Timestamp
	71, // 92: google.cloud.alloydb.v1alpha.Cluster.TrialMetadata.grace_end_time:type_name -> google.protobuf.Timestamp
	13, // 93: google.cloud.alloydb.v1alpha.Instance.UpdatePolicy.mode:type_name -> google.cloud.alloydb.v1alpha.Instance.UpdatePolicy.Mode
	22, // 94: google.cloud.alloydb.v1alpha.Instance.ClientConnectionConfig.ssl_config:type_name -> google.cloud.alloydb.v1alpha.SslConfig
	57, // 95: google.cloud.alloydb.v1alpha.Instance.PscInstanceConfig.psc_interface_configs:type_name -> google.cloud.alloydb.v1alpha.Instance.PscInterfaceConfig
	63, // 96: google.cloud.alloydb.v1alpha.Instance.InstanceNetworkConfig.authorized_external_networks:type_name -> google.cloud.alloydb.v1alpha.Instance.InstanceNetworkConfig.AuthorizedNetwork
	77, // 97: google.cloud.alloydb.v1alpha.SupportedDatabaseFlag.IntegerRestrictions.min_value:type_name -> google.protobuf.Int64Value
	77, // 98: google.cloud.alloydb.v1alpha.SupportedDatabaseFlag.IntegerRestrictions.max_value:type_name -> google.protobuf.Int64Value
	99, // [99:99] is the sub-list for method output_type
	99, // [99:99] is the sub-list for method input_type
	99, // [99:99] is the sub-list for extension type_name
	99, // [99:99] is the sub-list for extension extendee
	0,  // [0:99] is the sub-list for field type_name
}

func init() { file_google_cloud_alloydb_v1alpha_resources_proto_init() }
func file_google_cloud_alloydb_v1alpha_resources_proto_init() {
	if File_google_cloud_alloydb_v1alpha_resources_proto != nil {
		return
	}
	file_google_cloud_alloydb_v1alpha_csql_resources_proto_init()
	file_google_cloud_alloydb_v1alpha_gemini_proto_init()
	file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[5].OneofWrappers = []any{
		(*AutomatedBackupPolicy_WeeklySchedule_)(nil),
		(*AutomatedBackupPolicy_TimeBasedRetention_)(nil),
		(*AutomatedBackupPolicy_QuantityBasedRetention_)(nil),
	}
	file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[6].OneofWrappers = []any{}
	file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[12].OneofWrappers = []any{
		(*Cluster_BackupSource)(nil),
		(*Cluster_MigrationSource)(nil),
		(*Cluster_CloudsqlBackupRunSource)(nil),
	}
	file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[16].OneofWrappers = []any{
		(*SupportedDatabaseFlag_StringRestrictions_)(nil),
		(*SupportedDatabaseFlag_IntegerRestrictions_)(nil),
	}
	file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[34].OneofWrappers = []any{}
	file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes[35].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_alloydb_v1alpha_resources_proto_rawDesc,
			NumEnums:      18,
			NumMessages:   52,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_alloydb_v1alpha_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_alloydb_v1alpha_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_alloydb_v1alpha_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_alloydb_v1alpha_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_alloydb_v1alpha_resources_proto = out.File
	file_google_cloud_alloydb_v1alpha_resources_proto_rawDesc = nil
	file_google_cloud_alloydb_v1alpha_resources_proto_goTypes = nil
	file_google_cloud_alloydb_v1alpha_resources_proto_depIdxs = nil
}
