// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.5
// source: google/cloud/aiplatform/v1beta1/migration_service.proto

package aiplatformpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for [MigrationService.SearchMigratableResources][google.cloud.aiplatform.v1beta1.MigrationService.SearchMigratableResources].
type SearchMigratableResourcesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location that the migratable resources should be searched from.
	// It's the Vertex AI location that the resources can be migrated to, not
	// the resources' original location.
	// Format:
	// `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The standard page size.
	// The default and maximum value is 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The standard page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter for your search. You can use the following types of filters:
	//
	//   - Resource type filters. The following strings filter for a specific type
	//     of [MigratableResource][google.cloud.aiplatform.v1beta1.MigratableResource]:
	//   - `ml_engine_model_version:*`
	//   - `automl_model:*`
	//   - `automl_dataset:*`
	//   - `data_labeling_dataset:*`
	//   - "Migrated or not" filters. The following strings filter for resources
	//     that either have or have not already been migrated:
	//   - `last_migrate_time:*` filters for migrated resources.
	//   - `NOT last_migrate_time:*` filters for not yet migrated resources.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *SearchMigratableResourcesRequest) Reset() {
	*x = SearchMigratableResourcesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchMigratableResourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchMigratableResourcesRequest) ProtoMessage() {}

func (x *SearchMigratableResourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchMigratableResourcesRequest.ProtoReflect.Descriptor instead.
func (*SearchMigratableResourcesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_migration_service_proto_rawDescGZIP(), []int{0}
}

func (x *SearchMigratableResourcesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SearchMigratableResourcesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchMigratableResourcesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchMigratableResourcesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for [MigrationService.SearchMigratableResources][google.cloud.aiplatform.v1beta1.MigrationService.SearchMigratableResources].
type SearchMigratableResourcesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// All migratable resources that can be migrated to the
	// location specified in the request.
	MigratableResources []*MigratableResource `protobuf:"bytes,1,rep,name=migratable_resources,json=migratableResources,proto3" json:"migratable_resources,omitempty"`
	// The standard next-page token.
	// The migratable_resources may not fill page_size in
	// SearchMigratableResourcesRequest even when there are subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchMigratableResourcesResponse) Reset() {
	*x = SearchMigratableResourcesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchMigratableResourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchMigratableResourcesResponse) ProtoMessage() {}

func (x *SearchMigratableResourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchMigratableResourcesResponse.ProtoReflect.Descriptor instead.
func (*SearchMigratableResourcesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_migration_service_proto_rawDescGZIP(), []int{1}
}

func (x *SearchMigratableResourcesResponse) GetMigratableResources() []*MigratableResource {
	if x != nil {
		return x.MigratableResources
	}
	return nil
}

func (x *SearchMigratableResourcesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for [MigrationService.BatchMigrateResources][google.cloud.aiplatform.v1beta1.MigrationService.BatchMigrateResources].
type BatchMigrateResourcesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location of the migrated resource will live in.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The request messages specifying the resources to migrate.
	// They must be in the same location as the destination.
	// Up to 50 resources can be migrated in one batch.
	MigrateResourceRequests []*MigrateResourceRequest `protobuf:"bytes,2,rep,name=migrate_resource_requests,json=migrateResourceRequests,proto3" json:"migrate_resource_requests,omitempty"`
}

func (x *BatchMigrateResourcesRequest) Reset() {
	*x = BatchMigrateResourcesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchMigrateResourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchMigrateResourcesRequest) ProtoMessage() {}

func (x *BatchMigrateResourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchMigrateResourcesRequest.ProtoReflect.Descriptor instead.
func (*BatchMigrateResourcesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_migration_service_proto_rawDescGZIP(), []int{2}
}

func (x *BatchMigrateResourcesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchMigrateResourcesRequest) GetMigrateResourceRequests() []*MigrateResourceRequest {
	if x != nil {
		return x.MigrateResourceRequests
	}
	return nil
}

// Config of migrating one resource from automl.googleapis.com,
// datalabeling.googleapis.com and ml.googleapis.com to Vertex AI.
type MigrateResourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Request:
	//
	//	*MigrateResourceRequest_MigrateMlEngineModelVersionConfig_
	//	*MigrateResourceRequest_MigrateAutomlModelConfig_
	//	*MigrateResourceRequest_MigrateAutomlDatasetConfig_
	//	*MigrateResourceRequest_MigrateDataLabelingDatasetConfig_
	Request isMigrateResourceRequest_Request `protobuf_oneof:"request"`
}

func (x *MigrateResourceRequest) Reset() {
	*x = MigrateResourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MigrateResourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigrateResourceRequest) ProtoMessage() {}

func (x *MigrateResourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigrateResourceRequest.ProtoReflect.Descriptor instead.
func (*MigrateResourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_migration_service_proto_rawDescGZIP(), []int{3}
}

func (m *MigrateResourceRequest) GetRequest() isMigrateResourceRequest_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (x *MigrateResourceRequest) GetMigrateMlEngineModelVersionConfig() *MigrateResourceRequest_MigrateMlEngineModelVersionConfig {
	if x, ok := x.GetRequest().(*MigrateResourceRequest_MigrateMlEngineModelVersionConfig_); ok {
		return x.MigrateMlEngineModelVersionConfig
	}
	return nil
}

func (x *MigrateResourceRequest) GetMigrateAutomlModelConfig() *MigrateResourceRequest_MigrateAutomlModelConfig {
	if x, ok := x.GetRequest().(*MigrateResourceRequest_MigrateAutomlModelConfig_); ok {
		return x.MigrateAutomlModelConfig
	}
	return nil
}

func (x *MigrateResourceRequest) GetMigrateAutomlDatasetConfig() *MigrateResourceRequest_MigrateAutomlDatasetConfig {
	if x, ok := x.GetRequest().(*MigrateResourceRequest_MigrateAutomlDatasetConfig_); ok {
		return x.MigrateAutomlDatasetConfig
	}
	return nil
}

func (x *MigrateResourceRequest) GetMigrateDataLabelingDatasetConfig() *MigrateResourceRequest_MigrateDataLabelingDatasetConfig {
	if x, ok := x.GetRequest().(*MigrateResourceRequest_MigrateDataLabelingDatasetConfig_); ok {
		return x.MigrateDataLabelingDatasetConfig
	}
	return nil
}

type isMigrateResourceRequest_Request interface {
	isMigrateResourceRequest_Request()
}

type MigrateResourceRequest_MigrateMlEngineModelVersionConfig_ struct {
	// Config for migrating Version in ml.googleapis.com to Vertex AI's Model.
	MigrateMlEngineModelVersionConfig *MigrateResourceRequest_MigrateMlEngineModelVersionConfig `protobuf:"bytes,1,opt,name=migrate_ml_engine_model_version_config,json=migrateMlEngineModelVersionConfig,proto3,oneof"`
}

type MigrateResourceRequest_MigrateAutomlModelConfig_ struct {
	// Config for migrating Model in automl.googleapis.com to Vertex AI's
	// Model.
	MigrateAutomlModelConfig *MigrateResourceRequest_MigrateAutomlModelConfig `protobuf:"bytes,2,opt,name=migrate_automl_model_config,json=migrateAutomlModelConfig,proto3,oneof"`
}

type MigrateResourceRequest_MigrateAutomlDatasetConfig_ struct {
	// Config for migrating Dataset in automl.googleapis.com to Vertex AI's
	// Dataset.
	MigrateAutomlDatasetConfig *MigrateResourceRequest_MigrateAutomlDatasetConfig `protobuf:"bytes,3,opt,name=migrate_automl_dataset_config,json=migrateAutomlDatasetConfig,proto3,oneof"`
}

type MigrateResourceRequest_MigrateDataLabelingDatasetConfig_ struct {
	// Config for migrating Dataset in datalabeling.googleapis.com to
	// Vertex AI's Dataset.
	MigrateDataLabelingDatasetConfig *MigrateResourceRequest_MigrateDataLabelingDatasetConfig `protobuf:"bytes,4,opt,name=migrate_data_labeling_dataset_config,json=migrateDataLabelingDatasetConfig,proto3,oneof"`
}

func (*MigrateResourceRequest_MigrateMlEngineModelVersionConfig_) isMigrateResourceRequest_Request() {
}

func (*MigrateResourceRequest_MigrateAutomlModelConfig_) isMigrateResourceRequest_Request() {}

func (*MigrateResourceRequest_MigrateAutomlDatasetConfig_) isMigrateResourceRequest_Request() {}

func (*MigrateResourceRequest_MigrateDataLabelingDatasetConfig_) isMigrateResourceRequest_Request() {}

// Response message for [MigrationService.BatchMigrateResources][google.cloud.aiplatform.v1beta1.MigrationService.BatchMigrateResources].
type BatchMigrateResourcesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Successfully migrated resources.
	MigrateResourceResponses []*MigrateResourceResponse `protobuf:"bytes,1,rep,name=migrate_resource_responses,json=migrateResourceResponses,proto3" json:"migrate_resource_responses,omitempty"`
}

func (x *BatchMigrateResourcesResponse) Reset() {
	*x = BatchMigrateResourcesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchMigrateResourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchMigrateResourcesResponse) ProtoMessage() {}

func (x *BatchMigrateResourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchMigrateResourcesResponse.ProtoReflect.Descriptor instead.
func (*BatchMigrateResourcesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_migration_service_proto_rawDescGZIP(), []int{4}
}

func (x *BatchMigrateResourcesResponse) GetMigrateResourceResponses() []*MigrateResourceResponse {
	if x != nil {
		return x.MigrateResourceResponses
	}
	return nil
}

// Describes a successfully migrated resource.
type MigrateResourceResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// After migration, the resource name in Vertex AI.
	//
	// Types that are assignable to MigratedResource:
	//
	//	*MigrateResourceResponse_Dataset
	//	*MigrateResourceResponse_Model
	MigratedResource isMigrateResourceResponse_MigratedResource `protobuf_oneof:"migrated_resource"`
	// Before migration, the identifier in ml.googleapis.com,
	// automl.googleapis.com or datalabeling.googleapis.com.
	MigratableResource *MigratableResource `protobuf:"bytes,3,opt,name=migratable_resource,json=migratableResource,proto3" json:"migratable_resource,omitempty"`
}

func (x *MigrateResourceResponse) Reset() {
	*x = MigrateResourceResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MigrateResourceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigrateResourceResponse) ProtoMessage() {}

func (x *MigrateResourceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigrateResourceResponse.ProtoReflect.Descriptor instead.
func (*MigrateResourceResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_migration_service_proto_rawDescGZIP(), []int{5}
}

func (m *MigrateResourceResponse) GetMigratedResource() isMigrateResourceResponse_MigratedResource {
	if m != nil {
		return m.MigratedResource
	}
	return nil
}

func (x *MigrateResourceResponse) GetDataset() string {
	if x, ok := x.GetMigratedResource().(*MigrateResourceResponse_Dataset); ok {
		return x.Dataset
	}
	return ""
}

func (x *MigrateResourceResponse) GetModel() string {
	if x, ok := x.GetMigratedResource().(*MigrateResourceResponse_Model); ok {
		return x.Model
	}
	return ""
}

func (x *MigrateResourceResponse) GetMigratableResource() *MigratableResource {
	if x != nil {
		return x.MigratableResource
	}
	return nil
}

type isMigrateResourceResponse_MigratedResource interface {
	isMigrateResourceResponse_MigratedResource()
}

type MigrateResourceResponse_Dataset struct {
	// Migrated Dataset's resource name.
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3,oneof"`
}

type MigrateResourceResponse_Model struct {
	// Migrated Model's resource name.
	Model string `protobuf:"bytes,2,opt,name=model,proto3,oneof"`
}

func (*MigrateResourceResponse_Dataset) isMigrateResourceResponse_MigratedResource() {}

func (*MigrateResourceResponse_Model) isMigrateResourceResponse_MigratedResource() {}

// Runtime operation information for [MigrationService.BatchMigrateResources][google.cloud.aiplatform.v1beta1.MigrationService.BatchMigrateResources].
type BatchMigrateResourcesOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The common part of the operation metadata.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
	// Partial results that reflect the latest migration operation progress.
	PartialResults []*BatchMigrateResourcesOperationMetadata_PartialResult `protobuf:"bytes,2,rep,name=partial_results,json=partialResults,proto3" json:"partial_results,omitempty"`
}

func (x *BatchMigrateResourcesOperationMetadata) Reset() {
	*x = BatchMigrateResourcesOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchMigrateResourcesOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchMigrateResourcesOperationMetadata) ProtoMessage() {}

func (x *BatchMigrateResourcesOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchMigrateResourcesOperationMetadata.ProtoReflect.Descriptor instead.
func (*BatchMigrateResourcesOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_migration_service_proto_rawDescGZIP(), []int{6}
}

func (x *BatchMigrateResourcesOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

func (x *BatchMigrateResourcesOperationMetadata) GetPartialResults() []*BatchMigrateResourcesOperationMetadata_PartialResult {
	if x != nil {
		return x.PartialResults
	}
	return nil
}

// Config for migrating version in ml.googleapis.com to Vertex AI's Model.
type MigrateResourceRequest_MigrateMlEngineModelVersionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ml.googleapis.com endpoint that this model version should be migrated
	// from.
	// Example values:
	//
	// * ml.googleapis.com
	//
	// * us-centrall-ml.googleapis.com
	//
	// * europe-west4-ml.googleapis.com
	//
	// * asia-east1-ml.googleapis.com
	Endpoint string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// Required. Full resource name of ml engine model version.
	// Format: `projects/{project}/models/{model}/versions/{version}`.
	ModelVersion string `protobuf:"bytes,2,opt,name=model_version,json=modelVersion,proto3" json:"model_version,omitempty"`
	// Required. Display name of the model in Vertex AI.
	// System will pick a display name if unspecified.
	ModelDisplayName string `protobuf:"bytes,3,opt,name=model_display_name,json=modelDisplayName,proto3" json:"model_display_name,omitempty"`
}

func (x *MigrateResourceRequest_MigrateMlEngineModelVersionConfig) Reset() {
	*x = MigrateResourceRequest_MigrateMlEngineModelVersionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MigrateResourceRequest_MigrateMlEngineModelVersionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigrateResourceRequest_MigrateMlEngineModelVersionConfig) ProtoMessage() {}

func (x *MigrateResourceRequest_MigrateMlEngineModelVersionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigrateResourceRequest_MigrateMlEngineModelVersionConfig.ProtoReflect.Descriptor instead.
func (*MigrateResourceRequest_MigrateMlEngineModelVersionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_migration_service_proto_rawDescGZIP(), []int{3, 0}
}

func (x *MigrateResourceRequest_MigrateMlEngineModelVersionConfig) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *MigrateResourceRequest_MigrateMlEngineModelVersionConfig) GetModelVersion() string {
	if x != nil {
		return x.ModelVersion
	}
	return ""
}

func (x *MigrateResourceRequest_MigrateMlEngineModelVersionConfig) GetModelDisplayName() string {
	if x != nil {
		return x.ModelDisplayName
	}
	return ""
}

// Config for migrating Model in automl.googleapis.com to Vertex AI's Model.
type MigrateResourceRequest_MigrateAutomlModelConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full resource name of automl Model.
	// Format:
	// `projects/{project}/locations/{location}/models/{model}`.
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Optional. Display name of the model in Vertex AI.
	// System will pick a display name if unspecified.
	ModelDisplayName string `protobuf:"bytes,2,opt,name=model_display_name,json=modelDisplayName,proto3" json:"model_display_name,omitempty"`
}

func (x *MigrateResourceRequest_MigrateAutomlModelConfig) Reset() {
	*x = MigrateResourceRequest_MigrateAutomlModelConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MigrateResourceRequest_MigrateAutomlModelConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigrateResourceRequest_MigrateAutomlModelConfig) ProtoMessage() {}

func (x *MigrateResourceRequest_MigrateAutomlModelConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigrateResourceRequest_MigrateAutomlModelConfig.ProtoReflect.Descriptor instead.
func (*MigrateResourceRequest_MigrateAutomlModelConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_migration_service_proto_rawDescGZIP(), []int{3, 1}
}

func (x *MigrateResourceRequest_MigrateAutomlModelConfig) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *MigrateResourceRequest_MigrateAutomlModelConfig) GetModelDisplayName() string {
	if x != nil {
		return x.ModelDisplayName
	}
	return ""
}

// Config for migrating Dataset in automl.googleapis.com to Vertex AI's
// Dataset.
type MigrateResourceRequest_MigrateAutomlDatasetConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full resource name of automl Dataset.
	// Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}`.
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Required. Display name of the Dataset in Vertex AI.
	// System will pick a display name if unspecified.
	DatasetDisplayName string `protobuf:"bytes,2,opt,name=dataset_display_name,json=datasetDisplayName,proto3" json:"dataset_display_name,omitempty"`
}

func (x *MigrateResourceRequest_MigrateAutomlDatasetConfig) Reset() {
	*x = MigrateResourceRequest_MigrateAutomlDatasetConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MigrateResourceRequest_MigrateAutomlDatasetConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigrateResourceRequest_MigrateAutomlDatasetConfig) ProtoMessage() {}

func (x *MigrateResourceRequest_MigrateAutomlDatasetConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigrateResourceRequest_MigrateAutomlDatasetConfig.ProtoReflect.Descriptor instead.
func (*MigrateResourceRequest_MigrateAutomlDatasetConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_migration_service_proto_rawDescGZIP(), []int{3, 2}
}

func (x *MigrateResourceRequest_MigrateAutomlDatasetConfig) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

func (x *MigrateResourceRequest_MigrateAutomlDatasetConfig) GetDatasetDisplayName() string {
	if x != nil {
		return x.DatasetDisplayName
	}
	return ""
}

// Config for migrating Dataset in datalabeling.googleapis.com to Vertex
// AI's Dataset.
type MigrateResourceRequest_MigrateDataLabelingDatasetConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full resource name of data labeling Dataset.
	// Format:
	// `projects/{project}/datasets/{dataset}`.
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Optional. Display name of the Dataset in Vertex AI.
	// System will pick a display name if unspecified.
	DatasetDisplayName string `protobuf:"bytes,2,opt,name=dataset_display_name,json=datasetDisplayName,proto3" json:"dataset_display_name,omitempty"`
	// Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
	// Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
	// to the datalabeling Dataset.
	MigrateDataLabelingAnnotatedDatasetConfigs []*MigrateResourceRequest_MigrateDataLabelingDatasetConfig_MigrateDataLabelingAnnotatedDatasetConfig `protobuf:"bytes,3,rep,name=migrate_data_labeling_annotated_dataset_configs,json=migrateDataLabelingAnnotatedDatasetConfigs,proto3" json:"migrate_data_labeling_annotated_dataset_configs,omitempty"`
}

func (x *MigrateResourceRequest_MigrateDataLabelingDatasetConfig) Reset() {
	*x = MigrateResourceRequest_MigrateDataLabelingDatasetConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MigrateResourceRequest_MigrateDataLabelingDatasetConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigrateResourceRequest_MigrateDataLabelingDatasetConfig) ProtoMessage() {}

func (x *MigrateResourceRequest_MigrateDataLabelingDatasetConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigrateResourceRequest_MigrateDataLabelingDatasetConfig.ProtoReflect.Descriptor instead.
func (*MigrateResourceRequest_MigrateDataLabelingDatasetConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_migration_service_proto_rawDescGZIP(), []int{3, 3}
}

func (x *MigrateResourceRequest_MigrateDataLabelingDatasetConfig) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

func (x *MigrateResourceRequest_MigrateDataLabelingDatasetConfig) GetDatasetDisplayName() string {
	if x != nil {
		return x.DatasetDisplayName
	}
	return ""
}

func (x *MigrateResourceRequest_MigrateDataLabelingDatasetConfig) GetMigrateDataLabelingAnnotatedDatasetConfigs() []*MigrateResourceRequest_MigrateDataLabelingDatasetConfig_MigrateDataLabelingAnnotatedDatasetConfig {
	if x != nil {
		return x.MigrateDataLabelingAnnotatedDatasetConfigs
	}
	return nil
}

// Config for migrating AnnotatedDataset in datalabeling.googleapis.com to
// Vertex AI's SavedQuery.
type MigrateResourceRequest_MigrateDataLabelingDatasetConfig_MigrateDataLabelingAnnotatedDatasetConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full resource name of data labeling AnnotatedDataset.
	// Format:
	// `projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_dataset}`.
	AnnotatedDataset string `protobuf:"bytes,1,opt,name=annotated_dataset,json=annotatedDataset,proto3" json:"annotated_dataset,omitempty"`
}

func (x *MigrateResourceRequest_MigrateDataLabelingDatasetConfig_MigrateDataLabelingAnnotatedDatasetConfig) Reset() {
	*x = MigrateResourceRequest_MigrateDataLabelingDatasetConfig_MigrateDataLabelingAnnotatedDatasetConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MigrateResourceRequest_MigrateDataLabelingDatasetConfig_MigrateDataLabelingAnnotatedDatasetConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigrateResourceRequest_MigrateDataLabelingDatasetConfig_MigrateDataLabelingAnnotatedDatasetConfig) ProtoMessage() {
}

func (x *MigrateResourceRequest_MigrateDataLabelingDatasetConfig_MigrateDataLabelingAnnotatedDatasetConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigrateResourceRequest_MigrateDataLabelingDatasetConfig_MigrateDataLabelingAnnotatedDatasetConfig.ProtoReflect.Descriptor instead.
func (*MigrateResourceRequest_MigrateDataLabelingDatasetConfig_MigrateDataLabelingAnnotatedDatasetConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_migration_service_proto_rawDescGZIP(), []int{3, 3, 0}
}

func (x *MigrateResourceRequest_MigrateDataLabelingDatasetConfig_MigrateDataLabelingAnnotatedDatasetConfig) GetAnnotatedDataset() string {
	if x != nil {
		return x.AnnotatedDataset
	}
	return ""
}

// Represents a partial result in batch migration operation for one
// [MigrateResourceRequest][google.cloud.aiplatform.v1beta1.MigrateResourceRequest].
type BatchMigrateResourcesOperationMetadata_PartialResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If the resource's migration is ongoing, none of the result will be set.
	// If the resource's migration is finished, either error or one of the
	// migrated resource name will be filled.
	//
	// Types that are assignable to Result:
	//
	//	*BatchMigrateResourcesOperationMetadata_PartialResult_Error
	//	*BatchMigrateResourcesOperationMetadata_PartialResult_Model
	//	*BatchMigrateResourcesOperationMetadata_PartialResult_Dataset
	Result isBatchMigrateResourcesOperationMetadata_PartialResult_Result `protobuf_oneof:"result"`
	// It's the same as the value in
	// [MigrateResourceRequest.migrate_resource_requests][].
	Request *MigrateResourceRequest `protobuf:"bytes,1,opt,name=request,proto3" json:"request,omitempty"`
}

func (x *BatchMigrateResourcesOperationMetadata_PartialResult) Reset() {
	*x = BatchMigrateResourcesOperationMetadata_PartialResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchMigrateResourcesOperationMetadata_PartialResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchMigrateResourcesOperationMetadata_PartialResult) ProtoMessage() {}

func (x *BatchMigrateResourcesOperationMetadata_PartialResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchMigrateResourcesOperationMetadata_PartialResult.ProtoReflect.Descriptor instead.
func (*BatchMigrateResourcesOperationMetadata_PartialResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_migration_service_proto_rawDescGZIP(), []int{6, 0}
}

func (m *BatchMigrateResourcesOperationMetadata_PartialResult) GetResult() isBatchMigrateResourcesOperationMetadata_PartialResult_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *BatchMigrateResourcesOperationMetadata_PartialResult) GetError() *status.Status {
	if x, ok := x.GetResult().(*BatchMigrateResourcesOperationMetadata_PartialResult_Error); ok {
		return x.Error
	}
	return nil
}

func (x *BatchMigrateResourcesOperationMetadata_PartialResult) GetModel() string {
	if x, ok := x.GetResult().(*BatchMigrateResourcesOperationMetadata_PartialResult_Model); ok {
		return x.Model
	}
	return ""
}

func (x *BatchMigrateResourcesOperationMetadata_PartialResult) GetDataset() string {
	if x, ok := x.GetResult().(*BatchMigrateResourcesOperationMetadata_PartialResult_Dataset); ok {
		return x.Dataset
	}
	return ""
}

func (x *BatchMigrateResourcesOperationMetadata_PartialResult) GetRequest() *MigrateResourceRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

type isBatchMigrateResourcesOperationMetadata_PartialResult_Result interface {
	isBatchMigrateResourcesOperationMetadata_PartialResult_Result()
}

type BatchMigrateResourcesOperationMetadata_PartialResult_Error struct {
	// The error result of the migration request in case of failure.
	Error *status.Status `protobuf:"bytes,2,opt,name=error,proto3,oneof"`
}

type BatchMigrateResourcesOperationMetadata_PartialResult_Model struct {
	// Migrated model resource name.
	Model string `protobuf:"bytes,3,opt,name=model,proto3,oneof"`
}

type BatchMigrateResourcesOperationMetadata_PartialResult_Dataset struct {
	// Migrated dataset resource name.
	Dataset string `protobuf:"bytes,4,opt,name=dataset,proto3,oneof"`
}

func (*BatchMigrateResourcesOperationMetadata_PartialResult_Error) isBatchMigrateResourcesOperationMetadata_PartialResult_Result() {
}

func (*BatchMigrateResourcesOperationMetadata_PartialResult_Model) isBatchMigrateResourcesOperationMetadata_PartialResult_Result() {
}

func (*BatchMigrateResourcesOperationMetadata_PartialResult_Dataset) isBatchMigrateResourcesOperationMetadata_PartialResult_Result() {
}

var File_google_cloud_aiplatform_v1beta1_migration_service_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_migration_service_proto_rawDesc = []byte{
	0x0a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x39, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb9, 0x01, 0x0a, 0x20, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x22, 0xb3, 0x01, 0x0a, 0x21, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x66, 0x0a, 0x14, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x13, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xdb, 0x01, 0x0a, 0x1c, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x78, 0x0a,
	0x19, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x17,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0xb7, 0x0d, 0x0a, 0x16, 0x4d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0xae, 0x01, 0x0a, 0x26, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x6c, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x59, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x65, 0x4d, 0x6c, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00,
	0x52, 0x21, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x4d, 0x6c, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x91, 0x01, 0x0a, 0x1b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x5f,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x6c,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x18, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x97, 0x01, 0x0a, 0x1d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65,
	0x41, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x1a, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x41, 0x75,
	0x74, 0x6f, 0x6d, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0xaa, 0x01, 0x0a, 0x24, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x58, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x20, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e,
	0x67, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0xbf,
	0x01, 0x0a, 0x21, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x4d, 0x6c, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x1f, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x46, 0x0a, 0x0d, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x21, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x1b, 0x0a, 0x19, 0x6d, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x0c, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x0a,
	0x12, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x1a, 0x88, 0x01, 0x0a, 0x18, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x6f,
	0x6d, 0x6c, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x39, 0x0a,
	0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x31, 0x0a, 0x12, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x94, 0x01, 0x0a, 0x1a,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3f, 0x0a, 0x07, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x35, 0x0a, 0x14, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x1a, 0xa1, 0x04, 0x0a, 0x20, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x45, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25,
	0x0a, 0x23, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x35,
	0x0a, 0x14, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x12, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0xed, 0x01, 0x0a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x5f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x82, 0x01, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x2a, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x1a, 0x8e, 0x01, 0x0a, 0x29, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x61, 0x0a, 0x11, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x52, 0x10, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x44,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x42, 0x09, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x22, 0x97, 0x01, 0x0a, 0x1d, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x76, 0x0a, 0x1a, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x52, 0x18, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x22, 0x96, 0x02, 0x0a, 0x17,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x48, 0x00, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x3c, 0x0a, 0x05, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xfa, 0x41, 0x21, 0x0a,
	0x1f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x48, 0x00, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x64, 0x0a, 0x13, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x12, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42,
	0x13, 0x0a, 0x11, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x22, 0xab, 0x04, 0x0a, 0x26, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x64, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x7e, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x55,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x1a, 0x9a, 0x02, 0x0a, 0x0d, 0x50, 0x61, 0x72, 0x74, 0x69, 0x61,
	0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x2a, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x48, 0x00, 0x52, 0x05, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x12, 0x3c, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x24, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x48, 0x00, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x12, 0x42, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x48, 0x00, 0x52, 0x07, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x51, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52,
	0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x32, 0x9b, 0x05, 0x0a, 0x10, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xfb, 0x01, 0x0a, 0x19, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x57, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x48, 0x22, 0x43, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xb9, 0x02, 0x0a, 0x15, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc1, 0x01,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x22, 0x49, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x20, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0xca, 0x41, 0x47, 0x0a, 0x1d, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x26, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2,
	0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x42, 0xf2, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x15, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x49, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0xaa, 0x02, 0x1f, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02,
	0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49,
	0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_migration_service_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_migration_service_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_migration_service_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_migration_service_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_migration_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_migration_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_migration_service_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_migration_service_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_cloud_aiplatform_v1beta1_migration_service_proto_goTypes = []interface{}{
	(*SearchMigratableResourcesRequest)(nil),                                                                  // 0: google.cloud.aiplatform.v1beta1.SearchMigratableResourcesRequest
	(*SearchMigratableResourcesResponse)(nil),                                                                 // 1: google.cloud.aiplatform.v1beta1.SearchMigratableResourcesResponse
	(*BatchMigrateResourcesRequest)(nil),                                                                      // 2: google.cloud.aiplatform.v1beta1.BatchMigrateResourcesRequest
	(*MigrateResourceRequest)(nil),                                                                            // 3: google.cloud.aiplatform.v1beta1.MigrateResourceRequest
	(*BatchMigrateResourcesResponse)(nil),                                                                     // 4: google.cloud.aiplatform.v1beta1.BatchMigrateResourcesResponse
	(*MigrateResourceResponse)(nil),                                                                           // 5: google.cloud.aiplatform.v1beta1.MigrateResourceResponse
	(*BatchMigrateResourcesOperationMetadata)(nil),                                                            // 6: google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
	(*MigrateResourceRequest_MigrateMlEngineModelVersionConfig)(nil),                                          // 7: google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig
	(*MigrateResourceRequest_MigrateAutomlModelConfig)(nil),                                                   // 8: google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
	(*MigrateResourceRequest_MigrateAutomlDatasetConfig)(nil),                                                 // 9: google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
	(*MigrateResourceRequest_MigrateDataLabelingDatasetConfig)(nil),                                           // 10: google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig
	(*MigrateResourceRequest_MigrateDataLabelingDatasetConfig_MigrateDataLabelingAnnotatedDatasetConfig)(nil), // 11: google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
	(*BatchMigrateResourcesOperationMetadata_PartialResult)(nil),                                              // 12: google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult
	(*MigratableResource)(nil),                                                                                // 13: google.cloud.aiplatform.v1beta1.MigratableResource
	(*GenericOperationMetadata)(nil),                                                                          // 14: google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	(*status.Status)(nil),                                                                                     // 15: google.rpc.Status
	(*longrunning.Operation)(nil),                                                                             // 16: google.longrunning.Operation
}
var file_google_cloud_aiplatform_v1beta1_migration_service_proto_depIdxs = []int32{
	13, // 0: google.cloud.aiplatform.v1beta1.SearchMigratableResourcesResponse.migratable_resources:type_name -> google.cloud.aiplatform.v1beta1.MigratableResource
	3,  // 1: google.cloud.aiplatform.v1beta1.BatchMigrateResourcesRequest.migrate_resource_requests:type_name -> google.cloud.aiplatform.v1beta1.MigrateResourceRequest
	7,  // 2: google.cloud.aiplatform.v1beta1.MigrateResourceRequest.migrate_ml_engine_model_version_config:type_name -> google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig
	8,  // 3: google.cloud.aiplatform.v1beta1.MigrateResourceRequest.migrate_automl_model_config:type_name -> google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
	9,  // 4: google.cloud.aiplatform.v1beta1.MigrateResourceRequest.migrate_automl_dataset_config:type_name -> google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
	10, // 5: google.cloud.aiplatform.v1beta1.MigrateResourceRequest.migrate_data_labeling_dataset_config:type_name -> google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig
	5,  // 6: google.cloud.aiplatform.v1beta1.BatchMigrateResourcesResponse.migrate_resource_responses:type_name -> google.cloud.aiplatform.v1beta1.MigrateResourceResponse
	13, // 7: google.cloud.aiplatform.v1beta1.MigrateResourceResponse.migratable_resource:type_name -> google.cloud.aiplatform.v1beta1.MigratableResource
	14, // 8: google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	12, // 9: google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.partial_results:type_name -> google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult
	11, // 10: google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.migrate_data_labeling_annotated_dataset_configs:type_name -> google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
	15, // 11: google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult.error:type_name -> google.rpc.Status
	3,  // 12: google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult.request:type_name -> google.cloud.aiplatform.v1beta1.MigrateResourceRequest
	0,  // 13: google.cloud.aiplatform.v1beta1.MigrationService.SearchMigratableResources:input_type -> google.cloud.aiplatform.v1beta1.SearchMigratableResourcesRequest
	2,  // 14: google.cloud.aiplatform.v1beta1.MigrationService.BatchMigrateResources:input_type -> google.cloud.aiplatform.v1beta1.BatchMigrateResourcesRequest
	1,  // 15: google.cloud.aiplatform.v1beta1.MigrationService.SearchMigratableResources:output_type -> google.cloud.aiplatform.v1beta1.SearchMigratableResourcesResponse
	16, // 16: google.cloud.aiplatform.v1beta1.MigrationService.BatchMigrateResources:output_type -> google.longrunning.Operation
	15, // [15:17] is the sub-list for method output_type
	13, // [13:15] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_migration_service_proto_init() }
func file_google_cloud_aiplatform_v1beta1_migration_service_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_migration_service_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_migratable_resource_proto_init()
	file_google_cloud_aiplatform_v1beta1_operation_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchMigratableResourcesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchMigratableResourcesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchMigrateResourcesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MigrateResourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchMigrateResourcesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MigrateResourceResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchMigrateResourcesOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MigrateResourceRequest_MigrateMlEngineModelVersionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MigrateResourceRequest_MigrateAutomlModelConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MigrateResourceRequest_MigrateAutomlDatasetConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MigrateResourceRequest_MigrateDataLabelingDatasetConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MigrateResourceRequest_MigrateDataLabelingDatasetConfig_MigrateDataLabelingAnnotatedDatasetConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchMigrateResourcesOperationMetadata_PartialResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*MigrateResourceRequest_MigrateMlEngineModelVersionConfig_)(nil),
		(*MigrateResourceRequest_MigrateAutomlModelConfig_)(nil),
		(*MigrateResourceRequest_MigrateAutomlDatasetConfig_)(nil),
		(*MigrateResourceRequest_MigrateDataLabelingDatasetConfig_)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*MigrateResourceResponse_Dataset)(nil),
		(*MigrateResourceResponse_Model)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*BatchMigrateResourcesOperationMetadata_PartialResult_Error)(nil),
		(*BatchMigrateResourcesOperationMetadata_PartialResult_Model)(nil),
		(*BatchMigrateResourcesOperationMetadata_PartialResult_Dataset)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_migration_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_migration_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_migration_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_migration_service_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_migration_service_proto = out.File
	file_google_cloud_aiplatform_v1beta1_migration_service_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_migration_service_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_migration_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// MigrationServiceClient is the client API for MigrationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type MigrationServiceClient interface {
	// Searches all of the resources in automl.googleapis.com,
	// datalabeling.googleapis.com and ml.googleapis.com that can be migrated to
	// Vertex AI's given location.
	SearchMigratableResources(ctx context.Context, in *SearchMigratableResourcesRequest, opts ...grpc.CallOption) (*SearchMigratableResourcesResponse, error)
	// Batch migrates resources from ml.googleapis.com, automl.googleapis.com,
	// and datalabeling.googleapis.com to Vertex AI.
	BatchMigrateResources(ctx context.Context, in *BatchMigrateResourcesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type migrationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewMigrationServiceClient(cc grpc.ClientConnInterface) MigrationServiceClient {
	return &migrationServiceClient{cc}
}

func (c *migrationServiceClient) SearchMigratableResources(ctx context.Context, in *SearchMigratableResourcesRequest, opts ...grpc.CallOption) (*SearchMigratableResourcesResponse, error) {
	out := new(SearchMigratableResourcesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MigrationService/SearchMigratableResources", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationServiceClient) BatchMigrateResources(ctx context.Context, in *BatchMigrateResourcesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MigrationService/BatchMigrateResources", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MigrationServiceServer is the server API for MigrationService service.
type MigrationServiceServer interface {
	// Searches all of the resources in automl.googleapis.com,
	// datalabeling.googleapis.com and ml.googleapis.com that can be migrated to
	// Vertex AI's given location.
	SearchMigratableResources(context.Context, *SearchMigratableResourcesRequest) (*SearchMigratableResourcesResponse, error)
	// Batch migrates resources from ml.googleapis.com, automl.googleapis.com,
	// and datalabeling.googleapis.com to Vertex AI.
	BatchMigrateResources(context.Context, *BatchMigrateResourcesRequest) (*longrunning.Operation, error)
}

// UnimplementedMigrationServiceServer can be embedded to have forward compatible implementations.
type UnimplementedMigrationServiceServer struct {
}

func (*UnimplementedMigrationServiceServer) SearchMigratableResources(context.Context, *SearchMigratableResourcesRequest) (*SearchMigratableResourcesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SearchMigratableResources not implemented")
}
func (*UnimplementedMigrationServiceServer) BatchMigrateResources(context.Context, *BatchMigrateResourcesRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchMigrateResources not implemented")
}

func RegisterMigrationServiceServer(s *grpc.Server, srv MigrationServiceServer) {
	s.RegisterService(&_MigrationService_serviceDesc, srv)
}

func _MigrationService_SearchMigratableResources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchMigratableResourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationServiceServer).SearchMigratableResources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MigrationService/SearchMigratableResources",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationServiceServer).SearchMigratableResources(ctx, req.(*SearchMigratableResourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationService_BatchMigrateResources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchMigrateResourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationServiceServer).BatchMigrateResources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MigrationService/BatchMigrateResources",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationServiceServer).BatchMigrateResources(ctx, req.(*BatchMigrateResourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _MigrationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.MigrationService",
	HandlerType: (*MigrationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SearchMigratableResources",
			Handler:    _MigrationService_SearchMigratableResources_Handler,
		},
		{
			MethodName: "BatchMigrateResources",
			Handler:    _MigrationService_BatchMigrateResources_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1beta1/migration_service.proto",
}
