// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package aiplatform_test

import (
	"context"

	aiplatform "cloud.google.com/go/aiplatform/apiv1"
	"google.golang.org/api/iterator"
	aiplatformpb "google.golang.org/genproto/googleapis/cloud/aiplatform/v1"
)

func ExampleNewTensorboardClient() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	// TODO: Use client.
	_ = c
}

func ExampleTensorboardClient_CreateTensorboard() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &aiplatformpb.CreateTensorboardRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/aiplatform/v1#CreateTensorboardRequest.
	}
	op, err := c.CreateTensorboard(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}

	resp, err := op.Wait(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleTensorboardClient_GetTensorboard() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &aiplatformpb.GetTensorboardRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/aiplatform/v1#GetTensorboardRequest.
	}
	resp, err := c.GetTensorboard(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleTensorboardClient_UpdateTensorboard() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &aiplatformpb.UpdateTensorboardRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/aiplatform/v1#UpdateTensorboardRequest.
	}
	op, err := c.UpdateTensorboard(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}

	resp, err := op.Wait(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleTensorboardClient_ListTensorboards() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &aiplatformpb.ListTensorboardsRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/aiplatform/v1#ListTensorboardsRequest.
	}
	it := c.ListTensorboards(ctx, req)
	for {
		resp, err := it.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			// TODO: Handle error.
		}
		// TODO: Use resp.
		_ = resp
	}
}

func ExampleTensorboardClient_DeleteTensorboard() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &aiplatformpb.DeleteTensorboardRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/aiplatform/v1#DeleteTensorboardRequest.
	}
	op, err := c.DeleteTensorboard(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}

	err = op.Wait(ctx)
	if err != nil {
		// TODO: Handle error.
	}
}

func ExampleTensorboardClient_CreateTensorboardExperiment() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &aiplatformpb.CreateTensorboardExperimentRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/aiplatform/v1#CreateTensorboardExperimentRequest.
	}
	resp, err := c.CreateTensorboardExperiment(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleTensorboardClient_GetTensorboardExperiment() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &aiplatformpb.GetTensorboardExperimentRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/aiplatform/v1#GetTensorboardExperimentRequest.
	}
	resp, err := c.GetTensorboardExperiment(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleTensorboardClient_UpdateTensorboardExperiment() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &aiplatformpb.UpdateTensorboardExperimentRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/aiplatform/v1#UpdateTensorboardExperimentRequest.
	}
	resp, err := c.UpdateTensorboardExperiment(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleTensorboardClient_ListTensorboardExperiments() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &aiplatformpb.ListTensorboardExperimentsRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/aiplatform/v1#ListTensorboardExperimentsRequest.
	}
	it := c.ListTensorboardExperiments(ctx, req)
	for {
		resp, err := it.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			// TODO: Handle error.
		}
		// TODO: Use resp.
		_ = resp
	}
}

func ExampleTensorboardClient_DeleteTensorboardExperiment() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &aiplatformpb.DeleteTensorboardExperimentRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/aiplatform/v1#DeleteTensorboardExperimentRequest.
	}
	op, err := c.DeleteTensorboardExperiment(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}

	err = op.Wait(ctx)
	if err != nil {
		// TODO: Handle error.
	}
}

func ExampleTensorboardClient_CreateTensorboardRun() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &aiplatformpb.CreateTensorboardRunRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/aiplatform/v1#CreateTensorboardRunRequest.
	}
	resp, err := c.CreateTensorboardRun(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleTensorboardClient_BatchCreateTensorboardRuns() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &aiplatformpb.BatchCreateTensorboardRunsRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/aiplatform/v1#BatchCreateTensorboardRunsRequest.
	}
	resp, err := c.BatchCreateTensorboardRuns(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleTensorboardClient_GetTensorboardRun() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &aiplatformpb.GetTensorboardRunRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/aiplatform/v1#GetTensorboardRunRequest.
	}
	resp, err := c.GetTensorboardRun(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleTensorboardClient_UpdateTensorboardRun() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &aiplatformpb.UpdateTensorboardRunRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/aiplatform/v1#UpdateTensorboardRunRequest.
	}
	resp, err := c.UpdateTensorboardRun(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleTensorboardClient_ListTensorboardRuns() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &aiplatformpb.ListTensorboardRunsRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/aiplatform/v1#ListTensorboardRunsRequest.
	}
	it := c.ListTensorboardRuns(ctx, req)
	for {
		resp, err := it.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			// TODO: Handle error.
		}
		// TODO: Use resp.
		_ = resp
	}
}

func ExampleTensorboardClient_DeleteTensorboardRun() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &aiplatformpb.DeleteTensorboardRunRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/aiplatform/v1#DeleteTensorboardRunRequest.
	}
	op, err := c.DeleteTensorboardRun(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}

	err = op.Wait(ctx)
	if err != nil {
		// TODO: Handle error.
	}
}

func ExampleTensorboardClient_BatchCreateTensorboardTimeSeries() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &aiplatformpb.BatchCreateTensorboardTimeSeriesRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/aiplatform/v1#BatchCreateTensorboardTimeSeriesRequest.
	}
	resp, err := c.BatchCreateTensorboardTimeSeries(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleTensorboardClient_CreateTensorboardTimeSeries() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &aiplatformpb.CreateTensorboardTimeSeriesRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/aiplatform/v1#CreateTensorboardTimeSeriesRequest.
	}
	resp, err := c.CreateTensorboardTimeSeries(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleTensorboardClient_GetTensorboardTimeSeries() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &aiplatformpb.GetTensorboardTimeSeriesRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/aiplatform/v1#GetTensorboardTimeSeriesRequest.
	}
	resp, err := c.GetTensorboardTimeSeries(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleTensorboardClient_UpdateTensorboardTimeSeries() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &aiplatformpb.UpdateTensorboardTimeSeriesRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/aiplatform/v1#UpdateTensorboardTimeSeriesRequest.
	}
	resp, err := c.UpdateTensorboardTimeSeries(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleTensorboardClient_ListTensorboardTimeSeries() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &aiplatformpb.ListTensorboardTimeSeriesRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/aiplatform/v1#ListTensorboardTimeSeriesRequest.
	}
	it := c.ListTensorboardTimeSeries(ctx, req)
	for {
		resp, err := it.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			// TODO: Handle error.
		}
		// TODO: Use resp.
		_ = resp
	}
}

func ExampleTensorboardClient_DeleteTensorboardTimeSeries() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &aiplatformpb.DeleteTensorboardTimeSeriesRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/aiplatform/v1#DeleteTensorboardTimeSeriesRequest.
	}
	op, err := c.DeleteTensorboardTimeSeries(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}

	err = op.Wait(ctx)
	if err != nil {
		// TODO: Handle error.
	}
}

func ExampleTensorboardClient_BatchReadTensorboardTimeSeriesData() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &aiplatformpb.BatchReadTensorboardTimeSeriesDataRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/aiplatform/v1#BatchReadTensorboardTimeSeriesDataRequest.
	}
	resp, err := c.BatchReadTensorboardTimeSeriesData(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleTensorboardClient_ReadTensorboardTimeSeriesData() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &aiplatformpb.ReadTensorboardTimeSeriesDataRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/aiplatform/v1#ReadTensorboardTimeSeriesDataRequest.
	}
	resp, err := c.ReadTensorboardTimeSeriesData(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleTensorboardClient_WriteTensorboardExperimentData() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &aiplatformpb.WriteTensorboardExperimentDataRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/aiplatform/v1#WriteTensorboardExperimentDataRequest.
	}
	resp, err := c.WriteTensorboardExperimentData(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleTensorboardClient_WriteTensorboardRunData() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &aiplatformpb.WriteTensorboardRunDataRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/aiplatform/v1#WriteTensorboardRunDataRequest.
	}
	resp, err := c.WriteTensorboardRunData(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleTensorboardClient_ExportTensorboardTimeSeriesData() {
	ctx := context.Background()
	c, err := aiplatform.NewTensorboardClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &aiplatformpb.ExportTensorboardTimeSeriesDataRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/aiplatform/v1#ExportTensorboardTimeSeriesDataRequest.
	}
	it := c.ExportTensorboardTimeSeriesData(ctx, req)
	for {
		resp, err := it.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			// TODO: Handle error.
		}
		// TODO: Use resp.
		_ = resp
	}
}
