// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package stitcher

import (
	"context"
	"fmt"
	"math"
	"net/url"
	"time"

	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	stitcherpb "google.golang.org/genproto/googleapis/cloud/video/stitcher/v1"
	"google.golang.org/grpc"
	"google.golang.org/grpc/metadata"
	"google.golang.org/protobuf/proto"
)

var newVideoStitcherClientHook clientHook

// VideoStitcherCallOptions contains the retry settings for each method of VideoStitcherClient.
type VideoStitcherCallOptions struct {
	CreateCdnKey         []gax.CallOption
	ListCdnKeys          []gax.CallOption
	GetCdnKey            []gax.CallOption
	DeleteCdnKey         []gax.CallOption
	UpdateCdnKey         []gax.CallOption
	CreateVodSession     []gax.CallOption
	GetVodSession        []gax.CallOption
	ListVodStitchDetails []gax.CallOption
	GetVodStitchDetail   []gax.CallOption
	ListVodAdTagDetails  []gax.CallOption
	GetVodAdTagDetail    []gax.CallOption
	ListLiveAdTagDetails []gax.CallOption
	GetLiveAdTagDetail   []gax.CallOption
	CreateSlate          []gax.CallOption
	ListSlates           []gax.CallOption
	GetSlate             []gax.CallOption
	UpdateSlate          []gax.CallOption
	DeleteSlate          []gax.CallOption
	CreateLiveSession    []gax.CallOption
	GetLiveSession       []gax.CallOption
}

func defaultVideoStitcherGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("videostitcher.googleapis.com:443"),
		internaloption.WithDefaultMTLSEndpoint("videostitcher.mtls.googleapis.com:443"),
		internaloption.WithDefaultAudience("https://videostitcher.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultVideoStitcherCallOptions() *VideoStitcherCallOptions {
	return &VideoStitcherCallOptions{
		CreateCdnKey:         []gax.CallOption{},
		ListCdnKeys:          []gax.CallOption{},
		GetCdnKey:            []gax.CallOption{},
		DeleteCdnKey:         []gax.CallOption{},
		UpdateCdnKey:         []gax.CallOption{},
		CreateVodSession:     []gax.CallOption{},
		GetVodSession:        []gax.CallOption{},
		ListVodStitchDetails: []gax.CallOption{},
		GetVodStitchDetail:   []gax.CallOption{},
		ListVodAdTagDetails:  []gax.CallOption{},
		GetVodAdTagDetail:    []gax.CallOption{},
		ListLiveAdTagDetails: []gax.CallOption{},
		GetLiveAdTagDetail:   []gax.CallOption{},
		CreateSlate:          []gax.CallOption{},
		ListSlates:           []gax.CallOption{},
		GetSlate:             []gax.CallOption{},
		UpdateSlate:          []gax.CallOption{},
		DeleteSlate:          []gax.CallOption{},
		CreateLiveSession:    []gax.CallOption{},
		GetLiveSession:       []gax.CallOption{},
	}
}

// internalVideoStitcherClient is an interface that defines the methods available from Video Stitcher API.
type internalVideoStitcherClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	CreateCdnKey(context.Context, *stitcherpb.CreateCdnKeyRequest, ...gax.CallOption) (*stitcherpb.CdnKey, error)
	ListCdnKeys(context.Context, *stitcherpb.ListCdnKeysRequest, ...gax.CallOption) *CdnKeyIterator
	GetCdnKey(context.Context, *stitcherpb.GetCdnKeyRequest, ...gax.CallOption) (*stitcherpb.CdnKey, error)
	DeleteCdnKey(context.Context, *stitcherpb.DeleteCdnKeyRequest, ...gax.CallOption) error
	UpdateCdnKey(context.Context, *stitcherpb.UpdateCdnKeyRequest, ...gax.CallOption) (*stitcherpb.CdnKey, error)
	CreateVodSession(context.Context, *stitcherpb.CreateVodSessionRequest, ...gax.CallOption) (*stitcherpb.VodSession, error)
	GetVodSession(context.Context, *stitcherpb.GetVodSessionRequest, ...gax.CallOption) (*stitcherpb.VodSession, error)
	ListVodStitchDetails(context.Context, *stitcherpb.ListVodStitchDetailsRequest, ...gax.CallOption) *VodStitchDetailIterator
	GetVodStitchDetail(context.Context, *stitcherpb.GetVodStitchDetailRequest, ...gax.CallOption) (*stitcherpb.VodStitchDetail, error)
	ListVodAdTagDetails(context.Context, *stitcherpb.ListVodAdTagDetailsRequest, ...gax.CallOption) *VodAdTagDetailIterator
	GetVodAdTagDetail(context.Context, *stitcherpb.GetVodAdTagDetailRequest, ...gax.CallOption) (*stitcherpb.VodAdTagDetail, error)
	ListLiveAdTagDetails(context.Context, *stitcherpb.ListLiveAdTagDetailsRequest, ...gax.CallOption) *LiveAdTagDetailIterator
	GetLiveAdTagDetail(context.Context, *stitcherpb.GetLiveAdTagDetailRequest, ...gax.CallOption) (*stitcherpb.LiveAdTagDetail, error)
	CreateSlate(context.Context, *stitcherpb.CreateSlateRequest, ...gax.CallOption) (*stitcherpb.Slate, error)
	ListSlates(context.Context, *stitcherpb.ListSlatesRequest, ...gax.CallOption) *SlateIterator
	GetSlate(context.Context, *stitcherpb.GetSlateRequest, ...gax.CallOption) (*stitcherpb.Slate, error)
	UpdateSlate(context.Context, *stitcherpb.UpdateSlateRequest, ...gax.CallOption) (*stitcherpb.Slate, error)
	DeleteSlate(context.Context, *stitcherpb.DeleteSlateRequest, ...gax.CallOption) error
	CreateLiveSession(context.Context, *stitcherpb.CreateLiveSessionRequest, ...gax.CallOption) (*stitcherpb.LiveSession, error)
	GetLiveSession(context.Context, *stitcherpb.GetLiveSessionRequest, ...gax.CallOption) (*stitcherpb.LiveSession, error)
}

// VideoStitcherClient is a client for interacting with Video Stitcher API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Video-On-Demand content stitching API allows you to insert ads
// into (VoD) video on demand files. You will be able to render custom
// scrubber bars with highlighted ads, enforce ad policies, allow
// seamless playback and tracking on native players and monetize
// content with any standard VMAP compliant ad server.
type VideoStitcherClient struct {
	// The internal transport-dependent client.
	internalClient internalVideoStitcherClient

	// The call options for this service.
	CallOptions *VideoStitcherCallOptions
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *VideoStitcherClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *VideoStitcherClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated.
func (c *VideoStitcherClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// CreateCdnKey creates a new CDN key.
func (c *VideoStitcherClient) CreateCdnKey(ctx context.Context, req *stitcherpb.CreateCdnKeyRequest, opts ...gax.CallOption) (*stitcherpb.CdnKey, error) {
	return c.internalClient.CreateCdnKey(ctx, req, opts...)
}

// ListCdnKeys lists all CDN keys in the specified project and location.
func (c *VideoStitcherClient) ListCdnKeys(ctx context.Context, req *stitcherpb.ListCdnKeysRequest, opts ...gax.CallOption) *CdnKeyIterator {
	return c.internalClient.ListCdnKeys(ctx, req, opts...)
}

// GetCdnKey returns the specified CDN key.
func (c *VideoStitcherClient) GetCdnKey(ctx context.Context, req *stitcherpb.GetCdnKeyRequest, opts ...gax.CallOption) (*stitcherpb.CdnKey, error) {
	return c.internalClient.GetCdnKey(ctx, req, opts...)
}

// DeleteCdnKey deletes the specified CDN key.
func (c *VideoStitcherClient) DeleteCdnKey(ctx context.Context, req *stitcherpb.DeleteCdnKeyRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteCdnKey(ctx, req, opts...)
}

// UpdateCdnKey updates the specified CDN key. Only update fields specified
// in the call method body.
func (c *VideoStitcherClient) UpdateCdnKey(ctx context.Context, req *stitcherpb.UpdateCdnKeyRequest, opts ...gax.CallOption) (*stitcherpb.CdnKey, error) {
	return c.internalClient.UpdateCdnKey(ctx, req, opts...)
}

// CreateVodSession creates a client side playback VOD session and returns the full
// tracking and playback metadata of the session.
func (c *VideoStitcherClient) CreateVodSession(ctx context.Context, req *stitcherpb.CreateVodSessionRequest, opts ...gax.CallOption) (*stitcherpb.VodSession, error) {
	return c.internalClient.CreateVodSession(ctx, req, opts...)
}

// GetVodSession returns the full tracking, playback metadata, and relevant ad-ops
// logs for the specified VOD session.
func (c *VideoStitcherClient) GetVodSession(ctx context.Context, req *stitcherpb.GetVodSessionRequest, opts ...gax.CallOption) (*stitcherpb.VodSession, error) {
	return c.internalClient.GetVodSession(ctx, req, opts...)
}

// ListVodStitchDetails returns a list of detailed stitching information of the specified VOD
// session.
func (c *VideoStitcherClient) ListVodStitchDetails(ctx context.Context, req *stitcherpb.ListVodStitchDetailsRequest, opts ...gax.CallOption) *VodStitchDetailIterator {
	return c.internalClient.ListVodStitchDetails(ctx, req, opts...)
}

// GetVodStitchDetail returns the specified stitching information for the specified VOD session.
func (c *VideoStitcherClient) GetVodStitchDetail(ctx context.Context, req *stitcherpb.GetVodStitchDetailRequest, opts ...gax.CallOption) (*stitcherpb.VodStitchDetail, error) {
	return c.internalClient.GetVodStitchDetail(ctx, req, opts...)
}

// ListVodAdTagDetails return the list of ad tag details for the specified VOD session.
func (c *VideoStitcherClient) ListVodAdTagDetails(ctx context.Context, req *stitcherpb.ListVodAdTagDetailsRequest, opts ...gax.CallOption) *VodAdTagDetailIterator {
	return c.internalClient.ListVodAdTagDetails(ctx, req, opts...)
}

// GetVodAdTagDetail returns the specified ad tag detail for the specified VOD session.
func (c *VideoStitcherClient) GetVodAdTagDetail(ctx context.Context, req *stitcherpb.GetVodAdTagDetailRequest, opts ...gax.CallOption) (*stitcherpb.VodAdTagDetail, error) {
	return c.internalClient.GetVodAdTagDetail(ctx, req, opts...)
}

// ListLiveAdTagDetails return the list of ad tag details for the specified live session.
func (c *VideoStitcherClient) ListLiveAdTagDetails(ctx context.Context, req *stitcherpb.ListLiveAdTagDetailsRequest, opts ...gax.CallOption) *LiveAdTagDetailIterator {
	return c.internalClient.ListLiveAdTagDetails(ctx, req, opts...)
}

// GetLiveAdTagDetail returns the specified ad tag detail for the specified live session.
func (c *VideoStitcherClient) GetLiveAdTagDetail(ctx context.Context, req *stitcherpb.GetLiveAdTagDetailRequest, opts ...gax.CallOption) (*stitcherpb.LiveAdTagDetail, error) {
	return c.internalClient.GetLiveAdTagDetail(ctx, req, opts...)
}

// CreateSlate creates a slate.
func (c *VideoStitcherClient) CreateSlate(ctx context.Context, req *stitcherpb.CreateSlateRequest, opts ...gax.CallOption) (*stitcherpb.Slate, error) {
	return c.internalClient.CreateSlate(ctx, req, opts...)
}

// ListSlates lists all slates in the specified project and location.
func (c *VideoStitcherClient) ListSlates(ctx context.Context, req *stitcherpb.ListSlatesRequest, opts ...gax.CallOption) *SlateIterator {
	return c.internalClient.ListSlates(ctx, req, opts...)
}

// GetSlate returns the specified slate.
func (c *VideoStitcherClient) GetSlate(ctx context.Context, req *stitcherpb.GetSlateRequest, opts ...gax.CallOption) (*stitcherpb.Slate, error) {
	return c.internalClient.GetSlate(ctx, req, opts...)
}

// UpdateSlate updates the specified slate.
func (c *VideoStitcherClient) UpdateSlate(ctx context.Context, req *stitcherpb.UpdateSlateRequest, opts ...gax.CallOption) (*stitcherpb.Slate, error) {
	return c.internalClient.UpdateSlate(ctx, req, opts...)
}

// DeleteSlate deletes the specified slate.
func (c *VideoStitcherClient) DeleteSlate(ctx context.Context, req *stitcherpb.DeleteSlateRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteSlate(ctx, req, opts...)
}

// CreateLiveSession creates a new live session.
func (c *VideoStitcherClient) CreateLiveSession(ctx context.Context, req *stitcherpb.CreateLiveSessionRequest, opts ...gax.CallOption) (*stitcherpb.LiveSession, error) {
	return c.internalClient.CreateLiveSession(ctx, req, opts...)
}

// GetLiveSession returns the details for the specified live session.
func (c *VideoStitcherClient) GetLiveSession(ctx context.Context, req *stitcherpb.GetLiveSessionRequest, opts ...gax.CallOption) (*stitcherpb.LiveSession, error) {
	return c.internalClient.GetLiveSession(ctx, req, opts...)
}

// videoStitcherGRPCClient is a client for interacting with Video Stitcher API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type videoStitcherGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// flag to opt out of default deadlines via GOOGLE_API_GO_EXPERIMENTAL_DISABLE_DEFAULT_DEADLINE
	disableDeadlines bool

	// Points back to the CallOptions field of the containing VideoStitcherClient
	CallOptions **VideoStitcherCallOptions

	// The gRPC API client.
	videoStitcherClient stitcherpb.VideoStitcherServiceClient

	// The x-goog-* metadata to be sent with each request.
	xGoogMetadata metadata.MD
}

// NewVideoStitcherClient creates a new video stitcher service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Video-On-Demand content stitching API allows you to insert ads
// into (VoD) video on demand files. You will be able to render custom
// scrubber bars with highlighted ads, enforce ad policies, allow
// seamless playback and tracking on native players and monetize
// content with any standard VMAP compliant ad server.
func NewVideoStitcherClient(ctx context.Context, opts ...option.ClientOption) (*VideoStitcherClient, error) {
	clientOpts := defaultVideoStitcherGRPCClientOptions()
	if newVideoStitcherClientHook != nil {
		hookOpts, err := newVideoStitcherClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	disableDeadlines, err := checkDisableDeadlines()
	if err != nil {
		return nil, err
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := VideoStitcherClient{CallOptions: defaultVideoStitcherCallOptions()}

	c := &videoStitcherGRPCClient{
		connPool:            connPool,
		disableDeadlines:    disableDeadlines,
		videoStitcherClient: stitcherpb.NewVideoStitcherServiceClient(connPool),
		CallOptions:         &client.CallOptions,
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated.
func (c *videoStitcherGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *videoStitcherGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", versionGo()}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogMetadata = metadata.Pairs("x-goog-api-client", gax.XGoogHeader(kv...))
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *videoStitcherGRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *videoStitcherGRPCClient) CreateCdnKey(ctx context.Context, req *stitcherpb.CreateCdnKeyRequest, opts ...gax.CallOption) (*stitcherpb.CdnKey, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateCdnKey[0:len((*c.CallOptions).CreateCdnKey):len((*c.CallOptions).CreateCdnKey)], opts...)
	var resp *stitcherpb.CdnKey
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.CreateCdnKey(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *videoStitcherGRPCClient) ListCdnKeys(ctx context.Context, req *stitcherpb.ListCdnKeysRequest, opts ...gax.CallOption) *CdnKeyIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListCdnKeys[0:len((*c.CallOptions).ListCdnKeys):len((*c.CallOptions).ListCdnKeys)], opts...)
	it := &CdnKeyIterator{}
	req = proto.Clone(req).(*stitcherpb.ListCdnKeysRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*stitcherpb.CdnKey, string, error) {
		resp := &stitcherpb.ListCdnKeysResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.videoStitcherClient.ListCdnKeys(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetCdnKeys(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *videoStitcherGRPCClient) GetCdnKey(ctx context.Context, req *stitcherpb.GetCdnKeyRequest, opts ...gax.CallOption) (*stitcherpb.CdnKey, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetCdnKey[0:len((*c.CallOptions).GetCdnKey):len((*c.CallOptions).GetCdnKey)], opts...)
	var resp *stitcherpb.CdnKey
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.GetCdnKey(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *videoStitcherGRPCClient) DeleteCdnKey(ctx context.Context, req *stitcherpb.DeleteCdnKeyRequest, opts ...gax.CallOption) error {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteCdnKey[0:len((*c.CallOptions).DeleteCdnKey):len((*c.CallOptions).DeleteCdnKey)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.videoStitcherClient.DeleteCdnKey(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *videoStitcherGRPCClient) UpdateCdnKey(ctx context.Context, req *stitcherpb.UpdateCdnKeyRequest, opts ...gax.CallOption) (*stitcherpb.CdnKey, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "cdn_key.name", url.QueryEscape(req.GetCdnKey().GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateCdnKey[0:len((*c.CallOptions).UpdateCdnKey):len((*c.CallOptions).UpdateCdnKey)], opts...)
	var resp *stitcherpb.CdnKey
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.UpdateCdnKey(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *videoStitcherGRPCClient) CreateVodSession(ctx context.Context, req *stitcherpb.CreateVodSessionRequest, opts ...gax.CallOption) (*stitcherpb.VodSession, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateVodSession[0:len((*c.CallOptions).CreateVodSession):len((*c.CallOptions).CreateVodSession)], opts...)
	var resp *stitcherpb.VodSession
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.CreateVodSession(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *videoStitcherGRPCClient) GetVodSession(ctx context.Context, req *stitcherpb.GetVodSessionRequest, opts ...gax.CallOption) (*stitcherpb.VodSession, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetVodSession[0:len((*c.CallOptions).GetVodSession):len((*c.CallOptions).GetVodSession)], opts...)
	var resp *stitcherpb.VodSession
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.GetVodSession(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *videoStitcherGRPCClient) ListVodStitchDetails(ctx context.Context, req *stitcherpb.ListVodStitchDetailsRequest, opts ...gax.CallOption) *VodStitchDetailIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListVodStitchDetails[0:len((*c.CallOptions).ListVodStitchDetails):len((*c.CallOptions).ListVodStitchDetails)], opts...)
	it := &VodStitchDetailIterator{}
	req = proto.Clone(req).(*stitcherpb.ListVodStitchDetailsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*stitcherpb.VodStitchDetail, string, error) {
		resp := &stitcherpb.ListVodStitchDetailsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.videoStitcherClient.ListVodStitchDetails(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetVodStitchDetails(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *videoStitcherGRPCClient) GetVodStitchDetail(ctx context.Context, req *stitcherpb.GetVodStitchDetailRequest, opts ...gax.CallOption) (*stitcherpb.VodStitchDetail, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetVodStitchDetail[0:len((*c.CallOptions).GetVodStitchDetail):len((*c.CallOptions).GetVodStitchDetail)], opts...)
	var resp *stitcherpb.VodStitchDetail
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.GetVodStitchDetail(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *videoStitcherGRPCClient) ListVodAdTagDetails(ctx context.Context, req *stitcherpb.ListVodAdTagDetailsRequest, opts ...gax.CallOption) *VodAdTagDetailIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListVodAdTagDetails[0:len((*c.CallOptions).ListVodAdTagDetails):len((*c.CallOptions).ListVodAdTagDetails)], opts...)
	it := &VodAdTagDetailIterator{}
	req = proto.Clone(req).(*stitcherpb.ListVodAdTagDetailsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*stitcherpb.VodAdTagDetail, string, error) {
		resp := &stitcherpb.ListVodAdTagDetailsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.videoStitcherClient.ListVodAdTagDetails(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetVodAdTagDetails(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *videoStitcherGRPCClient) GetVodAdTagDetail(ctx context.Context, req *stitcherpb.GetVodAdTagDetailRequest, opts ...gax.CallOption) (*stitcherpb.VodAdTagDetail, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetVodAdTagDetail[0:len((*c.CallOptions).GetVodAdTagDetail):len((*c.CallOptions).GetVodAdTagDetail)], opts...)
	var resp *stitcherpb.VodAdTagDetail
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.GetVodAdTagDetail(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *videoStitcherGRPCClient) ListLiveAdTagDetails(ctx context.Context, req *stitcherpb.ListLiveAdTagDetailsRequest, opts ...gax.CallOption) *LiveAdTagDetailIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListLiveAdTagDetails[0:len((*c.CallOptions).ListLiveAdTagDetails):len((*c.CallOptions).ListLiveAdTagDetails)], opts...)
	it := &LiveAdTagDetailIterator{}
	req = proto.Clone(req).(*stitcherpb.ListLiveAdTagDetailsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*stitcherpb.LiveAdTagDetail, string, error) {
		resp := &stitcherpb.ListLiveAdTagDetailsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.videoStitcherClient.ListLiveAdTagDetails(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetLiveAdTagDetails(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *videoStitcherGRPCClient) GetLiveAdTagDetail(ctx context.Context, req *stitcherpb.GetLiveAdTagDetailRequest, opts ...gax.CallOption) (*stitcherpb.LiveAdTagDetail, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetLiveAdTagDetail[0:len((*c.CallOptions).GetLiveAdTagDetail):len((*c.CallOptions).GetLiveAdTagDetail)], opts...)
	var resp *stitcherpb.LiveAdTagDetail
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.GetLiveAdTagDetail(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *videoStitcherGRPCClient) CreateSlate(ctx context.Context, req *stitcherpb.CreateSlateRequest, opts ...gax.CallOption) (*stitcherpb.Slate, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateSlate[0:len((*c.CallOptions).CreateSlate):len((*c.CallOptions).CreateSlate)], opts...)
	var resp *stitcherpb.Slate
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.CreateSlate(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *videoStitcherGRPCClient) ListSlates(ctx context.Context, req *stitcherpb.ListSlatesRequest, opts ...gax.CallOption) *SlateIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListSlates[0:len((*c.CallOptions).ListSlates):len((*c.CallOptions).ListSlates)], opts...)
	it := &SlateIterator{}
	req = proto.Clone(req).(*stitcherpb.ListSlatesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*stitcherpb.Slate, string, error) {
		resp := &stitcherpb.ListSlatesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.videoStitcherClient.ListSlates(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetSlates(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *videoStitcherGRPCClient) GetSlate(ctx context.Context, req *stitcherpb.GetSlateRequest, opts ...gax.CallOption) (*stitcherpb.Slate, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetSlate[0:len((*c.CallOptions).GetSlate):len((*c.CallOptions).GetSlate)], opts...)
	var resp *stitcherpb.Slate
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.GetSlate(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *videoStitcherGRPCClient) UpdateSlate(ctx context.Context, req *stitcherpb.UpdateSlateRequest, opts ...gax.CallOption) (*stitcherpb.Slate, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "slate.name", url.QueryEscape(req.GetSlate().GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateSlate[0:len((*c.CallOptions).UpdateSlate):len((*c.CallOptions).UpdateSlate)], opts...)
	var resp *stitcherpb.Slate
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.UpdateSlate(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *videoStitcherGRPCClient) DeleteSlate(ctx context.Context, req *stitcherpb.DeleteSlateRequest, opts ...gax.CallOption) error {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteSlate[0:len((*c.CallOptions).DeleteSlate):len((*c.CallOptions).DeleteSlate)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.videoStitcherClient.DeleteSlate(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *videoStitcherGRPCClient) CreateLiveSession(ctx context.Context, req *stitcherpb.CreateLiveSessionRequest, opts ...gax.CallOption) (*stitcherpb.LiveSession, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateLiveSession[0:len((*c.CallOptions).CreateLiveSession):len((*c.CallOptions).CreateLiveSession)], opts...)
	var resp *stitcherpb.LiveSession
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.CreateLiveSession(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *videoStitcherGRPCClient) GetLiveSession(ctx context.Context, req *stitcherpb.GetLiveSessionRequest, opts ...gax.CallOption) (*stitcherpb.LiveSession, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetLiveSession[0:len((*c.CallOptions).GetLiveSession):len((*c.CallOptions).GetLiveSession)], opts...)
	var resp *stitcherpb.LiveSession
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.GetLiveSession(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// CdnKeyIterator manages a stream of *stitcherpb.CdnKey.
type CdnKeyIterator struct {
	items    []*stitcherpb.CdnKey
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*stitcherpb.CdnKey, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *CdnKeyIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *CdnKeyIterator) Next() (*stitcherpb.CdnKey, error) {
	var item *stitcherpb.CdnKey
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *CdnKeyIterator) bufLen() int {
	return len(it.items)
}

func (it *CdnKeyIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// LiveAdTagDetailIterator manages a stream of *stitcherpb.LiveAdTagDetail.
type LiveAdTagDetailIterator struct {
	items    []*stitcherpb.LiveAdTagDetail
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*stitcherpb.LiveAdTagDetail, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *LiveAdTagDetailIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *LiveAdTagDetailIterator) Next() (*stitcherpb.LiveAdTagDetail, error) {
	var item *stitcherpb.LiveAdTagDetail
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *LiveAdTagDetailIterator) bufLen() int {
	return len(it.items)
}

func (it *LiveAdTagDetailIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// SlateIterator manages a stream of *stitcherpb.Slate.
type SlateIterator struct {
	items    []*stitcherpb.Slate
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*stitcherpb.Slate, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *SlateIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *SlateIterator) Next() (*stitcherpb.Slate, error) {
	var item *stitcherpb.Slate
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *SlateIterator) bufLen() int {
	return len(it.items)
}

func (it *SlateIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// VodAdTagDetailIterator manages a stream of *stitcherpb.VodAdTagDetail.
type VodAdTagDetailIterator struct {
	items    []*stitcherpb.VodAdTagDetail
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*stitcherpb.VodAdTagDetail, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *VodAdTagDetailIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *VodAdTagDetailIterator) Next() (*stitcherpb.VodAdTagDetail, error) {
	var item *stitcherpb.VodAdTagDetail
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *VodAdTagDetailIterator) bufLen() int {
	return len(it.items)
}

func (it *VodAdTagDetailIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// VodStitchDetailIterator manages a stream of *stitcherpb.VodStitchDetail.
type VodStitchDetailIterator struct {
	items    []*stitcherpb.VodStitchDetail
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*stitcherpb.VodStitchDetail, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *VodStitchDetailIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *VodStitchDetailIterator) Next() (*stitcherpb.VodStitchDetail, error) {
	var item *stitcherpb.VodStitchDetail
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *VodStitchDetailIterator) bufLen() int {
	return len(it.items)
}

func (it *VodStitchDetailIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}
