// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package notebooks

import (
	"context"
	"fmt"
	"math"
	"net/url"
	"time"

	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	notebookspb "google.golang.org/genproto/googleapis/cloud/notebooks/v1"
	longrunningpb "google.golang.org/genproto/googleapis/longrunning"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/metadata"
	"google.golang.org/protobuf/proto"
)

var newManagedNotebookClientHook clientHook

// ManagedNotebookCallOptions contains the retry settings for each method of ManagedNotebookClient.
type ManagedNotebookCallOptions struct {
	ListRuntimes                []gax.CallOption
	GetRuntime                  []gax.CallOption
	CreateRuntime               []gax.CallOption
	DeleteRuntime               []gax.CallOption
	StartRuntime                []gax.CallOption
	StopRuntime                 []gax.CallOption
	SwitchRuntime               []gax.CallOption
	ResetRuntime                []gax.CallOption
	ReportRuntimeEvent          []gax.CallOption
	RefreshRuntimeTokenInternal []gax.CallOption
}

func defaultManagedNotebookGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("notebooks.googleapis.com:443"),
		internaloption.WithDefaultMTLSEndpoint("notebooks.mtls.googleapis.com:443"),
		internaloption.WithDefaultAudience("https://notebooks.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultManagedNotebookCallOptions() *ManagedNotebookCallOptions {
	return &ManagedNotebookCallOptions{
		ListRuntimes:  []gax.CallOption{},
		GetRuntime:    []gax.CallOption{},
		CreateRuntime: []gax.CallOption{},
		DeleteRuntime: []gax.CallOption{},
		StartRuntime:  []gax.CallOption{},
		StopRuntime:   []gax.CallOption{},
		SwitchRuntime: []gax.CallOption{},
		ResetRuntime: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ReportRuntimeEvent: []gax.CallOption{},
		RefreshRuntimeTokenInternal: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
	}
}

// internalManagedNotebookClient is an interface that defines the methods available from Notebooks API.
type internalManagedNotebookClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListRuntimes(context.Context, *notebookspb.ListRuntimesRequest, ...gax.CallOption) *RuntimeIterator
	GetRuntime(context.Context, *notebookspb.GetRuntimeRequest, ...gax.CallOption) (*notebookspb.Runtime, error)
	CreateRuntime(context.Context, *notebookspb.CreateRuntimeRequest, ...gax.CallOption) (*CreateRuntimeOperation, error)
	CreateRuntimeOperation(name string) *CreateRuntimeOperation
	DeleteRuntime(context.Context, *notebookspb.DeleteRuntimeRequest, ...gax.CallOption) (*DeleteRuntimeOperation, error)
	DeleteRuntimeOperation(name string) *DeleteRuntimeOperation
	StartRuntime(context.Context, *notebookspb.StartRuntimeRequest, ...gax.CallOption) (*StartRuntimeOperation, error)
	StartRuntimeOperation(name string) *StartRuntimeOperation
	StopRuntime(context.Context, *notebookspb.StopRuntimeRequest, ...gax.CallOption) (*StopRuntimeOperation, error)
	StopRuntimeOperation(name string) *StopRuntimeOperation
	SwitchRuntime(context.Context, *notebookspb.SwitchRuntimeRequest, ...gax.CallOption) (*SwitchRuntimeOperation, error)
	SwitchRuntimeOperation(name string) *SwitchRuntimeOperation
	ResetRuntime(context.Context, *notebookspb.ResetRuntimeRequest, ...gax.CallOption) (*ResetRuntimeOperation, error)
	ResetRuntimeOperation(name string) *ResetRuntimeOperation
	ReportRuntimeEvent(context.Context, *notebookspb.ReportRuntimeEventRequest, ...gax.CallOption) (*ReportRuntimeEventOperation, error)
	ReportRuntimeEventOperation(name string) *ReportRuntimeEventOperation
	RefreshRuntimeTokenInternal(context.Context, *notebookspb.RefreshRuntimeTokenInternalRequest, ...gax.CallOption) (*notebookspb.RefreshRuntimeTokenInternalResponse, error)
}

// ManagedNotebookClient is a client for interacting with Notebooks API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// API v1 service for Managed Notebooks.
type ManagedNotebookClient struct {
	// The internal transport-dependent client.
	internalClient internalManagedNotebookClient

	// The call options for this service.
	CallOptions *ManagedNotebookCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *ManagedNotebookClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *ManagedNotebookClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated.
func (c *ManagedNotebookClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListRuntimes lists Runtimes in a given project and location.
func (c *ManagedNotebookClient) ListRuntimes(ctx context.Context, req *notebookspb.ListRuntimesRequest, opts ...gax.CallOption) *RuntimeIterator {
	return c.internalClient.ListRuntimes(ctx, req, opts...)
}

// GetRuntime gets details of a single Runtime. The location must be a regional endpoint
// rather than zonal.
func (c *ManagedNotebookClient) GetRuntime(ctx context.Context, req *notebookspb.GetRuntimeRequest, opts ...gax.CallOption) (*notebookspb.Runtime, error) {
	return c.internalClient.GetRuntime(ctx, req, opts...)
}

// CreateRuntime creates a new Runtime in a given project and location.
func (c *ManagedNotebookClient) CreateRuntime(ctx context.Context, req *notebookspb.CreateRuntimeRequest, opts ...gax.CallOption) (*CreateRuntimeOperation, error) {
	return c.internalClient.CreateRuntime(ctx, req, opts...)
}

// CreateRuntimeOperation returns a new CreateRuntimeOperation from a given name.
// The name must be that of a previously created CreateRuntimeOperation, possibly from a different process.
func (c *ManagedNotebookClient) CreateRuntimeOperation(name string) *CreateRuntimeOperation {
	return c.internalClient.CreateRuntimeOperation(name)
}

// DeleteRuntime deletes a single Runtime.
func (c *ManagedNotebookClient) DeleteRuntime(ctx context.Context, req *notebookspb.DeleteRuntimeRequest, opts ...gax.CallOption) (*DeleteRuntimeOperation, error) {
	return c.internalClient.DeleteRuntime(ctx, req, opts...)
}

// DeleteRuntimeOperation returns a new DeleteRuntimeOperation from a given name.
// The name must be that of a previously created DeleteRuntimeOperation, possibly from a different process.
func (c *ManagedNotebookClient) DeleteRuntimeOperation(name string) *DeleteRuntimeOperation {
	return c.internalClient.DeleteRuntimeOperation(name)
}

// StartRuntime starts a Managed Notebook Runtime.
// Perform “Start” on GPU instances; “Resume” on CPU instances
// See:
// https://cloud.google.com/compute/docs/instances/stop-start-instance (at https://cloud.google.com/compute/docs/instances/stop-start-instance)
// https://cloud.google.com/compute/docs/instances/suspend-resume-instance (at https://cloud.google.com/compute/docs/instances/suspend-resume-instance)
func (c *ManagedNotebookClient) StartRuntime(ctx context.Context, req *notebookspb.StartRuntimeRequest, opts ...gax.CallOption) (*StartRuntimeOperation, error) {
	return c.internalClient.StartRuntime(ctx, req, opts...)
}

// StartRuntimeOperation returns a new StartRuntimeOperation from a given name.
// The name must be that of a previously created StartRuntimeOperation, possibly from a different process.
func (c *ManagedNotebookClient) StartRuntimeOperation(name string) *StartRuntimeOperation {
	return c.internalClient.StartRuntimeOperation(name)
}

// StopRuntime stops a Managed Notebook Runtime.
// Perform “Stop” on GPU instances; “Suspend” on CPU instances
// See:
// https://cloud.google.com/compute/docs/instances/stop-start-instance (at https://cloud.google.com/compute/docs/instances/stop-start-instance)
// https://cloud.google.com/compute/docs/instances/suspend-resume-instance (at https://cloud.google.com/compute/docs/instances/suspend-resume-instance)
func (c *ManagedNotebookClient) StopRuntime(ctx context.Context, req *notebookspb.StopRuntimeRequest, opts ...gax.CallOption) (*StopRuntimeOperation, error) {
	return c.internalClient.StopRuntime(ctx, req, opts...)
}

// StopRuntimeOperation returns a new StopRuntimeOperation from a given name.
// The name must be that of a previously created StopRuntimeOperation, possibly from a different process.
func (c *ManagedNotebookClient) StopRuntimeOperation(name string) *StopRuntimeOperation {
	return c.internalClient.StopRuntimeOperation(name)
}

// SwitchRuntime switch a Managed Notebook Runtime.
func (c *ManagedNotebookClient) SwitchRuntime(ctx context.Context, req *notebookspb.SwitchRuntimeRequest, opts ...gax.CallOption) (*SwitchRuntimeOperation, error) {
	return c.internalClient.SwitchRuntime(ctx, req, opts...)
}

// SwitchRuntimeOperation returns a new SwitchRuntimeOperation from a given name.
// The name must be that of a previously created SwitchRuntimeOperation, possibly from a different process.
func (c *ManagedNotebookClient) SwitchRuntimeOperation(name string) *SwitchRuntimeOperation {
	return c.internalClient.SwitchRuntimeOperation(name)
}

// ResetRuntime resets a Managed Notebook Runtime.
func (c *ManagedNotebookClient) ResetRuntime(ctx context.Context, req *notebookspb.ResetRuntimeRequest, opts ...gax.CallOption) (*ResetRuntimeOperation, error) {
	return c.internalClient.ResetRuntime(ctx, req, opts...)
}

// ResetRuntimeOperation returns a new ResetRuntimeOperation from a given name.
// The name must be that of a previously created ResetRuntimeOperation, possibly from a different process.
func (c *ManagedNotebookClient) ResetRuntimeOperation(name string) *ResetRuntimeOperation {
	return c.internalClient.ResetRuntimeOperation(name)
}

// ReportRuntimeEvent report and process a runtime event.
func (c *ManagedNotebookClient) ReportRuntimeEvent(ctx context.Context, req *notebookspb.ReportRuntimeEventRequest, opts ...gax.CallOption) (*ReportRuntimeEventOperation, error) {
	return c.internalClient.ReportRuntimeEvent(ctx, req, opts...)
}

// ReportRuntimeEventOperation returns a new ReportRuntimeEventOperation from a given name.
// The name must be that of a previously created ReportRuntimeEventOperation, possibly from a different process.
func (c *ManagedNotebookClient) ReportRuntimeEventOperation(name string) *ReportRuntimeEventOperation {
	return c.internalClient.ReportRuntimeEventOperation(name)
}

// RefreshRuntimeTokenInternal gets an access token for the consumer service account that the customer
// attached to the runtime. Only accessible from the tenant instance.
func (c *ManagedNotebookClient) RefreshRuntimeTokenInternal(ctx context.Context, req *notebookspb.RefreshRuntimeTokenInternalRequest, opts ...gax.CallOption) (*notebookspb.RefreshRuntimeTokenInternalResponse, error) {
	return c.internalClient.RefreshRuntimeTokenInternal(ctx, req, opts...)
}

// managedNotebookGRPCClient is a client for interacting with Notebooks API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type managedNotebookGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// flag to opt out of default deadlines via GOOGLE_API_GO_EXPERIMENTAL_DISABLE_DEFAULT_DEADLINE
	disableDeadlines bool

	// Points back to the CallOptions field of the containing ManagedNotebookClient
	CallOptions **ManagedNotebookCallOptions

	// The gRPC API client.
	managedNotebookClient notebookspb.ManagedNotebookServiceClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogMetadata metadata.MD
}

// NewManagedNotebookClient creates a new managed notebook service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// API v1 service for Managed Notebooks.
func NewManagedNotebookClient(ctx context.Context, opts ...option.ClientOption) (*ManagedNotebookClient, error) {
	clientOpts := defaultManagedNotebookGRPCClientOptions()
	if newManagedNotebookClientHook != nil {
		hookOpts, err := newManagedNotebookClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	disableDeadlines, err := checkDisableDeadlines()
	if err != nil {
		return nil, err
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := ManagedNotebookClient{CallOptions: defaultManagedNotebookCallOptions()}

	c := &managedNotebookGRPCClient{
		connPool:              connPool,
		disableDeadlines:      disableDeadlines,
		managedNotebookClient: notebookspb.NewManagedNotebookServiceClient(connPool),
		CallOptions:           &client.CallOptions,
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated.
func (c *managedNotebookGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *managedNotebookGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", versionGo()}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogMetadata = metadata.Pairs("x-goog-api-client", gax.XGoogHeader(kv...))
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *managedNotebookGRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *managedNotebookGRPCClient) ListRuntimes(ctx context.Context, req *notebookspb.ListRuntimesRequest, opts ...gax.CallOption) *RuntimeIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListRuntimes[0:len((*c.CallOptions).ListRuntimes):len((*c.CallOptions).ListRuntimes)], opts...)
	it := &RuntimeIterator{}
	req = proto.Clone(req).(*notebookspb.ListRuntimesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*notebookspb.Runtime, string, error) {
		resp := &notebookspb.ListRuntimesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.managedNotebookClient.ListRuntimes(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetRuntimes(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *managedNotebookGRPCClient) GetRuntime(ctx context.Context, req *notebookspb.GetRuntimeRequest, opts ...gax.CallOption) (*notebookspb.Runtime, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetRuntime[0:len((*c.CallOptions).GetRuntime):len((*c.CallOptions).GetRuntime)], opts...)
	var resp *notebookspb.Runtime
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.managedNotebookClient.GetRuntime(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *managedNotebookGRPCClient) CreateRuntime(ctx context.Context, req *notebookspb.CreateRuntimeRequest, opts ...gax.CallOption) (*CreateRuntimeOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateRuntime[0:len((*c.CallOptions).CreateRuntime):len((*c.CallOptions).CreateRuntime)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.managedNotebookClient.CreateRuntime(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *managedNotebookGRPCClient) DeleteRuntime(ctx context.Context, req *notebookspb.DeleteRuntimeRequest, opts ...gax.CallOption) (*DeleteRuntimeOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteRuntime[0:len((*c.CallOptions).DeleteRuntime):len((*c.CallOptions).DeleteRuntime)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.managedNotebookClient.DeleteRuntime(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *managedNotebookGRPCClient) StartRuntime(ctx context.Context, req *notebookspb.StartRuntimeRequest, opts ...gax.CallOption) (*StartRuntimeOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).StartRuntime[0:len((*c.CallOptions).StartRuntime):len((*c.CallOptions).StartRuntime)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.managedNotebookClient.StartRuntime(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &StartRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *managedNotebookGRPCClient) StopRuntime(ctx context.Context, req *notebookspb.StopRuntimeRequest, opts ...gax.CallOption) (*StopRuntimeOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).StopRuntime[0:len((*c.CallOptions).StopRuntime):len((*c.CallOptions).StopRuntime)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.managedNotebookClient.StopRuntime(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &StopRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *managedNotebookGRPCClient) SwitchRuntime(ctx context.Context, req *notebookspb.SwitchRuntimeRequest, opts ...gax.CallOption) (*SwitchRuntimeOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).SwitchRuntime[0:len((*c.CallOptions).SwitchRuntime):len((*c.CallOptions).SwitchRuntime)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.managedNotebookClient.SwitchRuntime(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &SwitchRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *managedNotebookGRPCClient) ResetRuntime(ctx context.Context, req *notebookspb.ResetRuntimeRequest, opts ...gax.CallOption) (*ResetRuntimeOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ResetRuntime[0:len((*c.CallOptions).ResetRuntime):len((*c.CallOptions).ResetRuntime)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.managedNotebookClient.ResetRuntime(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ResetRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *managedNotebookGRPCClient) ReportRuntimeEvent(ctx context.Context, req *notebookspb.ReportRuntimeEventRequest, opts ...gax.CallOption) (*ReportRuntimeEventOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ReportRuntimeEvent[0:len((*c.CallOptions).ReportRuntimeEvent):len((*c.CallOptions).ReportRuntimeEvent)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.managedNotebookClient.ReportRuntimeEvent(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ReportRuntimeEventOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *managedNotebookGRPCClient) RefreshRuntimeTokenInternal(ctx context.Context, req *notebookspb.RefreshRuntimeTokenInternalRequest, opts ...gax.CallOption) (*notebookspb.RefreshRuntimeTokenInternalResponse, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).RefreshRuntimeTokenInternal[0:len((*c.CallOptions).RefreshRuntimeTokenInternal):len((*c.CallOptions).RefreshRuntimeTokenInternal)], opts...)
	var resp *notebookspb.RefreshRuntimeTokenInternalResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.managedNotebookClient.RefreshRuntimeTokenInternal(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// CreateRuntimeOperation manages a long-running operation from CreateRuntime.
type CreateRuntimeOperation struct {
	lro *longrunning.Operation
}

// CreateRuntimeOperation returns a new CreateRuntimeOperation from a given name.
// The name must be that of a previously created CreateRuntimeOperation, possibly from a different process.
func (c *managedNotebookGRPCClient) CreateRuntimeOperation(name string) *CreateRuntimeOperation {
	return &CreateRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateRuntimeOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*notebookspb.Runtime, error) {
	var resp notebookspb.Runtime
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateRuntimeOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*notebookspb.Runtime, error) {
	var resp notebookspb.Runtime
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateRuntimeOperation) Metadata() (*notebookspb.OperationMetadata, error) {
	var meta notebookspb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateRuntimeOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateRuntimeOperation) Name() string {
	return op.lro.Name()
}

// DeleteRuntimeOperation manages a long-running operation from DeleteRuntime.
type DeleteRuntimeOperation struct {
	lro *longrunning.Operation
}

// DeleteRuntimeOperation returns a new DeleteRuntimeOperation from a given name.
// The name must be that of a previously created DeleteRuntimeOperation, possibly from a different process.
func (c *managedNotebookGRPCClient) DeleteRuntimeOperation(name string) *DeleteRuntimeOperation {
	return &DeleteRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteRuntimeOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteRuntimeOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteRuntimeOperation) Metadata() (*notebookspb.OperationMetadata, error) {
	var meta notebookspb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteRuntimeOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteRuntimeOperation) Name() string {
	return op.lro.Name()
}

// ReportRuntimeEventOperation manages a long-running operation from ReportRuntimeEvent.
type ReportRuntimeEventOperation struct {
	lro *longrunning.Operation
}

// ReportRuntimeEventOperation returns a new ReportRuntimeEventOperation from a given name.
// The name must be that of a previously created ReportRuntimeEventOperation, possibly from a different process.
func (c *managedNotebookGRPCClient) ReportRuntimeEventOperation(name string) *ReportRuntimeEventOperation {
	return &ReportRuntimeEventOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *ReportRuntimeEventOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*notebookspb.Runtime, error) {
	var resp notebookspb.Runtime
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *ReportRuntimeEventOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*notebookspb.Runtime, error) {
	var resp notebookspb.Runtime
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *ReportRuntimeEventOperation) Metadata() (*notebookspb.OperationMetadata, error) {
	var meta notebookspb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *ReportRuntimeEventOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *ReportRuntimeEventOperation) Name() string {
	return op.lro.Name()
}

// ResetRuntimeOperation manages a long-running operation from ResetRuntime.
type ResetRuntimeOperation struct {
	lro *longrunning.Operation
}

// ResetRuntimeOperation returns a new ResetRuntimeOperation from a given name.
// The name must be that of a previously created ResetRuntimeOperation, possibly from a different process.
func (c *managedNotebookGRPCClient) ResetRuntimeOperation(name string) *ResetRuntimeOperation {
	return &ResetRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *ResetRuntimeOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*notebookspb.Runtime, error) {
	var resp notebookspb.Runtime
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *ResetRuntimeOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*notebookspb.Runtime, error) {
	var resp notebookspb.Runtime
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *ResetRuntimeOperation) Metadata() (*notebookspb.OperationMetadata, error) {
	var meta notebookspb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *ResetRuntimeOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *ResetRuntimeOperation) Name() string {
	return op.lro.Name()
}

// StartRuntimeOperation manages a long-running operation from StartRuntime.
type StartRuntimeOperation struct {
	lro *longrunning.Operation
}

// StartRuntimeOperation returns a new StartRuntimeOperation from a given name.
// The name must be that of a previously created StartRuntimeOperation, possibly from a different process.
func (c *managedNotebookGRPCClient) StartRuntimeOperation(name string) *StartRuntimeOperation {
	return &StartRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *StartRuntimeOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*notebookspb.Runtime, error) {
	var resp notebookspb.Runtime
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *StartRuntimeOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*notebookspb.Runtime, error) {
	var resp notebookspb.Runtime
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *StartRuntimeOperation) Metadata() (*notebookspb.OperationMetadata, error) {
	var meta notebookspb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *StartRuntimeOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *StartRuntimeOperation) Name() string {
	return op.lro.Name()
}

// StopRuntimeOperation manages a long-running operation from StopRuntime.
type StopRuntimeOperation struct {
	lro *longrunning.Operation
}

// StopRuntimeOperation returns a new StopRuntimeOperation from a given name.
// The name must be that of a previously created StopRuntimeOperation, possibly from a different process.
func (c *managedNotebookGRPCClient) StopRuntimeOperation(name string) *StopRuntimeOperation {
	return &StopRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *StopRuntimeOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*notebookspb.Runtime, error) {
	var resp notebookspb.Runtime
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *StopRuntimeOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*notebookspb.Runtime, error) {
	var resp notebookspb.Runtime
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *StopRuntimeOperation) Metadata() (*notebookspb.OperationMetadata, error) {
	var meta notebookspb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *StopRuntimeOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *StopRuntimeOperation) Name() string {
	return op.lro.Name()
}

// SwitchRuntimeOperation manages a long-running operation from SwitchRuntime.
type SwitchRuntimeOperation struct {
	lro *longrunning.Operation
}

// SwitchRuntimeOperation returns a new SwitchRuntimeOperation from a given name.
// The name must be that of a previously created SwitchRuntimeOperation, possibly from a different process.
func (c *managedNotebookGRPCClient) SwitchRuntimeOperation(name string) *SwitchRuntimeOperation {
	return &SwitchRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *SwitchRuntimeOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*notebookspb.Runtime, error) {
	var resp notebookspb.Runtime
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *SwitchRuntimeOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*notebookspb.Runtime, error) {
	var resp notebookspb.Runtime
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *SwitchRuntimeOperation) Metadata() (*notebookspb.OperationMetadata, error) {
	var meta notebookspb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *SwitchRuntimeOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *SwitchRuntimeOperation) Name() string {
	return op.lro.Name()
}

// RuntimeIterator manages a stream of *notebookspb.Runtime.
type RuntimeIterator struct {
	items    []*notebookspb.Runtime
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*notebookspb.Runtime, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *RuntimeIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *RuntimeIterator) Next() (*notebookspb.Runtime, error) {
	var item *notebookspb.Runtime
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *RuntimeIterator) bufLen() int {
	return len(it.items)
}

func (it *RuntimeIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}
