// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.19.4
// source: metadata/metadata.proto

package metadata

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A programming language
type Language int32

const (
	// The language has not been specified. Consumers should not see this value.
	Language_LANGUAGE_UNSPECIFIED Language = 0
	Language_C_PLUS_PLUS          Language = 1
	Language_C_SHARP              Language = 2
	Language_DART                 Language = 3
	Language_ELIXIR               Language = 4
	Language_ERLANG               Language = 5
	Language_F_SHARP              Language = 6
	Language_GO                   Language = 7
	Language_JAVA                 Language = 8
	Language_JAVASCRIPT           Language = 9
	Language_KOTLIN               Language = 10
	Language_PHP                  Language = 11
	Language_PYTHON               Language = 12
	Language_RUBY                 Language = 13
	Language_RUST                 Language = 14
	Language_SWIFT                Language = 15
	Language_TYPESCRIPT           Language = 16
	Language_VB_NET               Language = 17
)

// Enum value maps for Language.
var (
	Language_name = map[int32]string{
		0:  "LANGUAGE_UNSPECIFIED",
		1:  "C_PLUS_PLUS",
		2:  "C_SHARP",
		3:  "DART",
		4:  "ELIXIR",
		5:  "ERLANG",
		6:  "F_SHARP",
		7:  "GO",
		8:  "JAVA",
		9:  "JAVASCRIPT",
		10: "KOTLIN",
		11: "PHP",
		12: "PYTHON",
		13: "RUBY",
		14: "RUST",
		15: "SWIFT",
		16: "TYPESCRIPT",
		17: "VB_NET",
	}
	Language_value = map[string]int32{
		"LANGUAGE_UNSPECIFIED": 0,
		"C_PLUS_PLUS":          1,
		"C_SHARP":              2,
		"DART":                 3,
		"ELIXIR":               4,
		"ERLANG":               5,
		"F_SHARP":              6,
		"GO":                   7,
		"JAVA":                 8,
		"JAVASCRIPT":           9,
		"KOTLIN":               10,
		"PHP":                  11,
		"PYTHON":               12,
		"RUBY":                 13,
		"RUST":                 14,
		"SWIFT":                15,
		"TYPESCRIPT":           16,
		"VB_NET":               17,
	}
)

func (x Language) Enum() *Language {
	p := new(Language)
	*p = x
	return p
}

func (x Language) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Language) Descriptor() protoreflect.EnumDescriptor {
	return file_metadata_metadata_proto_enumTypes[0].Descriptor()
}

func (Language) Type() protoreflect.EnumType {
	return &file_metadata_metadata_proto_enumTypes[0]
}

func (x Language) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Language.Descriptor instead.
func (Language) EnumDescriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{0}
}

// The origin of the snippet.
type Snippet_Origin int32

const (
	// The origin has not been specified. Consumers should not see this value.
	Snippet_ORIGIN_UNSPECIFIED Snippet_Origin = 0
	// The snippet is generated from the API definition only, including protos
	// and descriptive information, i.e. the same information used to generate
	// the client libraries themselves.
	// No snippet configuration has been specified. This refers to SnippetGen
	// phase 1.
	Snippet_API_DEFINITION Snippet_Origin = 1
	// The snippet is generated from the API definition and a specific snippet
	// configuration. This refers to SnippetGen phase 2.
	Snippet_CONFIG Snippet_Origin = 2
	// The snippet is handwritten.
	Snippet_HANDWRITTEN Snippet_Origin = 3
)

// Enum value maps for Snippet_Origin.
var (
	Snippet_Origin_name = map[int32]string{
		0: "ORIGIN_UNSPECIFIED",
		1: "API_DEFINITION",
		2: "CONFIG",
		3: "HANDWRITTEN",
	}
	Snippet_Origin_value = map[string]int32{
		"ORIGIN_UNSPECIFIED": 0,
		"API_DEFINITION":     1,
		"CONFIG":             2,
		"HANDWRITTEN":        3,
	}
)

func (x Snippet_Origin) Enum() *Snippet_Origin {
	p := new(Snippet_Origin)
	*p = x
	return p
}

func (x Snippet_Origin) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Snippet_Origin) Descriptor() protoreflect.EnumDescriptor {
	return file_metadata_metadata_proto_enumTypes[1].Descriptor()
}

func (Snippet_Origin) Type() protoreflect.EnumType {
	return &file_metadata_metadata_proto_enumTypes[1]
}

func (x Snippet_Origin) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Snippet_Origin.Descriptor instead.
func (Snippet_Origin) EnumDescriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{1, 0}
}

// The type of the segment.
// Basically describes what this segment shows.
type Snippet_Segment_SegmentType int32

const (
	// The segment type has not been specified. Consumers should not see this
	// value.
	Snippet_Segment_SEGMENT_TYPE_UNSPECIFIED Snippet_Segment_SegmentType = 0
	// The full sample including import statements.
	// This corresponds to the sample as determined by the region tags.
	Snippet_Segment_FULL Snippet_Segment_SegmentType = 1
	// A shorter version of the full sample, may not include imports and some
	// langauge specific initialization code. This is to be used in contexts
	// in which the full aspects of the sample are made clear outside the
	// code.
	Snippet_Segment_SHORT Snippet_Segment_SegmentType = 2
	// The segment contains the service client initialization code only.
	// To be used in tutorials, codelabs, etc.
	Snippet_Segment_CLIENT_INITIALIZATION Snippet_Segment_SegmentType = 3
	// The segment contains the request initialization code only.
	// To be used in tutorials, codelabs, etc.
	Snippet_Segment_REQUEST_INITIALIZATION Snippet_Segment_SegmentType = 4
	// The segment contains the request execution code only.
	// To be used in tutorials, codelabs, etc.
	Snippet_Segment_REQUEST_EXECUTION Snippet_Segment_SegmentType = 5
	// The segment contains the response handling code only.
	// To be used in tutorials, codelabs, etc.
	Snippet_Segment_RESPONSE_HANDLING Snippet_Segment_SegmentType = 6
)

// Enum value maps for Snippet_Segment_SegmentType.
var (
	Snippet_Segment_SegmentType_name = map[int32]string{
		0: "SEGMENT_TYPE_UNSPECIFIED",
		1: "FULL",
		2: "SHORT",
		3: "CLIENT_INITIALIZATION",
		4: "REQUEST_INITIALIZATION",
		5: "REQUEST_EXECUTION",
		6: "RESPONSE_HANDLING",
	}
	Snippet_Segment_SegmentType_value = map[string]int32{
		"SEGMENT_TYPE_UNSPECIFIED": 0,
		"FULL":                     1,
		"SHORT":                    2,
		"CLIENT_INITIALIZATION":    3,
		"REQUEST_INITIALIZATION":   4,
		"REQUEST_EXECUTION":        5,
		"RESPONSE_HANDLING":        6,
	}
)

func (x Snippet_Segment_SegmentType) Enum() *Snippet_Segment_SegmentType {
	p := new(Snippet_Segment_SegmentType)
	*p = x
	return p
}

func (x Snippet_Segment_SegmentType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Snippet_Segment_SegmentType) Descriptor() protoreflect.EnumDescriptor {
	return file_metadata_metadata_proto_enumTypes[2].Descriptor()
}

func (Snippet_Segment_SegmentType) Type() protoreflect.EnumType {
	return &file_metadata_metadata_proto_enumTypes[2]
}

func (x Snippet_Segment_SegmentType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Snippet_Segment_SegmentType.Descriptor instead.
func (Snippet_Segment_SegmentType) EnumDescriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{1, 0, 0}
}

// The snippet index for a single client library.
type Index struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Client Library these snippets are for.
	ClientLibrary *ClientLibrary `protobuf:"bytes,1,opt,name=client_library,json=clientLibrary,proto3" json:"client_library,omitempty"`
	// The list of snippets.
	Snippets []*Snippet `protobuf:"bytes,2,rep,name=snippets,proto3" json:"snippets,omitempty"`
}

func (x *Index) Reset() {
	*x = Index{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metadata_metadata_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Index) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Index) ProtoMessage() {}

func (x *Index) ProtoReflect() protoreflect.Message {
	mi := &file_metadata_metadata_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Index.ProtoReflect.Descriptor instead.
func (*Index) Descriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{0}
}

func (x *Index) GetClientLibrary() *ClientLibrary {
	if x != nil {
		return x.ClientLibrary
	}
	return nil
}

func (x *Index) GetSnippets() []*Snippet {
	if x != nil {
		return x.Snippets
	}
	return nil
}

// One sample.
// Parts of this information will be language specific.
type Snippet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The region tag name. Does not include the square brackets or the START or
	// END indicators.
	RegionTag string `protobuf:"bytes,1,opt,name=region_tag,json=regionTag,proto3" json:"region_tag,omitempty"`
	// The title of the snippet, for human consumption mostly. For generated
	// snippets this may be the snippet method or file name, or obtained from
	/// snippet configuration.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// A description of the snippet, for human consumption mostly. For generated
	// snippets this may be the description of the service method, or obtained
	// from snippet configuration.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The file where the snippet code lives.
	// The path should be relative to where this metadata file is stored on the
	// GitHub repo root and should not include branch, tag, commitish, etc.,
	// as those will be the same as for the metadata file.
	File string `protobuf:"bytes,4,opt,name=file,proto3" json:"file,omitempty"`
	// The programming language the snippet is written in.
	// This will match the client library language most of the time, but not
	// always. For instance, in .NET, libraries are written in C# but some samples
	// may be written in F# or VB .NET.
	// Note that this does not contain information about the snippet supported
	// platforms or language versions, etc. This is just a quick way to identify
	// the generally supported langauge.
	Language Language `protobuf:"varint,5,opt,name=language,proto3,enum=google.cloud.tools.snippetgen.snippetindex.v1.Language" json:"language,omitempty"`
	// The client library method this snippet is for.
	ClientMethod *ClientMethod `protobuf:"bytes,6,opt,name=client_method,json=clientMethod,proto3" json:"client_method,omitempty"`
	// Wether this is the canonical snippet for the corresponding service method.
	// This is to be interpreted in conjunction with origin as follows:
	// For a given service method:
	// - A handwritten canonical takes precedence over
	// - A config canonical which in turn takes precedence over
	// - A baseline canonical.
	Canonical bool `protobuf:"varint,7,opt,name=canonical,proto3" json:"canonical,omitempty"`
	// The origin of the snippet.
	Origin Snippet_Origin `protobuf:"varint,8,opt,name=origin,proto3,enum=google.cloud.tools.snippetgen.snippetindex.v1.Snippet_Origin" json:"origin,omitempty"`
	// The different segments of the snippet.
	// Must contain the FULL segment always.
	// There may be overlap between segments.
	Segments []*Snippet_Segment `protobuf:"bytes,9,rep,name=segments,proto3" json:"segments,omitempty"`
}

func (x *Snippet) Reset() {
	*x = Snippet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metadata_metadata_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Snippet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Snippet) ProtoMessage() {}

func (x *Snippet) ProtoReflect() protoreflect.Message {
	mi := &file_metadata_metadata_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Snippet.ProtoReflect.Descriptor instead.
func (*Snippet) Descriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{1}
}

func (x *Snippet) GetRegionTag() string {
	if x != nil {
		return x.RegionTag
	}
	return ""
}

func (x *Snippet) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Snippet) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Snippet) GetFile() string {
	if x != nil {
		return x.File
	}
	return ""
}

func (x *Snippet) GetLanguage() Language {
	if x != nil {
		return x.Language
	}
	return Language_LANGUAGE_UNSPECIFIED
}

func (x *Snippet) GetClientMethod() *ClientMethod {
	if x != nil {
		return x.ClientMethod
	}
	return nil
}

func (x *Snippet) GetCanonical() bool {
	if x != nil {
		return x.Canonical
	}
	return false
}

func (x *Snippet) GetOrigin() Snippet_Origin {
	if x != nil {
		return x.Origin
	}
	return Snippet_ORIGIN_UNSPECIFIED
}

func (x *Snippet) GetSegments() []*Snippet_Segment {
	if x != nil {
		return x.Segments
	}
	return nil
}

// A client library method.
// Will contain language specific information.
type ClientMethod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The short name of the method, usually the name it is declared with.
	// This may not be unique within the service client because of overloads.
	ShortName string `protobuf:"bytes,1,opt,name=short_name,json=shortName,proto3" json:"short_name,omitempty"`
	// The fully qualified name of the method, which is the short_name qualified
	// by the full_name of the service client.
	// This value is redundant, but present to make it easier for consumers to
	// obtain it.
	// This may not be unique within the service client because of overloads.
	FullName string `protobuf:"bytes,2,opt,name=full_name,json=fullName,proto3" json:"full_name,omitempty"`
	// Indicates wether this method is synchronous or asynchronous.
	// Some languages may support only one of the variants, in which case, this
	// field will always have the same value (for that language).
	Async bool `protobuf:"varint,3,opt,name=async,proto3" json:"async,omitempty"`
	// Parameters of this method in the same order as they appear on the method
	// declaration. Must be empty if the method has no parameters.
	Parameters []*ClientMethod_Parameter `protobuf:"bytes,4,rep,name=parameters,proto3" json:"parameters,omitempty"`
	// Fully qualified type name of this method result, if any.
	ResultType string `protobuf:"bytes,5,opt,name=result_type,json=resultType,proto3" json:"result_type,omitempty"`
	// The service client this method is declared in.
	Client *ServiceClient `protobuf:"bytes,6,opt,name=client,proto3" json:"client,omitempty"`
	// The service method this client method is for.
	Method *Method `protobuf:"bytes,7,opt,name=method,proto3" json:"method,omitempty"`
}

func (x *ClientMethod) Reset() {
	*x = ClientMethod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metadata_metadata_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClientMethod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientMethod) ProtoMessage() {}

func (x *ClientMethod) ProtoReflect() protoreflect.Message {
	mi := &file_metadata_metadata_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientMethod.ProtoReflect.Descriptor instead.
func (*ClientMethod) Descriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{2}
}

func (x *ClientMethod) GetShortName() string {
	if x != nil {
		return x.ShortName
	}
	return ""
}

func (x *ClientMethod) GetFullName() string {
	if x != nil {
		return x.FullName
	}
	return ""
}

func (x *ClientMethod) GetAsync() bool {
	if x != nil {
		return x.Async
	}
	return false
}

func (x *ClientMethod) GetParameters() []*ClientMethod_Parameter {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *ClientMethod) GetResultType() string {
	if x != nil {
		return x.ResultType
	}
	return ""
}

func (x *ClientMethod) GetClient() *ServiceClient {
	if x != nil {
		return x.Client
	}
	return nil
}

func (x *ClientMethod) GetMethod() *Method {
	if x != nil {
		return x.Method
	}
	return nil
}

// A service client defined in the client library specified in Index.
// Will contain language specific information.
type ServiceClient struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The short name of the service client, usually the name it is declared with.
	// This may not be unique within the client library because of
	// namespaces/packages.
	ShortName string `protobuf:"bytes,1,opt,name=short_name,json=shortName,proto3" json:"short_name,omitempty"`
	// The fully qualified name of the service client, which is the short_name
	// qualified by the namespace/package/type name this client is declared in.
	// This will be unique within the client libray.
	FullName string `protobuf:"bytes,2,opt,name=full_name,json=fullName,proto3" json:"full_name,omitempty"`
}

func (x *ServiceClient) Reset() {
	*x = ServiceClient{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metadata_metadata_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceClient) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceClient) ProtoMessage() {}

func (x *ServiceClient) ProtoReflect() protoreflect.Message {
	mi := &file_metadata_metadata_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceClient.ProtoReflect.Descriptor instead.
func (*ServiceClient) Descriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{3}
}

func (x *ServiceClient) GetShortName() string {
	if x != nil {
		return x.ShortName
	}
	return ""
}

func (x *ServiceClient) GetFullName() string {
	if x != nil {
		return x.FullName
	}
	return ""
}

// A client library.
// Will contain language specific information.
type ClientLibrary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the client library. This value will be language dependent
	// and may or may not include the library version.
	// Usually this will be the name used to identify the library on per-language
	// package managers.
	// Examples: "Google.Cloud.Translate.V3",
	// "cloud.google.com/go/translate/apiv3".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The full version of the client library. May also be language dependent.
	// Cannot be updated on metadata generation, but on library release.
	// Examples: "4.3.0", "2.5.2-beta01"
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// The programming language the library is written in.
	// Note that this does not contain information about the library supported
	// platforms or language versions, etc. This is just a quick way to identify
	// the generally supported langauge.
	Language Language `protobuf:"varint,3,opt,name=language,proto3,enum=google.cloud.tools.snippetgen.snippetindex.v1.Language" json:"language,omitempty"`
	// The APIs this client library is for.
	// Some languages bundle several APIs on the same client library.
	Apis []*Api `protobuf:"bytes,4,rep,name=apis,proto3" json:"apis,omitempty"`
}

func (x *ClientLibrary) Reset() {
	*x = ClientLibrary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metadata_metadata_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClientLibrary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientLibrary) ProtoMessage() {}

func (x *ClientLibrary) ProtoReflect() protoreflect.Message {
	mi := &file_metadata_metadata_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientLibrary.ProtoReflect.Descriptor instead.
func (*ClientLibrary) Descriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{4}
}

func (x *ClientLibrary) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ClientLibrary) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *ClientLibrary) GetLanguage() Language {
	if x != nil {
		return x.Language
	}
	return Language_LANGUAGE_UNSPECIFIED
}

func (x *ClientLibrary) GetApis() []*Api {
	if x != nil {
		return x.Apis
	}
	return nil
}

type Method struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The short name of the method, which is the name used to
	// declare it within the proto file. This is unique within the service,
	// but may not be unique within the API.
	ShortName string `protobuf:"bytes,1,opt,name=short_name,json=shortName,proto3" json:"short_name,omitempty"`
	// The full name of the method, which is the short name qualified
	// by the full name of the service in which it is declared.
	// This is globally unique.
	FullName string `protobuf:"bytes,2,opt,name=full_name,json=fullName,proto3" json:"full_name,omitempty"`
	// The service this method is declared in.
	Service *Service `protobuf:"bytes,3,opt,name=service,proto3" json:"service,omitempty"`
}

func (x *Method) Reset() {
	*x = Method{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metadata_metadata_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Method) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Method) ProtoMessage() {}

func (x *Method) ProtoReflect() protoreflect.Message {
	mi := &file_metadata_metadata_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Method.ProtoReflect.Descriptor instead.
func (*Method) Descriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{5}
}

func (x *Method) GetShortName() string {
	if x != nil {
		return x.ShortName
	}
	return ""
}

func (x *Method) GetFullName() string {
	if x != nil {
		return x.FullName
	}
	return ""
}

func (x *Method) GetService() *Service {
	if x != nil {
		return x.Service
	}
	return nil
}

// A service defined in the API the client library referenced in Index is for.
type Service struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The short name of the service, which is the name used to
	// declare it within the proto file. This is usually, but not
	// absolutely necessarily, unique within an API.
	// Example: "TranslationService"
	ShortName string `protobuf:"bytes,1,opt,name=short_name,json=shortName,proto3" json:"short_name,omitempty"`
	// The full name of the service, which is the short name qualified
	// by the package of the proto in which it is declared.
	// This is globally unique.
	// Example: "google.cloud.translate.v3.TranslationService"
	FullName string `protobuf:"bytes,2,opt,name=full_name,json=fullName,proto3" json:"full_name,omitempty"`
}

func (x *Service) Reset() {
	*x = Service{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metadata_metadata_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Service) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service) ProtoMessage() {}

func (x *Service) ProtoReflect() protoreflect.Message {
	mi := &file_metadata_metadata_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service.ProtoReflect.Descriptor instead.
func (*Service) Descriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{6}
}

func (x *Service) GetShortName() string {
	if x != nil {
		return x.ShortName
	}
	return ""
}

func (x *Service) GetFullName() string {
	if x != nil {
		return x.FullName
	}
	return ""
}

// An API
type Api struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the API, identical to the protobuf package
	// ending with a version number.
	// Example: "google.cloud.translate.v3"
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The full version inferred from the end of the ID.
	// Examples: "v3", "v2beta1", "v1beta"
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *Api) Reset() {
	*x = Api{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metadata_metadata_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Api) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Api) ProtoMessage() {}

func (x *Api) ProtoReflect() protoreflect.Message {
	mi := &file_metadata_metadata_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Api.ProtoReflect.Descriptor instead.
func (*Api) Descriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{7}
}

func (x *Api) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Api) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// A segment of the snippet.
type Snippet_Segment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The line where this segment begins, inclusive.
	// For the FULL segment, this will be the START region tag line + 1.
	Start int32 `protobuf:"varint,1,opt,name=start,proto3" json:"start,omitempty"`
	// The line where this segment ends, inclusive.
	// For the FULL segment, this will be the END region tag line - 1.
	End int32 `protobuf:"varint,2,opt,name=end,proto3" json:"end,omitempty"`
	// The type of the segment.
	Type Snippet_Segment_SegmentType `protobuf:"varint,3,opt,name=type,proto3,enum=google.cloud.tools.snippetgen.snippetindex.v1.Snippet_Segment_SegmentType" json:"type,omitempty"`
}

func (x *Snippet_Segment) Reset() {
	*x = Snippet_Segment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metadata_metadata_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Snippet_Segment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Snippet_Segment) ProtoMessage() {}

func (x *Snippet_Segment) ProtoReflect() protoreflect.Message {
	mi := &file_metadata_metadata_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Snippet_Segment.ProtoReflect.Descriptor instead.
func (*Snippet_Segment) Descriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{1, 0}
}

func (x *Snippet_Segment) GetStart() int32 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *Snippet_Segment) GetEnd() int32 {
	if x != nil {
		return x.End
	}
	return 0
}

func (x *Snippet_Segment) GetType() Snippet_Segment_SegmentType {
	if x != nil {
		return x.Type
	}
	return Snippet_Segment_SEGMENT_TYPE_UNSPECIFIED
}

// A method parameter as described by its type and name.
type ClientMethod_Parameter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Fully qualified type name of this parameter.
	// May be empty for languages that don't specify a type.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Name of the parameter as it appears on the method declaration.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ClientMethod_Parameter) Reset() {
	*x = ClientMethod_Parameter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metadata_metadata_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClientMethod_Parameter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientMethod_Parameter) ProtoMessage() {}

func (x *ClientMethod_Parameter) ProtoReflect() protoreflect.Message {
	mi := &file_metadata_metadata_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientMethod_Parameter.ProtoReflect.Descriptor instead.
func (*ClientMethod_Parameter) Descriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{2, 0}
}

func (x *ClientMethod_Parameter) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *ClientMethod_Parameter) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_metadata_metadata_proto protoreflect.FileDescriptor

var file_metadata_metadata_proto_rawDesc = []byte{
	0x0a, 0x17, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x73, 0x6e,
	0x69, 0x70, 0x70, 0x65, 0x74, 0x67, 0x65, 0x6e, 0x2e, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x22, 0xc0, 0x01, 0x0a, 0x05, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x12, 0x63, 0x0a, 0x0e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x69, 0x62,
	0x72, 0x61, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x67, 0x65, 0x6e, 0x2e, 0x73, 0x6e, 0x69, 0x70, 0x70,
	0x65, 0x74, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x0d, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x12, 0x52, 0x0a, 0x08, 0x73, 0x6e, 0x69, 0x70, 0x70,
	0x65, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x73,
	0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x67, 0x65, 0x6e, 0x2e, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65,
	0x74, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65,
	0x74, 0x52, 0x08, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x73, 0x22, 0x8b, 0x07, 0x0a, 0x07,
	0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x67, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x67,
	0x69, 0x6f, 0x6e, 0x54, 0x61, 0x67, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x20, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12,
	0x0a, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x69,
	0x6c, 0x65, 0x12, 0x53, 0x0a, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65,
	0x74, 0x67, 0x65, 0x6e, 0x2e, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x08, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x60, 0x0a, 0x0d, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x67, 0x65, 0x6e, 0x2e, 0x73,
	0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x0c, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x61, 0x6e,
	0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x63, 0x61,
	0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x12, 0x55, 0x0a, 0x06, 0x6f, 0x72, 0x69, 0x67, 0x69,
	0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x73, 0x6e, 0x69,
	0x70, 0x70, 0x65, 0x74, 0x67, 0x65, 0x6e, 0x2e, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x2e,
	0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x52, 0x06, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x12, 0x5a,
	0x0a, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x67, 0x65, 0x6e,
	0x2e, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0xb9, 0x02, 0x0a, 0x07, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x10, 0x0a, 0x03,
	0x65, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x03, 0x65, 0x6e, 0x64, 0x12, 0x5e,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x67, 0x65, 0x6e, 0x2e, 0x73, 0x6e, 0x69,
	0x70, 0x70, 0x65, 0x74, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6e, 0x69,
	0x70, 0x70, 0x65, 0x74, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0xa5,
	0x01, 0x0a, 0x0b, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c,
	0x0a, 0x18, 0x53, 0x45, 0x47, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04,
	0x46, 0x55, 0x4c, 0x4c, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x53, 0x48, 0x4f, 0x52, 0x54, 0x10,
	0x02, 0x12, 0x19, 0x0a, 0x15, 0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x49, 0x4e, 0x49, 0x54,
	0x49, 0x41, 0x4c, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x12, 0x1a, 0x0a, 0x16,
	0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x4c, 0x49,
	0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x15, 0x0a, 0x11, 0x52, 0x45, 0x51, 0x55,
	0x45, 0x53, 0x54, 0x5f, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x05, 0x12,
	0x15, 0x0a, 0x11, 0x52, 0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x5f, 0x48, 0x41, 0x4e, 0x44,
	0x4c, 0x49, 0x4e, 0x47, 0x10, 0x06, 0x22, 0x51, 0x0a, 0x06, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e,
	0x12, 0x16, 0x0a, 0x12, 0x4f, 0x52, 0x49, 0x47, 0x49, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x41, 0x50, 0x49, 0x5f,
	0x44, 0x45, 0x46, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06,
	0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x48, 0x41, 0x4e, 0x44,
	0x57, 0x52, 0x49, 0x54, 0x54, 0x45, 0x4e, 0x10, 0x03, 0x22, 0xc2, 0x03, 0x0a, 0x0c, 0x43, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x68,
	0x6f, 0x72, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x73, 0x68, 0x6f, 0x72, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x75, 0x6c,
	0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x75,
	0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x12, 0x65, 0x0a, 0x0a,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x67, 0x65, 0x6e,
	0x2e, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x2e, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x54, 0x0a, 0x06, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65,
	0x74, 0x67, 0x65, 0x6e, 0x2e, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x52, 0x06, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x6d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x67, 0x65, 0x6e, 0x2e, 0x73, 0x6e, 0x69, 0x70, 0x70,
	0x65, 0x74, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x52, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x1a, 0x33, 0x0a, 0x09, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x4b,
	0x0a, 0x0d, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x12,
	0x1d, 0x0a, 0x0a, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b,
	0x0a, 0x09, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x66, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xda, 0x01, 0x0a, 0x0d,
	0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x08, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x67, 0x65, 0x6e, 0x2e, 0x73, 0x6e,
	0x69, 0x70, 0x70, 0x65, 0x74, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x12, 0x46, 0x0a, 0x04, 0x61, 0x70, 0x69, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x67, 0x65, 0x6e, 0x2e, 0x73,
	0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x70, 0x69, 0x52, 0x04, 0x61, 0x70, 0x69, 0x73, 0x22, 0x96, 0x01, 0x0a, 0x06, 0x4d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x50, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x67, 0x65, 0x6e,
	0x2e, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x22, 0x45, 0x0a, 0x07, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x73, 0x68, 0x6f, 0x72, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x66,
	0x75, 0x6c, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x66, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x2f, 0x0a, 0x03, 0x41, 0x70, 0x69, 0x12,
	0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12,
	0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2a, 0xef, 0x01, 0x0a, 0x08, 0x4c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x18, 0x0a, 0x14, 0x4c, 0x41, 0x4e, 0x47, 0x55, 0x41,
	0x47, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0f, 0x0a, 0x0b, 0x43, 0x5f, 0x50, 0x4c, 0x55, 0x53, 0x5f, 0x50, 0x4c, 0x55, 0x53, 0x10,
	0x01, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x5f, 0x53, 0x48, 0x41, 0x52, 0x50, 0x10, 0x02, 0x12, 0x08,
	0x0a, 0x04, 0x44, 0x41, 0x52, 0x54, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x45, 0x4c, 0x49, 0x58,
	0x49, 0x52, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x45, 0x52, 0x4c, 0x41, 0x4e, 0x47, 0x10, 0x05,
	0x12, 0x0b, 0x0a, 0x07, 0x46, 0x5f, 0x53, 0x48, 0x41, 0x52, 0x50, 0x10, 0x06, 0x12, 0x06, 0x0a,
	0x02, 0x47, 0x4f, 0x10, 0x07, 0x12, 0x08, 0x0a, 0x04, 0x4a, 0x41, 0x56, 0x41, 0x10, 0x08, 0x12,
	0x0e, 0x0a, 0x0a, 0x4a, 0x41, 0x56, 0x41, 0x53, 0x43, 0x52, 0x49, 0x50, 0x54, 0x10, 0x09, 0x12,
	0x0a, 0x0a, 0x06, 0x4b, 0x4f, 0x54, 0x4c, 0x49, 0x4e, 0x10, 0x0a, 0x12, 0x07, 0x0a, 0x03, 0x50,
	0x48, 0x50, 0x10, 0x0b, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x59, 0x54, 0x48, 0x4f, 0x4e, 0x10, 0x0c,
	0x12, 0x08, 0x0a, 0x04, 0x52, 0x55, 0x42, 0x59, 0x10, 0x0d, 0x12, 0x08, 0x0a, 0x04, 0x52, 0x55,
	0x53, 0x54, 0x10, 0x0e, 0x12, 0x09, 0x0a, 0x05, 0x53, 0x57, 0x49, 0x46, 0x54, 0x10, 0x0f, 0x12,
	0x0e, 0x0a, 0x0a, 0x54, 0x59, 0x50, 0x45, 0x53, 0x43, 0x52, 0x49, 0x50, 0x54, 0x10, 0x10, 0x12,
	0x0a, 0x0a, 0x06, 0x56, 0x42, 0x5f, 0x4e, 0x45, 0x54, 0x10, 0x11, 0x42, 0xda, 0x01, 0x5a, 0x43,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2f, 0x67, 0x61, 0x70,
	0x69, 0x63, 0x67, 0x65, 0x6e, 0x2f, 0x67, 0x65, 0x6e, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74,
	0x73, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x3b, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xaa, 0x02, 0x2d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74,
	0x47, 0x65, 0x6e, 0x2e, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x56, 0x31, 0xca, 0x02, 0x2d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x5c, 0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x5c, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74,
	0x47, 0x65, 0x6e, 0x5c, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x5c, 0x56, 0x31, 0xea, 0x02, 0x32, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x3a, 0x3a, 0x53, 0x6e, 0x69, 0x70,
	0x70, 0x65, 0x74, 0x47, 0x65, 0x6e, 0x3a, 0x3a, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_metadata_metadata_proto_rawDescOnce sync.Once
	file_metadata_metadata_proto_rawDescData = file_metadata_metadata_proto_rawDesc
)

func file_metadata_metadata_proto_rawDescGZIP() []byte {
	file_metadata_metadata_proto_rawDescOnce.Do(func() {
		file_metadata_metadata_proto_rawDescData = protoimpl.X.CompressGZIP(file_metadata_metadata_proto_rawDescData)
	})
	return file_metadata_metadata_proto_rawDescData
}

var file_metadata_metadata_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_metadata_metadata_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_metadata_metadata_proto_goTypes = []interface{}{
	(Language)(0),                    // 0: google.cloud.tools.snippetgen.snippetindex.v1.Language
	(Snippet_Origin)(0),              // 1: google.cloud.tools.snippetgen.snippetindex.v1.Snippet.Origin
	(Snippet_Segment_SegmentType)(0), // 2: google.cloud.tools.snippetgen.snippetindex.v1.Snippet.Segment.SegmentType
	(*Index)(nil),                    // 3: google.cloud.tools.snippetgen.snippetindex.v1.Index
	(*Snippet)(nil),                  // 4: google.cloud.tools.snippetgen.snippetindex.v1.Snippet
	(*ClientMethod)(nil),             // 5: google.cloud.tools.snippetgen.snippetindex.v1.ClientMethod
	(*ServiceClient)(nil),            // 6: google.cloud.tools.snippetgen.snippetindex.v1.ServiceClient
	(*ClientLibrary)(nil),            // 7: google.cloud.tools.snippetgen.snippetindex.v1.ClientLibrary
	(*Method)(nil),                   // 8: google.cloud.tools.snippetgen.snippetindex.v1.Method
	(*Service)(nil),                  // 9: google.cloud.tools.snippetgen.snippetindex.v1.Service
	(*Api)(nil),                      // 10: google.cloud.tools.snippetgen.snippetindex.v1.Api
	(*Snippet_Segment)(nil),          // 11: google.cloud.tools.snippetgen.snippetindex.v1.Snippet.Segment
	(*ClientMethod_Parameter)(nil),   // 12: google.cloud.tools.snippetgen.snippetindex.v1.ClientMethod.Parameter
}
var file_metadata_metadata_proto_depIdxs = []int32{
	7,  // 0: google.cloud.tools.snippetgen.snippetindex.v1.Index.client_library:type_name -> google.cloud.tools.snippetgen.snippetindex.v1.ClientLibrary
	4,  // 1: google.cloud.tools.snippetgen.snippetindex.v1.Index.snippets:type_name -> google.cloud.tools.snippetgen.snippetindex.v1.Snippet
	0,  // 2: google.cloud.tools.snippetgen.snippetindex.v1.Snippet.language:type_name -> google.cloud.tools.snippetgen.snippetindex.v1.Language
	5,  // 3: google.cloud.tools.snippetgen.snippetindex.v1.Snippet.client_method:type_name -> google.cloud.tools.snippetgen.snippetindex.v1.ClientMethod
	1,  // 4: google.cloud.tools.snippetgen.snippetindex.v1.Snippet.origin:type_name -> google.cloud.tools.snippetgen.snippetindex.v1.Snippet.Origin
	11, // 5: google.cloud.tools.snippetgen.snippetindex.v1.Snippet.segments:type_name -> google.cloud.tools.snippetgen.snippetindex.v1.Snippet.Segment
	12, // 6: google.cloud.tools.snippetgen.snippetindex.v1.ClientMethod.parameters:type_name -> google.cloud.tools.snippetgen.snippetindex.v1.ClientMethod.Parameter
	6,  // 7: google.cloud.tools.snippetgen.snippetindex.v1.ClientMethod.client:type_name -> google.cloud.tools.snippetgen.snippetindex.v1.ServiceClient
	8,  // 8: google.cloud.tools.snippetgen.snippetindex.v1.ClientMethod.method:type_name -> google.cloud.tools.snippetgen.snippetindex.v1.Method
	0,  // 9: google.cloud.tools.snippetgen.snippetindex.v1.ClientLibrary.language:type_name -> google.cloud.tools.snippetgen.snippetindex.v1.Language
	10, // 10: google.cloud.tools.snippetgen.snippetindex.v1.ClientLibrary.apis:type_name -> google.cloud.tools.snippetgen.snippetindex.v1.Api
	9,  // 11: google.cloud.tools.snippetgen.snippetindex.v1.Method.service:type_name -> google.cloud.tools.snippetgen.snippetindex.v1.Service
	2,  // 12: google.cloud.tools.snippetgen.snippetindex.v1.Snippet.Segment.type:type_name -> google.cloud.tools.snippetgen.snippetindex.v1.Snippet.Segment.SegmentType
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_metadata_metadata_proto_init() }
func file_metadata_metadata_proto_init() {
	if File_metadata_metadata_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_metadata_metadata_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Index); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metadata_metadata_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Snippet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metadata_metadata_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClientMethod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metadata_metadata_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceClient); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metadata_metadata_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClientLibrary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metadata_metadata_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Method); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metadata_metadata_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Service); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metadata_metadata_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Api); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metadata_metadata_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Snippet_Segment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metadata_metadata_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClientMethod_Parameter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_metadata_metadata_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_metadata_metadata_proto_goTypes,
		DependencyIndexes: file_metadata_metadata_proto_depIdxs,
		EnumInfos:         file_metadata_metadata_proto_enumTypes,
		MessageInfos:      file_metadata_metadata_proto_msgTypes,
	}.Build()
	File_metadata_metadata_proto = out.File
	file_metadata_metadata_proto_rawDesc = nil
	file_metadata_metadata_proto_goTypes = nil
	file_metadata_metadata_proto_depIdxs = nil
}
