// Copyright 2021 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package recaptchaenterprise provides access to the reCAPTCHA Enterprise API.
//
// For product documentation, see: https://cloud.google.com/recaptcha-enterprise/
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/recaptchaenterprise/v1"
//   ...
//   ctx := context.Background()
//   recaptchaenterpriseService, err := recaptchaenterprise.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   recaptchaenterpriseService, err := recaptchaenterprise.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   recaptchaenterpriseService, err := recaptchaenterprise.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package recaptchaenterprise // import "google.golang.org/api/recaptchaenterprise/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "recaptchaenterprise:v1"
const apiName = "recaptchaenterprise"
const apiVersion = "v1"
const basePath = "https://recaptchaenterprise.googleapis.com/"
const mtlsBasePath = "https://recaptchaenterprise.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := option.WithScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Assessments = NewProjectsAssessmentsService(s)
	rs.Keys = NewProjectsKeysService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Assessments *ProjectsAssessmentsService

	Keys *ProjectsKeysService
}

func NewProjectsAssessmentsService(s *Service) *ProjectsAssessmentsService {
	rs := &ProjectsAssessmentsService{s: s}
	return rs
}

type ProjectsAssessmentsService struct {
	s *Service
}

func NewProjectsKeysService(s *Service) *ProjectsKeysService {
	rs := &ProjectsKeysService{s: s}
	return rs
}

type ProjectsKeysService struct {
	s *Service
}

// GoogleCloudRecaptchaenterpriseV1AndroidKeySettings: Settings specific
// to keys that can be used by Android apps.
type GoogleCloudRecaptchaenterpriseV1AndroidKeySettings struct {
	// AllowAllPackageNames: If set to true, allowed_package_names are not
	// enforced.
	AllowAllPackageNames bool `json:"allowAllPackageNames,omitempty"`

	// AllowedPackageNames: Android package names of apps allowed to use the
	// key. Example: 'com.companyname.appname'
	AllowedPackageNames []string `json:"allowedPackageNames,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AllowAllPackageNames") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowAllPackageNames") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecaptchaenterpriseV1AndroidKeySettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecaptchaenterpriseV1AndroidKeySettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecaptchaenterpriseV1AnnotateAssessmentRequest: The
// request message to annotate an Assessment.
type GoogleCloudRecaptchaenterpriseV1AnnotateAssessmentRequest struct {
	// Annotation: Optional. The annotation that will be assigned to the
	// Event. This field can be left empty to provide reasons that apply to
	// an event without concluding whether the event is legitimate or
	// fraudulent.
	//
	// Possible values:
	//   "ANNOTATION_UNSPECIFIED" - Default unspecified type.
	//   "LEGITIMATE" - Provides information that the event turned out to be
	// legitimate.
	//   "FRAUDULENT" - Provides information that the event turned out to be
	// fraudulent.
	//   "PASSWORD_CORRECT" - Provides information that the event was
	// related to a login event in which the user typed the correct
	// password. Deprecated, prefer indicating CORRECT_PASSWORD through the
	// reasons field instead.
	//   "PASSWORD_INCORRECT" - Provides information that the event was
	// related to a login event in which the user typed the incorrect
	// password. Deprecated, prefer indicating INCORRECT_PASSWORD through
	// the reasons field instead.
	Annotation string `json:"annotation,omitempty"`

	// Reasons: Optional. Optional reasons for the annotation that will be
	// assigned to the Event.
	//
	// Possible values:
	//   "REASON_UNSPECIFIED" - Default unspecified reason.
	//   "CHARGEBACK" - Indicates a chargeback for fraud was issued for the
	// transaction associated with the assessment.
	//   "PAYMENT_HEURISTICS" - Indicates the transaction associated with
	// the assessment is suspected of being fraudulent based on the payment
	// method, billing details, shipping address or other transaction
	// information.
	//   "INITIATED_TWO_FACTOR" - Indicates that the user was served a 2FA
	// challenge. An old assessment with `ENUM_VALUES.INITIATED_TWO_FACTOR`
	// reason that has not been overwritten with `PASSED_TWO_FACTOR` is
	// treated as an abandoned 2FA flow. This is equivalent to
	// `FAILED_TWO_FACTOR`.
	//   "PASSED_TWO_FACTOR" - Indicates that the user passed a 2FA
	// challenge.
	//   "FAILED_TWO_FACTOR" - Indicates that the user failed a 2FA
	// challenge.
	//   "CORRECT_PASSWORD" - Indicates the user provided the correct
	// password.
	//   "INCORRECT_PASSWORD" - Indicates the user provided an incorrect
	// password.
	Reasons []string `json:"reasons,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Annotation") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Annotation") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecaptchaenterpriseV1AnnotateAssessmentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecaptchaenterpriseV1AnnotateAssessmentRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecaptchaenterpriseV1AnnotateAssessmentResponse: Empty
// response for AnnotateAssessment.
type GoogleCloudRecaptchaenterpriseV1AnnotateAssessmentResponse struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleCloudRecaptchaenterpriseV1Assessment: A recaptcha assessment
// resource.
type GoogleCloudRecaptchaenterpriseV1Assessment struct {
	// Event: The event being assessed.
	Event *GoogleCloudRecaptchaenterpriseV1Event `json:"event,omitempty"`

	// Name: Output only. The resource name for the Assessment in the format
	// "projects/{project}/assessments/{assessment}".
	Name string `json:"name,omitempty"`

	// RiskAnalysis: Output only. The risk analysis result for the event
	// being assessed.
	RiskAnalysis *GoogleCloudRecaptchaenterpriseV1RiskAnalysis `json:"riskAnalysis,omitempty"`

	// TokenProperties: Output only. Properties of the provided event token.
	TokenProperties *GoogleCloudRecaptchaenterpriseV1TokenProperties `json:"tokenProperties,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Event") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Event") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecaptchaenterpriseV1Assessment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecaptchaenterpriseV1Assessment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecaptchaenterpriseV1ChallengeMetrics: Metrics related to
// challenges.
type GoogleCloudRecaptchaenterpriseV1ChallengeMetrics struct {
	// FailedCount: Count of submitted challenge solutions that were
	// incorrect or otherwise deemed suspicious such that a subsequent
	// challenge was triggered.
	FailedCount int64 `json:"failedCount,omitempty,string"`

	// NocaptchaCount: Count of nocaptchas (successful verification without
	// a challenge) issued.
	NocaptchaCount int64 `json:"nocaptchaCount,omitempty,string"`

	// PageloadCount: Count of reCAPTCHA checkboxes or badges rendered. This
	// is mostly equivalent to a count of pageloads for pages that include
	// reCAPTCHA.
	PageloadCount int64 `json:"pageloadCount,omitempty,string"`

	// PassedCount: Count of nocaptchas (successful verification without a
	// challenge) plus submitted challenge solutions that were correct and
	// resulted in verification.
	PassedCount int64 `json:"passedCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "FailedCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FailedCount") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecaptchaenterpriseV1ChallengeMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecaptchaenterpriseV1ChallengeMetrics
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudRecaptchaenterpriseV1Event struct {
	// ExpectedAction: Optional. The expected action for this type of event.
	// This should be the same action provided at token generation time on
	// client-side platforms already integrated with recaptcha enterprise.
	ExpectedAction string `json:"expectedAction,omitempty"`

	// SiteKey: Optional. The site key that was used to invoke reCAPTCHA on
	// your site and generate the token.
	SiteKey string `json:"siteKey,omitempty"`

	// Token: Optional. The user response token provided by the reCAPTCHA
	// client-side integration on your site.
	Token string `json:"token,omitempty"`

	// UserAgent: Optional. The user agent present in the request from the
	// user's device related to this event.
	UserAgent string `json:"userAgent,omitempty"`

	// UserIpAddress: Optional. The IP address in the request from the
	// user's device related to this event.
	UserIpAddress string `json:"userIpAddress,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExpectedAction") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExpectedAction") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecaptchaenterpriseV1Event) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecaptchaenterpriseV1Event
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecaptchaenterpriseV1IOSKeySettings: Settings specific to
// keys that can be used by iOS apps.
type GoogleCloudRecaptchaenterpriseV1IOSKeySettings struct {
	// AllowAllBundleIds: If set to true, allowed_bundle_ids are not
	// enforced.
	AllowAllBundleIds bool `json:"allowAllBundleIds,omitempty"`

	// AllowedBundleIds: iOS bundle ids of apps allowed to use the key.
	// Example: 'com.companyname.productname.appname'
	AllowedBundleIds []string `json:"allowedBundleIds,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllowAllBundleIds")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowAllBundleIds") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecaptchaenterpriseV1IOSKeySettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecaptchaenterpriseV1IOSKeySettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecaptchaenterpriseV1Key: A key used to identify and
// configure applications (web and/or mobile) that use reCAPTCHA
// Enterprise.
type GoogleCloudRecaptchaenterpriseV1Key struct {
	// AndroidSettings: Settings for keys that can be used by Android apps.
	AndroidSettings *GoogleCloudRecaptchaenterpriseV1AndroidKeySettings `json:"androidSettings,omitempty"`

	// CreateTime: The timestamp corresponding to the creation of this Key.
	CreateTime string `json:"createTime,omitempty"`

	// DisplayName: Human-readable display name of this key. Modifiable by
	// user.
	DisplayName string `json:"displayName,omitempty"`

	// IosSettings: Settings for keys that can be used by iOS apps.
	IosSettings *GoogleCloudRecaptchaenterpriseV1IOSKeySettings `json:"iosSettings,omitempty"`

	// Labels: See Creating and managing labels.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: The resource name for the Key in the format
	// "projects/{project}/keys/{key}".
	Name string `json:"name,omitempty"`

	// TestingOptions: Options for user acceptance testing.
	TestingOptions *GoogleCloudRecaptchaenterpriseV1TestingOptions `json:"testingOptions,omitempty"`

	// WebSettings: Settings for keys that can be used by websites.
	WebSettings *GoogleCloudRecaptchaenterpriseV1WebKeySettings `json:"webSettings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AndroidSettings") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AndroidSettings") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecaptchaenterpriseV1Key) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecaptchaenterpriseV1Key
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecaptchaenterpriseV1ListKeysResponse: Response to request
// to list keys in a project.
type GoogleCloudRecaptchaenterpriseV1ListKeysResponse struct {
	// Keys: Key details.
	Keys []*GoogleCloudRecaptchaenterpriseV1Key `json:"keys,omitempty"`

	// NextPageToken: Token to retrieve the next page of results. It is set
	// to empty if no keys remain in results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Keys") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Keys") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecaptchaenterpriseV1ListKeysResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecaptchaenterpriseV1ListKeysResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecaptchaenterpriseV1Metrics: Metrics for a single Key.
type GoogleCloudRecaptchaenterpriseV1Metrics struct {
	// ChallengeMetrics: Metrics will be continuous and in order by dates,
	// and in the granularity of day. Only challenge-based keys (CHECKBOX,
	// INVISIBLE), will have challenge-based data.
	ChallengeMetrics []*GoogleCloudRecaptchaenterpriseV1ChallengeMetrics `json:"challengeMetrics,omitempty"`

	// Name: Output only. The name of the metrics, in the format
	// "projects/{project}/keys/{key}/metrics".
	Name string `json:"name,omitempty"`

	// ScoreMetrics: Metrics will be continuous and in order by dates, and
	// in the granularity of day. All Key types should have score-based
	// data.
	ScoreMetrics []*GoogleCloudRecaptchaenterpriseV1ScoreMetrics `json:"scoreMetrics,omitempty"`

	// StartTime: Inclusive start time aligned to a day (UTC).
	StartTime string `json:"startTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ChallengeMetrics") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ChallengeMetrics") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecaptchaenterpriseV1Metrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecaptchaenterpriseV1Metrics
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecaptchaenterpriseV1MigrateKeyRequest: The migrate key
// request message.
type GoogleCloudRecaptchaenterpriseV1MigrateKeyRequest struct {
}

// GoogleCloudRecaptchaenterpriseV1RiskAnalysis: Risk analysis result
// for an event.
type GoogleCloudRecaptchaenterpriseV1RiskAnalysis struct {
	// Reasons: Reasons contributing to the risk analysis verdict.
	//
	// Possible values:
	//   "CLASSIFICATION_REASON_UNSPECIFIED" - Default unspecified type.
	//   "AUTOMATION" - Interactions matched the behavior of an automated
	// agent.
	//   "UNEXPECTED_ENVIRONMENT" - The event originated from an
	// illegitimate environment.
	//   "TOO_MUCH_TRAFFIC" - Traffic volume from the event source is higher
	// than normal.
	//   "UNEXPECTED_USAGE_PATTERNS" - Interactions with the site were
	// significantly different than expected patterns.
	//   "LOW_CONFIDENCE_SCORE" - Too little traffic has been received from
	// this site thus far to generate quality risk analysis.
	Reasons []string `json:"reasons,omitempty"`

	// Score: Legitimate event score from 0.0 to 1.0. (1.0 means very likely
	// legitimate traffic while 0.0 means very likely non-legitimate
	// traffic).
	Score float64 `json:"score,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Reasons") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Reasons") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecaptchaenterpriseV1RiskAnalysis) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecaptchaenterpriseV1RiskAnalysis
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudRecaptchaenterpriseV1RiskAnalysis) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudRecaptchaenterpriseV1RiskAnalysis
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudRecaptchaenterpriseV1ScoreDistribution: Score
// distribution.
type GoogleCloudRecaptchaenterpriseV1ScoreDistribution struct {
	// ScoreBuckets: Map key is score value multiplied by 100. The scores
	// are discrete values between [0, 1]. The maximum number of buckets is
	// on order of a few dozen, but typically much lower (ie. 10).
	ScoreBuckets map[string]string `json:"scoreBuckets,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ScoreBuckets") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ScoreBuckets") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecaptchaenterpriseV1ScoreDistribution) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecaptchaenterpriseV1ScoreDistribution
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecaptchaenterpriseV1ScoreMetrics: Metrics related to
// scoring.
type GoogleCloudRecaptchaenterpriseV1ScoreMetrics struct {
	// ActionMetrics: Action-based metrics. The map key is the action name
	// which specified by the site owners at time of the "execute"
	// client-side call. Populated only for SCORE keys.
	ActionMetrics map[string]GoogleCloudRecaptchaenterpriseV1ScoreDistribution `json:"actionMetrics,omitempty"`

	// OverallMetrics: Aggregated score metrics for all traffic.
	OverallMetrics *GoogleCloudRecaptchaenterpriseV1ScoreDistribution `json:"overallMetrics,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ActionMetrics") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActionMetrics") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecaptchaenterpriseV1ScoreMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecaptchaenterpriseV1ScoreMetrics
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecaptchaenterpriseV1TestingOptions: Options for user
// acceptance testing.
type GoogleCloudRecaptchaenterpriseV1TestingOptions struct {
	// TestingChallenge: For challenge-based keys only (CHECKBOX,
	// INVISIBLE), all challenge requests for this site will return
	// nocaptcha if NOCAPTCHA, or an unsolvable challenge if CHALLENGE.
	//
	// Possible values:
	//   "TESTING_CHALLENGE_UNSPECIFIED" - Perform the normal risk analysis
	// and return either nocaptcha or a challenge depending on risk and
	// trust factors.
	//   "NOCAPTCHA" - Challenge requests for this key always return a
	// nocaptcha, which does not require a solution.
	//   "UNSOLVABLE_CHALLENGE" - Challenge requests for this key always
	// return an unsolvable challenge.
	TestingChallenge string `json:"testingChallenge,omitempty"`

	// TestingScore: All assessments for this Key will return this score.
	// Must be between 0 (likely not legitimate) and 1 (likely legitimate)
	// inclusive.
	TestingScore float64 `json:"testingScore,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TestingChallenge") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TestingChallenge") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecaptchaenterpriseV1TestingOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecaptchaenterpriseV1TestingOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudRecaptchaenterpriseV1TestingOptions) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudRecaptchaenterpriseV1TestingOptions
	var s1 struct {
		TestingScore gensupport.JSONFloat64 `json:"testingScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.TestingScore = float64(s1.TestingScore)
	return nil
}

type GoogleCloudRecaptchaenterpriseV1TokenProperties struct {
	// Action: Action name provided at token generation.
	Action string `json:"action,omitempty"`

	// CreateTime: The timestamp corresponding to the generation of the
	// token.
	CreateTime string `json:"createTime,omitempty"`

	// Hostname: The hostname of the page on which the token was generated.
	Hostname string `json:"hostname,omitempty"`

	// InvalidReason: Reason associated with the response when valid =
	// false.
	//
	// Possible values:
	//   "INVALID_REASON_UNSPECIFIED" - Default unspecified type.
	//   "UNKNOWN_INVALID_REASON" - If the failure reason was not accounted
	// for.
	//   "MALFORMED" - The provided user verification token was malformed.
	//   "EXPIRED" - The user verification token had expired.
	//   "DUPE" - The user verification had already been seen.
	//   "MISSING" - The user verification token was not present.
	//   "BROWSER_ERROR" - A retriable error (such as network failure)
	// occurred on the browser. Could easily be simulated by an attacker.
	InvalidReason string `json:"invalidReason,omitempty"`

	// Valid: Whether the provided user response token is valid. When valid
	// = false, the reason could be specified in invalid_reason or it could
	// also be due to a user failing to solve a challenge or a sitekey
	// mismatch (i.e the sitekey used to generate the token was different
	// than the one specified in the assessment).
	Valid bool `json:"valid,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Action") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecaptchaenterpriseV1TokenProperties) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecaptchaenterpriseV1TokenProperties
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecaptchaenterpriseV1WebKeySettings: Settings specific to
// keys that can be used by websites.
type GoogleCloudRecaptchaenterpriseV1WebKeySettings struct {
	// AllowAllDomains: If set to true, it means allowed_domains will not be
	// enforced.
	AllowAllDomains bool `json:"allowAllDomains,omitempty"`

	// AllowAmpTraffic: If set to true, the key can be used on AMP
	// (Accelerated Mobile Pages) websites. This is supported only for the
	// SCORE integration type.
	AllowAmpTraffic bool `json:"allowAmpTraffic,omitempty"`

	// AllowedDomains: Domains or subdomains of websites allowed to use the
	// key. All subdomains of an allowed domain are automatically allowed. A
	// valid domain requires a host and must not include any path, port,
	// query or fragment. Examples: 'example.com' or 'subdomain.example.com'
	AllowedDomains []string `json:"allowedDomains,omitempty"`

	// ChallengeSecurityPreference: Settings for the frequency and
	// difficulty at which this key triggers captcha challenges. This should
	// only be specified for IntegrationTypes CHECKBOX and INVISIBLE.
	//
	// Possible values:
	//   "CHALLENGE_SECURITY_PREFERENCE_UNSPECIFIED" - Default type that
	// indicates this enum hasn't been specified.
	//   "USABILITY" - Key tends to show fewer and easier challenges.
	//   "BALANCE" - Key tends to show balanced (in amount and difficulty)
	// challenges.
	//   "SECURITY" - Key tends to show more and harder challenges.
	ChallengeSecurityPreference string `json:"challengeSecurityPreference,omitempty"`

	// IntegrationType: Required. Describes how this key is integrated with
	// the website.
	//
	// Possible values:
	//   "INTEGRATION_TYPE_UNSPECIFIED" - Default type that indicates this
	// enum hasn't been specified. This is not a valid IntegrationType, one
	// of the other types must be specified instead.
	//   "SCORE" - Only used to produce scores. It doesn't display the "I'm
	// not a robot" checkbox and never shows captcha challenges.
	//   "CHECKBOX" - Displays the "I'm not a robot" checkbox and may show
	// captcha challenges after it is checked.
	//   "INVISIBLE" - Doesn't display the "I'm not a robot" checkbox, but
	// may show captcha challenges after risk analysis.
	IntegrationType string `json:"integrationType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllowAllDomains") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowAllDomains") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecaptchaenterpriseV1WebKeySettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecaptchaenterpriseV1WebKeySettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to
// avoid defining duplicated empty messages in your APIs. A typical
// example is to use it as the request or the response type of an API
// method. For instance: service Foo { rpc Bar(google.protobuf.Empty)
// returns (google.protobuf.Empty); } The JSON representation for
// `Empty` is empty JSON object `{}`.
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// method id "recaptchaenterprise.projects.assessments.annotate":

type ProjectsAssessmentsAnnotateCall struct {
	s                                                         *Service
	name                                                      string
	googlecloudrecaptchaenterprisev1annotateassessmentrequest *GoogleCloudRecaptchaenterpriseV1AnnotateAssessmentRequest
	urlParams_                                                gensupport.URLParams
	ctx_                                                      context.Context
	header_                                                   http.Header
}

// Annotate: Annotates a previously created Assessment to provide
// additional information on whether the event turned out to be
// authentic or fraudulent.
//
// - name: The resource name of the Assessment, in the format
//   "projects/{project}/assessments/{assessment}".
func (r *ProjectsAssessmentsService) Annotate(name string, googlecloudrecaptchaenterprisev1annotateassessmentrequest *GoogleCloudRecaptchaenterpriseV1AnnotateAssessmentRequest) *ProjectsAssessmentsAnnotateCall {
	c := &ProjectsAssessmentsAnnotateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudrecaptchaenterprisev1annotateassessmentrequest = googlecloudrecaptchaenterprisev1annotateassessmentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAssessmentsAnnotateCall) Fields(s ...googleapi.Field) *ProjectsAssessmentsAnnotateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAssessmentsAnnotateCall) Context(ctx context.Context) *ProjectsAssessmentsAnnotateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAssessmentsAnnotateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAssessmentsAnnotateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211027")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudrecaptchaenterprisev1annotateassessmentrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:annotate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recaptchaenterprise.projects.assessments.annotate" call.
// Exactly one of
// *GoogleCloudRecaptchaenterpriseV1AnnotateAssessmentResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudRecaptchaenterpriseV1AnnotateAssessmentResponse.ServerResp
// onse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAssessmentsAnnotateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecaptchaenterpriseV1AnnotateAssessmentResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecaptchaenterpriseV1AnnotateAssessmentResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Annotates a previously created Assessment to provide additional information on whether the event turned out to be authentic or fraudulent.",
	//   "flatPath": "v1/projects/{projectsId}/assessments/{assessmentsId}:annotate",
	//   "httpMethod": "POST",
	//   "id": "recaptchaenterprise.projects.assessments.annotate",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the Assessment, in the format \"projects/{project}/assessments/{assessment}\".",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/assessments/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:annotate",
	//   "request": {
	//     "$ref": "GoogleCloudRecaptchaenterpriseV1AnnotateAssessmentRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRecaptchaenterpriseV1AnnotateAssessmentResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recaptchaenterprise.projects.assessments.create":

type ProjectsAssessmentsCreateCall struct {
	s                                          *Service
	parent                                     string
	googlecloudrecaptchaenterprisev1assessment *GoogleCloudRecaptchaenterpriseV1Assessment
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// Create: Creates an Assessment of the likelihood an event is
// legitimate.
//
// - parent: The name of the project in which the assessment will be
//   created, in the format "projects/{project}".
func (r *ProjectsAssessmentsService) Create(parent string, googlecloudrecaptchaenterprisev1assessment *GoogleCloudRecaptchaenterpriseV1Assessment) *ProjectsAssessmentsCreateCall {
	c := &ProjectsAssessmentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudrecaptchaenterprisev1assessment = googlecloudrecaptchaenterprisev1assessment
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAssessmentsCreateCall) Fields(s ...googleapi.Field) *ProjectsAssessmentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAssessmentsCreateCall) Context(ctx context.Context) *ProjectsAssessmentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAssessmentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAssessmentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211027")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudrecaptchaenterprisev1assessment)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/assessments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recaptchaenterprise.projects.assessments.create" call.
// Exactly one of *GoogleCloudRecaptchaenterpriseV1Assessment or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudRecaptchaenterpriseV1Assessment.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAssessmentsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecaptchaenterpriseV1Assessment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecaptchaenterpriseV1Assessment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates an Assessment of the likelihood an event is legitimate.",
	//   "flatPath": "v1/projects/{projectsId}/assessments",
	//   "httpMethod": "POST",
	//   "id": "recaptchaenterprise.projects.assessments.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The name of the project in which the assessment will be created, in the format \"projects/{project}\".",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/assessments",
	//   "request": {
	//     "$ref": "GoogleCloudRecaptchaenterpriseV1Assessment"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRecaptchaenterpriseV1Assessment"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recaptchaenterprise.projects.keys.create":

type ProjectsKeysCreateCall struct {
	s                                   *Service
	parent                              string
	googlecloudrecaptchaenterprisev1key *GoogleCloudRecaptchaenterpriseV1Key
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Create: Creates a new reCAPTCHA Enterprise key.
//
// - parent: The name of the project in which the key will be created,
//   in the format "projects/{project}".
func (r *ProjectsKeysService) Create(parent string, googlecloudrecaptchaenterprisev1key *GoogleCloudRecaptchaenterpriseV1Key) *ProjectsKeysCreateCall {
	c := &ProjectsKeysCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudrecaptchaenterprisev1key = googlecloudrecaptchaenterprisev1key
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsKeysCreateCall) Fields(s ...googleapi.Field) *ProjectsKeysCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsKeysCreateCall) Context(ctx context.Context) *ProjectsKeysCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsKeysCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsKeysCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211027")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudrecaptchaenterprisev1key)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/keys")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recaptchaenterprise.projects.keys.create" call.
// Exactly one of *GoogleCloudRecaptchaenterpriseV1Key or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudRecaptchaenterpriseV1Key.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsKeysCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecaptchaenterpriseV1Key, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecaptchaenterpriseV1Key{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new reCAPTCHA Enterprise key.",
	//   "flatPath": "v1/projects/{projectsId}/keys",
	//   "httpMethod": "POST",
	//   "id": "recaptchaenterprise.projects.keys.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The name of the project in which the key will be created, in the format \"projects/{project}\".",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/keys",
	//   "request": {
	//     "$ref": "GoogleCloudRecaptchaenterpriseV1Key"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRecaptchaenterpriseV1Key"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recaptchaenterprise.projects.keys.delete":

type ProjectsKeysDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified key.
//
// - name: The name of the key to be deleted, in the format
//   "projects/{project}/keys/{key}".
func (r *ProjectsKeysService) Delete(name string) *ProjectsKeysDeleteCall {
	c := &ProjectsKeysDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsKeysDeleteCall) Fields(s ...googleapi.Field) *ProjectsKeysDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsKeysDeleteCall) Context(ctx context.Context) *ProjectsKeysDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsKeysDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsKeysDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211027")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recaptchaenterprise.projects.keys.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsKeysDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes the specified key.",
	//   "flatPath": "v1/projects/{projectsId}/keys/{keysId}",
	//   "httpMethod": "DELETE",
	//   "id": "recaptchaenterprise.projects.keys.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the key to be deleted, in the format \"projects/{project}/keys/{key}\".",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/keys/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recaptchaenterprise.projects.keys.get":

type ProjectsKeysGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the specified key.
//
// - name: The name of the requested key, in the format
//   "projects/{project}/keys/{key}".
func (r *ProjectsKeysService) Get(name string) *ProjectsKeysGetCall {
	c := &ProjectsKeysGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsKeysGetCall) Fields(s ...googleapi.Field) *ProjectsKeysGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsKeysGetCall) IfNoneMatch(entityTag string) *ProjectsKeysGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsKeysGetCall) Context(ctx context.Context) *ProjectsKeysGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsKeysGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsKeysGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211027")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recaptchaenterprise.projects.keys.get" call.
// Exactly one of *GoogleCloudRecaptchaenterpriseV1Key or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudRecaptchaenterpriseV1Key.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsKeysGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecaptchaenterpriseV1Key, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecaptchaenterpriseV1Key{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns the specified key.",
	//   "flatPath": "v1/projects/{projectsId}/keys/{keysId}",
	//   "httpMethod": "GET",
	//   "id": "recaptchaenterprise.projects.keys.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the requested key, in the format \"projects/{project}/keys/{key}\".",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/keys/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudRecaptchaenterpriseV1Key"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recaptchaenterprise.projects.keys.getMetrics":

type ProjectsKeysGetMetricsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetMetrics: Get some aggregated metrics for a Key. This data can be
// used to build dashboards.
//
// - name: The name of the requested metrics, in the format
//   "projects/{project}/keys/{key}/metrics".
func (r *ProjectsKeysService) GetMetrics(name string) *ProjectsKeysGetMetricsCall {
	c := &ProjectsKeysGetMetricsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsKeysGetMetricsCall) Fields(s ...googleapi.Field) *ProjectsKeysGetMetricsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsKeysGetMetricsCall) IfNoneMatch(entityTag string) *ProjectsKeysGetMetricsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsKeysGetMetricsCall) Context(ctx context.Context) *ProjectsKeysGetMetricsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsKeysGetMetricsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsKeysGetMetricsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211027")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recaptchaenterprise.projects.keys.getMetrics" call.
// Exactly one of *GoogleCloudRecaptchaenterpriseV1Metrics or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudRecaptchaenterpriseV1Metrics.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsKeysGetMetricsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecaptchaenterpriseV1Metrics, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecaptchaenterpriseV1Metrics{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get some aggregated metrics for a Key. This data can be used to build dashboards.",
	//   "flatPath": "v1/projects/{projectsId}/keys/{keysId}/metrics",
	//   "httpMethod": "GET",
	//   "id": "recaptchaenterprise.projects.keys.getMetrics",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the requested metrics, in the format \"projects/{project}/keys/{key}/metrics\".",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/keys/[^/]+/metrics$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudRecaptchaenterpriseV1Metrics"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recaptchaenterprise.projects.keys.list":

type ProjectsKeysListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns the list of all keys that belong to a project.
//
// - parent: The name of the project that contains the keys that will be
//   listed, in the format "projects/{project}".
func (r *ProjectsKeysService) List(parent string) *ProjectsKeysListCall {
	c := &ProjectsKeysListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of keys to return. Default is 10. Max limit is 1000.
func (c *ProjectsKeysListCall) PageSize(pageSize int64) *ProjectsKeysListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The
// next_page_token value returned from a previous. ListKeysRequest, if
// any.
func (c *ProjectsKeysListCall) PageToken(pageToken string) *ProjectsKeysListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsKeysListCall) Fields(s ...googleapi.Field) *ProjectsKeysListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsKeysListCall) IfNoneMatch(entityTag string) *ProjectsKeysListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsKeysListCall) Context(ctx context.Context) *ProjectsKeysListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsKeysListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsKeysListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211027")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/keys")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recaptchaenterprise.projects.keys.list" call.
// Exactly one of *GoogleCloudRecaptchaenterpriseV1ListKeysResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudRecaptchaenterpriseV1ListKeysResponse.ServerResponse.Heade
// r or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsKeysListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecaptchaenterpriseV1ListKeysResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecaptchaenterpriseV1ListKeysResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns the list of all keys that belong to a project.",
	//   "flatPath": "v1/projects/{projectsId}/keys",
	//   "httpMethod": "GET",
	//   "id": "recaptchaenterprise.projects.keys.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "Optional. The maximum number of keys to return. Default is 10. Max limit is 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. The next_page_token value returned from a previous. ListKeysRequest, if any.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The name of the project that contains the keys that will be listed, in the format \"projects/{project}\".",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/keys",
	//   "response": {
	//     "$ref": "GoogleCloudRecaptchaenterpriseV1ListKeysResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsKeysListCall) Pages(ctx context.Context, f func(*GoogleCloudRecaptchaenterpriseV1ListKeysResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "recaptchaenterprise.projects.keys.migrate":

type ProjectsKeysMigrateCall struct {
	s                                                 *Service
	name                                              string
	googlecloudrecaptchaenterprisev1migratekeyrequest *GoogleCloudRecaptchaenterpriseV1MigrateKeyRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// Migrate: Migrates an existing key from reCAPTCHA to reCAPTCHA
// Enterprise. Once a key is migrated, it can be used from either
// product. SiteVerify requests are billed as CreateAssessment calls.
// You must be authenticated as one of the current owners of the
// reCAPTCHA Site Key, and your user must have the reCAPTCHA Enterprise
// Admin IAM role in the destination project.
//
// - name: The name of the key to be migrated, in the format
//   "projects/{project}/keys/{key}".
func (r *ProjectsKeysService) Migrate(name string, googlecloudrecaptchaenterprisev1migratekeyrequest *GoogleCloudRecaptchaenterpriseV1MigrateKeyRequest) *ProjectsKeysMigrateCall {
	c := &ProjectsKeysMigrateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudrecaptchaenterprisev1migratekeyrequest = googlecloudrecaptchaenterprisev1migratekeyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsKeysMigrateCall) Fields(s ...googleapi.Field) *ProjectsKeysMigrateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsKeysMigrateCall) Context(ctx context.Context) *ProjectsKeysMigrateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsKeysMigrateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsKeysMigrateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211027")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudrecaptchaenterprisev1migratekeyrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:migrate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recaptchaenterprise.projects.keys.migrate" call.
// Exactly one of *GoogleCloudRecaptchaenterpriseV1Key or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudRecaptchaenterpriseV1Key.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsKeysMigrateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecaptchaenterpriseV1Key, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecaptchaenterpriseV1Key{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Migrates an existing key from reCAPTCHA to reCAPTCHA Enterprise. Once a key is migrated, it can be used from either product. SiteVerify requests are billed as CreateAssessment calls. You must be authenticated as one of the current owners of the reCAPTCHA Site Key, and your user must have the reCAPTCHA Enterprise Admin IAM role in the destination project.",
	//   "flatPath": "v1/projects/{projectsId}/keys/{keysId}:migrate",
	//   "httpMethod": "POST",
	//   "id": "recaptchaenterprise.projects.keys.migrate",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the key to be migrated, in the format \"projects/{project}/keys/{key}\".",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/keys/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:migrate",
	//   "request": {
	//     "$ref": "GoogleCloudRecaptchaenterpriseV1MigrateKeyRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRecaptchaenterpriseV1Key"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recaptchaenterprise.projects.keys.patch":

type ProjectsKeysPatchCall struct {
	s                                   *Service
	name                                string
	googlecloudrecaptchaenterprisev1key *GoogleCloudRecaptchaenterpriseV1Key
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Patch: Updates the specified key.
//
// - name: The resource name for the Key in the format
//   "projects/{project}/keys/{key}".
func (r *ProjectsKeysService) Patch(name string, googlecloudrecaptchaenterprisev1key *GoogleCloudRecaptchaenterpriseV1Key) *ProjectsKeysPatchCall {
	c := &ProjectsKeysPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudrecaptchaenterprisev1key = googlecloudrecaptchaenterprisev1key
	return c
}

// UpdateMask sets the optional parameter "updateMask": The mask to
// control which fields of the key get updated. If the mask is not
// present, all fields will be updated.
func (c *ProjectsKeysPatchCall) UpdateMask(updateMask string) *ProjectsKeysPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsKeysPatchCall) Fields(s ...googleapi.Field) *ProjectsKeysPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsKeysPatchCall) Context(ctx context.Context) *ProjectsKeysPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsKeysPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsKeysPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211027")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudrecaptchaenterprisev1key)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recaptchaenterprise.projects.keys.patch" call.
// Exactly one of *GoogleCloudRecaptchaenterpriseV1Key or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudRecaptchaenterpriseV1Key.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsKeysPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecaptchaenterpriseV1Key, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecaptchaenterpriseV1Key{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the specified key.",
	//   "flatPath": "v1/projects/{projectsId}/keys/{keysId}",
	//   "httpMethod": "PATCH",
	//   "id": "recaptchaenterprise.projects.keys.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name for the Key in the format \"projects/{project}/keys/{key}\".",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/keys/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Optional. The mask to control which fields of the key get updated. If the mask is not present, all fields will be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudRecaptchaenterpriseV1Key"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRecaptchaenterpriseV1Key"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}
