// Copyright 2020 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package cloudcommerceprocurement provides access to the Cloud Commerce Partner Procurement API.
//
// For product documentation, see: https://cloud.google.com/marketplace/docs/partners/
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/cloudcommerceprocurement/v1"
//   ...
//   ctx := context.Background()
//   cloudcommerceprocurementService, err := cloudcommerceprocurement.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   cloudcommerceprocurementService, err := cloudcommerceprocurement.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   cloudcommerceprocurementService, err := cloudcommerceprocurement.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package cloudcommerceprocurement // import "google.golang.org/api/cloudcommerceprocurement/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "cloudcommerceprocurement:v1"
const apiName = "cloudcommerceprocurement"
const apiVersion = "v1"
const basePath = "https://cloudcommerceprocurement.googleapis.com/"
const mtlsBasePath = "https://cloudcommerceprocurement.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// View and manage your data across Google Cloud Platform services
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := option.WithScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Providers = NewProvidersService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Providers *ProvidersService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProvidersService(s *Service) *ProvidersService {
	rs := &ProvidersService{s: s}
	rs.Accounts = NewProvidersAccountsService(s)
	rs.Entitlements = NewProvidersEntitlementsService(s)
	return rs
}

type ProvidersService struct {
	s *Service

	Accounts *ProvidersAccountsService

	Entitlements *ProvidersEntitlementsService
}

func NewProvidersAccountsService(s *Service) *ProvidersAccountsService {
	rs := &ProvidersAccountsService{s: s}
	return rs
}

type ProvidersAccountsService struct {
	s *Service
}

func NewProvidersEntitlementsService(s *Service) *ProvidersEntitlementsService {
	rs := &ProvidersEntitlementsService{s: s}
	return rs
}

type ProvidersEntitlementsService struct {
	s *Service
}

// Account: Represents an account that was established by the customer
// on the service provider's system.
type Account struct {
	// Approvals: Output only. The approvals for this account. These
	// approvals are used to track actions that are permitted or have been
	// completed by a customer within the context of the provider. This
	// might include a sign up flow or a provisioning step, for example,
	// that the provider can admit to having happened.
	Approvals []*Approval `json:"approvals,omitempty"`

	// CreateTime: Output only. The creation timestamp.
	CreateTime string `json:"createTime,omitempty"`

	// InputProperties: Output only. The custom properties that were
	// collected from the user to create this account.
	InputProperties googleapi.RawMessage `json:"inputProperties,omitempty"`

	// Name: Output only. The resource name of the account. Account names
	// have the form `accounts/{account_id}`.
	Name string `json:"name,omitempty"`

	// Provider: Output only. The identifier of the service provider that
	// this account was created against. Each service provider is assigned a
	// unique provider value when they onboard with Cloud Commerce platform.
	Provider string `json:"provider,omitempty"`

	// State: Output only. The state of the account. This is used to decide
	// whether the customer is in good standing with the provider and is
	// able to make purchases. An account might not be able to make a
	// purchase if the billing account is suspended, for example.
	//
	// Possible values:
	//   "ACCOUNT_STATE_UNSPECIFIED" - Sentinel value, do not use.
	//   "ACCOUNT_ACTIVATION_REQUESTED" - The customer has requested the
	// creation of the account resource, and the provider notification
	// message is dispatched. This state has been deprecated, as accounts
	// now immediately transition to AccountState.ACCOUNT_ACTIVE.
	//   "ACCOUNT_ACTIVE" - The account is active and ready for use. The
	// next possible states are: - Account getting deleted: After the user
	// invokes delete from another API.
	State string `json:"state,omitempty"`

	// UpdateTime: Output only. The last update timestamp.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Approvals") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Approvals") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Account) MarshalJSON() ([]byte, error) {
	type NoMethod Account
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Approval: An approval for some action on an account.
type Approval struct {
	// Name: Output only. The name of the approval.
	Name string `json:"name,omitempty"`

	// Reason: Output only. An explanation for the state of the approval.
	Reason string `json:"reason,omitempty"`

	// State: Output only. The state of the approval.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Sentinel value; do not use.
	//   "PENDING" - The approval is pending response from the provider. The
	// approval state can transition to Account.Approval.State.APPROVED or
	// Account.Approval.State.REJECTED.
	//   "APPROVED" - The approval has been granted by the provider.
	//   "REJECTED" - The approval has been rejected by the provider. A
	// provider may choose to approve a previously rejected approval, so is
	// it possible to transition to Account.Approval.State.APPROVED.
	State string `json:"state,omitempty"`

	// UpdateTime: Optional. The last update timestamp of the approval.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Approval) MarshalJSON() ([]byte, error) {
	type NoMethod Approval
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ApproveAccountRequest: Request message for
// PartnerProcurementService.ApproveAccount.
type ApproveAccountRequest struct {
	// ApprovalName: The name of the approval being approved. If absent and
	// there is only one approval possible, that approval will be granted.
	// If absent and there are many approvals possible, the request will
	// fail with a 400 Bad Request. Optional.
	ApprovalName string `json:"approvalName,omitempty"`

	// Properties: Set of properties that should be associated with the
	// account. Optional.
	Properties map[string]string `json:"properties,omitempty"`

	// Reason: Free form text string explaining the approval reason.
	// Optional. Max allowed length: 256 bytes. Longer strings will be
	// truncated.
	Reason string `json:"reason,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApprovalName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApprovalName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ApproveAccountRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ApproveAccountRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ApproveEntitlementPlanChangeRequest: Request message for
// [PartnerProcurementService.ApproveEntitlementPlanChange[].
type ApproveEntitlementPlanChangeRequest struct {
	// PendingPlanName: Name of the pending plan that is being approved.
	// Required.
	PendingPlanName string `json:"pendingPlanName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PendingPlanName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PendingPlanName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ApproveEntitlementPlanChangeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ApproveEntitlementPlanChangeRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ApproveEntitlementRequest: Request message for
// [PartnerProcurementService.ApproveEntitlement[].
type ApproveEntitlementRequest struct {
	// Properties: Set of properties that should be associated with the
	// entitlement. Optional.
	Properties map[string]string `json:"properties,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Properties") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Properties") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ApproveEntitlementRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ApproveEntitlementRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Consumer: A resource using (consuming) this entitlement.
type Consumer struct {
	// Project: A project name with format `projects/`.
	Project string `json:"project,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Project") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Project") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Consumer) MarshalJSON() ([]byte, error) {
	type NoMethod Consumer
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For
// instance: service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); } The JSON representation for `Empty` is
// empty JSON object `{}`.
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// Entitlement: Represents a procured product of a customer. Next Id: 17
type Entitlement struct {
	// Account: Output only. The resource name of the account that this
	// entitlement is based on, if any.
	Account string `json:"account,omitempty"`

	// Consumers: Output only. The resources using this entitlement, if
	// applicable.
	Consumers []*Consumer `json:"consumers,omitempty"`

	// CreateTime: Output only. The creation timestamp.
	CreateTime string `json:"createTime,omitempty"`

	// InputProperties: Output only. The custom properties that were
	// collected from the user to create this entitlement.
	InputProperties googleapi.RawMessage `json:"inputProperties,omitempty"`

	// MessageToUser: Provider-supplied message that is displayed to the end
	// user. Currently this is used to communicate progress and ETA for
	// provisioning. This field can be updated only when a user is waiting
	// for an action from the provider, i.e. entitlement state is
	// EntitlementState.ENTITLEMENT_ACTIVATION_REQUESTED or
	// EntitlementState.ENTITLEMENT_PENDING_PLAN_CHANGE_APPROVAL. This field
	// is cleared automatically when the entitlement state changes.
	MessageToUser string `json:"messageToUser,omitempty"`

	// Name: Output only. The resource name of the entitlement. Entitlement
	// names have the form
	// `providers/{provider_id}/entitlements/{entitlement_id}`.
	Name string `json:"name,omitempty"`

	// NewPendingPlan: Output only. The identifier of the pending new plan.
	// Required if the product has plans and the entitlement has a pending
	// plan change.
	NewPendingPlan string `json:"newPendingPlan,omitempty"`

	// Plan: Output only. The identifier of the plan that was procured.
	// Required if the product has plans.
	Plan string `json:"plan,omitempty"`

	// Product: Output only. The identifier of the entity that was
	// purchased. This may actually represent a product or a quote.
	Product string `json:"product,omitempty"`

	// ProductExternalName: Output only. The identifier of the product that
	// was procured.
	ProductExternalName string `json:"productExternalName,omitempty"`

	// Provider: Output only. The identifier of the service provider that
	// this entitlement was created against. Each service provider is
	// assigned a unique provider value when they onboard with Cloud
	// Commerce platform.
	Provider string `json:"provider,omitempty"`

	// QuoteExternalName: Output only. The identifier of the quote that was
	// used to procure. Empty if the order is not purchased using a quote.
	QuoteExternalName string `json:"quoteExternalName,omitempty"`

	// State: Output only. The state of the entitlement.
	//
	// Possible values:
	//   "ENTITLEMENT_STATE_UNSPECIFIED" - Sentinel value. Do not use.
	//   "ENTITLEMENT_ACTIVATION_REQUESTED" - Indicates that the entitlement
	// is being created and the backend has sent a notification to the
	// provider for the activation approval. If the provider approves, then
	// the entitlement will transition to the
	// EntitlementState.ENTITLEMENT_ACTIVE state. Otherwise, the entitlement
	// will be removed. Plan changes are not allowed in this state. Instead
	// the entitlement is cancelled and re-created with a new plan name.
	//   "ENTITLEMENT_ACTIVE" - Indicates that the entitlement is active.
	// The procured item is now usable and any associated billing events
	// will start occurring. In this state, the customer can decide to
	// cancel the entitlement, which would change the state to
	// EntitlementState.ENTITLEMENT_PENDING_CANCELLATION, and then
	// EntitlementState.ENTITLEMENT_CANCELLED. The user can also request a
	// change of plan, which will transition the state to
	// EntitlementState.ENTITLEMENT_PENDING_PLAN_CHANGE, and then back to
	// EntitlementState.ENTITLEMENT_ACTIVE.
	//   "ENTITLEMENT_PENDING_CANCELLATION" - Indicates that the entitlement
	// was cancelled by the customer. The entitlement typically stays in
	// this state if the entitlement/plan allows use of the underlying
	// resource until the end of the current billing cycle. Once the billing
	// cycle completes, the resource will transition to
	// EntitlementState.ENTITLEMENT_CANCELLED state. The resource cannot be
	// modified during this state.
	//   "ENTITLEMENT_CANCELLED" - Indicates that the entitlement was
	// cancelled. The entitlement can now be deleted.
	//   "ENTITLEMENT_PENDING_PLAN_CHANGE" - Indicates that the entitlement
	// is currently active, but there is a pending plan change that is
	// requested by the customer. The entitlement typically stays in this
	// state, if the entitlement/plan requires the completion of the current
	// billing cycle before the plan can be changed. Once the billing cycle
	// completes, the resource will transition to
	// EntitlementState.ENTITLEMENT_ACTIVE, with its plan changed.
	//   "ENTITLEMENT_PENDING_PLAN_CHANGE_APPROVAL" - Indicates that the
	// entitlement is currently active, but there is a plan change request
	// pending provider approval. If the provider approves the plan change,
	// then the entitlement will transition either to
	// EntitlementState.ENTITLEMENT_ACTIVE or
	// EntitlementState.ENTITLEMENT_PENDING_PLAN_CHANGE depending on whether
	// current plan requires that the billing cycle completes. If the
	// provider rejects the plan change, then the pending plan change
	// request is removed and the entitlement stays in
	// EntitlementState.ENTITLEMENT_ACTIVE state with the old plan.
	//   "ENTITLEMENT_SUSPENDED" - Indicates that the entitlement is
	// suspended either by Google or provider request. This can be triggered
	// for various external reasons (e.g. expiration of credit card on the
	// billing account, violation of terms-of-service of the provider etc.).
	// As such, any remediating action needs to be taken externally, before
	// the entitlement can be activated. This is not yet supported.
	State string `json:"state,omitempty"`

	// SubscriptionEndTime: Output only. End time for the subscription
	// corresponding to this entitlement.
	SubscriptionEndTime string `json:"subscriptionEndTime,omitempty"`

	// UpdateTime: Output only. The last update timestamp.
	UpdateTime string `json:"updateTime,omitempty"`

	// UsageReportingId: Output only. The consumerId to use when reporting
	// usage through the Service Control API. See the consumerId field at
	// [Reporting
	// Metrics](https://cloud.google.com/service-control/reporting-metrics)
	// for more details. This field is present only if the product has
	// usage-based billing configured.
	UsageReportingId string `json:"usageReportingId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Account") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Account") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Entitlement) MarshalJSON() ([]byte, error) {
	type NoMethod Entitlement
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListAccountsResponse: Response message for
// [PartnerProcurementService.ListAccounts[].
type ListAccountsResponse struct {
	// Accounts: The list of accounts in this response.
	Accounts []*Account `json:"accounts,omitempty"`

	// NextPageToken: The token for fetching the next page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Accounts") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Accounts") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListAccountsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAccountsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListEntitlementsResponse: Response message for
// PartnerProcurementService.ListEntitlements.
type ListEntitlementsResponse struct {
	// Entitlements: The list of entitlements in this response.
	Entitlements []*Entitlement `json:"entitlements,omitempty"`

	// NextPageToken: The token for fetching the next page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Entitlements") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entitlements") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListEntitlementsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListEntitlementsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RejectAccountRequest: Request message for
// PartnerProcurementService.RejectAccount.
type RejectAccountRequest struct {
	// ApprovalName: The name of the approval being rejected. If absent and
	// there is only one approval possible, that approval will be rejected.
	// If absent and there are many approvals possible, the request will
	// fail with a 400 Bad Request. Optional.
	ApprovalName string `json:"approvalName,omitempty"`

	// Reason: Free form text string explaining the rejection reason. Max
	// allowed length: 256 bytes. Longer strings will be truncated.
	Reason string `json:"reason,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApprovalName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApprovalName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RejectAccountRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RejectAccountRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RejectEntitlementPlanChangeRequest: Request message for
// PartnerProcurementService.RejectEntitlementPlanChange.
type RejectEntitlementPlanChangeRequest struct {
	// PendingPlanName: Name of the pending plan that is being rejected.
	// Required.
	PendingPlanName string `json:"pendingPlanName,omitempty"`

	// Reason: Free form text string explaining the rejection reason. Max
	// allowed length: 256 bytes. Longer strings will be truncated.
	Reason string `json:"reason,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PendingPlanName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PendingPlanName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *RejectEntitlementPlanChangeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RejectEntitlementPlanChangeRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RejectEntitlementRequest: Request message for
// PartnerProcurementService.RejectEntitlement.
type RejectEntitlementRequest struct {
	// Reason: Free form text string explaining the rejection reason. Max
	// allowed length: 256 bytes. Longer strings will be truncated.
	Reason string `json:"reason,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Reason") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Reason") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RejectEntitlementRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RejectEntitlementRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ResetAccountRequest: Request message for for
// PartnerProcurementService.ResetAccount.
type ResetAccountRequest struct {
}

// SuspendEntitlementRequest: Request message for
// ParterProcurementService.SuspendEntitlement. This is not yet
// supported.
type SuspendEntitlementRequest struct {
	// Reason: A free-form reason string, explaining the reason for
	// suspension request.
	Reason string `json:"reason,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Reason") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Reason") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SuspendEntitlementRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SuspendEntitlementRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "cloudcommerceprocurement.providers.accounts.approve":

type ProvidersAccountsApproveCall struct {
	s                     *Service
	name                  string
	approveaccountrequest *ApproveAccountRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Approve: Grant an approval on an Account.
func (r *ProvidersAccountsService) Approve(name string, approveaccountrequest *ApproveAccountRequest) *ProvidersAccountsApproveCall {
	c := &ProvidersAccountsApproveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.approveaccountrequest = approveaccountrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProvidersAccountsApproveCall) Fields(s ...googleapi.Field) *ProvidersAccountsApproveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProvidersAccountsApproveCall) Context(ctx context.Context) *ProvidersAccountsApproveCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProvidersAccountsApproveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProvidersAccountsApproveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200821")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.approveaccountrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:approve")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudcommerceprocurement.providers.accounts.approve" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProvidersAccountsApproveCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Grant an approval on an Account.",
	//   "flatPath": "v1/providers/{providersId}/accounts/{accountsId}:approve",
	//   "httpMethod": "POST",
	//   "id": "cloudcommerceprocurement.providers.accounts.approve",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the account. Required.",
	//       "location": "path",
	//       "pattern": "^providers/[^/]+/accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:approve",
	//   "request": {
	//     "$ref": "ApproveAccountRequest"
	//   },
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudcommerceprocurement.providers.accounts.get":

type ProvidersAccountsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get a requested Account resource.
func (r *ProvidersAccountsService) Get(name string) *ProvidersAccountsGetCall {
	c := &ProvidersAccountsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProvidersAccountsGetCall) Fields(s ...googleapi.Field) *ProvidersAccountsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProvidersAccountsGetCall) IfNoneMatch(entityTag string) *ProvidersAccountsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProvidersAccountsGetCall) Context(ctx context.Context) *ProvidersAccountsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProvidersAccountsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProvidersAccountsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200821")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudcommerceprocurement.providers.accounts.get" call.
// Exactly one of *Account or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Account.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProvidersAccountsGetCall) Do(opts ...googleapi.CallOption) (*Account, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Account{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get a requested Account resource.",
	//   "flatPath": "v1/providers/{providersId}/accounts/{accountsId}",
	//   "httpMethod": "GET",
	//   "id": "cloudcommerceprocurement.providers.accounts.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the account to retrieve.",
	//       "location": "path",
	//       "pattern": "^providers/[^/]+/accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Account"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudcommerceprocurement.providers.accounts.list":

type ProvidersAccountsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List Accounts that the provider has access to.
func (r *ProvidersAccountsService) List(parent string) *ProvidersAccountsListCall {
	c := &ProvidersAccountsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of entries that are requested. Default size is 200.
func (c *ProvidersAccountsListCall) PageSize(pageSize int64) *ProvidersAccountsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The token for
// fetching the next page.
func (c *ProvidersAccountsListCall) PageToken(pageToken string) *ProvidersAccountsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProvidersAccountsListCall) Fields(s ...googleapi.Field) *ProvidersAccountsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProvidersAccountsListCall) IfNoneMatch(entityTag string) *ProvidersAccountsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProvidersAccountsListCall) Context(ctx context.Context) *ProvidersAccountsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProvidersAccountsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProvidersAccountsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200821")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/accounts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudcommerceprocurement.providers.accounts.list" call.
// Exactly one of *ListAccountsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListAccountsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProvidersAccountsListCall) Do(opts ...googleapi.CallOption) (*ListAccountsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListAccountsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "List Accounts that the provider has access to.",
	//   "flatPath": "v1/providers/{providersId}/accounts",
	//   "httpMethod": "GET",
	//   "id": "cloudcommerceprocurement.providers.accounts.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of entries that are requested. Default size is 200.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The token for fetching the next page.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "The parent resource name.",
	//       "location": "path",
	//       "pattern": "^providers/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/accounts",
	//   "response": {
	//     "$ref": "ListAccountsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProvidersAccountsListCall) Pages(ctx context.Context, f func(*ListAccountsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "cloudcommerceprocurement.providers.accounts.reject":

type ProvidersAccountsRejectCall struct {
	s                    *Service
	name                 string
	rejectaccountrequest *RejectAccountRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Reject: Reject an approval on an Account.
func (r *ProvidersAccountsService) Reject(name string, rejectaccountrequest *RejectAccountRequest) *ProvidersAccountsRejectCall {
	c := &ProvidersAccountsRejectCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.rejectaccountrequest = rejectaccountrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProvidersAccountsRejectCall) Fields(s ...googleapi.Field) *ProvidersAccountsRejectCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProvidersAccountsRejectCall) Context(ctx context.Context) *ProvidersAccountsRejectCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProvidersAccountsRejectCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProvidersAccountsRejectCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200821")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.rejectaccountrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:reject")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudcommerceprocurement.providers.accounts.reject" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProvidersAccountsRejectCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Reject an approval on an Account.",
	//   "flatPath": "v1/providers/{providersId}/accounts/{accountsId}:reject",
	//   "httpMethod": "POST",
	//   "id": "cloudcommerceprocurement.providers.accounts.reject",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the account. Required.",
	//       "location": "path",
	//       "pattern": "^providers/[^/]+/accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:reject",
	//   "request": {
	//     "$ref": "RejectAccountRequest"
	//   },
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudcommerceprocurement.providers.accounts.reset":

type ProvidersAccountsResetCall struct {
	s                   *Service
	name                string
	resetaccountrequest *ResetAccountRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Reset: Reset an Account and cancel all associated Entitlements.
// Partner can only reset accounts they own rather than customer
// accounts.
func (r *ProvidersAccountsService) Reset(name string, resetaccountrequest *ResetAccountRequest) *ProvidersAccountsResetCall {
	c := &ProvidersAccountsResetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.resetaccountrequest = resetaccountrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProvidersAccountsResetCall) Fields(s ...googleapi.Field) *ProvidersAccountsResetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProvidersAccountsResetCall) Context(ctx context.Context) *ProvidersAccountsResetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProvidersAccountsResetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProvidersAccountsResetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200821")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.resetaccountrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:reset")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudcommerceprocurement.providers.accounts.reset" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProvidersAccountsResetCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Reset an Account and cancel all associated Entitlements. Partner can only reset accounts they own rather than customer accounts.",
	//   "flatPath": "v1/providers/{providersId}/accounts/{accountsId}:reset",
	//   "httpMethod": "POST",
	//   "id": "cloudcommerceprocurement.providers.accounts.reset",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the account. Required.",
	//       "location": "path",
	//       "pattern": "^providers/[^/]+/accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:reset",
	//   "request": {
	//     "$ref": "ResetAccountRequest"
	//   },
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudcommerceprocurement.providers.entitlements.approve":

type ProvidersEntitlementsApproveCall struct {
	s                         *Service
	name                      string
	approveentitlementrequest *ApproveEntitlementRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// Approve: Approve an entitlement that is in the
// EntitlementState.ENTITLEMENT_ACTIVATION_REQUESTED state. This method
// is invoked by the provider to approve the creation of the entitlement
// resource.
func (r *ProvidersEntitlementsService) Approve(name string, approveentitlementrequest *ApproveEntitlementRequest) *ProvidersEntitlementsApproveCall {
	c := &ProvidersEntitlementsApproveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.approveentitlementrequest = approveentitlementrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProvidersEntitlementsApproveCall) Fields(s ...googleapi.Field) *ProvidersEntitlementsApproveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProvidersEntitlementsApproveCall) Context(ctx context.Context) *ProvidersEntitlementsApproveCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProvidersEntitlementsApproveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProvidersEntitlementsApproveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200821")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.approveentitlementrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:approve")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudcommerceprocurement.providers.entitlements.approve" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProvidersEntitlementsApproveCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Approve an entitlement that is in the EntitlementState.ENTITLEMENT_ACTIVATION_REQUESTED state. This method is invoked by the provider to approve the creation of the entitlement resource.",
	//   "flatPath": "v1/providers/{providersId}/entitlements/{entitlementsId}:approve",
	//   "httpMethod": "POST",
	//   "id": "cloudcommerceprocurement.providers.entitlements.approve",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the entitlement. Required.",
	//       "location": "path",
	//       "pattern": "^providers/[^/]+/entitlements/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:approve",
	//   "request": {
	//     "$ref": "ApproveEntitlementRequest"
	//   },
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudcommerceprocurement.providers.entitlements.approvePlanChange":

type ProvidersEntitlementsApprovePlanChangeCall struct {
	s                                   *Service
	name                                string
	approveentitlementplanchangerequest *ApproveEntitlementPlanChangeRequest
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// ApprovePlanChange: Approve an entitlement plan change that is in the
// EntitlementState.ENTITLEMENT_PENDING_PLAN_CHANGE_APPROVAL state. This
// method is invoked by the provider to approve the plan change on the
// entitlement resource.
func (r *ProvidersEntitlementsService) ApprovePlanChange(name string, approveentitlementplanchangerequest *ApproveEntitlementPlanChangeRequest) *ProvidersEntitlementsApprovePlanChangeCall {
	c := &ProvidersEntitlementsApprovePlanChangeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.approveentitlementplanchangerequest = approveentitlementplanchangerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProvidersEntitlementsApprovePlanChangeCall) Fields(s ...googleapi.Field) *ProvidersEntitlementsApprovePlanChangeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProvidersEntitlementsApprovePlanChangeCall) Context(ctx context.Context) *ProvidersEntitlementsApprovePlanChangeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProvidersEntitlementsApprovePlanChangeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProvidersEntitlementsApprovePlanChangeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200821")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.approveentitlementplanchangerequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:approvePlanChange")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudcommerceprocurement.providers.entitlements.approvePlanChange" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProvidersEntitlementsApprovePlanChangeCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Approve an entitlement plan change that is in the EntitlementState.ENTITLEMENT_PENDING_PLAN_CHANGE_APPROVAL state. This method is invoked by the provider to approve the plan change on the entitlement resource.",
	//   "flatPath": "v1/providers/{providersId}/entitlements/{entitlementsId}:approvePlanChange",
	//   "httpMethod": "POST",
	//   "id": "cloudcommerceprocurement.providers.entitlements.approvePlanChange",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the entitlement. Required.",
	//       "location": "path",
	//       "pattern": "^providers/[^/]+/entitlements/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:approvePlanChange",
	//   "request": {
	//     "$ref": "ApproveEntitlementPlanChangeRequest"
	//   },
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudcommerceprocurement.providers.entitlements.get":

type ProvidersEntitlementsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get a requested Entitlement resource.
func (r *ProvidersEntitlementsService) Get(name string) *ProvidersEntitlementsGetCall {
	c := &ProvidersEntitlementsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProvidersEntitlementsGetCall) Fields(s ...googleapi.Field) *ProvidersEntitlementsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProvidersEntitlementsGetCall) IfNoneMatch(entityTag string) *ProvidersEntitlementsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProvidersEntitlementsGetCall) Context(ctx context.Context) *ProvidersEntitlementsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProvidersEntitlementsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProvidersEntitlementsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200821")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudcommerceprocurement.providers.entitlements.get" call.
// Exactly one of *Entitlement or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Entitlement.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProvidersEntitlementsGetCall) Do(opts ...googleapi.CallOption) (*Entitlement, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Entitlement{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get a requested Entitlement resource.",
	//   "flatPath": "v1/providers/{providersId}/entitlements/{entitlementsId}",
	//   "httpMethod": "GET",
	//   "id": "cloudcommerceprocurement.providers.entitlements.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the entitlement to retrieve.",
	//       "location": "path",
	//       "pattern": "^providers/[^/]+/entitlements/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Entitlement"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudcommerceprocurement.providers.entitlements.list":

type ProvidersEntitlementsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List Entitlements for which the provider has read access.
func (r *ProvidersEntitlementsService) List(parent string) *ProvidersEntitlementsListCall {
	c := &ProvidersEntitlementsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": The filter that can be
// used to limit the list request. The filter is a query string that can
// match a selected set of attributes with string values. For example
// `account=E-1234-5678-ABCD-EFGH`, `state=pending_cancellation`, and
// `plan!=foo-plan`. Supported query attributes are * `account` *
// `product_external_name` * `quote_external_name` * `plan` *
// `newPendingPlan` or `new_pending_plan` * `state` *
// `consumers.project` Note that the consumers match works on repeated
// structures, so equality (`consumers.project=projects/123456789`) is
// not supported. Set membership can be expressed with the `:` operator.
// For example, `consumers.project:projects/123456789` finds
// entitlements with at least one consumer with project field equal to
// `projects/123456789`. Also note that the state name match is
// case-insensitive and query can omit the prefix "ENTITLEMENT_". For
// example, `state=active` is equivalent to `state=ENTITLEMENT_ACTIVE`.
// If the query contains some special characters other than letters,
// underscore, or digits, the phrase must be quoted with double quotes.
// For example, `product="providerId:productId", where the product name
// needs to be quoted because it contains special character colon.
// Queries can be combined with `AND`, `OR`, and `NOT` to form more
// complex queries. They can also be grouped to force a desired
// evaluation order. For example, `state=active AND (account=E-1234 OR
// account=5678) AND NOT (product=foo-product)`. Connective `AND` can be
// omitted between two predicates. For example `account=E-1234
// state=active` is equivalent to `account=E-1234 AND state=active`.
func (c *ProvidersEntitlementsListCall) Filter(filter string) *ProvidersEntitlementsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of entries that are requested.
func (c *ProvidersEntitlementsListCall) PageSize(pageSize int64) *ProvidersEntitlementsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The token for
// fetching the next page.
func (c *ProvidersEntitlementsListCall) PageToken(pageToken string) *ProvidersEntitlementsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProvidersEntitlementsListCall) Fields(s ...googleapi.Field) *ProvidersEntitlementsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProvidersEntitlementsListCall) IfNoneMatch(entityTag string) *ProvidersEntitlementsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProvidersEntitlementsListCall) Context(ctx context.Context) *ProvidersEntitlementsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProvidersEntitlementsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProvidersEntitlementsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200821")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/entitlements")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudcommerceprocurement.providers.entitlements.list" call.
// Exactly one of *ListEntitlementsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *ListEntitlementsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProvidersEntitlementsListCall) Do(opts ...googleapi.CallOption) (*ListEntitlementsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListEntitlementsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "List Entitlements for which the provider has read access.",
	//   "flatPath": "v1/providers/{providersId}/entitlements",
	//   "httpMethod": "GET",
	//   "id": "cloudcommerceprocurement.providers.entitlements.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The filter that can be used to limit the list request. The filter is a query string that can match a selected set of attributes with string values. For example `account=E-1234-5678-ABCD-EFGH`, `state=pending_cancellation`, and `plan!=foo-plan`. Supported query attributes are * `account` * `product_external_name` * `quote_external_name` * `plan` * `newPendingPlan` or `new_pending_plan` * `state` * `consumers.project` Note that the consumers match works on repeated structures, so equality (`consumers.project=projects/123456789`) is not supported. Set membership can be expressed with the `:` operator. For example, `consumers.project:projects/123456789` finds entitlements with at least one consumer with project field equal to `projects/123456789`. Also note that the state name match is case-insensitive and query can omit the prefix \"ENTITLEMENT_\". For example, `state=active` is equivalent to `state=ENTITLEMENT_ACTIVE`. If the query contains some special characters other than letters, underscore, or digits, the phrase must be quoted with double quotes. For example, `product=\"providerId:productId\"`, where the product name needs to be quoted because it contains special character colon. Queries can be combined with `AND`, `OR`, and `NOT` to form more complex queries. They can also be grouped to force a desired evaluation order. For example, `state=active AND (account=E-1234 OR account=5678) AND NOT (product=foo-product)`. Connective `AND` can be omitted between two predicates. For example `account=E-1234 state=active` is equivalent to `account=E-1234 AND state=active`.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of entries that are requested.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The token for fetching the next page.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "The parent resource name.",
	//       "location": "path",
	//       "pattern": "^providers/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/entitlements",
	//   "response": {
	//     "$ref": "ListEntitlementsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProvidersEntitlementsListCall) Pages(ctx context.Context, f func(*ListEntitlementsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "cloudcommerceprocurement.providers.entitlements.patch":

type ProvidersEntitlementsPatchCall struct {
	s           *Service
	name        string
	entitlement *Entitlement
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Patch: Updates an existing Entitlement.
func (r *ProvidersEntitlementsService) Patch(name string, entitlement *Entitlement) *ProvidersEntitlementsPatchCall {
	c := &ProvidersEntitlementsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.entitlement = entitlement
	return c
}

// UpdateMask sets the optional parameter "updateMask": The update mask
// that applies to the resource. See the [FieldMask definition]
// (https://developers.google.com/protocol-buffers/docs/reference/google.
// protobuf#fieldmask) for more details.
func (c *ProvidersEntitlementsPatchCall) UpdateMask(updateMask string) *ProvidersEntitlementsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProvidersEntitlementsPatchCall) Fields(s ...googleapi.Field) *ProvidersEntitlementsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProvidersEntitlementsPatchCall) Context(ctx context.Context) *ProvidersEntitlementsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProvidersEntitlementsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProvidersEntitlementsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200821")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.entitlement)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudcommerceprocurement.providers.entitlements.patch" call.
// Exactly one of *Entitlement or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Entitlement.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProvidersEntitlementsPatchCall) Do(opts ...googleapi.CallOption) (*Entitlement, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Entitlement{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates an existing Entitlement.",
	//   "flatPath": "v1/providers/{providersId}/entitlements/{entitlementsId}",
	//   "httpMethod": "PATCH",
	//   "id": "cloudcommerceprocurement.providers.entitlements.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the entitlement to update.",
	//       "location": "path",
	//       "pattern": "^providers/[^/]+/entitlements/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The update mask that applies to the resource. See the [FieldMask definition] (https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask) for more details.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "Entitlement"
	//   },
	//   "response": {
	//     "$ref": "Entitlement"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudcommerceprocurement.providers.entitlements.reject":

type ProvidersEntitlementsRejectCall struct {
	s                        *Service
	name                     string
	rejectentitlementrequest *RejectEntitlementRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// Reject: Reject an entitlement that is in the
// EntitlementState.ENTITLEMENT_ACTIVATION_REQUESTED state. This method
// is invoked by the provider to reject the creation of the entitlement
// resource.
func (r *ProvidersEntitlementsService) Reject(name string, rejectentitlementrequest *RejectEntitlementRequest) *ProvidersEntitlementsRejectCall {
	c := &ProvidersEntitlementsRejectCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.rejectentitlementrequest = rejectentitlementrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProvidersEntitlementsRejectCall) Fields(s ...googleapi.Field) *ProvidersEntitlementsRejectCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProvidersEntitlementsRejectCall) Context(ctx context.Context) *ProvidersEntitlementsRejectCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProvidersEntitlementsRejectCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProvidersEntitlementsRejectCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200821")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.rejectentitlementrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:reject")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudcommerceprocurement.providers.entitlements.reject" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProvidersEntitlementsRejectCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Reject an entitlement that is in the EntitlementState.ENTITLEMENT_ACTIVATION_REQUESTED state. This method is invoked by the provider to reject the creation of the entitlement resource.",
	//   "flatPath": "v1/providers/{providersId}/entitlements/{entitlementsId}:reject",
	//   "httpMethod": "POST",
	//   "id": "cloudcommerceprocurement.providers.entitlements.reject",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the entitlement. Required.",
	//       "location": "path",
	//       "pattern": "^providers/[^/]+/entitlements/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:reject",
	//   "request": {
	//     "$ref": "RejectEntitlementRequest"
	//   },
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudcommerceprocurement.providers.entitlements.rejectPlanChange":

type ProvidersEntitlementsRejectPlanChangeCall struct {
	s                                  *Service
	name                               string
	rejectentitlementplanchangerequest *RejectEntitlementPlanChangeRequest
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// RejectPlanChange: Reject an entitlement plan change that is in the
// EntitlementState.ENTITLEMENT_PENDING_PLAN_CHANGE_APPROVAL state. This
// method is invoked by the provider to reject the plan change on the
// entitlement resource.
func (r *ProvidersEntitlementsService) RejectPlanChange(name string, rejectentitlementplanchangerequest *RejectEntitlementPlanChangeRequest) *ProvidersEntitlementsRejectPlanChangeCall {
	c := &ProvidersEntitlementsRejectPlanChangeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.rejectentitlementplanchangerequest = rejectentitlementplanchangerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProvidersEntitlementsRejectPlanChangeCall) Fields(s ...googleapi.Field) *ProvidersEntitlementsRejectPlanChangeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProvidersEntitlementsRejectPlanChangeCall) Context(ctx context.Context) *ProvidersEntitlementsRejectPlanChangeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProvidersEntitlementsRejectPlanChangeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProvidersEntitlementsRejectPlanChangeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200821")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.rejectentitlementplanchangerequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:rejectPlanChange")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudcommerceprocurement.providers.entitlements.rejectPlanChange" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProvidersEntitlementsRejectPlanChangeCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Reject an entitlement plan change that is in the EntitlementState.ENTITLEMENT_PENDING_PLAN_CHANGE_APPROVAL state. This method is invoked by the provider to reject the plan change on the entitlement resource.",
	//   "flatPath": "v1/providers/{providersId}/entitlements/{entitlementsId}:rejectPlanChange",
	//   "httpMethod": "POST",
	//   "id": "cloudcommerceprocurement.providers.entitlements.rejectPlanChange",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the entitlement. Required.",
	//       "location": "path",
	//       "pattern": "^providers/[^/]+/entitlements/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:rejectPlanChange",
	//   "request": {
	//     "$ref": "RejectEntitlementPlanChangeRequest"
	//   },
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudcommerceprocurement.providers.entitlements.suspend":

type ProvidersEntitlementsSuspendCall struct {
	s                         *Service
	name                      string
	suspendentitlementrequest *SuspendEntitlementRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// Suspend: Request suspension of an active Entitlement. This is not yet
// supported.
func (r *ProvidersEntitlementsService) Suspend(name string, suspendentitlementrequest *SuspendEntitlementRequest) *ProvidersEntitlementsSuspendCall {
	c := &ProvidersEntitlementsSuspendCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.suspendentitlementrequest = suspendentitlementrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProvidersEntitlementsSuspendCall) Fields(s ...googleapi.Field) *ProvidersEntitlementsSuspendCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProvidersEntitlementsSuspendCall) Context(ctx context.Context) *ProvidersEntitlementsSuspendCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProvidersEntitlementsSuspendCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProvidersEntitlementsSuspendCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200821")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.suspendentitlementrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:suspend")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudcommerceprocurement.providers.entitlements.suspend" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProvidersEntitlementsSuspendCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Request suspension of an active Entitlement. This is not yet supported.",
	//   "flatPath": "v1/providers/{providersId}/entitlements/{entitlementsId}:suspend",
	//   "httpMethod": "POST",
	//   "id": "cloudcommerceprocurement.providers.entitlements.suspend",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the entitlement to suspend.",
	//       "location": "path",
	//       "pattern": "^providers/[^/]+/entitlements/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:suspend",
	//   "request": {
	//     "$ref": "SuspendEntitlementRequest"
	//   },
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}
