// Copyright 2023 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package places provides access to the Places API (New).
//
// For product documentation, see: https://mapsplatform.google.com/maps-products/#places-section
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/places/v1"
//	...
//	ctx := context.Background()
//	placesService, err := places.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	placesService, err := places.NewService(ctx, option.WithScopes(places.MapsPlatformPlacesTextsearchScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	placesService, err := places.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	placesService, err := places.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package places // import "google.golang.org/api/places/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "places:v1"
const apiName = "places"
const apiVersion = "v1"
const basePath = "https://places.googleapis.com/"
const mtlsBasePath = "https://places.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"

	// Private Service: https://www.googleapis.com/auth/maps-platform.places
	MapsPlatformPlacesScope = "https://www.googleapis.com/auth/maps-platform.places"

	// Private Service:
	// https://www.googleapis.com/auth/maps-platform.places.textsearch
	MapsPlatformPlacesTextsearchScope = "https://www.googleapis.com/auth/maps-platform.places.textsearch"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
		"https://www.googleapis.com/auth/maps-platform.places",
		"https://www.googleapis.com/auth/maps-platform.places.textsearch",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Places = NewPlacesService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Places *PlacesService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewPlacesService(s *Service) *PlacesService {
	rs := &PlacesService{s: s}
	return rs
}

type PlacesService struct {
	s *Service
}

// GoogleGeoTypeViewport: A latitude-longitude viewport, represented as
// two diagonally opposite `low` and `high` points. A viewport is
// considered a closed region, i.e. it includes its boundary. The
// latitude bounds must range between -90 to 90 degrees inclusive, and
// the longitude bounds must range between -180 to 180 degrees
// inclusive. Various cases include: - If `low` = `high`, the viewport
// consists of that single point. - If `low.longitude` >
// `high.longitude`, the longitude range is inverted (the viewport
// crosses the 180 degree longitude line). - If `low.longitude` = -180
// degrees and `high.longitude` = 180 degrees, the viewport includes all
// longitudes. - If `low.longitude` = 180 degrees and `high.longitude` =
// -180 degrees, the longitude range is empty. - If `low.latitude` >
// `high.latitude`, the latitude range is empty. Both `low` and `high`
// must be populated, and the represented box cannot be empty (as
// specified by the definitions above). An empty viewport will result in
// an error. For example, this viewport fully encloses New York City: {
// "low": { "latitude": 40.477398, "longitude": -74.259087 }, "high": {
// "latitude": 40.91618, "longitude": -73.70018 } }
type GoogleGeoTypeViewport struct {
	// High: Required. The high point of the viewport.
	High *GoogleTypeLatLng `json:"high,omitempty"`

	// Low: Required. The low point of the viewport.
	Low *GoogleTypeLatLng `json:"low,omitempty"`

	// ForceSendFields is a list of field names (e.g. "High") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "High") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleGeoTypeViewport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleGeoTypeViewport
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1AuthorAttribution: Information about the author of
// the UGC data. Used in Photo, and Review.
type GoogleMapsPlacesV1AuthorAttribution struct {
	// DisplayName: Output only. Name of the author of the Photo or Review.
	DisplayName string `json:"displayName,omitempty"`

	// PhotoUri: Output only. Profile photo URI of the author of the Photo
	// or Review.
	PhotoUri string `json:"photoUri,omitempty"`

	// Uri: Output only. URI of the author of the Photo or Review.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleMapsPlacesV1AuthorAttribution) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1AuthorAttribution
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1Circle: Circle with a LatLng as center and radius.
type GoogleMapsPlacesV1Circle struct {
	// Center: Required. Center latitude and longitude. The range of
	// latitude must be within [-90.0, 90.0]. The range of the longitude
	// must be within [-180.0, 180.0].
	Center *GoogleTypeLatLng `json:"center,omitempty"`

	// Radius: Required. Radius measured in meters. The radius must be
	// within [0.0, 50000.0].
	Radius float64 `json:"radius,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Center") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Center") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleMapsPlacesV1Circle) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1Circle
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleMapsPlacesV1Circle) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleMapsPlacesV1Circle
	var s1 struct {
		Radius gensupport.JSONFloat64 `json:"radius"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Radius = float64(s1.Radius)
	return nil
}

// GoogleMapsPlacesV1Place: All the information representing a Place.
type GoogleMapsPlacesV1Place struct {
	// AddressComponents: Output only. Repeated components for each locality
	// level.
	AddressComponents []*GoogleMapsPlacesV1PlaceAddressComponent `json:"addressComponents,omitempty"`

	// AdrFormatAddress: Output only. The place's address in adr
	// microformat: http://microformats.org/wiki/adr.
	AdrFormatAddress string `json:"adrFormatAddress,omitempty"`

	// Attributions: Output only. A set of data provider that must be shown
	// with this result.
	Attributions []*GoogleMapsPlacesV1PlaceAttribution `json:"attributions,omitempty"`

	// BusinessStatus: Output only. The business status for the place.
	//
	// Possible values:
	//   "BUSINESS_STATUS_UNSPECIFIED" - Default value. This value is
	// unused.
	//   "OPERATIONAL" - The establishment is operational, not necessarily
	// open now.
	//   "CLOSED_TEMPORARILY" - The establishment is temporarily closed.
	//   "CLOSED_PERMANENTLY" - The establishment is permanently closed.
	BusinessStatus string `json:"businessStatus,omitempty"`

	// CurbsidePickup: Output only. Specifies if the business supports
	// curbside pickup.
	CurbsidePickup bool `json:"curbsidePickup,omitempty"`

	// CurrentOpeningHours: Output only. The hours of operation for the next
	// seven days (including today). The time period starts at midnight on
	// the date of the request and ends at 11:59 pm six days later. This
	// field includes the special_days subfield of all hours, set for dates
	// that have exceptional hours.
	CurrentOpeningHours *GoogleMapsPlacesV1PlaceOpeningHours `json:"currentOpeningHours,omitempty"`

	// CurrentSecondaryOpeningHours: Output only. Contains an array of
	// entries for the next seven days including information about secondary
	// hours of a business. Secondary hours are different from a business's
	// main hours. For example, a restaurant can specify drive through hours
	// or delivery hours as its secondary hours. This field populates the
	// type subfield, which draws from a predefined list of opening hours
	// types (such as DRIVE_THROUGH, PICKUP, or TAKEOUT) based on the types
	// of the place. This field includes the special_days subfield of all
	// hours, set for dates that have exceptional hours.
	CurrentSecondaryOpeningHours []*GoogleMapsPlacesV1PlaceOpeningHours `json:"currentSecondaryOpeningHours,omitempty"`

	// Delivery: Output only. Specifies if the business supports delivery.
	Delivery bool `json:"delivery,omitempty"`

	// DineIn: Output only. Specifies if the business supports indoor or
	// outdoor seating options.
	DineIn bool `json:"dineIn,omitempty"`

	// DisplayName: Output only. The localized name of the place, suitable
	// as a short human-readable description. For example, "Google Sydney",
	// "Starbucks", "Pyrmont", etc.
	DisplayName *GoogleTypeLocalizedText `json:"displayName,omitempty"`

	// EditorialSummary: Output only. Contains a summary of the place. A
	// summary is comprised of a textual overview, and also includes the
	// language code for these if applicable. Summary text must be presented
	// as-is and can not be modified or altered.
	EditorialSummary *GoogleTypeLocalizedText `json:"editorialSummary,omitempty"`

	// FormattedAddress: Output only. A full, human-readable address for
	// this place.
	FormattedAddress string `json:"formattedAddress,omitempty"`

	// GoogleMapsUri: Output only. A URL providing more information about
	// this place.
	GoogleMapsUri string `json:"googleMapsUri,omitempty"`

	// IconBackgroundColor: Output only. Background color for icon_mask in
	// hex format, e.g. #909CE1.
	IconBackgroundColor string `json:"iconBackgroundColor,omitempty"`

	// IconMaskBaseUri: Output only. A truncated URL to an v2 icon mask.
	// User can access different icon type by appending type suffix to the
	// end (eg, ".svg" or ".png").
	IconMaskBaseUri string `json:"iconMaskBaseUri,omitempty"`

	// Id: Output only. The unique identifier of a place.
	Id string `json:"id,omitempty"`

	// InternationalPhoneNumber: Output only. A human-readable phone number
	// for the place, in international format.
	InternationalPhoneNumber string `json:"internationalPhoneNumber,omitempty"`

	// Location: Output only. The position of this place.
	Location *GoogleTypeLatLng `json:"location,omitempty"`

	// Name: Output only. An ID representing this place which may be used to
	// look up this place again (a.k.a. the API "resource" name: places/).
	Name string `json:"name,omitempty"`

	// NationalPhoneNumber: Output only. A human-readable phone number for
	// the place, in national format.
	NationalPhoneNumber string `json:"nationalPhoneNumber,omitempty"`

	// OpeningHours: Output only. The regular hours of operation.
	OpeningHours *GoogleMapsPlacesV1PlaceOpeningHours `json:"openingHours,omitempty"`

	// PlusCode: Output only. Plus code of the place location lat/long.
	PlusCode *GoogleMapsPlacesV1PlacePlusCode `json:"plusCode,omitempty"`

	// PriceLevel: Output only. Price level of the place.
	//
	// Possible values:
	//   "PRICE_LEVEL_UNSPECIFIED" - Place price level is unspecified or
	// unknown.
	//   "PRICE_LEVEL_FREE" - Place provides free services.
	//   "PRICE_LEVEL_INEXPENSIVE" - Place provides inexpensive services.
	//   "PRICE_LEVEL_MODERATE" - Place provides moderately priced services.
	//   "PRICE_LEVEL_EXPENSIVE" - Place provides expensive services.
	//   "PRICE_LEVEL_VERY_EXPENSIVE" - Place provides very expensive
	// service s.
	PriceLevel string `json:"priceLevel,omitempty"`

	// Rating: Output only. A rating between 1.0 and 5.0, based on user
	// reviews of this place.
	Rating float64 `json:"rating,omitempty"`

	// Reservable: Output only. Specifies if the place supports
	// reservations.
	Reservable bool `json:"reservable,omitempty"`

	// Reviews: Output only. List of reviews about this place.
	Reviews []*GoogleMapsPlacesV1Review `json:"reviews,omitempty"`

	// SecondaryOpeningHours: Output only. Contains an array of entries for
	// information about regular secondary hours of a business. Secondary
	// hours are different from a business's main hours. For example, a
	// restaurant can specify drive through hours or delivery hours as its
	// secondary hours. This field populates the type subfield, which draws
	// from a predefined list of opening hours types (such as DRIVE_THROUGH,
	// PICKUP, or TAKEOUT) based on the types of the place.
	SecondaryOpeningHours []*GoogleMapsPlacesV1PlaceOpeningHours `json:"secondaryOpeningHours,omitempty"`

	// ServesBeer: Output only. Specifies if the place serves beer.
	ServesBeer bool `json:"servesBeer,omitempty"`

	// ServesBreakfast: Output only. Specifies if the place serves
	// breakfast.
	ServesBreakfast bool `json:"servesBreakfast,omitempty"`

	// ServesBrunch: Output only. Specifies if the place serves brunch.
	ServesBrunch bool `json:"servesBrunch,omitempty"`

	// ServesDinner: Output only. Specifies if the place serves dinner.
	ServesDinner bool `json:"servesDinner,omitempty"`

	// ServesLunch: Output only. Specifies if the place serves lunch.
	ServesLunch bool `json:"servesLunch,omitempty"`

	// ServesVegetarianFood: Output only. Specifies if the place serves
	// vegetarian food.
	ServesVegetarianFood bool `json:"servesVegetarianFood,omitempty"`

	// ServesWine: Output only. Specifies if the place serves wine.
	ServesWine bool `json:"servesWine,omitempty"`

	// Takeout: Output only. Specifies if the business supports takeout.
	Takeout bool `json:"takeout,omitempty"`

	// Types: Output only. A set of type tags for this result. For example,
	// "political" and "locality".
	Types []string `json:"types,omitempty"`

	// UserRatingCount: Output only. The total number of reviews (with or
	// without text) for this place.
	UserRatingCount int64 `json:"userRatingCount,omitempty"`

	// UtcOffsetMinutes: Output only. Number of minutes this place's
	// timezone is currently offset from UTC. This is expressed in minutes
	// to support timezones that are offset by fractions of an hour, e.g. X
	// hours and 15 minutes.
	UtcOffsetMinutes int64 `json:"utcOffsetMinutes,omitempty"`

	// Viewport: Output only. A viewport suitable for displaying the place
	// on an average-sized map.
	Viewport *GoogleGeoTypeViewport `json:"viewport,omitempty"`

	// WebsiteUri: Output only. The authoritative website for this place,
	// e.g. a business' homepage. Note that for places that are part of a
	// chain (e.g. an IKEA store), this will usually be the website for the
	// individual store, not the overall chain.
	WebsiteUri string `json:"websiteUri,omitempty"`

	// WheelchairAccessibleEntrance: Output only. [Deprecated!] Specifies if
	// the place has an entrance that is wheelchair-accessible.
	WheelchairAccessibleEntrance bool `json:"wheelchairAccessibleEntrance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AddressComponents")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AddressComponents") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleMapsPlacesV1Place) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1Place
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleMapsPlacesV1Place) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleMapsPlacesV1Place
	var s1 struct {
		Rating gensupport.JSONFloat64 `json:"rating"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Rating = float64(s1.Rating)
	return nil
}

// GoogleMapsPlacesV1PlaceAddressComponent: The structured components
// that form the formatted address, if this information is available.
type GoogleMapsPlacesV1PlaceAddressComponent struct {
	// LanguageCode: Output only. The language used to format this
	// components, in CLDR notation.
	LanguageCode string `json:"languageCode,omitempty"`

	// LongText: Output only. The full text description or name of the
	// address component. For example, an address component for the country
	// Australia may have a long_name of "Australia".
	LongText string `json:"longText,omitempty"`

	// ShortText: Output only. An abbreviated textual name for the address
	// component, if available. For example, an address component for the
	// country of Australia may have a short_name of "AU".
	ShortText string `json:"shortText,omitempty"`

	// Types: Output only. An array indicating the type(s) of the address
	// component.
	Types []string `json:"types,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LanguageCode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleMapsPlacesV1PlaceAddressComponent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1PlaceAddressComponent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1PlaceAttribution: Information about data providers
// of this place.
type GoogleMapsPlacesV1PlaceAttribution struct {
	// Provider: Output only. Name of the Place's data provider.
	Provider string `json:"provider,omitempty"`

	// ProviderUri: Output only. URI to the Place's data provider.
	ProviderUri string `json:"providerUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Provider") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Provider") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleMapsPlacesV1PlaceAttribution) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1PlaceAttribution
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1PlaceOpeningHours: Information about business hour
// of the place.
type GoogleMapsPlacesV1PlaceOpeningHours struct {
	// OpenNow: Output only. Is this place open right now? Always present
	// unless we lack time-of-day or timezone data for these opening hours.
	OpenNow bool `json:"openNow,omitempty"`

	// Periods: Output only. The periods that this place is open during the
	// week. The periods are in chronological order, starting with Sunday in
	// the place-local timezone. An empty (but not absent) value indicates a
	// place that is never open, e.g. because it is closed temporarily for
	// renovations.
	Periods []*GoogleMapsPlacesV1PlaceOpeningHoursPeriod `json:"periods,omitempty"`

	// SecondaryHoursType: Output only. A type string used to identify the
	// type of secondary hours.
	//
	// Possible values:
	//   "SECONDARY_HOURS_TYPE_UNSPECIFIED" - Default value when secondary
	// hour type is not specified.
	//   "DRIVE_THROUGH" - The drive-through hour for banks, restaurants, or
	// pharmacies.
	//   "HAPPY_HOUR" - The happy hour.
	//   "DELIVERY" - The delivery hour.
	//   "TAKEOUT" - The takeout hour.
	//   "KITCHEN" - The kitchen hour.
	//   "BREAKFAST" - The breakfast hour.
	//   "LUNCH" - The lunch hour.
	//   "DINNER" - The dinner hour.
	//   "BRUNCH" - The brunch hour.
	//   "PICKUP" - The pickup hour.
	//   "ACCESS" - The access hours for storage places.
	//   "SENIOR_HOURS" - The special hours for seniors.
	//   "ONLINE_SERVICE_HOURS" - The online service hours.
	SecondaryHoursType string `json:"secondaryHoursType,omitempty"`

	// SpecialDays: Output only. Structured information for special days
	// that fall within the period that the returned opening hours cover.
	// Special days are days that could impact the business hours of a
	// place, e.g. Christmas day. Set for current_opening_hours and
	// current_secondary_opening_hours if there are exceptional hours.
	SpecialDays []*GoogleMapsPlacesV1PlaceOpeningHoursSpecialDay `json:"specialDays,omitempty"`

	// WeekdayDescriptions: Output only. Localized strings describing the
	// opening hours of this place, one string for each day of the week.
	// Will be empty if the hours are unknown or could not be converted to
	// localized text. Example: "Sun: 18:00–06:00"
	WeekdayDescriptions []string `json:"weekdayDescriptions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OpenNow") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OpenNow") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleMapsPlacesV1PlaceOpeningHours) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1PlaceOpeningHours
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1PlaceOpeningHoursPeriod: A period the place remains
// in open_now status.
type GoogleMapsPlacesV1PlaceOpeningHoursPeriod struct {
	// Close: Output only. The time that the place starts to be closed.
	Close *GoogleMapsPlacesV1PlaceOpeningHoursPeriodPoint `json:"close,omitempty"`

	// Open: Output only. The time that the place starts to be open.
	Open *GoogleMapsPlacesV1PlaceOpeningHoursPeriodPoint `json:"open,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Close") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Close") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleMapsPlacesV1PlaceOpeningHoursPeriod) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1PlaceOpeningHoursPeriod
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1PlaceOpeningHoursPeriodPoint: Status changing
// points.
type GoogleMapsPlacesV1PlaceOpeningHoursPeriodPoint struct {
	// Date: Output only. Date in the local timezone for the place.
	Date *GoogleTypeDate `json:"date,omitempty"`

	// Day: Output only. A day of the week, as an integer in the range 0-6.
	// 0 is Sunday, 1 is Monday, etc.
	Day int64 `json:"day,omitempty"`

	// Hour: Output only. The hour in 2 digits. Ranges from 00 to 23.
	Hour int64 `json:"hour,omitempty"`

	// Minute: Output only. The minute in 2 digits. Ranges from 00 to 59.
	Minute int64 `json:"minute,omitempty"`

	// Truncated: Output only. Whether or not this endpoint was truncated.
	// Truncation occurs when the real hours are outside the times we are
	// willing to return hours between, so we truncate the hours back to
	// these boundaries. This ensures that at most 24 * 7 hours from
	// midnight of the day of the request are returned.
	Truncated bool `json:"truncated,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Date") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Date") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleMapsPlacesV1PlaceOpeningHoursPeriodPoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1PlaceOpeningHoursPeriodPoint
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1PlaceOpeningHoursSpecialDay: Structured information
// for special days that fall within the period that the returned
// opening hours cover. Special days are days that could impact the
// business hours of a place, e.g. Christmas day.
type GoogleMapsPlacesV1PlaceOpeningHoursSpecialDay struct {
	// Date: Output only. The date of this special day.
	Date *GoogleTypeDate `json:"date,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Date") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Date") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleMapsPlacesV1PlaceOpeningHoursSpecialDay) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1PlaceOpeningHoursSpecialDay
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1PlacePlusCode: Plus code (http://plus.codes) is a
// location reference with two formats: global code defining a 14mx14m
// (1/8000th of a degree) or smaller rectangle, and compound code,
// replacing the prefix with a reference location.
type GoogleMapsPlacesV1PlacePlusCode struct {
	// CompoundCode: Output only. Place's compound code, such as "33GV+HQ,
	// Ramberg, Norway", containing the suffix of the global code and
	// replacing the prefix with a formatted name of a reference entity.
	CompoundCode string `json:"compoundCode,omitempty"`

	// GlobalCode: Output only. Place's global (full) code, such as
	// "9FWM33GV+HQ", representing an 1/8000 by 1/8000 degree area (~14 by
	// 14 meters).
	GlobalCode string `json:"globalCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CompoundCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CompoundCode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleMapsPlacesV1PlacePlusCode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1PlacePlusCode
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1Review: Information about a review of a place.
type GoogleMapsPlacesV1Review struct {
	// AuthorAttribution: Output only. This review's author.
	AuthorAttribution *GoogleMapsPlacesV1AuthorAttribution `json:"authorAttribution,omitempty"`

	// OriginalText: Output only. The review text in its original language.
	OriginalText *GoogleTypeLocalizedText `json:"originalText,omitempty"`

	// PublishTime: Output only. Timestamp for the review.
	PublishTime string `json:"publishTime,omitempty"`

	// Rating: Output only. A number between 1.0 and 5.0, a.k.a. the number
	// of stars.
	Rating float64 `json:"rating,omitempty"`

	// RelativePublishTimeDescription: Output only. A string of formatted
	// recent time, expressing the review time relative to the current time
	// in a form appropriate for the language and country.
	RelativePublishTimeDescription string `json:"relativePublishTimeDescription,omitempty"`

	// Text: Output only. The localized text of the review.
	Text *GoogleTypeLocalizedText `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AuthorAttribution")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AuthorAttribution") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleMapsPlacesV1Review) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1Review
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleMapsPlacesV1Review) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleMapsPlacesV1Review
	var s1 struct {
		Rating gensupport.JSONFloat64 `json:"rating"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Rating = float64(s1.Rating)
	return nil
}

// GoogleMapsPlacesV1SearchTextRequest: Request proto for SearchText.
type GoogleMapsPlacesV1SearchTextRequest struct {
	// IncludedType: The requested place type. Full list of types supported:
	// https://developers.google.com/places/supported_types. Only support
	// one included type.
	IncludedType string `json:"includedType,omitempty"`

	// LanguageCode: Place details will be displayed with the preferred
	// language if available. If the language code is unspecified or
	// unrecognized, place details of any language may be returned, with a
	// preference for English if such details exist. Current list of
	// supported languages:
	// https://developers.google.com/maps/faq#languagesupport.
	LanguageCode string `json:"languageCode,omitempty"`

	// LocationBias: The region to search. This location serves as a bias
	// which means results around given location might be returned. Cannot
	// be set along with location_restriction.
	LocationBias *GoogleMapsPlacesV1SearchTextRequestLocationBias `json:"locationBias,omitempty"`

	// LocationRestriction: The region to search. This location serves as a
	// restriction which means results outside given location will not be
	// returned. Cannot be set along with location_bias.
	LocationRestriction *GoogleMapsPlacesV1SearchTextRequestLocationRestriction `json:"locationRestriction,omitempty"`

	// MaxResultCount: Maximum number of results to return. It must be
	// between 1 and 20, inclusively. If the number is unset, it falls back
	// to the upper limit. If the number is set to negative or exceeds the
	// upper limit, an INVALID_ARGUMENT error is returned.
	MaxResultCount int64 `json:"maxResultCount,omitempty"`

	// MinRating: Filter out results whose average user rating is strictly
	// less than this limit. A valid value must be an float between 0 and 5
	// (inclusively) at a 0.5 cadence i.e. [0, 0.5, 1.0, ... , 5.0]
	// inclusively. This is to keep parity with LocalRefinement_UserRating.
	// The input rating will round up to the nearest 0.5(ceiling). For
	// instance, a rating of 0.6 will eliminate all results with a less than
	// 1.0 rating.
	MinRating float64 `json:"minRating,omitempty"`

	// OpenNow: Used to restrict the search to places that are open at a
	// specific time. open_now marks if a business is currently open.
	OpenNow bool `json:"openNow,omitempty"`

	// PriceLevels: Used to restrict the search to places that are marked as
	// certain price levels. Users can choose any combinations of price
	// levels. Default to select all price levels.
	//
	// Possible values:
	//   "PRICE_LEVEL_UNSPECIFIED" - Place price level is unspecified or
	// unknown.
	//   "PRICE_LEVEL_FREE" - Place provides free services.
	//   "PRICE_LEVEL_INEXPENSIVE" - Place provides inexpensive services.
	//   "PRICE_LEVEL_MODERATE" - Place provides moderately priced services.
	//   "PRICE_LEVEL_EXPENSIVE" - Place provides expensive services.
	//   "PRICE_LEVEL_VERY_EXPENSIVE" - Place provides very expensive
	// service s.
	PriceLevels []string `json:"priceLevels,omitempty"`

	// RankPreference: How results will be ranked in the response.
	//
	// Possible values:
	//   "RANK_PREFERENCE_UNSPECIFIED" - RankPreference value not set. Will
	// default to DISTANCE.
	//   "DISTANCE" - Ranks results by distance.
	//   "RELEVANCE" - Ranks results by relevance. Sort order determined by
	// normal ranking stack. See SortRefinement::RELEVANCE.
	RankPreference string `json:"rankPreference,omitempty"`

	// RegionCode: The Unicode country/region code (CLDR) of the location
	// where the request is coming from. This parameter is used to display
	// the place details, like region-specific place name, if available. The
	// parameter can affect results based on applicable law. For more
	// information, see
	// http://www.unicode.org/reports/tr35/#unicode_region_subtag. Note that
	// 3-digit region codes are not currently supported.
	RegionCode string `json:"regionCode,omitempty"`

	// StrictTypeFiltering: Used to set strict type filtering for
	// included_type. If set to true, only results of the same type will be
	// returned. Default to false.
	StrictTypeFiltering bool `json:"strictTypeFiltering,omitempty"`

	// TextQuery: Required. The text query for textual search.
	TextQuery string `json:"textQuery,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IncludedType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IncludedType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleMapsPlacesV1SearchTextRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1SearchTextRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleMapsPlacesV1SearchTextRequest) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleMapsPlacesV1SearchTextRequest
	var s1 struct {
		MinRating gensupport.JSONFloat64 `json:"minRating"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MinRating = float64(s1.MinRating)
	return nil
}

// GoogleMapsPlacesV1SearchTextRequestLocationBias: The region to
// search. This location serves as a bias which means results around
// given location might be returned.
type GoogleMapsPlacesV1SearchTextRequestLocationBias struct {
	// Circle: A circle defined by center point and radius.
	Circle *GoogleMapsPlacesV1Circle `json:"circle,omitempty"`

	// Rectangle: A rectangle box defined by northeast and southwest corner.
	Rectangle *GoogleGeoTypeViewport `json:"rectangle,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Circle") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Circle") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleMapsPlacesV1SearchTextRequestLocationBias) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1SearchTextRequestLocationBias
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1SearchTextRequestLocationRestriction: The region to
// search. This location serves as a restriction which means results
// outside given location will not be returned.
type GoogleMapsPlacesV1SearchTextRequestLocationRestriction struct {
	// Rectangle: A rectangle box defined by northeast and southwest corner.
	Rectangle *GoogleGeoTypeViewport `json:"rectangle,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Rectangle") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Rectangle") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleMapsPlacesV1SearchTextRequestLocationRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1SearchTextRequestLocationRestriction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1SearchTextResponse: Response proto for SearchText.
type GoogleMapsPlacesV1SearchTextResponse struct {
	// Places: A list of places that meet the user's text search criteria.
	Places []*GoogleMapsPlacesV1Place `json:"places,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Places") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Places") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleMapsPlacesV1SearchTextResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1SearchTextResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypeDate: Represents a whole or partial calendar date, such as
// a birthday. The time of day and time zone are either specified
// elsewhere or are insignificant. The date is relative to the Gregorian
// Calendar. This can represent one of the following: * A full date,
// with non-zero year, month, and day values. * A month and day, with a
// zero year (for example, an anniversary). * A year on its own, with a
// zero month and a zero day. * A year and month, with a zero day (for
// example, a credit card expiration date). Related types: *
// google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type GoogleTypeDate struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and
	// month, or 0 to specify a year by itself or a year and month where the
	// day isn't significant.
	Day int64 `json:"day,omitempty"`

	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year
	// without a month and day.
	Month int64 `json:"month,omitempty"`

	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a
	// date without a year.
	Year int64 `json:"year,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Day") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Day") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeDate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeDate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypeLatLng: An object that represents a latitude/longitude
// pair. This is expressed as a pair of doubles to represent degrees
// latitude and degrees longitude. Unless specified otherwise, this
// object must conform to the WGS84 standard. Values must be within
// normalized ranges.
type GoogleTypeLatLng struct {
	// Latitude: The latitude in degrees. It must be in the range [-90.0,
	// +90.0].
	Latitude float64 `json:"latitude,omitempty"`

	// Longitude: The longitude in degrees. It must be in the range [-180.0,
	// +180.0].
	Longitude float64 `json:"longitude,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Latitude") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Latitude") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeLatLng) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeLatLng
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleTypeLatLng) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleTypeLatLng
	var s1 struct {
		Latitude  gensupport.JSONFloat64 `json:"latitude"`
		Longitude gensupport.JSONFloat64 `json:"longitude"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Latitude = float64(s1.Latitude)
	s.Longitude = float64(s1.Longitude)
	return nil
}

// GoogleTypeLocalizedText: Localized variant of a text in a particular
// language.
type GoogleTypeLocalizedText struct {
	// LanguageCode: The text's BCP-47 language code, such as "en-US" or
	// "sr-Latn". For more information, see
	// http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
	LanguageCode string `json:"languageCode,omitempty"`

	// Text: Localized string in the language corresponding to
	// `language_code' below.
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LanguageCode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeLocalizedText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeLocalizedText
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "places.places.searchText":

type PlacesSearchTextCall struct {
	s                                   *Service
	googlemapsplacesv1searchtextrequest *GoogleMapsPlacesV1SearchTextRequest
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// SearchText: Text query based place search.
func (r *PlacesService) SearchText(googlemapsplacesv1searchtextrequest *GoogleMapsPlacesV1SearchTextRequest) *PlacesSearchTextCall {
	c := &PlacesSearchTextCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googlemapsplacesv1searchtextrequest = googlemapsplacesv1searchtextrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PlacesSearchTextCall) Fields(s ...googleapi.Field) *PlacesSearchTextCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PlacesSearchTextCall) Context(ctx context.Context) *PlacesSearchTextCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PlacesSearchTextCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PlacesSearchTextCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlemapsplacesv1searchtextrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/places:searchText")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "places.places.searchText" call.
// Exactly one of *GoogleMapsPlacesV1SearchTextResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleMapsPlacesV1SearchTextResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PlacesSearchTextCall) Do(opts ...googleapi.CallOption) (*GoogleMapsPlacesV1SearchTextResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleMapsPlacesV1SearchTextResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Text query based place search.",
	//   "flatPath": "v1/places:searchText",
	//   "httpMethod": "POST",
	//   "id": "places.places.searchText",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "v1/places:searchText",
	//   "request": {
	//     "$ref": "GoogleMapsPlacesV1SearchTextRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleMapsPlacesV1SearchTextResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/maps-platform.places",
	//     "https://www.googleapis.com/auth/maps-platform.places.textsearch"
	//   ]
	// }

}
