// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.11.2
// source: google/devtools/build/v1/build_events.proto

package build

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	any "github.com/golang/protobuf/ptypes/any"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// The type of console output stream.
type ConsoleOutputStream int32

const (
	// Unspecified or unknown.
	ConsoleOutputStream_UNKNOWN ConsoleOutputStream = 0
	// Normal output stream.
	ConsoleOutputStream_STDOUT ConsoleOutputStream = 1
	// Error output stream.
	ConsoleOutputStream_STDERR ConsoleOutputStream = 2
)

// Enum value maps for ConsoleOutputStream.
var (
	ConsoleOutputStream_name = map[int32]string{
		0: "UNKNOWN",
		1: "STDOUT",
		2: "STDERR",
	}
	ConsoleOutputStream_value = map[string]int32{
		"UNKNOWN": 0,
		"STDOUT":  1,
		"STDERR":  2,
	}
)

func (x ConsoleOutputStream) Enum() *ConsoleOutputStream {
	p := new(ConsoleOutputStream)
	*p = x
	return p
}

func (x ConsoleOutputStream) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConsoleOutputStream) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_build_v1_build_events_proto_enumTypes[0].Descriptor()
}

func (ConsoleOutputStream) Type() protoreflect.EnumType {
	return &file_google_devtools_build_v1_build_events_proto_enumTypes[0]
}

func (x ConsoleOutputStream) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConsoleOutputStream.Descriptor instead.
func (ConsoleOutputStream) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_build_v1_build_events_proto_rawDescGZIP(), []int{0}
}

// How did the event stream finish.
type BuildEvent_BuildComponentStreamFinished_FinishType int32

const (
	// Unknown or unspecified; callers should never set this value.
	BuildEvent_BuildComponentStreamFinished_FINISH_TYPE_UNSPECIFIED BuildEvent_BuildComponentStreamFinished_FinishType = 0
	// Set by the event publisher to indicate a build event stream is
	// finished.
	BuildEvent_BuildComponentStreamFinished_FINISHED BuildEvent_BuildComponentStreamFinished_FinishType = 1
	// Set by the WatchBuild RPC server when the publisher of a build event
	// stream stops publishing events without publishing a
	// BuildComponentStreamFinished event whose type equals FINISHED.
	BuildEvent_BuildComponentStreamFinished_EXPIRED BuildEvent_BuildComponentStreamFinished_FinishType = 2
)

// Enum value maps for BuildEvent_BuildComponentStreamFinished_FinishType.
var (
	BuildEvent_BuildComponentStreamFinished_FinishType_name = map[int32]string{
		0: "FINISH_TYPE_UNSPECIFIED",
		1: "FINISHED",
		2: "EXPIRED",
	}
	BuildEvent_BuildComponentStreamFinished_FinishType_value = map[string]int32{
		"FINISH_TYPE_UNSPECIFIED": 0,
		"FINISHED":                1,
		"EXPIRED":                 2,
	}
)

func (x BuildEvent_BuildComponentStreamFinished_FinishType) Enum() *BuildEvent_BuildComponentStreamFinished_FinishType {
	p := new(BuildEvent_BuildComponentStreamFinished_FinishType)
	*p = x
	return p
}

func (x BuildEvent_BuildComponentStreamFinished_FinishType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BuildEvent_BuildComponentStreamFinished_FinishType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_build_v1_build_events_proto_enumTypes[1].Descriptor()
}

func (BuildEvent_BuildComponentStreamFinished_FinishType) Type() protoreflect.EnumType {
	return &file_google_devtools_build_v1_build_events_proto_enumTypes[1]
}

func (x BuildEvent_BuildComponentStreamFinished_FinishType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BuildEvent_BuildComponentStreamFinished_FinishType.Descriptor instead.
func (BuildEvent_BuildComponentStreamFinished_FinishType) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_build_v1_build_events_proto_rawDescGZIP(), []int{0, 5, 0}
}

// Which build component generates this event stream. Each build component
// may generate one event stream.
type StreamId_BuildComponent int32

const (
	// Unknown or unspecified; callers should never set this value.
	StreamId_UNKNOWN_COMPONENT StreamId_BuildComponent = 0
	// A component that coordinates builds.
	StreamId_CONTROLLER StreamId_BuildComponent = 1
	// A component that runs executables needed to complete a build.
	StreamId_WORKER StreamId_BuildComponent = 2
	// A component that builds something.
	StreamId_TOOL StreamId_BuildComponent = 3
)

// Enum value maps for StreamId_BuildComponent.
var (
	StreamId_BuildComponent_name = map[int32]string{
		0: "UNKNOWN_COMPONENT",
		1: "CONTROLLER",
		2: "WORKER",
		3: "TOOL",
	}
	StreamId_BuildComponent_value = map[string]int32{
		"UNKNOWN_COMPONENT": 0,
		"CONTROLLER":        1,
		"WORKER":            2,
		"TOOL":              3,
	}
)

func (x StreamId_BuildComponent) Enum() *StreamId_BuildComponent {
	p := new(StreamId_BuildComponent)
	*p = x
	return p
}

func (x StreamId_BuildComponent) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StreamId_BuildComponent) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_build_v1_build_events_proto_enumTypes[2].Descriptor()
}

func (StreamId_BuildComponent) Type() protoreflect.EnumType {
	return &file_google_devtools_build_v1_build_events_proto_enumTypes[2]
}

func (x StreamId_BuildComponent) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StreamId_BuildComponent.Descriptor instead.
func (StreamId_BuildComponent) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_build_v1_build_events_proto_rawDescGZIP(), []int{1, 0}
}

// An event representing some state change that occurred in the build. This
// message does not include field for uniquely identifying an event.
type BuildEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The timestamp of this event.
	EventTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=event_time,json=eventTime,proto3" json:"event_time,omitempty"`
	// //////////////////////////////////////////////////////////////////////////
	// Events that indicate a state change of a build request in the build
	// queue.
	//
	// Types that are assignable to Event:
	//	*BuildEvent_InvocationAttemptStarted_
	//	*BuildEvent_InvocationAttemptFinished_
	//	*BuildEvent_BuildEnqueued_
	//	*BuildEvent_BuildFinished_
	//	*BuildEvent_ConsoleOutput_
	//	*BuildEvent_ComponentStreamFinished
	//	*BuildEvent_BazelEvent
	//	*BuildEvent_BuildExecutionEvent
	//	*BuildEvent_SourceFetchEvent
	Event isBuildEvent_Event `protobuf_oneof:"event"`
}

func (x *BuildEvent) Reset() {
	*x = BuildEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_build_v1_build_events_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BuildEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BuildEvent) ProtoMessage() {}

func (x *BuildEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_build_v1_build_events_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BuildEvent.ProtoReflect.Descriptor instead.
func (*BuildEvent) Descriptor() ([]byte, []int) {
	return file_google_devtools_build_v1_build_events_proto_rawDescGZIP(), []int{0}
}

func (x *BuildEvent) GetEventTime() *timestamp.Timestamp {
	if x != nil {
		return x.EventTime
	}
	return nil
}

func (m *BuildEvent) GetEvent() isBuildEvent_Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (x *BuildEvent) GetInvocationAttemptStarted() *BuildEvent_InvocationAttemptStarted {
	if x, ok := x.GetEvent().(*BuildEvent_InvocationAttemptStarted_); ok {
		return x.InvocationAttemptStarted
	}
	return nil
}

func (x *BuildEvent) GetInvocationAttemptFinished() *BuildEvent_InvocationAttemptFinished {
	if x, ok := x.GetEvent().(*BuildEvent_InvocationAttemptFinished_); ok {
		return x.InvocationAttemptFinished
	}
	return nil
}

func (x *BuildEvent) GetBuildEnqueued() *BuildEvent_BuildEnqueued {
	if x, ok := x.GetEvent().(*BuildEvent_BuildEnqueued_); ok {
		return x.BuildEnqueued
	}
	return nil
}

func (x *BuildEvent) GetBuildFinished() *BuildEvent_BuildFinished {
	if x, ok := x.GetEvent().(*BuildEvent_BuildFinished_); ok {
		return x.BuildFinished
	}
	return nil
}

func (x *BuildEvent) GetConsoleOutput() *BuildEvent_ConsoleOutput {
	if x, ok := x.GetEvent().(*BuildEvent_ConsoleOutput_); ok {
		return x.ConsoleOutput
	}
	return nil
}

func (x *BuildEvent) GetComponentStreamFinished() *BuildEvent_BuildComponentStreamFinished {
	if x, ok := x.GetEvent().(*BuildEvent_ComponentStreamFinished); ok {
		return x.ComponentStreamFinished
	}
	return nil
}

func (x *BuildEvent) GetBazelEvent() *any.Any {
	if x, ok := x.GetEvent().(*BuildEvent_BazelEvent); ok {
		return x.BazelEvent
	}
	return nil
}

func (x *BuildEvent) GetBuildExecutionEvent() *any.Any {
	if x, ok := x.GetEvent().(*BuildEvent_BuildExecutionEvent); ok {
		return x.BuildExecutionEvent
	}
	return nil
}

func (x *BuildEvent) GetSourceFetchEvent() *any.Any {
	if x, ok := x.GetEvent().(*BuildEvent_SourceFetchEvent); ok {
		return x.SourceFetchEvent
	}
	return nil
}

type isBuildEvent_Event interface {
	isBuildEvent_Event()
}

type BuildEvent_InvocationAttemptStarted_ struct {
	// An invocation attempt has started.
	InvocationAttemptStarted *BuildEvent_InvocationAttemptStarted `protobuf:"bytes,51,opt,name=invocation_attempt_started,json=invocationAttemptStarted,proto3,oneof"`
}

type BuildEvent_InvocationAttemptFinished_ struct {
	// An invocation attempt has finished.
	InvocationAttemptFinished *BuildEvent_InvocationAttemptFinished `protobuf:"bytes,52,opt,name=invocation_attempt_finished,json=invocationAttemptFinished,proto3,oneof"`
}

type BuildEvent_BuildEnqueued_ struct {
	// The build is enqueued.
	BuildEnqueued *BuildEvent_BuildEnqueued `protobuf:"bytes,53,opt,name=build_enqueued,json=buildEnqueued,proto3,oneof"`
}

type BuildEvent_BuildFinished_ struct {
	// The build has finished. Set when the build is terminated.
	BuildFinished *BuildEvent_BuildFinished `protobuf:"bytes,55,opt,name=build_finished,json=buildFinished,proto3,oneof"`
}

type BuildEvent_ConsoleOutput_ struct {
	// An event containing printed text.
	ConsoleOutput *BuildEvent_ConsoleOutput `protobuf:"bytes,56,opt,name=console_output,json=consoleOutput,proto3,oneof"`
}

type BuildEvent_ComponentStreamFinished struct {
	// Indicates the end of a build event stream (with the same StreamId) from
	// a build component executing the requested build task.
	// *** This field does not indicate the WatchBuild RPC is finished. ***
	ComponentStreamFinished *BuildEvent_BuildComponentStreamFinished `protobuf:"bytes,59,opt,name=component_stream_finished,json=componentStreamFinished,proto3,oneof"`
}

type BuildEvent_BazelEvent struct {
	// Structured build event generated by Bazel about its execution progress.
	BazelEvent *any.Any `protobuf:"bytes,60,opt,name=bazel_event,json=bazelEvent,proto3,oneof"`
}

type BuildEvent_BuildExecutionEvent struct {
	// An event that contains supplemental tool-specific information about
	// build execution.
	BuildExecutionEvent *any.Any `protobuf:"bytes,61,opt,name=build_execution_event,json=buildExecutionEvent,proto3,oneof"`
}

type BuildEvent_SourceFetchEvent struct {
	// An event that contains supplemental tool-specific information about
	// source fetching.
	SourceFetchEvent *any.Any `protobuf:"bytes,62,opt,name=source_fetch_event,json=sourceFetchEvent,proto3,oneof"`
}

func (*BuildEvent_InvocationAttemptStarted_) isBuildEvent_Event() {}

func (*BuildEvent_InvocationAttemptFinished_) isBuildEvent_Event() {}

func (*BuildEvent_BuildEnqueued_) isBuildEvent_Event() {}

func (*BuildEvent_BuildFinished_) isBuildEvent_Event() {}

func (*BuildEvent_ConsoleOutput_) isBuildEvent_Event() {}

func (*BuildEvent_ComponentStreamFinished) isBuildEvent_Event() {}

func (*BuildEvent_BazelEvent) isBuildEvent_Event() {}

func (*BuildEvent_BuildExecutionEvent) isBuildEvent_Event() {}

func (*BuildEvent_SourceFetchEvent) isBuildEvent_Event() {}

// Unique identifier for a build event stream.
type StreamId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of a Build message.
	BuildId string `protobuf:"bytes,1,opt,name=build_id,json=buildId,proto3" json:"build_id,omitempty"`
	// The unique invocation ID within this build.
	// It should be the same as {invocation} (below) during the migration.
	InvocationId string `protobuf:"bytes,6,opt,name=invocation_id,json=invocationId,proto3" json:"invocation_id,omitempty"`
	// The component that emitted this event.
	Component StreamId_BuildComponent `protobuf:"varint,3,opt,name=component,proto3,enum=google.devtools.build.v1.StreamId_BuildComponent" json:"component,omitempty"`
}

func (x *StreamId) Reset() {
	*x = StreamId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_build_v1_build_events_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamId) ProtoMessage() {}

func (x *StreamId) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_build_v1_build_events_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamId.ProtoReflect.Descriptor instead.
func (*StreamId) Descriptor() ([]byte, []int) {
	return file_google_devtools_build_v1_build_events_proto_rawDescGZIP(), []int{1}
}

func (x *StreamId) GetBuildId() string {
	if x != nil {
		return x.BuildId
	}
	return ""
}

func (x *StreamId) GetInvocationId() string {
	if x != nil {
		return x.InvocationId
	}
	return ""
}

func (x *StreamId) GetComponent() StreamId_BuildComponent {
	if x != nil {
		return x.Component
	}
	return StreamId_UNKNOWN_COMPONENT
}

// Notification that the build system has attempted to run the build tool.
type BuildEvent_InvocationAttemptStarted struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of the invocation attempt, starting at 1 and increasing by 1
	// for each new attempt. Can be used to determine if there is a later
	// invocation attempt replacing the current one a client is processing.
	AttemptNumber int64 `protobuf:"varint,1,opt,name=attempt_number,json=attemptNumber,proto3" json:"attempt_number,omitempty"`
	// Arbitrary details about the invocation attempt.
	Details *any.Any `protobuf:"bytes,2,opt,name=details,proto3" json:"details,omitempty"`
}

func (x *BuildEvent_InvocationAttemptStarted) Reset() {
	*x = BuildEvent_InvocationAttemptStarted{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_build_v1_build_events_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BuildEvent_InvocationAttemptStarted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BuildEvent_InvocationAttemptStarted) ProtoMessage() {}

func (x *BuildEvent_InvocationAttemptStarted) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_build_v1_build_events_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BuildEvent_InvocationAttemptStarted.ProtoReflect.Descriptor instead.
func (*BuildEvent_InvocationAttemptStarted) Descriptor() ([]byte, []int) {
	return file_google_devtools_build_v1_build_events_proto_rawDescGZIP(), []int{0, 0}
}

func (x *BuildEvent_InvocationAttemptStarted) GetAttemptNumber() int64 {
	if x != nil {
		return x.AttemptNumber
	}
	return 0
}

func (x *BuildEvent_InvocationAttemptStarted) GetDetails() *any.Any {
	if x != nil {
		return x.Details
	}
	return nil
}

// Notification that an invocation attempt has finished.
type BuildEvent_InvocationAttemptFinished struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Final status of the invocation.
	InvocationStatus *BuildStatus `protobuf:"bytes,3,opt,name=invocation_status,json=invocationStatus,proto3" json:"invocation_status,omitempty"`
	// Arbitrary details about the invocation attempt.
	Details *any.Any `protobuf:"bytes,4,opt,name=details,proto3" json:"details,omitempty"`
}

func (x *BuildEvent_InvocationAttemptFinished) Reset() {
	*x = BuildEvent_InvocationAttemptFinished{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_build_v1_build_events_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BuildEvent_InvocationAttemptFinished) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BuildEvent_InvocationAttemptFinished) ProtoMessage() {}

func (x *BuildEvent_InvocationAttemptFinished) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_build_v1_build_events_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BuildEvent_InvocationAttemptFinished.ProtoReflect.Descriptor instead.
func (*BuildEvent_InvocationAttemptFinished) Descriptor() ([]byte, []int) {
	return file_google_devtools_build_v1_build_events_proto_rawDescGZIP(), []int{0, 1}
}

func (x *BuildEvent_InvocationAttemptFinished) GetInvocationStatus() *BuildStatus {
	if x != nil {
		return x.InvocationStatus
	}
	return nil
}

func (x *BuildEvent_InvocationAttemptFinished) GetDetails() *any.Any {
	if x != nil {
		return x.Details
	}
	return nil
}

// Notification that the build request is enqueued.
type BuildEvent_BuildEnqueued struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Additional details about the Build.
	Details *any.Any `protobuf:"bytes,1,opt,name=details,proto3" json:"details,omitempty"`
}

func (x *BuildEvent_BuildEnqueued) Reset() {
	*x = BuildEvent_BuildEnqueued{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_build_v1_build_events_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BuildEvent_BuildEnqueued) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BuildEvent_BuildEnqueued) ProtoMessage() {}

func (x *BuildEvent_BuildEnqueued) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_build_v1_build_events_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BuildEvent_BuildEnqueued.ProtoReflect.Descriptor instead.
func (*BuildEvent_BuildEnqueued) Descriptor() ([]byte, []int) {
	return file_google_devtools_build_v1_build_events_proto_rawDescGZIP(), []int{0, 2}
}

func (x *BuildEvent_BuildEnqueued) GetDetails() *any.Any {
	if x != nil {
		return x.Details
	}
	return nil
}

// Notification that the build request has finished, and no further
// invocations will occur.  Note that this applies to the entire Build.
// Individual invocations trigger InvocationFinished when they finish.
type BuildEvent_BuildFinished struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Final status of the build.
	Status *BuildStatus `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// Additional details about the Build.
	Details *any.Any `protobuf:"bytes,2,opt,name=details,proto3" json:"details,omitempty"`
}

func (x *BuildEvent_BuildFinished) Reset() {
	*x = BuildEvent_BuildFinished{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_build_v1_build_events_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BuildEvent_BuildFinished) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BuildEvent_BuildFinished) ProtoMessage() {}

func (x *BuildEvent_BuildFinished) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_build_v1_build_events_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BuildEvent_BuildFinished.ProtoReflect.Descriptor instead.
func (*BuildEvent_BuildFinished) Descriptor() ([]byte, []int) {
	return file_google_devtools_build_v1_build_events_proto_rawDescGZIP(), []int{0, 3}
}

func (x *BuildEvent_BuildFinished) GetStatus() *BuildStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *BuildEvent_BuildFinished) GetDetails() *any.Any {
	if x != nil {
		return x.Details
	}
	return nil
}

// Textual output written to standard output or standard error.
type BuildEvent_ConsoleOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The output stream type.
	Type ConsoleOutputStream `protobuf:"varint,1,opt,name=type,proto3,enum=google.devtools.build.v1.ConsoleOutputStream" json:"type,omitempty"`
	// The output stream content.
	//
	// Types that are assignable to Output:
	//	*BuildEvent_ConsoleOutput_TextOutput
	//	*BuildEvent_ConsoleOutput_BinaryOutput
	Output isBuildEvent_ConsoleOutput_Output `protobuf_oneof:"output"`
}

func (x *BuildEvent_ConsoleOutput) Reset() {
	*x = BuildEvent_ConsoleOutput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_build_v1_build_events_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BuildEvent_ConsoleOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BuildEvent_ConsoleOutput) ProtoMessage() {}

func (x *BuildEvent_ConsoleOutput) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_build_v1_build_events_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BuildEvent_ConsoleOutput.ProtoReflect.Descriptor instead.
func (*BuildEvent_ConsoleOutput) Descriptor() ([]byte, []int) {
	return file_google_devtools_build_v1_build_events_proto_rawDescGZIP(), []int{0, 4}
}

func (x *BuildEvent_ConsoleOutput) GetType() ConsoleOutputStream {
	if x != nil {
		return x.Type
	}
	return ConsoleOutputStream_UNKNOWN
}

func (m *BuildEvent_ConsoleOutput) GetOutput() isBuildEvent_ConsoleOutput_Output {
	if m != nil {
		return m.Output
	}
	return nil
}

func (x *BuildEvent_ConsoleOutput) GetTextOutput() string {
	if x, ok := x.GetOutput().(*BuildEvent_ConsoleOutput_TextOutput); ok {
		return x.TextOutput
	}
	return ""
}

func (x *BuildEvent_ConsoleOutput) GetBinaryOutput() []byte {
	if x, ok := x.GetOutput().(*BuildEvent_ConsoleOutput_BinaryOutput); ok {
		return x.BinaryOutput
	}
	return nil
}

type isBuildEvent_ConsoleOutput_Output interface {
	isBuildEvent_ConsoleOutput_Output()
}

type BuildEvent_ConsoleOutput_TextOutput struct {
	// Regular UTF-8 output; normal text.
	TextOutput string `protobuf:"bytes,2,opt,name=text_output,json=textOutput,proto3,oneof"`
}

type BuildEvent_ConsoleOutput_BinaryOutput struct {
	// Used if the output is not UTF-8 text (for example, a binary proto).
	BinaryOutput []byte `protobuf:"bytes,3,opt,name=binary_output,json=binaryOutput,proto3,oneof"`
}

func (*BuildEvent_ConsoleOutput_TextOutput) isBuildEvent_ConsoleOutput_Output() {}

func (*BuildEvent_ConsoleOutput_BinaryOutput) isBuildEvent_ConsoleOutput_Output() {}

// Notification of the end of a build event stream published by a build
// component other than CONTROLLER (See StreamId.BuildComponents).
type BuildEvent_BuildComponentStreamFinished struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// How the event stream finished.
	Type BuildEvent_BuildComponentStreamFinished_FinishType `protobuf:"varint,1,opt,name=type,proto3,enum=google.devtools.build.v1.BuildEvent_BuildComponentStreamFinished_FinishType" json:"type,omitempty"`
}

func (x *BuildEvent_BuildComponentStreamFinished) Reset() {
	*x = BuildEvent_BuildComponentStreamFinished{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_build_v1_build_events_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BuildEvent_BuildComponentStreamFinished) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BuildEvent_BuildComponentStreamFinished) ProtoMessage() {}

func (x *BuildEvent_BuildComponentStreamFinished) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_build_v1_build_events_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BuildEvent_BuildComponentStreamFinished.ProtoReflect.Descriptor instead.
func (*BuildEvent_BuildComponentStreamFinished) Descriptor() ([]byte, []int) {
	return file_google_devtools_build_v1_build_events_proto_rawDescGZIP(), []int{0, 5}
}

func (x *BuildEvent_BuildComponentStreamFinished) GetType() BuildEvent_BuildComponentStreamFinished_FinishType {
	if x != nil {
		return x.Type
	}
	return BuildEvent_BuildComponentStreamFinished_FINISH_TYPE_UNSPECIFIED
}

var File_google_devtools_build_v1_build_events_proto protoreflect.FileDescriptor

var file_google_devtools_build_v1_build_events_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x76,
	0x31, 0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xfd, 0x0d, 0x0a, 0x0a, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12,
	0x39, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x7d, 0x0a, 0x1a, 0x69, 0x6e,
	0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74,
	0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x18, 0x33, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x2e, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41,
	0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x53, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52,
	0x18, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x74, 0x74, 0x65, 0x6d,
	0x70, 0x74, 0x53, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x12, 0x80, 0x01, 0x0a, 0x1b, 0x69, 0x6e,
	0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74,
	0x5f, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x18, 0x34, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x48,
	0x00, 0x52, 0x19, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x74, 0x74,
	0x65, 0x6d, 0x70, 0x74, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x12, 0x5b, 0x0a, 0x0e,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x65, 0x6e, 0x71, 0x75, 0x65, 0x75, 0x65, 0x64, 0x18, 0x35,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x75, 0x69, 0x6c, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64,
	0x45, 0x6e, 0x71, 0x75, 0x65, 0x75, 0x65, 0x64, 0x48, 0x00, 0x52, 0x0d, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x45, 0x6e, 0x71, 0x75, 0x65, 0x75, 0x65, 0x64, 0x12, 0x5b, 0x0a, 0x0e, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x5f, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x18, 0x37, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x46, 0x69, 0x6e,
	0x69, 0x73, 0x68, 0x65, 0x64, 0x48, 0x00, 0x52, 0x0d, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x46, 0x69,
	0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x12, 0x5b, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x73, 0x6f, 0x6c,
	0x65, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x38, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x65, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x48, 0x00, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x65, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x12, 0x7f, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74,
	0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64,
	0x18, 0x3b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x48, 0x00, 0x52, 0x17, 0x63, 0x6f, 0x6d,
	0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x46, 0x69, 0x6e, 0x69,
	0x73, 0x68, 0x65, 0x64, 0x12, 0x37, 0x0a, 0x0b, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x5f, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x18, 0x3c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x48,
	0x00, 0x52, 0x0a, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x4a, 0x0a,
	0x15, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x3d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41,
	0x6e, 0x79, 0x48, 0x00, 0x52, 0x13, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x44, 0x0a, 0x12, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x66, 0x65, 0x74, 0x63, 0x68, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18,
	0x3e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x48, 0x00, 0x52, 0x10, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x65, 0x74, 0x63, 0x68, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x1a,
	0x71, 0x0a, 0x18, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x74, 0x74,
	0x65, 0x6d, 0x70, 0x74, 0x53, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x61,
	0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0d, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x4e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x12, 0x2e, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x1a, 0x9f, 0x01, 0x0a, 0x19, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64,
	0x12, 0x52, 0x0a, 0x11, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x10, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x2e, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x07, 0x64, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x1a, 0x3f, 0x0a, 0x0d, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x45, 0x6e, 0x71,
	0x75, 0x65, 0x75, 0x65, 0x64, 0x12, 0x2e, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x07, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x1a, 0x7e, 0x0a, 0x0d, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x46, 0x69,
	0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x12, 0x3d, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x2e, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x07, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x1a, 0xa6, 0x01, 0x0a, 0x0d, 0x43, 0x6f, 0x6e, 0x73, 0x6f, 0x6c,
	0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x0b, 0x74, 0x65,
	0x78, 0x74, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x25, 0x0a,
	0x0d, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0c, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x4f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x42, 0x08, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x1a, 0xc6,
	0x01, 0x0a, 0x1c, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e,
	0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x12,
	0x60, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65,
	0x6e, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64,
	0x2e, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x22, 0x44, 0x0a, 0x0a, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1b, 0x0a, 0x17, 0x46, 0x49, 0x4e, 0x49, 0x53, 0x48, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08,
	0x46, 0x49, 0x4e, 0x49, 0x53, 0x48, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x58,
	0x50, 0x49, 0x52, 0x45, 0x44, 0x10, 0x02, 0x42, 0x07, 0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x22, 0xea, 0x01, 0x0a, 0x08, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x64, 0x12, 0x19, 0x0a,
	0x08, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x76, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x4f, 0x0a,
	0x09, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x49, 0x64, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e,
	0x65, 0x6e, 0x74, 0x52, 0x09, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x22, 0x4d,
	0x0a, 0x0e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74,
	0x12, 0x15, 0x0a, 0x11, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x43, 0x4f, 0x4d, 0x50,
	0x4f, 0x4e, 0x45, 0x4e, 0x54, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x4f, 0x4e, 0x54, 0x52,
	0x4f, 0x4c, 0x4c, 0x45, 0x52, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x57, 0x4f, 0x52, 0x4b, 0x45,
	0x52, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x54, 0x4f, 0x4f, 0x4c, 0x10, 0x03, 0x2a, 0x3a, 0x0a,
	0x13, 0x43, 0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10,
	0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x44, 0x4f, 0x55, 0x54, 0x10, 0x01, 0x12, 0x0a, 0x0a,
	0x06, 0x53, 0x54, 0x44, 0x45, 0x52, 0x52, 0x10, 0x02, 0x42, 0x73, 0x0a, 0x1c, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x42, 0x0f, 0x42, 0x75, 0x69, 0x6c, 0x64,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3d, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f,
	0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x2f, 0x76, 0x31, 0x3b, 0x62, 0x75, 0x69, 0x6c, 0x64, 0xf8, 0x01, 0x01, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_devtools_build_v1_build_events_proto_rawDescOnce sync.Once
	file_google_devtools_build_v1_build_events_proto_rawDescData = file_google_devtools_build_v1_build_events_proto_rawDesc
)

func file_google_devtools_build_v1_build_events_proto_rawDescGZIP() []byte {
	file_google_devtools_build_v1_build_events_proto_rawDescOnce.Do(func() {
		file_google_devtools_build_v1_build_events_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_devtools_build_v1_build_events_proto_rawDescData)
	})
	return file_google_devtools_build_v1_build_events_proto_rawDescData
}

var file_google_devtools_build_v1_build_events_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_devtools_build_v1_build_events_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_devtools_build_v1_build_events_proto_goTypes = []interface{}{
	(ConsoleOutputStream)(0),                                // 0: google.devtools.build.v1.ConsoleOutputStream
	(BuildEvent_BuildComponentStreamFinished_FinishType)(0), // 1: google.devtools.build.v1.BuildEvent.BuildComponentStreamFinished.FinishType
	(StreamId_BuildComponent)(0),                            // 2: google.devtools.build.v1.StreamId.BuildComponent
	(*BuildEvent)(nil),                                      // 3: google.devtools.build.v1.BuildEvent
	(*StreamId)(nil),                                        // 4: google.devtools.build.v1.StreamId
	(*BuildEvent_InvocationAttemptStarted)(nil),             // 5: google.devtools.build.v1.BuildEvent.InvocationAttemptStarted
	(*BuildEvent_InvocationAttemptFinished)(nil),            // 6: google.devtools.build.v1.BuildEvent.InvocationAttemptFinished
	(*BuildEvent_BuildEnqueued)(nil),                        // 7: google.devtools.build.v1.BuildEvent.BuildEnqueued
	(*BuildEvent_BuildFinished)(nil),                        // 8: google.devtools.build.v1.BuildEvent.BuildFinished
	(*BuildEvent_ConsoleOutput)(nil),                        // 9: google.devtools.build.v1.BuildEvent.ConsoleOutput
	(*BuildEvent_BuildComponentStreamFinished)(nil),         // 10: google.devtools.build.v1.BuildEvent.BuildComponentStreamFinished
	(*timestamp.Timestamp)(nil),                             // 11: google.protobuf.Timestamp
	(*any.Any)(nil),                                         // 12: google.protobuf.Any
	(*BuildStatus)(nil),                                     // 13: google.devtools.build.v1.BuildStatus
}
var file_google_devtools_build_v1_build_events_proto_depIdxs = []int32{
	11, // 0: google.devtools.build.v1.BuildEvent.event_time:type_name -> google.protobuf.Timestamp
	5,  // 1: google.devtools.build.v1.BuildEvent.invocation_attempt_started:type_name -> google.devtools.build.v1.BuildEvent.InvocationAttemptStarted
	6,  // 2: google.devtools.build.v1.BuildEvent.invocation_attempt_finished:type_name -> google.devtools.build.v1.BuildEvent.InvocationAttemptFinished
	7,  // 3: google.devtools.build.v1.BuildEvent.build_enqueued:type_name -> google.devtools.build.v1.BuildEvent.BuildEnqueued
	8,  // 4: google.devtools.build.v1.BuildEvent.build_finished:type_name -> google.devtools.build.v1.BuildEvent.BuildFinished
	9,  // 5: google.devtools.build.v1.BuildEvent.console_output:type_name -> google.devtools.build.v1.BuildEvent.ConsoleOutput
	10, // 6: google.devtools.build.v1.BuildEvent.component_stream_finished:type_name -> google.devtools.build.v1.BuildEvent.BuildComponentStreamFinished
	12, // 7: google.devtools.build.v1.BuildEvent.bazel_event:type_name -> google.protobuf.Any
	12, // 8: google.devtools.build.v1.BuildEvent.build_execution_event:type_name -> google.protobuf.Any
	12, // 9: google.devtools.build.v1.BuildEvent.source_fetch_event:type_name -> google.protobuf.Any
	2,  // 10: google.devtools.build.v1.StreamId.component:type_name -> google.devtools.build.v1.StreamId.BuildComponent
	12, // 11: google.devtools.build.v1.BuildEvent.InvocationAttemptStarted.details:type_name -> google.protobuf.Any
	13, // 12: google.devtools.build.v1.BuildEvent.InvocationAttemptFinished.invocation_status:type_name -> google.devtools.build.v1.BuildStatus
	12, // 13: google.devtools.build.v1.BuildEvent.InvocationAttemptFinished.details:type_name -> google.protobuf.Any
	12, // 14: google.devtools.build.v1.BuildEvent.BuildEnqueued.details:type_name -> google.protobuf.Any
	13, // 15: google.devtools.build.v1.BuildEvent.BuildFinished.status:type_name -> google.devtools.build.v1.BuildStatus
	12, // 16: google.devtools.build.v1.BuildEvent.BuildFinished.details:type_name -> google.protobuf.Any
	0,  // 17: google.devtools.build.v1.BuildEvent.ConsoleOutput.type:type_name -> google.devtools.build.v1.ConsoleOutputStream
	1,  // 18: google.devtools.build.v1.BuildEvent.BuildComponentStreamFinished.type:type_name -> google.devtools.build.v1.BuildEvent.BuildComponentStreamFinished.FinishType
	19, // [19:19] is the sub-list for method output_type
	19, // [19:19] is the sub-list for method input_type
	19, // [19:19] is the sub-list for extension type_name
	19, // [19:19] is the sub-list for extension extendee
	0,  // [0:19] is the sub-list for field type_name
}

func init() { file_google_devtools_build_v1_build_events_proto_init() }
func file_google_devtools_build_v1_build_events_proto_init() {
	if File_google_devtools_build_v1_build_events_proto != nil {
		return
	}
	file_google_devtools_build_v1_build_status_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_devtools_build_v1_build_events_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BuildEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_build_v1_build_events_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_build_v1_build_events_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BuildEvent_InvocationAttemptStarted); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_build_v1_build_events_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BuildEvent_InvocationAttemptFinished); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_build_v1_build_events_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BuildEvent_BuildEnqueued); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_build_v1_build_events_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BuildEvent_BuildFinished); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_build_v1_build_events_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BuildEvent_ConsoleOutput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_build_v1_build_events_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BuildEvent_BuildComponentStreamFinished); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_devtools_build_v1_build_events_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*BuildEvent_InvocationAttemptStarted_)(nil),
		(*BuildEvent_InvocationAttemptFinished_)(nil),
		(*BuildEvent_BuildEnqueued_)(nil),
		(*BuildEvent_BuildFinished_)(nil),
		(*BuildEvent_ConsoleOutput_)(nil),
		(*BuildEvent_ComponentStreamFinished)(nil),
		(*BuildEvent_BazelEvent)(nil),
		(*BuildEvent_BuildExecutionEvent)(nil),
		(*BuildEvent_SourceFetchEvent)(nil),
	}
	file_google_devtools_build_v1_build_events_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*BuildEvent_ConsoleOutput_TextOutput)(nil),
		(*BuildEvent_ConsoleOutput_BinaryOutput)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_devtools_build_v1_build_events_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_devtools_build_v1_build_events_proto_goTypes,
		DependencyIndexes: file_google_devtools_build_v1_build_events_proto_depIdxs,
		EnumInfos:         file_google_devtools_build_v1_build_events_proto_enumTypes,
		MessageInfos:      file_google_devtools_build_v1_build_events_proto_msgTypes,
	}.Build()
	File_google_devtools_build_v1_build_events_proto = out.File
	file_google_devtools_build_v1_build_events_proto_rawDesc = nil
	file_google_devtools_build_v1_build_events_proto_goTypes = nil
	file_google_devtools_build_v1_build_events_proto_depIdxs = nil
}
