// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/ads/googleads/v3/resources/recommendation.proto

package resources

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	common "google.golang.org/genproto/googleapis/ads/googleads/v3/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v3/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// A recommendation.
type Recommendation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The resource name of the recommendation.
	//
	// `customers/{customer_id}/recommendations/{recommendation_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Output only. The type of recommendation.
	Type enums.RecommendationTypeEnum_RecommendationType `protobuf:"varint,2,opt,name=type,proto3,enum=google.ads.googleads.v3.enums.RecommendationTypeEnum_RecommendationType" json:"type,omitempty"`
	// Output only. The impact on account performance as a result of applying the
	// recommendation.
	Impact *Recommendation_RecommendationImpact `protobuf:"bytes,3,opt,name=impact,proto3" json:"impact,omitempty"`
	// Output only. The budget targeted by this recommendation. This will be set only when
	// the recommendation affects a single campaign budget.
	//
	// This field will be set for the following recommendation types:
	// CAMPAIGN_BUDGET, FORECASTING_CAMPAIGN_BUDGET, MOVE_UNUSED_BUDGET
	CampaignBudget *wrapperspb.StringValue `protobuf:"bytes,5,opt,name=campaign_budget,json=campaignBudget,proto3" json:"campaign_budget,omitempty"`
	// Output only. The campaign targeted by this recommendation. This will be set only when
	// the recommendation affects a single campaign.
	//
	// This field will be set for the following recommendation types:
	// CALL_EXTENSION, CALLOUT_EXTENSION, ENHANCED_CPC_OPT_IN, KEYWORD,
	// KEYWORD_MATCH_TYPE, MAXIMIZE_CLICKS_OPT_IN, MAXIMIZE_CONVERSIONS_OPT_IN,
	// OPTIMIZE_AD_ROTATION, SEARCH_PARTNERS_OPT_IN, SITELINK_EXTENSION,
	// TARGET_CPA_OPT_IN, TARGET_ROAS_OPT_IN, TEXT_AD
	Campaign *wrapperspb.StringValue `protobuf:"bytes,6,opt,name=campaign,proto3" json:"campaign,omitempty"`
	// Output only. The ad group targeted by this recommendation. This will be set only when
	// the recommendation affects a single ad group.
	//
	// This field will be set for the following recommendation types:
	// KEYWORD, OPTIMIZE_AD_ROTATION, TEXT_AD
	AdGroup *wrapperspb.StringValue `protobuf:"bytes,7,opt,name=ad_group,json=adGroup,proto3" json:"ad_group,omitempty"`
	// Output only. Whether the recommendation is dismissed or not.
	Dismissed *wrapperspb.BoolValue `protobuf:"bytes,13,opt,name=dismissed,proto3" json:"dismissed,omitempty"`
	// The details of recommendation.
	//
	// Types that are assignable to Recommendation:
	//	*Recommendation_CampaignBudgetRecommendation_
	//	*Recommendation_KeywordRecommendation_
	//	*Recommendation_TextAdRecommendation_
	//	*Recommendation_TargetCpaOptInRecommendation_
	//	*Recommendation_MaximizeConversionsOptInRecommendation_
	//	*Recommendation_EnhancedCpcOptInRecommendation_
	//	*Recommendation_SearchPartnersOptInRecommendation_
	//	*Recommendation_MaximizeClicksOptInRecommendation_
	//	*Recommendation_OptimizeAdRotationRecommendation_
	//	*Recommendation_CalloutExtensionRecommendation_
	//	*Recommendation_SitelinkExtensionRecommendation_
	//	*Recommendation_CallExtensionRecommendation_
	//	*Recommendation_KeywordMatchTypeRecommendation_
	//	*Recommendation_MoveUnusedBudgetRecommendation_
	Recommendation isRecommendation_Recommendation `protobuf_oneof:"recommendation"`
}

func (x *Recommendation) Reset() {
	*x = Recommendation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Recommendation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Recommendation) ProtoMessage() {}

func (x *Recommendation) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Recommendation.ProtoReflect.Descriptor instead.
func (*Recommendation) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_resources_recommendation_proto_rawDescGZIP(), []int{0}
}

func (x *Recommendation) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *Recommendation) GetType() enums.RecommendationTypeEnum_RecommendationType {
	if x != nil {
		return x.Type
	}
	return enums.RecommendationTypeEnum_UNSPECIFIED
}

func (x *Recommendation) GetImpact() *Recommendation_RecommendationImpact {
	if x != nil {
		return x.Impact
	}
	return nil
}

func (x *Recommendation) GetCampaignBudget() *wrapperspb.StringValue {
	if x != nil {
		return x.CampaignBudget
	}
	return nil
}

func (x *Recommendation) GetCampaign() *wrapperspb.StringValue {
	if x != nil {
		return x.Campaign
	}
	return nil
}

func (x *Recommendation) GetAdGroup() *wrapperspb.StringValue {
	if x != nil {
		return x.AdGroup
	}
	return nil
}

func (x *Recommendation) GetDismissed() *wrapperspb.BoolValue {
	if x != nil {
		return x.Dismissed
	}
	return nil
}

func (m *Recommendation) GetRecommendation() isRecommendation_Recommendation {
	if m != nil {
		return m.Recommendation
	}
	return nil
}

func (x *Recommendation) GetCampaignBudgetRecommendation() *Recommendation_CampaignBudgetRecommendation {
	if x, ok := x.GetRecommendation().(*Recommendation_CampaignBudgetRecommendation_); ok {
		return x.CampaignBudgetRecommendation
	}
	return nil
}

func (x *Recommendation) GetKeywordRecommendation() *Recommendation_KeywordRecommendation {
	if x, ok := x.GetRecommendation().(*Recommendation_KeywordRecommendation_); ok {
		return x.KeywordRecommendation
	}
	return nil
}

func (x *Recommendation) GetTextAdRecommendation() *Recommendation_TextAdRecommendation {
	if x, ok := x.GetRecommendation().(*Recommendation_TextAdRecommendation_); ok {
		return x.TextAdRecommendation
	}
	return nil
}

func (x *Recommendation) GetTargetCpaOptInRecommendation() *Recommendation_TargetCpaOptInRecommendation {
	if x, ok := x.GetRecommendation().(*Recommendation_TargetCpaOptInRecommendation_); ok {
		return x.TargetCpaOptInRecommendation
	}
	return nil
}

func (x *Recommendation) GetMaximizeConversionsOptInRecommendation() *Recommendation_MaximizeConversionsOptInRecommendation {
	if x, ok := x.GetRecommendation().(*Recommendation_MaximizeConversionsOptInRecommendation_); ok {
		return x.MaximizeConversionsOptInRecommendation
	}
	return nil
}

func (x *Recommendation) GetEnhancedCpcOptInRecommendation() *Recommendation_EnhancedCpcOptInRecommendation {
	if x, ok := x.GetRecommendation().(*Recommendation_EnhancedCpcOptInRecommendation_); ok {
		return x.EnhancedCpcOptInRecommendation
	}
	return nil
}

func (x *Recommendation) GetSearchPartnersOptInRecommendation() *Recommendation_SearchPartnersOptInRecommendation {
	if x, ok := x.GetRecommendation().(*Recommendation_SearchPartnersOptInRecommendation_); ok {
		return x.SearchPartnersOptInRecommendation
	}
	return nil
}

func (x *Recommendation) GetMaximizeClicksOptInRecommendation() *Recommendation_MaximizeClicksOptInRecommendation {
	if x, ok := x.GetRecommendation().(*Recommendation_MaximizeClicksOptInRecommendation_); ok {
		return x.MaximizeClicksOptInRecommendation
	}
	return nil
}

func (x *Recommendation) GetOptimizeAdRotationRecommendation() *Recommendation_OptimizeAdRotationRecommendation {
	if x, ok := x.GetRecommendation().(*Recommendation_OptimizeAdRotationRecommendation_); ok {
		return x.OptimizeAdRotationRecommendation
	}
	return nil
}

func (x *Recommendation) GetCalloutExtensionRecommendation() *Recommendation_CalloutExtensionRecommendation {
	if x, ok := x.GetRecommendation().(*Recommendation_CalloutExtensionRecommendation_); ok {
		return x.CalloutExtensionRecommendation
	}
	return nil
}

func (x *Recommendation) GetSitelinkExtensionRecommendation() *Recommendation_SitelinkExtensionRecommendation {
	if x, ok := x.GetRecommendation().(*Recommendation_SitelinkExtensionRecommendation_); ok {
		return x.SitelinkExtensionRecommendation
	}
	return nil
}

func (x *Recommendation) GetCallExtensionRecommendation() *Recommendation_CallExtensionRecommendation {
	if x, ok := x.GetRecommendation().(*Recommendation_CallExtensionRecommendation_); ok {
		return x.CallExtensionRecommendation
	}
	return nil
}

func (x *Recommendation) GetKeywordMatchTypeRecommendation() *Recommendation_KeywordMatchTypeRecommendation {
	if x, ok := x.GetRecommendation().(*Recommendation_KeywordMatchTypeRecommendation_); ok {
		return x.KeywordMatchTypeRecommendation
	}
	return nil
}

func (x *Recommendation) GetMoveUnusedBudgetRecommendation() *Recommendation_MoveUnusedBudgetRecommendation {
	if x, ok := x.GetRecommendation().(*Recommendation_MoveUnusedBudgetRecommendation_); ok {
		return x.MoveUnusedBudgetRecommendation
	}
	return nil
}

type isRecommendation_Recommendation interface {
	isRecommendation_Recommendation()
}

type Recommendation_CampaignBudgetRecommendation_ struct {
	// Output only. The campaign budget recommendation.
	CampaignBudgetRecommendation *Recommendation_CampaignBudgetRecommendation `protobuf:"bytes,4,opt,name=campaign_budget_recommendation,json=campaignBudgetRecommendation,proto3,oneof"`
}

type Recommendation_KeywordRecommendation_ struct {
	// Output only. The keyword recommendation.
	KeywordRecommendation *Recommendation_KeywordRecommendation `protobuf:"bytes,8,opt,name=keyword_recommendation,json=keywordRecommendation,proto3,oneof"`
}

type Recommendation_TextAdRecommendation_ struct {
	// Output only. Add expanded text ad recommendation.
	TextAdRecommendation *Recommendation_TextAdRecommendation `protobuf:"bytes,9,opt,name=text_ad_recommendation,json=textAdRecommendation,proto3,oneof"`
}

type Recommendation_TargetCpaOptInRecommendation_ struct {
	// Output only. The TargetCPA opt-in recommendation.
	TargetCpaOptInRecommendation *Recommendation_TargetCpaOptInRecommendation `protobuf:"bytes,10,opt,name=target_cpa_opt_in_recommendation,json=targetCpaOptInRecommendation,proto3,oneof"`
}

type Recommendation_MaximizeConversionsOptInRecommendation_ struct {
	// Output only. The MaximizeConversions Opt-In recommendation.
	MaximizeConversionsOptInRecommendation *Recommendation_MaximizeConversionsOptInRecommendation `protobuf:"bytes,11,opt,name=maximize_conversions_opt_in_recommendation,json=maximizeConversionsOptInRecommendation,proto3,oneof"`
}

type Recommendation_EnhancedCpcOptInRecommendation_ struct {
	// Output only. The Enhanced Cost-Per-Click Opt-In recommendation.
	EnhancedCpcOptInRecommendation *Recommendation_EnhancedCpcOptInRecommendation `protobuf:"bytes,12,opt,name=enhanced_cpc_opt_in_recommendation,json=enhancedCpcOptInRecommendation,proto3,oneof"`
}

type Recommendation_SearchPartnersOptInRecommendation_ struct {
	// Output only. The Search Partners Opt-In recommendation.
	SearchPartnersOptInRecommendation *Recommendation_SearchPartnersOptInRecommendation `protobuf:"bytes,14,opt,name=search_partners_opt_in_recommendation,json=searchPartnersOptInRecommendation,proto3,oneof"`
}

type Recommendation_MaximizeClicksOptInRecommendation_ struct {
	// Output only. The MaximizeClicks Opt-In recommendation.
	MaximizeClicksOptInRecommendation *Recommendation_MaximizeClicksOptInRecommendation `protobuf:"bytes,15,opt,name=maximize_clicks_opt_in_recommendation,json=maximizeClicksOptInRecommendation,proto3,oneof"`
}

type Recommendation_OptimizeAdRotationRecommendation_ struct {
	// Output only. The Optimize Ad Rotation recommendation.
	OptimizeAdRotationRecommendation *Recommendation_OptimizeAdRotationRecommendation `protobuf:"bytes,16,opt,name=optimize_ad_rotation_recommendation,json=optimizeAdRotationRecommendation,proto3,oneof"`
}

type Recommendation_CalloutExtensionRecommendation_ struct {
	// Output only. The Callout extension recommendation.
	CalloutExtensionRecommendation *Recommendation_CalloutExtensionRecommendation `protobuf:"bytes,17,opt,name=callout_extension_recommendation,json=calloutExtensionRecommendation,proto3,oneof"`
}

type Recommendation_SitelinkExtensionRecommendation_ struct {
	// Output only. The Sitelink extension recommendation.
	SitelinkExtensionRecommendation *Recommendation_SitelinkExtensionRecommendation `protobuf:"bytes,18,opt,name=sitelink_extension_recommendation,json=sitelinkExtensionRecommendation,proto3,oneof"`
}

type Recommendation_CallExtensionRecommendation_ struct {
	// Output only. The Call extension recommendation.
	CallExtensionRecommendation *Recommendation_CallExtensionRecommendation `protobuf:"bytes,19,opt,name=call_extension_recommendation,json=callExtensionRecommendation,proto3,oneof"`
}

type Recommendation_KeywordMatchTypeRecommendation_ struct {
	// Output only. The keyword match type recommendation.
	KeywordMatchTypeRecommendation *Recommendation_KeywordMatchTypeRecommendation `protobuf:"bytes,20,opt,name=keyword_match_type_recommendation,json=keywordMatchTypeRecommendation,proto3,oneof"`
}

type Recommendation_MoveUnusedBudgetRecommendation_ struct {
	// Output only. The move unused budget recommendation.
	MoveUnusedBudgetRecommendation *Recommendation_MoveUnusedBudgetRecommendation `protobuf:"bytes,21,opt,name=move_unused_budget_recommendation,json=moveUnusedBudgetRecommendation,proto3,oneof"`
}

func (*Recommendation_CampaignBudgetRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_KeywordRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_TextAdRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_TargetCpaOptInRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_MaximizeConversionsOptInRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_EnhancedCpcOptInRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_SearchPartnersOptInRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_MaximizeClicksOptInRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_OptimizeAdRotationRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_CalloutExtensionRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_SitelinkExtensionRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_CallExtensionRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_KeywordMatchTypeRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_MoveUnusedBudgetRecommendation_) isRecommendation_Recommendation() {}

// The impact of making the change as described in the recommendation.
// Some types of recommendations may not have impact information.
type Recommendation_RecommendationImpact struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Base metrics at the time the recommendation was generated.
	BaseMetrics *Recommendation_RecommendationMetrics `protobuf:"bytes,1,opt,name=base_metrics,json=baseMetrics,proto3" json:"base_metrics,omitempty"`
	// Output only. Estimated metrics if the recommendation is applied.
	PotentialMetrics *Recommendation_RecommendationMetrics `protobuf:"bytes,2,opt,name=potential_metrics,json=potentialMetrics,proto3" json:"potential_metrics,omitempty"`
}

func (x *Recommendation_RecommendationImpact) Reset() {
	*x = Recommendation_RecommendationImpact{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Recommendation_RecommendationImpact) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Recommendation_RecommendationImpact) ProtoMessage() {}

func (x *Recommendation_RecommendationImpact) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Recommendation_RecommendationImpact.ProtoReflect.Descriptor instead.
func (*Recommendation_RecommendationImpact) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_resources_recommendation_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Recommendation_RecommendationImpact) GetBaseMetrics() *Recommendation_RecommendationMetrics {
	if x != nil {
		return x.BaseMetrics
	}
	return nil
}

func (x *Recommendation_RecommendationImpact) GetPotentialMetrics() *Recommendation_RecommendationMetrics {
	if x != nil {
		return x.PotentialMetrics
	}
	return nil
}

// Weekly account performance metrics. For some recommendation types, these
// are averaged over the past 90-day period and hence can be fractional.
type Recommendation_RecommendationMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Number of ad impressions.
	Impressions *wrapperspb.DoubleValue `protobuf:"bytes,1,opt,name=impressions,proto3" json:"impressions,omitempty"`
	// Output only. Number of ad clicks.
	Clicks *wrapperspb.DoubleValue `protobuf:"bytes,2,opt,name=clicks,proto3" json:"clicks,omitempty"`
	// Output only. Cost (in micros) for advertising, in the local currency for the account.
	CostMicros *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=cost_micros,json=costMicros,proto3" json:"cost_micros,omitempty"`
	// Output only. Number of conversions.
	Conversions *wrapperspb.DoubleValue `protobuf:"bytes,4,opt,name=conversions,proto3" json:"conversions,omitempty"`
	// Output only. Number of video views for a video ad campaign.
	VideoViews *wrapperspb.DoubleValue `protobuf:"bytes,5,opt,name=video_views,json=videoViews,proto3" json:"video_views,omitempty"`
}

func (x *Recommendation_RecommendationMetrics) Reset() {
	*x = Recommendation_RecommendationMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Recommendation_RecommendationMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Recommendation_RecommendationMetrics) ProtoMessage() {}

func (x *Recommendation_RecommendationMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Recommendation_RecommendationMetrics.ProtoReflect.Descriptor instead.
func (*Recommendation_RecommendationMetrics) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_resources_recommendation_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Recommendation_RecommendationMetrics) GetImpressions() *wrapperspb.DoubleValue {
	if x != nil {
		return x.Impressions
	}
	return nil
}

func (x *Recommendation_RecommendationMetrics) GetClicks() *wrapperspb.DoubleValue {
	if x != nil {
		return x.Clicks
	}
	return nil
}

func (x *Recommendation_RecommendationMetrics) GetCostMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.CostMicros
	}
	return nil
}

func (x *Recommendation_RecommendationMetrics) GetConversions() *wrapperspb.DoubleValue {
	if x != nil {
		return x.Conversions
	}
	return nil
}

func (x *Recommendation_RecommendationMetrics) GetVideoViews() *wrapperspb.DoubleValue {
	if x != nil {
		return x.VideoViews
	}
	return nil
}

// The budget recommendation for budget constrained campaigns.
type Recommendation_CampaignBudgetRecommendation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The current budget amount in micros.
	CurrentBudgetAmountMicros *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=current_budget_amount_micros,json=currentBudgetAmountMicros,proto3" json:"current_budget_amount_micros,omitempty"`
	// Output only. The recommended budget amount in micros.
	RecommendedBudgetAmountMicros *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=recommended_budget_amount_micros,json=recommendedBudgetAmountMicros,proto3" json:"recommended_budget_amount_micros,omitempty"`
	// Output only. The budget amounts and associated impact estimates for some values of
	// possible budget amounts.
	BudgetOptions []*Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption `protobuf:"bytes,3,rep,name=budget_options,json=budgetOptions,proto3" json:"budget_options,omitempty"`
}

func (x *Recommendation_CampaignBudgetRecommendation) Reset() {
	*x = Recommendation_CampaignBudgetRecommendation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Recommendation_CampaignBudgetRecommendation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Recommendation_CampaignBudgetRecommendation) ProtoMessage() {}

func (x *Recommendation_CampaignBudgetRecommendation) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Recommendation_CampaignBudgetRecommendation.ProtoReflect.Descriptor instead.
func (*Recommendation_CampaignBudgetRecommendation) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_resources_recommendation_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Recommendation_CampaignBudgetRecommendation) GetCurrentBudgetAmountMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.CurrentBudgetAmountMicros
	}
	return nil
}

func (x *Recommendation_CampaignBudgetRecommendation) GetRecommendedBudgetAmountMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.RecommendedBudgetAmountMicros
	}
	return nil
}

func (x *Recommendation_CampaignBudgetRecommendation) GetBudgetOptions() []*Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption {
	if x != nil {
		return x.BudgetOptions
	}
	return nil
}

// The keyword recommendation.
type Recommendation_KeywordRecommendation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The recommended keyword.
	Keyword *common.KeywordInfo `protobuf:"bytes,1,opt,name=keyword,proto3" json:"keyword,omitempty"`
	// Output only. The recommended CPC (cost-per-click) bid.
	RecommendedCpcBidMicros *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=recommended_cpc_bid_micros,json=recommendedCpcBidMicros,proto3" json:"recommended_cpc_bid_micros,omitempty"`
}

func (x *Recommendation_KeywordRecommendation) Reset() {
	*x = Recommendation_KeywordRecommendation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Recommendation_KeywordRecommendation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Recommendation_KeywordRecommendation) ProtoMessage() {}

func (x *Recommendation_KeywordRecommendation) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Recommendation_KeywordRecommendation.ProtoReflect.Descriptor instead.
func (*Recommendation_KeywordRecommendation) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_resources_recommendation_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Recommendation_KeywordRecommendation) GetKeyword() *common.KeywordInfo {
	if x != nil {
		return x.Keyword
	}
	return nil
}

func (x *Recommendation_KeywordRecommendation) GetRecommendedCpcBidMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.RecommendedCpcBidMicros
	}
	return nil
}

// The Optimize Ad Rotation recommendation.
type Recommendation_OptimizeAdRotationRecommendation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Recommendation_OptimizeAdRotationRecommendation) Reset() {
	*x = Recommendation_OptimizeAdRotationRecommendation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Recommendation_OptimizeAdRotationRecommendation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Recommendation_OptimizeAdRotationRecommendation) ProtoMessage() {}

func (x *Recommendation_OptimizeAdRotationRecommendation) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Recommendation_OptimizeAdRotationRecommendation.ProtoReflect.Descriptor instead.
func (*Recommendation_OptimizeAdRotationRecommendation) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_resources_recommendation_proto_rawDescGZIP(), []int{0, 4}
}

// The text ad recommendation.
type Recommendation_TextAdRecommendation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Recommended ad.
	Ad *Ad `protobuf:"bytes,1,opt,name=ad,proto3" json:"ad,omitempty"`
	// Output only. Creation date of the recommended ad.
	// YYYY-MM-DD format, e.g., 2018-04-17.
	CreationDate *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=creation_date,json=creationDate,proto3" json:"creation_date,omitempty"`
	// Output only. Date, if present, is the earliest when the recommendation will be auto
	// applied.
	// YYYY-MM-DD format, e.g., 2018-04-17.
	AutoApplyDate *wrapperspb.StringValue `protobuf:"bytes,3,opt,name=auto_apply_date,json=autoApplyDate,proto3" json:"auto_apply_date,omitempty"`
}

func (x *Recommendation_TextAdRecommendation) Reset() {
	*x = Recommendation_TextAdRecommendation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Recommendation_TextAdRecommendation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Recommendation_TextAdRecommendation) ProtoMessage() {}

func (x *Recommendation_TextAdRecommendation) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Recommendation_TextAdRecommendation.ProtoReflect.Descriptor instead.
func (*Recommendation_TextAdRecommendation) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_resources_recommendation_proto_rawDescGZIP(), []int{0, 5}
}

func (x *Recommendation_TextAdRecommendation) GetAd() *Ad {
	if x != nil {
		return x.Ad
	}
	return nil
}

func (x *Recommendation_TextAdRecommendation) GetCreationDate() *wrapperspb.StringValue {
	if x != nil {
		return x.CreationDate
	}
	return nil
}

func (x *Recommendation_TextAdRecommendation) GetAutoApplyDate() *wrapperspb.StringValue {
	if x != nil {
		return x.AutoApplyDate
	}
	return nil
}

// The Target CPA opt-in recommendation.
type Recommendation_TargetCpaOptInRecommendation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The available goals and corresponding options for Target CPA strategy.
	Options []*Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption `protobuf:"bytes,1,rep,name=options,proto3" json:"options,omitempty"`
	// Output only. The recommended average CPA target. See required budget amount and impact
	// of using this recommendation in options list.
	RecommendedTargetCpaMicros *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=recommended_target_cpa_micros,json=recommendedTargetCpaMicros,proto3" json:"recommended_target_cpa_micros,omitempty"`
}

func (x *Recommendation_TargetCpaOptInRecommendation) Reset() {
	*x = Recommendation_TargetCpaOptInRecommendation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Recommendation_TargetCpaOptInRecommendation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Recommendation_TargetCpaOptInRecommendation) ProtoMessage() {}

func (x *Recommendation_TargetCpaOptInRecommendation) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Recommendation_TargetCpaOptInRecommendation.ProtoReflect.Descriptor instead.
func (*Recommendation_TargetCpaOptInRecommendation) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_resources_recommendation_proto_rawDescGZIP(), []int{0, 6}
}

func (x *Recommendation_TargetCpaOptInRecommendation) GetOptions() []*Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *Recommendation_TargetCpaOptInRecommendation) GetRecommendedTargetCpaMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.RecommendedTargetCpaMicros
	}
	return nil
}

// The Enhanced Cost-Per-Click Opt-In recommendation.
type Recommendation_EnhancedCpcOptInRecommendation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Recommendation_EnhancedCpcOptInRecommendation) Reset() {
	*x = Recommendation_EnhancedCpcOptInRecommendation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Recommendation_EnhancedCpcOptInRecommendation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Recommendation_EnhancedCpcOptInRecommendation) ProtoMessage() {}

func (x *Recommendation_EnhancedCpcOptInRecommendation) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Recommendation_EnhancedCpcOptInRecommendation.ProtoReflect.Descriptor instead.
func (*Recommendation_EnhancedCpcOptInRecommendation) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_resources_recommendation_proto_rawDescGZIP(), []int{0, 7}
}

// The Maximize Clicks opt-in recommendation.
type Recommendation_MaximizeClicksOptInRecommendation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The recommended new budget amount.
	// Only set if the current budget is too high.
	RecommendedBudgetAmountMicros *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=recommended_budget_amount_micros,json=recommendedBudgetAmountMicros,proto3" json:"recommended_budget_amount_micros,omitempty"`
}

func (x *Recommendation_MaximizeClicksOptInRecommendation) Reset() {
	*x = Recommendation_MaximizeClicksOptInRecommendation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Recommendation_MaximizeClicksOptInRecommendation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Recommendation_MaximizeClicksOptInRecommendation) ProtoMessage() {}

func (x *Recommendation_MaximizeClicksOptInRecommendation) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Recommendation_MaximizeClicksOptInRecommendation.ProtoReflect.Descriptor instead.
func (*Recommendation_MaximizeClicksOptInRecommendation) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_resources_recommendation_proto_rawDescGZIP(), []int{0, 8}
}

func (x *Recommendation_MaximizeClicksOptInRecommendation) GetRecommendedBudgetAmountMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.RecommendedBudgetAmountMicros
	}
	return nil
}

// The Maximize Conversions Opt-In recommendation.
type Recommendation_MaximizeConversionsOptInRecommendation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The recommended new budget amount.
	RecommendedBudgetAmountMicros *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=recommended_budget_amount_micros,json=recommendedBudgetAmountMicros,proto3" json:"recommended_budget_amount_micros,omitempty"`
}

func (x *Recommendation_MaximizeConversionsOptInRecommendation) Reset() {
	*x = Recommendation_MaximizeConversionsOptInRecommendation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Recommendation_MaximizeConversionsOptInRecommendation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Recommendation_MaximizeConversionsOptInRecommendation) ProtoMessage() {}

func (x *Recommendation_MaximizeConversionsOptInRecommendation) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Recommendation_MaximizeConversionsOptInRecommendation.ProtoReflect.Descriptor instead.
func (*Recommendation_MaximizeConversionsOptInRecommendation) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_resources_recommendation_proto_rawDescGZIP(), []int{0, 9}
}

func (x *Recommendation_MaximizeConversionsOptInRecommendation) GetRecommendedBudgetAmountMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.RecommendedBudgetAmountMicros
	}
	return nil
}

// The Call extension recommendation.
type Recommendation_CallExtensionRecommendation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Call extensions recommended to be added.
	RecommendedExtensions []*common.CallFeedItem `protobuf:"bytes,1,rep,name=recommended_extensions,json=recommendedExtensions,proto3" json:"recommended_extensions,omitempty"`
}

func (x *Recommendation_CallExtensionRecommendation) Reset() {
	*x = Recommendation_CallExtensionRecommendation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Recommendation_CallExtensionRecommendation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Recommendation_CallExtensionRecommendation) ProtoMessage() {}

func (x *Recommendation_CallExtensionRecommendation) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Recommendation_CallExtensionRecommendation.ProtoReflect.Descriptor instead.
func (*Recommendation_CallExtensionRecommendation) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_resources_recommendation_proto_rawDescGZIP(), []int{0, 10}
}

func (x *Recommendation_CallExtensionRecommendation) GetRecommendedExtensions() []*common.CallFeedItem {
	if x != nil {
		return x.RecommendedExtensions
	}
	return nil
}

// The Search Partners Opt-In recommendation.
type Recommendation_SearchPartnersOptInRecommendation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Recommendation_SearchPartnersOptInRecommendation) Reset() {
	*x = Recommendation_SearchPartnersOptInRecommendation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Recommendation_SearchPartnersOptInRecommendation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Recommendation_SearchPartnersOptInRecommendation) ProtoMessage() {}

func (x *Recommendation_SearchPartnersOptInRecommendation) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Recommendation_SearchPartnersOptInRecommendation.ProtoReflect.Descriptor instead.
func (*Recommendation_SearchPartnersOptInRecommendation) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_resources_recommendation_proto_rawDescGZIP(), []int{0, 11}
}

// The Callout extension recommendation.
type Recommendation_CalloutExtensionRecommendation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Callout extensions recommended to be added.
	RecommendedExtensions []*common.CalloutFeedItem `protobuf:"bytes,1,rep,name=recommended_extensions,json=recommendedExtensions,proto3" json:"recommended_extensions,omitempty"`
}

func (x *Recommendation_CalloutExtensionRecommendation) Reset() {
	*x = Recommendation_CalloutExtensionRecommendation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Recommendation_CalloutExtensionRecommendation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Recommendation_CalloutExtensionRecommendation) ProtoMessage() {}

func (x *Recommendation_CalloutExtensionRecommendation) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Recommendation_CalloutExtensionRecommendation.ProtoReflect.Descriptor instead.
func (*Recommendation_CalloutExtensionRecommendation) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_resources_recommendation_proto_rawDescGZIP(), []int{0, 12}
}

func (x *Recommendation_CalloutExtensionRecommendation) GetRecommendedExtensions() []*common.CalloutFeedItem {
	if x != nil {
		return x.RecommendedExtensions
	}
	return nil
}

// The Sitelink extension recommendation.
type Recommendation_SitelinkExtensionRecommendation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Sitelink extensions recommended to be added.
	RecommendedExtensions []*common.SitelinkFeedItem `protobuf:"bytes,1,rep,name=recommended_extensions,json=recommendedExtensions,proto3" json:"recommended_extensions,omitempty"`
}

func (x *Recommendation_SitelinkExtensionRecommendation) Reset() {
	*x = Recommendation_SitelinkExtensionRecommendation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Recommendation_SitelinkExtensionRecommendation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Recommendation_SitelinkExtensionRecommendation) ProtoMessage() {}

func (x *Recommendation_SitelinkExtensionRecommendation) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Recommendation_SitelinkExtensionRecommendation.ProtoReflect.Descriptor instead.
func (*Recommendation_SitelinkExtensionRecommendation) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_resources_recommendation_proto_rawDescGZIP(), []int{0, 13}
}

func (x *Recommendation_SitelinkExtensionRecommendation) GetRecommendedExtensions() []*common.SitelinkFeedItem {
	if x != nil {
		return x.RecommendedExtensions
	}
	return nil
}

// The keyword match type recommendation.
type Recommendation_KeywordMatchTypeRecommendation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The existing keyword where the match type should be more broad.
	Keyword *common.KeywordInfo `protobuf:"bytes,1,opt,name=keyword,proto3" json:"keyword,omitempty"`
	// Output only. The recommended new match type.
	RecommendedMatchType enums.KeywordMatchTypeEnum_KeywordMatchType `protobuf:"varint,2,opt,name=recommended_match_type,json=recommendedMatchType,proto3,enum=google.ads.googleads.v3.enums.KeywordMatchTypeEnum_KeywordMatchType" json:"recommended_match_type,omitempty"`
}

func (x *Recommendation_KeywordMatchTypeRecommendation) Reset() {
	*x = Recommendation_KeywordMatchTypeRecommendation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Recommendation_KeywordMatchTypeRecommendation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Recommendation_KeywordMatchTypeRecommendation) ProtoMessage() {}

func (x *Recommendation_KeywordMatchTypeRecommendation) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Recommendation_KeywordMatchTypeRecommendation.ProtoReflect.Descriptor instead.
func (*Recommendation_KeywordMatchTypeRecommendation) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_resources_recommendation_proto_rawDescGZIP(), []int{0, 14}
}

func (x *Recommendation_KeywordMatchTypeRecommendation) GetKeyword() *common.KeywordInfo {
	if x != nil {
		return x.Keyword
	}
	return nil
}

func (x *Recommendation_KeywordMatchTypeRecommendation) GetRecommendedMatchType() enums.KeywordMatchTypeEnum_KeywordMatchType {
	if x != nil {
		return x.RecommendedMatchType
	}
	return enums.KeywordMatchTypeEnum_UNSPECIFIED
}

// The move unused budget recommendation.
type Recommendation_MoveUnusedBudgetRecommendation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The excess budget's resource_name.
	ExcessCampaignBudget *wrapperspb.StringValue `protobuf:"bytes,1,opt,name=excess_campaign_budget,json=excessCampaignBudget,proto3" json:"excess_campaign_budget,omitempty"`
	// Output only. The recommendation for the constrained budget to increase.
	BudgetRecommendation *Recommendation_CampaignBudgetRecommendation `protobuf:"bytes,2,opt,name=budget_recommendation,json=budgetRecommendation,proto3" json:"budget_recommendation,omitempty"`
}

func (x *Recommendation_MoveUnusedBudgetRecommendation) Reset() {
	*x = Recommendation_MoveUnusedBudgetRecommendation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Recommendation_MoveUnusedBudgetRecommendation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Recommendation_MoveUnusedBudgetRecommendation) ProtoMessage() {}

func (x *Recommendation_MoveUnusedBudgetRecommendation) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Recommendation_MoveUnusedBudgetRecommendation.ProtoReflect.Descriptor instead.
func (*Recommendation_MoveUnusedBudgetRecommendation) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_resources_recommendation_proto_rawDescGZIP(), []int{0, 15}
}

func (x *Recommendation_MoveUnusedBudgetRecommendation) GetExcessCampaignBudget() *wrapperspb.StringValue {
	if x != nil {
		return x.ExcessCampaignBudget
	}
	return nil
}

func (x *Recommendation_MoveUnusedBudgetRecommendation) GetBudgetRecommendation() *Recommendation_CampaignBudgetRecommendation {
	if x != nil {
		return x.BudgetRecommendation
	}
	return nil
}

// The impact estimates for a given budget amount.
type Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The budget amount for this option.
	BudgetAmountMicros *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=budget_amount_micros,json=budgetAmountMicros,proto3" json:"budget_amount_micros,omitempty"`
	// Output only. The impact estimate if budget is changed to amount specified in this
	// option.
	Impact *Recommendation_RecommendationImpact `protobuf:"bytes,2,opt,name=impact,proto3" json:"impact,omitempty"`
}

func (x *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) Reset() {
	*x = Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) ProtoMessage() {
}

func (x *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption.ProtoReflect.Descriptor instead.
func (*Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_resources_recommendation_proto_rawDescGZIP(), []int{0, 2, 0}
}

func (x *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) GetBudgetAmountMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.BudgetAmountMicros
	}
	return nil
}

func (x *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) GetImpact() *Recommendation_RecommendationImpact {
	if x != nil {
		return x.Impact
	}
	return nil
}

// The Target CPA opt-in option with impact estimate.
type Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The goal achieved by this option.
	Goal enums.TargetCpaOptInRecommendationGoalEnum_TargetCpaOptInRecommendationGoal `protobuf:"varint,1,opt,name=goal,proto3,enum=google.ads.googleads.v3.enums.TargetCpaOptInRecommendationGoalEnum_TargetCpaOptInRecommendationGoal" json:"goal,omitempty"`
	// Output only. Average CPA target.
	TargetCpaMicros *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=target_cpa_micros,json=targetCpaMicros,proto3" json:"target_cpa_micros,omitempty"`
	// Output only. The minimum campaign budget, in local currency for the account,
	// required to achieve the target CPA.
	// Amount is specified in micros, where one million is equivalent to one
	// currency unit.
	RequiredCampaignBudgetAmountMicros *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=required_campaign_budget_amount_micros,json=requiredCampaignBudgetAmountMicros,proto3" json:"required_campaign_budget_amount_micros,omitempty"`
	// Output only. The impact estimate if this option is selected.
	Impact *Recommendation_RecommendationImpact `protobuf:"bytes,4,opt,name=impact,proto3" json:"impact,omitempty"`
}

func (x *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) Reset() {
	*x = Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) ProtoMessage() {
}

func (x *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption.ProtoReflect.Descriptor instead.
func (*Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_resources_recommendation_proto_rawDescGZIP(), []int{0, 6, 0}
}

func (x *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) GetGoal() enums.TargetCpaOptInRecommendationGoalEnum_TargetCpaOptInRecommendationGoal {
	if x != nil {
		return x.Goal
	}
	return enums.TargetCpaOptInRecommendationGoalEnum_UNSPECIFIED
}

func (x *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) GetTargetCpaMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.TargetCpaMicros
	}
	return nil
}

func (x *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) GetRequiredCampaignBudgetAmountMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.RequiredCampaignBudgetAmountMicros
	}
	return nil
}

func (x *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) GetImpact() *Recommendation_RecommendationImpact {
	if x != nil {
		return x.Impact
	}
	return nil
}

var File_google_ads_googleads_v3_resources_recommendation_proto protoreflect.FileDescriptor

var file_google_ads_googleads_v3_resources_recommendation_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x33, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0x2d, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x63, 0x72, 0x69, 0x74,
	0x65, 0x72, 0x69, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2f, 0x76, 0x33, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x6b, 0x65, 0x79, 0x77, 0x6f,
	0x72, 0x64, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x49, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x5f, 0x63, 0x70, 0x61, 0x5f, 0x6f, 0x70, 0x74, 0x5f, 0x69, 0x6e, 0x5f, 0x72, 0x65,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x67, 0x6f, 0x61,
	0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x33,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x64, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb1, 0x35,
	0x0a, 0x0e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x54, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x05, 0xfa, 0x41, 0x29, 0x0a,
	0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d,
	0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x61, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x65,
	0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x52, 0x65, 0x63, 0x6f,
	0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x63, 0x0a, 0x06, 0x69, 0x6d, 0x70,
	0x61, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x33, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x52, 0x65,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6d, 0x70, 0x61, 0x63,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x69, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x12, 0x76,
	0x0a, 0x0f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65,
	0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x2f, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e,
	0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x52, 0x0e, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e,
	0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x12, 0x63, 0x0a, 0x08, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x29, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67,
	0x6e, 0x52, 0x08, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x12, 0x61, 0x0a, 0x08, 0x61,
	0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x28, 0xe0, 0x41, 0x03,
	0xfa, 0x41, 0x22, 0x0a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x64,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x07, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x3d,
	0x0a, 0x09, 0x64, 0x69, 0x73, 0x6d, 0x69, 0x73, 0x73, 0x65, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x09, 0x64, 0x69, 0x73, 0x6d, 0x69, 0x73, 0x73, 0x65, 0x64, 0x12, 0x9b, 0x01,
	0x0a, 0x1e, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65,
	0x74, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33,
	0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x1c, 0x63,
	0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x52, 0x65, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x85, 0x01, 0x0a, 0x16,
	0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x15, 0x6b, 0x65,
	0x79, 0x77, 0x6f, 0x72, 0x64, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x83, 0x01, 0x0a, 0x16, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x61, 0x64, 0x5f,
	0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x41, 0x64, 0x52, 0x65,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x48, 0x00, 0x52, 0x14, 0x74, 0x65, 0x78, 0x74, 0x41, 0x64, 0x52, 0x65, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x9d, 0x01, 0x0a, 0x20, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x70, 0x61, 0x5f, 0x6f, 0x70, 0x74, 0x5f, 0x69, 0x6e, 0x5f,
	0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x70,
	0x61, 0x4f, 0x70, 0x74, 0x49, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x1c, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x43, 0x70, 0x61, 0x4f, 0x70, 0x74, 0x49, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xbb, 0x01, 0x0a, 0x2a, 0x6d, 0x61,
	0x78, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x5f, 0x6f, 0x70, 0x74, 0x5f, 0x69, 0x6e, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d,
	0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x58,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x4d, 0x61, 0x78, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x4f, 0x70, 0x74, 0x49, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d,
	0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52,
	0x26, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x4f, 0x70, 0x74, 0x49, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xa3, 0x01, 0x0a, 0x22, 0x65, 0x6e, 0x68, 0x61,
	0x6e, 0x63, 0x65, 0x64, 0x5f, 0x63, 0x70, 0x63, 0x5f, 0x6f, 0x70, 0x74, 0x5f, 0x69, 0x6e, 0x5f,
	0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64,
	0x43, 0x70, 0x63, 0x4f, 0x70, 0x74, 0x49, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x1e, 0x65,
	0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x43, 0x70, 0x63, 0x4f, 0x70, 0x74, 0x49, 0x6e, 0x52,
	0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xac, 0x01,
	0x0a, 0x25, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72,
	0x73, 0x5f, 0x6f, 0x70, 0x74, 0x5f, 0x69, 0x6e, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x53, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x73, 0x4f,
	0x70, 0x74, 0x49, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x21, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x73, 0x4f, 0x70, 0x74, 0x49, 0x6e, 0x52, 0x65,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xac, 0x01, 0x0a,
	0x25, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73,
	0x5f, 0x6f, 0x70, 0x74, 0x5f, 0x69, 0x6e, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x53, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x4d, 0x61, 0x78, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x4f, 0x70,
	0x74, 0x49, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x21, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x69,
	0x7a, 0x65, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x4f, 0x70, 0x74, 0x49, 0x6e, 0x52, 0x65, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xa8, 0x01, 0x0a, 0x23,
	0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x64, 0x5f, 0x72, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x33, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x52, 0x65,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4f, 0x70, 0x74,
	0x69, 0x6d, 0x69, 0x7a, 0x65, 0x41, 0x64, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x00, 0x52, 0x20, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x41, 0x64,
	0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xa1, 0x01, 0x0a, 0x20, 0x63, 0x61, 0x6c, 0x6c, 0x6f,
	0x75, 0x74, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x11, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x45, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x1e, 0x63, 0x61, 0x6c, 0x6c,
	0x6f, 0x75, 0x74, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x63, 0x6f,
	0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xa4, 0x01, 0x0a, 0x21, 0x73,
	0x69, 0x74, 0x65, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33,
	0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x69, 0x74, 0x65, 0x6c, 0x69,
	0x6e, 0x6b, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00,
	0x52, 0x1f, 0x73, 0x69, 0x74, 0x65, 0x6c, 0x69, 0x6e, 0x6b, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x98, 0x01, 0x0a, 0x1d, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x33, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x52, 0x65,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x6c,
	0x6c, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d,
	0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52,
	0x1b, 0x63, 0x61, 0x6c, 0x6c, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xa2, 0x01, 0x0a,
	0x21, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x33, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x52, 0x65, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4b, 0x65, 0x79, 0x77,
	0x6f, 0x72, 0x64, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x63, 0x6f,
	0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48,
	0x00, 0x52, 0x1e, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0xa2, 0x01, 0x0a, 0x21, 0x6d, 0x6f, 0x76, 0x65, 0x5f, 0x75, 0x6e, 0x75, 0x73, 0x65,
	0x64, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x4d, 0x6f, 0x76, 0x65, 0x55, 0x6e, 0x75, 0x73, 0x65, 0x64, 0x42, 0x75, 0x64, 0x67, 0x65,
	0x74, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x1e, 0x6d, 0x6f, 0x76, 0x65, 0x55, 0x6e, 0x75, 0x73,
	0x65, 0x64, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x82, 0x02, 0x0a, 0x14, 0x52, 0x65, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x12,
	0x6f, 0x0a, 0x0c, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d,
	0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0b, 0x62, 0x61, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x12, 0x79, 0x0a, 0x11, 0x70, 0x6f, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e,
	0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52,
	0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x70, 0x6f, 0x74, 0x65, 0x6e,
	0x74, 0x69, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x1a, 0xe3, 0x02, 0x0a, 0x15,
	0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x43, 0x0a, 0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x69,
	0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x39, 0x0a, 0x06, 0x63, 0x6c,
	0x69, 0x63, 0x6b, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x63,
	0x6c, 0x69, 0x63, 0x6b, 0x73, 0x12, 0x41, 0x0a, 0x0b, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x69,
	0x63, 0x72, 0x6f, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74,
	0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x6f,
	0x73, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x43, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x42, 0x0a,
	0x0b, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x73, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x56, 0x69, 0x65, 0x77,
	0x73, 0x1a, 0xec, 0x04, 0x0a, 0x1c, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x42, 0x75,
	0x64, 0x67, 0x65, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x61, 0x0a, 0x1c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x62, 0x75,
	0x64, 0x67, 0x65, 0x74, 0x5f, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72,
	0x6f, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x19, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x74, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x41, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x4d,
	0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x69, 0x0a, 0x20, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x64, 0x65, 0x64, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x61, 0x6d, 0x6f, 0x75,
	0x6e, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x1d, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x42, 0x75,
	0x64, 0x67, 0x65, 0x74, 0x41, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73,
	0x12, 0x9d, 0x01, 0x0a, 0x0e, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x71, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x33, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x52, 0x65,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x6d,
	0x70, 0x61, 0x69, 0x67, 0x6e, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0d, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x1a, 0xdd, 0x01, 0x0a, 0x22, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x42, 0x75, 0x64,
	0x67, 0x65, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x52, 0x0a, 0x14, 0x62, 0x75, 0x64, 0x67, 0x65,
	0x74, 0x5f, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x41,
	0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x63, 0x0a, 0x06, 0x69,
	0x6d, 0x70, 0x61, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e,
	0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52,
	0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6d, 0x70,
	0x61, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x69, 0x6d, 0x70, 0x61, 0x63, 0x74,
	0x1a, 0xc2, 0x01, 0x0a, 0x15, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x52, 0x65, 0x63, 0x6f,
	0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4a, 0x0a, 0x07, 0x6b, 0x65,
	0x79, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4b, 0x65, 0x79,
	0x77, 0x6f, 0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x6b,
	0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x5d, 0x0a, 0x1a, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d,
	0x65, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x63, 0x70, 0x63, 0x5f, 0x62, 0x69, 0x64, 0x5f, 0x6d, 0x69,
	0x63, 0x72, 0x6f, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74,
	0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x72, 0x65,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x43, 0x70, 0x63, 0x42, 0x69, 0x64, 0x4d,
	0x69, 0x63, 0x72, 0x6f, 0x73, 0x1a, 0x22, 0x0a, 0x20, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a,
	0x65, 0x41, 0x64, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xe5, 0x01, 0x0a, 0x14, 0x54, 0x65,
	0x78, 0x74, 0x41, 0x64, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x02, 0x61, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2e, 0x41, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x02, 0x61, 0x64, 0x12, 0x46,
	0x0a, 0x0d, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x61, 0x74, 0x65, 0x12, 0x49, 0x0a, 0x0f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x61,
	0x70, 0x70, 0x6c, 0x79, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0d, 0x61, 0x75, 0x74, 0x6f, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x44, 0x61, 0x74,
	0x65, 0x1a, 0xe5, 0x05, 0x0a, 0x1c, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x70, 0x61, 0x4f,
	0x70, 0x74, 0x49, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x90, 0x01, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x71, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x70,
	0x61, 0x4f, 0x70, 0x74, 0x49, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x70, 0x61, 0x4f, 0x70,
	0x74, 0x49, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x63, 0x0a, 0x1d, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x64, 0x65, 0x64, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x70, 0x61, 0x5f,
	0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49,
	0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1a,
	0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x43, 0x70, 0x61, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x1a, 0xcc, 0x03, 0x0a, 0x22, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x70, 0x61, 0x4f, 0x70, 0x74, 0x49, 0x6e, 0x52, 0x65, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x7d, 0x0a, 0x04, 0x67, 0x6f, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x70, 0x61, 0x4f, 0x70, 0x74, 0x49, 0x6e, 0x52, 0x65,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x6f, 0x61, 0x6c,
	0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x70, 0x61, 0x4f, 0x70,
	0x74, 0x49, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x47, 0x6f, 0x61, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x67, 0x6f, 0x61, 0x6c,
	0x12, 0x4c, 0x0a, 0x11, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x70, 0x61, 0x5f, 0x6d,
	0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e,
	0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x70, 0x61, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x74,
	0x0a, 0x26, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6d, 0x70, 0x61,
	0x69, 0x67, 0x6e, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x61, 0x6d, 0x6f, 0x75, 0x6e,
	0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x22, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x41, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x4d, 0x69,
	0x63, 0x72, 0x6f, 0x73, 0x12, 0x63, 0x0a, 0x06, 0x69, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x06, 0x69, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x1a, 0x20, 0x0a, 0x1e, 0x45, 0x6e, 0x68,
	0x61, 0x6e, 0x63, 0x65, 0x64, 0x43, 0x70, 0x63, 0x4f, 0x70, 0x74, 0x49, 0x6e, 0x52, 0x65, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x8e, 0x01, 0x0a, 0x21,
	0x4d, 0x61, 0x78, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x4f, 0x70,
	0x74, 0x49, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x69, 0x0a, 0x20, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x64,
	0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6d,
	0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e,
	0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1d, 0x72,
	0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74,
	0x41, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x1a, 0x93, 0x01, 0x0a,
	0x26, 0x4d, 0x61, 0x78, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x4f, 0x70, 0x74, 0x49, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x69, 0x0a, 0x20, 0x72, 0x65, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x61, 0x6d,
	0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x1d, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x64,
	0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x41, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x4d, 0x69, 0x63, 0x72,
	0x6f, 0x73, 0x1a, 0x87, 0x01, 0x0a, 0x1b, 0x43, 0x61, 0x6c, 0x6c, 0x45, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x68, 0x0a, 0x16, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65,
	0x64, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x46, 0x65, 0x65, 0x64, 0x49, 0x74, 0x65, 0x6d,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64,
	0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x23, 0x0a, 0x21,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x73, 0x4f, 0x70,
	0x74, 0x49, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x1a, 0x8d, 0x01, 0x0a, 0x1e, 0x43, 0x61, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6b, 0x0a, 0x16, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
	0x64, 0x65, 0x64, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x46, 0x65, 0x65,
	0x64, 0x49, 0x74, 0x65, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x72, 0x65, 0x63, 0x6f,
	0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x1a, 0x8f, 0x01, 0x0a, 0x1f, 0x53, 0x69, 0x74, 0x65, 0x6c, 0x69, 0x6e, 0x6b, 0x45, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6c, 0x0a, 0x16, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x64, 0x65, 0x64, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x53, 0x69, 0x74, 0x65, 0x6c, 0x69, 0x6e, 0x6b, 0x46,
	0x65, 0x65, 0x64, 0x49, 0x74, 0x65, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x72, 0x65,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x1a, 0xed, 0x01, 0x0a, 0x1e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4a, 0x0a, 0x07, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x33, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64,
	0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x6b, 0x65, 0x79, 0x77, 0x6f,
	0x72, 0x64, 0x12, 0x7f, 0x0a, 0x16, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65,
	0x64, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54,
	0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x72,
	0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54,
	0x79, 0x70, 0x65, 0x1a, 0x84, 0x02, 0x0a, 0x1e, 0x4d, 0x6f, 0x76, 0x65, 0x55, 0x6e, 0x75, 0x73,
	0x65, 0x64, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x57, 0x0a, 0x16, 0x65, 0x78, 0x63, 0x65, 0x73, 0x73,
	0x5f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x65, 0x78, 0x63, 0x65, 0x73,
	0x73, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x12,
	0x88, 0x01, 0x0a, 0x15, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x42, 0x75, 0x64, 0x67, 0x65,
	0x74, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x52, 0x65, 0x63, 0x6f,
	0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x63, 0xea, 0x41, 0x60, 0x0a,
	0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d,
	0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x7d, 0x2f, 0x72,
	0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x42,
	0x10, 0x0a, 0x0e, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x80, 0x02, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x33, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x42, 0x13, 0x52, 0x65, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x4a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x3b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0xa2, 0x02,
	0x03, 0x47, 0x41, 0x41, 0xaa, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x64,
	0x73, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x2e, 0x56, 0x33, 0x2e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0xca, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5c, 0x41, 0x64, 0x73, 0x5c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x5c,
	0x56, 0x33, 0x5c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0xea, 0x02, 0x25, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x56, 0x33, 0x3a, 0x3a, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ads_googleads_v3_resources_recommendation_proto_rawDescOnce sync.Once
	file_google_ads_googleads_v3_resources_recommendation_proto_rawDescData = file_google_ads_googleads_v3_resources_recommendation_proto_rawDesc
)

func file_google_ads_googleads_v3_resources_recommendation_proto_rawDescGZIP() []byte {
	file_google_ads_googleads_v3_resources_recommendation_proto_rawDescOnce.Do(func() {
		file_google_ads_googleads_v3_resources_recommendation_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_googleads_v3_resources_recommendation_proto_rawDescData)
	})
	return file_google_ads_googleads_v3_resources_recommendation_proto_rawDescData
}

var file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes = make([]protoimpl.MessageInfo, 19)
var file_google_ads_googleads_v3_resources_recommendation_proto_goTypes = []interface{}{
	(*Recommendation)(nil),                                                                 // 0: google.ads.googleads.v3.resources.Recommendation
	(*Recommendation_RecommendationImpact)(nil),                                            // 1: google.ads.googleads.v3.resources.Recommendation.RecommendationImpact
	(*Recommendation_RecommendationMetrics)(nil),                                           // 2: google.ads.googleads.v3.resources.Recommendation.RecommendationMetrics
	(*Recommendation_CampaignBudgetRecommendation)(nil),                                    // 3: google.ads.googleads.v3.resources.Recommendation.CampaignBudgetRecommendation
	(*Recommendation_KeywordRecommendation)(nil),                                           // 4: google.ads.googleads.v3.resources.Recommendation.KeywordRecommendation
	(*Recommendation_OptimizeAdRotationRecommendation)(nil),                                // 5: google.ads.googleads.v3.resources.Recommendation.OptimizeAdRotationRecommendation
	(*Recommendation_TextAdRecommendation)(nil),                                            // 6: google.ads.googleads.v3.resources.Recommendation.TextAdRecommendation
	(*Recommendation_TargetCpaOptInRecommendation)(nil),                                    // 7: google.ads.googleads.v3.resources.Recommendation.TargetCpaOptInRecommendation
	(*Recommendation_EnhancedCpcOptInRecommendation)(nil),                                  // 8: google.ads.googleads.v3.resources.Recommendation.EnhancedCpcOptInRecommendation
	(*Recommendation_MaximizeClicksOptInRecommendation)(nil),                               // 9: google.ads.googleads.v3.resources.Recommendation.MaximizeClicksOptInRecommendation
	(*Recommendation_MaximizeConversionsOptInRecommendation)(nil),                          // 10: google.ads.googleads.v3.resources.Recommendation.MaximizeConversionsOptInRecommendation
	(*Recommendation_CallExtensionRecommendation)(nil),                                     // 11: google.ads.googleads.v3.resources.Recommendation.CallExtensionRecommendation
	(*Recommendation_SearchPartnersOptInRecommendation)(nil),                               // 12: google.ads.googleads.v3.resources.Recommendation.SearchPartnersOptInRecommendation
	(*Recommendation_CalloutExtensionRecommendation)(nil),                                  // 13: google.ads.googleads.v3.resources.Recommendation.CalloutExtensionRecommendation
	(*Recommendation_SitelinkExtensionRecommendation)(nil),                                 // 14: google.ads.googleads.v3.resources.Recommendation.SitelinkExtensionRecommendation
	(*Recommendation_KeywordMatchTypeRecommendation)(nil),                                  // 15: google.ads.googleads.v3.resources.Recommendation.KeywordMatchTypeRecommendation
	(*Recommendation_MoveUnusedBudgetRecommendation)(nil),                                  // 16: google.ads.googleads.v3.resources.Recommendation.MoveUnusedBudgetRecommendation
	(*Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption)(nil), // 17: google.ads.googleads.v3.resources.Recommendation.CampaignBudgetRecommendation.CampaignBudgetRecommendationOption
	(*Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption)(nil), // 18: google.ads.googleads.v3.resources.Recommendation.TargetCpaOptInRecommendation.TargetCpaOptInRecommendationOption
	(enums.RecommendationTypeEnum_RecommendationType)(0),                                   // 19: google.ads.googleads.v3.enums.RecommendationTypeEnum.RecommendationType
	(*wrapperspb.StringValue)(nil),                                                         // 20: google.protobuf.StringValue
	(*wrapperspb.BoolValue)(nil),                                                           // 21: google.protobuf.BoolValue
	(*wrapperspb.DoubleValue)(nil),                                                         // 22: google.protobuf.DoubleValue
	(*wrapperspb.Int64Value)(nil),                                                          // 23: google.protobuf.Int64Value
	(*common.KeywordInfo)(nil),                                                             // 24: google.ads.googleads.v3.common.KeywordInfo
	(*Ad)(nil),                                                                             // 25: google.ads.googleads.v3.resources.Ad
	(*common.CallFeedItem)(nil),                                                            // 26: google.ads.googleads.v3.common.CallFeedItem
	(*common.CalloutFeedItem)(nil),                                                         // 27: google.ads.googleads.v3.common.CalloutFeedItem
	(*common.SitelinkFeedItem)(nil),                                                        // 28: google.ads.googleads.v3.common.SitelinkFeedItem
	(enums.KeywordMatchTypeEnum_KeywordMatchType)(0),                                       // 29: google.ads.googleads.v3.enums.KeywordMatchTypeEnum.KeywordMatchType
	(enums.TargetCpaOptInRecommendationGoalEnum_TargetCpaOptInRecommendationGoal)(0),       // 30: google.ads.googleads.v3.enums.TargetCpaOptInRecommendationGoalEnum.TargetCpaOptInRecommendationGoal
}
var file_google_ads_googleads_v3_resources_recommendation_proto_depIdxs = []int32{
	19, // 0: google.ads.googleads.v3.resources.Recommendation.type:type_name -> google.ads.googleads.v3.enums.RecommendationTypeEnum.RecommendationType
	1,  // 1: google.ads.googleads.v3.resources.Recommendation.impact:type_name -> google.ads.googleads.v3.resources.Recommendation.RecommendationImpact
	20, // 2: google.ads.googleads.v3.resources.Recommendation.campaign_budget:type_name -> google.protobuf.StringValue
	20, // 3: google.ads.googleads.v3.resources.Recommendation.campaign:type_name -> google.protobuf.StringValue
	20, // 4: google.ads.googleads.v3.resources.Recommendation.ad_group:type_name -> google.protobuf.StringValue
	21, // 5: google.ads.googleads.v3.resources.Recommendation.dismissed:type_name -> google.protobuf.BoolValue
	3,  // 6: google.ads.googleads.v3.resources.Recommendation.campaign_budget_recommendation:type_name -> google.ads.googleads.v3.resources.Recommendation.CampaignBudgetRecommendation
	4,  // 7: google.ads.googleads.v3.resources.Recommendation.keyword_recommendation:type_name -> google.ads.googleads.v3.resources.Recommendation.KeywordRecommendation
	6,  // 8: google.ads.googleads.v3.resources.Recommendation.text_ad_recommendation:type_name -> google.ads.googleads.v3.resources.Recommendation.TextAdRecommendation
	7,  // 9: google.ads.googleads.v3.resources.Recommendation.target_cpa_opt_in_recommendation:type_name -> google.ads.googleads.v3.resources.Recommendation.TargetCpaOptInRecommendation
	10, // 10: google.ads.googleads.v3.resources.Recommendation.maximize_conversions_opt_in_recommendation:type_name -> google.ads.googleads.v3.resources.Recommendation.MaximizeConversionsOptInRecommendation
	8,  // 11: google.ads.googleads.v3.resources.Recommendation.enhanced_cpc_opt_in_recommendation:type_name -> google.ads.googleads.v3.resources.Recommendation.EnhancedCpcOptInRecommendation
	12, // 12: google.ads.googleads.v3.resources.Recommendation.search_partners_opt_in_recommendation:type_name -> google.ads.googleads.v3.resources.Recommendation.SearchPartnersOptInRecommendation
	9,  // 13: google.ads.googleads.v3.resources.Recommendation.maximize_clicks_opt_in_recommendation:type_name -> google.ads.googleads.v3.resources.Recommendation.MaximizeClicksOptInRecommendation
	5,  // 14: google.ads.googleads.v3.resources.Recommendation.optimize_ad_rotation_recommendation:type_name -> google.ads.googleads.v3.resources.Recommendation.OptimizeAdRotationRecommendation
	13, // 15: google.ads.googleads.v3.resources.Recommendation.callout_extension_recommendation:type_name -> google.ads.googleads.v3.resources.Recommendation.CalloutExtensionRecommendation
	14, // 16: google.ads.googleads.v3.resources.Recommendation.sitelink_extension_recommendation:type_name -> google.ads.googleads.v3.resources.Recommendation.SitelinkExtensionRecommendation
	11, // 17: google.ads.googleads.v3.resources.Recommendation.call_extension_recommendation:type_name -> google.ads.googleads.v3.resources.Recommendation.CallExtensionRecommendation
	15, // 18: google.ads.googleads.v3.resources.Recommendation.keyword_match_type_recommendation:type_name -> google.ads.googleads.v3.resources.Recommendation.KeywordMatchTypeRecommendation
	16, // 19: google.ads.googleads.v3.resources.Recommendation.move_unused_budget_recommendation:type_name -> google.ads.googleads.v3.resources.Recommendation.MoveUnusedBudgetRecommendation
	2,  // 20: google.ads.googleads.v3.resources.Recommendation.RecommendationImpact.base_metrics:type_name -> google.ads.googleads.v3.resources.Recommendation.RecommendationMetrics
	2,  // 21: google.ads.googleads.v3.resources.Recommendation.RecommendationImpact.potential_metrics:type_name -> google.ads.googleads.v3.resources.Recommendation.RecommendationMetrics
	22, // 22: google.ads.googleads.v3.resources.Recommendation.RecommendationMetrics.impressions:type_name -> google.protobuf.DoubleValue
	22, // 23: google.ads.googleads.v3.resources.Recommendation.RecommendationMetrics.clicks:type_name -> google.protobuf.DoubleValue
	23, // 24: google.ads.googleads.v3.resources.Recommendation.RecommendationMetrics.cost_micros:type_name -> google.protobuf.Int64Value
	22, // 25: google.ads.googleads.v3.resources.Recommendation.RecommendationMetrics.conversions:type_name -> google.protobuf.DoubleValue
	22, // 26: google.ads.googleads.v3.resources.Recommendation.RecommendationMetrics.video_views:type_name -> google.protobuf.DoubleValue
	23, // 27: google.ads.googleads.v3.resources.Recommendation.CampaignBudgetRecommendation.current_budget_amount_micros:type_name -> google.protobuf.Int64Value
	23, // 28: google.ads.googleads.v3.resources.Recommendation.CampaignBudgetRecommendation.recommended_budget_amount_micros:type_name -> google.protobuf.Int64Value
	17, // 29: google.ads.googleads.v3.resources.Recommendation.CampaignBudgetRecommendation.budget_options:type_name -> google.ads.googleads.v3.resources.Recommendation.CampaignBudgetRecommendation.CampaignBudgetRecommendationOption
	24, // 30: google.ads.googleads.v3.resources.Recommendation.KeywordRecommendation.keyword:type_name -> google.ads.googleads.v3.common.KeywordInfo
	23, // 31: google.ads.googleads.v3.resources.Recommendation.KeywordRecommendation.recommended_cpc_bid_micros:type_name -> google.protobuf.Int64Value
	25, // 32: google.ads.googleads.v3.resources.Recommendation.TextAdRecommendation.ad:type_name -> google.ads.googleads.v3.resources.Ad
	20, // 33: google.ads.googleads.v3.resources.Recommendation.TextAdRecommendation.creation_date:type_name -> google.protobuf.StringValue
	20, // 34: google.ads.googleads.v3.resources.Recommendation.TextAdRecommendation.auto_apply_date:type_name -> google.protobuf.StringValue
	18, // 35: google.ads.googleads.v3.resources.Recommendation.TargetCpaOptInRecommendation.options:type_name -> google.ads.googleads.v3.resources.Recommendation.TargetCpaOptInRecommendation.TargetCpaOptInRecommendationOption
	23, // 36: google.ads.googleads.v3.resources.Recommendation.TargetCpaOptInRecommendation.recommended_target_cpa_micros:type_name -> google.protobuf.Int64Value
	23, // 37: google.ads.googleads.v3.resources.Recommendation.MaximizeClicksOptInRecommendation.recommended_budget_amount_micros:type_name -> google.protobuf.Int64Value
	23, // 38: google.ads.googleads.v3.resources.Recommendation.MaximizeConversionsOptInRecommendation.recommended_budget_amount_micros:type_name -> google.protobuf.Int64Value
	26, // 39: google.ads.googleads.v3.resources.Recommendation.CallExtensionRecommendation.recommended_extensions:type_name -> google.ads.googleads.v3.common.CallFeedItem
	27, // 40: google.ads.googleads.v3.resources.Recommendation.CalloutExtensionRecommendation.recommended_extensions:type_name -> google.ads.googleads.v3.common.CalloutFeedItem
	28, // 41: google.ads.googleads.v3.resources.Recommendation.SitelinkExtensionRecommendation.recommended_extensions:type_name -> google.ads.googleads.v3.common.SitelinkFeedItem
	24, // 42: google.ads.googleads.v3.resources.Recommendation.KeywordMatchTypeRecommendation.keyword:type_name -> google.ads.googleads.v3.common.KeywordInfo
	29, // 43: google.ads.googleads.v3.resources.Recommendation.KeywordMatchTypeRecommendation.recommended_match_type:type_name -> google.ads.googleads.v3.enums.KeywordMatchTypeEnum.KeywordMatchType
	20, // 44: google.ads.googleads.v3.resources.Recommendation.MoveUnusedBudgetRecommendation.excess_campaign_budget:type_name -> google.protobuf.StringValue
	3,  // 45: google.ads.googleads.v3.resources.Recommendation.MoveUnusedBudgetRecommendation.budget_recommendation:type_name -> google.ads.googleads.v3.resources.Recommendation.CampaignBudgetRecommendation
	23, // 46: google.ads.googleads.v3.resources.Recommendation.CampaignBudgetRecommendation.CampaignBudgetRecommendationOption.budget_amount_micros:type_name -> google.protobuf.Int64Value
	1,  // 47: google.ads.googleads.v3.resources.Recommendation.CampaignBudgetRecommendation.CampaignBudgetRecommendationOption.impact:type_name -> google.ads.googleads.v3.resources.Recommendation.RecommendationImpact
	30, // 48: google.ads.googleads.v3.resources.Recommendation.TargetCpaOptInRecommendation.TargetCpaOptInRecommendationOption.goal:type_name -> google.ads.googleads.v3.enums.TargetCpaOptInRecommendationGoalEnum.TargetCpaOptInRecommendationGoal
	23, // 49: google.ads.googleads.v3.resources.Recommendation.TargetCpaOptInRecommendation.TargetCpaOptInRecommendationOption.target_cpa_micros:type_name -> google.protobuf.Int64Value
	23, // 50: google.ads.googleads.v3.resources.Recommendation.TargetCpaOptInRecommendation.TargetCpaOptInRecommendationOption.required_campaign_budget_amount_micros:type_name -> google.protobuf.Int64Value
	1,  // 51: google.ads.googleads.v3.resources.Recommendation.TargetCpaOptInRecommendation.TargetCpaOptInRecommendationOption.impact:type_name -> google.ads.googleads.v3.resources.Recommendation.RecommendationImpact
	52, // [52:52] is the sub-list for method output_type
	52, // [52:52] is the sub-list for method input_type
	52, // [52:52] is the sub-list for extension type_name
	52, // [52:52] is the sub-list for extension extendee
	0,  // [0:52] is the sub-list for field type_name
}

func init() { file_google_ads_googleads_v3_resources_recommendation_proto_init() }
func file_google_ads_googleads_v3_resources_recommendation_proto_init() {
	if File_google_ads_googleads_v3_resources_recommendation_proto != nil {
		return
	}
	file_google_ads_googleads_v3_resources_ad_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Recommendation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Recommendation_RecommendationImpact); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Recommendation_RecommendationMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Recommendation_CampaignBudgetRecommendation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Recommendation_KeywordRecommendation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Recommendation_OptimizeAdRotationRecommendation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Recommendation_TextAdRecommendation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Recommendation_TargetCpaOptInRecommendation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Recommendation_EnhancedCpcOptInRecommendation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Recommendation_MaximizeClicksOptInRecommendation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Recommendation_MaximizeConversionsOptInRecommendation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Recommendation_CallExtensionRecommendation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Recommendation_SearchPartnersOptInRecommendation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Recommendation_CalloutExtensionRecommendation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Recommendation_SitelinkExtensionRecommendation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Recommendation_KeywordMatchTypeRecommendation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Recommendation_MoveUnusedBudgetRecommendation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Recommendation_CampaignBudgetRecommendation_)(nil),
		(*Recommendation_KeywordRecommendation_)(nil),
		(*Recommendation_TextAdRecommendation_)(nil),
		(*Recommendation_TargetCpaOptInRecommendation_)(nil),
		(*Recommendation_MaximizeConversionsOptInRecommendation_)(nil),
		(*Recommendation_EnhancedCpcOptInRecommendation_)(nil),
		(*Recommendation_SearchPartnersOptInRecommendation_)(nil),
		(*Recommendation_MaximizeClicksOptInRecommendation_)(nil),
		(*Recommendation_OptimizeAdRotationRecommendation_)(nil),
		(*Recommendation_CalloutExtensionRecommendation_)(nil),
		(*Recommendation_SitelinkExtensionRecommendation_)(nil),
		(*Recommendation_CallExtensionRecommendation_)(nil),
		(*Recommendation_KeywordMatchTypeRecommendation_)(nil),
		(*Recommendation_MoveUnusedBudgetRecommendation_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_googleads_v3_resources_recommendation_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   19,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_ads_googleads_v3_resources_recommendation_proto_goTypes,
		DependencyIndexes: file_google_ads_googleads_v3_resources_recommendation_proto_depIdxs,
		MessageInfos:      file_google_ads_googleads_v3_resources_recommendation_proto_msgTypes,
	}.Build()
	File_google_ads_googleads_v3_resources_recommendation_proto = out.File
	file_google_ads_googleads_v3_resources_recommendation_proto_rawDesc = nil
	file_google_ads_googleads_v3_resources_recommendation_proto_goTypes = nil
	file_google_ads_googleads_v3_resources_recommendation_proto_depIdxs = nil
}
