// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.3
// source: google/ads/googleads/v3/common/policy.proto

package common

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v3/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Key of the violation. The key is used for referring to a violation
// when filing an exemption request.
type PolicyViolationKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique ID of the violated policy.
	PolicyName *wrappers.StringValue `protobuf:"bytes,1,opt,name=policy_name,json=policyName,proto3" json:"policy_name,omitempty"`
	// The text that violates the policy if specified.
	// Otherwise, refers to the policy in general
	// (e.g., when requesting to be exempt from the whole policy).
	// If not specified for criterion exemptions, the whole policy is implied.
	// Must be specified for ad exemptions.
	ViolatingText *wrappers.StringValue `protobuf:"bytes,2,opt,name=violating_text,json=violatingText,proto3" json:"violating_text,omitempty"`
}

func (x *PolicyViolationKey) Reset() {
	*x = PolicyViolationKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_common_policy_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyViolationKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyViolationKey) ProtoMessage() {}

func (x *PolicyViolationKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_common_policy_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyViolationKey.ProtoReflect.Descriptor instead.
func (*PolicyViolationKey) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_common_policy_proto_rawDescGZIP(), []int{0}
}

func (x *PolicyViolationKey) GetPolicyName() *wrappers.StringValue {
	if x != nil {
		return x.PolicyName
	}
	return nil
}

func (x *PolicyViolationKey) GetViolatingText() *wrappers.StringValue {
	if x != nil {
		return x.ViolatingText
	}
	return nil
}

// Parameter for controlling how policy exemption is done. Ignorable policy
// topics are only usable with expanded text ads and responsive search ads. All
// other ad types must use policy violation keys.
type PolicyValidationParameter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of policy topics that should not cause a PolicyFindingError to
	// be reported. This field is currently only compatible with Enhanced Text Ad.
	// It corresponds to the PolicyTopicEntry.topic field.
	//
	// Resources violating these policies will be saved, but will not be eligible
	// to serve. They may begin serving at a later time due to a change in
	// policies, re-review of the resource, or a change in advertiser
	// certificates.
	IgnorablePolicyTopics []*wrappers.StringValue `protobuf:"bytes,1,rep,name=ignorable_policy_topics,json=ignorablePolicyTopics,proto3" json:"ignorable_policy_topics,omitempty"`
	// The list of policy violation keys that should not cause a
	// PolicyViolationError to be reported. Not all policy violations are
	// exemptable, please refer to the is_exemptible field in the returned
	// PolicyViolationError.
	//
	// Resources violating these polices will be saved, but will not be eligible
	// to serve. They may begin serving at a later time due to a change in
	// policies, re-review of the resource, or a change in advertiser
	// certificates.
	ExemptPolicyViolationKeys []*PolicyViolationKey `protobuf:"bytes,2,rep,name=exempt_policy_violation_keys,json=exemptPolicyViolationKeys,proto3" json:"exempt_policy_violation_keys,omitempty"`
}

func (x *PolicyValidationParameter) Reset() {
	*x = PolicyValidationParameter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_common_policy_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyValidationParameter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyValidationParameter) ProtoMessage() {}

func (x *PolicyValidationParameter) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_common_policy_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyValidationParameter.ProtoReflect.Descriptor instead.
func (*PolicyValidationParameter) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_common_policy_proto_rawDescGZIP(), []int{1}
}

func (x *PolicyValidationParameter) GetIgnorablePolicyTopics() []*wrappers.StringValue {
	if x != nil {
		return x.IgnorablePolicyTopics
	}
	return nil
}

func (x *PolicyValidationParameter) GetExemptPolicyViolationKeys() []*PolicyViolationKey {
	if x != nil {
		return x.ExemptPolicyViolationKeys
	}
	return nil
}

// Policy finding attached to a resource (e.g. alcohol policy associated with
// a site that sells alcohol).
//
// Each PolicyTopicEntry has a topic that indicates the specific ads policy
// the entry is about and a type to indicate the effect that the entry will have
// on serving. It may optionally have one or more evidences that indicate the
// reason for the finding. It may also optionally have one or more constraints
// that provide details about how serving may be restricted.
type PolicyTopicEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Policy topic this finding refers to. For example, "ALCOHOL",
	// "TRADEMARKS_IN_AD_TEXT", or "DESTINATION_NOT_WORKING". The set of possible
	// policy topics is not fixed for a particular API version and may change
	// at any time.
	Topic *wrappers.StringValue `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// Describes the negative or positive effect this policy will have on serving.
	Type enums.PolicyTopicEntryTypeEnum_PolicyTopicEntryType `protobuf:"varint,2,opt,name=type,proto3,enum=google.ads.googleads.v3.enums.PolicyTopicEntryTypeEnum_PolicyTopicEntryType" json:"type,omitempty"`
	// Additional information that explains policy finding
	// (e.g. the brand name for a trademark finding).
	Evidences []*PolicyTopicEvidence `protobuf:"bytes,3,rep,name=evidences,proto3" json:"evidences,omitempty"`
	// Indicates how serving of this resource may be affected (e.g. not serving
	// in a country).
	Constraints []*PolicyTopicConstraint `protobuf:"bytes,4,rep,name=constraints,proto3" json:"constraints,omitempty"`
}

func (x *PolicyTopicEntry) Reset() {
	*x = PolicyTopicEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_common_policy_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyTopicEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyTopicEntry) ProtoMessage() {}

func (x *PolicyTopicEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_common_policy_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyTopicEntry.ProtoReflect.Descriptor instead.
func (*PolicyTopicEntry) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_common_policy_proto_rawDescGZIP(), []int{2}
}

func (x *PolicyTopicEntry) GetTopic() *wrappers.StringValue {
	if x != nil {
		return x.Topic
	}
	return nil
}

func (x *PolicyTopicEntry) GetType() enums.PolicyTopicEntryTypeEnum_PolicyTopicEntryType {
	if x != nil {
		return x.Type
	}
	return enums.PolicyTopicEntryTypeEnum_UNSPECIFIED
}

func (x *PolicyTopicEntry) GetEvidences() []*PolicyTopicEvidence {
	if x != nil {
		return x.Evidences
	}
	return nil
}

func (x *PolicyTopicEntry) GetConstraints() []*PolicyTopicConstraint {
	if x != nil {
		return x.Constraints
	}
	return nil
}

// Additional information that explains a policy finding.
type PolicyTopicEvidence struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specific evidence information depending on the evidence type.
	//
	// Types that are assignable to Value:
	//	*PolicyTopicEvidence_WebsiteList_
	//	*PolicyTopicEvidence_TextList_
	//	*PolicyTopicEvidence_LanguageCode
	//	*PolicyTopicEvidence_DestinationTextList_
	//	*PolicyTopicEvidence_DestinationMismatch_
	//	*PolicyTopicEvidence_DestinationNotWorking_
	Value isPolicyTopicEvidence_Value `protobuf_oneof:"value"`
}

func (x *PolicyTopicEvidence) Reset() {
	*x = PolicyTopicEvidence{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_common_policy_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyTopicEvidence) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyTopicEvidence) ProtoMessage() {}

func (x *PolicyTopicEvidence) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_common_policy_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyTopicEvidence.ProtoReflect.Descriptor instead.
func (*PolicyTopicEvidence) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_common_policy_proto_rawDescGZIP(), []int{3}
}

func (m *PolicyTopicEvidence) GetValue() isPolicyTopicEvidence_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *PolicyTopicEvidence) GetWebsiteList() *PolicyTopicEvidence_WebsiteList {
	if x, ok := x.GetValue().(*PolicyTopicEvidence_WebsiteList_); ok {
		return x.WebsiteList
	}
	return nil
}

func (x *PolicyTopicEvidence) GetTextList() *PolicyTopicEvidence_TextList {
	if x, ok := x.GetValue().(*PolicyTopicEvidence_TextList_); ok {
		return x.TextList
	}
	return nil
}

func (x *PolicyTopicEvidence) GetLanguageCode() *wrappers.StringValue {
	if x, ok := x.GetValue().(*PolicyTopicEvidence_LanguageCode); ok {
		return x.LanguageCode
	}
	return nil
}

func (x *PolicyTopicEvidence) GetDestinationTextList() *PolicyTopicEvidence_DestinationTextList {
	if x, ok := x.GetValue().(*PolicyTopicEvidence_DestinationTextList_); ok {
		return x.DestinationTextList
	}
	return nil
}

func (x *PolicyTopicEvidence) GetDestinationMismatch() *PolicyTopicEvidence_DestinationMismatch {
	if x, ok := x.GetValue().(*PolicyTopicEvidence_DestinationMismatch_); ok {
		return x.DestinationMismatch
	}
	return nil
}

func (x *PolicyTopicEvidence) GetDestinationNotWorking() *PolicyTopicEvidence_DestinationNotWorking {
	if x, ok := x.GetValue().(*PolicyTopicEvidence_DestinationNotWorking_); ok {
		return x.DestinationNotWorking
	}
	return nil
}

type isPolicyTopicEvidence_Value interface {
	isPolicyTopicEvidence_Value()
}

type PolicyTopicEvidence_WebsiteList_ struct {
	// List of websites linked with this resource.
	WebsiteList *PolicyTopicEvidence_WebsiteList `protobuf:"bytes,3,opt,name=website_list,json=websiteList,proto3,oneof"`
}

type PolicyTopicEvidence_TextList_ struct {
	// List of evidence found in the text of a resource.
	TextList *PolicyTopicEvidence_TextList `protobuf:"bytes,4,opt,name=text_list,json=textList,proto3,oneof"`
}

type PolicyTopicEvidence_LanguageCode struct {
	// The language the resource was detected to be written in.
	// This is an IETF language tag such as "en-US".
	LanguageCode *wrappers.StringValue `protobuf:"bytes,5,opt,name=language_code,json=languageCode,proto3,oneof"`
}

type PolicyTopicEvidence_DestinationTextList_ struct {
	// The text in the destination of the resource that is causing a policy
	// finding.
	DestinationTextList *PolicyTopicEvidence_DestinationTextList `protobuf:"bytes,6,opt,name=destination_text_list,json=destinationTextList,proto3,oneof"`
}

type PolicyTopicEvidence_DestinationMismatch_ struct {
	// Mismatch between the destinations of a resource's URLs.
	DestinationMismatch *PolicyTopicEvidence_DestinationMismatch `protobuf:"bytes,7,opt,name=destination_mismatch,json=destinationMismatch,proto3,oneof"`
}

type PolicyTopicEvidence_DestinationNotWorking_ struct {
	// Details when the destination is returning an HTTP error code or isn't
	// functional in all locations for commonly used devices.
	DestinationNotWorking *PolicyTopicEvidence_DestinationNotWorking `protobuf:"bytes,8,opt,name=destination_not_working,json=destinationNotWorking,proto3,oneof"`
}

func (*PolicyTopicEvidence_WebsiteList_) isPolicyTopicEvidence_Value() {}

func (*PolicyTopicEvidence_TextList_) isPolicyTopicEvidence_Value() {}

func (*PolicyTopicEvidence_LanguageCode) isPolicyTopicEvidence_Value() {}

func (*PolicyTopicEvidence_DestinationTextList_) isPolicyTopicEvidence_Value() {}

func (*PolicyTopicEvidence_DestinationMismatch_) isPolicyTopicEvidence_Value() {}

func (*PolicyTopicEvidence_DestinationNotWorking_) isPolicyTopicEvidence_Value() {}

// Describes the effect on serving that a policy topic entry will have.
type PolicyTopicConstraint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specific information about the constraint.
	//
	// Types that are assignable to Value:
	//	*PolicyTopicConstraint_CountryConstraintList_
	//	*PolicyTopicConstraint_ResellerConstraint_
	//	*PolicyTopicConstraint_CertificateMissingInCountryList
	//	*PolicyTopicConstraint_CertificateDomainMismatchInCountryList
	Value isPolicyTopicConstraint_Value `protobuf_oneof:"value"`
}

func (x *PolicyTopicConstraint) Reset() {
	*x = PolicyTopicConstraint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_common_policy_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyTopicConstraint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyTopicConstraint) ProtoMessage() {}

func (x *PolicyTopicConstraint) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_common_policy_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyTopicConstraint.ProtoReflect.Descriptor instead.
func (*PolicyTopicConstraint) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_common_policy_proto_rawDescGZIP(), []int{4}
}

func (m *PolicyTopicConstraint) GetValue() isPolicyTopicConstraint_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *PolicyTopicConstraint) GetCountryConstraintList() *PolicyTopicConstraint_CountryConstraintList {
	if x, ok := x.GetValue().(*PolicyTopicConstraint_CountryConstraintList_); ok {
		return x.CountryConstraintList
	}
	return nil
}

func (x *PolicyTopicConstraint) GetResellerConstraint() *PolicyTopicConstraint_ResellerConstraint {
	if x, ok := x.GetValue().(*PolicyTopicConstraint_ResellerConstraint_); ok {
		return x.ResellerConstraint
	}
	return nil
}

func (x *PolicyTopicConstraint) GetCertificateMissingInCountryList() *PolicyTopicConstraint_CountryConstraintList {
	if x, ok := x.GetValue().(*PolicyTopicConstraint_CertificateMissingInCountryList); ok {
		return x.CertificateMissingInCountryList
	}
	return nil
}

func (x *PolicyTopicConstraint) GetCertificateDomainMismatchInCountryList() *PolicyTopicConstraint_CountryConstraintList {
	if x, ok := x.GetValue().(*PolicyTopicConstraint_CertificateDomainMismatchInCountryList); ok {
		return x.CertificateDomainMismatchInCountryList
	}
	return nil
}

type isPolicyTopicConstraint_Value interface {
	isPolicyTopicConstraint_Value()
}

type PolicyTopicConstraint_CountryConstraintList_ struct {
	// Countries where the resource cannot serve.
	CountryConstraintList *PolicyTopicConstraint_CountryConstraintList `protobuf:"bytes,1,opt,name=country_constraint_list,json=countryConstraintList,proto3,oneof"`
}

type PolicyTopicConstraint_ResellerConstraint_ struct {
	// Reseller constraint.
	ResellerConstraint *PolicyTopicConstraint_ResellerConstraint `protobuf:"bytes,2,opt,name=reseller_constraint,json=resellerConstraint,proto3,oneof"`
}

type PolicyTopicConstraint_CertificateMissingInCountryList struct {
	// Countries where a certificate is required for serving.
	CertificateMissingInCountryList *PolicyTopicConstraint_CountryConstraintList `protobuf:"bytes,3,opt,name=certificate_missing_in_country_list,json=certificateMissingInCountryList,proto3,oneof"`
}

type PolicyTopicConstraint_CertificateDomainMismatchInCountryList struct {
	// Countries where the resource's domain is not covered by the
	// certificates associated with it.
	CertificateDomainMismatchInCountryList *PolicyTopicConstraint_CountryConstraintList `protobuf:"bytes,4,opt,name=certificate_domain_mismatch_in_country_list,json=certificateDomainMismatchInCountryList,proto3,oneof"`
}

func (*PolicyTopicConstraint_CountryConstraintList_) isPolicyTopicConstraint_Value() {}

func (*PolicyTopicConstraint_ResellerConstraint_) isPolicyTopicConstraint_Value() {}

func (*PolicyTopicConstraint_CertificateMissingInCountryList) isPolicyTopicConstraint_Value() {}

func (*PolicyTopicConstraint_CertificateDomainMismatchInCountryList) isPolicyTopicConstraint_Value() {}

// A list of fragments of text that violated a policy.
type PolicyTopicEvidence_TextList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The fragments of text from the resource that caused the policy finding.
	Texts []*wrappers.StringValue `protobuf:"bytes,1,rep,name=texts,proto3" json:"texts,omitempty"`
}

func (x *PolicyTopicEvidence_TextList) Reset() {
	*x = PolicyTopicEvidence_TextList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_common_policy_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyTopicEvidence_TextList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyTopicEvidence_TextList) ProtoMessage() {}

func (x *PolicyTopicEvidence_TextList) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_common_policy_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyTopicEvidence_TextList.ProtoReflect.Descriptor instead.
func (*PolicyTopicEvidence_TextList) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_common_policy_proto_rawDescGZIP(), []int{3, 0}
}

func (x *PolicyTopicEvidence_TextList) GetTexts() []*wrappers.StringValue {
	if x != nil {
		return x.Texts
	}
	return nil
}

// A list of websites that caused a policy finding. Used for
// ONE_WEBSITE_PER_AD_GROUP policy topic, for example. In case there are more
// than five websites, only the top five (those that appear in resources the
// most) will be listed here.
type PolicyTopicEvidence_WebsiteList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Websites that caused the policy finding.
	Websites []*wrappers.StringValue `protobuf:"bytes,1,rep,name=websites,proto3" json:"websites,omitempty"`
}

func (x *PolicyTopicEvidence_WebsiteList) Reset() {
	*x = PolicyTopicEvidence_WebsiteList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_common_policy_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyTopicEvidence_WebsiteList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyTopicEvidence_WebsiteList) ProtoMessage() {}

func (x *PolicyTopicEvidence_WebsiteList) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_common_policy_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyTopicEvidence_WebsiteList.ProtoReflect.Descriptor instead.
func (*PolicyTopicEvidence_WebsiteList) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_common_policy_proto_rawDescGZIP(), []int{3, 1}
}

func (x *PolicyTopicEvidence_WebsiteList) GetWebsites() []*wrappers.StringValue {
	if x != nil {
		return x.Websites
	}
	return nil
}

// A list of strings found in a destination page that caused a policy
// finding.
type PolicyTopicEvidence_DestinationTextList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of text found in the resource's destination page.
	DestinationTexts []*wrappers.StringValue `protobuf:"bytes,1,rep,name=destination_texts,json=destinationTexts,proto3" json:"destination_texts,omitempty"`
}

func (x *PolicyTopicEvidence_DestinationTextList) Reset() {
	*x = PolicyTopicEvidence_DestinationTextList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_common_policy_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyTopicEvidence_DestinationTextList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyTopicEvidence_DestinationTextList) ProtoMessage() {}

func (x *PolicyTopicEvidence_DestinationTextList) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_common_policy_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyTopicEvidence_DestinationTextList.ProtoReflect.Descriptor instead.
func (*PolicyTopicEvidence_DestinationTextList) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_common_policy_proto_rawDescGZIP(), []int{3, 2}
}

func (x *PolicyTopicEvidence_DestinationTextList) GetDestinationTexts() []*wrappers.StringValue {
	if x != nil {
		return x.DestinationTexts
	}
	return nil
}

// Evidence of mismatches between the URLs of a resource.
type PolicyTopicEvidence_DestinationMismatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of URLs that did not match each other.
	UrlTypes []enums.PolicyTopicEvidenceDestinationMismatchUrlTypeEnum_PolicyTopicEvidenceDestinationMismatchUrlType `protobuf:"varint,1,rep,packed,name=url_types,json=urlTypes,proto3,enum=google.ads.googleads.v3.enums.PolicyTopicEvidenceDestinationMismatchUrlTypeEnum_PolicyTopicEvidenceDestinationMismatchUrlType" json:"url_types,omitempty"`
}

func (x *PolicyTopicEvidence_DestinationMismatch) Reset() {
	*x = PolicyTopicEvidence_DestinationMismatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_common_policy_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyTopicEvidence_DestinationMismatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyTopicEvidence_DestinationMismatch) ProtoMessage() {}

func (x *PolicyTopicEvidence_DestinationMismatch) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_common_policy_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyTopicEvidence_DestinationMismatch.ProtoReflect.Descriptor instead.
func (*PolicyTopicEvidence_DestinationMismatch) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_common_policy_proto_rawDescGZIP(), []int{3, 3}
}

func (x *PolicyTopicEvidence_DestinationMismatch) GetUrlTypes() []enums.PolicyTopicEvidenceDestinationMismatchUrlTypeEnum_PolicyTopicEvidenceDestinationMismatchUrlType {
	if x != nil {
		return x.UrlTypes
	}
	return nil
}

// Evidence details when the destination is returning an HTTP error
// code or isn't functional in all locations for commonly used devices.
type PolicyTopicEvidence_DestinationNotWorking struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full URL that didn't work.
	ExpandedUrl *wrappers.StringValue `protobuf:"bytes,3,opt,name=expanded_url,json=expandedUrl,proto3" json:"expanded_url,omitempty"`
	// The type of device that failed to load the URL.
	Device enums.PolicyTopicEvidenceDestinationNotWorkingDeviceEnum_PolicyTopicEvidenceDestinationNotWorkingDevice `protobuf:"varint,4,opt,name=device,proto3,enum=google.ads.googleads.v3.enums.PolicyTopicEvidenceDestinationNotWorkingDeviceEnum_PolicyTopicEvidenceDestinationNotWorkingDevice" json:"device,omitempty"`
	// The time the URL was last checked.
	// The format is "YYYY-MM-DD HH:MM:SS".
	// Examples: "2018-03-05 09:15:00" or "2018-02-01 14:34:30"
	LastCheckedDateTime *wrappers.StringValue `protobuf:"bytes,5,opt,name=last_checked_date_time,json=lastCheckedDateTime,proto3" json:"last_checked_date_time,omitempty"`
	// Indicates the reason of the DESTINATION_NOT_WORKING policy finding.
	//
	// Types that are assignable to Reason:
	//	*PolicyTopicEvidence_DestinationNotWorking_DnsErrorType
	//	*PolicyTopicEvidence_DestinationNotWorking_HttpErrorCode
	Reason isPolicyTopicEvidence_DestinationNotWorking_Reason `protobuf_oneof:"reason"`
}

func (x *PolicyTopicEvidence_DestinationNotWorking) Reset() {
	*x = PolicyTopicEvidence_DestinationNotWorking{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_common_policy_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyTopicEvidence_DestinationNotWorking) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyTopicEvidence_DestinationNotWorking) ProtoMessage() {}

func (x *PolicyTopicEvidence_DestinationNotWorking) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_common_policy_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyTopicEvidence_DestinationNotWorking.ProtoReflect.Descriptor instead.
func (*PolicyTopicEvidence_DestinationNotWorking) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_common_policy_proto_rawDescGZIP(), []int{3, 4}
}

func (x *PolicyTopicEvidence_DestinationNotWorking) GetExpandedUrl() *wrappers.StringValue {
	if x != nil {
		return x.ExpandedUrl
	}
	return nil
}

func (x *PolicyTopicEvidence_DestinationNotWorking) GetDevice() enums.PolicyTopicEvidenceDestinationNotWorkingDeviceEnum_PolicyTopicEvidenceDestinationNotWorkingDevice {
	if x != nil {
		return x.Device
	}
	return enums.PolicyTopicEvidenceDestinationNotWorkingDeviceEnum_UNSPECIFIED
}

func (x *PolicyTopicEvidence_DestinationNotWorking) GetLastCheckedDateTime() *wrappers.StringValue {
	if x != nil {
		return x.LastCheckedDateTime
	}
	return nil
}

func (m *PolicyTopicEvidence_DestinationNotWorking) GetReason() isPolicyTopicEvidence_DestinationNotWorking_Reason {
	if m != nil {
		return m.Reason
	}
	return nil
}

func (x *PolicyTopicEvidence_DestinationNotWorking) GetDnsErrorType() enums.PolicyTopicEvidenceDestinationNotWorkingDnsErrorTypeEnum_PolicyTopicEvidenceDestinationNotWorkingDnsErrorType {
	if x, ok := x.GetReason().(*PolicyTopicEvidence_DestinationNotWorking_DnsErrorType); ok {
		return x.DnsErrorType
	}
	return enums.PolicyTopicEvidenceDestinationNotWorkingDnsErrorTypeEnum_UNSPECIFIED
}

func (x *PolicyTopicEvidence_DestinationNotWorking) GetHttpErrorCode() *wrappers.Int64Value {
	if x, ok := x.GetReason().(*PolicyTopicEvidence_DestinationNotWorking_HttpErrorCode); ok {
		return x.HttpErrorCode
	}
	return nil
}

type isPolicyTopicEvidence_DestinationNotWorking_Reason interface {
	isPolicyTopicEvidence_DestinationNotWorking_Reason()
}

type PolicyTopicEvidence_DestinationNotWorking_DnsErrorType struct {
	// The type of DNS error.
	DnsErrorType enums.PolicyTopicEvidenceDestinationNotWorkingDnsErrorTypeEnum_PolicyTopicEvidenceDestinationNotWorkingDnsErrorType `protobuf:"varint,1,opt,name=dns_error_type,json=dnsErrorType,proto3,enum=google.ads.googleads.v3.enums.PolicyTopicEvidenceDestinationNotWorkingDnsErrorTypeEnum_PolicyTopicEvidenceDestinationNotWorkingDnsErrorType,oneof"`
}

type PolicyTopicEvidence_DestinationNotWorking_HttpErrorCode struct {
	// The HTTP error code.
	HttpErrorCode *wrappers.Int64Value `protobuf:"bytes,2,opt,name=http_error_code,json=httpErrorCode,proto3,oneof"`
}

func (*PolicyTopicEvidence_DestinationNotWorking_DnsErrorType) isPolicyTopicEvidence_DestinationNotWorking_Reason() {
}

func (*PolicyTopicEvidence_DestinationNotWorking_HttpErrorCode) isPolicyTopicEvidence_DestinationNotWorking_Reason() {
}

// A list of countries where a resource's serving is constrained.
type PolicyTopicConstraint_CountryConstraintList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Total number of countries targeted by the resource.
	TotalTargetedCountries *wrappers.Int32Value `protobuf:"bytes,1,opt,name=total_targeted_countries,json=totalTargetedCountries,proto3" json:"total_targeted_countries,omitempty"`
	// Countries in which serving is restricted.
	Countries []*PolicyTopicConstraint_CountryConstraint `protobuf:"bytes,2,rep,name=countries,proto3" json:"countries,omitempty"`
}

func (x *PolicyTopicConstraint_CountryConstraintList) Reset() {
	*x = PolicyTopicConstraint_CountryConstraintList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_common_policy_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyTopicConstraint_CountryConstraintList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyTopicConstraint_CountryConstraintList) ProtoMessage() {}

func (x *PolicyTopicConstraint_CountryConstraintList) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_common_policy_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyTopicConstraint_CountryConstraintList.ProtoReflect.Descriptor instead.
func (*PolicyTopicConstraint_CountryConstraintList) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_common_policy_proto_rawDescGZIP(), []int{4, 0}
}

func (x *PolicyTopicConstraint_CountryConstraintList) GetTotalTargetedCountries() *wrappers.Int32Value {
	if x != nil {
		return x.TotalTargetedCountries
	}
	return nil
}

func (x *PolicyTopicConstraint_CountryConstraintList) GetCountries() []*PolicyTopicConstraint_CountryConstraint {
	if x != nil {
		return x.Countries
	}
	return nil
}

// Indicates that a policy topic was constrained due to disapproval of the
// website for reseller purposes.
type PolicyTopicConstraint_ResellerConstraint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PolicyTopicConstraint_ResellerConstraint) Reset() {
	*x = PolicyTopicConstraint_ResellerConstraint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_common_policy_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyTopicConstraint_ResellerConstraint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyTopicConstraint_ResellerConstraint) ProtoMessage() {}

func (x *PolicyTopicConstraint_ResellerConstraint) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_common_policy_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyTopicConstraint_ResellerConstraint.ProtoReflect.Descriptor instead.
func (*PolicyTopicConstraint_ResellerConstraint) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_common_policy_proto_rawDescGZIP(), []int{4, 1}
}

// Indicates that a resource's ability to serve in a particular country is
// constrained.
type PolicyTopicConstraint_CountryConstraint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Geo target constant resource name of the country in which serving is
	// constrained.
	CountryCriterion *wrappers.StringValue `protobuf:"bytes,1,opt,name=country_criterion,json=countryCriterion,proto3" json:"country_criterion,omitempty"`
}

func (x *PolicyTopicConstraint_CountryConstraint) Reset() {
	*x = PolicyTopicConstraint_CountryConstraint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_common_policy_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyTopicConstraint_CountryConstraint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyTopicConstraint_CountryConstraint) ProtoMessage() {}

func (x *PolicyTopicConstraint_CountryConstraint) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_common_policy_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyTopicConstraint_CountryConstraint.ProtoReflect.Descriptor instead.
func (*PolicyTopicConstraint_CountryConstraint) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_common_policy_proto_rawDescGZIP(), []int{4, 2}
}

func (x *PolicyTopicConstraint_CountryConstraint) GetCountryCriterion() *wrappers.StringValue {
	if x != nil {
		return x.CountryCriterion
	}
	return nil
}

var File_google_ads_googleads_v3_common_policy_proto protoreflect.FileDescriptor

var file_google_ads_googleads_v3_common_policy_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x1a, 0x3b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x57, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x33, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x5f, 0x65, 0x76, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f,
	0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x69, 0x73, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x5f, 0x75, 0x72, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x58, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x5f,
	0x65, 0x76, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67,
	0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x60, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x5f, 0x65, 0x76, 0x69, 0x64, 0x65, 0x6e,
	0x63, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e,
	0x6f, 0x74, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x6e, 0x73, 0x5f, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x98, 0x01,
	0x0a, 0x12, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4b, 0x65, 0x79, 0x12, 0x3d, 0x0a, 0x0b, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x43, 0x0a, 0x0e, 0x76, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x76, 0x69, 0x6f, 0x6c, 0x61,
	0x74, 0x69, 0x6e, 0x67, 0x54, 0x65, 0x78, 0x74, 0x22, 0xe6, 0x01, 0x0a, 0x19, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x54, 0x0a, 0x17, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x15, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x61, 0x62, 0x6c, 0x65,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x12, 0x73, 0x0a, 0x1c,
	0x65, 0x78, 0x65, 0x6d, 0x70, 0x74, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x76, 0x69,
	0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x19, 0x65, 0x78, 0x65, 0x6d, 0x70, 0x74, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79,
	0x73, 0x22, 0xd4, 0x02, 0x0a, 0x10, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x6f, 0x70, 0x69,
	0x63, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x32, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x60, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x33, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54,
	0x6f, 0x70, 0x69, 0x63, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75,
	0x6d, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x51, 0x0a, 0x09,
	0x65, 0x76, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x45, 0x76, 0x69, 0x64,
	0x65, 0x6e, 0x63, 0x65, 0x52, 0x09, 0x65, 0x76, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12,
	0x57, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x6f, 0x70, 0x69,
	0x63, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x52, 0x0b, 0x63, 0x6f, 0x6e,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x22, 0x9d, 0x0d, 0x0a, 0x13, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x45, 0x76, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65,
	0x12, 0x64, 0x0a, 0x0c, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x73, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x6f,
	0x70, 0x69, 0x63, 0x45, 0x76, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x57, 0x65, 0x62, 0x73,
	0x69, 0x74, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x77, 0x65, 0x62, 0x73, 0x69,
	0x74, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x5b, 0x0a, 0x09, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x6c,
	0x69, 0x73, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x33, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x45, 0x76, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x54,
	0x65, 0x78, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x08, 0x74, 0x65, 0x78, 0x74, 0x4c,
	0x69, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x7d, 0x0a, 0x15, 0x64, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x6c, 0x69, 0x73,
	0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x33, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54,
	0x6f, 0x70, 0x69, 0x63, 0x45, 0x76, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x44, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x78, 0x74, 0x4c, 0x69, 0x73, 0x74,
	0x48, 0x00, 0x52, 0x13, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x65, 0x78, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x7c, 0x0a, 0x14, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x69, 0x73, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x6f, 0x70,
	0x69, 0x63, 0x45, 0x76, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x69, 0x73, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x48, 0x00,
	0x52, 0x13, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x69, 0x73,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x83, 0x01, 0x0a, 0x17, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e,
	0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x33, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54,
	0x6f, 0x70, 0x69, 0x63, 0x45, 0x76, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x44, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x69,
	0x6e, 0x67, 0x48, 0x00, 0x52, 0x15, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4e, 0x6f, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x1a, 0x3e, 0x0a, 0x08, 0x54,
	0x65, 0x78, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x32, 0x0a, 0x05, 0x74, 0x65, 0x78, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x74, 0x65, 0x78, 0x74, 0x73, 0x1a, 0x47, 0x0a, 0x0b, 0x57,
	0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x08, 0x77, 0x65,
	0x62, 0x73, 0x69, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x77, 0x65, 0x62, 0x73,
	0x69, 0x74, 0x65, 0x73, 0x1a, 0x60, 0x0a, 0x13, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x65, 0x78, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x11, 0x64,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x10, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x65, 0x78, 0x74, 0x73, 0x1a, 0xb3, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x69, 0x73, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x9b,
	0x01, 0x0a, 0x09, 0x75, 0x72, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0e, 0x32, 0x7e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x45, 0x76,
	0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x69, 0x73, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x55, 0x72, 0x6c, 0x54, 0x79, 0x70, 0x65,
	0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x6f, 0x70, 0x69, 0x63,
	0x45, 0x76, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x69, 0x73, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x55, 0x72, 0x6c, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x08, 0x75, 0x72, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x73, 0x1a, 0xd0, 0x04, 0x0a,
	0x15, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x57,
	0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x12, 0x3f, 0x0a, 0x0c, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64,
	0x65, 0x64, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x65, 0x78, 0x70, 0x61,
	0x6e, 0x64, 0x65, 0x64, 0x55, 0x72, 0x6c, 0x12, 0x99, 0x01, 0x0a, 0x06, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x80, 0x01, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x33, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x54, 0x6f, 0x70, 0x69, 0x63, 0x45, 0x76, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x69,
	0x6e, 0x67, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x45, 0x76, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65,
	0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x57, 0x6f,
	0x72, 0x6b, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x06, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x12, 0x51, 0x0a, 0x16, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x63, 0x68, 0x65, 0x63,
	0x6b, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x13, 0x6c, 0x61, 0x73, 0x74, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x65, 0x64, 0x44, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0xb5, 0x01, 0x0a, 0x0e, 0x64, 0x6e, 0x73, 0x5f, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x8c, 0x01, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73,
	0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x45, 0x76, 0x69, 0x64,
	0x65, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e,
	0x6f, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x44, 0x6e, 0x73, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x54, 0x6f, 0x70, 0x69, 0x63, 0x45, 0x76, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x69,
	0x6e, 0x67, 0x44, 0x6e, 0x73, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00,
	0x52, 0x0c, 0x64, 0x6e, 0x73, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x45,
	0x0a, 0x0f, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x68, 0x74, 0x74, 0x70, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x43, 0x6f, 0x64, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42,
	0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xbe, 0x07, 0x0a, 0x15, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x74, 0x12, 0x85, 0x01, 0x0a, 0x17, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63,
	0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x6f, 0x70, 0x69,
	0x63, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x2e, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x4c, 0x69, 0x73,
	0x74, 0x48, 0x00, 0x52, 0x15, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x7b, 0x0a, 0x13, 0x72, 0x65,
	0x73, 0x65, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x33, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54,
	0x6f, 0x70, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x2e, 0x52,
	0x65, 0x73, 0x65, 0x6c, 0x6c, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x74, 0x48, 0x00, 0x52, 0x12, 0x72, 0x65, 0x73, 0x65, 0x6c, 0x6c, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x9b, 0x01, 0x0a, 0x23, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f,
	0x69, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x6f, 0x70,
	0x69, 0x63, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x2e, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x4c, 0x69,
	0x73, 0x74, 0x48, 0x00, 0x52, 0x1f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72,
	0x79, 0x4c, 0x69, 0x73, 0x74, 0x12, 0xaa, 0x01, 0x0a, 0x2b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x6d, 0x69, 0x73,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x69, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79,
	0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x74, 0x2e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x26, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4d, 0x69, 0x73,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69,
	0x73, 0x74, 0x1a, 0xd5, 0x01, 0x0a, 0x15, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x43, 0x6f,
	0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x18,
	0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x16, 0x74, 0x6f, 0x74,
	0x61, 0x6c, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x12, 0x65, 0x0a, 0x09, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x6f,
	0x70, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x2e, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x52,
	0x09, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x1a, 0x14, 0x0a, 0x12, 0x52, 0x65,
	0x73, 0x65, 0x6c, 0x6c, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74,
	0x1a, 0x5e, 0x0a, 0x11, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x49, 0x0a, 0x11, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79,
	0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x10,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e,
	0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0xe6, 0x01, 0x0a, 0x22, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x42, 0x0b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f,
	0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x3b, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0xa2, 0x02, 0x03, 0x47, 0x41, 0x41, 0xaa, 0x02, 0x1e, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x64, 0x73, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41,
	0x64, 0x73, 0x2e, 0x56, 0x33, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0xca, 0x02, 0x1e, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x64, 0x73, 0x5c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x41, 0x64, 0x73, 0x5c, 0x56, 0x33, 0x5c, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0xea, 0x02, 0x22,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x56, 0x33, 0x3a, 0x3a, 0x43, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ads_googleads_v3_common_policy_proto_rawDescOnce sync.Once
	file_google_ads_googleads_v3_common_policy_proto_rawDescData = file_google_ads_googleads_v3_common_policy_proto_rawDesc
)

func file_google_ads_googleads_v3_common_policy_proto_rawDescGZIP() []byte {
	file_google_ads_googleads_v3_common_policy_proto_rawDescOnce.Do(func() {
		file_google_ads_googleads_v3_common_policy_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_googleads_v3_common_policy_proto_rawDescData)
	})
	return file_google_ads_googleads_v3_common_policy_proto_rawDescData
}

var file_google_ads_googleads_v3_common_policy_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_ads_googleads_v3_common_policy_proto_goTypes = []interface{}{
	(*PolicyViolationKey)(nil),                               // 0: google.ads.googleads.v3.common.PolicyViolationKey
	(*PolicyValidationParameter)(nil),                        // 1: google.ads.googleads.v3.common.PolicyValidationParameter
	(*PolicyTopicEntry)(nil),                                 // 2: google.ads.googleads.v3.common.PolicyTopicEntry
	(*PolicyTopicEvidence)(nil),                              // 3: google.ads.googleads.v3.common.PolicyTopicEvidence
	(*PolicyTopicConstraint)(nil),                            // 4: google.ads.googleads.v3.common.PolicyTopicConstraint
	(*PolicyTopicEvidence_TextList)(nil),                     // 5: google.ads.googleads.v3.common.PolicyTopicEvidence.TextList
	(*PolicyTopicEvidence_WebsiteList)(nil),                  // 6: google.ads.googleads.v3.common.PolicyTopicEvidence.WebsiteList
	(*PolicyTopicEvidence_DestinationTextList)(nil),          // 7: google.ads.googleads.v3.common.PolicyTopicEvidence.DestinationTextList
	(*PolicyTopicEvidence_DestinationMismatch)(nil),          // 8: google.ads.googleads.v3.common.PolicyTopicEvidence.DestinationMismatch
	(*PolicyTopicEvidence_DestinationNotWorking)(nil),        // 9: google.ads.googleads.v3.common.PolicyTopicEvidence.DestinationNotWorking
	(*PolicyTopicConstraint_CountryConstraintList)(nil),      // 10: google.ads.googleads.v3.common.PolicyTopicConstraint.CountryConstraintList
	(*PolicyTopicConstraint_ResellerConstraint)(nil),         // 11: google.ads.googleads.v3.common.PolicyTopicConstraint.ResellerConstraint
	(*PolicyTopicConstraint_CountryConstraint)(nil),          // 12: google.ads.googleads.v3.common.PolicyTopicConstraint.CountryConstraint
	(*wrappers.StringValue)(nil),                             // 13: google.protobuf.StringValue
	(enums.PolicyTopicEntryTypeEnum_PolicyTopicEntryType)(0), // 14: google.ads.googleads.v3.enums.PolicyTopicEntryTypeEnum.PolicyTopicEntryType
	(enums.PolicyTopicEvidenceDestinationMismatchUrlTypeEnum_PolicyTopicEvidenceDestinationMismatchUrlType)(0),               // 15: google.ads.googleads.v3.enums.PolicyTopicEvidenceDestinationMismatchUrlTypeEnum.PolicyTopicEvidenceDestinationMismatchUrlType
	(enums.PolicyTopicEvidenceDestinationNotWorkingDeviceEnum_PolicyTopicEvidenceDestinationNotWorkingDevice)(0),             // 16: google.ads.googleads.v3.enums.PolicyTopicEvidenceDestinationNotWorkingDeviceEnum.PolicyTopicEvidenceDestinationNotWorkingDevice
	(enums.PolicyTopicEvidenceDestinationNotWorkingDnsErrorTypeEnum_PolicyTopicEvidenceDestinationNotWorkingDnsErrorType)(0), // 17: google.ads.googleads.v3.enums.PolicyTopicEvidenceDestinationNotWorkingDnsErrorTypeEnum.PolicyTopicEvidenceDestinationNotWorkingDnsErrorType
	(*wrappers.Int64Value)(nil), // 18: google.protobuf.Int64Value
	(*wrappers.Int32Value)(nil), // 19: google.protobuf.Int32Value
}
var file_google_ads_googleads_v3_common_policy_proto_depIdxs = []int32{
	13, // 0: google.ads.googleads.v3.common.PolicyViolationKey.policy_name:type_name -> google.protobuf.StringValue
	13, // 1: google.ads.googleads.v3.common.PolicyViolationKey.violating_text:type_name -> google.protobuf.StringValue
	13, // 2: google.ads.googleads.v3.common.PolicyValidationParameter.ignorable_policy_topics:type_name -> google.protobuf.StringValue
	0,  // 3: google.ads.googleads.v3.common.PolicyValidationParameter.exempt_policy_violation_keys:type_name -> google.ads.googleads.v3.common.PolicyViolationKey
	13, // 4: google.ads.googleads.v3.common.PolicyTopicEntry.topic:type_name -> google.protobuf.StringValue
	14, // 5: google.ads.googleads.v3.common.PolicyTopicEntry.type:type_name -> google.ads.googleads.v3.enums.PolicyTopicEntryTypeEnum.PolicyTopicEntryType
	3,  // 6: google.ads.googleads.v3.common.PolicyTopicEntry.evidences:type_name -> google.ads.googleads.v3.common.PolicyTopicEvidence
	4,  // 7: google.ads.googleads.v3.common.PolicyTopicEntry.constraints:type_name -> google.ads.googleads.v3.common.PolicyTopicConstraint
	6,  // 8: google.ads.googleads.v3.common.PolicyTopicEvidence.website_list:type_name -> google.ads.googleads.v3.common.PolicyTopicEvidence.WebsiteList
	5,  // 9: google.ads.googleads.v3.common.PolicyTopicEvidence.text_list:type_name -> google.ads.googleads.v3.common.PolicyTopicEvidence.TextList
	13, // 10: google.ads.googleads.v3.common.PolicyTopicEvidence.language_code:type_name -> google.protobuf.StringValue
	7,  // 11: google.ads.googleads.v3.common.PolicyTopicEvidence.destination_text_list:type_name -> google.ads.googleads.v3.common.PolicyTopicEvidence.DestinationTextList
	8,  // 12: google.ads.googleads.v3.common.PolicyTopicEvidence.destination_mismatch:type_name -> google.ads.googleads.v3.common.PolicyTopicEvidence.DestinationMismatch
	9,  // 13: google.ads.googleads.v3.common.PolicyTopicEvidence.destination_not_working:type_name -> google.ads.googleads.v3.common.PolicyTopicEvidence.DestinationNotWorking
	10, // 14: google.ads.googleads.v3.common.PolicyTopicConstraint.country_constraint_list:type_name -> google.ads.googleads.v3.common.PolicyTopicConstraint.CountryConstraintList
	11, // 15: google.ads.googleads.v3.common.PolicyTopicConstraint.reseller_constraint:type_name -> google.ads.googleads.v3.common.PolicyTopicConstraint.ResellerConstraint
	10, // 16: google.ads.googleads.v3.common.PolicyTopicConstraint.certificate_missing_in_country_list:type_name -> google.ads.googleads.v3.common.PolicyTopicConstraint.CountryConstraintList
	10, // 17: google.ads.googleads.v3.common.PolicyTopicConstraint.certificate_domain_mismatch_in_country_list:type_name -> google.ads.googleads.v3.common.PolicyTopicConstraint.CountryConstraintList
	13, // 18: google.ads.googleads.v3.common.PolicyTopicEvidence.TextList.texts:type_name -> google.protobuf.StringValue
	13, // 19: google.ads.googleads.v3.common.PolicyTopicEvidence.WebsiteList.websites:type_name -> google.protobuf.StringValue
	13, // 20: google.ads.googleads.v3.common.PolicyTopicEvidence.DestinationTextList.destination_texts:type_name -> google.protobuf.StringValue
	15, // 21: google.ads.googleads.v3.common.PolicyTopicEvidence.DestinationMismatch.url_types:type_name -> google.ads.googleads.v3.enums.PolicyTopicEvidenceDestinationMismatchUrlTypeEnum.PolicyTopicEvidenceDestinationMismatchUrlType
	13, // 22: google.ads.googleads.v3.common.PolicyTopicEvidence.DestinationNotWorking.expanded_url:type_name -> google.protobuf.StringValue
	16, // 23: google.ads.googleads.v3.common.PolicyTopicEvidence.DestinationNotWorking.device:type_name -> google.ads.googleads.v3.enums.PolicyTopicEvidenceDestinationNotWorkingDeviceEnum.PolicyTopicEvidenceDestinationNotWorkingDevice
	13, // 24: google.ads.googleads.v3.common.PolicyTopicEvidence.DestinationNotWorking.last_checked_date_time:type_name -> google.protobuf.StringValue
	17, // 25: google.ads.googleads.v3.common.PolicyTopicEvidence.DestinationNotWorking.dns_error_type:type_name -> google.ads.googleads.v3.enums.PolicyTopicEvidenceDestinationNotWorkingDnsErrorTypeEnum.PolicyTopicEvidenceDestinationNotWorkingDnsErrorType
	18, // 26: google.ads.googleads.v3.common.PolicyTopicEvidence.DestinationNotWorking.http_error_code:type_name -> google.protobuf.Int64Value
	19, // 27: google.ads.googleads.v3.common.PolicyTopicConstraint.CountryConstraintList.total_targeted_countries:type_name -> google.protobuf.Int32Value
	12, // 28: google.ads.googleads.v3.common.PolicyTopicConstraint.CountryConstraintList.countries:type_name -> google.ads.googleads.v3.common.PolicyTopicConstraint.CountryConstraint
	13, // 29: google.ads.googleads.v3.common.PolicyTopicConstraint.CountryConstraint.country_criterion:type_name -> google.protobuf.StringValue
	30, // [30:30] is the sub-list for method output_type
	30, // [30:30] is the sub-list for method input_type
	30, // [30:30] is the sub-list for extension type_name
	30, // [30:30] is the sub-list for extension extendee
	0,  // [0:30] is the sub-list for field type_name
}

func init() { file_google_ads_googleads_v3_common_policy_proto_init() }
func file_google_ads_googleads_v3_common_policy_proto_init() {
	if File_google_ads_googleads_v3_common_policy_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_ads_googleads_v3_common_policy_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyViolationKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_common_policy_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyValidationParameter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_common_policy_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyTopicEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_common_policy_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyTopicEvidence); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_common_policy_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyTopicConstraint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_common_policy_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyTopicEvidence_TextList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_common_policy_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyTopicEvidence_WebsiteList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_common_policy_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyTopicEvidence_DestinationTextList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_common_policy_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyTopicEvidence_DestinationMismatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_common_policy_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyTopicEvidence_DestinationNotWorking); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_common_policy_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyTopicConstraint_CountryConstraintList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_common_policy_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyTopicConstraint_ResellerConstraint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_common_policy_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyTopicConstraint_CountryConstraint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_ads_googleads_v3_common_policy_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*PolicyTopicEvidence_WebsiteList_)(nil),
		(*PolicyTopicEvidence_TextList_)(nil),
		(*PolicyTopicEvidence_LanguageCode)(nil),
		(*PolicyTopicEvidence_DestinationTextList_)(nil),
		(*PolicyTopicEvidence_DestinationMismatch_)(nil),
		(*PolicyTopicEvidence_DestinationNotWorking_)(nil),
	}
	file_google_ads_googleads_v3_common_policy_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*PolicyTopicConstraint_CountryConstraintList_)(nil),
		(*PolicyTopicConstraint_ResellerConstraint_)(nil),
		(*PolicyTopicConstraint_CertificateMissingInCountryList)(nil),
		(*PolicyTopicConstraint_CertificateDomainMismatchInCountryList)(nil),
	}
	file_google_ads_googleads_v3_common_policy_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*PolicyTopicEvidence_DestinationNotWorking_DnsErrorType)(nil),
		(*PolicyTopicEvidence_DestinationNotWorking_HttpErrorCode)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_googleads_v3_common_policy_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_ads_googleads_v3_common_policy_proto_goTypes,
		DependencyIndexes: file_google_ads_googleads_v3_common_policy_proto_depIdxs,
		MessageInfos:      file_google_ads_googleads_v3_common_policy_proto_msgTypes,
	}.Build()
	File_google_ads_googleads_v3_common_policy_proto = out.File
	file_google_ads_googleads_v3_common_policy_proto_rawDesc = nil
	file_google_ads_googleads_v3_common_policy_proto_goTypes = nil
	file_google_ads_googleads_v3_common_policy_proto_depIdxs = nil
}
