// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.3
// source: google/ads/googleads/v2/resources/feed_mapping.proto

package resources

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v2/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// A feed mapping.
type FeedMapping struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The resource name of the feed mapping.
	// Feed mapping resource names have the form:
	//
	// `customers/{customer_id}/feedMappings/{feed_id}~{feed_mapping_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Immutable. The feed of this feed mapping.
	Feed *wrappers.StringValue `protobuf:"bytes,2,opt,name=feed,proto3" json:"feed,omitempty"`
	// Immutable. Feed attributes to field mappings. These mappings are a one-to-many
	// relationship meaning that 1 feed attribute can be used to populate
	// multiple placeholder fields, but 1 placeholder field can only draw
	// data from 1 feed attribute. Ad Customizer is an exception, 1 placeholder
	// field can be mapped to multiple feed attributes. Required.
	AttributeFieldMappings []*AttributeFieldMapping `protobuf:"bytes,5,rep,name=attribute_field_mappings,json=attributeFieldMappings,proto3" json:"attribute_field_mappings,omitempty"`
	// Output only. Status of the feed mapping.
	// This field is read-only.
	Status enums.FeedMappingStatusEnum_FeedMappingStatus `protobuf:"varint,6,opt,name=status,proto3,enum=google.ads.googleads.v2.enums.FeedMappingStatusEnum_FeedMappingStatus" json:"status,omitempty"`
	// Feed mapping target. Can be either a placeholder or a criterion. For a
	// given feed, the active FeedMappings must have unique targets. Required.
	//
	// Types that are assignable to Target:
	//	*FeedMapping_PlaceholderType
	//	*FeedMapping_CriterionType
	Target isFeedMapping_Target `protobuf_oneof:"target"`
}

func (x *FeedMapping) Reset() {
	*x = FeedMapping{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_resources_feed_mapping_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FeedMapping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeedMapping) ProtoMessage() {}

func (x *FeedMapping) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_resources_feed_mapping_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeedMapping.ProtoReflect.Descriptor instead.
func (*FeedMapping) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_resources_feed_mapping_proto_rawDescGZIP(), []int{0}
}

func (x *FeedMapping) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *FeedMapping) GetFeed() *wrappers.StringValue {
	if x != nil {
		return x.Feed
	}
	return nil
}

func (x *FeedMapping) GetAttributeFieldMappings() []*AttributeFieldMapping {
	if x != nil {
		return x.AttributeFieldMappings
	}
	return nil
}

func (x *FeedMapping) GetStatus() enums.FeedMappingStatusEnum_FeedMappingStatus {
	if x != nil {
		return x.Status
	}
	return enums.FeedMappingStatusEnum_UNSPECIFIED
}

func (m *FeedMapping) GetTarget() isFeedMapping_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (x *FeedMapping) GetPlaceholderType() enums.PlaceholderTypeEnum_PlaceholderType {
	if x, ok := x.GetTarget().(*FeedMapping_PlaceholderType); ok {
		return x.PlaceholderType
	}
	return enums.PlaceholderTypeEnum_UNSPECIFIED
}

func (x *FeedMapping) GetCriterionType() enums.FeedMappingCriterionTypeEnum_FeedMappingCriterionType {
	if x, ok := x.GetTarget().(*FeedMapping_CriterionType); ok {
		return x.CriterionType
	}
	return enums.FeedMappingCriterionTypeEnum_UNSPECIFIED
}

type isFeedMapping_Target interface {
	isFeedMapping_Target()
}

type FeedMapping_PlaceholderType struct {
	// Immutable. The placeholder type of this mapping (i.e., if the mapping maps feed
	// attributes to placeholder fields).
	PlaceholderType enums.PlaceholderTypeEnum_PlaceholderType `protobuf:"varint,3,opt,name=placeholder_type,json=placeholderType,proto3,enum=google.ads.googleads.v2.enums.PlaceholderTypeEnum_PlaceholderType,oneof"`
}

type FeedMapping_CriterionType struct {
	// Immutable. The criterion type of this mapping (i.e., if the mapping maps feed
	// attributes to criterion fields).
	CriterionType enums.FeedMappingCriterionTypeEnum_FeedMappingCriterionType `protobuf:"varint,4,opt,name=criterion_type,json=criterionType,proto3,enum=google.ads.googleads.v2.enums.FeedMappingCriterionTypeEnum_FeedMappingCriterionType,oneof"`
}

func (*FeedMapping_PlaceholderType) isFeedMapping_Target() {}

func (*FeedMapping_CriterionType) isFeedMapping_Target() {}

// Maps from feed attribute id to a placeholder or criterion field id.
type AttributeFieldMapping struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. Feed attribute from which to map.
	FeedAttributeId *wrappers.Int64Value `protobuf:"bytes,1,opt,name=feed_attribute_id,json=feedAttributeId,proto3" json:"feed_attribute_id,omitempty"`
	// Output only. The placeholder field ID. If a placeholder field enum is not published in
	// the current API version, then this field will be populated and the field
	// oneof will be empty.
	// This field is read-only.
	FieldId *wrappers.Int64Value `protobuf:"bytes,2,opt,name=field_id,json=fieldId,proto3" json:"field_id,omitempty"`
	// Placeholder or criterion field to be populated using data from
	// the above feed attribute. Required.
	//
	// Types that are assignable to Field:
	//	*AttributeFieldMapping_SitelinkField
	//	*AttributeFieldMapping_CallField
	//	*AttributeFieldMapping_AppField
	//	*AttributeFieldMapping_LocationField
	//	*AttributeFieldMapping_AffiliateLocationField
	//	*AttributeFieldMapping_CalloutField
	//	*AttributeFieldMapping_StructuredSnippetField
	//	*AttributeFieldMapping_MessageField
	//	*AttributeFieldMapping_PriceField
	//	*AttributeFieldMapping_PromotionField
	//	*AttributeFieldMapping_AdCustomizerField
	//	*AttributeFieldMapping_DsaPageFeedField
	//	*AttributeFieldMapping_LocationExtensionTargetingField
	//	*AttributeFieldMapping_EducationField
	//	*AttributeFieldMapping_FlightField
	//	*AttributeFieldMapping_CustomField
	//	*AttributeFieldMapping_HotelField
	//	*AttributeFieldMapping_RealEstateField
	//	*AttributeFieldMapping_TravelField
	//	*AttributeFieldMapping_LocalField
	//	*AttributeFieldMapping_JobField
	Field isAttributeFieldMapping_Field `protobuf_oneof:"field"`
}

func (x *AttributeFieldMapping) Reset() {
	*x = AttributeFieldMapping{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_resources_feed_mapping_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttributeFieldMapping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributeFieldMapping) ProtoMessage() {}

func (x *AttributeFieldMapping) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_resources_feed_mapping_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributeFieldMapping.ProtoReflect.Descriptor instead.
func (*AttributeFieldMapping) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_resources_feed_mapping_proto_rawDescGZIP(), []int{1}
}

func (x *AttributeFieldMapping) GetFeedAttributeId() *wrappers.Int64Value {
	if x != nil {
		return x.FeedAttributeId
	}
	return nil
}

func (x *AttributeFieldMapping) GetFieldId() *wrappers.Int64Value {
	if x != nil {
		return x.FieldId
	}
	return nil
}

func (m *AttributeFieldMapping) GetField() isAttributeFieldMapping_Field {
	if m != nil {
		return m.Field
	}
	return nil
}

func (x *AttributeFieldMapping) GetSitelinkField() enums.SitelinkPlaceholderFieldEnum_SitelinkPlaceholderField {
	if x, ok := x.GetField().(*AttributeFieldMapping_SitelinkField); ok {
		return x.SitelinkField
	}
	return enums.SitelinkPlaceholderFieldEnum_UNSPECIFIED
}

func (x *AttributeFieldMapping) GetCallField() enums.CallPlaceholderFieldEnum_CallPlaceholderField {
	if x, ok := x.GetField().(*AttributeFieldMapping_CallField); ok {
		return x.CallField
	}
	return enums.CallPlaceholderFieldEnum_UNSPECIFIED
}

func (x *AttributeFieldMapping) GetAppField() enums.AppPlaceholderFieldEnum_AppPlaceholderField {
	if x, ok := x.GetField().(*AttributeFieldMapping_AppField); ok {
		return x.AppField
	}
	return enums.AppPlaceholderFieldEnum_UNSPECIFIED
}

func (x *AttributeFieldMapping) GetLocationField() enums.LocationPlaceholderFieldEnum_LocationPlaceholderField {
	if x, ok := x.GetField().(*AttributeFieldMapping_LocationField); ok {
		return x.LocationField
	}
	return enums.LocationPlaceholderFieldEnum_UNSPECIFIED
}

func (x *AttributeFieldMapping) GetAffiliateLocationField() enums.AffiliateLocationPlaceholderFieldEnum_AffiliateLocationPlaceholderField {
	if x, ok := x.GetField().(*AttributeFieldMapping_AffiliateLocationField); ok {
		return x.AffiliateLocationField
	}
	return enums.AffiliateLocationPlaceholderFieldEnum_UNSPECIFIED
}

func (x *AttributeFieldMapping) GetCalloutField() enums.CalloutPlaceholderFieldEnum_CalloutPlaceholderField {
	if x, ok := x.GetField().(*AttributeFieldMapping_CalloutField); ok {
		return x.CalloutField
	}
	return enums.CalloutPlaceholderFieldEnum_UNSPECIFIED
}

func (x *AttributeFieldMapping) GetStructuredSnippetField() enums.StructuredSnippetPlaceholderFieldEnum_StructuredSnippetPlaceholderField {
	if x, ok := x.GetField().(*AttributeFieldMapping_StructuredSnippetField); ok {
		return x.StructuredSnippetField
	}
	return enums.StructuredSnippetPlaceholderFieldEnum_UNSPECIFIED
}

func (x *AttributeFieldMapping) GetMessageField() enums.MessagePlaceholderFieldEnum_MessagePlaceholderField {
	if x, ok := x.GetField().(*AttributeFieldMapping_MessageField); ok {
		return x.MessageField
	}
	return enums.MessagePlaceholderFieldEnum_UNSPECIFIED
}

func (x *AttributeFieldMapping) GetPriceField() enums.PricePlaceholderFieldEnum_PricePlaceholderField {
	if x, ok := x.GetField().(*AttributeFieldMapping_PriceField); ok {
		return x.PriceField
	}
	return enums.PricePlaceholderFieldEnum_UNSPECIFIED
}

func (x *AttributeFieldMapping) GetPromotionField() enums.PromotionPlaceholderFieldEnum_PromotionPlaceholderField {
	if x, ok := x.GetField().(*AttributeFieldMapping_PromotionField); ok {
		return x.PromotionField
	}
	return enums.PromotionPlaceholderFieldEnum_UNSPECIFIED
}

func (x *AttributeFieldMapping) GetAdCustomizerField() enums.AdCustomizerPlaceholderFieldEnum_AdCustomizerPlaceholderField {
	if x, ok := x.GetField().(*AttributeFieldMapping_AdCustomizerField); ok {
		return x.AdCustomizerField
	}
	return enums.AdCustomizerPlaceholderFieldEnum_UNSPECIFIED
}

func (x *AttributeFieldMapping) GetDsaPageFeedField() enums.DsaPageFeedCriterionFieldEnum_DsaPageFeedCriterionField {
	if x, ok := x.GetField().(*AttributeFieldMapping_DsaPageFeedField); ok {
		return x.DsaPageFeedField
	}
	return enums.DsaPageFeedCriterionFieldEnum_UNSPECIFIED
}

func (x *AttributeFieldMapping) GetLocationExtensionTargetingField() enums.LocationExtensionTargetingCriterionFieldEnum_LocationExtensionTargetingCriterionField {
	if x, ok := x.GetField().(*AttributeFieldMapping_LocationExtensionTargetingField); ok {
		return x.LocationExtensionTargetingField
	}
	return enums.LocationExtensionTargetingCriterionFieldEnum_UNSPECIFIED
}

func (x *AttributeFieldMapping) GetEducationField() enums.EducationPlaceholderFieldEnum_EducationPlaceholderField {
	if x, ok := x.GetField().(*AttributeFieldMapping_EducationField); ok {
		return x.EducationField
	}
	return enums.EducationPlaceholderFieldEnum_UNSPECIFIED
}

func (x *AttributeFieldMapping) GetFlightField() enums.FlightPlaceholderFieldEnum_FlightPlaceholderField {
	if x, ok := x.GetField().(*AttributeFieldMapping_FlightField); ok {
		return x.FlightField
	}
	return enums.FlightPlaceholderFieldEnum_UNSPECIFIED
}

func (x *AttributeFieldMapping) GetCustomField() enums.CustomPlaceholderFieldEnum_CustomPlaceholderField {
	if x, ok := x.GetField().(*AttributeFieldMapping_CustomField); ok {
		return x.CustomField
	}
	return enums.CustomPlaceholderFieldEnum_UNSPECIFIED
}

func (x *AttributeFieldMapping) GetHotelField() enums.HotelPlaceholderFieldEnum_HotelPlaceholderField {
	if x, ok := x.GetField().(*AttributeFieldMapping_HotelField); ok {
		return x.HotelField
	}
	return enums.HotelPlaceholderFieldEnum_UNSPECIFIED
}

func (x *AttributeFieldMapping) GetRealEstateField() enums.RealEstatePlaceholderFieldEnum_RealEstatePlaceholderField {
	if x, ok := x.GetField().(*AttributeFieldMapping_RealEstateField); ok {
		return x.RealEstateField
	}
	return enums.RealEstatePlaceholderFieldEnum_UNSPECIFIED
}

func (x *AttributeFieldMapping) GetTravelField() enums.TravelPlaceholderFieldEnum_TravelPlaceholderField {
	if x, ok := x.GetField().(*AttributeFieldMapping_TravelField); ok {
		return x.TravelField
	}
	return enums.TravelPlaceholderFieldEnum_UNSPECIFIED
}

func (x *AttributeFieldMapping) GetLocalField() enums.LocalPlaceholderFieldEnum_LocalPlaceholderField {
	if x, ok := x.GetField().(*AttributeFieldMapping_LocalField); ok {
		return x.LocalField
	}
	return enums.LocalPlaceholderFieldEnum_UNSPECIFIED
}

func (x *AttributeFieldMapping) GetJobField() enums.JobPlaceholderFieldEnum_JobPlaceholderField {
	if x, ok := x.GetField().(*AttributeFieldMapping_JobField); ok {
		return x.JobField
	}
	return enums.JobPlaceholderFieldEnum_UNSPECIFIED
}

type isAttributeFieldMapping_Field interface {
	isAttributeFieldMapping_Field()
}

type AttributeFieldMapping_SitelinkField struct {
	// Immutable. Sitelink Placeholder Fields.
	SitelinkField enums.SitelinkPlaceholderFieldEnum_SitelinkPlaceholderField `protobuf:"varint,3,opt,name=sitelink_field,json=sitelinkField,proto3,enum=google.ads.googleads.v2.enums.SitelinkPlaceholderFieldEnum_SitelinkPlaceholderField,oneof"`
}

type AttributeFieldMapping_CallField struct {
	// Immutable. Call Placeholder Fields.
	CallField enums.CallPlaceholderFieldEnum_CallPlaceholderField `protobuf:"varint,4,opt,name=call_field,json=callField,proto3,enum=google.ads.googleads.v2.enums.CallPlaceholderFieldEnum_CallPlaceholderField,oneof"`
}

type AttributeFieldMapping_AppField struct {
	// Immutable. App Placeholder Fields.
	AppField enums.AppPlaceholderFieldEnum_AppPlaceholderField `protobuf:"varint,5,opt,name=app_field,json=appField,proto3,enum=google.ads.googleads.v2.enums.AppPlaceholderFieldEnum_AppPlaceholderField,oneof"`
}

type AttributeFieldMapping_LocationField struct {
	// Output only. Location Placeholder Fields. This field is read-only.
	LocationField enums.LocationPlaceholderFieldEnum_LocationPlaceholderField `protobuf:"varint,6,opt,name=location_field,json=locationField,proto3,enum=google.ads.googleads.v2.enums.LocationPlaceholderFieldEnum_LocationPlaceholderField,oneof"`
}

type AttributeFieldMapping_AffiliateLocationField struct {
	// Output only. Affiliate Location Placeholder Fields. This field is read-only.
	AffiliateLocationField enums.AffiliateLocationPlaceholderFieldEnum_AffiliateLocationPlaceholderField `protobuf:"varint,7,opt,name=affiliate_location_field,json=affiliateLocationField,proto3,enum=google.ads.googleads.v2.enums.AffiliateLocationPlaceholderFieldEnum_AffiliateLocationPlaceholderField,oneof"`
}

type AttributeFieldMapping_CalloutField struct {
	// Immutable. Callout Placeholder Fields.
	CalloutField enums.CalloutPlaceholderFieldEnum_CalloutPlaceholderField `protobuf:"varint,8,opt,name=callout_field,json=calloutField,proto3,enum=google.ads.googleads.v2.enums.CalloutPlaceholderFieldEnum_CalloutPlaceholderField,oneof"`
}

type AttributeFieldMapping_StructuredSnippetField struct {
	// Immutable. Structured Snippet Placeholder Fields.
	StructuredSnippetField enums.StructuredSnippetPlaceholderFieldEnum_StructuredSnippetPlaceholderField `protobuf:"varint,9,opt,name=structured_snippet_field,json=structuredSnippetField,proto3,enum=google.ads.googleads.v2.enums.StructuredSnippetPlaceholderFieldEnum_StructuredSnippetPlaceholderField,oneof"`
}

type AttributeFieldMapping_MessageField struct {
	// Immutable. Message Placeholder Fields.
	MessageField enums.MessagePlaceholderFieldEnum_MessagePlaceholderField `protobuf:"varint,10,opt,name=message_field,json=messageField,proto3,enum=google.ads.googleads.v2.enums.MessagePlaceholderFieldEnum_MessagePlaceholderField,oneof"`
}

type AttributeFieldMapping_PriceField struct {
	// Immutable. Price Placeholder Fields.
	PriceField enums.PricePlaceholderFieldEnum_PricePlaceholderField `protobuf:"varint,11,opt,name=price_field,json=priceField,proto3,enum=google.ads.googleads.v2.enums.PricePlaceholderFieldEnum_PricePlaceholderField,oneof"`
}

type AttributeFieldMapping_PromotionField struct {
	// Immutable. Promotion Placeholder Fields.
	PromotionField enums.PromotionPlaceholderFieldEnum_PromotionPlaceholderField `protobuf:"varint,12,opt,name=promotion_field,json=promotionField,proto3,enum=google.ads.googleads.v2.enums.PromotionPlaceholderFieldEnum_PromotionPlaceholderField,oneof"`
}

type AttributeFieldMapping_AdCustomizerField struct {
	// Immutable. Ad Customizer Placeholder Fields
	AdCustomizerField enums.AdCustomizerPlaceholderFieldEnum_AdCustomizerPlaceholderField `protobuf:"varint,13,opt,name=ad_customizer_field,json=adCustomizerField,proto3,enum=google.ads.googleads.v2.enums.AdCustomizerPlaceholderFieldEnum_AdCustomizerPlaceholderField,oneof"`
}

type AttributeFieldMapping_DsaPageFeedField struct {
	// Immutable. Dynamic Search Ad Page Feed Fields.
	DsaPageFeedField enums.DsaPageFeedCriterionFieldEnum_DsaPageFeedCriterionField `protobuf:"varint,14,opt,name=dsa_page_feed_field,json=dsaPageFeedField,proto3,enum=google.ads.googleads.v2.enums.DsaPageFeedCriterionFieldEnum_DsaPageFeedCriterionField,oneof"`
}

type AttributeFieldMapping_LocationExtensionTargetingField struct {
	// Immutable. Location Target Fields.
	LocationExtensionTargetingField enums.LocationExtensionTargetingCriterionFieldEnum_LocationExtensionTargetingCriterionField `protobuf:"varint,15,opt,name=location_extension_targeting_field,json=locationExtensionTargetingField,proto3,enum=google.ads.googleads.v2.enums.LocationExtensionTargetingCriterionFieldEnum_LocationExtensionTargetingCriterionField,oneof"`
}

type AttributeFieldMapping_EducationField struct {
	// Immutable. Education Placeholder Fields
	EducationField enums.EducationPlaceholderFieldEnum_EducationPlaceholderField `protobuf:"varint,16,opt,name=education_field,json=educationField,proto3,enum=google.ads.googleads.v2.enums.EducationPlaceholderFieldEnum_EducationPlaceholderField,oneof"`
}

type AttributeFieldMapping_FlightField struct {
	// Immutable. Flight Placeholder Fields
	FlightField enums.FlightPlaceholderFieldEnum_FlightPlaceholderField `protobuf:"varint,17,opt,name=flight_field,json=flightField,proto3,enum=google.ads.googleads.v2.enums.FlightPlaceholderFieldEnum_FlightPlaceholderField,oneof"`
}

type AttributeFieldMapping_CustomField struct {
	// Immutable. Custom Placeholder Fields
	CustomField enums.CustomPlaceholderFieldEnum_CustomPlaceholderField `protobuf:"varint,18,opt,name=custom_field,json=customField,proto3,enum=google.ads.googleads.v2.enums.CustomPlaceholderFieldEnum_CustomPlaceholderField,oneof"`
}

type AttributeFieldMapping_HotelField struct {
	// Immutable. Hotel Placeholder Fields
	HotelField enums.HotelPlaceholderFieldEnum_HotelPlaceholderField `protobuf:"varint,19,opt,name=hotel_field,json=hotelField,proto3,enum=google.ads.googleads.v2.enums.HotelPlaceholderFieldEnum_HotelPlaceholderField,oneof"`
}

type AttributeFieldMapping_RealEstateField struct {
	// Immutable. Real Estate Placeholder Fields
	RealEstateField enums.RealEstatePlaceholderFieldEnum_RealEstatePlaceholderField `protobuf:"varint,20,opt,name=real_estate_field,json=realEstateField,proto3,enum=google.ads.googleads.v2.enums.RealEstatePlaceholderFieldEnum_RealEstatePlaceholderField,oneof"`
}

type AttributeFieldMapping_TravelField struct {
	// Immutable. Travel Placeholder Fields
	TravelField enums.TravelPlaceholderFieldEnum_TravelPlaceholderField `protobuf:"varint,21,opt,name=travel_field,json=travelField,proto3,enum=google.ads.googleads.v2.enums.TravelPlaceholderFieldEnum_TravelPlaceholderField,oneof"`
}

type AttributeFieldMapping_LocalField struct {
	// Immutable. Local Placeholder Fields
	LocalField enums.LocalPlaceholderFieldEnum_LocalPlaceholderField `protobuf:"varint,22,opt,name=local_field,json=localField,proto3,enum=google.ads.googleads.v2.enums.LocalPlaceholderFieldEnum_LocalPlaceholderField,oneof"`
}

type AttributeFieldMapping_JobField struct {
	// Immutable. Job Placeholder Fields
	JobField enums.JobPlaceholderFieldEnum_JobPlaceholderField `protobuf:"varint,23,opt,name=job_field,json=jobField,proto3,enum=google.ads.googleads.v2.enums.JobPlaceholderFieldEnum_JobPlaceholderField,oneof"`
}

func (*AttributeFieldMapping_SitelinkField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_CallField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_AppField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_LocationField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_AffiliateLocationField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_CalloutField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_StructuredSnippetField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_MessageField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_PriceField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_PromotionField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_AdCustomizerField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_DsaPageFeedField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_LocationExtensionTargetingField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_EducationField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_FlightField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_CustomField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_HotelField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_RealEstateField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_TravelField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_LocalField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_JobField) isAttributeFieldMapping_Field() {}

var File_google_ads_googleads_v2_resources_feed_mapping_proto protoreflect.FileDescriptor

var file_google_ads_googleads_v2_resources_feed_mapping_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2f, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f,
	0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x61, 0x64, 0x5f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x69, 0x7a, 0x65, 0x72, 0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x48,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x61, 0x66,
	0x66, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76,
	0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2f, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x63,
	0x61, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x41, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x64, 0x73, 0x61, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72,
	0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x65,
	0x64, 0x75, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f,
	0x66, 0x65, 0x65, 0x64, 0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x72, 0x69,
	0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73,
	0x2f, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x66, 0x6c, 0x69, 0x67, 0x68, 0x74,
	0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76,
	0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64,
	0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65,
	0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x6a, 0x6f, 0x62, 0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x50, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72,
	0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e,
	0x75, 0x6d, 0x73, 0x2f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73,
	0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d,
	0x73, 0x2f, 0x72, 0x65, 0x61, 0x6c, 0x5f, 0x65, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64,
	0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65,
	0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x73, 0x69, 0x74, 0x65, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x48, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64,
	0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65,
	0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f,
	0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x74,
	0x72, 0x61, 0x76, 0x65, 0x6c, 0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70,
	0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf9, 0x05, 0x0a, 0x0b, 0x46, 0x65, 0x65, 0x64,
	0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x51, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c,
	0xe0, 0x41, 0x05, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x46, 0x65, 0x65, 0x64, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x0c, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x57, 0x0a, 0x04, 0x66, 0x65,
	0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x25, 0xe0, 0x41, 0x05, 0xfa, 0x41, 0x1f, 0x0a, 0x1d,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x65, 0x64, 0x52, 0x04, 0x66,
	0x65, 0x65, 0x64, 0x12, 0x77, 0x0a, 0x18, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x73, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x05, 0x52, 0x16, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x63, 0x0a, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x46, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x46, 0x65, 0x65,
	0x64, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x6e,
	0x75, 0x6d, 0x2e, 0x46, 0x65, 0x65, 0x64, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x74, 0x0a, 0x10, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x63,
	0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e,
	0x50, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x0f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x82, 0x01, 0x0a, 0x0e, 0x63, 0x72, 0x69, 0x74,
	0x65, 0x72, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73,
	0x2e, 0x46, 0x65, 0x65, 0x64, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x43, 0x72, 0x69, 0x74,
	0x65, 0x72, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x46, 0x65,
	0x65, 0x64, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69,
	0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x0d, 0x63,
	0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x3a, 0x5b, 0xea, 0x41,
	0x58, 0x0a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x65, 0x64,
	0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x30, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x73, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x7d, 0x2f, 0x66, 0x65,
	0x65, 0x64, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x66, 0x65, 0x65, 0x64,
	0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x7d, 0x42, 0x08, 0x0a, 0x06, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x22, 0xc9, 0x17, 0x0a, 0x15, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x4c, 0x0a,
	0x11, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0f, 0x66, 0x65, 0x65, 0x64,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x49, 0x64, 0x12, 0x3b, 0x0a, 0x08, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x07, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x12, 0x82, 0x01, 0x0a, 0x0e, 0x73, 0x69, 0x74,
	0x65, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d,
	0x73, 0x2e, 0x53, 0x69, 0x74, 0x65, 0x6c, 0x69, 0x6e, 0x6b, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x53,
	0x69, 0x74, 0x65, 0x6c, 0x69, 0x6e, 0x6b, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x0d,
	0x73, 0x69, 0x74, 0x65, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x72, 0x0a,
	0x0a, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d,
	0x73, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x50,
	0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42,
	0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x09, 0x63, 0x61, 0x6c, 0x6c, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x12, 0x6e, 0x0a, 0x09, 0x61, 0x70, 0x70, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65,
	0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x41, 0x70, 0x70, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x41, 0x70, 0x70,
	0x50, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x08, 0x61, 0x70, 0x70, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x12, 0x82, 0x01, 0x0a, 0x0e, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0d, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0xa7, 0x01, 0x0a, 0x18, 0x61, 0x66, 0x66, 0x69, 0x6c,
	0x69, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x66, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x41, 0x66, 0x66, 0x69, 0x6c, 0x69,
	0x61, 0x74, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6c, 0x61, 0x63, 0x65,
	0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x45, 0x6e, 0x75, 0x6d, 0x2e,
	0x41, 0x66, 0x66, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x16, 0x61, 0x66, 0x66, 0x69, 0x6c, 0x69,
	0x61, 0x74, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x12, 0x7e, 0x0a, 0x0d, 0x63, 0x61, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x50,
	0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x45,
	0x6e, 0x75, 0x6d, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x50, 0x6c, 0x61, 0x63, 0x65,
	0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x05,
	0x48, 0x00, 0x52, 0x0c, 0x63, 0x61, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x12, 0xa7, 0x01, 0x0a, 0x18, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f,
	0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x66, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e,
	0x75, 0x6d, 0x73, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x53, 0x6e,
	0x69, 0x70, 0x70, 0x65, 0x74, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x75, 0x72, 0x65, 0x64, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x50, 0x6c, 0x61, 0x63, 0x65,
	0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x05,
	0x48, 0x00, 0x52, 0x16, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x53, 0x6e,
	0x69, 0x70, 0x70, 0x65, 0x74, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x7e, 0x0a, 0x0d, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d,
	0x73, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x0c, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x76, 0x0a, 0x0b, 0x70, 0x72,
	0x69, 0x63, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e,
	0x50, 0x72, 0x69, 0x63, 0x65, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x50,
	0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42,
	0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x63, 0x65, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x12, 0x86, 0x01, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x56, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x72, 0x6f,
	0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x50, 0x72, 0x6f, 0x6d, 0x6f,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x0e, 0x70, 0x72, 0x6f,
	0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x93, 0x01, 0x0a, 0x13,
	0x61, 0x64, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x69, 0x7a, 0x65, 0x72, 0x5f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x41, 0x64, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x69, 0x7a, 0x65, 0x72, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x41, 0x64, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x69, 0x7a, 0x65, 0x72, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x11,
	0x61, 0x64, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x69, 0x7a, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x12, 0x8c, 0x01, 0x0a, 0x13, 0x64, 0x73, 0x61, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x66,
	0x65, 0x65, 0x64, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e,
	0x44, 0x73, 0x61, 0x50, 0x61, 0x67, 0x65, 0x46, 0x65, 0x65, 0x64, 0x43, 0x72, 0x69, 0x74, 0x65,
	0x72, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x44, 0x73,
	0x61, 0x50, 0x61, 0x67, 0x65, 0x46, 0x65, 0x65, 0x64, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69,
	0x6f, 0x6e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x10,
	0x64, 0x73, 0x61, 0x50, 0x61, 0x67, 0x65, 0x46, 0x65, 0x65, 0x64, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x12, 0xc8, 0x01, 0x0a, 0x22, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x69, 0x6e,
	0x67, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x74, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f,
	0x6e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x1f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x86, 0x01, 0x0a, 0x0f,
	0x65, 0x64, 0x75, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18,
	0x10, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x45, 0x64, 0x75, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x45,
	0x6e, 0x75, 0x6d, 0x2e, 0x45, 0x64, 0x75, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6c, 0x61,
	0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0,
	0x41, 0x05, 0x48, 0x00, 0x52, 0x0e, 0x65, 0x64, 0x75, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x12, 0x7a, 0x0a, 0x0c, 0x66, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x5f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x46, 0x6c, 0x69, 0x67, 0x68,
	0x74, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x46, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x50, 0x6c, 0x61, 0x63,
	0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41,
	0x05, 0x48, 0x00, 0x52, 0x0b, 0x66, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x12, 0x7a, 0x0a, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x18, 0x12, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x6c, 0x61,
	0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x45, 0x6e, 0x75,
	0x6d, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52,
	0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x76, 0x0a, 0x0b,
	0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x13, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d,
	0x73, 0x2e, 0x48, 0x6f, 0x74, 0x65, 0x6c, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x48, 0x6f, 0x74, 0x65,
	0x6c, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x0a, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x12, 0x8b, 0x01, 0x0a, 0x11, 0x72, 0x65, 0x61, 0x6c, 0x5f, 0x65, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x58, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73,
	0x2e, 0x52, 0x65, 0x61, 0x6c, 0x45, 0x73, 0x74, 0x61, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x63, 0x65,
	0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x45, 0x6e, 0x75, 0x6d, 0x2e,
	0x52, 0x65, 0x61, 0x6c, 0x45, 0x73, 0x74, 0x61, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48,
	0x00, 0x52, 0x0f, 0x72, 0x65, 0x61, 0x6c, 0x45, 0x73, 0x74, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x12, 0x7a, 0x0a, 0x0c, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x5f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x50,
	0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x45,
	0x6e, 0x75, 0x6d, 0x2e, 0x54, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48,
	0x00, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x76,
	0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x16, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e,
	0x75, 0x6d, 0x73, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x4c, 0x6f,
	0x63, 0x61, 0x6c, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61,
	0x6c, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x6e, 0x0a, 0x09, 0x6a, 0x6f, 0x62, 0x5f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x4a, 0x6f, 0x62, 0x50, 0x6c, 0x61,
	0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x45, 0x6e, 0x75,
	0x6d, 0x2e, 0x4a, 0x6f, 0x62, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x08, 0x6a, 0x6f,
	0x62, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x07, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x42,
	0xfd, 0x01, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x42, 0x10, 0x46, 0x65, 0x65, 0x64, 0x4d,
	0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67,
	0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x3b,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0xa2, 0x02, 0x03, 0x47, 0x41, 0x41, 0xaa,
	0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x64, 0x73, 0x2e, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x2e, 0x56, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0xca, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x64, 0x73,
	0x5c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x5c, 0x56, 0x32, 0x5c, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0xea, 0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x3a, 0x3a, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73,
	0x3a, 0x3a, 0x56, 0x32, 0x3a, 0x3a, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ads_googleads_v2_resources_feed_mapping_proto_rawDescOnce sync.Once
	file_google_ads_googleads_v2_resources_feed_mapping_proto_rawDescData = file_google_ads_googleads_v2_resources_feed_mapping_proto_rawDesc
)

func file_google_ads_googleads_v2_resources_feed_mapping_proto_rawDescGZIP() []byte {
	file_google_ads_googleads_v2_resources_feed_mapping_proto_rawDescOnce.Do(func() {
		file_google_ads_googleads_v2_resources_feed_mapping_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_googleads_v2_resources_feed_mapping_proto_rawDescData)
	})
	return file_google_ads_googleads_v2_resources_feed_mapping_proto_rawDescData
}

var file_google_ads_googleads_v2_resources_feed_mapping_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_ads_googleads_v2_resources_feed_mapping_proto_goTypes = []interface{}{
	(*FeedMapping)(nil),                                                                              // 0: google.ads.googleads.v2.resources.FeedMapping
	(*AttributeFieldMapping)(nil),                                                                    // 1: google.ads.googleads.v2.resources.AttributeFieldMapping
	(*wrappers.StringValue)(nil),                                                                     // 2: google.protobuf.StringValue
	(enums.FeedMappingStatusEnum_FeedMappingStatus)(0),                                               // 3: google.ads.googleads.v2.enums.FeedMappingStatusEnum.FeedMappingStatus
	(enums.PlaceholderTypeEnum_PlaceholderType)(0),                                                   // 4: google.ads.googleads.v2.enums.PlaceholderTypeEnum.PlaceholderType
	(enums.FeedMappingCriterionTypeEnum_FeedMappingCriterionType)(0),                                 // 5: google.ads.googleads.v2.enums.FeedMappingCriterionTypeEnum.FeedMappingCriterionType
	(*wrappers.Int64Value)(nil),                                                                      // 6: google.protobuf.Int64Value
	(enums.SitelinkPlaceholderFieldEnum_SitelinkPlaceholderField)(0),                                 // 7: google.ads.googleads.v2.enums.SitelinkPlaceholderFieldEnum.SitelinkPlaceholderField
	(enums.CallPlaceholderFieldEnum_CallPlaceholderField)(0),                                         // 8: google.ads.googleads.v2.enums.CallPlaceholderFieldEnum.CallPlaceholderField
	(enums.AppPlaceholderFieldEnum_AppPlaceholderField)(0),                                           // 9: google.ads.googleads.v2.enums.AppPlaceholderFieldEnum.AppPlaceholderField
	(enums.LocationPlaceholderFieldEnum_LocationPlaceholderField)(0),                                 // 10: google.ads.googleads.v2.enums.LocationPlaceholderFieldEnum.LocationPlaceholderField
	(enums.AffiliateLocationPlaceholderFieldEnum_AffiliateLocationPlaceholderField)(0),               // 11: google.ads.googleads.v2.enums.AffiliateLocationPlaceholderFieldEnum.AffiliateLocationPlaceholderField
	(enums.CalloutPlaceholderFieldEnum_CalloutPlaceholderField)(0),                                   // 12: google.ads.googleads.v2.enums.CalloutPlaceholderFieldEnum.CalloutPlaceholderField
	(enums.StructuredSnippetPlaceholderFieldEnum_StructuredSnippetPlaceholderField)(0),               // 13: google.ads.googleads.v2.enums.StructuredSnippetPlaceholderFieldEnum.StructuredSnippetPlaceholderField
	(enums.MessagePlaceholderFieldEnum_MessagePlaceholderField)(0),                                   // 14: google.ads.googleads.v2.enums.MessagePlaceholderFieldEnum.MessagePlaceholderField
	(enums.PricePlaceholderFieldEnum_PricePlaceholderField)(0),                                       // 15: google.ads.googleads.v2.enums.PricePlaceholderFieldEnum.PricePlaceholderField
	(enums.PromotionPlaceholderFieldEnum_PromotionPlaceholderField)(0),                               // 16: google.ads.googleads.v2.enums.PromotionPlaceholderFieldEnum.PromotionPlaceholderField
	(enums.AdCustomizerPlaceholderFieldEnum_AdCustomizerPlaceholderField)(0),                         // 17: google.ads.googleads.v2.enums.AdCustomizerPlaceholderFieldEnum.AdCustomizerPlaceholderField
	(enums.DsaPageFeedCriterionFieldEnum_DsaPageFeedCriterionField)(0),                               // 18: google.ads.googleads.v2.enums.DsaPageFeedCriterionFieldEnum.DsaPageFeedCriterionField
	(enums.LocationExtensionTargetingCriterionFieldEnum_LocationExtensionTargetingCriterionField)(0), // 19: google.ads.googleads.v2.enums.LocationExtensionTargetingCriterionFieldEnum.LocationExtensionTargetingCriterionField
	(enums.EducationPlaceholderFieldEnum_EducationPlaceholderField)(0),                               // 20: google.ads.googleads.v2.enums.EducationPlaceholderFieldEnum.EducationPlaceholderField
	(enums.FlightPlaceholderFieldEnum_FlightPlaceholderField)(0),                                     // 21: google.ads.googleads.v2.enums.FlightPlaceholderFieldEnum.FlightPlaceholderField
	(enums.CustomPlaceholderFieldEnum_CustomPlaceholderField)(0),                                     // 22: google.ads.googleads.v2.enums.CustomPlaceholderFieldEnum.CustomPlaceholderField
	(enums.HotelPlaceholderFieldEnum_HotelPlaceholderField)(0),                                       // 23: google.ads.googleads.v2.enums.HotelPlaceholderFieldEnum.HotelPlaceholderField
	(enums.RealEstatePlaceholderFieldEnum_RealEstatePlaceholderField)(0),                             // 24: google.ads.googleads.v2.enums.RealEstatePlaceholderFieldEnum.RealEstatePlaceholderField
	(enums.TravelPlaceholderFieldEnum_TravelPlaceholderField)(0),                                     // 25: google.ads.googleads.v2.enums.TravelPlaceholderFieldEnum.TravelPlaceholderField
	(enums.LocalPlaceholderFieldEnum_LocalPlaceholderField)(0),                                       // 26: google.ads.googleads.v2.enums.LocalPlaceholderFieldEnum.LocalPlaceholderField
	(enums.JobPlaceholderFieldEnum_JobPlaceholderField)(0),                                           // 27: google.ads.googleads.v2.enums.JobPlaceholderFieldEnum.JobPlaceholderField
}
var file_google_ads_googleads_v2_resources_feed_mapping_proto_depIdxs = []int32{
	2,  // 0: google.ads.googleads.v2.resources.FeedMapping.feed:type_name -> google.protobuf.StringValue
	1,  // 1: google.ads.googleads.v2.resources.FeedMapping.attribute_field_mappings:type_name -> google.ads.googleads.v2.resources.AttributeFieldMapping
	3,  // 2: google.ads.googleads.v2.resources.FeedMapping.status:type_name -> google.ads.googleads.v2.enums.FeedMappingStatusEnum.FeedMappingStatus
	4,  // 3: google.ads.googleads.v2.resources.FeedMapping.placeholder_type:type_name -> google.ads.googleads.v2.enums.PlaceholderTypeEnum.PlaceholderType
	5,  // 4: google.ads.googleads.v2.resources.FeedMapping.criterion_type:type_name -> google.ads.googleads.v2.enums.FeedMappingCriterionTypeEnum.FeedMappingCriterionType
	6,  // 5: google.ads.googleads.v2.resources.AttributeFieldMapping.feed_attribute_id:type_name -> google.protobuf.Int64Value
	6,  // 6: google.ads.googleads.v2.resources.AttributeFieldMapping.field_id:type_name -> google.protobuf.Int64Value
	7,  // 7: google.ads.googleads.v2.resources.AttributeFieldMapping.sitelink_field:type_name -> google.ads.googleads.v2.enums.SitelinkPlaceholderFieldEnum.SitelinkPlaceholderField
	8,  // 8: google.ads.googleads.v2.resources.AttributeFieldMapping.call_field:type_name -> google.ads.googleads.v2.enums.CallPlaceholderFieldEnum.CallPlaceholderField
	9,  // 9: google.ads.googleads.v2.resources.AttributeFieldMapping.app_field:type_name -> google.ads.googleads.v2.enums.AppPlaceholderFieldEnum.AppPlaceholderField
	10, // 10: google.ads.googleads.v2.resources.AttributeFieldMapping.location_field:type_name -> google.ads.googleads.v2.enums.LocationPlaceholderFieldEnum.LocationPlaceholderField
	11, // 11: google.ads.googleads.v2.resources.AttributeFieldMapping.affiliate_location_field:type_name -> google.ads.googleads.v2.enums.AffiliateLocationPlaceholderFieldEnum.AffiliateLocationPlaceholderField
	12, // 12: google.ads.googleads.v2.resources.AttributeFieldMapping.callout_field:type_name -> google.ads.googleads.v2.enums.CalloutPlaceholderFieldEnum.CalloutPlaceholderField
	13, // 13: google.ads.googleads.v2.resources.AttributeFieldMapping.structured_snippet_field:type_name -> google.ads.googleads.v2.enums.StructuredSnippetPlaceholderFieldEnum.StructuredSnippetPlaceholderField
	14, // 14: google.ads.googleads.v2.resources.AttributeFieldMapping.message_field:type_name -> google.ads.googleads.v2.enums.MessagePlaceholderFieldEnum.MessagePlaceholderField
	15, // 15: google.ads.googleads.v2.resources.AttributeFieldMapping.price_field:type_name -> google.ads.googleads.v2.enums.PricePlaceholderFieldEnum.PricePlaceholderField
	16, // 16: google.ads.googleads.v2.resources.AttributeFieldMapping.promotion_field:type_name -> google.ads.googleads.v2.enums.PromotionPlaceholderFieldEnum.PromotionPlaceholderField
	17, // 17: google.ads.googleads.v2.resources.AttributeFieldMapping.ad_customizer_field:type_name -> google.ads.googleads.v2.enums.AdCustomizerPlaceholderFieldEnum.AdCustomizerPlaceholderField
	18, // 18: google.ads.googleads.v2.resources.AttributeFieldMapping.dsa_page_feed_field:type_name -> google.ads.googleads.v2.enums.DsaPageFeedCriterionFieldEnum.DsaPageFeedCriterionField
	19, // 19: google.ads.googleads.v2.resources.AttributeFieldMapping.location_extension_targeting_field:type_name -> google.ads.googleads.v2.enums.LocationExtensionTargetingCriterionFieldEnum.LocationExtensionTargetingCriterionField
	20, // 20: google.ads.googleads.v2.resources.AttributeFieldMapping.education_field:type_name -> google.ads.googleads.v2.enums.EducationPlaceholderFieldEnum.EducationPlaceholderField
	21, // 21: google.ads.googleads.v2.resources.AttributeFieldMapping.flight_field:type_name -> google.ads.googleads.v2.enums.FlightPlaceholderFieldEnum.FlightPlaceholderField
	22, // 22: google.ads.googleads.v2.resources.AttributeFieldMapping.custom_field:type_name -> google.ads.googleads.v2.enums.CustomPlaceholderFieldEnum.CustomPlaceholderField
	23, // 23: google.ads.googleads.v2.resources.AttributeFieldMapping.hotel_field:type_name -> google.ads.googleads.v2.enums.HotelPlaceholderFieldEnum.HotelPlaceholderField
	24, // 24: google.ads.googleads.v2.resources.AttributeFieldMapping.real_estate_field:type_name -> google.ads.googleads.v2.enums.RealEstatePlaceholderFieldEnum.RealEstatePlaceholderField
	25, // 25: google.ads.googleads.v2.resources.AttributeFieldMapping.travel_field:type_name -> google.ads.googleads.v2.enums.TravelPlaceholderFieldEnum.TravelPlaceholderField
	26, // 26: google.ads.googleads.v2.resources.AttributeFieldMapping.local_field:type_name -> google.ads.googleads.v2.enums.LocalPlaceholderFieldEnum.LocalPlaceholderField
	27, // 27: google.ads.googleads.v2.resources.AttributeFieldMapping.job_field:type_name -> google.ads.googleads.v2.enums.JobPlaceholderFieldEnum.JobPlaceholderField
	28, // [28:28] is the sub-list for method output_type
	28, // [28:28] is the sub-list for method input_type
	28, // [28:28] is the sub-list for extension type_name
	28, // [28:28] is the sub-list for extension extendee
	0,  // [0:28] is the sub-list for field type_name
}

func init() { file_google_ads_googleads_v2_resources_feed_mapping_proto_init() }
func file_google_ads_googleads_v2_resources_feed_mapping_proto_init() {
	if File_google_ads_googleads_v2_resources_feed_mapping_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_ads_googleads_v2_resources_feed_mapping_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FeedMapping); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v2_resources_feed_mapping_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttributeFieldMapping); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_ads_googleads_v2_resources_feed_mapping_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*FeedMapping_PlaceholderType)(nil),
		(*FeedMapping_CriterionType)(nil),
	}
	file_google_ads_googleads_v2_resources_feed_mapping_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*AttributeFieldMapping_SitelinkField)(nil),
		(*AttributeFieldMapping_CallField)(nil),
		(*AttributeFieldMapping_AppField)(nil),
		(*AttributeFieldMapping_LocationField)(nil),
		(*AttributeFieldMapping_AffiliateLocationField)(nil),
		(*AttributeFieldMapping_CalloutField)(nil),
		(*AttributeFieldMapping_StructuredSnippetField)(nil),
		(*AttributeFieldMapping_MessageField)(nil),
		(*AttributeFieldMapping_PriceField)(nil),
		(*AttributeFieldMapping_PromotionField)(nil),
		(*AttributeFieldMapping_AdCustomizerField)(nil),
		(*AttributeFieldMapping_DsaPageFeedField)(nil),
		(*AttributeFieldMapping_LocationExtensionTargetingField)(nil),
		(*AttributeFieldMapping_EducationField)(nil),
		(*AttributeFieldMapping_FlightField)(nil),
		(*AttributeFieldMapping_CustomField)(nil),
		(*AttributeFieldMapping_HotelField)(nil),
		(*AttributeFieldMapping_RealEstateField)(nil),
		(*AttributeFieldMapping_TravelField)(nil),
		(*AttributeFieldMapping_LocalField)(nil),
		(*AttributeFieldMapping_JobField)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_googleads_v2_resources_feed_mapping_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_ads_googleads_v2_resources_feed_mapping_proto_goTypes,
		DependencyIndexes: file_google_ads_googleads_v2_resources_feed_mapping_proto_depIdxs,
		MessageInfos:      file_google_ads_googleads_v2_resources_feed_mapping_proto_msgTypes,
	}.Build()
	File_google_ads_googleads_v2_resources_feed_mapping_proto = out.File
	file_google_ads_googleads_v2_resources_feed_mapping_proto_rawDesc = nil
	file_google_ads_googleads_v2_resources_feed_mapping_proto_goTypes = nil
	file_google_ads_googleads_v2_resources_feed_mapping_proto_depIdxs = nil
}
