// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.3
// source: google/ads/googleads/v1/common/simulation.proto

package common

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// A container for simulation points for simulations of type BID_MODIFIER.
type BidModifierSimulationPointList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Projected metrics for a series of bid modifier amounts.
	Points []*BidModifierSimulationPoint `protobuf:"bytes,1,rep,name=points,proto3" json:"points,omitempty"`
}

func (x *BidModifierSimulationPointList) Reset() {
	*x = BidModifierSimulationPointList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_common_simulation_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BidModifierSimulationPointList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BidModifierSimulationPointList) ProtoMessage() {}

func (x *BidModifierSimulationPointList) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_common_simulation_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BidModifierSimulationPointList.ProtoReflect.Descriptor instead.
func (*BidModifierSimulationPointList) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_common_simulation_proto_rawDescGZIP(), []int{0}
}

func (x *BidModifierSimulationPointList) GetPoints() []*BidModifierSimulationPoint {
	if x != nil {
		return x.Points
	}
	return nil
}

// A container for simulation points for simulations of type CPC_BID.
type CpcBidSimulationPointList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Projected metrics for a series of CPC bid amounts.
	Points []*CpcBidSimulationPoint `protobuf:"bytes,1,rep,name=points,proto3" json:"points,omitempty"`
}

func (x *CpcBidSimulationPointList) Reset() {
	*x = CpcBidSimulationPointList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_common_simulation_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CpcBidSimulationPointList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CpcBidSimulationPointList) ProtoMessage() {}

func (x *CpcBidSimulationPointList) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_common_simulation_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CpcBidSimulationPointList.ProtoReflect.Descriptor instead.
func (*CpcBidSimulationPointList) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_common_simulation_proto_rawDescGZIP(), []int{1}
}

func (x *CpcBidSimulationPointList) GetPoints() []*CpcBidSimulationPoint {
	if x != nil {
		return x.Points
	}
	return nil
}

// A container for simulation points for simulations of type CPV_BID.
type CpvBidSimulationPointList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Projected metrics for a series of CPV bid amounts.
	Points []*CpvBidSimulationPoint `protobuf:"bytes,1,rep,name=points,proto3" json:"points,omitempty"`
}

func (x *CpvBidSimulationPointList) Reset() {
	*x = CpvBidSimulationPointList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_common_simulation_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CpvBidSimulationPointList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CpvBidSimulationPointList) ProtoMessage() {}

func (x *CpvBidSimulationPointList) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_common_simulation_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CpvBidSimulationPointList.ProtoReflect.Descriptor instead.
func (*CpvBidSimulationPointList) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_common_simulation_proto_rawDescGZIP(), []int{2}
}

func (x *CpvBidSimulationPointList) GetPoints() []*CpvBidSimulationPoint {
	if x != nil {
		return x.Points
	}
	return nil
}

// A container for simulation points for simulations of type TARGET_CPA.
type TargetCpaSimulationPointList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Projected metrics for a series of target CPA amounts.
	Points []*TargetCpaSimulationPoint `protobuf:"bytes,1,rep,name=points,proto3" json:"points,omitempty"`
}

func (x *TargetCpaSimulationPointList) Reset() {
	*x = TargetCpaSimulationPointList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_common_simulation_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetCpaSimulationPointList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetCpaSimulationPointList) ProtoMessage() {}

func (x *TargetCpaSimulationPointList) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_common_simulation_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetCpaSimulationPointList.ProtoReflect.Descriptor instead.
func (*TargetCpaSimulationPointList) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_common_simulation_proto_rawDescGZIP(), []int{3}
}

func (x *TargetCpaSimulationPointList) GetPoints() []*TargetCpaSimulationPoint {
	if x != nil {
		return x.Points
	}
	return nil
}

// Projected metrics for a specific bid modifier amount.
type BidModifierSimulationPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The simulated bid modifier upon which projected metrics are based.
	BidModifier *wrappers.DoubleValue `protobuf:"bytes,1,opt,name=bid_modifier,json=bidModifier,proto3" json:"bid_modifier,omitempty"`
	// Projected number of biddable conversions.
	// Only search advertising channel type supports this field.
	BiddableConversions *wrappers.DoubleValue `protobuf:"bytes,2,opt,name=biddable_conversions,json=biddableConversions,proto3" json:"biddable_conversions,omitempty"`
	// Projected total value of biddable conversions.
	// Only search advertising channel type supports this field.
	BiddableConversionsValue *wrappers.DoubleValue `protobuf:"bytes,3,opt,name=biddable_conversions_value,json=biddableConversionsValue,proto3" json:"biddable_conversions_value,omitempty"`
	// Projected number of clicks.
	Clicks *wrappers.Int64Value `protobuf:"bytes,4,opt,name=clicks,proto3" json:"clicks,omitempty"`
	// Projected cost in micros.
	CostMicros *wrappers.Int64Value `protobuf:"bytes,5,opt,name=cost_micros,json=costMicros,proto3" json:"cost_micros,omitempty"`
	// Projected number of impressions.
	Impressions *wrappers.Int64Value `protobuf:"bytes,6,opt,name=impressions,proto3" json:"impressions,omitempty"`
	// Projected number of top slot impressions.
	// Only search advertising channel type supports this field.
	TopSlotImpressions *wrappers.Int64Value `protobuf:"bytes,7,opt,name=top_slot_impressions,json=topSlotImpressions,proto3" json:"top_slot_impressions,omitempty"`
	// Projected number of biddable conversions for the parent resource.
	// Only search advertising channel type supports this field.
	ParentBiddableConversions *wrappers.DoubleValue `protobuf:"bytes,8,opt,name=parent_biddable_conversions,json=parentBiddableConversions,proto3" json:"parent_biddable_conversions,omitempty"`
	// Projected total value of biddable conversions for the parent resource.
	// Only search advertising channel type supports this field.
	ParentBiddableConversionsValue *wrappers.DoubleValue `protobuf:"bytes,9,opt,name=parent_biddable_conversions_value,json=parentBiddableConversionsValue,proto3" json:"parent_biddable_conversions_value,omitempty"`
	// Projected number of clicks for the parent resource.
	ParentClicks *wrappers.Int64Value `protobuf:"bytes,10,opt,name=parent_clicks,json=parentClicks,proto3" json:"parent_clicks,omitempty"`
	// Projected cost in micros for the parent resource.
	ParentCostMicros *wrappers.Int64Value `protobuf:"bytes,11,opt,name=parent_cost_micros,json=parentCostMicros,proto3" json:"parent_cost_micros,omitempty"`
	// Projected number of impressions for the parent resource.
	ParentImpressions *wrappers.Int64Value `protobuf:"bytes,12,opt,name=parent_impressions,json=parentImpressions,proto3" json:"parent_impressions,omitempty"`
	// Projected number of top slot impressions for the parent resource.
	// Only search advertising channel type supports this field.
	ParentTopSlotImpressions *wrappers.Int64Value `protobuf:"bytes,13,opt,name=parent_top_slot_impressions,json=parentTopSlotImpressions,proto3" json:"parent_top_slot_impressions,omitempty"`
}

func (x *BidModifierSimulationPoint) Reset() {
	*x = BidModifierSimulationPoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_common_simulation_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BidModifierSimulationPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BidModifierSimulationPoint) ProtoMessage() {}

func (x *BidModifierSimulationPoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_common_simulation_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BidModifierSimulationPoint.ProtoReflect.Descriptor instead.
func (*BidModifierSimulationPoint) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_common_simulation_proto_rawDescGZIP(), []int{4}
}

func (x *BidModifierSimulationPoint) GetBidModifier() *wrappers.DoubleValue {
	if x != nil {
		return x.BidModifier
	}
	return nil
}

func (x *BidModifierSimulationPoint) GetBiddableConversions() *wrappers.DoubleValue {
	if x != nil {
		return x.BiddableConversions
	}
	return nil
}

func (x *BidModifierSimulationPoint) GetBiddableConversionsValue() *wrappers.DoubleValue {
	if x != nil {
		return x.BiddableConversionsValue
	}
	return nil
}

func (x *BidModifierSimulationPoint) GetClicks() *wrappers.Int64Value {
	if x != nil {
		return x.Clicks
	}
	return nil
}

func (x *BidModifierSimulationPoint) GetCostMicros() *wrappers.Int64Value {
	if x != nil {
		return x.CostMicros
	}
	return nil
}

func (x *BidModifierSimulationPoint) GetImpressions() *wrappers.Int64Value {
	if x != nil {
		return x.Impressions
	}
	return nil
}

func (x *BidModifierSimulationPoint) GetTopSlotImpressions() *wrappers.Int64Value {
	if x != nil {
		return x.TopSlotImpressions
	}
	return nil
}

func (x *BidModifierSimulationPoint) GetParentBiddableConversions() *wrappers.DoubleValue {
	if x != nil {
		return x.ParentBiddableConversions
	}
	return nil
}

func (x *BidModifierSimulationPoint) GetParentBiddableConversionsValue() *wrappers.DoubleValue {
	if x != nil {
		return x.ParentBiddableConversionsValue
	}
	return nil
}

func (x *BidModifierSimulationPoint) GetParentClicks() *wrappers.Int64Value {
	if x != nil {
		return x.ParentClicks
	}
	return nil
}

func (x *BidModifierSimulationPoint) GetParentCostMicros() *wrappers.Int64Value {
	if x != nil {
		return x.ParentCostMicros
	}
	return nil
}

func (x *BidModifierSimulationPoint) GetParentImpressions() *wrappers.Int64Value {
	if x != nil {
		return x.ParentImpressions
	}
	return nil
}

func (x *BidModifierSimulationPoint) GetParentTopSlotImpressions() *wrappers.Int64Value {
	if x != nil {
		return x.ParentTopSlotImpressions
	}
	return nil
}

// Projected metrics for a specific CPC bid amount.
type CpcBidSimulationPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The simulated CPC bid upon which projected metrics are based.
	CpcBidMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=cpc_bid_micros,json=cpcBidMicros,proto3" json:"cpc_bid_micros,omitempty"`
	// Projected number of biddable conversions.
	BiddableConversions *wrappers.DoubleValue `protobuf:"bytes,2,opt,name=biddable_conversions,json=biddableConversions,proto3" json:"biddable_conversions,omitempty"`
	// Projected total value of biddable conversions.
	BiddableConversionsValue *wrappers.DoubleValue `protobuf:"bytes,3,opt,name=biddable_conversions_value,json=biddableConversionsValue,proto3" json:"biddable_conversions_value,omitempty"`
	// Projected number of clicks.
	Clicks *wrappers.Int64Value `protobuf:"bytes,4,opt,name=clicks,proto3" json:"clicks,omitempty"`
	// Projected cost in micros.
	CostMicros *wrappers.Int64Value `protobuf:"bytes,5,opt,name=cost_micros,json=costMicros,proto3" json:"cost_micros,omitempty"`
	// Projected number of impressions.
	Impressions *wrappers.Int64Value `protobuf:"bytes,6,opt,name=impressions,proto3" json:"impressions,omitempty"`
	// Projected number of top slot impressions.
	// Only search advertising channel type supports this field.
	TopSlotImpressions *wrappers.Int64Value `protobuf:"bytes,7,opt,name=top_slot_impressions,json=topSlotImpressions,proto3" json:"top_slot_impressions,omitempty"`
}

func (x *CpcBidSimulationPoint) Reset() {
	*x = CpcBidSimulationPoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_common_simulation_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CpcBidSimulationPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CpcBidSimulationPoint) ProtoMessage() {}

func (x *CpcBidSimulationPoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_common_simulation_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CpcBidSimulationPoint.ProtoReflect.Descriptor instead.
func (*CpcBidSimulationPoint) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_common_simulation_proto_rawDescGZIP(), []int{5}
}

func (x *CpcBidSimulationPoint) GetCpcBidMicros() *wrappers.Int64Value {
	if x != nil {
		return x.CpcBidMicros
	}
	return nil
}

func (x *CpcBidSimulationPoint) GetBiddableConversions() *wrappers.DoubleValue {
	if x != nil {
		return x.BiddableConversions
	}
	return nil
}

func (x *CpcBidSimulationPoint) GetBiddableConversionsValue() *wrappers.DoubleValue {
	if x != nil {
		return x.BiddableConversionsValue
	}
	return nil
}

func (x *CpcBidSimulationPoint) GetClicks() *wrappers.Int64Value {
	if x != nil {
		return x.Clicks
	}
	return nil
}

func (x *CpcBidSimulationPoint) GetCostMicros() *wrappers.Int64Value {
	if x != nil {
		return x.CostMicros
	}
	return nil
}

func (x *CpcBidSimulationPoint) GetImpressions() *wrappers.Int64Value {
	if x != nil {
		return x.Impressions
	}
	return nil
}

func (x *CpcBidSimulationPoint) GetTopSlotImpressions() *wrappers.Int64Value {
	if x != nil {
		return x.TopSlotImpressions
	}
	return nil
}

// Projected metrics for a specific CPV bid amount.
type CpvBidSimulationPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The simulated CPV bid upon which projected metrics are based.
	CpvBidMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=cpv_bid_micros,json=cpvBidMicros,proto3" json:"cpv_bid_micros,omitempty"`
	// Projected cost in micros.
	CostMicros *wrappers.Int64Value `protobuf:"bytes,2,opt,name=cost_micros,json=costMicros,proto3" json:"cost_micros,omitempty"`
	// Projected number of impressions.
	Impressions *wrappers.Int64Value `protobuf:"bytes,3,opt,name=impressions,proto3" json:"impressions,omitempty"`
}

func (x *CpvBidSimulationPoint) Reset() {
	*x = CpvBidSimulationPoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_common_simulation_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CpvBidSimulationPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CpvBidSimulationPoint) ProtoMessage() {}

func (x *CpvBidSimulationPoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_common_simulation_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CpvBidSimulationPoint.ProtoReflect.Descriptor instead.
func (*CpvBidSimulationPoint) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_common_simulation_proto_rawDescGZIP(), []int{6}
}

func (x *CpvBidSimulationPoint) GetCpvBidMicros() *wrappers.Int64Value {
	if x != nil {
		return x.CpvBidMicros
	}
	return nil
}

func (x *CpvBidSimulationPoint) GetCostMicros() *wrappers.Int64Value {
	if x != nil {
		return x.CostMicros
	}
	return nil
}

func (x *CpvBidSimulationPoint) GetImpressions() *wrappers.Int64Value {
	if x != nil {
		return x.Impressions
	}
	return nil
}

// Projected metrics for a specific target CPA amount.
type TargetCpaSimulationPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The simulated target CPA upon which projected metrics are based.
	TargetCpaMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=target_cpa_micros,json=targetCpaMicros,proto3" json:"target_cpa_micros,omitempty"`
	// Projected number of biddable conversions.
	BiddableConversions *wrappers.DoubleValue `protobuf:"bytes,2,opt,name=biddable_conversions,json=biddableConversions,proto3" json:"biddable_conversions,omitempty"`
	// Projected total value of biddable conversions.
	BiddableConversionsValue *wrappers.DoubleValue `protobuf:"bytes,3,opt,name=biddable_conversions_value,json=biddableConversionsValue,proto3" json:"biddable_conversions_value,omitempty"`
	// Projected number of clicks.
	Clicks *wrappers.Int64Value `protobuf:"bytes,4,opt,name=clicks,proto3" json:"clicks,omitempty"`
	// Projected cost in micros.
	CostMicros *wrappers.Int64Value `protobuf:"bytes,5,opt,name=cost_micros,json=costMicros,proto3" json:"cost_micros,omitempty"`
	// Projected number of impressions.
	Impressions *wrappers.Int64Value `protobuf:"bytes,6,opt,name=impressions,proto3" json:"impressions,omitempty"`
	// Projected number of top slot impressions.
	// Only search advertising channel type supports this field.
	TopSlotImpressions *wrappers.Int64Value `protobuf:"bytes,7,opt,name=top_slot_impressions,json=topSlotImpressions,proto3" json:"top_slot_impressions,omitempty"`
}

func (x *TargetCpaSimulationPoint) Reset() {
	*x = TargetCpaSimulationPoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_common_simulation_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetCpaSimulationPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetCpaSimulationPoint) ProtoMessage() {}

func (x *TargetCpaSimulationPoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_common_simulation_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetCpaSimulationPoint.ProtoReflect.Descriptor instead.
func (*TargetCpaSimulationPoint) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_common_simulation_proto_rawDescGZIP(), []int{7}
}

func (x *TargetCpaSimulationPoint) GetTargetCpaMicros() *wrappers.Int64Value {
	if x != nil {
		return x.TargetCpaMicros
	}
	return nil
}

func (x *TargetCpaSimulationPoint) GetBiddableConversions() *wrappers.DoubleValue {
	if x != nil {
		return x.BiddableConversions
	}
	return nil
}

func (x *TargetCpaSimulationPoint) GetBiddableConversionsValue() *wrappers.DoubleValue {
	if x != nil {
		return x.BiddableConversionsValue
	}
	return nil
}

func (x *TargetCpaSimulationPoint) GetClicks() *wrappers.Int64Value {
	if x != nil {
		return x.Clicks
	}
	return nil
}

func (x *TargetCpaSimulationPoint) GetCostMicros() *wrappers.Int64Value {
	if x != nil {
		return x.CostMicros
	}
	return nil
}

func (x *TargetCpaSimulationPoint) GetImpressions() *wrappers.Int64Value {
	if x != nil {
		return x.Impressions
	}
	return nil
}

func (x *TargetCpaSimulationPoint) GetTopSlotImpressions() *wrappers.Int64Value {
	if x != nil {
		return x.TopSlotImpressions
	}
	return nil
}

var File_google_ads_googleads_v1_common_simulation_proto protoreflect.FileDescriptor

var file_google_ads_googleads_v1_common_simulation_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2f, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0x74, 0x0a, 0x1e, 0x42, 0x69, 0x64, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x53, 0x69,
	0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x4c, 0x69, 0x73,
	0x74, 0x12, 0x52, 0x0a, 0x06, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x2e, 0x42, 0x69, 0x64, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x53, 0x69,
	0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x06, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x73, 0x22, 0x6a, 0x0a, 0x19, 0x43, 0x70, 0x63, 0x42, 0x69, 0x64, 0x53,
	0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x4c, 0x69,
	0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x70, 0x63, 0x42, 0x69, 0x64, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x73, 0x22, 0x6a, 0x0a, 0x19, 0x43, 0x70, 0x76, 0x42, 0x69, 0x64, 0x53, 0x69, 0x6d, 0x75, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x4d,
	0x0a, 0x06, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x43, 0x70, 0x76, 0x42, 0x69, 0x64, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x22, 0x70, 0x0a,
	0x1c, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x70, 0x61, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x50, 0x0a,
	0x06, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x70, 0x61, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x22,
	0x87, 0x08, 0x0a, 0x1a, 0x42, 0x69, 0x64, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x53,
	0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x3f,
	0x0a, 0x0c, 0x62, 0x69, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0b, 0x62, 0x69, 0x64, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12,
	0x4f, 0x0a, 0x14, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x62, 0x69, 0x64,
	0x64, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x5a, 0x0a, 0x1a, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x18, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x33, 0x0a, 0x06,
	0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49,
	0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x63, 0x6c, 0x69, 0x63, 0x6b,
	0x73, 0x12, 0x3c, 0x0a, 0x0b, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x0a, 0x63, 0x6f, 0x73, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12,
	0x3d, 0x0a, 0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4d,
	0x0a, 0x14, 0x74, 0x6f, 0x70, 0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49,
	0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x12, 0x74, 0x6f, 0x70, 0x53, 0x6c,
	0x6f, 0x74, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5c, 0x0a,
	0x1b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x19, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x42, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x67, 0x0a, 0x21, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x1e, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x42, 0x69, 0x64, 0x64,
	0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x40, 0x0a, 0x0d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x63,
	0x6c, 0x69, 0x63, 0x6b, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e,
	0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x43, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x12, 0x49, 0x0a, 0x12, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x5f, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x10, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x73, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f,
	0x73, 0x12, 0x4a, 0x0a, 0x12, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x11, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5a, 0x0a,
	0x1b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x73, 0x6c, 0x6f, 0x74,
	0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x18, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x70, 0x53, 0x6c, 0x6f, 0x74, 0x49, 0x6d,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x88, 0x04, 0x0a, 0x15, 0x43, 0x70,
	0x63, 0x42, 0x69, 0x64, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f,
	0x69, 0x6e, 0x74, 0x12, 0x41, 0x0a, 0x0e, 0x63, 0x70, 0x63, 0x5f, 0x62, 0x69, 0x64, 0x5f, 0x6d,
	0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e,
	0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x63, 0x70, 0x63, 0x42, 0x69, 0x64,
	0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x4f, 0x0a, 0x14, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x13, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5a, 0x0a, 0x1a, 0x62, 0x69, 0x64, 0x64, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f,
	0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x18, 0x62, 0x69, 0x64, 0x64, 0x61,
	0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x33, 0x0a, 0x06, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x06, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x12, 0x3c, 0x0a, 0x0b, 0x63, 0x6f, 0x73, 0x74,
	0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x63, 0x6f, 0x73, 0x74,
	0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x3d, 0x0a, 0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e,
	0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4d, 0x0a, 0x14, 0x74, 0x6f, 0x70, 0x5f, 0x73, 0x6c, 0x6f,
	0x74, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x12, 0x74, 0x6f, 0x70, 0x53, 0x6c, 0x6f, 0x74, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x22, 0xd7, 0x01, 0x0a, 0x15, 0x43, 0x70, 0x76, 0x42, 0x69, 0x64, 0x53,
	0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x41,
	0x0a, 0x0e, 0x63, 0x70, 0x76, 0x5f, 0x62, 0x69, 0x64, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x0c, 0x63, 0x70, 0x76, 0x42, 0x69, 0x64, 0x4d, 0x69, 0x63, 0x72, 0x6f,
	0x73, 0x12, 0x3c, 0x0a, 0x0b, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x0a, 0x63, 0x6f, 0x73, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12,
	0x3d, 0x0a, 0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x91,
	0x04, 0x0a, 0x18, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x70, 0x61, 0x53, 0x69, 0x6d, 0x75,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x47, 0x0a, 0x11, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x70, 0x61, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x0f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x70, 0x61, 0x4d, 0x69,
	0x63, 0x72, 0x6f, 0x73, 0x12, 0x4f, 0x0a, 0x14, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x13, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5a, 0x0a, 0x1a, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62,
	0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x18, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c,
	0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x33, 0x0a, 0x06, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06,
	0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x12, 0x3c, 0x0a, 0x0b, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6d,
	0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e,
	0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x63, 0x6f, 0x73, 0x74, 0x4d, 0x69,
	0x63, 0x72, 0x6f, 0x73, 0x12, 0x3d, 0x0a, 0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x4d, 0x0a, 0x14, 0x74, 0x6f, 0x70, 0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x5f,
	0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x12,
	0x74, 0x6f, 0x70, 0x53, 0x6c, 0x6f, 0x74, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x42, 0xea, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x42, 0x0f, 0x53, 0x69, 0x6d, 0x75, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x44, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f,
	0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x3b, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0xa2, 0x02, 0x03, 0x47, 0x41, 0x41, 0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x41, 0x64, 0x73, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x2e,
	0x56, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x41, 0x64, 0x73, 0x5c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73,
	0x5c, 0x56, 0x31, 0x5c, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x41, 0x64, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x3a, 0x3a, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ads_googleads_v1_common_simulation_proto_rawDescOnce sync.Once
	file_google_ads_googleads_v1_common_simulation_proto_rawDescData = file_google_ads_googleads_v1_common_simulation_proto_rawDesc
)

func file_google_ads_googleads_v1_common_simulation_proto_rawDescGZIP() []byte {
	file_google_ads_googleads_v1_common_simulation_proto_rawDescOnce.Do(func() {
		file_google_ads_googleads_v1_common_simulation_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_googleads_v1_common_simulation_proto_rawDescData)
	})
	return file_google_ads_googleads_v1_common_simulation_proto_rawDescData
}

var file_google_ads_googleads_v1_common_simulation_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_ads_googleads_v1_common_simulation_proto_goTypes = []interface{}{
	(*BidModifierSimulationPointList)(nil), // 0: google.ads.googleads.v1.common.BidModifierSimulationPointList
	(*CpcBidSimulationPointList)(nil),      // 1: google.ads.googleads.v1.common.CpcBidSimulationPointList
	(*CpvBidSimulationPointList)(nil),      // 2: google.ads.googleads.v1.common.CpvBidSimulationPointList
	(*TargetCpaSimulationPointList)(nil),   // 3: google.ads.googleads.v1.common.TargetCpaSimulationPointList
	(*BidModifierSimulationPoint)(nil),     // 4: google.ads.googleads.v1.common.BidModifierSimulationPoint
	(*CpcBidSimulationPoint)(nil),          // 5: google.ads.googleads.v1.common.CpcBidSimulationPoint
	(*CpvBidSimulationPoint)(nil),          // 6: google.ads.googleads.v1.common.CpvBidSimulationPoint
	(*TargetCpaSimulationPoint)(nil),       // 7: google.ads.googleads.v1.common.TargetCpaSimulationPoint
	(*wrappers.DoubleValue)(nil),           // 8: google.protobuf.DoubleValue
	(*wrappers.Int64Value)(nil),            // 9: google.protobuf.Int64Value
}
var file_google_ads_googleads_v1_common_simulation_proto_depIdxs = []int32{
	4,  // 0: google.ads.googleads.v1.common.BidModifierSimulationPointList.points:type_name -> google.ads.googleads.v1.common.BidModifierSimulationPoint
	5,  // 1: google.ads.googleads.v1.common.CpcBidSimulationPointList.points:type_name -> google.ads.googleads.v1.common.CpcBidSimulationPoint
	6,  // 2: google.ads.googleads.v1.common.CpvBidSimulationPointList.points:type_name -> google.ads.googleads.v1.common.CpvBidSimulationPoint
	7,  // 3: google.ads.googleads.v1.common.TargetCpaSimulationPointList.points:type_name -> google.ads.googleads.v1.common.TargetCpaSimulationPoint
	8,  // 4: google.ads.googleads.v1.common.BidModifierSimulationPoint.bid_modifier:type_name -> google.protobuf.DoubleValue
	8,  // 5: google.ads.googleads.v1.common.BidModifierSimulationPoint.biddable_conversions:type_name -> google.protobuf.DoubleValue
	8,  // 6: google.ads.googleads.v1.common.BidModifierSimulationPoint.biddable_conversions_value:type_name -> google.protobuf.DoubleValue
	9,  // 7: google.ads.googleads.v1.common.BidModifierSimulationPoint.clicks:type_name -> google.protobuf.Int64Value
	9,  // 8: google.ads.googleads.v1.common.BidModifierSimulationPoint.cost_micros:type_name -> google.protobuf.Int64Value
	9,  // 9: google.ads.googleads.v1.common.BidModifierSimulationPoint.impressions:type_name -> google.protobuf.Int64Value
	9,  // 10: google.ads.googleads.v1.common.BidModifierSimulationPoint.top_slot_impressions:type_name -> google.protobuf.Int64Value
	8,  // 11: google.ads.googleads.v1.common.BidModifierSimulationPoint.parent_biddable_conversions:type_name -> google.protobuf.DoubleValue
	8,  // 12: google.ads.googleads.v1.common.BidModifierSimulationPoint.parent_biddable_conversions_value:type_name -> google.protobuf.DoubleValue
	9,  // 13: google.ads.googleads.v1.common.BidModifierSimulationPoint.parent_clicks:type_name -> google.protobuf.Int64Value
	9,  // 14: google.ads.googleads.v1.common.BidModifierSimulationPoint.parent_cost_micros:type_name -> google.protobuf.Int64Value
	9,  // 15: google.ads.googleads.v1.common.BidModifierSimulationPoint.parent_impressions:type_name -> google.protobuf.Int64Value
	9,  // 16: google.ads.googleads.v1.common.BidModifierSimulationPoint.parent_top_slot_impressions:type_name -> google.protobuf.Int64Value
	9,  // 17: google.ads.googleads.v1.common.CpcBidSimulationPoint.cpc_bid_micros:type_name -> google.protobuf.Int64Value
	8,  // 18: google.ads.googleads.v1.common.CpcBidSimulationPoint.biddable_conversions:type_name -> google.protobuf.DoubleValue
	8,  // 19: google.ads.googleads.v1.common.CpcBidSimulationPoint.biddable_conversions_value:type_name -> google.protobuf.DoubleValue
	9,  // 20: google.ads.googleads.v1.common.CpcBidSimulationPoint.clicks:type_name -> google.protobuf.Int64Value
	9,  // 21: google.ads.googleads.v1.common.CpcBidSimulationPoint.cost_micros:type_name -> google.protobuf.Int64Value
	9,  // 22: google.ads.googleads.v1.common.CpcBidSimulationPoint.impressions:type_name -> google.protobuf.Int64Value
	9,  // 23: google.ads.googleads.v1.common.CpcBidSimulationPoint.top_slot_impressions:type_name -> google.protobuf.Int64Value
	9,  // 24: google.ads.googleads.v1.common.CpvBidSimulationPoint.cpv_bid_micros:type_name -> google.protobuf.Int64Value
	9,  // 25: google.ads.googleads.v1.common.CpvBidSimulationPoint.cost_micros:type_name -> google.protobuf.Int64Value
	9,  // 26: google.ads.googleads.v1.common.CpvBidSimulationPoint.impressions:type_name -> google.protobuf.Int64Value
	9,  // 27: google.ads.googleads.v1.common.TargetCpaSimulationPoint.target_cpa_micros:type_name -> google.protobuf.Int64Value
	8,  // 28: google.ads.googleads.v1.common.TargetCpaSimulationPoint.biddable_conversions:type_name -> google.protobuf.DoubleValue
	8,  // 29: google.ads.googleads.v1.common.TargetCpaSimulationPoint.biddable_conversions_value:type_name -> google.protobuf.DoubleValue
	9,  // 30: google.ads.googleads.v1.common.TargetCpaSimulationPoint.clicks:type_name -> google.protobuf.Int64Value
	9,  // 31: google.ads.googleads.v1.common.TargetCpaSimulationPoint.cost_micros:type_name -> google.protobuf.Int64Value
	9,  // 32: google.ads.googleads.v1.common.TargetCpaSimulationPoint.impressions:type_name -> google.protobuf.Int64Value
	9,  // 33: google.ads.googleads.v1.common.TargetCpaSimulationPoint.top_slot_impressions:type_name -> google.protobuf.Int64Value
	34, // [34:34] is the sub-list for method output_type
	34, // [34:34] is the sub-list for method input_type
	34, // [34:34] is the sub-list for extension type_name
	34, // [34:34] is the sub-list for extension extendee
	0,  // [0:34] is the sub-list for field type_name
}

func init() { file_google_ads_googleads_v1_common_simulation_proto_init() }
func file_google_ads_googleads_v1_common_simulation_proto_init() {
	if File_google_ads_googleads_v1_common_simulation_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_ads_googleads_v1_common_simulation_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BidModifierSimulationPointList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_common_simulation_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CpcBidSimulationPointList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_common_simulation_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CpvBidSimulationPointList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_common_simulation_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TargetCpaSimulationPointList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_common_simulation_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BidModifierSimulationPoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_common_simulation_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CpcBidSimulationPoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_common_simulation_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CpvBidSimulationPoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_common_simulation_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TargetCpaSimulationPoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_googleads_v1_common_simulation_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_ads_googleads_v1_common_simulation_proto_goTypes,
		DependencyIndexes: file_google_ads_googleads_v1_common_simulation_proto_depIdxs,
		MessageInfos:      file_google_ads_googleads_v1_common_simulation_proto_msgTypes,
	}.Build()
	File_google_ads_googleads_v1_common_simulation_proto = out.File
	file_google_ads_googleads_v1_common_simulation_proto_rawDesc = nil
	file_google_ads_googleads_v1_common_simulation_proto_goTypes = nil
	file_google_ads_googleads_v1_common_simulation_proto_depIdxs = nil
}
