// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/cloud/aiplatform/v1beta1/model.proto

package aiplatform

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Identifies a type of Model's prediction resources.
type Model_DeploymentResourcesType int32

const (
	// Should not be used.
	Model_DEPLOYMENT_RESOURCES_TYPE_UNSPECIFIED Model_DeploymentResourcesType = 0
	// Resources that are dedicated to the [DeployedModel][google.cloud.aiplatform.v1beta1.DeployedModel], and that need a
	// higher degree of manual configuration.
	Model_DEDICATED_RESOURCES Model_DeploymentResourcesType = 1
	// Resources that to large degree are decided by AI Platform, and require
	// only a modest additional configuration.
	Model_AUTOMATIC_RESOURCES Model_DeploymentResourcesType = 2
)

// Enum value maps for Model_DeploymentResourcesType.
var (
	Model_DeploymentResourcesType_name = map[int32]string{
		0: "DEPLOYMENT_RESOURCES_TYPE_UNSPECIFIED",
		1: "DEDICATED_RESOURCES",
		2: "AUTOMATIC_RESOURCES",
	}
	Model_DeploymentResourcesType_value = map[string]int32{
		"DEPLOYMENT_RESOURCES_TYPE_UNSPECIFIED": 0,
		"DEDICATED_RESOURCES":                   1,
		"AUTOMATIC_RESOURCES":                   2,
	}
)

func (x Model_DeploymentResourcesType) Enum() *Model_DeploymentResourcesType {
	p := new(Model_DeploymentResourcesType)
	*p = x
	return p
}

func (x Model_DeploymentResourcesType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Model_DeploymentResourcesType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_model_proto_enumTypes[0].Descriptor()
}

func (Model_DeploymentResourcesType) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_model_proto_enumTypes[0]
}

func (x Model_DeploymentResourcesType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Model_DeploymentResourcesType.Descriptor instead.
func (Model_DeploymentResourcesType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_proto_rawDescGZIP(), []int{0, 0}
}

// The Model content that can be exported.
type Model_ExportFormat_ExportableContent int32

const (
	// Should not be used.
	Model_ExportFormat_EXPORTABLE_CONTENT_UNSPECIFIED Model_ExportFormat_ExportableContent = 0
	// Model artifact and any of its supported files. Will be exported to the
	// specified [ExportModelRequest.output_config.artifact_destination]
	Model_ExportFormat_ARTIFACT Model_ExportFormat_ExportableContent = 1
	// The container image that is to be used when deploying this Model. Will
	// be exported to the specified
	// [ExportModelRequest.output_config.image_destination]
	Model_ExportFormat_IMAGE Model_ExportFormat_ExportableContent = 2
)

// Enum value maps for Model_ExportFormat_ExportableContent.
var (
	Model_ExportFormat_ExportableContent_name = map[int32]string{
		0: "EXPORTABLE_CONTENT_UNSPECIFIED",
		1: "ARTIFACT",
		2: "IMAGE",
	}
	Model_ExportFormat_ExportableContent_value = map[string]int32{
		"EXPORTABLE_CONTENT_UNSPECIFIED": 0,
		"ARTIFACT":                       1,
		"IMAGE":                          2,
	}
)

func (x Model_ExportFormat_ExportableContent) Enum() *Model_ExportFormat_ExportableContent {
	p := new(Model_ExportFormat_ExportableContent)
	*p = x
	return p
}

func (x Model_ExportFormat_ExportableContent) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Model_ExportFormat_ExportableContent) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_model_proto_enumTypes[1].Descriptor()
}

func (Model_ExportFormat_ExportableContent) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_model_proto_enumTypes[1]
}

func (x Model_ExportFormat_ExportableContent) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Model_ExportFormat_ExportableContent.Descriptor instead.
func (Model_ExportFormat_ExportableContent) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_proto_rawDescGZIP(), []int{0, 0, 0}
}

// A trained machine learning Model.
type Model struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the Model.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the Model.
	// The name can be up to 128 characters long and can be consist of any UTF-8
	// characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The description of the Model.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The schemata that describe formats of the Model's predictions and
	// explanations as given and returned via
	// [PredictionService.Predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict] and [PredictionService.Explain][google.cloud.aiplatform.v1beta1.PredictionService.Explain].
	PredictSchemata *PredictSchemata `protobuf:"bytes,4,opt,name=predict_schemata,json=predictSchemata,proto3" json:"predict_schemata,omitempty"`
	// Immutable. Points to a YAML file stored on Google Cloud Storage describing additional
	// information about the Model, that is specific to it. Unset if the Model
	// does not have any additional information.
	// The schema is defined as an OpenAPI 3.0.2
	// [Schema Object](https://tinyurl.com/y538mdwt#schema-object).
	// AutoML Models always have this field populated by AI Platform, if no
	// additional metadata is needed this field is set to an empty string.
	// Note: The URI given on output will be immutable and probably different,
	// including the URI scheme, than the one given on input. The output URI will
	// point to a location where the user only has a read access.
	MetadataSchemaUri string `protobuf:"bytes,5,opt,name=metadata_schema_uri,json=metadataSchemaUri,proto3" json:"metadata_schema_uri,omitempty"`
	// Immutable. An additional information about the Model; the schema of the metadata can
	// be found in [metadata_schema][google.cloud.aiplatform.v1beta1.Model.metadata_schema_uri].
	// Unset if the Model does not have any additional information.
	Metadata *structpb.Value `protobuf:"bytes,6,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Output only. The formats in which this Model may be exported. If empty, this Model is
	// not avaiable for export.
	SupportedExportFormats []*Model_ExportFormat `protobuf:"bytes,20,rep,name=supported_export_formats,json=supportedExportFormats,proto3" json:"supported_export_formats,omitempty"`
	// Output only. The resource name of the TrainingPipeline that uploaded this Model, if any.
	TrainingPipeline string `protobuf:"bytes,7,opt,name=training_pipeline,json=trainingPipeline,proto3" json:"training_pipeline,omitempty"`
	// Input only. The specification of the container that is to be used when deploying
	// this Model. The specification is ingested upon
	// [ModelService.UploadModel][google.cloud.aiplatform.v1beta1.ModelService.UploadModel], and all binaries it contains are copied
	// and stored internally by AI Platform.
	// Not present for AutoML Models.
	ContainerSpec *ModelContainerSpec `protobuf:"bytes,9,opt,name=container_spec,json=containerSpec,proto3" json:"container_spec,omitempty"`
	// Immutable. The path to the directory containing the Model artifact and any of its
	// supporting files.
	// Not present for AutoML Models.
	ArtifactUri string `protobuf:"bytes,26,opt,name=artifact_uri,json=artifactUri,proto3" json:"artifact_uri,omitempty"`
	// Output only. When this Model is deployed, its prediction resources are described by the
	// `prediction_resources` field of the [Endpoint.deployed_models][google.cloud.aiplatform.v1beta1.Endpoint.deployed_models] object.
	// Because not all Models support all resource configuration types, the
	// configuration types this Model supports are listed here. If no
	// configuration types are listed, the Model cannot be deployed to an
	// [Endpoint][google.cloud.aiplatform.v1beta1.Endpoint] and does not support
	// online predictions ([PredictionService.Predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict] or
	// [PredictionService.Explain][google.cloud.aiplatform.v1beta1.PredictionService.Explain]). Such a Model can serve predictions by
	// using a [BatchPredictionJob][google.cloud.aiplatform.v1beta1.BatchPredictionJob], if it has at least one entry each in
	// [supported_input_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_input_storage_formats] and
	// [supported_output_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_output_storage_formats].
	SupportedDeploymentResourcesTypes []Model_DeploymentResourcesType `protobuf:"varint,10,rep,packed,name=supported_deployment_resources_types,json=supportedDeploymentResourcesTypes,proto3,enum=google.cloud.aiplatform.v1beta1.Model_DeploymentResourcesType" json:"supported_deployment_resources_types,omitempty"`
	// Output only. The formats this Model supports in
	// [BatchPredictionJob.input_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.input_config]. If
	// [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri] exists, the instances
	// should be given as per that schema.
	//
	// The possible formats are:
	//
	// * `jsonl`
	// The JSON Lines format, where each instance is a single line. Uses
	// [GcsSource][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.gcs_source].
	//
	// * `csv`
	// The CSV format, where each instance is a single comma-separated line.
	// The first line in the file is the header, containing comma-separated field
	// names. Uses [GcsSource][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.gcs_source].
	//
	// * `tf-record`
	// The TFRecord format, where each instance is a single record in tfrecord
	// syntax. Uses [GcsSource][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.gcs_source].
	//
	// * `tf-record-gzip`
	// Similar to `tf-record`, but the file is gzipped. Uses
	// [GcsSource][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.gcs_source].
	//
	// * `bigquery`
	// Each instance is a single row in BigQuery. Uses
	// [BigQuerySource][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.bigquery_source].
	//
	//
	//
	// If this Model doesn't support any of these formats it means it cannot be
	// used with a [BatchPredictionJob][google.cloud.aiplatform.v1beta1.BatchPredictionJob]. However, if it has
	// [supported_deployment_resources_types][google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types], it could serve online
	// predictions by using [PredictionService.Predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict] or
	// [PredictionService.Explain][google.cloud.aiplatform.v1beta1.PredictionService.Explain].
	SupportedInputStorageFormats []string `protobuf:"bytes,11,rep,name=supported_input_storage_formats,json=supportedInputStorageFormats,proto3" json:"supported_input_storage_formats,omitempty"`
	// Output only. The formats this Model supports in
	// [BatchPredictionJob.output_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.output_config]. If both
	// [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri] and
	// [PredictSchemata.prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri] exist, the predictions
	// are returned together with their instances. In other words, the
	// prediction has the original instance data first, followed
	// by the actual prediction content (as per the schema).
	//
	// The possible formats are:
	//
	// * `jsonl`
	// The JSON Lines format, where each prediction is a single line. Uses
	// [GcsDestination][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.gcs_destination].
	//
	// * `csv`
	// The CSV format, where each prediction is a single comma-separated line.
	// The first line in the file is the header, containing comma-separated field
	// names. Uses
	// [GcsDestination][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.gcs_destination].
	//
	// * `bigquery`
	// Each prediction is a single row in a BigQuery table, uses
	// [BigQueryDestination][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.bigquery_destination]
	// .
	//
	//
	// If this Model doesn't support any of these formats it means it cannot be
	// used with a [BatchPredictionJob][google.cloud.aiplatform.v1beta1.BatchPredictionJob]. However, if it has
	// [supported_deployment_resources_types][google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types], it could serve online
	// predictions by using [PredictionService.Predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict] or
	// [PredictionService.Explain][google.cloud.aiplatform.v1beta1.PredictionService.Explain].
	SupportedOutputStorageFormats []string `protobuf:"bytes,12,rep,name=supported_output_storage_formats,json=supportedOutputStorageFormats,proto3" json:"supported_output_storage_formats,omitempty"`
	// Output only. Timestamp when this Model was uploaded into AI Platform.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,13,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when this Model was most recently updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,14,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The pointers to DeployedModels created from this Model. Note that
	// Model could have been deployed to Endpoints in different Locations.
	DeployedModels []*DeployedModelRef `protobuf:"bytes,15,rep,name=deployed_models,json=deployedModels,proto3" json:"deployed_models,omitempty"`
	// Output only. The default explanation specification for this Model.
	//
	// Model can be used for [requesting explanation][google.cloud.aiplatform.v1beta1.PredictionService.Explain]
	// after being [deployed][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel] iff it is populated.
	//
	// All fields of the explanation_spec can be overridden by
	// [explanation_spec][google.cloud.aiplatform.v1beta1.DeployedModel.explanation_spec] of
	// [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1beta1.DeployModelRequest.deployed_model].
	//
	// This field is populated only for tabular AutoML Models.
	// Specifying it with [ModelService.UploadModel][google.cloud.aiplatform.v1beta1.ModelService.UploadModel] is not supported.
	ExplanationSpec *ExplanationSpec `protobuf:"bytes,23,opt,name=explanation_spec,json=explanationSpec,proto3" json:"explanation_spec,omitempty"`
	// Used to perform consistent read-modify-write updates. If not set, a blind
	// "overwrite" update happens.
	Etag string `protobuf:"bytes,16,opt,name=etag,proto3" json:"etag,omitempty"`
	// The labels with user-defined metadata to organize your Models.
	//
	// Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	//
	// See https://goo.gl/xmQnxf for more information and examples of labels.
	Labels map[string]string `protobuf:"bytes,17,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Model) Reset() {
	*x = Model{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model) ProtoMessage() {}

func (x *Model) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model.ProtoReflect.Descriptor instead.
func (*Model) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_proto_rawDescGZIP(), []int{0}
}

func (x *Model) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Model) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Model) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Model) GetPredictSchemata() *PredictSchemata {
	if x != nil {
		return x.PredictSchemata
	}
	return nil
}

func (x *Model) GetMetadataSchemaUri() string {
	if x != nil {
		return x.MetadataSchemaUri
	}
	return ""
}

func (x *Model) GetMetadata() *structpb.Value {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Model) GetSupportedExportFormats() []*Model_ExportFormat {
	if x != nil {
		return x.SupportedExportFormats
	}
	return nil
}

func (x *Model) GetTrainingPipeline() string {
	if x != nil {
		return x.TrainingPipeline
	}
	return ""
}

func (x *Model) GetContainerSpec() *ModelContainerSpec {
	if x != nil {
		return x.ContainerSpec
	}
	return nil
}

func (x *Model) GetArtifactUri() string {
	if x != nil {
		return x.ArtifactUri
	}
	return ""
}

func (x *Model) GetSupportedDeploymentResourcesTypes() []Model_DeploymentResourcesType {
	if x != nil {
		return x.SupportedDeploymentResourcesTypes
	}
	return nil
}

func (x *Model) GetSupportedInputStorageFormats() []string {
	if x != nil {
		return x.SupportedInputStorageFormats
	}
	return nil
}

func (x *Model) GetSupportedOutputStorageFormats() []string {
	if x != nil {
		return x.SupportedOutputStorageFormats
	}
	return nil
}

func (x *Model) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Model) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Model) GetDeployedModels() []*DeployedModelRef {
	if x != nil {
		return x.DeployedModels
	}
	return nil
}

func (x *Model) GetExplanationSpec() *ExplanationSpec {
	if x != nil {
		return x.ExplanationSpec
	}
	return nil
}

func (x *Model) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Model) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Contains the schemata used in Model's predictions and explanations via
// [PredictionService.Predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict], [PredictionService.Explain][google.cloud.aiplatform.v1beta1.PredictionService.Explain] and
// [BatchPredictionJob][google.cloud.aiplatform.v1beta1.BatchPredictionJob].
type PredictSchemata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. Points to a YAML file stored on Google Cloud Storage describing the format
	// of a single instance, which are used in [PredictRequest.instances][google.cloud.aiplatform.v1beta1.PredictRequest.instances],
	// [ExplainRequest.instances][google.cloud.aiplatform.v1beta1.ExplainRequest.instances] and
	// [BatchPredictionJob.input_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.input_config].
	// The schema is defined as an OpenAPI 3.0.2
	// [Schema Object](https://tinyurl.com/y538mdwt#schema-object).
	// AutoML Models always have this field populated by AI Platform.
	// Note: The URI given on output will be immutable and probably different,
	// including the URI scheme, than the one given on input. The output URI will
	// point to a location where the user only has a read access.
	InstanceSchemaUri string `protobuf:"bytes,1,opt,name=instance_schema_uri,json=instanceSchemaUri,proto3" json:"instance_schema_uri,omitempty"`
	// Immutable. Points to a YAML file stored on Google Cloud Storage describing the
	// parameters of prediction and explanation via
	// [PredictRequest.parameters][google.cloud.aiplatform.v1beta1.PredictRequest.parameters], [ExplainRequest.parameters][google.cloud.aiplatform.v1beta1.ExplainRequest.parameters] and
	// [BatchPredictionJob.model_parameters][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model_parameters].
	// The schema is defined as an OpenAPI 3.0.2
	// [Schema Object](https://tinyurl.com/y538mdwt#schema-object).
	// AutoML Models always have this field populated by AI Platform, if no
	// parameters are supported it is set to an empty string.
	// Note: The URI given on output will be immutable and probably different,
	// including the URI scheme, than the one given on input. The output URI will
	// point to a location where the user only has a read access.
	ParametersSchemaUri string `protobuf:"bytes,2,opt,name=parameters_schema_uri,json=parametersSchemaUri,proto3" json:"parameters_schema_uri,omitempty"`
	// Immutable. Points to a YAML file stored on Google Cloud Storage describing the format
	// of a single prediction produced by this Model, which are returned via
	// [PredictResponse.predictions][google.cloud.aiplatform.v1beta1.PredictResponse.predictions], [ExplainResponse.explanations][google.cloud.aiplatform.v1beta1.ExplainResponse.explanations], and
	// [BatchPredictionJob.output_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.output_config].
	// The schema is defined as an OpenAPI 3.0.2
	// [Schema Object](https://tinyurl.com/y538mdwt#schema-object).
	// AutoML Models always have this field populated by AI Platform.
	// Note: The URI given on output will be immutable and probably different,
	// including the URI scheme, than the one given on input. The output URI will
	// point to a location where the user only has a read access.
	PredictionSchemaUri string `protobuf:"bytes,3,opt,name=prediction_schema_uri,json=predictionSchemaUri,proto3" json:"prediction_schema_uri,omitempty"`
}

func (x *PredictSchemata) Reset() {
	*x = PredictSchemata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PredictSchemata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PredictSchemata) ProtoMessage() {}

func (x *PredictSchemata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PredictSchemata.ProtoReflect.Descriptor instead.
func (*PredictSchemata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_proto_rawDescGZIP(), []int{1}
}

func (x *PredictSchemata) GetInstanceSchemaUri() string {
	if x != nil {
		return x.InstanceSchemaUri
	}
	return ""
}

func (x *PredictSchemata) GetParametersSchemaUri() string {
	if x != nil {
		return x.ParametersSchemaUri
	}
	return ""
}

func (x *PredictSchemata) GetPredictionSchemaUri() string {
	if x != nil {
		return x.PredictionSchemaUri
	}
	return ""
}

// Specification of the container to be deployed for this Model.
// The ModelContainerSpec is based on the Kubernetes Container
// [specification](https://tinyurl.com/k8s-io-api/v1.10/#container-v1-core).
type ModelContainerSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Immutable. The URI of the Model serving container file in the Container Registry. The
	// container image is ingested upon [ModelService.UploadModel][google.cloud.aiplatform.v1beta1.ModelService.UploadModel], stored
	// internally, and this original path is afterwards not used.
	ImageUri string `protobuf:"bytes,1,opt,name=image_uri,json=imageUri,proto3" json:"image_uri,omitempty"`
	// Immutable. The command with which the container is run. Not executed within a shell.
	// The Docker image's ENTRYPOINT is used if this is not provided.
	// Variable references $(VAR_NAME) are expanded using the container's
	// environment. If a variable cannot be resolved, the reference in the input
	// string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
	// double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
	// regardless of whether the variable exists or not.
	// More info: https://tinyurl.com/y42hmlxe
	Command []string `protobuf:"bytes,2,rep,name=command,proto3" json:"command,omitempty"`
	// Immutable. The arguments to the command.
	// The Docker image's CMD is used if this is not provided.
	// Variable references $(VAR_NAME) are expanded using the container's
	// environment. If a variable cannot be resolved, the reference in the input
	// string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
	// double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
	// regardless of whether the variable exists or not.
	// More info: https://tinyurl.com/y42hmlxe
	Args []string `protobuf:"bytes,3,rep,name=args,proto3" json:"args,omitempty"`
	// Immutable. The environment variables that are to be present in the container.
	Env []*EnvVar `protobuf:"bytes,4,rep,name=env,proto3" json:"env,omitempty"`
	// Immutable. Declaration of ports that are exposed by the container. This field is
	// primarily informational, it gives AI Platform information about the
	// network connections the container uses. Listing or not a port
	// here has no impact on whether the port is actually exposed, any port
	// listening on the default "0.0.0.0" address inside a container will be
	// accessible from the network.
	Ports []*Port `protobuf:"bytes,5,rep,name=ports,proto3" json:"ports,omitempty"`
	// Immutable. An HTTP path to send prediction requests to the container, and which
	// must be supported by it. If not specified a default HTTP path will be
	// used by AI Platform.
	PredictRoute string `protobuf:"bytes,6,opt,name=predict_route,json=predictRoute,proto3" json:"predict_route,omitempty"`
	// Immutable. An HTTP path to send health check requests to the container, and which
	// must be supported by it. If not specified a standard HTTP path will be
	// used by AI Platform.
	HealthRoute string `protobuf:"bytes,7,opt,name=health_route,json=healthRoute,proto3" json:"health_route,omitempty"`
}

func (x *ModelContainerSpec) Reset() {
	*x = ModelContainerSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelContainerSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelContainerSpec) ProtoMessage() {}

func (x *ModelContainerSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelContainerSpec.ProtoReflect.Descriptor instead.
func (*ModelContainerSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_proto_rawDescGZIP(), []int{2}
}

func (x *ModelContainerSpec) GetImageUri() string {
	if x != nil {
		return x.ImageUri
	}
	return ""
}

func (x *ModelContainerSpec) GetCommand() []string {
	if x != nil {
		return x.Command
	}
	return nil
}

func (x *ModelContainerSpec) GetArgs() []string {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *ModelContainerSpec) GetEnv() []*EnvVar {
	if x != nil {
		return x.Env
	}
	return nil
}

func (x *ModelContainerSpec) GetPorts() []*Port {
	if x != nil {
		return x.Ports
	}
	return nil
}

func (x *ModelContainerSpec) GetPredictRoute() string {
	if x != nil {
		return x.PredictRoute
	}
	return ""
}

func (x *ModelContainerSpec) GetHealthRoute() string {
	if x != nil {
		return x.HealthRoute
	}
	return ""
}

// Represents a network port in a container.
type Port struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of the port to expose on the pod's IP address.
	// Must be a valid port number, between 1 and 65535 inclusive.
	ContainerPort int32 `protobuf:"varint,3,opt,name=container_port,json=containerPort,proto3" json:"container_port,omitempty"`
}

func (x *Port) Reset() {
	*x = Port{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Port) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Port) ProtoMessage() {}

func (x *Port) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Port.ProtoReflect.Descriptor instead.
func (*Port) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_proto_rawDescGZIP(), []int{3}
}

func (x *Port) GetContainerPort() int32 {
	if x != nil {
		return x.ContainerPort
	}
	return 0
}

// Represents a supported by the Model export format.
// All formats export to Google Cloud Storage.
type Model_ExportFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The ID of the export format.
	// The possible format IDs are:
	//
	// * `tflite`
	// Used for Android mobile devices.
	//
	// * `edgetpu-tflite`
	// Used for [Edge TPU](https://cloud.google.com/edge-tpu/) devices.
	//
	// * `tf-saved-model`
	// A tensorflow model in SavedModel format.
	//
	// * `tf-js`
	// A [TensorFlow.js](https://www.tensorflow.org/js) model that can be used
	// in the browser and in Node.js using JavaScript.
	//
	// * `core-ml`
	// Used for iOS mobile devices.
	//
	// * `custom-trained`
	// A Model that was uploaded or trained by custom code.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Output only. The content of this Model that may be exported.
	ExportableContents []Model_ExportFormat_ExportableContent `protobuf:"varint,2,rep,packed,name=exportable_contents,json=exportableContents,proto3,enum=google.cloud.aiplatform.v1beta1.Model_ExportFormat_ExportableContent" json:"exportable_contents,omitempty"`
}

func (x *Model_ExportFormat) Reset() {
	*x = Model_ExportFormat{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_ExportFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_ExportFormat) ProtoMessage() {}

func (x *Model_ExportFormat) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_ExportFormat.ProtoReflect.Descriptor instead.
func (*Model_ExportFormat) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Model_ExportFormat) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Model_ExportFormat) GetExportableContents() []Model_ExportFormat_ExportableContent {
	if x != nil {
		return x.ExportableContents
	}
	return nil
}

var File_google_cloud_aiplatform_v1beta1_model_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_model_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x65, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x72, 0x65, 0x66, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x65, 0x6e, 0x76, 0x5f, 0x76, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xec, 0x0e, 0x0a, 0x05, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5b, 0x0a, 0x10, 0x70, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x74, 0x61, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x74, 0x61, 0x12, 0x33, 0x0a, 0x13, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x11, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x55, 0x72, 0x69, 0x12, 0x37, 0x0a, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x08, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x72, 0x0a, 0x18, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x65, 0x64, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x73, 0x18, 0x14, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x16, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x73, 0x12, 0x5f, 0x0a, 0x11, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67,
	0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x10, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69,
	0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x5f, 0x0a, 0x0e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x0d, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x12, 0x26, 0x0a, 0x0c, 0x61,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x1a, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0b, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x55, 0x72, 0x69, 0x12, 0x94, 0x01, 0x0a, 0x24, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65,
	0x64, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x03,
	0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x21, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x65, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x4a, 0x0a, 0x1f, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x73, 0x18, 0x0b, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1c, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72,
	0x74, 0x65, 0x64, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x46,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x73, 0x12, 0x4c, 0x0a, 0x20, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72,
	0x74, 0x65, 0x64, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1d, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x46, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5f, 0x0a, 0x0f, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x65, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x52, 0x65, 0x66, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x12, 0x60, 0x0a, 0x10, 0x65, 0x78, 0x70,
	0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x17, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x65, 0x78, 0x70, 0x6c,
	0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x12, 0x0a, 0x04, 0x65,
	0x74, 0x61, 0x67, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12,
	0x4a, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0xf2, 0x01, 0x0a, 0x0c,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x13, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x7b, 0x0a, 0x13, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x45,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x65, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x50,
	0x0a, 0x11, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x1e, 0x45, 0x58, 0x50, 0x4f, 0x52, 0x54, 0x41, 0x42, 0x4c,
	0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x41, 0x52, 0x54, 0x49, 0x46,
	0x41, 0x43, 0x54, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x10, 0x02,
	0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x76, 0x0a, 0x17, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x54, 0x79, 0x70, 0x65, 0x12, 0x29, 0x0a, 0x25, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59,
	0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x53, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x17, 0x0a, 0x13, 0x44, 0x45, 0x44, 0x49, 0x43, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x52,
	0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x53, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x41, 0x55,
	0x54, 0x4f, 0x4d, 0x41, 0x54, 0x49, 0x43, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45,
	0x53, 0x10, 0x02, 0x3a, 0x5c, 0xea, 0x41, 0x59, 0x0a, 0x1f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x36, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x7d, 0x22, 0xb8, 0x01, 0x0a, 0x0f, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x74, 0x61, 0x12, 0x33, 0x0a, 0x13, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x55, 0x72, 0x69, 0x12, 0x37, 0x0a, 0x15, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x13,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x55, 0x72, 0x69, 0x12, 0x37, 0x0a, 0x15, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x13, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x55, 0x72, 0x69, 0x22, 0xc5, 0x02, 0x0a,
	0x12, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x23, 0x0a, 0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x08,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x55, 0x72, 0x69, 0x12, 0x1d, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x07,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x17, 0x0a, 0x04, 0x61, 0x72, 0x67, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x61, 0x72, 0x67, 0x73,
	0x12, 0x3e, 0x0a, 0x03, 0x65, 0x6e, 0x76, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x45, 0x6e, 0x76, 0x56, 0x61, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x03, 0x65, 0x6e, 0x76,
	0x12, 0x40, 0x0a, 0x05, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x50, 0x6f, 0x72, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x05, 0x70, 0x6f, 0x72,
	0x74, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x5f, 0x72, 0x6f,
	0x75, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0c,
	0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x26, 0x0a, 0x0c,
	0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0b, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x22, 0x2d, 0x0a, 0x04, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x25, 0x0a, 0x0e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x50,
	0x6f, 0x72, 0x74, 0x42, 0x7e, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x0a, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x49, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_model_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_model_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_model_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_model_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_model_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_model_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_model_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_model_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_model_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_aiplatform_v1beta1_model_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_cloud_aiplatform_v1beta1_model_proto_goTypes = []interface{}{
	(Model_DeploymentResourcesType)(0),        // 0: google.cloud.aiplatform.v1beta1.Model.DeploymentResourcesType
	(Model_ExportFormat_ExportableContent)(0), // 1: google.cloud.aiplatform.v1beta1.Model.ExportFormat.ExportableContent
	(*Model)(nil),                 // 2: google.cloud.aiplatform.v1beta1.Model
	(*PredictSchemata)(nil),       // 3: google.cloud.aiplatform.v1beta1.PredictSchemata
	(*ModelContainerSpec)(nil),    // 4: google.cloud.aiplatform.v1beta1.ModelContainerSpec
	(*Port)(nil),                  // 5: google.cloud.aiplatform.v1beta1.Port
	(*Model_ExportFormat)(nil),    // 6: google.cloud.aiplatform.v1beta1.Model.ExportFormat
	nil,                           // 7: google.cloud.aiplatform.v1beta1.Model.LabelsEntry
	(*structpb.Value)(nil),        // 8: google.protobuf.Value
	(*timestamppb.Timestamp)(nil), // 9: google.protobuf.Timestamp
	(*DeployedModelRef)(nil),      // 10: google.cloud.aiplatform.v1beta1.DeployedModelRef
	(*ExplanationSpec)(nil),       // 11: google.cloud.aiplatform.v1beta1.ExplanationSpec
	(*EnvVar)(nil),                // 12: google.cloud.aiplatform.v1beta1.EnvVar
}
var file_google_cloud_aiplatform_v1beta1_model_proto_depIdxs = []int32{
	3,  // 0: google.cloud.aiplatform.v1beta1.Model.predict_schemata:type_name -> google.cloud.aiplatform.v1beta1.PredictSchemata
	8,  // 1: google.cloud.aiplatform.v1beta1.Model.metadata:type_name -> google.protobuf.Value
	6,  // 2: google.cloud.aiplatform.v1beta1.Model.supported_export_formats:type_name -> google.cloud.aiplatform.v1beta1.Model.ExportFormat
	4,  // 3: google.cloud.aiplatform.v1beta1.Model.container_spec:type_name -> google.cloud.aiplatform.v1beta1.ModelContainerSpec
	0,  // 4: google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types:type_name -> google.cloud.aiplatform.v1beta1.Model.DeploymentResourcesType
	9,  // 5: google.cloud.aiplatform.v1beta1.Model.create_time:type_name -> google.protobuf.Timestamp
	9,  // 6: google.cloud.aiplatform.v1beta1.Model.update_time:type_name -> google.protobuf.Timestamp
	10, // 7: google.cloud.aiplatform.v1beta1.Model.deployed_models:type_name -> google.cloud.aiplatform.v1beta1.DeployedModelRef
	11, // 8: google.cloud.aiplatform.v1beta1.Model.explanation_spec:type_name -> google.cloud.aiplatform.v1beta1.ExplanationSpec
	7,  // 9: google.cloud.aiplatform.v1beta1.Model.labels:type_name -> google.cloud.aiplatform.v1beta1.Model.LabelsEntry
	12, // 10: google.cloud.aiplatform.v1beta1.ModelContainerSpec.env:type_name -> google.cloud.aiplatform.v1beta1.EnvVar
	5,  // 11: google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports:type_name -> google.cloud.aiplatform.v1beta1.Port
	1,  // 12: google.cloud.aiplatform.v1beta1.Model.ExportFormat.exportable_contents:type_name -> google.cloud.aiplatform.v1beta1.Model.ExportFormat.ExportableContent
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_model_proto_init() }
func file_google_cloud_aiplatform_v1beta1_model_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_model_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_dataset_proto_init()
	file_google_cloud_aiplatform_v1beta1_deployed_model_ref_proto_init()
	file_google_cloud_aiplatform_v1beta1_env_var_proto_init()
	file_google_cloud_aiplatform_v1beta1_explanation_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1beta1_model_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PredictSchemata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelContainerSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Port); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_ExportFormat); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_model_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_model_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_model_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1beta1_model_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_model_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_model_proto = out.File
	file_google_cloud_aiplatform_v1beta1_model_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_model_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_model_proto_depIdxs = nil
}
