// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/ads/googleads/v5/common/simulation.proto

package common

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// A container for simulation points for simulations of type BID_MODIFIER.
type BidModifierSimulationPointList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Projected metrics for a series of bid modifier amounts.
	Points []*BidModifierSimulationPoint `protobuf:"bytes,1,rep,name=points,proto3" json:"points,omitempty"`
}

func (x *BidModifierSimulationPointList) Reset() {
	*x = BidModifierSimulationPointList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_common_simulation_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BidModifierSimulationPointList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BidModifierSimulationPointList) ProtoMessage() {}

func (x *BidModifierSimulationPointList) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_common_simulation_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BidModifierSimulationPointList.ProtoReflect.Descriptor instead.
func (*BidModifierSimulationPointList) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_common_simulation_proto_rawDescGZIP(), []int{0}
}

func (x *BidModifierSimulationPointList) GetPoints() []*BidModifierSimulationPoint {
	if x != nil {
		return x.Points
	}
	return nil
}

// A container for simulation points for simulations of type CPC_BID.
type CpcBidSimulationPointList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Projected metrics for a series of CPC bid amounts.
	Points []*CpcBidSimulationPoint `protobuf:"bytes,1,rep,name=points,proto3" json:"points,omitempty"`
}

func (x *CpcBidSimulationPointList) Reset() {
	*x = CpcBidSimulationPointList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_common_simulation_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CpcBidSimulationPointList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CpcBidSimulationPointList) ProtoMessage() {}

func (x *CpcBidSimulationPointList) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_common_simulation_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CpcBidSimulationPointList.ProtoReflect.Descriptor instead.
func (*CpcBidSimulationPointList) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_common_simulation_proto_rawDescGZIP(), []int{1}
}

func (x *CpcBidSimulationPointList) GetPoints() []*CpcBidSimulationPoint {
	if x != nil {
		return x.Points
	}
	return nil
}

// A container for simulation points for simulations of type CPV_BID.
type CpvBidSimulationPointList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Projected metrics for a series of CPV bid amounts.
	Points []*CpvBidSimulationPoint `protobuf:"bytes,1,rep,name=points,proto3" json:"points,omitempty"`
}

func (x *CpvBidSimulationPointList) Reset() {
	*x = CpvBidSimulationPointList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_common_simulation_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CpvBidSimulationPointList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CpvBidSimulationPointList) ProtoMessage() {}

func (x *CpvBidSimulationPointList) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_common_simulation_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CpvBidSimulationPointList.ProtoReflect.Descriptor instead.
func (*CpvBidSimulationPointList) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_common_simulation_proto_rawDescGZIP(), []int{2}
}

func (x *CpvBidSimulationPointList) GetPoints() []*CpvBidSimulationPoint {
	if x != nil {
		return x.Points
	}
	return nil
}

// A container for simulation points for simulations of type TARGET_CPA.
type TargetCpaSimulationPointList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Projected metrics for a series of target CPA amounts.
	Points []*TargetCpaSimulationPoint `protobuf:"bytes,1,rep,name=points,proto3" json:"points,omitempty"`
}

func (x *TargetCpaSimulationPointList) Reset() {
	*x = TargetCpaSimulationPointList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_common_simulation_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetCpaSimulationPointList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetCpaSimulationPointList) ProtoMessage() {}

func (x *TargetCpaSimulationPointList) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_common_simulation_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetCpaSimulationPointList.ProtoReflect.Descriptor instead.
func (*TargetCpaSimulationPointList) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_common_simulation_proto_rawDescGZIP(), []int{3}
}

func (x *TargetCpaSimulationPointList) GetPoints() []*TargetCpaSimulationPoint {
	if x != nil {
		return x.Points
	}
	return nil
}

// A container for simulation points for simulations of type TARGET_ROAS.
type TargetRoasSimulationPointList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Projected metrics for a series of target ROAS amounts.
	Points []*TargetRoasSimulationPoint `protobuf:"bytes,1,rep,name=points,proto3" json:"points,omitempty"`
}

func (x *TargetRoasSimulationPointList) Reset() {
	*x = TargetRoasSimulationPointList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_common_simulation_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetRoasSimulationPointList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetRoasSimulationPointList) ProtoMessage() {}

func (x *TargetRoasSimulationPointList) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_common_simulation_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetRoasSimulationPointList.ProtoReflect.Descriptor instead.
func (*TargetRoasSimulationPointList) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_common_simulation_proto_rawDescGZIP(), []int{4}
}

func (x *TargetRoasSimulationPointList) GetPoints() []*TargetRoasSimulationPoint {
	if x != nil {
		return x.Points
	}
	return nil
}

// A container for simulation points for simulations of type PERCENT_CPC_BID.
type PercentCpcBidSimulationPointList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Projected metrics for a series of percent CPC bid amounts.
	Points []*PercentCpcBidSimulationPoint `protobuf:"bytes,1,rep,name=points,proto3" json:"points,omitempty"`
}

func (x *PercentCpcBidSimulationPointList) Reset() {
	*x = PercentCpcBidSimulationPointList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_common_simulation_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PercentCpcBidSimulationPointList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PercentCpcBidSimulationPointList) ProtoMessage() {}

func (x *PercentCpcBidSimulationPointList) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_common_simulation_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PercentCpcBidSimulationPointList.ProtoReflect.Descriptor instead.
func (*PercentCpcBidSimulationPointList) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_common_simulation_proto_rawDescGZIP(), []int{5}
}

func (x *PercentCpcBidSimulationPointList) GetPoints() []*PercentCpcBidSimulationPoint {
	if x != nil {
		return x.Points
	}
	return nil
}

// Projected metrics for a specific bid modifier amount.
type BidModifierSimulationPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The simulated bid modifier upon which projected metrics are based.
	BidModifier *float64 `protobuf:"fixed64,15,opt,name=bid_modifier,json=bidModifier,proto3,oneof" json:"bid_modifier,omitempty"`
	// Projected number of biddable conversions.
	// Only search advertising channel type supports this field.
	BiddableConversions *float64 `protobuf:"fixed64,16,opt,name=biddable_conversions,json=biddableConversions,proto3,oneof" json:"biddable_conversions,omitempty"`
	// Projected total value of biddable conversions.
	// Only search advertising channel type supports this field.
	BiddableConversionsValue *float64 `protobuf:"fixed64,17,opt,name=biddable_conversions_value,json=biddableConversionsValue,proto3,oneof" json:"biddable_conversions_value,omitempty"`
	// Projected number of clicks.
	Clicks *int64 `protobuf:"varint,18,opt,name=clicks,proto3,oneof" json:"clicks,omitempty"`
	// Projected cost in micros.
	CostMicros *int64 `protobuf:"varint,19,opt,name=cost_micros,json=costMicros,proto3,oneof" json:"cost_micros,omitempty"`
	// Projected number of impressions.
	Impressions *int64 `protobuf:"varint,20,opt,name=impressions,proto3,oneof" json:"impressions,omitempty"`
	// Projected number of top slot impressions.
	// Only search advertising channel type supports this field.
	TopSlotImpressions *int64 `protobuf:"varint,21,opt,name=top_slot_impressions,json=topSlotImpressions,proto3,oneof" json:"top_slot_impressions,omitempty"`
	// Projected number of biddable conversions for the parent resource.
	// Only search advertising channel type supports this field.
	ParentBiddableConversions *float64 `protobuf:"fixed64,22,opt,name=parent_biddable_conversions,json=parentBiddableConversions,proto3,oneof" json:"parent_biddable_conversions,omitempty"`
	// Projected total value of biddable conversions for the parent resource.
	// Only search advertising channel type supports this field.
	ParentBiddableConversionsValue *float64 `protobuf:"fixed64,23,opt,name=parent_biddable_conversions_value,json=parentBiddableConversionsValue,proto3,oneof" json:"parent_biddable_conversions_value,omitempty"`
	// Projected number of clicks for the parent resource.
	ParentClicks *int64 `protobuf:"varint,24,opt,name=parent_clicks,json=parentClicks,proto3,oneof" json:"parent_clicks,omitempty"`
	// Projected cost in micros for the parent resource.
	ParentCostMicros *int64 `protobuf:"varint,25,opt,name=parent_cost_micros,json=parentCostMicros,proto3,oneof" json:"parent_cost_micros,omitempty"`
	// Projected number of impressions for the parent resource.
	ParentImpressions *int64 `protobuf:"varint,26,opt,name=parent_impressions,json=parentImpressions,proto3,oneof" json:"parent_impressions,omitempty"`
	// Projected number of top slot impressions for the parent resource.
	// Only search advertising channel type supports this field.
	ParentTopSlotImpressions *int64 `protobuf:"varint,27,opt,name=parent_top_slot_impressions,json=parentTopSlotImpressions,proto3,oneof" json:"parent_top_slot_impressions,omitempty"`
	// Projected minimum daily budget that must be available to the parent
	// resource to realize this simulation.
	ParentRequiredBudgetMicros *int64 `protobuf:"varint,28,opt,name=parent_required_budget_micros,json=parentRequiredBudgetMicros,proto3,oneof" json:"parent_required_budget_micros,omitempty"`
}

func (x *BidModifierSimulationPoint) Reset() {
	*x = BidModifierSimulationPoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_common_simulation_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BidModifierSimulationPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BidModifierSimulationPoint) ProtoMessage() {}

func (x *BidModifierSimulationPoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_common_simulation_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BidModifierSimulationPoint.ProtoReflect.Descriptor instead.
func (*BidModifierSimulationPoint) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_common_simulation_proto_rawDescGZIP(), []int{6}
}

func (x *BidModifierSimulationPoint) GetBidModifier() float64 {
	if x != nil && x.BidModifier != nil {
		return *x.BidModifier
	}
	return 0
}

func (x *BidModifierSimulationPoint) GetBiddableConversions() float64 {
	if x != nil && x.BiddableConversions != nil {
		return *x.BiddableConversions
	}
	return 0
}

func (x *BidModifierSimulationPoint) GetBiddableConversionsValue() float64 {
	if x != nil && x.BiddableConversionsValue != nil {
		return *x.BiddableConversionsValue
	}
	return 0
}

func (x *BidModifierSimulationPoint) GetClicks() int64 {
	if x != nil && x.Clicks != nil {
		return *x.Clicks
	}
	return 0
}

func (x *BidModifierSimulationPoint) GetCostMicros() int64 {
	if x != nil && x.CostMicros != nil {
		return *x.CostMicros
	}
	return 0
}

func (x *BidModifierSimulationPoint) GetImpressions() int64 {
	if x != nil && x.Impressions != nil {
		return *x.Impressions
	}
	return 0
}

func (x *BidModifierSimulationPoint) GetTopSlotImpressions() int64 {
	if x != nil && x.TopSlotImpressions != nil {
		return *x.TopSlotImpressions
	}
	return 0
}

func (x *BidModifierSimulationPoint) GetParentBiddableConversions() float64 {
	if x != nil && x.ParentBiddableConversions != nil {
		return *x.ParentBiddableConversions
	}
	return 0
}

func (x *BidModifierSimulationPoint) GetParentBiddableConversionsValue() float64 {
	if x != nil && x.ParentBiddableConversionsValue != nil {
		return *x.ParentBiddableConversionsValue
	}
	return 0
}

func (x *BidModifierSimulationPoint) GetParentClicks() int64 {
	if x != nil && x.ParentClicks != nil {
		return *x.ParentClicks
	}
	return 0
}

func (x *BidModifierSimulationPoint) GetParentCostMicros() int64 {
	if x != nil && x.ParentCostMicros != nil {
		return *x.ParentCostMicros
	}
	return 0
}

func (x *BidModifierSimulationPoint) GetParentImpressions() int64 {
	if x != nil && x.ParentImpressions != nil {
		return *x.ParentImpressions
	}
	return 0
}

func (x *BidModifierSimulationPoint) GetParentTopSlotImpressions() int64 {
	if x != nil && x.ParentTopSlotImpressions != nil {
		return *x.ParentTopSlotImpressions
	}
	return 0
}

func (x *BidModifierSimulationPoint) GetParentRequiredBudgetMicros() int64 {
	if x != nil && x.ParentRequiredBudgetMicros != nil {
		return *x.ParentRequiredBudgetMicros
	}
	return 0
}

// Projected metrics for a specific CPC bid amount.
type CpcBidSimulationPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The simulated CPC bid upon which projected metrics are based.
	CpcBidMicros *int64 `protobuf:"varint,8,opt,name=cpc_bid_micros,json=cpcBidMicros,proto3,oneof" json:"cpc_bid_micros,omitempty"`
	// Projected number of biddable conversions.
	BiddableConversions *float64 `protobuf:"fixed64,9,opt,name=biddable_conversions,json=biddableConversions,proto3,oneof" json:"biddable_conversions,omitempty"`
	// Projected total value of biddable conversions.
	BiddableConversionsValue *float64 `protobuf:"fixed64,10,opt,name=biddable_conversions_value,json=biddableConversionsValue,proto3,oneof" json:"biddable_conversions_value,omitempty"`
	// Projected number of clicks.
	Clicks *int64 `protobuf:"varint,11,opt,name=clicks,proto3,oneof" json:"clicks,omitempty"`
	// Projected cost in micros.
	CostMicros *int64 `protobuf:"varint,12,opt,name=cost_micros,json=costMicros,proto3,oneof" json:"cost_micros,omitempty"`
	// Projected number of impressions.
	Impressions *int64 `protobuf:"varint,13,opt,name=impressions,proto3,oneof" json:"impressions,omitempty"`
	// Projected number of top slot impressions.
	// Only search advertising channel type supports this field.
	TopSlotImpressions *int64 `protobuf:"varint,14,opt,name=top_slot_impressions,json=topSlotImpressions,proto3,oneof" json:"top_slot_impressions,omitempty"`
}

func (x *CpcBidSimulationPoint) Reset() {
	*x = CpcBidSimulationPoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_common_simulation_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CpcBidSimulationPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CpcBidSimulationPoint) ProtoMessage() {}

func (x *CpcBidSimulationPoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_common_simulation_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CpcBidSimulationPoint.ProtoReflect.Descriptor instead.
func (*CpcBidSimulationPoint) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_common_simulation_proto_rawDescGZIP(), []int{7}
}

func (x *CpcBidSimulationPoint) GetCpcBidMicros() int64 {
	if x != nil && x.CpcBidMicros != nil {
		return *x.CpcBidMicros
	}
	return 0
}

func (x *CpcBidSimulationPoint) GetBiddableConversions() float64 {
	if x != nil && x.BiddableConversions != nil {
		return *x.BiddableConversions
	}
	return 0
}

func (x *CpcBidSimulationPoint) GetBiddableConversionsValue() float64 {
	if x != nil && x.BiddableConversionsValue != nil {
		return *x.BiddableConversionsValue
	}
	return 0
}

func (x *CpcBidSimulationPoint) GetClicks() int64 {
	if x != nil && x.Clicks != nil {
		return *x.Clicks
	}
	return 0
}

func (x *CpcBidSimulationPoint) GetCostMicros() int64 {
	if x != nil && x.CostMicros != nil {
		return *x.CostMicros
	}
	return 0
}

func (x *CpcBidSimulationPoint) GetImpressions() int64 {
	if x != nil && x.Impressions != nil {
		return *x.Impressions
	}
	return 0
}

func (x *CpcBidSimulationPoint) GetTopSlotImpressions() int64 {
	if x != nil && x.TopSlotImpressions != nil {
		return *x.TopSlotImpressions
	}
	return 0
}

// Projected metrics for a specific CPV bid amount.
type CpvBidSimulationPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The simulated CPV bid upon which projected metrics are based.
	CpvBidMicros *int64 `protobuf:"varint,5,opt,name=cpv_bid_micros,json=cpvBidMicros,proto3,oneof" json:"cpv_bid_micros,omitempty"`
	// Projected cost in micros.
	CostMicros *int64 `protobuf:"varint,6,opt,name=cost_micros,json=costMicros,proto3,oneof" json:"cost_micros,omitempty"`
	// Projected number of impressions.
	Impressions *int64 `protobuf:"varint,7,opt,name=impressions,proto3,oneof" json:"impressions,omitempty"`
	// Projected number of views.
	Views *int64 `protobuf:"varint,8,opt,name=views,proto3,oneof" json:"views,omitempty"`
}

func (x *CpvBidSimulationPoint) Reset() {
	*x = CpvBidSimulationPoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_common_simulation_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CpvBidSimulationPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CpvBidSimulationPoint) ProtoMessage() {}

func (x *CpvBidSimulationPoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_common_simulation_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CpvBidSimulationPoint.ProtoReflect.Descriptor instead.
func (*CpvBidSimulationPoint) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_common_simulation_proto_rawDescGZIP(), []int{8}
}

func (x *CpvBidSimulationPoint) GetCpvBidMicros() int64 {
	if x != nil && x.CpvBidMicros != nil {
		return *x.CpvBidMicros
	}
	return 0
}

func (x *CpvBidSimulationPoint) GetCostMicros() int64 {
	if x != nil && x.CostMicros != nil {
		return *x.CostMicros
	}
	return 0
}

func (x *CpvBidSimulationPoint) GetImpressions() int64 {
	if x != nil && x.Impressions != nil {
		return *x.Impressions
	}
	return 0
}

func (x *CpvBidSimulationPoint) GetViews() int64 {
	if x != nil && x.Views != nil {
		return *x.Views
	}
	return 0
}

// Projected metrics for a specific target CPA amount.
type TargetCpaSimulationPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The simulated target CPA upon which projected metrics are based.
	TargetCpaMicros *int64 `protobuf:"varint,8,opt,name=target_cpa_micros,json=targetCpaMicros,proto3,oneof" json:"target_cpa_micros,omitempty"`
	// Projected number of biddable conversions.
	BiddableConversions *float64 `protobuf:"fixed64,9,opt,name=biddable_conversions,json=biddableConversions,proto3,oneof" json:"biddable_conversions,omitempty"`
	// Projected total value of biddable conversions.
	BiddableConversionsValue *float64 `protobuf:"fixed64,10,opt,name=biddable_conversions_value,json=biddableConversionsValue,proto3,oneof" json:"biddable_conversions_value,omitempty"`
	// Projected number of clicks.
	Clicks *int64 `protobuf:"varint,11,opt,name=clicks,proto3,oneof" json:"clicks,omitempty"`
	// Projected cost in micros.
	CostMicros *int64 `protobuf:"varint,12,opt,name=cost_micros,json=costMicros,proto3,oneof" json:"cost_micros,omitempty"`
	// Projected number of impressions.
	Impressions *int64 `protobuf:"varint,13,opt,name=impressions,proto3,oneof" json:"impressions,omitempty"`
	// Projected number of top slot impressions.
	// Only search advertising channel type supports this field.
	TopSlotImpressions *int64 `protobuf:"varint,14,opt,name=top_slot_impressions,json=topSlotImpressions,proto3,oneof" json:"top_slot_impressions,omitempty"`
}

func (x *TargetCpaSimulationPoint) Reset() {
	*x = TargetCpaSimulationPoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_common_simulation_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetCpaSimulationPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetCpaSimulationPoint) ProtoMessage() {}

func (x *TargetCpaSimulationPoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_common_simulation_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetCpaSimulationPoint.ProtoReflect.Descriptor instead.
func (*TargetCpaSimulationPoint) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_common_simulation_proto_rawDescGZIP(), []int{9}
}

func (x *TargetCpaSimulationPoint) GetTargetCpaMicros() int64 {
	if x != nil && x.TargetCpaMicros != nil {
		return *x.TargetCpaMicros
	}
	return 0
}

func (x *TargetCpaSimulationPoint) GetBiddableConversions() float64 {
	if x != nil && x.BiddableConversions != nil {
		return *x.BiddableConversions
	}
	return 0
}

func (x *TargetCpaSimulationPoint) GetBiddableConversionsValue() float64 {
	if x != nil && x.BiddableConversionsValue != nil {
		return *x.BiddableConversionsValue
	}
	return 0
}

func (x *TargetCpaSimulationPoint) GetClicks() int64 {
	if x != nil && x.Clicks != nil {
		return *x.Clicks
	}
	return 0
}

func (x *TargetCpaSimulationPoint) GetCostMicros() int64 {
	if x != nil && x.CostMicros != nil {
		return *x.CostMicros
	}
	return 0
}

func (x *TargetCpaSimulationPoint) GetImpressions() int64 {
	if x != nil && x.Impressions != nil {
		return *x.Impressions
	}
	return 0
}

func (x *TargetCpaSimulationPoint) GetTopSlotImpressions() int64 {
	if x != nil && x.TopSlotImpressions != nil {
		return *x.TopSlotImpressions
	}
	return 0
}

// Projected metrics for a specific target ROAS amount.
type TargetRoasSimulationPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The simulated target ROAS upon which projected metrics are based.
	TargetRoas *float64 `protobuf:"fixed64,8,opt,name=target_roas,json=targetRoas,proto3,oneof" json:"target_roas,omitempty"`
	// Projected number of biddable conversions.
	BiddableConversions *float64 `protobuf:"fixed64,9,opt,name=biddable_conversions,json=biddableConversions,proto3,oneof" json:"biddable_conversions,omitempty"`
	// Projected total value of biddable conversions.
	BiddableConversionsValue *float64 `protobuf:"fixed64,10,opt,name=biddable_conversions_value,json=biddableConversionsValue,proto3,oneof" json:"biddable_conversions_value,omitempty"`
	// Projected number of clicks.
	Clicks *int64 `protobuf:"varint,11,opt,name=clicks,proto3,oneof" json:"clicks,omitempty"`
	// Projected cost in micros.
	CostMicros *int64 `protobuf:"varint,12,opt,name=cost_micros,json=costMicros,proto3,oneof" json:"cost_micros,omitempty"`
	// Projected number of impressions.
	Impressions *int64 `protobuf:"varint,13,opt,name=impressions,proto3,oneof" json:"impressions,omitempty"`
	// Projected number of top slot impressions.
	// Only Search advertising channel type supports this field.
	TopSlotImpressions *int64 `protobuf:"varint,14,opt,name=top_slot_impressions,json=topSlotImpressions,proto3,oneof" json:"top_slot_impressions,omitempty"`
}

func (x *TargetRoasSimulationPoint) Reset() {
	*x = TargetRoasSimulationPoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_common_simulation_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetRoasSimulationPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetRoasSimulationPoint) ProtoMessage() {}

func (x *TargetRoasSimulationPoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_common_simulation_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetRoasSimulationPoint.ProtoReflect.Descriptor instead.
func (*TargetRoasSimulationPoint) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_common_simulation_proto_rawDescGZIP(), []int{10}
}

func (x *TargetRoasSimulationPoint) GetTargetRoas() float64 {
	if x != nil && x.TargetRoas != nil {
		return *x.TargetRoas
	}
	return 0
}

func (x *TargetRoasSimulationPoint) GetBiddableConversions() float64 {
	if x != nil && x.BiddableConversions != nil {
		return *x.BiddableConversions
	}
	return 0
}

func (x *TargetRoasSimulationPoint) GetBiddableConversionsValue() float64 {
	if x != nil && x.BiddableConversionsValue != nil {
		return *x.BiddableConversionsValue
	}
	return 0
}

func (x *TargetRoasSimulationPoint) GetClicks() int64 {
	if x != nil && x.Clicks != nil {
		return *x.Clicks
	}
	return 0
}

func (x *TargetRoasSimulationPoint) GetCostMicros() int64 {
	if x != nil && x.CostMicros != nil {
		return *x.CostMicros
	}
	return 0
}

func (x *TargetRoasSimulationPoint) GetImpressions() int64 {
	if x != nil && x.Impressions != nil {
		return *x.Impressions
	}
	return 0
}

func (x *TargetRoasSimulationPoint) GetTopSlotImpressions() int64 {
	if x != nil && x.TopSlotImpressions != nil {
		return *x.TopSlotImpressions
	}
	return 0
}

// Projected metrics for a specific percent CPC amount. Only Hotel advertising
// channel type supports this field.
type PercentCpcBidSimulationPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The simulated percent CPC upon which projected metrics are based. Percent
	// CPC expressed as fraction of the advertised price for some good or service.
	// The value stored here is 1,000,000 * [fraction].
	PercentCpcBidMicros *int64 `protobuf:"varint,1,opt,name=percent_cpc_bid_micros,json=percentCpcBidMicros,proto3,oneof" json:"percent_cpc_bid_micros,omitempty"`
	// Projected number of biddable conversions.
	BiddableConversions *float64 `protobuf:"fixed64,2,opt,name=biddable_conversions,json=biddableConversions,proto3,oneof" json:"biddable_conversions,omitempty"`
	// Projected total value of biddable conversions in local currency.
	BiddableConversionsValue *float64 `protobuf:"fixed64,3,opt,name=biddable_conversions_value,json=biddableConversionsValue,proto3,oneof" json:"biddable_conversions_value,omitempty"`
	// Projected number of clicks.
	Clicks *int64 `protobuf:"varint,4,opt,name=clicks,proto3,oneof" json:"clicks,omitempty"`
	// Projected cost in micros.
	CostMicros *int64 `protobuf:"varint,5,opt,name=cost_micros,json=costMicros,proto3,oneof" json:"cost_micros,omitempty"`
	// Projected number of impressions.
	Impressions *int64 `protobuf:"varint,6,opt,name=impressions,proto3,oneof" json:"impressions,omitempty"`
	// Projected number of top slot impressions.
	TopSlotImpressions *int64 `protobuf:"varint,7,opt,name=top_slot_impressions,json=topSlotImpressions,proto3,oneof" json:"top_slot_impressions,omitempty"`
}

func (x *PercentCpcBidSimulationPoint) Reset() {
	*x = PercentCpcBidSimulationPoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_common_simulation_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PercentCpcBidSimulationPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PercentCpcBidSimulationPoint) ProtoMessage() {}

func (x *PercentCpcBidSimulationPoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_common_simulation_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PercentCpcBidSimulationPoint.ProtoReflect.Descriptor instead.
func (*PercentCpcBidSimulationPoint) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_common_simulation_proto_rawDescGZIP(), []int{11}
}

func (x *PercentCpcBidSimulationPoint) GetPercentCpcBidMicros() int64 {
	if x != nil && x.PercentCpcBidMicros != nil {
		return *x.PercentCpcBidMicros
	}
	return 0
}

func (x *PercentCpcBidSimulationPoint) GetBiddableConversions() float64 {
	if x != nil && x.BiddableConversions != nil {
		return *x.BiddableConversions
	}
	return 0
}

func (x *PercentCpcBidSimulationPoint) GetBiddableConversionsValue() float64 {
	if x != nil && x.BiddableConversionsValue != nil {
		return *x.BiddableConversionsValue
	}
	return 0
}

func (x *PercentCpcBidSimulationPoint) GetClicks() int64 {
	if x != nil && x.Clicks != nil {
		return *x.Clicks
	}
	return 0
}

func (x *PercentCpcBidSimulationPoint) GetCostMicros() int64 {
	if x != nil && x.CostMicros != nil {
		return *x.CostMicros
	}
	return 0
}

func (x *PercentCpcBidSimulationPoint) GetImpressions() int64 {
	if x != nil && x.Impressions != nil {
		return *x.Impressions
	}
	return 0
}

func (x *PercentCpcBidSimulationPoint) GetTopSlotImpressions() int64 {
	if x != nil && x.TopSlotImpressions != nil {
		return *x.TopSlotImpressions
	}
	return 0
}

var File_google_ads_googleads_v5_common_simulation_proto protoreflect.FileDescriptor

var file_google_ads_googleads_v5_common_simulation_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x35, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2f, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0x74, 0x0a, 0x1e, 0x42, 0x69, 0x64, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x53, 0x69,
	0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x4c, 0x69, 0x73,
	0x74, 0x12, 0x52, 0x0a, 0x06, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x2e, 0x42, 0x69, 0x64, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x53, 0x69,
	0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x06, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x73, 0x22, 0x6a, 0x0a, 0x19, 0x43, 0x70, 0x63, 0x42, 0x69, 0x64, 0x53,
	0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x4c, 0x69,
	0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x70, 0x63, 0x42, 0x69, 0x64, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x73, 0x22, 0x6a, 0x0a, 0x19, 0x43, 0x70, 0x76, 0x42, 0x69, 0x64, 0x53, 0x69, 0x6d, 0x75, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x4d,
	0x0a, 0x06, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x43, 0x70, 0x76, 0x42, 0x69, 0x64, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x22, 0x70, 0x0a,
	0x1c, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x70, 0x61, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x50, 0x0a,
	0x06, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x70, 0x61, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x22,
	0x72, 0x0a, 0x1d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x6f, 0x61, 0x73, 0x53, 0x69, 0x6d,
	0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x4c, 0x69, 0x73, 0x74,
	0x12, 0x51, 0x0a, 0x06, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x6f, 0x61, 0x73, 0x53, 0x69, 0x6d, 0x75,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x73, 0x22, 0x78, 0x0a, 0x20, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x43, 0x70,
	0x63, 0x42, 0x69, 0x64, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f,
	0x69, 0x6e, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x06, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x35, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74,
	0x43, 0x70, 0x63, 0x42, 0x69, 0x64, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x22, 0xe7, 0x08,
	0x0a, 0x1a, 0x42, 0x69, 0x64, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x53, 0x69, 0x6d,
	0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x26, 0x0a, 0x0c,
	0x62, 0x69, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x01, 0x48, 0x00, 0x52, 0x0b, 0x62, 0x69, 0x64, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x88, 0x01, 0x01, 0x12, 0x36, 0x0a, 0x14, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x10, 0x20, 0x01,
	0x28, 0x01, 0x48, 0x01, 0x52, 0x13, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x41, 0x0a, 0x1a,
	0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x01,
	0x48, 0x02, 0x52, 0x18, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x1b, 0x0a, 0x06, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x18, 0x12, 0x20, 0x01, 0x28, 0x03, 0x48,
	0x03, 0x52, 0x06, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b,
	0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x13, 0x20, 0x01, 0x28,
	0x03, 0x48, 0x04, 0x52, 0x0a, 0x63, 0x6f, 0x73, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x88,
	0x01, 0x01, 0x12, 0x25, 0x0a, 0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x14, 0x20, 0x01, 0x28, 0x03, 0x48, 0x05, 0x52, 0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x35, 0x0a, 0x14, 0x74, 0x6f, 0x70,
	0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x15, 0x20, 0x01, 0x28, 0x03, 0x48, 0x06, 0x52, 0x12, 0x74, 0x6f, 0x70, 0x53, 0x6c,
	0x6f, 0x74, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01,
	0x12, 0x43, 0x0a, 0x1b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x62, 0x69, 0x64, 0x64, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x16, 0x20, 0x01, 0x28, 0x01, 0x48, 0x07, 0x52, 0x19, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x42,
	0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x4e, 0x0a, 0x21, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f,
	0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x17, 0x20, 0x01, 0x28, 0x01,
	0x48, 0x08, 0x52, 0x1e, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x42, 0x69, 0x64, 0x64, 0x61, 0x62,
	0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f,
	0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x18, 0x18, 0x20, 0x01, 0x28, 0x03, 0x48, 0x09, 0x52, 0x0c,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x88, 0x01, 0x01, 0x12,
	0x31, 0x0a, 0x12, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6d,
	0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x19, 0x20, 0x01, 0x28, 0x03, 0x48, 0x0a, 0x52, 0x10, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x73, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x88,
	0x01, 0x01, 0x12, 0x32, 0x0a, 0x12, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6d, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x03, 0x48, 0x0b,
	0x52, 0x11, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x42, 0x0a, 0x1b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x03, 0x48, 0x0c, 0x52, 0x18, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x70, 0x53, 0x6c, 0x6f, 0x74, 0x49, 0x6d, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x46, 0x0a, 0x1d, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x62, 0x75,
	0x64, 0x67, 0x65, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x1c, 0x20, 0x01, 0x28,
	0x03, 0x48, 0x0d, 0x52, 0x1a, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x64, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x88,
	0x01, 0x01, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x62, 0x69, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66,
	0x69, 0x65, 0x72, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x1d, 0x0a, 0x1b,
	0x5f, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x09, 0x0a, 0x07, 0x5f,
	0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x5f,
	0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x73,
	0x6c, 0x6f, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x42,
	0x1e, 0x0a, 0x1c, 0x5f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x62, 0x69, 0x64, 0x64, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x42,
	0x24, 0x0a, 0x22, 0x5f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x62, 0x69, 0x64, 0x64, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x42, 0x15,
	0x0a, 0x13, 0x5f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x20, 0x0a, 0x1e, 0x5f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x5f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74,
	0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x22, 0xed, 0x03, 0x0a, 0x15, 0x43, 0x70, 0x63, 0x42,
	0x69, 0x64, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x69, 0x6e,
	0x74, 0x12, 0x29, 0x0a, 0x0e, 0x63, 0x70, 0x63, 0x5f, 0x62, 0x69, 0x64, 0x5f, 0x6d, 0x69, 0x63,
	0x72, 0x6f, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x0c, 0x63, 0x70, 0x63,
	0x42, 0x69, 0x64, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x88, 0x01, 0x01, 0x12, 0x36, 0x0a, 0x14,
	0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x01, 0x48, 0x01, 0x52, 0x13, 0x62, 0x69,
	0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x88, 0x01, 0x01, 0x12, 0x41, 0x0a, 0x1a, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x01, 0x48, 0x02, 0x52, 0x18, 0x62, 0x69, 0x64, 0x64,
	0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1b, 0x0a, 0x06, 0x63, 0x6c, 0x69, 0x63, 0x6b,
	0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x03, 0x48, 0x03, 0x52, 0x06, 0x63, 0x6c, 0x69, 0x63, 0x6b,
	0x73, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x69, 0x63,
	0x72, 0x6f, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x03, 0x48, 0x04, 0x52, 0x0a, 0x63, 0x6f, 0x73,
	0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x88, 0x01, 0x01, 0x12, 0x25, 0x0a, 0x0b, 0x69, 0x6d,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x03, 0x48,
	0x05, 0x52, 0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01,
	0x01, 0x12, 0x35, 0x0a, 0x14, 0x74, 0x6f, 0x70, 0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x5f, 0x69, 0x6d,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x03, 0x48,
	0x06, 0x52, 0x12, 0x74, 0x6f, 0x70, 0x53, 0x6c, 0x6f, 0x74, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x63, 0x70, 0x63,
	0x5f, 0x62, 0x69, 0x64, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x42, 0x17, 0x0a, 0x15, 0x5f,
	0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x42, 0x1d, 0x0a, 0x1b, 0x5f, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x42, 0x0e,
	0x0a, 0x0c, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x42, 0x0e,
	0x0a, 0x0c, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x17,
	0x0a, 0x15, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xe7, 0x01, 0x0a, 0x15, 0x43, 0x70, 0x76, 0x42,
	0x69, 0x64, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x69, 0x6e,
	0x74, 0x12, 0x29, 0x0a, 0x0e, 0x63, 0x70, 0x76, 0x5f, 0x62, 0x69, 0x64, 0x5f, 0x6d, 0x69, 0x63,
	0x72, 0x6f, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x0c, 0x63, 0x70, 0x76,
	0x42, 0x69, 0x64, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b,
	0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x03, 0x48, 0x01, 0x52, 0x0a, 0x63, 0x6f, 0x73, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x88,
	0x01, 0x01, 0x12, 0x25, 0x0a, 0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x48, 0x02, 0x52, 0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a, 0x05, 0x76, 0x69, 0x65,
	0x77, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x48, 0x03, 0x52, 0x05, 0x76, 0x69, 0x65, 0x77,
	0x73, 0x88, 0x01, 0x01, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x63, 0x70, 0x76, 0x5f, 0x62, 0x69, 0x64,
	0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x63, 0x6f, 0x73, 0x74,
	0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x69, 0x6d, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x76, 0x69, 0x65, 0x77,
	0x73, 0x22, 0xf9, 0x03, 0x0a, 0x18, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x70, 0x61, 0x53,
	0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x2f,
	0x0a, 0x11, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x70, 0x61, 0x5f, 0x6d, 0x69, 0x63,
	0x72, 0x6f, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x0f, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x43, 0x70, 0x61, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x88, 0x01, 0x01, 0x12,
	0x36, 0x0a, 0x14, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x01, 0x48, 0x01, 0x52,
	0x13, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x41, 0x0a, 0x1a, 0x62, 0x69, 0x64, 0x64, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x01, 0x48, 0x02, 0x52, 0x18, 0x62,
	0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1b, 0x0a, 0x06, 0x63, 0x6c,
	0x69, 0x63, 0x6b, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x03, 0x48, 0x03, 0x52, 0x06, 0x63, 0x6c,
	0x69, 0x63, 0x6b, 0x73, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x6f, 0x73, 0x74, 0x5f,
	0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x03, 0x48, 0x04, 0x52, 0x0a,
	0x63, 0x6f, 0x73, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x88, 0x01, 0x01, 0x12, 0x25, 0x0a,
	0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x03, 0x48, 0x05, 0x52, 0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x88, 0x01, 0x01, 0x12, 0x35, 0x0a, 0x14, 0x74, 0x6f, 0x70, 0x5f, 0x73, 0x6c, 0x6f, 0x74,
	0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x03, 0x48, 0x06, 0x52, 0x12, 0x74, 0x6f, 0x70, 0x53, 0x6c, 0x6f, 0x74, 0x49, 0x6d, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x42, 0x14, 0x0a, 0x12, 0x5f,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x70, 0x61, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f,
	0x73, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x1d, 0x0a, 0x1b, 0x5f, 0x62,
	0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x63, 0x6c,
	0x69, 0x63, 0x6b, 0x73, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x69,
	0x63, 0x72, 0x6f, 0x73, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x73, 0x6c, 0x6f,
	0x74, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xe9, 0x03,
	0x0a, 0x19, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x6f, 0x61, 0x73, 0x53, 0x69, 0x6d, 0x75,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x72, 0x6f, 0x61, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x01,
	0x48, 0x00, 0x52, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x6f, 0x61, 0x73, 0x88, 0x01,
	0x01, 0x12, 0x36, 0x0a, 0x14, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x01, 0x48,
	0x01, 0x52, 0x13, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x41, 0x0a, 0x1a, 0x62, 0x69, 0x64,
	0x64, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x01, 0x48, 0x02, 0x52,
	0x18, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1b, 0x0a, 0x06,
	0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x03, 0x48, 0x03, 0x52, 0x06,
	0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x6f, 0x73,
	0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x03, 0x48, 0x04,
	0x52, 0x0a, 0x63, 0x6f, 0x73, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x88, 0x01, 0x01, 0x12,
	0x25, 0x0a, 0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x03, 0x48, 0x05, 0x52, 0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x35, 0x0a, 0x14, 0x74, 0x6f, 0x70, 0x5f, 0x73, 0x6c,
	0x6f, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x03, 0x48, 0x06, 0x52, 0x12, 0x74, 0x6f, 0x70, 0x53, 0x6c, 0x6f, 0x74, 0x49,
	0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x42, 0x0e, 0x0a,
	0x0c, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x72, 0x6f, 0x61, 0x73, 0x42, 0x17, 0x0a,
	0x15, 0x5f, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x1d, 0x0a, 0x1b, 0x5f, 0x62, 0x69, 0x64, 0x64, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73,
	0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73,
	0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x42, 0x17, 0x0a, 0x15, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x5f, 0x69, 0x6d,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x8b, 0x04, 0x0a, 0x1c, 0x50, 0x65,
	0x72, 0x63, 0x65, 0x6e, 0x74, 0x43, 0x70, 0x63, 0x42, 0x69, 0x64, 0x53, 0x69, 0x6d, 0x75, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x38, 0x0a, 0x16, 0x70, 0x65,
	0x72, 0x63, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x70, 0x63, 0x5f, 0x62, 0x69, 0x64, 0x5f, 0x6d, 0x69,
	0x63, 0x72, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x13, 0x70, 0x65,
	0x72, 0x63, 0x65, 0x6e, 0x74, 0x43, 0x70, 0x63, 0x42, 0x69, 0x64, 0x4d, 0x69, 0x63, 0x72, 0x6f,
	0x73, 0x88, 0x01, 0x01, 0x12, 0x36, 0x0a, 0x14, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x01, 0x48, 0x01, 0x52, 0x13, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x41, 0x0a, 0x1a,
	0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01,
	0x48, 0x02, 0x52, 0x18, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x1b, 0x0a, 0x06, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x48,
	0x03, 0x52, 0x06, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b,
	0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x03, 0x48, 0x04, 0x52, 0x0a, 0x63, 0x6f, 0x73, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x88,
	0x01, 0x01, 0x12, 0x25, 0x0a, 0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x48, 0x05, 0x52, 0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x35, 0x0a, 0x14, 0x74, 0x6f, 0x70,
	0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x48, 0x06, 0x52, 0x12, 0x74, 0x6f, 0x70, 0x53, 0x6c,
	0x6f, 0x74, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01,
	0x42, 0x19, 0x0a, 0x17, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x70, 0x63,
	0x5f, 0x62, 0x69, 0x64, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x42, 0x17, 0x0a, 0x15, 0x5f,
	0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x42, 0x1d, 0x0a, 0x1b, 0x5f, 0x62, 0x69, 0x64, 0x64, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x42, 0x0e,
	0x0a, 0x0c, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x42, 0x0e,
	0x0a, 0x0c, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x17,
	0x0a, 0x15, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0xea, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x42, 0x0f,
	0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x35, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x3b, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0xa2, 0x02, 0x03, 0x47, 0x41, 0x41, 0xaa, 0x02, 0x1e,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x64, 0x73, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x41, 0x64, 0x73, 0x2e, 0x56, 0x35, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0xca, 0x02,
	0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x64, 0x73, 0x5c, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x41, 0x64, 0x73, 0x5c, 0x56, 0x35, 0x5c, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0xea,
	0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x56, 0x35, 0x3a, 0x3a, 0x43, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ads_googleads_v5_common_simulation_proto_rawDescOnce sync.Once
	file_google_ads_googleads_v5_common_simulation_proto_rawDescData = file_google_ads_googleads_v5_common_simulation_proto_rawDesc
)

func file_google_ads_googleads_v5_common_simulation_proto_rawDescGZIP() []byte {
	file_google_ads_googleads_v5_common_simulation_proto_rawDescOnce.Do(func() {
		file_google_ads_googleads_v5_common_simulation_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_googleads_v5_common_simulation_proto_rawDescData)
	})
	return file_google_ads_googleads_v5_common_simulation_proto_rawDescData
}

var file_google_ads_googleads_v5_common_simulation_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_ads_googleads_v5_common_simulation_proto_goTypes = []interface{}{
	(*BidModifierSimulationPointList)(nil),   // 0: google.ads.googleads.v5.common.BidModifierSimulationPointList
	(*CpcBidSimulationPointList)(nil),        // 1: google.ads.googleads.v5.common.CpcBidSimulationPointList
	(*CpvBidSimulationPointList)(nil),        // 2: google.ads.googleads.v5.common.CpvBidSimulationPointList
	(*TargetCpaSimulationPointList)(nil),     // 3: google.ads.googleads.v5.common.TargetCpaSimulationPointList
	(*TargetRoasSimulationPointList)(nil),    // 4: google.ads.googleads.v5.common.TargetRoasSimulationPointList
	(*PercentCpcBidSimulationPointList)(nil), // 5: google.ads.googleads.v5.common.PercentCpcBidSimulationPointList
	(*BidModifierSimulationPoint)(nil),       // 6: google.ads.googleads.v5.common.BidModifierSimulationPoint
	(*CpcBidSimulationPoint)(nil),            // 7: google.ads.googleads.v5.common.CpcBidSimulationPoint
	(*CpvBidSimulationPoint)(nil),            // 8: google.ads.googleads.v5.common.CpvBidSimulationPoint
	(*TargetCpaSimulationPoint)(nil),         // 9: google.ads.googleads.v5.common.TargetCpaSimulationPoint
	(*TargetRoasSimulationPoint)(nil),        // 10: google.ads.googleads.v5.common.TargetRoasSimulationPoint
	(*PercentCpcBidSimulationPoint)(nil),     // 11: google.ads.googleads.v5.common.PercentCpcBidSimulationPoint
}
var file_google_ads_googleads_v5_common_simulation_proto_depIdxs = []int32{
	6,  // 0: google.ads.googleads.v5.common.BidModifierSimulationPointList.points:type_name -> google.ads.googleads.v5.common.BidModifierSimulationPoint
	7,  // 1: google.ads.googleads.v5.common.CpcBidSimulationPointList.points:type_name -> google.ads.googleads.v5.common.CpcBidSimulationPoint
	8,  // 2: google.ads.googleads.v5.common.CpvBidSimulationPointList.points:type_name -> google.ads.googleads.v5.common.CpvBidSimulationPoint
	9,  // 3: google.ads.googleads.v5.common.TargetCpaSimulationPointList.points:type_name -> google.ads.googleads.v5.common.TargetCpaSimulationPoint
	10, // 4: google.ads.googleads.v5.common.TargetRoasSimulationPointList.points:type_name -> google.ads.googleads.v5.common.TargetRoasSimulationPoint
	11, // 5: google.ads.googleads.v5.common.PercentCpcBidSimulationPointList.points:type_name -> google.ads.googleads.v5.common.PercentCpcBidSimulationPoint
	6,  // [6:6] is the sub-list for method output_type
	6,  // [6:6] is the sub-list for method input_type
	6,  // [6:6] is the sub-list for extension type_name
	6,  // [6:6] is the sub-list for extension extendee
	0,  // [0:6] is the sub-list for field type_name
}

func init() { file_google_ads_googleads_v5_common_simulation_proto_init() }
func file_google_ads_googleads_v5_common_simulation_proto_init() {
	if File_google_ads_googleads_v5_common_simulation_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_ads_googleads_v5_common_simulation_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BidModifierSimulationPointList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_common_simulation_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CpcBidSimulationPointList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_common_simulation_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CpvBidSimulationPointList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_common_simulation_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TargetCpaSimulationPointList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_common_simulation_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TargetRoasSimulationPointList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_common_simulation_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PercentCpcBidSimulationPointList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_common_simulation_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BidModifierSimulationPoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_common_simulation_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CpcBidSimulationPoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_common_simulation_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CpvBidSimulationPoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_common_simulation_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TargetCpaSimulationPoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_common_simulation_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TargetRoasSimulationPoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_common_simulation_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PercentCpcBidSimulationPoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_ads_googleads_v5_common_simulation_proto_msgTypes[6].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v5_common_simulation_proto_msgTypes[7].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v5_common_simulation_proto_msgTypes[8].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v5_common_simulation_proto_msgTypes[9].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v5_common_simulation_proto_msgTypes[10].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v5_common_simulation_proto_msgTypes[11].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_googleads_v5_common_simulation_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_ads_googleads_v5_common_simulation_proto_goTypes,
		DependencyIndexes: file_google_ads_googleads_v5_common_simulation_proto_depIdxs,
		MessageInfos:      file_google_ads_googleads_v5_common_simulation_proto_msgTypes,
	}.Build()
	File_google_ads_googleads_v5_common_simulation_proto = out.File
	file_google_ads_googleads_v5_common_simulation_proto_rawDesc = nil
	file_google_ads_googleads_v5_common_simulation_proto_goTypes = nil
	file_google_ads_googleads_v5_common_simulation_proto_depIdxs = nil
}
