// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/ads/googleads/v5/services/keyword_plan_service.proto

package services

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	common "google.golang.org/genproto/googleapis/ads/googleads/v5/common"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v5/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Request message for [KeywordPlanService.GetKeywordPlan][google.ads.googleads.v5.services.KeywordPlanService.GetKeywordPlan].
type GetKeywordPlanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the plan to fetch.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
}

func (x *GetKeywordPlanRequest) Reset() {
	*x = GetKeywordPlanRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetKeywordPlanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetKeywordPlanRequest) ProtoMessage() {}

func (x *GetKeywordPlanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetKeywordPlanRequest.ProtoReflect.Descriptor instead.
func (*GetKeywordPlanRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetKeywordPlanRequest) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

// Request message for [KeywordPlanService.MutateKeywordPlans][google.ads.googleads.v5.services.KeywordPlanService.MutateKeywordPlans].
type MutateKeywordPlansRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the customer whose keyword plans are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The list of operations to perform on individual keyword plans.
	Operations []*KeywordPlanOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, all operations will be carried
	// out in one transaction if and only if they are all valid.
	// Default is false.
	PartialFailure bool `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *MutateKeywordPlansRequest) Reset() {
	*x = MutateKeywordPlansRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MutateKeywordPlansRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateKeywordPlansRequest) ProtoMessage() {}

func (x *MutateKeywordPlansRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateKeywordPlansRequest.ProtoReflect.Descriptor instead.
func (*MutateKeywordPlansRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescGZIP(), []int{1}
}

func (x *MutateKeywordPlansRequest) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *MutateKeywordPlansRequest) GetOperations() []*KeywordPlanOperation {
	if x != nil {
		return x.Operations
	}
	return nil
}

func (x *MutateKeywordPlansRequest) GetPartialFailure() bool {
	if x != nil {
		return x.PartialFailure
	}
	return false
}

func (x *MutateKeywordPlansRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// A single operation (create, update, remove) on a keyword plan.
type KeywordPlanOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The FieldMask that determines which resource fields are modified in an
	// update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are assignable to Operation:
	//	*KeywordPlanOperation_Create
	//	*KeywordPlanOperation_Update
	//	*KeywordPlanOperation_Remove
	Operation isKeywordPlanOperation_Operation `protobuf_oneof:"operation"`
}

func (x *KeywordPlanOperation) Reset() {
	*x = KeywordPlanOperation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeywordPlanOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeywordPlanOperation) ProtoMessage() {}

func (x *KeywordPlanOperation) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeywordPlanOperation.ProtoReflect.Descriptor instead.
func (*KeywordPlanOperation) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescGZIP(), []int{2}
}

func (x *KeywordPlanOperation) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (m *KeywordPlanOperation) GetOperation() isKeywordPlanOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (x *KeywordPlanOperation) GetCreate() *resources.KeywordPlan {
	if x, ok := x.GetOperation().(*KeywordPlanOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (x *KeywordPlanOperation) GetUpdate() *resources.KeywordPlan {
	if x, ok := x.GetOperation().(*KeywordPlanOperation_Update); ok {
		return x.Update
	}
	return nil
}

func (x *KeywordPlanOperation) GetRemove() string {
	if x, ok := x.GetOperation().(*KeywordPlanOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

type isKeywordPlanOperation_Operation interface {
	isKeywordPlanOperation_Operation()
}

type KeywordPlanOperation_Create struct {
	// Create operation: No resource name is expected for the new keyword plan.
	Create *resources.KeywordPlan `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type KeywordPlanOperation_Update struct {
	// Update operation: The keyword plan is expected to have a valid resource
	// name.
	Update *resources.KeywordPlan `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

type KeywordPlanOperation_Remove struct {
	// Remove operation: A resource name for the removed keyword plan is
	// expected in this format:
	//
	// `customers/{customer_id}/keywordPlans/{keyword_plan_id}`
	Remove string `protobuf:"bytes,3,opt,name=remove,proto3,oneof"`
}

func (*KeywordPlanOperation_Create) isKeywordPlanOperation_Operation() {}

func (*KeywordPlanOperation_Update) isKeywordPlanOperation_Operation() {}

func (*KeywordPlanOperation_Remove) isKeywordPlanOperation_Operation() {}

// Response message for a keyword plan mutate.
type MutateKeywordPlansResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors),
	// we return an RPC level error.
	PartialFailureError *status.Status `protobuf:"bytes,3,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	// All results for the mutate.
	Results []*MutateKeywordPlansResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
}

func (x *MutateKeywordPlansResponse) Reset() {
	*x = MutateKeywordPlansResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MutateKeywordPlansResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateKeywordPlansResponse) ProtoMessage() {}

func (x *MutateKeywordPlansResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateKeywordPlansResponse.ProtoReflect.Descriptor instead.
func (*MutateKeywordPlansResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescGZIP(), []int{3}
}

func (x *MutateKeywordPlansResponse) GetPartialFailureError() *status.Status {
	if x != nil {
		return x.PartialFailureError
	}
	return nil
}

func (x *MutateKeywordPlansResponse) GetResults() []*MutateKeywordPlansResult {
	if x != nil {
		return x.Results
	}
	return nil
}

// The result for the keyword plan mutate.
type MutateKeywordPlansResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Returned for successful operations.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
}

func (x *MutateKeywordPlansResult) Reset() {
	*x = MutateKeywordPlansResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MutateKeywordPlansResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateKeywordPlansResult) ProtoMessage() {}

func (x *MutateKeywordPlansResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateKeywordPlansResult.ProtoReflect.Descriptor instead.
func (*MutateKeywordPlansResult) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescGZIP(), []int{4}
}

func (x *MutateKeywordPlansResult) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

// Request message for [KeywordPlanService.GenerateForecastCurve][google.ads.googleads.v5.services.KeywordPlanService.GenerateForecastCurve].
type GenerateForecastCurveRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the keyword plan to be forecasted.
	KeywordPlan string `protobuf:"bytes,1,opt,name=keyword_plan,json=keywordPlan,proto3" json:"keyword_plan,omitempty"`
}

func (x *GenerateForecastCurveRequest) Reset() {
	*x = GenerateForecastCurveRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateForecastCurveRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateForecastCurveRequest) ProtoMessage() {}

func (x *GenerateForecastCurveRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateForecastCurveRequest.ProtoReflect.Descriptor instead.
func (*GenerateForecastCurveRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescGZIP(), []int{5}
}

func (x *GenerateForecastCurveRequest) GetKeywordPlan() string {
	if x != nil {
		return x.KeywordPlan
	}
	return ""
}

// Response message for [KeywordPlanService.GenerateForecastCurve][google.ads.googleads.v5.services.KeywordPlanService.GenerateForecastCurve].
type GenerateForecastCurveResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of forecast curves for the keyword plan campaign.
	// One maximum.
	CampaignForecastCurves []*KeywordPlanCampaignForecastCurve `protobuf:"bytes,1,rep,name=campaign_forecast_curves,json=campaignForecastCurves,proto3" json:"campaign_forecast_curves,omitempty"`
}

func (x *GenerateForecastCurveResponse) Reset() {
	*x = GenerateForecastCurveResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateForecastCurveResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateForecastCurveResponse) ProtoMessage() {}

func (x *GenerateForecastCurveResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateForecastCurveResponse.ProtoReflect.Descriptor instead.
func (*GenerateForecastCurveResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescGZIP(), []int{6}
}

func (x *GenerateForecastCurveResponse) GetCampaignForecastCurves() []*KeywordPlanCampaignForecastCurve {
	if x != nil {
		return x.CampaignForecastCurves
	}
	return nil
}

// Request message for [KeywordPlanService.GenerateForecastTimeSeries][google.ads.googleads.v5.services.KeywordPlanService.GenerateForecastTimeSeries].
type GenerateForecastTimeSeriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the keyword plan to be forecasted.
	KeywordPlan string `protobuf:"bytes,1,opt,name=keyword_plan,json=keywordPlan,proto3" json:"keyword_plan,omitempty"`
}

func (x *GenerateForecastTimeSeriesRequest) Reset() {
	*x = GenerateForecastTimeSeriesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateForecastTimeSeriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateForecastTimeSeriesRequest) ProtoMessage() {}

func (x *GenerateForecastTimeSeriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateForecastTimeSeriesRequest.ProtoReflect.Descriptor instead.
func (*GenerateForecastTimeSeriesRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescGZIP(), []int{7}
}

func (x *GenerateForecastTimeSeriesRequest) GetKeywordPlan() string {
	if x != nil {
		return x.KeywordPlan
	}
	return ""
}

// Response message for [KeywordPlanService.GenerateForecastTimeSeries][google.ads.googleads.v5.services.KeywordPlanService.GenerateForecastTimeSeries].
type GenerateForecastTimeSeriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of weekly time series forecasts for the keyword plan campaign.
	// One maximum.
	WeeklyTimeSeriesForecasts []*KeywordPlanWeeklyTimeSeriesForecast `protobuf:"bytes,1,rep,name=weekly_time_series_forecasts,json=weeklyTimeSeriesForecasts,proto3" json:"weekly_time_series_forecasts,omitempty"`
}

func (x *GenerateForecastTimeSeriesResponse) Reset() {
	*x = GenerateForecastTimeSeriesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateForecastTimeSeriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateForecastTimeSeriesResponse) ProtoMessage() {}

func (x *GenerateForecastTimeSeriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateForecastTimeSeriesResponse.ProtoReflect.Descriptor instead.
func (*GenerateForecastTimeSeriesResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescGZIP(), []int{8}
}

func (x *GenerateForecastTimeSeriesResponse) GetWeeklyTimeSeriesForecasts() []*KeywordPlanWeeklyTimeSeriesForecast {
	if x != nil {
		return x.WeeklyTimeSeriesForecasts
	}
	return nil
}

// Request message for [KeywordPlanService.GenerateForecastMetrics][google.ads.googleads.v5.services.KeywordPlanService.GenerateForecastMetrics].
type GenerateForecastMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the keyword plan to be forecasted.
	KeywordPlan string `protobuf:"bytes,1,opt,name=keyword_plan,json=keywordPlan,proto3" json:"keyword_plan,omitempty"`
}

func (x *GenerateForecastMetricsRequest) Reset() {
	*x = GenerateForecastMetricsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateForecastMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateForecastMetricsRequest) ProtoMessage() {}

func (x *GenerateForecastMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateForecastMetricsRequest.ProtoReflect.Descriptor instead.
func (*GenerateForecastMetricsRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescGZIP(), []int{9}
}

func (x *GenerateForecastMetricsRequest) GetKeywordPlan() string {
	if x != nil {
		return x.KeywordPlan
	}
	return ""
}

// Response message for [KeywordPlanService.GenerateForecastMetrics][google.ads.googleads.v5.services.KeywordPlanService.GenerateForecastMetrics].
type GenerateForecastMetricsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of campaign forecasts.
	// One maximum.
	CampaignForecasts []*KeywordPlanCampaignForecast `protobuf:"bytes,1,rep,name=campaign_forecasts,json=campaignForecasts,proto3" json:"campaign_forecasts,omitempty"`
	// List of ad group forecasts.
	AdGroupForecasts []*KeywordPlanAdGroupForecast `protobuf:"bytes,2,rep,name=ad_group_forecasts,json=adGroupForecasts,proto3" json:"ad_group_forecasts,omitempty"`
	// List of keyword forecasts.
	KeywordForecasts []*KeywordPlanKeywordForecast `protobuf:"bytes,3,rep,name=keyword_forecasts,json=keywordForecasts,proto3" json:"keyword_forecasts,omitempty"`
}

func (x *GenerateForecastMetricsResponse) Reset() {
	*x = GenerateForecastMetricsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateForecastMetricsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateForecastMetricsResponse) ProtoMessage() {}

func (x *GenerateForecastMetricsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateForecastMetricsResponse.ProtoReflect.Descriptor instead.
func (*GenerateForecastMetricsResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescGZIP(), []int{10}
}

func (x *GenerateForecastMetricsResponse) GetCampaignForecasts() []*KeywordPlanCampaignForecast {
	if x != nil {
		return x.CampaignForecasts
	}
	return nil
}

func (x *GenerateForecastMetricsResponse) GetAdGroupForecasts() []*KeywordPlanAdGroupForecast {
	if x != nil {
		return x.AdGroupForecasts
	}
	return nil
}

func (x *GenerateForecastMetricsResponse) GetKeywordForecasts() []*KeywordPlanKeywordForecast {
	if x != nil {
		return x.KeywordForecasts
	}
	return nil
}

// A campaign forecast.
type KeywordPlanCampaignForecast struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the Keyword Plan campaign related to the forecast.
	//
	// `customers/{customer_id}/keywordPlanCampaigns/{keyword_plan_campaign_id}`
	KeywordPlanCampaign *wrapperspb.StringValue `protobuf:"bytes,1,opt,name=keyword_plan_campaign,json=keywordPlanCampaign,proto3" json:"keyword_plan_campaign,omitempty"`
	// The forecast for the Keyword Plan campaign.
	CampaignForecast *ForecastMetrics `protobuf:"bytes,2,opt,name=campaign_forecast,json=campaignForecast,proto3" json:"campaign_forecast,omitempty"`
}

func (x *KeywordPlanCampaignForecast) Reset() {
	*x = KeywordPlanCampaignForecast{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeywordPlanCampaignForecast) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeywordPlanCampaignForecast) ProtoMessage() {}

func (x *KeywordPlanCampaignForecast) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeywordPlanCampaignForecast.ProtoReflect.Descriptor instead.
func (*KeywordPlanCampaignForecast) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescGZIP(), []int{11}
}

func (x *KeywordPlanCampaignForecast) GetKeywordPlanCampaign() *wrapperspb.StringValue {
	if x != nil {
		return x.KeywordPlanCampaign
	}
	return nil
}

func (x *KeywordPlanCampaignForecast) GetCampaignForecast() *ForecastMetrics {
	if x != nil {
		return x.CampaignForecast
	}
	return nil
}

// An ad group forecast.
type KeywordPlanAdGroupForecast struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the Keyword Plan ad group related to the forecast.
	//
	// `customers/{customer_id}/keywordPlanAdGroups/{keyword_plan_ad_group_id}`
	KeywordPlanAdGroup *wrapperspb.StringValue `protobuf:"bytes,1,opt,name=keyword_plan_ad_group,json=keywordPlanAdGroup,proto3" json:"keyword_plan_ad_group,omitempty"`
	// The forecast for the Keyword Plan ad group.
	AdGroupForecast *ForecastMetrics `protobuf:"bytes,2,opt,name=ad_group_forecast,json=adGroupForecast,proto3" json:"ad_group_forecast,omitempty"`
}

func (x *KeywordPlanAdGroupForecast) Reset() {
	*x = KeywordPlanAdGroupForecast{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeywordPlanAdGroupForecast) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeywordPlanAdGroupForecast) ProtoMessage() {}

func (x *KeywordPlanAdGroupForecast) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeywordPlanAdGroupForecast.ProtoReflect.Descriptor instead.
func (*KeywordPlanAdGroupForecast) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescGZIP(), []int{12}
}

func (x *KeywordPlanAdGroupForecast) GetKeywordPlanAdGroup() *wrapperspb.StringValue {
	if x != nil {
		return x.KeywordPlanAdGroup
	}
	return nil
}

func (x *KeywordPlanAdGroupForecast) GetAdGroupForecast() *ForecastMetrics {
	if x != nil {
		return x.AdGroupForecast
	}
	return nil
}

// A keyword forecast.
type KeywordPlanKeywordForecast struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the Keyword Plan keyword related to the forecast.
	//
	// `customers/{customer_id}/keywordPlanAdGroupKeywords/{keyword_plan_ad_group_keyword_id}`
	KeywordPlanAdGroupKeyword *wrapperspb.StringValue `protobuf:"bytes,1,opt,name=keyword_plan_ad_group_keyword,json=keywordPlanAdGroupKeyword,proto3" json:"keyword_plan_ad_group_keyword,omitempty"`
	// The forecast for the Keyword Plan keyword.
	KeywordForecast *ForecastMetrics `protobuf:"bytes,2,opt,name=keyword_forecast,json=keywordForecast,proto3" json:"keyword_forecast,omitempty"`
}

func (x *KeywordPlanKeywordForecast) Reset() {
	*x = KeywordPlanKeywordForecast{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeywordPlanKeywordForecast) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeywordPlanKeywordForecast) ProtoMessage() {}

func (x *KeywordPlanKeywordForecast) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeywordPlanKeywordForecast.ProtoReflect.Descriptor instead.
func (*KeywordPlanKeywordForecast) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescGZIP(), []int{13}
}

func (x *KeywordPlanKeywordForecast) GetKeywordPlanAdGroupKeyword() *wrapperspb.StringValue {
	if x != nil {
		return x.KeywordPlanAdGroupKeyword
	}
	return nil
}

func (x *KeywordPlanKeywordForecast) GetKeywordForecast() *ForecastMetrics {
	if x != nil {
		return x.KeywordForecast
	}
	return nil
}

// The forecast curve for the campaign.
type KeywordPlanCampaignForecastCurve struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the Keyword Plan campaign related to the forecast.
	//
	// `customers/{customer_id}/keywordPlanCampaigns/{keyword_plan_campaign_id}`
	KeywordPlanCampaign *wrapperspb.StringValue `protobuf:"bytes,1,opt,name=keyword_plan_campaign,json=keywordPlanCampaign,proto3" json:"keyword_plan_campaign,omitempty"`
	// The max cpc bid forecast curve for the campaign.
	MaxCpcBidForecastCurve *KeywordPlanMaxCpcBidForecastCurve `protobuf:"bytes,2,opt,name=max_cpc_bid_forecast_curve,json=maxCpcBidForecastCurve,proto3" json:"max_cpc_bid_forecast_curve,omitempty"`
}

func (x *KeywordPlanCampaignForecastCurve) Reset() {
	*x = KeywordPlanCampaignForecastCurve{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeywordPlanCampaignForecastCurve) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeywordPlanCampaignForecastCurve) ProtoMessage() {}

func (x *KeywordPlanCampaignForecastCurve) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeywordPlanCampaignForecastCurve.ProtoReflect.Descriptor instead.
func (*KeywordPlanCampaignForecastCurve) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescGZIP(), []int{14}
}

func (x *KeywordPlanCampaignForecastCurve) GetKeywordPlanCampaign() *wrapperspb.StringValue {
	if x != nil {
		return x.KeywordPlanCampaign
	}
	return nil
}

func (x *KeywordPlanCampaignForecastCurve) GetMaxCpcBidForecastCurve() *KeywordPlanMaxCpcBidForecastCurve {
	if x != nil {
		return x.MaxCpcBidForecastCurve
	}
	return nil
}

// The max cpc bid forecast curve.
type KeywordPlanMaxCpcBidForecastCurve struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The forecasts for the Keyword Plan campaign at different max CPC bids.
	MaxCpcBidForecasts []*KeywordPlanMaxCpcBidForecast `protobuf:"bytes,1,rep,name=max_cpc_bid_forecasts,json=maxCpcBidForecasts,proto3" json:"max_cpc_bid_forecasts,omitempty"`
}

func (x *KeywordPlanMaxCpcBidForecastCurve) Reset() {
	*x = KeywordPlanMaxCpcBidForecastCurve{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeywordPlanMaxCpcBidForecastCurve) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeywordPlanMaxCpcBidForecastCurve) ProtoMessage() {}

func (x *KeywordPlanMaxCpcBidForecastCurve) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeywordPlanMaxCpcBidForecastCurve.ProtoReflect.Descriptor instead.
func (*KeywordPlanMaxCpcBidForecastCurve) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescGZIP(), []int{15}
}

func (x *KeywordPlanMaxCpcBidForecastCurve) GetMaxCpcBidForecasts() []*KeywordPlanMaxCpcBidForecast {
	if x != nil {
		return x.MaxCpcBidForecasts
	}
	return nil
}

// The forecast of the campaign at a specific bid.
type KeywordPlanMaxCpcBidForecast struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The max cpc bid in micros.
	MaxCpcBidMicros *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=max_cpc_bid_micros,json=maxCpcBidMicros,proto3" json:"max_cpc_bid_micros,omitempty"`
	// The forecast for the Keyword Plan campaign at the specific bid.
	MaxCpcBidForecast *ForecastMetrics `protobuf:"bytes,2,opt,name=max_cpc_bid_forecast,json=maxCpcBidForecast,proto3" json:"max_cpc_bid_forecast,omitempty"`
}

func (x *KeywordPlanMaxCpcBidForecast) Reset() {
	*x = KeywordPlanMaxCpcBidForecast{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeywordPlanMaxCpcBidForecast) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeywordPlanMaxCpcBidForecast) ProtoMessage() {}

func (x *KeywordPlanMaxCpcBidForecast) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeywordPlanMaxCpcBidForecast.ProtoReflect.Descriptor instead.
func (*KeywordPlanMaxCpcBidForecast) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescGZIP(), []int{16}
}

func (x *KeywordPlanMaxCpcBidForecast) GetMaxCpcBidMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.MaxCpcBidMicros
	}
	return nil
}

func (x *KeywordPlanMaxCpcBidForecast) GetMaxCpcBidForecast() *ForecastMetrics {
	if x != nil {
		return x.MaxCpcBidForecast
	}
	return nil
}

// The weekly time series forecast for the keyword plan campaign.
type KeywordPlanWeeklyTimeSeriesForecast struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the Keyword Plan campaign related to the forecast.
	//
	// `customers/{customer_id}/keywordPlanCampaigns/{keyword_plan_campaign_id}`
	KeywordPlanCampaign *string `protobuf:"bytes,1,opt,name=keyword_plan_campaign,json=keywordPlanCampaign,proto3,oneof" json:"keyword_plan_campaign,omitempty"`
	// The forecasts for the Keyword Plan campaign at different max CPC bids.
	WeeklyForecasts []*KeywordPlanWeeklyForecast `protobuf:"bytes,2,rep,name=weekly_forecasts,json=weeklyForecasts,proto3" json:"weekly_forecasts,omitempty"`
}

func (x *KeywordPlanWeeklyTimeSeriesForecast) Reset() {
	*x = KeywordPlanWeeklyTimeSeriesForecast{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeywordPlanWeeklyTimeSeriesForecast) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeywordPlanWeeklyTimeSeriesForecast) ProtoMessage() {}

func (x *KeywordPlanWeeklyTimeSeriesForecast) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeywordPlanWeeklyTimeSeriesForecast.ProtoReflect.Descriptor instead.
func (*KeywordPlanWeeklyTimeSeriesForecast) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescGZIP(), []int{17}
}

func (x *KeywordPlanWeeklyTimeSeriesForecast) GetKeywordPlanCampaign() string {
	if x != nil && x.KeywordPlanCampaign != nil {
		return *x.KeywordPlanCampaign
	}
	return ""
}

func (x *KeywordPlanWeeklyTimeSeriesForecast) GetWeeklyForecasts() []*KeywordPlanWeeklyForecast {
	if x != nil {
		return x.WeeklyForecasts
	}
	return nil
}

// The forecast of the campaign for the week starting start_date.
type KeywordPlanWeeklyForecast struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The start date, in yyyy-mm-dd format. This date is inclusive.
	StartDate *string `protobuf:"bytes,1,opt,name=start_date,json=startDate,proto3,oneof" json:"start_date,omitempty"`
	// The forecast for the Keyword Plan campaign for the week.
	Forecast *ForecastMetrics `protobuf:"bytes,2,opt,name=forecast,proto3" json:"forecast,omitempty"`
}

func (x *KeywordPlanWeeklyForecast) Reset() {
	*x = KeywordPlanWeeklyForecast{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeywordPlanWeeklyForecast) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeywordPlanWeeklyForecast) ProtoMessage() {}

func (x *KeywordPlanWeeklyForecast) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeywordPlanWeeklyForecast.ProtoReflect.Descriptor instead.
func (*KeywordPlanWeeklyForecast) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescGZIP(), []int{18}
}

func (x *KeywordPlanWeeklyForecast) GetStartDate() string {
	if x != nil && x.StartDate != nil {
		return *x.StartDate
	}
	return ""
}

func (x *KeywordPlanWeeklyForecast) GetForecast() *ForecastMetrics {
	if x != nil {
		return x.Forecast
	}
	return nil
}

// Forecast metrics.
type ForecastMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Impressions
	Impressions *wrapperspb.DoubleValue `protobuf:"bytes,1,opt,name=impressions,proto3" json:"impressions,omitempty"`
	// Ctr
	Ctr *wrapperspb.DoubleValue `protobuf:"bytes,2,opt,name=ctr,proto3" json:"ctr,omitempty"`
	// AVG cpc
	AverageCpc *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=average_cpc,json=averageCpc,proto3" json:"average_cpc,omitempty"`
	// Clicks
	Clicks *wrapperspb.DoubleValue `protobuf:"bytes,5,opt,name=clicks,proto3" json:"clicks,omitempty"`
	// Cost
	CostMicros *wrapperspb.Int64Value `protobuf:"bytes,6,opt,name=cost_micros,json=costMicros,proto3" json:"cost_micros,omitempty"`
}

func (x *ForecastMetrics) Reset() {
	*x = ForecastMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ForecastMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForecastMetrics) ProtoMessage() {}

func (x *ForecastMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ForecastMetrics.ProtoReflect.Descriptor instead.
func (*ForecastMetrics) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescGZIP(), []int{19}
}

func (x *ForecastMetrics) GetImpressions() *wrapperspb.DoubleValue {
	if x != nil {
		return x.Impressions
	}
	return nil
}

func (x *ForecastMetrics) GetCtr() *wrapperspb.DoubleValue {
	if x != nil {
		return x.Ctr
	}
	return nil
}

func (x *ForecastMetrics) GetAverageCpc() *wrapperspb.Int64Value {
	if x != nil {
		return x.AverageCpc
	}
	return nil
}

func (x *ForecastMetrics) GetClicks() *wrapperspb.DoubleValue {
	if x != nil {
		return x.Clicks
	}
	return nil
}

func (x *ForecastMetrics) GetCostMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.CostMicros
	}
	return nil
}

// Request message for [KeywordPlanService.GenerateHistoricalMetrics][google.ads.googleads.v5.services.KeywordPlanService.GenerateHistoricalMetrics].
type GenerateHistoricalMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the keyword plan of which historical metrics are
	// requested.
	KeywordPlan string `protobuf:"bytes,1,opt,name=keyword_plan,json=keywordPlan,proto3" json:"keyword_plan,omitempty"`
}

func (x *GenerateHistoricalMetricsRequest) Reset() {
	*x = GenerateHistoricalMetricsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateHistoricalMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateHistoricalMetricsRequest) ProtoMessage() {}

func (x *GenerateHistoricalMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateHistoricalMetricsRequest.ProtoReflect.Descriptor instead.
func (*GenerateHistoricalMetricsRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescGZIP(), []int{20}
}

func (x *GenerateHistoricalMetricsRequest) GetKeywordPlan() string {
	if x != nil {
		return x.KeywordPlan
	}
	return ""
}

// Response message for [KeywordPlanService.GenerateHistoricalMetrics][google.ads.googleads.v5.services.KeywordPlanService.GenerateHistoricalMetrics].
type GenerateHistoricalMetricsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of keyword historical metrics.
	Metrics []*KeywordPlanKeywordHistoricalMetrics `protobuf:"bytes,1,rep,name=metrics,proto3" json:"metrics,omitempty"`
}

func (x *GenerateHistoricalMetricsResponse) Reset() {
	*x = GenerateHistoricalMetricsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateHistoricalMetricsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateHistoricalMetricsResponse) ProtoMessage() {}

func (x *GenerateHistoricalMetricsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateHistoricalMetricsResponse.ProtoReflect.Descriptor instead.
func (*GenerateHistoricalMetricsResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescGZIP(), []int{21}
}

func (x *GenerateHistoricalMetricsResponse) GetMetrics() []*KeywordPlanKeywordHistoricalMetrics {
	if x != nil {
		return x.Metrics
	}
	return nil
}

// A keyword historical metrics.
type KeywordPlanKeywordHistoricalMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The text of the query associated with one or more ad_group_keywords in the
	// plan.
	//
	// Note that we de-dupe your keywords list, eliminating close variants before
	// returning the plan's keywords as text. For example, if your plan originally
	// contained the keywords 'car' and 'cars', the returned search query will
	// only contain 'cars'.
	// Starting V5, the list of de-duped queries will be included in
	// close_variants field.
	SearchQuery *wrapperspb.StringValue `protobuf:"bytes,1,opt,name=search_query,json=searchQuery,proto3" json:"search_query,omitempty"`
	// The list of close variant queries for search_query whose search results
	// are combined into the search_query.
	CloseVariants []string `protobuf:"bytes,3,rep,name=close_variants,json=closeVariants,proto3" json:"close_variants,omitempty"`
	// The historical metrics for the query associated with one or more
	// ad_group_keywords in the plan.
	KeywordMetrics *common.KeywordPlanHistoricalMetrics `protobuf:"bytes,2,opt,name=keyword_metrics,json=keywordMetrics,proto3" json:"keyword_metrics,omitempty"`
}

func (x *KeywordPlanKeywordHistoricalMetrics) Reset() {
	*x = KeywordPlanKeywordHistoricalMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeywordPlanKeywordHistoricalMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeywordPlanKeywordHistoricalMetrics) ProtoMessage() {}

func (x *KeywordPlanKeywordHistoricalMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeywordPlanKeywordHistoricalMetrics.ProtoReflect.Descriptor instead.
func (*KeywordPlanKeywordHistoricalMetrics) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescGZIP(), []int{22}
}

func (x *KeywordPlanKeywordHistoricalMetrics) GetSearchQuery() *wrapperspb.StringValue {
	if x != nil {
		return x.SearchQuery
	}
	return nil
}

func (x *KeywordPlanKeywordHistoricalMetrics) GetCloseVariants() []string {
	if x != nil {
		return x.CloseVariants
	}
	return nil
}

func (x *KeywordPlanKeywordHistoricalMetrics) GetKeywordMetrics() *common.KeywordPlanHistoricalMetrics {
	if x != nil {
		return x.KeywordMetrics
	}
	return nil
}

var File_google_ads_googleads_v5_services_keyword_plan_service_proto protoreflect.FileDescriptor

var file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDesc = []byte{
	0x0a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x35, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2f, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x1a,
	0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x35, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f,
	0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f,
	0x76, 0x35, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x6b, 0x65, 0x79,
	0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63,
	0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x6a, 0x0a,
	0x15, 0x47, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x0c, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xec, 0x01, 0x0a, 0x19, 0x4d, 0x75,
	0x74, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x12, 0x5b, 0x0a,
	0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x46, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x8e, 0x02, 0x0a, 0x14, 0x4b, 0x65, 0x79,
	0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x48,
	0x0a, 0x06, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x48, 0x00,
	0x52, 0x06, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x12, 0x48, 0x0a, 0x06, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x35, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79,
	0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x48, 0x00, 0x52, 0x06, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x12, 0x18, 0x0a, 0x06, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x42, 0x0b, 0x0a, 0x09,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xba, 0x01, 0x0a, 0x1a, 0x4d, 0x75,
	0x74, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x15, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x61, 0x6c, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x13, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x61, 0x6c, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x12, 0x54, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x77, 0x6f,
	0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0x3f, 0x0a, 0x18, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65,
	0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x46, 0x0a, 0x1c, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x43, 0x75, 0x72, 0x76, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x26, 0x0a, 0x0c, 0x6b, 0x65, 0x79, 0x77, 0x6f,
	0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0b, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x22,
	0x9d, 0x01, 0x0a, 0x1d, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x46, 0x6f, 0x72, 0x65,
	0x63, 0x61, 0x73, 0x74, 0x43, 0x75, 0x72, 0x76, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x7c, 0x0a, 0x18, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x66, 0x6f,
	0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x5f, 0x63, 0x75, 0x72, 0x76, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c,
	0x61, 0x6e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61,
	0x73, 0x74, 0x43, 0x75, 0x72, 0x76, 0x65, 0x52, 0x16, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67,
	0x6e, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x43, 0x75, 0x72, 0x76, 0x65, 0x73, 0x22,
	0x4b, 0x0a, 0x21, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x46, 0x6f, 0x72, 0x65, 0x63,
	0x61, 0x73, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x26, 0x0a, 0x0c, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f,
	0x70, 0x6c, 0x61, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0b, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x22, 0xad, 0x01, 0x0a,
	0x22, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x86, 0x01, 0x0a, 0x1c, 0x77, 0x65, 0x65, 0x6b, 0x6c, 0x79, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x5f, 0x66, 0x6f, 0x72, 0x65, 0x63,
	0x61, 0x73, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4b, 0x65,
	0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x57, 0x65, 0x65, 0x6b, 0x6c, 0x79, 0x54,
	0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73,
	0x74, 0x52, 0x19, 0x77, 0x65, 0x65, 0x6b, 0x6c, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x73, 0x22, 0x48, 0x0a, 0x1e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x26,
	0x0a, 0x0c, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6b, 0x65, 0x79, 0x77, 0x6f,
	0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x22, 0xe6, 0x02, 0x0a, 0x1f, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6c, 0x0a, 0x12, 0x63, 0x61,
	0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72,
	0x64, 0x50, 0x6c, 0x61, 0x6e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x46, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x73, 0x74, 0x52, 0x11, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x46,
	0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x73, 0x12, 0x6a, 0x0a, 0x12, 0x61, 0x64, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x5f, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50,
	0x6c, 0x61, 0x6e, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61,
	0x73, 0x74, 0x52, 0x10, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x6f, 0x72, 0x65, 0x63,
	0x61, 0x73, 0x74, 0x73, 0x12, 0x69, 0x0a, 0x11, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f,
	0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x4b, 0x65,
	0x79, 0x77, 0x6f, 0x72, 0x64, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x52, 0x10, 0x6b,
	0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x73, 0x22,
	0xcf, 0x01, 0x0a, 0x1b, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x43,
	0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x12,
	0x50, 0x0a, 0x15, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f,
	0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x6b, 0x65,
	0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67,
	0x6e, 0x12, 0x5e, 0x0a, 0x11, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x66, 0x6f,
	0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e,
	0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52,
	0x10, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73,
	0x74, 0x22, 0xcc, 0x01, 0x0a, 0x1a, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61,
	0x6e, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74,
	0x12, 0x4f, 0x0a, 0x15, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e,
	0x5f, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x12, 0x6b,
	0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x12, 0x5d, 0x0a, 0x11, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x66, 0x6f,
	0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e,
	0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52,
	0x0f, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74,
	0x22, 0xda, 0x01, 0x0a, 0x1a, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e,
	0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x12,
	0x5e, 0x0a, 0x1d, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f,
	0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x19, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61,
	0x6e, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x12,
	0x5c, 0x0a, 0x10, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x65, 0x63,
	0x61, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x46, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x0f, 0x6b, 0x65,
	0x79, 0x77, 0x6f, 0x72, 0x64, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x22, 0xf5, 0x01,
	0x0a, 0x20, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x43, 0x61, 0x6d,
	0x70, 0x61, 0x69, 0x67, 0x6e, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x43, 0x75, 0x72,
	0x76, 0x65, 0x12, 0x50, 0x0a, 0x15, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c,
	0x61, 0x6e, 0x5f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x13, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x43, 0x61, 0x6d, 0x70,
	0x61, 0x69, 0x67, 0x6e, 0x12, 0x7f, 0x0a, 0x1a, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x70, 0x63, 0x5f,
	0x62, 0x69, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x5f, 0x63, 0x75, 0x72,
	0x76, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x35, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79, 0x77,
	0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x4d, 0x61, 0x78, 0x43, 0x70, 0x63, 0x42, 0x69, 0x64,
	0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x43, 0x75, 0x72, 0x76, 0x65, 0x52, 0x16, 0x6d,
	0x61, 0x78, 0x43, 0x70, 0x63, 0x42, 0x69, 0x64, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74,
	0x43, 0x75, 0x72, 0x76, 0x65, 0x22, 0x96, 0x01, 0x0a, 0x21, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72,
	0x64, 0x50, 0x6c, 0x61, 0x6e, 0x4d, 0x61, 0x78, 0x43, 0x70, 0x63, 0x42, 0x69, 0x64, 0x46, 0x6f,
	0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x43, 0x75, 0x72, 0x76, 0x65, 0x12, 0x71, 0x0a, 0x15, 0x6d,
	0x61, 0x78, 0x5f, 0x63, 0x70, 0x63, 0x5f, 0x62, 0x69, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x65, 0x63,
	0x61, 0x73, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4b, 0x65,
	0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x4d, 0x61, 0x78, 0x43, 0x70, 0x63, 0x42,
	0x69, 0x64, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x52, 0x12, 0x6d, 0x61, 0x78, 0x43,
	0x70, 0x63, 0x42, 0x69, 0x64, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x73, 0x22, 0xcc,
	0x01, 0x0a, 0x1c, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x4d, 0x61,
	0x78, 0x43, 0x70, 0x63, 0x42, 0x69, 0x64, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x12,
	0x48, 0x0a, 0x12, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x70, 0x63, 0x5f, 0x62, 0x69, 0x64, 0x5f, 0x6d,
	0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e,
	0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x43, 0x70, 0x63,
	0x42, 0x69, 0x64, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x62, 0x0a, 0x14, 0x6d, 0x61, 0x78,
	0x5f, 0x63, 0x70, 0x63, 0x5f, 0x62, 0x69, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x35, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x46, 0x6f, 0x72, 0x65, 0x63,
	0x61, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x11, 0x6d, 0x61, 0x78, 0x43,
	0x70, 0x63, 0x42, 0x69, 0x64, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x22, 0xe0, 0x01,
	0x0a, 0x23, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x57, 0x65, 0x65,
	0x6b, 0x6c, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x46, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x15, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64,
	0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x13, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50,
	0x6c, 0x61, 0x6e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x66,
	0x0a, 0x10, 0x77, 0x65, 0x65, 0x6b, 0x6c, 0x79, 0x5f, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73,
	0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x35, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79, 0x77,
	0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x57, 0x65, 0x65, 0x6b, 0x6c, 0x79, 0x46, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x73, 0x74, 0x52, 0x0f, 0x77, 0x65, 0x65, 0x6b, 0x6c, 0x79, 0x46, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x73, 0x74, 0x73, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x6b, 0x65, 0x79, 0x77, 0x6f,
	0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e,
	0x22, 0x9d, 0x01, 0x0a, 0x19, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e,
	0x57, 0x65, 0x65, 0x6b, 0x6c, 0x79, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x12, 0x22,
	0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x44, 0x61, 0x74, 0x65, 0x88,
	0x01, 0x01, 0x12, 0x4d, 0x0a, 0x08, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x08, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73,
	0x74, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x65,
	0x22, 0xb3, 0x02, 0x0a, 0x0f, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x12, 0x3e, 0x0a, 0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62,
	0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2e, 0x0a, 0x03, 0x63, 0x74, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x03, 0x63, 0x74, 0x72, 0x12, 0x3c, 0x0a, 0x0b, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f,
	0x63, 0x70, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x43,
	0x70, 0x63, 0x12, 0x34, 0x0a, 0x06, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x06, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x12, 0x3c, 0x0a, 0x0b, 0x63, 0x6f, 0x73, 0x74,
	0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x63, 0x6f, 0x73, 0x74,
	0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x22, 0x4a, 0x0a, 0x20, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x26, 0x0a, 0x0c, 0x6b, 0x65,
	0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c,
	0x61, 0x6e, 0x22, 0x84, 0x01, 0x0a, 0x21, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x48,
	0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5f, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79,
	0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x48,
	0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x22, 0xf4, 0x01, 0x0a, 0x23, 0x4b, 0x65,
	0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64,
	0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x12, 0x3f, 0x0a, 0x0c, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x5f, 0x76, 0x61, 0x72, 0x69,
	0x61, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6c, 0x6f, 0x73,
	0x65, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x12, 0x65, 0x0a, 0x0f, 0x6b, 0x65, 0x79,
	0x77, 0x6f, 0x72, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x48,
	0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x52, 0x0e, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x32, 0xf2, 0x0b, 0x0a, 0x12, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xc1, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x4b,
	0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x47, 0x65,
	0x74, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50,
	0x6c, 0x61, 0x6e, 0x22, 0x46, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f, 0x76, 0x35,
	0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6b, 0x65, 0x79, 0x77,
	0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x0d, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xe6, 0x01, 0x0a, 0x12,
	0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61,
	0x6e, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x77,
	0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64,
	0x50, 0x6c, 0x61, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x55, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x36, 0x22, 0x31, 0x2f, 0x76, 0x35, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x3d, 0x2a, 0x7d, 0x2f, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e,
	0x73, 0x3a, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x16, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x2c, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0xf7, 0x01, 0x0a, 0x15, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x43, 0x75, 0x72, 0x76, 0x65, 0x12, 0x3e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61,
	0x73, 0x74, 0x43, 0x75, 0x72, 0x76, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61,
	0x73, 0x74, 0x43, 0x75, 0x72, 0x76, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x5d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x22, 0x43, 0x2f, 0x76, 0x35, 0x2f, 0x7b, 0x6b, 0x65,
	0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x3d, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c,
	0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x46,
	0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x43, 0x75, 0x72, 0x76, 0x65, 0x3a, 0x01, 0x2a, 0xda,
	0x41, 0x0c, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x12, 0x8b,
	0x02, 0x0a, 0x1a, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x46, 0x6f, 0x72, 0x65, 0x63,
	0x61, 0x73, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x43, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x46, 0x6f,
	0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x62, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d,
	0x22, 0x48, 0x2f, 0x76, 0x35, 0x2f, 0x7b, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70,
	0x6c, 0x61, 0x6e, 0x3d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f,
	0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0c,
	0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x12, 0xff, 0x01, 0x0a,
	0x17, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73,
	0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x35, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5f, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x22, 0x45, 0x2f, 0x76, 0x35, 0x2f, 0x7b, 0x6b, 0x65, 0x79, 0x77,
	0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x3d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x46, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x01, 0x2a, 0xda,
	0x41, 0x0c, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x12, 0x87,
	0x02, 0x0a, 0x19, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f,
	0x72, 0x69, 0x63, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x42, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63,
	0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x48, 0x69, 0x73, 0x74,
	0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4c, 0x22, 0x47, 0x2f,
	0x76, 0x35, 0x2f, 0x7b, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e,
	0x3d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6b, 0x65, 0x79,
	0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0c, 0x6b, 0x65, 0x79, 0x77,
	0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x1a, 0x1b, 0xca, 0x41, 0x18, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x42, 0xfe, 0x01, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x35, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x42, 0x17,
	0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x48, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76,
	0x35, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x3b, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0xa2, 0x02, 0x03, 0x47, 0x41, 0x41, 0xaa, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x41, 0x64, 0x73, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73,
	0x2e, 0x56, 0x35, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0xca, 0x02, 0x20, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x64, 0x73, 0x5c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x41, 0x64, 0x73, 0x5c, 0x56, 0x35, 0x5c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0xea,
	0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x56, 0x35, 0x3a, 0x3a, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescOnce sync.Once
	file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescData = file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDesc
)

func file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescGZIP() []byte {
	file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescOnce.Do(func() {
		file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescData)
	})
	return file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDescData
}

var file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes = make([]protoimpl.MessageInfo, 23)
var file_google_ads_googleads_v5_services_keyword_plan_service_proto_goTypes = []interface{}{
	(*GetKeywordPlanRequest)(nil),               // 0: google.ads.googleads.v5.services.GetKeywordPlanRequest
	(*MutateKeywordPlansRequest)(nil),           // 1: google.ads.googleads.v5.services.MutateKeywordPlansRequest
	(*KeywordPlanOperation)(nil),                // 2: google.ads.googleads.v5.services.KeywordPlanOperation
	(*MutateKeywordPlansResponse)(nil),          // 3: google.ads.googleads.v5.services.MutateKeywordPlansResponse
	(*MutateKeywordPlansResult)(nil),            // 4: google.ads.googleads.v5.services.MutateKeywordPlansResult
	(*GenerateForecastCurveRequest)(nil),        // 5: google.ads.googleads.v5.services.GenerateForecastCurveRequest
	(*GenerateForecastCurveResponse)(nil),       // 6: google.ads.googleads.v5.services.GenerateForecastCurveResponse
	(*GenerateForecastTimeSeriesRequest)(nil),   // 7: google.ads.googleads.v5.services.GenerateForecastTimeSeriesRequest
	(*GenerateForecastTimeSeriesResponse)(nil),  // 8: google.ads.googleads.v5.services.GenerateForecastTimeSeriesResponse
	(*GenerateForecastMetricsRequest)(nil),      // 9: google.ads.googleads.v5.services.GenerateForecastMetricsRequest
	(*GenerateForecastMetricsResponse)(nil),     // 10: google.ads.googleads.v5.services.GenerateForecastMetricsResponse
	(*KeywordPlanCampaignForecast)(nil),         // 11: google.ads.googleads.v5.services.KeywordPlanCampaignForecast
	(*KeywordPlanAdGroupForecast)(nil),          // 12: google.ads.googleads.v5.services.KeywordPlanAdGroupForecast
	(*KeywordPlanKeywordForecast)(nil),          // 13: google.ads.googleads.v5.services.KeywordPlanKeywordForecast
	(*KeywordPlanCampaignForecastCurve)(nil),    // 14: google.ads.googleads.v5.services.KeywordPlanCampaignForecastCurve
	(*KeywordPlanMaxCpcBidForecastCurve)(nil),   // 15: google.ads.googleads.v5.services.KeywordPlanMaxCpcBidForecastCurve
	(*KeywordPlanMaxCpcBidForecast)(nil),        // 16: google.ads.googleads.v5.services.KeywordPlanMaxCpcBidForecast
	(*KeywordPlanWeeklyTimeSeriesForecast)(nil), // 17: google.ads.googleads.v5.services.KeywordPlanWeeklyTimeSeriesForecast
	(*KeywordPlanWeeklyForecast)(nil),           // 18: google.ads.googleads.v5.services.KeywordPlanWeeklyForecast
	(*ForecastMetrics)(nil),                     // 19: google.ads.googleads.v5.services.ForecastMetrics
	(*GenerateHistoricalMetricsRequest)(nil),    // 20: google.ads.googleads.v5.services.GenerateHistoricalMetricsRequest
	(*GenerateHistoricalMetricsResponse)(nil),   // 21: google.ads.googleads.v5.services.GenerateHistoricalMetricsResponse
	(*KeywordPlanKeywordHistoricalMetrics)(nil), // 22: google.ads.googleads.v5.services.KeywordPlanKeywordHistoricalMetrics
	(*fieldmaskpb.FieldMask)(nil),               // 23: google.protobuf.FieldMask
	(*resources.KeywordPlan)(nil),               // 24: google.ads.googleads.v5.resources.KeywordPlan
	(*status.Status)(nil),                       // 25: google.rpc.Status
	(*wrapperspb.StringValue)(nil),              // 26: google.protobuf.StringValue
	(*wrapperspb.Int64Value)(nil),               // 27: google.protobuf.Int64Value
	(*wrapperspb.DoubleValue)(nil),              // 28: google.protobuf.DoubleValue
	(*common.KeywordPlanHistoricalMetrics)(nil), // 29: google.ads.googleads.v5.common.KeywordPlanHistoricalMetrics
}
var file_google_ads_googleads_v5_services_keyword_plan_service_proto_depIdxs = []int32{
	2,  // 0: google.ads.googleads.v5.services.MutateKeywordPlansRequest.operations:type_name -> google.ads.googleads.v5.services.KeywordPlanOperation
	23, // 1: google.ads.googleads.v5.services.KeywordPlanOperation.update_mask:type_name -> google.protobuf.FieldMask
	24, // 2: google.ads.googleads.v5.services.KeywordPlanOperation.create:type_name -> google.ads.googleads.v5.resources.KeywordPlan
	24, // 3: google.ads.googleads.v5.services.KeywordPlanOperation.update:type_name -> google.ads.googleads.v5.resources.KeywordPlan
	25, // 4: google.ads.googleads.v5.services.MutateKeywordPlansResponse.partial_failure_error:type_name -> google.rpc.Status
	4,  // 5: google.ads.googleads.v5.services.MutateKeywordPlansResponse.results:type_name -> google.ads.googleads.v5.services.MutateKeywordPlansResult
	14, // 6: google.ads.googleads.v5.services.GenerateForecastCurveResponse.campaign_forecast_curves:type_name -> google.ads.googleads.v5.services.KeywordPlanCampaignForecastCurve
	17, // 7: google.ads.googleads.v5.services.GenerateForecastTimeSeriesResponse.weekly_time_series_forecasts:type_name -> google.ads.googleads.v5.services.KeywordPlanWeeklyTimeSeriesForecast
	11, // 8: google.ads.googleads.v5.services.GenerateForecastMetricsResponse.campaign_forecasts:type_name -> google.ads.googleads.v5.services.KeywordPlanCampaignForecast
	12, // 9: google.ads.googleads.v5.services.GenerateForecastMetricsResponse.ad_group_forecasts:type_name -> google.ads.googleads.v5.services.KeywordPlanAdGroupForecast
	13, // 10: google.ads.googleads.v5.services.GenerateForecastMetricsResponse.keyword_forecasts:type_name -> google.ads.googleads.v5.services.KeywordPlanKeywordForecast
	26, // 11: google.ads.googleads.v5.services.KeywordPlanCampaignForecast.keyword_plan_campaign:type_name -> google.protobuf.StringValue
	19, // 12: google.ads.googleads.v5.services.KeywordPlanCampaignForecast.campaign_forecast:type_name -> google.ads.googleads.v5.services.ForecastMetrics
	26, // 13: google.ads.googleads.v5.services.KeywordPlanAdGroupForecast.keyword_plan_ad_group:type_name -> google.protobuf.StringValue
	19, // 14: google.ads.googleads.v5.services.KeywordPlanAdGroupForecast.ad_group_forecast:type_name -> google.ads.googleads.v5.services.ForecastMetrics
	26, // 15: google.ads.googleads.v5.services.KeywordPlanKeywordForecast.keyword_plan_ad_group_keyword:type_name -> google.protobuf.StringValue
	19, // 16: google.ads.googleads.v5.services.KeywordPlanKeywordForecast.keyword_forecast:type_name -> google.ads.googleads.v5.services.ForecastMetrics
	26, // 17: google.ads.googleads.v5.services.KeywordPlanCampaignForecastCurve.keyword_plan_campaign:type_name -> google.protobuf.StringValue
	15, // 18: google.ads.googleads.v5.services.KeywordPlanCampaignForecastCurve.max_cpc_bid_forecast_curve:type_name -> google.ads.googleads.v5.services.KeywordPlanMaxCpcBidForecastCurve
	16, // 19: google.ads.googleads.v5.services.KeywordPlanMaxCpcBidForecastCurve.max_cpc_bid_forecasts:type_name -> google.ads.googleads.v5.services.KeywordPlanMaxCpcBidForecast
	27, // 20: google.ads.googleads.v5.services.KeywordPlanMaxCpcBidForecast.max_cpc_bid_micros:type_name -> google.protobuf.Int64Value
	19, // 21: google.ads.googleads.v5.services.KeywordPlanMaxCpcBidForecast.max_cpc_bid_forecast:type_name -> google.ads.googleads.v5.services.ForecastMetrics
	18, // 22: google.ads.googleads.v5.services.KeywordPlanWeeklyTimeSeriesForecast.weekly_forecasts:type_name -> google.ads.googleads.v5.services.KeywordPlanWeeklyForecast
	19, // 23: google.ads.googleads.v5.services.KeywordPlanWeeklyForecast.forecast:type_name -> google.ads.googleads.v5.services.ForecastMetrics
	28, // 24: google.ads.googleads.v5.services.ForecastMetrics.impressions:type_name -> google.protobuf.DoubleValue
	28, // 25: google.ads.googleads.v5.services.ForecastMetrics.ctr:type_name -> google.protobuf.DoubleValue
	27, // 26: google.ads.googleads.v5.services.ForecastMetrics.average_cpc:type_name -> google.protobuf.Int64Value
	28, // 27: google.ads.googleads.v5.services.ForecastMetrics.clicks:type_name -> google.protobuf.DoubleValue
	27, // 28: google.ads.googleads.v5.services.ForecastMetrics.cost_micros:type_name -> google.protobuf.Int64Value
	22, // 29: google.ads.googleads.v5.services.GenerateHistoricalMetricsResponse.metrics:type_name -> google.ads.googleads.v5.services.KeywordPlanKeywordHistoricalMetrics
	26, // 30: google.ads.googleads.v5.services.KeywordPlanKeywordHistoricalMetrics.search_query:type_name -> google.protobuf.StringValue
	29, // 31: google.ads.googleads.v5.services.KeywordPlanKeywordHistoricalMetrics.keyword_metrics:type_name -> google.ads.googleads.v5.common.KeywordPlanHistoricalMetrics
	0,  // 32: google.ads.googleads.v5.services.KeywordPlanService.GetKeywordPlan:input_type -> google.ads.googleads.v5.services.GetKeywordPlanRequest
	1,  // 33: google.ads.googleads.v5.services.KeywordPlanService.MutateKeywordPlans:input_type -> google.ads.googleads.v5.services.MutateKeywordPlansRequest
	5,  // 34: google.ads.googleads.v5.services.KeywordPlanService.GenerateForecastCurve:input_type -> google.ads.googleads.v5.services.GenerateForecastCurveRequest
	7,  // 35: google.ads.googleads.v5.services.KeywordPlanService.GenerateForecastTimeSeries:input_type -> google.ads.googleads.v5.services.GenerateForecastTimeSeriesRequest
	9,  // 36: google.ads.googleads.v5.services.KeywordPlanService.GenerateForecastMetrics:input_type -> google.ads.googleads.v5.services.GenerateForecastMetricsRequest
	20, // 37: google.ads.googleads.v5.services.KeywordPlanService.GenerateHistoricalMetrics:input_type -> google.ads.googleads.v5.services.GenerateHistoricalMetricsRequest
	24, // 38: google.ads.googleads.v5.services.KeywordPlanService.GetKeywordPlan:output_type -> google.ads.googleads.v5.resources.KeywordPlan
	3,  // 39: google.ads.googleads.v5.services.KeywordPlanService.MutateKeywordPlans:output_type -> google.ads.googleads.v5.services.MutateKeywordPlansResponse
	6,  // 40: google.ads.googleads.v5.services.KeywordPlanService.GenerateForecastCurve:output_type -> google.ads.googleads.v5.services.GenerateForecastCurveResponse
	8,  // 41: google.ads.googleads.v5.services.KeywordPlanService.GenerateForecastTimeSeries:output_type -> google.ads.googleads.v5.services.GenerateForecastTimeSeriesResponse
	10, // 42: google.ads.googleads.v5.services.KeywordPlanService.GenerateForecastMetrics:output_type -> google.ads.googleads.v5.services.GenerateForecastMetricsResponse
	21, // 43: google.ads.googleads.v5.services.KeywordPlanService.GenerateHistoricalMetrics:output_type -> google.ads.googleads.v5.services.GenerateHistoricalMetricsResponse
	38, // [38:44] is the sub-list for method output_type
	32, // [32:38] is the sub-list for method input_type
	32, // [32:32] is the sub-list for extension type_name
	32, // [32:32] is the sub-list for extension extendee
	0,  // [0:32] is the sub-list for field type_name
}

func init() { file_google_ads_googleads_v5_services_keyword_plan_service_proto_init() }
func file_google_ads_googleads_v5_services_keyword_plan_service_proto_init() {
	if File_google_ads_googleads_v5_services_keyword_plan_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetKeywordPlanRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MutateKeywordPlansRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeywordPlanOperation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MutateKeywordPlansResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MutateKeywordPlansResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateForecastCurveRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateForecastCurveResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateForecastTimeSeriesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateForecastTimeSeriesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateForecastMetricsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateForecastMetricsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeywordPlanCampaignForecast); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeywordPlanAdGroupForecast); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeywordPlanKeywordForecast); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeywordPlanCampaignForecastCurve); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeywordPlanMaxCpcBidForecastCurve); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeywordPlanMaxCpcBidForecast); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeywordPlanWeeklyTimeSeriesForecast); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeywordPlanWeeklyForecast); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ForecastMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateHistoricalMetricsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateHistoricalMetricsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeywordPlanKeywordHistoricalMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*KeywordPlanOperation_Create)(nil),
		(*KeywordPlanOperation_Update)(nil),
		(*KeywordPlanOperation_Remove)(nil),
	}
	file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[17].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes[18].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_ads_googleads_v5_services_keyword_plan_service_proto_goTypes,
		DependencyIndexes: file_google_ads_googleads_v5_services_keyword_plan_service_proto_depIdxs,
		MessageInfos:      file_google_ads_googleads_v5_services_keyword_plan_service_proto_msgTypes,
	}.Build()
	File_google_ads_googleads_v5_services_keyword_plan_service_proto = out.File
	file_google_ads_googleads_v5_services_keyword_plan_service_proto_rawDesc = nil
	file_google_ads_googleads_v5_services_keyword_plan_service_proto_goTypes = nil
	file_google_ads_googleads_v5_services_keyword_plan_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// KeywordPlanServiceClient is the client API for KeywordPlanService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type KeywordPlanServiceClient interface {
	// Returns the requested plan in full detail.
	GetKeywordPlan(ctx context.Context, in *GetKeywordPlanRequest, opts ...grpc.CallOption) (*resources.KeywordPlan, error)
	// Creates, updates, or removes keyword plans. Operation statuses are
	// returned.
	MutateKeywordPlans(ctx context.Context, in *MutateKeywordPlansRequest, opts ...grpc.CallOption) (*MutateKeywordPlansResponse, error)
	// Returns the requested Keyword Plan forecast curve.
	// Only the bidding strategy is considered for generating forecast curve.
	// The bidding strategy value specified in the plan is ignored.
	//
	// To generate a forecast at a value specified in the plan, use
	// KeywordPlanService.GenerateForecastMetrics.
	GenerateForecastCurve(ctx context.Context, in *GenerateForecastCurveRequest, opts ...grpc.CallOption) (*GenerateForecastCurveResponse, error)
	// Returns a forecast in the form of a time series for the Keyword Plan over
	// the next 52 weeks.
	// (1) Forecasts closer to the current date are generally more accurate than
	// further out.
	//
	// (2) The forecast reflects seasonal trends using current and
	// prior traffic patterns. The forecast period of the plan is ignored.
	GenerateForecastTimeSeries(ctx context.Context, in *GenerateForecastTimeSeriesRequest, opts ...grpc.CallOption) (*GenerateForecastTimeSeriesResponse, error)
	// Returns the requested Keyword Plan forecasts.
	GenerateForecastMetrics(ctx context.Context, in *GenerateForecastMetricsRequest, opts ...grpc.CallOption) (*GenerateForecastMetricsResponse, error)
	// Returns the requested Keyword Plan historical metrics.
	GenerateHistoricalMetrics(ctx context.Context, in *GenerateHistoricalMetricsRequest, opts ...grpc.CallOption) (*GenerateHistoricalMetricsResponse, error)
}

type keywordPlanServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewKeywordPlanServiceClient(cc grpc.ClientConnInterface) KeywordPlanServiceClient {
	return &keywordPlanServiceClient{cc}
}

func (c *keywordPlanServiceClient) GetKeywordPlan(ctx context.Context, in *GetKeywordPlanRequest, opts ...grpc.CallOption) (*resources.KeywordPlan, error) {
	out := new(resources.KeywordPlan)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v5.services.KeywordPlanService/GetKeywordPlan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keywordPlanServiceClient) MutateKeywordPlans(ctx context.Context, in *MutateKeywordPlansRequest, opts ...grpc.CallOption) (*MutateKeywordPlansResponse, error) {
	out := new(MutateKeywordPlansResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v5.services.KeywordPlanService/MutateKeywordPlans", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keywordPlanServiceClient) GenerateForecastCurve(ctx context.Context, in *GenerateForecastCurveRequest, opts ...grpc.CallOption) (*GenerateForecastCurveResponse, error) {
	out := new(GenerateForecastCurveResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v5.services.KeywordPlanService/GenerateForecastCurve", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keywordPlanServiceClient) GenerateForecastTimeSeries(ctx context.Context, in *GenerateForecastTimeSeriesRequest, opts ...grpc.CallOption) (*GenerateForecastTimeSeriesResponse, error) {
	out := new(GenerateForecastTimeSeriesResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v5.services.KeywordPlanService/GenerateForecastTimeSeries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keywordPlanServiceClient) GenerateForecastMetrics(ctx context.Context, in *GenerateForecastMetricsRequest, opts ...grpc.CallOption) (*GenerateForecastMetricsResponse, error) {
	out := new(GenerateForecastMetricsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v5.services.KeywordPlanService/GenerateForecastMetrics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keywordPlanServiceClient) GenerateHistoricalMetrics(ctx context.Context, in *GenerateHistoricalMetricsRequest, opts ...grpc.CallOption) (*GenerateHistoricalMetricsResponse, error) {
	out := new(GenerateHistoricalMetricsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v5.services.KeywordPlanService/GenerateHistoricalMetrics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// KeywordPlanServiceServer is the server API for KeywordPlanService service.
type KeywordPlanServiceServer interface {
	// Returns the requested plan in full detail.
	GetKeywordPlan(context.Context, *GetKeywordPlanRequest) (*resources.KeywordPlan, error)
	// Creates, updates, or removes keyword plans. Operation statuses are
	// returned.
	MutateKeywordPlans(context.Context, *MutateKeywordPlansRequest) (*MutateKeywordPlansResponse, error)
	// Returns the requested Keyword Plan forecast curve.
	// Only the bidding strategy is considered for generating forecast curve.
	// The bidding strategy value specified in the plan is ignored.
	//
	// To generate a forecast at a value specified in the plan, use
	// KeywordPlanService.GenerateForecastMetrics.
	GenerateForecastCurve(context.Context, *GenerateForecastCurveRequest) (*GenerateForecastCurveResponse, error)
	// Returns a forecast in the form of a time series for the Keyword Plan over
	// the next 52 weeks.
	// (1) Forecasts closer to the current date are generally more accurate than
	// further out.
	//
	// (2) The forecast reflects seasonal trends using current and
	// prior traffic patterns. The forecast period of the plan is ignored.
	GenerateForecastTimeSeries(context.Context, *GenerateForecastTimeSeriesRequest) (*GenerateForecastTimeSeriesResponse, error)
	// Returns the requested Keyword Plan forecasts.
	GenerateForecastMetrics(context.Context, *GenerateForecastMetricsRequest) (*GenerateForecastMetricsResponse, error)
	// Returns the requested Keyword Plan historical metrics.
	GenerateHistoricalMetrics(context.Context, *GenerateHistoricalMetricsRequest) (*GenerateHistoricalMetricsResponse, error)
}

// UnimplementedKeywordPlanServiceServer can be embedded to have forward compatible implementations.
type UnimplementedKeywordPlanServiceServer struct {
}

func (*UnimplementedKeywordPlanServiceServer) GetKeywordPlan(context.Context, *GetKeywordPlanRequest) (*resources.KeywordPlan, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetKeywordPlan not implemented")
}
func (*UnimplementedKeywordPlanServiceServer) MutateKeywordPlans(context.Context, *MutateKeywordPlansRequest) (*MutateKeywordPlansResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MutateKeywordPlans not implemented")
}
func (*UnimplementedKeywordPlanServiceServer) GenerateForecastCurve(context.Context, *GenerateForecastCurveRequest) (*GenerateForecastCurveResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GenerateForecastCurve not implemented")
}
func (*UnimplementedKeywordPlanServiceServer) GenerateForecastTimeSeries(context.Context, *GenerateForecastTimeSeriesRequest) (*GenerateForecastTimeSeriesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GenerateForecastTimeSeries not implemented")
}
func (*UnimplementedKeywordPlanServiceServer) GenerateForecastMetrics(context.Context, *GenerateForecastMetricsRequest) (*GenerateForecastMetricsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GenerateForecastMetrics not implemented")
}
func (*UnimplementedKeywordPlanServiceServer) GenerateHistoricalMetrics(context.Context, *GenerateHistoricalMetricsRequest) (*GenerateHistoricalMetricsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GenerateHistoricalMetrics not implemented")
}

func RegisterKeywordPlanServiceServer(s *grpc.Server, srv KeywordPlanServiceServer) {
	s.RegisterService(&_KeywordPlanService_serviceDesc, srv)
}

func _KeywordPlanService_GetKeywordPlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetKeywordPlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeywordPlanServiceServer).GetKeywordPlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v5.services.KeywordPlanService/GetKeywordPlan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeywordPlanServiceServer).GetKeywordPlan(ctx, req.(*GetKeywordPlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeywordPlanService_MutateKeywordPlans_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateKeywordPlansRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeywordPlanServiceServer).MutateKeywordPlans(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v5.services.KeywordPlanService/MutateKeywordPlans",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeywordPlanServiceServer).MutateKeywordPlans(ctx, req.(*MutateKeywordPlansRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeywordPlanService_GenerateForecastCurve_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateForecastCurveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeywordPlanServiceServer).GenerateForecastCurve(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v5.services.KeywordPlanService/GenerateForecastCurve",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeywordPlanServiceServer).GenerateForecastCurve(ctx, req.(*GenerateForecastCurveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeywordPlanService_GenerateForecastTimeSeries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateForecastTimeSeriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeywordPlanServiceServer).GenerateForecastTimeSeries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v5.services.KeywordPlanService/GenerateForecastTimeSeries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeywordPlanServiceServer).GenerateForecastTimeSeries(ctx, req.(*GenerateForecastTimeSeriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeywordPlanService_GenerateForecastMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateForecastMetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeywordPlanServiceServer).GenerateForecastMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v5.services.KeywordPlanService/GenerateForecastMetrics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeywordPlanServiceServer).GenerateForecastMetrics(ctx, req.(*GenerateForecastMetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeywordPlanService_GenerateHistoricalMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateHistoricalMetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeywordPlanServiceServer).GenerateHistoricalMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v5.services.KeywordPlanService/GenerateHistoricalMetrics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeywordPlanServiceServer).GenerateHistoricalMetrics(ctx, req.(*GenerateHistoricalMetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _KeywordPlanService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v5.services.KeywordPlanService",
	HandlerType: (*KeywordPlanServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetKeywordPlan",
			Handler:    _KeywordPlanService_GetKeywordPlan_Handler,
		},
		{
			MethodName: "MutateKeywordPlans",
			Handler:    _KeywordPlanService_MutateKeywordPlans_Handler,
		},
		{
			MethodName: "GenerateForecastCurve",
			Handler:    _KeywordPlanService_GenerateForecastCurve_Handler,
		},
		{
			MethodName: "GenerateForecastTimeSeries",
			Handler:    _KeywordPlanService_GenerateForecastTimeSeries_Handler,
		},
		{
			MethodName: "GenerateForecastMetrics",
			Handler:    _KeywordPlanService_GenerateForecastMetrics_Handler,
		},
		{
			MethodName: "GenerateHistoricalMetrics",
			Handler:    _KeywordPlanService_GenerateHistoricalMetrics_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v5/services/keyword_plan_service.proto",
}
