// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/contentwarehouse/v1/rule_engine.proto

package contentwarehouse

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Rule_TriggerType int32

const (
	Rule_UNKNOWN Rule_TriggerType = 0
	// Trigger for create document action.
	Rule_ON_CREATE Rule_TriggerType = 1
	// Trigger for update document action.
	Rule_ON_UPDATE Rule_TriggerType = 4
)

// Enum value maps for Rule_TriggerType.
var (
	Rule_TriggerType_name = map[int32]string{
		0: "UNKNOWN",
		1: "ON_CREATE",
		4: "ON_UPDATE",
	}
	Rule_TriggerType_value = map[string]int32{
		"UNKNOWN":   0,
		"ON_CREATE": 1,
		"ON_UPDATE": 4,
	}
)

func (x Rule_TriggerType) Enum() *Rule_TriggerType {
	p := new(Rule_TriggerType)
	*p = x
	return p
}

func (x Rule_TriggerType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Rule_TriggerType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contentwarehouse_v1_rule_engine_proto_enumTypes[0].Descriptor()
}

func (Rule_TriggerType) Type() protoreflect.EnumType {
	return &file_google_cloud_contentwarehouse_v1_rule_engine_proto_enumTypes[0]
}

func (x Rule_TriggerType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Rule_TriggerType.Descriptor instead.
func (Rule_TriggerType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDescGZIP(), []int{1, 0}
}

// Type of ACL modification operation.
type AccessControlAction_OperationType int32

const (
	AccessControlAction_UNKNOWN AccessControlAction_OperationType = 0
	// Adds newly given policy bindings in the existing bindings list.
	AccessControlAction_ADD_POLICY_BINDING AccessControlAction_OperationType = 1
	// Removes newly given policy bindings from the existing bindings list.
	AccessControlAction_REMOVE_POLICY_BINDING AccessControlAction_OperationType = 2
	// Replaces existing policy bindings with the given policy binding list
	AccessControlAction_REPLACE_POLICY_BINDING AccessControlAction_OperationType = 3
)

// Enum value maps for AccessControlAction_OperationType.
var (
	AccessControlAction_OperationType_name = map[int32]string{
		0: "UNKNOWN",
		1: "ADD_POLICY_BINDING",
		2: "REMOVE_POLICY_BINDING",
		3: "REPLACE_POLICY_BINDING",
	}
	AccessControlAction_OperationType_value = map[string]int32{
		"UNKNOWN":                0,
		"ADD_POLICY_BINDING":     1,
		"REMOVE_POLICY_BINDING":  2,
		"REPLACE_POLICY_BINDING": 3,
	}
)

func (x AccessControlAction_OperationType) Enum() *AccessControlAction_OperationType {
	p := new(AccessControlAction_OperationType)
	*p = x
	return p
}

func (x AccessControlAction_OperationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AccessControlAction_OperationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contentwarehouse_v1_rule_engine_proto_enumTypes[1].Descriptor()
}

func (AccessControlAction_OperationType) Type() protoreflect.EnumType {
	return &file_google_cloud_contentwarehouse_v1_rule_engine_proto_enumTypes[1]
}

func (x AccessControlAction_OperationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AccessControlAction_OperationType.Descriptor instead.
func (AccessControlAction_OperationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDescGZIP(), []int{3, 0}
}

// Represents execution state of the action.
type ActionOutput_State int32

const (
	ActionOutput_UNKNOWN ActionOutput_State = 0
	// State indicating action executed successfully.
	ActionOutput_ACTION_SUCCEEDED ActionOutput_State = 1
	// State indicating action failed.
	ActionOutput_ACTION_FAILED ActionOutput_State = 2
	// State indicating action timed out.
	ActionOutput_ACTION_TIMED_OUT ActionOutput_State = 3
	// State indicating action is pending.
	ActionOutput_ACTION_PENDING ActionOutput_State = 4
)

// Enum value maps for ActionOutput_State.
var (
	ActionOutput_State_name = map[int32]string{
		0: "UNKNOWN",
		1: "ACTION_SUCCEEDED",
		2: "ACTION_FAILED",
		3: "ACTION_TIMED_OUT",
		4: "ACTION_PENDING",
	}
	ActionOutput_State_value = map[string]int32{
		"UNKNOWN":          0,
		"ACTION_SUCCEEDED": 1,
		"ACTION_FAILED":    2,
		"ACTION_TIMED_OUT": 3,
		"ACTION_PENDING":   4,
	}
)

func (x ActionOutput_State) Enum() *ActionOutput_State {
	p := new(ActionOutput_State)
	*p = x
	return p
}

func (x ActionOutput_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ActionOutput_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contentwarehouse_v1_rule_engine_proto_enumTypes[2].Descriptor()
}

func (ActionOutput_State) Type() protoreflect.EnumType {
	return &file_google_cloud_contentwarehouse_v1_rule_engine_proto_enumTypes[2]
}

func (x ActionOutput_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ActionOutput_State.Descriptor instead.
func (ActionOutput_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDescGZIP(), []int{15, 0}
}

// Represents a set of rules from a single customer.
type RuleSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the rule set. Managed internally.
	// Format:
	// projects/{project_number}/locations/{location}/ruleSet/{rule_set_id}.
	//
	// The name is ignored when creating a rule set.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	// Short description of the rule-set.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// Source of the rules i.e., customer name.
	Source string `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
	// List of rules given by the customer.
	Rules []*Rule `protobuf:"bytes,3,rep,name=rules,proto3" json:"rules,omitempty"`
}

func (x *RuleSet) Reset() {
	*x = RuleSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuleSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuleSet) ProtoMessage() {}

func (x *RuleSet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuleSet.ProtoReflect.Descriptor instead.
func (*RuleSet) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDescGZIP(), []int{0}
}

func (x *RuleSet) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RuleSet) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *RuleSet) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *RuleSet) GetRules() []*Rule {
	if x != nil {
		return x.Rules
	}
	return nil
}

// Represents the rule for a content warehouse trigger.
type Rule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Short description of the rule and its context.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// ID of the rule. It has to be unique across all the examples.
	// This is managed internally.
	RuleId string `protobuf:"bytes,2,opt,name=rule_id,json=ruleId,proto3" json:"rule_id,omitempty"`
	// Identifies the trigger type for running the policy.
	TriggerType Rule_TriggerType `protobuf:"varint,3,opt,name=trigger_type,json=triggerType,proto3,enum=google.cloud.contentwarehouse.v1.Rule_TriggerType" json:"trigger_type,omitempty"`
	// Represents the conditional expression to be evaluated.
	// Expression should evaluate to a boolean result.
	// When the condition is true actions are executed.
	// Example: user_role = "hsbc_role_1" AND doc.salary > 20000
	Condition string `protobuf:"bytes,4,opt,name=condition,proto3" json:"condition,omitempty"`
	// List of actions that are executed when the rule is satisfied.
	Actions []*Action `protobuf:"bytes,5,rep,name=actions,proto3" json:"actions,omitempty"`
}

func (x *Rule) Reset() {
	*x = Rule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rule) ProtoMessage() {}

func (x *Rule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rule.ProtoReflect.Descriptor instead.
func (*Rule) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDescGZIP(), []int{1}
}

func (x *Rule) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Rule) GetRuleId() string {
	if x != nil {
		return x.RuleId
	}
	return ""
}

func (x *Rule) GetTriggerType() Rule_TriggerType {
	if x != nil {
		return x.TriggerType
	}
	return Rule_UNKNOWN
}

func (x *Rule) GetCondition() string {
	if x != nil {
		return x.Condition
	}
	return ""
}

func (x *Rule) GetActions() []*Action {
	if x != nil {
		return x.Actions
	}
	return nil
}

// Represents the action triggered by Rule Engine when the rule is true.
type Action struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the action. Managed internally.
	ActionId string `protobuf:"bytes,1,opt,name=action_id,json=actionId,proto3" json:"action_id,omitempty"`
	// Types that are assignable to Action:
	//
	//	*Action_AccessControl
	//	*Action_DataValidation
	//	*Action_DataUpdate
	//	*Action_AddToFolder
	//	*Action_PublishToPubSub
	//	*Action_RemoveFromFolderAction
	//	*Action_DeleteDocumentAction
	Action isAction_Action `protobuf_oneof:"action"`
}

func (x *Action) Reset() {
	*x = Action{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action) ProtoMessage() {}

func (x *Action) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action.ProtoReflect.Descriptor instead.
func (*Action) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDescGZIP(), []int{2}
}

func (x *Action) GetActionId() string {
	if x != nil {
		return x.ActionId
	}
	return ""
}

func (m *Action) GetAction() isAction_Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (x *Action) GetAccessControl() *AccessControlAction {
	if x, ok := x.GetAction().(*Action_AccessControl); ok {
		return x.AccessControl
	}
	return nil
}

func (x *Action) GetDataValidation() *DataValidationAction {
	if x, ok := x.GetAction().(*Action_DataValidation); ok {
		return x.DataValidation
	}
	return nil
}

func (x *Action) GetDataUpdate() *DataUpdateAction {
	if x, ok := x.GetAction().(*Action_DataUpdate); ok {
		return x.DataUpdate
	}
	return nil
}

func (x *Action) GetAddToFolder() *AddToFolderAction {
	if x, ok := x.GetAction().(*Action_AddToFolder); ok {
		return x.AddToFolder
	}
	return nil
}

func (x *Action) GetPublishToPubSub() *PublishAction {
	if x, ok := x.GetAction().(*Action_PublishToPubSub); ok {
		return x.PublishToPubSub
	}
	return nil
}

func (x *Action) GetRemoveFromFolderAction() *RemoveFromFolderAction {
	if x, ok := x.GetAction().(*Action_RemoveFromFolderAction); ok {
		return x.RemoveFromFolderAction
	}
	return nil
}

func (x *Action) GetDeleteDocumentAction() *DeleteDocumentAction {
	if x, ok := x.GetAction().(*Action_DeleteDocumentAction); ok {
		return x.DeleteDocumentAction
	}
	return nil
}

type isAction_Action interface {
	isAction_Action()
}

type Action_AccessControl struct {
	// Action triggering access control operations.
	AccessControl *AccessControlAction `protobuf:"bytes,2,opt,name=access_control,json=accessControl,proto3,oneof"`
}

type Action_DataValidation struct {
	// Action triggering data validation operations.
	DataValidation *DataValidationAction `protobuf:"bytes,3,opt,name=data_validation,json=dataValidation,proto3,oneof"`
}

type Action_DataUpdate struct {
	// Action triggering data update operations.
	DataUpdate *DataUpdateAction `protobuf:"bytes,4,opt,name=data_update,json=dataUpdate,proto3,oneof"`
}

type Action_AddToFolder struct {
	// Action triggering create document link operation.
	AddToFolder *AddToFolderAction `protobuf:"bytes,5,opt,name=add_to_folder,json=addToFolder,proto3,oneof"`
}

type Action_PublishToPubSub struct {
	// Action publish to Pub/Sub operation.
	PublishToPubSub *PublishAction `protobuf:"bytes,6,opt,name=publish_to_pub_sub,json=publishToPubSub,proto3,oneof"`
}

type Action_RemoveFromFolderAction struct {
	// Action removing a document from a folder.
	RemoveFromFolderAction *RemoveFromFolderAction `protobuf:"bytes,9,opt,name=remove_from_folder_action,json=removeFromFolderAction,proto3,oneof"`
}

type Action_DeleteDocumentAction struct {
	// Action deleting the document.
	DeleteDocumentAction *DeleteDocumentAction `protobuf:"bytes,10,opt,name=delete_document_action,json=deleteDocumentAction,proto3,oneof"`
}

func (*Action_AccessControl) isAction_Action() {}

func (*Action_DataValidation) isAction_Action() {}

func (*Action_DataUpdate) isAction_Action() {}

func (*Action_AddToFolder) isAction_Action() {}

func (*Action_PublishToPubSub) isAction_Action() {}

func (*Action_RemoveFromFolderAction) isAction_Action() {}

func (*Action_DeleteDocumentAction) isAction_Action() {}

// Represents the action responsible for access control list management
// operations.
type AccessControlAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifies the type of operation.
	OperationType AccessControlAction_OperationType `protobuf:"varint,1,opt,name=operation_type,json=operationType,proto3,enum=google.cloud.contentwarehouse.v1.AccessControlAction_OperationType" json:"operation_type,omitempty"`
	// Represents the new policy from which bindings are added, removed or
	// replaced based on the type of the operation. the policy is limited to a few
	// 10s of KB.
	Policy *v1.Policy `protobuf:"bytes,2,opt,name=policy,proto3" json:"policy,omitempty"`
}

func (x *AccessControlAction) Reset() {
	*x = AccessControlAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessControlAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessControlAction) ProtoMessage() {}

func (x *AccessControlAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessControlAction.ProtoReflect.Descriptor instead.
func (*AccessControlAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDescGZIP(), []int{3}
}

func (x *AccessControlAction) GetOperationType() AccessControlAction_OperationType {
	if x != nil {
		return x.OperationType
	}
	return AccessControlAction_UNKNOWN
}

func (x *AccessControlAction) GetPolicy() *v1.Policy {
	if x != nil {
		return x.Policy
	}
	return nil
}

// Represents the action responsible for data validation operations.
type DataValidationAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Map of (K, V) -> (field, string condition to be evaluated on the field)
	// E.g., ("age", "age > 18  && age < 60") entry triggers validation of field
	// age with the given condition. Map entries will be ANDed during validation.
	Conditions map[string]string `protobuf:"bytes,1,rep,name=conditions,proto3" json:"conditions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *DataValidationAction) Reset() {
	*x = DataValidationAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataValidationAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataValidationAction) ProtoMessage() {}

func (x *DataValidationAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataValidationAction.ProtoReflect.Descriptor instead.
func (*DataValidationAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDescGZIP(), []int{4}
}

func (x *DataValidationAction) GetConditions() map[string]string {
	if x != nil {
		return x.Conditions
	}
	return nil
}

// Represents the action responsible for properties update operations.
type DataUpdateAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Map of (K, V) -> (valid name of the field, new value of the field)
	// E.g., ("age", "60") entry triggers update of field age with a value of 60.
	// If the field is not present then new entry is added.
	// During update action execution, value strings will be casted to
	// appropriate types.
	Entries map[string]string `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *DataUpdateAction) Reset() {
	*x = DataUpdateAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataUpdateAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataUpdateAction) ProtoMessage() {}

func (x *DataUpdateAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataUpdateAction.ProtoReflect.Descriptor instead.
func (*DataUpdateAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDescGZIP(), []int{5}
}

func (x *DataUpdateAction) GetEntries() map[string]string {
	if x != nil {
		return x.Entries
	}
	return nil
}

// Represents the action responsible for adding document under a folder.
type AddToFolderAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Names of the folder under which new document is to be added.
	// Format:
	// projects/{project_number}/locations/{location}/documents/{document_id}.
	Folders []string `protobuf:"bytes,1,rep,name=folders,proto3" json:"folders,omitempty"`
}

func (x *AddToFolderAction) Reset() {
	*x = AddToFolderAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddToFolderAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddToFolderAction) ProtoMessage() {}

func (x *AddToFolderAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddToFolderAction.ProtoReflect.Descriptor instead.
func (*AddToFolderAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDescGZIP(), []int{6}
}

func (x *AddToFolderAction) GetFolders() []string {
	if x != nil {
		return x.Folders
	}
	return nil
}

// Represents the action responsible for remove a document from a specific
// folder.
type RemoveFromFolderAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Condition of the action to be executed.
	Condition string `protobuf:"bytes,1,opt,name=condition,proto3" json:"condition,omitempty"`
	// Name of the folder under which new document is to be added.
	// Format:
	// projects/{project_number}/locations/{location}/documents/{document_id}.
	Folder string `protobuf:"bytes,2,opt,name=folder,proto3" json:"folder,omitempty"`
}

func (x *RemoveFromFolderAction) Reset() {
	*x = RemoveFromFolderAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveFromFolderAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveFromFolderAction) ProtoMessage() {}

func (x *RemoveFromFolderAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveFromFolderAction.ProtoReflect.Descriptor instead.
func (*RemoveFromFolderAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDescGZIP(), []int{7}
}

func (x *RemoveFromFolderAction) GetCondition() string {
	if x != nil {
		return x.Condition
	}
	return ""
}

func (x *RemoveFromFolderAction) GetFolder() string {
	if x != nil {
		return x.Folder
	}
	return ""
}

// Represents the action responsible for publishing messages to a Pub/Sub topic.
type PublishAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The topic id in the Pub/Sub service for which messages will be published
	// to.
	TopicId string `protobuf:"bytes,1,opt,name=topic_id,json=topicId,proto3" json:"topic_id,omitempty"`
	// Messages to be published.
	Messages []string `protobuf:"bytes,2,rep,name=messages,proto3" json:"messages,omitempty"`
}

func (x *PublishAction) Reset() {
	*x = PublishAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublishAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublishAction) ProtoMessage() {}

func (x *PublishAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublishAction.ProtoReflect.Descriptor instead.
func (*PublishAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDescGZIP(), []int{8}
}

func (x *PublishAction) GetTopicId() string {
	if x != nil {
		return x.TopicId
	}
	return ""
}

func (x *PublishAction) GetMessages() []string {
	if x != nil {
		return x.Messages
	}
	return nil
}

// Represents the action responsible for deleting the document.
type DeleteDocumentAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Boolean field to select between hard vs soft delete options.
	// Set 'true' for 'hard delete' and 'false' for 'soft delete'.
	EnableHardDelete bool `protobuf:"varint,1,opt,name=enable_hard_delete,json=enableHardDelete,proto3" json:"enable_hard_delete,omitempty"`
}

func (x *DeleteDocumentAction) Reset() {
	*x = DeleteDocumentAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDocumentAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDocumentAction) ProtoMessage() {}

func (x *DeleteDocumentAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDocumentAction.ProtoReflect.Descriptor instead.
func (*DeleteDocumentAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDescGZIP(), []int{9}
}

func (x *DeleteDocumentAction) GetEnableHardDelete() bool {
	if x != nil {
		return x.EnableHardDelete
	}
	return false
}

// Records the output of Rule Engine including rule evaluation and actions
// result.
type RuleEngineOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the document against which the rules and actions were evaluated.
	DocumentName string `protobuf:"bytes,3,opt,name=document_name,json=documentName,proto3" json:"document_name,omitempty"`
	// Output from Rule Evaluator containing matched, unmatched and invalid rules.
	RuleEvaluatorOutput *RuleEvaluatorOutput `protobuf:"bytes,1,opt,name=rule_evaluator_output,json=ruleEvaluatorOutput,proto3" json:"rule_evaluator_output,omitempty"`
	// Output from Action Executor containing rule and corresponding actions
	// execution result.
	ActionExecutorOutput *ActionExecutorOutput `protobuf:"bytes,2,opt,name=action_executor_output,json=actionExecutorOutput,proto3" json:"action_executor_output,omitempty"`
}

func (x *RuleEngineOutput) Reset() {
	*x = RuleEngineOutput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuleEngineOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuleEngineOutput) ProtoMessage() {}

func (x *RuleEngineOutput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuleEngineOutput.ProtoReflect.Descriptor instead.
func (*RuleEngineOutput) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDescGZIP(), []int{10}
}

func (x *RuleEngineOutput) GetDocumentName() string {
	if x != nil {
		return x.DocumentName
	}
	return ""
}

func (x *RuleEngineOutput) GetRuleEvaluatorOutput() *RuleEvaluatorOutput {
	if x != nil {
		return x.RuleEvaluatorOutput
	}
	return nil
}

func (x *RuleEngineOutput) GetActionExecutorOutput() *ActionExecutorOutput {
	if x != nil {
		return x.ActionExecutorOutput
	}
	return nil
}

// Represents the output of the Rule Evaluator.
type RuleEvaluatorOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of rules fetched from database for the given request trigger type.
	TriggeredRules []*Rule `protobuf:"bytes,1,rep,name=triggered_rules,json=triggeredRules,proto3" json:"triggered_rules,omitempty"`
	// A subset of triggered rules that are evaluated true for a given request.
	MatchedRules []*Rule `protobuf:"bytes,2,rep,name=matched_rules,json=matchedRules,proto3" json:"matched_rules,omitempty"`
	// A subset of triggered rules that failed the validation check(s) after
	// parsing.
	InvalidRules []*InvalidRule `protobuf:"bytes,3,rep,name=invalid_rules,json=invalidRules,proto3" json:"invalid_rules,omitempty"`
}

func (x *RuleEvaluatorOutput) Reset() {
	*x = RuleEvaluatorOutput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuleEvaluatorOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuleEvaluatorOutput) ProtoMessage() {}

func (x *RuleEvaluatorOutput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuleEvaluatorOutput.ProtoReflect.Descriptor instead.
func (*RuleEvaluatorOutput) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDescGZIP(), []int{11}
}

func (x *RuleEvaluatorOutput) GetTriggeredRules() []*Rule {
	if x != nil {
		return x.TriggeredRules
	}
	return nil
}

func (x *RuleEvaluatorOutput) GetMatchedRules() []*Rule {
	if x != nil {
		return x.MatchedRules
	}
	return nil
}

func (x *RuleEvaluatorOutput) GetInvalidRules() []*InvalidRule {
	if x != nil {
		return x.InvalidRules
	}
	return nil
}

// A triggered rule that failed the validation check(s) after parsing.
type InvalidRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Triggered rule.
	Rule *Rule `protobuf:"bytes,1,opt,name=rule,proto3" json:"rule,omitempty"`
	// Validation error on a parsed expression.
	Error string `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *InvalidRule) Reset() {
	*x = InvalidRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InvalidRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InvalidRule) ProtoMessage() {}

func (x *InvalidRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InvalidRule.ProtoReflect.Descriptor instead.
func (*InvalidRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDescGZIP(), []int{12}
}

func (x *InvalidRule) GetRule() *Rule {
	if x != nil {
		return x.Rule
	}
	return nil
}

func (x *InvalidRule) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

// Represents the output of the Action Executor.
type ActionExecutorOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of rule and corresponding actions result.
	RuleActionsPairs []*RuleActionsPair `protobuf:"bytes,1,rep,name=rule_actions_pairs,json=ruleActionsPairs,proto3" json:"rule_actions_pairs,omitempty"`
}

func (x *ActionExecutorOutput) Reset() {
	*x = ActionExecutorOutput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionExecutorOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionExecutorOutput) ProtoMessage() {}

func (x *ActionExecutorOutput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionExecutorOutput.ProtoReflect.Descriptor instead.
func (*ActionExecutorOutput) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDescGZIP(), []int{13}
}

func (x *ActionExecutorOutput) GetRuleActionsPairs() []*RuleActionsPair {
	if x != nil {
		return x.RuleActionsPairs
	}
	return nil
}

// Represents a rule and outputs of associated actions.
type RuleActionsPair struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Represents the rule.
	Rule *Rule `protobuf:"bytes,1,opt,name=rule,proto3" json:"rule,omitempty"`
	// Outputs of executing the actions associated with the above rule.
	ActionOutputs []*ActionOutput `protobuf:"bytes,2,rep,name=action_outputs,json=actionOutputs,proto3" json:"action_outputs,omitempty"`
}

func (x *RuleActionsPair) Reset() {
	*x = RuleActionsPair{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuleActionsPair) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuleActionsPair) ProtoMessage() {}

func (x *RuleActionsPair) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuleActionsPair.ProtoReflect.Descriptor instead.
func (*RuleActionsPair) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDescGZIP(), []int{14}
}

func (x *RuleActionsPair) GetRule() *Rule {
	if x != nil {
		return x.Rule
	}
	return nil
}

func (x *RuleActionsPair) GetActionOutputs() []*ActionOutput {
	if x != nil {
		return x.ActionOutputs
	}
	return nil
}

// Represents the result of executing an action.
type ActionOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the action.
	ActionId string `protobuf:"bytes,1,opt,name=action_id,json=actionId,proto3" json:"action_id,omitempty"`
	// State of an action.
	ActionState ActionOutput_State `protobuf:"varint,2,opt,name=action_state,json=actionState,proto3,enum=google.cloud.contentwarehouse.v1.ActionOutput_State" json:"action_state,omitempty"`
	// Action execution output message.
	OutputMessage string `protobuf:"bytes,3,opt,name=output_message,json=outputMessage,proto3" json:"output_message,omitempty"`
}

func (x *ActionOutput) Reset() {
	*x = ActionOutput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionOutput) ProtoMessage() {}

func (x *ActionOutput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionOutput.ProtoReflect.Descriptor instead.
func (*ActionOutput) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDescGZIP(), []int{15}
}

func (x *ActionOutput) GetActionId() string {
	if x != nil {
		return x.ActionId
	}
	return ""
}

func (x *ActionOutput) GetActionState() ActionOutput_State {
	if x != nil {
		return x.ActionState
	}
	return ActionOutput_UNKNOWN
}

func (x *ActionOutput) GetOutputMessage() string {
	if x != nil {
		return x.OutputMessage
	}
	return ""
}

var File_google_cloud_contentwarehouse_v1_rule_engine_proto protoreflect.FileDescriptor

var file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2f,
	0x76, 0x31, 0x2f, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f,
	0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76,
	0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x80,
	0x02, 0x0a, 0x07, 0x52, 0x75, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x16, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x3c, 0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61,
	0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6c, 0x65, 0x52,
	0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x3a, 0x69, 0xea, 0x41, 0x66, 0x0a, 0x27, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x75, 0x6c,
	0x65, 0x53, 0x65, 0x74, 0x12, 0x3b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x75,
	0x6c, 0x65, 0x53, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x74,
	0x7d, 0x22, 0xb4, 0x02, 0x0a, 0x04, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x07,
	0x72, 0x75, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72,
	0x75, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x55, 0x0a, 0x0c, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x75, 0x6c, 0x65, 0x2e, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x0b, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x09,
	0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x07, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x38,
	0x0a, 0x0b, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0b, 0x0a,
	0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x4f, 0x4e,
	0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x4f, 0x4e, 0x5f,
	0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x04, 0x22, 0xeb, 0x05, 0x0a, 0x06, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x12, 0x5e, 0x0a, 0x0e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77,
	0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x0d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x12, 0x61, 0x0a, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x55, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77,
	0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0a,
	0x64, 0x61, 0x74, 0x61, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x59, 0x0a, 0x0d, 0x61, 0x64,
	0x64, 0x5f, 0x74, 0x6f, 0x5f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x54, 0x6f, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0b, 0x61, 0x64, 0x64, 0x54, 0x6f, 0x46,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x12, 0x5e, 0x0a, 0x12, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x5f, 0x74, 0x6f, 0x5f, 0x70, 0x75, 0x62, 0x5f, 0x73, 0x75, 0x62, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x54, 0x6f, 0x50,
	0x75, 0x62, 0x53, 0x75, 0x62, 0x12, 0x75, 0x0a, 0x19, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x5f,
	0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77,
	0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f,
	0x76, 0x65, 0x46, 0x72, 0x6f, 0x6d, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x16, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x46, 0x72, 0x6f, 0x6d,
	0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6e, 0x0a, 0x16,
	0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x14, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x08, 0x0a, 0x06,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9d, 0x02, 0x0a, 0x13, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6a,
	0x0a, 0x0e, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72,
	0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0d, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2d, 0x0a, 0x06, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x6b, 0x0a, 0x0d, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e,
	0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x41, 0x44, 0x44, 0x5f, 0x50,
	0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x42, 0x49, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12,
	0x19, 0x0a, 0x15, 0x52, 0x45, 0x4d, 0x4f, 0x56, 0x45, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59,
	0x5f, 0x42, 0x49, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x1a, 0x0a, 0x16, 0x52, 0x45,
	0x50, 0x4c, 0x41, 0x43, 0x45, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x42, 0x49, 0x4e,
	0x44, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x22, 0xbd, 0x01, 0x0a, 0x14, 0x44, 0x61, 0x74, 0x61, 0x56,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x66, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f,
	0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x63, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x3d, 0x0a, 0x0f, 0x43, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xa9, 0x01, 0x0a, 0x10, 0x44, 0x61, 0x74, 0x61, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x59, 0x0a, 0x07, 0x65,
	0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x65,
	0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x1a, 0x3a, 0x0a, 0x0c, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x5c, 0x0a, 0x11, 0x41, 0x64, 0x64, 0x54, 0x6f, 0x46, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x47, 0x0a, 0x07, 0x66, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2d, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x07, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73,
	0x22, 0x7d, 0x0a, 0x16, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x46, 0x72, 0x6f, 0x6d, 0x46, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x0a, 0x06, 0x66, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x22,
	0x46, 0x0a, 0x0d, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x19, 0x0a, 0x08, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x22, 0x44, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x2c, 0x0a, 0x12, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x68, 0x61, 0x72, 0x64, 0x5f, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x48, 0x61, 0x72, 0x64, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x22, 0x90, 0x02,
	0x0a, 0x10, 0x52, 0x75, 0x6c, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x69, 0x0a, 0x15, 0x72, 0x75, 0x6c, 0x65, 0x5f,
	0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72,
	0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6c, 0x65, 0x45, 0x76,
	0x61, 0x6c, 0x75, 0x61, 0x74, 0x6f, 0x72, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x13, 0x72,
	0x75, 0x6c, 0x65, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x6f, 0x72, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x12, 0x6c, 0x0a, 0x16, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x6f, 0x72, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75,
	0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x6f, 0x72, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x14, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x22, 0x87, 0x02, 0x0a, 0x13, 0x52, 0x75, 0x6c, 0x65, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74,
	0x6f, 0x72, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x4f, 0x0a, 0x0f, 0x74, 0x72, 0x69, 0x67,
	0x67, 0x65, 0x72, 0x65, 0x64, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x0e, 0x74, 0x72, 0x69, 0x67, 0x67,
	0x65, 0x72, 0x65, 0x64, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x4b, 0x0a, 0x0d, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x64, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x0c, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65,
	0x64, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x52, 0x0a, 0x0d, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x0c, 0x69, 0x6e,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x22, 0x5f, 0x0a, 0x0b, 0x49, 0x6e,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x3a, 0x0a, 0x04, 0x72, 0x75, 0x6c,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61,
	0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6c, 0x65, 0x52,
	0x04, 0x72, 0x75, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x77, 0x0a, 0x14, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x12, 0x5f, 0x0a, 0x12, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x5f, 0x70, 0x61, 0x69, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x75, 0x6c, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x50, 0x61,
	0x69, 0x72, 0x52, 0x10, 0x72, 0x75, 0x6c, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x50,
	0x61, 0x69, 0x72, 0x73, 0x22, 0xa4, 0x01, 0x0a, 0x0f, 0x52, 0x75, 0x6c, 0x65, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x50, 0x61, 0x69, 0x72, 0x12, 0x3a, 0x0a, 0x04, 0x72, 0x75, 0x6c, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72,
	0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x04,
	0x72, 0x75, 0x6c, 0x65, 0x12, 0x55, 0x0a, 0x0e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x0d, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x22, 0x94, 0x02, 0x0a, 0x0c,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x57, 0x0a, 0x0c, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0b, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x67, 0x0a, 0x05, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12,
	0x14, 0x0a, 0x10, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45,
	0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x41, 0x43, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x44, 0x5f, 0x4f, 0x55, 0x54, 0x10, 0x03, 0x12, 0x12,
	0x0a, 0x0e, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47,
	0x10, 0x04, 0x42, 0x8b, 0x01, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77,
	0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x0f, 0x52, 0x75, 0x6c,
	0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x50,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72,
	0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2f, 0x76, 0x31, 0x3b,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDescOnce sync.Once
	file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDescData = file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDesc
)

func file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDescGZIP() []byte {
	file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDescOnce.Do(func() {
		file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDescData)
	})
	return file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDescData
}

var file_google_cloud_contentwarehouse_v1_rule_engine_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_google_cloud_contentwarehouse_v1_rule_engine_proto_goTypes = []interface{}{
	(Rule_TriggerType)(0),                  // 0: google.cloud.contentwarehouse.v1.Rule.TriggerType
	(AccessControlAction_OperationType)(0), // 1: google.cloud.contentwarehouse.v1.AccessControlAction.OperationType
	(ActionOutput_State)(0),                // 2: google.cloud.contentwarehouse.v1.ActionOutput.State
	(*RuleSet)(nil),                        // 3: google.cloud.contentwarehouse.v1.RuleSet
	(*Rule)(nil),                           // 4: google.cloud.contentwarehouse.v1.Rule
	(*Action)(nil),                         // 5: google.cloud.contentwarehouse.v1.Action
	(*AccessControlAction)(nil),            // 6: google.cloud.contentwarehouse.v1.AccessControlAction
	(*DataValidationAction)(nil),           // 7: google.cloud.contentwarehouse.v1.DataValidationAction
	(*DataUpdateAction)(nil),               // 8: google.cloud.contentwarehouse.v1.DataUpdateAction
	(*AddToFolderAction)(nil),              // 9: google.cloud.contentwarehouse.v1.AddToFolderAction
	(*RemoveFromFolderAction)(nil),         // 10: google.cloud.contentwarehouse.v1.RemoveFromFolderAction
	(*PublishAction)(nil),                  // 11: google.cloud.contentwarehouse.v1.PublishAction
	(*DeleteDocumentAction)(nil),           // 12: google.cloud.contentwarehouse.v1.DeleteDocumentAction
	(*RuleEngineOutput)(nil),               // 13: google.cloud.contentwarehouse.v1.RuleEngineOutput
	(*RuleEvaluatorOutput)(nil),            // 14: google.cloud.contentwarehouse.v1.RuleEvaluatorOutput
	(*InvalidRule)(nil),                    // 15: google.cloud.contentwarehouse.v1.InvalidRule
	(*ActionExecutorOutput)(nil),           // 16: google.cloud.contentwarehouse.v1.ActionExecutorOutput
	(*RuleActionsPair)(nil),                // 17: google.cloud.contentwarehouse.v1.RuleActionsPair
	(*ActionOutput)(nil),                   // 18: google.cloud.contentwarehouse.v1.ActionOutput
	nil,                                    // 19: google.cloud.contentwarehouse.v1.DataValidationAction.ConditionsEntry
	nil,                                    // 20: google.cloud.contentwarehouse.v1.DataUpdateAction.EntriesEntry
	(*v1.Policy)(nil),                      // 21: google.iam.v1.Policy
}
var file_google_cloud_contentwarehouse_v1_rule_engine_proto_depIdxs = []int32{
	4,  // 0: google.cloud.contentwarehouse.v1.RuleSet.rules:type_name -> google.cloud.contentwarehouse.v1.Rule
	0,  // 1: google.cloud.contentwarehouse.v1.Rule.trigger_type:type_name -> google.cloud.contentwarehouse.v1.Rule.TriggerType
	5,  // 2: google.cloud.contentwarehouse.v1.Rule.actions:type_name -> google.cloud.contentwarehouse.v1.Action
	6,  // 3: google.cloud.contentwarehouse.v1.Action.access_control:type_name -> google.cloud.contentwarehouse.v1.AccessControlAction
	7,  // 4: google.cloud.contentwarehouse.v1.Action.data_validation:type_name -> google.cloud.contentwarehouse.v1.DataValidationAction
	8,  // 5: google.cloud.contentwarehouse.v1.Action.data_update:type_name -> google.cloud.contentwarehouse.v1.DataUpdateAction
	9,  // 6: google.cloud.contentwarehouse.v1.Action.add_to_folder:type_name -> google.cloud.contentwarehouse.v1.AddToFolderAction
	11, // 7: google.cloud.contentwarehouse.v1.Action.publish_to_pub_sub:type_name -> google.cloud.contentwarehouse.v1.PublishAction
	10, // 8: google.cloud.contentwarehouse.v1.Action.remove_from_folder_action:type_name -> google.cloud.contentwarehouse.v1.RemoveFromFolderAction
	12, // 9: google.cloud.contentwarehouse.v1.Action.delete_document_action:type_name -> google.cloud.contentwarehouse.v1.DeleteDocumentAction
	1,  // 10: google.cloud.contentwarehouse.v1.AccessControlAction.operation_type:type_name -> google.cloud.contentwarehouse.v1.AccessControlAction.OperationType
	21, // 11: google.cloud.contentwarehouse.v1.AccessControlAction.policy:type_name -> google.iam.v1.Policy
	19, // 12: google.cloud.contentwarehouse.v1.DataValidationAction.conditions:type_name -> google.cloud.contentwarehouse.v1.DataValidationAction.ConditionsEntry
	20, // 13: google.cloud.contentwarehouse.v1.DataUpdateAction.entries:type_name -> google.cloud.contentwarehouse.v1.DataUpdateAction.EntriesEntry
	14, // 14: google.cloud.contentwarehouse.v1.RuleEngineOutput.rule_evaluator_output:type_name -> google.cloud.contentwarehouse.v1.RuleEvaluatorOutput
	16, // 15: google.cloud.contentwarehouse.v1.RuleEngineOutput.action_executor_output:type_name -> google.cloud.contentwarehouse.v1.ActionExecutorOutput
	4,  // 16: google.cloud.contentwarehouse.v1.RuleEvaluatorOutput.triggered_rules:type_name -> google.cloud.contentwarehouse.v1.Rule
	4,  // 17: google.cloud.contentwarehouse.v1.RuleEvaluatorOutput.matched_rules:type_name -> google.cloud.contentwarehouse.v1.Rule
	15, // 18: google.cloud.contentwarehouse.v1.RuleEvaluatorOutput.invalid_rules:type_name -> google.cloud.contentwarehouse.v1.InvalidRule
	4,  // 19: google.cloud.contentwarehouse.v1.InvalidRule.rule:type_name -> google.cloud.contentwarehouse.v1.Rule
	17, // 20: google.cloud.contentwarehouse.v1.ActionExecutorOutput.rule_actions_pairs:type_name -> google.cloud.contentwarehouse.v1.RuleActionsPair
	4,  // 21: google.cloud.contentwarehouse.v1.RuleActionsPair.rule:type_name -> google.cloud.contentwarehouse.v1.Rule
	18, // 22: google.cloud.contentwarehouse.v1.RuleActionsPair.action_outputs:type_name -> google.cloud.contentwarehouse.v1.ActionOutput
	2,  // 23: google.cloud.contentwarehouse.v1.ActionOutput.action_state:type_name -> google.cloud.contentwarehouse.v1.ActionOutput.State
	24, // [24:24] is the sub-list for method output_type
	24, // [24:24] is the sub-list for method input_type
	24, // [24:24] is the sub-list for extension type_name
	24, // [24:24] is the sub-list for extension extendee
	0,  // [0:24] is the sub-list for field type_name
}

func init() { file_google_cloud_contentwarehouse_v1_rule_engine_proto_init() }
func file_google_cloud_contentwarehouse_v1_rule_engine_proto_init() {
	if File_google_cloud_contentwarehouse_v1_rule_engine_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuleSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Rule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessControlAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataValidationAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataUpdateAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddToFolderAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveFromFolderAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublishAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDocumentAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuleEngineOutput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuleEvaluatorOutput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InvalidRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionExecutorOutput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuleActionsPair); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionOutput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*Action_AccessControl)(nil),
		(*Action_DataValidation)(nil),
		(*Action_DataUpdate)(nil),
		(*Action_AddToFolder)(nil),
		(*Action_PublishToPubSub)(nil),
		(*Action_RemoveFromFolderAction)(nil),
		(*Action_DeleteDocumentAction)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_contentwarehouse_v1_rule_engine_proto_goTypes,
		DependencyIndexes: file_google_cloud_contentwarehouse_v1_rule_engine_proto_depIdxs,
		EnumInfos:         file_google_cloud_contentwarehouse_v1_rule_engine_proto_enumTypes,
		MessageInfos:      file_google_cloud_contentwarehouse_v1_rule_engine_proto_msgTypes,
	}.Build()
	File_google_cloud_contentwarehouse_v1_rule_engine_proto = out.File
	file_google_cloud_contentwarehouse_v1_rule_engine_proto_rawDesc = nil
	file_google_cloud_contentwarehouse_v1_rule_engine_proto_goTypes = nil
	file_google_cloud_contentwarehouse_v1_rule_engine_proto_depIdxs = nil
}
