// Copyright 2009 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

//go:build ignore
// +build ignore

/*
Input to cgo -godefs.  See README.md
*/

// +godefs map struct_in_addr [4]byte /* in_addr */
// +godefs map struct_in6_addr [16]byte /* in6_addr */

package unix

/*
#define _LARGEFILE_SOURCE
#define _LARGEFILE64_SOURCE
#define _FILE_OFFSET_BITS 64
#define _GNU_SOURCE

#include <dirent.h>
#include <poll.h>
#include <sched.h>
#include <signal.h>
#include <stdio.h>
#include <time.h>
#include <unistd.h>
#include <utime.h>

#include <netinet/in.h>
#include <netinet/tcp.h>

#include <sys/epoll.h>
#include <sys/inotify.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <sys/mount.h>
#include <sys/param.h>
#include <sys/ptrace.h>
#include <sys/resource.h>
#include <sys/select.h>
#include <sys/signal.h>
#include <sys/signalfd.h>
#include <sys/statfs.h>
#include <sys/statvfs.h>
#include <sys/sysinfo.h>
#include <sys/time.h>
#include <sys/timerfd.h>
#include <sys/times.h>
#include <sys/timex.h>
#include <sys/un.h>
#include <sys/user.h>
#include <sys/utsname.h>
#include <sys/wait.h>

#if defined(__sparc__)
// On sparc{,64}, the kernel defines struct termios2 itself which clashes with the
// definition in glibc. Duplicate the kernel version here.
#if defined(__arch64__)
typedef unsigned int tcflag_t;
#else
typedef unsigned long tcflag_t;
#endif

struct termios2 {
	tcflag_t c_iflag;
	tcflag_t c_oflag;
	tcflag_t c_cflag;
	tcflag_t c_lflag;
	unsigned char c_line;
	unsigned char c_cc[19];
	unsigned int c_ispeed;
	unsigned int c_ospeed;
};
#else
#include <asm/termbits.h>
#endif
#include <asm/ptrace.h>

#include <linux/blkpg.h>
#include <linux/bpf.h>
#include <linux/can.h>
#include <linux/can/netlink.h>
#include <linux/can/raw.h>
#include <linux/capability.h>
#include <linux/cgroupstats.h>
#include <linux/close_range.h>
#include <linux/cryptouser.h>
#include <linux/devlink.h>
#include <linux/dm-ioctl.h>
#include <linux/errqueue.h>
#include <linux/ethtool.h>
#include <linux/ethtool_netlink.h>
#include <linux/fanotify.h>
#include <linux/fib_rules.h>
#include <linux/filter.h>
#include <linux/fs.h>
#include <linux/fsverity.h>
#include <linux/genetlink.h>
#include <linux/hdreg.h>
#include <linux/hidraw.h>
#include <linux/icmp.h>
#include <linux/icmpv6.h>
#include <linux/if_alg.h>
#include <linux/if_bridge.h>
#include <linux/if_packet.h>
#include <linux/if_pppox.h>
#include <linux/if_xdp.h>
#include <linux/ipc.h>
#include <linux/kcm.h>
#include <linux/keyctl.h>
#include <linux/landlock.h>
#include <linux/loop.h>
#include <linux/lwtunnel.h>
#include <linux/mpls_iptunnel.h>
#include <linux/ncsi.h>
#include <linux/net_namespace.h>
#include <linux/net_tstamp.h>
#include <linux/netfilter/nf_tables.h>
#include <linux/netfilter/nf_tables_compat.h>
#include <linux/netfilter/nfnetlink.h>
#include <linux/netfilter.h>
#include <linux/netfilter_ipv4.h>
#include <linux/netlink.h>
#include <linux/nexthop.h>
#include <linux/nfc.h>
#include <linux/nl80211.h>
#include <linux/openat2.h>
#include <linux/perf_event.h>
#include <linux/pps.h>
#include <linux/random.h>
#include <linux/rtc.h>
#include <linux/rtnetlink.h>
#include <linux/shm.h>
#include <linux/socket.h>
#include <linux/stat.h>
#include <linux/taskstats.h>
#include <linux/tipc.h>
#include <linux/watchdog.h>
#include <linux/wireguard.h>
#include <linux/vm_sockets.h>

#include <mtd/mtd-user.h>

// abi/abi.h generated by mkall.go.
#include "abi/abi.h"

// On mips64, the glibc stat and kernel stat do not agree
#if (defined(__mips__) && _MIPS_SIM == _MIPS_SIM_ABI64)

// Use the stat defined by the kernel with a few modifications. These are:
//	* The time fields (like st_atime and st_atimensec) use the timespec
//	  struct (like st_atim) for consistency with the glibc fields.
//	* The padding fields get different names to not break compatibility.
//	* st_blocks is signed, again for compatibility.
struct stat {
	unsigned int		st_dev;
	unsigned int		st_pad1[3]; // Reserved for st_dev expansion

	unsigned long		st_ino;

	mode_t			st_mode;
	__u32			st_nlink;

	uid_t			st_uid;
	gid_t			st_gid;

	unsigned int		st_rdev;
	unsigned int		st_pad2[3]; // Reserved for st_rdev expansion

	off_t			st_size;

	// These are declared as separate fields in the kernel. Here we use
	// the timespec struct for consistency with the other stat structs.
	struct timespec		st_atim;
	struct timespec		st_mtim;
	struct timespec		st_ctim;

	unsigned int		st_blksize;
	unsigned int		st_pad4;

	long			st_blocks;
};

// These are needed because we do not include fcntl.h or sys/types.h
#include <linux/fcntl.h>
#include <linux/fadvise.h>

#else

// Use the stat defined by glibc
#include <fcntl.h>
#include <sys/types.h>

#endif

// These are defined in linux/fcntl.h, but including it globally causes
// conflicts with fcntl.h
#ifndef AT_STATX_SYNC_TYPE
# define AT_STATX_SYNC_TYPE	0x6000	// Type of synchronisation required from statx()
#endif
#ifndef AT_STATX_SYNC_AS_STAT
# define AT_STATX_SYNC_AS_STAT	0x0000	// - Do whatever stat() does
#endif
#ifndef AT_STATX_FORCE_SYNC
# define AT_STATX_FORCE_SYNC	0x2000	// - Force the attributes to be sync'd with the server
#endif
#ifndef AT_STATX_DONT_SYNC
# define AT_STATX_DONT_SYNC	0x4000	// - Don't sync attributes with the server
#endif

#ifndef AT_EACCESS
# define AT_EACCESS		0x200	// Test access permitted for effective IDs, not real IDs.
#endif

#ifdef TCSETS2
// On systems that have "struct termios2" use this as type Termios.
typedef struct termios2 termios_t;
#else
typedef struct termios termios_t;
#endif

enum {
	sizeofPtr = sizeof(void*),
};

union sockaddr_all {
	struct sockaddr s1;	// this one gets used for fields
	struct sockaddr_in s2;	// these pad it out
	struct sockaddr_in6 s3;
	struct sockaddr_un s4;
	struct sockaddr_ll s5;
	struct sockaddr_nl s6;
	struct sockaddr_pppox s7;
	struct sockaddr_l2tpip s8;
	struct sockaddr_l2tpip6 s9;
	struct sockaddr_nfc s10;
	struct sockaddr_nfc_llcp s11;
};

struct sockaddr_any {
	struct sockaddr addr;
	char pad[sizeof(union sockaddr_all) - sizeof(struct sockaddr)];
};

// copied from /usr/include/bluetooth/hci.h
struct sockaddr_hci {
        sa_family_t     hci_family;
        unsigned short  hci_dev;
        unsigned short  hci_channel;
};

// copied from /usr/include/bluetooth/bluetooth.h
#define BDADDR_BREDR           0x00
#define BDADDR_LE_PUBLIC       0x01
#define BDADDR_LE_RANDOM       0x02

// copied from /usr/include/bluetooth/l2cap.h
struct sockaddr_l2 {
	sa_family_t	l2_family;
	unsigned short	l2_psm;
	uint8_t		l2_bdaddr[6];
	unsigned short	l2_cid;
	uint8_t		l2_bdaddr_type;
};

// copied from /usr/include/net/bluetooth/rfcomm.h
struct sockaddr_rc {
	sa_family_t rc_family;
	uint8_t     rc_bdaddr[6];
	uint8_t     rc_channel;
};

// copied from /usr/include/linux/un.h
struct my_sockaddr_un {
	sa_family_t sun_family;
#if defined(__ARM_EABI__) || defined(__powerpc__) || defined(__powerpc64__) || defined(__riscv)
	// on some platforms char is unsigned by default
	signed char sun_path[108];
#else
	char sun_path[108];
#endif
};

// copied from /usr/include/netiucv/iucv.h modified with explicit signed chars.
struct sockaddr_iucv {
	sa_family_t siucv_family;
	unsigned short siucv_port;
	unsigned int siucv_addr;
	signed char siucv_nodeid[8];
	signed char siucv_user_id[8];
	signed char siucv_name[8];
};

// copied from /usr/include/linux/nfc.h modified with explicit unsigned chars.
struct my_sockaddr_nfc_llcp {
	sa_family_t sa_family;
	uint32_t dev_idx;
	uint32_t target_idx;
	uint32_t nfc_protocol;
	uint8_t dsap;
	uint8_t ssap;
	uint8_t service_name[NFC_LLCP_MAX_SERVICE_NAME];
	size_t service_name_len;
};

#ifdef __ARM_EABI__
typedef struct user_regs PtraceRegs;
#elif defined(__aarch64__) || defined(__loongarch64)
typedef struct user_pt_regs PtraceRegs;
#elif defined(__mips__) || defined(__powerpc__) || defined(__powerpc64__)
typedef struct pt_regs PtraceRegs;
#elif defined(__s390x__)
typedef struct _user_regs_struct PtraceRegs;
#elif defined(__sparc__)
#include <asm/ptrace.h>
typedef struct pt_regs PtraceRegs;
#else
typedef struct user_regs_struct PtraceRegs;
#endif

#if defined(__s390x__)
typedef struct _user_psw_struct ptracePsw;
typedef struct _user_fpregs_struct ptraceFpregs;
typedef struct _user_per_struct ptracePer;
#else
typedef struct {} ptracePsw;
typedef struct {} ptraceFpregs;
typedef struct {} ptracePer;
#endif

// The real epoll_event is a union, and godefs doesn't handle it well.
struct my_epoll_event {
	uint32_t events;
#if defined(__ARM_EABI__) || defined(__aarch64__) || (defined(__mips__) && _MIPS_SIM == _ABIO32)
	// padding is not specified in linux/eventpoll.h but added to conform to the
	// alignment requirements of EABI
	int32_t padFd;
#elif defined(__powerpc__) || defined(__powerpc64__) || defined(__s390x__) || defined(__sparc__) \
		|| defined(__riscv) || (defined(__mips__) && _MIPS_SIM == _MIPS_SIM_ABI64) \
		|| defined(__loongarch64)
	int32_t _padFd;
#endif
	int32_t fd;
	int32_t pad;
};

// Copied from <linux/perf_event.h> with the following modifications:
// 1) bit field after read_format redeclared as '__u64 bits' to make it
//    accessible from Go
// 2) collapsed the unions, to avoid confusing godoc for the generated output
//    (e.g. having to use BpAddr as an extension of Config)
struct perf_event_attr_go {
	__u32 type;

	__u32 size;
	__u64 config;

	// union {
	//   __u64 sample_period;
	//   __u64 sample_freq;
	// };
	__u64 sample;

	__u64 sample_type;
	__u64 read_format;

	// Replaces the bit field. Flags are defined as constants.
	__u64 bits;

	// union {
	//   __u32 wakeup_events;
	//   __u32 wakeup_watermark;
	// };
	__u32 wakeup;

	__u32 bp_type;

	// union {
	//   __u64 bp_addr;
	//   __u64 config1;
	// };
	__u64 ext1;

	// union {
	//   __u64 bp_len;
	//   __u64 config2;
	// };
	__u64 ext2;

	__u64 branch_sample_type;

	__u64 sample_regs_user;

	__u32 sample_stack_user;

	__s32 clockid;
	__u64 sample_regs_intr;
	__u32 aux_watermark;
	__u16 sample_max_stack;
	__u16 __reserved_2;
};

// ustat is deprecated and glibc 2.28 removed ustat.h. Provide the type here for
// backwards compatibility. Copied from /usr/include/bits/ustat.h
struct ustat {
	__daddr_t f_tfree;
	__ino_t f_tinode;
	char f_fname[6];
	char f_fpack[6];
};

// my_blkpg_partition is blkpg_partition with unsigned devname & volname.
struct my_blkpg_partition {
	long long start;
	long long length;
	int pno;
	unsigned char devname[BLKPG_DEVNAMELTH];
	unsigned char volname[BLKPG_VOLNAMELTH];
};

// tipc_service_name is a copied and slightly modified form of the "name"
// variant in sockaddr_tipc's union in tipc.h, so it can be exported as part of
// SockaddrTIPC's API.
struct tipc_service_name {
	// From tipc_service_addr.
	__u32 type;
	__u32 instance;
	// From the union.
	__u32 domain;
};

// copied from /usr/include/linux/can/netlink.h modified with explicit unsigned chars.
struct my_can_bittiming_const {
	uint8_t name[16];
	__u32 tseg1_min;
	__u32 tseg1_max;
	__u32 tseg2_min;
	__u32 tseg2_max;
	__u32 sjw_max;
	__u32 brp_min;
	__u32 brp_max;
	__u32 brp_inc;
};
*/
import "C"

// Machine characteristics

const (
	SizeofPtr      = C.sizeofPtr
	SizeofShort    = C.sizeof_short
	SizeofInt      = C.sizeof_int
	SizeofLong     = C.sizeof_long
	SizeofLongLong = C.sizeof_longlong
	PathMax        = C.PATH_MAX
)

// Basic types

type (
	_C_short     C.short
	_C_int       C.int
	_C_long      C.long
	_C_long_long C.longlong
)

// Time

type Timespec C.struct_timespec

type Timeval C.struct_timeval

type Timex C.struct_timex

type ItimerSpec C.struct_itimerspec

type Itimerval C.struct_itimerval

const (
	TIME_OK    = C.TIME_OK
	TIME_INS   = C.TIME_INS
	TIME_DEL   = C.TIME_DEL
	TIME_OOP   = C.TIME_OOP
	TIME_WAIT  = C.TIME_WAIT
	TIME_ERROR = C.TIME_ERROR
	TIME_BAD   = C.TIME_BAD
)

type Time_t C.time_t

type Tms C.struct_tms

type Utimbuf C.struct_utimbuf

// Processes

type Rusage C.struct_rusage

type Rlimit C.struct_rlimit

type _Gid_t C.gid_t

// Files

type Stat_t C.struct_stat

type StatxTimestamp C.struct_statx_timestamp

type Statx_t C.struct_statx

type Dirent C.struct_dirent

type Fsid C.fsid_t

type Flock_t C.struct_flock

type FileCloneRange C.struct_file_clone_range

type RawFileDedupeRange C.struct_file_dedupe_range

type RawFileDedupeRangeInfo C.struct_file_dedupe_range_info

const (
	SizeofRawFileDedupeRange     = C.sizeof_struct_file_dedupe_range
	SizeofRawFileDedupeRangeInfo = C.sizeof_struct_file_dedupe_range_info
	FILE_DEDUPE_RANGE_SAME       = C.FILE_DEDUPE_RANGE_SAME
	FILE_DEDUPE_RANGE_DIFFERS    = C.FILE_DEDUPE_RANGE_DIFFERS
)

// Filesystem Encryption

type FscryptPolicy C.struct_fscrypt_policy

type FscryptKey C.struct_fscrypt_key

type FscryptPolicyV1 C.struct_fscrypt_policy_v1

type FscryptPolicyV2 C.struct_fscrypt_policy_v2

type FscryptGetPolicyExArg C.struct_fscrypt_get_policy_ex_arg

type FscryptKeySpecifier C.struct_fscrypt_key_specifier

type FscryptAddKeyArg C.struct_fscrypt_add_key_arg

type FscryptRemoveKeyArg C.struct_fscrypt_remove_key_arg

type FscryptGetKeyStatusArg C.struct_fscrypt_get_key_status_arg

// Device Mapper

type DmIoctl C.struct_dm_ioctl

type DmTargetSpec C.struct_dm_target_spec

type DmTargetDeps C.struct_dm_target_deps

type DmNameList C.struct_dm_name_list

type DmTargetVersions C.struct_dm_target_versions

type DmTargetMsg C.struct_dm_target_msg

const (
	SizeofDmIoctl      = C.sizeof_struct_dm_ioctl
	SizeofDmTargetSpec = C.sizeof_struct_dm_target_spec
)

// Structure for Keyctl

type KeyctlDHParams C.struct_keyctl_dh_params

// Advice to Fadvise

const (
	FADV_NORMAL     = C.POSIX_FADV_NORMAL
	FADV_RANDOM     = C.POSIX_FADV_RANDOM
	FADV_SEQUENTIAL = C.POSIX_FADV_SEQUENTIAL
	FADV_WILLNEED   = C.POSIX_FADV_WILLNEED
	FADV_DONTNEED   = C.POSIX_FADV_DONTNEED
	FADV_NOREUSE    = C.POSIX_FADV_NOREUSE
)

// Sockets

type RawSockaddrInet4 C.struct_sockaddr_in

type RawSockaddrInet6 C.struct_sockaddr_in6

type RawSockaddrUnix C.struct_my_sockaddr_un

type RawSockaddrLinklayer C.struct_sockaddr_ll

type RawSockaddrNetlink C.struct_sockaddr_nl

type RawSockaddrHCI C.struct_sockaddr_hci

type RawSockaddrL2 C.struct_sockaddr_l2

type RawSockaddrRFCOMM C.struct_sockaddr_rc

type RawSockaddrCAN C.struct_sockaddr_can

type RawSockaddrALG C.struct_sockaddr_alg

type RawSockaddrVM C.struct_sockaddr_vm

type RawSockaddrXDP C.struct_sockaddr_xdp

type RawSockaddrPPPoX [C.sizeof_struct_sockaddr_pppox]byte

type RawSockaddrTIPC C.struct_sockaddr_tipc

type RawSockaddrL2TPIP C.struct_sockaddr_l2tpip

type RawSockaddrL2TPIP6 C.struct_sockaddr_l2tpip6

type RawSockaddrIUCV C.struct_sockaddr_iucv

type RawSockaddrNFC C.struct_sockaddr_nfc

type RawSockaddrNFCLLCP C.struct_my_sockaddr_nfc_llcp

type RawSockaddr C.struct_sockaddr

type RawSockaddrAny C.struct_sockaddr_any

type _Socklen C.socklen_t

type Linger C.struct_linger

type Iovec C.struct_iovec

type IPMreq C.struct_ip_mreq

type IPMreqn C.struct_ip_mreqn

type IPv6Mreq C.struct_ipv6_mreq

type PacketMreq C.struct_packet_mreq

type Msghdr C.struct_msghdr

type Cmsghdr C.struct_cmsghdr

type Inet4Pktinfo C.struct_in_pktinfo

type Inet6Pktinfo C.struct_in6_pktinfo

type IPv6MTUInfo C.struct_ip6_mtuinfo

type ICMPv6Filter C.struct_icmp6_filter

type Ucred C.struct_ucred

type TCPInfo C.struct_tcp_info

type CanFilter C.struct_can_filter

type ifreq C.struct_ifreq

type TCPRepairOpt C.struct_tcp_repair_opt

const (
	SizeofSockaddrInet4     = C.sizeof_struct_sockaddr_in
	SizeofSockaddrInet6     = C.sizeof_struct_sockaddr_in6
	SizeofSockaddrAny       = C.sizeof_struct_sockaddr_any
	SizeofSockaddrUnix      = C.sizeof_struct_sockaddr_un
	SizeofSockaddrLinklayer = C.sizeof_struct_sockaddr_ll
	SizeofSockaddrNetlink   = C.sizeof_struct_sockaddr_nl
	SizeofSockaddrHCI       = C.sizeof_struct_sockaddr_hci
	SizeofSockaddrL2        = C.sizeof_struct_sockaddr_l2
	SizeofSockaddrRFCOMM    = C.sizeof_struct_sockaddr_rc
	SizeofSockaddrCAN       = C.sizeof_struct_sockaddr_can
	SizeofSockaddrALG       = C.sizeof_struct_sockaddr_alg
	SizeofSockaddrVM        = C.sizeof_struct_sockaddr_vm
	SizeofSockaddrXDP       = C.sizeof_struct_sockaddr_xdp
	SizeofSockaddrPPPoX     = C.sizeof_struct_sockaddr_pppox
	SizeofSockaddrTIPC      = C.sizeof_struct_sockaddr_tipc
	SizeofSockaddrL2TPIP    = C.sizeof_struct_sockaddr_l2tpip
	SizeofSockaddrL2TPIP6   = C.sizeof_struct_sockaddr_l2tpip6
	SizeofSockaddrIUCV      = C.sizeof_struct_sockaddr_iucv
	SizeofSockaddrNFC       = C.sizeof_struct_sockaddr_nfc
	SizeofSockaddrNFCLLCP   = C.sizeof_struct_sockaddr_nfc_llcp
	SizeofLinger            = C.sizeof_struct_linger
	SizeofIovec             = C.sizeof_struct_iovec
	SizeofIPMreq            = C.sizeof_struct_ip_mreq
	SizeofIPMreqn           = C.sizeof_struct_ip_mreqn
	SizeofIPv6Mreq          = C.sizeof_struct_ipv6_mreq
	SizeofPacketMreq        = C.sizeof_struct_packet_mreq
	SizeofMsghdr            = C.sizeof_struct_msghdr
	SizeofCmsghdr           = C.sizeof_struct_cmsghdr
	SizeofInet4Pktinfo      = C.sizeof_struct_in_pktinfo
	SizeofInet6Pktinfo      = C.sizeof_struct_in6_pktinfo
	SizeofIPv6MTUInfo       = C.sizeof_struct_ip6_mtuinfo
	SizeofICMPv6Filter      = C.sizeof_struct_icmp6_filter
	SizeofUcred             = C.sizeof_struct_ucred
	SizeofTCPInfo           = C.sizeof_struct_tcp_info
	SizeofCanFilter         = C.sizeof_struct_can_filter
	SizeofTCPRepairOpt      = C.sizeof_struct_tcp_repair_opt
)

// Netlink routing and interface messages

const (
	NDA_UNSPEC         = C.NDA_UNSPEC
	NDA_DST            = C.NDA_DST
	NDA_LLADDR         = C.NDA_LLADDR
	NDA_CACHEINFO      = C.NDA_CACHEINFO
	NDA_PROBES         = C.NDA_PROBES
	NDA_VLAN           = C.NDA_VLAN
	NDA_PORT           = C.NDA_PORT
	NDA_VNI            = C.NDA_VNI
	NDA_IFINDEX        = C.NDA_IFINDEX
	NDA_MASTER         = C.NDA_MASTER
	NDA_LINK_NETNSID   = C.NDA_LINK_NETNSID
	NDA_SRC_VNI        = C.NDA_SRC_VNI
	NTF_USE            = C.NTF_USE
	NTF_SELF           = C.NTF_SELF
	NTF_MASTER         = C.NTF_MASTER
	NTF_PROXY          = C.NTF_PROXY
	NTF_EXT_LEARNED    = C.NTF_EXT_LEARNED
	NTF_OFFLOADED      = C.NTF_OFFLOADED
	NTF_ROUTER         = C.NTF_ROUTER
	NUD_INCOMPLETE     = C.NUD_INCOMPLETE
	NUD_REACHABLE      = C.NUD_REACHABLE
	NUD_STALE          = C.NUD_STALE
	NUD_DELAY          = C.NUD_DELAY
	NUD_PROBE          = C.NUD_PROBE
	NUD_FAILED         = C.NUD_FAILED
	NUD_NOARP          = C.NUD_NOARP
	NUD_PERMANENT      = C.NUD_PERMANENT
	NUD_NONE           = C.NUD_NONE
	IFA_UNSPEC         = C.IFA_UNSPEC
	IFA_ADDRESS        = C.IFA_ADDRESS
	IFA_LOCAL          = C.IFA_LOCAL
	IFA_LABEL          = C.IFA_LABEL
	IFA_BROADCAST      = C.IFA_BROADCAST
	IFA_ANYCAST        = C.IFA_ANYCAST
	IFA_CACHEINFO      = C.IFA_CACHEINFO
	IFA_MULTICAST      = C.IFA_MULTICAST
	IFA_FLAGS          = C.IFA_FLAGS
	IFA_RT_PRIORITY    = C.IFA_RT_PRIORITY
	IFA_TARGET_NETNSID = C.IFA_TARGET_NETNSID
	RT_SCOPE_UNIVERSE  = C.RT_SCOPE_UNIVERSE
	RT_SCOPE_SITE      = C.RT_SCOPE_SITE
	RT_SCOPE_LINK      = C.RT_SCOPE_LINK
	RT_SCOPE_HOST      = C.RT_SCOPE_HOST
	RT_SCOPE_NOWHERE   = C.RT_SCOPE_NOWHERE
	RT_TABLE_UNSPEC    = C.RT_TABLE_UNSPEC
	RT_TABLE_COMPAT    = C.RT_TABLE_COMPAT
	RT_TABLE_DEFAULT   = C.RT_TABLE_DEFAULT
	RT_TABLE_MAIN      = C.RT_TABLE_MAIN
	RT_TABLE_LOCAL     = C.RT_TABLE_LOCAL
	RT_TABLE_MAX       = C.RT_TABLE_MAX
	RTA_UNSPEC         = C.RTA_UNSPEC
	RTA_DST            = C.RTA_DST
	RTA_SRC            = C.RTA_SRC
	RTA_IIF            = C.RTA_IIF
	RTA_OIF            = C.RTA_OIF
	RTA_GATEWAY        = C.RTA_GATEWAY
	RTA_PRIORITY       = C.RTA_PRIORITY
	RTA_PREFSRC        = C.RTA_PREFSRC
	RTA_METRICS        = C.RTA_METRICS
	RTA_MULTIPATH      = C.RTA_MULTIPATH
	RTA_FLOW           = C.RTA_FLOW
	RTA_CACHEINFO      = C.RTA_CACHEINFO
	RTA_TABLE          = C.RTA_TABLE
	RTA_MARK           = C.RTA_MARK
	RTA_MFC_STATS      = C.RTA_MFC_STATS
	RTA_VIA            = C.RTA_VIA
	RTA_NEWDST         = C.RTA_NEWDST
	RTA_PREF           = C.RTA_PREF
	RTA_ENCAP_TYPE     = C.RTA_ENCAP_TYPE
	RTA_ENCAP          = C.RTA_ENCAP
	RTA_EXPIRES        = C.RTA_EXPIRES
	RTA_PAD            = C.RTA_PAD
	RTA_UID            = C.RTA_UID
	RTA_TTL_PROPAGATE  = C.RTA_TTL_PROPAGATE
	RTA_IP_PROTO       = C.RTA_IP_PROTO
	RTA_SPORT          = C.RTA_SPORT
	RTA_DPORT          = C.RTA_DPORT
	RTN_UNSPEC         = C.RTN_UNSPEC
	RTN_UNICAST        = C.RTN_UNICAST
	RTN_LOCAL          = C.RTN_LOCAL
	RTN_BROADCAST      = C.RTN_BROADCAST
	RTN_ANYCAST        = C.RTN_ANYCAST
	RTN_MULTICAST      = C.RTN_MULTICAST
	RTN_BLACKHOLE      = C.RTN_BLACKHOLE
	RTN_UNREACHABLE    = C.RTN_UNREACHABLE
	RTN_PROHIBIT       = C.RTN_PROHIBIT
	RTN_THROW          = C.RTN_THROW
	RTN_NAT            = C.RTN_NAT
	RTN_XRESOLVE       = C.RTN_XRESOLVE
	SizeofNlMsghdr     = C.sizeof_struct_nlmsghdr
	SizeofNlMsgerr     = C.sizeof_struct_nlmsgerr
	SizeofRtGenmsg     = C.sizeof_struct_rtgenmsg
	SizeofNlAttr       = C.sizeof_struct_nlattr
	SizeofRtAttr       = C.sizeof_struct_rtattr
	SizeofIfInfomsg    = C.sizeof_struct_ifinfomsg
	SizeofIfAddrmsg    = C.sizeof_struct_ifaddrmsg
	SizeofIfaCacheinfo = C.sizeof_struct_ifa_cacheinfo
	SizeofRtMsg        = C.sizeof_struct_rtmsg
	SizeofRtNexthop    = C.sizeof_struct_rtnexthop
	SizeofNdUseroptmsg = C.sizeof_struct_nduseroptmsg
	SizeofNdMsg        = C.sizeof_struct_ndmsg
)

type NlMsghdr C.struct_nlmsghdr

type NlMsgerr C.struct_nlmsgerr

type RtGenmsg C.struct_rtgenmsg

type NlAttr C.struct_nlattr

type RtAttr C.struct_rtattr

type IfInfomsg C.struct_ifinfomsg

type IfAddrmsg C.struct_ifaddrmsg

type IfaCacheinfo C.struct_ifa_cacheinfo

type RtMsg C.struct_rtmsg

type RtNexthop C.struct_rtnexthop

type NdUseroptmsg C.struct_nduseroptmsg

type NdMsg C.struct_ndmsg

// ICMP socket options

const (
	ICMP_FILTER = C.ICMP_FILTER

	ICMPV6_FILTER             = C.ICMPV6_FILTER
	ICMPV6_FILTER_BLOCK       = C.ICMPV6_FILTER_BLOCK
	ICMPV6_FILTER_BLOCKOTHERS = C.ICMPV6_FILTER_BLOCKOTHERS
	ICMPV6_FILTER_PASS        = C.ICMPV6_FILTER_PASS
	ICMPV6_FILTER_PASSONLY    = C.ICMPV6_FILTER_PASSONLY
)

// Linux socket filter

const (
	SizeofSockFilter = C.sizeof_struct_sock_filter
	SizeofSockFprog  = C.sizeof_struct_sock_fprog
)

type SockFilter C.struct_sock_filter

type SockFprog C.struct_sock_fprog

// Inotify

type InotifyEvent C.struct_inotify_event

const SizeofInotifyEvent = C.sizeof_struct_inotify_event

// Ptrace

// Register structures
type PtraceRegs C.PtraceRegs

// Structures contained in PtraceRegs on s390x (exported by mkpost.go)
type PtracePsw C.ptracePsw

type PtraceFpregs C.ptraceFpregs

type PtracePer C.ptracePer

// Misc

type FdSet C.fd_set

type Sysinfo_t C.struct_sysinfo

const SI_LOAD_SHIFT = C.SI_LOAD_SHIFT

type Utsname C.struct_utsname

type Ustat_t C.struct_ustat

type EpollEvent C.struct_my_epoll_event

const (
	AT_EMPTY_PATH   = C.AT_EMPTY_PATH
	AT_FDCWD        = C.AT_FDCWD
	AT_NO_AUTOMOUNT = C.AT_NO_AUTOMOUNT
	AT_REMOVEDIR    = C.AT_REMOVEDIR

	AT_STATX_SYNC_AS_STAT = C.AT_STATX_SYNC_AS_STAT
	AT_STATX_FORCE_SYNC   = C.AT_STATX_FORCE_SYNC
	AT_STATX_DONT_SYNC    = C.AT_STATX_DONT_SYNC

	AT_RECURSIVE = C.AT_RECURSIVE

	AT_SYMLINK_FOLLOW   = C.AT_SYMLINK_FOLLOW
	AT_SYMLINK_NOFOLLOW = C.AT_SYMLINK_NOFOLLOW

	AT_EACCESS = C.AT_EACCESS

	OPEN_TREE_CLONE   = C.OPEN_TREE_CLONE
	OPEN_TREE_CLOEXEC = C.OPEN_TREE_CLOEXEC

	MOVE_MOUNT_F_SYMLINKS   = C.MOVE_MOUNT_F_SYMLINKS
	MOVE_MOUNT_F_AUTOMOUNTS = C.MOVE_MOUNT_F_AUTOMOUNTS
	MOVE_MOUNT_F_EMPTY_PATH = C.MOVE_MOUNT_F_EMPTY_PATH
	MOVE_MOUNT_T_SYMLINKS   = C.MOVE_MOUNT_T_SYMLINKS
	MOVE_MOUNT_T_AUTOMOUNTS = C.MOVE_MOUNT_T_AUTOMOUNTS
	MOVE_MOUNT_T_EMPTY_PATH = C.MOVE_MOUNT_T_EMPTY_PATH
	MOVE_MOUNT_SET_GROUP    = C.MOVE_MOUNT_SET_GROUP

	FSOPEN_CLOEXEC = C.FSOPEN_CLOEXEC

	FSPICK_CLOEXEC          = C.FSPICK_CLOEXEC
	FSPICK_SYMLINK_NOFOLLOW = C.FSPICK_SYMLINK_NOFOLLOW
	FSPICK_NO_AUTOMOUNT     = C.FSPICK_NO_AUTOMOUNT
	FSPICK_EMPTY_PATH       = C.FSPICK_EMPTY_PATH

	FSMOUNT_CLOEXEC = C.FSMOUNT_CLOEXEC
)

type OpenHow C.struct_open_how

const SizeofOpenHow = C.sizeof_struct_open_how

const (
	RESOLVE_BENEATH       = C.RESOLVE_BENEATH
	RESOLVE_IN_ROOT       = C.RESOLVE_IN_ROOT
	RESOLVE_NO_MAGICLINKS = C.RESOLVE_NO_MAGICLINKS
	RESOLVE_NO_SYMLINKS   = C.RESOLVE_NO_SYMLINKS
	RESOLVE_NO_XDEV       = C.RESOLVE_NO_XDEV
)

type PollFd C.struct_pollfd

const (
	POLLIN    = C.POLLIN
	POLLPRI   = C.POLLPRI
	POLLOUT   = C.POLLOUT
	POLLRDHUP = C.POLLRDHUP
	POLLERR   = C.POLLERR
	POLLHUP   = C.POLLHUP
	POLLNVAL  = C.POLLNVAL
)

type Sigset_t C.sigset_t

const _C__NSIG = C._NSIG

type SignalfdSiginfo C.struct_signalfd_siginfo

type Siginfo C.siginfo_t

// Terminal handling

type Termios C.termios_t

type Winsize C.struct_winsize

// Taskstats and cgroup stats.

type Taskstats C.struct_taskstats

const (
	TASKSTATS_CMD_UNSPEC                  = C.TASKSTATS_CMD_UNSPEC
	TASKSTATS_CMD_GET                     = C.TASKSTATS_CMD_GET
	TASKSTATS_CMD_NEW                     = C.TASKSTATS_CMD_NEW
	TASKSTATS_TYPE_UNSPEC                 = C.TASKSTATS_TYPE_UNSPEC
	TASKSTATS_TYPE_PID                    = C.TASKSTATS_TYPE_PID
	TASKSTATS_TYPE_TGID                   = C.TASKSTATS_TYPE_TGID
	TASKSTATS_TYPE_STATS                  = C.TASKSTATS_TYPE_STATS
	TASKSTATS_TYPE_AGGR_PID               = C.TASKSTATS_TYPE_AGGR_PID
	TASKSTATS_TYPE_AGGR_TGID              = C.TASKSTATS_TYPE_AGGR_TGID
	TASKSTATS_TYPE_NULL                   = C.TASKSTATS_TYPE_NULL
	TASKSTATS_CMD_ATTR_UNSPEC             = C.TASKSTATS_CMD_ATTR_UNSPEC
	TASKSTATS_CMD_ATTR_PID                = C.TASKSTATS_CMD_ATTR_PID
	TASKSTATS_CMD_ATTR_TGID               = C.TASKSTATS_CMD_ATTR_TGID
	TASKSTATS_CMD_ATTR_REGISTER_CPUMASK   = C.TASKSTATS_CMD_ATTR_REGISTER_CPUMASK
	TASKSTATS_CMD_ATTR_DEREGISTER_CPUMASK = C.TASKSTATS_CMD_ATTR_DEREGISTER_CPUMASK
)

type CGroupStats C.struct_cgroupstats

const (
	CGROUPSTATS_CMD_UNSPEC        = C.__TASKSTATS_CMD_MAX
	CGROUPSTATS_CMD_GET           = C.CGROUPSTATS_CMD_GET
	CGROUPSTATS_CMD_NEW           = C.CGROUPSTATS_CMD_NEW
	CGROUPSTATS_TYPE_UNSPEC       = C.CGROUPSTATS_TYPE_UNSPEC
	CGROUPSTATS_TYPE_CGROUP_STATS = C.CGROUPSTATS_TYPE_CGROUP_STATS
	CGROUPSTATS_CMD_ATTR_UNSPEC   = C.CGROUPSTATS_CMD_ATTR_UNSPEC
	CGROUPSTATS_CMD_ATTR_FD       = C.CGROUPSTATS_CMD_ATTR_FD
)

// Generic netlink

type Genlmsghdr C.struct_genlmsghdr

// Generated by:
// $ perl -nlE '/^\s*(CTRL_\w+)/ && say "$1 = C.$1"' /usr/include/linux/genetlink.h
const (
	CTRL_CMD_UNSPEC            = C.CTRL_CMD_UNSPEC
	CTRL_CMD_NEWFAMILY         = C.CTRL_CMD_NEWFAMILY
	CTRL_CMD_DELFAMILY         = C.CTRL_CMD_DELFAMILY
	CTRL_CMD_GETFAMILY         = C.CTRL_CMD_GETFAMILY
	CTRL_CMD_NEWOPS            = C.CTRL_CMD_NEWOPS
	CTRL_CMD_DELOPS            = C.CTRL_CMD_DELOPS
	CTRL_CMD_GETOPS            = C.CTRL_CMD_GETOPS
	CTRL_CMD_NEWMCAST_GRP      = C.CTRL_CMD_NEWMCAST_GRP
	CTRL_CMD_DELMCAST_GRP      = C.CTRL_CMD_DELMCAST_GRP
	CTRL_CMD_GETMCAST_GRP      = C.CTRL_CMD_GETMCAST_GRP
	CTRL_CMD_GETPOLICY         = C.CTRL_CMD_GETPOLICY
	CTRL_ATTR_UNSPEC           = C.CTRL_ATTR_UNSPEC
	CTRL_ATTR_FAMILY_ID        = C.CTRL_ATTR_FAMILY_ID
	CTRL_ATTR_FAMILY_NAME      = C.CTRL_ATTR_FAMILY_NAME
	CTRL_ATTR_VERSION          = C.CTRL_ATTR_VERSION
	CTRL_ATTR_HDRSIZE          = C.CTRL_ATTR_HDRSIZE
	CTRL_ATTR_MAXATTR          = C.CTRL_ATTR_MAXATTR
	CTRL_ATTR_OPS              = C.CTRL_ATTR_OPS
	CTRL_ATTR_MCAST_GROUPS     = C.CTRL_ATTR_MCAST_GROUPS
	CTRL_ATTR_POLICY           = C.CTRL_ATTR_POLICY
	CTRL_ATTR_OP_POLICY        = C.CTRL_ATTR_OP_POLICY
	CTRL_ATTR_OP               = C.CTRL_ATTR_OP
	CTRL_ATTR_OP_UNSPEC        = C.CTRL_ATTR_OP_UNSPEC
	CTRL_ATTR_OP_ID            = C.CTRL_ATTR_OP_ID
	CTRL_ATTR_OP_FLAGS         = C.CTRL_ATTR_OP_FLAGS
	CTRL_ATTR_MCAST_GRP_UNSPEC = C.CTRL_ATTR_MCAST_GRP_UNSPEC
	CTRL_ATTR_MCAST_GRP_NAME   = C.CTRL_ATTR_MCAST_GRP_NAME
	CTRL_ATTR_MCAST_GRP_ID     = C.CTRL_ATTR_MCAST_GRP_ID
	CTRL_ATTR_POLICY_UNSPEC    = C.CTRL_ATTR_POLICY_UNSPEC
	CTRL_ATTR_POLICY_DO        = C.CTRL_ATTR_POLICY_DO
	CTRL_ATTR_POLICY_DUMP      = C.CTRL_ATTR_POLICY_DUMP
	CTRL_ATTR_POLICY_DUMP_MAX  = C.CTRL_ATTR_POLICY_DUMP_MAX
)

// CPU affinity

type cpuMask C.__cpu_mask

const (
	_CPU_SETSIZE = C.__CPU_SETSIZE
	_NCPUBITS    = C.__NCPUBITS
)

// Bluetooth

const (
	BDADDR_BREDR     = C.BDADDR_BREDR
	BDADDR_LE_PUBLIC = C.BDADDR_LE_PUBLIC
	BDADDR_LE_RANDOM = C.BDADDR_LE_RANDOM
)

// Perf subsystem

type PerfEventAttr C.struct_perf_event_attr_go

type PerfEventMmapPage C.struct_perf_event_mmap_page

// Bit field in struct perf_event_attr expanded as flags.
// Set these on PerfEventAttr.Bits by ORing them together.
const (
	PerfBitDisabled               uint64 = CBitFieldMaskBit0
	PerfBitInherit                       = CBitFieldMaskBit1
	PerfBitPinned                        = CBitFieldMaskBit2
	PerfBitExclusive                     = CBitFieldMaskBit3
	PerfBitExcludeUser                   = CBitFieldMaskBit4
	PerfBitExcludeKernel                 = CBitFieldMaskBit5
	PerfBitExcludeHv                     = CBitFieldMaskBit6
	PerfBitExcludeIdle                   = CBitFieldMaskBit7
	PerfBitMmap                          = CBitFieldMaskBit8
	PerfBitComm                          = CBitFieldMaskBit9
	PerfBitFreq                          = CBitFieldMaskBit10
	PerfBitInheritStat                   = CBitFieldMaskBit11
	PerfBitEnableOnExec                  = CBitFieldMaskBit12
	PerfBitTask                          = CBitFieldMaskBit13
	PerfBitWatermark                     = CBitFieldMaskBit14
	PerfBitPreciseIPBit1                 = CBitFieldMaskBit15
	PerfBitPreciseIPBit2                 = CBitFieldMaskBit16
	PerfBitMmapData                      = CBitFieldMaskBit17
	PerfBitSampleIDAll                   = CBitFieldMaskBit18
	PerfBitExcludeHost                   = CBitFieldMaskBit19
	PerfBitExcludeGuest                  = CBitFieldMaskBit20
	PerfBitExcludeCallchainKernel        = CBitFieldMaskBit21
	PerfBitExcludeCallchainUser          = CBitFieldMaskBit22
	PerfBitMmap2                         = CBitFieldMaskBit23
	PerfBitCommExec                      = CBitFieldMaskBit24
	PerfBitUseClockID                    = CBitFieldMaskBit25
	PerfBitContextSwitch                 = CBitFieldMaskBit26
)

// generated by:
// perl -nlE '/^\s*(PERF_\w+)/ && say "$1 = C.$1"' /usr/include/linux/perf_event.h
const (
	PERF_TYPE_HARDWARE                    = C.PERF_TYPE_HARDWARE
	PERF_TYPE_SOFTWARE                    = C.PERF_TYPE_SOFTWARE
	PERF_TYPE_TRACEPOINT                  = C.PERF_TYPE_TRACEPOINT
	PERF_TYPE_HW_CACHE                    = C.PERF_TYPE_HW_CACHE
	PERF_TYPE_RAW                         = C.PERF_TYPE_RAW
	PERF_TYPE_BREAKPOINT                  = C.PERF_TYPE_BREAKPOINT
	PERF_TYPE_MAX                         = C.PERF_TYPE_MAX
	PERF_COUNT_HW_CPU_CYCLES              = C.PERF_COUNT_HW_CPU_CYCLES
	PERF_COUNT_HW_INSTRUCTIONS            = C.PERF_COUNT_HW_INSTRUCTIONS
	PERF_COUNT_HW_CACHE_REFERENCES        = C.PERF_COUNT_HW_CACHE_REFERENCES
	PERF_COUNT_HW_CACHE_MISSES            = C.PERF_COUNT_HW_CACHE_MISSES
	PERF_COUNT_HW_BRANCH_INSTRUCTIONS     = C.PERF_COUNT_HW_BRANCH_INSTRUCTIONS
	PERF_COUNT_HW_BRANCH_MISSES           = C.PERF_COUNT_HW_BRANCH_MISSES
	PERF_COUNT_HW_BUS_CYCLES              = C.PERF_COUNT_HW_BUS_CYCLES
	PERF_COUNT_HW_STALLED_CYCLES_FRONTEND = C.PERF_COUNT_HW_STALLED_CYCLES_FRONTEND
	PERF_COUNT_HW_STALLED_CYCLES_BACKEND  = C.PERF_COUNT_HW_STALLED_CYCLES_BACKEND
	PERF_COUNT_HW_REF_CPU_CYCLES          = C.PERF_COUNT_HW_REF_CPU_CYCLES
	PERF_COUNT_HW_MAX                     = C.PERF_COUNT_HW_MAX
	PERF_COUNT_HW_CACHE_L1D               = C.PERF_COUNT_HW_CACHE_L1D
	PERF_COUNT_HW_CACHE_L1I               = C.PERF_COUNT_HW_CACHE_L1I
	PERF_COUNT_HW_CACHE_LL                = C.PERF_COUNT_HW_CACHE_LL
	PERF_COUNT_HW_CACHE_DTLB              = C.PERF_COUNT_HW_CACHE_DTLB
	PERF_COUNT_HW_CACHE_ITLB              = C.PERF_COUNT_HW_CACHE_ITLB
	PERF_COUNT_HW_CACHE_BPU               = C.PERF_COUNT_HW_CACHE_BPU
	PERF_COUNT_HW_CACHE_NODE              = C.PERF_COUNT_HW_CACHE_NODE
	PERF_COUNT_HW_CACHE_MAX               = C.PERF_COUNT_HW_CACHE_MAX
	PERF_COUNT_HW_CACHE_OP_READ           = C.PERF_COUNT_HW_CACHE_OP_READ
	PERF_COUNT_HW_CACHE_OP_WRITE          = C.PERF_COUNT_HW_CACHE_OP_WRITE
	PERF_COUNT_HW_CACHE_OP_PREFETCH       = C.PERF_COUNT_HW_CACHE_OP_PREFETCH
	PERF_COUNT_HW_CACHE_OP_MAX            = C.PERF_COUNT_HW_CACHE_OP_MAX
	PERF_COUNT_HW_CACHE_RESULT_ACCESS     = C.PERF_COUNT_HW_CACHE_RESULT_ACCESS
	PERF_COUNT_HW_CACHE_RESULT_MISS       = C.PERF_COUNT_HW_CACHE_RESULT_MISS
	PERF_COUNT_HW_CACHE_RESULT_MAX        = C.PERF_COUNT_HW_CACHE_RESULT_MAX
	PERF_COUNT_SW_CPU_CLOCK               = C.PERF_COUNT_SW_CPU_CLOCK
	PERF_COUNT_SW_TASK_CLOCK              = C.PERF_COUNT_SW_TASK_CLOCK
	PERF_COUNT_SW_PAGE_FAULTS             = C.PERF_COUNT_SW_PAGE_FAULTS
	PERF_COUNT_SW_CONTEXT_SWITCHES        = C.PERF_COUNT_SW_CONTEXT_SWITCHES
	PERF_COUNT_SW_CPU_MIGRATIONS          = C.PERF_COUNT_SW_CPU_MIGRATIONS
	PERF_COUNT_SW_PAGE_FAULTS_MIN         = C.PERF_COUNT_SW_PAGE_FAULTS_MIN
	PERF_COUNT_SW_PAGE_FAULTS_MAJ         = C.PERF_COUNT_SW_PAGE_FAULTS_MAJ
	PERF_COUNT_SW_ALIGNMENT_FAULTS        = C.PERF_COUNT_SW_ALIGNMENT_FAULTS
	PERF_COUNT_SW_EMULATION_FAULTS        = C.PERF_COUNT_SW_EMULATION_FAULTS
	PERF_COUNT_SW_DUMMY                   = C.PERF_COUNT_SW_DUMMY
	PERF_COUNT_SW_BPF_OUTPUT              = C.PERF_COUNT_SW_BPF_OUTPUT
	PERF_COUNT_SW_MAX                     = C.PERF_COUNT_SW_MAX
	PERF_SAMPLE_IP                        = C.PERF_SAMPLE_IP
	PERF_SAMPLE_TID                       = C.PERF_SAMPLE_TID
	PERF_SAMPLE_TIME                      = C.PERF_SAMPLE_TIME
	PERF_SAMPLE_ADDR                      = C.PERF_SAMPLE_ADDR
	PERF_SAMPLE_READ                      = C.PERF_SAMPLE_READ
	PERF_SAMPLE_CALLCHAIN                 = C.PERF_SAMPLE_CALLCHAIN
	PERF_SAMPLE_ID                        = C.PERF_SAMPLE_ID
	PERF_SAMPLE_CPU                       = C.PERF_SAMPLE_CPU
	PERF_SAMPLE_PERIOD                    = C.PERF_SAMPLE_PERIOD
	PERF_SAMPLE_STREAM_ID                 = C.PERF_SAMPLE_STREAM_ID
	PERF_SAMPLE_RAW                       = C.PERF_SAMPLE_RAW
	PERF_SAMPLE_BRANCH_STACK              = C.PERF_SAMPLE_BRANCH_STACK
	PERF_SAMPLE_REGS_USER                 = C.PERF_SAMPLE_REGS_USER
	PERF_SAMPLE_STACK_USER                = C.PERF_SAMPLE_STACK_USER
	PERF_SAMPLE_WEIGHT                    = C.PERF_SAMPLE_WEIGHT
	PERF_SAMPLE_DATA_SRC                  = C.PERF_SAMPLE_DATA_SRC
	PERF_SAMPLE_IDENTIFIER                = C.PERF_SAMPLE_IDENTIFIER
	PERF_SAMPLE_TRANSACTION               = C.PERF_SAMPLE_TRANSACTION
	PERF_SAMPLE_REGS_INTR                 = C.PERF_SAMPLE_REGS_INTR
	PERF_SAMPLE_PHYS_ADDR                 = C.PERF_SAMPLE_PHYS_ADDR
	PERF_SAMPLE_AUX                       = C.PERF_SAMPLE_AUX
	PERF_SAMPLE_CGROUP                    = C.PERF_SAMPLE_CGROUP
	PERF_SAMPLE_DATA_PAGE_SIZE            = C.PERF_SAMPLE_DATA_PAGE_SIZE
	PERF_SAMPLE_CODE_PAGE_SIZE            = C.PERF_SAMPLE_CODE_PAGE_SIZE
	PERF_SAMPLE_WEIGHT_STRUCT             = C.PERF_SAMPLE_WEIGHT_STRUCT
	PERF_SAMPLE_MAX                       = C.PERF_SAMPLE_MAX
	PERF_SAMPLE_BRANCH_USER_SHIFT         = C.PERF_SAMPLE_BRANCH_USER_SHIFT
	PERF_SAMPLE_BRANCH_KERNEL_SHIFT       = C.PERF_SAMPLE_BRANCH_KERNEL_SHIFT
	PERF_SAMPLE_BRANCH_HV_SHIFT           = C.PERF_SAMPLE_BRANCH_HV_SHIFT
	PERF_SAMPLE_BRANCH_ANY_SHIFT          = C.PERF_SAMPLE_BRANCH_ANY_SHIFT
	PERF_SAMPLE_BRANCH_ANY_CALL_SHIFT     = C.PERF_SAMPLE_BRANCH_ANY_CALL_SHIFT
	PERF_SAMPLE_BRANCH_ANY_RETURN_SHIFT   = C.PERF_SAMPLE_BRANCH_ANY_RETURN_SHIFT
	PERF_SAMPLE_BRANCH_IND_CALL_SHIFT     = C.PERF_SAMPLE_BRANCH_IND_CALL_SHIFT
	PERF_SAMPLE_BRANCH_ABORT_TX_SHIFT     = C.PERF_SAMPLE_BRANCH_ABORT_TX_SHIFT
	PERF_SAMPLE_BRANCH_IN_TX_SHIFT        = C.PERF_SAMPLE_BRANCH_IN_TX_SHIFT
	PERF_SAMPLE_BRANCH_NO_TX_SHIFT        = C.PERF_SAMPLE_BRANCH_NO_TX_SHIFT
	PERF_SAMPLE_BRANCH_COND_SHIFT         = C.PERF_SAMPLE_BRANCH_COND_SHIFT
	PERF_SAMPLE_BRANCH_CALL_STACK_SHIFT   = C.PERF_SAMPLE_BRANCH_CALL_STACK_SHIFT
	PERF_SAMPLE_BRANCH_IND_JUMP_SHIFT     = C.PERF_SAMPLE_BRANCH_IND_JUMP_SHIFT
	PERF_SAMPLE_BRANCH_CALL_SHIFT         = C.PERF_SAMPLE_BRANCH_CALL_SHIFT
	PERF_SAMPLE_BRANCH_NO_FLAGS_SHIFT     = C.PERF_SAMPLE_BRANCH_NO_FLAGS_SHIFT
	PERF_SAMPLE_BRANCH_NO_CYCLES_SHIFT    = C.PERF_SAMPLE_BRANCH_NO_CYCLES_SHIFT
	PERF_SAMPLE_BRANCH_TYPE_SAVE_SHIFT    = C.PERF_SAMPLE_BRANCH_TYPE_SAVE_SHIFT
	PERF_SAMPLE_BRANCH_HW_INDEX_SHIFT     = C.PERF_SAMPLE_BRANCH_HW_INDEX_SHIFT
	PERF_SAMPLE_BRANCH_MAX_SHIFT          = C.PERF_SAMPLE_BRANCH_MAX_SHIFT
	PERF_SAMPLE_BRANCH_USER               = C.PERF_SAMPLE_BRANCH_USER
	PERF_SAMPLE_BRANCH_KERNEL             = C.PERF_SAMPLE_BRANCH_KERNEL
	PERF_SAMPLE_BRANCH_HV                 = C.PERF_SAMPLE_BRANCH_HV
	PERF_SAMPLE_BRANCH_ANY                = C.PERF_SAMPLE_BRANCH_ANY
	PERF_SAMPLE_BRANCH_ANY_CALL           = C.PERF_SAMPLE_BRANCH_ANY_CALL
	PERF_SAMPLE_BRANCH_ANY_RETURN         = C.PERF_SAMPLE_BRANCH_ANY_RETURN
	PERF_SAMPLE_BRANCH_IND_CALL           = C.PERF_SAMPLE_BRANCH_IND_CALL
	PERF_SAMPLE_BRANCH_ABORT_TX           = C.PERF_SAMPLE_BRANCH_ABORT_TX
	PERF_SAMPLE_BRANCH_IN_TX              = C.PERF_SAMPLE_BRANCH_IN_TX
	PERF_SAMPLE_BRANCH_NO_TX              = C.PERF_SAMPLE_BRANCH_NO_TX
	PERF_SAMPLE_BRANCH_COND               = C.PERF_SAMPLE_BRANCH_COND
	PERF_SAMPLE_BRANCH_CALL_STACK         = C.PERF_SAMPLE_BRANCH_CALL_STACK
	PERF_SAMPLE_BRANCH_IND_JUMP           = C.PERF_SAMPLE_BRANCH_IND_JUMP
	PERF_SAMPLE_BRANCH_CALL               = C.PERF_SAMPLE_BRANCH_CALL
	PERF_SAMPLE_BRANCH_NO_FLAGS           = C.PERF_SAMPLE_BRANCH_NO_FLAGS
	PERF_SAMPLE_BRANCH_NO_CYCLES          = C.PERF_SAMPLE_BRANCH_NO_CYCLES
	PERF_SAMPLE_BRANCH_TYPE_SAVE          = C.PERF_SAMPLE_BRANCH_TYPE_SAVE
	PERF_SAMPLE_BRANCH_HW_INDEX           = C.PERF_SAMPLE_BRANCH_HW_INDEX
	PERF_SAMPLE_BRANCH_MAX                = C.PERF_SAMPLE_BRANCH_MAX
	PERF_BR_UNKNOWN                       = C.PERF_BR_UNKNOWN
	PERF_BR_COND                          = C.PERF_BR_COND
	PERF_BR_UNCOND                        = C.PERF_BR_UNCOND
	PERF_BR_IND                           = C.PERF_BR_IND
	PERF_BR_CALL                          = C.PERF_BR_CALL
	PERF_BR_IND_CALL                      = C.PERF_BR_IND_CALL
	PERF_BR_RET                           = C.PERF_BR_RET
	PERF_BR_SYSCALL                       = C.PERF_BR_SYSCALL
	PERF_BR_SYSRET                        = C.PERF_BR_SYSRET
	PERF_BR_COND_CALL                     = C.PERF_BR_COND_CALL
	PERF_BR_COND_RET                      = C.PERF_BR_COND_RET
	PERF_BR_ERET                          = C.PERF_BR_ERET
	PERF_BR_IRQ                           = C.PERF_BR_IRQ
	PERF_BR_MAX                           = C.PERF_BR_MAX
	PERF_SAMPLE_REGS_ABI_NONE             = C.PERF_SAMPLE_REGS_ABI_NONE
	PERF_SAMPLE_REGS_ABI_32               = C.PERF_SAMPLE_REGS_ABI_32
	PERF_SAMPLE_REGS_ABI_64               = C.PERF_SAMPLE_REGS_ABI_64
	PERF_TXN_ELISION                      = C.PERF_TXN_ELISION
	PERF_TXN_TRANSACTION                  = C.PERF_TXN_TRANSACTION
	PERF_TXN_SYNC                         = C.PERF_TXN_SYNC
	PERF_TXN_ASYNC                        = C.PERF_TXN_ASYNC
	PERF_TXN_RETRY                        = C.PERF_TXN_RETRY
	PERF_TXN_CONFLICT                     = C.PERF_TXN_CONFLICT
	PERF_TXN_CAPACITY_WRITE               = C.PERF_TXN_CAPACITY_WRITE
	PERF_TXN_CAPACITY_READ                = C.PERF_TXN_CAPACITY_READ
	PERF_TXN_MAX                          = C.PERF_TXN_MAX
	PERF_TXN_ABORT_MASK                   = C.PERF_TXN_ABORT_MASK
	PERF_TXN_ABORT_SHIFT                  = C.PERF_TXN_ABORT_SHIFT
	PERF_FORMAT_TOTAL_TIME_ENABLED        = C.PERF_FORMAT_TOTAL_TIME_ENABLED
	PERF_FORMAT_TOTAL_TIME_RUNNING        = C.PERF_FORMAT_TOTAL_TIME_RUNNING
	PERF_FORMAT_ID                        = C.PERF_FORMAT_ID
	PERF_FORMAT_GROUP                     = C.PERF_FORMAT_GROUP
	PERF_FORMAT_MAX                       = C.PERF_FORMAT_MAX
	PERF_IOC_FLAG_GROUP                   = C.PERF_IOC_FLAG_GROUP
	PERF_RECORD_MMAP                      = C.PERF_RECORD_MMAP
	PERF_RECORD_LOST                      = C.PERF_RECORD_LOST
	PERF_RECORD_COMM                      = C.PERF_RECORD_COMM
	PERF_RECORD_EXIT                      = C.PERF_RECORD_EXIT
	PERF_RECORD_THROTTLE                  = C.PERF_RECORD_THROTTLE
	PERF_RECORD_UNTHROTTLE                = C.PERF_RECORD_UNTHROTTLE
	PERF_RECORD_FORK                      = C.PERF_RECORD_FORK
	PERF_RECORD_READ                      = C.PERF_RECORD_READ
	PERF_RECORD_SAMPLE                    = C.PERF_RECORD_SAMPLE
	PERF_RECORD_MMAP2                     = C.PERF_RECORD_MMAP2
	PERF_RECORD_AUX                       = C.PERF_RECORD_AUX
	PERF_RECORD_ITRACE_START              = C.PERF_RECORD_ITRACE_START
	PERF_RECORD_LOST_SAMPLES              = C.PERF_RECORD_LOST_SAMPLES
	PERF_RECORD_SWITCH                    = C.PERF_RECORD_SWITCH
	PERF_RECORD_SWITCH_CPU_WIDE           = C.PERF_RECORD_SWITCH_CPU_WIDE
	PERF_RECORD_NAMESPACES                = C.PERF_RECORD_NAMESPACES
	PERF_RECORD_KSYMBOL                   = C.PERF_RECORD_KSYMBOL
	PERF_RECORD_BPF_EVENT                 = C.PERF_RECORD_BPF_EVENT
	PERF_RECORD_CGROUP                    = C.PERF_RECORD_CGROUP
	PERF_RECORD_TEXT_POKE                 = C.PERF_RECORD_TEXT_POKE
	PERF_RECORD_AUX_OUTPUT_HW_ID          = C.PERF_RECORD_AUX_OUTPUT_HW_ID
	PERF_RECORD_MAX                       = C.PERF_RECORD_MAX
	PERF_RECORD_KSYMBOL_TYPE_UNKNOWN      = C.PERF_RECORD_KSYMBOL_TYPE_UNKNOWN
	PERF_RECORD_KSYMBOL_TYPE_BPF          = C.PERF_RECORD_KSYMBOL_TYPE_BPF
	PERF_RECORD_KSYMBOL_TYPE_OOL          = C.PERF_RECORD_KSYMBOL_TYPE_OOL
	PERF_RECORD_KSYMBOL_TYPE_MAX          = C.PERF_RECORD_KSYMBOL_TYPE_MAX
	PERF_BPF_EVENT_UNKNOWN                = C.PERF_BPF_EVENT_UNKNOWN
	PERF_BPF_EVENT_PROG_LOAD              = C.PERF_BPF_EVENT_PROG_LOAD
	PERF_BPF_EVENT_PROG_UNLOAD            = C.PERF_BPF_EVENT_PROG_UNLOAD
	PERF_BPF_EVENT_MAX                    = C.PERF_BPF_EVENT_MAX
	PERF_CONTEXT_HV                       = C.PERF_CONTEXT_HV
	PERF_CONTEXT_KERNEL                   = C.PERF_CONTEXT_KERNEL
	PERF_CONTEXT_USER                     = C.PERF_CONTEXT_USER
	PERF_CONTEXT_GUEST                    = C.PERF_CONTEXT_GUEST
	PERF_CONTEXT_GUEST_KERNEL             = C.PERF_CONTEXT_GUEST_KERNEL
	PERF_CONTEXT_GUEST_USER               = C.PERF_CONTEXT_GUEST_USER
	PERF_CONTEXT_MAX                      = C.PERF_CONTEXT_MAX
)

// Platform ABI and calling convention

// Bit field masks for interoperability with C code that uses bit fields.
// Each mask corresponds to a single bit set - bit field behavior can be replicated by combining
// the masks with bitwise OR.
const (
	CBitFieldMaskBit0  = C.BITFIELD_MASK_0
	CBitFieldMaskBit1  = C.BITFIELD_MASK_1
	CBitFieldMaskBit2  = C.BITFIELD_MASK_2
	CBitFieldMaskBit3  = C.BITFIELD_MASK_3
	CBitFieldMaskBit4  = C.BITFIELD_MASK_4
	CBitFieldMaskBit5  = C.BITFIELD_MASK_5
	CBitFieldMaskBit6  = C.BITFIELD_MASK_6
	CBitFieldMaskBit7  = C.BITFIELD_MASK_7
	CBitFieldMaskBit8  = C.BITFIELD_MASK_8
	CBitFieldMaskBit9  = C.BITFIELD_MASK_9
	CBitFieldMaskBit10 = C.BITFIELD_MASK_10
	CBitFieldMaskBit11 = C.BITFIELD_MASK_11
	CBitFieldMaskBit12 = C.BITFIELD_MASK_12
	CBitFieldMaskBit13 = C.BITFIELD_MASK_13
	CBitFieldMaskBit14 = C.BITFIELD_MASK_14
	CBitFieldMaskBit15 = C.BITFIELD_MASK_15
	CBitFieldMaskBit16 = C.BITFIELD_MASK_16
	CBitFieldMaskBit17 = C.BITFIELD_MASK_17
	CBitFieldMaskBit18 = C.BITFIELD_MASK_18
	CBitFieldMaskBit19 = C.BITFIELD_MASK_19
	CBitFieldMaskBit20 = C.BITFIELD_MASK_20
	CBitFieldMaskBit21 = C.BITFIELD_MASK_21
	CBitFieldMaskBit22 = C.BITFIELD_MASK_22
	CBitFieldMaskBit23 = C.BITFIELD_MASK_23
	CBitFieldMaskBit24 = C.BITFIELD_MASK_24
	CBitFieldMaskBit25 = C.BITFIELD_MASK_25
	CBitFieldMaskBit26 = C.BITFIELD_MASK_26
	CBitFieldMaskBit27 = C.BITFIELD_MASK_27
	CBitFieldMaskBit28 = C.BITFIELD_MASK_28
	CBitFieldMaskBit29 = C.BITFIELD_MASK_29
	CBitFieldMaskBit30 = C.BITFIELD_MASK_30
	CBitFieldMaskBit31 = C.BITFIELD_MASK_31
	CBitFieldMaskBit32 = C.BITFIELD_MASK_32
	CBitFieldMaskBit33 = C.BITFIELD_MASK_33
	CBitFieldMaskBit34 = C.BITFIELD_MASK_34
	CBitFieldMaskBit35 = C.BITFIELD_MASK_35
	CBitFieldMaskBit36 = C.BITFIELD_MASK_36
	CBitFieldMaskBit37 = C.BITFIELD_MASK_37
	CBitFieldMaskBit38 = C.BITFIELD_MASK_38
	CBitFieldMaskBit39 = C.BITFIELD_MASK_39
	CBitFieldMaskBit40 = C.BITFIELD_MASK_40
	CBitFieldMaskBit41 = C.BITFIELD_MASK_41
	CBitFieldMaskBit42 = C.BITFIELD_MASK_42
	CBitFieldMaskBit43 = C.BITFIELD_MASK_43
	CBitFieldMaskBit44 = C.BITFIELD_MASK_44
	CBitFieldMaskBit45 = C.BITFIELD_MASK_45
	CBitFieldMaskBit46 = C.BITFIELD_MASK_46
	CBitFieldMaskBit47 = C.BITFIELD_MASK_47
	CBitFieldMaskBit48 = C.BITFIELD_MASK_48
	CBitFieldMaskBit49 = C.BITFIELD_MASK_49
	CBitFieldMaskBit50 = C.BITFIELD_MASK_50
	CBitFieldMaskBit51 = C.BITFIELD_MASK_51
	CBitFieldMaskBit52 = C.BITFIELD_MASK_52
	CBitFieldMaskBit53 = C.BITFIELD_MASK_53
	CBitFieldMaskBit54 = C.BITFIELD_MASK_54
	CBitFieldMaskBit55 = C.BITFIELD_MASK_55
	CBitFieldMaskBit56 = C.BITFIELD_MASK_56
	CBitFieldMaskBit57 = C.BITFIELD_MASK_57
	CBitFieldMaskBit58 = C.BITFIELD_MASK_58
	CBitFieldMaskBit59 = C.BITFIELD_MASK_59
	CBitFieldMaskBit60 = C.BITFIELD_MASK_60
	CBitFieldMaskBit61 = C.BITFIELD_MASK_61
	CBitFieldMaskBit62 = C.BITFIELD_MASK_62
	CBitFieldMaskBit63 = C.BITFIELD_MASK_63
)

// TCP-MD5 signature.

type SockaddrStorage C.struct_sockaddr_storage

type TCPMD5Sig C.struct_tcp_md5sig

// Disk drive operations.

type HDDriveCmdHdr C.struct_hd_drive_cmd_hdr

type HDGeometry C.struct_hd_geometry

type HDDriveID C.struct_hd_driveid

// Statfs

type Statfs_t C.struct_statfs

const (
	ST_MANDLOCK    = C.ST_MANDLOCK
	ST_NOATIME     = C.ST_NOATIME
	ST_NODEV       = C.ST_NODEV
	ST_NODIRATIME  = C.ST_NODIRATIME
	ST_NOEXEC      = C.ST_NOEXEC
	ST_NOSUID      = C.ST_NOSUID
	ST_RDONLY      = C.ST_RDONLY
	ST_RELATIME    = C.ST_RELATIME
	ST_SYNCHRONOUS = C.ST_SYNCHRONOUS
)

// TPacket

type TpacketHdr C.struct_tpacket_hdr

type Tpacket2Hdr C.struct_tpacket2_hdr

type Tpacket3Hdr C.struct_tpacket3_hdr

type TpacketHdrVariant1 C.struct_tpacket_hdr_variant1

type TpacketBlockDesc C.struct_tpacket_block_desc

type TpacketBDTS C.struct_tpacket_bd_ts

type TpacketHdrV1 C.struct_tpacket_hdr_v1

type TpacketReq C.struct_tpacket_req

type TpacketReq3 C.struct_tpacket_req3

type TpacketStats C.struct_tpacket_stats

type TpacketStatsV3 C.struct_tpacket_stats_v3

type TpacketAuxdata C.struct_tpacket_auxdata

const (
	TPACKET_V1 = C.TPACKET_V1
	TPACKET_V2 = C.TPACKET_V2
	TPACKET_V3 = C.TPACKET_V3
)

const (
	SizeofTpacketHdr  = C.sizeof_struct_tpacket_hdr
	SizeofTpacket2Hdr = C.sizeof_struct_tpacket2_hdr
	SizeofTpacket3Hdr = C.sizeof_struct_tpacket3_hdr

	SizeofTpacketStats   = C.sizeof_struct_tpacket_stats
	SizeofTpacketStatsV3 = C.sizeof_struct_tpacket_stats_v3
)

// generated by:
// perl -nlE '/^\s*(IFLA\w+)/ && say "$1 = C.$1"' /usr/include/linux/if_link.h
const (
	IFLA_UNSPEC                                = C.IFLA_UNSPEC
	IFLA_ADDRESS                               = C.IFLA_ADDRESS
	IFLA_BROADCAST                             = C.IFLA_BROADCAST
	IFLA_IFNAME                                = C.IFLA_IFNAME
	IFLA_MTU                                   = C.IFLA_MTU
	IFLA_LINK                                  = C.IFLA_LINK
	IFLA_QDISC                                 = C.IFLA_QDISC
	IFLA_STATS                                 = C.IFLA_STATS
	IFLA_COST                                  = C.IFLA_COST
	IFLA_PRIORITY                              = C.IFLA_PRIORITY
	IFLA_MASTER                                = C.IFLA_MASTER
	IFLA_WIRELESS                              = C.IFLA_WIRELESS
	IFLA_PROTINFO                              = C.IFLA_PROTINFO
	IFLA_TXQLEN                                = C.IFLA_TXQLEN
	IFLA_MAP                                   = C.IFLA_MAP
	IFLA_WEIGHT                                = C.IFLA_WEIGHT
	IFLA_OPERSTATE                             = C.IFLA_OPERSTATE
	IFLA_LINKMODE                              = C.IFLA_LINKMODE
	IFLA_LINKINFO                              = C.IFLA_LINKINFO
	IFLA_NET_NS_PID                            = C.IFLA_NET_NS_PID
	IFLA_IFALIAS                               = C.IFLA_IFALIAS
	IFLA_NUM_VF                                = C.IFLA_NUM_VF
	IFLA_VFINFO_LIST                           = C.IFLA_VFINFO_LIST
	IFLA_STATS64                               = C.IFLA_STATS64
	IFLA_VF_PORTS                              = C.IFLA_VF_PORTS
	IFLA_PORT_SELF                             = C.IFLA_PORT_SELF
	IFLA_AF_SPEC                               = C.IFLA_AF_SPEC
	IFLA_GROUP                                 = C.IFLA_GROUP
	IFLA_NET_NS_FD                             = C.IFLA_NET_NS_FD
	IFLA_EXT_MASK                              = C.IFLA_EXT_MASK
	IFLA_PROMISCUITY                           = C.IFLA_PROMISCUITY
	IFLA_NUM_TX_QUEUES                         = C.IFLA_NUM_TX_QUEUES
	IFLA_NUM_RX_QUEUES                         = C.IFLA_NUM_RX_QUEUES
	IFLA_CARRIER                               = C.IFLA_CARRIER
	IFLA_PHYS_PORT_ID                          = C.IFLA_PHYS_PORT_ID
	IFLA_CARRIER_CHANGES                       = C.IFLA_CARRIER_CHANGES
	IFLA_PHYS_SWITCH_ID                        = C.IFLA_PHYS_SWITCH_ID
	IFLA_LINK_NETNSID                          = C.IFLA_LINK_NETNSID
	IFLA_PHYS_PORT_NAME                        = C.IFLA_PHYS_PORT_NAME
	IFLA_PROTO_DOWN                            = C.IFLA_PROTO_DOWN
	IFLA_GSO_MAX_SEGS                          = C.IFLA_GSO_MAX_SEGS
	IFLA_GSO_MAX_SIZE                          = C.IFLA_GSO_MAX_SIZE
	IFLA_PAD                                   = C.IFLA_PAD
	IFLA_XDP                                   = C.IFLA_XDP
	IFLA_EVENT                                 = C.IFLA_EVENT
	IFLA_NEW_NETNSID                           = C.IFLA_NEW_NETNSID
	IFLA_IF_NETNSID                            = C.IFLA_IF_NETNSID
	IFLA_TARGET_NETNSID                        = C.IFLA_TARGET_NETNSID
	IFLA_CARRIER_UP_COUNT                      = C.IFLA_CARRIER_UP_COUNT
	IFLA_CARRIER_DOWN_COUNT                    = C.IFLA_CARRIER_DOWN_COUNT
	IFLA_NEW_IFINDEX                           = C.IFLA_NEW_IFINDEX
	IFLA_MIN_MTU                               = C.IFLA_MIN_MTU
	IFLA_MAX_MTU                               = C.IFLA_MAX_MTU
	IFLA_PROP_LIST                             = C.IFLA_PROP_LIST
	IFLA_ALT_IFNAME                            = C.IFLA_ALT_IFNAME
	IFLA_PERM_ADDRESS                          = C.IFLA_PERM_ADDRESS
	IFLA_PROTO_DOWN_REASON                     = C.IFLA_PROTO_DOWN_REASON
	IFLA_PROTO_DOWN_REASON_UNSPEC              = C.IFLA_PROTO_DOWN_REASON_UNSPEC
	IFLA_PROTO_DOWN_REASON_MASK                = C.IFLA_PROTO_DOWN_REASON_MASK
	IFLA_PROTO_DOWN_REASON_VALUE               = C.IFLA_PROTO_DOWN_REASON_VALUE
	IFLA_PROTO_DOWN_REASON_MAX                 = C.IFLA_PROTO_DOWN_REASON_MAX
	IFLA_INET_UNSPEC                           = C.IFLA_INET_UNSPEC
	IFLA_INET_CONF                             = C.IFLA_INET_CONF
	IFLA_INET6_UNSPEC                          = C.IFLA_INET6_UNSPEC
	IFLA_INET6_FLAGS                           = C.IFLA_INET6_FLAGS
	IFLA_INET6_CONF                            = C.IFLA_INET6_CONF
	IFLA_INET6_STATS                           = C.IFLA_INET6_STATS
	IFLA_INET6_MCAST                           = C.IFLA_INET6_MCAST
	IFLA_INET6_CACHEINFO                       = C.IFLA_INET6_CACHEINFO
	IFLA_INET6_ICMP6STATS                      = C.IFLA_INET6_ICMP6STATS
	IFLA_INET6_TOKEN                           = C.IFLA_INET6_TOKEN
	IFLA_INET6_ADDR_GEN_MODE                   = C.IFLA_INET6_ADDR_GEN_MODE
	IFLA_BR_UNSPEC                             = C.IFLA_BR_UNSPEC
	IFLA_BR_FORWARD_DELAY                      = C.IFLA_BR_FORWARD_DELAY
	IFLA_BR_HELLO_TIME                         = C.IFLA_BR_HELLO_TIME
	IFLA_BR_MAX_AGE                            = C.IFLA_BR_MAX_AGE
	IFLA_BR_AGEING_TIME                        = C.IFLA_BR_AGEING_TIME
	IFLA_BR_STP_STATE                          = C.IFLA_BR_STP_STATE
	IFLA_BR_PRIORITY                           = C.IFLA_BR_PRIORITY
	IFLA_BR_VLAN_FILTERING                     = C.IFLA_BR_VLAN_FILTERING
	IFLA_BR_VLAN_PROTOCOL                      = C.IFLA_BR_VLAN_PROTOCOL
	IFLA_BR_GROUP_FWD_MASK                     = C.IFLA_BR_GROUP_FWD_MASK
	IFLA_BR_ROOT_ID                            = C.IFLA_BR_ROOT_ID
	IFLA_BR_BRIDGE_ID                          = C.IFLA_BR_BRIDGE_ID
	IFLA_BR_ROOT_PORT                          = C.IFLA_BR_ROOT_PORT
	IFLA_BR_ROOT_PATH_COST                     = C.IFLA_BR_ROOT_PATH_COST
	IFLA_BR_TOPOLOGY_CHANGE                    = C.IFLA_BR_TOPOLOGY_CHANGE
	IFLA_BR_TOPOLOGY_CHANGE_DETECTED           = C.IFLA_BR_TOPOLOGY_CHANGE_DETECTED
	IFLA_BR_HELLO_TIMER                        = C.IFLA_BR_HELLO_TIMER
	IFLA_BR_TCN_TIMER                          = C.IFLA_BR_TCN_TIMER
	IFLA_BR_TOPOLOGY_CHANGE_TIMER              = C.IFLA_BR_TOPOLOGY_CHANGE_TIMER
	IFLA_BR_GC_TIMER                           = C.IFLA_BR_GC_TIMER
	IFLA_BR_GROUP_ADDR                         = C.IFLA_BR_GROUP_ADDR
	IFLA_BR_FDB_FLUSH                          = C.IFLA_BR_FDB_FLUSH
	IFLA_BR_MCAST_ROUTER                       = C.IFLA_BR_MCAST_ROUTER
	IFLA_BR_MCAST_SNOOPING                     = C.IFLA_BR_MCAST_SNOOPING
	IFLA_BR_MCAST_QUERY_USE_IFADDR             = C.IFLA_BR_MCAST_QUERY_USE_IFADDR
	IFLA_BR_MCAST_QUERIER                      = C.IFLA_BR_MCAST_QUERIER
	IFLA_BR_MCAST_HASH_ELASTICITY              = C.IFLA_BR_MCAST_HASH_ELASTICITY
	IFLA_BR_MCAST_HASH_MAX                     = C.IFLA_BR_MCAST_HASH_MAX
	IFLA_BR_MCAST_LAST_MEMBER_CNT              = C.IFLA_BR_MCAST_LAST_MEMBER_CNT
	IFLA_BR_MCAST_STARTUP_QUERY_CNT            = C.IFLA_BR_MCAST_STARTUP_QUERY_CNT
	IFLA_BR_MCAST_LAST_MEMBER_INTVL            = C.IFLA_BR_MCAST_LAST_MEMBER_INTVL
	IFLA_BR_MCAST_MEMBERSHIP_INTVL             = C.IFLA_BR_MCAST_MEMBERSHIP_INTVL
	IFLA_BR_MCAST_QUERIER_INTVL                = C.IFLA_BR_MCAST_QUERIER_INTVL
	IFLA_BR_MCAST_QUERY_INTVL                  = C.IFLA_BR_MCAST_QUERY_INTVL
	IFLA_BR_MCAST_QUERY_RESPONSE_INTVL         = C.IFLA_BR_MCAST_QUERY_RESPONSE_INTVL
	IFLA_BR_MCAST_STARTUP_QUERY_INTVL          = C.IFLA_BR_MCAST_STARTUP_QUERY_INTVL
	IFLA_BR_NF_CALL_IPTABLES                   = C.IFLA_BR_NF_CALL_IPTABLES
	IFLA_BR_NF_CALL_IP6TABLES                  = C.IFLA_BR_NF_CALL_IP6TABLES
	IFLA_BR_NF_CALL_ARPTABLES                  = C.IFLA_BR_NF_CALL_ARPTABLES
	IFLA_BR_VLAN_DEFAULT_PVID                  = C.IFLA_BR_VLAN_DEFAULT_PVID
	IFLA_BR_PAD                                = C.IFLA_BR_PAD
	IFLA_BR_VLAN_STATS_ENABLED                 = C.IFLA_BR_VLAN_STATS_ENABLED
	IFLA_BR_MCAST_STATS_ENABLED                = C.IFLA_BR_MCAST_STATS_ENABLED
	IFLA_BR_MCAST_IGMP_VERSION                 = C.IFLA_BR_MCAST_IGMP_VERSION
	IFLA_BR_MCAST_MLD_VERSION                  = C.IFLA_BR_MCAST_MLD_VERSION
	IFLA_BR_VLAN_STATS_PER_PORT                = C.IFLA_BR_VLAN_STATS_PER_PORT
	IFLA_BR_MULTI_BOOLOPT                      = C.IFLA_BR_MULTI_BOOLOPT
	IFLA_BRPORT_UNSPEC                         = C.IFLA_BRPORT_UNSPEC
	IFLA_BRPORT_STATE                          = C.IFLA_BRPORT_STATE
	IFLA_BRPORT_PRIORITY                       = C.IFLA_BRPORT_PRIORITY
	IFLA_BRPORT_COST                           = C.IFLA_BRPORT_COST
	IFLA_BRPORT_MODE                           = C.IFLA_BRPORT_MODE
	IFLA_BRPORT_GUARD                          = C.IFLA_BRPORT_GUARD
	IFLA_BRPORT_PROTECT                        = C.IFLA_BRPORT_PROTECT
	IFLA_BRPORT_FAST_LEAVE                     = C.IFLA_BRPORT_FAST_LEAVE
	IFLA_BRPORT_LEARNING                       = C.IFLA_BRPORT_LEARNING
	IFLA_BRPORT_UNICAST_FLOOD                  = C.IFLA_BRPORT_UNICAST_FLOOD
	IFLA_BRPORT_PROXYARP                       = C.IFLA_BRPORT_PROXYARP
	IFLA_BRPORT_LEARNING_SYNC                  = C.IFLA_BRPORT_LEARNING_SYNC
	IFLA_BRPORT_PROXYARP_WIFI                  = C.IFLA_BRPORT_PROXYARP_WIFI
	IFLA_BRPORT_ROOT_ID                        = C.IFLA_BRPORT_ROOT_ID
	IFLA_BRPORT_BRIDGE_ID                      = C.IFLA_BRPORT_BRIDGE_ID
	IFLA_BRPORT_DESIGNATED_PORT                = C.IFLA_BRPORT_DESIGNATED_PORT
	IFLA_BRPORT_DESIGNATED_COST                = C.IFLA_BRPORT_DESIGNATED_COST
	IFLA_BRPORT_ID                             = C.IFLA_BRPORT_ID
	IFLA_BRPORT_NO                             = C.IFLA_BRPORT_NO
	IFLA_BRPORT_TOPOLOGY_CHANGE_ACK            = C.IFLA_BRPORT_TOPOLOGY_CHANGE_ACK
	IFLA_BRPORT_CONFIG_PENDING                 = C.IFLA_BRPORT_CONFIG_PENDING
	IFLA_BRPORT_MESSAGE_AGE_TIMER              = C.IFLA_BRPORT_MESSAGE_AGE_TIMER
	IFLA_BRPORT_FORWARD_DELAY_TIMER            = C.IFLA_BRPORT_FORWARD_DELAY_TIMER
	IFLA_BRPORT_HOLD_TIMER                     = C.IFLA_BRPORT_HOLD_TIMER
	IFLA_BRPORT_FLUSH                          = C.IFLA_BRPORT_FLUSH
	IFLA_BRPORT_MULTICAST_ROUTER               = C.IFLA_BRPORT_MULTICAST_ROUTER
	IFLA_BRPORT_PAD                            = C.IFLA_BRPORT_PAD
	IFLA_BRPORT_MCAST_FLOOD                    = C.IFLA_BRPORT_MCAST_FLOOD
	IFLA_BRPORT_MCAST_TO_UCAST                 = C.IFLA_BRPORT_MCAST_TO_UCAST
	IFLA_BRPORT_VLAN_TUNNEL                    = C.IFLA_BRPORT_VLAN_TUNNEL
	IFLA_BRPORT_BCAST_FLOOD                    = C.IFLA_BRPORT_BCAST_FLOOD
	IFLA_BRPORT_GROUP_FWD_MASK                 = C.IFLA_BRPORT_GROUP_FWD_MASK
	IFLA_BRPORT_NEIGH_SUPPRESS                 = C.IFLA_BRPORT_NEIGH_SUPPRESS
	IFLA_BRPORT_ISOLATED                       = C.IFLA_BRPORT_ISOLATED
	IFLA_BRPORT_BACKUP_PORT                    = C.IFLA_BRPORT_BACKUP_PORT
	IFLA_BRPORT_MRP_RING_OPEN                  = C.IFLA_BRPORT_MRP_RING_OPEN
	IFLA_BRPORT_MRP_IN_OPEN                    = C.IFLA_BRPORT_MRP_IN_OPEN
	IFLA_INFO_UNSPEC                           = C.IFLA_INFO_UNSPEC
	IFLA_INFO_KIND                             = C.IFLA_INFO_KIND
	IFLA_INFO_DATA                             = C.IFLA_INFO_DATA
	IFLA_INFO_XSTATS                           = C.IFLA_INFO_XSTATS
	IFLA_INFO_SLAVE_KIND                       = C.IFLA_INFO_SLAVE_KIND
	IFLA_INFO_SLAVE_DATA                       = C.IFLA_INFO_SLAVE_DATA
	IFLA_VLAN_UNSPEC                           = C.IFLA_VLAN_UNSPEC
	IFLA_VLAN_ID                               = C.IFLA_VLAN_ID
	IFLA_VLAN_FLAGS                            = C.IFLA_VLAN_FLAGS
	IFLA_VLAN_EGRESS_QOS                       = C.IFLA_VLAN_EGRESS_QOS
	IFLA_VLAN_INGRESS_QOS                      = C.IFLA_VLAN_INGRESS_QOS
	IFLA_VLAN_PROTOCOL                         = C.IFLA_VLAN_PROTOCOL
	IFLA_VLAN_QOS_UNSPEC                       = C.IFLA_VLAN_QOS_UNSPEC
	IFLA_VLAN_QOS_MAPPING                      = C.IFLA_VLAN_QOS_MAPPING
	IFLA_MACVLAN_UNSPEC                        = C.IFLA_MACVLAN_UNSPEC
	IFLA_MACVLAN_MODE                          = C.IFLA_MACVLAN_MODE
	IFLA_MACVLAN_FLAGS                         = C.IFLA_MACVLAN_FLAGS
	IFLA_MACVLAN_MACADDR_MODE                  = C.IFLA_MACVLAN_MACADDR_MODE
	IFLA_MACVLAN_MACADDR                       = C.IFLA_MACVLAN_MACADDR
	IFLA_MACVLAN_MACADDR_DATA                  = C.IFLA_MACVLAN_MACADDR_DATA
	IFLA_MACVLAN_MACADDR_COUNT                 = C.IFLA_MACVLAN_MACADDR_COUNT
	IFLA_VRF_UNSPEC                            = C.IFLA_VRF_UNSPEC
	IFLA_VRF_TABLE                             = C.IFLA_VRF_TABLE
	IFLA_VRF_PORT_UNSPEC                       = C.IFLA_VRF_PORT_UNSPEC
	IFLA_VRF_PORT_TABLE                        = C.IFLA_VRF_PORT_TABLE
	IFLA_MACSEC_UNSPEC                         = C.IFLA_MACSEC_UNSPEC
	IFLA_MACSEC_SCI                            = C.IFLA_MACSEC_SCI
	IFLA_MACSEC_PORT                           = C.IFLA_MACSEC_PORT
	IFLA_MACSEC_ICV_LEN                        = C.IFLA_MACSEC_ICV_LEN
	IFLA_MACSEC_CIPHER_SUITE                   = C.IFLA_MACSEC_CIPHER_SUITE
	IFLA_MACSEC_WINDOW                         = C.IFLA_MACSEC_WINDOW
	IFLA_MACSEC_ENCODING_SA                    = C.IFLA_MACSEC_ENCODING_SA
	IFLA_MACSEC_ENCRYPT                        = C.IFLA_MACSEC_ENCRYPT
	IFLA_MACSEC_PROTECT                        = C.IFLA_MACSEC_PROTECT
	IFLA_MACSEC_INC_SCI                        = C.IFLA_MACSEC_INC_SCI
	IFLA_MACSEC_ES                             = C.IFLA_MACSEC_ES
	IFLA_MACSEC_SCB                            = C.IFLA_MACSEC_SCB
	IFLA_MACSEC_REPLAY_PROTECT                 = C.IFLA_MACSEC_REPLAY_PROTECT
	IFLA_MACSEC_VALIDATION                     = C.IFLA_MACSEC_VALIDATION
	IFLA_MACSEC_PAD                            = C.IFLA_MACSEC_PAD
	IFLA_MACSEC_OFFLOAD                        = C.IFLA_MACSEC_OFFLOAD
	IFLA_XFRM_UNSPEC                           = C.IFLA_XFRM_UNSPEC
	IFLA_XFRM_LINK                             = C.IFLA_XFRM_LINK
	IFLA_XFRM_IF_ID                            = C.IFLA_XFRM_IF_ID
	IFLA_IPVLAN_UNSPEC                         = C.IFLA_IPVLAN_UNSPEC
	IFLA_IPVLAN_MODE                           = C.IFLA_IPVLAN_MODE
	IFLA_IPVLAN_FLAGS                          = C.IFLA_IPVLAN_FLAGS
	IFLA_VXLAN_UNSPEC                          = C.IFLA_VXLAN_UNSPEC
	IFLA_VXLAN_ID                              = C.IFLA_VXLAN_ID
	IFLA_VXLAN_GROUP                           = C.IFLA_VXLAN_GROUP
	IFLA_VXLAN_LINK                            = C.IFLA_VXLAN_LINK
	IFLA_VXLAN_LOCAL                           = C.IFLA_VXLAN_LOCAL
	IFLA_VXLAN_TTL                             = C.IFLA_VXLAN_TTL
	IFLA_VXLAN_TOS                             = C.IFLA_VXLAN_TOS
	IFLA_VXLAN_LEARNING                        = C.IFLA_VXLAN_LEARNING
	IFLA_VXLAN_AGEING                          = C.IFLA_VXLAN_AGEING
	IFLA_VXLAN_LIMIT                           = C.IFLA_VXLAN_LIMIT
	IFLA_VXLAN_PORT_RANGE                      = C.IFLA_VXLAN_PORT_RANGE
	IFLA_VXLAN_PROXY                           = C.IFLA_VXLAN_PROXY
	IFLA_VXLAN_RSC                             = C.IFLA_VXLAN_RSC
	IFLA_VXLAN_L2MISS                          = C.IFLA_VXLAN_L2MISS
	IFLA_VXLAN_L3MISS                          = C.IFLA_VXLAN_L3MISS
	IFLA_VXLAN_PORT                            = C.IFLA_VXLAN_PORT
	IFLA_VXLAN_GROUP6                          = C.IFLA_VXLAN_GROUP6
	IFLA_VXLAN_LOCAL6                          = C.IFLA_VXLAN_LOCAL6
	IFLA_VXLAN_UDP_CSUM                        = C.IFLA_VXLAN_UDP_CSUM
	IFLA_VXLAN_UDP_ZERO_CSUM6_TX               = C.IFLA_VXLAN_UDP_ZERO_CSUM6_TX
	IFLA_VXLAN_UDP_ZERO_CSUM6_RX               = C.IFLA_VXLAN_UDP_ZERO_CSUM6_RX
	IFLA_VXLAN_REMCSUM_TX                      = C.IFLA_VXLAN_REMCSUM_TX
	IFLA_VXLAN_REMCSUM_RX                      = C.IFLA_VXLAN_REMCSUM_RX
	IFLA_VXLAN_GBP                             = C.IFLA_VXLAN_GBP
	IFLA_VXLAN_REMCSUM_NOPARTIAL               = C.IFLA_VXLAN_REMCSUM_NOPARTIAL
	IFLA_VXLAN_COLLECT_METADATA                = C.IFLA_VXLAN_COLLECT_METADATA
	IFLA_VXLAN_LABEL                           = C.IFLA_VXLAN_LABEL
	IFLA_VXLAN_GPE                             = C.IFLA_VXLAN_GPE
	IFLA_VXLAN_TTL_INHERIT                     = C.IFLA_VXLAN_TTL_INHERIT
	IFLA_VXLAN_DF                              = C.IFLA_VXLAN_DF
	IFLA_GENEVE_UNSPEC                         = C.IFLA_GENEVE_UNSPEC
	IFLA_GENEVE_ID                             = C.IFLA_GENEVE_ID
	IFLA_GENEVE_REMOTE                         = C.IFLA_GENEVE_REMOTE
	IFLA_GENEVE_TTL                            = C.IFLA_GENEVE_TTL
	IFLA_GENEVE_TOS                            = C.IFLA_GENEVE_TOS
	IFLA_GENEVE_PORT                           = C.IFLA_GENEVE_PORT
	IFLA_GENEVE_COLLECT_METADATA               = C.IFLA_GENEVE_COLLECT_METADATA
	IFLA_GENEVE_REMOTE6                        = C.IFLA_GENEVE_REMOTE6
	IFLA_GENEVE_UDP_CSUM                       = C.IFLA_GENEVE_UDP_CSUM
	IFLA_GENEVE_UDP_ZERO_CSUM6_TX              = C.IFLA_GENEVE_UDP_ZERO_CSUM6_TX
	IFLA_GENEVE_UDP_ZERO_CSUM6_RX              = C.IFLA_GENEVE_UDP_ZERO_CSUM6_RX
	IFLA_GENEVE_LABEL                          = C.IFLA_GENEVE_LABEL
	IFLA_GENEVE_TTL_INHERIT                    = C.IFLA_GENEVE_TTL_INHERIT
	IFLA_GENEVE_DF                             = C.IFLA_GENEVE_DF
	IFLA_BAREUDP_UNSPEC                        = C.IFLA_BAREUDP_UNSPEC
	IFLA_BAREUDP_PORT                          = C.IFLA_BAREUDP_PORT
	IFLA_BAREUDP_ETHERTYPE                     = C.IFLA_BAREUDP_ETHERTYPE
	IFLA_BAREUDP_SRCPORT_MIN                   = C.IFLA_BAREUDP_SRCPORT_MIN
	IFLA_BAREUDP_MULTIPROTO_MODE               = C.IFLA_BAREUDP_MULTIPROTO_MODE
	IFLA_PPP_UNSPEC                            = C.IFLA_PPP_UNSPEC
	IFLA_PPP_DEV_FD                            = C.IFLA_PPP_DEV_FD
	IFLA_GTP_UNSPEC                            = C.IFLA_GTP_UNSPEC
	IFLA_GTP_FD0                               = C.IFLA_GTP_FD0
	IFLA_GTP_FD1                               = C.IFLA_GTP_FD1
	IFLA_GTP_PDP_HASHSIZE                      = C.IFLA_GTP_PDP_HASHSIZE
	IFLA_GTP_ROLE                              = C.IFLA_GTP_ROLE
	IFLA_BOND_UNSPEC                           = C.IFLA_BOND_UNSPEC
	IFLA_BOND_MODE                             = C.IFLA_BOND_MODE
	IFLA_BOND_ACTIVE_SLAVE                     = C.IFLA_BOND_ACTIVE_SLAVE
	IFLA_BOND_MIIMON                           = C.IFLA_BOND_MIIMON
	IFLA_BOND_UPDELAY                          = C.IFLA_BOND_UPDELAY
	IFLA_BOND_DOWNDELAY                        = C.IFLA_BOND_DOWNDELAY
	IFLA_BOND_USE_CARRIER                      = C.IFLA_BOND_USE_CARRIER
	IFLA_BOND_ARP_INTERVAL                     = C.IFLA_BOND_ARP_INTERVAL
	IFLA_BOND_ARP_IP_TARGET                    = C.IFLA_BOND_ARP_IP_TARGET
	IFLA_BOND_ARP_VALIDATE                     = C.IFLA_BOND_ARP_VALIDATE
	IFLA_BOND_ARP_ALL_TARGETS                  = C.IFLA_BOND_ARP_ALL_TARGETS
	IFLA_BOND_PRIMARY                          = C.IFLA_BOND_PRIMARY
	IFLA_BOND_PRIMARY_RESELECT                 = C.IFLA_BOND_PRIMARY_RESELECT
	IFLA_BOND_FAIL_OVER_MAC                    = C.IFLA_BOND_FAIL_OVER_MAC
	IFLA_BOND_XMIT_HASH_POLICY                 = C.IFLA_BOND_XMIT_HASH_POLICY
	IFLA_BOND_RESEND_IGMP                      = C.IFLA_BOND_RESEND_IGMP
	IFLA_BOND_NUM_PEER_NOTIF                   = C.IFLA_BOND_NUM_PEER_NOTIF
	IFLA_BOND_ALL_SLAVES_ACTIVE                = C.IFLA_BOND_ALL_SLAVES_ACTIVE
	IFLA_BOND_MIN_LINKS                        = C.IFLA_BOND_MIN_LINKS
	IFLA_BOND_LP_INTERVAL                      = C.IFLA_BOND_LP_INTERVAL
	IFLA_BOND_PACKETS_PER_SLAVE                = C.IFLA_BOND_PACKETS_PER_SLAVE
	IFLA_BOND_AD_LACP_RATE                     = C.IFLA_BOND_AD_LACP_RATE
	IFLA_BOND_AD_SELECT                        = C.IFLA_BOND_AD_SELECT
	IFLA_BOND_AD_INFO                          = C.IFLA_BOND_AD_INFO
	IFLA_BOND_AD_ACTOR_SYS_PRIO                = C.IFLA_BOND_AD_ACTOR_SYS_PRIO
	IFLA_BOND_AD_USER_PORT_KEY                 = C.IFLA_BOND_AD_USER_PORT_KEY
	IFLA_BOND_AD_ACTOR_SYSTEM                  = C.IFLA_BOND_AD_ACTOR_SYSTEM
	IFLA_BOND_TLB_DYNAMIC_LB                   = C.IFLA_BOND_TLB_DYNAMIC_LB
	IFLA_BOND_PEER_NOTIF_DELAY                 = C.IFLA_BOND_PEER_NOTIF_DELAY
	IFLA_BOND_AD_INFO_UNSPEC                   = C.IFLA_BOND_AD_INFO_UNSPEC
	IFLA_BOND_AD_INFO_AGGREGATOR               = C.IFLA_BOND_AD_INFO_AGGREGATOR
	IFLA_BOND_AD_INFO_NUM_PORTS                = C.IFLA_BOND_AD_INFO_NUM_PORTS
	IFLA_BOND_AD_INFO_ACTOR_KEY                = C.IFLA_BOND_AD_INFO_ACTOR_KEY
	IFLA_BOND_AD_INFO_PARTNER_KEY              = C.IFLA_BOND_AD_INFO_PARTNER_KEY
	IFLA_BOND_AD_INFO_PARTNER_MAC              = C.IFLA_BOND_AD_INFO_PARTNER_MAC
	IFLA_BOND_SLAVE_UNSPEC                     = C.IFLA_BOND_SLAVE_UNSPEC
	IFLA_BOND_SLAVE_STATE                      = C.IFLA_BOND_SLAVE_STATE
	IFLA_BOND_SLAVE_MII_STATUS                 = C.IFLA_BOND_SLAVE_MII_STATUS
	IFLA_BOND_SLAVE_LINK_FAILURE_COUNT         = C.IFLA_BOND_SLAVE_LINK_FAILURE_COUNT
	IFLA_BOND_SLAVE_PERM_HWADDR                = C.IFLA_BOND_SLAVE_PERM_HWADDR
	IFLA_BOND_SLAVE_QUEUE_ID                   = C.IFLA_BOND_SLAVE_QUEUE_ID
	IFLA_BOND_SLAVE_AD_AGGREGATOR_ID           = C.IFLA_BOND_SLAVE_AD_AGGREGATOR_ID
	IFLA_BOND_SLAVE_AD_ACTOR_OPER_PORT_STATE   = C.IFLA_BOND_SLAVE_AD_ACTOR_OPER_PORT_STATE
	IFLA_BOND_SLAVE_AD_PARTNER_OPER_PORT_STATE = C.IFLA_BOND_SLAVE_AD_PARTNER_OPER_PORT_STATE
	IFLA_VF_INFO_UNSPEC                        = C.IFLA_VF_INFO_UNSPEC
	IFLA_VF_INFO                               = C.IFLA_VF_INFO
	IFLA_VF_UNSPEC                             = C.IFLA_VF_UNSPEC
	IFLA_VF_MAC                                = C.IFLA_VF_MAC
	IFLA_VF_VLAN                               = C.IFLA_VF_VLAN
	IFLA_VF_TX_RATE                            = C.IFLA_VF_TX_RATE
	IFLA_VF_SPOOFCHK                           = C.IFLA_VF_SPOOFCHK
	IFLA_VF_LINK_STATE                         = C.IFLA_VF_LINK_STATE
	IFLA_VF_RATE                               = C.IFLA_VF_RATE
	IFLA_VF_RSS_QUERY_EN                       = C.IFLA_VF_RSS_QUERY_EN
	IFLA_VF_STATS                              = C.IFLA_VF_STATS
	IFLA_VF_TRUST                              = C.IFLA_VF_TRUST
	IFLA_VF_IB_NODE_GUID                       = C.IFLA_VF_IB_NODE_GUID
	IFLA_VF_IB_PORT_GUID                       = C.IFLA_VF_IB_PORT_GUID
	IFLA_VF_VLAN_LIST                          = C.IFLA_VF_VLAN_LIST
	IFLA_VF_BROADCAST                          = C.IFLA_VF_BROADCAST
	IFLA_VF_VLAN_INFO_UNSPEC                   = C.IFLA_VF_VLAN_INFO_UNSPEC
	IFLA_VF_VLAN_INFO                          = C.IFLA_VF_VLAN_INFO
	IFLA_VF_LINK_STATE_AUTO                    = C.IFLA_VF_LINK_STATE_AUTO
	IFLA_VF_LINK_STATE_ENABLE                  = C.IFLA_VF_LINK_STATE_ENABLE
	IFLA_VF_LINK_STATE_DISABLE                 = C.IFLA_VF_LINK_STATE_DISABLE
	IFLA_VF_STATS_RX_PACKETS                   = C.IFLA_VF_STATS_RX_PACKETS
	IFLA_VF_STATS_TX_PACKETS                   = C.IFLA_VF_STATS_TX_PACKETS
	IFLA_VF_STATS_RX_BYTES                     = C.IFLA_VF_STATS_RX_BYTES
	IFLA_VF_STATS_TX_BYTES                     = C.IFLA_VF_STATS_TX_BYTES
	IFLA_VF_STATS_BROADCAST                    = C.IFLA_VF_STATS_BROADCAST
	IFLA_VF_STATS_MULTICAST                    = C.IFLA_VF_STATS_MULTICAST
	IFLA_VF_STATS_PAD                          = C.IFLA_VF_STATS_PAD
	IFLA_VF_STATS_RX_DROPPED                   = C.IFLA_VF_STATS_RX_DROPPED
	IFLA_VF_STATS_TX_DROPPED                   = C.IFLA_VF_STATS_TX_DROPPED
	IFLA_VF_PORT_UNSPEC                        = C.IFLA_VF_PORT_UNSPEC
	IFLA_VF_PORT                               = C.IFLA_VF_PORT
	IFLA_PORT_UNSPEC                           = C.IFLA_PORT_UNSPEC
	IFLA_PORT_VF                               = C.IFLA_PORT_VF
	IFLA_PORT_PROFILE                          = C.IFLA_PORT_PROFILE
	IFLA_PORT_VSI_TYPE                         = C.IFLA_PORT_VSI_TYPE
	IFLA_PORT_INSTANCE_UUID                    = C.IFLA_PORT_INSTANCE_UUID
	IFLA_PORT_HOST_UUID                        = C.IFLA_PORT_HOST_UUID
	IFLA_PORT_REQUEST                          = C.IFLA_PORT_REQUEST
	IFLA_PORT_RESPONSE                         = C.IFLA_PORT_RESPONSE
	IFLA_IPOIB_UNSPEC                          = C.IFLA_IPOIB_UNSPEC
	IFLA_IPOIB_PKEY                            = C.IFLA_IPOIB_PKEY
	IFLA_IPOIB_MODE                            = C.IFLA_IPOIB_MODE
	IFLA_IPOIB_UMCAST                          = C.IFLA_IPOIB_UMCAST
	IFLA_HSR_UNSPEC                            = C.IFLA_HSR_UNSPEC
	IFLA_HSR_SLAVE1                            = C.IFLA_HSR_SLAVE1
	IFLA_HSR_SLAVE2                            = C.IFLA_HSR_SLAVE2
	IFLA_HSR_MULTICAST_SPEC                    = C.IFLA_HSR_MULTICAST_SPEC
	IFLA_HSR_SUPERVISION_ADDR                  = C.IFLA_HSR_SUPERVISION_ADDR
	IFLA_HSR_SEQ_NR                            = C.IFLA_HSR_SEQ_NR
	IFLA_HSR_VERSION                           = C.IFLA_HSR_VERSION
	IFLA_HSR_PROTOCOL                          = C.IFLA_HSR_PROTOCOL
	IFLA_STATS_UNSPEC                          = C.IFLA_STATS_UNSPEC
	IFLA_STATS_LINK_64                         = C.IFLA_STATS_LINK_64
	IFLA_STATS_LINK_XSTATS                     = C.IFLA_STATS_LINK_XSTATS
	IFLA_STATS_LINK_XSTATS_SLAVE               = C.IFLA_STATS_LINK_XSTATS_SLAVE
	IFLA_STATS_LINK_OFFLOAD_XSTATS             = C.IFLA_STATS_LINK_OFFLOAD_XSTATS
	IFLA_STATS_AF_SPEC                         = C.IFLA_STATS_AF_SPEC
	IFLA_OFFLOAD_XSTATS_UNSPEC                 = C.IFLA_OFFLOAD_XSTATS_UNSPEC
	IFLA_OFFLOAD_XSTATS_CPU_HIT                = C.IFLA_OFFLOAD_XSTATS_CPU_HIT
	IFLA_XDP_UNSPEC                            = C.IFLA_XDP_UNSPEC
	IFLA_XDP_FD                                = C.IFLA_XDP_FD
	IFLA_XDP_ATTACHED                          = C.IFLA_XDP_ATTACHED
	IFLA_XDP_FLAGS                             = C.IFLA_XDP_FLAGS
	IFLA_XDP_PROG_ID                           = C.IFLA_XDP_PROG_ID
	IFLA_XDP_DRV_PROG_ID                       = C.IFLA_XDP_DRV_PROG_ID
	IFLA_XDP_SKB_PROG_ID                       = C.IFLA_XDP_SKB_PROG_ID
	IFLA_XDP_HW_PROG_ID                        = C.IFLA_XDP_HW_PROG_ID
	IFLA_XDP_EXPECTED_FD                       = C.IFLA_XDP_EXPECTED_FD
	IFLA_EVENT_NONE                            = C.IFLA_EVENT_NONE
	IFLA_EVENT_REBOOT                          = C.IFLA_EVENT_REBOOT
	IFLA_EVENT_FEATURES                        = C.IFLA_EVENT_FEATURES
	IFLA_EVENT_BONDING_FAILOVER                = C.IFLA_EVENT_BONDING_FAILOVER
	IFLA_EVENT_NOTIFY_PEERS                    = C.IFLA_EVENT_NOTIFY_PEERS
	IFLA_EVENT_IGMP_RESEND                     = C.IFLA_EVENT_IGMP_RESEND
	IFLA_EVENT_BONDING_OPTIONS                 = C.IFLA_EVENT_BONDING_OPTIONS
	IFLA_TUN_UNSPEC                            = C.IFLA_TUN_UNSPEC
	IFLA_TUN_OWNER                             = C.IFLA_TUN_OWNER
	IFLA_TUN_GROUP                             = C.IFLA_TUN_GROUP
	IFLA_TUN_TYPE                              = C.IFLA_TUN_TYPE
	IFLA_TUN_PI                                = C.IFLA_TUN_PI
	IFLA_TUN_VNET_HDR                          = C.IFLA_TUN_VNET_HDR
	IFLA_TUN_PERSIST                           = C.IFLA_TUN_PERSIST
	IFLA_TUN_MULTI_QUEUE                       = C.IFLA_TUN_MULTI_QUEUE
	IFLA_TUN_NUM_QUEUES                        = C.IFLA_TUN_NUM_QUEUES
	IFLA_TUN_NUM_DISABLED_QUEUES               = C.IFLA_TUN_NUM_DISABLED_QUEUES
	IFLA_RMNET_UNSPEC                          = C.IFLA_RMNET_UNSPEC
	IFLA_RMNET_MUX_ID                          = C.IFLA_RMNET_MUX_ID
	IFLA_RMNET_FLAGS                           = C.IFLA_RMNET_FLAGS
)

// netfilter
// generated using:
// perl -nlE '/^\s*(NF\w+)/ && say "$1 = C.$1"' /usr/include/linux/netfilter.h
const (
	NF_INET_PRE_ROUTING  = C.NF_INET_PRE_ROUTING
	NF_INET_LOCAL_IN     = C.NF_INET_LOCAL_IN
	NF_INET_FORWARD      = C.NF_INET_FORWARD
	NF_INET_LOCAL_OUT    = C.NF_INET_LOCAL_OUT
	NF_INET_POST_ROUTING = C.NF_INET_POST_ROUTING
	NF_INET_NUMHOOKS     = C.NF_INET_NUMHOOKS
)

const (
	NF_NETDEV_INGRESS  = C.NF_NETDEV_INGRESS
	NF_NETDEV_EGRESS   = C.NF_NETDEV_EGRESS
	NF_NETDEV_NUMHOOKS = C.NF_NETDEV_NUMHOOKS
)

const (
	NFPROTO_UNSPEC   = C.NFPROTO_UNSPEC
	NFPROTO_INET     = C.NFPROTO_INET
	NFPROTO_IPV4     = C.NFPROTO_IPV4
	NFPROTO_ARP      = C.NFPROTO_ARP
	NFPROTO_NETDEV   = C.NFPROTO_NETDEV
	NFPROTO_BRIDGE   = C.NFPROTO_BRIDGE
	NFPROTO_IPV6     = C.NFPROTO_IPV6
	NFPROTO_DECNET   = C.NFPROTO_DECNET
	NFPROTO_NUMPROTO = C.NFPROTO_NUMPROTO
)

const SO_ORIGINAL_DST = C.SO_ORIGINAL_DST

// netfilter nfnetlink
type Nfgenmsg C.struct_nfgenmsg

const (
	NFNL_BATCH_UNSPEC = C.NFNL_BATCH_UNSPEC
	NFNL_BATCH_GENID  = C.NFNL_BATCH_GENID
)

// netfilter nf_tables
// generated using:
// perl -nlE '/^\s*(NFT\w+)/ && say "$1 = C.$1"' /usr/include/linux/netfilter/nf_tables.h
const (
	NFT_REG_VERDICT                   = C.NFT_REG_VERDICT
	NFT_REG_1                         = C.NFT_REG_1
	NFT_REG_2                         = C.NFT_REG_2
	NFT_REG_3                         = C.NFT_REG_3
	NFT_REG_4                         = C.NFT_REG_4
	NFT_REG32_00                      = C.NFT_REG32_00
	NFT_REG32_01                      = C.NFT_REG32_01
	NFT_REG32_02                      = C.NFT_REG32_02
	NFT_REG32_03                      = C.NFT_REG32_03
	NFT_REG32_04                      = C.NFT_REG32_04
	NFT_REG32_05                      = C.NFT_REG32_05
	NFT_REG32_06                      = C.NFT_REG32_06
	NFT_REG32_07                      = C.NFT_REG32_07
	NFT_REG32_08                      = C.NFT_REG32_08
	NFT_REG32_09                      = C.NFT_REG32_09
	NFT_REG32_10                      = C.NFT_REG32_10
	NFT_REG32_11                      = C.NFT_REG32_11
	NFT_REG32_12                      = C.NFT_REG32_12
	NFT_REG32_13                      = C.NFT_REG32_13
	NFT_REG32_14                      = C.NFT_REG32_14
	NFT_REG32_15                      = C.NFT_REG32_15
	NFT_CONTINUE                      = C.NFT_CONTINUE
	NFT_BREAK                         = C.NFT_BREAK
	NFT_JUMP                          = C.NFT_JUMP
	NFT_GOTO                          = C.NFT_GOTO
	NFT_RETURN                        = C.NFT_RETURN
	NFT_MSG_NEWTABLE                  = C.NFT_MSG_NEWTABLE
	NFT_MSG_GETTABLE                  = C.NFT_MSG_GETTABLE
	NFT_MSG_DELTABLE                  = C.NFT_MSG_DELTABLE
	NFT_MSG_NEWCHAIN                  = C.NFT_MSG_NEWCHAIN
	NFT_MSG_GETCHAIN                  = C.NFT_MSG_GETCHAIN
	NFT_MSG_DELCHAIN                  = C.NFT_MSG_DELCHAIN
	NFT_MSG_NEWRULE                   = C.NFT_MSG_NEWRULE
	NFT_MSG_GETRULE                   = C.NFT_MSG_GETRULE
	NFT_MSG_DELRULE                   = C.NFT_MSG_DELRULE
	NFT_MSG_NEWSET                    = C.NFT_MSG_NEWSET
	NFT_MSG_GETSET                    = C.NFT_MSG_GETSET
	NFT_MSG_DELSET                    = C.NFT_MSG_DELSET
	NFT_MSG_NEWSETELEM                = C.NFT_MSG_NEWSETELEM
	NFT_MSG_GETSETELEM                = C.NFT_MSG_GETSETELEM
	NFT_MSG_DELSETELEM                = C.NFT_MSG_DELSETELEM
	NFT_MSG_NEWGEN                    = C.NFT_MSG_NEWGEN
	NFT_MSG_GETGEN                    = C.NFT_MSG_GETGEN
	NFT_MSG_TRACE                     = C.NFT_MSG_TRACE
	NFT_MSG_NEWOBJ                    = C.NFT_MSG_NEWOBJ
	NFT_MSG_GETOBJ                    = C.NFT_MSG_GETOBJ
	NFT_MSG_DELOBJ                    = C.NFT_MSG_DELOBJ
	NFT_MSG_GETOBJ_RESET              = C.NFT_MSG_GETOBJ_RESET
	NFT_MSG_MAX                       = C.NFT_MSG_MAX
	NFTA_LIST_UNSPEC                  = C.NFTA_LIST_UNSPEC
	NFTA_LIST_ELEM                    = C.NFTA_LIST_ELEM
	NFTA_HOOK_UNSPEC                  = C.NFTA_HOOK_UNSPEC
	NFTA_HOOK_HOOKNUM                 = C.NFTA_HOOK_HOOKNUM
	NFTA_HOOK_PRIORITY                = C.NFTA_HOOK_PRIORITY
	NFTA_HOOK_DEV                     = C.NFTA_HOOK_DEV
	NFT_TABLE_F_DORMANT               = C.NFT_TABLE_F_DORMANT
	NFTA_TABLE_UNSPEC                 = C.NFTA_TABLE_UNSPEC
	NFTA_TABLE_NAME                   = C.NFTA_TABLE_NAME
	NFTA_TABLE_FLAGS                  = C.NFTA_TABLE_FLAGS
	NFTA_TABLE_USE                    = C.NFTA_TABLE_USE
	NFTA_CHAIN_UNSPEC                 = C.NFTA_CHAIN_UNSPEC
	NFTA_CHAIN_TABLE                  = C.NFTA_CHAIN_TABLE
	NFTA_CHAIN_HANDLE                 = C.NFTA_CHAIN_HANDLE
	NFTA_CHAIN_NAME                   = C.NFTA_CHAIN_NAME
	NFTA_CHAIN_HOOK                   = C.NFTA_CHAIN_HOOK
	NFTA_CHAIN_POLICY                 = C.NFTA_CHAIN_POLICY
	NFTA_CHAIN_USE                    = C.NFTA_CHAIN_USE
	NFTA_CHAIN_TYPE                   = C.NFTA_CHAIN_TYPE
	NFTA_CHAIN_COUNTERS               = C.NFTA_CHAIN_COUNTERS
	NFTA_CHAIN_PAD                    = C.NFTA_CHAIN_PAD
	NFTA_RULE_UNSPEC                  = C.NFTA_RULE_UNSPEC
	NFTA_RULE_TABLE                   = C.NFTA_RULE_TABLE
	NFTA_RULE_CHAIN                   = C.NFTA_RULE_CHAIN
	NFTA_RULE_HANDLE                  = C.NFTA_RULE_HANDLE
	NFTA_RULE_EXPRESSIONS             = C.NFTA_RULE_EXPRESSIONS
	NFTA_RULE_COMPAT                  = C.NFTA_RULE_COMPAT
	NFTA_RULE_POSITION                = C.NFTA_RULE_POSITION
	NFTA_RULE_USERDATA                = C.NFTA_RULE_USERDATA
	NFTA_RULE_PAD                     = C.NFTA_RULE_PAD
	NFTA_RULE_ID                      = C.NFTA_RULE_ID
	NFT_RULE_COMPAT_F_INV             = C.NFT_RULE_COMPAT_F_INV
	NFT_RULE_COMPAT_F_MASK            = C.NFT_RULE_COMPAT_F_MASK
	NFTA_RULE_COMPAT_UNSPEC           = C.NFTA_RULE_COMPAT_UNSPEC
	NFTA_RULE_COMPAT_PROTO            = C.NFTA_RULE_COMPAT_PROTO
	NFTA_RULE_COMPAT_FLAGS            = C.NFTA_RULE_COMPAT_FLAGS
	NFT_SET_ANONYMOUS                 = C.NFT_SET_ANONYMOUS
	NFT_SET_CONSTANT                  = C.NFT_SET_CONSTANT
	NFT_SET_INTERVAL                  = C.NFT_SET_INTERVAL
	NFT_SET_MAP                       = C.NFT_SET_MAP
	NFT_SET_TIMEOUT                   = C.NFT_SET_TIMEOUT
	NFT_SET_EVAL                      = C.NFT_SET_EVAL
	NFT_SET_OBJECT                    = C.NFT_SET_OBJECT
	NFT_SET_POL_PERFORMANCE           = C.NFT_SET_POL_PERFORMANCE
	NFT_SET_POL_MEMORY                = C.NFT_SET_POL_MEMORY
	NFTA_SET_DESC_UNSPEC              = C.NFTA_SET_DESC_UNSPEC
	NFTA_SET_DESC_SIZE                = C.NFTA_SET_DESC_SIZE
	NFTA_SET_UNSPEC                   = C.NFTA_SET_UNSPEC
	NFTA_SET_TABLE                    = C.NFTA_SET_TABLE
	NFTA_SET_NAME                     = C.NFTA_SET_NAME
	NFTA_SET_FLAGS                    = C.NFTA_SET_FLAGS
	NFTA_SET_KEY_TYPE                 = C.NFTA_SET_KEY_TYPE
	NFTA_SET_KEY_LEN                  = C.NFTA_SET_KEY_LEN
	NFTA_SET_DATA_TYPE                = C.NFTA_SET_DATA_TYPE
	NFTA_SET_DATA_LEN                 = C.NFTA_SET_DATA_LEN
	NFTA_SET_POLICY                   = C.NFTA_SET_POLICY
	NFTA_SET_DESC                     = C.NFTA_SET_DESC
	NFTA_SET_ID                       = C.NFTA_SET_ID
	NFTA_SET_TIMEOUT                  = C.NFTA_SET_TIMEOUT
	NFTA_SET_GC_INTERVAL              = C.NFTA_SET_GC_INTERVAL
	NFTA_SET_USERDATA                 = C.NFTA_SET_USERDATA
	NFTA_SET_PAD                      = C.NFTA_SET_PAD
	NFTA_SET_OBJ_TYPE                 = C.NFTA_SET_OBJ_TYPE
	NFT_SET_ELEM_INTERVAL_END         = C.NFT_SET_ELEM_INTERVAL_END
	NFTA_SET_ELEM_UNSPEC              = C.NFTA_SET_ELEM_UNSPEC
	NFTA_SET_ELEM_KEY                 = C.NFTA_SET_ELEM_KEY
	NFTA_SET_ELEM_DATA                = C.NFTA_SET_ELEM_DATA
	NFTA_SET_ELEM_FLAGS               = C.NFTA_SET_ELEM_FLAGS
	NFTA_SET_ELEM_TIMEOUT             = C.NFTA_SET_ELEM_TIMEOUT
	NFTA_SET_ELEM_EXPIRATION          = C.NFTA_SET_ELEM_EXPIRATION
	NFTA_SET_ELEM_USERDATA            = C.NFTA_SET_ELEM_USERDATA
	NFTA_SET_ELEM_EXPR                = C.NFTA_SET_ELEM_EXPR
	NFTA_SET_ELEM_PAD                 = C.NFTA_SET_ELEM_PAD
	NFTA_SET_ELEM_OBJREF              = C.NFTA_SET_ELEM_OBJREF
	NFTA_SET_ELEM_LIST_UNSPEC         = C.NFTA_SET_ELEM_LIST_UNSPEC
	NFTA_SET_ELEM_LIST_TABLE          = C.NFTA_SET_ELEM_LIST_TABLE
	NFTA_SET_ELEM_LIST_SET            = C.NFTA_SET_ELEM_LIST_SET
	NFTA_SET_ELEM_LIST_ELEMENTS       = C.NFTA_SET_ELEM_LIST_ELEMENTS
	NFTA_SET_ELEM_LIST_SET_ID         = C.NFTA_SET_ELEM_LIST_SET_ID
	NFT_DATA_VALUE                    = C.NFT_DATA_VALUE
	NFT_DATA_VERDICT                  = C.NFT_DATA_VERDICT
	NFTA_DATA_UNSPEC                  = C.NFTA_DATA_UNSPEC
	NFTA_DATA_VALUE                   = C.NFTA_DATA_VALUE
	NFTA_DATA_VERDICT                 = C.NFTA_DATA_VERDICT
	NFTA_VERDICT_UNSPEC               = C.NFTA_VERDICT_UNSPEC
	NFTA_VERDICT_CODE                 = C.NFTA_VERDICT_CODE
	NFTA_VERDICT_CHAIN                = C.NFTA_VERDICT_CHAIN
	NFTA_EXPR_UNSPEC                  = C.NFTA_EXPR_UNSPEC
	NFTA_EXPR_NAME                    = C.NFTA_EXPR_NAME
	NFTA_EXPR_DATA                    = C.NFTA_EXPR_DATA
	NFTA_IMMEDIATE_UNSPEC             = C.NFTA_IMMEDIATE_UNSPEC
	NFTA_IMMEDIATE_DREG               = C.NFTA_IMMEDIATE_DREG
	NFTA_IMMEDIATE_DATA               = C.NFTA_IMMEDIATE_DATA
	NFTA_BITWISE_UNSPEC               = C.NFTA_BITWISE_UNSPEC
	NFTA_BITWISE_SREG                 = C.NFTA_BITWISE_SREG
	NFTA_BITWISE_DREG                 = C.NFTA_BITWISE_DREG
	NFTA_BITWISE_LEN                  = C.NFTA_BITWISE_LEN
	NFTA_BITWISE_MASK                 = C.NFTA_BITWISE_MASK
	NFTA_BITWISE_XOR                  = C.NFTA_BITWISE_XOR
	NFT_BYTEORDER_NTOH                = C.NFT_BYTEORDER_NTOH
	NFT_BYTEORDER_HTON                = C.NFT_BYTEORDER_HTON
	NFTA_BYTEORDER_UNSPEC             = C.NFTA_BYTEORDER_UNSPEC
	NFTA_BYTEORDER_SREG               = C.NFTA_BYTEORDER_SREG
	NFTA_BYTEORDER_DREG               = C.NFTA_BYTEORDER_DREG
	NFTA_BYTEORDER_OP                 = C.NFTA_BYTEORDER_OP
	NFTA_BYTEORDER_LEN                = C.NFTA_BYTEORDER_LEN
	NFTA_BYTEORDER_SIZE               = C.NFTA_BYTEORDER_SIZE
	NFT_CMP_EQ                        = C.NFT_CMP_EQ
	NFT_CMP_NEQ                       = C.NFT_CMP_NEQ
	NFT_CMP_LT                        = C.NFT_CMP_LT
	NFT_CMP_LTE                       = C.NFT_CMP_LTE
	NFT_CMP_GT                        = C.NFT_CMP_GT
	NFT_CMP_GTE                       = C.NFT_CMP_GTE
	NFTA_CMP_UNSPEC                   = C.NFTA_CMP_UNSPEC
	NFTA_CMP_SREG                     = C.NFTA_CMP_SREG
	NFTA_CMP_OP                       = C.NFTA_CMP_OP
	NFTA_CMP_DATA                     = C.NFTA_CMP_DATA
	NFT_RANGE_EQ                      = C.NFT_RANGE_EQ
	NFT_RANGE_NEQ                     = C.NFT_RANGE_NEQ
	NFTA_RANGE_UNSPEC                 = C.NFTA_RANGE_UNSPEC
	NFTA_RANGE_SREG                   = C.NFTA_RANGE_SREG
	NFTA_RANGE_OP                     = C.NFTA_RANGE_OP
	NFTA_RANGE_FROM_DATA              = C.NFTA_RANGE_FROM_DATA
	NFTA_RANGE_TO_DATA                = C.NFTA_RANGE_TO_DATA
	NFT_LOOKUP_F_INV                  = C.NFT_LOOKUP_F_INV
	NFTA_LOOKUP_UNSPEC                = C.NFTA_LOOKUP_UNSPEC
	NFTA_LOOKUP_SET                   = C.NFTA_LOOKUP_SET
	NFTA_LOOKUP_SREG                  = C.NFTA_LOOKUP_SREG
	NFTA_LOOKUP_DREG                  = C.NFTA_LOOKUP_DREG
	NFTA_LOOKUP_SET_ID                = C.NFTA_LOOKUP_SET_ID
	NFTA_LOOKUP_FLAGS                 = C.NFTA_LOOKUP_FLAGS
	NFT_DYNSET_OP_ADD                 = C.NFT_DYNSET_OP_ADD
	NFT_DYNSET_OP_UPDATE              = C.NFT_DYNSET_OP_UPDATE
	NFT_DYNSET_F_INV                  = C.NFT_DYNSET_F_INV
	NFTA_DYNSET_UNSPEC                = C.NFTA_DYNSET_UNSPEC
	NFTA_DYNSET_SET_NAME              = C.NFTA_DYNSET_SET_NAME
	NFTA_DYNSET_SET_ID                = C.NFTA_DYNSET_SET_ID
	NFTA_DYNSET_OP                    = C.NFTA_DYNSET_OP
	NFTA_DYNSET_SREG_KEY              = C.NFTA_DYNSET_SREG_KEY
	NFTA_DYNSET_SREG_DATA             = C.NFTA_DYNSET_SREG_DATA
	NFTA_DYNSET_TIMEOUT               = C.NFTA_DYNSET_TIMEOUT
	NFTA_DYNSET_EXPR                  = C.NFTA_DYNSET_EXPR
	NFTA_DYNSET_PAD                   = C.NFTA_DYNSET_PAD
	NFTA_DYNSET_FLAGS                 = C.NFTA_DYNSET_FLAGS
	NFT_PAYLOAD_LL_HEADER             = C.NFT_PAYLOAD_LL_HEADER
	NFT_PAYLOAD_NETWORK_HEADER        = C.NFT_PAYLOAD_NETWORK_HEADER
	NFT_PAYLOAD_TRANSPORT_HEADER      = C.NFT_PAYLOAD_TRANSPORT_HEADER
	NFT_PAYLOAD_CSUM_NONE             = C.NFT_PAYLOAD_CSUM_NONE
	NFT_PAYLOAD_CSUM_INET             = C.NFT_PAYLOAD_CSUM_INET
	NFT_PAYLOAD_L4CSUM_PSEUDOHDR      = C.NFT_PAYLOAD_L4CSUM_PSEUDOHDR
	NFTA_PAYLOAD_UNSPEC               = C.NFTA_PAYLOAD_UNSPEC
	NFTA_PAYLOAD_DREG                 = C.NFTA_PAYLOAD_DREG
	NFTA_PAYLOAD_BASE                 = C.NFTA_PAYLOAD_BASE
	NFTA_PAYLOAD_OFFSET               = C.NFTA_PAYLOAD_OFFSET
	NFTA_PAYLOAD_LEN                  = C.NFTA_PAYLOAD_LEN
	NFTA_PAYLOAD_SREG                 = C.NFTA_PAYLOAD_SREG
	NFTA_PAYLOAD_CSUM_TYPE            = C.NFTA_PAYLOAD_CSUM_TYPE
	NFTA_PAYLOAD_CSUM_OFFSET          = C.NFTA_PAYLOAD_CSUM_OFFSET
	NFTA_PAYLOAD_CSUM_FLAGS           = C.NFTA_PAYLOAD_CSUM_FLAGS
	NFT_EXTHDR_F_PRESENT              = C.NFT_EXTHDR_F_PRESENT
	NFT_EXTHDR_OP_IPV6                = C.NFT_EXTHDR_OP_IPV6
	NFT_EXTHDR_OP_TCPOPT              = C.NFT_EXTHDR_OP_TCPOPT
	NFTA_EXTHDR_UNSPEC                = C.NFTA_EXTHDR_UNSPEC
	NFTA_EXTHDR_DREG                  = C.NFTA_EXTHDR_DREG
	NFTA_EXTHDR_TYPE                  = C.NFTA_EXTHDR_TYPE
	NFTA_EXTHDR_OFFSET                = C.NFTA_EXTHDR_OFFSET
	NFTA_EXTHDR_LEN                   = C.NFTA_EXTHDR_LEN
	NFTA_EXTHDR_FLAGS                 = C.NFTA_EXTHDR_FLAGS
	NFTA_EXTHDR_OP                    = C.NFTA_EXTHDR_OP
	NFTA_EXTHDR_SREG                  = C.NFTA_EXTHDR_SREG
	NFT_META_LEN                      = C.NFT_META_LEN
	NFT_META_PROTOCOL                 = C.NFT_META_PROTOCOL
	NFT_META_PRIORITY                 = C.NFT_META_PRIORITY
	NFT_META_MARK                     = C.NFT_META_MARK
	NFT_META_IIF                      = C.NFT_META_IIF
	NFT_META_OIF                      = C.NFT_META_OIF
	NFT_META_IIFNAME                  = C.NFT_META_IIFNAME
	NFT_META_OIFNAME                  = C.NFT_META_OIFNAME
	NFT_META_IIFTYPE                  = C.NFT_META_IIFTYPE
	NFT_META_OIFTYPE                  = C.NFT_META_OIFTYPE
	NFT_META_SKUID                    = C.NFT_META_SKUID
	NFT_META_SKGID                    = C.NFT_META_SKGID
	NFT_META_NFTRACE                  = C.NFT_META_NFTRACE
	NFT_META_RTCLASSID                = C.NFT_META_RTCLASSID
	NFT_META_SECMARK                  = C.NFT_META_SECMARK
	NFT_META_NFPROTO                  = C.NFT_META_NFPROTO
	NFT_META_L4PROTO                  = C.NFT_META_L4PROTO
	NFT_META_BRI_IIFNAME              = C.NFT_META_BRI_IIFNAME
	NFT_META_BRI_OIFNAME              = C.NFT_META_BRI_OIFNAME
	NFT_META_PKTTYPE                  = C.NFT_META_PKTTYPE
	NFT_META_CPU                      = C.NFT_META_CPU
	NFT_META_IIFGROUP                 = C.NFT_META_IIFGROUP
	NFT_META_OIFGROUP                 = C.NFT_META_OIFGROUP
	NFT_META_CGROUP                   = C.NFT_META_CGROUP
	NFT_META_PRANDOM                  = C.NFT_META_PRANDOM
	NFT_RT_CLASSID                    = C.NFT_RT_CLASSID
	NFT_RT_NEXTHOP4                   = C.NFT_RT_NEXTHOP4
	NFT_RT_NEXTHOP6                   = C.NFT_RT_NEXTHOP6
	NFT_RT_TCPMSS                     = C.NFT_RT_TCPMSS
	NFT_HASH_JENKINS                  = C.NFT_HASH_JENKINS
	NFT_HASH_SYM                      = C.NFT_HASH_SYM
	NFTA_HASH_UNSPEC                  = C.NFTA_HASH_UNSPEC
	NFTA_HASH_SREG                    = C.NFTA_HASH_SREG
	NFTA_HASH_DREG                    = C.NFTA_HASH_DREG
	NFTA_HASH_LEN                     = C.NFTA_HASH_LEN
	NFTA_HASH_MODULUS                 = C.NFTA_HASH_MODULUS
	NFTA_HASH_SEED                    = C.NFTA_HASH_SEED
	NFTA_HASH_OFFSET                  = C.NFTA_HASH_OFFSET
	NFTA_HASH_TYPE                    = C.NFTA_HASH_TYPE
	NFTA_META_UNSPEC                  = C.NFTA_META_UNSPEC
	NFTA_META_DREG                    = C.NFTA_META_DREG
	NFTA_META_KEY                     = C.NFTA_META_KEY
	NFTA_META_SREG                    = C.NFTA_META_SREG
	NFTA_RT_UNSPEC                    = C.NFTA_RT_UNSPEC
	NFTA_RT_DREG                      = C.NFTA_RT_DREG
	NFTA_RT_KEY                       = C.NFTA_RT_KEY
	NFT_CT_STATE                      = C.NFT_CT_STATE
	NFT_CT_DIRECTION                  = C.NFT_CT_DIRECTION
	NFT_CT_STATUS                     = C.NFT_CT_STATUS
	NFT_CT_MARK                       = C.NFT_CT_MARK
	NFT_CT_SECMARK                    = C.NFT_CT_SECMARK
	NFT_CT_EXPIRATION                 = C.NFT_CT_EXPIRATION
	NFT_CT_HELPER                     = C.NFT_CT_HELPER
	NFT_CT_L3PROTOCOL                 = C.NFT_CT_L3PROTOCOL
	NFT_CT_SRC                        = C.NFT_CT_SRC
	NFT_CT_DST                        = C.NFT_CT_DST
	NFT_CT_PROTOCOL                   = C.NFT_CT_PROTOCOL
	NFT_CT_PROTO_SRC                  = C.NFT_CT_PROTO_SRC
	NFT_CT_PROTO_DST                  = C.NFT_CT_PROTO_DST
	NFT_CT_LABELS                     = C.NFT_CT_LABELS
	NFT_CT_PKTS                       = C.NFT_CT_PKTS
	NFT_CT_BYTES                      = C.NFT_CT_BYTES
	NFT_CT_AVGPKT                     = C.NFT_CT_AVGPKT
	NFT_CT_ZONE                       = C.NFT_CT_ZONE
	NFT_CT_EVENTMASK                  = C.NFT_CT_EVENTMASK
	NFTA_CT_UNSPEC                    = C.NFTA_CT_UNSPEC
	NFTA_CT_DREG                      = C.NFTA_CT_DREG
	NFTA_CT_KEY                       = C.NFTA_CT_KEY
	NFTA_CT_DIRECTION                 = C.NFTA_CT_DIRECTION
	NFTA_CT_SREG                      = C.NFTA_CT_SREG
	NFT_LIMIT_PKTS                    = C.NFT_LIMIT_PKTS
	NFT_LIMIT_PKT_BYTES               = C.NFT_LIMIT_PKT_BYTES
	NFT_LIMIT_F_INV                   = C.NFT_LIMIT_F_INV
	NFTA_LIMIT_UNSPEC                 = C.NFTA_LIMIT_UNSPEC
	NFTA_LIMIT_RATE                   = C.NFTA_LIMIT_RATE
	NFTA_LIMIT_UNIT                   = C.NFTA_LIMIT_UNIT
	NFTA_LIMIT_BURST                  = C.NFTA_LIMIT_BURST
	NFTA_LIMIT_TYPE                   = C.NFTA_LIMIT_TYPE
	NFTA_LIMIT_FLAGS                  = C.NFTA_LIMIT_FLAGS
	NFTA_LIMIT_PAD                    = C.NFTA_LIMIT_PAD
	NFTA_COUNTER_UNSPEC               = C.NFTA_COUNTER_UNSPEC
	NFTA_COUNTER_BYTES                = C.NFTA_COUNTER_BYTES
	NFTA_COUNTER_PACKETS              = C.NFTA_COUNTER_PACKETS
	NFTA_COUNTER_PAD                  = C.NFTA_COUNTER_PAD
	NFTA_LOG_UNSPEC                   = C.NFTA_LOG_UNSPEC
	NFTA_LOG_GROUP                    = C.NFTA_LOG_GROUP
	NFTA_LOG_PREFIX                   = C.NFTA_LOG_PREFIX
	NFTA_LOG_SNAPLEN                  = C.NFTA_LOG_SNAPLEN
	NFTA_LOG_QTHRESHOLD               = C.NFTA_LOG_QTHRESHOLD
	NFTA_LOG_LEVEL                    = C.NFTA_LOG_LEVEL
	NFTA_LOG_FLAGS                    = C.NFTA_LOG_FLAGS
	NFTA_QUEUE_UNSPEC                 = C.NFTA_QUEUE_UNSPEC
	NFTA_QUEUE_NUM                    = C.NFTA_QUEUE_NUM
	NFTA_QUEUE_TOTAL                  = C.NFTA_QUEUE_TOTAL
	NFTA_QUEUE_FLAGS                  = C.NFTA_QUEUE_FLAGS
	NFTA_QUEUE_SREG_QNUM              = C.NFTA_QUEUE_SREG_QNUM
	NFT_QUOTA_F_INV                   = C.NFT_QUOTA_F_INV
	NFT_QUOTA_F_DEPLETED              = C.NFT_QUOTA_F_DEPLETED
	NFTA_QUOTA_UNSPEC                 = C.NFTA_QUOTA_UNSPEC
	NFTA_QUOTA_BYTES                  = C.NFTA_QUOTA_BYTES
	NFTA_QUOTA_FLAGS                  = C.NFTA_QUOTA_FLAGS
	NFTA_QUOTA_PAD                    = C.NFTA_QUOTA_PAD
	NFTA_QUOTA_CONSUMED               = C.NFTA_QUOTA_CONSUMED
	NFT_REJECT_ICMP_UNREACH           = C.NFT_REJECT_ICMP_UNREACH
	NFT_REJECT_TCP_RST                = C.NFT_REJECT_TCP_RST
	NFT_REJECT_ICMPX_UNREACH          = C.NFT_REJECT_ICMPX_UNREACH
	NFT_REJECT_ICMPX_NO_ROUTE         = C.NFT_REJECT_ICMPX_NO_ROUTE
	NFT_REJECT_ICMPX_PORT_UNREACH     = C.NFT_REJECT_ICMPX_PORT_UNREACH
	NFT_REJECT_ICMPX_HOST_UNREACH     = C.NFT_REJECT_ICMPX_HOST_UNREACH
	NFT_REJECT_ICMPX_ADMIN_PROHIBITED = C.NFT_REJECT_ICMPX_ADMIN_PROHIBITED
	NFTA_REJECT_UNSPEC                = C.NFTA_REJECT_UNSPEC
	NFTA_REJECT_TYPE                  = C.NFTA_REJECT_TYPE
	NFTA_REJECT_ICMP_CODE             = C.NFTA_REJECT_ICMP_CODE
	NFT_NAT_SNAT                      = C.NFT_NAT_SNAT
	NFT_NAT_DNAT                      = C.NFT_NAT_DNAT
	NFTA_NAT_UNSPEC                   = C.NFTA_NAT_UNSPEC
	NFTA_NAT_TYPE                     = C.NFTA_NAT_TYPE
	NFTA_NAT_FAMILY                   = C.NFTA_NAT_FAMILY
	NFTA_NAT_REG_ADDR_MIN             = C.NFTA_NAT_REG_ADDR_MIN
	NFTA_NAT_REG_ADDR_MAX             = C.NFTA_NAT_REG_ADDR_MAX
	NFTA_NAT_REG_PROTO_MIN            = C.NFTA_NAT_REG_PROTO_MIN
	NFTA_NAT_REG_PROTO_MAX            = C.NFTA_NAT_REG_PROTO_MAX
	NFTA_NAT_FLAGS                    = C.NFTA_NAT_FLAGS
	NFTA_MASQ_UNSPEC                  = C.NFTA_MASQ_UNSPEC
	NFTA_MASQ_FLAGS                   = C.NFTA_MASQ_FLAGS
	NFTA_MASQ_REG_PROTO_MIN           = C.NFTA_MASQ_REG_PROTO_MIN
	NFTA_MASQ_REG_PROTO_MAX           = C.NFTA_MASQ_REG_PROTO_MAX
	NFTA_REDIR_UNSPEC                 = C.NFTA_REDIR_UNSPEC
	NFTA_REDIR_REG_PROTO_MIN          = C.NFTA_REDIR_REG_PROTO_MIN
	NFTA_REDIR_REG_PROTO_MAX          = C.NFTA_REDIR_REG_PROTO_MAX
	NFTA_REDIR_FLAGS                  = C.NFTA_REDIR_FLAGS
	NFTA_DUP_UNSPEC                   = C.NFTA_DUP_UNSPEC
	NFTA_DUP_SREG_ADDR                = C.NFTA_DUP_SREG_ADDR
	NFTA_DUP_SREG_DEV                 = C.NFTA_DUP_SREG_DEV
	NFTA_FWD_UNSPEC                   = C.NFTA_FWD_UNSPEC
	NFTA_FWD_SREG_DEV                 = C.NFTA_FWD_SREG_DEV
	NFTA_OBJREF_UNSPEC                = C.NFTA_OBJREF_UNSPEC
	NFTA_OBJREF_IMM_TYPE              = C.NFTA_OBJREF_IMM_TYPE
	NFTA_OBJREF_IMM_NAME              = C.NFTA_OBJREF_IMM_NAME
	NFTA_OBJREF_SET_SREG              = C.NFTA_OBJREF_SET_SREG
	NFTA_OBJREF_SET_NAME              = C.NFTA_OBJREF_SET_NAME
	NFTA_OBJREF_SET_ID                = C.NFTA_OBJREF_SET_ID
	NFTA_GEN_UNSPEC                   = C.NFTA_GEN_UNSPEC
	NFTA_GEN_ID                       = C.NFTA_GEN_ID
	NFTA_GEN_PROC_PID                 = C.NFTA_GEN_PROC_PID
	NFTA_GEN_PROC_NAME                = C.NFTA_GEN_PROC_NAME
	NFTA_FIB_UNSPEC                   = C.NFTA_FIB_UNSPEC
	NFTA_FIB_DREG                     = C.NFTA_FIB_DREG
	NFTA_FIB_RESULT                   = C.NFTA_FIB_RESULT
	NFTA_FIB_FLAGS                    = C.NFTA_FIB_FLAGS
	NFT_FIB_RESULT_UNSPEC             = C.NFT_FIB_RESULT_UNSPEC
	NFT_FIB_RESULT_OIF                = C.NFT_FIB_RESULT_OIF
	NFT_FIB_RESULT_OIFNAME            = C.NFT_FIB_RESULT_OIFNAME
	NFT_FIB_RESULT_ADDRTYPE           = C.NFT_FIB_RESULT_ADDRTYPE
	NFTA_FIB_F_SADDR                  = C.NFTA_FIB_F_SADDR
	NFTA_FIB_F_DADDR                  = C.NFTA_FIB_F_DADDR
	NFTA_FIB_F_MARK                   = C.NFTA_FIB_F_MARK
	NFTA_FIB_F_IIF                    = C.NFTA_FIB_F_IIF
	NFTA_FIB_F_OIF                    = C.NFTA_FIB_F_OIF
	NFTA_FIB_F_PRESENT                = C.NFTA_FIB_F_PRESENT
	NFTA_CT_HELPER_UNSPEC             = C.NFTA_CT_HELPER_UNSPEC
	NFTA_CT_HELPER_NAME               = C.NFTA_CT_HELPER_NAME
	NFTA_CT_HELPER_L3PROTO            = C.NFTA_CT_HELPER_L3PROTO
	NFTA_CT_HELPER_L4PROTO            = C.NFTA_CT_HELPER_L4PROTO
	NFTA_OBJ_UNSPEC                   = C.NFTA_OBJ_UNSPEC
	NFTA_OBJ_TABLE                    = C.NFTA_OBJ_TABLE
	NFTA_OBJ_NAME                     = C.NFTA_OBJ_NAME
	NFTA_OBJ_TYPE                     = C.NFTA_OBJ_TYPE
	NFTA_OBJ_DATA                     = C.NFTA_OBJ_DATA
	NFTA_OBJ_USE                      = C.NFTA_OBJ_USE
	NFTA_TRACE_UNSPEC                 = C.NFTA_TRACE_UNSPEC
	NFTA_TRACE_TABLE                  = C.NFTA_TRACE_TABLE
	NFTA_TRACE_CHAIN                  = C.NFTA_TRACE_CHAIN
	NFTA_TRACE_RULE_HANDLE            = C.NFTA_TRACE_RULE_HANDLE
	NFTA_TRACE_TYPE                   = C.NFTA_TRACE_TYPE
	NFTA_TRACE_VERDICT                = C.NFTA_TRACE_VERDICT
	NFTA_TRACE_ID                     = C.NFTA_TRACE_ID
	NFTA_TRACE_LL_HEADER              = C.NFTA_TRACE_LL_HEADER
	NFTA_TRACE_NETWORK_HEADER         = C.NFTA_TRACE_NETWORK_HEADER
	NFTA_TRACE_TRANSPORT_HEADER       = C.NFTA_TRACE_TRANSPORT_HEADER
	NFTA_TRACE_IIF                    = C.NFTA_TRACE_IIF
	NFTA_TRACE_IIFTYPE                = C.NFTA_TRACE_IIFTYPE
	NFTA_TRACE_OIF                    = C.NFTA_TRACE_OIF
	NFTA_TRACE_OIFTYPE                = C.NFTA_TRACE_OIFTYPE
	NFTA_TRACE_MARK                   = C.NFTA_TRACE_MARK
	NFTA_TRACE_NFPROTO                = C.NFTA_TRACE_NFPROTO
	NFTA_TRACE_POLICY                 = C.NFTA_TRACE_POLICY
	NFTA_TRACE_PAD                    = C.NFTA_TRACE_PAD
	NFT_TRACETYPE_UNSPEC              = C.NFT_TRACETYPE_UNSPEC
	NFT_TRACETYPE_POLICY              = C.NFT_TRACETYPE_POLICY
	NFT_TRACETYPE_RETURN              = C.NFT_TRACETYPE_RETURN
	NFT_TRACETYPE_RULE                = C.NFT_TRACETYPE_RULE
	NFTA_NG_UNSPEC                    = C.NFTA_NG_UNSPEC
	NFTA_NG_DREG                      = C.NFTA_NG_DREG
	NFTA_NG_MODULUS                   = C.NFTA_NG_MODULUS
	NFTA_NG_TYPE                      = C.NFTA_NG_TYPE
	NFTA_NG_OFFSET                    = C.NFTA_NG_OFFSET
	NFT_NG_INCREMENTAL                = C.NFT_NG_INCREMENTAL
	NFT_NG_RANDOM                     = C.NFT_NG_RANDOM
)

// netfilter nf_tables_compat
// generated using:
// perl -nlE '/^\s*(NFT\w+)/ && say "$1 = C.$1"' /usr/include/linux/netfilter/nf_tables_compat.h
const (
	NFTA_TARGET_UNSPEC = C.NFTA_TARGET_UNSPEC
	NFTA_TARGET_NAME   = C.NFTA_TARGET_NAME
	NFTA_TARGET_REV    = C.NFTA_TARGET_REV
	NFTA_TARGET_INFO   = C.NFTA_TARGET_INFO
	NFTA_MATCH_UNSPEC  = C.NFTA_MATCH_UNSPEC
	NFTA_MATCH_NAME    = C.NFTA_MATCH_NAME
	NFTA_MATCH_REV     = C.NFTA_MATCH_REV
	NFTA_MATCH_INFO    = C.NFTA_MATCH_INFO
	NFTA_COMPAT_UNSPEC = C.NFTA_COMPAT_UNSPEC
	NFTA_COMPAT_NAME   = C.NFTA_COMPAT_NAME
	NFTA_COMPAT_REV    = C.NFTA_COMPAT_REV
	NFTA_COMPAT_TYPE   = C.NFTA_COMPAT_TYPE
)

type RTCTime C.struct_rtc_time

type RTCWkAlrm C.struct_rtc_wkalrm

type RTCPLLInfo C.struct_rtc_pll_info

// BLKPG ioctl:

type BlkpgIoctlArg C.struct_blkpg_ioctl_arg

type BlkpgPartition C.struct_my_blkpg_partition

const (
	BLKPG                  = C.BLKPG
	BLKPG_ADD_PARTITION    = C.BLKPG_ADD_PARTITION
	BLKPG_DEL_PARTITION    = C.BLKPG_DEL_PARTITION
	BLKPG_RESIZE_PARTITION = C.BLKPG_RESIZE_PARTITION
)

// netlink namespace
// generated from
// perl -nlE '/^\s*(NETNSA\w+)/ && say "$1 = C.$1"' /usr/include/linux/net_namespace.h
const (
	NETNSA_NONE         = C.NETNSA_NONE
	NETNSA_NSID         = C.NETNSA_NSID
	NETNSA_PID          = C.NETNSA_PID
	NETNSA_FD           = C.NETNSA_FD
	NETNSA_TARGET_NSID  = C.NETNSA_TARGET_NSID
	NETNSA_CURRENT_NSID = C.NETNSA_CURRENT_NSID
)

// AF_XDP:

type XDPRingOffset C.struct_xdp_ring_offset

type XDPMmapOffsets C.struct_xdp_mmap_offsets

type XDPUmemReg C.struct_xdp_umem_reg

type XDPStatistics C.struct_xdp_statistics

type XDPDesc C.struct_xdp_desc

// NCSI generic netlink:

const (
	NCSI_CMD_UNSPEC                 = C.NCSI_CMD_UNSPEC
	NCSI_CMD_PKG_INFO               = C.NCSI_CMD_PKG_INFO
	NCSI_CMD_SET_INTERFACE          = C.NCSI_CMD_SET_INTERFACE
	NCSI_CMD_CLEAR_INTERFACE        = C.NCSI_CMD_CLEAR_INTERFACE
	NCSI_ATTR_UNSPEC                = C.NCSI_ATTR_UNSPEC
	NCSI_ATTR_IFINDEX               = C.NCSI_ATTR_IFINDEX
	NCSI_ATTR_PACKAGE_LIST          = C.NCSI_ATTR_PACKAGE_LIST
	NCSI_ATTR_PACKAGE_ID            = C.NCSI_ATTR_PACKAGE_ID
	NCSI_ATTR_CHANNEL_ID            = C.NCSI_ATTR_CHANNEL_ID
	NCSI_PKG_ATTR_UNSPEC            = C.NCSI_PKG_ATTR_UNSPEC
	NCSI_PKG_ATTR                   = C.NCSI_PKG_ATTR
	NCSI_PKG_ATTR_ID                = C.NCSI_PKG_ATTR_ID
	NCSI_PKG_ATTR_FORCED            = C.NCSI_PKG_ATTR_FORCED
	NCSI_PKG_ATTR_CHANNEL_LIST      = C.NCSI_PKG_ATTR_CHANNEL_LIST
	NCSI_CHANNEL_ATTR_UNSPEC        = C.NCSI_CHANNEL_ATTR_UNSPEC
	NCSI_CHANNEL_ATTR               = C.NCSI_CHANNEL_ATTR
	NCSI_CHANNEL_ATTR_ID            = C.NCSI_CHANNEL_ATTR_ID
	NCSI_CHANNEL_ATTR_VERSION_MAJOR = C.NCSI_CHANNEL_ATTR_VERSION_MAJOR
	NCSI_CHANNEL_ATTR_VERSION_MINOR = C.NCSI_CHANNEL_ATTR_VERSION_MINOR
	NCSI_CHANNEL_ATTR_VERSION_STR   = C.NCSI_CHANNEL_ATTR_VERSION_STR
	NCSI_CHANNEL_ATTR_LINK_STATE    = C.NCSI_CHANNEL_ATTR_LINK_STATE
	NCSI_CHANNEL_ATTR_ACTIVE        = C.NCSI_CHANNEL_ATTR_ACTIVE
	NCSI_CHANNEL_ATTR_FORCED        = C.NCSI_CHANNEL_ATTR_FORCED
	NCSI_CHANNEL_ATTR_VLAN_LIST     = C.NCSI_CHANNEL_ATTR_VLAN_LIST
	NCSI_CHANNEL_ATTR_VLAN_ID       = C.NCSI_CHANNEL_ATTR_VLAN_ID
)

// Timestamping

type ScmTimestamping C.struct_scm_timestamping

const (
	SOF_TIMESTAMPING_TX_HARDWARE  = C.SOF_TIMESTAMPING_TX_HARDWARE
	SOF_TIMESTAMPING_TX_SOFTWARE  = C.SOF_TIMESTAMPING_TX_SOFTWARE
	SOF_TIMESTAMPING_RX_HARDWARE  = C.SOF_TIMESTAMPING_RX_HARDWARE
	SOF_TIMESTAMPING_RX_SOFTWARE  = C.SOF_TIMESTAMPING_RX_SOFTWARE
	SOF_TIMESTAMPING_SOFTWARE     = C.SOF_TIMESTAMPING_SOFTWARE
	SOF_TIMESTAMPING_SYS_HARDWARE = C.SOF_TIMESTAMPING_SYS_HARDWARE
	SOF_TIMESTAMPING_RAW_HARDWARE = C.SOF_TIMESTAMPING_RAW_HARDWARE
	SOF_TIMESTAMPING_OPT_ID       = C.SOF_TIMESTAMPING_OPT_ID
	SOF_TIMESTAMPING_TX_SCHED     = C.SOF_TIMESTAMPING_TX_SCHED
	SOF_TIMESTAMPING_TX_ACK       = C.SOF_TIMESTAMPING_TX_ACK
	SOF_TIMESTAMPING_OPT_CMSG     = C.SOF_TIMESTAMPING_OPT_CMSG
	SOF_TIMESTAMPING_OPT_TSONLY   = C.SOF_TIMESTAMPING_OPT_TSONLY
	SOF_TIMESTAMPING_OPT_STATS    = C.SOF_TIMESTAMPING_OPT_STATS
	SOF_TIMESTAMPING_OPT_PKTINFO  = C.SOF_TIMESTAMPING_OPT_PKTINFO
	SOF_TIMESTAMPING_OPT_TX_SWHW  = C.SOF_TIMESTAMPING_OPT_TX_SWHW

	SOF_TIMESTAMPING_LAST = C.SOF_TIMESTAMPING_LAST
	SOF_TIMESTAMPING_MASK = C.SOF_TIMESTAMPING_MASK

	SCM_TSTAMP_SND   = C.SCM_TSTAMP_SND
	SCM_TSTAMP_SCHED = C.SCM_TSTAMP_SCHED
	SCM_TSTAMP_ACK   = C.SCM_TSTAMP_ACK
)

// Socket error queue

type SockExtendedErr C.struct_sock_extended_err

// Fanotify

type FanotifyEventMetadata C.struct_fanotify_event_metadata

type FanotifyResponse C.struct_fanotify_response

// Crypto user configuration API.

const (
	CRYPTO_MSG_BASE      = C.CRYPTO_MSG_BASE
	CRYPTO_MSG_NEWALG    = C.CRYPTO_MSG_NEWALG
	CRYPTO_MSG_DELALG    = C.CRYPTO_MSG_DELALG
	CRYPTO_MSG_UPDATEALG = C.CRYPTO_MSG_UPDATEALG
	CRYPTO_MSG_GETALG    = C.CRYPTO_MSG_GETALG
	CRYPTO_MSG_DELRNG    = C.CRYPTO_MSG_DELRNG
	CRYPTO_MSG_GETSTAT   = C.CRYPTO_MSG_GETSTAT
)

const (
	CRYPTOCFGA_UNSPEC           = C.CRYPTOCFGA_UNSPEC
	CRYPTOCFGA_PRIORITY_VAL     = C.CRYPTOCFGA_PRIORITY_VAL
	CRYPTOCFGA_REPORT_LARVAL    = C.CRYPTOCFGA_REPORT_LARVAL
	CRYPTOCFGA_REPORT_HASH      = C.CRYPTOCFGA_REPORT_HASH
	CRYPTOCFGA_REPORT_BLKCIPHER = C.CRYPTOCFGA_REPORT_BLKCIPHER
	CRYPTOCFGA_REPORT_AEAD      = C.CRYPTOCFGA_REPORT_AEAD
	CRYPTOCFGA_REPORT_COMPRESS  = C.CRYPTOCFGA_REPORT_COMPRESS
	CRYPTOCFGA_REPORT_RNG       = C.CRYPTOCFGA_REPORT_RNG
	CRYPTOCFGA_REPORT_CIPHER    = C.CRYPTOCFGA_REPORT_CIPHER
	CRYPTOCFGA_REPORT_AKCIPHER  = C.CRYPTOCFGA_REPORT_AKCIPHER
	CRYPTOCFGA_REPORT_KPP       = C.CRYPTOCFGA_REPORT_KPP
	CRYPTOCFGA_REPORT_ACOMP     = C.CRYPTOCFGA_REPORT_ACOMP
	CRYPTOCFGA_STAT_LARVAL      = C.CRYPTOCFGA_STAT_LARVAL
	CRYPTOCFGA_STAT_HASH        = C.CRYPTOCFGA_STAT_HASH
	CRYPTOCFGA_STAT_BLKCIPHER   = C.CRYPTOCFGA_STAT_BLKCIPHER
	CRYPTOCFGA_STAT_AEAD        = C.CRYPTOCFGA_STAT_AEAD
	CRYPTOCFGA_STAT_COMPRESS    = C.CRYPTOCFGA_STAT_COMPRESS
	CRYPTOCFGA_STAT_RNG         = C.CRYPTOCFGA_STAT_RNG
	CRYPTOCFGA_STAT_CIPHER      = C.CRYPTOCFGA_STAT_CIPHER
	CRYPTOCFGA_STAT_AKCIPHER    = C.CRYPTOCFGA_STAT_AKCIPHER
	CRYPTOCFGA_STAT_KPP         = C.CRYPTOCFGA_STAT_KPP
	CRYPTOCFGA_STAT_ACOMP       = C.CRYPTOCFGA_STAT_ACOMP
)

type CryptoUserAlg C.struct_crypto_user_alg

type CryptoStatAEAD C.struct_crypto_stat_aead

type CryptoStatAKCipher C.struct_crypto_stat_akcipher

type CryptoStatCipher C.struct_crypto_stat_cipher

type CryptoStatCompress C.struct_crypto_stat_compress

type CryptoStatHash C.struct_crypto_stat_hash

type CryptoStatKPP C.struct_crypto_stat_kpp

type CryptoStatRNG C.struct_crypto_stat_rng

type CryptoStatLarval C.struct_crypto_stat_larval

type CryptoReportLarval C.struct_crypto_report_larval

type CryptoReportHash C.struct_crypto_report_hash

type CryptoReportCipher C.struct_crypto_report_cipher

type CryptoReportBlkCipher C.struct_crypto_report_blkcipher

type CryptoReportAEAD C.struct_crypto_report_aead

type CryptoReportComp C.struct_crypto_report_comp

type CryptoReportRNG C.struct_crypto_report_rng

type CryptoReportAKCipher C.struct_crypto_report_akcipher

type CryptoReportKPP C.struct_crypto_report_kpp

type CryptoReportAcomp C.struct_crypto_report_acomp

// generated by:
// perl -nlE '/^\s*((TCP_)?BPF_\w+)/ && say "$1 = C.$1"' include/uapi/linux/bpf.h
const (
	BPF_REG_0                                  = C.BPF_REG_0
	BPF_REG_1                                  = C.BPF_REG_1
	BPF_REG_2                                  = C.BPF_REG_2
	BPF_REG_3                                  = C.BPF_REG_3
	BPF_REG_4                                  = C.BPF_REG_4
	BPF_REG_5                                  = C.BPF_REG_5
	BPF_REG_6                                  = C.BPF_REG_6
	BPF_REG_7                                  = C.BPF_REG_7
	BPF_REG_8                                  = C.BPF_REG_8
	BPF_REG_9                                  = C.BPF_REG_9
	BPF_REG_10                                 = C.BPF_REG_10
	BPF_MAP_CREATE                             = C.BPF_MAP_CREATE
	BPF_MAP_LOOKUP_ELEM                        = C.BPF_MAP_LOOKUP_ELEM
	BPF_MAP_UPDATE_ELEM                        = C.BPF_MAP_UPDATE_ELEM
	BPF_MAP_DELETE_ELEM                        = C.BPF_MAP_DELETE_ELEM
	BPF_MAP_GET_NEXT_KEY                       = C.BPF_MAP_GET_NEXT_KEY
	BPF_PROG_LOAD                              = C.BPF_PROG_LOAD
	BPF_OBJ_PIN                                = C.BPF_OBJ_PIN
	BPF_OBJ_GET                                = C.BPF_OBJ_GET
	BPF_PROG_ATTACH                            = C.BPF_PROG_ATTACH
	BPF_PROG_DETACH                            = C.BPF_PROG_DETACH
	BPF_PROG_TEST_RUN                          = C.BPF_PROG_TEST_RUN
	BPF_PROG_GET_NEXT_ID                       = C.BPF_PROG_GET_NEXT_ID
	BPF_MAP_GET_NEXT_ID                        = C.BPF_MAP_GET_NEXT_ID
	BPF_PROG_GET_FD_BY_ID                      = C.BPF_PROG_GET_FD_BY_ID
	BPF_MAP_GET_FD_BY_ID                       = C.BPF_MAP_GET_FD_BY_ID
	BPF_OBJ_GET_INFO_BY_FD                     = C.BPF_OBJ_GET_INFO_BY_FD
	BPF_PROG_QUERY                             = C.BPF_PROG_QUERY
	BPF_RAW_TRACEPOINT_OPEN                    = C.BPF_RAW_TRACEPOINT_OPEN
	BPF_BTF_LOAD                               = C.BPF_BTF_LOAD
	BPF_BTF_GET_FD_BY_ID                       = C.BPF_BTF_GET_FD_BY_ID
	BPF_TASK_FD_QUERY                          = C.BPF_TASK_FD_QUERY
	BPF_MAP_LOOKUP_AND_DELETE_ELEM             = C.BPF_MAP_LOOKUP_AND_DELETE_ELEM
	BPF_MAP_FREEZE                             = C.BPF_MAP_FREEZE
	BPF_BTF_GET_NEXT_ID                        = C.BPF_BTF_GET_NEXT_ID
	BPF_MAP_LOOKUP_BATCH                       = C.BPF_MAP_LOOKUP_BATCH
	BPF_MAP_LOOKUP_AND_DELETE_BATCH            = C.BPF_MAP_LOOKUP_AND_DELETE_BATCH
	BPF_MAP_UPDATE_BATCH                       = C.BPF_MAP_UPDATE_BATCH
	BPF_MAP_DELETE_BATCH                       = C.BPF_MAP_DELETE_BATCH
	BPF_LINK_CREATE                            = C.BPF_LINK_CREATE
	BPF_LINK_UPDATE                            = C.BPF_LINK_UPDATE
	BPF_LINK_GET_FD_BY_ID                      = C.BPF_LINK_GET_FD_BY_ID
	BPF_LINK_GET_NEXT_ID                       = C.BPF_LINK_GET_NEXT_ID
	BPF_ENABLE_STATS                           = C.BPF_ENABLE_STATS
	BPF_ITER_CREATE                            = C.BPF_ITER_CREATE
	BPF_LINK_DETACH                            = C.BPF_LINK_DETACH
	BPF_PROG_BIND_MAP                          = C.BPF_PROG_BIND_MAP
	BPF_MAP_TYPE_UNSPEC                        = C.BPF_MAP_TYPE_UNSPEC
	BPF_MAP_TYPE_HASH                          = C.BPF_MAP_TYPE_HASH
	BPF_MAP_TYPE_ARRAY                         = C.BPF_MAP_TYPE_ARRAY
	BPF_MAP_TYPE_PROG_ARRAY                    = C.BPF_MAP_TYPE_PROG_ARRAY
	BPF_MAP_TYPE_PERF_EVENT_ARRAY              = C.BPF_MAP_TYPE_PERF_EVENT_ARRAY
	BPF_MAP_TYPE_PERCPU_HASH                   = C.BPF_MAP_TYPE_PERCPU_HASH
	BPF_MAP_TYPE_PERCPU_ARRAY                  = C.BPF_MAP_TYPE_PERCPU_ARRAY
	BPF_MAP_TYPE_STACK_TRACE                   = C.BPF_MAP_TYPE_STACK_TRACE
	BPF_MAP_TYPE_CGROUP_ARRAY                  = C.BPF_MAP_TYPE_CGROUP_ARRAY
	BPF_MAP_TYPE_LRU_HASH                      = C.BPF_MAP_TYPE_LRU_HASH
	BPF_MAP_TYPE_LRU_PERCPU_HASH               = C.BPF_MAP_TYPE_LRU_PERCPU_HASH
	BPF_MAP_TYPE_LPM_TRIE                      = C.BPF_MAP_TYPE_LPM_TRIE
	BPF_MAP_TYPE_ARRAY_OF_MAPS                 = C.BPF_MAP_TYPE_ARRAY_OF_MAPS
	BPF_MAP_TYPE_HASH_OF_MAPS                  = C.BPF_MAP_TYPE_HASH_OF_MAPS
	BPF_MAP_TYPE_DEVMAP                        = C.BPF_MAP_TYPE_DEVMAP
	BPF_MAP_TYPE_SOCKMAP                       = C.BPF_MAP_TYPE_SOCKMAP
	BPF_MAP_TYPE_CPUMAP                        = C.BPF_MAP_TYPE_CPUMAP
	BPF_MAP_TYPE_XSKMAP                        = C.BPF_MAP_TYPE_XSKMAP
	BPF_MAP_TYPE_SOCKHASH                      = C.BPF_MAP_TYPE_SOCKHASH
	BPF_MAP_TYPE_CGROUP_STORAGE                = C.BPF_MAP_TYPE_CGROUP_STORAGE
	BPF_MAP_TYPE_REUSEPORT_SOCKARRAY           = C.BPF_MAP_TYPE_REUSEPORT_SOCKARRAY
	BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE         = C.BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE
	BPF_MAP_TYPE_QUEUE                         = C.BPF_MAP_TYPE_QUEUE
	BPF_MAP_TYPE_STACK                         = C.BPF_MAP_TYPE_STACK
	BPF_MAP_TYPE_SK_STORAGE                    = C.BPF_MAP_TYPE_SK_STORAGE
	BPF_MAP_TYPE_DEVMAP_HASH                   = C.BPF_MAP_TYPE_DEVMAP_HASH
	BPF_MAP_TYPE_STRUCT_OPS                    = C.BPF_MAP_TYPE_STRUCT_OPS
	BPF_MAP_TYPE_RINGBUF                       = C.BPF_MAP_TYPE_RINGBUF
	BPF_MAP_TYPE_INODE_STORAGE                 = C.BPF_MAP_TYPE_INODE_STORAGE
	BPF_PROG_TYPE_UNSPEC                       = C.BPF_PROG_TYPE_UNSPEC
	BPF_PROG_TYPE_SOCKET_FILTER                = C.BPF_PROG_TYPE_SOCKET_FILTER
	BPF_PROG_TYPE_KPROBE                       = C.BPF_PROG_TYPE_KPROBE
	BPF_PROG_TYPE_SCHED_CLS                    = C.BPF_PROG_TYPE_SCHED_CLS
	BPF_PROG_TYPE_SCHED_ACT                    = C.BPF_PROG_TYPE_SCHED_ACT
	BPF_PROG_TYPE_TRACEPOINT                   = C.BPF_PROG_TYPE_TRACEPOINT
	BPF_PROG_TYPE_XDP                          = C.BPF_PROG_TYPE_XDP
	BPF_PROG_TYPE_PERF_EVENT                   = C.BPF_PROG_TYPE_PERF_EVENT
	BPF_PROG_TYPE_CGROUP_SKB                   = C.BPF_PROG_TYPE_CGROUP_SKB
	BPF_PROG_TYPE_CGROUP_SOCK                  = C.BPF_PROG_TYPE_CGROUP_SOCK
	BPF_PROG_TYPE_LWT_IN                       = C.BPF_PROG_TYPE_LWT_IN
	BPF_PROG_TYPE_LWT_OUT                      = C.BPF_PROG_TYPE_LWT_OUT
	BPF_PROG_TYPE_LWT_XMIT                     = C.BPF_PROG_TYPE_LWT_XMIT
	BPF_PROG_TYPE_SOCK_OPS                     = C.BPF_PROG_TYPE_SOCK_OPS
	BPF_PROG_TYPE_SK_SKB                       = C.BPF_PROG_TYPE_SK_SKB
	BPF_PROG_TYPE_CGROUP_DEVICE                = C.BPF_PROG_TYPE_CGROUP_DEVICE
	BPF_PROG_TYPE_SK_MSG                       = C.BPF_PROG_TYPE_SK_MSG
	BPF_PROG_TYPE_RAW_TRACEPOINT               = C.BPF_PROG_TYPE_RAW_TRACEPOINT
	BPF_PROG_TYPE_CGROUP_SOCK_ADDR             = C.BPF_PROG_TYPE_CGROUP_SOCK_ADDR
	BPF_PROG_TYPE_LWT_SEG6LOCAL                = C.BPF_PROG_TYPE_LWT_SEG6LOCAL
	BPF_PROG_TYPE_LIRC_MODE2                   = C.BPF_PROG_TYPE_LIRC_MODE2
	BPF_PROG_TYPE_SK_REUSEPORT                 = C.BPF_PROG_TYPE_SK_REUSEPORT
	BPF_PROG_TYPE_FLOW_DISSECTOR               = C.BPF_PROG_TYPE_FLOW_DISSECTOR
	BPF_PROG_TYPE_CGROUP_SYSCTL                = C.BPF_PROG_TYPE_CGROUP_SYSCTL
	BPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE      = C.BPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE
	BPF_PROG_TYPE_CGROUP_SOCKOPT               = C.BPF_PROG_TYPE_CGROUP_SOCKOPT
	BPF_PROG_TYPE_TRACING                      = C.BPF_PROG_TYPE_TRACING
	BPF_PROG_TYPE_STRUCT_OPS                   = C.BPF_PROG_TYPE_STRUCT_OPS
	BPF_PROG_TYPE_EXT                          = C.BPF_PROG_TYPE_EXT
	BPF_PROG_TYPE_LSM                          = C.BPF_PROG_TYPE_LSM
	BPF_PROG_TYPE_SK_LOOKUP                    = C.BPF_PROG_TYPE_SK_LOOKUP
	BPF_CGROUP_INET_INGRESS                    = C.BPF_CGROUP_INET_INGRESS
	BPF_CGROUP_INET_EGRESS                     = C.BPF_CGROUP_INET_EGRESS
	BPF_CGROUP_INET_SOCK_CREATE                = C.BPF_CGROUP_INET_SOCK_CREATE
	BPF_CGROUP_SOCK_OPS                        = C.BPF_CGROUP_SOCK_OPS
	BPF_SK_SKB_STREAM_PARSER                   = C.BPF_SK_SKB_STREAM_PARSER
	BPF_SK_SKB_STREAM_VERDICT                  = C.BPF_SK_SKB_STREAM_VERDICT
	BPF_CGROUP_DEVICE                          = C.BPF_CGROUP_DEVICE
	BPF_SK_MSG_VERDICT                         = C.BPF_SK_MSG_VERDICT
	BPF_CGROUP_INET4_BIND                      = C.BPF_CGROUP_INET4_BIND
	BPF_CGROUP_INET6_BIND                      = C.BPF_CGROUP_INET6_BIND
	BPF_CGROUP_INET4_CONNECT                   = C.BPF_CGROUP_INET4_CONNECT
	BPF_CGROUP_INET6_CONNECT                   = C.BPF_CGROUP_INET6_CONNECT
	BPF_CGROUP_INET4_POST_BIND                 = C.BPF_CGROUP_INET4_POST_BIND
	BPF_CGROUP_INET6_POST_BIND                 = C.BPF_CGROUP_INET6_POST_BIND
	BPF_CGROUP_UDP4_SENDMSG                    = C.BPF_CGROUP_UDP4_SENDMSG
	BPF_CGROUP_UDP6_SENDMSG                    = C.BPF_CGROUP_UDP6_SENDMSG
	BPF_LIRC_MODE2                             = C.BPF_LIRC_MODE2
	BPF_FLOW_DISSECTOR                         = C.BPF_FLOW_DISSECTOR
	BPF_CGROUP_SYSCTL                          = C.BPF_CGROUP_SYSCTL
	BPF_CGROUP_UDP4_RECVMSG                    = C.BPF_CGROUP_UDP4_RECVMSG
	BPF_CGROUP_UDP6_RECVMSG                    = C.BPF_CGROUP_UDP6_RECVMSG
	BPF_CGROUP_GETSOCKOPT                      = C.BPF_CGROUP_GETSOCKOPT
	BPF_CGROUP_SETSOCKOPT                      = C.BPF_CGROUP_SETSOCKOPT
	BPF_TRACE_RAW_TP                           = C.BPF_TRACE_RAW_TP
	BPF_TRACE_FENTRY                           = C.BPF_TRACE_FENTRY
	BPF_TRACE_FEXIT                            = C.BPF_TRACE_FEXIT
	BPF_MODIFY_RETURN                          = C.BPF_MODIFY_RETURN
	BPF_LSM_MAC                                = C.BPF_LSM_MAC
	BPF_TRACE_ITER                             = C.BPF_TRACE_ITER
	BPF_CGROUP_INET4_GETPEERNAME               = C.BPF_CGROUP_INET4_GETPEERNAME
	BPF_CGROUP_INET6_GETPEERNAME               = C.BPF_CGROUP_INET6_GETPEERNAME
	BPF_CGROUP_INET4_GETSOCKNAME               = C.BPF_CGROUP_INET4_GETSOCKNAME
	BPF_CGROUP_INET6_GETSOCKNAME               = C.BPF_CGROUP_INET6_GETSOCKNAME
	BPF_XDP_DEVMAP                             = C.BPF_XDP_DEVMAP
	BPF_CGROUP_INET_SOCK_RELEASE               = C.BPF_CGROUP_INET_SOCK_RELEASE
	BPF_XDP_CPUMAP                             = C.BPF_XDP_CPUMAP
	BPF_SK_LOOKUP                              = C.BPF_SK_LOOKUP
	BPF_XDP                                    = C.BPF_XDP
	BPF_LINK_TYPE_UNSPEC                       = C.BPF_LINK_TYPE_UNSPEC
	BPF_LINK_TYPE_RAW_TRACEPOINT               = C.BPF_LINK_TYPE_RAW_TRACEPOINT
	BPF_LINK_TYPE_TRACING                      = C.BPF_LINK_TYPE_TRACING
	BPF_LINK_TYPE_CGROUP                       = C.BPF_LINK_TYPE_CGROUP
	BPF_LINK_TYPE_ITER                         = C.BPF_LINK_TYPE_ITER
	BPF_LINK_TYPE_NETNS                        = C.BPF_LINK_TYPE_NETNS
	BPF_LINK_TYPE_XDP                          = C.BPF_LINK_TYPE_XDP
	BPF_ANY                                    = C.BPF_ANY
	BPF_NOEXIST                                = C.BPF_NOEXIST
	BPF_EXIST                                  = C.BPF_EXIST
	BPF_F_LOCK                                 = C.BPF_F_LOCK
	BPF_F_NO_PREALLOC                          = C.BPF_F_NO_PREALLOC
	BPF_F_NO_COMMON_LRU                        = C.BPF_F_NO_COMMON_LRU
	BPF_F_NUMA_NODE                            = C.BPF_F_NUMA_NODE
	BPF_F_RDONLY                               = C.BPF_F_RDONLY
	BPF_F_WRONLY                               = C.BPF_F_WRONLY
	BPF_F_STACK_BUILD_ID                       = C.BPF_F_STACK_BUILD_ID
	BPF_F_ZERO_SEED                            = C.BPF_F_ZERO_SEED
	BPF_F_RDONLY_PROG                          = C.BPF_F_RDONLY_PROG
	BPF_F_WRONLY_PROG                          = C.BPF_F_WRONLY_PROG
	BPF_F_CLONE                                = C.BPF_F_CLONE
	BPF_F_MMAPABLE                             = C.BPF_F_MMAPABLE
	BPF_F_PRESERVE_ELEMS                       = C.BPF_F_PRESERVE_ELEMS
	BPF_F_INNER_MAP                            = C.BPF_F_INNER_MAP
	BPF_STATS_RUN_TIME                         = C.BPF_STATS_RUN_TIME
	BPF_STACK_BUILD_ID_EMPTY                   = C.BPF_STACK_BUILD_ID_EMPTY
	BPF_STACK_BUILD_ID_VALID                   = C.BPF_STACK_BUILD_ID_VALID
	BPF_STACK_BUILD_ID_IP                      = C.BPF_STACK_BUILD_ID_IP
	BPF_F_RECOMPUTE_CSUM                       = C.BPF_F_RECOMPUTE_CSUM
	BPF_F_INVALIDATE_HASH                      = C.BPF_F_INVALIDATE_HASH
	BPF_F_HDR_FIELD_MASK                       = C.BPF_F_HDR_FIELD_MASK
	BPF_F_PSEUDO_HDR                           = C.BPF_F_PSEUDO_HDR
	BPF_F_MARK_MANGLED_0                       = C.BPF_F_MARK_MANGLED_0
	BPF_F_MARK_ENFORCE                         = C.BPF_F_MARK_ENFORCE
	BPF_F_INGRESS                              = C.BPF_F_INGRESS
	BPF_F_TUNINFO_IPV6                         = C.BPF_F_TUNINFO_IPV6
	BPF_F_SKIP_FIELD_MASK                      = C.BPF_F_SKIP_FIELD_MASK
	BPF_F_USER_STACK                           = C.BPF_F_USER_STACK
	BPF_F_FAST_STACK_CMP                       = C.BPF_F_FAST_STACK_CMP
	BPF_F_REUSE_STACKID                        = C.BPF_F_REUSE_STACKID
	BPF_F_USER_BUILD_ID                        = C.BPF_F_USER_BUILD_ID
	BPF_F_ZERO_CSUM_TX                         = C.BPF_F_ZERO_CSUM_TX
	BPF_F_DONT_FRAGMENT                        = C.BPF_F_DONT_FRAGMENT
	BPF_F_SEQ_NUMBER                           = C.BPF_F_SEQ_NUMBER
	BPF_F_INDEX_MASK                           = C.BPF_F_INDEX_MASK
	BPF_F_CURRENT_CPU                          = C.BPF_F_CURRENT_CPU
	BPF_F_CTXLEN_MASK                          = C.BPF_F_CTXLEN_MASK
	BPF_F_CURRENT_NETNS                        = C.BPF_F_CURRENT_NETNS
	BPF_CSUM_LEVEL_QUERY                       = C.BPF_CSUM_LEVEL_QUERY
	BPF_CSUM_LEVEL_INC                         = C.BPF_CSUM_LEVEL_INC
	BPF_CSUM_LEVEL_DEC                         = C.BPF_CSUM_LEVEL_DEC
	BPF_CSUM_LEVEL_RESET                       = C.BPF_CSUM_LEVEL_RESET
	BPF_F_ADJ_ROOM_FIXED_GSO                   = C.BPF_F_ADJ_ROOM_FIXED_GSO
	BPF_F_ADJ_ROOM_ENCAP_L3_IPV4               = C.BPF_F_ADJ_ROOM_ENCAP_L3_IPV4
	BPF_F_ADJ_ROOM_ENCAP_L3_IPV6               = C.BPF_F_ADJ_ROOM_ENCAP_L3_IPV6
	BPF_F_ADJ_ROOM_ENCAP_L4_GRE                = C.BPF_F_ADJ_ROOM_ENCAP_L4_GRE
	BPF_F_ADJ_ROOM_ENCAP_L4_UDP                = C.BPF_F_ADJ_ROOM_ENCAP_L4_UDP
	BPF_F_ADJ_ROOM_NO_CSUM_RESET               = C.BPF_F_ADJ_ROOM_NO_CSUM_RESET
	BPF_ADJ_ROOM_ENCAP_L2_MASK                 = C.BPF_ADJ_ROOM_ENCAP_L2_MASK
	BPF_ADJ_ROOM_ENCAP_L2_SHIFT                = C.BPF_ADJ_ROOM_ENCAP_L2_SHIFT
	BPF_F_SYSCTL_BASE_NAME                     = C.BPF_F_SYSCTL_BASE_NAME
	BPF_LOCAL_STORAGE_GET_F_CREATE             = C.BPF_LOCAL_STORAGE_GET_F_CREATE
	BPF_SK_STORAGE_GET_F_CREATE                = C.BPF_SK_STORAGE_GET_F_CREATE
	BPF_F_GET_BRANCH_RECORDS_SIZE              = C.BPF_F_GET_BRANCH_RECORDS_SIZE
	BPF_RB_NO_WAKEUP                           = C.BPF_RB_NO_WAKEUP
	BPF_RB_FORCE_WAKEUP                        = C.BPF_RB_FORCE_WAKEUP
	BPF_RB_AVAIL_DATA                          = C.BPF_RB_AVAIL_DATA
	BPF_RB_RING_SIZE                           = C.BPF_RB_RING_SIZE
	BPF_RB_CONS_POS                            = C.BPF_RB_CONS_POS
	BPF_RB_PROD_POS                            = C.BPF_RB_PROD_POS
	BPF_RINGBUF_BUSY_BIT                       = C.BPF_RINGBUF_BUSY_BIT
	BPF_RINGBUF_DISCARD_BIT                    = C.BPF_RINGBUF_DISCARD_BIT
	BPF_RINGBUF_HDR_SZ                         = C.BPF_RINGBUF_HDR_SZ
	BPF_SK_LOOKUP_F_REPLACE                    = C.BPF_SK_LOOKUP_F_REPLACE
	BPF_SK_LOOKUP_F_NO_REUSEPORT               = C.BPF_SK_LOOKUP_F_NO_REUSEPORT
	BPF_ADJ_ROOM_NET                           = C.BPF_ADJ_ROOM_NET
	BPF_ADJ_ROOM_MAC                           = C.BPF_ADJ_ROOM_MAC
	BPF_HDR_START_MAC                          = C.BPF_HDR_START_MAC
	BPF_HDR_START_NET                          = C.BPF_HDR_START_NET
	BPF_LWT_ENCAP_SEG6                         = C.BPF_LWT_ENCAP_SEG6
	BPF_LWT_ENCAP_SEG6_INLINE                  = C.BPF_LWT_ENCAP_SEG6_INLINE
	BPF_LWT_ENCAP_IP                           = C.BPF_LWT_ENCAP_IP
	BPF_OK                                     = C.BPF_OK
	BPF_DROP                                   = C.BPF_DROP
	BPF_REDIRECT                               = C.BPF_REDIRECT
	BPF_LWT_REROUTE                            = C.BPF_LWT_REROUTE
	BPF_SOCK_OPS_RTO_CB_FLAG                   = C.BPF_SOCK_OPS_RTO_CB_FLAG
	BPF_SOCK_OPS_RETRANS_CB_FLAG               = C.BPF_SOCK_OPS_RETRANS_CB_FLAG
	BPF_SOCK_OPS_STATE_CB_FLAG                 = C.BPF_SOCK_OPS_STATE_CB_FLAG
	BPF_SOCK_OPS_RTT_CB_FLAG                   = C.BPF_SOCK_OPS_RTT_CB_FLAG
	BPF_SOCK_OPS_PARSE_ALL_HDR_OPT_CB_FLAG     = C.BPF_SOCK_OPS_PARSE_ALL_HDR_OPT_CB_FLAG
	BPF_SOCK_OPS_PARSE_UNKNOWN_HDR_OPT_CB_FLAG = C.BPF_SOCK_OPS_PARSE_UNKNOWN_HDR_OPT_CB_FLAG
	BPF_SOCK_OPS_WRITE_HDR_OPT_CB_FLAG         = C.BPF_SOCK_OPS_WRITE_HDR_OPT_CB_FLAG
	BPF_SOCK_OPS_ALL_CB_FLAGS                  = C.BPF_SOCK_OPS_ALL_CB_FLAGS
	BPF_SOCK_OPS_VOID                          = C.BPF_SOCK_OPS_VOID
	BPF_SOCK_OPS_TIMEOUT_INIT                  = C.BPF_SOCK_OPS_TIMEOUT_INIT
	BPF_SOCK_OPS_RWND_INIT                     = C.BPF_SOCK_OPS_RWND_INIT
	BPF_SOCK_OPS_TCP_CONNECT_CB                = C.BPF_SOCK_OPS_TCP_CONNECT_CB
	BPF_SOCK_OPS_ACTIVE_ESTABLISHED_CB         = C.BPF_SOCK_OPS_ACTIVE_ESTABLISHED_CB
	BPF_SOCK_OPS_PASSIVE_ESTABLISHED_CB        = C.BPF_SOCK_OPS_PASSIVE_ESTABLISHED_CB
	BPF_SOCK_OPS_NEEDS_ECN                     = C.BPF_SOCK_OPS_NEEDS_ECN
	BPF_SOCK_OPS_BASE_RTT                      = C.BPF_SOCK_OPS_BASE_RTT
	BPF_SOCK_OPS_RTO_CB                        = C.BPF_SOCK_OPS_RTO_CB
	BPF_SOCK_OPS_RETRANS_CB                    = C.BPF_SOCK_OPS_RETRANS_CB
	BPF_SOCK_OPS_STATE_CB                      = C.BPF_SOCK_OPS_STATE_CB
	BPF_SOCK_OPS_TCP_LISTEN_CB                 = C.BPF_SOCK_OPS_TCP_LISTEN_CB
	BPF_SOCK_OPS_RTT_CB                        = C.BPF_SOCK_OPS_RTT_CB
	BPF_SOCK_OPS_PARSE_HDR_OPT_CB              = C.BPF_SOCK_OPS_PARSE_HDR_OPT_CB
	BPF_SOCK_OPS_HDR_OPT_LEN_CB                = C.BPF_SOCK_OPS_HDR_OPT_LEN_CB
	BPF_SOCK_OPS_WRITE_HDR_OPT_CB              = C.BPF_SOCK_OPS_WRITE_HDR_OPT_CB
	BPF_TCP_ESTABLISHED                        = C.BPF_TCP_ESTABLISHED
	BPF_TCP_SYN_SENT                           = C.BPF_TCP_SYN_SENT
	BPF_TCP_SYN_RECV                           = C.BPF_TCP_SYN_RECV
	BPF_TCP_FIN_WAIT1                          = C.BPF_TCP_FIN_WAIT1
	BPF_TCP_FIN_WAIT2                          = C.BPF_TCP_FIN_WAIT2
	BPF_TCP_TIME_WAIT                          = C.BPF_TCP_TIME_WAIT
	BPF_TCP_CLOSE                              = C.BPF_TCP_CLOSE
	BPF_TCP_CLOSE_WAIT                         = C.BPF_TCP_CLOSE_WAIT
	BPF_TCP_LAST_ACK                           = C.BPF_TCP_LAST_ACK
	BPF_TCP_LISTEN                             = C.BPF_TCP_LISTEN
	BPF_TCP_CLOSING                            = C.BPF_TCP_CLOSING
	BPF_TCP_NEW_SYN_RECV                       = C.BPF_TCP_NEW_SYN_RECV
	BPF_TCP_MAX_STATES                         = C.BPF_TCP_MAX_STATES
	TCP_BPF_IW                                 = C.TCP_BPF_IW
	TCP_BPF_SNDCWND_CLAMP                      = C.TCP_BPF_SNDCWND_CLAMP
	TCP_BPF_DELACK_MAX                         = C.TCP_BPF_DELACK_MAX
	TCP_BPF_RTO_MIN                            = C.TCP_BPF_RTO_MIN
	TCP_BPF_SYN                                = C.TCP_BPF_SYN
	TCP_BPF_SYN_IP                             = C.TCP_BPF_SYN_IP
	TCP_BPF_SYN_MAC                            = C.TCP_BPF_SYN_MAC
	BPF_LOAD_HDR_OPT_TCP_SYN                   = C.BPF_LOAD_HDR_OPT_TCP_SYN
	BPF_WRITE_HDR_TCP_CURRENT_MSS              = C.BPF_WRITE_HDR_TCP_CURRENT_MSS
	BPF_WRITE_HDR_TCP_SYNACK_COOKIE            = C.BPF_WRITE_HDR_TCP_SYNACK_COOKIE
	BPF_DEVCG_ACC_MKNOD                        = C.BPF_DEVCG_ACC_MKNOD
	BPF_DEVCG_ACC_READ                         = C.BPF_DEVCG_ACC_READ
	BPF_DEVCG_ACC_WRITE                        = C.BPF_DEVCG_ACC_WRITE
	BPF_DEVCG_DEV_BLOCK                        = C.BPF_DEVCG_DEV_BLOCK
	BPF_DEVCG_DEV_CHAR                         = C.BPF_DEVCG_DEV_CHAR
	BPF_FIB_LOOKUP_DIRECT                      = C.BPF_FIB_LOOKUP_DIRECT
	BPF_FIB_LOOKUP_OUTPUT                      = C.BPF_FIB_LOOKUP_OUTPUT
	BPF_FIB_LKUP_RET_SUCCESS                   = C.BPF_FIB_LKUP_RET_SUCCESS
	BPF_FIB_LKUP_RET_BLACKHOLE                 = C.BPF_FIB_LKUP_RET_BLACKHOLE
	BPF_FIB_LKUP_RET_UNREACHABLE               = C.BPF_FIB_LKUP_RET_UNREACHABLE
	BPF_FIB_LKUP_RET_PROHIBIT                  = C.BPF_FIB_LKUP_RET_PROHIBIT
	BPF_FIB_LKUP_RET_NOT_FWDED                 = C.BPF_FIB_LKUP_RET_NOT_FWDED
	BPF_FIB_LKUP_RET_FWD_DISABLED              = C.BPF_FIB_LKUP_RET_FWD_DISABLED
	BPF_FIB_LKUP_RET_UNSUPP_LWT                = C.BPF_FIB_LKUP_RET_UNSUPP_LWT
	BPF_FIB_LKUP_RET_NO_NEIGH                  = C.BPF_FIB_LKUP_RET_NO_NEIGH
	BPF_FIB_LKUP_RET_FRAG_NEEDED               = C.BPF_FIB_LKUP_RET_FRAG_NEEDED
	BPF_FD_TYPE_RAW_TRACEPOINT                 = C.BPF_FD_TYPE_RAW_TRACEPOINT
	BPF_FD_TYPE_TRACEPOINT                     = C.BPF_FD_TYPE_TRACEPOINT
	BPF_FD_TYPE_KPROBE                         = C.BPF_FD_TYPE_KPROBE
	BPF_FD_TYPE_KRETPROBE                      = C.BPF_FD_TYPE_KRETPROBE
	BPF_FD_TYPE_UPROBE                         = C.BPF_FD_TYPE_UPROBE
	BPF_FD_TYPE_URETPROBE                      = C.BPF_FD_TYPE_URETPROBE
	BPF_FLOW_DISSECTOR_F_PARSE_1ST_FRAG        = C.BPF_FLOW_DISSECTOR_F_PARSE_1ST_FRAG
	BPF_FLOW_DISSECTOR_F_STOP_AT_FLOW_LABEL    = C.BPF_FLOW_DISSECTOR_F_STOP_AT_FLOW_LABEL
	BPF_FLOW_DISSECTOR_F_STOP_AT_ENCAP         = C.BPF_FLOW_DISSECTOR_F_STOP_AT_ENCAP
)

// generated by:
// perl -nlE '/^\s*(RTNLGRP_\w+)/ && say "$1 = C.$1"' include/uapi/linux/rtnetlink.h
const (
	RTNLGRP_NONE          = C.RTNLGRP_NONE
	RTNLGRP_LINK          = C.RTNLGRP_LINK
	RTNLGRP_NOTIFY        = C.RTNLGRP_NOTIFY
	RTNLGRP_NEIGH         = C.RTNLGRP_NEIGH
	RTNLGRP_TC            = C.RTNLGRP_TC
	RTNLGRP_IPV4_IFADDR   = C.RTNLGRP_IPV4_IFADDR
	RTNLGRP_IPV4_MROUTE   = C.RTNLGRP_IPV4_MROUTE
	RTNLGRP_IPV4_ROUTE    = C.RTNLGRP_IPV4_ROUTE
	RTNLGRP_IPV4_RULE     = C.RTNLGRP_IPV4_RULE
	RTNLGRP_IPV6_IFADDR   = C.RTNLGRP_IPV6_IFADDR
	RTNLGRP_IPV6_MROUTE   = C.RTNLGRP_IPV6_MROUTE
	RTNLGRP_IPV6_ROUTE    = C.RTNLGRP_IPV6_ROUTE
	RTNLGRP_IPV6_IFINFO   = C.RTNLGRP_IPV6_IFINFO
	RTNLGRP_DECnet_IFADDR = C.RTNLGRP_DECnet_IFADDR
	RTNLGRP_NOP2          = C.RTNLGRP_NOP2
	RTNLGRP_DECnet_ROUTE  = C.RTNLGRP_DECnet_ROUTE
	RTNLGRP_DECnet_RULE   = C.RTNLGRP_DECnet_RULE
	RTNLGRP_NOP4          = C.RTNLGRP_NOP4
	RTNLGRP_IPV6_PREFIX   = C.RTNLGRP_IPV6_PREFIX
	RTNLGRP_IPV6_RULE     = C.RTNLGRP_IPV6_RULE
	RTNLGRP_ND_USEROPT    = C.RTNLGRP_ND_USEROPT
	RTNLGRP_PHONET_IFADDR = C.RTNLGRP_PHONET_IFADDR
	RTNLGRP_PHONET_ROUTE  = C.RTNLGRP_PHONET_ROUTE
	RTNLGRP_DCB           = C.RTNLGRP_DCB
	RTNLGRP_IPV4_NETCONF  = C.RTNLGRP_IPV4_NETCONF
	RTNLGRP_IPV6_NETCONF  = C.RTNLGRP_IPV6_NETCONF
	RTNLGRP_MDB           = C.RTNLGRP_MDB
	RTNLGRP_MPLS_ROUTE    = C.RTNLGRP_MPLS_ROUTE
	RTNLGRP_NSID          = C.RTNLGRP_NSID
	RTNLGRP_MPLS_NETCONF  = C.RTNLGRP_MPLS_NETCONF
	RTNLGRP_IPV4_MROUTE_R = C.RTNLGRP_IPV4_MROUTE_R
	RTNLGRP_IPV6_MROUTE_R = C.RTNLGRP_IPV6_MROUTE_R
	RTNLGRP_NEXTHOP       = C.RTNLGRP_NEXTHOP
	RTNLGRP_BRVLAN        = C.RTNLGRP_BRVLAN
)

// Capabilities

type CapUserHeader C.struct___user_cap_header_struct

type CapUserData C.struct___user_cap_data_struct

const (
	LINUX_CAPABILITY_VERSION_1 = C._LINUX_CAPABILITY_VERSION_1
	LINUX_CAPABILITY_VERSION_2 = C._LINUX_CAPABILITY_VERSION_2
	LINUX_CAPABILITY_VERSION_3 = C._LINUX_CAPABILITY_VERSION_3
)

// Loop devices

const (
	LO_FLAGS_READ_ONLY = C.LO_FLAGS_READ_ONLY
	LO_FLAGS_AUTOCLEAR = C.LO_FLAGS_AUTOCLEAR
	LO_FLAGS_PARTSCAN  = C.LO_FLAGS_PARTSCAN
	LO_FLAGS_DIRECT_IO = C.LO_FLAGS_DIRECT_IO
)

type LoopInfo C.struct_loop_info
type LoopInfo64 C.struct_loop_info64

// AF_TIPC

type TIPCSocketAddr C.struct_tipc_socket_addr

type TIPCServiceRange C.struct_tipc_service_range

type TIPCServiceName C.struct_tipc_service_name

type TIPCSubscr C.struct_tipc_subscr

type TIPCEvent C.struct_tipc_event

type TIPCGroupReq C.struct_tipc_group_req

type TIPCSIOCLNReq C.struct_tipc_sioc_ln_req

type TIPCSIOCNodeIDReq C.struct_tipc_sioc_nodeid_req

const (
	TIPC_CLUSTER_SCOPE = C.TIPC_CLUSTER_SCOPE
	TIPC_NODE_SCOPE    = C.TIPC_NODE_SCOPE
)

const (
	SYSLOG_ACTION_CLOSE         = 0
	SYSLOG_ACTION_OPEN          = 1
	SYSLOG_ACTION_READ          = 2
	SYSLOG_ACTION_READ_ALL      = 3
	SYSLOG_ACTION_READ_CLEAR    = 4
	SYSLOG_ACTION_CLEAR         = 5
	SYSLOG_ACTION_CONSOLE_OFF   = 6
	SYSLOG_ACTION_CONSOLE_ON    = 7
	SYSLOG_ACTION_CONSOLE_LEVEL = 8
	SYSLOG_ACTION_SIZE_UNREAD   = 9
	SYSLOG_ACTION_SIZE_BUFFER   = 10
)

// Devlink generic netlink API, generated using:
// perl -nlE '/^\s*(DEVLINK_\w+)/ && say "$1 = C.$1"' devlink.h
const (
	DEVLINK_CMD_UNSPEC                                 = C.DEVLINK_CMD_UNSPEC
	DEVLINK_CMD_GET                                    = C.DEVLINK_CMD_GET
	DEVLINK_CMD_SET                                    = C.DEVLINK_CMD_SET
	DEVLINK_CMD_NEW                                    = C.DEVLINK_CMD_NEW
	DEVLINK_CMD_DEL                                    = C.DEVLINK_CMD_DEL
	DEVLINK_CMD_PORT_GET                               = C.DEVLINK_CMD_PORT_GET
	DEVLINK_CMD_PORT_SET                               = C.DEVLINK_CMD_PORT_SET
	DEVLINK_CMD_PORT_NEW                               = C.DEVLINK_CMD_PORT_NEW
	DEVLINK_CMD_PORT_DEL                               = C.DEVLINK_CMD_PORT_DEL
	DEVLINK_CMD_PORT_SPLIT                             = C.DEVLINK_CMD_PORT_SPLIT
	DEVLINK_CMD_PORT_UNSPLIT                           = C.DEVLINK_CMD_PORT_UNSPLIT
	DEVLINK_CMD_SB_GET                                 = C.DEVLINK_CMD_SB_GET
	DEVLINK_CMD_SB_SET                                 = C.DEVLINK_CMD_SB_SET
	DEVLINK_CMD_SB_NEW                                 = C.DEVLINK_CMD_SB_NEW
	DEVLINK_CMD_SB_DEL                                 = C.DEVLINK_CMD_SB_DEL
	DEVLINK_CMD_SB_POOL_GET                            = C.DEVLINK_CMD_SB_POOL_GET
	DEVLINK_CMD_SB_POOL_SET                            = C.DEVLINK_CMD_SB_POOL_SET
	DEVLINK_CMD_SB_POOL_NEW                            = C.DEVLINK_CMD_SB_POOL_NEW
	DEVLINK_CMD_SB_POOL_DEL                            = C.DEVLINK_CMD_SB_POOL_DEL
	DEVLINK_CMD_SB_PORT_POOL_GET                       = C.DEVLINK_CMD_SB_PORT_POOL_GET
	DEVLINK_CMD_SB_PORT_POOL_SET                       = C.DEVLINK_CMD_SB_PORT_POOL_SET
	DEVLINK_CMD_SB_PORT_POOL_NEW                       = C.DEVLINK_CMD_SB_PORT_POOL_NEW
	DEVLINK_CMD_SB_PORT_POOL_DEL                       = C.DEVLINK_CMD_SB_PORT_POOL_DEL
	DEVLINK_CMD_SB_TC_POOL_BIND_GET                    = C.DEVLINK_CMD_SB_TC_POOL_BIND_GET
	DEVLINK_CMD_SB_TC_POOL_BIND_SET                    = C.DEVLINK_CMD_SB_TC_POOL_BIND_SET
	DEVLINK_CMD_SB_TC_POOL_BIND_NEW                    = C.DEVLINK_CMD_SB_TC_POOL_BIND_NEW
	DEVLINK_CMD_SB_TC_POOL_BIND_DEL                    = C.DEVLINK_CMD_SB_TC_POOL_BIND_DEL
	DEVLINK_CMD_SB_OCC_SNAPSHOT                        = C.DEVLINK_CMD_SB_OCC_SNAPSHOT
	DEVLINK_CMD_SB_OCC_MAX_CLEAR                       = C.DEVLINK_CMD_SB_OCC_MAX_CLEAR
	DEVLINK_CMD_ESWITCH_GET                            = C.DEVLINK_CMD_ESWITCH_GET
	DEVLINK_CMD_ESWITCH_SET                            = C.DEVLINK_CMD_ESWITCH_SET
	DEVLINK_CMD_DPIPE_TABLE_GET                        = C.DEVLINK_CMD_DPIPE_TABLE_GET
	DEVLINK_CMD_DPIPE_ENTRIES_GET                      = C.DEVLINK_CMD_DPIPE_ENTRIES_GET
	DEVLINK_CMD_DPIPE_HEADERS_GET                      = C.DEVLINK_CMD_DPIPE_HEADERS_GET
	DEVLINK_CMD_DPIPE_TABLE_COUNTERS_SET               = C.DEVLINK_CMD_DPIPE_TABLE_COUNTERS_SET
	DEVLINK_CMD_RESOURCE_SET                           = C.DEVLINK_CMD_RESOURCE_SET
	DEVLINK_CMD_RESOURCE_DUMP                          = C.DEVLINK_CMD_RESOURCE_DUMP
	DEVLINK_CMD_RELOAD                                 = C.DEVLINK_CMD_RELOAD
	DEVLINK_CMD_PARAM_GET                              = C.DEVLINK_CMD_PARAM_GET
	DEVLINK_CMD_PARAM_SET                              = C.DEVLINK_CMD_PARAM_SET
	DEVLINK_CMD_PARAM_NEW                              = C.DEVLINK_CMD_PARAM_NEW
	DEVLINK_CMD_PARAM_DEL                              = C.DEVLINK_CMD_PARAM_DEL
	DEVLINK_CMD_REGION_GET                             = C.DEVLINK_CMD_REGION_GET
	DEVLINK_CMD_REGION_SET                             = C.DEVLINK_CMD_REGION_SET
	DEVLINK_CMD_REGION_NEW                             = C.DEVLINK_CMD_REGION_NEW
	DEVLINK_CMD_REGION_DEL                             = C.DEVLINK_CMD_REGION_DEL
	DEVLINK_CMD_REGION_READ                            = C.DEVLINK_CMD_REGION_READ
	DEVLINK_CMD_PORT_PARAM_GET                         = C.DEVLINK_CMD_PORT_PARAM_GET
	DEVLINK_CMD_PORT_PARAM_SET                         = C.DEVLINK_CMD_PORT_PARAM_SET
	DEVLINK_CMD_PORT_PARAM_NEW                         = C.DEVLINK_CMD_PORT_PARAM_NEW
	DEVLINK_CMD_PORT_PARAM_DEL                         = C.DEVLINK_CMD_PORT_PARAM_DEL
	DEVLINK_CMD_INFO_GET                               = C.DEVLINK_CMD_INFO_GET
	DEVLINK_CMD_HEALTH_REPORTER_GET                    = C.DEVLINK_CMD_HEALTH_REPORTER_GET
	DEVLINK_CMD_HEALTH_REPORTER_SET                    = C.DEVLINK_CMD_HEALTH_REPORTER_SET
	DEVLINK_CMD_HEALTH_REPORTER_RECOVER                = C.DEVLINK_CMD_HEALTH_REPORTER_RECOVER
	DEVLINK_CMD_HEALTH_REPORTER_DIAGNOSE               = C.DEVLINK_CMD_HEALTH_REPORTER_DIAGNOSE
	DEVLINK_CMD_HEALTH_REPORTER_DUMP_GET               = C.DEVLINK_CMD_HEALTH_REPORTER_DUMP_GET
	DEVLINK_CMD_HEALTH_REPORTER_DUMP_CLEAR             = C.DEVLINK_CMD_HEALTH_REPORTER_DUMP_CLEAR
	DEVLINK_CMD_FLASH_UPDATE                           = C.DEVLINK_CMD_FLASH_UPDATE
	DEVLINK_CMD_FLASH_UPDATE_END                       = C.DEVLINK_CMD_FLASH_UPDATE_END
	DEVLINK_CMD_FLASH_UPDATE_STATUS                    = C.DEVLINK_CMD_FLASH_UPDATE_STATUS
	DEVLINK_CMD_TRAP_GET                               = C.DEVLINK_CMD_TRAP_GET
	DEVLINK_CMD_TRAP_SET                               = C.DEVLINK_CMD_TRAP_SET
	DEVLINK_CMD_TRAP_NEW                               = C.DEVLINK_CMD_TRAP_NEW
	DEVLINK_CMD_TRAP_DEL                               = C.DEVLINK_CMD_TRAP_DEL
	DEVLINK_CMD_TRAP_GROUP_GET                         = C.DEVLINK_CMD_TRAP_GROUP_GET
	DEVLINK_CMD_TRAP_GROUP_SET                         = C.DEVLINK_CMD_TRAP_GROUP_SET
	DEVLINK_CMD_TRAP_GROUP_NEW                         = C.DEVLINK_CMD_TRAP_GROUP_NEW
	DEVLINK_CMD_TRAP_GROUP_DEL                         = C.DEVLINK_CMD_TRAP_GROUP_DEL
	DEVLINK_CMD_TRAP_POLICER_GET                       = C.DEVLINK_CMD_TRAP_POLICER_GET
	DEVLINK_CMD_TRAP_POLICER_SET                       = C.DEVLINK_CMD_TRAP_POLICER_SET
	DEVLINK_CMD_TRAP_POLICER_NEW                       = C.DEVLINK_CMD_TRAP_POLICER_NEW
	DEVLINK_CMD_TRAP_POLICER_DEL                       = C.DEVLINK_CMD_TRAP_POLICER_DEL
	DEVLINK_CMD_HEALTH_REPORTER_TEST                   = C.DEVLINK_CMD_HEALTH_REPORTER_TEST
	DEVLINK_CMD_MAX                                    = C.DEVLINK_CMD_MAX
	DEVLINK_PORT_TYPE_NOTSET                           = C.DEVLINK_PORT_TYPE_NOTSET
	DEVLINK_PORT_TYPE_AUTO                             = C.DEVLINK_PORT_TYPE_AUTO
	DEVLINK_PORT_TYPE_ETH                              = C.DEVLINK_PORT_TYPE_ETH
	DEVLINK_PORT_TYPE_IB                               = C.DEVLINK_PORT_TYPE_IB
	DEVLINK_SB_POOL_TYPE_INGRESS                       = C.DEVLINK_SB_POOL_TYPE_INGRESS
	DEVLINK_SB_POOL_TYPE_EGRESS                        = C.DEVLINK_SB_POOL_TYPE_EGRESS
	DEVLINK_SB_THRESHOLD_TYPE_STATIC                   = C.DEVLINK_SB_THRESHOLD_TYPE_STATIC
	DEVLINK_SB_THRESHOLD_TYPE_DYNAMIC                  = C.DEVLINK_SB_THRESHOLD_TYPE_DYNAMIC
	DEVLINK_ESWITCH_MODE_LEGACY                        = C.DEVLINK_ESWITCH_MODE_LEGACY
	DEVLINK_ESWITCH_MODE_SWITCHDEV                     = C.DEVLINK_ESWITCH_MODE_SWITCHDEV
	DEVLINK_ESWITCH_INLINE_MODE_NONE                   = C.DEVLINK_ESWITCH_INLINE_MODE_NONE
	DEVLINK_ESWITCH_INLINE_MODE_LINK                   = C.DEVLINK_ESWITCH_INLINE_MODE_LINK
	DEVLINK_ESWITCH_INLINE_MODE_NETWORK                = C.DEVLINK_ESWITCH_INLINE_MODE_NETWORK
	DEVLINK_ESWITCH_INLINE_MODE_TRANSPORT              = C.DEVLINK_ESWITCH_INLINE_MODE_TRANSPORT
	DEVLINK_ESWITCH_ENCAP_MODE_NONE                    = C.DEVLINK_ESWITCH_ENCAP_MODE_NONE
	DEVLINK_ESWITCH_ENCAP_MODE_BASIC                   = C.DEVLINK_ESWITCH_ENCAP_MODE_BASIC
	DEVLINK_PORT_FLAVOUR_PHYSICAL                      = C.DEVLINK_PORT_FLAVOUR_PHYSICAL
	DEVLINK_PORT_FLAVOUR_CPU                           = C.DEVLINK_PORT_FLAVOUR_CPU
	DEVLINK_PORT_FLAVOUR_DSA                           = C.DEVLINK_PORT_FLAVOUR_DSA
	DEVLINK_PORT_FLAVOUR_PCI_PF                        = C.DEVLINK_PORT_FLAVOUR_PCI_PF
	DEVLINK_PORT_FLAVOUR_PCI_VF                        = C.DEVLINK_PORT_FLAVOUR_PCI_VF
	DEVLINK_PORT_FLAVOUR_VIRTUAL                       = C.DEVLINK_PORT_FLAVOUR_VIRTUAL
	DEVLINK_PORT_FLAVOUR_UNUSED                        = C.DEVLINK_PORT_FLAVOUR_UNUSED
	DEVLINK_PARAM_CMODE_RUNTIME                        = C.DEVLINK_PARAM_CMODE_RUNTIME
	DEVLINK_PARAM_CMODE_DRIVERINIT                     = C.DEVLINK_PARAM_CMODE_DRIVERINIT
	DEVLINK_PARAM_CMODE_PERMANENT                      = C.DEVLINK_PARAM_CMODE_PERMANENT
	DEVLINK_PARAM_CMODE_MAX                            = C.DEVLINK_PARAM_CMODE_MAX
	DEVLINK_PARAM_FW_LOAD_POLICY_VALUE_DRIVER          = C.DEVLINK_PARAM_FW_LOAD_POLICY_VALUE_DRIVER
	DEVLINK_PARAM_FW_LOAD_POLICY_VALUE_FLASH           = C.DEVLINK_PARAM_FW_LOAD_POLICY_VALUE_FLASH
	DEVLINK_PARAM_FW_LOAD_POLICY_VALUE_DISK            = C.DEVLINK_PARAM_FW_LOAD_POLICY_VALUE_DISK
	DEVLINK_PARAM_FW_LOAD_POLICY_VALUE_UNKNOWN         = C.DEVLINK_PARAM_FW_LOAD_POLICY_VALUE_UNKNOWN
	DEVLINK_PARAM_RESET_DEV_ON_DRV_PROBE_VALUE_UNKNOWN = C.DEVLINK_PARAM_RESET_DEV_ON_DRV_PROBE_VALUE_UNKNOWN
	DEVLINK_PARAM_RESET_DEV_ON_DRV_PROBE_VALUE_ALWAYS  = C.DEVLINK_PARAM_RESET_DEV_ON_DRV_PROBE_VALUE_ALWAYS
	DEVLINK_PARAM_RESET_DEV_ON_DRV_PROBE_VALUE_NEVER   = C.DEVLINK_PARAM_RESET_DEV_ON_DRV_PROBE_VALUE_NEVER
	DEVLINK_PARAM_RESET_DEV_ON_DRV_PROBE_VALUE_DISK    = C.DEVLINK_PARAM_RESET_DEV_ON_DRV_PROBE_VALUE_DISK
	DEVLINK_ATTR_STATS_RX_PACKETS                      = C.DEVLINK_ATTR_STATS_RX_PACKETS
	DEVLINK_ATTR_STATS_RX_BYTES                        = C.DEVLINK_ATTR_STATS_RX_BYTES
	DEVLINK_ATTR_STATS_RX_DROPPED                      = C.DEVLINK_ATTR_STATS_RX_DROPPED
	DEVLINK_ATTR_STATS_MAX                             = C.DEVLINK_ATTR_STATS_MAX
	DEVLINK_FLASH_OVERWRITE_SETTINGS_BIT               = C.DEVLINK_FLASH_OVERWRITE_SETTINGS_BIT
	DEVLINK_FLASH_OVERWRITE_IDENTIFIERS_BIT            = C.DEVLINK_FLASH_OVERWRITE_IDENTIFIERS_BIT
	DEVLINK_FLASH_OVERWRITE_MAX_BIT                    = C.DEVLINK_FLASH_OVERWRITE_MAX_BIT
	DEVLINK_TRAP_ACTION_DROP                           = C.DEVLINK_TRAP_ACTION_DROP
	DEVLINK_TRAP_ACTION_TRAP                           = C.DEVLINK_TRAP_ACTION_TRAP
	DEVLINK_TRAP_ACTION_MIRROR                         = C.DEVLINK_TRAP_ACTION_MIRROR
	DEVLINK_TRAP_TYPE_DROP                             = C.DEVLINK_TRAP_TYPE_DROP
	DEVLINK_TRAP_TYPE_EXCEPTION                        = C.DEVLINK_TRAP_TYPE_EXCEPTION
	DEVLINK_TRAP_TYPE_CONTROL                          = C.DEVLINK_TRAP_TYPE_CONTROL
	DEVLINK_ATTR_TRAP_METADATA_TYPE_IN_PORT            = C.DEVLINK_ATTR_TRAP_METADATA_TYPE_IN_PORT
	DEVLINK_ATTR_TRAP_METADATA_TYPE_FA_COOKIE          = C.DEVLINK_ATTR_TRAP_METADATA_TYPE_FA_COOKIE
	DEVLINK_RELOAD_ACTION_UNSPEC                       = C.DEVLINK_RELOAD_ACTION_UNSPEC
	DEVLINK_RELOAD_ACTION_DRIVER_REINIT                = C.DEVLINK_RELOAD_ACTION_DRIVER_REINIT
	DEVLINK_RELOAD_ACTION_FW_ACTIVATE                  = C.DEVLINK_RELOAD_ACTION_FW_ACTIVATE
	DEVLINK_RELOAD_ACTION_MAX                          = C.DEVLINK_RELOAD_ACTION_MAX
	DEVLINK_RELOAD_LIMIT_UNSPEC                        = C.DEVLINK_RELOAD_LIMIT_UNSPEC
	DEVLINK_RELOAD_LIMIT_NO_RESET                      = C.DEVLINK_RELOAD_LIMIT_NO_RESET
	DEVLINK_RELOAD_LIMIT_MAX                           = C.DEVLINK_RELOAD_LIMIT_MAX
	DEVLINK_ATTR_UNSPEC                                = C.DEVLINK_ATTR_UNSPEC
	DEVLINK_ATTR_BUS_NAME                              = C.DEVLINK_ATTR_BUS_NAME
	DEVLINK_ATTR_DEV_NAME                              = C.DEVLINK_ATTR_DEV_NAME
	DEVLINK_ATTR_PORT_INDEX                            = C.DEVLINK_ATTR_PORT_INDEX
	DEVLINK_ATTR_PORT_TYPE                             = C.DEVLINK_ATTR_PORT_TYPE
	DEVLINK_ATTR_PORT_DESIRED_TYPE                     = C.DEVLINK_ATTR_PORT_DESIRED_TYPE
	DEVLINK_ATTR_PORT_NETDEV_IFINDEX                   = C.DEVLINK_ATTR_PORT_NETDEV_IFINDEX
	DEVLINK_ATTR_PORT_NETDEV_NAME                      = C.DEVLINK_ATTR_PORT_NETDEV_NAME
	DEVLINK_ATTR_PORT_IBDEV_NAME                       = C.DEVLINK_ATTR_PORT_IBDEV_NAME
	DEVLINK_ATTR_PORT_SPLIT_COUNT                      = C.DEVLINK_ATTR_PORT_SPLIT_COUNT
	DEVLINK_ATTR_PORT_SPLIT_GROUP                      = C.DEVLINK_ATTR_PORT_SPLIT_GROUP
	DEVLINK_ATTR_SB_INDEX                              = C.DEVLINK_ATTR_SB_INDEX
	DEVLINK_ATTR_SB_SIZE                               = C.DEVLINK_ATTR_SB_SIZE
	DEVLINK_ATTR_SB_INGRESS_POOL_COUNT                 = C.DEVLINK_ATTR_SB_INGRESS_POOL_COUNT
	DEVLINK_ATTR_SB_EGRESS_POOL_COUNT                  = C.DEVLINK_ATTR_SB_EGRESS_POOL_COUNT
	DEVLINK_ATTR_SB_INGRESS_TC_COUNT                   = C.DEVLINK_ATTR_SB_INGRESS_TC_COUNT
	DEVLINK_ATTR_SB_EGRESS_TC_COUNT                    = C.DEVLINK_ATTR_SB_EGRESS_TC_COUNT
	DEVLINK_ATTR_SB_POOL_INDEX                         = C.DEVLINK_ATTR_SB_POOL_INDEX
	DEVLINK_ATTR_SB_POOL_TYPE                          = C.DEVLINK_ATTR_SB_POOL_TYPE
	DEVLINK_ATTR_SB_POOL_SIZE                          = C.DEVLINK_ATTR_SB_POOL_SIZE
	DEVLINK_ATTR_SB_POOL_THRESHOLD_TYPE                = C.DEVLINK_ATTR_SB_POOL_THRESHOLD_TYPE
	DEVLINK_ATTR_SB_THRESHOLD                          = C.DEVLINK_ATTR_SB_THRESHOLD
	DEVLINK_ATTR_SB_TC_INDEX                           = C.DEVLINK_ATTR_SB_TC_INDEX
	DEVLINK_ATTR_SB_OCC_CUR                            = C.DEVLINK_ATTR_SB_OCC_CUR
	DEVLINK_ATTR_SB_OCC_MAX                            = C.DEVLINK_ATTR_SB_OCC_MAX
	DEVLINK_ATTR_ESWITCH_MODE                          = C.DEVLINK_ATTR_ESWITCH_MODE
	DEVLINK_ATTR_ESWITCH_INLINE_MODE                   = C.DEVLINK_ATTR_ESWITCH_INLINE_MODE
	DEVLINK_ATTR_DPIPE_TABLES                          = C.DEVLINK_ATTR_DPIPE_TABLES
	DEVLINK_ATTR_DPIPE_TABLE                           = C.DEVLINK_ATTR_DPIPE_TABLE
	DEVLINK_ATTR_DPIPE_TABLE_NAME                      = C.DEVLINK_ATTR_DPIPE_TABLE_NAME
	DEVLINK_ATTR_DPIPE_TABLE_SIZE                      = C.DEVLINK_ATTR_DPIPE_TABLE_SIZE
	DEVLINK_ATTR_DPIPE_TABLE_MATCHES                   = C.DEVLINK_ATTR_DPIPE_TABLE_MATCHES
	DEVLINK_ATTR_DPIPE_TABLE_ACTIONS                   = C.DEVLINK_ATTR_DPIPE_TABLE_ACTIONS
	DEVLINK_ATTR_DPIPE_TABLE_COUNTERS_ENABLED          = C.DEVLINK_ATTR_DPIPE_TABLE_COUNTERS_ENABLED
	DEVLINK_ATTR_DPIPE_ENTRIES                         = C.DEVLINK_ATTR_DPIPE_ENTRIES
	DEVLINK_ATTR_DPIPE_ENTRY                           = C.DEVLINK_ATTR_DPIPE_ENTRY
	DEVLINK_ATTR_DPIPE_ENTRY_INDEX                     = C.DEVLINK_ATTR_DPIPE_ENTRY_INDEX
	DEVLINK_ATTR_DPIPE_ENTRY_MATCH_VALUES              = C.DEVLINK_ATTR_DPIPE_ENTRY_MATCH_VALUES
	DEVLINK_ATTR_DPIPE_ENTRY_ACTION_VALUES             = C.DEVLINK_ATTR_DPIPE_ENTRY_ACTION_VALUES
	DEVLINK_ATTR_DPIPE_ENTRY_COUNTER                   = C.DEVLINK_ATTR_DPIPE_ENTRY_COUNTER
	DEVLINK_ATTR_DPIPE_MATCH                           = C.DEVLINK_ATTR_DPIPE_MATCH
	DEVLINK_ATTR_DPIPE_MATCH_VALUE                     = C.DEVLINK_ATTR_DPIPE_MATCH_VALUE
	DEVLINK_ATTR_DPIPE_MATCH_TYPE                      = C.DEVLINK_ATTR_DPIPE_MATCH_TYPE
	DEVLINK_ATTR_DPIPE_ACTION                          = C.DEVLINK_ATTR_DPIPE_ACTION
	DEVLINK_ATTR_DPIPE_ACTION_VALUE                    = C.DEVLINK_ATTR_DPIPE_ACTION_VALUE
	DEVLINK_ATTR_DPIPE_ACTION_TYPE                     = C.DEVLINK_ATTR_DPIPE_ACTION_TYPE
	DEVLINK_ATTR_DPIPE_VALUE                           = C.DEVLINK_ATTR_DPIPE_VALUE
	DEVLINK_ATTR_DPIPE_VALUE_MASK                      = C.DEVLINK_ATTR_DPIPE_VALUE_MASK
	DEVLINK_ATTR_DPIPE_VALUE_MAPPING                   = C.DEVLINK_ATTR_DPIPE_VALUE_MAPPING
	DEVLINK_ATTR_DPIPE_HEADERS                         = C.DEVLINK_ATTR_DPIPE_HEADERS
	DEVLINK_ATTR_DPIPE_HEADER                          = C.DEVLINK_ATTR_DPIPE_HEADER
	DEVLINK_ATTR_DPIPE_HEADER_NAME                     = C.DEVLINK_ATTR_DPIPE_HEADER_NAME
	DEVLINK_ATTR_DPIPE_HEADER_ID                       = C.DEVLINK_ATTR_DPIPE_HEADER_ID
	DEVLINK_ATTR_DPIPE_HEADER_FIELDS                   = C.DEVLINK_ATTR_DPIPE_HEADER_FIELDS
	DEVLINK_ATTR_DPIPE_HEADER_GLOBAL                   = C.DEVLINK_ATTR_DPIPE_HEADER_GLOBAL
	DEVLINK_ATTR_DPIPE_HEADER_INDEX                    = C.DEVLINK_ATTR_DPIPE_HEADER_INDEX
	DEVLINK_ATTR_DPIPE_FIELD                           = C.DEVLINK_ATTR_DPIPE_FIELD
	DEVLINK_ATTR_DPIPE_FIELD_NAME                      = C.DEVLINK_ATTR_DPIPE_FIELD_NAME
	DEVLINK_ATTR_DPIPE_FIELD_ID                        = C.DEVLINK_ATTR_DPIPE_FIELD_ID
	DEVLINK_ATTR_DPIPE_FIELD_BITWIDTH                  = C.DEVLINK_ATTR_DPIPE_FIELD_BITWIDTH
	DEVLINK_ATTR_DPIPE_FIELD_MAPPING_TYPE              = C.DEVLINK_ATTR_DPIPE_FIELD_MAPPING_TYPE
	DEVLINK_ATTR_PAD                                   = C.DEVLINK_ATTR_PAD
	DEVLINK_ATTR_ESWITCH_ENCAP_MODE                    = C.DEVLINK_ATTR_ESWITCH_ENCAP_MODE
	DEVLINK_ATTR_RESOURCE_LIST                         = C.DEVLINK_ATTR_RESOURCE_LIST
	DEVLINK_ATTR_RESOURCE                              = C.DEVLINK_ATTR_RESOURCE
	DEVLINK_ATTR_RESOURCE_NAME                         = C.DEVLINK_ATTR_RESOURCE_NAME
	DEVLINK_ATTR_RESOURCE_ID                           = C.DEVLINK_ATTR_RESOURCE_ID
	DEVLINK_ATTR_RESOURCE_SIZE                         = C.DEVLINK_ATTR_RESOURCE_SIZE
	DEVLINK_ATTR_RESOURCE_SIZE_NEW                     = C.DEVLINK_ATTR_RESOURCE_SIZE_NEW
	DEVLINK_ATTR_RESOURCE_SIZE_VALID                   = C.DEVLINK_ATTR_RESOURCE_SIZE_VALID
	DEVLINK_ATTR_RESOURCE_SIZE_MIN                     = C.DEVLINK_ATTR_RESOURCE_SIZE_MIN
	DEVLINK_ATTR_RESOURCE_SIZE_MAX                     = C.DEVLINK_ATTR_RESOURCE_SIZE_MAX
	DEVLINK_ATTR_RESOURCE_SIZE_GRAN                    = C.DEVLINK_ATTR_RESOURCE_SIZE_GRAN
	DEVLINK_ATTR_RESOURCE_UNIT                         = C.DEVLINK_ATTR_RESOURCE_UNIT
	DEVLINK_ATTR_RESOURCE_OCC                          = C.DEVLINK_ATTR_RESOURCE_OCC
	DEVLINK_ATTR_DPIPE_TABLE_RESOURCE_ID               = C.DEVLINK_ATTR_DPIPE_TABLE_RESOURCE_ID
	DEVLINK_ATTR_DPIPE_TABLE_RESOURCE_UNITS            = C.DEVLINK_ATTR_DPIPE_TABLE_RESOURCE_UNITS
	DEVLINK_ATTR_PORT_FLAVOUR                          = C.DEVLINK_ATTR_PORT_FLAVOUR
	DEVLINK_ATTR_PORT_NUMBER                           = C.DEVLINK_ATTR_PORT_NUMBER
	DEVLINK_ATTR_PORT_SPLIT_SUBPORT_NUMBER             = C.DEVLINK_ATTR_PORT_SPLIT_SUBPORT_NUMBER
	DEVLINK_ATTR_PARAM                                 = C.DEVLINK_ATTR_PARAM
	DEVLINK_ATTR_PARAM_NAME                            = C.DEVLINK_ATTR_PARAM_NAME
	DEVLINK_ATTR_PARAM_GENERIC                         = C.DEVLINK_ATTR_PARAM_GENERIC
	DEVLINK_ATTR_PARAM_TYPE                            = C.DEVLINK_ATTR_PARAM_TYPE
	DEVLINK_ATTR_PARAM_VALUES_LIST                     = C.DEVLINK_ATTR_PARAM_VALUES_LIST
	DEVLINK_ATTR_PARAM_VALUE                           = C.DEVLINK_ATTR_PARAM_VALUE
	DEVLINK_ATTR_PARAM_VALUE_DATA                      = C.DEVLINK_ATTR_PARAM_VALUE_DATA
	DEVLINK_ATTR_PARAM_VALUE_CMODE                     = C.DEVLINK_ATTR_PARAM_VALUE_CMODE
	DEVLINK_ATTR_REGION_NAME                           = C.DEVLINK_ATTR_REGION_NAME
	DEVLINK_ATTR_REGION_SIZE                           = C.DEVLINK_ATTR_REGION_SIZE
	DEVLINK_ATTR_REGION_SNAPSHOTS                      = C.DEVLINK_ATTR_REGION_SNAPSHOTS
	DEVLINK_ATTR_REGION_SNAPSHOT                       = C.DEVLINK_ATTR_REGION_SNAPSHOT
	DEVLINK_ATTR_REGION_SNAPSHOT_ID                    = C.DEVLINK_ATTR_REGION_SNAPSHOT_ID
	DEVLINK_ATTR_REGION_CHUNKS                         = C.DEVLINK_ATTR_REGION_CHUNKS
	DEVLINK_ATTR_REGION_CHUNK                          = C.DEVLINK_ATTR_REGION_CHUNK
	DEVLINK_ATTR_REGION_CHUNK_DATA                     = C.DEVLINK_ATTR_REGION_CHUNK_DATA
	DEVLINK_ATTR_REGION_CHUNK_ADDR                     = C.DEVLINK_ATTR_REGION_CHUNK_ADDR
	DEVLINK_ATTR_REGION_CHUNK_LEN                      = C.DEVLINK_ATTR_REGION_CHUNK_LEN
	DEVLINK_ATTR_INFO_DRIVER_NAME                      = C.DEVLINK_ATTR_INFO_DRIVER_NAME
	DEVLINK_ATTR_INFO_SERIAL_NUMBER                    = C.DEVLINK_ATTR_INFO_SERIAL_NUMBER
	DEVLINK_ATTR_INFO_VERSION_FIXED                    = C.DEVLINK_ATTR_INFO_VERSION_FIXED
	DEVLINK_ATTR_INFO_VERSION_RUNNING                  = C.DEVLINK_ATTR_INFO_VERSION_RUNNING
	DEVLINK_ATTR_INFO_VERSION_STORED                   = C.DEVLINK_ATTR_INFO_VERSION_STORED
	DEVLINK_ATTR_INFO_VERSION_NAME                     = C.DEVLINK_ATTR_INFO_VERSION_NAME
	DEVLINK_ATTR_INFO_VERSION_VALUE                    = C.DEVLINK_ATTR_INFO_VERSION_VALUE
	DEVLINK_ATTR_SB_POOL_CELL_SIZE                     = C.DEVLINK_ATTR_SB_POOL_CELL_SIZE
	DEVLINK_ATTR_FMSG                                  = C.DEVLINK_ATTR_FMSG
	DEVLINK_ATTR_FMSG_OBJ_NEST_START                   = C.DEVLINK_ATTR_FMSG_OBJ_NEST_START
	DEVLINK_ATTR_FMSG_PAIR_NEST_START                  = C.DEVLINK_ATTR_FMSG_PAIR_NEST_START
	DEVLINK_ATTR_FMSG_ARR_NEST_START                   = C.DEVLINK_ATTR_FMSG_ARR_NEST_START
	DEVLINK_ATTR_FMSG_NEST_END                         = C.DEVLINK_ATTR_FMSG_NEST_END
	DEVLINK_ATTR_FMSG_OBJ_NAME                         = C.DEVLINK_ATTR_FMSG_OBJ_NAME
	DEVLINK_ATTR_FMSG_OBJ_VALUE_TYPE                   = C.DEVLINK_ATTR_FMSG_OBJ_VALUE_TYPE
	DEVLINK_ATTR_FMSG_OBJ_VALUE_DATA                   = C.DEVLINK_ATTR_FMSG_OBJ_VALUE_DATA
	DEVLINK_ATTR_HEALTH_REPORTER                       = C.DEVLINK_ATTR_HEALTH_REPORTER
	DEVLINK_ATTR_HEALTH_REPORTER_NAME                  = C.DEVLINK_ATTR_HEALTH_REPORTER_NAME
	DEVLINK_ATTR_HEALTH_REPORTER_STATE                 = C.DEVLINK_ATTR_HEALTH_REPORTER_STATE
	DEVLINK_ATTR_HEALTH_REPORTER_ERR_COUNT             = C.DEVLINK_ATTR_HEALTH_REPORTER_ERR_COUNT
	DEVLINK_ATTR_HEALTH_REPORTER_RECOVER_COUNT         = C.DEVLINK_ATTR_HEALTH_REPORTER_RECOVER_COUNT
	DEVLINK_ATTR_HEALTH_REPORTER_DUMP_TS               = C.DEVLINK_ATTR_HEALTH_REPORTER_DUMP_TS
	DEVLINK_ATTR_HEALTH_REPORTER_GRACEFUL_PERIOD       = C.DEVLINK_ATTR_HEALTH_REPORTER_GRACEFUL_PERIOD
	DEVLINK_ATTR_HEALTH_REPORTER_AUTO_RECOVER          = C.DEVLINK_ATTR_HEALTH_REPORTER_AUTO_RECOVER
	DEVLINK_ATTR_FLASH_UPDATE_FILE_NAME                = C.DEVLINK_ATTR_FLASH_UPDATE_FILE_NAME
	DEVLINK_ATTR_FLASH_UPDATE_COMPONENT                = C.DEVLINK_ATTR_FLASH_UPDATE_COMPONENT
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_MSG               = C.DEVLINK_ATTR_FLASH_UPDATE_STATUS_MSG
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_DONE              = C.DEVLINK_ATTR_FLASH_UPDATE_STATUS_DONE
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_TOTAL             = C.DEVLINK_ATTR_FLASH_UPDATE_STATUS_TOTAL
	DEVLINK_ATTR_PORT_PCI_PF_NUMBER                    = C.DEVLINK_ATTR_PORT_PCI_PF_NUMBER
	DEVLINK_ATTR_PORT_PCI_VF_NUMBER                    = C.DEVLINK_ATTR_PORT_PCI_VF_NUMBER
	DEVLINK_ATTR_STATS                                 = C.DEVLINK_ATTR_STATS
	DEVLINK_ATTR_TRAP_NAME                             = C.DEVLINK_ATTR_TRAP_NAME
	DEVLINK_ATTR_TRAP_ACTION                           = C.DEVLINK_ATTR_TRAP_ACTION
	DEVLINK_ATTR_TRAP_TYPE                             = C.DEVLINK_ATTR_TRAP_TYPE
	DEVLINK_ATTR_TRAP_GENERIC                          = C.DEVLINK_ATTR_TRAP_GENERIC
	DEVLINK_ATTR_TRAP_METADATA                         = C.DEVLINK_ATTR_TRAP_METADATA
	DEVLINK_ATTR_TRAP_GROUP_NAME                       = C.DEVLINK_ATTR_TRAP_GROUP_NAME
	DEVLINK_ATTR_RELOAD_FAILED                         = C.DEVLINK_ATTR_RELOAD_FAILED
	DEVLINK_ATTR_HEALTH_REPORTER_DUMP_TS_NS            = C.DEVLINK_ATTR_HEALTH_REPORTER_DUMP_TS_NS
	DEVLINK_ATTR_NETNS_FD                              = C.DEVLINK_ATTR_NETNS_FD
	DEVLINK_ATTR_NETNS_PID                             = C.DEVLINK_ATTR_NETNS_PID
	DEVLINK_ATTR_NETNS_ID                              = C.DEVLINK_ATTR_NETNS_ID
	DEVLINK_ATTR_HEALTH_REPORTER_AUTO_DUMP             = C.DEVLINK_ATTR_HEALTH_REPORTER_AUTO_DUMP
	DEVLINK_ATTR_TRAP_POLICER_ID                       = C.DEVLINK_ATTR_TRAP_POLICER_ID
	DEVLINK_ATTR_TRAP_POLICER_RATE                     = C.DEVLINK_ATTR_TRAP_POLICER_RATE
	DEVLINK_ATTR_TRAP_POLICER_BURST                    = C.DEVLINK_ATTR_TRAP_POLICER_BURST
	DEVLINK_ATTR_PORT_FUNCTION                         = C.DEVLINK_ATTR_PORT_FUNCTION
	DEVLINK_ATTR_INFO_BOARD_SERIAL_NUMBER              = C.DEVLINK_ATTR_INFO_BOARD_SERIAL_NUMBER
	DEVLINK_ATTR_PORT_LANES                            = C.DEVLINK_ATTR_PORT_LANES
	DEVLINK_ATTR_PORT_SPLITTABLE                       = C.DEVLINK_ATTR_PORT_SPLITTABLE
	DEVLINK_ATTR_PORT_EXTERNAL                         = C.DEVLINK_ATTR_PORT_EXTERNAL
	DEVLINK_ATTR_PORT_CONTROLLER_NUMBER                = C.DEVLINK_ATTR_PORT_CONTROLLER_NUMBER
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_TIMEOUT           = C.DEVLINK_ATTR_FLASH_UPDATE_STATUS_TIMEOUT
	DEVLINK_ATTR_FLASH_UPDATE_OVERWRITE_MASK           = C.DEVLINK_ATTR_FLASH_UPDATE_OVERWRITE_MASK
	DEVLINK_ATTR_RELOAD_ACTION                         = C.DEVLINK_ATTR_RELOAD_ACTION
	DEVLINK_ATTR_RELOAD_ACTIONS_PERFORMED              = C.DEVLINK_ATTR_RELOAD_ACTIONS_PERFORMED
	DEVLINK_ATTR_RELOAD_LIMITS                         = C.DEVLINK_ATTR_RELOAD_LIMITS
	DEVLINK_ATTR_DEV_STATS                             = C.DEVLINK_ATTR_DEV_STATS
	DEVLINK_ATTR_RELOAD_STATS                          = C.DEVLINK_ATTR_RELOAD_STATS
	DEVLINK_ATTR_RELOAD_STATS_ENTRY                    = C.DEVLINK_ATTR_RELOAD_STATS_ENTRY
	DEVLINK_ATTR_RELOAD_STATS_LIMIT                    = C.DEVLINK_ATTR_RELOAD_STATS_LIMIT
	DEVLINK_ATTR_RELOAD_STATS_VALUE                    = C.DEVLINK_ATTR_RELOAD_STATS_VALUE
	DEVLINK_ATTR_REMOTE_RELOAD_STATS                   = C.DEVLINK_ATTR_REMOTE_RELOAD_STATS
	DEVLINK_ATTR_RELOAD_ACTION_INFO                    = C.DEVLINK_ATTR_RELOAD_ACTION_INFO
	DEVLINK_ATTR_RELOAD_ACTION_STATS                   = C.DEVLINK_ATTR_RELOAD_ACTION_STATS
	DEVLINK_ATTR_PORT_PCI_SF_NUMBER                    = C.DEVLINK_ATTR_PORT_PCI_SF_NUMBER
	DEVLINK_ATTR_RATE_TYPE                             = C.DEVLINK_ATTR_RATE_TYPE
	DEVLINK_ATTR_RATE_TX_SHARE                         = C.DEVLINK_ATTR_RATE_TX_SHARE
	DEVLINK_ATTR_RATE_TX_MAX                           = C.DEVLINK_ATTR_RATE_TX_MAX
	DEVLINK_ATTR_RATE_NODE_NAME                        = C.DEVLINK_ATTR_RATE_NODE_NAME
	DEVLINK_ATTR_RATE_PARENT_NODE_NAME                 = C.DEVLINK_ATTR_RATE_PARENT_NODE_NAME
	DEVLINK_ATTR_REGION_MAX_SNAPSHOTS                  = C.DEVLINK_ATTR_REGION_MAX_SNAPSHOTS
	DEVLINK_ATTR_MAX                                   = C.DEVLINK_ATTR_MAX
	DEVLINK_DPIPE_FIELD_MAPPING_TYPE_NONE              = C.DEVLINK_DPIPE_FIELD_MAPPING_TYPE_NONE
	DEVLINK_DPIPE_FIELD_MAPPING_TYPE_IFINDEX           = C.DEVLINK_DPIPE_FIELD_MAPPING_TYPE_IFINDEX
	DEVLINK_DPIPE_MATCH_TYPE_FIELD_EXACT               = C.DEVLINK_DPIPE_MATCH_TYPE_FIELD_EXACT
	DEVLINK_DPIPE_ACTION_TYPE_FIELD_MODIFY             = C.DEVLINK_DPIPE_ACTION_TYPE_FIELD_MODIFY
	DEVLINK_DPIPE_FIELD_ETHERNET_DST_MAC               = C.DEVLINK_DPIPE_FIELD_ETHERNET_DST_MAC
	DEVLINK_DPIPE_FIELD_IPV4_DST_IP                    = C.DEVLINK_DPIPE_FIELD_IPV4_DST_IP
	DEVLINK_DPIPE_FIELD_IPV6_DST_IP                    = C.DEVLINK_DPIPE_FIELD_IPV6_DST_IP
	DEVLINK_DPIPE_HEADER_ETHERNET                      = C.DEVLINK_DPIPE_HEADER_ETHERNET
	DEVLINK_DPIPE_HEADER_IPV4                          = C.DEVLINK_DPIPE_HEADER_IPV4
	DEVLINK_DPIPE_HEADER_IPV6                          = C.DEVLINK_DPIPE_HEADER_IPV6
	DEVLINK_RESOURCE_UNIT_ENTRY                        = C.DEVLINK_RESOURCE_UNIT_ENTRY
	DEVLINK_PORT_FUNCTION_ATTR_UNSPEC                  = C.DEVLINK_PORT_FUNCTION_ATTR_UNSPEC
	DEVLINK_PORT_FUNCTION_ATTR_HW_ADDR                 = C.DEVLINK_PORT_FUNCTION_ATTR_HW_ADDR
	DEVLINK_PORT_FN_ATTR_STATE                         = C.DEVLINK_PORT_FN_ATTR_STATE
	DEVLINK_PORT_FN_ATTR_OPSTATE                       = C.DEVLINK_PORT_FN_ATTR_OPSTATE
	DEVLINK_PORT_FUNCTION_ATTR_MAX                     = C.DEVLINK_PORT_FUNCTION_ATTR_MAX
)

// fs-verity

type FsverityDigest C.struct_fsverity_digest

type FsverityEnableArg C.struct_fsverity_enable_arg

// nexthop

type Nhmsg C.struct_nhmsg

type NexthopGrp C.struct_nexthop_grp

const (
	NHA_UNSPEC     = C.NHA_UNSPEC
	NHA_ID         = C.NHA_ID
	NHA_GROUP      = C.NHA_GROUP
	NHA_GROUP_TYPE = C.NHA_GROUP_TYPE
	NHA_BLACKHOLE  = C.NHA_BLACKHOLE
	NHA_OIF        = C.NHA_OIF
	NHA_GATEWAY    = C.NHA_GATEWAY
	NHA_ENCAP_TYPE = C.NHA_ENCAP_TYPE
	NHA_ENCAP      = C.NHA_ENCAP
	NHA_GROUPS     = C.NHA_GROUPS
	NHA_MASTER     = C.NHA_MASTER
)

// raw CAN sockets

const (
	CAN_RAW_FILTER        = C.CAN_RAW_FILTER
	CAN_RAW_ERR_FILTER    = C.CAN_RAW_ERR_FILTER
	CAN_RAW_LOOPBACK      = C.CAN_RAW_LOOPBACK
	CAN_RAW_RECV_OWN_MSGS = C.CAN_RAW_RECV_OWN_MSGS
	CAN_RAW_FD_FRAMES     = C.CAN_RAW_FD_FRAMES
	CAN_RAW_JOIN_FILTERS  = C.CAN_RAW_JOIN_FILTERS
)

// Watchdog API

type WatchdogInfo C.struct_watchdog_info

// PPS API

type PPSFData C.struct_pps_fdata

type PPSKParams C.struct_pps_kparams

type PPSKInfo C.struct_pps_kinfo

type PPSKTime C.struct_pps_ktime

const (
	PPS_GETPARAMS = C.PPS_GETPARAMS
	PPS_SETPARAMS = C.PPS_SETPARAMS
	PPS_GETCAP    = C.PPS_GETCAP
	PPS_FETCH     = C.PPS_FETCH
)

// lwtunnel and related APIs

const (
	LWTUNNEL_ENCAP_NONE       = C.LWTUNNEL_ENCAP_NONE
	LWTUNNEL_ENCAP_MPLS       = C.LWTUNNEL_ENCAP_MPLS
	LWTUNNEL_ENCAP_IP         = C.LWTUNNEL_ENCAP_IP
	LWTUNNEL_ENCAP_ILA        = C.LWTUNNEL_ENCAP_ILA
	LWTUNNEL_ENCAP_IP6        = C.LWTUNNEL_ENCAP_IP6
	LWTUNNEL_ENCAP_SEG6       = C.LWTUNNEL_ENCAP_SEG6
	LWTUNNEL_ENCAP_BPF        = C.LWTUNNEL_ENCAP_BPF
	LWTUNNEL_ENCAP_SEG6_LOCAL = C.LWTUNNEL_ENCAP_SEG6_LOCAL
	LWTUNNEL_ENCAP_RPL        = C.LWTUNNEL_ENCAP_RPL
	LWTUNNEL_ENCAP_IOAM6      = C.LWTUNNEL_ENCAP_IOAM6
	LWTUNNEL_ENCAP_MAX        = C.LWTUNNEL_ENCAP_MAX

	MPLS_IPTUNNEL_UNSPEC = C.MPLS_IPTUNNEL_UNSPEC
	MPLS_IPTUNNEL_DST    = C.MPLS_IPTUNNEL_DST
	MPLS_IPTUNNEL_TTL    = C.MPLS_IPTUNNEL_TTL
	MPLS_IPTUNNEL_MAX    = C.MPLS_IPTUNNEL_MAX
)

// ethtool and its netlink interface, generated using:
//
// perl -nlE '/^\s*(ETHTOOL_\w+)/ && say "$1 = C.$1"' ethtool.h
// perl -nlE '/^\s*(ETHTOOL_\w+)/ && say "$1 = C.$1"' ethtool_netlink.h
//
// Note that a couple of constants produced by this command will be duplicated
// by mkerrors.sh, so some manual pruning was necessary.
const (
	ETHTOOL_ID_UNSPEC                                                       = C.ETHTOOL_ID_UNSPEC
	ETHTOOL_RX_COPYBREAK                                                    = C.ETHTOOL_RX_COPYBREAK
	ETHTOOL_TX_COPYBREAK                                                    = C.ETHTOOL_TX_COPYBREAK
	ETHTOOL_PFC_PREVENTION_TOUT                                             = C.ETHTOOL_PFC_PREVENTION_TOUT
	ETHTOOL_TUNABLE_UNSPEC                                                  = C.ETHTOOL_TUNABLE_UNSPEC
	ETHTOOL_TUNABLE_U8                                                      = C.ETHTOOL_TUNABLE_U8
	ETHTOOL_TUNABLE_U16                                                     = C.ETHTOOL_TUNABLE_U16
	ETHTOOL_TUNABLE_U32                                                     = C.ETHTOOL_TUNABLE_U32
	ETHTOOL_TUNABLE_U64                                                     = C.ETHTOOL_TUNABLE_U64
	ETHTOOL_TUNABLE_STRING                                                  = C.ETHTOOL_TUNABLE_STRING
	ETHTOOL_TUNABLE_S8                                                      = C.ETHTOOL_TUNABLE_S8
	ETHTOOL_TUNABLE_S16                                                     = C.ETHTOOL_TUNABLE_S16
	ETHTOOL_TUNABLE_S32                                                     = C.ETHTOOL_TUNABLE_S32
	ETHTOOL_TUNABLE_S64                                                     = C.ETHTOOL_TUNABLE_S64
	ETHTOOL_PHY_ID_UNSPEC                                                   = C.ETHTOOL_PHY_ID_UNSPEC
	ETHTOOL_PHY_DOWNSHIFT                                                   = C.ETHTOOL_PHY_DOWNSHIFT
	ETHTOOL_PHY_FAST_LINK_DOWN                                              = C.ETHTOOL_PHY_FAST_LINK_DOWN
	ETHTOOL_PHY_EDPD                                                        = C.ETHTOOL_PHY_EDPD
	ETHTOOL_LINK_EXT_STATE_AUTONEG                                          = C.ETHTOOL_LINK_EXT_STATE_AUTONEG
	ETHTOOL_LINK_EXT_STATE_LINK_TRAINING_FAILURE                            = C.ETHTOOL_LINK_EXT_STATE_LINK_TRAINING_FAILURE
	ETHTOOL_LINK_EXT_STATE_LINK_LOGICAL_MISMATCH                            = C.ETHTOOL_LINK_EXT_STATE_LINK_LOGICAL_MISMATCH
	ETHTOOL_LINK_EXT_STATE_BAD_SIGNAL_INTEGRITY                             = C.ETHTOOL_LINK_EXT_STATE_BAD_SIGNAL_INTEGRITY
	ETHTOOL_LINK_EXT_STATE_NO_CABLE                                         = C.ETHTOOL_LINK_EXT_STATE_NO_CABLE
	ETHTOOL_LINK_EXT_STATE_CABLE_ISSUE                                      = C.ETHTOOL_LINK_EXT_STATE_CABLE_ISSUE
	ETHTOOL_LINK_EXT_STATE_EEPROM_ISSUE                                     = C.ETHTOOL_LINK_EXT_STATE_EEPROM_ISSUE
	ETHTOOL_LINK_EXT_STATE_CALIBRATION_FAILURE                              = C.ETHTOOL_LINK_EXT_STATE_CALIBRATION_FAILURE
	ETHTOOL_LINK_EXT_STATE_POWER_BUDGET_EXCEEDED                            = C.ETHTOOL_LINK_EXT_STATE_POWER_BUDGET_EXCEEDED
	ETHTOOL_LINK_EXT_STATE_OVERHEAT                                         = C.ETHTOOL_LINK_EXT_STATE_OVERHEAT
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED                        = C.ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED
	ETHTOOL_LINK_EXT_SUBSTATE_AN_ACK_NOT_RECEIVED                           = C.ETHTOOL_LINK_EXT_SUBSTATE_AN_ACK_NOT_RECEIVED
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NEXT_PAGE_EXCHANGE_FAILED                  = C.ETHTOOL_LINK_EXT_SUBSTATE_AN_NEXT_PAGE_EXCHANGE_FAILED
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED_FORCE_MODE             = C.ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED_FORCE_MODE
	ETHTOOL_LINK_EXT_SUBSTATE_AN_FEC_MISMATCH_DURING_OVERRIDE               = C.ETHTOOL_LINK_EXT_SUBSTATE_AN_FEC_MISMATCH_DURING_OVERRIDE
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_HCD                                     = C.ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_HCD
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_FRAME_LOCK_NOT_ACQUIRED                 = C.ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_FRAME_LOCK_NOT_ACQUIRED
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_INHIBIT_TIMEOUT                    = C.ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_INHIBIT_TIMEOUT
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_PARTNER_DID_NOT_SET_RECEIVER_READY = C.ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_PARTNER_DID_NOT_SET_RECEIVER_READY
	ETHTOOL_LINK_EXT_SUBSTATE_LT_REMOTE_FAULT                               = C.ETHTOOL_LINK_EXT_SUBSTATE_LT_REMOTE_FAULT
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_BLOCK_LOCK            = C.ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_BLOCK_LOCK
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_AM_LOCK               = C.ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_AM_LOCK
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_GET_ALIGN_STATUS              = C.ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_GET_ALIGN_STATUS
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_FC_FEC_IS_NOT_LOCKED                      = C.ETHTOOL_LINK_EXT_SUBSTATE_LLM_FC_FEC_IS_NOT_LOCKED
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_RS_FEC_IS_NOT_LOCKED                      = C.ETHTOOL_LINK_EXT_SUBSTATE_LLM_RS_FEC_IS_NOT_LOCKED
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_LARGE_NUMBER_OF_PHYSICAL_ERRORS           = C.ETHTOOL_LINK_EXT_SUBSTATE_BSI_LARGE_NUMBER_OF_PHYSICAL_ERRORS
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_UNSUPPORTED_RATE                          = C.ETHTOOL_LINK_EXT_SUBSTATE_BSI_UNSUPPORTED_RATE
	ETHTOOL_LINK_EXT_SUBSTATE_CI_UNSUPPORTED_CABLE                          = C.ETHTOOL_LINK_EXT_SUBSTATE_CI_UNSUPPORTED_CABLE
	ETHTOOL_LINK_EXT_SUBSTATE_CI_CABLE_TEST_FAILURE                         = C.ETHTOOL_LINK_EXT_SUBSTATE_CI_CABLE_TEST_FAILURE
	ETHTOOL_FLASH_ALL_REGIONS                                               = C.ETHTOOL_FLASH_ALL_REGIONS
	ETHTOOL_F_UNSUPPORTED__BIT                                              = C.ETHTOOL_F_UNSUPPORTED__BIT
	ETHTOOL_F_WISH__BIT                                                     = C.ETHTOOL_F_WISH__BIT
	ETHTOOL_F_COMPAT__BIT                                                   = C.ETHTOOL_F_COMPAT__BIT
	ETHTOOL_FEC_NONE_BIT                                                    = C.ETHTOOL_FEC_NONE_BIT
	ETHTOOL_FEC_AUTO_BIT                                                    = C.ETHTOOL_FEC_AUTO_BIT
	ETHTOOL_FEC_OFF_BIT                                                     = C.ETHTOOL_FEC_OFF_BIT
	ETHTOOL_FEC_RS_BIT                                                      = C.ETHTOOL_FEC_RS_BIT
	ETHTOOL_FEC_BASER_BIT                                                   = C.ETHTOOL_FEC_BASER_BIT
	ETHTOOL_FEC_LLRS_BIT                                                    = C.ETHTOOL_FEC_LLRS_BIT
	ETHTOOL_LINK_MODE_10baseT_Half_BIT                                      = C.ETHTOOL_LINK_MODE_10baseT_Half_BIT
	ETHTOOL_LINK_MODE_10baseT_Full_BIT                                      = C.ETHTOOL_LINK_MODE_10baseT_Full_BIT
	ETHTOOL_LINK_MODE_100baseT_Half_BIT                                     = C.ETHTOOL_LINK_MODE_100baseT_Half_BIT
	ETHTOOL_LINK_MODE_100baseT_Full_BIT                                     = C.ETHTOOL_LINK_MODE_100baseT_Full_BIT
	ETHTOOL_LINK_MODE_1000baseT_Half_BIT                                    = C.ETHTOOL_LINK_MODE_1000baseT_Half_BIT
	ETHTOOL_LINK_MODE_1000baseT_Full_BIT                                    = C.ETHTOOL_LINK_MODE_1000baseT_Full_BIT
	ETHTOOL_LINK_MODE_Autoneg_BIT                                           = C.ETHTOOL_LINK_MODE_Autoneg_BIT
	ETHTOOL_LINK_MODE_TP_BIT                                                = C.ETHTOOL_LINK_MODE_TP_BIT
	ETHTOOL_LINK_MODE_AUI_BIT                                               = C.ETHTOOL_LINK_MODE_AUI_BIT
	ETHTOOL_LINK_MODE_MII_BIT                                               = C.ETHTOOL_LINK_MODE_MII_BIT
	ETHTOOL_LINK_MODE_FIBRE_BIT                                             = C.ETHTOOL_LINK_MODE_FIBRE_BIT
	ETHTOOL_LINK_MODE_BNC_BIT                                               = C.ETHTOOL_LINK_MODE_BNC_BIT
	ETHTOOL_LINK_MODE_10000baseT_Full_BIT                                   = C.ETHTOOL_LINK_MODE_10000baseT_Full_BIT
	ETHTOOL_LINK_MODE_Pause_BIT                                             = C.ETHTOOL_LINK_MODE_Pause_BIT
	ETHTOOL_LINK_MODE_Asym_Pause_BIT                                        = C.ETHTOOL_LINK_MODE_Asym_Pause_BIT
	ETHTOOL_LINK_MODE_2500baseX_Full_BIT                                    = C.ETHTOOL_LINK_MODE_2500baseX_Full_BIT
	ETHTOOL_LINK_MODE_Backplane_BIT                                         = C.ETHTOOL_LINK_MODE_Backplane_BIT
	ETHTOOL_LINK_MODE_1000baseKX_Full_BIT                                   = C.ETHTOOL_LINK_MODE_1000baseKX_Full_BIT
	ETHTOOL_LINK_MODE_10000baseKX4_Full_BIT                                 = C.ETHTOOL_LINK_MODE_10000baseKX4_Full_BIT
	ETHTOOL_LINK_MODE_10000baseKR_Full_BIT                                  = C.ETHTOOL_LINK_MODE_10000baseKR_Full_BIT
	ETHTOOL_LINK_MODE_10000baseR_FEC_BIT                                    = C.ETHTOOL_LINK_MODE_10000baseR_FEC_BIT
	ETHTOOL_LINK_MODE_20000baseMLD2_Full_BIT                                = C.ETHTOOL_LINK_MODE_20000baseMLD2_Full_BIT
	ETHTOOL_LINK_MODE_20000baseKR2_Full_BIT                                 = C.ETHTOOL_LINK_MODE_20000baseKR2_Full_BIT
	ETHTOOL_LINK_MODE_40000baseKR4_Full_BIT                                 = C.ETHTOOL_LINK_MODE_40000baseKR4_Full_BIT
	ETHTOOL_LINK_MODE_40000baseCR4_Full_BIT                                 = C.ETHTOOL_LINK_MODE_40000baseCR4_Full_BIT
	ETHTOOL_LINK_MODE_40000baseSR4_Full_BIT                                 = C.ETHTOOL_LINK_MODE_40000baseSR4_Full_BIT
	ETHTOOL_LINK_MODE_40000baseLR4_Full_BIT                                 = C.ETHTOOL_LINK_MODE_40000baseLR4_Full_BIT
	ETHTOOL_LINK_MODE_56000baseKR4_Full_BIT                                 = C.ETHTOOL_LINK_MODE_56000baseKR4_Full_BIT
	ETHTOOL_LINK_MODE_56000baseCR4_Full_BIT                                 = C.ETHTOOL_LINK_MODE_56000baseCR4_Full_BIT
	ETHTOOL_LINK_MODE_56000baseSR4_Full_BIT                                 = C.ETHTOOL_LINK_MODE_56000baseSR4_Full_BIT
	ETHTOOL_LINK_MODE_56000baseLR4_Full_BIT                                 = C.ETHTOOL_LINK_MODE_56000baseLR4_Full_BIT
	ETHTOOL_LINK_MODE_25000baseCR_Full_BIT                                  = C.ETHTOOL_LINK_MODE_25000baseCR_Full_BIT
	ETHTOOL_LINK_MODE_25000baseKR_Full_BIT                                  = C.ETHTOOL_LINK_MODE_25000baseKR_Full_BIT
	ETHTOOL_LINK_MODE_25000baseSR_Full_BIT                                  = C.ETHTOOL_LINK_MODE_25000baseSR_Full_BIT
	ETHTOOL_LINK_MODE_50000baseCR2_Full_BIT                                 = C.ETHTOOL_LINK_MODE_50000baseCR2_Full_BIT
	ETHTOOL_LINK_MODE_50000baseKR2_Full_BIT                                 = C.ETHTOOL_LINK_MODE_50000baseKR2_Full_BIT
	ETHTOOL_LINK_MODE_100000baseKR4_Full_BIT                                = C.ETHTOOL_LINK_MODE_100000baseKR4_Full_BIT
	ETHTOOL_LINK_MODE_100000baseSR4_Full_BIT                                = C.ETHTOOL_LINK_MODE_100000baseSR4_Full_BIT
	ETHTOOL_LINK_MODE_100000baseCR4_Full_BIT                                = C.ETHTOOL_LINK_MODE_100000baseCR4_Full_BIT
	ETHTOOL_LINK_MODE_100000baseLR4_ER4_Full_BIT                            = C.ETHTOOL_LINK_MODE_100000baseLR4_ER4_Full_BIT
	ETHTOOL_LINK_MODE_50000baseSR2_Full_BIT                                 = C.ETHTOOL_LINK_MODE_50000baseSR2_Full_BIT
	ETHTOOL_LINK_MODE_1000baseX_Full_BIT                                    = C.ETHTOOL_LINK_MODE_1000baseX_Full_BIT
	ETHTOOL_LINK_MODE_10000baseCR_Full_BIT                                  = C.ETHTOOL_LINK_MODE_10000baseCR_Full_BIT
	ETHTOOL_LINK_MODE_10000baseSR_Full_BIT                                  = C.ETHTOOL_LINK_MODE_10000baseSR_Full_BIT
	ETHTOOL_LINK_MODE_10000baseLR_Full_BIT                                  = C.ETHTOOL_LINK_MODE_10000baseLR_Full_BIT
	ETHTOOL_LINK_MODE_10000baseLRM_Full_BIT                                 = C.ETHTOOL_LINK_MODE_10000baseLRM_Full_BIT
	ETHTOOL_LINK_MODE_10000baseER_Full_BIT                                  = C.ETHTOOL_LINK_MODE_10000baseER_Full_BIT
	ETHTOOL_LINK_MODE_2500baseT_Full_BIT                                    = C.ETHTOOL_LINK_MODE_2500baseT_Full_BIT
	ETHTOOL_LINK_MODE_5000baseT_Full_BIT                                    = C.ETHTOOL_LINK_MODE_5000baseT_Full_BIT
	ETHTOOL_LINK_MODE_FEC_NONE_BIT                                          = C.ETHTOOL_LINK_MODE_FEC_NONE_BIT
	ETHTOOL_LINK_MODE_FEC_RS_BIT                                            = C.ETHTOOL_LINK_MODE_FEC_RS_BIT
	ETHTOOL_LINK_MODE_FEC_BASER_BIT                                         = C.ETHTOOL_LINK_MODE_FEC_BASER_BIT
	ETHTOOL_LINK_MODE_50000baseKR_Full_BIT                                  = C.ETHTOOL_LINK_MODE_50000baseKR_Full_BIT
	ETHTOOL_LINK_MODE_50000baseSR_Full_BIT                                  = C.ETHTOOL_LINK_MODE_50000baseSR_Full_BIT
	ETHTOOL_LINK_MODE_50000baseCR_Full_BIT                                  = C.ETHTOOL_LINK_MODE_50000baseCR_Full_BIT
	ETHTOOL_LINK_MODE_50000baseLR_ER_FR_Full_BIT                            = C.ETHTOOL_LINK_MODE_50000baseLR_ER_FR_Full_BIT
	ETHTOOL_LINK_MODE_50000baseDR_Full_BIT                                  = C.ETHTOOL_LINK_MODE_50000baseDR_Full_BIT
	ETHTOOL_LINK_MODE_100000baseKR2_Full_BIT                                = C.ETHTOOL_LINK_MODE_100000baseKR2_Full_BIT
	ETHTOOL_LINK_MODE_100000baseSR2_Full_BIT                                = C.ETHTOOL_LINK_MODE_100000baseSR2_Full_BIT
	ETHTOOL_LINK_MODE_100000baseCR2_Full_BIT                                = C.ETHTOOL_LINK_MODE_100000baseCR2_Full_BIT
	ETHTOOL_LINK_MODE_100000baseLR2_ER2_FR2_Full_BIT                        = C.ETHTOOL_LINK_MODE_100000baseLR2_ER2_FR2_Full_BIT
	ETHTOOL_LINK_MODE_100000baseDR2_Full_BIT                                = C.ETHTOOL_LINK_MODE_100000baseDR2_Full_BIT
	ETHTOOL_LINK_MODE_200000baseKR4_Full_BIT                                = C.ETHTOOL_LINK_MODE_200000baseKR4_Full_BIT
	ETHTOOL_LINK_MODE_200000baseSR4_Full_BIT                                = C.ETHTOOL_LINK_MODE_200000baseSR4_Full_BIT
	ETHTOOL_LINK_MODE_200000baseLR4_ER4_FR4_Full_BIT                        = C.ETHTOOL_LINK_MODE_200000baseLR4_ER4_FR4_Full_BIT
	ETHTOOL_LINK_MODE_200000baseDR4_Full_BIT                                = C.ETHTOOL_LINK_MODE_200000baseDR4_Full_BIT
	ETHTOOL_LINK_MODE_200000baseCR4_Full_BIT                                = C.ETHTOOL_LINK_MODE_200000baseCR4_Full_BIT
	ETHTOOL_LINK_MODE_100baseT1_Full_BIT                                    = C.ETHTOOL_LINK_MODE_100baseT1_Full_BIT
	ETHTOOL_LINK_MODE_1000baseT1_Full_BIT                                   = C.ETHTOOL_LINK_MODE_1000baseT1_Full_BIT
	ETHTOOL_LINK_MODE_400000baseKR8_Full_BIT                                = C.ETHTOOL_LINK_MODE_400000baseKR8_Full_BIT
	ETHTOOL_LINK_MODE_400000baseSR8_Full_BIT                                = C.ETHTOOL_LINK_MODE_400000baseSR8_Full_BIT
	ETHTOOL_LINK_MODE_400000baseLR8_ER8_FR8_Full_BIT                        = C.ETHTOOL_LINK_MODE_400000baseLR8_ER8_FR8_Full_BIT
	ETHTOOL_LINK_MODE_400000baseDR8_Full_BIT                                = C.ETHTOOL_LINK_MODE_400000baseDR8_Full_BIT
	ETHTOOL_LINK_MODE_400000baseCR8_Full_BIT                                = C.ETHTOOL_LINK_MODE_400000baseCR8_Full_BIT
	ETHTOOL_LINK_MODE_FEC_LLRS_BIT                                          = C.ETHTOOL_LINK_MODE_FEC_LLRS_BIT
	ETHTOOL_LINK_MODE_100000baseKR_Full_BIT                                 = C.ETHTOOL_LINK_MODE_100000baseKR_Full_BIT
	ETHTOOL_LINK_MODE_100000baseSR_Full_BIT                                 = C.ETHTOOL_LINK_MODE_100000baseSR_Full_BIT
	ETHTOOL_LINK_MODE_100000baseLR_ER_FR_Full_BIT                           = C.ETHTOOL_LINK_MODE_100000baseLR_ER_FR_Full_BIT
	ETHTOOL_LINK_MODE_100000baseCR_Full_BIT                                 = C.ETHTOOL_LINK_MODE_100000baseCR_Full_BIT
	ETHTOOL_LINK_MODE_100000baseDR_Full_BIT                                 = C.ETHTOOL_LINK_MODE_100000baseDR_Full_BIT
	ETHTOOL_LINK_MODE_200000baseKR2_Full_BIT                                = C.ETHTOOL_LINK_MODE_200000baseKR2_Full_BIT
	ETHTOOL_LINK_MODE_200000baseSR2_Full_BIT                                = C.ETHTOOL_LINK_MODE_200000baseSR2_Full_BIT
	ETHTOOL_LINK_MODE_200000baseLR2_ER2_FR2_Full_BIT                        = C.ETHTOOL_LINK_MODE_200000baseLR2_ER2_FR2_Full_BIT
	ETHTOOL_LINK_MODE_200000baseDR2_Full_BIT                                = C.ETHTOOL_LINK_MODE_200000baseDR2_Full_BIT
	ETHTOOL_LINK_MODE_200000baseCR2_Full_BIT                                = C.ETHTOOL_LINK_MODE_200000baseCR2_Full_BIT
	ETHTOOL_LINK_MODE_400000baseKR4_Full_BIT                                = C.ETHTOOL_LINK_MODE_400000baseKR4_Full_BIT
	ETHTOOL_LINK_MODE_400000baseSR4_Full_BIT                                = C.ETHTOOL_LINK_MODE_400000baseSR4_Full_BIT
	ETHTOOL_LINK_MODE_400000baseLR4_ER4_FR4_Full_BIT                        = C.ETHTOOL_LINK_MODE_400000baseLR4_ER4_FR4_Full_BIT
	ETHTOOL_LINK_MODE_400000baseDR4_Full_BIT                                = C.ETHTOOL_LINK_MODE_400000baseDR4_Full_BIT
	ETHTOOL_LINK_MODE_400000baseCR4_Full_BIT                                = C.ETHTOOL_LINK_MODE_400000baseCR4_Full_BIT
	ETHTOOL_LINK_MODE_100baseFX_Half_BIT                                    = C.ETHTOOL_LINK_MODE_100baseFX_Half_BIT
	ETHTOOL_LINK_MODE_100baseFX_Full_BIT                                    = C.ETHTOOL_LINK_MODE_100baseFX_Full_BIT

	ETHTOOL_MSG_USER_NONE                     = C.ETHTOOL_MSG_USER_NONE
	ETHTOOL_MSG_STRSET_GET                    = C.ETHTOOL_MSG_STRSET_GET
	ETHTOOL_MSG_LINKINFO_GET                  = C.ETHTOOL_MSG_LINKINFO_GET
	ETHTOOL_MSG_LINKINFO_SET                  = C.ETHTOOL_MSG_LINKINFO_SET
	ETHTOOL_MSG_LINKMODES_GET                 = C.ETHTOOL_MSG_LINKMODES_GET
	ETHTOOL_MSG_LINKMODES_SET                 = C.ETHTOOL_MSG_LINKMODES_SET
	ETHTOOL_MSG_LINKSTATE_GET                 = C.ETHTOOL_MSG_LINKSTATE_GET
	ETHTOOL_MSG_DEBUG_GET                     = C.ETHTOOL_MSG_DEBUG_GET
	ETHTOOL_MSG_DEBUG_SET                     = C.ETHTOOL_MSG_DEBUG_SET
	ETHTOOL_MSG_WOL_GET                       = C.ETHTOOL_MSG_WOL_GET
	ETHTOOL_MSG_WOL_SET                       = C.ETHTOOL_MSG_WOL_SET
	ETHTOOL_MSG_FEATURES_GET                  = C.ETHTOOL_MSG_FEATURES_GET
	ETHTOOL_MSG_FEATURES_SET                  = C.ETHTOOL_MSG_FEATURES_SET
	ETHTOOL_MSG_PRIVFLAGS_GET                 = C.ETHTOOL_MSG_PRIVFLAGS_GET
	ETHTOOL_MSG_PRIVFLAGS_SET                 = C.ETHTOOL_MSG_PRIVFLAGS_SET
	ETHTOOL_MSG_RINGS_GET                     = C.ETHTOOL_MSG_RINGS_GET
	ETHTOOL_MSG_RINGS_SET                     = C.ETHTOOL_MSG_RINGS_SET
	ETHTOOL_MSG_CHANNELS_GET                  = C.ETHTOOL_MSG_CHANNELS_GET
	ETHTOOL_MSG_CHANNELS_SET                  = C.ETHTOOL_MSG_CHANNELS_SET
	ETHTOOL_MSG_COALESCE_GET                  = C.ETHTOOL_MSG_COALESCE_GET
	ETHTOOL_MSG_COALESCE_SET                  = C.ETHTOOL_MSG_COALESCE_SET
	ETHTOOL_MSG_PAUSE_GET                     = C.ETHTOOL_MSG_PAUSE_GET
	ETHTOOL_MSG_PAUSE_SET                     = C.ETHTOOL_MSG_PAUSE_SET
	ETHTOOL_MSG_EEE_GET                       = C.ETHTOOL_MSG_EEE_GET
	ETHTOOL_MSG_EEE_SET                       = C.ETHTOOL_MSG_EEE_SET
	ETHTOOL_MSG_TSINFO_GET                    = C.ETHTOOL_MSG_TSINFO_GET
	ETHTOOL_MSG_CABLE_TEST_ACT                = C.ETHTOOL_MSG_CABLE_TEST_ACT
	ETHTOOL_MSG_CABLE_TEST_TDR_ACT            = C.ETHTOOL_MSG_CABLE_TEST_TDR_ACT
	ETHTOOL_MSG_TUNNEL_INFO_GET               = C.ETHTOOL_MSG_TUNNEL_INFO_GET
	ETHTOOL_MSG_FEC_GET                       = C.ETHTOOL_MSG_FEC_GET
	ETHTOOL_MSG_FEC_SET                       = C.ETHTOOL_MSG_FEC_SET
	ETHTOOL_MSG_MODULE_EEPROM_GET             = C.ETHTOOL_MSG_MODULE_EEPROM_GET
	ETHTOOL_MSG_STATS_GET                     = C.ETHTOOL_MSG_STATS_GET
	ETHTOOL_MSG_PHC_VCLOCKS_GET               = C.ETHTOOL_MSG_PHC_VCLOCKS_GET
	ETHTOOL_MSG_MODULE_GET                    = C.ETHTOOL_MSG_MODULE_GET
	ETHTOOL_MSG_MODULE_SET                    = C.ETHTOOL_MSG_MODULE_SET
	ETHTOOL_MSG_USER_MAX                      = C.ETHTOOL_MSG_USER_MAX
	ETHTOOL_MSG_KERNEL_NONE                   = C.ETHTOOL_MSG_KERNEL_NONE
	ETHTOOL_MSG_STRSET_GET_REPLY              = C.ETHTOOL_MSG_STRSET_GET_REPLY
	ETHTOOL_MSG_LINKINFO_GET_REPLY            = C.ETHTOOL_MSG_LINKINFO_GET_REPLY
	ETHTOOL_MSG_LINKINFO_NTF                  = C.ETHTOOL_MSG_LINKINFO_NTF
	ETHTOOL_MSG_LINKMODES_GET_REPLY           = C.ETHTOOL_MSG_LINKMODES_GET_REPLY
	ETHTOOL_MSG_LINKMODES_NTF                 = C.ETHTOOL_MSG_LINKMODES_NTF
	ETHTOOL_MSG_LINKSTATE_GET_REPLY           = C.ETHTOOL_MSG_LINKSTATE_GET_REPLY
	ETHTOOL_MSG_DEBUG_GET_REPLY               = C.ETHTOOL_MSG_DEBUG_GET_REPLY
	ETHTOOL_MSG_DEBUG_NTF                     = C.ETHTOOL_MSG_DEBUG_NTF
	ETHTOOL_MSG_WOL_GET_REPLY                 = C.ETHTOOL_MSG_WOL_GET_REPLY
	ETHTOOL_MSG_WOL_NTF                       = C.ETHTOOL_MSG_WOL_NTF
	ETHTOOL_MSG_FEATURES_GET_REPLY            = C.ETHTOOL_MSG_FEATURES_GET_REPLY
	ETHTOOL_MSG_FEATURES_SET_REPLY            = C.ETHTOOL_MSG_FEATURES_SET_REPLY
	ETHTOOL_MSG_FEATURES_NTF                  = C.ETHTOOL_MSG_FEATURES_NTF
	ETHTOOL_MSG_PRIVFLAGS_GET_REPLY           = C.ETHTOOL_MSG_PRIVFLAGS_GET_REPLY
	ETHTOOL_MSG_PRIVFLAGS_NTF                 = C.ETHTOOL_MSG_PRIVFLAGS_NTF
	ETHTOOL_MSG_RINGS_GET_REPLY               = C.ETHTOOL_MSG_RINGS_GET_REPLY
	ETHTOOL_MSG_RINGS_NTF                     = C.ETHTOOL_MSG_RINGS_NTF
	ETHTOOL_MSG_CHANNELS_GET_REPLY            = C.ETHTOOL_MSG_CHANNELS_GET_REPLY
	ETHTOOL_MSG_CHANNELS_NTF                  = C.ETHTOOL_MSG_CHANNELS_NTF
	ETHTOOL_MSG_COALESCE_GET_REPLY            = C.ETHTOOL_MSG_COALESCE_GET_REPLY
	ETHTOOL_MSG_COALESCE_NTF                  = C.ETHTOOL_MSG_COALESCE_NTF
	ETHTOOL_MSG_PAUSE_GET_REPLY               = C.ETHTOOL_MSG_PAUSE_GET_REPLY
	ETHTOOL_MSG_PAUSE_NTF                     = C.ETHTOOL_MSG_PAUSE_NTF
	ETHTOOL_MSG_EEE_GET_REPLY                 = C.ETHTOOL_MSG_EEE_GET_REPLY
	ETHTOOL_MSG_EEE_NTF                       = C.ETHTOOL_MSG_EEE_NTF
	ETHTOOL_MSG_TSINFO_GET_REPLY              = C.ETHTOOL_MSG_TSINFO_GET_REPLY
	ETHTOOL_MSG_CABLE_TEST_NTF                = C.ETHTOOL_MSG_CABLE_TEST_NTF
	ETHTOOL_MSG_CABLE_TEST_TDR_NTF            = C.ETHTOOL_MSG_CABLE_TEST_TDR_NTF
	ETHTOOL_MSG_TUNNEL_INFO_GET_REPLY         = C.ETHTOOL_MSG_TUNNEL_INFO_GET_REPLY
	ETHTOOL_MSG_FEC_GET_REPLY                 = C.ETHTOOL_MSG_FEC_GET_REPLY
	ETHTOOL_MSG_FEC_NTF                       = C.ETHTOOL_MSG_FEC_NTF
	ETHTOOL_MSG_MODULE_EEPROM_GET_REPLY       = C.ETHTOOL_MSG_MODULE_EEPROM_GET_REPLY
	ETHTOOL_MSG_STATS_GET_REPLY               = C.ETHTOOL_MSG_STATS_GET_REPLY
	ETHTOOL_MSG_PHC_VCLOCKS_GET_REPLY         = C.ETHTOOL_MSG_PHC_VCLOCKS_GET_REPLY
	ETHTOOL_MSG_MODULE_GET_REPLY              = C.ETHTOOL_MSG_MODULE_GET_REPLY
	ETHTOOL_MSG_MODULE_NTF                    = C.ETHTOOL_MSG_MODULE_NTF
	ETHTOOL_MSG_KERNEL_MAX                    = C.ETHTOOL_MSG_KERNEL_MAX
	ETHTOOL_A_HEADER_UNSPEC                   = C.ETHTOOL_A_HEADER_UNSPEC
	ETHTOOL_A_HEADER_DEV_INDEX                = C.ETHTOOL_A_HEADER_DEV_INDEX
	ETHTOOL_A_HEADER_DEV_NAME                 = C.ETHTOOL_A_HEADER_DEV_NAME
	ETHTOOL_A_HEADER_FLAGS                    = C.ETHTOOL_A_HEADER_FLAGS
	ETHTOOL_A_HEADER_MAX                      = C.ETHTOOL_A_HEADER_MAX
	ETHTOOL_A_BITSET_BIT_UNSPEC               = C.ETHTOOL_A_BITSET_BIT_UNSPEC
	ETHTOOL_A_BITSET_BIT_INDEX                = C.ETHTOOL_A_BITSET_BIT_INDEX
	ETHTOOL_A_BITSET_BIT_NAME                 = C.ETHTOOL_A_BITSET_BIT_NAME
	ETHTOOL_A_BITSET_BIT_VALUE                = C.ETHTOOL_A_BITSET_BIT_VALUE
	ETHTOOL_A_BITSET_BIT_MAX                  = C.ETHTOOL_A_BITSET_BIT_MAX
	ETHTOOL_A_BITSET_BITS_UNSPEC              = C.ETHTOOL_A_BITSET_BITS_UNSPEC
	ETHTOOL_A_BITSET_BITS_BIT                 = C.ETHTOOL_A_BITSET_BITS_BIT
	ETHTOOL_A_BITSET_BITS_MAX                 = C.ETHTOOL_A_BITSET_BITS_MAX
	ETHTOOL_A_BITSET_UNSPEC                   = C.ETHTOOL_A_BITSET_UNSPEC
	ETHTOOL_A_BITSET_NOMASK                   = C.ETHTOOL_A_BITSET_NOMASK
	ETHTOOL_A_BITSET_SIZE                     = C.ETHTOOL_A_BITSET_SIZE
	ETHTOOL_A_BITSET_BITS                     = C.ETHTOOL_A_BITSET_BITS
	ETHTOOL_A_BITSET_VALUE                    = C.ETHTOOL_A_BITSET_VALUE
	ETHTOOL_A_BITSET_MASK                     = C.ETHTOOL_A_BITSET_MASK
	ETHTOOL_A_BITSET_MAX                      = C.ETHTOOL_A_BITSET_MAX
	ETHTOOL_A_STRING_UNSPEC                   = C.ETHTOOL_A_STRING_UNSPEC
	ETHTOOL_A_STRING_INDEX                    = C.ETHTOOL_A_STRING_INDEX
	ETHTOOL_A_STRING_VALUE                    = C.ETHTOOL_A_STRING_VALUE
	ETHTOOL_A_STRING_MAX                      = C.ETHTOOL_A_STRING_MAX
	ETHTOOL_A_STRINGS_UNSPEC                  = C.ETHTOOL_A_STRINGS_UNSPEC
	ETHTOOL_A_STRINGS_STRING                  = C.ETHTOOL_A_STRINGS_STRING
	ETHTOOL_A_STRINGS_MAX                     = C.ETHTOOL_A_STRINGS_MAX
	ETHTOOL_A_STRINGSET_UNSPEC                = C.ETHTOOL_A_STRINGSET_UNSPEC
	ETHTOOL_A_STRINGSET_ID                    = C.ETHTOOL_A_STRINGSET_ID
	ETHTOOL_A_STRINGSET_COUNT                 = C.ETHTOOL_A_STRINGSET_COUNT
	ETHTOOL_A_STRINGSET_STRINGS               = C.ETHTOOL_A_STRINGSET_STRINGS
	ETHTOOL_A_STRINGSET_MAX                   = C.ETHTOOL_A_STRINGSET_MAX
	ETHTOOL_A_STRINGSETS_UNSPEC               = C.ETHTOOL_A_STRINGSETS_UNSPEC
	ETHTOOL_A_STRINGSETS_STRINGSET            = C.ETHTOOL_A_STRINGSETS_STRINGSET
	ETHTOOL_A_STRINGSETS_MAX                  = C.ETHTOOL_A_STRINGSETS_MAX
	ETHTOOL_A_STRSET_UNSPEC                   = C.ETHTOOL_A_STRSET_UNSPEC
	ETHTOOL_A_STRSET_HEADER                   = C.ETHTOOL_A_STRSET_HEADER
	ETHTOOL_A_STRSET_STRINGSETS               = C.ETHTOOL_A_STRSET_STRINGSETS
	ETHTOOL_A_STRSET_COUNTS_ONLY              = C.ETHTOOL_A_STRSET_COUNTS_ONLY
	ETHTOOL_A_STRSET_MAX                      = C.ETHTOOL_A_STRSET_MAX
	ETHTOOL_A_LINKINFO_UNSPEC                 = C.ETHTOOL_A_LINKINFO_UNSPEC
	ETHTOOL_A_LINKINFO_HEADER                 = C.ETHTOOL_A_LINKINFO_HEADER
	ETHTOOL_A_LINKINFO_PORT                   = C.ETHTOOL_A_LINKINFO_PORT
	ETHTOOL_A_LINKINFO_PHYADDR                = C.ETHTOOL_A_LINKINFO_PHYADDR
	ETHTOOL_A_LINKINFO_TP_MDIX                = C.ETHTOOL_A_LINKINFO_TP_MDIX
	ETHTOOL_A_LINKINFO_TP_MDIX_CTRL           = C.ETHTOOL_A_LINKINFO_TP_MDIX_CTRL
	ETHTOOL_A_LINKINFO_TRANSCEIVER            = C.ETHTOOL_A_LINKINFO_TRANSCEIVER
	ETHTOOL_A_LINKINFO_MAX                    = C.ETHTOOL_A_LINKINFO_MAX
	ETHTOOL_A_LINKMODES_UNSPEC                = C.ETHTOOL_A_LINKMODES_UNSPEC
	ETHTOOL_A_LINKMODES_HEADER                = C.ETHTOOL_A_LINKMODES_HEADER
	ETHTOOL_A_LINKMODES_AUTONEG               = C.ETHTOOL_A_LINKMODES_AUTONEG
	ETHTOOL_A_LINKMODES_OURS                  = C.ETHTOOL_A_LINKMODES_OURS
	ETHTOOL_A_LINKMODES_PEER                  = C.ETHTOOL_A_LINKMODES_PEER
	ETHTOOL_A_LINKMODES_SPEED                 = C.ETHTOOL_A_LINKMODES_SPEED
	ETHTOOL_A_LINKMODES_DUPLEX                = C.ETHTOOL_A_LINKMODES_DUPLEX
	ETHTOOL_A_LINKMODES_MASTER_SLAVE_CFG      = C.ETHTOOL_A_LINKMODES_MASTER_SLAVE_CFG
	ETHTOOL_A_LINKMODES_MASTER_SLAVE_STATE    = C.ETHTOOL_A_LINKMODES_MASTER_SLAVE_STATE
	ETHTOOL_A_LINKMODES_LANES                 = C.ETHTOOL_A_LINKMODES_LANES
	ETHTOOL_A_LINKMODES_MAX                   = C.ETHTOOL_A_LINKMODES_MAX
	ETHTOOL_A_LINKSTATE_UNSPEC                = C.ETHTOOL_A_LINKSTATE_UNSPEC
	ETHTOOL_A_LINKSTATE_HEADER                = C.ETHTOOL_A_LINKSTATE_HEADER
	ETHTOOL_A_LINKSTATE_LINK                  = C.ETHTOOL_A_LINKSTATE_LINK
	ETHTOOL_A_LINKSTATE_SQI                   = C.ETHTOOL_A_LINKSTATE_SQI
	ETHTOOL_A_LINKSTATE_SQI_MAX               = C.ETHTOOL_A_LINKSTATE_SQI_MAX
	ETHTOOL_A_LINKSTATE_EXT_STATE             = C.ETHTOOL_A_LINKSTATE_EXT_STATE
	ETHTOOL_A_LINKSTATE_EXT_SUBSTATE          = C.ETHTOOL_A_LINKSTATE_EXT_SUBSTATE
	ETHTOOL_A_LINKSTATE_MAX                   = C.ETHTOOL_A_LINKSTATE_MAX
	ETHTOOL_A_DEBUG_UNSPEC                    = C.ETHTOOL_A_DEBUG_UNSPEC
	ETHTOOL_A_DEBUG_HEADER                    = C.ETHTOOL_A_DEBUG_HEADER
	ETHTOOL_A_DEBUG_MSGMASK                   = C.ETHTOOL_A_DEBUG_MSGMASK
	ETHTOOL_A_DEBUG_MAX                       = C.ETHTOOL_A_DEBUG_MAX
	ETHTOOL_A_WOL_UNSPEC                      = C.ETHTOOL_A_WOL_UNSPEC
	ETHTOOL_A_WOL_HEADER                      = C.ETHTOOL_A_WOL_HEADER
	ETHTOOL_A_WOL_MODES                       = C.ETHTOOL_A_WOL_MODES
	ETHTOOL_A_WOL_SOPASS                      = C.ETHTOOL_A_WOL_SOPASS
	ETHTOOL_A_WOL_MAX                         = C.ETHTOOL_A_WOL_MAX
	ETHTOOL_A_FEATURES_UNSPEC                 = C.ETHTOOL_A_FEATURES_UNSPEC
	ETHTOOL_A_FEATURES_HEADER                 = C.ETHTOOL_A_FEATURES_HEADER
	ETHTOOL_A_FEATURES_HW                     = C.ETHTOOL_A_FEATURES_HW
	ETHTOOL_A_FEATURES_WANTED                 = C.ETHTOOL_A_FEATURES_WANTED
	ETHTOOL_A_FEATURES_ACTIVE                 = C.ETHTOOL_A_FEATURES_ACTIVE
	ETHTOOL_A_FEATURES_NOCHANGE               = C.ETHTOOL_A_FEATURES_NOCHANGE
	ETHTOOL_A_FEATURES_MAX                    = C.ETHTOOL_A_FEATURES_MAX
	ETHTOOL_A_PRIVFLAGS_UNSPEC                = C.ETHTOOL_A_PRIVFLAGS_UNSPEC
	ETHTOOL_A_PRIVFLAGS_HEADER                = C.ETHTOOL_A_PRIVFLAGS_HEADER
	ETHTOOL_A_PRIVFLAGS_FLAGS                 = C.ETHTOOL_A_PRIVFLAGS_FLAGS
	ETHTOOL_A_PRIVFLAGS_MAX                   = C.ETHTOOL_A_PRIVFLAGS_MAX
	ETHTOOL_A_RINGS_UNSPEC                    = C.ETHTOOL_A_RINGS_UNSPEC
	ETHTOOL_A_RINGS_HEADER                    = C.ETHTOOL_A_RINGS_HEADER
	ETHTOOL_A_RINGS_RX_MAX                    = C.ETHTOOL_A_RINGS_RX_MAX
	ETHTOOL_A_RINGS_RX_MINI_MAX               = C.ETHTOOL_A_RINGS_RX_MINI_MAX
	ETHTOOL_A_RINGS_RX_JUMBO_MAX              = C.ETHTOOL_A_RINGS_RX_JUMBO_MAX
	ETHTOOL_A_RINGS_TX_MAX                    = C.ETHTOOL_A_RINGS_TX_MAX
	ETHTOOL_A_RINGS_RX                        = C.ETHTOOL_A_RINGS_RX
	ETHTOOL_A_RINGS_RX_MINI                   = C.ETHTOOL_A_RINGS_RX_MINI
	ETHTOOL_A_RINGS_RX_JUMBO                  = C.ETHTOOL_A_RINGS_RX_JUMBO
	ETHTOOL_A_RINGS_TX                        = C.ETHTOOL_A_RINGS_TX
	ETHTOOL_A_RINGS_RX_BUF_LEN                = C.ETHTOOL_A_RINGS_RX_BUF_LEN
	ETHTOOL_A_RINGS_TCP_DATA_SPLIT            = C.ETHTOOL_A_RINGS_TCP_DATA_SPLIT
	ETHTOOL_A_RINGS_CQE_SIZE                  = C.ETHTOOL_A_RINGS_CQE_SIZE
	ETHTOOL_A_RINGS_TX_PUSH                   = C.ETHTOOL_A_RINGS_TX_PUSH
	ETHTOOL_A_RINGS_MAX                       = C.ETHTOOL_A_RINGS_MAX
	ETHTOOL_A_CHANNELS_UNSPEC                 = C.ETHTOOL_A_CHANNELS_UNSPEC
	ETHTOOL_A_CHANNELS_HEADER                 = C.ETHTOOL_A_CHANNELS_HEADER
	ETHTOOL_A_CHANNELS_RX_MAX                 = C.ETHTOOL_A_CHANNELS_RX_MAX
	ETHTOOL_A_CHANNELS_TX_MAX                 = C.ETHTOOL_A_CHANNELS_TX_MAX
	ETHTOOL_A_CHANNELS_OTHER_MAX              = C.ETHTOOL_A_CHANNELS_OTHER_MAX
	ETHTOOL_A_CHANNELS_COMBINED_MAX           = C.ETHTOOL_A_CHANNELS_COMBINED_MAX
	ETHTOOL_A_CHANNELS_RX_COUNT               = C.ETHTOOL_A_CHANNELS_RX_COUNT
	ETHTOOL_A_CHANNELS_TX_COUNT               = C.ETHTOOL_A_CHANNELS_TX_COUNT
	ETHTOOL_A_CHANNELS_OTHER_COUNT            = C.ETHTOOL_A_CHANNELS_OTHER_COUNT
	ETHTOOL_A_CHANNELS_COMBINED_COUNT         = C.ETHTOOL_A_CHANNELS_COMBINED_COUNT
	ETHTOOL_A_CHANNELS_MAX                    = C.ETHTOOL_A_CHANNELS_MAX
	ETHTOOL_A_COALESCE_UNSPEC                 = C.ETHTOOL_A_COALESCE_UNSPEC
	ETHTOOL_A_COALESCE_HEADER                 = C.ETHTOOL_A_COALESCE_HEADER
	ETHTOOL_A_COALESCE_RX_USECS               = C.ETHTOOL_A_COALESCE_RX_USECS
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES          = C.ETHTOOL_A_COALESCE_RX_MAX_FRAMES
	ETHTOOL_A_COALESCE_RX_USECS_IRQ           = C.ETHTOOL_A_COALESCE_RX_USECS_IRQ
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_IRQ      = C.ETHTOOL_A_COALESCE_RX_MAX_FRAMES_IRQ
	ETHTOOL_A_COALESCE_TX_USECS               = C.ETHTOOL_A_COALESCE_TX_USECS
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES          = C.ETHTOOL_A_COALESCE_TX_MAX_FRAMES
	ETHTOOL_A_COALESCE_TX_USECS_IRQ           = C.ETHTOOL_A_COALESCE_TX_USECS_IRQ
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_IRQ      = C.ETHTOOL_A_COALESCE_TX_MAX_FRAMES_IRQ
	ETHTOOL_A_COALESCE_STATS_BLOCK_USECS      = C.ETHTOOL_A_COALESCE_STATS_BLOCK_USECS
	ETHTOOL_A_COALESCE_USE_ADAPTIVE_RX        = C.ETHTOOL_A_COALESCE_USE_ADAPTIVE_RX
	ETHTOOL_A_COALESCE_USE_ADAPTIVE_TX        = C.ETHTOOL_A_COALESCE_USE_ADAPTIVE_TX
	ETHTOOL_A_COALESCE_PKT_RATE_LOW           = C.ETHTOOL_A_COALESCE_PKT_RATE_LOW
	ETHTOOL_A_COALESCE_RX_USECS_LOW           = C.ETHTOOL_A_COALESCE_RX_USECS_LOW
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_LOW      = C.ETHTOOL_A_COALESCE_RX_MAX_FRAMES_LOW
	ETHTOOL_A_COALESCE_TX_USECS_LOW           = C.ETHTOOL_A_COALESCE_TX_USECS_LOW
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_LOW      = C.ETHTOOL_A_COALESCE_TX_MAX_FRAMES_LOW
	ETHTOOL_A_COALESCE_PKT_RATE_HIGH          = C.ETHTOOL_A_COALESCE_PKT_RATE_HIGH
	ETHTOOL_A_COALESCE_RX_USECS_HIGH          = C.ETHTOOL_A_COALESCE_RX_USECS_HIGH
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_HIGH     = C.ETHTOOL_A_COALESCE_RX_MAX_FRAMES_HIGH
	ETHTOOL_A_COALESCE_TX_USECS_HIGH          = C.ETHTOOL_A_COALESCE_TX_USECS_HIGH
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_HIGH     = C.ETHTOOL_A_COALESCE_TX_MAX_FRAMES_HIGH
	ETHTOOL_A_COALESCE_RATE_SAMPLE_INTERVAL   = C.ETHTOOL_A_COALESCE_RATE_SAMPLE_INTERVAL
	ETHTOOL_A_COALESCE_USE_CQE_MODE_TX        = C.ETHTOOL_A_COALESCE_USE_CQE_MODE_TX
	ETHTOOL_A_COALESCE_USE_CQE_MODE_RX        = C.ETHTOOL_A_COALESCE_USE_CQE_MODE_RX
	ETHTOOL_A_COALESCE_MAX                    = C.ETHTOOL_A_COALESCE_MAX
	ETHTOOL_A_PAUSE_UNSPEC                    = C.ETHTOOL_A_PAUSE_UNSPEC
	ETHTOOL_A_PAUSE_HEADER                    = C.ETHTOOL_A_PAUSE_HEADER
	ETHTOOL_A_PAUSE_AUTONEG                   = C.ETHTOOL_A_PAUSE_AUTONEG
	ETHTOOL_A_PAUSE_RX                        = C.ETHTOOL_A_PAUSE_RX
	ETHTOOL_A_PAUSE_TX                        = C.ETHTOOL_A_PAUSE_TX
	ETHTOOL_A_PAUSE_STATS                     = C.ETHTOOL_A_PAUSE_STATS
	ETHTOOL_A_PAUSE_MAX                       = C.ETHTOOL_A_PAUSE_MAX
	ETHTOOL_A_PAUSE_STAT_UNSPEC               = C.ETHTOOL_A_PAUSE_STAT_UNSPEC
	ETHTOOL_A_PAUSE_STAT_PAD                  = C.ETHTOOL_A_PAUSE_STAT_PAD
	ETHTOOL_A_PAUSE_STAT_TX_FRAMES            = C.ETHTOOL_A_PAUSE_STAT_TX_FRAMES
	ETHTOOL_A_PAUSE_STAT_RX_FRAMES            = C.ETHTOOL_A_PAUSE_STAT_RX_FRAMES
	ETHTOOL_A_PAUSE_STAT_MAX                  = C.ETHTOOL_A_PAUSE_STAT_MAX
	ETHTOOL_A_EEE_UNSPEC                      = C.ETHTOOL_A_EEE_UNSPEC
	ETHTOOL_A_EEE_HEADER                      = C.ETHTOOL_A_EEE_HEADER
	ETHTOOL_A_EEE_MODES_OURS                  = C.ETHTOOL_A_EEE_MODES_OURS
	ETHTOOL_A_EEE_MODES_PEER                  = C.ETHTOOL_A_EEE_MODES_PEER
	ETHTOOL_A_EEE_ACTIVE                      = C.ETHTOOL_A_EEE_ACTIVE
	ETHTOOL_A_EEE_ENABLED                     = C.ETHTOOL_A_EEE_ENABLED
	ETHTOOL_A_EEE_TX_LPI_ENABLED              = C.ETHTOOL_A_EEE_TX_LPI_ENABLED
	ETHTOOL_A_EEE_TX_LPI_TIMER                = C.ETHTOOL_A_EEE_TX_LPI_TIMER
	ETHTOOL_A_EEE_MAX                         = C.ETHTOOL_A_EEE_MAX
	ETHTOOL_A_TSINFO_UNSPEC                   = C.ETHTOOL_A_TSINFO_UNSPEC
	ETHTOOL_A_TSINFO_HEADER                   = C.ETHTOOL_A_TSINFO_HEADER
	ETHTOOL_A_TSINFO_TIMESTAMPING             = C.ETHTOOL_A_TSINFO_TIMESTAMPING
	ETHTOOL_A_TSINFO_TX_TYPES                 = C.ETHTOOL_A_TSINFO_TX_TYPES
	ETHTOOL_A_TSINFO_RX_FILTERS               = C.ETHTOOL_A_TSINFO_RX_FILTERS
	ETHTOOL_A_TSINFO_PHC_INDEX                = C.ETHTOOL_A_TSINFO_PHC_INDEX
	ETHTOOL_A_TSINFO_MAX                      = C.ETHTOOL_A_TSINFO_MAX
	ETHTOOL_A_CABLE_TEST_UNSPEC               = C.ETHTOOL_A_CABLE_TEST_UNSPEC
	ETHTOOL_A_CABLE_TEST_HEADER               = C.ETHTOOL_A_CABLE_TEST_HEADER
	ETHTOOL_A_CABLE_TEST_MAX                  = C.ETHTOOL_A_CABLE_TEST_MAX
	ETHTOOL_A_CABLE_RESULT_CODE_UNSPEC        = C.ETHTOOL_A_CABLE_RESULT_CODE_UNSPEC
	ETHTOOL_A_CABLE_RESULT_CODE_OK            = C.ETHTOOL_A_CABLE_RESULT_CODE_OK
	ETHTOOL_A_CABLE_RESULT_CODE_OPEN          = C.ETHTOOL_A_CABLE_RESULT_CODE_OPEN
	ETHTOOL_A_CABLE_RESULT_CODE_SAME_SHORT    = C.ETHTOOL_A_CABLE_RESULT_CODE_SAME_SHORT
	ETHTOOL_A_CABLE_RESULT_CODE_CROSS_SHORT   = C.ETHTOOL_A_CABLE_RESULT_CODE_CROSS_SHORT
	ETHTOOL_A_CABLE_PAIR_A                    = C.ETHTOOL_A_CABLE_PAIR_A
	ETHTOOL_A_CABLE_PAIR_B                    = C.ETHTOOL_A_CABLE_PAIR_B
	ETHTOOL_A_CABLE_PAIR_C                    = C.ETHTOOL_A_CABLE_PAIR_C
	ETHTOOL_A_CABLE_PAIR_D                    = C.ETHTOOL_A_CABLE_PAIR_D
	ETHTOOL_A_CABLE_RESULT_UNSPEC             = C.ETHTOOL_A_CABLE_RESULT_UNSPEC
	ETHTOOL_A_CABLE_RESULT_PAIR               = C.ETHTOOL_A_CABLE_RESULT_PAIR
	ETHTOOL_A_CABLE_RESULT_CODE               = C.ETHTOOL_A_CABLE_RESULT_CODE
	ETHTOOL_A_CABLE_RESULT_MAX                = C.ETHTOOL_A_CABLE_RESULT_MAX
	ETHTOOL_A_CABLE_FAULT_LENGTH_UNSPEC       = C.ETHTOOL_A_CABLE_FAULT_LENGTH_UNSPEC
	ETHTOOL_A_CABLE_FAULT_LENGTH_PAIR         = C.ETHTOOL_A_CABLE_FAULT_LENGTH_PAIR
	ETHTOOL_A_CABLE_FAULT_LENGTH_CM           = C.ETHTOOL_A_CABLE_FAULT_LENGTH_CM
	ETHTOOL_A_CABLE_FAULT_LENGTH_MAX          = C.ETHTOOL_A_CABLE_FAULT_LENGTH_MAX
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_UNSPEC    = C.ETHTOOL_A_CABLE_TEST_NTF_STATUS_UNSPEC
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_STARTED   = C.ETHTOOL_A_CABLE_TEST_NTF_STATUS_STARTED
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_COMPLETED = C.ETHTOOL_A_CABLE_TEST_NTF_STATUS_COMPLETED
	ETHTOOL_A_CABLE_NEST_UNSPEC               = C.ETHTOOL_A_CABLE_NEST_UNSPEC
	ETHTOOL_A_CABLE_NEST_RESULT               = C.ETHTOOL_A_CABLE_NEST_RESULT
	ETHTOOL_A_CABLE_NEST_FAULT_LENGTH         = C.ETHTOOL_A_CABLE_NEST_FAULT_LENGTH
	ETHTOOL_A_CABLE_NEST_MAX                  = C.ETHTOOL_A_CABLE_NEST_MAX
	ETHTOOL_A_CABLE_TEST_NTF_UNSPEC           = C.ETHTOOL_A_CABLE_TEST_NTF_UNSPEC
	ETHTOOL_A_CABLE_TEST_NTF_HEADER           = C.ETHTOOL_A_CABLE_TEST_NTF_HEADER
	ETHTOOL_A_CABLE_TEST_NTF_STATUS           = C.ETHTOOL_A_CABLE_TEST_NTF_STATUS
	ETHTOOL_A_CABLE_TEST_NTF_NEST             = C.ETHTOOL_A_CABLE_TEST_NTF_NEST
	ETHTOOL_A_CABLE_TEST_NTF_MAX              = C.ETHTOOL_A_CABLE_TEST_NTF_MAX
	ETHTOOL_A_CABLE_TEST_TDR_CFG_UNSPEC       = C.ETHTOOL_A_CABLE_TEST_TDR_CFG_UNSPEC
	ETHTOOL_A_CABLE_TEST_TDR_CFG_FIRST        = C.ETHTOOL_A_CABLE_TEST_TDR_CFG_FIRST
	ETHTOOL_A_CABLE_TEST_TDR_CFG_LAST         = C.ETHTOOL_A_CABLE_TEST_TDR_CFG_LAST
	ETHTOOL_A_CABLE_TEST_TDR_CFG_STEP         = C.ETHTOOL_A_CABLE_TEST_TDR_CFG_STEP
	ETHTOOL_A_CABLE_TEST_TDR_CFG_PAIR         = C.ETHTOOL_A_CABLE_TEST_TDR_CFG_PAIR
	ETHTOOL_A_CABLE_TEST_TDR_CFG_MAX          = C.ETHTOOL_A_CABLE_TEST_TDR_CFG_MAX
	ETHTOOL_A_CABLE_TEST_TDR_UNSPEC           = C.ETHTOOL_A_CABLE_TEST_TDR_UNSPEC
	ETHTOOL_A_CABLE_TEST_TDR_HEADER           = C.ETHTOOL_A_CABLE_TEST_TDR_HEADER
	ETHTOOL_A_CABLE_TEST_TDR_CFG              = C.ETHTOOL_A_CABLE_TEST_TDR_CFG
	ETHTOOL_A_CABLE_TEST_TDR_MAX              = C.ETHTOOL_A_CABLE_TEST_TDR_MAX
	ETHTOOL_A_CABLE_AMPLITUDE_UNSPEC          = C.ETHTOOL_A_CABLE_AMPLITUDE_UNSPEC
	ETHTOOL_A_CABLE_AMPLITUDE_PAIR            = C.ETHTOOL_A_CABLE_AMPLITUDE_PAIR
	ETHTOOL_A_CABLE_AMPLITUDE_mV              = C.ETHTOOL_A_CABLE_AMPLITUDE_mV
	ETHTOOL_A_CABLE_AMPLITUDE_MAX             = C.ETHTOOL_A_CABLE_AMPLITUDE_MAX
	ETHTOOL_A_CABLE_PULSE_UNSPEC              = C.ETHTOOL_A_CABLE_PULSE_UNSPEC
	ETHTOOL_A_CABLE_PULSE_mV                  = C.ETHTOOL_A_CABLE_PULSE_mV
	ETHTOOL_A_CABLE_PULSE_MAX                 = C.ETHTOOL_A_CABLE_PULSE_MAX
	ETHTOOL_A_CABLE_STEP_UNSPEC               = C.ETHTOOL_A_CABLE_STEP_UNSPEC
	ETHTOOL_A_CABLE_STEP_FIRST_DISTANCE       = C.ETHTOOL_A_CABLE_STEP_FIRST_DISTANCE
	ETHTOOL_A_CABLE_STEP_LAST_DISTANCE        = C.ETHTOOL_A_CABLE_STEP_LAST_DISTANCE
	ETHTOOL_A_CABLE_STEP_STEP_DISTANCE        = C.ETHTOOL_A_CABLE_STEP_STEP_DISTANCE
	ETHTOOL_A_CABLE_STEP_MAX                  = C.ETHTOOL_A_CABLE_STEP_MAX
	ETHTOOL_A_CABLE_TDR_NEST_UNSPEC           = C.ETHTOOL_A_CABLE_TDR_NEST_UNSPEC
	ETHTOOL_A_CABLE_TDR_NEST_STEP             = C.ETHTOOL_A_CABLE_TDR_NEST_STEP
	ETHTOOL_A_CABLE_TDR_NEST_AMPLITUDE        = C.ETHTOOL_A_CABLE_TDR_NEST_AMPLITUDE
	ETHTOOL_A_CABLE_TDR_NEST_PULSE            = C.ETHTOOL_A_CABLE_TDR_NEST_PULSE
	ETHTOOL_A_CABLE_TDR_NEST_MAX              = C.ETHTOOL_A_CABLE_TDR_NEST_MAX
	ETHTOOL_A_CABLE_TEST_TDR_NTF_UNSPEC       = C.ETHTOOL_A_CABLE_TEST_TDR_NTF_UNSPEC
	ETHTOOL_A_CABLE_TEST_TDR_NTF_HEADER       = C.ETHTOOL_A_CABLE_TEST_TDR_NTF_HEADER
	ETHTOOL_A_CABLE_TEST_TDR_NTF_STATUS       = C.ETHTOOL_A_CABLE_TEST_TDR_NTF_STATUS
	ETHTOOL_A_CABLE_TEST_TDR_NTF_NEST         = C.ETHTOOL_A_CABLE_TEST_TDR_NTF_NEST
	ETHTOOL_A_CABLE_TEST_TDR_NTF_MAX          = C.ETHTOOL_A_CABLE_TEST_TDR_NTF_MAX
	ETHTOOL_UDP_TUNNEL_TYPE_VXLAN             = C.ETHTOOL_UDP_TUNNEL_TYPE_VXLAN
	ETHTOOL_UDP_TUNNEL_TYPE_GENEVE            = C.ETHTOOL_UDP_TUNNEL_TYPE_GENEVE
	ETHTOOL_UDP_TUNNEL_TYPE_VXLAN_GPE         = C.ETHTOOL_UDP_TUNNEL_TYPE_VXLAN_GPE
	ETHTOOL_A_TUNNEL_UDP_ENTRY_UNSPEC         = C.ETHTOOL_A_TUNNEL_UDP_ENTRY_UNSPEC
	ETHTOOL_A_TUNNEL_UDP_ENTRY_PORT           = C.ETHTOOL_A_TUNNEL_UDP_ENTRY_PORT
	ETHTOOL_A_TUNNEL_UDP_ENTRY_TYPE           = C.ETHTOOL_A_TUNNEL_UDP_ENTRY_TYPE
	ETHTOOL_A_TUNNEL_UDP_ENTRY_MAX            = C.ETHTOOL_A_TUNNEL_UDP_ENTRY_MAX
	ETHTOOL_A_TUNNEL_UDP_TABLE_UNSPEC         = C.ETHTOOL_A_TUNNEL_UDP_TABLE_UNSPEC
	ETHTOOL_A_TUNNEL_UDP_TABLE_SIZE           = C.ETHTOOL_A_TUNNEL_UDP_TABLE_SIZE
	ETHTOOL_A_TUNNEL_UDP_TABLE_TYPES          = C.ETHTOOL_A_TUNNEL_UDP_TABLE_TYPES
	ETHTOOL_A_TUNNEL_UDP_TABLE_ENTRY          = C.ETHTOOL_A_TUNNEL_UDP_TABLE_ENTRY
	ETHTOOL_A_TUNNEL_UDP_TABLE_MAX            = C.ETHTOOL_A_TUNNEL_UDP_TABLE_MAX
	ETHTOOL_A_TUNNEL_UDP_UNSPEC               = C.ETHTOOL_A_TUNNEL_UDP_UNSPEC
	ETHTOOL_A_TUNNEL_UDP_TABLE                = C.ETHTOOL_A_TUNNEL_UDP_TABLE
	ETHTOOL_A_TUNNEL_UDP_MAX                  = C.ETHTOOL_A_TUNNEL_UDP_MAX
	ETHTOOL_A_TUNNEL_INFO_UNSPEC              = C.ETHTOOL_A_TUNNEL_INFO_UNSPEC
	ETHTOOL_A_TUNNEL_INFO_HEADER              = C.ETHTOOL_A_TUNNEL_INFO_HEADER
	ETHTOOL_A_TUNNEL_INFO_UDP_PORTS           = C.ETHTOOL_A_TUNNEL_INFO_UDP_PORTS
	ETHTOOL_A_TUNNEL_INFO_MAX                 = C.ETHTOOL_A_TUNNEL_INFO_MAX
)

const SPEED_UNKNOWN = C.SPEED_UNKNOWN

type EthtoolDrvinfo C.struct_ethtool_drvinfo

type (
	HIDRawReportDescriptor C.struct_hidraw_report_descriptor
	HIDRawDevInfo          C.struct_hidraw_devinfo
)

// close_range
const (
	CLOSE_RANGE_UNSHARE = C.CLOSE_RANGE_UNSHARE
	CLOSE_RANGE_CLOEXEC = C.CLOSE_RANGE_CLOEXEC
)

// Netlink extended acknowledgement TLVs.

const (
	NLMSGERR_ATTR_MSG    = C.NLMSGERR_ATTR_MSG
	NLMSGERR_ATTR_OFFS   = C.NLMSGERR_ATTR_OFFS
	NLMSGERR_ATTR_COOKIE = C.NLMSGERR_ATTR_COOKIE
)

// MTD

type (
	EraseInfo     C.struct_erase_info_user
	EraseInfo64   C.struct_erase_info_user64
	MtdOobBuf     C.struct_mtd_oob_buf
	MtdOobBuf64   C.struct_mtd_oob_buf64
	MtdWriteReq   C.struct_mtd_write_req
	MtdInfo       C.struct_mtd_info_user
	RegionInfo    C.struct_region_info_user
	OtpInfo       C.struct_otp_info
	NandOobinfo   C.struct_nand_oobinfo
	NandOobfree   C.struct_nand_oobfree
	NandEcclayout C.struct_nand_ecclayout_user
	MtdEccStats   C.struct_mtd_ecc_stats
)

const (
	MTD_OPS_PLACE_OOB = C.MTD_OPS_PLACE_OOB
	MTD_OPS_AUTO_OOB  = C.MTD_OPS_AUTO_OOB
	MTD_OPS_RAW       = C.MTD_OPS_RAW
)

const (
	MTD_FILE_MODE_NORMAL      = C.MTD_FILE_MODE_NORMAL
	MTD_FILE_MODE_OTP_FACTORY = C.MTD_FILE_MODE_OTP_FACTORY
	MTD_FILE_MODE_OTP_USER    = C.MTD_FILE_MODE_OTP_USER
	MTD_FILE_MODE_RAW         = C.MTD_FILE_MODE_RAW
)

// NFC Subsystem enums.

const (
	NFC_CMD_UNSPEC                    = C.NFC_CMD_UNSPEC
	NFC_CMD_GET_DEVICE                = C.NFC_CMD_GET_DEVICE
	NFC_CMD_DEV_UP                    = C.NFC_CMD_DEV_UP
	NFC_CMD_DEV_DOWN                  = C.NFC_CMD_DEV_DOWN
	NFC_CMD_DEP_LINK_UP               = C.NFC_CMD_DEP_LINK_UP
	NFC_CMD_DEP_LINK_DOWN             = C.NFC_CMD_DEP_LINK_DOWN
	NFC_CMD_START_POLL                = C.NFC_CMD_START_POLL
	NFC_CMD_STOP_POLL                 = C.NFC_CMD_STOP_POLL
	NFC_CMD_GET_TARGET                = C.NFC_CMD_GET_TARGET
	NFC_EVENT_TARGETS_FOUND           = C.NFC_EVENT_TARGETS_FOUND
	NFC_EVENT_DEVICE_ADDED            = C.NFC_EVENT_DEVICE_ADDED
	NFC_EVENT_DEVICE_REMOVED          = C.NFC_EVENT_DEVICE_REMOVED
	NFC_EVENT_TARGET_LOST             = C.NFC_EVENT_TARGET_LOST
	NFC_EVENT_TM_ACTIVATED            = C.NFC_EVENT_TM_ACTIVATED
	NFC_EVENT_TM_DEACTIVATED          = C.NFC_EVENT_TM_DEACTIVATED
	NFC_CMD_LLC_GET_PARAMS            = C.NFC_CMD_LLC_GET_PARAMS
	NFC_CMD_LLC_SET_PARAMS            = C.NFC_CMD_LLC_SET_PARAMS
	NFC_CMD_ENABLE_SE                 = C.NFC_CMD_ENABLE_SE
	NFC_CMD_DISABLE_SE                = C.NFC_CMD_DISABLE_SE
	NFC_CMD_LLC_SDREQ                 = C.NFC_CMD_LLC_SDREQ
	NFC_EVENT_LLC_SDRES               = C.NFC_EVENT_LLC_SDRES
	NFC_CMD_FW_DOWNLOAD               = C.NFC_CMD_FW_DOWNLOAD
	NFC_EVENT_SE_ADDED                = C.NFC_EVENT_SE_ADDED
	NFC_EVENT_SE_REMOVED              = C.NFC_EVENT_SE_REMOVED
	NFC_EVENT_SE_CONNECTIVITY         = C.NFC_EVENT_SE_CONNECTIVITY
	NFC_EVENT_SE_TRANSACTION          = C.NFC_EVENT_SE_TRANSACTION
	NFC_CMD_GET_SE                    = C.NFC_CMD_GET_SE
	NFC_CMD_SE_IO                     = C.NFC_CMD_SE_IO
	NFC_CMD_ACTIVATE_TARGET           = C.NFC_CMD_ACTIVATE_TARGET
	NFC_CMD_VENDOR                    = C.NFC_CMD_VENDOR
	NFC_CMD_DEACTIVATE_TARGET         = C.NFC_CMD_DEACTIVATE_TARGET
	NFC_ATTR_UNSPEC                   = C.NFC_ATTR_UNSPEC
	NFC_ATTR_DEVICE_INDEX             = C.NFC_ATTR_DEVICE_INDEX
	NFC_ATTR_DEVICE_NAME              = C.NFC_ATTR_DEVICE_NAME
	NFC_ATTR_PROTOCOLS                = C.NFC_ATTR_PROTOCOLS
	NFC_ATTR_TARGET_INDEX             = C.NFC_ATTR_TARGET_INDEX
	NFC_ATTR_TARGET_SENS_RES          = C.NFC_ATTR_TARGET_SENS_RES
	NFC_ATTR_TARGET_SEL_RES           = C.NFC_ATTR_TARGET_SEL_RES
	NFC_ATTR_TARGET_NFCID1            = C.NFC_ATTR_TARGET_NFCID1
	NFC_ATTR_TARGET_SENSB_RES         = C.NFC_ATTR_TARGET_SENSB_RES
	NFC_ATTR_TARGET_SENSF_RES         = C.NFC_ATTR_TARGET_SENSF_RES
	NFC_ATTR_COMM_MODE                = C.NFC_ATTR_COMM_MODE
	NFC_ATTR_RF_MODE                  = C.NFC_ATTR_RF_MODE
	NFC_ATTR_DEVICE_POWERED           = C.NFC_ATTR_DEVICE_POWERED
	NFC_ATTR_IM_PROTOCOLS             = C.NFC_ATTR_IM_PROTOCOLS
	NFC_ATTR_TM_PROTOCOLS             = C.NFC_ATTR_TM_PROTOCOLS
	NFC_ATTR_LLC_PARAM_LTO            = C.NFC_ATTR_LLC_PARAM_LTO
	NFC_ATTR_LLC_PARAM_RW             = C.NFC_ATTR_LLC_PARAM_RW
	NFC_ATTR_LLC_PARAM_MIUX           = C.NFC_ATTR_LLC_PARAM_MIUX
	NFC_ATTR_SE                       = C.NFC_ATTR_SE
	NFC_ATTR_LLC_SDP                  = C.NFC_ATTR_LLC_SDP
	NFC_ATTR_FIRMWARE_NAME            = C.NFC_ATTR_FIRMWARE_NAME
	NFC_ATTR_SE_INDEX                 = C.NFC_ATTR_SE_INDEX
	NFC_ATTR_SE_TYPE                  = C.NFC_ATTR_SE_TYPE
	NFC_ATTR_SE_AID                   = C.NFC_ATTR_SE_AID
	NFC_ATTR_FIRMWARE_DOWNLOAD_STATUS = C.NFC_ATTR_FIRMWARE_DOWNLOAD_STATUS
	NFC_ATTR_SE_APDU                  = C.NFC_ATTR_SE_APDU
	NFC_ATTR_TARGET_ISO15693_DSFID    = C.NFC_ATTR_TARGET_ISO15693_DSFID
	NFC_ATTR_TARGET_ISO15693_UID      = C.NFC_ATTR_TARGET_ISO15693_UID
	NFC_ATTR_SE_PARAMS                = C.NFC_ATTR_SE_PARAMS
	NFC_ATTR_VENDOR_ID                = C.NFC_ATTR_VENDOR_ID
	NFC_ATTR_VENDOR_SUBCMD            = C.NFC_ATTR_VENDOR_SUBCMD
	NFC_ATTR_VENDOR_DATA              = C.NFC_ATTR_VENDOR_DATA
	NFC_SDP_ATTR_UNSPEC               = C.NFC_SDP_ATTR_UNSPEC
	NFC_SDP_ATTR_URI                  = C.NFC_SDP_ATTR_URI
	NFC_SDP_ATTR_SAP                  = C.NFC_SDP_ATTR_SAP
)

// Landlock

type LandlockRulesetAttr C.struct_landlock_ruleset_attr

type LandlockPathBeneathAttr C.struct_landlock_path_beneath_attr

const (
	LANDLOCK_RULE_PATH_BENEATH = C.LANDLOCK_RULE_PATH_BENEATH
)

// pidfd flags.

const (
	PIDFD_NONBLOCK = C.O_NONBLOCK
)

// shm

type SysvIpcPerm C.struct_ipc64_perm
type SysvShmDesc C.struct_shmid64_ds

const (
	IPC_CREAT   = C.IPC_CREAT
	IPC_EXCL    = C.IPC_EXCL
	IPC_NOWAIT  = C.IPC_NOWAIT
	IPC_PRIVATE = C.IPC_PRIVATE

	ipc_64 = C.IPC_64
)

const (
	IPC_RMID = C.IPC_RMID
	IPC_SET  = C.IPC_SET
	IPC_STAT = C.IPC_STAT
)

const (
	SHM_RDONLY = C.SHM_RDONLY
	SHM_RND    = C.SHM_RND
)

// mount_setattr

type MountAttr C.struct_mount_attr

// WireGuard generic netlink interface

// Generated by:
// perl -nlE '/^\s*(WG\w+)/ && say "$1 = C.$1"' /usr/include/linux/wireguard.h
const (
	WG_CMD_GET_DEVICE                      = C.WG_CMD_GET_DEVICE
	WG_CMD_SET_DEVICE                      = C.WG_CMD_SET_DEVICE
	WGDEVICE_F_REPLACE_PEERS               = C.WGDEVICE_F_REPLACE_PEERS
	WGDEVICE_A_UNSPEC                      = C.WGDEVICE_A_UNSPEC
	WGDEVICE_A_IFINDEX                     = C.WGDEVICE_A_IFINDEX
	WGDEVICE_A_IFNAME                      = C.WGDEVICE_A_IFNAME
	WGDEVICE_A_PRIVATE_KEY                 = C.WGDEVICE_A_PRIVATE_KEY
	WGDEVICE_A_PUBLIC_KEY                  = C.WGDEVICE_A_PUBLIC_KEY
	WGDEVICE_A_FLAGS                       = C.WGDEVICE_A_FLAGS
	WGDEVICE_A_LISTEN_PORT                 = C.WGDEVICE_A_LISTEN_PORT
	WGDEVICE_A_FWMARK                      = C.WGDEVICE_A_FWMARK
	WGDEVICE_A_PEERS                       = C.WGDEVICE_A_PEERS
	WGPEER_F_REMOVE_ME                     = C.WGPEER_F_REMOVE_ME
	WGPEER_F_REPLACE_ALLOWEDIPS            = C.WGPEER_F_REPLACE_ALLOWEDIPS
	WGPEER_F_UPDATE_ONLY                   = C.WGPEER_F_UPDATE_ONLY
	WGPEER_A_UNSPEC                        = C.WGPEER_A_UNSPEC
	WGPEER_A_PUBLIC_KEY                    = C.WGPEER_A_PUBLIC_KEY
	WGPEER_A_PRESHARED_KEY                 = C.WGPEER_A_PRESHARED_KEY
	WGPEER_A_FLAGS                         = C.WGPEER_A_FLAGS
	WGPEER_A_ENDPOINT                      = C.WGPEER_A_ENDPOINT
	WGPEER_A_PERSISTENT_KEEPALIVE_INTERVAL = C.WGPEER_A_PERSISTENT_KEEPALIVE_INTERVAL
	WGPEER_A_LAST_HANDSHAKE_TIME           = C.WGPEER_A_LAST_HANDSHAKE_TIME
	WGPEER_A_RX_BYTES                      = C.WGPEER_A_RX_BYTES
	WGPEER_A_TX_BYTES                      = C.WGPEER_A_TX_BYTES
	WGPEER_A_ALLOWEDIPS                    = C.WGPEER_A_ALLOWEDIPS
	WGPEER_A_PROTOCOL_VERSION              = C.WGPEER_A_PROTOCOL_VERSION
	WGALLOWEDIP_A_UNSPEC                   = C.WGALLOWEDIP_A_UNSPEC
	WGALLOWEDIP_A_FAMILY                   = C.WGALLOWEDIP_A_FAMILY
	WGALLOWEDIP_A_IPADDR                   = C.WGALLOWEDIP_A_IPADDR
	WGALLOWEDIP_A_CIDR_MASK                = C.WGALLOWEDIP_A_CIDR_MASK
)

// netlink attribute types and policies

// Generated by:
// perl -nlE '/^\s*(NL_ATTR\w+)/ && say "$1 = C.$1"' /usr/include/linux/netlink.h
// perl -nlE '/^\s*(NL_POLICY\w+)/ && say "$1 = C.$1"' /usr/include/linux/netlink.h
const (
	NL_ATTR_TYPE_INVALID      = C.NL_ATTR_TYPE_INVALID
	NL_ATTR_TYPE_FLAG         = C.NL_ATTR_TYPE_FLAG
	NL_ATTR_TYPE_U8           = C.NL_ATTR_TYPE_U8
	NL_ATTR_TYPE_U16          = C.NL_ATTR_TYPE_U16
	NL_ATTR_TYPE_U32          = C.NL_ATTR_TYPE_U32
	NL_ATTR_TYPE_U64          = C.NL_ATTR_TYPE_U64
	NL_ATTR_TYPE_S8           = C.NL_ATTR_TYPE_S8
	NL_ATTR_TYPE_S16          = C.NL_ATTR_TYPE_S16
	NL_ATTR_TYPE_S32          = C.NL_ATTR_TYPE_S32
	NL_ATTR_TYPE_S64          = C.NL_ATTR_TYPE_S64
	NL_ATTR_TYPE_BINARY       = C.NL_ATTR_TYPE_BINARY
	NL_ATTR_TYPE_STRING       = C.NL_ATTR_TYPE_STRING
	NL_ATTR_TYPE_NUL_STRING   = C.NL_ATTR_TYPE_NUL_STRING
	NL_ATTR_TYPE_NESTED       = C.NL_ATTR_TYPE_NESTED
	NL_ATTR_TYPE_NESTED_ARRAY = C.NL_ATTR_TYPE_NESTED_ARRAY
	NL_ATTR_TYPE_BITFIELD32   = C.NL_ATTR_TYPE_BITFIELD32

	NL_POLICY_TYPE_ATTR_UNSPEC          = C.NL_POLICY_TYPE_ATTR_UNSPEC
	NL_POLICY_TYPE_ATTR_TYPE            = C.NL_POLICY_TYPE_ATTR_TYPE
	NL_POLICY_TYPE_ATTR_MIN_VALUE_S     = C.NL_POLICY_TYPE_ATTR_MIN_VALUE_S
	NL_POLICY_TYPE_ATTR_MAX_VALUE_S     = C.NL_POLICY_TYPE_ATTR_MAX_VALUE_S
	NL_POLICY_TYPE_ATTR_MIN_VALUE_U     = C.NL_POLICY_TYPE_ATTR_MIN_VALUE_U
	NL_POLICY_TYPE_ATTR_MAX_VALUE_U     = C.NL_POLICY_TYPE_ATTR_MAX_VALUE_U
	NL_POLICY_TYPE_ATTR_MIN_LENGTH      = C.NL_POLICY_TYPE_ATTR_MIN_LENGTH
	NL_POLICY_TYPE_ATTR_MAX_LENGTH      = C.NL_POLICY_TYPE_ATTR_MAX_LENGTH
	NL_POLICY_TYPE_ATTR_POLICY_IDX      = C.NL_POLICY_TYPE_ATTR_POLICY_IDX
	NL_POLICY_TYPE_ATTR_POLICY_MAXTYPE  = C.NL_POLICY_TYPE_ATTR_POLICY_MAXTYPE
	NL_POLICY_TYPE_ATTR_BITFIELD32_MASK = C.NL_POLICY_TYPE_ATTR_BITFIELD32_MASK
	NL_POLICY_TYPE_ATTR_PAD             = C.NL_POLICY_TYPE_ATTR_PAD
	NL_POLICY_TYPE_ATTR_MASK            = C.NL_POLICY_TYPE_ATTR_MASK
	NL_POLICY_TYPE_ATTR_MAX             = C.NL_POLICY_TYPE_ATTR_MAX
)

// CAN netlink types

type CANBitTiming C.struct_can_bittiming

type CANBitTimingConst C.struct_my_can_bittiming_const

type CANClock C.struct_can_clock

type CANBusErrorCounters C.struct_can_berr_counter

type CANCtrlMode C.struct_can_ctrlmode

type CANDeviceStats C.struct_can_device_stats

// Generated by:
// perl -nlE '/^\s*(CAN_STATE\w+)/ && say "$1 = C.$1"' /usr/include/linux/can/netlink.h
const (
	CAN_STATE_ERROR_ACTIVE  = C.CAN_STATE_ERROR_ACTIVE
	CAN_STATE_ERROR_WARNING = C.CAN_STATE_ERROR_WARNING
	CAN_STATE_ERROR_PASSIVE = C.CAN_STATE_ERROR_PASSIVE
	CAN_STATE_BUS_OFF       = C.CAN_STATE_BUS_OFF
	CAN_STATE_STOPPED       = C.CAN_STATE_STOPPED
	CAN_STATE_SLEEPING      = C.CAN_STATE_SLEEPING
	CAN_STATE_MAX           = C.CAN_STATE_MAX
)

// Generated by:
// perl -nlE '/^\s*(IFLA_CAN\w+)/ && say "$1 = C.$1"' /usr/include/linux/can/netlink.h
const (
	IFLA_CAN_UNSPEC               = C.IFLA_CAN_UNSPEC
	IFLA_CAN_BITTIMING            = C.IFLA_CAN_BITTIMING
	IFLA_CAN_BITTIMING_CONST      = C.IFLA_CAN_BITTIMING_CONST
	IFLA_CAN_CLOCK                = C.IFLA_CAN_CLOCK
	IFLA_CAN_STATE                = C.IFLA_CAN_STATE
	IFLA_CAN_CTRLMODE             = C.IFLA_CAN_CTRLMODE
	IFLA_CAN_RESTART_MS           = C.IFLA_CAN_RESTART_MS
	IFLA_CAN_RESTART              = C.IFLA_CAN_RESTART
	IFLA_CAN_BERR_COUNTER         = C.IFLA_CAN_BERR_COUNTER
	IFLA_CAN_DATA_BITTIMING       = C.IFLA_CAN_DATA_BITTIMING
	IFLA_CAN_DATA_BITTIMING_CONST = C.IFLA_CAN_DATA_BITTIMING_CONST
	IFLA_CAN_TERMINATION          = C.IFLA_CAN_TERMINATION
	IFLA_CAN_TERMINATION_CONST    = C.IFLA_CAN_TERMINATION_CONST
	IFLA_CAN_BITRATE_CONST        = C.IFLA_CAN_BITRATE_CONST
	IFLA_CAN_DATA_BITRATE_CONST   = C.IFLA_CAN_DATA_BITRATE_CONST
	IFLA_CAN_BITRATE_MAX          = C.IFLA_CAN_BITRATE_MAX
)

// Kernel connection multiplexor

type KCMAttach C.struct_kcm_attach

type KCMUnattach C.struct_kcm_unattach

type KCMClone C.struct_kcm_clone

// nl80211 generic netlink

// Generated by the following steps:
//
// perl -nlE '/^#define (NL80211_\w+)/ && say "$1 = C.$1"' /usr/include/linux/nl80211.h > define.txt
// perl -nlE '/^\s*(NL80211_\w+)/ && say "$1 = C.$1"' /usr/include/linux/nl80211.h > enum.txt
// cat define.txt enum.txt | sort --unique
//
// nl80211 has some duplicated values between enums and C preprocessor macros,
// so this list must be sorted and made unique.
const (
	NL80211_AC_BE                                           = C.NL80211_AC_BE
	NL80211_AC_BK                                           = C.NL80211_AC_BK
	NL80211_ACL_POLICY_ACCEPT_UNLESS_LISTED                 = C.NL80211_ACL_POLICY_ACCEPT_UNLESS_LISTED
	NL80211_ACL_POLICY_DENY_UNLESS_LISTED                   = C.NL80211_ACL_POLICY_DENY_UNLESS_LISTED
	NL80211_AC_VI                                           = C.NL80211_AC_VI
	NL80211_AC_VO                                           = C.NL80211_AC_VO
	NL80211_ATTR_4ADDR                                      = C.NL80211_ATTR_4ADDR
	NL80211_ATTR_ACK                                        = C.NL80211_ATTR_ACK
	NL80211_ATTR_ACK_SIGNAL                                 = C.NL80211_ATTR_ACK_SIGNAL
	NL80211_ATTR_ACL_POLICY                                 = C.NL80211_ATTR_ACL_POLICY
	NL80211_ATTR_ADMITTED_TIME                              = C.NL80211_ATTR_ADMITTED_TIME
	NL80211_ATTR_AIRTIME_WEIGHT                             = C.NL80211_ATTR_AIRTIME_WEIGHT
	NL80211_ATTR_AKM_SUITES                                 = C.NL80211_ATTR_AKM_SUITES
	NL80211_ATTR_AP_ISOLATE                                 = C.NL80211_ATTR_AP_ISOLATE
	NL80211_ATTR_AUTH_DATA                                  = C.NL80211_ATTR_AUTH_DATA
	NL80211_ATTR_AUTH_TYPE                                  = C.NL80211_ATTR_AUTH_TYPE
	NL80211_ATTR_BANDS                                      = C.NL80211_ATTR_BANDS
	NL80211_ATTR_BEACON_HEAD                                = C.NL80211_ATTR_BEACON_HEAD
	NL80211_ATTR_BEACON_INTERVAL                            = C.NL80211_ATTR_BEACON_INTERVAL
	NL80211_ATTR_BEACON_TAIL                                = C.NL80211_ATTR_BEACON_TAIL
	NL80211_ATTR_BG_SCAN_PERIOD                             = C.NL80211_ATTR_BG_SCAN_PERIOD
	NL80211_ATTR_BSS_BASIC_RATES                            = C.NL80211_ATTR_BSS_BASIC_RATES
	NL80211_ATTR_BSS                                        = C.NL80211_ATTR_BSS
	NL80211_ATTR_BSS_CTS_PROT                               = C.NL80211_ATTR_BSS_CTS_PROT
	NL80211_ATTR_BSS_HT_OPMODE                              = C.NL80211_ATTR_BSS_HT_OPMODE
	NL80211_ATTR_BSSID                                      = C.NL80211_ATTR_BSSID
	NL80211_ATTR_BSS_SELECT                                 = C.NL80211_ATTR_BSS_SELECT
	NL80211_ATTR_BSS_SHORT_PREAMBLE                         = C.NL80211_ATTR_BSS_SHORT_PREAMBLE
	NL80211_ATTR_BSS_SHORT_SLOT_TIME                        = C.NL80211_ATTR_BSS_SHORT_SLOT_TIME
	NL80211_ATTR_CENTER_FREQ1                               = C.NL80211_ATTR_CENTER_FREQ1
	NL80211_ATTR_CENTER_FREQ1_OFFSET                        = C.NL80211_ATTR_CENTER_FREQ1_OFFSET
	NL80211_ATTR_CENTER_FREQ2                               = C.NL80211_ATTR_CENTER_FREQ2
	NL80211_ATTR_CHANNEL_WIDTH                              = C.NL80211_ATTR_CHANNEL_WIDTH
	NL80211_ATTR_CH_SWITCH_BLOCK_TX                         = C.NL80211_ATTR_CH_SWITCH_BLOCK_TX
	NL80211_ATTR_CH_SWITCH_COUNT                            = C.NL80211_ATTR_CH_SWITCH_COUNT
	NL80211_ATTR_CIPHER_SUITE_GROUP                         = C.NL80211_ATTR_CIPHER_SUITE_GROUP
	NL80211_ATTR_CIPHER_SUITES                              = C.NL80211_ATTR_CIPHER_SUITES
	NL80211_ATTR_CIPHER_SUITES_PAIRWISE                     = C.NL80211_ATTR_CIPHER_SUITES_PAIRWISE
	NL80211_ATTR_CNTDWN_OFFS_BEACON                         = C.NL80211_ATTR_CNTDWN_OFFS_BEACON
	NL80211_ATTR_CNTDWN_OFFS_PRESP                          = C.NL80211_ATTR_CNTDWN_OFFS_PRESP
	NL80211_ATTR_COALESCE_RULE                              = C.NL80211_ATTR_COALESCE_RULE
	NL80211_ATTR_COALESCE_RULE_CONDITION                    = C.NL80211_ATTR_COALESCE_RULE_CONDITION
	NL80211_ATTR_COALESCE_RULE_DELAY                        = C.NL80211_ATTR_COALESCE_RULE_DELAY
	NL80211_ATTR_COALESCE_RULE_MAX                          = C.NL80211_ATTR_COALESCE_RULE_MAX
	NL80211_ATTR_COALESCE_RULE_PKT_PATTERN                  = C.NL80211_ATTR_COALESCE_RULE_PKT_PATTERN
	NL80211_ATTR_CONN_FAILED_REASON                         = C.NL80211_ATTR_CONN_FAILED_REASON
	NL80211_ATTR_CONTROL_PORT                               = C.NL80211_ATTR_CONTROL_PORT
	NL80211_ATTR_CONTROL_PORT_ETHERTYPE                     = C.NL80211_ATTR_CONTROL_PORT_ETHERTYPE
	NL80211_ATTR_CONTROL_PORT_NO_ENCRYPT                    = C.NL80211_ATTR_CONTROL_PORT_NO_ENCRYPT
	NL80211_ATTR_CONTROL_PORT_NO_PREAUTH                    = C.NL80211_ATTR_CONTROL_PORT_NO_PREAUTH
	NL80211_ATTR_CONTROL_PORT_OVER_NL80211                  = C.NL80211_ATTR_CONTROL_PORT_OVER_NL80211
	NL80211_ATTR_COOKIE                                     = C.NL80211_ATTR_COOKIE
	NL80211_ATTR_CQM_BEACON_LOSS_EVENT                      = C.NL80211_ATTR_CQM_BEACON_LOSS_EVENT
	NL80211_ATTR_CQM                                        = C.NL80211_ATTR_CQM
	NL80211_ATTR_CQM_MAX                                    = C.NL80211_ATTR_CQM_MAX
	NL80211_ATTR_CQM_PKT_LOSS_EVENT                         = C.NL80211_ATTR_CQM_PKT_LOSS_EVENT
	NL80211_ATTR_CQM_RSSI_HYST                              = C.NL80211_ATTR_CQM_RSSI_HYST
	NL80211_ATTR_CQM_RSSI_LEVEL                             = C.NL80211_ATTR_CQM_RSSI_LEVEL
	NL80211_ATTR_CQM_RSSI_THOLD                             = C.NL80211_ATTR_CQM_RSSI_THOLD
	NL80211_ATTR_CQM_RSSI_THRESHOLD_EVENT                   = C.NL80211_ATTR_CQM_RSSI_THRESHOLD_EVENT
	NL80211_ATTR_CQM_TXE_INTVL                              = C.NL80211_ATTR_CQM_TXE_INTVL
	NL80211_ATTR_CQM_TXE_PKTS                               = C.NL80211_ATTR_CQM_TXE_PKTS
	NL80211_ATTR_CQM_TXE_RATE                               = C.NL80211_ATTR_CQM_TXE_RATE
	NL80211_ATTR_CRIT_PROT_ID                               = C.NL80211_ATTR_CRIT_PROT_ID
	NL80211_ATTR_CSA_C_OFF_BEACON                           = C.NL80211_ATTR_CSA_C_OFF_BEACON
	NL80211_ATTR_CSA_C_OFF_PRESP                            = C.NL80211_ATTR_CSA_C_OFF_PRESP
	NL80211_ATTR_CSA_C_OFFSETS_TX                           = C.NL80211_ATTR_CSA_C_OFFSETS_TX
	NL80211_ATTR_CSA_IES                                    = C.NL80211_ATTR_CSA_IES
	NL80211_ATTR_DEVICE_AP_SME                              = C.NL80211_ATTR_DEVICE_AP_SME
	NL80211_ATTR_DFS_CAC_TIME                               = C.NL80211_ATTR_DFS_CAC_TIME
	NL80211_ATTR_DFS_REGION                                 = C.NL80211_ATTR_DFS_REGION
	NL80211_ATTR_DISABLE_HE                                 = C.NL80211_ATTR_DISABLE_HE
	NL80211_ATTR_DISABLE_HT                                 = C.NL80211_ATTR_DISABLE_HT
	NL80211_ATTR_DISABLE_VHT                                = C.NL80211_ATTR_DISABLE_VHT
	NL80211_ATTR_DISCONNECTED_BY_AP                         = C.NL80211_ATTR_DISCONNECTED_BY_AP
	NL80211_ATTR_DONT_WAIT_FOR_ACK                          = C.NL80211_ATTR_DONT_WAIT_FOR_ACK
	NL80211_ATTR_DTIM_PERIOD                                = C.NL80211_ATTR_DTIM_PERIOD
	NL80211_ATTR_DURATION                                   = C.NL80211_ATTR_DURATION
	NL80211_ATTR_EXT_CAPA                                   = C.NL80211_ATTR_EXT_CAPA
	NL80211_ATTR_EXT_CAPA_MASK                              = C.NL80211_ATTR_EXT_CAPA_MASK
	NL80211_ATTR_EXTERNAL_AUTH_ACTION                       = C.NL80211_ATTR_EXTERNAL_AUTH_ACTION
	NL80211_ATTR_EXTERNAL_AUTH_SUPPORT                      = C.NL80211_ATTR_EXTERNAL_AUTH_SUPPORT
	NL80211_ATTR_EXT_FEATURES                               = C.NL80211_ATTR_EXT_FEATURES
	NL80211_ATTR_FEATURE_FLAGS                              = C.NL80211_ATTR_FEATURE_FLAGS
	NL80211_ATTR_FILS_CACHE_ID                              = C.NL80211_ATTR_FILS_CACHE_ID
	NL80211_ATTR_FILS_DISCOVERY                             = C.NL80211_ATTR_FILS_DISCOVERY
	NL80211_ATTR_FILS_ERP_NEXT_SEQ_NUM                      = C.NL80211_ATTR_FILS_ERP_NEXT_SEQ_NUM
	NL80211_ATTR_FILS_ERP_REALM                             = C.NL80211_ATTR_FILS_ERP_REALM
	NL80211_ATTR_FILS_ERP_RRK                               = C.NL80211_ATTR_FILS_ERP_RRK
	NL80211_ATTR_FILS_ERP_USERNAME                          = C.NL80211_ATTR_FILS_ERP_USERNAME
	NL80211_ATTR_FILS_KEK                                   = C.NL80211_ATTR_FILS_KEK
	NL80211_ATTR_FILS_NONCES                                = C.NL80211_ATTR_FILS_NONCES
	NL80211_ATTR_FRAME                                      = C.NL80211_ATTR_FRAME
	NL80211_ATTR_FRAME_MATCH                                = C.NL80211_ATTR_FRAME_MATCH
	NL80211_ATTR_FRAME_TYPE                                 = C.NL80211_ATTR_FRAME_TYPE
	NL80211_ATTR_FREQ_AFTER                                 = C.NL80211_ATTR_FREQ_AFTER
	NL80211_ATTR_FREQ_BEFORE                                = C.NL80211_ATTR_FREQ_BEFORE
	NL80211_ATTR_FREQ_FIXED                                 = C.NL80211_ATTR_FREQ_FIXED
	NL80211_ATTR_FREQ_RANGE_END                             = C.NL80211_ATTR_FREQ_RANGE_END
	NL80211_ATTR_FREQ_RANGE_MAX_BW                          = C.NL80211_ATTR_FREQ_RANGE_MAX_BW
	NL80211_ATTR_FREQ_RANGE_START                           = C.NL80211_ATTR_FREQ_RANGE_START
	NL80211_ATTR_FTM_RESPONDER                              = C.NL80211_ATTR_FTM_RESPONDER
	NL80211_ATTR_FTM_RESPONDER_STATS                        = C.NL80211_ATTR_FTM_RESPONDER_STATS
	NL80211_ATTR_GENERATION                                 = C.NL80211_ATTR_GENERATION
	NL80211_ATTR_HANDLE_DFS                                 = C.NL80211_ATTR_HANDLE_DFS
	NL80211_ATTR_HE_6GHZ_CAPABILITY                         = C.NL80211_ATTR_HE_6GHZ_CAPABILITY
	NL80211_ATTR_HE_BSS_COLOR                               = C.NL80211_ATTR_HE_BSS_COLOR
	NL80211_ATTR_HE_CAPABILITY                              = C.NL80211_ATTR_HE_CAPABILITY
	NL80211_ATTR_HE_OBSS_PD                                 = C.NL80211_ATTR_HE_OBSS_PD
	NL80211_ATTR_HIDDEN_SSID                                = C.NL80211_ATTR_HIDDEN_SSID
	NL80211_ATTR_HT_CAPABILITY                              = C.NL80211_ATTR_HT_CAPABILITY
	NL80211_ATTR_HT_CAPABILITY_MASK                         = C.NL80211_ATTR_HT_CAPABILITY_MASK
	NL80211_ATTR_IE_ASSOC_RESP                              = C.NL80211_ATTR_IE_ASSOC_RESP
	NL80211_ATTR_IE                                         = C.NL80211_ATTR_IE
	NL80211_ATTR_IE_PROBE_RESP                              = C.NL80211_ATTR_IE_PROBE_RESP
	NL80211_ATTR_IE_RIC                                     = C.NL80211_ATTR_IE_RIC
	NL80211_ATTR_IFACE_SOCKET_OWNER                         = C.NL80211_ATTR_IFACE_SOCKET_OWNER
	NL80211_ATTR_IFINDEX                                    = C.NL80211_ATTR_IFINDEX
	NL80211_ATTR_IFNAME                                     = C.NL80211_ATTR_IFNAME
	NL80211_ATTR_IFTYPE_AKM_SUITES                          = C.NL80211_ATTR_IFTYPE_AKM_SUITES
	NL80211_ATTR_IFTYPE                                     = C.NL80211_ATTR_IFTYPE
	NL80211_ATTR_IFTYPE_EXT_CAPA                            = C.NL80211_ATTR_IFTYPE_EXT_CAPA
	NL80211_ATTR_INACTIVITY_TIMEOUT                         = C.NL80211_ATTR_INACTIVITY_TIMEOUT
	NL80211_ATTR_INTERFACE_COMBINATIONS                     = C.NL80211_ATTR_INTERFACE_COMBINATIONS
	NL80211_ATTR_KEY_CIPHER                                 = C.NL80211_ATTR_KEY_CIPHER
	NL80211_ATTR_KEY                                        = C.NL80211_ATTR_KEY
	NL80211_ATTR_KEY_DATA                                   = C.NL80211_ATTR_KEY_DATA
	NL80211_ATTR_KEY_DEFAULT                                = C.NL80211_ATTR_KEY_DEFAULT
	NL80211_ATTR_KEY_DEFAULT_MGMT                           = C.NL80211_ATTR_KEY_DEFAULT_MGMT
	NL80211_ATTR_KEY_DEFAULT_TYPES                          = C.NL80211_ATTR_KEY_DEFAULT_TYPES
	NL80211_ATTR_KEY_IDX                                    = C.NL80211_ATTR_KEY_IDX
	NL80211_ATTR_KEYS                                       = C.NL80211_ATTR_KEYS
	NL80211_ATTR_KEY_SEQ                                    = C.NL80211_ATTR_KEY_SEQ
	NL80211_ATTR_KEY_TYPE                                   = C.NL80211_ATTR_KEY_TYPE
	NL80211_ATTR_LOCAL_MESH_POWER_MODE                      = C.NL80211_ATTR_LOCAL_MESH_POWER_MODE
	NL80211_ATTR_LOCAL_STATE_CHANGE                         = C.NL80211_ATTR_LOCAL_STATE_CHANGE
	NL80211_ATTR_MAC_ACL_MAX                                = C.NL80211_ATTR_MAC_ACL_MAX
	NL80211_ATTR_MAC_ADDRS                                  = C.NL80211_ATTR_MAC_ADDRS
	NL80211_ATTR_MAC                                        = C.NL80211_ATTR_MAC
	NL80211_ATTR_MAC_HINT                                   = C.NL80211_ATTR_MAC_HINT
	NL80211_ATTR_MAC_MASK                                   = C.NL80211_ATTR_MAC_MASK
	NL80211_ATTR_MAX_AP_ASSOC_STA                           = C.NL80211_ATTR_MAX_AP_ASSOC_STA
	NL80211_ATTR_MAX                                        = C.NL80211_ATTR_MAX
	NL80211_ATTR_MAX_CRIT_PROT_DURATION                     = C.NL80211_ATTR_MAX_CRIT_PROT_DURATION
	NL80211_ATTR_MAX_CSA_COUNTERS                           = C.NL80211_ATTR_MAX_CSA_COUNTERS
	NL80211_ATTR_MAX_MATCH_SETS                             = C.NL80211_ATTR_MAX_MATCH_SETS
	NL80211_ATTR_MAX_NUM_PMKIDS                             = C.NL80211_ATTR_MAX_NUM_PMKIDS
	NL80211_ATTR_MAX_NUM_SCAN_SSIDS                         = C.NL80211_ATTR_MAX_NUM_SCAN_SSIDS
	NL80211_ATTR_MAX_NUM_SCHED_SCAN_PLANS                   = C.NL80211_ATTR_MAX_NUM_SCHED_SCAN_PLANS
	NL80211_ATTR_MAX_NUM_SCHED_SCAN_SSIDS                   = C.NL80211_ATTR_MAX_NUM_SCHED_SCAN_SSIDS
	NL80211_ATTR_MAX_REMAIN_ON_CHANNEL_DURATION             = C.NL80211_ATTR_MAX_REMAIN_ON_CHANNEL_DURATION
	NL80211_ATTR_MAX_SCAN_IE_LEN                            = C.NL80211_ATTR_MAX_SCAN_IE_LEN
	NL80211_ATTR_MAX_SCAN_PLAN_INTERVAL                     = C.NL80211_ATTR_MAX_SCAN_PLAN_INTERVAL
	NL80211_ATTR_MAX_SCAN_PLAN_ITERATIONS                   = C.NL80211_ATTR_MAX_SCAN_PLAN_ITERATIONS
	NL80211_ATTR_MAX_SCHED_SCAN_IE_LEN                      = C.NL80211_ATTR_MAX_SCHED_SCAN_IE_LEN
	NL80211_ATTR_MCAST_RATE                                 = C.NL80211_ATTR_MCAST_RATE
	NL80211_ATTR_MDID                                       = C.NL80211_ATTR_MDID
	NL80211_ATTR_MEASUREMENT_DURATION                       = C.NL80211_ATTR_MEASUREMENT_DURATION
	NL80211_ATTR_MEASUREMENT_DURATION_MANDATORY             = C.NL80211_ATTR_MEASUREMENT_DURATION_MANDATORY
	NL80211_ATTR_MESH_CONFIG                                = C.NL80211_ATTR_MESH_CONFIG
	NL80211_ATTR_MESH_ID                                    = C.NL80211_ATTR_MESH_ID
	NL80211_ATTR_MESH_PEER_AID                              = C.NL80211_ATTR_MESH_PEER_AID
	NL80211_ATTR_MESH_SETUP                                 = C.NL80211_ATTR_MESH_SETUP
	NL80211_ATTR_MGMT_SUBTYPE                               = C.NL80211_ATTR_MGMT_SUBTYPE
	NL80211_ATTR_MNTR_FLAGS                                 = C.NL80211_ATTR_MNTR_FLAGS
	NL80211_ATTR_MPATH_INFO                                 = C.NL80211_ATTR_MPATH_INFO
	NL80211_ATTR_MPATH_NEXT_HOP                             = C.NL80211_ATTR_MPATH_NEXT_HOP
	NL80211_ATTR_MULTICAST_TO_UNICAST_ENABLED               = C.NL80211_ATTR_MULTICAST_TO_UNICAST_ENABLED
	NL80211_ATTR_MU_MIMO_FOLLOW_MAC_ADDR                    = C.NL80211_ATTR_MU_MIMO_FOLLOW_MAC_ADDR
	NL80211_ATTR_MU_MIMO_GROUP_DATA                         = C.NL80211_ATTR_MU_MIMO_GROUP_DATA
	NL80211_ATTR_NAN_FUNC                                   = C.NL80211_ATTR_NAN_FUNC
	NL80211_ATTR_NAN_MASTER_PREF                            = C.NL80211_ATTR_NAN_MASTER_PREF
	NL80211_ATTR_NAN_MATCH                                  = C.NL80211_ATTR_NAN_MATCH
	NL80211_ATTR_NETNS_FD                                   = C.NL80211_ATTR_NETNS_FD
	NL80211_ATTR_NOACK_MAP                                  = C.NL80211_ATTR_NOACK_MAP
	NL80211_ATTR_NSS                                        = C.NL80211_ATTR_NSS
	NL80211_ATTR_OFFCHANNEL_TX_OK                           = C.NL80211_ATTR_OFFCHANNEL_TX_OK
	NL80211_ATTR_OPER_CLASS                                 = C.NL80211_ATTR_OPER_CLASS
	NL80211_ATTR_OPMODE_NOTIF                               = C.NL80211_ATTR_OPMODE_NOTIF
	NL80211_ATTR_P2P_CTWINDOW                               = C.NL80211_ATTR_P2P_CTWINDOW
	NL80211_ATTR_P2P_OPPPS                                  = C.NL80211_ATTR_P2P_OPPPS
	NL80211_ATTR_PAD                                        = C.NL80211_ATTR_PAD
	NL80211_ATTR_PBSS                                       = C.NL80211_ATTR_PBSS
	NL80211_ATTR_PEER_AID                                   = C.NL80211_ATTR_PEER_AID
	NL80211_ATTR_PEER_MEASUREMENTS                          = C.NL80211_ATTR_PEER_MEASUREMENTS
	NL80211_ATTR_PID                                        = C.NL80211_ATTR_PID
	NL80211_ATTR_PMK                                        = C.NL80211_ATTR_PMK
	NL80211_ATTR_PMKID                                      = C.NL80211_ATTR_PMKID
	NL80211_ATTR_PMK_LIFETIME                               = C.NL80211_ATTR_PMK_LIFETIME
	NL80211_ATTR_PMKR0_NAME                                 = C.NL80211_ATTR_PMKR0_NAME
	NL80211_ATTR_PMK_REAUTH_THRESHOLD                       = C.NL80211_ATTR_PMK_REAUTH_THRESHOLD
	NL80211_ATTR_PMKSA_CANDIDATE                            = C.NL80211_ATTR_PMKSA_CANDIDATE
	NL80211_ATTR_PORT_AUTHORIZED                            = C.NL80211_ATTR_PORT_AUTHORIZED
	NL80211_ATTR_POWER_RULE_MAX_ANT_GAIN                    = C.NL80211_ATTR_POWER_RULE_MAX_ANT_GAIN
	NL80211_ATTR_POWER_RULE_MAX_EIRP                        = C.NL80211_ATTR_POWER_RULE_MAX_EIRP
	NL80211_ATTR_PREV_BSSID                                 = C.NL80211_ATTR_PREV_BSSID
	NL80211_ATTR_PRIVACY                                    = C.NL80211_ATTR_PRIVACY
	NL80211_ATTR_PROBE_RESP                                 = C.NL80211_ATTR_PROBE_RESP
	NL80211_ATTR_PROBE_RESP_OFFLOAD                         = C.NL80211_ATTR_PROBE_RESP_OFFLOAD
	NL80211_ATTR_PROTOCOL_FEATURES                          = C.NL80211_ATTR_PROTOCOL_FEATURES
	NL80211_ATTR_PS_STATE                                   = C.NL80211_ATTR_PS_STATE
	NL80211_ATTR_QOS_MAP                                    = C.NL80211_ATTR_QOS_MAP
	NL80211_ATTR_RADAR_EVENT                                = C.NL80211_ATTR_RADAR_EVENT
	NL80211_ATTR_REASON_CODE                                = C.NL80211_ATTR_REASON_CODE
	NL80211_ATTR_RECEIVE_MULTICAST                          = C.NL80211_ATTR_RECEIVE_MULTICAST
	NL80211_ATTR_RECONNECT_REQUESTED                        = C.NL80211_ATTR_RECONNECT_REQUESTED
	NL80211_ATTR_REG_ALPHA2                                 = C.NL80211_ATTR_REG_ALPHA2
	NL80211_ATTR_REG_INDOOR                                 = C.NL80211_ATTR_REG_INDOOR
	NL80211_ATTR_REG_INITIATOR                              = C.NL80211_ATTR_REG_INITIATOR
	NL80211_ATTR_REG_RULE_FLAGS                             = C.NL80211_ATTR_REG_RULE_FLAGS
	NL80211_ATTR_REG_RULES                                  = C.NL80211_ATTR_REG_RULES
	NL80211_ATTR_REG_TYPE                                   = C.NL80211_ATTR_REG_TYPE
	NL80211_ATTR_REKEY_DATA                                 = C.NL80211_ATTR_REKEY_DATA
	NL80211_ATTR_REQ_IE                                     = C.NL80211_ATTR_REQ_IE
	NL80211_ATTR_RESP_IE                                    = C.NL80211_ATTR_RESP_IE
	NL80211_ATTR_ROAM_SUPPORT                               = C.NL80211_ATTR_ROAM_SUPPORT
	NL80211_ATTR_RX_FRAME_TYPES                             = C.NL80211_ATTR_RX_FRAME_TYPES
	NL80211_ATTR_RXMGMT_FLAGS                               = C.NL80211_ATTR_RXMGMT_FLAGS
	NL80211_ATTR_RX_SIGNAL_DBM                              = C.NL80211_ATTR_RX_SIGNAL_DBM
	NL80211_ATTR_S1G_CAPABILITY                             = C.NL80211_ATTR_S1G_CAPABILITY
	NL80211_ATTR_S1G_CAPABILITY_MASK                        = C.NL80211_ATTR_S1G_CAPABILITY_MASK
	NL80211_ATTR_SAE_DATA                                   = C.NL80211_ATTR_SAE_DATA
	NL80211_ATTR_SAE_PASSWORD                               = C.NL80211_ATTR_SAE_PASSWORD
	NL80211_ATTR_SAE_PWE                                    = C.NL80211_ATTR_SAE_PWE
	NL80211_ATTR_SAR_SPEC                                   = C.NL80211_ATTR_SAR_SPEC
	NL80211_ATTR_SCAN_FLAGS                                 = C.NL80211_ATTR_SCAN_FLAGS
	NL80211_ATTR_SCAN_FREQ_KHZ                              = C.NL80211_ATTR_SCAN_FREQ_KHZ
	NL80211_ATTR_SCAN_FREQUENCIES                           = C.NL80211_ATTR_SCAN_FREQUENCIES
	NL80211_ATTR_SCAN_GENERATION                            = C.NL80211_ATTR_SCAN_GENERATION
	NL80211_ATTR_SCAN_SSIDS                                 = C.NL80211_ATTR_SCAN_SSIDS
	NL80211_ATTR_SCAN_START_TIME_TSF_BSSID                  = C.NL80211_ATTR_SCAN_START_TIME_TSF_BSSID
	NL80211_ATTR_SCAN_START_TIME_TSF                        = C.NL80211_ATTR_SCAN_START_TIME_TSF
	NL80211_ATTR_SCAN_SUPP_RATES                            = C.NL80211_ATTR_SCAN_SUPP_RATES
	NL80211_ATTR_SCHED_SCAN_DELAY                           = C.NL80211_ATTR_SCHED_SCAN_DELAY
	NL80211_ATTR_SCHED_SCAN_INTERVAL                        = C.NL80211_ATTR_SCHED_SCAN_INTERVAL
	NL80211_ATTR_SCHED_SCAN_MATCH                           = C.NL80211_ATTR_SCHED_SCAN_MATCH
	NL80211_ATTR_SCHED_SCAN_MATCH_SSID                      = C.NL80211_ATTR_SCHED_SCAN_MATCH_SSID
	NL80211_ATTR_SCHED_SCAN_MAX_REQS                        = C.NL80211_ATTR_SCHED_SCAN_MAX_REQS
	NL80211_ATTR_SCHED_SCAN_MULTI                           = C.NL80211_ATTR_SCHED_SCAN_MULTI
	NL80211_ATTR_SCHED_SCAN_PLANS                           = C.NL80211_ATTR_SCHED_SCAN_PLANS
	NL80211_ATTR_SCHED_SCAN_RELATIVE_RSSI                   = C.NL80211_ATTR_SCHED_SCAN_RELATIVE_RSSI
	NL80211_ATTR_SCHED_SCAN_RSSI_ADJUST                     = C.NL80211_ATTR_SCHED_SCAN_RSSI_ADJUST
	NL80211_ATTR_SMPS_MODE                                  = C.NL80211_ATTR_SMPS_MODE
	NL80211_ATTR_SOCKET_OWNER                               = C.NL80211_ATTR_SOCKET_OWNER
	NL80211_ATTR_SOFTWARE_IFTYPES                           = C.NL80211_ATTR_SOFTWARE_IFTYPES
	NL80211_ATTR_SPLIT_WIPHY_DUMP                           = C.NL80211_ATTR_SPLIT_WIPHY_DUMP
	NL80211_ATTR_SSID                                       = C.NL80211_ATTR_SSID
	NL80211_ATTR_STA_AID                                    = C.NL80211_ATTR_STA_AID
	NL80211_ATTR_STA_CAPABILITY                             = C.NL80211_ATTR_STA_CAPABILITY
	NL80211_ATTR_STA_EXT_CAPABILITY                         = C.NL80211_ATTR_STA_EXT_CAPABILITY
	NL80211_ATTR_STA_FLAGS2                                 = C.NL80211_ATTR_STA_FLAGS2
	NL80211_ATTR_STA_FLAGS                                  = C.NL80211_ATTR_STA_FLAGS
	NL80211_ATTR_STA_INFO                                   = C.NL80211_ATTR_STA_INFO
	NL80211_ATTR_STA_LISTEN_INTERVAL                        = C.NL80211_ATTR_STA_LISTEN_INTERVAL
	NL80211_ATTR_STA_PLINK_ACTION                           = C.NL80211_ATTR_STA_PLINK_ACTION
	NL80211_ATTR_STA_PLINK_STATE                            = C.NL80211_ATTR_STA_PLINK_STATE
	NL80211_ATTR_STA_SUPPORTED_CHANNELS                     = C.NL80211_ATTR_STA_SUPPORTED_CHANNELS
	NL80211_ATTR_STA_SUPPORTED_OPER_CLASSES                 = C.NL80211_ATTR_STA_SUPPORTED_OPER_CLASSES
	NL80211_ATTR_STA_SUPPORTED_RATES                        = C.NL80211_ATTR_STA_SUPPORTED_RATES
	NL80211_ATTR_STA_SUPPORT_P2P_PS                         = C.NL80211_ATTR_STA_SUPPORT_P2P_PS
	NL80211_ATTR_STATUS_CODE                                = C.NL80211_ATTR_STATUS_CODE
	NL80211_ATTR_STA_TX_POWER                               = C.NL80211_ATTR_STA_TX_POWER
	NL80211_ATTR_STA_TX_POWER_SETTING                       = C.NL80211_ATTR_STA_TX_POWER_SETTING
	NL80211_ATTR_STA_VLAN                                   = C.NL80211_ATTR_STA_VLAN
	NL80211_ATTR_STA_WME                                    = C.NL80211_ATTR_STA_WME
	NL80211_ATTR_SUPPORT_10_MHZ                             = C.NL80211_ATTR_SUPPORT_10_MHZ
	NL80211_ATTR_SUPPORT_5_MHZ                              = C.NL80211_ATTR_SUPPORT_5_MHZ
	NL80211_ATTR_SUPPORT_AP_UAPSD                           = C.NL80211_ATTR_SUPPORT_AP_UAPSD
	NL80211_ATTR_SUPPORTED_COMMANDS                         = C.NL80211_ATTR_SUPPORTED_COMMANDS
	NL80211_ATTR_SUPPORTED_IFTYPES                          = C.NL80211_ATTR_SUPPORTED_IFTYPES
	NL80211_ATTR_SUPPORT_IBSS_RSN                           = C.NL80211_ATTR_SUPPORT_IBSS_RSN
	NL80211_ATTR_SUPPORT_MESH_AUTH                          = C.NL80211_ATTR_SUPPORT_MESH_AUTH
	NL80211_ATTR_SURVEY_INFO                                = C.NL80211_ATTR_SURVEY_INFO
	NL80211_ATTR_SURVEY_RADIO_STATS                         = C.NL80211_ATTR_SURVEY_RADIO_STATS
	NL80211_ATTR_TDLS_ACTION                                = C.NL80211_ATTR_TDLS_ACTION
	NL80211_ATTR_TDLS_DIALOG_TOKEN                          = C.NL80211_ATTR_TDLS_DIALOG_TOKEN
	NL80211_ATTR_TDLS_EXTERNAL_SETUP                        = C.NL80211_ATTR_TDLS_EXTERNAL_SETUP
	NL80211_ATTR_TDLS_INITIATOR                             = C.NL80211_ATTR_TDLS_INITIATOR
	NL80211_ATTR_TDLS_OPERATION                             = C.NL80211_ATTR_TDLS_OPERATION
	NL80211_ATTR_TDLS_PEER_CAPABILITY                       = C.NL80211_ATTR_TDLS_PEER_CAPABILITY
	NL80211_ATTR_TDLS_SUPPORT                               = C.NL80211_ATTR_TDLS_SUPPORT
	NL80211_ATTR_TESTDATA                                   = C.NL80211_ATTR_TESTDATA
	NL80211_ATTR_TID_CONFIG                                 = C.NL80211_ATTR_TID_CONFIG
	NL80211_ATTR_TIMED_OUT                                  = C.NL80211_ATTR_TIMED_OUT
	NL80211_ATTR_TIMEOUT                                    = C.NL80211_ATTR_TIMEOUT
	NL80211_ATTR_TIMEOUT_REASON                             = C.NL80211_ATTR_TIMEOUT_REASON
	NL80211_ATTR_TSID                                       = C.NL80211_ATTR_TSID
	NL80211_ATTR_TWT_RESPONDER                              = C.NL80211_ATTR_TWT_RESPONDER
	NL80211_ATTR_TX_FRAME_TYPES                             = C.NL80211_ATTR_TX_FRAME_TYPES
	NL80211_ATTR_TX_NO_CCK_RATE                             = C.NL80211_ATTR_TX_NO_CCK_RATE
	NL80211_ATTR_TXQ_LIMIT                                  = C.NL80211_ATTR_TXQ_LIMIT
	NL80211_ATTR_TXQ_MEMORY_LIMIT                           = C.NL80211_ATTR_TXQ_MEMORY_LIMIT
	NL80211_ATTR_TXQ_QUANTUM                                = C.NL80211_ATTR_TXQ_QUANTUM
	NL80211_ATTR_TXQ_STATS                                  = C.NL80211_ATTR_TXQ_STATS
	NL80211_ATTR_TX_RATES                                   = C.NL80211_ATTR_TX_RATES
	NL80211_ATTR_UNSOL_BCAST_PROBE_RESP                     = C.NL80211_ATTR_UNSOL_BCAST_PROBE_RESP
	NL80211_ATTR_UNSPEC                                     = C.NL80211_ATTR_UNSPEC
	NL80211_ATTR_USE_MFP                                    = C.NL80211_ATTR_USE_MFP
	NL80211_ATTR_USER_PRIO                                  = C.NL80211_ATTR_USER_PRIO
	NL80211_ATTR_USER_REG_HINT_TYPE                         = C.NL80211_ATTR_USER_REG_HINT_TYPE
	NL80211_ATTR_USE_RRM                                    = C.NL80211_ATTR_USE_RRM
	NL80211_ATTR_VENDOR_DATA                                = C.NL80211_ATTR_VENDOR_DATA
	NL80211_ATTR_VENDOR_EVENTS                              = C.NL80211_ATTR_VENDOR_EVENTS
	NL80211_ATTR_VENDOR_ID                                  = C.NL80211_ATTR_VENDOR_ID
	NL80211_ATTR_VENDOR_SUBCMD                              = C.NL80211_ATTR_VENDOR_SUBCMD
	NL80211_ATTR_VHT_CAPABILITY                             = C.NL80211_ATTR_VHT_CAPABILITY
	NL80211_ATTR_VHT_CAPABILITY_MASK                        = C.NL80211_ATTR_VHT_CAPABILITY_MASK
	NL80211_ATTR_VLAN_ID                                    = C.NL80211_ATTR_VLAN_ID
	NL80211_ATTR_WANT_1X_4WAY_HS                            = C.NL80211_ATTR_WANT_1X_4WAY_HS
	NL80211_ATTR_WDEV                                       = C.NL80211_ATTR_WDEV
	NL80211_ATTR_WIPHY_ANTENNA_AVAIL_RX                     = C.NL80211_ATTR_WIPHY_ANTENNA_AVAIL_RX
	NL80211_ATTR_WIPHY_ANTENNA_AVAIL_TX                     = C.NL80211_ATTR_WIPHY_ANTENNA_AVAIL_TX
	NL80211_ATTR_WIPHY_ANTENNA_RX                           = C.NL80211_ATTR_WIPHY_ANTENNA_RX
	NL80211_ATTR_WIPHY_ANTENNA_TX                           = C.NL80211_ATTR_WIPHY_ANTENNA_TX
	NL80211_ATTR_WIPHY_BANDS                                = C.NL80211_ATTR_WIPHY_BANDS
	NL80211_ATTR_WIPHY_CHANNEL_TYPE                         = C.NL80211_ATTR_WIPHY_CHANNEL_TYPE
	NL80211_ATTR_WIPHY                                      = C.NL80211_ATTR_WIPHY
	NL80211_ATTR_WIPHY_COVERAGE_CLASS                       = C.NL80211_ATTR_WIPHY_COVERAGE_CLASS
	NL80211_ATTR_WIPHY_DYN_ACK                              = C.NL80211_ATTR_WIPHY_DYN_ACK
	NL80211_ATTR_WIPHY_EDMG_BW_CONFIG                       = C.NL80211_ATTR_WIPHY_EDMG_BW_CONFIG
	NL80211_ATTR_WIPHY_EDMG_CHANNELS                        = C.NL80211_ATTR_WIPHY_EDMG_CHANNELS
	NL80211_ATTR_WIPHY_FRAG_THRESHOLD                       = C.NL80211_ATTR_WIPHY_FRAG_THRESHOLD
	NL80211_ATTR_WIPHY_FREQ                                 = C.NL80211_ATTR_WIPHY_FREQ
	NL80211_ATTR_WIPHY_FREQ_HINT                            = C.NL80211_ATTR_WIPHY_FREQ_HINT
	NL80211_ATTR_WIPHY_FREQ_OFFSET                          = C.NL80211_ATTR_WIPHY_FREQ_OFFSET
	NL80211_ATTR_WIPHY_NAME                                 = C.NL80211_ATTR_WIPHY_NAME
	NL80211_ATTR_WIPHY_RETRY_LONG                           = C.NL80211_ATTR_WIPHY_RETRY_LONG
	NL80211_ATTR_WIPHY_RETRY_SHORT                          = C.NL80211_ATTR_WIPHY_RETRY_SHORT
	NL80211_ATTR_WIPHY_RTS_THRESHOLD                        = C.NL80211_ATTR_WIPHY_RTS_THRESHOLD
	NL80211_ATTR_WIPHY_SELF_MANAGED_REG                     = C.NL80211_ATTR_WIPHY_SELF_MANAGED_REG
	NL80211_ATTR_WIPHY_TX_POWER_LEVEL                       = C.NL80211_ATTR_WIPHY_TX_POWER_LEVEL
	NL80211_ATTR_WIPHY_TX_POWER_SETTING                     = C.NL80211_ATTR_WIPHY_TX_POWER_SETTING
	NL80211_ATTR_WIPHY_TXQ_PARAMS                           = C.NL80211_ATTR_WIPHY_TXQ_PARAMS
	NL80211_ATTR_WOWLAN_TRIGGERS                            = C.NL80211_ATTR_WOWLAN_TRIGGERS
	NL80211_ATTR_WOWLAN_TRIGGERS_SUPPORTED                  = C.NL80211_ATTR_WOWLAN_TRIGGERS_SUPPORTED
	NL80211_ATTR_WPA_VERSIONS                               = C.NL80211_ATTR_WPA_VERSIONS
	NL80211_AUTHTYPE_AUTOMATIC                              = C.NL80211_AUTHTYPE_AUTOMATIC
	NL80211_AUTHTYPE_FILS_PK                                = C.NL80211_AUTHTYPE_FILS_PK
	NL80211_AUTHTYPE_FILS_SK                                = C.NL80211_AUTHTYPE_FILS_SK
	NL80211_AUTHTYPE_FILS_SK_PFS                            = C.NL80211_AUTHTYPE_FILS_SK_PFS
	NL80211_AUTHTYPE_FT                                     = C.NL80211_AUTHTYPE_FT
	NL80211_AUTHTYPE_MAX                                    = C.NL80211_AUTHTYPE_MAX
	NL80211_AUTHTYPE_NETWORK_EAP                            = C.NL80211_AUTHTYPE_NETWORK_EAP
	NL80211_AUTHTYPE_OPEN_SYSTEM                            = C.NL80211_AUTHTYPE_OPEN_SYSTEM
	NL80211_AUTHTYPE_SAE                                    = C.NL80211_AUTHTYPE_SAE
	NL80211_AUTHTYPE_SHARED_KEY                             = C.NL80211_AUTHTYPE_SHARED_KEY
	NL80211_BAND_2GHZ                                       = C.NL80211_BAND_2GHZ
	NL80211_BAND_5GHZ                                       = C.NL80211_BAND_5GHZ
	NL80211_BAND_60GHZ                                      = C.NL80211_BAND_60GHZ
	NL80211_BAND_6GHZ                                       = C.NL80211_BAND_6GHZ
	NL80211_BAND_ATTR_EDMG_BW_CONFIG                        = C.NL80211_BAND_ATTR_EDMG_BW_CONFIG
	NL80211_BAND_ATTR_EDMG_CHANNELS                         = C.NL80211_BAND_ATTR_EDMG_CHANNELS
	NL80211_BAND_ATTR_FREQS                                 = C.NL80211_BAND_ATTR_FREQS
	NL80211_BAND_ATTR_HT_AMPDU_DENSITY                      = C.NL80211_BAND_ATTR_HT_AMPDU_DENSITY
	NL80211_BAND_ATTR_HT_AMPDU_FACTOR                       = C.NL80211_BAND_ATTR_HT_AMPDU_FACTOR
	NL80211_BAND_ATTR_HT_CAPA                               = C.NL80211_BAND_ATTR_HT_CAPA
	NL80211_BAND_ATTR_HT_MCS_SET                            = C.NL80211_BAND_ATTR_HT_MCS_SET
	NL80211_BAND_ATTR_IFTYPE_DATA                           = C.NL80211_BAND_ATTR_IFTYPE_DATA
	NL80211_BAND_ATTR_MAX                                   = C.NL80211_BAND_ATTR_MAX
	NL80211_BAND_ATTR_RATES                                 = C.NL80211_BAND_ATTR_RATES
	NL80211_BAND_ATTR_VHT_CAPA                              = C.NL80211_BAND_ATTR_VHT_CAPA
	NL80211_BAND_ATTR_VHT_MCS_SET                           = C.NL80211_BAND_ATTR_VHT_MCS_SET
	NL80211_BAND_IFTYPE_ATTR_HE_6GHZ_CAPA                   = C.NL80211_BAND_IFTYPE_ATTR_HE_6GHZ_CAPA
	NL80211_BAND_IFTYPE_ATTR_HE_CAP_MAC                     = C.NL80211_BAND_IFTYPE_ATTR_HE_CAP_MAC
	NL80211_BAND_IFTYPE_ATTR_HE_CAP_MCS_SET                 = C.NL80211_BAND_IFTYPE_ATTR_HE_CAP_MCS_SET
	NL80211_BAND_IFTYPE_ATTR_HE_CAP_PHY                     = C.NL80211_BAND_IFTYPE_ATTR_HE_CAP_PHY
	NL80211_BAND_IFTYPE_ATTR_HE_CAP_PPE                     = C.NL80211_BAND_IFTYPE_ATTR_HE_CAP_PPE
	NL80211_BAND_IFTYPE_ATTR_IFTYPES                        = C.NL80211_BAND_IFTYPE_ATTR_IFTYPES
	NL80211_BAND_IFTYPE_ATTR_MAX                            = C.NL80211_BAND_IFTYPE_ATTR_MAX
	NL80211_BAND_S1GHZ                                      = C.NL80211_BAND_S1GHZ
	NL80211_BITRATE_ATTR_2GHZ_SHORTPREAMBLE                 = C.NL80211_BITRATE_ATTR_2GHZ_SHORTPREAMBLE
	NL80211_BITRATE_ATTR_MAX                                = C.NL80211_BITRATE_ATTR_MAX
	NL80211_BITRATE_ATTR_RATE                               = C.NL80211_BITRATE_ATTR_RATE
	NL80211_BSS_BEACON_IES                                  = C.NL80211_BSS_BEACON_IES
	NL80211_BSS_BEACON_INTERVAL                             = C.NL80211_BSS_BEACON_INTERVAL
	NL80211_BSS_BEACON_TSF                                  = C.NL80211_BSS_BEACON_TSF
	NL80211_BSS_BSSID                                       = C.NL80211_BSS_BSSID
	NL80211_BSS_CAPABILITY                                  = C.NL80211_BSS_CAPABILITY
	NL80211_BSS_CHAIN_SIGNAL                                = C.NL80211_BSS_CHAIN_SIGNAL
	NL80211_BSS_CHAN_WIDTH_10                               = C.NL80211_BSS_CHAN_WIDTH_10
	NL80211_BSS_CHAN_WIDTH_1                                = C.NL80211_BSS_CHAN_WIDTH_1
	NL80211_BSS_CHAN_WIDTH_20                               = C.NL80211_BSS_CHAN_WIDTH_20
	NL80211_BSS_CHAN_WIDTH_2                                = C.NL80211_BSS_CHAN_WIDTH_2
	NL80211_BSS_CHAN_WIDTH_5                                = C.NL80211_BSS_CHAN_WIDTH_5
	NL80211_BSS_CHAN_WIDTH                                  = C.NL80211_BSS_CHAN_WIDTH
	NL80211_BSS_FREQUENCY                                   = C.NL80211_BSS_FREQUENCY
	NL80211_BSS_FREQUENCY_OFFSET                            = C.NL80211_BSS_FREQUENCY_OFFSET
	NL80211_BSS_INFORMATION_ELEMENTS                        = C.NL80211_BSS_INFORMATION_ELEMENTS
	NL80211_BSS_LAST_SEEN_BOOTTIME                          = C.NL80211_BSS_LAST_SEEN_BOOTTIME
	NL80211_BSS_MAX                                         = C.NL80211_BSS_MAX
	NL80211_BSS_PAD                                         = C.NL80211_BSS_PAD
	NL80211_BSS_PARENT_BSSID                                = C.NL80211_BSS_PARENT_BSSID
	NL80211_BSS_PARENT_TSF                                  = C.NL80211_BSS_PARENT_TSF
	NL80211_BSS_PRESP_DATA                                  = C.NL80211_BSS_PRESP_DATA
	NL80211_BSS_SEEN_MS_AGO                                 = C.NL80211_BSS_SEEN_MS_AGO
	NL80211_BSS_SELECT_ATTR_BAND_PREF                       = C.NL80211_BSS_SELECT_ATTR_BAND_PREF
	NL80211_BSS_SELECT_ATTR_MAX                             = C.NL80211_BSS_SELECT_ATTR_MAX
	NL80211_BSS_SELECT_ATTR_RSSI_ADJUST                     = C.NL80211_BSS_SELECT_ATTR_RSSI_ADJUST
	NL80211_BSS_SELECT_ATTR_RSSI                            = C.NL80211_BSS_SELECT_ATTR_RSSI
	NL80211_BSS_SIGNAL_MBM                                  = C.NL80211_BSS_SIGNAL_MBM
	NL80211_BSS_SIGNAL_UNSPEC                               = C.NL80211_BSS_SIGNAL_UNSPEC
	NL80211_BSS_STATUS_ASSOCIATED                           = C.NL80211_BSS_STATUS_ASSOCIATED
	NL80211_BSS_STATUS_AUTHENTICATED                        = C.NL80211_BSS_STATUS_AUTHENTICATED
	NL80211_BSS_STATUS                                      = C.NL80211_BSS_STATUS
	NL80211_BSS_STATUS_IBSS_JOINED                          = C.NL80211_BSS_STATUS_IBSS_JOINED
	NL80211_BSS_TSF                                         = C.NL80211_BSS_TSF
	NL80211_CHAN_HT20                                       = C.NL80211_CHAN_HT20
	NL80211_CHAN_HT40MINUS                                  = C.NL80211_CHAN_HT40MINUS
	NL80211_CHAN_HT40PLUS                                   = C.NL80211_CHAN_HT40PLUS
	NL80211_CHAN_NO_HT                                      = C.NL80211_CHAN_NO_HT
	NL80211_CHAN_WIDTH_10                                   = C.NL80211_CHAN_WIDTH_10
	NL80211_CHAN_WIDTH_160                                  = C.NL80211_CHAN_WIDTH_160
	NL80211_CHAN_WIDTH_16                                   = C.NL80211_CHAN_WIDTH_16
	NL80211_CHAN_WIDTH_1                                    = C.NL80211_CHAN_WIDTH_1
	NL80211_CHAN_WIDTH_20                                   = C.NL80211_CHAN_WIDTH_20
	NL80211_CHAN_WIDTH_20_NOHT                              = C.NL80211_CHAN_WIDTH_20_NOHT
	NL80211_CHAN_WIDTH_2                                    = C.NL80211_CHAN_WIDTH_2
	NL80211_CHAN_WIDTH_40                                   = C.NL80211_CHAN_WIDTH_40
	NL80211_CHAN_WIDTH_4                                    = C.NL80211_CHAN_WIDTH_4
	NL80211_CHAN_WIDTH_5                                    = C.NL80211_CHAN_WIDTH_5
	NL80211_CHAN_WIDTH_80                                   = C.NL80211_CHAN_WIDTH_80
	NL80211_CHAN_WIDTH_80P80                                = C.NL80211_CHAN_WIDTH_80P80
	NL80211_CHAN_WIDTH_8                                    = C.NL80211_CHAN_WIDTH_8
	NL80211_CMD_ABORT_SCAN                                  = C.NL80211_CMD_ABORT_SCAN
	NL80211_CMD_ACTION                                      = C.NL80211_CMD_ACTION
	NL80211_CMD_ACTION_TX_STATUS                            = C.NL80211_CMD_ACTION_TX_STATUS
	NL80211_CMD_ADD_NAN_FUNCTION                            = C.NL80211_CMD_ADD_NAN_FUNCTION
	NL80211_CMD_ADD_TX_TS                                   = C.NL80211_CMD_ADD_TX_TS
	NL80211_CMD_ASSOCIATE                                   = C.NL80211_CMD_ASSOCIATE
	NL80211_CMD_AUTHENTICATE                                = C.NL80211_CMD_AUTHENTICATE
	NL80211_CMD_CANCEL_REMAIN_ON_CHANNEL                    = C.NL80211_CMD_CANCEL_REMAIN_ON_CHANNEL
	NL80211_CMD_CHANGE_NAN_CONFIG                           = C.NL80211_CMD_CHANGE_NAN_CONFIG
	NL80211_CMD_CHANNEL_SWITCH                              = C.NL80211_CMD_CHANNEL_SWITCH
	NL80211_CMD_CH_SWITCH_NOTIFY                            = C.NL80211_CMD_CH_SWITCH_NOTIFY
	NL80211_CMD_CH_SWITCH_STARTED_NOTIFY                    = C.NL80211_CMD_CH_SWITCH_STARTED_NOTIFY
	NL80211_CMD_CONNECT                                     = C.NL80211_CMD_CONNECT
	NL80211_CMD_CONN_FAILED                                 = C.NL80211_CMD_CONN_FAILED
	NL80211_CMD_CONTROL_PORT_FRAME                          = C.NL80211_CMD_CONTROL_PORT_FRAME
	NL80211_CMD_CONTROL_PORT_FRAME_TX_STATUS                = C.NL80211_CMD_CONTROL_PORT_FRAME_TX_STATUS
	NL80211_CMD_CRIT_PROTOCOL_START                         = C.NL80211_CMD_CRIT_PROTOCOL_START
	NL80211_CMD_CRIT_PROTOCOL_STOP                          = C.NL80211_CMD_CRIT_PROTOCOL_STOP
	NL80211_CMD_DEAUTHENTICATE                              = C.NL80211_CMD_DEAUTHENTICATE
	NL80211_CMD_DEL_BEACON                                  = C.NL80211_CMD_DEL_BEACON
	NL80211_CMD_DEL_INTERFACE                               = C.NL80211_CMD_DEL_INTERFACE
	NL80211_CMD_DEL_KEY                                     = C.NL80211_CMD_DEL_KEY
	NL80211_CMD_DEL_MPATH                                   = C.NL80211_CMD_DEL_MPATH
	NL80211_CMD_DEL_NAN_FUNCTION                            = C.NL80211_CMD_DEL_NAN_FUNCTION
	NL80211_CMD_DEL_PMK                                     = C.NL80211_CMD_DEL_PMK
	NL80211_CMD_DEL_PMKSA                                   = C.NL80211_CMD_DEL_PMKSA
	NL80211_CMD_DEL_STATION                                 = C.NL80211_CMD_DEL_STATION
	NL80211_CMD_DEL_TX_TS                                   = C.NL80211_CMD_DEL_TX_TS
	NL80211_CMD_DEL_WIPHY                                   = C.NL80211_CMD_DEL_WIPHY
	NL80211_CMD_DISASSOCIATE                                = C.NL80211_CMD_DISASSOCIATE
	NL80211_CMD_DISCONNECT                                  = C.NL80211_CMD_DISCONNECT
	NL80211_CMD_EXTERNAL_AUTH                               = C.NL80211_CMD_EXTERNAL_AUTH
	NL80211_CMD_FLUSH_PMKSA                                 = C.NL80211_CMD_FLUSH_PMKSA
	NL80211_CMD_FRAME                                       = C.NL80211_CMD_FRAME
	NL80211_CMD_FRAME_TX_STATUS                             = C.NL80211_CMD_FRAME_TX_STATUS
	NL80211_CMD_FRAME_WAIT_CANCEL                           = C.NL80211_CMD_FRAME_WAIT_CANCEL
	NL80211_CMD_FT_EVENT                                    = C.NL80211_CMD_FT_EVENT
	NL80211_CMD_GET_BEACON                                  = C.NL80211_CMD_GET_BEACON
	NL80211_CMD_GET_COALESCE                                = C.NL80211_CMD_GET_COALESCE
	NL80211_CMD_GET_FTM_RESPONDER_STATS                     = C.NL80211_CMD_GET_FTM_RESPONDER_STATS
	NL80211_CMD_GET_INTERFACE                               = C.NL80211_CMD_GET_INTERFACE
	NL80211_CMD_GET_KEY                                     = C.NL80211_CMD_GET_KEY
	NL80211_CMD_GET_MESH_CONFIG                             = C.NL80211_CMD_GET_MESH_CONFIG
	NL80211_CMD_GET_MESH_PARAMS                             = C.NL80211_CMD_GET_MESH_PARAMS
	NL80211_CMD_GET_MPATH                                   = C.NL80211_CMD_GET_MPATH
	NL80211_CMD_GET_MPP                                     = C.NL80211_CMD_GET_MPP
	NL80211_CMD_GET_POWER_SAVE                              = C.NL80211_CMD_GET_POWER_SAVE
	NL80211_CMD_GET_PROTOCOL_FEATURES                       = C.NL80211_CMD_GET_PROTOCOL_FEATURES
	NL80211_CMD_GET_REG                                     = C.NL80211_CMD_GET_REG
	NL80211_CMD_GET_SCAN                                    = C.NL80211_CMD_GET_SCAN
	NL80211_CMD_GET_STATION                                 = C.NL80211_CMD_GET_STATION
	NL80211_CMD_GET_SURVEY                                  = C.NL80211_CMD_GET_SURVEY
	NL80211_CMD_GET_WIPHY                                   = C.NL80211_CMD_GET_WIPHY
	NL80211_CMD_GET_WOWLAN                                  = C.NL80211_CMD_GET_WOWLAN
	NL80211_CMD_JOIN_IBSS                                   = C.NL80211_CMD_JOIN_IBSS
	NL80211_CMD_JOIN_MESH                                   = C.NL80211_CMD_JOIN_MESH
	NL80211_CMD_JOIN_OCB                                    = C.NL80211_CMD_JOIN_OCB
	NL80211_CMD_LEAVE_IBSS                                  = C.NL80211_CMD_LEAVE_IBSS
	NL80211_CMD_LEAVE_MESH                                  = C.NL80211_CMD_LEAVE_MESH
	NL80211_CMD_LEAVE_OCB                                   = C.NL80211_CMD_LEAVE_OCB
	NL80211_CMD_MAX                                         = C.NL80211_CMD_MAX
	NL80211_CMD_MICHAEL_MIC_FAILURE                         = C.NL80211_CMD_MICHAEL_MIC_FAILURE
	NL80211_CMD_NAN_MATCH                                   = C.NL80211_CMD_NAN_MATCH
	NL80211_CMD_NEW_BEACON                                  = C.NL80211_CMD_NEW_BEACON
	NL80211_CMD_NEW_INTERFACE                               = C.NL80211_CMD_NEW_INTERFACE
	NL80211_CMD_NEW_KEY                                     = C.NL80211_CMD_NEW_KEY
	NL80211_CMD_NEW_MPATH                                   = C.NL80211_CMD_NEW_MPATH
	NL80211_CMD_NEW_PEER_CANDIDATE                          = C.NL80211_CMD_NEW_PEER_CANDIDATE
	NL80211_CMD_NEW_SCAN_RESULTS                            = C.NL80211_CMD_NEW_SCAN_RESULTS
	NL80211_CMD_NEW_STATION                                 = C.NL80211_CMD_NEW_STATION
	NL80211_CMD_NEW_SURVEY_RESULTS                          = C.NL80211_CMD_NEW_SURVEY_RESULTS
	NL80211_CMD_NEW_WIPHY                                   = C.NL80211_CMD_NEW_WIPHY
	NL80211_CMD_NOTIFY_CQM                                  = C.NL80211_CMD_NOTIFY_CQM
	NL80211_CMD_NOTIFY_RADAR                                = C.NL80211_CMD_NOTIFY_RADAR
	NL80211_CMD_PEER_MEASUREMENT_COMPLETE                   = C.NL80211_CMD_PEER_MEASUREMENT_COMPLETE
	NL80211_CMD_PEER_MEASUREMENT_RESULT                     = C.NL80211_CMD_PEER_MEASUREMENT_RESULT
	NL80211_CMD_PEER_MEASUREMENT_START                      = C.NL80211_CMD_PEER_MEASUREMENT_START
	NL80211_CMD_PMKSA_CANDIDATE                             = C.NL80211_CMD_PMKSA_CANDIDATE
	NL80211_CMD_PORT_AUTHORIZED                             = C.NL80211_CMD_PORT_AUTHORIZED
	NL80211_CMD_PROBE_CLIENT                                = C.NL80211_CMD_PROBE_CLIENT
	NL80211_CMD_PROBE_MESH_LINK                             = C.NL80211_CMD_PROBE_MESH_LINK
	NL80211_CMD_RADAR_DETECT                                = C.NL80211_CMD_RADAR_DETECT
	NL80211_CMD_REG_BEACON_HINT                             = C.NL80211_CMD_REG_BEACON_HINT
	NL80211_CMD_REG_CHANGE                                  = C.NL80211_CMD_REG_CHANGE
	NL80211_CMD_REGISTER_ACTION                             = C.NL80211_CMD_REGISTER_ACTION
	NL80211_CMD_REGISTER_BEACONS                            = C.NL80211_CMD_REGISTER_BEACONS
	NL80211_CMD_REGISTER_FRAME                              = C.NL80211_CMD_REGISTER_FRAME
	NL80211_CMD_RELOAD_REGDB                                = C.NL80211_CMD_RELOAD_REGDB
	NL80211_CMD_REMAIN_ON_CHANNEL                           = C.NL80211_CMD_REMAIN_ON_CHANNEL
	NL80211_CMD_REQ_SET_REG                                 = C.NL80211_CMD_REQ_SET_REG
	NL80211_CMD_ROAM                                        = C.NL80211_CMD_ROAM
	NL80211_CMD_SCAN_ABORTED                                = C.NL80211_CMD_SCAN_ABORTED
	NL80211_CMD_SCHED_SCAN_RESULTS                          = C.NL80211_CMD_SCHED_SCAN_RESULTS
	NL80211_CMD_SCHED_SCAN_STOPPED                          = C.NL80211_CMD_SCHED_SCAN_STOPPED
	NL80211_CMD_SET_BEACON                                  = C.NL80211_CMD_SET_BEACON
	NL80211_CMD_SET_BSS                                     = C.NL80211_CMD_SET_BSS
	NL80211_CMD_SET_CHANNEL                                 = C.NL80211_CMD_SET_CHANNEL
	NL80211_CMD_SET_COALESCE                                = C.NL80211_CMD_SET_COALESCE
	NL80211_CMD_SET_CQM                                     = C.NL80211_CMD_SET_CQM
	NL80211_CMD_SET_INTERFACE                               = C.NL80211_CMD_SET_INTERFACE
	NL80211_CMD_SET_KEY                                     = C.NL80211_CMD_SET_KEY
	NL80211_CMD_SET_MAC_ACL                                 = C.NL80211_CMD_SET_MAC_ACL
	NL80211_CMD_SET_MCAST_RATE                              = C.NL80211_CMD_SET_MCAST_RATE
	NL80211_CMD_SET_MESH_CONFIG                             = C.NL80211_CMD_SET_MESH_CONFIG
	NL80211_CMD_SET_MESH_PARAMS                             = C.NL80211_CMD_SET_MESH_PARAMS
	NL80211_CMD_SET_MGMT_EXTRA_IE                           = C.NL80211_CMD_SET_MGMT_EXTRA_IE
	NL80211_CMD_SET_MPATH                                   = C.NL80211_CMD_SET_MPATH
	NL80211_CMD_SET_MULTICAST_TO_UNICAST                    = C.NL80211_CMD_SET_MULTICAST_TO_UNICAST
	NL80211_CMD_SET_NOACK_MAP                               = C.NL80211_CMD_SET_NOACK_MAP
	NL80211_CMD_SET_PMK                                     = C.NL80211_CMD_SET_PMK
	NL80211_CMD_SET_PMKSA                                   = C.NL80211_CMD_SET_PMKSA
	NL80211_CMD_SET_POWER_SAVE                              = C.NL80211_CMD_SET_POWER_SAVE
	NL80211_CMD_SET_QOS_MAP                                 = C.NL80211_CMD_SET_QOS_MAP
	NL80211_CMD_SET_REG                                     = C.NL80211_CMD_SET_REG
	NL80211_CMD_SET_REKEY_OFFLOAD                           = C.NL80211_CMD_SET_REKEY_OFFLOAD
	NL80211_CMD_SET_SAR_SPECS                               = C.NL80211_CMD_SET_SAR_SPECS
	NL80211_CMD_SET_STATION                                 = C.NL80211_CMD_SET_STATION
	NL80211_CMD_SET_TID_CONFIG                              = C.NL80211_CMD_SET_TID_CONFIG
	NL80211_CMD_SET_TX_BITRATE_MASK                         = C.NL80211_CMD_SET_TX_BITRATE_MASK
	NL80211_CMD_SET_WDS_PEER                                = C.NL80211_CMD_SET_WDS_PEER
	NL80211_CMD_SET_WIPHY                                   = C.NL80211_CMD_SET_WIPHY
	NL80211_CMD_SET_WIPHY_NETNS                             = C.NL80211_CMD_SET_WIPHY_NETNS
	NL80211_CMD_SET_WOWLAN                                  = C.NL80211_CMD_SET_WOWLAN
	NL80211_CMD_STA_OPMODE_CHANGED                          = C.NL80211_CMD_STA_OPMODE_CHANGED
	NL80211_CMD_START_AP                                    = C.NL80211_CMD_START_AP
	NL80211_CMD_START_NAN                                   = C.NL80211_CMD_START_NAN
	NL80211_CMD_START_P2P_DEVICE                            = C.NL80211_CMD_START_P2P_DEVICE
	NL80211_CMD_START_SCHED_SCAN                            = C.NL80211_CMD_START_SCHED_SCAN
	NL80211_CMD_STOP_AP                                     = C.NL80211_CMD_STOP_AP
	NL80211_CMD_STOP_NAN                                    = C.NL80211_CMD_STOP_NAN
	NL80211_CMD_STOP_P2P_DEVICE                             = C.NL80211_CMD_STOP_P2P_DEVICE
	NL80211_CMD_STOP_SCHED_SCAN                             = C.NL80211_CMD_STOP_SCHED_SCAN
	NL80211_CMD_TDLS_CANCEL_CHANNEL_SWITCH                  = C.NL80211_CMD_TDLS_CANCEL_CHANNEL_SWITCH
	NL80211_CMD_TDLS_CHANNEL_SWITCH                         = C.NL80211_CMD_TDLS_CHANNEL_SWITCH
	NL80211_CMD_TDLS_MGMT                                   = C.NL80211_CMD_TDLS_MGMT
	NL80211_CMD_TDLS_OPER                                   = C.NL80211_CMD_TDLS_OPER
	NL80211_CMD_TESTMODE                                    = C.NL80211_CMD_TESTMODE
	NL80211_CMD_TRIGGER_SCAN                                = C.NL80211_CMD_TRIGGER_SCAN
	NL80211_CMD_UNEXPECTED_4ADDR_FRAME                      = C.NL80211_CMD_UNEXPECTED_4ADDR_FRAME
	NL80211_CMD_UNEXPECTED_FRAME                            = C.NL80211_CMD_UNEXPECTED_FRAME
	NL80211_CMD_UNPROT_BEACON                               = C.NL80211_CMD_UNPROT_BEACON
	NL80211_CMD_UNPROT_DEAUTHENTICATE                       = C.NL80211_CMD_UNPROT_DEAUTHENTICATE
	NL80211_CMD_UNPROT_DISASSOCIATE                         = C.NL80211_CMD_UNPROT_DISASSOCIATE
	NL80211_CMD_UNSPEC                                      = C.NL80211_CMD_UNSPEC
	NL80211_CMD_UPDATE_CONNECT_PARAMS                       = C.NL80211_CMD_UPDATE_CONNECT_PARAMS
	NL80211_CMD_UPDATE_FT_IES                               = C.NL80211_CMD_UPDATE_FT_IES
	NL80211_CMD_UPDATE_OWE_INFO                             = C.NL80211_CMD_UPDATE_OWE_INFO
	NL80211_CMD_VENDOR                                      = C.NL80211_CMD_VENDOR
	NL80211_CMD_WIPHY_REG_CHANGE                            = C.NL80211_CMD_WIPHY_REG_CHANGE
	NL80211_COALESCE_CONDITION_MATCH                        = C.NL80211_COALESCE_CONDITION_MATCH
	NL80211_COALESCE_CONDITION_NO_MATCH                     = C.NL80211_COALESCE_CONDITION_NO_MATCH
	NL80211_CONN_FAIL_BLOCKED_CLIENT                        = C.NL80211_CONN_FAIL_BLOCKED_CLIENT
	NL80211_CONN_FAIL_MAX_CLIENTS                           = C.NL80211_CONN_FAIL_MAX_CLIENTS
	NL80211_CQM_RSSI_BEACON_LOSS_EVENT                      = C.NL80211_CQM_RSSI_BEACON_LOSS_EVENT
	NL80211_CQM_RSSI_THRESHOLD_EVENT_HIGH                   = C.NL80211_CQM_RSSI_THRESHOLD_EVENT_HIGH
	NL80211_CQM_RSSI_THRESHOLD_EVENT_LOW                    = C.NL80211_CQM_RSSI_THRESHOLD_EVENT_LOW
	NL80211_CQM_TXE_MAX_INTVL                               = C.NL80211_CQM_TXE_MAX_INTVL
	NL80211_CRIT_PROTO_APIPA                                = C.NL80211_CRIT_PROTO_APIPA
	NL80211_CRIT_PROTO_DHCP                                 = C.NL80211_CRIT_PROTO_DHCP
	NL80211_CRIT_PROTO_EAPOL                                = C.NL80211_CRIT_PROTO_EAPOL
	NL80211_CRIT_PROTO_MAX_DURATION                         = C.NL80211_CRIT_PROTO_MAX_DURATION
	NL80211_CRIT_PROTO_UNSPEC                               = C.NL80211_CRIT_PROTO_UNSPEC
	NL80211_DFS_AVAILABLE                                   = C.NL80211_DFS_AVAILABLE
	NL80211_DFS_ETSI                                        = C.NL80211_DFS_ETSI
	NL80211_DFS_FCC                                         = C.NL80211_DFS_FCC
	NL80211_DFS_JP                                          = C.NL80211_DFS_JP
	NL80211_DFS_UNAVAILABLE                                 = C.NL80211_DFS_UNAVAILABLE
	NL80211_DFS_UNSET                                       = C.NL80211_DFS_UNSET
	NL80211_DFS_USABLE                                      = C.NL80211_DFS_USABLE
	NL80211_EDMG_BW_CONFIG_MAX                              = C.NL80211_EDMG_BW_CONFIG_MAX
	NL80211_EDMG_BW_CONFIG_MIN                              = C.NL80211_EDMG_BW_CONFIG_MIN
	NL80211_EDMG_CHANNELS_MAX                               = C.NL80211_EDMG_CHANNELS_MAX
	NL80211_EDMG_CHANNELS_MIN                               = C.NL80211_EDMG_CHANNELS_MIN
	NL80211_EXTERNAL_AUTH_ABORT                             = C.NL80211_EXTERNAL_AUTH_ABORT
	NL80211_EXTERNAL_AUTH_START                             = C.NL80211_EXTERNAL_AUTH_START
	NL80211_EXT_FEATURE_4WAY_HANDSHAKE_AP_PSK               = C.NL80211_EXT_FEATURE_4WAY_HANDSHAKE_AP_PSK
	NL80211_EXT_FEATURE_4WAY_HANDSHAKE_STA_1X               = C.NL80211_EXT_FEATURE_4WAY_HANDSHAKE_STA_1X
	NL80211_EXT_FEATURE_4WAY_HANDSHAKE_STA_PSK              = C.NL80211_EXT_FEATURE_4WAY_HANDSHAKE_STA_PSK
	NL80211_EXT_FEATURE_ACCEPT_BCAST_PROBE_RESP             = C.NL80211_EXT_FEATURE_ACCEPT_BCAST_PROBE_RESP
	NL80211_EXT_FEATURE_ACK_SIGNAL_SUPPORT                  = C.NL80211_EXT_FEATURE_ACK_SIGNAL_SUPPORT
	NL80211_EXT_FEATURE_AIRTIME_FAIRNESS                    = C.NL80211_EXT_FEATURE_AIRTIME_FAIRNESS
	NL80211_EXT_FEATURE_AP_PMKSA_CACHING                    = C.NL80211_EXT_FEATURE_AP_PMKSA_CACHING
	NL80211_EXT_FEATURE_AQL                                 = C.NL80211_EXT_FEATURE_AQL
	NL80211_EXT_FEATURE_BEACON_PROTECTION_CLIENT            = C.NL80211_EXT_FEATURE_BEACON_PROTECTION_CLIENT
	NL80211_EXT_FEATURE_BEACON_PROTECTION                   = C.NL80211_EXT_FEATURE_BEACON_PROTECTION
	NL80211_EXT_FEATURE_BEACON_RATE_HE                      = C.NL80211_EXT_FEATURE_BEACON_RATE_HE
	NL80211_EXT_FEATURE_BEACON_RATE_HT                      = C.NL80211_EXT_FEATURE_BEACON_RATE_HT
	NL80211_EXT_FEATURE_BEACON_RATE_LEGACY                  = C.NL80211_EXT_FEATURE_BEACON_RATE_LEGACY
	NL80211_EXT_FEATURE_BEACON_RATE_VHT                     = C.NL80211_EXT_FEATURE_BEACON_RATE_VHT
	NL80211_EXT_FEATURE_BSS_PARENT_TSF                      = C.NL80211_EXT_FEATURE_BSS_PARENT_TSF
	NL80211_EXT_FEATURE_CAN_REPLACE_PTK0                    = C.NL80211_EXT_FEATURE_CAN_REPLACE_PTK0
	NL80211_EXT_FEATURE_CONTROL_PORT_NO_PREAUTH             = C.NL80211_EXT_FEATURE_CONTROL_PORT_NO_PREAUTH
	NL80211_EXT_FEATURE_CONTROL_PORT_OVER_NL80211           = C.NL80211_EXT_FEATURE_CONTROL_PORT_OVER_NL80211
	NL80211_EXT_FEATURE_CONTROL_PORT_OVER_NL80211_TX_STATUS = C.NL80211_EXT_FEATURE_CONTROL_PORT_OVER_NL80211_TX_STATUS
	NL80211_EXT_FEATURE_CQM_RSSI_LIST                       = C.NL80211_EXT_FEATURE_CQM_RSSI_LIST
	NL80211_EXT_FEATURE_DATA_ACK_SIGNAL_SUPPORT             = C.NL80211_EXT_FEATURE_DATA_ACK_SIGNAL_SUPPORT
	NL80211_EXT_FEATURE_DEL_IBSS_STA                        = C.NL80211_EXT_FEATURE_DEL_IBSS_STA
	NL80211_EXT_FEATURE_DFS_OFFLOAD                         = C.NL80211_EXT_FEATURE_DFS_OFFLOAD
	NL80211_EXT_FEATURE_ENABLE_FTM_RESPONDER                = C.NL80211_EXT_FEATURE_ENABLE_FTM_RESPONDER
	NL80211_EXT_FEATURE_EXT_KEY_ID                          = C.NL80211_EXT_FEATURE_EXT_KEY_ID
	NL80211_EXT_FEATURE_FILS_DISCOVERY                      = C.NL80211_EXT_FEATURE_FILS_DISCOVERY
	NL80211_EXT_FEATURE_FILS_MAX_CHANNEL_TIME               = C.NL80211_EXT_FEATURE_FILS_MAX_CHANNEL_TIME
	NL80211_EXT_FEATURE_FILS_SK_OFFLOAD                     = C.NL80211_EXT_FEATURE_FILS_SK_OFFLOAD
	NL80211_EXT_FEATURE_FILS_STA                            = C.NL80211_EXT_FEATURE_FILS_STA
	NL80211_EXT_FEATURE_HIGH_ACCURACY_SCAN                  = C.NL80211_EXT_FEATURE_HIGH_ACCURACY_SCAN
	NL80211_EXT_FEATURE_LOW_POWER_SCAN                      = C.NL80211_EXT_FEATURE_LOW_POWER_SCAN
	NL80211_EXT_FEATURE_LOW_SPAN_SCAN                       = C.NL80211_EXT_FEATURE_LOW_SPAN_SCAN
	NL80211_EXT_FEATURE_MFP_OPTIONAL                        = C.NL80211_EXT_FEATURE_MFP_OPTIONAL
	NL80211_EXT_FEATURE_MGMT_TX_RANDOM_TA                   = C.NL80211_EXT_FEATURE_MGMT_TX_RANDOM_TA
	NL80211_EXT_FEATURE_MGMT_TX_RANDOM_TA_CONNECTED         = C.NL80211_EXT_FEATURE_MGMT_TX_RANDOM_TA_CONNECTED
	NL80211_EXT_FEATURE_MULTICAST_REGISTRATIONS             = C.NL80211_EXT_FEATURE_MULTICAST_REGISTRATIONS
	NL80211_EXT_FEATURE_MU_MIMO_AIR_SNIFFER                 = C.NL80211_EXT_FEATURE_MU_MIMO_AIR_SNIFFER
	NL80211_EXT_FEATURE_OCE_PROBE_REQ_DEFERRAL_SUPPRESSION  = C.NL80211_EXT_FEATURE_OCE_PROBE_REQ_DEFERRAL_SUPPRESSION
	NL80211_EXT_FEATURE_OCE_PROBE_REQ_HIGH_TX_RATE          = C.NL80211_EXT_FEATURE_OCE_PROBE_REQ_HIGH_TX_RATE
	NL80211_EXT_FEATURE_OPERATING_CHANNEL_VALIDATION        = C.NL80211_EXT_FEATURE_OPERATING_CHANNEL_VALIDATION
	NL80211_EXT_FEATURE_PROTECTED_TWT                       = C.NL80211_EXT_FEATURE_PROTECTED_TWT
	NL80211_EXT_FEATURE_PROT_RANGE_NEGO_AND_MEASURE         = C.NL80211_EXT_FEATURE_PROT_RANGE_NEGO_AND_MEASURE
	NL80211_EXT_FEATURE_RRM                                 = C.NL80211_EXT_FEATURE_RRM
	NL80211_EXT_FEATURE_SAE_OFFLOAD_AP                      = C.NL80211_EXT_FEATURE_SAE_OFFLOAD_AP
	NL80211_EXT_FEATURE_SAE_OFFLOAD                         = C.NL80211_EXT_FEATURE_SAE_OFFLOAD
	NL80211_EXT_FEATURE_SCAN_FREQ_KHZ                       = C.NL80211_EXT_FEATURE_SCAN_FREQ_KHZ
	NL80211_EXT_FEATURE_SCAN_MIN_PREQ_CONTENT               = C.NL80211_EXT_FEATURE_SCAN_MIN_PREQ_CONTENT
	NL80211_EXT_FEATURE_SCAN_RANDOM_SN                      = C.NL80211_EXT_FEATURE_SCAN_RANDOM_SN
	NL80211_EXT_FEATURE_SCAN_START_TIME                     = C.NL80211_EXT_FEATURE_SCAN_START_TIME
	NL80211_EXT_FEATURE_SCHED_SCAN_BAND_SPECIFIC_RSSI_THOLD = C.NL80211_EXT_FEATURE_SCHED_SCAN_BAND_SPECIFIC_RSSI_THOLD
	NL80211_EXT_FEATURE_SCHED_SCAN_RELATIVE_RSSI            = C.NL80211_EXT_FEATURE_SCHED_SCAN_RELATIVE_RSSI
	NL80211_EXT_FEATURE_SECURE_LTF                          = C.NL80211_EXT_FEATURE_SECURE_LTF
	NL80211_EXT_FEATURE_SECURE_RTT                          = C.NL80211_EXT_FEATURE_SECURE_RTT
	NL80211_EXT_FEATURE_SET_SCAN_DWELL                      = C.NL80211_EXT_FEATURE_SET_SCAN_DWELL
	NL80211_EXT_FEATURE_STA_TX_PWR                          = C.NL80211_EXT_FEATURE_STA_TX_PWR
	NL80211_EXT_FEATURE_TXQS                                = C.NL80211_EXT_FEATURE_TXQS
	NL80211_EXT_FEATURE_UNSOL_BCAST_PROBE_RESP              = C.NL80211_EXT_FEATURE_UNSOL_BCAST_PROBE_RESP
	NL80211_EXT_FEATURE_VHT_IBSS                            = C.NL80211_EXT_FEATURE_VHT_IBSS
	NL80211_EXT_FEATURE_VLAN_OFFLOAD                        = C.NL80211_EXT_FEATURE_VLAN_OFFLOAD
	NL80211_FEATURE_ACKTO_ESTIMATION                        = C.NL80211_FEATURE_ACKTO_ESTIMATION
	NL80211_FEATURE_ACTIVE_MONITOR                          = C.NL80211_FEATURE_ACTIVE_MONITOR
	NL80211_FEATURE_ADVERTISE_CHAN_LIMITS                   = C.NL80211_FEATURE_ADVERTISE_CHAN_LIMITS
	NL80211_FEATURE_AP_MODE_CHAN_WIDTH_CHANGE               = C.NL80211_FEATURE_AP_MODE_CHAN_WIDTH_CHANGE
	NL80211_FEATURE_AP_SCAN                                 = C.NL80211_FEATURE_AP_SCAN
	NL80211_FEATURE_CELL_BASE_REG_HINTS                     = C.NL80211_FEATURE_CELL_BASE_REG_HINTS
	NL80211_FEATURE_DS_PARAM_SET_IE_IN_PROBES               = C.NL80211_FEATURE_DS_PARAM_SET_IE_IN_PROBES
	NL80211_FEATURE_DYNAMIC_SMPS                            = C.NL80211_FEATURE_DYNAMIC_SMPS
	NL80211_FEATURE_FULL_AP_CLIENT_STATE                    = C.NL80211_FEATURE_FULL_AP_CLIENT_STATE
	NL80211_FEATURE_HT_IBSS                                 = C.NL80211_FEATURE_HT_IBSS
	NL80211_FEATURE_INACTIVITY_TIMER                        = C.NL80211_FEATURE_INACTIVITY_TIMER
	NL80211_FEATURE_LOW_PRIORITY_SCAN                       = C.NL80211_FEATURE_LOW_PRIORITY_SCAN
	NL80211_FEATURE_MAC_ON_CREATE                           = C.NL80211_FEATURE_MAC_ON_CREATE
	NL80211_FEATURE_ND_RANDOM_MAC_ADDR                      = C.NL80211_FEATURE_ND_RANDOM_MAC_ADDR
	NL80211_FEATURE_NEED_OBSS_SCAN                          = C.NL80211_FEATURE_NEED_OBSS_SCAN
	NL80211_FEATURE_P2P_DEVICE_NEEDS_CHANNEL                = C.NL80211_FEATURE_P2P_DEVICE_NEEDS_CHANNEL
	NL80211_FEATURE_P2P_GO_CTWIN                            = C.NL80211_FEATURE_P2P_GO_CTWIN
	NL80211_FEATURE_P2P_GO_OPPPS                            = C.NL80211_FEATURE_P2P_GO_OPPPS
	NL80211_FEATURE_QUIET                                   = C.NL80211_FEATURE_QUIET
	NL80211_FEATURE_SAE                                     = C.NL80211_FEATURE_SAE
	NL80211_FEATURE_SCAN_FLUSH                              = C.NL80211_FEATURE_SCAN_FLUSH
	NL80211_FEATURE_SCAN_RANDOM_MAC_ADDR                    = C.NL80211_FEATURE_SCAN_RANDOM_MAC_ADDR
	NL80211_FEATURE_SCHED_SCAN_RANDOM_MAC_ADDR              = C.NL80211_FEATURE_SCHED_SCAN_RANDOM_MAC_ADDR
	NL80211_FEATURE_SK_TX_STATUS                            = C.NL80211_FEATURE_SK_TX_STATUS
	NL80211_FEATURE_STATIC_SMPS                             = C.NL80211_FEATURE_STATIC_SMPS
	NL80211_FEATURE_SUPPORTS_WMM_ADMISSION                  = C.NL80211_FEATURE_SUPPORTS_WMM_ADMISSION
	NL80211_FEATURE_TDLS_CHANNEL_SWITCH                     = C.NL80211_FEATURE_TDLS_CHANNEL_SWITCH
	NL80211_FEATURE_TX_POWER_INSERTION                      = C.NL80211_FEATURE_TX_POWER_INSERTION
	NL80211_FEATURE_USERSPACE_MPM                           = C.NL80211_FEATURE_USERSPACE_MPM
	NL80211_FEATURE_VIF_TXPOWER                             = C.NL80211_FEATURE_VIF_TXPOWER
	NL80211_FEATURE_WFA_TPC_IE_IN_PROBES                    = C.NL80211_FEATURE_WFA_TPC_IE_IN_PROBES
	NL80211_FILS_DISCOVERY_ATTR_INT_MAX                     = C.NL80211_FILS_DISCOVERY_ATTR_INT_MAX
	NL80211_FILS_DISCOVERY_ATTR_INT_MIN                     = C.NL80211_FILS_DISCOVERY_ATTR_INT_MIN
	NL80211_FILS_DISCOVERY_ATTR_MAX                         = C.NL80211_FILS_DISCOVERY_ATTR_MAX
	NL80211_FILS_DISCOVERY_ATTR_TMPL                        = C.NL80211_FILS_DISCOVERY_ATTR_TMPL
	NL80211_FILS_DISCOVERY_TMPL_MIN_LEN                     = C.NL80211_FILS_DISCOVERY_TMPL_MIN_LEN
	NL80211_FREQUENCY_ATTR_16MHZ                            = C.NL80211_FREQUENCY_ATTR_16MHZ
	NL80211_FREQUENCY_ATTR_1MHZ                             = C.NL80211_FREQUENCY_ATTR_1MHZ
	NL80211_FREQUENCY_ATTR_2MHZ                             = C.NL80211_FREQUENCY_ATTR_2MHZ
	NL80211_FREQUENCY_ATTR_4MHZ                             = C.NL80211_FREQUENCY_ATTR_4MHZ
	NL80211_FREQUENCY_ATTR_8MHZ                             = C.NL80211_FREQUENCY_ATTR_8MHZ
	NL80211_FREQUENCY_ATTR_DFS_CAC_TIME                     = C.NL80211_FREQUENCY_ATTR_DFS_CAC_TIME
	NL80211_FREQUENCY_ATTR_DFS_STATE                        = C.NL80211_FREQUENCY_ATTR_DFS_STATE
	NL80211_FREQUENCY_ATTR_DFS_TIME                         = C.NL80211_FREQUENCY_ATTR_DFS_TIME
	NL80211_FREQUENCY_ATTR_DISABLED                         = C.NL80211_FREQUENCY_ATTR_DISABLED
	NL80211_FREQUENCY_ATTR_FREQ                             = C.NL80211_FREQUENCY_ATTR_FREQ
	NL80211_FREQUENCY_ATTR_GO_CONCURRENT                    = C.NL80211_FREQUENCY_ATTR_GO_CONCURRENT
	NL80211_FREQUENCY_ATTR_INDOOR_ONLY                      = C.NL80211_FREQUENCY_ATTR_INDOOR_ONLY
	NL80211_FREQUENCY_ATTR_IR_CONCURRENT                    = C.NL80211_FREQUENCY_ATTR_IR_CONCURRENT
	NL80211_FREQUENCY_ATTR_MAX                              = C.NL80211_FREQUENCY_ATTR_MAX
	NL80211_FREQUENCY_ATTR_MAX_TX_POWER                     = C.NL80211_FREQUENCY_ATTR_MAX_TX_POWER
	NL80211_FREQUENCY_ATTR_NO_10MHZ                         = C.NL80211_FREQUENCY_ATTR_NO_10MHZ
	NL80211_FREQUENCY_ATTR_NO_160MHZ                        = C.NL80211_FREQUENCY_ATTR_NO_160MHZ
	NL80211_FREQUENCY_ATTR_NO_20MHZ                         = C.NL80211_FREQUENCY_ATTR_NO_20MHZ
	NL80211_FREQUENCY_ATTR_NO_80MHZ                         = C.NL80211_FREQUENCY_ATTR_NO_80MHZ
	NL80211_FREQUENCY_ATTR_NO_HE                            = C.NL80211_FREQUENCY_ATTR_NO_HE
	NL80211_FREQUENCY_ATTR_NO_HT40_MINUS                    = C.NL80211_FREQUENCY_ATTR_NO_HT40_MINUS
	NL80211_FREQUENCY_ATTR_NO_HT40_PLUS                     = C.NL80211_FREQUENCY_ATTR_NO_HT40_PLUS
	NL80211_FREQUENCY_ATTR_NO_IBSS                          = C.NL80211_FREQUENCY_ATTR_NO_IBSS
	NL80211_FREQUENCY_ATTR_NO_IR                            = C.NL80211_FREQUENCY_ATTR_NO_IR
	NL80211_FREQUENCY_ATTR_OFFSET                           = C.NL80211_FREQUENCY_ATTR_OFFSET
	NL80211_FREQUENCY_ATTR_PASSIVE_SCAN                     = C.NL80211_FREQUENCY_ATTR_PASSIVE_SCAN
	NL80211_FREQUENCY_ATTR_RADAR                            = C.NL80211_FREQUENCY_ATTR_RADAR
	NL80211_FREQUENCY_ATTR_WMM                              = C.NL80211_FREQUENCY_ATTR_WMM
	NL80211_FTM_RESP_ATTR_CIVICLOC                          = C.NL80211_FTM_RESP_ATTR_CIVICLOC
	NL80211_FTM_RESP_ATTR_ENABLED                           = C.NL80211_FTM_RESP_ATTR_ENABLED
	NL80211_FTM_RESP_ATTR_LCI                               = C.NL80211_FTM_RESP_ATTR_LCI
	NL80211_FTM_RESP_ATTR_MAX                               = C.NL80211_FTM_RESP_ATTR_MAX
	NL80211_FTM_STATS_ASAP_NUM                              = C.NL80211_FTM_STATS_ASAP_NUM
	NL80211_FTM_STATS_FAILED_NUM                            = C.NL80211_FTM_STATS_FAILED_NUM
	NL80211_FTM_STATS_MAX                                   = C.NL80211_FTM_STATS_MAX
	NL80211_FTM_STATS_NON_ASAP_NUM                          = C.NL80211_FTM_STATS_NON_ASAP_NUM
	NL80211_FTM_STATS_OUT_OF_WINDOW_TRIGGERS_NUM            = C.NL80211_FTM_STATS_OUT_OF_WINDOW_TRIGGERS_NUM
	NL80211_FTM_STATS_PAD                                   = C.NL80211_FTM_STATS_PAD
	NL80211_FTM_STATS_PARTIAL_NUM                           = C.NL80211_FTM_STATS_PARTIAL_NUM
	NL80211_FTM_STATS_RESCHEDULE_REQUESTS_NUM               = C.NL80211_FTM_STATS_RESCHEDULE_REQUESTS_NUM
	NL80211_FTM_STATS_SUCCESS_NUM                           = C.NL80211_FTM_STATS_SUCCESS_NUM
	NL80211_FTM_STATS_TOTAL_DURATION_MSEC                   = C.NL80211_FTM_STATS_TOTAL_DURATION_MSEC
	NL80211_FTM_STATS_UNKNOWN_TRIGGERS_NUM                  = C.NL80211_FTM_STATS_UNKNOWN_TRIGGERS_NUM
	NL80211_GENL_NAME                                       = C.NL80211_GENL_NAME
	NL80211_HE_BSS_COLOR_ATTR_COLOR                         = C.NL80211_HE_BSS_COLOR_ATTR_COLOR
	NL80211_HE_BSS_COLOR_ATTR_DISABLED                      = C.NL80211_HE_BSS_COLOR_ATTR_DISABLED
	NL80211_HE_BSS_COLOR_ATTR_MAX                           = C.NL80211_HE_BSS_COLOR_ATTR_MAX
	NL80211_HE_BSS_COLOR_ATTR_PARTIAL                       = C.NL80211_HE_BSS_COLOR_ATTR_PARTIAL
	NL80211_HE_MAX_CAPABILITY_LEN                           = C.NL80211_HE_MAX_CAPABILITY_LEN
	NL80211_HE_MIN_CAPABILITY_LEN                           = C.NL80211_HE_MIN_CAPABILITY_LEN
	NL80211_HE_NSS_MAX                                      = C.NL80211_HE_NSS_MAX
	NL80211_HE_OBSS_PD_ATTR_BSS_COLOR_BITMAP                = C.NL80211_HE_OBSS_PD_ATTR_BSS_COLOR_BITMAP
	NL80211_HE_OBSS_PD_ATTR_MAX                             = C.NL80211_HE_OBSS_PD_ATTR_MAX
	NL80211_HE_OBSS_PD_ATTR_MAX_OFFSET                      = C.NL80211_HE_OBSS_PD_ATTR_MAX_OFFSET
	NL80211_HE_OBSS_PD_ATTR_MIN_OFFSET                      = C.NL80211_HE_OBSS_PD_ATTR_MIN_OFFSET
	NL80211_HE_OBSS_PD_ATTR_NON_SRG_MAX_OFFSET              = C.NL80211_HE_OBSS_PD_ATTR_NON_SRG_MAX_OFFSET
	NL80211_HE_OBSS_PD_ATTR_PARTIAL_BSSID_BITMAP            = C.NL80211_HE_OBSS_PD_ATTR_PARTIAL_BSSID_BITMAP
	NL80211_HE_OBSS_PD_ATTR_SR_CTRL                         = C.NL80211_HE_OBSS_PD_ATTR_SR_CTRL
	NL80211_HIDDEN_SSID_NOT_IN_USE                          = C.NL80211_HIDDEN_SSID_NOT_IN_USE
	NL80211_HIDDEN_SSID_ZERO_CONTENTS                       = C.NL80211_HIDDEN_SSID_ZERO_CONTENTS
	NL80211_HIDDEN_SSID_ZERO_LEN                            = C.NL80211_HIDDEN_SSID_ZERO_LEN
	NL80211_HT_CAPABILITY_LEN                               = C.NL80211_HT_CAPABILITY_LEN
	NL80211_IFACE_COMB_BI_MIN_GCD                           = C.NL80211_IFACE_COMB_BI_MIN_GCD
	NL80211_IFACE_COMB_LIMITS                               = C.NL80211_IFACE_COMB_LIMITS
	NL80211_IFACE_COMB_MAXNUM                               = C.NL80211_IFACE_COMB_MAXNUM
	NL80211_IFACE_COMB_NUM_CHANNELS                         = C.NL80211_IFACE_COMB_NUM_CHANNELS
	NL80211_IFACE_COMB_RADAR_DETECT_REGIONS                 = C.NL80211_IFACE_COMB_RADAR_DETECT_REGIONS
	NL80211_IFACE_COMB_RADAR_DETECT_WIDTHS                  = C.NL80211_IFACE_COMB_RADAR_DETECT_WIDTHS
	NL80211_IFACE_COMB_STA_AP_BI_MATCH                      = C.NL80211_IFACE_COMB_STA_AP_BI_MATCH
	NL80211_IFACE_COMB_UNSPEC                               = C.NL80211_IFACE_COMB_UNSPEC
	NL80211_IFACE_LIMIT_MAX                                 = C.NL80211_IFACE_LIMIT_MAX
	NL80211_IFACE_LIMIT_TYPES                               = C.NL80211_IFACE_LIMIT_TYPES
	NL80211_IFACE_LIMIT_UNSPEC                              = C.NL80211_IFACE_LIMIT_UNSPEC
	NL80211_IFTYPE_ADHOC                                    = C.NL80211_IFTYPE_ADHOC
	NL80211_IFTYPE_AKM_ATTR_IFTYPES                         = C.NL80211_IFTYPE_AKM_ATTR_IFTYPES
	NL80211_IFTYPE_AKM_ATTR_MAX                             = C.NL80211_IFTYPE_AKM_ATTR_MAX
	NL80211_IFTYPE_AKM_ATTR_SUITES                          = C.NL80211_IFTYPE_AKM_ATTR_SUITES
	NL80211_IFTYPE_AP                                       = C.NL80211_IFTYPE_AP
	NL80211_IFTYPE_AP_VLAN                                  = C.NL80211_IFTYPE_AP_VLAN
	NL80211_IFTYPE_MAX                                      = C.NL80211_IFTYPE_MAX
	NL80211_IFTYPE_MESH_POINT                               = C.NL80211_IFTYPE_MESH_POINT
	NL80211_IFTYPE_MONITOR                                  = C.NL80211_IFTYPE_MONITOR
	NL80211_IFTYPE_NAN                                      = C.NL80211_IFTYPE_NAN
	NL80211_IFTYPE_OCB                                      = C.NL80211_IFTYPE_OCB
	NL80211_IFTYPE_P2P_CLIENT                               = C.NL80211_IFTYPE_P2P_CLIENT
	NL80211_IFTYPE_P2P_DEVICE                               = C.NL80211_IFTYPE_P2P_DEVICE
	NL80211_IFTYPE_P2P_GO                                   = C.NL80211_IFTYPE_P2P_GO
	NL80211_IFTYPE_STATION                                  = C.NL80211_IFTYPE_STATION
	NL80211_IFTYPE_UNSPECIFIED                              = C.NL80211_IFTYPE_UNSPECIFIED
	NL80211_IFTYPE_WDS                                      = C.NL80211_IFTYPE_WDS
	NL80211_KCK_EXT_LEN                                     = C.NL80211_KCK_EXT_LEN
	NL80211_KCK_LEN                                         = C.NL80211_KCK_LEN
	NL80211_KEK_EXT_LEN                                     = C.NL80211_KEK_EXT_LEN
	NL80211_KEK_LEN                                         = C.NL80211_KEK_LEN
	NL80211_KEY_CIPHER                                      = C.NL80211_KEY_CIPHER
	NL80211_KEY_DATA                                        = C.NL80211_KEY_DATA
	NL80211_KEY_DEFAULT_BEACON                              = C.NL80211_KEY_DEFAULT_BEACON
	NL80211_KEY_DEFAULT                                     = C.NL80211_KEY_DEFAULT
	NL80211_KEY_DEFAULT_MGMT                                = C.NL80211_KEY_DEFAULT_MGMT
	NL80211_KEY_DEFAULT_TYPE_MULTICAST                      = C.NL80211_KEY_DEFAULT_TYPE_MULTICAST
	NL80211_KEY_DEFAULT_TYPES                               = C.NL80211_KEY_DEFAULT_TYPES
	NL80211_KEY_DEFAULT_TYPE_UNICAST                        = C.NL80211_KEY_DEFAULT_TYPE_UNICAST
	NL80211_KEY_IDX                                         = C.NL80211_KEY_IDX
	NL80211_KEY_MAX                                         = C.NL80211_KEY_MAX
	NL80211_KEY_MODE                                        = C.NL80211_KEY_MODE
	NL80211_KEY_NO_TX                                       = C.NL80211_KEY_NO_TX
	NL80211_KEY_RX_TX                                       = C.NL80211_KEY_RX_TX
	NL80211_KEY_SEQ                                         = C.NL80211_KEY_SEQ
	NL80211_KEY_SET_TX                                      = C.NL80211_KEY_SET_TX
	NL80211_KEY_TYPE                                        = C.NL80211_KEY_TYPE
	NL80211_KEYTYPE_GROUP                                   = C.NL80211_KEYTYPE_GROUP
	NL80211_KEYTYPE_PAIRWISE                                = C.NL80211_KEYTYPE_PAIRWISE
	NL80211_KEYTYPE_PEERKEY                                 = C.NL80211_KEYTYPE_PEERKEY
	NL80211_MAX_NR_AKM_SUITES                               = C.NL80211_MAX_NR_AKM_SUITES
	NL80211_MAX_NR_CIPHER_SUITES                            = C.NL80211_MAX_NR_CIPHER_SUITES
	NL80211_MAX_SUPP_HT_RATES                               = C.NL80211_MAX_SUPP_HT_RATES
	NL80211_MAX_SUPP_RATES                                  = C.NL80211_MAX_SUPP_RATES
	NL80211_MAX_SUPP_REG_RULES                              = C.NL80211_MAX_SUPP_REG_RULES
	NL80211_MESHCONF_ATTR_MAX                               = C.NL80211_MESHCONF_ATTR_MAX
	NL80211_MESHCONF_AUTO_OPEN_PLINKS                       = C.NL80211_MESHCONF_AUTO_OPEN_PLINKS
	NL80211_MESHCONF_AWAKE_WINDOW                           = C.NL80211_MESHCONF_AWAKE_WINDOW
	NL80211_MESHCONF_CONFIRM_TIMEOUT                        = C.NL80211_MESHCONF_CONFIRM_TIMEOUT
	NL80211_MESHCONF_CONNECTED_TO_AS                        = C.NL80211_MESHCONF_CONNECTED_TO_AS
	NL80211_MESHCONF_CONNECTED_TO_GATE                      = C.NL80211_MESHCONF_CONNECTED_TO_GATE
	NL80211_MESHCONF_ELEMENT_TTL                            = C.NL80211_MESHCONF_ELEMENT_TTL
	NL80211_MESHCONF_FORWARDING                             = C.NL80211_MESHCONF_FORWARDING
	NL80211_MESHCONF_GATE_ANNOUNCEMENTS                     = C.NL80211_MESHCONF_GATE_ANNOUNCEMENTS
	NL80211_MESHCONF_HOLDING_TIMEOUT                        = C.NL80211_MESHCONF_HOLDING_TIMEOUT
	NL80211_MESHCONF_HT_OPMODE                              = C.NL80211_MESHCONF_HT_OPMODE
	NL80211_MESHCONF_HWMP_ACTIVE_PATH_TIMEOUT               = C.NL80211_MESHCONF_HWMP_ACTIVE_PATH_TIMEOUT
	NL80211_MESHCONF_HWMP_CONFIRMATION_INTERVAL             = C.NL80211_MESHCONF_HWMP_CONFIRMATION_INTERVAL
	NL80211_MESHCONF_HWMP_MAX_PREQ_RETRIES                  = C.NL80211_MESHCONF_HWMP_MAX_PREQ_RETRIES
	NL80211_MESHCONF_HWMP_NET_DIAM_TRVS_TIME                = C.NL80211_MESHCONF_HWMP_NET_DIAM_TRVS_TIME
	NL80211_MESHCONF_HWMP_PATH_TO_ROOT_TIMEOUT              = C.NL80211_MESHCONF_HWMP_PATH_TO_ROOT_TIMEOUT
	NL80211_MESHCONF_HWMP_PERR_MIN_INTERVAL                 = C.NL80211_MESHCONF_HWMP_PERR_MIN_INTERVAL
	NL80211_MESHCONF_HWMP_PREQ_MIN_INTERVAL                 = C.NL80211_MESHCONF_HWMP_PREQ_MIN_INTERVAL
	NL80211_MESHCONF_HWMP_RANN_INTERVAL                     = C.NL80211_MESHCONF_HWMP_RANN_INTERVAL
	NL80211_MESHCONF_HWMP_ROOT_INTERVAL                     = C.NL80211_MESHCONF_HWMP_ROOT_INTERVAL
	NL80211_MESHCONF_HWMP_ROOTMODE                          = C.NL80211_MESHCONF_HWMP_ROOTMODE
	NL80211_MESHCONF_MAX_PEER_LINKS                         = C.NL80211_MESHCONF_MAX_PEER_LINKS
	NL80211_MESHCONF_MAX_RETRIES                            = C.NL80211_MESHCONF_MAX_RETRIES
	NL80211_MESHCONF_MIN_DISCOVERY_TIMEOUT                  = C.NL80211_MESHCONF_MIN_DISCOVERY_TIMEOUT
	NL80211_MESHCONF_NOLEARN                                = C.NL80211_MESHCONF_NOLEARN
	NL80211_MESHCONF_PATH_REFRESH_TIME                      = C.NL80211_MESHCONF_PATH_REFRESH_TIME
	NL80211_MESHCONF_PLINK_TIMEOUT                          = C.NL80211_MESHCONF_PLINK_TIMEOUT
	NL80211_MESHCONF_POWER_MODE                             = C.NL80211_MESHCONF_POWER_MODE
	NL80211_MESHCONF_RETRY_TIMEOUT                          = C.NL80211_MESHCONF_RETRY_TIMEOUT
	NL80211_MESHCONF_RSSI_THRESHOLD                         = C.NL80211_MESHCONF_RSSI_THRESHOLD
	NL80211_MESHCONF_SYNC_OFFSET_MAX_NEIGHBOR               = C.NL80211_MESHCONF_SYNC_OFFSET_MAX_NEIGHBOR
	NL80211_MESHCONF_TTL                                    = C.NL80211_MESHCONF_TTL
	NL80211_MESH_POWER_ACTIVE                               = C.NL80211_MESH_POWER_ACTIVE
	NL80211_MESH_POWER_DEEP_SLEEP                           = C.NL80211_MESH_POWER_DEEP_SLEEP
	NL80211_MESH_POWER_LIGHT_SLEEP                          = C.NL80211_MESH_POWER_LIGHT_SLEEP
	NL80211_MESH_POWER_MAX                                  = C.NL80211_MESH_POWER_MAX
	NL80211_MESH_POWER_UNKNOWN                              = C.NL80211_MESH_POWER_UNKNOWN
	NL80211_MESH_SETUP_ATTR_MAX                             = C.NL80211_MESH_SETUP_ATTR_MAX
	NL80211_MESH_SETUP_AUTH_PROTOCOL                        = C.NL80211_MESH_SETUP_AUTH_PROTOCOL
	NL80211_MESH_SETUP_ENABLE_VENDOR_METRIC                 = C.NL80211_MESH_SETUP_ENABLE_VENDOR_METRIC
	NL80211_MESH_SETUP_ENABLE_VENDOR_PATH_SEL               = C.NL80211_MESH_SETUP_ENABLE_VENDOR_PATH_SEL
	NL80211_MESH_SETUP_ENABLE_VENDOR_SYNC                   = C.NL80211_MESH_SETUP_ENABLE_VENDOR_SYNC
	NL80211_MESH_SETUP_IE                                   = C.NL80211_MESH_SETUP_IE
	NL80211_MESH_SETUP_USERSPACE_AMPE                       = C.NL80211_MESH_SETUP_USERSPACE_AMPE
	NL80211_MESH_SETUP_USERSPACE_AUTH                       = C.NL80211_MESH_SETUP_USERSPACE_AUTH
	NL80211_MESH_SETUP_USERSPACE_MPM                        = C.NL80211_MESH_SETUP_USERSPACE_MPM
	NL80211_MESH_SETUP_VENDOR_PATH_SEL_IE                   = C.NL80211_MESH_SETUP_VENDOR_PATH_SEL_IE
	NL80211_MFP_NO                                          = C.NL80211_MFP_NO
	NL80211_MFP_OPTIONAL                                    = C.NL80211_MFP_OPTIONAL
	NL80211_MFP_REQUIRED                                    = C.NL80211_MFP_REQUIRED
	NL80211_MIN_REMAIN_ON_CHANNEL_TIME                      = C.NL80211_MIN_REMAIN_ON_CHANNEL_TIME
	NL80211_MNTR_FLAG_ACTIVE                                = C.NL80211_MNTR_FLAG_ACTIVE
	NL80211_MNTR_FLAG_CONTROL                               = C.NL80211_MNTR_FLAG_CONTROL
	NL80211_MNTR_FLAG_COOK_FRAMES                           = C.NL80211_MNTR_FLAG_COOK_FRAMES
	NL80211_MNTR_FLAG_FCSFAIL                               = C.NL80211_MNTR_FLAG_FCSFAIL
	NL80211_MNTR_FLAG_MAX                                   = C.NL80211_MNTR_FLAG_MAX
	NL80211_MNTR_FLAG_OTHER_BSS                             = C.NL80211_MNTR_FLAG_OTHER_BSS
	NL80211_MNTR_FLAG_PLCPFAIL                              = C.NL80211_MNTR_FLAG_PLCPFAIL
	NL80211_MPATH_FLAG_ACTIVE                               = C.NL80211_MPATH_FLAG_ACTIVE
	NL80211_MPATH_FLAG_FIXED                                = C.NL80211_MPATH_FLAG_FIXED
	NL80211_MPATH_FLAG_RESOLVED                             = C.NL80211_MPATH_FLAG_RESOLVED
	NL80211_MPATH_FLAG_RESOLVING                            = C.NL80211_MPATH_FLAG_RESOLVING
	NL80211_MPATH_FLAG_SN_VALID                             = C.NL80211_MPATH_FLAG_SN_VALID
	NL80211_MPATH_INFO_DISCOVERY_RETRIES                    = C.NL80211_MPATH_INFO_DISCOVERY_RETRIES
	NL80211_MPATH_INFO_DISCOVERY_TIMEOUT                    = C.NL80211_MPATH_INFO_DISCOVERY_TIMEOUT
	NL80211_MPATH_INFO_EXPTIME                              = C.NL80211_MPATH_INFO_EXPTIME
	NL80211_MPATH_INFO_FLAGS                                = C.NL80211_MPATH_INFO_FLAGS
	NL80211_MPATH_INFO_FRAME_QLEN                           = C.NL80211_MPATH_INFO_FRAME_QLEN
	NL80211_MPATH_INFO_HOP_COUNT                            = C.NL80211_MPATH_INFO_HOP_COUNT
	NL80211_MPATH_INFO_MAX                                  = C.NL80211_MPATH_INFO_MAX
	NL80211_MPATH_INFO_METRIC                               = C.NL80211_MPATH_INFO_METRIC
	NL80211_MPATH_INFO_PATH_CHANGE                          = C.NL80211_MPATH_INFO_PATH_CHANGE
	NL80211_MPATH_INFO_SN                                   = C.NL80211_MPATH_INFO_SN
	NL80211_MULTICAST_GROUP_CONFIG                          = C.NL80211_MULTICAST_GROUP_CONFIG
	NL80211_MULTICAST_GROUP_MLME                            = C.NL80211_MULTICAST_GROUP_MLME
	NL80211_MULTICAST_GROUP_NAN                             = C.NL80211_MULTICAST_GROUP_NAN
	NL80211_MULTICAST_GROUP_REG                             = C.NL80211_MULTICAST_GROUP_REG
	NL80211_MULTICAST_GROUP_SCAN                            = C.NL80211_MULTICAST_GROUP_SCAN
	NL80211_MULTICAST_GROUP_TESTMODE                        = C.NL80211_MULTICAST_GROUP_TESTMODE
	NL80211_MULTICAST_GROUP_VENDOR                          = C.NL80211_MULTICAST_GROUP_VENDOR
	NL80211_NAN_FUNC_ATTR_MAX                               = C.NL80211_NAN_FUNC_ATTR_MAX
	NL80211_NAN_FUNC_CLOSE_RANGE                            = C.NL80211_NAN_FUNC_CLOSE_RANGE
	NL80211_NAN_FUNC_FOLLOW_UP                              = C.NL80211_NAN_FUNC_FOLLOW_UP
	NL80211_NAN_FUNC_FOLLOW_UP_DEST                         = C.NL80211_NAN_FUNC_FOLLOW_UP_DEST
	NL80211_NAN_FUNC_FOLLOW_UP_ID                           = C.NL80211_NAN_FUNC_FOLLOW_UP_ID
	NL80211_NAN_FUNC_FOLLOW_UP_REQ_ID                       = C.NL80211_NAN_FUNC_FOLLOW_UP_REQ_ID
	NL80211_NAN_FUNC_INSTANCE_ID                            = C.NL80211_NAN_FUNC_INSTANCE_ID
	NL80211_NAN_FUNC_MAX_TYPE                               = C.NL80211_NAN_FUNC_MAX_TYPE
	NL80211_NAN_FUNC_PUBLISH_BCAST                          = C.NL80211_NAN_FUNC_PUBLISH_BCAST
	NL80211_NAN_FUNC_PUBLISH                                = C.NL80211_NAN_FUNC_PUBLISH
	NL80211_NAN_FUNC_PUBLISH_TYPE                           = C.NL80211_NAN_FUNC_PUBLISH_TYPE
	NL80211_NAN_FUNC_RX_MATCH_FILTER                        = C.NL80211_NAN_FUNC_RX_MATCH_FILTER
	NL80211_NAN_FUNC_SERVICE_ID                             = C.NL80211_NAN_FUNC_SERVICE_ID
	NL80211_NAN_FUNC_SERVICE_ID_LEN                         = C.NL80211_NAN_FUNC_SERVICE_ID_LEN
	NL80211_NAN_FUNC_SERVICE_INFO                           = C.NL80211_NAN_FUNC_SERVICE_INFO
	NL80211_NAN_FUNC_SERVICE_SPEC_INFO_MAX_LEN              = C.NL80211_NAN_FUNC_SERVICE_SPEC_INFO_MAX_LEN
	NL80211_NAN_FUNC_SRF                                    = C.NL80211_NAN_FUNC_SRF
	NL80211_NAN_FUNC_SRF_MAX_LEN                            = C.NL80211_NAN_FUNC_SRF_MAX_LEN
	NL80211_NAN_FUNC_SUBSCRIBE_ACTIVE                       = C.NL80211_NAN_FUNC_SUBSCRIBE_ACTIVE
	NL80211_NAN_FUNC_SUBSCRIBE                              = C.NL80211_NAN_FUNC_SUBSCRIBE
	NL80211_NAN_FUNC_TERM_REASON                            = C.NL80211_NAN_FUNC_TERM_REASON
	NL80211_NAN_FUNC_TERM_REASON_ERROR                      = C.NL80211_NAN_FUNC_TERM_REASON_ERROR
	NL80211_NAN_FUNC_TERM_REASON_TTL_EXPIRED                = C.NL80211_NAN_FUNC_TERM_REASON_TTL_EXPIRED
	NL80211_NAN_FUNC_TERM_REASON_USER_REQUEST               = C.NL80211_NAN_FUNC_TERM_REASON_USER_REQUEST
	NL80211_NAN_FUNC_TTL                                    = C.NL80211_NAN_FUNC_TTL
	NL80211_NAN_FUNC_TX_MATCH_FILTER                        = C.NL80211_NAN_FUNC_TX_MATCH_FILTER
	NL80211_NAN_FUNC_TYPE                                   = C.NL80211_NAN_FUNC_TYPE
	NL80211_NAN_MATCH_ATTR_MAX                              = C.NL80211_NAN_MATCH_ATTR_MAX
	NL80211_NAN_MATCH_FUNC_LOCAL                            = C.NL80211_NAN_MATCH_FUNC_LOCAL
	NL80211_NAN_MATCH_FUNC_PEER                             = C.NL80211_NAN_MATCH_FUNC_PEER
	NL80211_NAN_SOLICITED_PUBLISH                           = C.NL80211_NAN_SOLICITED_PUBLISH
	NL80211_NAN_SRF_ATTR_MAX                                = C.NL80211_NAN_SRF_ATTR_MAX
	NL80211_NAN_SRF_BF                                      = C.NL80211_NAN_SRF_BF
	NL80211_NAN_SRF_BF_IDX                                  = C.NL80211_NAN_SRF_BF_IDX
	NL80211_NAN_SRF_INCLUDE                                 = C.NL80211_NAN_SRF_INCLUDE
	NL80211_NAN_SRF_MAC_ADDRS                               = C.NL80211_NAN_SRF_MAC_ADDRS
	NL80211_NAN_UNSOLICITED_PUBLISH                         = C.NL80211_NAN_UNSOLICITED_PUBLISH
	NL80211_NUM_ACS                                         = C.NL80211_NUM_ACS
	NL80211_P2P_PS_SUPPORTED                                = C.NL80211_P2P_PS_SUPPORTED
	NL80211_P2P_PS_UNSUPPORTED                              = C.NL80211_P2P_PS_UNSUPPORTED
	NL80211_PKTPAT_MASK                                     = C.NL80211_PKTPAT_MASK
	NL80211_PKTPAT_OFFSET                                   = C.NL80211_PKTPAT_OFFSET
	NL80211_PKTPAT_PATTERN                                  = C.NL80211_PKTPAT_PATTERN
	NL80211_PLINK_ACTION_BLOCK                              = C.NL80211_PLINK_ACTION_BLOCK
	NL80211_PLINK_ACTION_NO_ACTION                          = C.NL80211_PLINK_ACTION_NO_ACTION
	NL80211_PLINK_ACTION_OPEN                               = C.NL80211_PLINK_ACTION_OPEN
	NL80211_PLINK_BLOCKED                                   = C.NL80211_PLINK_BLOCKED
	NL80211_PLINK_CNF_RCVD                                  = C.NL80211_PLINK_CNF_RCVD
	NL80211_PLINK_ESTAB                                     = C.NL80211_PLINK_ESTAB
	NL80211_PLINK_HOLDING                                   = C.NL80211_PLINK_HOLDING
	NL80211_PLINK_LISTEN                                    = C.NL80211_PLINK_LISTEN
	NL80211_PLINK_OPN_RCVD                                  = C.NL80211_PLINK_OPN_RCVD
	NL80211_PLINK_OPN_SNT                                   = C.NL80211_PLINK_OPN_SNT
	NL80211_PMKSA_CANDIDATE_BSSID                           = C.NL80211_PMKSA_CANDIDATE_BSSID
	NL80211_PMKSA_CANDIDATE_INDEX                           = C.NL80211_PMKSA_CANDIDATE_INDEX
	NL80211_PMKSA_CANDIDATE_PREAUTH                         = C.NL80211_PMKSA_CANDIDATE_PREAUTH
	NL80211_PMSR_ATTR_MAX                                   = C.NL80211_PMSR_ATTR_MAX
	NL80211_PMSR_ATTR_MAX_PEERS                             = C.NL80211_PMSR_ATTR_MAX_PEERS
	NL80211_PMSR_ATTR_PEERS                                 = C.NL80211_PMSR_ATTR_PEERS
	NL80211_PMSR_ATTR_RANDOMIZE_MAC_ADDR                    = C.NL80211_PMSR_ATTR_RANDOMIZE_MAC_ADDR
	NL80211_PMSR_ATTR_REPORT_AP_TSF                         = C.NL80211_PMSR_ATTR_REPORT_AP_TSF
	NL80211_PMSR_ATTR_TYPE_CAPA                             = C.NL80211_PMSR_ATTR_TYPE_CAPA
	NL80211_PMSR_FTM_CAPA_ATTR_ASAP                         = C.NL80211_PMSR_FTM_CAPA_ATTR_ASAP
	NL80211_PMSR_FTM_CAPA_ATTR_BANDWIDTHS                   = C.NL80211_PMSR_FTM_CAPA_ATTR_BANDWIDTHS
	NL80211_PMSR_FTM_CAPA_ATTR_MAX_BURSTS_EXPONENT          = C.NL80211_PMSR_FTM_CAPA_ATTR_MAX_BURSTS_EXPONENT
	NL80211_PMSR_FTM_CAPA_ATTR_MAX                          = C.NL80211_PMSR_FTM_CAPA_ATTR_MAX
	NL80211_PMSR_FTM_CAPA_ATTR_MAX_FTMS_PER_BURST           = C.NL80211_PMSR_FTM_CAPA_ATTR_MAX_FTMS_PER_BURST
	NL80211_PMSR_FTM_CAPA_ATTR_NON_ASAP                     = C.NL80211_PMSR_FTM_CAPA_ATTR_NON_ASAP
	NL80211_PMSR_FTM_CAPA_ATTR_NON_TRIGGER_BASED            = C.NL80211_PMSR_FTM_CAPA_ATTR_NON_TRIGGER_BASED
	NL80211_PMSR_FTM_CAPA_ATTR_PREAMBLES                    = C.NL80211_PMSR_FTM_CAPA_ATTR_PREAMBLES
	NL80211_PMSR_FTM_CAPA_ATTR_REQ_CIVICLOC                 = C.NL80211_PMSR_FTM_CAPA_ATTR_REQ_CIVICLOC
	NL80211_PMSR_FTM_CAPA_ATTR_REQ_LCI                      = C.NL80211_PMSR_FTM_CAPA_ATTR_REQ_LCI
	NL80211_PMSR_FTM_CAPA_ATTR_TRIGGER_BASED                = C.NL80211_PMSR_FTM_CAPA_ATTR_TRIGGER_BASED
	NL80211_PMSR_FTM_FAILURE_BAD_CHANGED_PARAMS             = C.NL80211_PMSR_FTM_FAILURE_BAD_CHANGED_PARAMS
	NL80211_PMSR_FTM_FAILURE_INVALID_TIMESTAMP              = C.NL80211_PMSR_FTM_FAILURE_INVALID_TIMESTAMP
	NL80211_PMSR_FTM_FAILURE_NO_RESPONSE                    = C.NL80211_PMSR_FTM_FAILURE_NO_RESPONSE
	NL80211_PMSR_FTM_FAILURE_PEER_BUSY                      = C.NL80211_PMSR_FTM_FAILURE_PEER_BUSY
	NL80211_PMSR_FTM_FAILURE_PEER_NOT_CAPABLE               = C.NL80211_PMSR_FTM_FAILURE_PEER_NOT_CAPABLE
	NL80211_PMSR_FTM_FAILURE_REJECTED                       = C.NL80211_PMSR_FTM_FAILURE_REJECTED
	NL80211_PMSR_FTM_FAILURE_UNSPECIFIED                    = C.NL80211_PMSR_FTM_FAILURE_UNSPECIFIED
	NL80211_PMSR_FTM_FAILURE_WRONG_CHANNEL                  = C.NL80211_PMSR_FTM_FAILURE_WRONG_CHANNEL
	NL80211_PMSR_FTM_REQ_ATTR_ASAP                          = C.NL80211_PMSR_FTM_REQ_ATTR_ASAP
	NL80211_PMSR_FTM_REQ_ATTR_BURST_DURATION                = C.NL80211_PMSR_FTM_REQ_ATTR_BURST_DURATION
	NL80211_PMSR_FTM_REQ_ATTR_BURST_PERIOD                  = C.NL80211_PMSR_FTM_REQ_ATTR_BURST_PERIOD
	NL80211_PMSR_FTM_REQ_ATTR_FTMS_PER_BURST                = C.NL80211_PMSR_FTM_REQ_ATTR_FTMS_PER_BURST
	NL80211_PMSR_FTM_REQ_ATTR_LMR_FEEDBACK                  = C.NL80211_PMSR_FTM_REQ_ATTR_LMR_FEEDBACK
	NL80211_PMSR_FTM_REQ_ATTR_MAX                           = C.NL80211_PMSR_FTM_REQ_ATTR_MAX
	NL80211_PMSR_FTM_REQ_ATTR_NON_TRIGGER_BASED             = C.NL80211_PMSR_FTM_REQ_ATTR_NON_TRIGGER_BASED
	NL80211_PMSR_FTM_REQ_ATTR_NUM_BURSTS_EXP                = C.NL80211_PMSR_FTM_REQ_ATTR_NUM_BURSTS_EXP
	NL80211_PMSR_FTM_REQ_ATTR_NUM_FTMR_RETRIES              = C.NL80211_PMSR_FTM_REQ_ATTR_NUM_FTMR_RETRIES
	NL80211_PMSR_FTM_REQ_ATTR_PREAMBLE                      = C.NL80211_PMSR_FTM_REQ_ATTR_PREAMBLE
	NL80211_PMSR_FTM_REQ_ATTR_REQUEST_CIVICLOC              = C.NL80211_PMSR_FTM_REQ_ATTR_REQUEST_CIVICLOC
	NL80211_PMSR_FTM_REQ_ATTR_REQUEST_LCI                   = C.NL80211_PMSR_FTM_REQ_ATTR_REQUEST_LCI
	NL80211_PMSR_FTM_REQ_ATTR_TRIGGER_BASED                 = C.NL80211_PMSR_FTM_REQ_ATTR_TRIGGER_BASED
	NL80211_PMSR_FTM_RESP_ATTR_BURST_DURATION               = C.NL80211_PMSR_FTM_RESP_ATTR_BURST_DURATION
	NL80211_PMSR_FTM_RESP_ATTR_BURST_INDEX                  = C.NL80211_PMSR_FTM_RESP_ATTR_BURST_INDEX
	NL80211_PMSR_FTM_RESP_ATTR_BUSY_RETRY_TIME              = C.NL80211_PMSR_FTM_RESP_ATTR_BUSY_RETRY_TIME
	NL80211_PMSR_FTM_RESP_ATTR_CIVICLOC                     = C.NL80211_PMSR_FTM_RESP_ATTR_CIVICLOC
	NL80211_PMSR_FTM_RESP_ATTR_DIST_AVG                     = C.NL80211_PMSR_FTM_RESP_ATTR_DIST_AVG
	NL80211_PMSR_FTM_RESP_ATTR_DIST_SPREAD                  = C.NL80211_PMSR_FTM_RESP_ATTR_DIST_SPREAD
	NL80211_PMSR_FTM_RESP_ATTR_DIST_VARIANCE                = C.NL80211_PMSR_FTM_RESP_ATTR_DIST_VARIANCE
	NL80211_PMSR_FTM_RESP_ATTR_FAIL_REASON                  = C.NL80211_PMSR_FTM_RESP_ATTR_FAIL_REASON
	NL80211_PMSR_FTM_RESP_ATTR_FTMS_PER_BURST               = C.NL80211_PMSR_FTM_RESP_ATTR_FTMS_PER_BURST
	NL80211_PMSR_FTM_RESP_ATTR_LCI                          = C.NL80211_PMSR_FTM_RESP_ATTR_LCI
	NL80211_PMSR_FTM_RESP_ATTR_MAX                          = C.NL80211_PMSR_FTM_RESP_ATTR_MAX
	NL80211_PMSR_FTM_RESP_ATTR_NUM_BURSTS_EXP               = C.NL80211_PMSR_FTM_RESP_ATTR_NUM_BURSTS_EXP
	NL80211_PMSR_FTM_RESP_ATTR_NUM_FTMR_ATTEMPTS            = C.NL80211_PMSR_FTM_RESP_ATTR_NUM_FTMR_ATTEMPTS
	NL80211_PMSR_FTM_RESP_ATTR_NUM_FTMR_SUCCESSES           = C.NL80211_PMSR_FTM_RESP_ATTR_NUM_FTMR_SUCCESSES
	NL80211_PMSR_FTM_RESP_ATTR_PAD                          = C.NL80211_PMSR_FTM_RESP_ATTR_PAD
	NL80211_PMSR_FTM_RESP_ATTR_RSSI_AVG                     = C.NL80211_PMSR_FTM_RESP_ATTR_RSSI_AVG
	NL80211_PMSR_FTM_RESP_ATTR_RSSI_SPREAD                  = C.NL80211_PMSR_FTM_RESP_ATTR_RSSI_SPREAD
	NL80211_PMSR_FTM_RESP_ATTR_RTT_AVG                      = C.NL80211_PMSR_FTM_RESP_ATTR_RTT_AVG
	NL80211_PMSR_FTM_RESP_ATTR_RTT_SPREAD                   = C.NL80211_PMSR_FTM_RESP_ATTR_RTT_SPREAD
	NL80211_PMSR_FTM_RESP_ATTR_RTT_VARIANCE                 = C.NL80211_PMSR_FTM_RESP_ATTR_RTT_VARIANCE
	NL80211_PMSR_FTM_RESP_ATTR_RX_RATE                      = C.NL80211_PMSR_FTM_RESP_ATTR_RX_RATE
	NL80211_PMSR_FTM_RESP_ATTR_TX_RATE                      = C.NL80211_PMSR_FTM_RESP_ATTR_TX_RATE
	NL80211_PMSR_PEER_ATTR_ADDR                             = C.NL80211_PMSR_PEER_ATTR_ADDR
	NL80211_PMSR_PEER_ATTR_CHAN                             = C.NL80211_PMSR_PEER_ATTR_CHAN
	NL80211_PMSR_PEER_ATTR_MAX                              = C.NL80211_PMSR_PEER_ATTR_MAX
	NL80211_PMSR_PEER_ATTR_REQ                              = C.NL80211_PMSR_PEER_ATTR_REQ
	NL80211_PMSR_PEER_ATTR_RESP                             = C.NL80211_PMSR_PEER_ATTR_RESP
	NL80211_PMSR_REQ_ATTR_DATA                              = C.NL80211_PMSR_REQ_ATTR_DATA
	NL80211_PMSR_REQ_ATTR_GET_AP_TSF                        = C.NL80211_PMSR_REQ_ATTR_GET_AP_TSF
	NL80211_PMSR_REQ_ATTR_MAX                               = C.NL80211_PMSR_REQ_ATTR_MAX
	NL80211_PMSR_RESP_ATTR_AP_TSF                           = C.NL80211_PMSR_RESP_ATTR_AP_TSF
	NL80211_PMSR_RESP_ATTR_DATA                             = C.NL80211_PMSR_RESP_ATTR_DATA
	NL80211_PMSR_RESP_ATTR_FINAL                            = C.NL80211_PMSR_RESP_ATTR_FINAL
	NL80211_PMSR_RESP_ATTR_HOST_TIME                        = C.NL80211_PMSR_RESP_ATTR_HOST_TIME
	NL80211_PMSR_RESP_ATTR_MAX                              = C.NL80211_PMSR_RESP_ATTR_MAX
	NL80211_PMSR_RESP_ATTR_PAD                              = C.NL80211_PMSR_RESP_ATTR_PAD
	NL80211_PMSR_RESP_ATTR_STATUS                           = C.NL80211_PMSR_RESP_ATTR_STATUS
	NL80211_PMSR_STATUS_FAILURE                             = C.NL80211_PMSR_STATUS_FAILURE
	NL80211_PMSR_STATUS_REFUSED                             = C.NL80211_PMSR_STATUS_REFUSED
	NL80211_PMSR_STATUS_SUCCESS                             = C.NL80211_PMSR_STATUS_SUCCESS
	NL80211_PMSR_STATUS_TIMEOUT                             = C.NL80211_PMSR_STATUS_TIMEOUT
	NL80211_PMSR_TYPE_FTM                                   = C.NL80211_PMSR_TYPE_FTM
	NL80211_PMSR_TYPE_INVALID                               = C.NL80211_PMSR_TYPE_INVALID
	NL80211_PMSR_TYPE_MAX                                   = C.NL80211_PMSR_TYPE_MAX
	NL80211_PREAMBLE_DMG                                    = C.NL80211_PREAMBLE_DMG
	NL80211_PREAMBLE_HE                                     = C.NL80211_PREAMBLE_HE
	NL80211_PREAMBLE_HT                                     = C.NL80211_PREAMBLE_HT
	NL80211_PREAMBLE_LEGACY                                 = C.NL80211_PREAMBLE_LEGACY
	NL80211_PREAMBLE_VHT                                    = C.NL80211_PREAMBLE_VHT
	NL80211_PROBE_RESP_OFFLOAD_SUPPORT_80211U               = C.NL80211_PROBE_RESP_OFFLOAD_SUPPORT_80211U
	NL80211_PROBE_RESP_OFFLOAD_SUPPORT_P2P                  = C.NL80211_PROBE_RESP_OFFLOAD_SUPPORT_P2P
	NL80211_PROBE_RESP_OFFLOAD_SUPPORT_WPS2                 = C.NL80211_PROBE_RESP_OFFLOAD_SUPPORT_WPS2
	NL80211_PROBE_RESP_OFFLOAD_SUPPORT_WPS                  = C.NL80211_PROBE_RESP_OFFLOAD_SUPPORT_WPS
	NL80211_PROTOCOL_FEATURE_SPLIT_WIPHY_DUMP               = C.NL80211_PROTOCOL_FEATURE_SPLIT_WIPHY_DUMP
	NL80211_PS_DISABLED                                     = C.NL80211_PS_DISABLED
	NL80211_PS_ENABLED                                      = C.NL80211_PS_ENABLED
	NL80211_RADAR_CAC_ABORTED                               = C.NL80211_RADAR_CAC_ABORTED
	NL80211_RADAR_CAC_FINISHED                              = C.NL80211_RADAR_CAC_FINISHED
	NL80211_RADAR_CAC_STARTED                               = C.NL80211_RADAR_CAC_STARTED
	NL80211_RADAR_DETECTED                                  = C.NL80211_RADAR_DETECTED
	NL80211_RADAR_NOP_FINISHED                              = C.NL80211_RADAR_NOP_FINISHED
	NL80211_RADAR_PRE_CAC_EXPIRED                           = C.NL80211_RADAR_PRE_CAC_EXPIRED
	NL80211_RATE_INFO_10_MHZ_WIDTH                          = C.NL80211_RATE_INFO_10_MHZ_WIDTH
	NL80211_RATE_INFO_160_MHZ_WIDTH                         = C.NL80211_RATE_INFO_160_MHZ_WIDTH
	NL80211_RATE_INFO_40_MHZ_WIDTH                          = C.NL80211_RATE_INFO_40_MHZ_WIDTH
	NL80211_RATE_INFO_5_MHZ_WIDTH                           = C.NL80211_RATE_INFO_5_MHZ_WIDTH
	NL80211_RATE_INFO_80_MHZ_WIDTH                          = C.NL80211_RATE_INFO_80_MHZ_WIDTH
	NL80211_RATE_INFO_80P80_MHZ_WIDTH                       = C.NL80211_RATE_INFO_80P80_MHZ_WIDTH
	NL80211_RATE_INFO_BITRATE32                             = C.NL80211_RATE_INFO_BITRATE32
	NL80211_RATE_INFO_BITRATE                               = C.NL80211_RATE_INFO_BITRATE
	NL80211_RATE_INFO_HE_1XLTF                              = C.NL80211_RATE_INFO_HE_1XLTF
	NL80211_RATE_INFO_HE_2XLTF                              = C.NL80211_RATE_INFO_HE_2XLTF
	NL80211_RATE_INFO_HE_4XLTF                              = C.NL80211_RATE_INFO_HE_4XLTF
	NL80211_RATE_INFO_HE_DCM                                = C.NL80211_RATE_INFO_HE_DCM
	NL80211_RATE_INFO_HE_GI_0_8                             = C.NL80211_RATE_INFO_HE_GI_0_8
	NL80211_RATE_INFO_HE_GI_1_6                             = C.NL80211_RATE_INFO_HE_GI_1_6
	NL80211_RATE_INFO_HE_GI_3_2                             = C.NL80211_RATE_INFO_HE_GI_3_2
	NL80211_RATE_INFO_HE_GI                                 = C.NL80211_RATE_INFO_HE_GI
	NL80211_RATE_INFO_HE_MCS                                = C.NL80211_RATE_INFO_HE_MCS
	NL80211_RATE_INFO_HE_NSS                                = C.NL80211_RATE_INFO_HE_NSS
	NL80211_RATE_INFO_HE_RU_ALLOC_106                       = C.NL80211_RATE_INFO_HE_RU_ALLOC_106
	NL80211_RATE_INFO_HE_RU_ALLOC_242                       = C.NL80211_RATE_INFO_HE_RU_ALLOC_242
	NL80211_RATE_INFO_HE_RU_ALLOC_26                        = C.NL80211_RATE_INFO_HE_RU_ALLOC_26
	NL80211_RATE_INFO_HE_RU_ALLOC_2x996                     = C.NL80211_RATE_INFO_HE_RU_ALLOC_2x996
	NL80211_RATE_INFO_HE_RU_ALLOC_484                       = C.NL80211_RATE_INFO_HE_RU_ALLOC_484
	NL80211_RATE_INFO_HE_RU_ALLOC_52                        = C.NL80211_RATE_INFO_HE_RU_ALLOC_52
	NL80211_RATE_INFO_HE_RU_ALLOC_996                       = C.NL80211_RATE_INFO_HE_RU_ALLOC_996
	NL80211_RATE_INFO_HE_RU_ALLOC                           = C.NL80211_RATE_INFO_HE_RU_ALLOC
	NL80211_RATE_INFO_MAX                                   = C.NL80211_RATE_INFO_MAX
	NL80211_RATE_INFO_MCS                                   = C.NL80211_RATE_INFO_MCS
	NL80211_RATE_INFO_SHORT_GI                              = C.NL80211_RATE_INFO_SHORT_GI
	NL80211_RATE_INFO_VHT_MCS                               = C.NL80211_RATE_INFO_VHT_MCS
	NL80211_RATE_INFO_VHT_NSS                               = C.NL80211_RATE_INFO_VHT_NSS
	NL80211_REGDOM_SET_BY_CORE                              = C.NL80211_REGDOM_SET_BY_CORE
	NL80211_REGDOM_SET_BY_COUNTRY_IE                        = C.NL80211_REGDOM_SET_BY_COUNTRY_IE
	NL80211_REGDOM_SET_BY_DRIVER                            = C.NL80211_REGDOM_SET_BY_DRIVER
	NL80211_REGDOM_SET_BY_USER                              = C.NL80211_REGDOM_SET_BY_USER
	NL80211_REGDOM_TYPE_COUNTRY                             = C.NL80211_REGDOM_TYPE_COUNTRY
	NL80211_REGDOM_TYPE_CUSTOM_WORLD                        = C.NL80211_REGDOM_TYPE_CUSTOM_WORLD
	NL80211_REGDOM_TYPE_INTERSECTION                        = C.NL80211_REGDOM_TYPE_INTERSECTION
	NL80211_REGDOM_TYPE_WORLD                               = C.NL80211_REGDOM_TYPE_WORLD
	NL80211_REG_RULE_ATTR_MAX                               = C.NL80211_REG_RULE_ATTR_MAX
	NL80211_REKEY_DATA_AKM                                  = C.NL80211_REKEY_DATA_AKM
	NL80211_REKEY_DATA_KCK                                  = C.NL80211_REKEY_DATA_KCK
	NL80211_REKEY_DATA_KEK                                  = C.NL80211_REKEY_DATA_KEK
	NL80211_REKEY_DATA_REPLAY_CTR                           = C.NL80211_REKEY_DATA_REPLAY_CTR
	NL80211_REPLAY_CTR_LEN                                  = C.NL80211_REPLAY_CTR_LEN
	NL80211_RRF_AUTO_BW                                     = C.NL80211_RRF_AUTO_BW
	NL80211_RRF_DFS                                         = C.NL80211_RRF_DFS
	NL80211_RRF_GO_CONCURRENT                               = C.NL80211_RRF_GO_CONCURRENT
	NL80211_RRF_IR_CONCURRENT                               = C.NL80211_RRF_IR_CONCURRENT
	NL80211_RRF_NO_160MHZ                                   = C.NL80211_RRF_NO_160MHZ
	NL80211_RRF_NO_80MHZ                                    = C.NL80211_RRF_NO_80MHZ
	NL80211_RRF_NO_CCK                                      = C.NL80211_RRF_NO_CCK
	NL80211_RRF_NO_HE                                       = C.NL80211_RRF_NO_HE
	NL80211_RRF_NO_HT40                                     = C.NL80211_RRF_NO_HT40
	NL80211_RRF_NO_HT40MINUS                                = C.NL80211_RRF_NO_HT40MINUS
	NL80211_RRF_NO_HT40PLUS                                 = C.NL80211_RRF_NO_HT40PLUS
	NL80211_RRF_NO_IBSS                                     = C.NL80211_RRF_NO_IBSS
	NL80211_RRF_NO_INDOOR                                   = C.NL80211_RRF_NO_INDOOR
	NL80211_RRF_NO_IR_ALL                                   = C.NL80211_RRF_NO_IR_ALL
	NL80211_RRF_NO_IR                                       = C.NL80211_RRF_NO_IR
	NL80211_RRF_NO_OFDM                                     = C.NL80211_RRF_NO_OFDM
	NL80211_RRF_NO_OUTDOOR                                  = C.NL80211_RRF_NO_OUTDOOR
	NL80211_RRF_PASSIVE_SCAN                                = C.NL80211_RRF_PASSIVE_SCAN
	NL80211_RRF_PTMP_ONLY                                   = C.NL80211_RRF_PTMP_ONLY
	NL80211_RRF_PTP_ONLY                                    = C.NL80211_RRF_PTP_ONLY
	NL80211_RXMGMT_FLAG_ANSWERED                            = C.NL80211_RXMGMT_FLAG_ANSWERED
	NL80211_RXMGMT_FLAG_EXTERNAL_AUTH                       = C.NL80211_RXMGMT_FLAG_EXTERNAL_AUTH
	NL80211_SAE_PWE_BOTH                                    = C.NL80211_SAE_PWE_BOTH
	NL80211_SAE_PWE_HASH_TO_ELEMENT                         = C.NL80211_SAE_PWE_HASH_TO_ELEMENT
	NL80211_SAE_PWE_HUNT_AND_PECK                           = C.NL80211_SAE_PWE_HUNT_AND_PECK
	NL80211_SAE_PWE_UNSPECIFIED                             = C.NL80211_SAE_PWE_UNSPECIFIED
	NL80211_SAR_ATTR_MAX                                    = C.NL80211_SAR_ATTR_MAX
	NL80211_SAR_ATTR_SPECS                                  = C.NL80211_SAR_ATTR_SPECS
	NL80211_SAR_ATTR_SPECS_END_FREQ                         = C.NL80211_SAR_ATTR_SPECS_END_FREQ
	NL80211_SAR_ATTR_SPECS_MAX                              = C.NL80211_SAR_ATTR_SPECS_MAX
	NL80211_SAR_ATTR_SPECS_POWER                            = C.NL80211_SAR_ATTR_SPECS_POWER
	NL80211_SAR_ATTR_SPECS_RANGE_INDEX                      = C.NL80211_SAR_ATTR_SPECS_RANGE_INDEX
	NL80211_SAR_ATTR_SPECS_START_FREQ                       = C.NL80211_SAR_ATTR_SPECS_START_FREQ
	NL80211_SAR_ATTR_TYPE                                   = C.NL80211_SAR_ATTR_TYPE
	NL80211_SAR_TYPE_POWER                                  = C.NL80211_SAR_TYPE_POWER
	NL80211_SCAN_FLAG_ACCEPT_BCAST_PROBE_RESP               = C.NL80211_SCAN_FLAG_ACCEPT_BCAST_PROBE_RESP
	NL80211_SCAN_FLAG_AP                                    = C.NL80211_SCAN_FLAG_AP
	NL80211_SCAN_FLAG_COLOCATED_6GHZ                        = C.NL80211_SCAN_FLAG_COLOCATED_6GHZ
	NL80211_SCAN_FLAG_FILS_MAX_CHANNEL_TIME                 = C.NL80211_SCAN_FLAG_FILS_MAX_CHANNEL_TIME
	NL80211_SCAN_FLAG_FLUSH                                 = C.NL80211_SCAN_FLAG_FLUSH
	NL80211_SCAN_FLAG_FREQ_KHZ                              = C.NL80211_SCAN_FLAG_FREQ_KHZ
	NL80211_SCAN_FLAG_HIGH_ACCURACY                         = C.NL80211_SCAN_FLAG_HIGH_ACCURACY
	NL80211_SCAN_FLAG_LOW_POWER                             = C.NL80211_SCAN_FLAG_LOW_POWER
	NL80211_SCAN_FLAG_LOW_PRIORITY                          = C.NL80211_SCAN_FLAG_LOW_PRIORITY
	NL80211_SCAN_FLAG_LOW_SPAN                              = C.NL80211_SCAN_FLAG_LOW_SPAN
	NL80211_SCAN_FLAG_MIN_PREQ_CONTENT                      = C.NL80211_SCAN_FLAG_MIN_PREQ_CONTENT
	NL80211_SCAN_FLAG_OCE_PROBE_REQ_DEFERRAL_SUPPRESSION    = C.NL80211_SCAN_FLAG_OCE_PROBE_REQ_DEFERRAL_SUPPRESSION
	NL80211_SCAN_FLAG_OCE_PROBE_REQ_HIGH_TX_RATE            = C.NL80211_SCAN_FLAG_OCE_PROBE_REQ_HIGH_TX_RATE
	NL80211_SCAN_FLAG_RANDOM_ADDR                           = C.NL80211_SCAN_FLAG_RANDOM_ADDR
	NL80211_SCAN_FLAG_RANDOM_SN                             = C.NL80211_SCAN_FLAG_RANDOM_SN
	NL80211_SCAN_RSSI_THOLD_OFF                             = C.NL80211_SCAN_RSSI_THOLD_OFF
	NL80211_SCHED_SCAN_MATCH_ATTR_BSSID                     = C.NL80211_SCHED_SCAN_MATCH_ATTR_BSSID
	NL80211_SCHED_SCAN_MATCH_ATTR_MAX                       = C.NL80211_SCHED_SCAN_MATCH_ATTR_MAX
	NL80211_SCHED_SCAN_MATCH_ATTR_RELATIVE_RSSI             = C.NL80211_SCHED_SCAN_MATCH_ATTR_RELATIVE_RSSI
	NL80211_SCHED_SCAN_MATCH_ATTR_RSSI_ADJUST               = C.NL80211_SCHED_SCAN_MATCH_ATTR_RSSI_ADJUST
	NL80211_SCHED_SCAN_MATCH_ATTR_RSSI                      = C.NL80211_SCHED_SCAN_MATCH_ATTR_RSSI
	NL80211_SCHED_SCAN_MATCH_ATTR_SSID                      = C.NL80211_SCHED_SCAN_MATCH_ATTR_SSID
	NL80211_SCHED_SCAN_MATCH_PER_BAND_RSSI                  = C.NL80211_SCHED_SCAN_MATCH_PER_BAND_RSSI
	NL80211_SCHED_SCAN_PLAN_INTERVAL                        = C.NL80211_SCHED_SCAN_PLAN_INTERVAL
	NL80211_SCHED_SCAN_PLAN_ITERATIONS                      = C.NL80211_SCHED_SCAN_PLAN_ITERATIONS
	NL80211_SCHED_SCAN_PLAN_MAX                             = C.NL80211_SCHED_SCAN_PLAN_MAX
	NL80211_SMPS_DYNAMIC                                    = C.NL80211_SMPS_DYNAMIC
	NL80211_SMPS_MAX                                        = C.NL80211_SMPS_MAX
	NL80211_SMPS_OFF                                        = C.NL80211_SMPS_OFF
	NL80211_SMPS_STATIC                                     = C.NL80211_SMPS_STATIC
	NL80211_STA_BSS_PARAM_BEACON_INTERVAL                   = C.NL80211_STA_BSS_PARAM_BEACON_INTERVAL
	NL80211_STA_BSS_PARAM_CTS_PROT                          = C.NL80211_STA_BSS_PARAM_CTS_PROT
	NL80211_STA_BSS_PARAM_DTIM_PERIOD                       = C.NL80211_STA_BSS_PARAM_DTIM_PERIOD
	NL80211_STA_BSS_PARAM_MAX                               = C.NL80211_STA_BSS_PARAM_MAX
	NL80211_STA_BSS_PARAM_SHORT_PREAMBLE                    = C.NL80211_STA_BSS_PARAM_SHORT_PREAMBLE
	NL80211_STA_BSS_PARAM_SHORT_SLOT_TIME                   = C.NL80211_STA_BSS_PARAM_SHORT_SLOT_TIME
	NL80211_STA_FLAG_ASSOCIATED                             = C.NL80211_STA_FLAG_ASSOCIATED
	NL80211_STA_FLAG_AUTHENTICATED                          = C.NL80211_STA_FLAG_AUTHENTICATED
	NL80211_STA_FLAG_AUTHORIZED                             = C.NL80211_STA_FLAG_AUTHORIZED
	NL80211_STA_FLAG_MAX                                    = C.NL80211_STA_FLAG_MAX
	NL80211_STA_FLAG_MAX_OLD_API                            = C.NL80211_STA_FLAG_MAX_OLD_API
	NL80211_STA_FLAG_MFP                                    = C.NL80211_STA_FLAG_MFP
	NL80211_STA_FLAG_SHORT_PREAMBLE                         = C.NL80211_STA_FLAG_SHORT_PREAMBLE
	NL80211_STA_FLAG_TDLS_PEER                              = C.NL80211_STA_FLAG_TDLS_PEER
	NL80211_STA_FLAG_WME                                    = C.NL80211_STA_FLAG_WME
	NL80211_STA_INFO_ACK_SIGNAL_AVG                         = C.NL80211_STA_INFO_ACK_SIGNAL_AVG
	NL80211_STA_INFO_ACK_SIGNAL                             = C.NL80211_STA_INFO_ACK_SIGNAL
	NL80211_STA_INFO_AIRTIME_LINK_METRIC                    = C.NL80211_STA_INFO_AIRTIME_LINK_METRIC
	NL80211_STA_INFO_AIRTIME_WEIGHT                         = C.NL80211_STA_INFO_AIRTIME_WEIGHT
	NL80211_STA_INFO_ASSOC_AT_BOOTTIME                      = C.NL80211_STA_INFO_ASSOC_AT_BOOTTIME
	NL80211_STA_INFO_BEACON_LOSS                            = C.NL80211_STA_INFO_BEACON_LOSS
	NL80211_STA_INFO_BEACON_RX                              = C.NL80211_STA_INFO_BEACON_RX
	NL80211_STA_INFO_BEACON_SIGNAL_AVG                      = C.NL80211_STA_INFO_BEACON_SIGNAL_AVG
	NL80211_STA_INFO_BSS_PARAM                              = C.NL80211_STA_INFO_BSS_PARAM
	NL80211_STA_INFO_CHAIN_SIGNAL_AVG                       = C.NL80211_STA_INFO_CHAIN_SIGNAL_AVG
	NL80211_STA_INFO_CHAIN_SIGNAL                           = C.NL80211_STA_INFO_CHAIN_SIGNAL
	NL80211_STA_INFO_CONNECTED_TIME                         = C.NL80211_STA_INFO_CONNECTED_TIME
	NL80211_STA_INFO_CONNECTED_TO_AS                        = C.NL80211_STA_INFO_CONNECTED_TO_AS
	NL80211_STA_INFO_CONNECTED_TO_GATE                      = C.NL80211_STA_INFO_CONNECTED_TO_GATE
	NL80211_STA_INFO_DATA_ACK_SIGNAL_AVG                    = C.NL80211_STA_INFO_DATA_ACK_SIGNAL_AVG
	NL80211_STA_INFO_EXPECTED_THROUGHPUT                    = C.NL80211_STA_INFO_EXPECTED_THROUGHPUT
	NL80211_STA_INFO_FCS_ERROR_COUNT                        = C.NL80211_STA_INFO_FCS_ERROR_COUNT
	NL80211_STA_INFO_INACTIVE_TIME                          = C.NL80211_STA_INFO_INACTIVE_TIME
	NL80211_STA_INFO_LLID                                   = C.NL80211_STA_INFO_LLID
	NL80211_STA_INFO_LOCAL_PM                               = C.NL80211_STA_INFO_LOCAL_PM
	NL80211_STA_INFO_MAX                                    = C.NL80211_STA_INFO_MAX
	NL80211_STA_INFO_NONPEER_PM                             = C.NL80211_STA_INFO_NONPEER_PM
	NL80211_STA_INFO_PAD                                    = C.NL80211_STA_INFO_PAD
	NL80211_STA_INFO_PEER_PM                                = C.NL80211_STA_INFO_PEER_PM
	NL80211_STA_INFO_PLID                                   = C.NL80211_STA_INFO_PLID
	NL80211_STA_INFO_PLINK_STATE                            = C.NL80211_STA_INFO_PLINK_STATE
	NL80211_STA_INFO_RX_BITRATE                             = C.NL80211_STA_INFO_RX_BITRATE
	NL80211_STA_INFO_RX_BYTES64                             = C.NL80211_STA_INFO_RX_BYTES64
	NL80211_STA_INFO_RX_BYTES                               = C.NL80211_STA_INFO_RX_BYTES
	NL80211_STA_INFO_RX_DROP_MISC                           = C.NL80211_STA_INFO_RX_DROP_MISC
	NL80211_STA_INFO_RX_DURATION                            = C.NL80211_STA_INFO_RX_DURATION
	NL80211_STA_INFO_RX_MPDUS                               = C.NL80211_STA_INFO_RX_MPDUS
	NL80211_STA_INFO_RX_PACKETS                             = C.NL80211_STA_INFO_RX_PACKETS
	NL80211_STA_INFO_SIGNAL_AVG                             = C.NL80211_STA_INFO_SIGNAL_AVG
	NL80211_STA_INFO_SIGNAL                                 = C.NL80211_STA_INFO_SIGNAL
	NL80211_STA_INFO_STA_FLAGS                              = C.NL80211_STA_INFO_STA_FLAGS
	NL80211_STA_INFO_TID_STATS                              = C.NL80211_STA_INFO_TID_STATS
	NL80211_STA_INFO_T_OFFSET                               = C.NL80211_STA_INFO_T_OFFSET
	NL80211_STA_INFO_TX_BITRATE                             = C.NL80211_STA_INFO_TX_BITRATE
	NL80211_STA_INFO_TX_BYTES64                             = C.NL80211_STA_INFO_TX_BYTES64
	NL80211_STA_INFO_TX_BYTES                               = C.NL80211_STA_INFO_TX_BYTES
	NL80211_STA_INFO_TX_DURATION                            = C.NL80211_STA_INFO_TX_DURATION
	NL80211_STA_INFO_TX_FAILED                              = C.NL80211_STA_INFO_TX_FAILED
	NL80211_STA_INFO_TX_PACKETS                             = C.NL80211_STA_INFO_TX_PACKETS
	NL80211_STA_INFO_TX_RETRIES                             = C.NL80211_STA_INFO_TX_RETRIES
	NL80211_STA_WME_MAX                                     = C.NL80211_STA_WME_MAX
	NL80211_STA_WME_MAX_SP                                  = C.NL80211_STA_WME_MAX_SP
	NL80211_STA_WME_UAPSD_QUEUES                            = C.NL80211_STA_WME_UAPSD_QUEUES
	NL80211_SURVEY_INFO_CHANNEL_TIME_BUSY                   = C.NL80211_SURVEY_INFO_CHANNEL_TIME_BUSY
	NL80211_SURVEY_INFO_CHANNEL_TIME                        = C.NL80211_SURVEY_INFO_CHANNEL_TIME
	NL80211_SURVEY_INFO_CHANNEL_TIME_EXT_BUSY               = C.NL80211_SURVEY_INFO_CHANNEL_TIME_EXT_BUSY
	NL80211_SURVEY_INFO_CHANNEL_TIME_RX                     = C.NL80211_SURVEY_INFO_CHANNEL_TIME_RX
	NL80211_SURVEY_INFO_CHANNEL_TIME_TX                     = C.NL80211_SURVEY_INFO_CHANNEL_TIME_TX
	NL80211_SURVEY_INFO_FREQUENCY                           = C.NL80211_SURVEY_INFO_FREQUENCY
	NL80211_SURVEY_INFO_FREQUENCY_OFFSET                    = C.NL80211_SURVEY_INFO_FREQUENCY_OFFSET
	NL80211_SURVEY_INFO_IN_USE                              = C.NL80211_SURVEY_INFO_IN_USE
	NL80211_SURVEY_INFO_MAX                                 = C.NL80211_SURVEY_INFO_MAX
	NL80211_SURVEY_INFO_NOISE                               = C.NL80211_SURVEY_INFO_NOISE
	NL80211_SURVEY_INFO_PAD                                 = C.NL80211_SURVEY_INFO_PAD
	NL80211_SURVEY_INFO_TIME_BSS_RX                         = C.NL80211_SURVEY_INFO_TIME_BSS_RX
	NL80211_SURVEY_INFO_TIME_BUSY                           = C.NL80211_SURVEY_INFO_TIME_BUSY
	NL80211_SURVEY_INFO_TIME                                = C.NL80211_SURVEY_INFO_TIME
	NL80211_SURVEY_INFO_TIME_EXT_BUSY                       = C.NL80211_SURVEY_INFO_TIME_EXT_BUSY
	NL80211_SURVEY_INFO_TIME_RX                             = C.NL80211_SURVEY_INFO_TIME_RX
	NL80211_SURVEY_INFO_TIME_SCAN                           = C.NL80211_SURVEY_INFO_TIME_SCAN
	NL80211_SURVEY_INFO_TIME_TX                             = C.NL80211_SURVEY_INFO_TIME_TX
	NL80211_TDLS_DISABLE_LINK                               = C.NL80211_TDLS_DISABLE_LINK
	NL80211_TDLS_DISCOVERY_REQ                              = C.NL80211_TDLS_DISCOVERY_REQ
	NL80211_TDLS_ENABLE_LINK                                = C.NL80211_TDLS_ENABLE_LINK
	NL80211_TDLS_PEER_HE                                    = C.NL80211_TDLS_PEER_HE
	NL80211_TDLS_PEER_HT                                    = C.NL80211_TDLS_PEER_HT
	NL80211_TDLS_PEER_VHT                                   = C.NL80211_TDLS_PEER_VHT
	NL80211_TDLS_PEER_WMM                                   = C.NL80211_TDLS_PEER_WMM
	NL80211_TDLS_SETUP                                      = C.NL80211_TDLS_SETUP
	NL80211_TDLS_TEARDOWN                                   = C.NL80211_TDLS_TEARDOWN
	NL80211_TID_CONFIG_ATTR_AMPDU_CTRL                      = C.NL80211_TID_CONFIG_ATTR_AMPDU_CTRL
	NL80211_TID_CONFIG_ATTR_AMSDU_CTRL                      = C.NL80211_TID_CONFIG_ATTR_AMSDU_CTRL
	NL80211_TID_CONFIG_ATTR_MAX                             = C.NL80211_TID_CONFIG_ATTR_MAX
	NL80211_TID_CONFIG_ATTR_NOACK                           = C.NL80211_TID_CONFIG_ATTR_NOACK
	NL80211_TID_CONFIG_ATTR_OVERRIDE                        = C.NL80211_TID_CONFIG_ATTR_OVERRIDE
	NL80211_TID_CONFIG_ATTR_PAD                             = C.NL80211_TID_CONFIG_ATTR_PAD
	NL80211_TID_CONFIG_ATTR_PEER_SUPP                       = C.NL80211_TID_CONFIG_ATTR_PEER_SUPP
	NL80211_TID_CONFIG_ATTR_RETRY_LONG                      = C.NL80211_TID_CONFIG_ATTR_RETRY_LONG
	NL80211_TID_CONFIG_ATTR_RETRY_SHORT                     = C.NL80211_TID_CONFIG_ATTR_RETRY_SHORT
	NL80211_TID_CONFIG_ATTR_RTSCTS_CTRL                     = C.NL80211_TID_CONFIG_ATTR_RTSCTS_CTRL
	NL80211_TID_CONFIG_ATTR_TIDS                            = C.NL80211_TID_CONFIG_ATTR_TIDS
	NL80211_TID_CONFIG_ATTR_TX_RATE                         = C.NL80211_TID_CONFIG_ATTR_TX_RATE
	NL80211_TID_CONFIG_ATTR_TX_RATE_TYPE                    = C.NL80211_TID_CONFIG_ATTR_TX_RATE_TYPE
	NL80211_TID_CONFIG_ATTR_VIF_SUPP                        = C.NL80211_TID_CONFIG_ATTR_VIF_SUPP
	NL80211_TID_CONFIG_DISABLE                              = C.NL80211_TID_CONFIG_DISABLE
	NL80211_TID_CONFIG_ENABLE                               = C.NL80211_TID_CONFIG_ENABLE
	NL80211_TID_STATS_MAX                                   = C.NL80211_TID_STATS_MAX
	NL80211_TID_STATS_PAD                                   = C.NL80211_TID_STATS_PAD
	NL80211_TID_STATS_RX_MSDU                               = C.NL80211_TID_STATS_RX_MSDU
	NL80211_TID_STATS_TX_MSDU                               = C.NL80211_TID_STATS_TX_MSDU
	NL80211_TID_STATS_TX_MSDU_FAILED                        = C.NL80211_TID_STATS_TX_MSDU_FAILED
	NL80211_TID_STATS_TX_MSDU_RETRIES                       = C.NL80211_TID_STATS_TX_MSDU_RETRIES
	NL80211_TID_STATS_TXQ_STATS                             = C.NL80211_TID_STATS_TXQ_STATS
	NL80211_TIMEOUT_ASSOC                                   = C.NL80211_TIMEOUT_ASSOC
	NL80211_TIMEOUT_AUTH                                    = C.NL80211_TIMEOUT_AUTH
	NL80211_TIMEOUT_SCAN                                    = C.NL80211_TIMEOUT_SCAN
	NL80211_TIMEOUT_UNSPECIFIED                             = C.NL80211_TIMEOUT_UNSPECIFIED
	NL80211_TKIP_DATA_OFFSET_ENCR_KEY                       = C.NL80211_TKIP_DATA_OFFSET_ENCR_KEY
	NL80211_TKIP_DATA_OFFSET_RX_MIC_KEY                     = C.NL80211_TKIP_DATA_OFFSET_RX_MIC_KEY
	NL80211_TKIP_DATA_OFFSET_TX_MIC_KEY                     = C.NL80211_TKIP_DATA_OFFSET_TX_MIC_KEY
	NL80211_TX_POWER_AUTOMATIC                              = C.NL80211_TX_POWER_AUTOMATIC
	NL80211_TX_POWER_FIXED                                  = C.NL80211_TX_POWER_FIXED
	NL80211_TX_POWER_LIMITED                                = C.NL80211_TX_POWER_LIMITED
	NL80211_TXQ_ATTR_AC                                     = C.NL80211_TXQ_ATTR_AC
	NL80211_TXQ_ATTR_AIFS                                   = C.NL80211_TXQ_ATTR_AIFS
	NL80211_TXQ_ATTR_CWMAX                                  = C.NL80211_TXQ_ATTR_CWMAX
	NL80211_TXQ_ATTR_CWMIN                                  = C.NL80211_TXQ_ATTR_CWMIN
	NL80211_TXQ_ATTR_MAX                                    = C.NL80211_TXQ_ATTR_MAX
	NL80211_TXQ_ATTR_QUEUE                                  = C.NL80211_TXQ_ATTR_QUEUE
	NL80211_TXQ_ATTR_TXOP                                   = C.NL80211_TXQ_ATTR_TXOP
	NL80211_TXQ_Q_BE                                        = C.NL80211_TXQ_Q_BE
	NL80211_TXQ_Q_BK                                        = C.NL80211_TXQ_Q_BK
	NL80211_TXQ_Q_VI                                        = C.NL80211_TXQ_Q_VI
	NL80211_TXQ_Q_VO                                        = C.NL80211_TXQ_Q_VO
	NL80211_TXQ_STATS_BACKLOG_BYTES                         = C.NL80211_TXQ_STATS_BACKLOG_BYTES
	NL80211_TXQ_STATS_BACKLOG_PACKETS                       = C.NL80211_TXQ_STATS_BACKLOG_PACKETS
	NL80211_TXQ_STATS_COLLISIONS                            = C.NL80211_TXQ_STATS_COLLISIONS
	NL80211_TXQ_STATS_DROPS                                 = C.NL80211_TXQ_STATS_DROPS
	NL80211_TXQ_STATS_ECN_MARKS                             = C.NL80211_TXQ_STATS_ECN_MARKS
	NL80211_TXQ_STATS_FLOWS                                 = C.NL80211_TXQ_STATS_FLOWS
	NL80211_TXQ_STATS_MAX                                   = C.NL80211_TXQ_STATS_MAX
	NL80211_TXQ_STATS_MAX_FLOWS                             = C.NL80211_TXQ_STATS_MAX_FLOWS
	NL80211_TXQ_STATS_OVERLIMIT                             = C.NL80211_TXQ_STATS_OVERLIMIT
	NL80211_TXQ_STATS_OVERMEMORY                            = C.NL80211_TXQ_STATS_OVERMEMORY
	NL80211_TXQ_STATS_TX_BYTES                              = C.NL80211_TXQ_STATS_TX_BYTES
	NL80211_TXQ_STATS_TX_PACKETS                            = C.NL80211_TXQ_STATS_TX_PACKETS
	NL80211_TX_RATE_AUTOMATIC                               = C.NL80211_TX_RATE_AUTOMATIC
	NL80211_TXRATE_DEFAULT_GI                               = C.NL80211_TXRATE_DEFAULT_GI
	NL80211_TX_RATE_FIXED                                   = C.NL80211_TX_RATE_FIXED
	NL80211_TXRATE_FORCE_LGI                                = C.NL80211_TXRATE_FORCE_LGI
	NL80211_TXRATE_FORCE_SGI                                = C.NL80211_TXRATE_FORCE_SGI
	NL80211_TXRATE_GI                                       = C.NL80211_TXRATE_GI
	NL80211_TXRATE_HE                                       = C.NL80211_TXRATE_HE
	NL80211_TXRATE_HE_GI                                    = C.NL80211_TXRATE_HE_GI
	NL80211_TXRATE_HE_LTF                                   = C.NL80211_TXRATE_HE_LTF
	NL80211_TXRATE_HT                                       = C.NL80211_TXRATE_HT
	NL80211_TXRATE_LEGACY                                   = C.NL80211_TXRATE_LEGACY
	NL80211_TX_RATE_LIMITED                                 = C.NL80211_TX_RATE_LIMITED
	NL80211_TXRATE_MAX                                      = C.NL80211_TXRATE_MAX
	NL80211_TXRATE_MCS                                      = C.NL80211_TXRATE_MCS
	NL80211_TXRATE_VHT                                      = C.NL80211_TXRATE_VHT
	NL80211_UNSOL_BCAST_PROBE_RESP_ATTR_INT                 = C.NL80211_UNSOL_BCAST_PROBE_RESP_ATTR_INT
	NL80211_UNSOL_BCAST_PROBE_RESP_ATTR_MAX                 = C.NL80211_UNSOL_BCAST_PROBE_RESP_ATTR_MAX
	NL80211_UNSOL_BCAST_PROBE_RESP_ATTR_TMPL                = C.NL80211_UNSOL_BCAST_PROBE_RESP_ATTR_TMPL
	NL80211_USER_REG_HINT_CELL_BASE                         = C.NL80211_USER_REG_HINT_CELL_BASE
	NL80211_USER_REG_HINT_INDOOR                            = C.NL80211_USER_REG_HINT_INDOOR
	NL80211_USER_REG_HINT_USER                              = C.NL80211_USER_REG_HINT_USER
	NL80211_VENDOR_ID_IS_LINUX                              = C.NL80211_VENDOR_ID_IS_LINUX
	NL80211_VHT_CAPABILITY_LEN                              = C.NL80211_VHT_CAPABILITY_LEN
	NL80211_VHT_NSS_MAX                                     = C.NL80211_VHT_NSS_MAX
	NL80211_WIPHY_NAME_MAXLEN                               = C.NL80211_WIPHY_NAME_MAXLEN
	NL80211_WMMR_AIFSN                                      = C.NL80211_WMMR_AIFSN
	NL80211_WMMR_CW_MAX                                     = C.NL80211_WMMR_CW_MAX
	NL80211_WMMR_CW_MIN                                     = C.NL80211_WMMR_CW_MIN
	NL80211_WMMR_MAX                                        = C.NL80211_WMMR_MAX
	NL80211_WMMR_TXOP                                       = C.NL80211_WMMR_TXOP
	NL80211_WOWLAN_PKTPAT_MASK                              = C.NL80211_WOWLAN_PKTPAT_MASK
	NL80211_WOWLAN_PKTPAT_OFFSET                            = C.NL80211_WOWLAN_PKTPAT_OFFSET
	NL80211_WOWLAN_PKTPAT_PATTERN                           = C.NL80211_WOWLAN_PKTPAT_PATTERN
	NL80211_WOWLAN_TCP_DATA_INTERVAL                        = C.NL80211_WOWLAN_TCP_DATA_INTERVAL
	NL80211_WOWLAN_TCP_DATA_PAYLOAD                         = C.NL80211_WOWLAN_TCP_DATA_PAYLOAD
	NL80211_WOWLAN_TCP_DATA_PAYLOAD_SEQ                     = C.NL80211_WOWLAN_TCP_DATA_PAYLOAD_SEQ
	NL80211_WOWLAN_TCP_DATA_PAYLOAD_TOKEN                   = C.NL80211_WOWLAN_TCP_DATA_PAYLOAD_TOKEN
	NL80211_WOWLAN_TCP_DST_IPV4                             = C.NL80211_WOWLAN_TCP_DST_IPV4
	NL80211_WOWLAN_TCP_DST_MAC                              = C.NL80211_WOWLAN_TCP_DST_MAC
	NL80211_WOWLAN_TCP_DST_PORT                             = C.NL80211_WOWLAN_TCP_DST_PORT
	NL80211_WOWLAN_TCP_SRC_IPV4                             = C.NL80211_WOWLAN_TCP_SRC_IPV4
	NL80211_WOWLAN_TCP_SRC_PORT                             = C.NL80211_WOWLAN_TCP_SRC_PORT
	NL80211_WOWLAN_TCP_WAKE_MASK                            = C.NL80211_WOWLAN_TCP_WAKE_MASK
	NL80211_WOWLAN_TCP_WAKE_PAYLOAD                         = C.NL80211_WOWLAN_TCP_WAKE_PAYLOAD
	NL80211_WOWLAN_TRIG_4WAY_HANDSHAKE                      = C.NL80211_WOWLAN_TRIG_4WAY_HANDSHAKE
	NL80211_WOWLAN_TRIG_ANY                                 = C.NL80211_WOWLAN_TRIG_ANY
	NL80211_WOWLAN_TRIG_DISCONNECT                          = C.NL80211_WOWLAN_TRIG_DISCONNECT
	NL80211_WOWLAN_TRIG_EAP_IDENT_REQUEST                   = C.NL80211_WOWLAN_TRIG_EAP_IDENT_REQUEST
	NL80211_WOWLAN_TRIG_GTK_REKEY_FAILURE                   = C.NL80211_WOWLAN_TRIG_GTK_REKEY_FAILURE
	NL80211_WOWLAN_TRIG_GTK_REKEY_SUPPORTED                 = C.NL80211_WOWLAN_TRIG_GTK_REKEY_SUPPORTED
	NL80211_WOWLAN_TRIG_MAGIC_PKT                           = C.NL80211_WOWLAN_TRIG_MAGIC_PKT
	NL80211_WOWLAN_TRIG_NET_DETECT                          = C.NL80211_WOWLAN_TRIG_NET_DETECT
	NL80211_WOWLAN_TRIG_NET_DETECT_RESULTS                  = C.NL80211_WOWLAN_TRIG_NET_DETECT_RESULTS
	NL80211_WOWLAN_TRIG_PKT_PATTERN                         = C.NL80211_WOWLAN_TRIG_PKT_PATTERN
	NL80211_WOWLAN_TRIG_RFKILL_RELEASE                      = C.NL80211_WOWLAN_TRIG_RFKILL_RELEASE
	NL80211_WOWLAN_TRIG_TCP_CONNECTION                      = C.NL80211_WOWLAN_TRIG_TCP_CONNECTION
	NL80211_WOWLAN_TRIG_WAKEUP_PKT_80211                    = C.NL80211_WOWLAN_TRIG_WAKEUP_PKT_80211
	NL80211_WOWLAN_TRIG_WAKEUP_PKT_80211_LEN                = C.NL80211_WOWLAN_TRIG_WAKEUP_PKT_80211_LEN
	NL80211_WOWLAN_TRIG_WAKEUP_PKT_8023                     = C.NL80211_WOWLAN_TRIG_WAKEUP_PKT_8023
	NL80211_WOWLAN_TRIG_WAKEUP_PKT_8023_LEN                 = C.NL80211_WOWLAN_TRIG_WAKEUP_PKT_8023_LEN
	NL80211_WOWLAN_TRIG_WAKEUP_TCP_CONNLOST                 = C.NL80211_WOWLAN_TRIG_WAKEUP_TCP_CONNLOST
	NL80211_WOWLAN_TRIG_WAKEUP_TCP_MATCH                    = C.NL80211_WOWLAN_TRIG_WAKEUP_TCP_MATCH
	NL80211_WOWLAN_TRIG_WAKEUP_TCP_NOMORETOKENS             = C.NL80211_WOWLAN_TRIG_WAKEUP_TCP_NOMORETOKENS
	NL80211_WPA_VERSION_1                                   = C.NL80211_WPA_VERSION_1
	NL80211_WPA_VERSION_2                                   = C.NL80211_WPA_VERSION_2
	NL80211_WPA_VERSION_3                                   = C.NL80211_WPA_VERSION_3
)

// generated by:
// perl -nlE '/^\s*((FR_ACT|FRA)_\w+)/ && say "$1 = C.$1"' include/uapi/linux/fib_rules.h
const (
	FRA_UNSPEC             = C.FRA_UNSPEC
	FRA_DST                = C.FRA_DST
	FRA_SRC                = C.FRA_SRC
	FRA_IIFNAME            = C.FRA_IIFNAME
	FRA_GOTO               = C.FRA_GOTO
	FRA_UNUSED2            = C.FRA_UNUSED2
	FRA_PRIORITY           = C.FRA_PRIORITY
	FRA_UNUSED3            = C.FRA_UNUSED3
	FRA_UNUSED4            = C.FRA_UNUSED4
	FRA_UNUSED5            = C.FRA_UNUSED5
	FRA_FWMARK             = C.FRA_FWMARK
	FRA_FLOW               = C.FRA_FLOW
	FRA_TUN_ID             = C.FRA_TUN_ID
	FRA_SUPPRESS_IFGROUP   = C.FRA_SUPPRESS_IFGROUP
	FRA_SUPPRESS_PREFIXLEN = C.FRA_SUPPRESS_PREFIXLEN
	FRA_TABLE              = C.FRA_TABLE
	FRA_FWMASK             = C.FRA_FWMASK
	FRA_OIFNAME            = C.FRA_OIFNAME
	FRA_PAD                = C.FRA_PAD
	FRA_L3MDEV             = C.FRA_L3MDEV
	FRA_UID_RANGE          = C.FRA_UID_RANGE
	FRA_PROTOCOL           = C.FRA_PROTOCOL
	FRA_IP_PROTO           = C.FRA_IP_PROTO
	FRA_SPORT_RANGE        = C.FRA_SPORT_RANGE
	FRA_DPORT_RANGE        = C.FRA_DPORT_RANGE
	FR_ACT_UNSPEC          = C.FR_ACT_UNSPEC
	FR_ACT_TO_TBL          = C.FR_ACT_TO_TBL
	FR_ACT_GOTO            = C.FR_ACT_GOTO
	FR_ACT_NOP             = C.FR_ACT_NOP
	FR_ACT_RES3            = C.FR_ACT_RES3
	FR_ACT_RES4            = C.FR_ACT_RES4
	FR_ACT_BLACKHOLE       = C.FR_ACT_BLACKHOLE
	FR_ACT_UNREACHABLE     = C.FR_ACT_UNREACHABLE
	FR_ACT_PROHIBIT        = C.FR_ACT_PROHIBIT
)
