// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/logging/v2/logging_metrics.proto

package logging

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_api4 "google.golang.org/genproto/googleapis/api/distribution"
import google_api5 "google.golang.org/genproto/googleapis/api/metric"
import google_protobuf5 "github.com/golang/protobuf/ptypes/empty"
import _ "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Stackdriver Logging API version.
type LogMetric_ApiVersion int32

const (
	// Stackdriver Logging API v2.
	LogMetric_V2 LogMetric_ApiVersion = 0
	// Stackdriver Logging API v1.
	LogMetric_V1 LogMetric_ApiVersion = 1
)

var LogMetric_ApiVersion_name = map[int32]string{
	0: "V2",
	1: "V1",
}
var LogMetric_ApiVersion_value = map[string]int32{
	"V2": 0,
	"V1": 1,
}

func (x LogMetric_ApiVersion) String() string {
	return proto.EnumName(LogMetric_ApiVersion_name, int32(x))
}
func (LogMetric_ApiVersion) EnumDescriptor() ([]byte, []int) { return fileDescriptor3, []int{0, 0} }

// Describes a logs-based metric.  The value of the metric is the
// number of log entries that match a logs filter in a given time interval.
//
// A logs-based metric can also be used to extract values from logs and create a
// a distribution of the values. The distribution records the statistics of the
// extracted values along with an optional histogram of the values as specified
// by the bucket options.
type LogMetric struct {
	// Required. The client-assigned metric identifier.
	// Examples: `"error_count"`, `"nginx/requests"`.
	//
	// Metric identifiers are limited to 100 characters and can include
	// only the following characters: `A-Z`, `a-z`, `0-9`, and the
	// special characters `_-.,+!*',()%/`.  The forward-slash character
	// (`/`) denotes a hierarchy of name pieces, and it cannot be the
	// first character of the name.
	//
	// The metric identifier in this field must not be
	// [URL-encoded](https://en.wikipedia.org/wiki/Percent-encoding).
	// However, when the metric identifier appears as the `[METRIC_ID]`
	// part of a `metric_name` API parameter, then the metric identifier
	// must be URL-encoded. Example:
	// `"projects/my-project/metrics/nginx%2Frequests"`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Optional. A description of this metric, which is used in documentation.
	Description string `protobuf:"bytes,2,opt,name=description" json:"description,omitempty"`
	// Required. An [advanced logs filter](/logging/docs/view/advanced_filters)
	// which is used to match log entries.
	// Example:
	//
	//     "resource.type=gae_app AND severity>=ERROR"
	//
	// The maximum length of the filter is 20000 characters.
	Filter string `protobuf:"bytes,3,opt,name=filter" json:"filter,omitempty"`
	// Optional. The metric descriptor associated with the logs-based metric.
	// If unspecified, it uses a default metric descriptor with a DELTA metric
	// kind, INT64 value type, with no labels and a unit of "1". Such a metric
	// counts the number of log entries matching the `filter` expression.
	//
	// The `name`, `type`, and `description` fields in the `metric_descriptor`
	// are output only, and is constructed using the `name` and `description`
	// field in the LogMetric.
	//
	// To create a logs-based metric that records a distribution of log values, a
	// DELTA metric kind with a DISTRIBUTION value type must be used along with
	// a `value_extractor` expression in the LogMetric.
	//
	// Each label in the metric descriptor must have a matching label
	// name as the key and an extractor expression as the value in the
	// `label_extractors` map.
	//
	// The `metric_kind` and `value_type` fields in the `metric_descriptor` cannot
	// be updated once initially configured. New labels can be added in the
	// `metric_descriptor`, but existing labels cannot be modified except for
	// their description.
	MetricDescriptor *google_api5.MetricDescriptor `protobuf:"bytes,5,opt,name=metric_descriptor,json=metricDescriptor" json:"metric_descriptor,omitempty"`
	// Optional. A `value_extractor` is required when using a distribution
	// logs-based metric to extract the values to record from a log entry.
	// Two functions are supported for value extraction: `EXTRACT(field)` or
	// `REGEXP_EXTRACT(field, regex)`. The argument are:
	//   1. field: The name of the log entry field from which the value is to be
	//      extracted.
	//   2. regex: A regular expression using the Google RE2 syntax
	//      (https://github.com/google/re2/wiki/Syntax) with a single capture
	//      group to extract data from the specified log entry field. The value
	//      of the field is converted to a string before applying the regex.
	//      It is an error to specify a regex that does not include exactly one
	//      capture group.
	//
	// The result of the extraction must be convertible to a double type, as the
	// distribution always records double values. If either the extraction or
	// the conversion to double fails, then those values are not recorded in the
	// distribution.
	//
	// Example: `REGEXP_EXTRACT(jsonPayload.request, ".*quantity=(\d+).*")`
	ValueExtractor string `protobuf:"bytes,6,opt,name=value_extractor,json=valueExtractor" json:"value_extractor,omitempty"`
	// Optional. A map from a label key string to an extractor expression which is
	// used to extract data from a log entry field and assign as the label value.
	// Each label key specified in the LabelDescriptor must have an associated
	// extractor expression in this map. The syntax of the extractor expression
	// is the same as for the `value_extractor` field.
	//
	// The extracted value is converted to the type defined in the label
	// descriptor. If the either the extraction or the type conversion fails,
	// the label will have a default value. The default value for a string
	// label is an empty string, for an integer label its 0, and for a boolean
	// label its `false`.
	//
	// Note that there are upper bounds on the maximum number of labels and the
	// number of active time series that are allowed in a project.
	LabelExtractors map[string]string `protobuf:"bytes,7,rep,name=label_extractors,json=labelExtractors" json:"label_extractors,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Optional. The `bucket_options` are required when the logs-based metric is
	// using a DISTRIBUTION value type and it describes the bucket boundaries
	// used to create a histogram of the extracted values.
	BucketOptions *google_api4.Distribution_BucketOptions `protobuf:"bytes,8,opt,name=bucket_options,json=bucketOptions" json:"bucket_options,omitempty"`
	// Deprecated. The API version that created or updated this metric.
	// The v2 format is used by default and cannot be changed.
	Version LogMetric_ApiVersion `protobuf:"varint,4,opt,name=version,enum=google.logging.v2.LogMetric_ApiVersion" json:"version,omitempty"`
}

func (m *LogMetric) Reset()                    { *m = LogMetric{} }
func (m *LogMetric) String() string            { return proto.CompactTextString(m) }
func (*LogMetric) ProtoMessage()               {}
func (*LogMetric) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0} }

func (m *LogMetric) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *LogMetric) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *LogMetric) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *LogMetric) GetMetricDescriptor() *google_api5.MetricDescriptor {
	if m != nil {
		return m.MetricDescriptor
	}
	return nil
}

func (m *LogMetric) GetValueExtractor() string {
	if m != nil {
		return m.ValueExtractor
	}
	return ""
}

func (m *LogMetric) GetLabelExtractors() map[string]string {
	if m != nil {
		return m.LabelExtractors
	}
	return nil
}

func (m *LogMetric) GetBucketOptions() *google_api4.Distribution_BucketOptions {
	if m != nil {
		return m.BucketOptions
	}
	return nil
}

func (m *LogMetric) GetVersion() LogMetric_ApiVersion {
	if m != nil {
		return m.Version
	}
	return LogMetric_V2
}

// The parameters to ListLogMetrics.
type ListLogMetricsRequest struct {
	// Required. The name of the project containing the metrics:
	//
	//     "projects/[PROJECT_ID]"
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Optional. If present, then retrieve the next batch of results from the
	// preceding call to this method.  `pageToken` must be the value of
	// `nextPageToken` from the previous response.  The values of other method
	// parameters should be identical to those in the previous call.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// Optional. The maximum number of results to return from this request.
	// Non-positive values are ignored.  The presence of `nextPageToken` in the
	// response indicates that more results might be available.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
}

func (m *ListLogMetricsRequest) Reset()                    { *m = ListLogMetricsRequest{} }
func (m *ListLogMetricsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListLogMetricsRequest) ProtoMessage()               {}
func (*ListLogMetricsRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{1} }

func (m *ListLogMetricsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListLogMetricsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListLogMetricsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Result returned from ListLogMetrics.
type ListLogMetricsResponse struct {
	// A list of logs-based metrics.
	Metrics []*LogMetric `protobuf:"bytes,1,rep,name=metrics" json:"metrics,omitempty"`
	// If there might be more results than appear in this response, then
	// `nextPageToken` is included.  To get the next set of results, call this
	// method again using the value of `nextPageToken` as `pageToken`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListLogMetricsResponse) Reset()                    { *m = ListLogMetricsResponse{} }
func (m *ListLogMetricsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListLogMetricsResponse) ProtoMessage()               {}
func (*ListLogMetricsResponse) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{2} }

func (m *ListLogMetricsResponse) GetMetrics() []*LogMetric {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *ListLogMetricsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The parameters to GetLogMetric.
type GetLogMetricRequest struct {
	// The resource name of the desired metric:
	//
	//     "projects/[PROJECT_ID]/metrics/[METRIC_ID]"
	MetricName string `protobuf:"bytes,1,opt,name=metric_name,json=metricName" json:"metric_name,omitempty"`
}

func (m *GetLogMetricRequest) Reset()                    { *m = GetLogMetricRequest{} }
func (m *GetLogMetricRequest) String() string            { return proto.CompactTextString(m) }
func (*GetLogMetricRequest) ProtoMessage()               {}
func (*GetLogMetricRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{3} }

func (m *GetLogMetricRequest) GetMetricName() string {
	if m != nil {
		return m.MetricName
	}
	return ""
}

// The parameters to CreateLogMetric.
type CreateLogMetricRequest struct {
	// The resource name of the project in which to create the metric:
	//
	//     "projects/[PROJECT_ID]"
	//
	// The new metric must be provided in the request.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The new logs-based metric, which must not have an identifier that
	// already exists.
	Metric *LogMetric `protobuf:"bytes,2,opt,name=metric" json:"metric,omitempty"`
}

func (m *CreateLogMetricRequest) Reset()                    { *m = CreateLogMetricRequest{} }
func (m *CreateLogMetricRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateLogMetricRequest) ProtoMessage()               {}
func (*CreateLogMetricRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{4} }

func (m *CreateLogMetricRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateLogMetricRequest) GetMetric() *LogMetric {
	if m != nil {
		return m.Metric
	}
	return nil
}

// The parameters to UpdateLogMetric.
type UpdateLogMetricRequest struct {
	// The resource name of the metric to update:
	//
	//     "projects/[PROJECT_ID]/metrics/[METRIC_ID]"
	//
	// The updated metric must be provided in the request and it's
	// `name` field must be the same as `[METRIC_ID]` If the metric
	// does not exist in `[PROJECT_ID]`, then a new metric is created.
	MetricName string `protobuf:"bytes,1,opt,name=metric_name,json=metricName" json:"metric_name,omitempty"`
	// The updated metric.
	Metric *LogMetric `protobuf:"bytes,2,opt,name=metric" json:"metric,omitempty"`
}

func (m *UpdateLogMetricRequest) Reset()                    { *m = UpdateLogMetricRequest{} }
func (m *UpdateLogMetricRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateLogMetricRequest) ProtoMessage()               {}
func (*UpdateLogMetricRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{5} }

func (m *UpdateLogMetricRequest) GetMetricName() string {
	if m != nil {
		return m.MetricName
	}
	return ""
}

func (m *UpdateLogMetricRequest) GetMetric() *LogMetric {
	if m != nil {
		return m.Metric
	}
	return nil
}

// The parameters to DeleteLogMetric.
type DeleteLogMetricRequest struct {
	// The resource name of the metric to delete:
	//
	//     "projects/[PROJECT_ID]/metrics/[METRIC_ID]"
	MetricName string `protobuf:"bytes,1,opt,name=metric_name,json=metricName" json:"metric_name,omitempty"`
}

func (m *DeleteLogMetricRequest) Reset()                    { *m = DeleteLogMetricRequest{} }
func (m *DeleteLogMetricRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteLogMetricRequest) ProtoMessage()               {}
func (*DeleteLogMetricRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{6} }

func (m *DeleteLogMetricRequest) GetMetricName() string {
	if m != nil {
		return m.MetricName
	}
	return ""
}

func init() {
	proto.RegisterType((*LogMetric)(nil), "google.logging.v2.LogMetric")
	proto.RegisterType((*ListLogMetricsRequest)(nil), "google.logging.v2.ListLogMetricsRequest")
	proto.RegisterType((*ListLogMetricsResponse)(nil), "google.logging.v2.ListLogMetricsResponse")
	proto.RegisterType((*GetLogMetricRequest)(nil), "google.logging.v2.GetLogMetricRequest")
	proto.RegisterType((*CreateLogMetricRequest)(nil), "google.logging.v2.CreateLogMetricRequest")
	proto.RegisterType((*UpdateLogMetricRequest)(nil), "google.logging.v2.UpdateLogMetricRequest")
	proto.RegisterType((*DeleteLogMetricRequest)(nil), "google.logging.v2.DeleteLogMetricRequest")
	proto.RegisterEnum("google.logging.v2.LogMetric_ApiVersion", LogMetric_ApiVersion_name, LogMetric_ApiVersion_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for MetricsServiceV2 service

type MetricsServiceV2Client interface {
	// Lists logs-based metrics.
	ListLogMetrics(ctx context.Context, in *ListLogMetricsRequest, opts ...grpc.CallOption) (*ListLogMetricsResponse, error)
	// Gets a logs-based metric.
	GetLogMetric(ctx context.Context, in *GetLogMetricRequest, opts ...grpc.CallOption) (*LogMetric, error)
	// Creates a logs-based metric.
	CreateLogMetric(ctx context.Context, in *CreateLogMetricRequest, opts ...grpc.CallOption) (*LogMetric, error)
	// Creates or updates a logs-based metric.
	UpdateLogMetric(ctx context.Context, in *UpdateLogMetricRequest, opts ...grpc.CallOption) (*LogMetric, error)
	// Deletes a logs-based metric.
	DeleteLogMetric(ctx context.Context, in *DeleteLogMetricRequest, opts ...grpc.CallOption) (*google_protobuf5.Empty, error)
}

type metricsServiceV2Client struct {
	cc *grpc.ClientConn
}

func NewMetricsServiceV2Client(cc *grpc.ClientConn) MetricsServiceV2Client {
	return &metricsServiceV2Client{cc}
}

func (c *metricsServiceV2Client) ListLogMetrics(ctx context.Context, in *ListLogMetricsRequest, opts ...grpc.CallOption) (*ListLogMetricsResponse, error) {
	out := new(ListLogMetricsResponse)
	err := grpc.Invoke(ctx, "/google.logging.v2.MetricsServiceV2/ListLogMetrics", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricsServiceV2Client) GetLogMetric(ctx context.Context, in *GetLogMetricRequest, opts ...grpc.CallOption) (*LogMetric, error) {
	out := new(LogMetric)
	err := grpc.Invoke(ctx, "/google.logging.v2.MetricsServiceV2/GetLogMetric", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricsServiceV2Client) CreateLogMetric(ctx context.Context, in *CreateLogMetricRequest, opts ...grpc.CallOption) (*LogMetric, error) {
	out := new(LogMetric)
	err := grpc.Invoke(ctx, "/google.logging.v2.MetricsServiceV2/CreateLogMetric", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricsServiceV2Client) UpdateLogMetric(ctx context.Context, in *UpdateLogMetricRequest, opts ...grpc.CallOption) (*LogMetric, error) {
	out := new(LogMetric)
	err := grpc.Invoke(ctx, "/google.logging.v2.MetricsServiceV2/UpdateLogMetric", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricsServiceV2Client) DeleteLogMetric(ctx context.Context, in *DeleteLogMetricRequest, opts ...grpc.CallOption) (*google_protobuf5.Empty, error) {
	out := new(google_protobuf5.Empty)
	err := grpc.Invoke(ctx, "/google.logging.v2.MetricsServiceV2/DeleteLogMetric", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for MetricsServiceV2 service

type MetricsServiceV2Server interface {
	// Lists logs-based metrics.
	ListLogMetrics(context.Context, *ListLogMetricsRequest) (*ListLogMetricsResponse, error)
	// Gets a logs-based metric.
	GetLogMetric(context.Context, *GetLogMetricRequest) (*LogMetric, error)
	// Creates a logs-based metric.
	CreateLogMetric(context.Context, *CreateLogMetricRequest) (*LogMetric, error)
	// Creates or updates a logs-based metric.
	UpdateLogMetric(context.Context, *UpdateLogMetricRequest) (*LogMetric, error)
	// Deletes a logs-based metric.
	DeleteLogMetric(context.Context, *DeleteLogMetricRequest) (*google_protobuf5.Empty, error)
}

func RegisterMetricsServiceV2Server(s *grpc.Server, srv MetricsServiceV2Server) {
	s.RegisterService(&_MetricsServiceV2_serviceDesc, srv)
}

func _MetricsServiceV2_ListLogMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLogMetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsServiceV2Server).ListLogMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.MetricsServiceV2/ListLogMetrics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsServiceV2Server).ListLogMetrics(ctx, req.(*ListLogMetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricsServiceV2_GetLogMetric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLogMetricRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsServiceV2Server).GetLogMetric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.MetricsServiceV2/GetLogMetric",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsServiceV2Server).GetLogMetric(ctx, req.(*GetLogMetricRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricsServiceV2_CreateLogMetric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateLogMetricRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsServiceV2Server).CreateLogMetric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.MetricsServiceV2/CreateLogMetric",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsServiceV2Server).CreateLogMetric(ctx, req.(*CreateLogMetricRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricsServiceV2_UpdateLogMetric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateLogMetricRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsServiceV2Server).UpdateLogMetric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.MetricsServiceV2/UpdateLogMetric",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsServiceV2Server).UpdateLogMetric(ctx, req.(*UpdateLogMetricRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricsServiceV2_DeleteLogMetric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteLogMetricRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsServiceV2Server).DeleteLogMetric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.MetricsServiceV2/DeleteLogMetric",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsServiceV2Server).DeleteLogMetric(ctx, req.(*DeleteLogMetricRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _MetricsServiceV2_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.logging.v2.MetricsServiceV2",
	HandlerType: (*MetricsServiceV2Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListLogMetrics",
			Handler:    _MetricsServiceV2_ListLogMetrics_Handler,
		},
		{
			MethodName: "GetLogMetric",
			Handler:    _MetricsServiceV2_GetLogMetric_Handler,
		},
		{
			MethodName: "CreateLogMetric",
			Handler:    _MetricsServiceV2_CreateLogMetric_Handler,
		},
		{
			MethodName: "UpdateLogMetric",
			Handler:    _MetricsServiceV2_UpdateLogMetric_Handler,
		},
		{
			MethodName: "DeleteLogMetric",
			Handler:    _MetricsServiceV2_DeleteLogMetric_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/logging/v2/logging_metrics.proto",
}

func init() { proto.RegisterFile("google/logging/v2/logging_metrics.proto", fileDescriptor3) }

var fileDescriptor3 = []byte{
	// 835 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x56, 0xc1, 0x6e, 0xdb, 0x46,
	0x10, 0xed, 0xca, 0xb6, 0x1c, 0x8f, 0x1b, 0x4b, 0xd9, 0x24, 0x8a, 0xa0, 0x28, 0x88, 0xca, 0x83,
	0xa4, 0xf8, 0x40, 0x36, 0x6c, 0x61, 0xa4, 0x29, 0x7a, 0x88, 0x62, 0x23, 0x28, 0xa0, 0xb4, 0x06,
	0xd3, 0xea, 0x50, 0x14, 0x20, 0x28, 0x69, 0x44, 0x6c, 0x45, 0x71, 0x59, 0xee, 0x4a, 0xb0, 0x53,
	0xe4, 0x52, 0xa4, 0xa7, 0x02, 0x3d, 0xb4, 0x1f, 0xd0, 0x7b, 0x7f, 0xa7, 0xfd, 0x84, 0x7e, 0x44,
	0x8f, 0x05, 0x97, 0x4b, 0x99, 0x91, 0x18, 0xcb, 0xf0, 0xc9, 0xbb, 0x33, 0x6f, 0xf6, 0xbd, 0x99,
	0x79, 0xb2, 0x04, 0x1d, 0x9f, 0x73, 0x3f, 0x40, 0x2b, 0xe0, 0xbe, 0xcf, 0x42, 0xdf, 0x5a, 0xd8,
	0xd9, 0xd1, 0x9d, 0xa1, 0x8c, 0xd9, 0x48, 0x98, 0x51, 0xcc, 0x25, 0xa7, 0xb7, 0x52, 0xa0, 0xa9,
	0xb3, 0xe6, 0xc2, 0x6e, 0x34, 0x75, 0xad, 0x17, 0x31, 0xcb, 0x0b, 0x43, 0x2e, 0x3d, 0xc9, 0x78,
	0xa8, 0x0b, 0x1a, 0x0f, 0x72, 0xd9, 0x31, 0x13, 0x32, 0x66, 0xc3, 0x79, 0x92, 0xd7, 0xe9, 0x7b,
	0xb9, 0x74, 0xca, 0xa4, 0x13, 0xf7, 0x75, 0x42, 0xdd, 0x86, 0xf3, 0x89, 0x85, 0xb3, 0x48, 0x9e,
	0xeb, 0x64, 0x6b, 0x35, 0x39, 0x61, 0x18, 0x8c, 0xdd, 0x99, 0x27, 0xa6, 0x29, 0xc2, 0xf8, 0x73,
	0x1b, 0xf6, 0xfa, 0xdc, 0x7f, 0xa9, 0x9e, 0xa4, 0x14, 0xb6, 0x43, 0x6f, 0x86, 0x75, 0xd2, 0x22,
	0xdd, 0x3d, 0x47, 0x9d, 0x69, 0x0b, 0xf6, 0xc7, 0x28, 0x46, 0x31, 0x8b, 0x12, 0x39, 0xf5, 0x92,
	0x4a, 0xe5, 0x43, 0xb4, 0x06, 0xe5, 0x09, 0x0b, 0x24, 0xc6, 0xf5, 0x2d, 0x95, 0xd4, 0x37, 0xfa,
	0x25, 0xdc, 0x4a, 0xa5, 0xba, 0x19, 0x9a, 0xc7, 0xf5, 0x9d, 0x16, 0xe9, 0xee, 0xdb, 0x4d, 0x53,
	0xcf, 0xc7, 0x8b, 0x98, 0x99, 0x92, 0x1f, 0x2f, 0x31, 0x4e, 0x75, 0xb6, 0x12, 0xa1, 0x1d, 0xa8,
	0x2c, 0xbc, 0x60, 0x8e, 0x2e, 0x9e, 0xc9, 0xd8, 0x1b, 0x25, 0x0f, 0x95, 0x15, 0xd7, 0x81, 0x0a,
	0x9f, 0x64, 0x51, 0xfa, 0x3d, 0x54, 0x03, 0x6f, 0x88, 0xc1, 0x05, 0x50, 0xd4, 0x77, 0x5b, 0x5b,
	0xdd, 0x7d, 0xfb, 0xb1, 0xb9, 0xb6, 0x12, 0x73, 0xd9, 0xb9, 0xd9, 0x4f, 0x8a, 0x96, 0xcf, 0x88,
	0x93, 0x50, 0xc6, 0xe7, 0x4e, 0x25, 0x78, 0x37, 0x4a, 0x5f, 0xc2, 0xc1, 0x70, 0x3e, 0x9a, 0xa2,
	0x74, 0xb9, 0x6a, 0x5d, 0xd4, 0x6f, 0xa8, 0x76, 0xda, 0xf9, 0x76, 0x8e, 0xf3, 0xdb, 0xeb, 0x29,
	0xf8, 0xd7, 0x29, 0xda, 0xb9, 0x39, 0xcc, 0x5f, 0xe9, 0x33, 0xd8, 0x5d, 0x60, 0x2c, 0x92, 0xb1,
	0x6e, 0xb7, 0x48, 0xf7, 0xc0, 0xee, 0x5c, 0xaa, 0xf1, 0x59, 0xc4, 0x06, 0x29, 0xdc, 0xc9, 0xea,
	0x1a, 0x3d, 0xb8, 0x53, 0x24, 0x9d, 0x56, 0x61, 0x6b, 0x8a, 0xe7, 0x7a, 0x91, 0xc9, 0x91, 0xde,
	0x81, 0x1d, 0x35, 0x2b, 0xbd, 0xc1, 0xf4, 0xf2, 0xb4, 0xf4, 0x84, 0x18, 0x4d, 0x80, 0x8b, 0xa7,
	0x69, 0x19, 0x4a, 0x03, 0xbb, 0xfa, 0x81, 0xfa, 0xfb, 0xb8, 0x4a, 0x8c, 0x29, 0xdc, 0xed, 0x33,
	0x21, 0x97, 0x32, 0x84, 0x83, 0x3f, 0xce, 0x51, 0xc8, 0x64, 0xed, 0x91, 0x17, 0x63, 0x28, 0x35,
	0x8b, 0xbe, 0xd1, 0x07, 0x00, 0x91, 0xe7, 0xa3, 0x2b, 0xf9, 0x14, 0x33, 0xbf, 0xec, 0x25, 0x91,
	0x6f, 0x92, 0x00, 0xbd, 0x0f, 0xea, 0xe2, 0x0a, 0xf6, 0x1a, 0x95, 0x61, 0x76, 0x9c, 0x1b, 0x49,
	0xe0, 0x15, 0x7b, 0x8d, 0xc6, 0x19, 0xd4, 0x56, 0xc9, 0x44, 0xc4, 0x43, 0x81, 0xf4, 0x08, 0x76,
	0xf5, 0x27, 0xac, 0x4e, 0xd4, 0x3e, 0x9b, 0x97, 0xcd, 0xca, 0xc9, 0xc0, 0xb4, 0x0d, 0x95, 0x10,
	0xcf, 0xa4, 0xbb, 0x26, 0xe9, 0x66, 0x12, 0x3e, 0xcd, 0x64, 0x19, 0x47, 0x70, 0xfb, 0x05, 0x5e,
	0x10, 0x67, 0x4d, 0x3e, 0x84, 0x7d, 0xed, 0xe1, 0xdc, 0x07, 0x03, 0xd2, 0xd0, 0x57, 0xde, 0x0c,
	0x8d, 0x09, 0xd4, 0x9e, 0xc7, 0xe8, 0x49, 0x5c, 0x2b, 0x7d, 0xdf, 0x7c, 0x3e, 0x85, 0x72, 0x5a,
	0xaf, 0x84, 0x6c, 0x6a, 0x44, 0x63, 0x0d, 0x0e, 0xb5, 0x6f, 0xa3, 0x71, 0x11, 0xcf, 0x26, 0x89,
	0xd7, 0x24, 0xfc, 0x0c, 0x6a, 0xc7, 0x18, 0xe0, 0x35, 0x08, 0xed, 0x7f, 0x76, 0xa0, 0xaa, 0xf7,
	0xf7, 0x0a, 0xe3, 0x05, 0x1b, 0xe1, 0xc0, 0xa6, 0xbf, 0x11, 0x38, 0x78, 0x77, 0xb7, 0xb4, 0x5b,
	0x24, 0xa4, 0xc8, 0x6b, 0x8d, 0x47, 0x57, 0x40, 0xa6, 0x46, 0x31, 0x3a, 0x3f, 0xff, 0xfd, 0xef,
	0x1f, 0xa5, 0x8f, 0xe8, 0xc3, 0xe4, 0x9f, 0xf3, 0x4f, 0xe9, 0xcc, 0xbf, 0x88, 0x62, 0xfe, 0x03,
	0x8e, 0xa4, 0xb0, 0x0e, 0xdf, 0x58, 0x99, 0x33, 0xde, 0x12, 0xf8, 0x30, 0xbf, 0x72, 0xda, 0x2e,
	0x20, 0x29, 0xf0, 0x44, 0xe3, 0xd2, 0xf9, 0x19, 0xa6, 0xe2, 0xef, 0xd2, 0xb6, 0xe2, 0xcf, 0x0d,
	0x2a, 0x27, 0x22, 0xd3, 0x60, 0x1d, 0xbe, 0xa1, 0xbf, 0x12, 0xa8, 0xac, 0x38, 0x88, 0x16, 0xb5,
	0x5b, 0xec, 0xb2, 0x0d, 0x62, 0x2c, 0x25, 0xe6, 0x91, 0xb1, 0x69, 0x18, 0x4f, 0xf5, 0xd6, 0xe9,
	0xef, 0x04, 0x2a, 0x2b, 0x3e, 0x2b, 0x54, 0x53, 0xec, 0xc5, 0x0d, 0x6a, 0x8e, 0x94, 0x9a, 0x8f,
	0x1b, 0x57, 0x1c, 0xcd, 0x52, 0xd4, 0x5b, 0x02, 0x95, 0x15, 0x2f, 0x16, 0x8a, 0x2a, 0xf6, 0x6b,
	0xa3, 0x96, 0x41, 0xb3, 0xaf, 0x41, 0xf3, 0x24, 0xf9, 0x8e, 0xcc, 0x36, 0x75, 0x78, 0x45, 0x39,
	0xbd, 0x5f, 0x08, 0xdc, 0x1d, 0xf1, 0xd9, 0x3a, 0x71, 0xef, 0x76, 0x3f, 0x3d, 0x6b, 0x2f, 0x9e,
	0x26, 0x3c, 0xa7, 0xe4, 0xbb, 0x27, 0x1a, 0xe9, 0xf3, 0xc0, 0x0b, 0x7d, 0x93, 0xc7, 0xbe, 0xe5,
	0x63, 0xa8, 0x54, 0x58, 0x69, 0xca, 0x8b, 0x98, 0xc8, 0xfd, 0x98, 0xf8, 0x5c, 0x1f, 0xff, 0x23,
	0xe4, 0xaf, 0xd2, 0xbd, 0x17, 0x69, 0xf5, 0xf3, 0x80, 0xcf, 0xc7, 0xa6, 0x66, 0x30, 0x07, 0xf6,
	0xb0, 0xac, 0x5e, 0xf8, 0xe4, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x51, 0x07, 0x4b, 0xa6, 0x8d,
	0x08, 0x00, 0x00,
}
