// Created by go generate; DO NOT EDIT
// Copyright 2014 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package gosrc

const (
	goRepoPath  = 1
	packagePath = 2
)

var pathFlags = map[string]int{
	"C":                                   2,
	"archive":                             1,
	"archive/tar":                         3,
	"archive/zip":                         3,
	"bufio":                               3,
	"builtin":                             3,
	"bytes":                               3,
	"cmd":                                 1,
	"cmd/addr2line":                       3,
	"cmd/api":                             3,
	"cmd/asm":                             3,
	"cmd/asm/internal":                    1,
	"cmd/asm/internal/arch":               3,
	"cmd/asm/internal/asm":                3,
	"cmd/asm/internal/flags":              3,
	"cmd/asm/internal/lex":                3,
	"cmd/buildid":                         3,
	"cmd/cgo":                             3,
	"cmd/compile":                         3,
	"cmd/compile/internal":                1,
	"cmd/compile/internal/amd64":          3,
	"cmd/compile/internal/arm":            3,
	"cmd/compile/internal/arm64":          3,
	"cmd/compile/internal/gc":             3,
	"cmd/compile/internal/mips":           3,
	"cmd/compile/internal/mips64":         3,
	"cmd/compile/internal/ppc64":          3,
	"cmd/compile/internal/s390x":          3,
	"cmd/compile/internal/ssa":            3,
	"cmd/compile/internal/syntax":         3,
	"cmd/compile/internal/test":           3,
	"cmd/compile/internal/types":          3,
	"cmd/compile/internal/wasm":           3,
	"cmd/compile/internal/x86":            3,
	"cmd/cover":                           3,
	"cmd/dist":                            3,
	"cmd/doc":                             3,
	"cmd/fix":                             3,
	"cmd/go":                              3,
	"cmd/go/internal":                     1,
	"cmd/go/internal/auth":                3,
	"cmd/go/internal/base":                3,
	"cmd/go/internal/bug":                 3,
	"cmd/go/internal/cache":               3,
	"cmd/go/internal/cfg":                 3,
	"cmd/go/internal/clean":               3,
	"cmd/go/internal/cmdflag":             3,
	"cmd/go/internal/dirhash":             3,
	"cmd/go/internal/doc":                 3,
	"cmd/go/internal/envcmd":              3,
	"cmd/go/internal/fix":                 3,
	"cmd/go/internal/fmtcmd":              3,
	"cmd/go/internal/generate":            3,
	"cmd/go/internal/get":                 3,
	"cmd/go/internal/help":                3,
	"cmd/go/internal/imports":             3,
	"cmd/go/internal/list":                3,
	"cmd/go/internal/load":                3,
	"cmd/go/internal/lockedfile":          3,
	"cmd/go/internal/lockedfile/internal": 1,
	"cmd/go/internal/lockedfile/internal/filelock":         3,
	"cmd/go/internal/modcmd":                               3,
	"cmd/go/internal/modconv":                              3,
	"cmd/go/internal/modfetch":                             3,
	"cmd/go/internal/modfetch/codehost":                    3,
	"cmd/go/internal/modfile":                              3,
	"cmd/go/internal/modget":                               3,
	"cmd/go/internal/modinfo":                              3,
	"cmd/go/internal/modload":                              3,
	"cmd/go/internal/module":                               3,
	"cmd/go/internal/mvs":                                  3,
	"cmd/go/internal/note":                                 3,
	"cmd/go/internal/par":                                  3,
	"cmd/go/internal/renameio":                             3,
	"cmd/go/internal/robustio":                             3,
	"cmd/go/internal/run":                                  3,
	"cmd/go/internal/search":                               3,
	"cmd/go/internal/semver":                               3,
	"cmd/go/internal/str":                                  3,
	"cmd/go/internal/sumweb":                               3,
	"cmd/go/internal/test":                                 3,
	"cmd/go/internal/tlog":                                 3,
	"cmd/go/internal/tool":                                 3,
	"cmd/go/internal/txtar":                                3,
	"cmd/go/internal/version":                              3,
	"cmd/go/internal/vet":                                  3,
	"cmd/go/internal/web":                                  3,
	"cmd/go/internal/work":                                 3,
	"cmd/gofmt":                                            3,
	"cmd/internal":                                         1,
	"cmd/internal/bio":                                     3,
	"cmd/internal/browser":                                 3,
	"cmd/internal/buildid":                                 3,
	"cmd/internal/dwarf":                                   3,
	"cmd/internal/edit":                                    3,
	"cmd/internal/gcprog":                                  3,
	"cmd/internal/goobj":                                   3,
	"cmd/internal/obj":                                     3,
	"cmd/internal/obj/arm":                                 3,
	"cmd/internal/obj/arm64":                               3,
	"cmd/internal/obj/mips":                                3,
	"cmd/internal/obj/ppc64":                               3,
	"cmd/internal/obj/s390x":                               3,
	"cmd/internal/obj/wasm":                                3,
	"cmd/internal/obj/x86":                                 3,
	"cmd/internal/objabi":                                  3,
	"cmd/internal/objfile":                                 3,
	"cmd/internal/src":                                     3,
	"cmd/internal/sys":                                     3,
	"cmd/internal/test2json":                               3,
	"cmd/link":                                             3,
	"cmd/link/internal":                                    1,
	"cmd/link/internal/amd64":                              3,
	"cmd/link/internal/arm":                                3,
	"cmd/link/internal/arm64":                              3,
	"cmd/link/internal/ld":                                 3,
	"cmd/link/internal/loadelf":                            3,
	"cmd/link/internal/loadmacho":                          3,
	"cmd/link/internal/loadpe":                             3,
	"cmd/link/internal/loadxcoff":                          3,
	"cmd/link/internal/mips":                               3,
	"cmd/link/internal/mips64":                             3,
	"cmd/link/internal/objfile":                            3,
	"cmd/link/internal/ppc64":                              3,
	"cmd/link/internal/s390x":                              3,
	"cmd/link/internal/sym":                                3,
	"cmd/link/internal/wasm":                               3,
	"cmd/link/internal/x86":                                3,
	"cmd/nm":                                               3,
	"cmd/objdump":                                          3,
	"cmd/pack":                                             3,
	"cmd/pprof":                                            3,
	"cmd/test2json":                                        3,
	"cmd/trace":                                            3,
	"cmd/vendor":                                           1,
	"cmd/vendor/github.com":                                1,
	"cmd/vendor/github.com/google":                         1,
	"cmd/vendor/github.com/google/pprof":                   1,
	"cmd/vendor/github.com/google/pprof/driver":            3,
	"cmd/vendor/github.com/google/pprof/internal":          1,
	"cmd/vendor/github.com/google/pprof/internal/binutils": 3,
	"cmd/vendor/github.com/google/pprof/internal/driver":   3,
	"cmd/vendor/github.com/google/pprof/internal/elfexec":  3,
	"cmd/vendor/github.com/google/pprof/internal/graph":    3,
	"cmd/vendor/github.com/google/pprof/internal/measurement":                3,
	"cmd/vendor/github.com/google/pprof/internal/plugin":                     3,
	"cmd/vendor/github.com/google/pprof/internal/report":                     3,
	"cmd/vendor/github.com/google/pprof/internal/symbolizer":                 3,
	"cmd/vendor/github.com/google/pprof/internal/symbolz":                    3,
	"cmd/vendor/github.com/google/pprof/internal/transport":                  3,
	"cmd/vendor/github.com/google/pprof/profile":                             3,
	"cmd/vendor/github.com/google/pprof/third_party":                         1,
	"cmd/vendor/github.com/google/pprof/third_party/d3":                      3,
	"cmd/vendor/github.com/google/pprof/third_party/d3flamegraph":            3,
	"cmd/vendor/github.com/google/pprof/third_party/svgpan":                  3,
	"cmd/vendor/github.com/ianlancetaylor":                                   1,
	"cmd/vendor/github.com/ianlancetaylor/demangle":                          3,
	"cmd/vendor/golang.org":                                                  1,
	"cmd/vendor/golang.org/x":                                                1,
	"cmd/vendor/golang.org/x/arch":                                           1,
	"cmd/vendor/golang.org/x/arch/arm":                                       1,
	"cmd/vendor/golang.org/x/arch/arm/armasm":                                3,
	"cmd/vendor/golang.org/x/arch/arm64":                                     1,
	"cmd/vendor/golang.org/x/arch/arm64/arm64asm":                            3,
	"cmd/vendor/golang.org/x/arch/ppc64":                                     1,
	"cmd/vendor/golang.org/x/arch/ppc64/ppc64asm":                            3,
	"cmd/vendor/golang.org/x/arch/x86":                                       1,
	"cmd/vendor/golang.org/x/arch/x86/x86asm":                                3,
	"cmd/vendor/golang.org/x/crypto":                                         1,
	"cmd/vendor/golang.org/x/crypto/ssh":                                     1,
	"cmd/vendor/golang.org/x/crypto/ssh/terminal":                            3,
	"cmd/vendor/golang.org/x/sys":                                            1,
	"cmd/vendor/golang.org/x/sys/unix":                                       3,
	"cmd/vendor/golang.org/x/sys/windows":                                    3,
	"cmd/vendor/golang.org/x/tools":                                          1,
	"cmd/vendor/golang.org/x/tools/go":                                       1,
	"cmd/vendor/golang.org/x/tools/go/analysis":                              3,
	"cmd/vendor/golang.org/x/tools/go/analysis/internal":                     1,
	"cmd/vendor/golang.org/x/tools/go/analysis/internal/analysisflags":       3,
	"cmd/vendor/golang.org/x/tools/go/analysis/internal/facts":               3,
	"cmd/vendor/golang.org/x/tools/go/analysis/passes":                       1,
	"cmd/vendor/golang.org/x/tools/go/analysis/passes/asmdecl":               3,
	"cmd/vendor/golang.org/x/tools/go/analysis/passes/assign":                3,
	"cmd/vendor/golang.org/x/tools/go/analysis/passes/atomic":                3,
	"cmd/vendor/golang.org/x/tools/go/analysis/passes/bools":                 3,
	"cmd/vendor/golang.org/x/tools/go/analysis/passes/buildtag":              3,
	"cmd/vendor/golang.org/x/tools/go/analysis/passes/cgocall":               3,
	"cmd/vendor/golang.org/x/tools/go/analysis/passes/composite":             3,
	"cmd/vendor/golang.org/x/tools/go/analysis/passes/copylock":              3,
	"cmd/vendor/golang.org/x/tools/go/analysis/passes/ctrlflow":              3,
	"cmd/vendor/golang.org/x/tools/go/analysis/passes/errorsas":              3,
	"cmd/vendor/golang.org/x/tools/go/analysis/passes/httpresponse":          3,
	"cmd/vendor/golang.org/x/tools/go/analysis/passes/inspect":               3,
	"cmd/vendor/golang.org/x/tools/go/analysis/passes/internal":              1,
	"cmd/vendor/golang.org/x/tools/go/analysis/passes/internal/analysisutil": 3,
	"cmd/vendor/golang.org/x/tools/go/analysis/passes/loopclosure":           3,
	"cmd/vendor/golang.org/x/tools/go/analysis/passes/lostcancel":            3,
	"cmd/vendor/golang.org/x/tools/go/analysis/passes/nilfunc":               3,
	"cmd/vendor/golang.org/x/tools/go/analysis/passes/printf":                3,
	"cmd/vendor/golang.org/x/tools/go/analysis/passes/shift":                 3,
	"cmd/vendor/golang.org/x/tools/go/analysis/passes/stdmethods":            3,
	"cmd/vendor/golang.org/x/tools/go/analysis/passes/structtag":             3,
	"cmd/vendor/golang.org/x/tools/go/analysis/passes/tests":                 3,
	"cmd/vendor/golang.org/x/tools/go/analysis/passes/unmarshal":             3,
	"cmd/vendor/golang.org/x/tools/go/analysis/passes/unreachable":           3,
	"cmd/vendor/golang.org/x/tools/go/analysis/passes/unsafeptr":             3,
	"cmd/vendor/golang.org/x/tools/go/analysis/passes/unusedresult":          3,
	"cmd/vendor/golang.org/x/tools/go/analysis/unitchecker":                  3,
	"cmd/vendor/golang.org/x/tools/go/ast":                                   1,
	"cmd/vendor/golang.org/x/tools/go/ast/astutil":                           3,
	"cmd/vendor/golang.org/x/tools/go/ast/inspector":                         3,
	"cmd/vendor/golang.org/x/tools/go/cfg":                                   3,
	"cmd/vendor/golang.org/x/tools/go/types":                                 1,
	"cmd/vendor/golang.org/x/tools/go/types/objectpath":                      3,
	"cmd/vendor/golang.org/x/tools/go/types/typeutil":                        3,
	"cmd/vet":                              3,
	"compress":                             1,
	"compress/bzip2":                       3,
	"compress/flate":                       3,
	"compress/gzip":                        3,
	"compress/lzw":                         3,
	"compress/zlib":                        3,
	"container":                            1,
	"container/heap":                       3,
	"container/list":                       3,
	"container/ring":                       3,
	"context":                              3,
	"crypto":                               3,
	"crypto/aes":                           3,
	"crypto/cipher":                        3,
	"crypto/des":                           3,
	"crypto/dsa":                           3,
	"crypto/ecdsa":                         3,
	"crypto/ed25519":                       3,
	"crypto/ed25519/internal":              1,
	"crypto/ed25519/internal/edwards25519": 3,
	"crypto/elliptic":                      3,
	"crypto/hmac":                          3,
	"crypto/internal":                      1,
	"crypto/internal/randutil":             3,
	"crypto/internal/subtle":               3,
	"crypto/md5":                           3,
	"crypto/rand":                          3,
	"crypto/rc4":                           3,
	"crypto/rsa":                           3,
	"crypto/sha1":                          3,
	"crypto/sha256":                        3,
	"crypto/sha512":                        3,
	"crypto/subtle":                        3,
	"crypto/tls":                           3,
	"crypto/x509":                          3,
	"crypto/x509/pkix":                     3,
	"database":                             1,
	"database/sql":                         3,
	"database/sql/driver":                  3,
	"debug":                                1,
	"debug/dwarf":                          3,
	"debug/elf":                            3,
	"debug/gosym":                          3,
	"debug/macho":                          3,
	"debug/pe":                             3,
	"debug/plan9obj":                       3,
	"encoding":                             3,
	"encoding/ascii85":                     3,
	"encoding/asn1":                        3,
	"encoding/base32":                      3,
	"encoding/base64":                      3,
	"encoding/binary":                      3,
	"encoding/csv":                         3,
	"encoding/gob":                         3,
	"encoding/hex":                         3,
	"encoding/json":                        3,
	"encoding/pem":                         3,
	"encoding/xml":                         3,
	"errors":                               3,
	"expvar":                               3,
	"flag":                                 3,
	"fmt":                                  3,
	"go":                                   1,
	"go/ast":                               3,
	"go/build":                             3,
	"go/constant":                          3,
	"go/doc":                               3,
	"go/format":                            3,
	"go/importer":                          3,
	"go/internal":                          1,
	"go/internal/gccgoimporter":            3,
	"go/internal/gcimporter":               3,
	"go/internal/srcimporter":              3,
	"go/parser":                            3,
	"go/printer":                           3,
	"go/scanner":                           3,
	"go/token":                             3,
	"go/types":                             3,
	"hash":                                 3,
	"hash/adler32":                         3,
	"hash/crc32":                           3,
	"hash/crc64":                           3,
	"hash/fnv":                             3,
	"html":                                 3,
	"html/template":                        3,
	"image":                                3,
	"image/color":                          3,
	"image/color/palette":                  3,
	"image/draw":                           3,
	"image/gif":                            3,
	"image/internal":                       1,
	"image/internal/imageutil":             3,
	"image/jpeg":                           3,
	"image/png":                            3,
	"index":                                1,
	"index/suffixarray":                    3,
	"internal":                             1,
	"internal/bytealg":                     3,
	"internal/cfg":                         3,
	"internal/cpu":                         3,
	"internal/fmtsort":                     3,
	"internal/goroot":                      3,
	"internal/goversion":                   3,
	"internal/lazyregexp":                  3,
	"internal/lazytemplate":                3,
	"internal/nettrace":                    3,
	"internal/oserror":                     3,
	"internal/poll":                        3,
	"internal/race":                        3,
	"internal/reflectlite":                 3,
	"internal/singleflight":                3,
	"internal/syscall":                     1,
	"internal/syscall/unix":                3,
	"internal/syscall/windows":             3,
	"internal/syscall/windows/registry":    3,
	"internal/syscall/windows/sysdll":      3,
	"internal/testenv":                     3,
	"internal/testlog":                     3,
	"internal/trace":                       3,
	"internal/xcoff":                       3,
	"io":                                   3,
	"io/ioutil":                            3,
	"log":                                  3,
	"log/syslog":                           3,
	"math":                                 3,
	"math/big":                             3,
	"math/bits":                            3,
	"math/cmplx":                           3,
	"math/rand":                            3,
	"mime":                                 3,
	"mime/multipart":                       3,
	"mime/quotedprintable":                 3,
	"net":                                  3,
	"net/http":                             3,
	"net/http/cgi":                         3,
	"net/http/cookiejar":                   3,
	"net/http/fcgi":                        3,
	"net/http/httptest":                    3,
	"net/http/httptrace":                   3,
	"net/http/httputil":                    3,
	"net/http/internal":                    3,
	"net/http/pprof":                       3,
	"net/internal":                         1,
	"net/internal/socktest":                3,
	"net/mail":                             3,
	"net/rpc":                              3,
	"net/rpc/jsonrpc":                      3,
	"net/smtp":                             3,
	"net/textproto":                        3,
	"net/url":                              3,
	"os":                                   3,
	"os/exec":                              3,
	"os/signal":                            3,
	"os/signal/internal":                   1,
	"os/signal/internal/pty":               3,
	"os/user":                              3,
	"path":                                 3,
	"path/filepath":                        3,
	"plugin":                               3,
	"reflect":                              3,
	"regexp":                               3,
	"regexp/syntax":                        3,
	"runtime":                              3,
	"runtime/cgo":                          3,
	"runtime/debug":                        3,
	"runtime/internal":                     1,
	"runtime/internal/atomic":              3,
	"runtime/internal/math":                3,
	"runtime/internal/sys":                 3,
	"runtime/pprof":                        3,
	"runtime/pprof/internal":               1,
	"runtime/pprof/internal/profile":       3,
	"runtime/race":                         3,
	"runtime/trace":                        3,
	"sort":                                 3,
	"strconv":                              3,
	"strings":                              3,
	"sync":                                 3,
	"sync/atomic":                          3,
	"syscall":                              3,
	"syscall/js":                           3,
	"testing":                              3,
	"testing/internal":                     1,
	"testing/internal/testdeps":            3,
	"testing/iotest":                       3,
	"testing/quick":                        3,
	"text":                                 1,
	"text/scanner":                         3,
	"text/tabwriter":                       3,
	"text/template":                        3,
	"text/template/parse":                  3,
	"time":                                 3,
	"unicode":                              3,
	"unicode/utf16":                        3,
	"unicode/utf8":                         3,
	"unsafe":                               3,
	"vendor":                               1,
	"vendor/golang.org":                    1,
	"vendor/golang.org/x":                  1,
	"vendor/golang.org/x/crypto":           1,
	"vendor/golang.org/x/crypto/chacha20poly1305":  3,
	"vendor/golang.org/x/crypto/cryptobyte":        3,
	"vendor/golang.org/x/crypto/cryptobyte/asn1":   3,
	"vendor/golang.org/x/crypto/curve25519":        3,
	"vendor/golang.org/x/crypto/hkdf":              3,
	"vendor/golang.org/x/crypto/internal":          1,
	"vendor/golang.org/x/crypto/internal/chacha20": 3,
	"vendor/golang.org/x/crypto/internal/subtle":   3,
	"vendor/golang.org/x/crypto/poly1305":          3,
	"vendor/golang.org/x/net":                      1,
	"vendor/golang.org/x/net/dns":                  1,
	"vendor/golang.org/x/net/dns/dnsmessage":       3,
	"vendor/golang.org/x/net/http":                 1,
	"vendor/golang.org/x/net/http/httpguts":        3,
	"vendor/golang.org/x/net/http/httpproxy":       3,
	"vendor/golang.org/x/net/http2":                1,
	"vendor/golang.org/x/net/http2/hpack":          3,
	"vendor/golang.org/x/net/idna":                 3,
	"vendor/golang.org/x/net/lif":                  3,
	"vendor/golang.org/x/net/nettest":              3,
	"vendor/golang.org/x/net/route":                3,
	"vendor/golang.org/x/sys":                      1,
	"vendor/golang.org/x/sys/cpu":                  3,
	"vendor/golang.org/x/text":                     1,
	"vendor/golang.org/x/text/secure":              1,
	"vendor/golang.org/x/text/secure/bidirule":     3,
	"vendor/golang.org/x/text/transform":           3,
	"vendor/golang.org/x/text/unicode":             1,
	"vendor/golang.org/x/text/unicode/bidi":        3,
	"vendor/golang.org/x/text/unicode/norm":        3,
}

var validTLDs = map[string]bool{
	".aaa":                      true,
	".aarp":                     true,
	".abarth":                   true,
	".abb":                      true,
	".abbott":                   true,
	".abbvie":                   true,
	".abc":                      true,
	".able":                     true,
	".abogado":                  true,
	".abudhabi":                 true,
	".ac":                       true,
	".academy":                  true,
	".accenture":                true,
	".accountant":               true,
	".accountants":              true,
	".aco":                      true,
	".actor":                    true,
	".ad":                       true,
	".adac":                     true,
	".ads":                      true,
	".adult":                    true,
	".ae":                       true,
	".aeg":                      true,
	".aero":                     true,
	".aetna":                    true,
	".af":                       true,
	".afamilycompany":           true,
	".afl":                      true,
	".africa":                   true,
	".ag":                       true,
	".agakhan":                  true,
	".agency":                   true,
	".ai":                       true,
	".aig":                      true,
	".aigo":                     true,
	".airbus":                   true,
	".airforce":                 true,
	".airtel":                   true,
	".akdn":                     true,
	".al":                       true,
	".alfaromeo":                true,
	".alibaba":                  true,
	".alipay":                   true,
	".allfinanz":                true,
	".allstate":                 true,
	".ally":                     true,
	".alsace":                   true,
	".alstom":                   true,
	".am":                       true,
	".americanexpress":          true,
	".americanfamily":           true,
	".amex":                     true,
	".amfam":                    true,
	".amica":                    true,
	".amsterdam":                true,
	".analytics":                true,
	".android":                  true,
	".anquan":                   true,
	".anz":                      true,
	".ao":                       true,
	".aol":                      true,
	".apartments":               true,
	".app":                      true,
	".apple":                    true,
	".aq":                       true,
	".aquarelle":                true,
	".ar":                       true,
	".arab":                     true,
	".aramco":                   true,
	".archi":                    true,
	".army":                     true,
	".arpa":                     true,
	".art":                      true,
	".arte":                     true,
	".as":                       true,
	".asda":                     true,
	".asia":                     true,
	".associates":               true,
	".at":                       true,
	".athleta":                  true,
	".attorney":                 true,
	".au":                       true,
	".auction":                  true,
	".audi":                     true,
	".audible":                  true,
	".audio":                    true,
	".auspost":                  true,
	".author":                   true,
	".auto":                     true,
	".autos":                    true,
	".avianca":                  true,
	".aw":                       true,
	".aws":                      true,
	".ax":                       true,
	".axa":                      true,
	".az":                       true,
	".azure":                    true,
	".ba":                       true,
	".baby":                     true,
	".baidu":                    true,
	".banamex":                  true,
	".bananarepublic":           true,
	".band":                     true,
	".bank":                     true,
	".bar":                      true,
	".barcelona":                true,
	".barclaycard":              true,
	".barclays":                 true,
	".barefoot":                 true,
	".bargains":                 true,
	".baseball":                 true,
	".basketball":               true,
	".bauhaus":                  true,
	".bayern":                   true,
	".bb":                       true,
	".bbc":                      true,
	".bbt":                      true,
	".bbva":                     true,
	".bcg":                      true,
	".bcn":                      true,
	".bd":                       true,
	".be":                       true,
	".beats":                    true,
	".beauty":                   true,
	".beer":                     true,
	".bentley":                  true,
	".berlin":                   true,
	".best":                     true,
	".bestbuy":                  true,
	".bet":                      true,
	".bf":                       true,
	".bg":                       true,
	".bh":                       true,
	".bharti":                   true,
	".bi":                       true,
	".bible":                    true,
	".bid":                      true,
	".bike":                     true,
	".bing":                     true,
	".bingo":                    true,
	".bio":                      true,
	".biz":                      true,
	".bj":                       true,
	".black":                    true,
	".blackfriday":              true,
	".blockbuster":              true,
	".blog":                     true,
	".bloomberg":                true,
	".blue":                     true,
	".bm":                       true,
	".bms":                      true,
	".bmw":                      true,
	".bn":                       true,
	".bnpparibas":               true,
	".bo":                       true,
	".boats":                    true,
	".boehringer":               true,
	".bofa":                     true,
	".bom":                      true,
	".bond":                     true,
	".boo":                      true,
	".book":                     true,
	".booking":                  true,
	".bosch":                    true,
	".bostik":                   true,
	".boston":                   true,
	".bot":                      true,
	".boutique":                 true,
	".box":                      true,
	".br":                       true,
	".bradesco":                 true,
	".bridgestone":              true,
	".broadway":                 true,
	".broker":                   true,
	".brother":                  true,
	".brussels":                 true,
	".bs":                       true,
	".bt":                       true,
	".budapest":                 true,
	".bugatti":                  true,
	".build":                    true,
	".builders":                 true,
	".business":                 true,
	".buy":                      true,
	".buzz":                     true,
	".bv":                       true,
	".bw":                       true,
	".by":                       true,
	".bz":                       true,
	".bzh":                      true,
	".ca":                       true,
	".cab":                      true,
	".cafe":                     true,
	".cal":                      true,
	".call":                     true,
	".calvinklein":              true,
	".cam":                      true,
	".camera":                   true,
	".camp":                     true,
	".cancerresearch":           true,
	".canon":                    true,
	".capetown":                 true,
	".capital":                  true,
	".capitalone":               true,
	".car":                      true,
	".caravan":                  true,
	".cards":                    true,
	".care":                     true,
	".career":                   true,
	".careers":                  true,
	".cars":                     true,
	".cartier":                  true,
	".casa":                     true,
	".case":                     true,
	".caseih":                   true,
	".cash":                     true,
	".casino":                   true,
	".cat":                      true,
	".catering":                 true,
	".catholic":                 true,
	".cba":                      true,
	".cbn":                      true,
	".cbre":                     true,
	".cbs":                      true,
	".cc":                       true,
	".cd":                       true,
	".ceb":                      true,
	".center":                   true,
	".ceo":                      true,
	".cern":                     true,
	".cf":                       true,
	".cfa":                      true,
	".cfd":                      true,
	".cg":                       true,
	".ch":                       true,
	".chanel":                   true,
	".channel":                  true,
	".charity":                  true,
	".chase":                    true,
	".chat":                     true,
	".cheap":                    true,
	".chintai":                  true,
	".christmas":                true,
	".chrome":                   true,
	".chrysler":                 true,
	".church":                   true,
	".ci":                       true,
	".cipriani":                 true,
	".circle":                   true,
	".cisco":                    true,
	".citadel":                  true,
	".citi":                     true,
	".citic":                    true,
	".city":                     true,
	".cityeats":                 true,
	".ck":                       true,
	".cl":                       true,
	".claims":                   true,
	".cleaning":                 true,
	".click":                    true,
	".clinic":                   true,
	".clinique":                 true,
	".clothing":                 true,
	".cloud":                    true,
	".club":                     true,
	".clubmed":                  true,
	".cm":                       true,
	".cn":                       true,
	".co":                       true,
	".coach":                    true,
	".codes":                    true,
	".coffee":                   true,
	".college":                  true,
	".cologne":                  true,
	".com":                      true,
	".comcast":                  true,
	".commbank":                 true,
	".community":                true,
	".company":                  true,
	".compare":                  true,
	".computer":                 true,
	".comsec":                   true,
	".condos":                   true,
	".construction":             true,
	".consulting":               true,
	".contact":                  true,
	".contractors":              true,
	".cooking":                  true,
	".cookingchannel":           true,
	".cool":                     true,
	".coop":                     true,
	".corsica":                  true,
	".country":                  true,
	".coupon":                   true,
	".coupons":                  true,
	".courses":                  true,
	".cr":                       true,
	".credit":                   true,
	".creditcard":               true,
	".creditunion":              true,
	".cricket":                  true,
	".crown":                    true,
	".crs":                      true,
	".cruise":                   true,
	".cruises":                  true,
	".csc":                      true,
	".cu":                       true,
	".cuisinella":               true,
	".cv":                       true,
	".cw":                       true,
	".cx":                       true,
	".cy":                       true,
	".cymru":                    true,
	".cyou":                     true,
	".cz":                       true,
	".dabur":                    true,
	".dad":                      true,
	".dance":                    true,
	".data":                     true,
	".date":                     true,
	".dating":                   true,
	".datsun":                   true,
	".day":                      true,
	".dclk":                     true,
	".dds":                      true,
	".de":                       true,
	".deal":                     true,
	".dealer":                   true,
	".deals":                    true,
	".degree":                   true,
	".delivery":                 true,
	".dell":                     true,
	".deloitte":                 true,
	".delta":                    true,
	".democrat":                 true,
	".dental":                   true,
	".dentist":                  true,
	".desi":                     true,
	".design":                   true,
	".dev":                      true,
	".dhl":                      true,
	".diamonds":                 true,
	".diet":                     true,
	".digital":                  true,
	".direct":                   true,
	".directory":                true,
	".discount":                 true,
	".discover":                 true,
	".dish":                     true,
	".diy":                      true,
	".dj":                       true,
	".dk":                       true,
	".dm":                       true,
	".dnp":                      true,
	".do":                       true,
	".docs":                     true,
	".doctor":                   true,
	".dodge":                    true,
	".dog":                      true,
	".domains":                  true,
	".dot":                      true,
	".download":                 true,
	".drive":                    true,
	".dtv":                      true,
	".dubai":                    true,
	".duck":                     true,
	".dunlop":                   true,
	".dupont":                   true,
	".durban":                   true,
	".dvag":                     true,
	".dvr":                      true,
	".dz":                       true,
	".earth":                    true,
	".eat":                      true,
	".ec":                       true,
	".eco":                      true,
	".edeka":                    true,
	".edu":                      true,
	".education":                true,
	".ee":                       true,
	".eg":                       true,
	".email":                    true,
	".emerck":                   true,
	".energy":                   true,
	".engineer":                 true,
	".engineering":              true,
	".enterprises":              true,
	".epson":                    true,
	".equipment":                true,
	".er":                       true,
	".ericsson":                 true,
	".erni":                     true,
	".es":                       true,
	".esq":                      true,
	".estate":                   true,
	".esurance":                 true,
	".et":                       true,
	".etisalat":                 true,
	".eu":                       true,
	".eurovision":               true,
	".eus":                      true,
	".events":                   true,
	".everbank":                 true,
	".exchange":                 true,
	".expert":                   true,
	".exposed":                  true,
	".express":                  true,
	".extraspace":               true,
	".fage":                     true,
	".fail":                     true,
	".fairwinds":                true,
	".faith":                    true,
	".family":                   true,
	".fan":                      true,
	".fans":                     true,
	".farm":                     true,
	".farmers":                  true,
	".fashion":                  true,
	".fast":                     true,
	".fedex":                    true,
	".feedback":                 true,
	".ferrari":                  true,
	".ferrero":                  true,
	".fi":                       true,
	".fiat":                     true,
	".fidelity":                 true,
	".fido":                     true,
	".film":                     true,
	".final":                    true,
	".finance":                  true,
	".financial":                true,
	".fire":                     true,
	".firestone":                true,
	".firmdale":                 true,
	".fish":                     true,
	".fishing":                  true,
	".fit":                      true,
	".fitness":                  true,
	".fj":                       true,
	".fk":                       true,
	".flickr":                   true,
	".flights":                  true,
	".flir":                     true,
	".florist":                  true,
	".flowers":                  true,
	".fly":                      true,
	".fm":                       true,
	".fo":                       true,
	".foo":                      true,
	".food":                     true,
	".foodnetwork":              true,
	".football":                 true,
	".ford":                     true,
	".forex":                    true,
	".forsale":                  true,
	".forum":                    true,
	".foundation":               true,
	".fox":                      true,
	".fr":                       true,
	".free":                     true,
	".fresenius":                true,
	".frl":                      true,
	".frogans":                  true,
	".frontdoor":                true,
	".frontier":                 true,
	".ftr":                      true,
	".fujitsu":                  true,
	".fujixerox":                true,
	".fun":                      true,
	".fund":                     true,
	".furniture":                true,
	".futbol":                   true,
	".fyi":                      true,
	".ga":                       true,
	".gal":                      true,
	".gallery":                  true,
	".gallo":                    true,
	".gallup":                   true,
	".game":                     true,
	".games":                    true,
	".gap":                      true,
	".garden":                   true,
	".gay":                      true,
	".gb":                       true,
	".gbiz":                     true,
	".gd":                       true,
	".gdn":                      true,
	".ge":                       true,
	".gea":                      true,
	".gent":                     true,
	".genting":                  true,
	".george":                   true,
	".gf":                       true,
	".gg":                       true,
	".ggee":                     true,
	".gh":                       true,
	".gi":                       true,
	".gift":                     true,
	".gifts":                    true,
	".gives":                    true,
	".giving":                   true,
	".gl":                       true,
	".glade":                    true,
	".glass":                    true,
	".gle":                      true,
	".global":                   true,
	".globo":                    true,
	".gm":                       true,
	".gmail":                    true,
	".gmbh":                     true,
	".gmo":                      true,
	".gmx":                      true,
	".gn":                       true,
	".godaddy":                  true,
	".gold":                     true,
	".goldpoint":                true,
	".golf":                     true,
	".goo":                      true,
	".goodyear":                 true,
	".goog":                     true,
	".google":                   true,
	".gop":                      true,
	".got":                      true,
	".gov":                      true,
	".gp":                       true,
	".gq":                       true,
	".gr":                       true,
	".grainger":                 true,
	".graphics":                 true,
	".gratis":                   true,
	".green":                    true,
	".gripe":                    true,
	".grocery":                  true,
	".group":                    true,
	".gs":                       true,
	".gt":                       true,
	".gu":                       true,
	".guardian":                 true,
	".gucci":                    true,
	".guge":                     true,
	".guide":                    true,
	".guitars":                  true,
	".guru":                     true,
	".gw":                       true,
	".gy":                       true,
	".hair":                     true,
	".hamburg":                  true,
	".hangout":                  true,
	".haus":                     true,
	".hbo":                      true,
	".hdfc":                     true,
	".hdfcbank":                 true,
	".health":                   true,
	".healthcare":               true,
	".help":                     true,
	".helsinki":                 true,
	".here":                     true,
	".hermes":                   true,
	".hgtv":                     true,
	".hiphop":                   true,
	".hisamitsu":                true,
	".hitachi":                  true,
	".hiv":                      true,
	".hk":                       true,
	".hkt":                      true,
	".hm":                       true,
	".hn":                       true,
	".hockey":                   true,
	".holdings":                 true,
	".holiday":                  true,
	".homedepot":                true,
	".homegoods":                true,
	".homes":                    true,
	".homesense":                true,
	".honda":                    true,
	".horse":                    true,
	".hospital":                 true,
	".host":                     true,
	".hosting":                  true,
	".hot":                      true,
	".hoteles":                  true,
	".hotels":                   true,
	".hotmail":                  true,
	".house":                    true,
	".how":                      true,
	".hr":                       true,
	".hsbc":                     true,
	".ht":                       true,
	".hu":                       true,
	".hughes":                   true,
	".hyatt":                    true,
	".hyundai":                  true,
	".ibm":                      true,
	".icbc":                     true,
	".ice":                      true,
	".icu":                      true,
	".id":                       true,
	".ie":                       true,
	".ieee":                     true,
	".ifm":                      true,
	".ikano":                    true,
	".il":                       true,
	".im":                       true,
	".imamat":                   true,
	".imdb":                     true,
	".immo":                     true,
	".immobilien":               true,
	".in":                       true,
	".inc":                      true,
	".industries":               true,
	".infiniti":                 true,
	".info":                     true,
	".ing":                      true,
	".ink":                      true,
	".institute":                true,
	".insurance":                true,
	".insure":                   true,
	".int":                      true,
	".intel":                    true,
	".international":            true,
	".intuit":                   true,
	".investments":              true,
	".io":                       true,
	".ipiranga":                 true,
	".iq":                       true,
	".ir":                       true,
	".irish":                    true,
	".is":                       true,
	".ismaili":                  true,
	".ist":                      true,
	".istanbul":                 true,
	".it":                       true,
	".itau":                     true,
	".itv":                      true,
	".iveco":                    true,
	".jaguar":                   true,
	".java":                     true,
	".jcb":                      true,
	".jcp":                      true,
	".je":                       true,
	".jeep":                     true,
	".jetzt":                    true,
	".jewelry":                  true,
	".jio":                      true,
	".jll":                      true,
	".jm":                       true,
	".jmp":                      true,
	".jnj":                      true,
	".jo":                       true,
	".jobs":                     true,
	".joburg":                   true,
	".jot":                      true,
	".joy":                      true,
	".jp":                       true,
	".jpmorgan":                 true,
	".jprs":                     true,
	".juegos":                   true,
	".juniper":                  true,
	".kaufen":                   true,
	".kddi":                     true,
	".ke":                       true,
	".kerryhotels":              true,
	".kerrylogistics":           true,
	".kerryproperties":          true,
	".kfh":                      true,
	".kg":                       true,
	".kh":                       true,
	".ki":                       true,
	".kia":                      true,
	".kim":                      true,
	".kinder":                   true,
	".kindle":                   true,
	".kitchen":                  true,
	".kiwi":                     true,
	".km":                       true,
	".kn":                       true,
	".koeln":                    true,
	".komatsu":                  true,
	".kosher":                   true,
	".kp":                       true,
	".kpmg":                     true,
	".kpn":                      true,
	".kr":                       true,
	".krd":                      true,
	".kred":                     true,
	".kuokgroup":                true,
	".kw":                       true,
	".ky":                       true,
	".kyoto":                    true,
	".kz":                       true,
	".la":                       true,
	".lacaixa":                  true,
	".ladbrokes":                true,
	".lamborghini":              true,
	".lamer":                    true,
	".lancaster":                true,
	".lancia":                   true,
	".lancome":                  true,
	".land":                     true,
	".landrover":                true,
	".lanxess":                  true,
	".lasalle":                  true,
	".lat":                      true,
	".latino":                   true,
	".latrobe":                  true,
	".law":                      true,
	".lawyer":                   true,
	".lb":                       true,
	".lc":                       true,
	".lds":                      true,
	".lease":                    true,
	".leclerc":                  true,
	".lefrak":                   true,
	".legal":                    true,
	".lego":                     true,
	".lexus":                    true,
	".lgbt":                     true,
	".li":                       true,
	".liaison":                  true,
	".lidl":                     true,
	".life":                     true,
	".lifeinsurance":            true,
	".lifestyle":                true,
	".lighting":                 true,
	".like":                     true,
	".lilly":                    true,
	".limited":                  true,
	".limo":                     true,
	".lincoln":                  true,
	".linde":                    true,
	".link":                     true,
	".lipsy":                    true,
	".live":                     true,
	".living":                   true,
	".lixil":                    true,
	".lk":                       true,
	".llc":                      true,
	".loan":                     true,
	".loans":                    true,
	".locker":                   true,
	".locus":                    true,
	".loft":                     true,
	".lol":                      true,
	".london":                   true,
	".lotte":                    true,
	".lotto":                    true,
	".love":                     true,
	".lpl":                      true,
	".lplfinancial":             true,
	".lr":                       true,
	".ls":                       true,
	".lt":                       true,
	".ltd":                      true,
	".ltda":                     true,
	".lu":                       true,
	".lundbeck":                 true,
	".lupin":                    true,
	".luxe":                     true,
	".luxury":                   true,
	".lv":                       true,
	".ly":                       true,
	".ma":                       true,
	".macys":                    true,
	".madrid":                   true,
	".maif":                     true,
	".maison":                   true,
	".makeup":                   true,
	".man":                      true,
	".management":               true,
	".mango":                    true,
	".map":                      true,
	".market":                   true,
	".marketing":                true,
	".markets":                  true,
	".marriott":                 true,
	".marshalls":                true,
	".maserati":                 true,
	".mattel":                   true,
	".mba":                      true,
	".mc":                       true,
	".mckinsey":                 true,
	".md":                       true,
	".me":                       true,
	".med":                      true,
	".media":                    true,
	".meet":                     true,
	".melbourne":                true,
	".meme":                     true,
	".memorial":                 true,
	".men":                      true,
	".menu":                     true,
	".merckmsd":                 true,
	".metlife":                  true,
	".mg":                       true,
	".mh":                       true,
	".miami":                    true,
	".microsoft":                true,
	".mil":                      true,
	".mini":                     true,
	".mint":                     true,
	".mit":                      true,
	".mitsubishi":               true,
	".mk":                       true,
	".ml":                       true,
	".mlb":                      true,
	".mls":                      true,
	".mm":                       true,
	".mma":                      true,
	".mn":                       true,
	".mo":                       true,
	".mobi":                     true,
	".mobile":                   true,
	".mobily":                   true,
	".moda":                     true,
	".moe":                      true,
	".moi":                      true,
	".mom":                      true,
	".monash":                   true,
	".money":                    true,
	".monster":                  true,
	".mopar":                    true,
	".mormon":                   true,
	".mortgage":                 true,
	".moscow":                   true,
	".moto":                     true,
	".motorcycles":              true,
	".mov":                      true,
	".movie":                    true,
	".movistar":                 true,
	".mp":                       true,
	".mq":                       true,
	".mr":                       true,
	".ms":                       true,
	".msd":                      true,
	".mt":                       true,
	".mtn":                      true,
	".mtr":                      true,
	".mu":                       true,
	".museum":                   true,
	".mutual":                   true,
	".mv":                       true,
	".mw":                       true,
	".mx":                       true,
	".my":                       true,
	".mz":                       true,
	".na":                       true,
	".nab":                      true,
	".nadex":                    true,
	".nagoya":                   true,
	".name":                     true,
	".nationwide":               true,
	".natura":                   true,
	".navy":                     true,
	".nba":                      true,
	".nc":                       true,
	".ne":                       true,
	".nec":                      true,
	".net":                      true,
	".netbank":                  true,
	".netflix":                  true,
	".network":                  true,
	".neustar":                  true,
	".new":                      true,
	".newholland":               true,
	".news":                     true,
	".next":                     true,
	".nextdirect":               true,
	".nexus":                    true,
	".nf":                       true,
	".nfl":                      true,
	".ng":                       true,
	".ngo":                      true,
	".nhk":                      true,
	".ni":                       true,
	".nico":                     true,
	".nike":                     true,
	".nikon":                    true,
	".ninja":                    true,
	".nissan":                   true,
	".nissay":                   true,
	".nl":                       true,
	".no":                       true,
	".nokia":                    true,
	".northwesternmutual":       true,
	".norton":                   true,
	".now":                      true,
	".nowruz":                   true,
	".nowtv":                    true,
	".np":                       true,
	".nr":                       true,
	".nra":                      true,
	".nrw":                      true,
	".ntt":                      true,
	".nu":                       true,
	".nyc":                      true,
	".nz":                       true,
	".obi":                      true,
	".observer":                 true,
	".off":                      true,
	".office":                   true,
	".okinawa":                  true,
	".olayan":                   true,
	".olayangroup":              true,
	".oldnavy":                  true,
	".ollo":                     true,
	".om":                       true,
	".omega":                    true,
	".one":                      true,
	".ong":                      true,
	".onl":                      true,
	".online":                   true,
	".onyourside":               true,
	".ooo":                      true,
	".open":                     true,
	".oracle":                   true,
	".orange":                   true,
	".org":                      true,
	".organic":                  true,
	".origins":                  true,
	".osaka":                    true,
	".otsuka":                   true,
	".ott":                      true,
	".ovh":                      true,
	".pa":                       true,
	".page":                     true,
	".panasonic":                true,
	".paris":                    true,
	".pars":                     true,
	".partners":                 true,
	".parts":                    true,
	".party":                    true,
	".passagens":                true,
	".pay":                      true,
	".pccw":                     true,
	".pe":                       true,
	".pet":                      true,
	".pf":                       true,
	".pfizer":                   true,
	".pg":                       true,
	".ph":                       true,
	".pharmacy":                 true,
	".phd":                      true,
	".philips":                  true,
	".phone":                    true,
	".photo":                    true,
	".photography":              true,
	".photos":                   true,
	".physio":                   true,
	".piaget":                   true,
	".pics":                     true,
	".pictet":                   true,
	".pictures":                 true,
	".pid":                      true,
	".pin":                      true,
	".ping":                     true,
	".pink":                     true,
	".pioneer":                  true,
	".pizza":                    true,
	".pk":                       true,
	".pl":                       true,
	".place":                    true,
	".play":                     true,
	".playstation":              true,
	".plumbing":                 true,
	".plus":                     true,
	".pm":                       true,
	".pn":                       true,
	".pnc":                      true,
	".pohl":                     true,
	".poker":                    true,
	".politie":                  true,
	".porn":                     true,
	".post":                     true,
	".pr":                       true,
	".pramerica":                true,
	".praxi":                    true,
	".press":                    true,
	".prime":                    true,
	".pro":                      true,
	".prod":                     true,
	".productions":              true,
	".prof":                     true,
	".progressive":              true,
	".promo":                    true,
	".properties":               true,
	".property":                 true,
	".protection":               true,
	".pru":                      true,
	".prudential":               true,
	".ps":                       true,
	".pt":                       true,
	".pub":                      true,
	".pw":                       true,
	".pwc":                      true,
	".py":                       true,
	".qa":                       true,
	".qpon":                     true,
	".quebec":                   true,
	".quest":                    true,
	".qvc":                      true,
	".racing":                   true,
	".radio":                    true,
	".raid":                     true,
	".re":                       true,
	".read":                     true,
	".realestate":               true,
	".realtor":                  true,
	".realty":                   true,
	".recipes":                  true,
	".red":                      true,
	".redstone":                 true,
	".redumbrella":              true,
	".rehab":                    true,
	".reise":                    true,
	".reisen":                   true,
	".reit":                     true,
	".reliance":                 true,
	".ren":                      true,
	".rent":                     true,
	".rentals":                  true,
	".repair":                   true,
	".report":                   true,
	".republican":               true,
	".rest":                     true,
	".restaurant":               true,
	".review":                   true,
	".reviews":                  true,
	".rexroth":                  true,
	".rich":                     true,
	".richardli":                true,
	".ricoh":                    true,
	".rightathome":              true,
	".ril":                      true,
	".rio":                      true,
	".rip":                      true,
	".rmit":                     true,
	".ro":                       true,
	".rocher":                   true,
	".rocks":                    true,
	".rodeo":                    true,
	".rogers":                   true,
	".room":                     true,
	".rs":                       true,
	".rsvp":                     true,
	".ru":                       true,
	".rugby":                    true,
	".ruhr":                     true,
	".run":                      true,
	".rw":                       true,
	".rwe":                      true,
	".ryukyu":                   true,
	".sa":                       true,
	".saarland":                 true,
	".safe":                     true,
	".safety":                   true,
	".sakura":                   true,
	".sale":                     true,
	".salon":                    true,
	".samsclub":                 true,
	".samsung":                  true,
	".sandvik":                  true,
	".sandvikcoromant":          true,
	".sanofi":                   true,
	".sap":                      true,
	".sarl":                     true,
	".sas":                      true,
	".save":                     true,
	".saxo":                     true,
	".sb":                       true,
	".sbi":                      true,
	".sbs":                      true,
	".sc":                       true,
	".sca":                      true,
	".scb":                      true,
	".schaeffler":               true,
	".schmidt":                  true,
	".scholarships":             true,
	".school":                   true,
	".schule":                   true,
	".schwarz":                  true,
	".science":                  true,
	".scjohnson":                true,
	".scor":                     true,
	".scot":                     true,
	".sd":                       true,
	".se":                       true,
	".search":                   true,
	".seat":                     true,
	".secure":                   true,
	".security":                 true,
	".seek":                     true,
	".select":                   true,
	".sener":                    true,
	".services":                 true,
	".ses":                      true,
	".seven":                    true,
	".sew":                      true,
	".sex":                      true,
	".sexy":                     true,
	".sfr":                      true,
	".sg":                       true,
	".sh":                       true,
	".shangrila":                true,
	".sharp":                    true,
	".shaw":                     true,
	".shell":                    true,
	".shia":                     true,
	".shiksha":                  true,
	".shoes":                    true,
	".shop":                     true,
	".shopping":                 true,
	".shouji":                   true,
	".show":                     true,
	".showtime":                 true,
	".shriram":                  true,
	".si":                       true,
	".silk":                     true,
	".sina":                     true,
	".singles":                  true,
	".site":                     true,
	".sj":                       true,
	".sk":                       true,
	".ski":                      true,
	".skin":                     true,
	".sky":                      true,
	".skype":                    true,
	".sl":                       true,
	".sling":                    true,
	".sm":                       true,
	".smart":                    true,
	".smile":                    true,
	".sn":                       true,
	".sncf":                     true,
	".so":                       true,
	".soccer":                   true,
	".social":                   true,
	".softbank":                 true,
	".software":                 true,
	".sohu":                     true,
	".solar":                    true,
	".solutions":                true,
	".song":                     true,
	".sony":                     true,
	".soy":                      true,
	".space":                    true,
	".sport":                    true,
	".spot":                     true,
	".spreadbetting":            true,
	".sr":                       true,
	".srl":                      true,
	".srt":                      true,
	".ss":                       true,
	".st":                       true,
	".stada":                    true,
	".staples":                  true,
	".star":                     true,
	".statebank":                true,
	".statefarm":                true,
	".stc":                      true,
	".stcgroup":                 true,
	".stockholm":                true,
	".storage":                  true,
	".store":                    true,
	".stream":                   true,
	".studio":                   true,
	".study":                    true,
	".style":                    true,
	".su":                       true,
	".sucks":                    true,
	".supplies":                 true,
	".supply":                   true,
	".support":                  true,
	".surf":                     true,
	".surgery":                  true,
	".suzuki":                   true,
	".sv":                       true,
	".swatch":                   true,
	".swiftcover":               true,
	".swiss":                    true,
	".sx":                       true,
	".sy":                       true,
	".sydney":                   true,
	".symantec":                 true,
	".systems":                  true,
	".sz":                       true,
	".tab":                      true,
	".taipei":                   true,
	".talk":                     true,
	".taobao":                   true,
	".target":                   true,
	".tatamotors":               true,
	".tatar":                    true,
	".tattoo":                   true,
	".tax":                      true,
	".taxi":                     true,
	".tc":                       true,
	".tci":                      true,
	".td":                       true,
	".tdk":                      true,
	".team":                     true,
	".tech":                     true,
	".technology":               true,
	".tel":                      true,
	".telefonica":               true,
	".temasek":                  true,
	".tennis":                   true,
	".teva":                     true,
	".tf":                       true,
	".tg":                       true,
	".th":                       true,
	".thd":                      true,
	".theater":                  true,
	".theatre":                  true,
	".tiaa":                     true,
	".tickets":                  true,
	".tienda":                   true,
	".tiffany":                  true,
	".tips":                     true,
	".tires":                    true,
	".tirol":                    true,
	".tj":                       true,
	".tjmaxx":                   true,
	".tjx":                      true,
	".tk":                       true,
	".tkmaxx":                   true,
	".tl":                       true,
	".tm":                       true,
	".tmall":                    true,
	".tn":                       true,
	".to":                       true,
	".today":                    true,
	".tokyo":                    true,
	".tools":                    true,
	".top":                      true,
	".toray":                    true,
	".toshiba":                  true,
	".total":                    true,
	".tours":                    true,
	".town":                     true,
	".toyota":                   true,
	".toys":                     true,
	".tr":                       true,
	".trade":                    true,
	".trading":                  true,
	".training":                 true,
	".travel":                   true,
	".travelchannel":            true,
	".travelers":                true,
	".travelersinsurance":       true,
	".trust":                    true,
	".trv":                      true,
	".tt":                       true,
	".tube":                     true,
	".tui":                      true,
	".tunes":                    true,
	".tushu":                    true,
	".tv":                       true,
	".tvs":                      true,
	".tw":                       true,
	".tz":                       true,
	".ua":                       true,
	".ubank":                    true,
	".ubs":                      true,
	".uconnect":                 true,
	".ug":                       true,
	".uk":                       true,
	".unicom":                   true,
	".university":               true,
	".uno":                      true,
	".uol":                      true,
	".ups":                      true,
	".us":                       true,
	".uy":                       true,
	".uz":                       true,
	".va":                       true,
	".vacations":                true,
	".vana":                     true,
	".vanguard":                 true,
	".vc":                       true,
	".ve":                       true,
	".vegas":                    true,
	".ventures":                 true,
	".verisign":                 true,
	".versicherung":             true,
	".vet":                      true,
	".vg":                       true,
	".vi":                       true,
	".viajes":                   true,
	".video":                    true,
	".vig":                      true,
	".viking":                   true,
	".villas":                   true,
	".vin":                      true,
	".vip":                      true,
	".virgin":                   true,
	".visa":                     true,
	".vision":                   true,
	".vistaprint":               true,
	".viva":                     true,
	".vivo":                     true,
	".vlaanderen":               true,
	".vn":                       true,
	".vodka":                    true,
	".volkswagen":               true,
	".volvo":                    true,
	".vote":                     true,
	".voting":                   true,
	".voto":                     true,
	".voyage":                   true,
	".vu":                       true,
	".vuelos":                   true,
	".wales":                    true,
	".walmart":                  true,
	".walter":                   true,
	".wang":                     true,
	".wanggou":                  true,
	".warman":                   true,
	".watch":                    true,
	".watches":                  true,
	".weather":                  true,
	".weatherchannel":           true,
	".webcam":                   true,
	".weber":                    true,
	".website":                  true,
	".wed":                      true,
	".wedding":                  true,
	".weibo":                    true,
	".weir":                     true,
	".wf":                       true,
	".whoswho":                  true,
	".wien":                     true,
	".wiki":                     true,
	".williamhill":              true,
	".win":                      true,
	".windows":                  true,
	".wine":                     true,
	".winners":                  true,
	".wme":                      true,
	".wolterskluwer":            true,
	".woodside":                 true,
	".work":                     true,
	".works":                    true,
	".world":                    true,
	".wow":                      true,
	".ws":                       true,
	".wtc":                      true,
	".wtf":                      true,
	".xbox":                     true,
	".xerox":                    true,
	".xfinity":                  true,
	".xihuan":                   true,
	".xin":                      true,
	".xn--11b4c3d":              true,
	".xn--1ck2e1b":              true,
	".xn--1qqw23a":              true,
	".xn--2scrj9c":              true,
	".xn--30rr7y":               true,
	".xn--3bst00m":              true,
	".xn--3ds443g":              true,
	".xn--3e0b707e":             true,
	".xn--3hcrj9c":              true,
	".xn--3oq18vl8pn36a":        true,
	".xn--3pxu8k":               true,
	".xn--42c2d9a":              true,
	".xn--45br5cyl":             true,
	".xn--45brj9c":              true,
	".xn--45q11c":               true,
	".xn--4gbrim":               true,
	".xn--54b7fta0cc":           true,
	".xn--55qw42g":              true,
	".xn--55qx5d":               true,
	".xn--5su34j936bgsg":        true,
	".xn--5tzm5g":               true,
	".xn--6frz82g":              true,
	".xn--6qq986b3xl":           true,
	".xn--80adxhks":             true,
	".xn--80ao21a":              true,
	".xn--80aqecdr1a":           true,
	".xn--80asehdb":             true,
	".xn--80aswg":               true,
	".xn--8y0a063a":             true,
	".xn--90a3ac":               true,
	".xn--90ae":                 true,
	".xn--90ais":                true,
	".xn--9dbq2a":               true,
	".xn--9et52u":               true,
	".xn--9krt00a":              true,
	".xn--b4w605ferd":           true,
	".xn--bck1b9a5dre4c":        true,
	".xn--c1avg":                true,
	".xn--c2br7g":               true,
	".xn--cck2b3b":              true,
	".xn--cg4bki":               true,
	".xn--clchc0ea0b2g2a9gcd":   true,
	".xn--czr694b":              true,
	".xn--czrs0t":               true,
	".xn--czru2d":               true,
	".xn--d1acj3b":              true,
	".xn--d1alf":                true,
	".xn--e1a4c":                true,
	".xn--eckvdtc9d":            true,
	".xn--efvy88h":              true,
	".xn--estv75g":              true,
	".xn--fct429k":              true,
	".xn--fhbei":                true,
	".xn--fiq228c5hs":           true,
	".xn--fiq64b":               true,
	".xn--fiqs8s":               true,
	".xn--fiqz9s":               true,
	".xn--fjq720a":              true,
	".xn--flw351e":              true,
	".xn--fpcrj9c3d":            true,
	".xn--fzc2c9e2c":            true,
	".xn--fzys8d69uvgm":         true,
	".xn--g2xx48c":              true,
	".xn--gckr3f0f":             true,
	".xn--gecrj9c":              true,
	".xn--gk3at1e":              true,
	".xn--h2breg3eve":           true,
	".xn--h2brj9c":              true,
	".xn--h2brj9c8c":            true,
	".xn--hxt814e":              true,
	".xn--i1b6b1a6a2e":          true,
	".xn--imr513n":              true,
	".xn--io0a7i":               true,
	".xn--j1aef":                true,
	".xn--j1amh":                true,
	".xn--j6w193g":              true,
	".xn--jlq61u9w7b":           true,
	".xn--jvr189m":              true,
	".xn--kcrx77d1x4a":          true,
	".xn--kprw13d":              true,
	".xn--kpry57d":              true,
	".xn--kpu716f":              true,
	".xn--kput3i":               true,
	".xn--l1acc":                true,
	".xn--lgbbat1ad8j":          true,
	".xn--mgb9awbf":             true,
	".xn--mgba3a3ejt":           true,
	".xn--mgba3a4f16a":          true,
	".xn--mgba7c0bbn0a":         true,
	".xn--mgbaakc7dvf":          true,
	".xn--mgbaam7a8h":           true,
	".xn--mgbab2bd":             true,
	".xn--mgbah1a3hjkrd":        true,
	".xn--mgbai9azgqp6j":        true,
	".xn--mgbayh7gpa":           true,
	".xn--mgbb9fbpob":           true,
	".xn--mgbbh1a":              true,
	".xn--mgbbh1a71e":           true,
	".xn--mgbc0a9azcg":          true,
	".xn--mgbca7dzdo":           true,
	".xn--mgberp4a5d4ar":        true,
	".xn--mgbgu82a":             true,
	".xn--mgbi4ecexp":           true,
	".xn--mgbpl2fh":             true,
	".xn--mgbt3dhd":             true,
	".xn--mgbtx2b":              true,
	".xn--mgbx4cd0ab":           true,
	".xn--mix891f":              true,
	".xn--mk1bu44c":             true,
	".xn--mxtq1m":               true,
	".xn--ngbc5azd":             true,
	".xn--ngbe9e0a":             true,
	".xn--ngbrx":                true,
	".xn--node":                 true,
	".xn--nqv7f":                true,
	".xn--nqv7fs00ema":          true,
	".xn--nyqy26a":              true,
	".xn--o3cw4h":               true,
	".xn--ogbpf8fl":             true,
	".xn--otu796d":              true,
	".xn--p1acf":                true,
	".xn--p1ai":                 true,
	".xn--pbt977c":              true,
	".xn--pgbs0dh":              true,
	".xn--pssy2u":               true,
	".xn--q9jyb4c":              true,
	".xn--qcka1pmc":             true,
	".xn--qxam":                 true,
	".xn--rhqv96g":              true,
	".xn--rovu88b":              true,
	".xn--rvc1e0am3e":           true,
	".xn--s9brj9c":              true,
	".xn--ses554g":              true,
	".xn--t60b56a":              true,
	".xn--tckwe":                true,
	".xn--tiq49xqyj":            true,
	".xn--unup4y":               true,
	".xn--vermgensberater-ctb":  true,
	".xn--vermgensberatung-pwb": true,
	".xn--vhquv":                true,
	".xn--vuq861b":              true,
	".xn--w4r85el8fhu5dnra":     true,
	".xn--w4rs40l":              true,
	".xn--wgbh1c":               true,
	".xn--wgbl6a":               true,
	".xn--xhq521b":              true,
	".xn--xkc2al3hye2a":         true,
	".xn--xkc2dl3a5ee0h":        true,
	".xn--y9a3aq":               true,
	".xn--yfro4i67o":            true,
	".xn--ygbi2ammx":            true,
	".xn--zfr164b":              true,
	".xxx":                      true,
	".xyz":                      true,
	".yachts":                   true,
	".yahoo":                    true,
	".yamaxun":                  true,
	".yandex":                   true,
	".ye":                       true,
	".yodobashi":                true,
	".yoga":                     true,
	".yokohama":                 true,
	".you":                      true,
	".youtube":                  true,
	".yt":                       true,
	".yun":                      true,
	".za":                       true,
	".zappos":                   true,
	".zara":                     true,
	".zero":                     true,
	".zip":                      true,
	".zm":                       true,
	".zone":                     true,
	".zuerich":                  true,
	".zw":                       true,
}
