// This file is generated by "./lib/proto/generate"

package proto

/*

ServiceWorker

*/

// ServiceWorkerRegistrationID ...
type ServiceWorkerRegistrationID string

// ServiceWorkerServiceWorkerRegistration ServiceWorker registration.
type ServiceWorkerServiceWorkerRegistration struct {
	// RegistrationID ...
	RegistrationID ServiceWorkerRegistrationID `json:"registrationId"`

	// ScopeURL ...
	ScopeURL string `json:"scopeURL"`

	// IsDeleted ...
	IsDeleted bool `json:"isDeleted"`
}

// ServiceWorkerServiceWorkerVersionRunningStatus ...
type ServiceWorkerServiceWorkerVersionRunningStatus string

const (
	// ServiceWorkerServiceWorkerVersionRunningStatusStopped enum const.
	ServiceWorkerServiceWorkerVersionRunningStatusStopped ServiceWorkerServiceWorkerVersionRunningStatus = "stopped"

	// ServiceWorkerServiceWorkerVersionRunningStatusStarting enum const.
	ServiceWorkerServiceWorkerVersionRunningStatusStarting ServiceWorkerServiceWorkerVersionRunningStatus = "starting"

	// ServiceWorkerServiceWorkerVersionRunningStatusRunning enum const.
	ServiceWorkerServiceWorkerVersionRunningStatusRunning ServiceWorkerServiceWorkerVersionRunningStatus = "running"

	// ServiceWorkerServiceWorkerVersionRunningStatusStopping enum const.
	ServiceWorkerServiceWorkerVersionRunningStatusStopping ServiceWorkerServiceWorkerVersionRunningStatus = "stopping"
)

// ServiceWorkerServiceWorkerVersionStatus ...
type ServiceWorkerServiceWorkerVersionStatus string

const (
	// ServiceWorkerServiceWorkerVersionStatusNew enum const.
	ServiceWorkerServiceWorkerVersionStatusNew ServiceWorkerServiceWorkerVersionStatus = "new"

	// ServiceWorkerServiceWorkerVersionStatusInstalling enum const.
	ServiceWorkerServiceWorkerVersionStatusInstalling ServiceWorkerServiceWorkerVersionStatus = "installing"

	// ServiceWorkerServiceWorkerVersionStatusInstalled enum const.
	ServiceWorkerServiceWorkerVersionStatusInstalled ServiceWorkerServiceWorkerVersionStatus = "installed"

	// ServiceWorkerServiceWorkerVersionStatusActivating enum const.
	ServiceWorkerServiceWorkerVersionStatusActivating ServiceWorkerServiceWorkerVersionStatus = "activating"

	// ServiceWorkerServiceWorkerVersionStatusActivated enum const.
	ServiceWorkerServiceWorkerVersionStatusActivated ServiceWorkerServiceWorkerVersionStatus = "activated"

	// ServiceWorkerServiceWorkerVersionStatusRedundant enum const.
	ServiceWorkerServiceWorkerVersionStatusRedundant ServiceWorkerServiceWorkerVersionStatus = "redundant"
)

// ServiceWorkerServiceWorkerVersion ServiceWorker version.
type ServiceWorkerServiceWorkerVersion struct {
	// VersionID ...
	VersionID string `json:"versionId"`

	// RegistrationID ...
	RegistrationID ServiceWorkerRegistrationID `json:"registrationId"`

	// ScriptURL ...
	ScriptURL string `json:"scriptURL"`

	// RunningStatus ...
	RunningStatus ServiceWorkerServiceWorkerVersionRunningStatus `json:"runningStatus"`

	// Status ...
	Status ServiceWorkerServiceWorkerVersionStatus `json:"status"`

	// ScriptLastModified (optional) The Last-Modified header value of the main script.
	ScriptLastModified *float64 `json:"scriptLastModified,omitempty"`

	// ScriptResponseTime (optional) The time at which the response headers of the main script were received from the server.
	// For cached script it is the last time the cache entry was validated.
	ScriptResponseTime *float64 `json:"scriptResponseTime,omitempty"`

	// ControlledClients (optional) ...
	ControlledClients []TargetTargetID `json:"controlledClients,omitempty"`

	// TargetID (optional) ...
	TargetID TargetTargetID `json:"targetId,omitempty"`
}

// ServiceWorkerServiceWorkerErrorMessage ServiceWorker error message.
type ServiceWorkerServiceWorkerErrorMessage struct {
	// ErrorMessage ...
	ErrorMessage string `json:"errorMessage"`

	// RegistrationID ...
	RegistrationID ServiceWorkerRegistrationID `json:"registrationId"`

	// VersionID ...
	VersionID string `json:"versionId"`

	// SourceURL ...
	SourceURL string `json:"sourceURL"`

	// LineNumber ...
	LineNumber int `json:"lineNumber"`

	// ColumnNumber ...
	ColumnNumber int `json:"columnNumber"`
}

// ServiceWorkerDeliverPushMessage ...
type ServiceWorkerDeliverPushMessage struct {
	// Origin ...
	Origin string `json:"origin"`

	// RegistrationID ...
	RegistrationID ServiceWorkerRegistrationID `json:"registrationId"`

	// Data ...
	Data string `json:"data"`
}

// ProtoReq name.
func (m ServiceWorkerDeliverPushMessage) ProtoReq() string { return "ServiceWorker.deliverPushMessage" }

// Call sends the request.
func (m ServiceWorkerDeliverPushMessage) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// ServiceWorkerDisable ...
type ServiceWorkerDisable struct{}

// ProtoReq name.
func (m ServiceWorkerDisable) ProtoReq() string { return "ServiceWorker.disable" }

// Call sends the request.
func (m ServiceWorkerDisable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// ServiceWorkerDispatchSyncEvent ...
type ServiceWorkerDispatchSyncEvent struct {
	// Origin ...
	Origin string `json:"origin"`

	// RegistrationID ...
	RegistrationID ServiceWorkerRegistrationID `json:"registrationId"`

	// Tag ...
	Tag string `json:"tag"`

	// LastChance ...
	LastChance bool `json:"lastChance"`
}

// ProtoReq name.
func (m ServiceWorkerDispatchSyncEvent) ProtoReq() string { return "ServiceWorker.dispatchSyncEvent" }

// Call sends the request.
func (m ServiceWorkerDispatchSyncEvent) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// ServiceWorkerDispatchPeriodicSyncEvent ...
type ServiceWorkerDispatchPeriodicSyncEvent struct {
	// Origin ...
	Origin string `json:"origin"`

	// RegistrationID ...
	RegistrationID ServiceWorkerRegistrationID `json:"registrationId"`

	// Tag ...
	Tag string `json:"tag"`
}

// ProtoReq name.
func (m ServiceWorkerDispatchPeriodicSyncEvent) ProtoReq() string {
	return "ServiceWorker.dispatchPeriodicSyncEvent"
}

// Call sends the request.
func (m ServiceWorkerDispatchPeriodicSyncEvent) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// ServiceWorkerEnable ...
type ServiceWorkerEnable struct{}

// ProtoReq name.
func (m ServiceWorkerEnable) ProtoReq() string { return "ServiceWorker.enable" }

// Call sends the request.
func (m ServiceWorkerEnable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// ServiceWorkerInspectWorker ...
type ServiceWorkerInspectWorker struct {
	// VersionID ...
	VersionID string `json:"versionId"`
}

// ProtoReq name.
func (m ServiceWorkerInspectWorker) ProtoReq() string { return "ServiceWorker.inspectWorker" }

// Call sends the request.
func (m ServiceWorkerInspectWorker) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// ServiceWorkerSetForceUpdateOnPageLoad ...
type ServiceWorkerSetForceUpdateOnPageLoad struct {
	// ForceUpdateOnPageLoad ...
	ForceUpdateOnPageLoad bool `json:"forceUpdateOnPageLoad"`
}

// ProtoReq name.
func (m ServiceWorkerSetForceUpdateOnPageLoad) ProtoReq() string {
	return "ServiceWorker.setForceUpdateOnPageLoad"
}

// Call sends the request.
func (m ServiceWorkerSetForceUpdateOnPageLoad) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// ServiceWorkerSkipWaiting ...
type ServiceWorkerSkipWaiting struct {
	// ScopeURL ...
	ScopeURL string `json:"scopeURL"`
}

// ProtoReq name.
func (m ServiceWorkerSkipWaiting) ProtoReq() string { return "ServiceWorker.skipWaiting" }

// Call sends the request.
func (m ServiceWorkerSkipWaiting) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// ServiceWorkerStartWorker ...
type ServiceWorkerStartWorker struct {
	// ScopeURL ...
	ScopeURL string `json:"scopeURL"`
}

// ProtoReq name.
func (m ServiceWorkerStartWorker) ProtoReq() string { return "ServiceWorker.startWorker" }

// Call sends the request.
func (m ServiceWorkerStartWorker) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// ServiceWorkerStopAllWorkers ...
type ServiceWorkerStopAllWorkers struct{}

// ProtoReq name.
func (m ServiceWorkerStopAllWorkers) ProtoReq() string { return "ServiceWorker.stopAllWorkers" }

// Call sends the request.
func (m ServiceWorkerStopAllWorkers) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// ServiceWorkerStopWorker ...
type ServiceWorkerStopWorker struct {
	// VersionID ...
	VersionID string `json:"versionId"`
}

// ProtoReq name.
func (m ServiceWorkerStopWorker) ProtoReq() string { return "ServiceWorker.stopWorker" }

// Call sends the request.
func (m ServiceWorkerStopWorker) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// ServiceWorkerUnregister ...
type ServiceWorkerUnregister struct {
	// ScopeURL ...
	ScopeURL string `json:"scopeURL"`
}

// ProtoReq name.
func (m ServiceWorkerUnregister) ProtoReq() string { return "ServiceWorker.unregister" }

// Call sends the request.
func (m ServiceWorkerUnregister) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// ServiceWorkerUpdateRegistration ...
type ServiceWorkerUpdateRegistration struct {
	// ScopeURL ...
	ScopeURL string `json:"scopeURL"`
}

// ProtoReq name.
func (m ServiceWorkerUpdateRegistration) ProtoReq() string { return "ServiceWorker.updateRegistration" }

// Call sends the request.
func (m ServiceWorkerUpdateRegistration) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// ServiceWorkerWorkerErrorReported ...
type ServiceWorkerWorkerErrorReported struct {
	// ErrorMessage ...
	ErrorMessage *ServiceWorkerServiceWorkerErrorMessage `json:"errorMessage"`
}

// ProtoEvent name.
func (evt ServiceWorkerWorkerErrorReported) ProtoEvent() string {
	return "ServiceWorker.workerErrorReported"
}

// ServiceWorkerWorkerRegistrationUpdated ...
type ServiceWorkerWorkerRegistrationUpdated struct {
	// Registrations ...
	Registrations []*ServiceWorkerServiceWorkerRegistration `json:"registrations"`
}

// ProtoEvent name.
func (evt ServiceWorkerWorkerRegistrationUpdated) ProtoEvent() string {
	return "ServiceWorker.workerRegistrationUpdated"
}

// ServiceWorkerWorkerVersionUpdated ...
type ServiceWorkerWorkerVersionUpdated struct {
	// Versions ...
	Versions []*ServiceWorkerServiceWorkerVersion `json:"versions"`
}

// ProtoEvent name.
func (evt ServiceWorkerWorkerVersionUpdated) ProtoEvent() string {
	return "ServiceWorker.workerVersionUpdated"
}
