// This file is generated by "./lib/proto/generate"

package proto

/*

Animation

*/

// AnimationAnimationType enum.
type AnimationAnimationType string

const (
	// AnimationAnimationTypeCSSTransition enum const.
	AnimationAnimationTypeCSSTransition AnimationAnimationType = "CSSTransition"

	// AnimationAnimationTypeCSSAnimation enum const.
	AnimationAnimationTypeCSSAnimation AnimationAnimationType = "CSSAnimation"

	// AnimationAnimationTypeWebAnimation enum const.
	AnimationAnimationTypeWebAnimation AnimationAnimationType = "WebAnimation"
)

// AnimationAnimation Animation instance.
type AnimationAnimation struct {
	// ID `Animation`'s id.
	ID string `json:"id"`

	// Name `Animation`'s name.
	Name string `json:"name"`

	// PausedState `Animation`'s internal paused state.
	PausedState bool `json:"pausedState"`

	// PlayState `Animation`'s play state.
	PlayState string `json:"playState"`

	// PlaybackRate `Animation`'s playback rate.
	PlaybackRate float64 `json:"playbackRate"`

	// StartTime `Animation`'s start time.
	StartTime float64 `json:"startTime"`

	// CurrentTime `Animation`'s current time.
	CurrentTime float64 `json:"currentTime"`

	// Type Animation type of `Animation`.
	Type AnimationAnimationType `json:"type"`

	// Source (optional) `Animation`'s source animation node.
	Source *AnimationAnimationEffect `json:"source,omitempty"`

	// CSSID (optional) A unique ID for `Animation` representing the sources that triggered this CSS
	// animation/transition.
	CSSID string `json:"cssId,omitempty"`
}

// AnimationAnimationEffect AnimationEffect instance.
type AnimationAnimationEffect struct {
	// Delay `AnimationEffect`'s delay.
	Delay float64 `json:"delay"`

	// EndDelay `AnimationEffect`'s end delay.
	EndDelay float64 `json:"endDelay"`

	// IterationStart `AnimationEffect`'s iteration start.
	IterationStart float64 `json:"iterationStart"`

	// Iterations `AnimationEffect`'s iterations.
	Iterations float64 `json:"iterations"`

	// Duration `AnimationEffect`'s iteration duration.
	Duration float64 `json:"duration"`

	// Direction `AnimationEffect`'s playback direction.
	Direction string `json:"direction"`

	// Fill `AnimationEffect`'s fill mode.
	Fill string `json:"fill"`

	// BackendNodeID (optional) `AnimationEffect`'s target node.
	BackendNodeID DOMBackendNodeID `json:"backendNodeId,omitempty"`

	// KeyframesRule (optional) `AnimationEffect`'s keyframes.
	KeyframesRule *AnimationKeyframesRule `json:"keyframesRule,omitempty"`

	// Easing `AnimationEffect`'s timing function.
	Easing string `json:"easing"`
}

// AnimationKeyframesRule Keyframes Rule.
type AnimationKeyframesRule struct {
	// Name (optional) CSS keyframed animation's name.
	Name string `json:"name,omitempty"`

	// Keyframes List of animation keyframes.
	Keyframes []*AnimationKeyframeStyle `json:"keyframes"`
}

// AnimationKeyframeStyle Keyframe Style.
type AnimationKeyframeStyle struct {
	// Offset Keyframe's time offset.
	Offset string `json:"offset"`

	// Easing `AnimationEffect`'s timing function.
	Easing string `json:"easing"`
}

// AnimationDisable Disables animation domain notifications.
type AnimationDisable struct{}

// ProtoReq name.
func (m AnimationDisable) ProtoReq() string { return "Animation.disable" }

// Call sends the request.
func (m AnimationDisable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// AnimationEnable Enables animation domain notifications.
type AnimationEnable struct{}

// ProtoReq name.
func (m AnimationEnable) ProtoReq() string { return "Animation.enable" }

// Call sends the request.
func (m AnimationEnable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// AnimationGetCurrentTime Returns the current time of the an animation.
type AnimationGetCurrentTime struct {
	// ID Id of animation.
	ID string `json:"id"`
}

// ProtoReq name.
func (m AnimationGetCurrentTime) ProtoReq() string { return "Animation.getCurrentTime" }

// Call the request.
func (m AnimationGetCurrentTime) Call(c Client) (*AnimationGetCurrentTimeResult, error) {
	var res AnimationGetCurrentTimeResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// AnimationGetCurrentTimeResult ...
type AnimationGetCurrentTimeResult struct {
	// CurrentTime Current time of the page.
	CurrentTime float64 `json:"currentTime"`
}

// AnimationGetPlaybackRate Gets the playback rate of the document timeline.
type AnimationGetPlaybackRate struct{}

// ProtoReq name.
func (m AnimationGetPlaybackRate) ProtoReq() string { return "Animation.getPlaybackRate" }

// Call the request.
func (m AnimationGetPlaybackRate) Call(c Client) (*AnimationGetPlaybackRateResult, error) {
	var res AnimationGetPlaybackRateResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// AnimationGetPlaybackRateResult ...
type AnimationGetPlaybackRateResult struct {
	// PlaybackRate Playback rate for animations on page.
	PlaybackRate float64 `json:"playbackRate"`
}

// AnimationReleaseAnimations Releases a set of animations to no longer be manipulated.
type AnimationReleaseAnimations struct {
	// Animations List of animation ids to seek.
	Animations []string `json:"animations"`
}

// ProtoReq name.
func (m AnimationReleaseAnimations) ProtoReq() string { return "Animation.releaseAnimations" }

// Call sends the request.
func (m AnimationReleaseAnimations) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// AnimationResolveAnimation Gets the remote object of the Animation.
type AnimationResolveAnimation struct {
	// AnimationID Animation id.
	AnimationID string `json:"animationId"`
}

// ProtoReq name.
func (m AnimationResolveAnimation) ProtoReq() string { return "Animation.resolveAnimation" }

// Call the request.
func (m AnimationResolveAnimation) Call(c Client) (*AnimationResolveAnimationResult, error) {
	var res AnimationResolveAnimationResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// AnimationResolveAnimationResult ...
type AnimationResolveAnimationResult struct {
	// RemoteObject Corresponding remote object.
	RemoteObject *RuntimeRemoteObject `json:"remoteObject"`
}

// AnimationSeekAnimations Seek a set of animations to a particular time within each animation.
type AnimationSeekAnimations struct {
	// Animations List of animation ids to seek.
	Animations []string `json:"animations"`

	// CurrentTime Set the current time of each animation.
	CurrentTime float64 `json:"currentTime"`
}

// ProtoReq name.
func (m AnimationSeekAnimations) ProtoReq() string { return "Animation.seekAnimations" }

// Call sends the request.
func (m AnimationSeekAnimations) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// AnimationSetPaused Sets the paused state of a set of animations.
type AnimationSetPaused struct {
	// Animations to set the pause state of.
	Animations []string `json:"animations"`

	// Paused state to set to.
	Paused bool `json:"paused"`
}

// ProtoReq name.
func (m AnimationSetPaused) ProtoReq() string { return "Animation.setPaused" }

// Call sends the request.
func (m AnimationSetPaused) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// AnimationSetPlaybackRate Sets the playback rate of the document timeline.
type AnimationSetPlaybackRate struct {
	// PlaybackRate Playback rate for animations on page
	PlaybackRate float64 `json:"playbackRate"`
}

// ProtoReq name.
func (m AnimationSetPlaybackRate) ProtoReq() string { return "Animation.setPlaybackRate" }

// Call sends the request.
func (m AnimationSetPlaybackRate) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// AnimationSetTiming Sets the timing of an animation node.
type AnimationSetTiming struct {
	// AnimationID Animation id.
	AnimationID string `json:"animationId"`

	// Duration of the animation.
	Duration float64 `json:"duration"`

	// Delay of the animation.
	Delay float64 `json:"delay"`
}

// ProtoReq name.
func (m AnimationSetTiming) ProtoReq() string { return "Animation.setTiming" }

// Call sends the request.
func (m AnimationSetTiming) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// AnimationAnimationCanceled Event for when an animation has been cancelled.
type AnimationAnimationCanceled struct {
	// ID Id of the animation that was cancelled.
	ID string `json:"id"`
}

// ProtoEvent name.
func (evt AnimationAnimationCanceled) ProtoEvent() string {
	return "Animation.animationCanceled"
}

// AnimationAnimationCreated Event for each animation that has been created.
type AnimationAnimationCreated struct {
	// ID Id of the animation that was created.
	ID string `json:"id"`
}

// ProtoEvent name.
func (evt AnimationAnimationCreated) ProtoEvent() string {
	return "Animation.animationCreated"
}

// AnimationAnimationStarted Event for animation that has been started.
type AnimationAnimationStarted struct {
	// Animation that was started.
	Animation *AnimationAnimation `json:"animation"`
}

// ProtoEvent name.
func (evt AnimationAnimationStarted) ProtoEvent() string {
	return "Animation.animationStarted"
}
