// This file is generated by "./lib/proto/generate"

package proto

import (
	"github.com/ysmood/gson"
)

/*

Tracing

*/

// TracingMemoryDumpConfig Configuration for memory dump. Used only when "memory-infra" category is enabled.
type TracingMemoryDumpConfig map[string]gson.JSON

// TracingTraceConfigRecordMode enum
type TracingTraceConfigRecordMode string

const (
	// TracingTraceConfigRecordModeRecordUntilFull enum const
	TracingTraceConfigRecordModeRecordUntilFull TracingTraceConfigRecordMode = "recordUntilFull"

	// TracingTraceConfigRecordModeRecordContinuously enum const
	TracingTraceConfigRecordModeRecordContinuously TracingTraceConfigRecordMode = "recordContinuously"

	// TracingTraceConfigRecordModeRecordAsMuchAsPossible enum const
	TracingTraceConfigRecordModeRecordAsMuchAsPossible TracingTraceConfigRecordMode = "recordAsMuchAsPossible"

	// TracingTraceConfigRecordModeEchoToConsole enum const
	TracingTraceConfigRecordModeEchoToConsole TracingTraceConfigRecordMode = "echoToConsole"
)

// TracingTraceConfig ...
type TracingTraceConfig struct {

	// RecordMode (optional) Controls how the trace buffer stores data.
	RecordMode TracingTraceConfigRecordMode `json:"recordMode,omitempty"`

	// TraceBufferSizeInKb (optional) Size of the trace buffer in kilobytes. If not specified or zero is passed, a default value
	// of 200 MB would be used.
	TraceBufferSizeInKb *float64 `json:"traceBufferSizeInKb,omitempty"`

	// EnableSampling (optional) Turns on JavaScript stack sampling.
	EnableSampling bool `json:"enableSampling,omitempty"`

	// EnableSystrace (optional) Turns on system tracing.
	EnableSystrace bool `json:"enableSystrace,omitempty"`

	// EnableArgumentFilter (optional) Turns on argument filter.
	EnableArgumentFilter bool `json:"enableArgumentFilter,omitempty"`

	// IncludedCategories (optional) Included category filters.
	IncludedCategories []string `json:"includedCategories,omitempty"`

	// ExcludedCategories (optional) Excluded category filters.
	ExcludedCategories []string `json:"excludedCategories,omitempty"`

	// SyntheticDelays (optional) Configuration to synthesize the delays in tracing.
	SyntheticDelays []string `json:"syntheticDelays,omitempty"`

	// MemoryDumpConfig (optional) Configuration for memory dump triggers. Used only when "memory-infra" category is enabled.
	MemoryDumpConfig TracingMemoryDumpConfig `json:"memoryDumpConfig,omitempty"`
}

// TracingStreamFormat Data format of a trace. Can be either the legacy JSON format or the
// protocol buffer format. Note that the JSON format will be deprecated soon.
type TracingStreamFormat string

const (
	// TracingStreamFormatJSON enum const
	TracingStreamFormatJSON TracingStreamFormat = "json"

	// TracingStreamFormatProto enum const
	TracingStreamFormatProto TracingStreamFormat = "proto"
)

// TracingStreamCompression Compression type to use for traces returned via streams.
type TracingStreamCompression string

const (
	// TracingStreamCompressionNone enum const
	TracingStreamCompressionNone TracingStreamCompression = "none"

	// TracingStreamCompressionGzip enum const
	TracingStreamCompressionGzip TracingStreamCompression = "gzip"
)

// TracingMemoryDumpLevelOfDetail Details exposed when memory request explicitly declared.
// Keep consistent with memory_dump_request_args.h and
// memory_instrumentation.mojom
type TracingMemoryDumpLevelOfDetail string

const (
	// TracingMemoryDumpLevelOfDetailBackground enum const
	TracingMemoryDumpLevelOfDetailBackground TracingMemoryDumpLevelOfDetail = "background"

	// TracingMemoryDumpLevelOfDetailLight enum const
	TracingMemoryDumpLevelOfDetailLight TracingMemoryDumpLevelOfDetail = "light"

	// TracingMemoryDumpLevelOfDetailDetailed enum const
	TracingMemoryDumpLevelOfDetailDetailed TracingMemoryDumpLevelOfDetail = "detailed"
)

// TracingTracingBackend Backend type to use for tracing. `chrome` uses the Chrome-integrated
// tracing service and is supported on all platforms. `system` is only
// supported on Chrome OS and uses the Perfetto system tracing service.
// `auto` chooses `system` when the perfettoConfig provided to Tracing.start
// specifies at least one non-Chrome data source; otherwise uses `chrome`.
type TracingTracingBackend string

const (
	// TracingTracingBackendAuto enum const
	TracingTracingBackendAuto TracingTracingBackend = "auto"

	// TracingTracingBackendChrome enum const
	TracingTracingBackendChrome TracingTracingBackend = "chrome"

	// TracingTracingBackendSystem enum const
	TracingTracingBackendSystem TracingTracingBackend = "system"
)

// TracingEnd Stop trace events collection.
type TracingEnd struct {
}

// ProtoReq name
func (m TracingEnd) ProtoReq() string { return "Tracing.end" }

// Call sends the request
func (m TracingEnd) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// TracingGetCategories Gets supported tracing categories.
type TracingGetCategories struct {
}

// ProtoReq name
func (m TracingGetCategories) ProtoReq() string { return "Tracing.getCategories" }

// Call the request
func (m TracingGetCategories) Call(c Client) (*TracingGetCategoriesResult, error) {
	var res TracingGetCategoriesResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// TracingGetCategoriesResult ...
type TracingGetCategoriesResult struct {

	// Categories A list of supported tracing categories.
	Categories []string `json:"categories"`
}

// TracingRecordClockSyncMarker Record a clock sync marker in the trace.
type TracingRecordClockSyncMarker struct {

	// SyncID The ID of this clock sync marker
	SyncID string `json:"syncId"`
}

// ProtoReq name
func (m TracingRecordClockSyncMarker) ProtoReq() string { return "Tracing.recordClockSyncMarker" }

// Call sends the request
func (m TracingRecordClockSyncMarker) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// TracingRequestMemoryDump Request a global memory dump.
type TracingRequestMemoryDump struct {

	// Deterministic (optional) Enables more deterministic results by forcing garbage collection
	Deterministic bool `json:"deterministic,omitempty"`

	// LevelOfDetail (optional) Specifies level of details in memory dump. Defaults to "detailed".
	LevelOfDetail TracingMemoryDumpLevelOfDetail `json:"levelOfDetail,omitempty"`
}

// ProtoReq name
func (m TracingRequestMemoryDump) ProtoReq() string { return "Tracing.requestMemoryDump" }

// Call the request
func (m TracingRequestMemoryDump) Call(c Client) (*TracingRequestMemoryDumpResult, error) {
	var res TracingRequestMemoryDumpResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// TracingRequestMemoryDumpResult ...
type TracingRequestMemoryDumpResult struct {

	// DumpGUID GUID of the resulting global memory dump.
	DumpGUID string `json:"dumpGuid"`

	// Success True iff the global memory dump succeeded.
	Success bool `json:"success"`
}

// TracingStartTransferMode enum
type TracingStartTransferMode string

const (
	// TracingStartTransferModeReportEvents enum const
	TracingStartTransferModeReportEvents TracingStartTransferMode = "ReportEvents"

	// TracingStartTransferModeReturnAsStream enum const
	TracingStartTransferModeReturnAsStream TracingStartTransferMode = "ReturnAsStream"
)

// TracingStart Start trace events collection.
type TracingStart struct {

	// Categories (deprecated) (optional) Category/tag filter
	Categories string `json:"categories,omitempty"`

	// Options (deprecated) (optional) Tracing options
	Options string `json:"options,omitempty"`

	// BufferUsageReportingInterval (optional) If set, the agent will issue bufferUsage events at this interval, specified in milliseconds
	BufferUsageReportingInterval *float64 `json:"bufferUsageReportingInterval,omitempty"`

	// TransferMode (optional) Whether to report trace events as series of dataCollected events or to save trace to a
	// stream (defaults to `ReportEvents`).
	TransferMode TracingStartTransferMode `json:"transferMode,omitempty"`

	// StreamFormat (optional) Trace data format to use. This only applies when using `ReturnAsStream`
	// transfer mode (defaults to `json`).
	StreamFormat TracingStreamFormat `json:"streamFormat,omitempty"`

	// StreamCompression (optional) Compression format to use. This only applies when using `ReturnAsStream`
	// transfer mode (defaults to `none`)
	StreamCompression TracingStreamCompression `json:"streamCompression,omitempty"`

	// TraceConfig (optional) ...
	TraceConfig *TracingTraceConfig `json:"traceConfig,omitempty"`

	// PerfettoConfig (optional) Base64-encoded serialized perfetto.protos.TraceConfig protobuf message
	// When specified, the parameters `categories`, `options`, `traceConfig`
	// are ignored.
	PerfettoConfig []byte `json:"perfettoConfig,omitempty"`

	// TracingBackend (optional) Backend type (defaults to `auto`)
	TracingBackend TracingTracingBackend `json:"tracingBackend,omitempty"`
}

// ProtoReq name
func (m TracingStart) ProtoReq() string { return "Tracing.start" }

// Call sends the request
func (m TracingStart) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// TracingBufferUsage ...
type TracingBufferUsage struct {

	// PercentFull (optional) A number in range [0..1] that indicates the used size of event buffer as a fraction of its
	// total size.
	PercentFull *float64 `json:"percentFull,omitempty"`

	// EventCount (optional) An approximate number of events in the trace log.
	EventCount *float64 `json:"eventCount,omitempty"`

	// Value (optional) A number in range [0..1] that indicates the used size of event buffer as a fraction of its
	// total size.
	Value *float64 `json:"value,omitempty"`
}

// ProtoEvent name
func (evt TracingBufferUsage) ProtoEvent() string {
	return "Tracing.bufferUsage"
}

// TracingDataCollected Contains an bucket of collected trace events. When tracing is stopped collected events will be
// send as a sequence of dataCollected events followed by tracingComplete event.
type TracingDataCollected struct {

	// Value ...
	Value []map[string]gson.JSON `json:"value"`
}

// ProtoEvent name
func (evt TracingDataCollected) ProtoEvent() string {
	return "Tracing.dataCollected"
}

// TracingTracingComplete Signals that tracing is stopped and there is no trace buffers pending flush, all data were
// delivered via dataCollected events.
type TracingTracingComplete struct {

	// DataLossOccurred Indicates whether some trace data is known to have been lost, e.g. because the trace ring
	// buffer wrapped around.
	DataLossOccurred bool `json:"dataLossOccurred"`

	// Stream (optional) A handle of the stream that holds resulting trace data.
	Stream IOStreamHandle `json:"stream,omitempty"`

	// TraceFormat (optional) Trace data format of returned stream.
	TraceFormat TracingStreamFormat `json:"traceFormat,omitempty"`

	// StreamCompression (optional) Compression format of returned stream.
	StreamCompression TracingStreamCompression `json:"streamCompression,omitempty"`
}

// ProtoEvent name
func (evt TracingTracingComplete) ProtoEvent() string {
	return "Tracing.tracingComplete"
}
