// Code generated by "precompile.go". DO NOT EDIT.

package rulesdata

import "github.com/quasilyte/go-ruleguard/ruleguard/ir"

var PrecompiledRules = &ir.File{
	PkgPath:       "gorules",
	CustomDecls:   []string{},
	BundleImports: []ir.BundleImport{},
	RuleGroups: []ir.RuleGroup{
		ir.RuleGroup{
			Line:        11,
			Name:        "redundantSprint",
			MatcherName: "m",
			DocTags: []string{
				"style",
				"experimental",
			},
			DocSummary: "Detects redundant fmt.Sprint calls",
			DocBefore:  "fmt.Sprint(x)",
			DocAfter:   "x.String()",
			Rules: []ir.Rule{
				ir.Rule{
					Line:            12,
					SyntaxPattern:   "fmt.Sprint($x)",
					ReportTemplate:  "use $x.String() instead",
					SuggestTemplate: "$x.String()",
					WhereExpr: ir.FilterExpr{
						Line:  13,
						Op:    ir.FilterVarTypeImplementsOp,
						Src:   "m[\"x\"].Type.Implements(`fmt.Stringer`)",
						Value: "x",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  13,
								Op:    ir.FilterStringOp,
								Src:   "`fmt.Stringer`",
								Value: "fmt.Stringer",
							},
						},
					},
				},
				ir.Rule{
					Line:            12,
					SyntaxPattern:   "fmt.Sprintf(\"%s\", $x)",
					ReportTemplate:  "use $x.String() instead",
					SuggestTemplate: "$x.String()",
					WhereExpr: ir.FilterExpr{
						Line:  13,
						Op:    ir.FilterVarTypeImplementsOp,
						Src:   "m[\"x\"].Type.Implements(`fmt.Stringer`)",
						Value: "x",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  13,
								Op:    ir.FilterStringOp,
								Src:   "`fmt.Stringer`",
								Value: "fmt.Stringer",
							},
						},
					},
				},
				ir.Rule{
					Line:            12,
					SyntaxPattern:   "fmt.Sprintf(\"%v\", $x)",
					ReportTemplate:  "use $x.String() instead",
					SuggestTemplate: "$x.String()",
					WhereExpr: ir.FilterExpr{
						Line:  13,
						Op:    ir.FilterVarTypeImplementsOp,
						Src:   "m[\"x\"].Type.Implements(`fmt.Stringer`)",
						Value: "x",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  13,
								Op:    ir.FilterStringOp,
								Src:   "`fmt.Stringer`",
								Value: "fmt.Stringer",
							},
						},
					},
				},
				ir.Rule{
					Line:            17,
					SyntaxPattern:   "fmt.Sprint($x)",
					ReportTemplate:  "use $x.Error() instead",
					SuggestTemplate: "$x.Error()",
					WhereExpr: ir.FilterExpr{
						Line:  18,
						Op:    ir.FilterVarTypeImplementsOp,
						Src:   "m[\"x\"].Type.Implements(`error`)",
						Value: "x",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  18,
								Op:    ir.FilterStringOp,
								Src:   "`error`",
								Value: "error",
							},
						},
					},
				},
				ir.Rule{
					Line:            17,
					SyntaxPattern:   "fmt.Sprintf(\"%s\", $x)",
					ReportTemplate:  "use $x.Error() instead",
					SuggestTemplate: "$x.Error()",
					WhereExpr: ir.FilterExpr{
						Line:  18,
						Op:    ir.FilterVarTypeImplementsOp,
						Src:   "m[\"x\"].Type.Implements(`error`)",
						Value: "x",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  18,
								Op:    ir.FilterStringOp,
								Src:   "`error`",
								Value: "error",
							},
						},
					},
				},
				ir.Rule{
					Line:            17,
					SyntaxPattern:   "fmt.Sprintf(\"%v\", $x)",
					ReportTemplate:  "use $x.Error() instead",
					SuggestTemplate: "$x.Error()",
					WhereExpr: ir.FilterExpr{
						Line:  18,
						Op:    ir.FilterVarTypeImplementsOp,
						Src:   "m[\"x\"].Type.Implements(`error`)",
						Value: "x",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  18,
								Op:    ir.FilterStringOp,
								Src:   "`error`",
								Value: "error",
							},
						},
					},
				},
				ir.Rule{
					Line:            22,
					SyntaxPattern:   "fmt.Sprint($x)",
					ReportTemplate:  "$x is already string",
					SuggestTemplate: "$x",
					WhereExpr: ir.FilterExpr{
						Line:  23,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"x\"].Type.Is(`string`)",
						Value: "x",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  23,
								Op:    ir.FilterStringOp,
								Src:   "`string`",
								Value: "string",
							},
						},
					},
				},
				ir.Rule{
					Line:            22,
					SyntaxPattern:   "fmt.Sprintf(\"%s\", $x)",
					ReportTemplate:  "$x is already string",
					SuggestTemplate: "$x",
					WhereExpr: ir.FilterExpr{
						Line:  23,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"x\"].Type.Is(`string`)",
						Value: "x",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  23,
								Op:    ir.FilterStringOp,
								Src:   "`string`",
								Value: "string",
							},
						},
					},
				},
				ir.Rule{
					Line:            22,
					SyntaxPattern:   "fmt.Sprintf(\"%v\", $x)",
					ReportTemplate:  "$x is already string",
					SuggestTemplate: "$x",
					WhereExpr: ir.FilterExpr{
						Line:  23,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"x\"].Type.Is(`string`)",
						Value: "x",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  23,
								Op:    ir.FilterStringOp,
								Src:   "`string`",
								Value: "string",
							},
						},
					},
				},
			},
		},
		ir.RuleGroup{
			Line:        32,
			Name:        "deferUnlambda",
			MatcherName: "m",
			DocTags: []string{
				"style",
				"experimental",
			},
			DocSummary: "Detects deferred function literals that can be simplified",
			DocBefore:  "defer func() { f() }()",
			DocAfter:   "defer f()",
			Rules: []ir.Rule{
				ir.Rule{
					Line:           33,
					SyntaxPattern:  "defer func() { $f($*args) }()",
					ReportTemplate: "can rewrite as `defer $f($args)`",
					WhereExpr: ir.FilterExpr{
						Line: 34,
						Op:   ir.FilterAndOp,
						Src:  "m[\"f\"].Node.Is(`Ident`) && m[\"f\"].Text != \"panic\" && m[\"f\"].Text != \"recover\" && m[\"args\"].Const",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line: 34,
								Op:   ir.FilterAndOp,
								Src:  "m[\"f\"].Node.Is(`Ident`) && m[\"f\"].Text != \"panic\" && m[\"f\"].Text != \"recover\"",
								Args: []ir.FilterExpr{
									ir.FilterExpr{
										Line: 34,
										Op:   ir.FilterAndOp,
										Src:  "m[\"f\"].Node.Is(`Ident`) && m[\"f\"].Text != \"panic\"",
										Args: []ir.FilterExpr{
											ir.FilterExpr{
												Line:  34,
												Op:    ir.FilterVarNodeIsOp,
												Src:   "m[\"f\"].Node.Is(`Ident`)",
												Value: "f",
												Args: []ir.FilterExpr{
													ir.FilterExpr{
														Line:  34,
														Op:    ir.FilterStringOp,
														Src:   "`Ident`",
														Value: "Ident",
													},
												},
											},
											ir.FilterExpr{
												Line: 34,
												Op:   ir.FilterNeqOp,
												Src:  "m[\"f\"].Text != \"panic\"",
												Args: []ir.FilterExpr{
													ir.FilterExpr{
														Line:  34,
														Op:    ir.FilterVarTextOp,
														Src:   "m[\"f\"].Text",
														Value: "f",
													},
													ir.FilterExpr{
														Line:  34,
														Op:    ir.FilterStringOp,
														Src:   "\"panic\"",
														Value: "panic",
													},
												},
											},
										},
									},
									ir.FilterExpr{
										Line: 34,
										Op:   ir.FilterNeqOp,
										Src:  "m[\"f\"].Text != \"recover\"",
										Args: []ir.FilterExpr{
											ir.FilterExpr{
												Line:  34,
												Op:    ir.FilterVarTextOp,
												Src:   "m[\"f\"].Text",
												Value: "f",
											},
											ir.FilterExpr{
												Line:  34,
												Op:    ir.FilterStringOp,
												Src:   "\"recover\"",
												Value: "recover",
											},
										},
									},
								},
							},
							ir.FilterExpr{
								Line:  34,
								Op:    ir.FilterVarConstOp,
								Src:   "m[\"args\"].Const",
								Value: "args",
							},
						},
					},
				},
				ir.Rule{
					Line:           37,
					SyntaxPattern:  "defer func() { $pkg.$f($*args) }()",
					ReportTemplate: "can rewrite as `defer $pkg.$f($args)`",
					WhereExpr: ir.FilterExpr{
						Line: 38,
						Op:   ir.FilterAndOp,
						Src:  "m[\"f\"].Node.Is(`Ident`) && m[\"args\"].Const && m[\"pkg\"].Object.Is(`PkgName`)",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line: 38,
								Op:   ir.FilterAndOp,
								Src:  "m[\"f\"].Node.Is(`Ident`) && m[\"args\"].Const",
								Args: []ir.FilterExpr{
									ir.FilterExpr{
										Line:  38,
										Op:    ir.FilterVarNodeIsOp,
										Src:   "m[\"f\"].Node.Is(`Ident`)",
										Value: "f",
										Args: []ir.FilterExpr{
											ir.FilterExpr{
												Line:  38,
												Op:    ir.FilterStringOp,
												Src:   "`Ident`",
												Value: "Ident",
											},
										},
									},
									ir.FilterExpr{
										Line:  38,
										Op:    ir.FilterVarConstOp,
										Src:   "m[\"args\"].Const",
										Value: "args",
									},
								},
							},
							ir.FilterExpr{
								Line:  38,
								Op:    ir.FilterVarObjectIsOp,
								Src:   "m[\"pkg\"].Object.Is(`PkgName`)",
								Value: "pkg",
								Args: []ir.FilterExpr{
									ir.FilterExpr{
										Line:  38,
										Op:    ir.FilterStringOp,
										Src:   "`PkgName`",
										Value: "PkgName",
									},
								},
							},
						},
					},
				},
			},
		},
		ir.RuleGroup{
			Line:        46,
			Name:        "ioutilDeprecated",
			MatcherName: "m",
			DocTags: []string{
				"style",
				"experimental",
			},
			DocSummary: "Detects deprecated io/ioutil package usages",
			DocBefore:  "ioutil.ReadAll(r)",
			DocAfter:   "io.ReadAll(r)",
			Rules: []ir.Rule{
				ir.Rule{
					Line:           47,
					SyntaxPattern:  "ioutil.ReadAll($_)",
					ReportTemplate: "ioutil.ReadAll is deprecated, use io.ReadAll instead",
				},
				ir.Rule{
					Line:           50,
					SyntaxPattern:  "ioutil.ReadFile($_)",
					ReportTemplate: "ioutil.ReadFile is deprecated, use os.ReadFile instead",
				},
				ir.Rule{
					Line:           53,
					SyntaxPattern:  "ioutil.WriteFile($_, $_, $_)",
					ReportTemplate: "ioutil.WriteFile is deprecated, use os.WriteFile instead",
				},
				ir.Rule{
					Line:           56,
					SyntaxPattern:  "ioutil.ReadDir($_)",
					ReportTemplate: "ioutil.ReadDir is deprecated, use os.ReadDir instead",
				},
				ir.Rule{
					Line:           59,
					SyntaxPattern:  "ioutil.NopCloser($_)",
					ReportTemplate: "ioutil.NopCloser is deprecated, use io.NopCloser instead",
				},
				ir.Rule{
					Line:           62,
					SyntaxPattern:  "ioutil.Discard",
					ReportTemplate: "ioutil.Discard is deprecated, use io.Discard instead",
				},
			},
		},
		ir.RuleGroup{
			Line:        70,
			Name:        "badLock",
			MatcherName: "m",
			DocTags: []string{
				"diagnostic",
				"experimental",
			},
			DocSummary: "Detects suspicious mutex lock/unlock operations",
			DocBefore:  "mu.Lock(); mu.Unlock()",
			DocAfter:   "mu.Lock(); defer mu.Unlock()",
			Rules: []ir.Rule{
				ir.Rule{
					Line:           74,
					SyntaxPattern:  "$mu1.Lock(); $mu2.Unlock()",
					ReportTemplate: "defer is missing, mutex is unlocked immediately",
					WhereExpr: ir.FilterExpr{
						Line: 75,
						Op:   ir.FilterEqOp,
						Src:  "m[\"mu1\"].Text == m[\"mu2\"].Text",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  75,
								Op:    ir.FilterVarTextOp,
								Src:   "m[\"mu1\"].Text",
								Value: "mu1",
							},
							ir.FilterExpr{
								Line:  75,
								Op:    ir.FilterVarTextOp,
								Src:   "m[\"mu2\"].Text",
								Value: "mu2",
							},
						},
					},
					LocationVar: "mu2",
				},
				ir.Rule{
					Line:           79,
					SyntaxPattern:  "$mu1.RLock(); $mu2.RUnlock()",
					ReportTemplate: "defer is missing, mutex is unlocked immediately",
					WhereExpr: ir.FilterExpr{
						Line: 80,
						Op:   ir.FilterEqOp,
						Src:  "m[\"mu1\"].Text == m[\"mu2\"].Text",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  80,
								Op:    ir.FilterVarTextOp,
								Src:   "m[\"mu1\"].Text",
								Value: "mu1",
							},
							ir.FilterExpr{
								Line:  80,
								Op:    ir.FilterVarTextOp,
								Src:   "m[\"mu2\"].Text",
								Value: "mu2",
							},
						},
					},
					LocationVar: "mu2",
				},
				ir.Rule{
					Line:           85,
					SyntaxPattern:  "$mu1.Lock(); defer $mu2.RUnlock()",
					ReportTemplate: "suspicious unlock, maybe Unlock was intended?",
					WhereExpr: ir.FilterExpr{
						Line: 86,
						Op:   ir.FilterEqOp,
						Src:  "m[\"mu1\"].Text == m[\"mu2\"].Text",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  86,
								Op:    ir.FilterVarTextOp,
								Src:   "m[\"mu1\"].Text",
								Value: "mu1",
							},
							ir.FilterExpr{
								Line:  86,
								Op:    ir.FilterVarTextOp,
								Src:   "m[\"mu2\"].Text",
								Value: "mu2",
							},
						},
					},
					LocationVar: "mu2",
				},
				ir.Rule{
					Line:           90,
					SyntaxPattern:  "$mu1.RLock(); defer $mu2.Unlock()",
					ReportTemplate: "suspicious unlock, maybe RUnlock was intended?",
					WhereExpr: ir.FilterExpr{
						Line: 91,
						Op:   ir.FilterEqOp,
						Src:  "m[\"mu1\"].Text == m[\"mu2\"].Text",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  91,
								Op:    ir.FilterVarTextOp,
								Src:   "m[\"mu1\"].Text",
								Value: "mu1",
							},
							ir.FilterExpr{
								Line:  91,
								Op:    ir.FilterVarTextOp,
								Src:   "m[\"mu2\"].Text",
								Value: "mu2",
							},
						},
					},
					LocationVar: "mu2",
				},
				ir.Rule{
					Line:           96,
					SyntaxPattern:  "$mu1.Lock(); defer $mu2.Lock()",
					ReportTemplate: "maybe defer $mu1.Unlock() was intended?",
					WhereExpr: ir.FilterExpr{
						Line: 97,
						Op:   ir.FilterEqOp,
						Src:  "m[\"mu1\"].Text == m[\"mu2\"].Text",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  97,
								Op:    ir.FilterVarTextOp,
								Src:   "m[\"mu1\"].Text",
								Value: "mu1",
							},
							ir.FilterExpr{
								Line:  97,
								Op:    ir.FilterVarTextOp,
								Src:   "m[\"mu2\"].Text",
								Value: "mu2",
							},
						},
					},
					LocationVar: "mu2",
				},
				ir.Rule{
					Line:           101,
					SyntaxPattern:  "$mu1.RLock(); defer $mu2.RLock()",
					ReportTemplate: "maybe defer $mu1.RUnlock() was intended?",
					WhereExpr: ir.FilterExpr{
						Line: 102,
						Op:   ir.FilterEqOp,
						Src:  "m[\"mu1\"].Text == m[\"mu2\"].Text",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  102,
								Op:    ir.FilterVarTextOp,
								Src:   "m[\"mu1\"].Text",
								Value: "mu1",
							},
							ir.FilterExpr{
								Line:  102,
								Op:    ir.FilterVarTextOp,
								Src:   "m[\"mu2\"].Text",
								Value: "mu2",
							},
						},
					},
					LocationVar: "mu2",
				},
			},
		},
		ir.RuleGroup{
			Line:        111,
			Name:        "httpNoBody",
			MatcherName: "m",
			DocTags: []string{
				"style",
				"experimental",
			},
			DocSummary: "Detects nil usages in http.NewRequest calls, suggesting http.NoBody as an alternative",
			DocBefore:  "http.NewRequest(\"GET\", url, nil)",
			DocAfter:   "http.NewRequest(\"GET\", url, http.NoBody)",
			Rules: []ir.Rule{
				ir.Rule{
					Line:            112,
					SyntaxPattern:   "http.NewRequest($method, $url, $nil)",
					ReportTemplate:  "http.NoBody should be preferred to the nil request body",
					SuggestTemplate: "http.NewRequest($method, $url, http.NoBody)",
					WhereExpr: ir.FilterExpr{
						Line: 113,
						Op:   ir.FilterEqOp,
						Src:  "m[\"nil\"].Text == \"nil\"",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  113,
								Op:    ir.FilterVarTextOp,
								Src:   "m[\"nil\"].Text",
								Value: "nil",
							},
							ir.FilterExpr{
								Line:  113,
								Op:    ir.FilterStringOp,
								Src:   "\"nil\"",
								Value: "nil",
							},
						},
					},
				},
				ir.Rule{
					Line:            117,
					SyntaxPattern:   "http.NewRequestWithContext($ctx, $method, $url, $nil)",
					ReportTemplate:  "http.NoBody should be preferred to the nil request body",
					SuggestTemplate: "http.NewRequestWithContext($ctx, $method, $url, http.NoBody)",
					WhereExpr: ir.FilterExpr{
						Line: 118,
						Op:   ir.FilterEqOp,
						Src:  "m[\"nil\"].Text == \"nil\"",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  118,
								Op:    ir.FilterVarTextOp,
								Src:   "m[\"nil\"].Text",
								Value: "nil",
							},
							ir.FilterExpr{
								Line:  118,
								Op:    ir.FilterStringOp,
								Src:   "\"nil\"",
								Value: "nil",
							},
						},
					},
				},
			},
		},
		ir.RuleGroup{
			Line:        128,
			Name:        "preferDecodeRune",
			MatcherName: "m",
			DocTags: []string{
				"performance",
				"experimental",
			},
			DocSummary: "Detects expressions like []rune(s)[0] that may cause unwanted rune slice allocation",
			DocBefore:  "r := []rune(s)[0]",
			DocAfter:   "r, _ := utf8.DecodeRuneInString(s)",
			DocNote:    "See Go issue for details: https://github.com/golang/go/issues/45260",
			Rules: []ir.Rule{
				ir.Rule{
					Line:           129,
					SyntaxPattern:  "[]rune($s)[0]",
					ReportTemplate: "consider replacing $$ with utf8.DecodeRuneInString($s)",
					WhereExpr: ir.FilterExpr{
						Line:  130,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"s\"].Type.Is(`string`)",
						Value: "s",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  130,
								Op:    ir.FilterStringOp,
								Src:   "`string`",
								Value: "string",
							},
						},
					},
				},
			},
		},
		ir.RuleGroup{
			Line:        138,
			Name:        "sloppyLen",
			MatcherName: "m",
			DocTags: []string{
				"style",
			},
			DocSummary: "Detects usage of `len` when result is obvious or doesn't make sense",
			DocBefore:  "len(arr) <= 0",
			DocAfter:   "len(arr) == 0",
			Rules: []ir.Rule{
				ir.Rule{
					Line:           139,
					SyntaxPattern:  "len($_) >= 0",
					ReportTemplate: "$$ is always true",
				},
				ir.Rule{
					Line:           140,
					SyntaxPattern:  "len($_) < 0",
					ReportTemplate: "$$ is always false",
				},
				ir.Rule{
					Line:           141,
					SyntaxPattern:  "len($x) <= 0",
					ReportTemplate: "$$ can be len($x) == 0",
				},
			},
		},
		ir.RuleGroup{
			Line:        148,
			Name:        "valSwap",
			MatcherName: "m",
			DocTags: []string{
				"style",
			},
			DocSummary: "Detects value swapping code that are not using parallel assignment",
			DocBefore:  "*tmp = *x; *x = *y; *y = *tmp",
			DocAfter:   "*x, *y = *y, *x",
			Rules: []ir.Rule{
				ir.Rule{
					Line:           149,
					SyntaxPattern:  "$tmp := $y; $y = $x; $x = $tmp",
					ReportTemplate: "can re-write as `$y, $x = $x, $y`",
				},
			},
		},
		ir.RuleGroup{
			Line:        157,
			Name:        "switchTrue",
			MatcherName: "m",
			DocTags: []string{
				"style",
			},
			DocSummary: "Detects switch-over-bool statements that use explicit `true` tag value",
			DocBefore:  "switch true {...}",
			DocAfter:   "switch {...}",
			Rules: []ir.Rule{
				ir.Rule{
					Line:           158,
					SyntaxPattern:  "switch true { $*_ }",
					ReportTemplate: "replace 'switch true {}' with 'switch {}'",
				},
				ir.Rule{
					Line:           160,
					SyntaxPattern:  "switch $x; true { $*_ }",
					ReportTemplate: "replace 'switch $x; true {}' with 'switch $x; {}'",
				},
			},
		},
		ir.RuleGroup{
			Line:        168,
			Name:        "flagDeref",
			MatcherName: "m",
			DocTags: []string{
				"diagnostic",
			},
			DocSummary: "Detects immediate dereferencing of `flag` package pointers",
			DocBefore:  "b := *flag.Bool(\"b\", false, \"b docs\")",
			DocAfter:   "var b bool; flag.BoolVar(&b, \"b\", false, \"b docs\")",
			Rules: []ir.Rule{
				ir.Rule{
					Line:           169,
					SyntaxPattern:  "*flag.Bool($*_)",
					ReportTemplate: "immediate deref in $$ is most likely an error; consider using flag.BoolVar",
				},
				ir.Rule{
					Line:           170,
					SyntaxPattern:  "*flag.Duration($*_)",
					ReportTemplate: "immediate deref in $$ is most likely an error; consider using flag.DurationVar",
				},
				ir.Rule{
					Line:           171,
					SyntaxPattern:  "*flag.Float64($*_)",
					ReportTemplate: "immediate deref in $$ is most likely an error; consider using flag.Float64Var",
				},
				ir.Rule{
					Line:           172,
					SyntaxPattern:  "*flag.Int($*_)",
					ReportTemplate: "immediate deref in $$ is most likely an error; consider using flag.IntVar",
				},
				ir.Rule{
					Line:           173,
					SyntaxPattern:  "*flag.Int64($*_)",
					ReportTemplate: "immediate deref in $$ is most likely an error; consider using flag.Int64Var",
				},
				ir.Rule{
					Line:           174,
					SyntaxPattern:  "*flag.String($*_)",
					ReportTemplate: "immediate deref in $$ is most likely an error; consider using flag.StringVar",
				},
				ir.Rule{
					Line:           175,
					SyntaxPattern:  "*flag.Uint($*_)",
					ReportTemplate: "immediate deref in $$ is most likely an error; consider using flag.UintVar",
				},
				ir.Rule{
					Line:           176,
					SyntaxPattern:  "*flag.Uint64($*_)",
					ReportTemplate: "immediate deref in $$ is most likely an error; consider using flag.Uint64Var",
				},
			},
		},
		ir.RuleGroup{
			Line:        183,
			Name:        "emptyStringTest",
			MatcherName: "m",
			DocTags: []string{
				"style",
				"experimental",
			},
			DocSummary: "Detects empty string checks that can be written more idiomatically",
			DocBefore:  "len(s) == 0",
			DocAfter:   "s == \"\"",
			Rules: []ir.Rule{
				ir.Rule{
					Line:           184,
					SyntaxPattern:  "len($s) != 0",
					ReportTemplate: "replace `$$` with `$s != \"\"`",
					WhereExpr: ir.FilterExpr{
						Line:  185,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"s\"].Type.Is(`string`)",
						Value: "s",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  185,
								Op:    ir.FilterStringOp,
								Src:   "`string`",
								Value: "string",
							},
						},
					},
				},
				ir.Rule{
					Line:           188,
					SyntaxPattern:  "len($s) == 0",
					ReportTemplate: "replace `$$` with `$s == \"\"`",
					WhereExpr: ir.FilterExpr{
						Line:  189,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"s\"].Type.Is(`string`)",
						Value: "s",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  189,
								Op:    ir.FilterStringOp,
								Src:   "`string`",
								Value: "string",
							},
						},
					},
				},
			},
		},
		ir.RuleGroup{
			Line:        197,
			Name:        "stringXbytes",
			MatcherName: "m",
			DocTags: []string{
				"style",
			},
			DocSummary: "Detects redundant conversions between string and []byte",
			DocBefore:  "copy(b, []byte(s))",
			DocAfter:   "copy(b, s)",
			Rules: []ir.Rule{
				ir.Rule{
					Line:           198,
					SyntaxPattern:  "copy($_, []byte($s))",
					ReportTemplate: "can simplify `[]byte($s)` to `$s`",
				},
			},
		},
		ir.RuleGroup{
			Line:        206,
			Name:        "indexAlloc",
			MatcherName: "m",
			DocTags: []string{
				"performance",
			},
			DocSummary: "Detects strings.Index calls that may cause unwanted allocs",
			DocBefore:  "strings.Index(string(x), y)",
			DocAfter:   "bytes.Index(x, []byte(y))",
			DocNote:    "See Go issue for details: https://github.com/golang/go/issues/25864",
			Rules: []ir.Rule{
				ir.Rule{
					Line:           207,
					SyntaxPattern:  "strings.Index(string($x), $y)",
					ReportTemplate: "consider replacing $$ with bytes.Index($x, []byte($y))",
					WhereExpr: ir.FilterExpr{
						Line: 208,
						Op:   ir.FilterAndOp,
						Src:  "m[\"x\"].Pure && m[\"y\"].Pure",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  208,
								Op:    ir.FilterVarPureOp,
								Src:   "m[\"x\"].Pure",
								Value: "x",
							},
							ir.FilterExpr{
								Line:  208,
								Op:    ir.FilterVarPureOp,
								Src:   "m[\"y\"].Pure",
								Value: "y",
							},
						},
					},
				},
			},
		},
		ir.RuleGroup{
			Line:        216,
			Name:        "wrapperFunc",
			MatcherName: "m",
			DocTags: []string{
				"style",
			},
			DocSummary: "Detects function calls that can be replaced with convenience wrappers",
			DocBefore:  "wg.Add(-1)",
			DocAfter:   "wg.Done()",
			Rules: []ir.Rule{
				ir.Rule{
					Line:           217,
					SyntaxPattern:  "$wg.Add(-1)",
					ReportTemplate: "use WaitGroup.Done method in `$$`",
					WhereExpr: ir.FilterExpr{
						Line:  218,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"wg\"].Type.Is(`sync.WaitGroup`)",
						Value: "wg",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  218,
								Op:    ir.FilterStringOp,
								Src:   "`sync.WaitGroup`",
								Value: "sync.WaitGroup",
							},
						},
					},
				},
				ir.Rule{
					Line:           221,
					SyntaxPattern:  "$buf.Truncate(0)",
					ReportTemplate: "use Buffer.Reset method in `$$`",
					WhereExpr: ir.FilterExpr{
						Line:  222,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"buf\"].Type.Is(`bytes.Buffer`)",
						Value: "buf",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  222,
								Op:    ir.FilterStringOp,
								Src:   "`bytes.Buffer`",
								Value: "bytes.Buffer",
							},
						},
					},
				},
				ir.Rule{
					Line:           225,
					SyntaxPattern:  "http.HandlerFunc(http.NotFound)",
					ReportTemplate: "use http.NotFoundHandler method in `$$`",
				},
				ir.Rule{
					Line:           227,
					SyntaxPattern:  "strings.SplitN($_, $_, -1)",
					ReportTemplate: "use strings.Split method in `$$`",
				},
				ir.Rule{
					Line:           228,
					SyntaxPattern:  "strings.Replace($_, $_, $_, -1)",
					ReportTemplate: "use strings.ReplaceAll method in `$$`",
				},
				ir.Rule{
					Line:           229,
					SyntaxPattern:  "strings.Map(unicode.ToTitle, $_)",
					ReportTemplate: "use strings.ToTitle method in `$$`",
				},
				ir.Rule{
					Line:           231,
					SyntaxPattern:  "bytes.SplitN(b, []byte(\".\"), -1)",
					ReportTemplate: "use bytes.Split method in `$$`",
				},
				ir.Rule{
					Line:           232,
					SyntaxPattern:  "bytes.Replace($_, $_, $_, -1)",
					ReportTemplate: "use bytes.ReplaceAll method in `$$`",
				},
				ir.Rule{
					Line:           233,
					SyntaxPattern:  "bytes.Map(unicode.ToUpper, $_)",
					ReportTemplate: "use bytes.ToUpper method in `$$`",
				},
				ir.Rule{
					Line:           234,
					SyntaxPattern:  "bytes.Map(unicode.ToLower, $_)",
					ReportTemplate: "use bytes.ToLower method in `$$`",
				},
				ir.Rule{
					Line:           235,
					SyntaxPattern:  "bytes.Map(unicode.ToTitle, $_)",
					ReportTemplate: "use bytes.ToTitle method in `$$`",
				},
				ir.Rule{
					Line:           237,
					SyntaxPattern:  "draw.DrawMask($_, $_, $_, $_, nil, image.Point{}, $_)",
					ReportTemplate: "use draw.Draw method in `$$`",
				},
			},
		},
		ir.RuleGroup{
			Line:        245,
			Name:        "regexpMust",
			MatcherName: "m",
			DocTags: []string{
				"style",
			},
			DocSummary: "Detects `regexp.Compile*` that can be replaced with `regexp.MustCompile*`",
			DocBefore:  "re, _ := regexp.Compile(\"const pattern\")",
			DocAfter:   "re := regexp.MustCompile(\"const pattern\")",
			Rules: []ir.Rule{
				ir.Rule{
					Line:           246,
					SyntaxPattern:  "regexp.Compile($pat)",
					ReportTemplate: "for const patterns like $pat, use regexp.MustCompile",
					WhereExpr: ir.FilterExpr{
						Line:  247,
						Op:    ir.FilterVarConstOp,
						Src:   "m[\"pat\"].Const",
						Value: "pat",
					},
				},
				ir.Rule{
					Line:           250,
					SyntaxPattern:  "regexp.CompilePOSIX($pat)",
					ReportTemplate: "for const patterns like $pat, use regexp.MustCompilePOSIX",
					WhereExpr: ir.FilterExpr{
						Line:  251,
						Op:    ir.FilterVarConstOp,
						Src:   "m[\"pat\"].Const",
						Value: "pat",
					},
				},
			},
		},
		ir.RuleGroup{
			Line:        259,
			Name:        "badCall",
			MatcherName: "m",
			DocTags: []string{
				"diagnostic",
			},
			DocSummary: "Detects suspicious function calls",
			DocBefore:  "strings.Replace(s, from, to, 0)",
			DocAfter:   "strings.Replace(s, from, to, -1)",
			Rules: []ir.Rule{
				ir.Rule{
					Line:           260,
					SyntaxPattern:  "strings.Replace($_, $_, $_, $zero)",
					ReportTemplate: "suspicious arg 0, probably meant -1",
					WhereExpr: ir.FilterExpr{
						Line: 261,
						Op:   ir.FilterEqOp,
						Src:  "m[\"zero\"].Value.Int() == 0",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  261,
								Op:    ir.FilterVarValueIntOp,
								Src:   "m[\"zero\"].Value.Int()",
								Value: "zero",
							},
							ir.FilterExpr{
								Line:  261,
								Op:    ir.FilterIntOp,
								Src:   "0",
								Value: int64(0),
							},
						},
					},
					LocationVar: "zero",
				},
				ir.Rule{
					Line:           263,
					SyntaxPattern:  "bytes.Replace($_, $_, $_, $zero)",
					ReportTemplate: "suspicious arg 0, probably meant -1",
					WhereExpr: ir.FilterExpr{
						Line: 264,
						Op:   ir.FilterEqOp,
						Src:  "m[\"zero\"].Value.Int() == 0",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  264,
								Op:    ir.FilterVarValueIntOp,
								Src:   "m[\"zero\"].Value.Int()",
								Value: "zero",
							},
							ir.FilterExpr{
								Line:  264,
								Op:    ir.FilterIntOp,
								Src:   "0",
								Value: int64(0),
							},
						},
					},
					LocationVar: "zero",
				},
				ir.Rule{
					Line:           267,
					SyntaxPattern:  "strings.SplitN($_, $_, $zero)",
					ReportTemplate: "suspicious arg 0, probably meant -1",
					WhereExpr: ir.FilterExpr{
						Line: 268,
						Op:   ir.FilterEqOp,
						Src:  "m[\"zero\"].Value.Int() == 0",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  268,
								Op:    ir.FilterVarValueIntOp,
								Src:   "m[\"zero\"].Value.Int()",
								Value: "zero",
							},
							ir.FilterExpr{
								Line:  268,
								Op:    ir.FilterIntOp,
								Src:   "0",
								Value: int64(0),
							},
						},
					},
					LocationVar: "zero",
				},
				ir.Rule{
					Line:           270,
					SyntaxPattern:  "bytes.SplitN($_, $_, $zero)",
					ReportTemplate: "suspicious arg 0, probably meant -1",
					WhereExpr: ir.FilterExpr{
						Line: 271,
						Op:   ir.FilterEqOp,
						Src:  "m[\"zero\"].Value.Int() == 0",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  271,
								Op:    ir.FilterVarValueIntOp,
								Src:   "m[\"zero\"].Value.Int()",
								Value: "zero",
							},
							ir.FilterExpr{
								Line:  271,
								Op:    ir.FilterIntOp,
								Src:   "0",
								Value: int64(0),
							},
						},
					},
					LocationVar: "zero",
				},
				ir.Rule{
					Line:           274,
					SyntaxPattern:  "append($_)",
					ReportTemplate: "no-op append call, probably missing arguments",
				},
			},
		},
		ir.RuleGroup{
			Line:        281,
			Name:        "assignOp",
			MatcherName: "m",
			DocTags: []string{
				"style",
			},
			DocSummary: "Detects assignments that can be simplified by using assignment operators",
			DocBefore:  "x = x * 2",
			DocAfter:   "x *= 2",
			Rules: []ir.Rule{
				ir.Rule{
					Line:           282,
					SyntaxPattern:  "$x = $x + 1",
					ReportTemplate: "replace `$$` with `$x++`",
					WhereExpr: ir.FilterExpr{
						Line:  282,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           283,
					SyntaxPattern:  "$x = $x - 1",
					ReportTemplate: "replace `$$` with `$x--`",
					WhereExpr: ir.FilterExpr{
						Line:  283,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           285,
					SyntaxPattern:  "$x = $x + $y",
					ReportTemplate: "replace `$$` with `$x += $y`",
					WhereExpr: ir.FilterExpr{
						Line:  285,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           286,
					SyntaxPattern:  "$x = $x - $y",
					ReportTemplate: "replace `$$` with `$x -= $y`",
					WhereExpr: ir.FilterExpr{
						Line:  286,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           288,
					SyntaxPattern:  "$x = $x * $y",
					ReportTemplate: "replace `$$` with `$x *= $y`",
					WhereExpr: ir.FilterExpr{
						Line:  288,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           289,
					SyntaxPattern:  "$x = $x / $y",
					ReportTemplate: "replace `$$` with `$x /= $y`",
					WhereExpr: ir.FilterExpr{
						Line:  289,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           290,
					SyntaxPattern:  "$x = $x % $y",
					ReportTemplate: "replace `$$` with `$x %= $y`",
					WhereExpr: ir.FilterExpr{
						Line:  290,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           291,
					SyntaxPattern:  "$x = $x & $y",
					ReportTemplate: "replace `$$` with `$x &= $y`",
					WhereExpr: ir.FilterExpr{
						Line:  291,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           292,
					SyntaxPattern:  "$x = $x | $y",
					ReportTemplate: "replace `$$` with `$x |= $y`",
					WhereExpr: ir.FilterExpr{
						Line:  292,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           293,
					SyntaxPattern:  "$x = $x ^ $y",
					ReportTemplate: "replace `$$` with `$x ^= $y`",
					WhereExpr: ir.FilterExpr{
						Line:  293,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           294,
					SyntaxPattern:  "$x = $x << $y",
					ReportTemplate: "replace `$$` with `$x <<= $y`",
					WhereExpr: ir.FilterExpr{
						Line:  294,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           295,
					SyntaxPattern:  "$x = $x >> $y",
					ReportTemplate: "replace `$$` with `$x >>= $y`",
					WhereExpr: ir.FilterExpr{
						Line:  295,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           296,
					SyntaxPattern:  "$x = $x &^ $y",
					ReportTemplate: "replace `$$` with `$x &^= $y`",
					WhereExpr: ir.FilterExpr{
						Line:  296,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
			},
		},
		ir.RuleGroup{
			Line:        303,
			Name:        "preferWriteByte",
			MatcherName: "m",
			DocTags: []string{
				"performance",
				"experimental",
			},
			DocSummary: "Detects WriteRune calls with byte literal argument and reports to use WriteByte instead",
			DocBefore:  "w.WriteRune('\\n')",
			DocAfter:   "w.WriteByte('\\n')",
			Rules: []ir.Rule{
				ir.Rule{
					Line:           304,
					SyntaxPattern:  "$w.WriteRune($c)",
					ReportTemplate: "consider replacing $$ with $w.WriteByte($c)",
					WhereExpr: ir.FilterExpr{
						Line: 305,
						Op:   ir.FilterAndOp,
						Src:  "m[\"w\"].Type.Implements(\"io.ByteWriter\") && (m[\"c\"].Const && m[\"c\"].Value.Int() < 256)",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  305,
								Op:    ir.FilterVarTypeImplementsOp,
								Src:   "m[\"w\"].Type.Implements(\"io.ByteWriter\")",
								Value: "w",
								Args: []ir.FilterExpr{
									ir.FilterExpr{
										Line:  305,
										Op:    ir.FilterStringOp,
										Src:   "\"io.ByteWriter\"",
										Value: "io.ByteWriter",
									},
								},
							},
							ir.FilterExpr{
								Line: 305,
								Op:   ir.FilterAndOp,
								Src:  "(m[\"c\"].Const && m[\"c\"].Value.Int() < 256)",
								Args: []ir.FilterExpr{
									ir.FilterExpr{
										Line:  305,
										Op:    ir.FilterVarConstOp,
										Src:   "m[\"c\"].Const",
										Value: "c",
									},
									ir.FilterExpr{
										Line: 305,
										Op:   ir.FilterLtOp,
										Src:  "m[\"c\"].Value.Int() < 256",
										Args: []ir.FilterExpr{
											ir.FilterExpr{
												Line:  305,
												Op:    ir.FilterVarValueIntOp,
												Src:   "m[\"c\"].Value.Int()",
												Value: "c",
											},
											ir.FilterExpr{
												Line:  305,
												Op:    ir.FilterIntOp,
												Src:   "256",
												Value: int64(256),
											},
										},
									},
								},
							},
						},
					},
				},
			},
		},
		ir.RuleGroup{
			Line:        313,
			Name:        "preferFprint",
			MatcherName: "m",
			DocTags: []string{
				"performance",
				"experimental",
			},
			DocSummary: "Detects fmt.Sprint(f|ln) calls which can be replaced with fmt.Fprint(f|ln)",
			DocBefore:  "w.Write([]byte(fmt.Sprintf(\"%x\", 10)))",
			DocAfter:   "fmt.Fprintf(w, \"%x\", 10)",
			Rules: []ir.Rule{
				ir.Rule{
					Line:            314,
					SyntaxPattern:   "$w.Write([]byte(fmt.Sprint($*args)))",
					ReportTemplate:  "fmt.Fprint($w, $args) should be preferred to the $$",
					SuggestTemplate: "fmt.Fprint($w, $args)",
					WhereExpr: ir.FilterExpr{
						Line:  315,
						Op:    ir.FilterVarTypeImplementsOp,
						Src:   "m[\"w\"].Type.Implements(\"io.Writer\")",
						Value: "w",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  315,
								Op:    ir.FilterStringOp,
								Src:   "\"io.Writer\"",
								Value: "io.Writer",
							},
						},
					},
				},
				ir.Rule{
					Line:            319,
					SyntaxPattern:   "$w.Write([]byte(fmt.Sprintf($*args)))",
					ReportTemplate:  "fmt.Fprintf($w, $args) should be preferred to the $$",
					SuggestTemplate: "fmt.Fprintf($w, $args)",
					WhereExpr: ir.FilterExpr{
						Line:  320,
						Op:    ir.FilterVarTypeImplementsOp,
						Src:   "m[\"w\"].Type.Implements(\"io.Writer\")",
						Value: "w",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  320,
								Op:    ir.FilterStringOp,
								Src:   "\"io.Writer\"",
								Value: "io.Writer",
							},
						},
					},
				},
				ir.Rule{
					Line:            324,
					SyntaxPattern:   "$w.Write([]byte(fmt.Sprintln($*args)))",
					ReportTemplate:  "fmt.Fprintln($w, $args) should be preferred to the $$",
					SuggestTemplate: "fmt.Fprintln($w, $args)",
					WhereExpr: ir.FilterExpr{
						Line:  325,
						Op:    ir.FilterVarTypeImplementsOp,
						Src:   "m[\"w\"].Type.Implements(\"io.Writer\")",
						Value: "w",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  325,
								Op:    ir.FilterStringOp,
								Src:   "\"io.Writer\"",
								Value: "io.Writer",
							},
						},
					},
				},
			},
		},
		ir.RuleGroup{
			Line:        334,
			Name:        "dupArg",
			MatcherName: "m",
			DocTags: []string{
				"diagnostic",
			},
			DocSummary: "Detects suspicious duplicated arguments",
			DocBefore:  "copy(dst, dst)",
			DocAfter:   "copy(dst, src)",
			Rules: []ir.Rule{
				ir.Rule{
					Line:           335,
					SyntaxPattern:  "$x.Equal($x)",
					ReportTemplate: "suspicious method call with the same argument and receiver",
					WhereExpr: ir.FilterExpr{
						Line:  336,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           335,
					SyntaxPattern:  "$x.Equals($x)",
					ReportTemplate: "suspicious method call with the same argument and receiver",
					WhereExpr: ir.FilterExpr{
						Line:  336,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           335,
					SyntaxPattern:  "$x.Compare($x)",
					ReportTemplate: "suspicious method call with the same argument and receiver",
					WhereExpr: ir.FilterExpr{
						Line:  336,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           335,
					SyntaxPattern:  "$x.Cmp($x)",
					ReportTemplate: "suspicious method call with the same argument and receiver",
					WhereExpr: ir.FilterExpr{
						Line:  336,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "copy($x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "math.Max($x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "math.Min($x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "reflect.Copy($x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "reflect.DeepEqual($x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "strings.Contains($x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "strings.Compare($x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "strings.EqualFold($x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "strings.HasPrefix($x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "strings.HasSuffix($x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "strings.Index($x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "strings.LastIndex($x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "strings.Split($x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "strings.SplitAfter($x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "strings.SplitAfterN($x, $x, $_)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "strings.SplitN($x, $x, $_)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "strings.Replace($_, $x, $x, $_)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "strings.ReplaceAll($_, $x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "bytes.Contains($x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "bytes.Compare($x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "bytes.Equal($x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "bytes.EqualFold($x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "bytes.HasPrefix($x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "bytes.HasSuffix($x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "bytes.Index($x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "bytes.LastIndex($x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "bytes.Split($x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "bytes.SplitAfter($x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "bytes.SplitAfterN($x, $x, $_)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "bytes.SplitN($x, $x, $_)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "bytes.Replace($_, $x, $x, $_)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "bytes.ReplaceAll($_, $x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "types.Identical($x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "types.IdenticalIgnoreTags($x, $x)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
				ir.Rule{
					Line:           339,
					SyntaxPattern:  "draw.Draw($x, $_, $x, $_, $_)",
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr: ir.FilterExpr{
						Line:  374,
						Op:    ir.FilterVarPureOp,
						Src:   "m[\"x\"].Pure",
						Value: "x",
					},
				},
			},
		},
		ir.RuleGroup{
			Line:        382,
			Name:        "returnAfterHttpError",
			MatcherName: "m",
			DocTags: []string{
				"diagnostic",
				"experimental",
			},
			DocSummary: "Detects suspicious http.Error call without following return",
			DocBefore:  "x + string(os.PathSeparator) + y",
			DocAfter:   "filepath.Join(x, y)",
			Rules: []ir.Rule{
				ir.Rule{
					Line:           383,
					SyntaxPattern:  "if $_ { $*_; http.Error($w, $err, $code) }",
					ReportTemplate: "Possibly return is missed after the http.Error call",
					LocationVar:    "w",
				},
			},
		},
		ir.RuleGroup{
			Line:        392,
			Name:        "preferFilepathJoin",
			MatcherName: "m",
			DocTags: []string{
				"style",
				"experimental",
			},
			DocSummary: "Detects concatenation with os.PathSeparator which can be replaced with filepath.Join",
			DocBefore:  "x + string(os.PathSeparator) + y",
			DocAfter:   "filepath.Join(x, y)",
			Rules: []ir.Rule{
				ir.Rule{
					Line:            393,
					SyntaxPattern:   "$x + string(os.PathSeparator) + $y",
					ReportTemplate:  "filepath.Join($x, $y) should be preferred to the $$",
					SuggestTemplate: "filepath.Join($x, $y)",
					WhereExpr: ir.FilterExpr{
						Line: 394,
						Op:   ir.FilterAndOp,
						Src:  "m[\"x\"].Type.Is(`string`) && m[\"y\"].Type.Is(`string`)",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  394,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"x\"].Type.Is(`string`)",
								Value: "x",
								Args: []ir.FilterExpr{
									ir.FilterExpr{
										Line:  394,
										Op:    ir.FilterStringOp,
										Src:   "`string`",
										Value: "string",
									},
								},
							},
							ir.FilterExpr{
								Line:  394,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"y\"].Type.Is(`string`)",
								Value: "y",
								Args: []ir.FilterExpr{
									ir.FilterExpr{
										Line:  394,
										Op:    ir.FilterStringOp,
										Src:   "`string`",
										Value: "string",
									},
								},
							},
						},
					},
				},
			},
		},
		ir.RuleGroup{
			Line:        403,
			Name:        "preferStringWriter",
			MatcherName: "m",
			DocTags: []string{
				"performance",
				"experimental",
			},
			DocSummary: "Detects w.Write or io.WriteString calls which can be replaced with w.WriteString",
			DocBefore:  "w.Write([]byte(\"foo\"))",
			DocAfter:   "w.WriteString(\"foo\")",
			Rules: []ir.Rule{
				ir.Rule{
					Line:            404,
					SyntaxPattern:   "$w.Write([]byte($s))",
					ReportTemplate:  "$w.WriteString($s) should be preferred to the $$",
					SuggestTemplate: "$w.WriteString($s)",
					WhereExpr: ir.FilterExpr{
						Line:  405,
						Op:    ir.FilterVarTypeImplementsOp,
						Src:   "m[\"w\"].Type.Implements(\"io.StringWriter\")",
						Value: "w",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  405,
								Op:    ir.FilterStringOp,
								Src:   "\"io.StringWriter\"",
								Value: "io.StringWriter",
							},
						},
					},
				},
				ir.Rule{
					Line:            409,
					SyntaxPattern:   "io.WriteString($w, $s)",
					ReportTemplate:  "$w.WriteString($s) should be preferred to the $$",
					SuggestTemplate: "$w.WriteString($s)",
					WhereExpr: ir.FilterExpr{
						Line:  410,
						Op:    ir.FilterVarTypeImplementsOp,
						Src:   "m[\"w\"].Type.Implements(\"io.StringWriter\")",
						Value: "w",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  410,
								Op:    ir.FilterStringOp,
								Src:   "\"io.StringWriter\"",
								Value: "io.StringWriter",
							},
						},
					},
				},
			},
		},
		ir.RuleGroup{
			Line:        419,
			Name:        "sliceClear",
			MatcherName: "m",
			DocTags: []string{
				"performance",
				"experimental",
			},
			DocSummary: "Detects slice clear loops, suggests an idiom that is recognized by the Go compiler",
			DocBefore:  "for i := 0; i < len(buf); i++ { buf[i] = 0 }",
			DocAfter:   "for i := range buf { buf[i] = 0 }",
			Rules: []ir.Rule{
				ir.Rule{
					Line:           420,
					SyntaxPattern:  "for $i := 0; $i < len($xs); $i++ { $xs[$i] = $zero }",
					ReportTemplate: "rewrite as for-range so compiler can recognize this pattern",
					WhereExpr: ir.FilterExpr{
						Line: 421,
						Op:   ir.FilterEqOp,
						Src:  "m[\"zero\"].Value.Int() == 0",
						Args: []ir.FilterExpr{
							ir.FilterExpr{
								Line:  421,
								Op:    ir.FilterVarValueIntOp,
								Src:   "m[\"zero\"].Value.Int()",
								Value: "zero",
							},
							ir.FilterExpr{
								Line:  421,
								Op:    ir.FilterIntOp,
								Src:   "0",
								Value: int64(0),
							},
						},
					},
				},
			},
		},
	},
}

