---
comments: false
---

# Install GitLab Runner

GitLab Runner can be installed and used on GNU/Linux, macOS, FreeBSD, and Windows.
There are three ways to install it. Use Docker, download a binary manually, or
use a repository for rpm/deb packages.

GitLab Runner officially supported binaries are available for the following architectures:

- x86, AMD64, ARM64, ARM, s390x

Official packages are available for the following Linux distributions:

- CentOS, Debian, Ubuntu, RHEL, Fedora, Mint

Runner officially supports the following operating systems:

- Linux, Windows, macOS, FreeBSD

You can find information on the different installation methods below.

<!--You can also view installation instructions in GitLab by going to your project's
**Settings > CI / CD**, expanding the **Runners** section, and clicking
**Show Runner installation instructions**.-->

## Repositories

- [Install using GitLab's repository for Debian/Ubuntu/CentOS/RedHat](linux-repository.md)

## Binaries

- [Install on GNU/Linux](linux-manually.md)
- [Install on macOS](osx.md)
- [Install on Windows](windows.md)
- [Install on FreeBSD](freebsd.md)
- [Install nightly builds](bleeding-edge.md)

## Docker service

- [Install as a Docker service](docker.md)
- [Install on Kubernetes](kubernetes.md)
- [Install on OpenShift](openshift.md)

## Autoscale

- [Install in autoscaling mode using Docker machine](../executors/docker_machine.md)
- [Install the registry and cache servers](registry_and_cache_servers.md)
