// Copyright 2017 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// THIS FILE IS AUTOMATICALLY GENERATED.

package openapi_v3

import (
	"fmt"
	"github.com/googleapis/gnostic/compiler"
	"gopkg.in/yaml.v2"
	"regexp"
	"strings"
)

// Version returns the package name (and OpenAPI version).
func Version() string {
	return "openapi_v3"
}

// NewAdditionalPropertiesItem creates an object of type AdditionalPropertiesItem if possible, returning an error if not.
func NewAdditionalPropertiesItem(in interface{}, context *compiler.Context) (*AdditionalPropertiesItem, error) {
	errors := make([]error, 0)
	x := &AdditionalPropertiesItem{}
	matched := false
	// SchemaOrReference schema_or_reference = 1;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewSchemaOrReference(m, compiler.NewContext("schemaOrReference", context))
			if matchingError == nil {
				x.Oneof = &AdditionalPropertiesItem_SchemaOrReference{SchemaOrReference: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	// bool boolean = 2;
	boolValue, ok := in.(bool)
	if ok {
		x.Oneof = &AdditionalPropertiesItem_Boolean{Boolean: boolValue}
	}
	if matched {
		// since the oneof matched one of its possibilities, discard any matching errors
		errors = make([]error, 0)
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewAny creates an object of type Any if possible, returning an error if not.
func NewAny(in interface{}, context *compiler.Context) (*Any, error) {
	errors := make([]error, 0)
	x := &Any{}
	bytes, _ := yaml.Marshal(in)
	x.Yaml = string(bytes)
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewAnyOrExpression creates an object of type AnyOrExpression if possible, returning an error if not.
func NewAnyOrExpression(in interface{}, context *compiler.Context) (*AnyOrExpression, error) {
	errors := make([]error, 0)
	x := &AnyOrExpression{}
	matched := false
	// Any any = 1;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewAny(m, compiler.NewContext("any", context))
			if matchingError == nil {
				x.Oneof = &AnyOrExpression_Any{Any: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	// Expression expression = 2;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewExpression(m, compiler.NewContext("expression", context))
			if matchingError == nil {
				x.Oneof = &AnyOrExpression_Expression{Expression: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	if matched {
		// since the oneof matched one of its possibilities, discard any matching errors
		errors = make([]error, 0)
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewAnysOrExpressions creates an object of type AnysOrExpressions if possible, returning an error if not.
func NewAnysOrExpressions(in interface{}, context *compiler.Context) (*AnysOrExpressions, error) {
	errors := make([]error, 0)
	x := &AnysOrExpressions{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedAnyOrExpression additional_properties = 1;
		// MAP: AnyOrExpression
		x.AdditionalProperties = make([]*NamedAnyOrExpression, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedAnyOrExpression{}
				pair.Name = k
				var err error
				pair.Value, err = NewAnyOrExpression(v, compiler.NewContext(k, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewCallback creates an object of type Callback if possible, returning an error if not.
func NewCallback(in interface{}, context *compiler.Context) (*Callback, error) {
	errors := make([]error, 0)
	x := &Callback{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{}
		allowedPatterns := []*regexp.Regexp{pattern0, pattern1}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// repeated NamedPathItem path = 1;
		// MAP: PathItem ^
		x.Path = make([]*NamedPathItem, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if true {
					pair := &NamedPathItem{}
					pair.Name = k
					var err error
					pair.Value, err = NewPathItem(v, compiler.NewContext(k, context))
					if err != nil {
						errors = append(errors, err)
					}
					x.Path = append(x.Path, pair)
				}
			}
		}
		// repeated NamedAny specification_extension = 2;
		// MAP: Any ^x-
		x.SpecificationExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "x-") {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.SpecificationExtension = append(x.SpecificationExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewCallbackOrReference creates an object of type CallbackOrReference if possible, returning an error if not.
func NewCallbackOrReference(in interface{}, context *compiler.Context) (*CallbackOrReference, error) {
	errors := make([]error, 0)
	x := &CallbackOrReference{}
	matched := false
	// Callback callback = 1;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewCallback(m, compiler.NewContext("callback", context))
			if matchingError == nil {
				x.Oneof = &CallbackOrReference_Callback{Callback: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	// Reference reference = 2;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewReference(m, compiler.NewContext("reference", context))
			if matchingError == nil {
				x.Oneof = &CallbackOrReference_Reference{Reference: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	if matched {
		// since the oneof matched one of its possibilities, discard any matching errors
		errors = make([]error, 0)
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewCallbacksOrReferences creates an object of type CallbacksOrReferences if possible, returning an error if not.
func NewCallbacksOrReferences(in interface{}, context *compiler.Context) (*CallbacksOrReferences, error) {
	errors := make([]error, 0)
	x := &CallbacksOrReferences{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedCallbackOrReference additional_properties = 1;
		// MAP: CallbackOrReference
		x.AdditionalProperties = make([]*NamedCallbackOrReference, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedCallbackOrReference{}
				pair.Name = k
				var err error
				pair.Value, err = NewCallbackOrReference(v, compiler.NewContext(k, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewComponents creates an object of type Components if possible, returning an error if not.
func NewComponents(in interface{}, context *compiler.Context) (*Components, error) {
	errors := make([]error, 0)
	x := &Components{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"callbacks", "examples", "headers", "links", "parameters", "requestBodies", "responses", "schemas", "securitySchemes"}
		allowedPatterns := []*regexp.Regexp{pattern1}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// SchemasOrReferences schemas = 1;
		v1 := compiler.MapValueForKey(m, "schemas")
		if v1 != nil {
			var err error
			x.Schemas, err = NewSchemasOrReferences(v1, compiler.NewContext("schemas", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// ResponsesOrReferences responses = 2;
		v2 := compiler.MapValueForKey(m, "responses")
		if v2 != nil {
			var err error
			x.Responses, err = NewResponsesOrReferences(v2, compiler.NewContext("responses", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// ParametersOrReferences parameters = 3;
		v3 := compiler.MapValueForKey(m, "parameters")
		if v3 != nil {
			var err error
			x.Parameters, err = NewParametersOrReferences(v3, compiler.NewContext("parameters", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// ExamplesOrReferences examples = 4;
		v4 := compiler.MapValueForKey(m, "examples")
		if v4 != nil {
			var err error
			x.Examples, err = NewExamplesOrReferences(v4, compiler.NewContext("examples", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// RequestBodiesOrReferences request_bodies = 5;
		v5 := compiler.MapValueForKey(m, "requestBodies")
		if v5 != nil {
			var err error
			x.RequestBodies, err = NewRequestBodiesOrReferences(v5, compiler.NewContext("requestBodies", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// HeadersOrReferences headers = 6;
		v6 := compiler.MapValueForKey(m, "headers")
		if v6 != nil {
			var err error
			x.Headers, err = NewHeadersOrReferences(v6, compiler.NewContext("headers", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// SecuritySchemesOrReferences security_schemes = 7;
		v7 := compiler.MapValueForKey(m, "securitySchemes")
		if v7 != nil {
			var err error
			x.SecuritySchemes, err = NewSecuritySchemesOrReferences(v7, compiler.NewContext("securitySchemes", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// LinksOrReferences links = 8;
		v8 := compiler.MapValueForKey(m, "links")
		if v8 != nil {
			var err error
			x.Links, err = NewLinksOrReferences(v8, compiler.NewContext("links", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// CallbacksOrReferences callbacks = 9;
		v9 := compiler.MapValueForKey(m, "callbacks")
		if v9 != nil {
			var err error
			x.Callbacks, err = NewCallbacksOrReferences(v9, compiler.NewContext("callbacks", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated NamedAny specification_extension = 10;
		// MAP: Any ^x-
		x.SpecificationExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "x-") {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.SpecificationExtension = append(x.SpecificationExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewContact creates an object of type Contact if possible, returning an error if not.
func NewContact(in interface{}, context *compiler.Context) (*Contact, error) {
	errors := make([]error, 0)
	x := &Contact{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"email", "name", "url"}
		allowedPatterns := []*regexp.Regexp{pattern1}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string url = 2;
		v2 := compiler.MapValueForKey(m, "url")
		if v2 != nil {
			x.Url, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for url: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string email = 3;
		v3 := compiler.MapValueForKey(m, "email")
		if v3 != nil {
			x.Email, ok = v3.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for email: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated NamedAny specification_extension = 4;
		// MAP: Any ^x-
		x.SpecificationExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "x-") {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.SpecificationExtension = append(x.SpecificationExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewDefaultType creates an object of type DefaultType if possible, returning an error if not.
func NewDefaultType(in interface{}, context *compiler.Context) (*DefaultType, error) {
	errors := make([]error, 0)
	x := &DefaultType{}
	matched := false
	switch in := in.(type) {
	case bool:
		x.Oneof = &DefaultType_Boolean{Boolean: in}
		matched = true
	case string:
		x.Oneof = &DefaultType_String_{String_: in}
		matched = true
	case int64:
		x.Oneof = &DefaultType_Number{Number: float64(in)}
		matched = true
	case int32:
		x.Oneof = &DefaultType_Number{Number: float64(in)}
		matched = true
	case int:
		x.Oneof = &DefaultType_Number{Number: float64(in)}
		matched = true
	case float64:
		x.Oneof = &DefaultType_Number{Number: in}
		matched = true
	case float32:
		x.Oneof = &DefaultType_Number{Number: float64(in)}
		matched = true
	}
	if matched {
		// since the oneof matched one of its possibilities, discard any matching errors
		errors = make([]error, 0)
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewDiscriminator creates an object of type Discriminator if possible, returning an error if not.
func NewDiscriminator(in interface{}, context *compiler.Context) (*Discriminator, error) {
	errors := make([]error, 0)
	x := &Discriminator{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"propertyName"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"mapping", "propertyName"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string property_name = 1;
		v1 := compiler.MapValueForKey(m, "propertyName")
		if v1 != nil {
			x.PropertyName, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for propertyName: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Strings mapping = 2;
		v2 := compiler.MapValueForKey(m, "mapping")
		if v2 != nil {
			var err error
			x.Mapping, err = NewStrings(v2, compiler.NewContext("mapping", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewDocument creates an object of type Document if possible, returning an error if not.
func NewDocument(in interface{}, context *compiler.Context) (*Document, error) {
	errors := make([]error, 0)
	x := &Document{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"info", "openapi", "paths"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"components", "externalDocs", "info", "openapi", "paths", "security", "servers", "tags"}
		allowedPatterns := []*regexp.Regexp{pattern1}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string openapi = 1;
		v1 := compiler.MapValueForKey(m, "openapi")
		if v1 != nil {
			x.Openapi, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for openapi: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Info info = 2;
		v2 := compiler.MapValueForKey(m, "info")
		if v2 != nil {
			var err error
			x.Info, err = NewInfo(v2, compiler.NewContext("info", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated Server servers = 3;
		v3 := compiler.MapValueForKey(m, "servers")
		if v3 != nil {
			// repeated Server
			x.Servers = make([]*Server, 0)
			a, ok := v3.([]interface{})
			if ok {
				for _, item := range a {
					y, err := NewServer(item, compiler.NewContext("servers", context))
					if err != nil {
						errors = append(errors, err)
					}
					x.Servers = append(x.Servers, y)
				}
			}
		}
		// Paths paths = 4;
		v4 := compiler.MapValueForKey(m, "paths")
		if v4 != nil {
			var err error
			x.Paths, err = NewPaths(v4, compiler.NewContext("paths", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Components components = 5;
		v5 := compiler.MapValueForKey(m, "components")
		if v5 != nil {
			var err error
			x.Components, err = NewComponents(v5, compiler.NewContext("components", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated SecurityRequirement security = 6;
		v6 := compiler.MapValueForKey(m, "security")
		if v6 != nil {
			// repeated SecurityRequirement
			x.Security = make([]*SecurityRequirement, 0)
			a, ok := v6.([]interface{})
			if ok {
				for _, item := range a {
					y, err := NewSecurityRequirement(item, compiler.NewContext("security", context))
					if err != nil {
						errors = append(errors, err)
					}
					x.Security = append(x.Security, y)
				}
			}
		}
		// repeated Tag tags = 7;
		v7 := compiler.MapValueForKey(m, "tags")
		if v7 != nil {
			// repeated Tag
			x.Tags = make([]*Tag, 0)
			a, ok := v7.([]interface{})
			if ok {
				for _, item := range a {
					y, err := NewTag(item, compiler.NewContext("tags", context))
					if err != nil {
						errors = append(errors, err)
					}
					x.Tags = append(x.Tags, y)
				}
			}
		}
		// ExternalDocs external_docs = 8;
		v8 := compiler.MapValueForKey(m, "externalDocs")
		if v8 != nil {
			var err error
			x.ExternalDocs, err = NewExternalDocs(v8, compiler.NewContext("externalDocs", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated NamedAny specification_extension = 9;
		// MAP: Any ^x-
		x.SpecificationExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "x-") {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.SpecificationExtension = append(x.SpecificationExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewEncoding creates an object of type Encoding if possible, returning an error if not.
func NewEncoding(in interface{}, context *compiler.Context) (*Encoding, error) {
	errors := make([]error, 0)
	x := &Encoding{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"allowReserved", "contentType", "explode", "headers", "style"}
		allowedPatterns := []*regexp.Regexp{pattern1}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string content_type = 1;
		v1 := compiler.MapValueForKey(m, "contentType")
		if v1 != nil {
			x.ContentType, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for contentType: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// HeadersOrReferences headers = 2;
		v2 := compiler.MapValueForKey(m, "headers")
		if v2 != nil {
			var err error
			x.Headers, err = NewHeadersOrReferences(v2, compiler.NewContext("headers", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// string style = 3;
		v3 := compiler.MapValueForKey(m, "style")
		if v3 != nil {
			x.Style, ok = v3.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for style: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool explode = 4;
		v4 := compiler.MapValueForKey(m, "explode")
		if v4 != nil {
			x.Explode, ok = v4.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for explode: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool allow_reserved = 5;
		v5 := compiler.MapValueForKey(m, "allowReserved")
		if v5 != nil {
			x.AllowReserved, ok = v5.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for allowReserved: %+v (%T)", v5, v5)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated NamedAny specification_extension = 6;
		// MAP: Any ^x-
		x.SpecificationExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "x-") {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.SpecificationExtension = append(x.SpecificationExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewEncodings creates an object of type Encodings if possible, returning an error if not.
func NewEncodings(in interface{}, context *compiler.Context) (*Encodings, error) {
	errors := make([]error, 0)
	x := &Encodings{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedEncoding additional_properties = 1;
		// MAP: Encoding
		x.AdditionalProperties = make([]*NamedEncoding, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedEncoding{}
				pair.Name = k
				var err error
				pair.Value, err = NewEncoding(v, compiler.NewContext(k, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewExample creates an object of type Example if possible, returning an error if not.
func NewExample(in interface{}, context *compiler.Context) (*Example, error) {
	errors := make([]error, 0)
	x := &Example{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"description", "externalValue", "summary", "value"}
		allowedPatterns := []*regexp.Regexp{pattern1}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string summary = 1;
		v1 := compiler.MapValueForKey(m, "summary")
		if v1 != nil {
			x.Summary, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for summary: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 2;
		v2 := compiler.MapValueForKey(m, "description")
		if v2 != nil {
			x.Description, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Any value = 3;
		v3 := compiler.MapValueForKey(m, "value")
		if v3 != nil {
			var err error
			x.Value, err = NewAny(v3, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// string external_value = 4;
		v4 := compiler.MapValueForKey(m, "externalValue")
		if v4 != nil {
			x.ExternalValue, ok = v4.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for externalValue: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated NamedAny specification_extension = 5;
		// MAP: Any ^x-
		x.SpecificationExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "x-") {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.SpecificationExtension = append(x.SpecificationExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewExampleOrReference creates an object of type ExampleOrReference if possible, returning an error if not.
func NewExampleOrReference(in interface{}, context *compiler.Context) (*ExampleOrReference, error) {
	errors := make([]error, 0)
	x := &ExampleOrReference{}
	matched := false
	// Example example = 1;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewExample(m, compiler.NewContext("example", context))
			if matchingError == nil {
				x.Oneof = &ExampleOrReference_Example{Example: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	// Reference reference = 2;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewReference(m, compiler.NewContext("reference", context))
			if matchingError == nil {
				x.Oneof = &ExampleOrReference_Reference{Reference: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	if matched {
		// since the oneof matched one of its possibilities, discard any matching errors
		errors = make([]error, 0)
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewExamples creates an object of type Examples if possible, returning an error if not.
func NewExamples(in interface{}, context *compiler.Context) (*Examples, error) {
	errors := make([]error, 0)
	x := &Examples{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewExamplesOrReferences creates an object of type ExamplesOrReferences if possible, returning an error if not.
func NewExamplesOrReferences(in interface{}, context *compiler.Context) (*ExamplesOrReferences, error) {
	errors := make([]error, 0)
	x := &ExamplesOrReferences{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedExampleOrReference additional_properties = 1;
		// MAP: ExampleOrReference
		x.AdditionalProperties = make([]*NamedExampleOrReference, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedExampleOrReference{}
				pair.Name = k
				var err error
				pair.Value, err = NewExampleOrReference(v, compiler.NewContext(k, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewExpression creates an object of type Expression if possible, returning an error if not.
func NewExpression(in interface{}, context *compiler.Context) (*Expression, error) {
	errors := make([]error, 0)
	x := &Expression{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedAny additional_properties = 1;
		// MAP: Any
		x.AdditionalProperties = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedAny{}
				pair.Name = k
				result := &Any{}
				handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
				if handled {
					if err != nil {
						errors = append(errors, err)
					} else {
						bytes, _ := yaml.Marshal(v)
						result.Yaml = string(bytes)
						result.Value = resultFromExt
						pair.Value = result
					}
				} else {
					pair.Value, err = NewAny(v, compiler.NewContext(k, context))
					if err != nil {
						errors = append(errors, err)
					}
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewExternalDocs creates an object of type ExternalDocs if possible, returning an error if not.
func NewExternalDocs(in interface{}, context *compiler.Context) (*ExternalDocs, error) {
	errors := make([]error, 0)
	x := &ExternalDocs{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"url"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"description", "url"}
		allowedPatterns := []*regexp.Regexp{pattern1}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string description = 1;
		v1 := compiler.MapValueForKey(m, "description")
		if v1 != nil {
			x.Description, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string url = 2;
		v2 := compiler.MapValueForKey(m, "url")
		if v2 != nil {
			x.Url, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for url: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated NamedAny specification_extension = 3;
		// MAP: Any ^x-
		x.SpecificationExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "x-") {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.SpecificationExtension = append(x.SpecificationExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewHeader creates an object of type Header if possible, returning an error if not.
func NewHeader(in interface{}, context *compiler.Context) (*Header, error) {
	errors := make([]error, 0)
	x := &Header{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"allowEmptyValue", "allowReserved", "content", "deprecated", "description", "example", "examples", "explode", "required", "schema", "style"}
		allowedPatterns := []*regexp.Regexp{pattern1}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string description = 1;
		v1 := compiler.MapValueForKey(m, "description")
		if v1 != nil {
			x.Description, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool required = 2;
		v2 := compiler.MapValueForKey(m, "required")
		if v2 != nil {
			x.Required, ok = v2.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for required: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool deprecated = 3;
		v3 := compiler.MapValueForKey(m, "deprecated")
		if v3 != nil {
			x.Deprecated, ok = v3.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for deprecated: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool allow_empty_value = 4;
		v4 := compiler.MapValueForKey(m, "allowEmptyValue")
		if v4 != nil {
			x.AllowEmptyValue, ok = v4.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for allowEmptyValue: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string style = 5;
		v5 := compiler.MapValueForKey(m, "style")
		if v5 != nil {
			x.Style, ok = v5.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for style: %+v (%T)", v5, v5)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool explode = 6;
		v6 := compiler.MapValueForKey(m, "explode")
		if v6 != nil {
			x.Explode, ok = v6.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for explode: %+v (%T)", v6, v6)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool allow_reserved = 7;
		v7 := compiler.MapValueForKey(m, "allowReserved")
		if v7 != nil {
			x.AllowReserved, ok = v7.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for allowReserved: %+v (%T)", v7, v7)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// SchemaOrReference schema = 8;
		v8 := compiler.MapValueForKey(m, "schema")
		if v8 != nil {
			var err error
			x.Schema, err = NewSchemaOrReference(v8, compiler.NewContext("schema", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Any example = 9;
		v9 := compiler.MapValueForKey(m, "example")
		if v9 != nil {
			var err error
			x.Example, err = NewAny(v9, compiler.NewContext("example", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// ExamplesOrReferences examples = 10;
		v10 := compiler.MapValueForKey(m, "examples")
		if v10 != nil {
			var err error
			x.Examples, err = NewExamplesOrReferences(v10, compiler.NewContext("examples", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// MediaTypes content = 11;
		v11 := compiler.MapValueForKey(m, "content")
		if v11 != nil {
			var err error
			x.Content, err = NewMediaTypes(v11, compiler.NewContext("content", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated NamedAny specification_extension = 12;
		// MAP: Any ^x-
		x.SpecificationExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "x-") {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.SpecificationExtension = append(x.SpecificationExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewHeaderOrReference creates an object of type HeaderOrReference if possible, returning an error if not.
func NewHeaderOrReference(in interface{}, context *compiler.Context) (*HeaderOrReference, error) {
	errors := make([]error, 0)
	x := &HeaderOrReference{}
	matched := false
	// Header header = 1;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewHeader(m, compiler.NewContext("header", context))
			if matchingError == nil {
				x.Oneof = &HeaderOrReference_Header{Header: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	// Reference reference = 2;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewReference(m, compiler.NewContext("reference", context))
			if matchingError == nil {
				x.Oneof = &HeaderOrReference_Reference{Reference: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	if matched {
		// since the oneof matched one of its possibilities, discard any matching errors
		errors = make([]error, 0)
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewHeadersOrReferences creates an object of type HeadersOrReferences if possible, returning an error if not.
func NewHeadersOrReferences(in interface{}, context *compiler.Context) (*HeadersOrReferences, error) {
	errors := make([]error, 0)
	x := &HeadersOrReferences{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedHeaderOrReference additional_properties = 1;
		// MAP: HeaderOrReference
		x.AdditionalProperties = make([]*NamedHeaderOrReference, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedHeaderOrReference{}
				pair.Name = k
				var err error
				pair.Value, err = NewHeaderOrReference(v, compiler.NewContext(k, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewInfo creates an object of type Info if possible, returning an error if not.
func NewInfo(in interface{}, context *compiler.Context) (*Info, error) {
	errors := make([]error, 0)
	x := &Info{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"title", "version"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"contact", "description", "license", "termsOfService", "title", "version"}
		allowedPatterns := []*regexp.Regexp{pattern1}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string title = 1;
		v1 := compiler.MapValueForKey(m, "title")
		if v1 != nil {
			x.Title, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for title: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 2;
		v2 := compiler.MapValueForKey(m, "description")
		if v2 != nil {
			x.Description, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string terms_of_service = 3;
		v3 := compiler.MapValueForKey(m, "termsOfService")
		if v3 != nil {
			x.TermsOfService, ok = v3.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for termsOfService: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Contact contact = 4;
		v4 := compiler.MapValueForKey(m, "contact")
		if v4 != nil {
			var err error
			x.Contact, err = NewContact(v4, compiler.NewContext("contact", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// License license = 5;
		v5 := compiler.MapValueForKey(m, "license")
		if v5 != nil {
			var err error
			x.License, err = NewLicense(v5, compiler.NewContext("license", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// string version = 6;
		v6 := compiler.MapValueForKey(m, "version")
		if v6 != nil {
			x.Version, ok = v6.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for version: %+v (%T)", v6, v6)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated NamedAny specification_extension = 7;
		// MAP: Any ^x-
		x.SpecificationExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "x-") {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.SpecificationExtension = append(x.SpecificationExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewItemsItem creates an object of type ItemsItem if possible, returning an error if not.
func NewItemsItem(in interface{}, context *compiler.Context) (*ItemsItem, error) {
	errors := make([]error, 0)
	x := &ItemsItem{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value for item array: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		x.SchemaOrReference = make([]*SchemaOrReference, 0)
		y, err := NewSchemaOrReference(m, compiler.NewContext("<array>", context))
		if err != nil {
			return nil, err
		}
		x.SchemaOrReference = append(x.SchemaOrReference, y)
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewLicense creates an object of type License if possible, returning an error if not.
func NewLicense(in interface{}, context *compiler.Context) (*License, error) {
	errors := make([]error, 0)
	x := &License{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"name"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"name", "url"}
		allowedPatterns := []*regexp.Regexp{pattern1}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string url = 2;
		v2 := compiler.MapValueForKey(m, "url")
		if v2 != nil {
			x.Url, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for url: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated NamedAny specification_extension = 3;
		// MAP: Any ^x-
		x.SpecificationExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "x-") {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.SpecificationExtension = append(x.SpecificationExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewLink creates an object of type Link if possible, returning an error if not.
func NewLink(in interface{}, context *compiler.Context) (*Link, error) {
	errors := make([]error, 0)
	x := &Link{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"description", "operationId", "operationRef", "parameters", "requestBody", "server"}
		allowedPatterns := []*regexp.Regexp{pattern1}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string operation_ref = 1;
		v1 := compiler.MapValueForKey(m, "operationRef")
		if v1 != nil {
			x.OperationRef, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for operationRef: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string operation_id = 2;
		v2 := compiler.MapValueForKey(m, "operationId")
		if v2 != nil {
			x.OperationId, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for operationId: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// AnysOrExpressions parameters = 3;
		v3 := compiler.MapValueForKey(m, "parameters")
		if v3 != nil {
			var err error
			x.Parameters, err = NewAnysOrExpressions(v3, compiler.NewContext("parameters", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// AnyOrExpression request_body = 4;
		v4 := compiler.MapValueForKey(m, "requestBody")
		if v4 != nil {
			var err error
			x.RequestBody, err = NewAnyOrExpression(v4, compiler.NewContext("requestBody", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// string description = 5;
		v5 := compiler.MapValueForKey(m, "description")
		if v5 != nil {
			x.Description, ok = v5.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v5, v5)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Server server = 6;
		v6 := compiler.MapValueForKey(m, "server")
		if v6 != nil {
			var err error
			x.Server, err = NewServer(v6, compiler.NewContext("server", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated NamedAny specification_extension = 7;
		// MAP: Any ^x-
		x.SpecificationExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "x-") {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.SpecificationExtension = append(x.SpecificationExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewLinkOrReference creates an object of type LinkOrReference if possible, returning an error if not.
func NewLinkOrReference(in interface{}, context *compiler.Context) (*LinkOrReference, error) {
	errors := make([]error, 0)
	x := &LinkOrReference{}
	matched := false
	// Link link = 1;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewLink(m, compiler.NewContext("link", context))
			if matchingError == nil {
				x.Oneof = &LinkOrReference_Link{Link: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	// Reference reference = 2;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewReference(m, compiler.NewContext("reference", context))
			if matchingError == nil {
				x.Oneof = &LinkOrReference_Reference{Reference: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	if matched {
		// since the oneof matched one of its possibilities, discard any matching errors
		errors = make([]error, 0)
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewLinksOrReferences creates an object of type LinksOrReferences if possible, returning an error if not.
func NewLinksOrReferences(in interface{}, context *compiler.Context) (*LinksOrReferences, error) {
	errors := make([]error, 0)
	x := &LinksOrReferences{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedLinkOrReference additional_properties = 1;
		// MAP: LinkOrReference
		x.AdditionalProperties = make([]*NamedLinkOrReference, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedLinkOrReference{}
				pair.Name = k
				var err error
				pair.Value, err = NewLinkOrReference(v, compiler.NewContext(k, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewMediaType creates an object of type MediaType if possible, returning an error if not.
func NewMediaType(in interface{}, context *compiler.Context) (*MediaType, error) {
	errors := make([]error, 0)
	x := &MediaType{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"encoding", "example", "examples", "schema"}
		allowedPatterns := []*regexp.Regexp{pattern1}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// SchemaOrReference schema = 1;
		v1 := compiler.MapValueForKey(m, "schema")
		if v1 != nil {
			var err error
			x.Schema, err = NewSchemaOrReference(v1, compiler.NewContext("schema", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Any example = 2;
		v2 := compiler.MapValueForKey(m, "example")
		if v2 != nil {
			var err error
			x.Example, err = NewAny(v2, compiler.NewContext("example", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// ExamplesOrReferences examples = 3;
		v3 := compiler.MapValueForKey(m, "examples")
		if v3 != nil {
			var err error
			x.Examples, err = NewExamplesOrReferences(v3, compiler.NewContext("examples", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Encodings encoding = 4;
		v4 := compiler.MapValueForKey(m, "encoding")
		if v4 != nil {
			var err error
			x.Encoding, err = NewEncodings(v4, compiler.NewContext("encoding", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated NamedAny specification_extension = 5;
		// MAP: Any ^x-
		x.SpecificationExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "x-") {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.SpecificationExtension = append(x.SpecificationExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewMediaTypes creates an object of type MediaTypes if possible, returning an error if not.
func NewMediaTypes(in interface{}, context *compiler.Context) (*MediaTypes, error) {
	errors := make([]error, 0)
	x := &MediaTypes{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedMediaType additional_properties = 1;
		// MAP: MediaType
		x.AdditionalProperties = make([]*NamedMediaType, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedMediaType{}
				pair.Name = k
				var err error
				pair.Value, err = NewMediaType(v, compiler.NewContext(k, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedAny creates an object of type NamedAny if possible, returning an error if not.
func NewNamedAny(in interface{}, context *compiler.Context) (*NamedAny, error) {
	errors := make([]error, 0)
	x := &NamedAny{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Any value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewAny(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedAnyOrExpression creates an object of type NamedAnyOrExpression if possible, returning an error if not.
func NewNamedAnyOrExpression(in interface{}, context *compiler.Context) (*NamedAnyOrExpression, error) {
	errors := make([]error, 0)
	x := &NamedAnyOrExpression{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// AnyOrExpression value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewAnyOrExpression(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedCallbackOrReference creates an object of type NamedCallbackOrReference if possible, returning an error if not.
func NewNamedCallbackOrReference(in interface{}, context *compiler.Context) (*NamedCallbackOrReference, error) {
	errors := make([]error, 0)
	x := &NamedCallbackOrReference{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// CallbackOrReference value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewCallbackOrReference(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedEncoding creates an object of type NamedEncoding if possible, returning an error if not.
func NewNamedEncoding(in interface{}, context *compiler.Context) (*NamedEncoding, error) {
	errors := make([]error, 0)
	x := &NamedEncoding{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Encoding value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewEncoding(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedExampleOrReference creates an object of type NamedExampleOrReference if possible, returning an error if not.
func NewNamedExampleOrReference(in interface{}, context *compiler.Context) (*NamedExampleOrReference, error) {
	errors := make([]error, 0)
	x := &NamedExampleOrReference{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// ExampleOrReference value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewExampleOrReference(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedHeaderOrReference creates an object of type NamedHeaderOrReference if possible, returning an error if not.
func NewNamedHeaderOrReference(in interface{}, context *compiler.Context) (*NamedHeaderOrReference, error) {
	errors := make([]error, 0)
	x := &NamedHeaderOrReference{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// HeaderOrReference value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewHeaderOrReference(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedLinkOrReference creates an object of type NamedLinkOrReference if possible, returning an error if not.
func NewNamedLinkOrReference(in interface{}, context *compiler.Context) (*NamedLinkOrReference, error) {
	errors := make([]error, 0)
	x := &NamedLinkOrReference{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// LinkOrReference value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewLinkOrReference(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedMediaType creates an object of type NamedMediaType if possible, returning an error if not.
func NewNamedMediaType(in interface{}, context *compiler.Context) (*NamedMediaType, error) {
	errors := make([]error, 0)
	x := &NamedMediaType{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// MediaType value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewMediaType(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedParameterOrReference creates an object of type NamedParameterOrReference if possible, returning an error if not.
func NewNamedParameterOrReference(in interface{}, context *compiler.Context) (*NamedParameterOrReference, error) {
	errors := make([]error, 0)
	x := &NamedParameterOrReference{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// ParameterOrReference value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewParameterOrReference(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedPathItem creates an object of type NamedPathItem if possible, returning an error if not.
func NewNamedPathItem(in interface{}, context *compiler.Context) (*NamedPathItem, error) {
	errors := make([]error, 0)
	x := &NamedPathItem{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// PathItem value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewPathItem(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedRequestBodyOrReference creates an object of type NamedRequestBodyOrReference if possible, returning an error if not.
func NewNamedRequestBodyOrReference(in interface{}, context *compiler.Context) (*NamedRequestBodyOrReference, error) {
	errors := make([]error, 0)
	x := &NamedRequestBodyOrReference{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// RequestBodyOrReference value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewRequestBodyOrReference(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedResponseOrReference creates an object of type NamedResponseOrReference if possible, returning an error if not.
func NewNamedResponseOrReference(in interface{}, context *compiler.Context) (*NamedResponseOrReference, error) {
	errors := make([]error, 0)
	x := &NamedResponseOrReference{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// ResponseOrReference value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewResponseOrReference(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedSchemaOrReference creates an object of type NamedSchemaOrReference if possible, returning an error if not.
func NewNamedSchemaOrReference(in interface{}, context *compiler.Context) (*NamedSchemaOrReference, error) {
	errors := make([]error, 0)
	x := &NamedSchemaOrReference{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// SchemaOrReference value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewSchemaOrReference(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedSecuritySchemeOrReference creates an object of type NamedSecuritySchemeOrReference if possible, returning an error if not.
func NewNamedSecuritySchemeOrReference(in interface{}, context *compiler.Context) (*NamedSecuritySchemeOrReference, error) {
	errors := make([]error, 0)
	x := &NamedSecuritySchemeOrReference{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// SecuritySchemeOrReference value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewSecuritySchemeOrReference(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedServerVariable creates an object of type NamedServerVariable if possible, returning an error if not.
func NewNamedServerVariable(in interface{}, context *compiler.Context) (*NamedServerVariable, error) {
	errors := make([]error, 0)
	x := &NamedServerVariable{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// ServerVariable value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewServerVariable(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedString creates an object of type NamedString if possible, returning an error if not.
func NewNamedString(in interface{}, context *compiler.Context) (*NamedString, error) {
	errors := make([]error, 0)
	x := &NamedString{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			x.Value, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for value: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewOauthFlow creates an object of type OauthFlow if possible, returning an error if not.
func NewOauthFlow(in interface{}, context *compiler.Context) (*OauthFlow, error) {
	errors := make([]error, 0)
	x := &OauthFlow{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"authorizationUrl", "refreshUrl", "scopes", "tokenUrl"}
		allowedPatterns := []*regexp.Regexp{pattern1}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string authorization_url = 1;
		v1 := compiler.MapValueForKey(m, "authorizationUrl")
		if v1 != nil {
			x.AuthorizationUrl, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for authorizationUrl: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string token_url = 2;
		v2 := compiler.MapValueForKey(m, "tokenUrl")
		if v2 != nil {
			x.TokenUrl, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for tokenUrl: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string refresh_url = 3;
		v3 := compiler.MapValueForKey(m, "refreshUrl")
		if v3 != nil {
			x.RefreshUrl, ok = v3.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for refreshUrl: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Strings scopes = 4;
		v4 := compiler.MapValueForKey(m, "scopes")
		if v4 != nil {
			var err error
			x.Scopes, err = NewStrings(v4, compiler.NewContext("scopes", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated NamedAny specification_extension = 5;
		// MAP: Any ^x-
		x.SpecificationExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "x-") {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.SpecificationExtension = append(x.SpecificationExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewOauthFlows creates an object of type OauthFlows if possible, returning an error if not.
func NewOauthFlows(in interface{}, context *compiler.Context) (*OauthFlows, error) {
	errors := make([]error, 0)
	x := &OauthFlows{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"authorizationCode", "clientCredentials", "implicit", "password"}
		allowedPatterns := []*regexp.Regexp{pattern1}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// OauthFlow implicit = 1;
		v1 := compiler.MapValueForKey(m, "implicit")
		if v1 != nil {
			var err error
			x.Implicit, err = NewOauthFlow(v1, compiler.NewContext("implicit", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// OauthFlow password = 2;
		v2 := compiler.MapValueForKey(m, "password")
		if v2 != nil {
			var err error
			x.Password, err = NewOauthFlow(v2, compiler.NewContext("password", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// OauthFlow client_credentials = 3;
		v3 := compiler.MapValueForKey(m, "clientCredentials")
		if v3 != nil {
			var err error
			x.ClientCredentials, err = NewOauthFlow(v3, compiler.NewContext("clientCredentials", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// OauthFlow authorization_code = 4;
		v4 := compiler.MapValueForKey(m, "authorizationCode")
		if v4 != nil {
			var err error
			x.AuthorizationCode, err = NewOauthFlow(v4, compiler.NewContext("authorizationCode", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated NamedAny specification_extension = 5;
		// MAP: Any ^x-
		x.SpecificationExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "x-") {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.SpecificationExtension = append(x.SpecificationExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewObject creates an object of type Object if possible, returning an error if not.
func NewObject(in interface{}, context *compiler.Context) (*Object, error) {
	errors := make([]error, 0)
	x := &Object{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedAny additional_properties = 1;
		// MAP: Any
		x.AdditionalProperties = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedAny{}
				pair.Name = k
				result := &Any{}
				handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
				if handled {
					if err != nil {
						errors = append(errors, err)
					} else {
						bytes, _ := yaml.Marshal(v)
						result.Yaml = string(bytes)
						result.Value = resultFromExt
						pair.Value = result
					}
				} else {
					pair.Value, err = NewAny(v, compiler.NewContext(k, context))
					if err != nil {
						errors = append(errors, err)
					}
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewOperation creates an object of type Operation if possible, returning an error if not.
func NewOperation(in interface{}, context *compiler.Context) (*Operation, error) {
	errors := make([]error, 0)
	x := &Operation{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"responses"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"callbacks", "deprecated", "description", "externalDocs", "operationId", "parameters", "requestBody", "responses", "security", "servers", "summary", "tags"}
		allowedPatterns := []*regexp.Regexp{pattern1}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// repeated string tags = 1;
		v1 := compiler.MapValueForKey(m, "tags")
		if v1 != nil {
			v, ok := v1.([]interface{})
			if ok {
				x.Tags = compiler.ConvertInterfaceArrayToStringArray(v)
			} else {
				message := fmt.Sprintf("has unexpected value for tags: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string summary = 2;
		v2 := compiler.MapValueForKey(m, "summary")
		if v2 != nil {
			x.Summary, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for summary: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 3;
		v3 := compiler.MapValueForKey(m, "description")
		if v3 != nil {
			x.Description, ok = v3.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// ExternalDocs external_docs = 4;
		v4 := compiler.MapValueForKey(m, "externalDocs")
		if v4 != nil {
			var err error
			x.ExternalDocs, err = NewExternalDocs(v4, compiler.NewContext("externalDocs", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// string operation_id = 5;
		v5 := compiler.MapValueForKey(m, "operationId")
		if v5 != nil {
			x.OperationId, ok = v5.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for operationId: %+v (%T)", v5, v5)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated ParameterOrReference parameters = 6;
		v6 := compiler.MapValueForKey(m, "parameters")
		if v6 != nil {
			// repeated ParameterOrReference
			x.Parameters = make([]*ParameterOrReference, 0)
			a, ok := v6.([]interface{})
			if ok {
				for _, item := range a {
					y, err := NewParameterOrReference(item, compiler.NewContext("parameters", context))
					if err != nil {
						errors = append(errors, err)
					}
					x.Parameters = append(x.Parameters, y)
				}
			}
		}
		// RequestBodyOrReference request_body = 7;
		v7 := compiler.MapValueForKey(m, "requestBody")
		if v7 != nil {
			var err error
			x.RequestBody, err = NewRequestBodyOrReference(v7, compiler.NewContext("requestBody", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Responses responses = 8;
		v8 := compiler.MapValueForKey(m, "responses")
		if v8 != nil {
			var err error
			x.Responses, err = NewResponses(v8, compiler.NewContext("responses", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// CallbacksOrReferences callbacks = 9;
		v9 := compiler.MapValueForKey(m, "callbacks")
		if v9 != nil {
			var err error
			x.Callbacks, err = NewCallbacksOrReferences(v9, compiler.NewContext("callbacks", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// bool deprecated = 10;
		v10 := compiler.MapValueForKey(m, "deprecated")
		if v10 != nil {
			x.Deprecated, ok = v10.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for deprecated: %+v (%T)", v10, v10)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated SecurityRequirement security = 11;
		v11 := compiler.MapValueForKey(m, "security")
		if v11 != nil {
			// repeated SecurityRequirement
			x.Security = make([]*SecurityRequirement, 0)
			a, ok := v11.([]interface{})
			if ok {
				for _, item := range a {
					y, err := NewSecurityRequirement(item, compiler.NewContext("security", context))
					if err != nil {
						errors = append(errors, err)
					}
					x.Security = append(x.Security, y)
				}
			}
		}
		// repeated Server servers = 12;
		v12 := compiler.MapValueForKey(m, "servers")
		if v12 != nil {
			// repeated Server
			x.Servers = make([]*Server, 0)
			a, ok := v12.([]interface{})
			if ok {
				for _, item := range a {
					y, err := NewServer(item, compiler.NewContext("servers", context))
					if err != nil {
						errors = append(errors, err)
					}
					x.Servers = append(x.Servers, y)
				}
			}
		}
		// repeated NamedAny specification_extension = 13;
		// MAP: Any ^x-
		x.SpecificationExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "x-") {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.SpecificationExtension = append(x.SpecificationExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewParameter creates an object of type Parameter if possible, returning an error if not.
func NewParameter(in interface{}, context *compiler.Context) (*Parameter, error) {
	errors := make([]error, 0)
	x := &Parameter{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"in", "name"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"allowEmptyValue", "allowReserved", "content", "deprecated", "description", "example", "examples", "explode", "in", "name", "required", "schema", "style"}
		allowedPatterns := []*regexp.Regexp{pattern1}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string in = 2;
		v2 := compiler.MapValueForKey(m, "in")
		if v2 != nil {
			x.In, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for in: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 3;
		v3 := compiler.MapValueForKey(m, "description")
		if v3 != nil {
			x.Description, ok = v3.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool required = 4;
		v4 := compiler.MapValueForKey(m, "required")
		if v4 != nil {
			x.Required, ok = v4.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for required: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool deprecated = 5;
		v5 := compiler.MapValueForKey(m, "deprecated")
		if v5 != nil {
			x.Deprecated, ok = v5.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for deprecated: %+v (%T)", v5, v5)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool allow_empty_value = 6;
		v6 := compiler.MapValueForKey(m, "allowEmptyValue")
		if v6 != nil {
			x.AllowEmptyValue, ok = v6.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for allowEmptyValue: %+v (%T)", v6, v6)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string style = 7;
		v7 := compiler.MapValueForKey(m, "style")
		if v7 != nil {
			x.Style, ok = v7.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for style: %+v (%T)", v7, v7)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool explode = 8;
		v8 := compiler.MapValueForKey(m, "explode")
		if v8 != nil {
			x.Explode, ok = v8.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for explode: %+v (%T)", v8, v8)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool allow_reserved = 9;
		v9 := compiler.MapValueForKey(m, "allowReserved")
		if v9 != nil {
			x.AllowReserved, ok = v9.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for allowReserved: %+v (%T)", v9, v9)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// SchemaOrReference schema = 10;
		v10 := compiler.MapValueForKey(m, "schema")
		if v10 != nil {
			var err error
			x.Schema, err = NewSchemaOrReference(v10, compiler.NewContext("schema", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Any example = 11;
		v11 := compiler.MapValueForKey(m, "example")
		if v11 != nil {
			var err error
			x.Example, err = NewAny(v11, compiler.NewContext("example", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// ExamplesOrReferences examples = 12;
		v12 := compiler.MapValueForKey(m, "examples")
		if v12 != nil {
			var err error
			x.Examples, err = NewExamplesOrReferences(v12, compiler.NewContext("examples", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// MediaTypes content = 13;
		v13 := compiler.MapValueForKey(m, "content")
		if v13 != nil {
			var err error
			x.Content, err = NewMediaTypes(v13, compiler.NewContext("content", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated NamedAny specification_extension = 14;
		// MAP: Any ^x-
		x.SpecificationExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "x-") {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.SpecificationExtension = append(x.SpecificationExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewParameterOrReference creates an object of type ParameterOrReference if possible, returning an error if not.
func NewParameterOrReference(in interface{}, context *compiler.Context) (*ParameterOrReference, error) {
	errors := make([]error, 0)
	x := &ParameterOrReference{}
	matched := false
	// Parameter parameter = 1;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewParameter(m, compiler.NewContext("parameter", context))
			if matchingError == nil {
				x.Oneof = &ParameterOrReference_Parameter{Parameter: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	// Reference reference = 2;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewReference(m, compiler.NewContext("reference", context))
			if matchingError == nil {
				x.Oneof = &ParameterOrReference_Reference{Reference: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	if matched {
		// since the oneof matched one of its possibilities, discard any matching errors
		errors = make([]error, 0)
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewParametersOrReferences creates an object of type ParametersOrReferences if possible, returning an error if not.
func NewParametersOrReferences(in interface{}, context *compiler.Context) (*ParametersOrReferences, error) {
	errors := make([]error, 0)
	x := &ParametersOrReferences{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedParameterOrReference additional_properties = 1;
		// MAP: ParameterOrReference
		x.AdditionalProperties = make([]*NamedParameterOrReference, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedParameterOrReference{}
				pair.Name = k
				var err error
				pair.Value, err = NewParameterOrReference(v, compiler.NewContext(k, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewPathItem creates an object of type PathItem if possible, returning an error if not.
func NewPathItem(in interface{}, context *compiler.Context) (*PathItem, error) {
	errors := make([]error, 0)
	x := &PathItem{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"$ref", "delete", "description", "get", "head", "options", "parameters", "patch", "post", "put", "servers", "summary", "trace"}
		allowedPatterns := []*regexp.Regexp{pattern1}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string _ref = 1;
		v1 := compiler.MapValueForKey(m, "$ref")
		if v1 != nil {
			x.XRef, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for $ref: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string summary = 2;
		v2 := compiler.MapValueForKey(m, "summary")
		if v2 != nil {
			x.Summary, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for summary: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 3;
		v3 := compiler.MapValueForKey(m, "description")
		if v3 != nil {
			x.Description, ok = v3.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Operation get = 4;
		v4 := compiler.MapValueForKey(m, "get")
		if v4 != nil {
			var err error
			x.Get, err = NewOperation(v4, compiler.NewContext("get", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Operation put = 5;
		v5 := compiler.MapValueForKey(m, "put")
		if v5 != nil {
			var err error
			x.Put, err = NewOperation(v5, compiler.NewContext("put", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Operation post = 6;
		v6 := compiler.MapValueForKey(m, "post")
		if v6 != nil {
			var err error
			x.Post, err = NewOperation(v6, compiler.NewContext("post", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Operation delete = 7;
		v7 := compiler.MapValueForKey(m, "delete")
		if v7 != nil {
			var err error
			x.Delete, err = NewOperation(v7, compiler.NewContext("delete", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Operation options = 8;
		v8 := compiler.MapValueForKey(m, "options")
		if v8 != nil {
			var err error
			x.Options, err = NewOperation(v8, compiler.NewContext("options", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Operation head = 9;
		v9 := compiler.MapValueForKey(m, "head")
		if v9 != nil {
			var err error
			x.Head, err = NewOperation(v9, compiler.NewContext("head", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Operation patch = 10;
		v10 := compiler.MapValueForKey(m, "patch")
		if v10 != nil {
			var err error
			x.Patch, err = NewOperation(v10, compiler.NewContext("patch", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Operation trace = 11;
		v11 := compiler.MapValueForKey(m, "trace")
		if v11 != nil {
			var err error
			x.Trace, err = NewOperation(v11, compiler.NewContext("trace", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated Server servers = 12;
		v12 := compiler.MapValueForKey(m, "servers")
		if v12 != nil {
			// repeated Server
			x.Servers = make([]*Server, 0)
			a, ok := v12.([]interface{})
			if ok {
				for _, item := range a {
					y, err := NewServer(item, compiler.NewContext("servers", context))
					if err != nil {
						errors = append(errors, err)
					}
					x.Servers = append(x.Servers, y)
				}
			}
		}
		// repeated ParameterOrReference parameters = 13;
		v13 := compiler.MapValueForKey(m, "parameters")
		if v13 != nil {
			// repeated ParameterOrReference
			x.Parameters = make([]*ParameterOrReference, 0)
			a, ok := v13.([]interface{})
			if ok {
				for _, item := range a {
					y, err := NewParameterOrReference(item, compiler.NewContext("parameters", context))
					if err != nil {
						errors = append(errors, err)
					}
					x.Parameters = append(x.Parameters, y)
				}
			}
		}
		// repeated NamedAny specification_extension = 14;
		// MAP: Any ^x-
		x.SpecificationExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "x-") {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.SpecificationExtension = append(x.SpecificationExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewPaths creates an object of type Paths if possible, returning an error if not.
func NewPaths(in interface{}, context *compiler.Context) (*Paths, error) {
	errors := make([]error, 0)
	x := &Paths{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{}
		allowedPatterns := []*regexp.Regexp{pattern2, pattern1}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// repeated NamedPathItem path = 1;
		// MAP: PathItem ^/
		x.Path = make([]*NamedPathItem, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "/") {
					pair := &NamedPathItem{}
					pair.Name = k
					var err error
					pair.Value, err = NewPathItem(v, compiler.NewContext(k, context))
					if err != nil {
						errors = append(errors, err)
					}
					x.Path = append(x.Path, pair)
				}
			}
		}
		// repeated NamedAny specification_extension = 2;
		// MAP: Any ^x-
		x.SpecificationExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "x-") {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.SpecificationExtension = append(x.SpecificationExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewProperties creates an object of type Properties if possible, returning an error if not.
func NewProperties(in interface{}, context *compiler.Context) (*Properties, error) {
	errors := make([]error, 0)
	x := &Properties{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedSchemaOrReference additional_properties = 1;
		// MAP: SchemaOrReference
		x.AdditionalProperties = make([]*NamedSchemaOrReference, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedSchemaOrReference{}
				pair.Name = k
				var err error
				pair.Value, err = NewSchemaOrReference(v, compiler.NewContext(k, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewReference creates an object of type Reference if possible, returning an error if not.
func NewReference(in interface{}, context *compiler.Context) (*Reference, error) {
	errors := make([]error, 0)
	x := &Reference{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"$ref"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"$ref"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string _ref = 1;
		v1 := compiler.MapValueForKey(m, "$ref")
		if v1 != nil {
			x.XRef, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for $ref: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewRequestBodiesOrReferences creates an object of type RequestBodiesOrReferences if possible, returning an error if not.
func NewRequestBodiesOrReferences(in interface{}, context *compiler.Context) (*RequestBodiesOrReferences, error) {
	errors := make([]error, 0)
	x := &RequestBodiesOrReferences{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedRequestBodyOrReference additional_properties = 1;
		// MAP: RequestBodyOrReference
		x.AdditionalProperties = make([]*NamedRequestBodyOrReference, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedRequestBodyOrReference{}
				pair.Name = k
				var err error
				pair.Value, err = NewRequestBodyOrReference(v, compiler.NewContext(k, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewRequestBody creates an object of type RequestBody if possible, returning an error if not.
func NewRequestBody(in interface{}, context *compiler.Context) (*RequestBody, error) {
	errors := make([]error, 0)
	x := &RequestBody{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"content"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"content", "description", "required"}
		allowedPatterns := []*regexp.Regexp{pattern1}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string description = 1;
		v1 := compiler.MapValueForKey(m, "description")
		if v1 != nil {
			x.Description, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// MediaTypes content = 2;
		v2 := compiler.MapValueForKey(m, "content")
		if v2 != nil {
			var err error
			x.Content, err = NewMediaTypes(v2, compiler.NewContext("content", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// bool required = 3;
		v3 := compiler.MapValueForKey(m, "required")
		if v3 != nil {
			x.Required, ok = v3.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for required: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated NamedAny specification_extension = 4;
		// MAP: Any ^x-
		x.SpecificationExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "x-") {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.SpecificationExtension = append(x.SpecificationExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewRequestBodyOrReference creates an object of type RequestBodyOrReference if possible, returning an error if not.
func NewRequestBodyOrReference(in interface{}, context *compiler.Context) (*RequestBodyOrReference, error) {
	errors := make([]error, 0)
	x := &RequestBodyOrReference{}
	matched := false
	// RequestBody request_body = 1;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewRequestBody(m, compiler.NewContext("requestBody", context))
			if matchingError == nil {
				x.Oneof = &RequestBodyOrReference_RequestBody{RequestBody: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	// Reference reference = 2;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewReference(m, compiler.NewContext("reference", context))
			if matchingError == nil {
				x.Oneof = &RequestBodyOrReference_Reference{Reference: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	if matched {
		// since the oneof matched one of its possibilities, discard any matching errors
		errors = make([]error, 0)
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewResponse creates an object of type Response if possible, returning an error if not.
func NewResponse(in interface{}, context *compiler.Context) (*Response, error) {
	errors := make([]error, 0)
	x := &Response{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"description"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"content", "description", "headers", "links"}
		allowedPatterns := []*regexp.Regexp{pattern1}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string description = 1;
		v1 := compiler.MapValueForKey(m, "description")
		if v1 != nil {
			x.Description, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// HeadersOrReferences headers = 2;
		v2 := compiler.MapValueForKey(m, "headers")
		if v2 != nil {
			var err error
			x.Headers, err = NewHeadersOrReferences(v2, compiler.NewContext("headers", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// MediaTypes content = 3;
		v3 := compiler.MapValueForKey(m, "content")
		if v3 != nil {
			var err error
			x.Content, err = NewMediaTypes(v3, compiler.NewContext("content", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// LinksOrReferences links = 4;
		v4 := compiler.MapValueForKey(m, "links")
		if v4 != nil {
			var err error
			x.Links, err = NewLinksOrReferences(v4, compiler.NewContext("links", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated NamedAny specification_extension = 5;
		// MAP: Any ^x-
		x.SpecificationExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "x-") {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.SpecificationExtension = append(x.SpecificationExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewResponseOrReference creates an object of type ResponseOrReference if possible, returning an error if not.
func NewResponseOrReference(in interface{}, context *compiler.Context) (*ResponseOrReference, error) {
	errors := make([]error, 0)
	x := &ResponseOrReference{}
	matched := false
	// Response response = 1;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewResponse(m, compiler.NewContext("response", context))
			if matchingError == nil {
				x.Oneof = &ResponseOrReference_Response{Response: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	// Reference reference = 2;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewReference(m, compiler.NewContext("reference", context))
			if matchingError == nil {
				x.Oneof = &ResponseOrReference_Reference{Reference: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	if matched {
		// since the oneof matched one of its possibilities, discard any matching errors
		errors = make([]error, 0)
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewResponses creates an object of type Responses if possible, returning an error if not.
func NewResponses(in interface{}, context *compiler.Context) (*Responses, error) {
	errors := make([]error, 0)
	x := &Responses{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"default"}
		allowedPatterns := []*regexp.Regexp{pattern3, pattern1}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// ResponseOrReference default = 1;
		v1 := compiler.MapValueForKey(m, "default")
		if v1 != nil {
			var err error
			x.Default, err = NewResponseOrReference(v1, compiler.NewContext("default", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated NamedResponseOrReference response_or_reference = 2;
		// MAP: ResponseOrReference ^([0-9X]{3})$
		x.ResponseOrReference = make([]*NamedResponseOrReference, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if pattern3.MatchString(k) {
					pair := &NamedResponseOrReference{}
					pair.Name = k
					var err error
					pair.Value, err = NewResponseOrReference(v, compiler.NewContext(k, context))
					if err != nil {
						errors = append(errors, err)
					}
					x.ResponseOrReference = append(x.ResponseOrReference, pair)
				}
			}
		}
		// repeated NamedAny specification_extension = 3;
		// MAP: Any ^x-
		x.SpecificationExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "x-") {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.SpecificationExtension = append(x.SpecificationExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewResponsesOrReferences creates an object of type ResponsesOrReferences if possible, returning an error if not.
func NewResponsesOrReferences(in interface{}, context *compiler.Context) (*ResponsesOrReferences, error) {
	errors := make([]error, 0)
	x := &ResponsesOrReferences{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedResponseOrReference additional_properties = 1;
		// MAP: ResponseOrReference
		x.AdditionalProperties = make([]*NamedResponseOrReference, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedResponseOrReference{}
				pair.Name = k
				var err error
				pair.Value, err = NewResponseOrReference(v, compiler.NewContext(k, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewSchema creates an object of type Schema if possible, returning an error if not.
func NewSchema(in interface{}, context *compiler.Context) (*Schema, error) {
	errors := make([]error, 0)
	x := &Schema{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"additionalProperties", "allOf", "anyOf", "default", "deprecated", "description", "discriminator", "enum", "example", "exclusiveMaximum", "exclusiveMinimum", "externalDocs", "format", "items", "maxItems", "maxLength", "maxProperties", "maximum", "minItems", "minLength", "minProperties", "minimum", "multipleOf", "not", "nullable", "oneOf", "pattern", "properties", "readOnly", "required", "title", "type", "uniqueItems", "writeOnly", "xml"}
		allowedPatterns := []*regexp.Regexp{pattern1}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// bool nullable = 1;
		v1 := compiler.MapValueForKey(m, "nullable")
		if v1 != nil {
			x.Nullable, ok = v1.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for nullable: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Discriminator discriminator = 2;
		v2 := compiler.MapValueForKey(m, "discriminator")
		if v2 != nil {
			var err error
			x.Discriminator, err = NewDiscriminator(v2, compiler.NewContext("discriminator", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// bool read_only = 3;
		v3 := compiler.MapValueForKey(m, "readOnly")
		if v3 != nil {
			x.ReadOnly, ok = v3.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for readOnly: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool write_only = 4;
		v4 := compiler.MapValueForKey(m, "writeOnly")
		if v4 != nil {
			x.WriteOnly, ok = v4.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for writeOnly: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Xml xml = 5;
		v5 := compiler.MapValueForKey(m, "xml")
		if v5 != nil {
			var err error
			x.Xml, err = NewXml(v5, compiler.NewContext("xml", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// ExternalDocs external_docs = 6;
		v6 := compiler.MapValueForKey(m, "externalDocs")
		if v6 != nil {
			var err error
			x.ExternalDocs, err = NewExternalDocs(v6, compiler.NewContext("externalDocs", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Any example = 7;
		v7 := compiler.MapValueForKey(m, "example")
		if v7 != nil {
			var err error
			x.Example, err = NewAny(v7, compiler.NewContext("example", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// bool deprecated = 8;
		v8 := compiler.MapValueForKey(m, "deprecated")
		if v8 != nil {
			x.Deprecated, ok = v8.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for deprecated: %+v (%T)", v8, v8)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string title = 9;
		v9 := compiler.MapValueForKey(m, "title")
		if v9 != nil {
			x.Title, ok = v9.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for title: %+v (%T)", v9, v9)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// float multiple_of = 10;
		v10 := compiler.MapValueForKey(m, "multipleOf")
		if v10 != nil {
			switch v10 := v10.(type) {
			case float64:
				x.MultipleOf = v10
			case float32:
				x.MultipleOf = float64(v10)
			case uint64:
				x.MultipleOf = float64(v10)
			case uint32:
				x.MultipleOf = float64(v10)
			case int64:
				x.MultipleOf = float64(v10)
			case int32:
				x.MultipleOf = float64(v10)
			case int:
				x.MultipleOf = float64(v10)
			default:
				message := fmt.Sprintf("has unexpected value for multipleOf: %+v (%T)", v10, v10)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// float maximum = 11;
		v11 := compiler.MapValueForKey(m, "maximum")
		if v11 != nil {
			switch v11 := v11.(type) {
			case float64:
				x.Maximum = v11
			case float32:
				x.Maximum = float64(v11)
			case uint64:
				x.Maximum = float64(v11)
			case uint32:
				x.Maximum = float64(v11)
			case int64:
				x.Maximum = float64(v11)
			case int32:
				x.Maximum = float64(v11)
			case int:
				x.Maximum = float64(v11)
			default:
				message := fmt.Sprintf("has unexpected value for maximum: %+v (%T)", v11, v11)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool exclusive_maximum = 12;
		v12 := compiler.MapValueForKey(m, "exclusiveMaximum")
		if v12 != nil {
			x.ExclusiveMaximum, ok = v12.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for exclusiveMaximum: %+v (%T)", v12, v12)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// float minimum = 13;
		v13 := compiler.MapValueForKey(m, "minimum")
		if v13 != nil {
			switch v13 := v13.(type) {
			case float64:
				x.Minimum = v13
			case float32:
				x.Minimum = float64(v13)
			case uint64:
				x.Minimum = float64(v13)
			case uint32:
				x.Minimum = float64(v13)
			case int64:
				x.Minimum = float64(v13)
			case int32:
				x.Minimum = float64(v13)
			case int:
				x.Minimum = float64(v13)
			default:
				message := fmt.Sprintf("has unexpected value for minimum: %+v (%T)", v13, v13)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool exclusive_minimum = 14;
		v14 := compiler.MapValueForKey(m, "exclusiveMinimum")
		if v14 != nil {
			x.ExclusiveMinimum, ok = v14.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for exclusiveMinimum: %+v (%T)", v14, v14)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 max_length = 15;
		v15 := compiler.MapValueForKey(m, "maxLength")
		if v15 != nil {
			t, ok := v15.(int)
			if ok {
				x.MaxLength = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for maxLength: %+v (%T)", v15, v15)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 min_length = 16;
		v16 := compiler.MapValueForKey(m, "minLength")
		if v16 != nil {
			t, ok := v16.(int)
			if ok {
				x.MinLength = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for minLength: %+v (%T)", v16, v16)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string pattern = 17;
		v17 := compiler.MapValueForKey(m, "pattern")
		if v17 != nil {
			x.Pattern, ok = v17.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for pattern: %+v (%T)", v17, v17)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 max_items = 18;
		v18 := compiler.MapValueForKey(m, "maxItems")
		if v18 != nil {
			t, ok := v18.(int)
			if ok {
				x.MaxItems = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for maxItems: %+v (%T)", v18, v18)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 min_items = 19;
		v19 := compiler.MapValueForKey(m, "minItems")
		if v19 != nil {
			t, ok := v19.(int)
			if ok {
				x.MinItems = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for minItems: %+v (%T)", v19, v19)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool unique_items = 20;
		v20 := compiler.MapValueForKey(m, "uniqueItems")
		if v20 != nil {
			x.UniqueItems, ok = v20.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for uniqueItems: %+v (%T)", v20, v20)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 max_properties = 21;
		v21 := compiler.MapValueForKey(m, "maxProperties")
		if v21 != nil {
			t, ok := v21.(int)
			if ok {
				x.MaxProperties = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for maxProperties: %+v (%T)", v21, v21)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 min_properties = 22;
		v22 := compiler.MapValueForKey(m, "minProperties")
		if v22 != nil {
			t, ok := v22.(int)
			if ok {
				x.MinProperties = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for minProperties: %+v (%T)", v22, v22)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated string required = 23;
		v23 := compiler.MapValueForKey(m, "required")
		if v23 != nil {
			v, ok := v23.([]interface{})
			if ok {
				x.Required = compiler.ConvertInterfaceArrayToStringArray(v)
			} else {
				message := fmt.Sprintf("has unexpected value for required: %+v (%T)", v23, v23)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated Any enum = 24;
		v24 := compiler.MapValueForKey(m, "enum")
		if v24 != nil {
			// repeated Any
			x.Enum = make([]*Any, 0)
			a, ok := v24.([]interface{})
			if ok {
				for _, item := range a {
					y, err := NewAny(item, compiler.NewContext("enum", context))
					if err != nil {
						errors = append(errors, err)
					}
					x.Enum = append(x.Enum, y)
				}
			}
		}
		// string type = 25;
		v25 := compiler.MapValueForKey(m, "type")
		if v25 != nil {
			x.Type, ok = v25.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v25, v25)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated SchemaOrReference all_of = 26;
		v26 := compiler.MapValueForKey(m, "allOf")
		if v26 != nil {
			// repeated SchemaOrReference
			x.AllOf = make([]*SchemaOrReference, 0)
			a, ok := v26.([]interface{})
			if ok {
				for _, item := range a {
					y, err := NewSchemaOrReference(item, compiler.NewContext("allOf", context))
					if err != nil {
						errors = append(errors, err)
					}
					x.AllOf = append(x.AllOf, y)
				}
			}
		}
		// repeated SchemaOrReference one_of = 27;
		v27 := compiler.MapValueForKey(m, "oneOf")
		if v27 != nil {
			// repeated SchemaOrReference
			x.OneOf = make([]*SchemaOrReference, 0)
			a, ok := v27.([]interface{})
			if ok {
				for _, item := range a {
					y, err := NewSchemaOrReference(item, compiler.NewContext("oneOf", context))
					if err != nil {
						errors = append(errors, err)
					}
					x.OneOf = append(x.OneOf, y)
				}
			}
		}
		// repeated SchemaOrReference any_of = 28;
		v28 := compiler.MapValueForKey(m, "anyOf")
		if v28 != nil {
			// repeated SchemaOrReference
			x.AnyOf = make([]*SchemaOrReference, 0)
			a, ok := v28.([]interface{})
			if ok {
				for _, item := range a {
					y, err := NewSchemaOrReference(item, compiler.NewContext("anyOf", context))
					if err != nil {
						errors = append(errors, err)
					}
					x.AnyOf = append(x.AnyOf, y)
				}
			}
		}
		// Schema not = 29;
		v29 := compiler.MapValueForKey(m, "not")
		if v29 != nil {
			var err error
			x.Not, err = NewSchema(v29, compiler.NewContext("not", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// ItemsItem items = 30;
		v30 := compiler.MapValueForKey(m, "items")
		if v30 != nil {
			var err error
			x.Items, err = NewItemsItem(v30, compiler.NewContext("items", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Properties properties = 31;
		v31 := compiler.MapValueForKey(m, "properties")
		if v31 != nil {
			var err error
			x.Properties, err = NewProperties(v31, compiler.NewContext("properties", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// AdditionalPropertiesItem additional_properties = 32;
		v32 := compiler.MapValueForKey(m, "additionalProperties")
		if v32 != nil {
			var err error
			x.AdditionalProperties, err = NewAdditionalPropertiesItem(v32, compiler.NewContext("additionalProperties", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// DefaultType default = 33;
		v33 := compiler.MapValueForKey(m, "default")
		if v33 != nil {
			var err error
			x.Default, err = NewDefaultType(v33, compiler.NewContext("default", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// string description = 34;
		v34 := compiler.MapValueForKey(m, "description")
		if v34 != nil {
			x.Description, ok = v34.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v34, v34)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string format = 35;
		v35 := compiler.MapValueForKey(m, "format")
		if v35 != nil {
			x.Format, ok = v35.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for format: %+v (%T)", v35, v35)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated NamedAny specification_extension = 36;
		// MAP: Any ^x-
		x.SpecificationExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "x-") {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.SpecificationExtension = append(x.SpecificationExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewSchemaOrReference creates an object of type SchemaOrReference if possible, returning an error if not.
func NewSchemaOrReference(in interface{}, context *compiler.Context) (*SchemaOrReference, error) {
	errors := make([]error, 0)
	x := &SchemaOrReference{}
	matched := false
	// Schema schema = 1;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewSchema(m, compiler.NewContext("schema", context))
			if matchingError == nil {
				x.Oneof = &SchemaOrReference_Schema{Schema: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	// Reference reference = 2;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewReference(m, compiler.NewContext("reference", context))
			if matchingError == nil {
				x.Oneof = &SchemaOrReference_Reference{Reference: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	if matched {
		// since the oneof matched one of its possibilities, discard any matching errors
		errors = make([]error, 0)
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewSchemasOrReferences creates an object of type SchemasOrReferences if possible, returning an error if not.
func NewSchemasOrReferences(in interface{}, context *compiler.Context) (*SchemasOrReferences, error) {
	errors := make([]error, 0)
	x := &SchemasOrReferences{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedSchemaOrReference additional_properties = 1;
		// MAP: SchemaOrReference
		x.AdditionalProperties = make([]*NamedSchemaOrReference, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedSchemaOrReference{}
				pair.Name = k
				var err error
				pair.Value, err = NewSchemaOrReference(v, compiler.NewContext(k, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewSecurityRequirement creates an object of type SecurityRequirement if possible, returning an error if not.
func NewSecurityRequirement(in interface{}, context *compiler.Context) (*SecurityRequirement, error) {
	errors := make([]error, 0)
	x := &SecurityRequirement{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{}
		allowedPatterns := []*regexp.Regexp{pattern4}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewSecurityScheme creates an object of type SecurityScheme if possible, returning an error if not.
func NewSecurityScheme(in interface{}, context *compiler.Context) (*SecurityScheme, error) {
	errors := make([]error, 0)
	x := &SecurityScheme{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"type"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"bearerFormat", "description", "flows", "in", "name", "openIdConnectUrl", "scheme", "type"}
		allowedPatterns := []*regexp.Regexp{pattern1}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string type = 1;
		v1 := compiler.MapValueForKey(m, "type")
		if v1 != nil {
			x.Type, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 2;
		v2 := compiler.MapValueForKey(m, "description")
		if v2 != nil {
			x.Description, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string name = 3;
		v3 := compiler.MapValueForKey(m, "name")
		if v3 != nil {
			x.Name, ok = v3.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string in = 4;
		v4 := compiler.MapValueForKey(m, "in")
		if v4 != nil {
			x.In, ok = v4.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for in: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string scheme = 5;
		v5 := compiler.MapValueForKey(m, "scheme")
		if v5 != nil {
			x.Scheme, ok = v5.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for scheme: %+v (%T)", v5, v5)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string bearer_format = 6;
		v6 := compiler.MapValueForKey(m, "bearerFormat")
		if v6 != nil {
			x.BearerFormat, ok = v6.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for bearerFormat: %+v (%T)", v6, v6)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// OauthFlows flows = 7;
		v7 := compiler.MapValueForKey(m, "flows")
		if v7 != nil {
			var err error
			x.Flows, err = NewOauthFlows(v7, compiler.NewContext("flows", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// string open_id_connect_url = 8;
		v8 := compiler.MapValueForKey(m, "openIdConnectUrl")
		if v8 != nil {
			x.OpenIdConnectUrl, ok = v8.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for openIdConnectUrl: %+v (%T)", v8, v8)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated NamedAny specification_extension = 9;
		// MAP: Any ^x-
		x.SpecificationExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "x-") {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.SpecificationExtension = append(x.SpecificationExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewSecuritySchemeOrReference creates an object of type SecuritySchemeOrReference if possible, returning an error if not.
func NewSecuritySchemeOrReference(in interface{}, context *compiler.Context) (*SecuritySchemeOrReference, error) {
	errors := make([]error, 0)
	x := &SecuritySchemeOrReference{}
	matched := false
	// SecurityScheme security_scheme = 1;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewSecurityScheme(m, compiler.NewContext("securityScheme", context))
			if matchingError == nil {
				x.Oneof = &SecuritySchemeOrReference_SecurityScheme{SecurityScheme: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	// Reference reference = 2;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewReference(m, compiler.NewContext("reference", context))
			if matchingError == nil {
				x.Oneof = &SecuritySchemeOrReference_Reference{Reference: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	if matched {
		// since the oneof matched one of its possibilities, discard any matching errors
		errors = make([]error, 0)
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewSecuritySchemesOrReferences creates an object of type SecuritySchemesOrReferences if possible, returning an error if not.
func NewSecuritySchemesOrReferences(in interface{}, context *compiler.Context) (*SecuritySchemesOrReferences, error) {
	errors := make([]error, 0)
	x := &SecuritySchemesOrReferences{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedSecuritySchemeOrReference additional_properties = 1;
		// MAP: SecuritySchemeOrReference
		x.AdditionalProperties = make([]*NamedSecuritySchemeOrReference, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedSecuritySchemeOrReference{}
				pair.Name = k
				var err error
				pair.Value, err = NewSecuritySchemeOrReference(v, compiler.NewContext(k, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewServer creates an object of type Server if possible, returning an error if not.
func NewServer(in interface{}, context *compiler.Context) (*Server, error) {
	errors := make([]error, 0)
	x := &Server{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"url"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"description", "url", "variables"}
		allowedPatterns := []*regexp.Regexp{pattern1}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string url = 1;
		v1 := compiler.MapValueForKey(m, "url")
		if v1 != nil {
			x.Url, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for url: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 2;
		v2 := compiler.MapValueForKey(m, "description")
		if v2 != nil {
			x.Description, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// ServerVariables variables = 3;
		v3 := compiler.MapValueForKey(m, "variables")
		if v3 != nil {
			var err error
			x.Variables, err = NewServerVariables(v3, compiler.NewContext("variables", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated NamedAny specification_extension = 4;
		// MAP: Any ^x-
		x.SpecificationExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "x-") {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.SpecificationExtension = append(x.SpecificationExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewServerVariable creates an object of type ServerVariable if possible, returning an error if not.
func NewServerVariable(in interface{}, context *compiler.Context) (*ServerVariable, error) {
	errors := make([]error, 0)
	x := &ServerVariable{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"default"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"default", "description", "enum"}
		allowedPatterns := []*regexp.Regexp{pattern1}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// repeated string enum = 1;
		v1 := compiler.MapValueForKey(m, "enum")
		if v1 != nil {
			v, ok := v1.([]interface{})
			if ok {
				x.Enum = compiler.ConvertInterfaceArrayToStringArray(v)
			} else {
				message := fmt.Sprintf("has unexpected value for enum: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string default = 2;
		v2 := compiler.MapValueForKey(m, "default")
		if v2 != nil {
			x.Default, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for default: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 3;
		v3 := compiler.MapValueForKey(m, "description")
		if v3 != nil {
			x.Description, ok = v3.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated NamedAny specification_extension = 4;
		// MAP: Any ^x-
		x.SpecificationExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "x-") {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.SpecificationExtension = append(x.SpecificationExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewServerVariables creates an object of type ServerVariables if possible, returning an error if not.
func NewServerVariables(in interface{}, context *compiler.Context) (*ServerVariables, error) {
	errors := make([]error, 0)
	x := &ServerVariables{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedServerVariable additional_properties = 1;
		// MAP: ServerVariable
		x.AdditionalProperties = make([]*NamedServerVariable, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedServerVariable{}
				pair.Name = k
				var err error
				pair.Value, err = NewServerVariable(v, compiler.NewContext(k, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewSpecificationExtension creates an object of type SpecificationExtension if possible, returning an error if not.
func NewSpecificationExtension(in interface{}, context *compiler.Context) (*SpecificationExtension, error) {
	errors := make([]error, 0)
	x := &SpecificationExtension{}
	matched := false
	switch in := in.(type) {
	case bool:
		x.Oneof = &SpecificationExtension_Boolean{Boolean: in}
		matched = true
	case string:
		x.Oneof = &SpecificationExtension_String_{String_: in}
		matched = true
	case int64:
		x.Oneof = &SpecificationExtension_Number{Number: float64(in)}
		matched = true
	case int32:
		x.Oneof = &SpecificationExtension_Number{Number: float64(in)}
		matched = true
	case int:
		x.Oneof = &SpecificationExtension_Number{Number: float64(in)}
		matched = true
	case float64:
		x.Oneof = &SpecificationExtension_Number{Number: in}
		matched = true
	case float32:
		x.Oneof = &SpecificationExtension_Number{Number: float64(in)}
		matched = true
	}
	if matched {
		// since the oneof matched one of its possibilities, discard any matching errors
		errors = make([]error, 0)
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewStringArray creates an object of type StringArray if possible, returning an error if not.
func NewStringArray(in interface{}, context *compiler.Context) (*StringArray, error) {
	errors := make([]error, 0)
	x := &StringArray{}
	a, ok := in.([]interface{})
	if !ok {
		message := fmt.Sprintf("has unexpected value for StringArray: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		x.Value = make([]string, 0)
		for _, s := range a {
			x.Value = append(x.Value, s.(string))
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewStrings creates an object of type Strings if possible, returning an error if not.
func NewStrings(in interface{}, context *compiler.Context) (*Strings, error) {
	errors := make([]error, 0)
	x := &Strings{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedString additional_properties = 1;
		// MAP: string
		x.AdditionalProperties = make([]*NamedString, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedString{}
				pair.Name = k
				pair.Value = v.(string)
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewTag creates an object of type Tag if possible, returning an error if not.
func NewTag(in interface{}, context *compiler.Context) (*Tag, error) {
	errors := make([]error, 0)
	x := &Tag{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"name"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"description", "externalDocs", "name"}
		allowedPatterns := []*regexp.Regexp{pattern1}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 2;
		v2 := compiler.MapValueForKey(m, "description")
		if v2 != nil {
			x.Description, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// ExternalDocs external_docs = 3;
		v3 := compiler.MapValueForKey(m, "externalDocs")
		if v3 != nil {
			var err error
			x.ExternalDocs, err = NewExternalDocs(v3, compiler.NewContext("externalDocs", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated NamedAny specification_extension = 4;
		// MAP: Any ^x-
		x.SpecificationExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "x-") {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.SpecificationExtension = append(x.SpecificationExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewXml creates an object of type Xml if possible, returning an error if not.
func NewXml(in interface{}, context *compiler.Context) (*Xml, error) {
	errors := make([]error, 0)
	x := &Xml{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"attribute", "name", "namespace", "prefix", "wrapped"}
		allowedPatterns := []*regexp.Regexp{pattern1}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string namespace = 2;
		v2 := compiler.MapValueForKey(m, "namespace")
		if v2 != nil {
			x.Namespace, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for namespace: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string prefix = 3;
		v3 := compiler.MapValueForKey(m, "prefix")
		if v3 != nil {
			x.Prefix, ok = v3.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for prefix: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool attribute = 4;
		v4 := compiler.MapValueForKey(m, "attribute")
		if v4 != nil {
			x.Attribute, ok = v4.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for attribute: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool wrapped = 5;
		v5 := compiler.MapValueForKey(m, "wrapped")
		if v5 != nil {
			x.Wrapped, ok = v5.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for wrapped: %+v (%T)", v5, v5)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated NamedAny specification_extension = 6;
		// MAP: Any ^x-
		x.SpecificationExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if strings.HasPrefix(k, "x-") {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.SpecificationExtension = append(x.SpecificationExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside AdditionalPropertiesItem objects.
func (m *AdditionalPropertiesItem) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	{
		p, ok := m.Oneof.(*AdditionalPropertiesItem_SchemaOrReference)
		if ok {
			_, err := p.SchemaOrReference.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Any objects.
func (m *Any) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside AnyOrExpression objects.
func (m *AnyOrExpression) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	{
		p, ok := m.Oneof.(*AnyOrExpression_Any)
		if ok {
			_, err := p.Any.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	{
		p, ok := m.Oneof.(*AnyOrExpression_Expression)
		if ok {
			_, err := p.Expression.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside AnysOrExpressions objects.
func (m *AnysOrExpressions) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Callback objects.
func (m *Callback) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.Path {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	for _, item := range m.SpecificationExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside CallbackOrReference objects.
func (m *CallbackOrReference) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	{
		p, ok := m.Oneof.(*CallbackOrReference_Callback)
		if ok {
			_, err := p.Callback.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	{
		p, ok := m.Oneof.(*CallbackOrReference_Reference)
		if ok {
			_, err := p.Reference.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside CallbacksOrReferences objects.
func (m *CallbacksOrReferences) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Components objects.
func (m *Components) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Schemas != nil {
		_, err := m.Schemas.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Responses != nil {
		_, err := m.Responses.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Parameters != nil {
		_, err := m.Parameters.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Examples != nil {
		_, err := m.Examples.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.RequestBodies != nil {
		_, err := m.RequestBodies.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Headers != nil {
		_, err := m.Headers.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.SecuritySchemes != nil {
		_, err := m.SecuritySchemes.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Links != nil {
		_, err := m.Links.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Callbacks != nil {
		_, err := m.Callbacks.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.SpecificationExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Contact objects.
func (m *Contact) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.SpecificationExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside DefaultType objects.
func (m *DefaultType) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Discriminator objects.
func (m *Discriminator) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Mapping != nil {
		_, err := m.Mapping.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Document objects.
func (m *Document) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Info != nil {
		_, err := m.Info.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.Servers {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	if m.Paths != nil {
		_, err := m.Paths.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Components != nil {
		_, err := m.Components.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.Security {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	for _, item := range m.Tags {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	if m.ExternalDocs != nil {
		_, err := m.ExternalDocs.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.SpecificationExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Encoding objects.
func (m *Encoding) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Headers != nil {
		_, err := m.Headers.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.SpecificationExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Encodings objects.
func (m *Encodings) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Example objects.
func (m *Example) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.SpecificationExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside ExampleOrReference objects.
func (m *ExampleOrReference) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	{
		p, ok := m.Oneof.(*ExampleOrReference_Example)
		if ok {
			_, err := p.Example.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	{
		p, ok := m.Oneof.(*ExampleOrReference_Reference)
		if ok {
			_, err := p.Reference.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Examples objects.
func (m *Examples) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside ExamplesOrReferences objects.
func (m *ExamplesOrReferences) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Expression objects.
func (m *Expression) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside ExternalDocs objects.
func (m *ExternalDocs) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.SpecificationExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Header objects.
func (m *Header) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Schema != nil {
		_, err := m.Schema.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Example != nil {
		_, err := m.Example.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Examples != nil {
		_, err := m.Examples.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Content != nil {
		_, err := m.Content.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.SpecificationExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside HeaderOrReference objects.
func (m *HeaderOrReference) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	{
		p, ok := m.Oneof.(*HeaderOrReference_Header)
		if ok {
			_, err := p.Header.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	{
		p, ok := m.Oneof.(*HeaderOrReference_Reference)
		if ok {
			_, err := p.Reference.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside HeadersOrReferences objects.
func (m *HeadersOrReferences) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Info objects.
func (m *Info) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Contact != nil {
		_, err := m.Contact.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.License != nil {
		_, err := m.License.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.SpecificationExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside ItemsItem objects.
func (m *ItemsItem) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.SchemaOrReference {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside License objects.
func (m *License) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.SpecificationExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Link objects.
func (m *Link) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Parameters != nil {
		_, err := m.Parameters.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.RequestBody != nil {
		_, err := m.RequestBody.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Server != nil {
		_, err := m.Server.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.SpecificationExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside LinkOrReference objects.
func (m *LinkOrReference) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	{
		p, ok := m.Oneof.(*LinkOrReference_Link)
		if ok {
			_, err := p.Link.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	{
		p, ok := m.Oneof.(*LinkOrReference_Reference)
		if ok {
			_, err := p.Reference.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside LinksOrReferences objects.
func (m *LinksOrReferences) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside MediaType objects.
func (m *MediaType) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Schema != nil {
		_, err := m.Schema.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Example != nil {
		_, err := m.Example.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Examples != nil {
		_, err := m.Examples.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Encoding != nil {
		_, err := m.Encoding.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.SpecificationExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside MediaTypes objects.
func (m *MediaTypes) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedAny objects.
func (m *NamedAny) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedAnyOrExpression objects.
func (m *NamedAnyOrExpression) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedCallbackOrReference objects.
func (m *NamedCallbackOrReference) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedEncoding objects.
func (m *NamedEncoding) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedExampleOrReference objects.
func (m *NamedExampleOrReference) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedHeaderOrReference objects.
func (m *NamedHeaderOrReference) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedLinkOrReference objects.
func (m *NamedLinkOrReference) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedMediaType objects.
func (m *NamedMediaType) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedParameterOrReference objects.
func (m *NamedParameterOrReference) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedPathItem objects.
func (m *NamedPathItem) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedRequestBodyOrReference objects.
func (m *NamedRequestBodyOrReference) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedResponseOrReference objects.
func (m *NamedResponseOrReference) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedSchemaOrReference objects.
func (m *NamedSchemaOrReference) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedSecuritySchemeOrReference objects.
func (m *NamedSecuritySchemeOrReference) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedServerVariable objects.
func (m *NamedServerVariable) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedString objects.
func (m *NamedString) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside OauthFlow objects.
func (m *OauthFlow) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Scopes != nil {
		_, err := m.Scopes.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.SpecificationExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside OauthFlows objects.
func (m *OauthFlows) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Implicit != nil {
		_, err := m.Implicit.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Password != nil {
		_, err := m.Password.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.ClientCredentials != nil {
		_, err := m.ClientCredentials.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.AuthorizationCode != nil {
		_, err := m.AuthorizationCode.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.SpecificationExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Object objects.
func (m *Object) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Operation objects.
func (m *Operation) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.ExternalDocs != nil {
		_, err := m.ExternalDocs.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.Parameters {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	if m.RequestBody != nil {
		_, err := m.RequestBody.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Responses != nil {
		_, err := m.Responses.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Callbacks != nil {
		_, err := m.Callbacks.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.Security {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	for _, item := range m.Servers {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	for _, item := range m.SpecificationExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Parameter objects.
func (m *Parameter) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Schema != nil {
		_, err := m.Schema.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Example != nil {
		_, err := m.Example.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Examples != nil {
		_, err := m.Examples.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Content != nil {
		_, err := m.Content.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.SpecificationExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside ParameterOrReference objects.
func (m *ParameterOrReference) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	{
		p, ok := m.Oneof.(*ParameterOrReference_Parameter)
		if ok {
			_, err := p.Parameter.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	{
		p, ok := m.Oneof.(*ParameterOrReference_Reference)
		if ok {
			_, err := p.Reference.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside ParametersOrReferences objects.
func (m *ParametersOrReferences) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside PathItem objects.
func (m *PathItem) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.XRef != "" {
		info, err := compiler.ReadInfoForRef(root, m.XRef)
		if err != nil {
			return nil, err
		}
		if info != nil {
			replacement, err := NewPathItem(info, nil)
			if err == nil {
				*m = *replacement
				return m.ResolveReferences(root)
			}
		}
		return info, nil
	}
	if m.Get != nil {
		_, err := m.Get.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Put != nil {
		_, err := m.Put.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Post != nil {
		_, err := m.Post.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Delete != nil {
		_, err := m.Delete.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Options != nil {
		_, err := m.Options.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Head != nil {
		_, err := m.Head.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Patch != nil {
		_, err := m.Patch.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Trace != nil {
		_, err := m.Trace.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.Servers {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	for _, item := range m.Parameters {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	for _, item := range m.SpecificationExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Paths objects.
func (m *Paths) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.Path {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	for _, item := range m.SpecificationExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Properties objects.
func (m *Properties) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Reference objects.
func (m *Reference) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.XRef != "" {
		info, err := compiler.ReadInfoForRef(root, m.XRef)
		if err != nil {
			return nil, err
		}
		return info, nil
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside RequestBodiesOrReferences objects.
func (m *RequestBodiesOrReferences) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside RequestBody objects.
func (m *RequestBody) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Content != nil {
		_, err := m.Content.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.SpecificationExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside RequestBodyOrReference objects.
func (m *RequestBodyOrReference) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	{
		p, ok := m.Oneof.(*RequestBodyOrReference_RequestBody)
		if ok {
			_, err := p.RequestBody.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	{
		p, ok := m.Oneof.(*RequestBodyOrReference_Reference)
		if ok {
			_, err := p.Reference.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Response objects.
func (m *Response) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Headers != nil {
		_, err := m.Headers.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Content != nil {
		_, err := m.Content.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Links != nil {
		_, err := m.Links.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.SpecificationExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside ResponseOrReference objects.
func (m *ResponseOrReference) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	{
		p, ok := m.Oneof.(*ResponseOrReference_Response)
		if ok {
			_, err := p.Response.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	{
		p, ok := m.Oneof.(*ResponseOrReference_Reference)
		if ok {
			_, err := p.Reference.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Responses objects.
func (m *Responses) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Default != nil {
		_, err := m.Default.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.ResponseOrReference {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	for _, item := range m.SpecificationExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside ResponsesOrReferences objects.
func (m *ResponsesOrReferences) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Schema objects.
func (m *Schema) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Discriminator != nil {
		_, err := m.Discriminator.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Xml != nil {
		_, err := m.Xml.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.ExternalDocs != nil {
		_, err := m.ExternalDocs.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Example != nil {
		_, err := m.Example.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.Enum {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	for _, item := range m.AllOf {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	for _, item := range m.OneOf {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	for _, item := range m.AnyOf {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	if m.Not != nil {
		_, err := m.Not.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Items != nil {
		_, err := m.Items.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Properties != nil {
		_, err := m.Properties.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.AdditionalProperties != nil {
		_, err := m.AdditionalProperties.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Default != nil {
		_, err := m.Default.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.SpecificationExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside SchemaOrReference objects.
func (m *SchemaOrReference) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	{
		p, ok := m.Oneof.(*SchemaOrReference_Schema)
		if ok {
			_, err := p.Schema.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	{
		p, ok := m.Oneof.(*SchemaOrReference_Reference)
		if ok {
			_, err := p.Reference.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside SchemasOrReferences objects.
func (m *SchemasOrReferences) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside SecurityRequirement objects.
func (m *SecurityRequirement) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside SecurityScheme objects.
func (m *SecurityScheme) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Flows != nil {
		_, err := m.Flows.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.SpecificationExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside SecuritySchemeOrReference objects.
func (m *SecuritySchemeOrReference) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	{
		p, ok := m.Oneof.(*SecuritySchemeOrReference_SecurityScheme)
		if ok {
			_, err := p.SecurityScheme.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	{
		p, ok := m.Oneof.(*SecuritySchemeOrReference_Reference)
		if ok {
			_, err := p.Reference.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside SecuritySchemesOrReferences objects.
func (m *SecuritySchemesOrReferences) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Server objects.
func (m *Server) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Variables != nil {
		_, err := m.Variables.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.SpecificationExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside ServerVariable objects.
func (m *ServerVariable) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.SpecificationExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside ServerVariables objects.
func (m *ServerVariables) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside SpecificationExtension objects.
func (m *SpecificationExtension) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside StringArray objects.
func (m *StringArray) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Strings objects.
func (m *Strings) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Tag objects.
func (m *Tag) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.ExternalDocs != nil {
		_, err := m.ExternalDocs.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.SpecificationExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Xml objects.
func (m *Xml) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.SpecificationExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ToRawInfo returns a description of AdditionalPropertiesItem suitable for JSON or YAML export.
func (m *AdditionalPropertiesItem) ToRawInfo() interface{} {
	// ONE OF WRAPPER
	// AdditionalPropertiesItem
	// {Name:schemaOrReference Type:SchemaOrReference StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v0 := m.GetSchemaOrReference()
	if v0 != nil {
		return v0.ToRawInfo()
	}
	// {Name:boolean Type:bool StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if v1, ok := m.GetOneof().(*AdditionalPropertiesItem_Boolean); ok {
		return v1.Boolean
	}
	return nil
}

// ToRawInfo returns a description of Any suitable for JSON or YAML export.
func (m *Any) ToRawInfo() interface{} {
	var err error
	var info1 []yaml.MapSlice
	err = yaml.Unmarshal([]byte(m.Yaml), &info1)
	if err == nil {
		return info1
	}
	var info2 yaml.MapSlice
	err = yaml.Unmarshal([]byte(m.Yaml), &info2)
	if err == nil {
		return info2
	}
	var info3 interface{}
	err = yaml.Unmarshal([]byte(m.Yaml), &info3)
	if err == nil {
		return info3
	}
	return nil
}

// ToRawInfo returns a description of AnyOrExpression suitable for JSON or YAML export.
func (m *AnyOrExpression) ToRawInfo() interface{} {
	// ONE OF WRAPPER
	// AnyOrExpression
	// {Name:any Type:Any StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v0 := m.GetAny()
	if v0 != nil {
		return v0.ToRawInfo()
	}
	// {Name:expression Type:Expression StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v1 := m.GetExpression()
	if v1 != nil {
		return v1.ToRawInfo()
	}
	return nil
}

// ToRawInfo returns a description of AnysOrExpressions suitable for JSON or YAML export.
func (m *AnysOrExpressions) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedAnyOrExpression StringEnumValues:[] MapType:AnyOrExpression Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Callback suitable for JSON or YAML export.
func (m *Callback) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Path != nil {
		for _, item := range m.Path {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:Path Type:NamedPathItem StringEnumValues:[] MapType:PathItem Repeated:true Pattern:^ Implicit:true Description:}
	if m.SpecificationExtension != nil {
		for _, item := range m.SpecificationExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:SpecificationExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of CallbackOrReference suitable for JSON or YAML export.
func (m *CallbackOrReference) ToRawInfo() interface{} {
	// ONE OF WRAPPER
	// CallbackOrReference
	// {Name:callback Type:Callback StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v0 := m.GetCallback()
	if v0 != nil {
		return v0.ToRawInfo()
	}
	// {Name:reference Type:Reference StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v1 := m.GetReference()
	if v1 != nil {
		return v1.ToRawInfo()
	}
	return nil
}

// ToRawInfo returns a description of CallbacksOrReferences suitable for JSON or YAML export.
func (m *CallbacksOrReferences) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedCallbackOrReference StringEnumValues:[] MapType:CallbackOrReference Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Components suitable for JSON or YAML export.
func (m *Components) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Schemas != nil {
		info = append(info, yaml.MapItem{"schemas", m.Schemas.ToRawInfo()})
	}
	// &{Name:schemas Type:SchemasOrReferences StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Responses != nil {
		info = append(info, yaml.MapItem{"responses", m.Responses.ToRawInfo()})
	}
	// &{Name:responses Type:ResponsesOrReferences StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Parameters != nil {
		info = append(info, yaml.MapItem{"parameters", m.Parameters.ToRawInfo()})
	}
	// &{Name:parameters Type:ParametersOrReferences StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Examples != nil {
		info = append(info, yaml.MapItem{"examples", m.Examples.ToRawInfo()})
	}
	// &{Name:examples Type:ExamplesOrReferences StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.RequestBodies != nil {
		info = append(info, yaml.MapItem{"requestBodies", m.RequestBodies.ToRawInfo()})
	}
	// &{Name:requestBodies Type:RequestBodiesOrReferences StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Headers != nil {
		info = append(info, yaml.MapItem{"headers", m.Headers.ToRawInfo()})
	}
	// &{Name:headers Type:HeadersOrReferences StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.SecuritySchemes != nil {
		info = append(info, yaml.MapItem{"securitySchemes", m.SecuritySchemes.ToRawInfo()})
	}
	// &{Name:securitySchemes Type:SecuritySchemesOrReferences StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Links != nil {
		info = append(info, yaml.MapItem{"links", m.Links.ToRawInfo()})
	}
	// &{Name:links Type:LinksOrReferences StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Callbacks != nil {
		info = append(info, yaml.MapItem{"callbacks", m.Callbacks.ToRawInfo()})
	}
	// &{Name:callbacks Type:CallbacksOrReferences StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.SpecificationExtension != nil {
		for _, item := range m.SpecificationExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:SpecificationExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Contact suitable for JSON or YAML export.
func (m *Contact) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	if m.Url != "" {
		info = append(info, yaml.MapItem{"url", m.Url})
	}
	if m.Email != "" {
		info = append(info, yaml.MapItem{"email", m.Email})
	}
	if m.SpecificationExtension != nil {
		for _, item := range m.SpecificationExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:SpecificationExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of DefaultType suitable for JSON or YAML export.
func (m *DefaultType) ToRawInfo() interface{} {
	// ONE OF WRAPPER
	// DefaultType
	// {Name:number Type:float StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if v0, ok := m.GetOneof().(*DefaultType_Number); ok {
		return v0.Number
	}
	// {Name:boolean Type:bool StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if v1, ok := m.GetOneof().(*DefaultType_Boolean); ok {
		return v1.Boolean
	}
	// {Name:string Type:string StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if v2, ok := m.GetOneof().(*DefaultType_String_); ok {
		return v2.String_
	}
	return nil
}

// ToRawInfo returns a description of Discriminator suitable for JSON or YAML export.
func (m *Discriminator) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.PropertyName != "" {
		info = append(info, yaml.MapItem{"propertyName", m.PropertyName})
	}
	if m.Mapping != nil {
		info = append(info, yaml.MapItem{"mapping", m.Mapping.ToRawInfo()})
	}
	// &{Name:mapping Type:Strings StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	return info
}

// ToRawInfo returns a description of Document suitable for JSON or YAML export.
func (m *Document) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Openapi != "" {
		info = append(info, yaml.MapItem{"openapi", m.Openapi})
	}
	if m.Info != nil {
		info = append(info, yaml.MapItem{"info", m.Info.ToRawInfo()})
	}
	// &{Name:info Type:Info StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if len(m.Servers) != 0 {
		items := make([]interface{}, 0)
		for _, item := range m.Servers {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"servers", items})
	}
	// &{Name:servers Type:Server StringEnumValues:[] MapType: Repeated:true Pattern: Implicit:false Description:}
	if m.Paths != nil {
		info = append(info, yaml.MapItem{"paths", m.Paths.ToRawInfo()})
	}
	// &{Name:paths Type:Paths StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Components != nil {
		info = append(info, yaml.MapItem{"components", m.Components.ToRawInfo()})
	}
	// &{Name:components Type:Components StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if len(m.Security) != 0 {
		items := make([]interface{}, 0)
		for _, item := range m.Security {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"security", items})
	}
	// &{Name:security Type:SecurityRequirement StringEnumValues:[] MapType: Repeated:true Pattern: Implicit:false Description:}
	if len(m.Tags) != 0 {
		items := make([]interface{}, 0)
		for _, item := range m.Tags {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"tags", items})
	}
	// &{Name:tags Type:Tag StringEnumValues:[] MapType: Repeated:true Pattern: Implicit:false Description:}
	if m.ExternalDocs != nil {
		info = append(info, yaml.MapItem{"externalDocs", m.ExternalDocs.ToRawInfo()})
	}
	// &{Name:externalDocs Type:ExternalDocs StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.SpecificationExtension != nil {
		for _, item := range m.SpecificationExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:SpecificationExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Encoding suitable for JSON or YAML export.
func (m *Encoding) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.ContentType != "" {
		info = append(info, yaml.MapItem{"contentType", m.ContentType})
	}
	if m.Headers != nil {
		info = append(info, yaml.MapItem{"headers", m.Headers.ToRawInfo()})
	}
	// &{Name:headers Type:HeadersOrReferences StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Style != "" {
		info = append(info, yaml.MapItem{"style", m.Style})
	}
	if m.Explode != false {
		info = append(info, yaml.MapItem{"explode", m.Explode})
	}
	if m.AllowReserved != false {
		info = append(info, yaml.MapItem{"allowReserved", m.AllowReserved})
	}
	if m.SpecificationExtension != nil {
		for _, item := range m.SpecificationExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:SpecificationExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Encodings suitable for JSON or YAML export.
func (m *Encodings) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedEncoding StringEnumValues:[] MapType:Encoding Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Example suitable for JSON or YAML export.
func (m *Example) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Summary != "" {
		info = append(info, yaml.MapItem{"summary", m.Summary})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	// &{Name:value Type:Any StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.ExternalValue != "" {
		info = append(info, yaml.MapItem{"externalValue", m.ExternalValue})
	}
	if m.SpecificationExtension != nil {
		for _, item := range m.SpecificationExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:SpecificationExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of ExampleOrReference suitable for JSON or YAML export.
func (m *ExampleOrReference) ToRawInfo() interface{} {
	// ONE OF WRAPPER
	// ExampleOrReference
	// {Name:example Type:Example StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v0 := m.GetExample()
	if v0 != nil {
		return v0.ToRawInfo()
	}
	// {Name:reference Type:Reference StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v1 := m.GetReference()
	if v1 != nil {
		return v1.ToRawInfo()
	}
	return nil
}

// ToRawInfo returns a description of Examples suitable for JSON or YAML export.
func (m *Examples) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	return info
}

// ToRawInfo returns a description of ExamplesOrReferences suitable for JSON or YAML export.
func (m *ExamplesOrReferences) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedExampleOrReference StringEnumValues:[] MapType:ExampleOrReference Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Expression suitable for JSON or YAML export.
func (m *Expression) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of ExternalDocs suitable for JSON or YAML export.
func (m *ExternalDocs) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.Url != "" {
		info = append(info, yaml.MapItem{"url", m.Url})
	}
	if m.SpecificationExtension != nil {
		for _, item := range m.SpecificationExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:SpecificationExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Header suitable for JSON or YAML export.
func (m *Header) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.Required != false {
		info = append(info, yaml.MapItem{"required", m.Required})
	}
	if m.Deprecated != false {
		info = append(info, yaml.MapItem{"deprecated", m.Deprecated})
	}
	if m.AllowEmptyValue != false {
		info = append(info, yaml.MapItem{"allowEmptyValue", m.AllowEmptyValue})
	}
	if m.Style != "" {
		info = append(info, yaml.MapItem{"style", m.Style})
	}
	if m.Explode != false {
		info = append(info, yaml.MapItem{"explode", m.Explode})
	}
	if m.AllowReserved != false {
		info = append(info, yaml.MapItem{"allowReserved", m.AllowReserved})
	}
	if m.Schema != nil {
		info = append(info, yaml.MapItem{"schema", m.Schema.ToRawInfo()})
	}
	// &{Name:schema Type:SchemaOrReference StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Example != nil {
		info = append(info, yaml.MapItem{"example", m.Example.ToRawInfo()})
	}
	// &{Name:example Type:Any StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Examples != nil {
		info = append(info, yaml.MapItem{"examples", m.Examples.ToRawInfo()})
	}
	// &{Name:examples Type:ExamplesOrReferences StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Content != nil {
		info = append(info, yaml.MapItem{"content", m.Content.ToRawInfo()})
	}
	// &{Name:content Type:MediaTypes StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.SpecificationExtension != nil {
		for _, item := range m.SpecificationExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:SpecificationExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of HeaderOrReference suitable for JSON or YAML export.
func (m *HeaderOrReference) ToRawInfo() interface{} {
	// ONE OF WRAPPER
	// HeaderOrReference
	// {Name:header Type:Header StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v0 := m.GetHeader()
	if v0 != nil {
		return v0.ToRawInfo()
	}
	// {Name:reference Type:Reference StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v1 := m.GetReference()
	if v1 != nil {
		return v1.ToRawInfo()
	}
	return nil
}

// ToRawInfo returns a description of HeadersOrReferences suitable for JSON or YAML export.
func (m *HeadersOrReferences) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedHeaderOrReference StringEnumValues:[] MapType:HeaderOrReference Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Info suitable for JSON or YAML export.
func (m *Info) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Title != "" {
		info = append(info, yaml.MapItem{"title", m.Title})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.TermsOfService != "" {
		info = append(info, yaml.MapItem{"termsOfService", m.TermsOfService})
	}
	if m.Contact != nil {
		info = append(info, yaml.MapItem{"contact", m.Contact.ToRawInfo()})
	}
	// &{Name:contact Type:Contact StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.License != nil {
		info = append(info, yaml.MapItem{"license", m.License.ToRawInfo()})
	}
	// &{Name:license Type:License StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Version != "" {
		info = append(info, yaml.MapItem{"version", m.Version})
	}
	if m.SpecificationExtension != nil {
		for _, item := range m.SpecificationExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:SpecificationExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of ItemsItem suitable for JSON or YAML export.
func (m *ItemsItem) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if len(m.SchemaOrReference) != 0 {
		items := make([]interface{}, 0)
		for _, item := range m.SchemaOrReference {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"schemaOrReference", items})
	}
	// &{Name:schemaOrReference Type:SchemaOrReference StringEnumValues:[] MapType: Repeated:true Pattern: Implicit:false Description:}
	return info
}

// ToRawInfo returns a description of License suitable for JSON or YAML export.
func (m *License) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	if m.Url != "" {
		info = append(info, yaml.MapItem{"url", m.Url})
	}
	if m.SpecificationExtension != nil {
		for _, item := range m.SpecificationExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:SpecificationExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Link suitable for JSON or YAML export.
func (m *Link) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.OperationRef != "" {
		info = append(info, yaml.MapItem{"operationRef", m.OperationRef})
	}
	if m.OperationId != "" {
		info = append(info, yaml.MapItem{"operationId", m.OperationId})
	}
	if m.Parameters != nil {
		info = append(info, yaml.MapItem{"parameters", m.Parameters.ToRawInfo()})
	}
	// &{Name:parameters Type:AnysOrExpressions StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.RequestBody != nil {
		info = append(info, yaml.MapItem{"requestBody", m.RequestBody.ToRawInfo()})
	}
	// &{Name:requestBody Type:AnyOrExpression StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.Server != nil {
		info = append(info, yaml.MapItem{"server", m.Server.ToRawInfo()})
	}
	// &{Name:server Type:Server StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.SpecificationExtension != nil {
		for _, item := range m.SpecificationExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:SpecificationExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of LinkOrReference suitable for JSON or YAML export.
func (m *LinkOrReference) ToRawInfo() interface{} {
	// ONE OF WRAPPER
	// LinkOrReference
	// {Name:link Type:Link StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v0 := m.GetLink()
	if v0 != nil {
		return v0.ToRawInfo()
	}
	// {Name:reference Type:Reference StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v1 := m.GetReference()
	if v1 != nil {
		return v1.ToRawInfo()
	}
	return nil
}

// ToRawInfo returns a description of LinksOrReferences suitable for JSON or YAML export.
func (m *LinksOrReferences) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedLinkOrReference StringEnumValues:[] MapType:LinkOrReference Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of MediaType suitable for JSON or YAML export.
func (m *MediaType) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Schema != nil {
		info = append(info, yaml.MapItem{"schema", m.Schema.ToRawInfo()})
	}
	// &{Name:schema Type:SchemaOrReference StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Example != nil {
		info = append(info, yaml.MapItem{"example", m.Example.ToRawInfo()})
	}
	// &{Name:example Type:Any StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Examples != nil {
		info = append(info, yaml.MapItem{"examples", m.Examples.ToRawInfo()})
	}
	// &{Name:examples Type:ExamplesOrReferences StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Encoding != nil {
		info = append(info, yaml.MapItem{"encoding", m.Encoding.ToRawInfo()})
	}
	// &{Name:encoding Type:Encodings StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.SpecificationExtension != nil {
		for _, item := range m.SpecificationExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:SpecificationExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of MediaTypes suitable for JSON or YAML export.
func (m *MediaTypes) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedMediaType StringEnumValues:[] MapType:MediaType Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of NamedAny suitable for JSON or YAML export.
func (m *NamedAny) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:Any StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedAnyOrExpression suitable for JSON or YAML export.
func (m *NamedAnyOrExpression) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:AnyOrExpression StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedCallbackOrReference suitable for JSON or YAML export.
func (m *NamedCallbackOrReference) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:CallbackOrReference StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedEncoding suitable for JSON or YAML export.
func (m *NamedEncoding) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:Encoding StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedExampleOrReference suitable for JSON or YAML export.
func (m *NamedExampleOrReference) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:ExampleOrReference StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedHeaderOrReference suitable for JSON or YAML export.
func (m *NamedHeaderOrReference) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:HeaderOrReference StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedLinkOrReference suitable for JSON or YAML export.
func (m *NamedLinkOrReference) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:LinkOrReference StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedMediaType suitable for JSON or YAML export.
func (m *NamedMediaType) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:MediaType StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedParameterOrReference suitable for JSON or YAML export.
func (m *NamedParameterOrReference) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:ParameterOrReference StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedPathItem suitable for JSON or YAML export.
func (m *NamedPathItem) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:PathItem StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedRequestBodyOrReference suitable for JSON or YAML export.
func (m *NamedRequestBodyOrReference) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:RequestBodyOrReference StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedResponseOrReference suitable for JSON or YAML export.
func (m *NamedResponseOrReference) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:ResponseOrReference StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedSchemaOrReference suitable for JSON or YAML export.
func (m *NamedSchemaOrReference) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:SchemaOrReference StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedSecuritySchemeOrReference suitable for JSON or YAML export.
func (m *NamedSecuritySchemeOrReference) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:SecuritySchemeOrReference StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedServerVariable suitable for JSON or YAML export.
func (m *NamedServerVariable) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:ServerVariable StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedString suitable for JSON or YAML export.
func (m *NamedString) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	if m.Value != "" {
		info = append(info, yaml.MapItem{"value", m.Value})
	}
	return info
}

// ToRawInfo returns a description of OauthFlow suitable for JSON or YAML export.
func (m *OauthFlow) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AuthorizationUrl != "" {
		info = append(info, yaml.MapItem{"authorizationUrl", m.AuthorizationUrl})
	}
	if m.TokenUrl != "" {
		info = append(info, yaml.MapItem{"tokenUrl", m.TokenUrl})
	}
	if m.RefreshUrl != "" {
		info = append(info, yaml.MapItem{"refreshUrl", m.RefreshUrl})
	}
	if m.Scopes != nil {
		info = append(info, yaml.MapItem{"scopes", m.Scopes.ToRawInfo()})
	}
	// &{Name:scopes Type:Strings StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.SpecificationExtension != nil {
		for _, item := range m.SpecificationExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:SpecificationExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of OauthFlows suitable for JSON or YAML export.
func (m *OauthFlows) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Implicit != nil {
		info = append(info, yaml.MapItem{"implicit", m.Implicit.ToRawInfo()})
	}
	// &{Name:implicit Type:OauthFlow StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Password != nil {
		info = append(info, yaml.MapItem{"password", m.Password.ToRawInfo()})
	}
	// &{Name:password Type:OauthFlow StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.ClientCredentials != nil {
		info = append(info, yaml.MapItem{"clientCredentials", m.ClientCredentials.ToRawInfo()})
	}
	// &{Name:clientCredentials Type:OauthFlow StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.AuthorizationCode != nil {
		info = append(info, yaml.MapItem{"authorizationCode", m.AuthorizationCode.ToRawInfo()})
	}
	// &{Name:authorizationCode Type:OauthFlow StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.SpecificationExtension != nil {
		for _, item := range m.SpecificationExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:SpecificationExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Object suitable for JSON or YAML export.
func (m *Object) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Operation suitable for JSON or YAML export.
func (m *Operation) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if len(m.Tags) != 0 {
		info = append(info, yaml.MapItem{"tags", m.Tags})
	}
	if m.Summary != "" {
		info = append(info, yaml.MapItem{"summary", m.Summary})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.ExternalDocs != nil {
		info = append(info, yaml.MapItem{"externalDocs", m.ExternalDocs.ToRawInfo()})
	}
	// &{Name:externalDocs Type:ExternalDocs StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.OperationId != "" {
		info = append(info, yaml.MapItem{"operationId", m.OperationId})
	}
	if len(m.Parameters) != 0 {
		items := make([]interface{}, 0)
		for _, item := range m.Parameters {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"parameters", items})
	}
	// &{Name:parameters Type:ParameterOrReference StringEnumValues:[] MapType: Repeated:true Pattern: Implicit:false Description:}
	if m.RequestBody != nil {
		info = append(info, yaml.MapItem{"requestBody", m.RequestBody.ToRawInfo()})
	}
	// &{Name:requestBody Type:RequestBodyOrReference StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Responses != nil {
		info = append(info, yaml.MapItem{"responses", m.Responses.ToRawInfo()})
	}
	// &{Name:responses Type:Responses StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Callbacks != nil {
		info = append(info, yaml.MapItem{"callbacks", m.Callbacks.ToRawInfo()})
	}
	// &{Name:callbacks Type:CallbacksOrReferences StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Deprecated != false {
		info = append(info, yaml.MapItem{"deprecated", m.Deprecated})
	}
	if len(m.Security) != 0 {
		items := make([]interface{}, 0)
		for _, item := range m.Security {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"security", items})
	}
	// &{Name:security Type:SecurityRequirement StringEnumValues:[] MapType: Repeated:true Pattern: Implicit:false Description:}
	if len(m.Servers) != 0 {
		items := make([]interface{}, 0)
		for _, item := range m.Servers {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"servers", items})
	}
	// &{Name:servers Type:Server StringEnumValues:[] MapType: Repeated:true Pattern: Implicit:false Description:}
	if m.SpecificationExtension != nil {
		for _, item := range m.SpecificationExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:SpecificationExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Parameter suitable for JSON or YAML export.
func (m *Parameter) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	if m.In != "" {
		info = append(info, yaml.MapItem{"in", m.In})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.Required != false {
		info = append(info, yaml.MapItem{"required", m.Required})
	}
	if m.Deprecated != false {
		info = append(info, yaml.MapItem{"deprecated", m.Deprecated})
	}
	if m.AllowEmptyValue != false {
		info = append(info, yaml.MapItem{"allowEmptyValue", m.AllowEmptyValue})
	}
	if m.Style != "" {
		info = append(info, yaml.MapItem{"style", m.Style})
	}
	if m.Explode != false {
		info = append(info, yaml.MapItem{"explode", m.Explode})
	}
	if m.AllowReserved != false {
		info = append(info, yaml.MapItem{"allowReserved", m.AllowReserved})
	}
	if m.Schema != nil {
		info = append(info, yaml.MapItem{"schema", m.Schema.ToRawInfo()})
	}
	// &{Name:schema Type:SchemaOrReference StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Example != nil {
		info = append(info, yaml.MapItem{"example", m.Example.ToRawInfo()})
	}
	// &{Name:example Type:Any StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Examples != nil {
		info = append(info, yaml.MapItem{"examples", m.Examples.ToRawInfo()})
	}
	// &{Name:examples Type:ExamplesOrReferences StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Content != nil {
		info = append(info, yaml.MapItem{"content", m.Content.ToRawInfo()})
	}
	// &{Name:content Type:MediaTypes StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.SpecificationExtension != nil {
		for _, item := range m.SpecificationExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:SpecificationExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of ParameterOrReference suitable for JSON or YAML export.
func (m *ParameterOrReference) ToRawInfo() interface{} {
	// ONE OF WRAPPER
	// ParameterOrReference
	// {Name:parameter Type:Parameter StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v0 := m.GetParameter()
	if v0 != nil {
		return v0.ToRawInfo()
	}
	// {Name:reference Type:Reference StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v1 := m.GetReference()
	if v1 != nil {
		return v1.ToRawInfo()
	}
	return nil
}

// ToRawInfo returns a description of ParametersOrReferences suitable for JSON or YAML export.
func (m *ParametersOrReferences) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedParameterOrReference StringEnumValues:[] MapType:ParameterOrReference Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of PathItem suitable for JSON or YAML export.
func (m *PathItem) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.XRef != "" {
		info = append(info, yaml.MapItem{"$ref", m.XRef})
	}
	if m.Summary != "" {
		info = append(info, yaml.MapItem{"summary", m.Summary})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.Get != nil {
		info = append(info, yaml.MapItem{"get", m.Get.ToRawInfo()})
	}
	// &{Name:get Type:Operation StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Put != nil {
		info = append(info, yaml.MapItem{"put", m.Put.ToRawInfo()})
	}
	// &{Name:put Type:Operation StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Post != nil {
		info = append(info, yaml.MapItem{"post", m.Post.ToRawInfo()})
	}
	// &{Name:post Type:Operation StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Delete != nil {
		info = append(info, yaml.MapItem{"delete", m.Delete.ToRawInfo()})
	}
	// &{Name:delete Type:Operation StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Options != nil {
		info = append(info, yaml.MapItem{"options", m.Options.ToRawInfo()})
	}
	// &{Name:options Type:Operation StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Head != nil {
		info = append(info, yaml.MapItem{"head", m.Head.ToRawInfo()})
	}
	// &{Name:head Type:Operation StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Patch != nil {
		info = append(info, yaml.MapItem{"patch", m.Patch.ToRawInfo()})
	}
	// &{Name:patch Type:Operation StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Trace != nil {
		info = append(info, yaml.MapItem{"trace", m.Trace.ToRawInfo()})
	}
	// &{Name:trace Type:Operation StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if len(m.Servers) != 0 {
		items := make([]interface{}, 0)
		for _, item := range m.Servers {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"servers", items})
	}
	// &{Name:servers Type:Server StringEnumValues:[] MapType: Repeated:true Pattern: Implicit:false Description:}
	if len(m.Parameters) != 0 {
		items := make([]interface{}, 0)
		for _, item := range m.Parameters {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"parameters", items})
	}
	// &{Name:parameters Type:ParameterOrReference StringEnumValues:[] MapType: Repeated:true Pattern: Implicit:false Description:}
	if m.SpecificationExtension != nil {
		for _, item := range m.SpecificationExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:SpecificationExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Paths suitable for JSON or YAML export.
func (m *Paths) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Path != nil {
		for _, item := range m.Path {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:Path Type:NamedPathItem StringEnumValues:[] MapType:PathItem Repeated:true Pattern:^/ Implicit:true Description:}
	if m.SpecificationExtension != nil {
		for _, item := range m.SpecificationExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:SpecificationExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Properties suitable for JSON or YAML export.
func (m *Properties) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedSchemaOrReference StringEnumValues:[] MapType:SchemaOrReference Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Reference suitable for JSON or YAML export.
func (m *Reference) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.XRef != "" {
		info = append(info, yaml.MapItem{"$ref", m.XRef})
	}
	return info
}

// ToRawInfo returns a description of RequestBodiesOrReferences suitable for JSON or YAML export.
func (m *RequestBodiesOrReferences) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedRequestBodyOrReference StringEnumValues:[] MapType:RequestBodyOrReference Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of RequestBody suitable for JSON or YAML export.
func (m *RequestBody) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.Content != nil {
		info = append(info, yaml.MapItem{"content", m.Content.ToRawInfo()})
	}
	// &{Name:content Type:MediaTypes StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Required != false {
		info = append(info, yaml.MapItem{"required", m.Required})
	}
	if m.SpecificationExtension != nil {
		for _, item := range m.SpecificationExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:SpecificationExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of RequestBodyOrReference suitable for JSON or YAML export.
func (m *RequestBodyOrReference) ToRawInfo() interface{} {
	// ONE OF WRAPPER
	// RequestBodyOrReference
	// {Name:requestBody Type:RequestBody StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v0 := m.GetRequestBody()
	if v0 != nil {
		return v0.ToRawInfo()
	}
	// {Name:reference Type:Reference StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v1 := m.GetReference()
	if v1 != nil {
		return v1.ToRawInfo()
	}
	return nil
}

// ToRawInfo returns a description of Response suitable for JSON or YAML export.
func (m *Response) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.Headers != nil {
		info = append(info, yaml.MapItem{"headers", m.Headers.ToRawInfo()})
	}
	// &{Name:headers Type:HeadersOrReferences StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Content != nil {
		info = append(info, yaml.MapItem{"content", m.Content.ToRawInfo()})
	}
	// &{Name:content Type:MediaTypes StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Links != nil {
		info = append(info, yaml.MapItem{"links", m.Links.ToRawInfo()})
	}
	// &{Name:links Type:LinksOrReferences StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.SpecificationExtension != nil {
		for _, item := range m.SpecificationExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:SpecificationExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of ResponseOrReference suitable for JSON or YAML export.
func (m *ResponseOrReference) ToRawInfo() interface{} {
	// ONE OF WRAPPER
	// ResponseOrReference
	// {Name:response Type:Response StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v0 := m.GetResponse()
	if v0 != nil {
		return v0.ToRawInfo()
	}
	// {Name:reference Type:Reference StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v1 := m.GetReference()
	if v1 != nil {
		return v1.ToRawInfo()
	}
	return nil
}

// ToRawInfo returns a description of Responses suitable for JSON or YAML export.
func (m *Responses) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Default != nil {
		info = append(info, yaml.MapItem{"default", m.Default.ToRawInfo()})
	}
	// &{Name:default Type:ResponseOrReference StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.ResponseOrReference != nil {
		for _, item := range m.ResponseOrReference {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:ResponseOrReference Type:NamedResponseOrReference StringEnumValues:[] MapType:ResponseOrReference Repeated:true Pattern:^([0-9X]{3})$ Implicit:true Description:}
	if m.SpecificationExtension != nil {
		for _, item := range m.SpecificationExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:SpecificationExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of ResponsesOrReferences suitable for JSON or YAML export.
func (m *ResponsesOrReferences) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedResponseOrReference StringEnumValues:[] MapType:ResponseOrReference Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Schema suitable for JSON or YAML export.
func (m *Schema) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Nullable != false {
		info = append(info, yaml.MapItem{"nullable", m.Nullable})
	}
	if m.Discriminator != nil {
		info = append(info, yaml.MapItem{"discriminator", m.Discriminator.ToRawInfo()})
	}
	// &{Name:discriminator Type:Discriminator StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.ReadOnly != false {
		info = append(info, yaml.MapItem{"readOnly", m.ReadOnly})
	}
	if m.WriteOnly != false {
		info = append(info, yaml.MapItem{"writeOnly", m.WriteOnly})
	}
	if m.Xml != nil {
		info = append(info, yaml.MapItem{"xml", m.Xml.ToRawInfo()})
	}
	// &{Name:xml Type:Xml StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.ExternalDocs != nil {
		info = append(info, yaml.MapItem{"externalDocs", m.ExternalDocs.ToRawInfo()})
	}
	// &{Name:externalDocs Type:ExternalDocs StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Example != nil {
		info = append(info, yaml.MapItem{"example", m.Example.ToRawInfo()})
	}
	// &{Name:example Type:Any StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Deprecated != false {
		info = append(info, yaml.MapItem{"deprecated", m.Deprecated})
	}
	if m.Title != "" {
		info = append(info, yaml.MapItem{"title", m.Title})
	}
	if m.MultipleOf != 0.0 {
		info = append(info, yaml.MapItem{"multipleOf", m.MultipleOf})
	}
	if m.Maximum != 0.0 {
		info = append(info, yaml.MapItem{"maximum", m.Maximum})
	}
	if m.ExclusiveMaximum != false {
		info = append(info, yaml.MapItem{"exclusiveMaximum", m.ExclusiveMaximum})
	}
	if m.Minimum != 0.0 {
		info = append(info, yaml.MapItem{"minimum", m.Minimum})
	}
	if m.ExclusiveMinimum != false {
		info = append(info, yaml.MapItem{"exclusiveMinimum", m.ExclusiveMinimum})
	}
	if m.MaxLength != 0 {
		info = append(info, yaml.MapItem{"maxLength", m.MaxLength})
	}
	if m.MinLength != 0 {
		info = append(info, yaml.MapItem{"minLength", m.MinLength})
	}
	if m.Pattern != "" {
		info = append(info, yaml.MapItem{"pattern", m.Pattern})
	}
	if m.MaxItems != 0 {
		info = append(info, yaml.MapItem{"maxItems", m.MaxItems})
	}
	if m.MinItems != 0 {
		info = append(info, yaml.MapItem{"minItems", m.MinItems})
	}
	if m.UniqueItems != false {
		info = append(info, yaml.MapItem{"uniqueItems", m.UniqueItems})
	}
	if m.MaxProperties != 0 {
		info = append(info, yaml.MapItem{"maxProperties", m.MaxProperties})
	}
	if m.MinProperties != 0 {
		info = append(info, yaml.MapItem{"minProperties", m.MinProperties})
	}
	if len(m.Required) != 0 {
		info = append(info, yaml.MapItem{"required", m.Required})
	}
	if len(m.Enum) != 0 {
		items := make([]interface{}, 0)
		for _, item := range m.Enum {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"enum", items})
	}
	// &{Name:enum Type:Any StringEnumValues:[] MapType: Repeated:true Pattern: Implicit:false Description:}
	if m.Type != "" {
		info = append(info, yaml.MapItem{"type", m.Type})
	}
	if len(m.AllOf) != 0 {
		items := make([]interface{}, 0)
		for _, item := range m.AllOf {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"allOf", items})
	}
	// &{Name:allOf Type:SchemaOrReference StringEnumValues:[] MapType: Repeated:true Pattern: Implicit:false Description:}
	if len(m.OneOf) != 0 {
		items := make([]interface{}, 0)
		for _, item := range m.OneOf {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"oneOf", items})
	}
	// &{Name:oneOf Type:SchemaOrReference StringEnumValues:[] MapType: Repeated:true Pattern: Implicit:false Description:}
	if len(m.AnyOf) != 0 {
		items := make([]interface{}, 0)
		for _, item := range m.AnyOf {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"anyOf", items})
	}
	// &{Name:anyOf Type:SchemaOrReference StringEnumValues:[] MapType: Repeated:true Pattern: Implicit:false Description:}
	if m.Not != nil {
		info = append(info, yaml.MapItem{"not", m.Not.ToRawInfo()})
	}
	// &{Name:not Type:Schema StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Items != nil {
		items := make([]interface{}, 0)
		for _, item := range m.Items.SchemaOrReference {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"items", items[0]})
	}
	// &{Name:items Type:ItemsItem StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Properties != nil {
		info = append(info, yaml.MapItem{"properties", m.Properties.ToRawInfo()})
	}
	// &{Name:properties Type:Properties StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.AdditionalProperties != nil {
		info = append(info, yaml.MapItem{"additionalProperties", m.AdditionalProperties.ToRawInfo()})
	}
	// &{Name:additionalProperties Type:AdditionalPropertiesItem StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Default != nil {
		info = append(info, yaml.MapItem{"default", m.Default.ToRawInfo()})
	}
	// &{Name:default Type:DefaultType StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.Format != "" {
		info = append(info, yaml.MapItem{"format", m.Format})
	}
	if m.SpecificationExtension != nil {
		for _, item := range m.SpecificationExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:SpecificationExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of SchemaOrReference suitable for JSON or YAML export.
func (m *SchemaOrReference) ToRawInfo() interface{} {
	// ONE OF WRAPPER
	// SchemaOrReference
	// {Name:schema Type:Schema StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v0 := m.GetSchema()
	if v0 != nil {
		return v0.ToRawInfo()
	}
	// {Name:reference Type:Reference StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v1 := m.GetReference()
	if v1 != nil {
		return v1.ToRawInfo()
	}
	return nil
}

// ToRawInfo returns a description of SchemasOrReferences suitable for JSON or YAML export.
func (m *SchemasOrReferences) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedSchemaOrReference StringEnumValues:[] MapType:SchemaOrReference Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of SecurityRequirement suitable for JSON or YAML export.
func (m *SecurityRequirement) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	return info
}

// ToRawInfo returns a description of SecurityScheme suitable for JSON or YAML export.
func (m *SecurityScheme) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Type != "" {
		info = append(info, yaml.MapItem{"type", m.Type})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	if m.In != "" {
		info = append(info, yaml.MapItem{"in", m.In})
	}
	if m.Scheme != "" {
		info = append(info, yaml.MapItem{"scheme", m.Scheme})
	}
	if m.BearerFormat != "" {
		info = append(info, yaml.MapItem{"bearerFormat", m.BearerFormat})
	}
	if m.Flows != nil {
		info = append(info, yaml.MapItem{"flows", m.Flows.ToRawInfo()})
	}
	// &{Name:flows Type:OauthFlows StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.OpenIdConnectUrl != "" {
		info = append(info, yaml.MapItem{"openIdConnectUrl", m.OpenIdConnectUrl})
	}
	if m.SpecificationExtension != nil {
		for _, item := range m.SpecificationExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:SpecificationExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of SecuritySchemeOrReference suitable for JSON or YAML export.
func (m *SecuritySchemeOrReference) ToRawInfo() interface{} {
	// ONE OF WRAPPER
	// SecuritySchemeOrReference
	// {Name:securityScheme Type:SecurityScheme StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v0 := m.GetSecurityScheme()
	if v0 != nil {
		return v0.ToRawInfo()
	}
	// {Name:reference Type:Reference StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v1 := m.GetReference()
	if v1 != nil {
		return v1.ToRawInfo()
	}
	return nil
}

// ToRawInfo returns a description of SecuritySchemesOrReferences suitable for JSON or YAML export.
func (m *SecuritySchemesOrReferences) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedSecuritySchemeOrReference StringEnumValues:[] MapType:SecuritySchemeOrReference Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Server suitable for JSON or YAML export.
func (m *Server) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Url != "" {
		info = append(info, yaml.MapItem{"url", m.Url})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.Variables != nil {
		info = append(info, yaml.MapItem{"variables", m.Variables.ToRawInfo()})
	}
	// &{Name:variables Type:ServerVariables StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.SpecificationExtension != nil {
		for _, item := range m.SpecificationExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:SpecificationExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of ServerVariable suitable for JSON or YAML export.
func (m *ServerVariable) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if len(m.Enum) != 0 {
		info = append(info, yaml.MapItem{"enum", m.Enum})
	}
	if m.Default != "" {
		info = append(info, yaml.MapItem{"default", m.Default})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.SpecificationExtension != nil {
		for _, item := range m.SpecificationExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:SpecificationExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of ServerVariables suitable for JSON or YAML export.
func (m *ServerVariables) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedServerVariable StringEnumValues:[] MapType:ServerVariable Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of SpecificationExtension suitable for JSON or YAML export.
func (m *SpecificationExtension) ToRawInfo() interface{} {
	// ONE OF WRAPPER
	// SpecificationExtension
	// {Name:number Type:float StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if v0, ok := m.GetOneof().(*SpecificationExtension_Number); ok {
		return v0.Number
	}
	// {Name:boolean Type:bool StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if v1, ok := m.GetOneof().(*SpecificationExtension_Boolean); ok {
		return v1.Boolean
	}
	// {Name:string Type:string StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if v2, ok := m.GetOneof().(*SpecificationExtension_String_); ok {
		return v2.String_
	}
	return nil
}

// ToRawInfo returns a description of StringArray suitable for JSON or YAML export.
func (m *StringArray) ToRawInfo() interface{} {
	return m.Value
}

// ToRawInfo returns a description of Strings suitable for JSON or YAML export.
func (m *Strings) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	// &{Name:additionalProperties Type:NamedString StringEnumValues:[] MapType:string Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Tag suitable for JSON or YAML export.
func (m *Tag) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.ExternalDocs != nil {
		info = append(info, yaml.MapItem{"externalDocs", m.ExternalDocs.ToRawInfo()})
	}
	// &{Name:externalDocs Type:ExternalDocs StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.SpecificationExtension != nil {
		for _, item := range m.SpecificationExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:SpecificationExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Xml suitable for JSON or YAML export.
func (m *Xml) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	if m.Namespace != "" {
		info = append(info, yaml.MapItem{"namespace", m.Namespace})
	}
	if m.Prefix != "" {
		info = append(info, yaml.MapItem{"prefix", m.Prefix})
	}
	if m.Attribute != false {
		info = append(info, yaml.MapItem{"attribute", m.Attribute})
	}
	if m.Wrapped != false {
		info = append(info, yaml.MapItem{"wrapped", m.Wrapped})
	}
	if m.SpecificationExtension != nil {
		for _, item := range m.SpecificationExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:SpecificationExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

var (
	pattern0 = regexp.MustCompile("^")
	pattern1 = regexp.MustCompile("^x-")
	pattern2 = regexp.MustCompile("^/")
	pattern3 = regexp.MustCompile("^([0-9X]{3})$")
	pattern4 = regexp.MustCompile("^[a-zA-Z0-9\\.\\-_]+$")
)
